(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20404,        828]
NotebookOptionsPosition[     12034,        554]
NotebookOutlinePosition[     15975,        671]
CellTagsIndexPosition[     15874,        665]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Subscripts", "Title",
 CellID->1904869366],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]]]
}], "Section",
 CellID->19111],

Cell["Type the symbol that will have the subscript. ", "Text",
 CellID->140466097],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->73829089],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellID->173992176],

Cell[TextData[{
 "Create a subscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["-", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellTags->"fractions",
 CellID->437149809],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 "\[AutoOperand] or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->299233980],

Cell[BoxData[
 SubscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->123565387],

Cell["\<\
Type the subscript into the placeholder (which is already selected).\
\>", "Text",
 CellTags->"fractions",
 CellID->426230220],

Cell[TextData[{
 "Type ",
 Cell[BoxData["i"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->156471717],

Cell[BoxData[
 SubscriptBox["x", 
  RowBox[{"i", "\[VerticalSeparator]"}]]], "Input",
 CellID->92233581],

Cell[TextData[{
 "Move the insertion point out of the subscript position up to the baseline \
by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->321696010],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->238134069],

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", "i"], "\[VerticalSeparator]"}]], "Input",
 CellID->364055760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    RowBox[{"i", " ", "j"}]], TraditionalForm]]]
}], "Section",
 CellID->19222],

Cell["Type the symbol that will have the subscript. ", "Text",
 CellID->302153063],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->191675762],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellID->108672185],

Cell[TextData[{
 "Create a subscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["-", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellTags->"fractions",
 CellID->406876596],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 "\[AutoOperand] or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->199877152],

Cell[BoxData[
 SubscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->21436492],

Cell["\<\
Type the subscript into the placeholder (which is already selected).\
\>", "Text",
 CellTags->"fractions",
 CellID->299017078],

Cell[TextData[{
 "Type ",
 Cell[BoxData["i"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->14143329],

Cell[BoxData[
 SubscriptBox["x", 
  RowBox[{"i", "\[VerticalSeparator]"}]]], "Input",
 CellID->395291080],

Cell[TextData[{
 "Press the ",
 StyleBox["Space", "KeyEvent"],
 " bar and then type ",
 Cell[BoxData["j"], "InlineFormula"],
 "."
}], "Text",
 CellTags->"fractions",
 CellID->119962421],

Cell[TextData[{
 "Press ",
 StyleBox["Space", "KeyEvent"],
 " and type ",
 Cell[BoxData["j"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->115554181],

Cell[BoxData[
 SubscriptBox["x", 
  RowBox[{
   RowBox[{"i", " ", "j"}], "\[VerticalSeparator]"}]]], "Input",
 CellTags->"subscripts",
 CellID->284421011],

Cell[TextData[{
 StyleBox["*To avoid multiplying the two subscripts, separate them with an \
invisible comma\[VeryThinSpace]. To type the alias for an invisible comma, \
press the ",
  FontWeight->"Plain"],
 StyleBox["Escape", "KeyEvent"],
 StyleBox[" key before and after typing a comma. ",
  FontWeight->"Plain"]
}], "Text",
 CellTags->"fractions",
 CellID->27947241],

Cell[TextData[{
 "Press ",
 StyleBox["Esc", "KeyEvent"],
 ", type a comma, press ",
 StyleBox["Esc", "KeyEvent"],
 ", and type ",
 Cell[BoxData["j"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->185742960],

Cell[BoxData[
 SubscriptBox["x", 
  RowBox[{
   RowBox[{"i", " ", "j"}], "\[VerticalSeparator]"}]]], "Input",
 CellTags->"subscripts",
 CellID->13769230],

Cell[TextData[{
 "Move the insertion point out of the subscript position up to the baseline \
by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->341068034],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->209872053],

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", 
   RowBox[{"i", " ", "j"}]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"subscripts",
 CellID->248710757]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    RowBox[{"2", "\[InvisibleComma]", "3"}]], TraditionalForm]]]
}], "Section",
 CellID->19333],

Cell["Type the symbol that will have the subscript. ", "Text",
 CellID->257792591],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->10431842],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellID->556894432],

Cell[TextData[{
 "Create a subscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["-", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellTags->"fractions",
 CellID->166677086],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["-", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->923108830],

Cell[BoxData[
 SubscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellID->700648788],

Cell["\<\
Type the subscript into the placeholder (which is already selected).\
\>", "Text",
 CellTags->"fractions",
 CellID->295204788],

Cell[TextData[{
 "Type ",
 Cell[BoxData["2"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->376666186],

Cell[BoxData[
 SubscriptBox["x", 
  RowBox[{
   StyleBox["2",
    FontColor->RGBColor[0, 0, 1]], "\[VerticalSeparator]"}]]], "Input",
 CellID->109565317],

Cell[TextData[{
 "To avoid multiplying the two subscripts, separate them with an invisible \
comma\[VeryThinSpace]. To type the alias for an invisible comma, press the ",
 StyleBox["Escape", "KeyEvent"],
 " key before and after typing a comma. "
}], "Text",
 CellTags->"fractions",
 CellID->272137675],

Cell[TextData[{
 "Press ",
 StyleBox["Esc", "KeyEvent"],
 ", type a comma, press ",
 StyleBox["Esc", "KeyEvent"],
 ", and type ",
 Cell[BoxData["3"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->238955707],

Cell[BoxData[
 SubscriptBox["x", 
  RowBox[{
   StyleBox["2",
    FontColor->RGBColor[0, 0, 1]], 
   StyleBox["\[InvisibleComma]",
    FontColor->RGBColor[0, 0, 1]], 
   RowBox[{
    StyleBox["3",
     FontColor->RGBColor[0, 0, 1]], "\[VerticalSeparator]"}]}]]], "Input",
 CellTags->"subscripts",
 CellID->47006483],

Cell[TextData[{
 "Move the insertion point out of the subscript position up to the baseline \
by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->221646011],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->171969893],

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", 
   StyleBox[
    RowBox[{"2", "\[InvisibleComma]", "3"}],
    FontColor->RGBColor[0, 0, 1]]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"subscripts",
 CellID->107890417]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    SubscriptBox["n", "i"]], TraditionalForm]]]
}], "Section",
 CellID->19444],

Cell["\<\
The first three steps create and fill in the subscript and its subscript. \
\>", "Text",
 CellID->173268223],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 ", then press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->724836093],

Cell[BoxData[
 SubscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"subscripts",
 CellID->227859376],

Cell[TextData[{
 "Type ",
 Cell[BoxData["n"], "InlineFormula"],
 ", then press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->11377225],

Cell[BoxData[
 SubscriptBox["x", 
  SubscriptBox["n", 
   StyleBox["\[Placeholder]",
    DrawHighlighted->1]]]], "Input",
 CellTags->"subscripts",
 CellID->51305750],

Cell[TextData[{
 "Type ",
 Cell[BoxData["i"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->233813452],

Cell[BoxData[
 SubscriptBox["x", 
  SubscriptBox["n", 
   RowBox[{"i", "\[VerticalSeparator]"}]]]], "Input",
 CellTags->"subscripts",
 CellID->404115878],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time twice to get up to the baseline. "
}], "Text",
 CellID->627500808],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " twice."
}], "MathCaption",
 CellID->487917521],

Cell[BoxData[
 SubscriptBox["x", 
  RowBox[{
   SubscriptBox["n", "i"], "\[VerticalSeparator]"}]]], "Input",
 CellTags->"subscripts",
 CellID->177441133],

Cell[BoxData[
 RowBox[{
  SubscriptBox["x", 
   SubscriptBox["n", "i"]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"subscripts",
 CellID->7185185],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->47335793],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Subscripts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingSuperscripts"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingOverscripts"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 35.0786598}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Type the symbol that will have the subscript. Type x. Create a subscript \
by pressing the Control key and the - key at the same time. ", 
    "synonyms" -> {}, "title" -> "Typing Subscripts", "type" -> "Tutorial", 
    "uri" -> "tutorial/TypingSubscripts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "fractions"->{
  Cell[1807, 72, 218, 8, 70, "Text",
   CellTags->"fractions",
   CellID->437149809],
  Cell[2436, 101, 136, 4, 70, "Text",
   CellTags->"fractions",
   CellID->426230220],
  Cell[3809, 170, 218, 8, 70, "Text",
   CellTags->"fractions",
   CellID->406876596],
  Cell[4437, 199, 136, 4, 70, "Text",
   CellTags->"fractions",
   CellID->299017078],
  Cell[4793, 217, 185, 8, 70, "Text",
   CellTags->"fractions",
   CellID->119962421],
  Cell[5296, 243, 369, 10, 70, "Text",
   CellTags->"fractions",
   CellID->27947241],
  Cell[7119, 326, 218, 8, 70, "Text",
   CellTags->"fractions",
   CellID->166677086],
  Cell[7734, 355, 136, 4, 70, "Text",
   CellTags->"fractions",
   CellID->295204788],
  Cell[8139, 375, 301, 7, 70, "Text",
   CellTags->"fractions",
   CellID->272137675]},
 "subscripts"->{
  Cell[5139, 236, 154, 5, 70, "Input",
   CellTags->"subscripts",
   CellID->284421011],
  Cell[5882, 266, 153, 5, 70, "Input",
   CellTags->"subscripts",
   CellID->13769230],
  Cell[6469, 292, 154, 5, 70, "Input",
   CellTags->"subscripts",
   CellID->248710757],
  Cell[8657, 395, 315, 11, 70, "Input",
   CellTags->"subscripts",
   CellID->47006483],
  Cell[9406, 427, 219, 7, 70, "Input",
   CellTags->"subscripts",
   CellID->107890417],
  Cell[10169, 465, 142, 5, 70, "Input",
   CellTags->"subscripts",
   CellID->227859376],
  Cell[10537, 483, 165, 6, 70, "Input",
   CellTags->"subscripts",
   CellID->51305750],
  Cell[10815, 498, 153, 5, 70, "Input",
   CellTags->"subscripts",
   CellID->404115878],
  Cell[11358, 523, 153, 5, 70, "Input",
   CellTags->"subscripts",
   CellID->177441133],
  Cell[11514, 530, 151, 5, 70, "Input",
   CellTags->"subscripts",
   CellID->7185185]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"fractions", 14159, 603},
 {"subscripts", 14959, 631}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 55, 1, 70, "Title",
 CellID->1904869366],
Cell[CellGroupData[{
Cell[1389, 49, 135, 7, 70, "Section",
 CellID->19111],
Cell[1527, 58, 82, 1, 70, "Text",
 CellID->140466097],
Cell[1612, 61, 106, 5, 70, "MathCaption",
 CellID->73829089],
Cell[1721, 68, 83, 2, 70, "Input",
 CellID->173992176],
Cell[1807, 72, 218, 8, 70, "Text",
 CellTags->"fractions",
 CellID->437149809],
Cell[2028, 82, 285, 11, 70, "MathCaption",
 CellID->299233980],
Cell[2316, 95, 117, 4, 70, "Input",
 CellID->123565387],
Cell[2436, 101, 136, 4, 70, "Text",
 CellTags->"fractions",
 CellID->426230220],
Cell[2575, 107, 107, 5, 70, "MathCaption",
 CellID->156471717],
Cell[2685, 114, 104, 3, 70, "Input",
 CellID->92233581],
Cell[2792, 119, 255, 8, 70, "Text",
 CellID->321696010],
Cell[3050, 129, 170, 7, 70, "MathCaption",
 CellID->238134069],
Cell[3223, 138, 105, 3, 70, "Input",
 CellID->364055760]
}, Open  ]],
Cell[CellGroupData[{
Cell[3365, 146, 160, 8, 70, "Section",
 CellID->19222],
Cell[3528, 156, 82, 1, 70, "Text",
 CellID->302153063],
Cell[3613, 159, 107, 5, 70, "MathCaption",
 CellID->191675762],
Cell[3723, 166, 83, 2, 70, "Input",
 CellID->108672185],
Cell[3809, 170, 218, 8, 70, "Text",
 CellTags->"fractions",
 CellID->406876596],
Cell[4030, 180, 285, 11, 70, "MathCaption",
 CellID->199877152],
Cell[4318, 193, 116, 4, 70, "Input",
 CellID->21436492],
Cell[4437, 199, 136, 4, 70, "Text",
 CellTags->"fractions",
 CellID->299017078],
Cell[4576, 205, 106, 5, 70, "MathCaption",
 CellID->14143329],
Cell[4685, 212, 105, 3, 70, "Input",
 CellID->395291080],
Cell[4793, 217, 185, 8, 70, "Text",
 CellTags->"fractions",
 CellID->119962421],
Cell[4981, 227, 155, 7, 70, "MathCaption",
 CellID->115554181],
Cell[5139, 236, 154, 5, 70, "Input",
 CellTags->"subscripts",
 CellID->284421011],
Cell[5296, 243, 369, 10, 70, "Text",
 CellTags->"fractions",
 CellID->27947241],
Cell[5668, 255, 211, 9, 70, "MathCaption",
 CellID->185742960],
Cell[5882, 266, 153, 5, 70, "Input",
 CellTags->"subscripts",
 CellID->13769230],
Cell[6038, 273, 255, 8, 70, "Text",
 CellID->341068034],
Cell[6296, 283, 170, 7, 70, "MathCaption",
 CellID->209872053],
Cell[6469, 292, 154, 5, 70, "Input",
 CellTags->"subscripts",
 CellID->248710757]
}, Open  ]],
Cell[CellGroupData[{
Cell[6660, 302, 176, 8, 70, "Section",
 CellID->19333],
Cell[6839, 312, 82, 1, 70, "Text",
 CellID->257792591],
Cell[6924, 315, 106, 5, 70, "MathCaption",
 CellID->10431842],
Cell[7033, 322, 83, 2, 70, "Input",
 CellID->556894432],
Cell[7119, 326, 218, 8, 70, "Text",
 CellTags->"fractions",
 CellID->166677086],
Cell[7340, 336, 271, 11, 70, "MathCaption",
 CellID->923108830],
Cell[7614, 349, 117, 4, 70, "Input",
 CellID->700648788],
Cell[7734, 355, 136, 4, 70, "Text",
 CellTags->"fractions",
 CellID->295204788],
Cell[7873, 361, 107, 5, 70, "MathCaption",
 CellID->376666186],
Cell[7983, 368, 153, 5, 70, "Input",
 CellID->109565317],
Cell[8139, 375, 301, 7, 70, "Text",
 CellTags->"fractions",
 CellID->272137675],
Cell[8443, 384, 211, 9, 70, "MathCaption",
 CellID->238955707],
Cell[8657, 395, 315, 11, 70, "Input",
 CellTags->"subscripts",
 CellID->47006483],
Cell[8975, 408, 255, 8, 70, "Text",
 CellID->221646011],
Cell[9233, 418, 170, 7, 70, "MathCaption",
 CellID->171969893],
Cell[9406, 427, 219, 7, 70, "Input",
 CellTags->"subscripts",
 CellID->107890417]
}, Open  ]],
Cell[CellGroupData[{
Cell[9662, 439, 159, 8, 70, "Section",
 CellID->19444],
Cell[9824, 449, 118, 3, 70, "Text",
 CellID->173268223],
Cell[9945, 454, 221, 9, 70, "MathCaption",
 CellID->724836093],
Cell[10169, 465, 142, 5, 70, "Input",
 CellTags->"subscripts",
 CellID->227859376],
Cell[10314, 472, 220, 9, 70, "MathCaption",
 CellID->11377225],
Cell[10537, 483, 165, 6, 70, "Input",
 CellTags->"subscripts",
 CellID->51305750],
Cell[10705, 491, 107, 5, 70, "MathCaption",
 CellID->233813452],
Cell[10815, 498, 153, 5, 70, "Input",
 CellTags->"subscripts",
 CellID->404115878],
Cell[10971, 505, 205, 7, 70, "Text",
 CellID->627500808],
Cell[11179, 514, 176, 7, 70, "MathCaption",
 CellID->487917521],
Cell[11358, 523, 153, 5, 70, "Input",
 CellTags->"subscripts",
 CellID->177441133],
Cell[11514, 530, 151, 5, 70, "Input",
 CellTags->"subscripts",
 CellID->7185185],
Cell[CellGroupData[{
Cell[11690, 539, 71, 1, 70, "RelatedTutorialsSection",
 CellID->47335793],
Cell[11764, 542, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[12007, 552, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

