(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19905,        804]
NotebookOptionsPosition[     11791,        540]
NotebookOutlinePosition[     15576,        651]
CellTagsIndexPosition[     15474,        645]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Two-Dimensional Expressions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Entering Two-Dimensional Expressions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Typing Superscripts", "Title",
 CellID->453224886],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " Superscript ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "i"], TraditionalForm]]]
}], "Section",
 CellID->45111],

Cell["Type the symbol that will have the superscript. ", "Text",
 CellID->27935537],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->232727688],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"overview",
 CellID->253008179],

Cell[TextData[{
 "Create a superscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["6", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->806053681],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->280147577],

Cell[BoxData[
 SuperscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"overview",
 CellID->49594275],

Cell["\<\
Type the superscript into the placeholder (which is already selected). \
\>", "Text",
 CellID->22524654],

Cell[TextData[{
 "Type ",
 Cell[BoxData["i"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->545404410],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"i", "\[VerticalSeparator]"}]]], "Input",
 CellID->588772911],

Cell[TextData[{
 "Move the insertion point out of the superscript position down to the \
baseline by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time. "
}], "Text",
 CellID->14040892],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->430304506],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "i"], "\[VerticalSeparator]"}]], "Input",
 CellID->250385489]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " Superscript ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{"i", " ", "j"}]], TraditionalForm]]]
}], "Section",
 CellID->45222],

Cell["Type the symbol that will have the superscript. ", "Text",
 CellID->430164509],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->498119332],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"overview",
 CellID->270001251],

Cell[TextData[{
 "Create a superscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["6", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->634110214],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->395488844],

Cell[BoxData[
 SuperscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"overview",
 CellID->20159620],

Cell[TextData[{
 "To avoid multiplying the two superscripts, separate them with an invisible \
comma\[VeryThinSpace]. To type the alias for an invisible comma, press the ",
 StyleBox["Escape", "KeyEvent"],
 " key before and after typing a comma. "
}], "Text",
 CellID->157841407],

Cell[TextData[{
 "Type ",
 Cell[BoxData["i"], "InlineFormula"],
 ", press ",
 StyleBox["Esc", "KeyEvent"],
 ", type a comma, press ",
 StyleBox["Esc", "KeyEvent"],
 ", and type ",
 Cell[BoxData["j"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->2116010],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{
   RowBox[{"i", " ", "j"}], "\[VerticalSeparator]"}]]], "Input",
 CellTags->"superscripts",
 CellID->737743858],

Cell[TextData[{
 "Get out of the superscript position up to the baseline by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time."
}], "Text",
 CellID->212075838],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->415000221],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"i", " ", "j"}]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"superscripts",
 CellID->71275620]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " Superscript ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{"2", "\[InvisibleComma]", "3"}]], TraditionalForm]]],
 " "
}], "Section",
 CellID->45333],

Cell["Type the symbol that will have the superscript. ", "Text",
 CellID->748722706],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->287354178],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"overview",
 CellID->40054363],

Cell[TextData[{
 "Create a superscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["6", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->415893885],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->232578087],

Cell[BoxData[
 SuperscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"overview",
 CellID->336065413],

Cell[TextData[{
 "To avoid multiplying the two superscripts, separate them with an invisible \
comma\[VeryThinSpace]. To type the alias for an invisible comma, press the ",
 StyleBox["Escape", "KeyEvent"],
 " key before and after typing a comma. "
}], "Text",
 CellID->418650168],

Cell[TextData[{
 "Type ",
 Cell[BoxData["2"], "InlineFormula"],
 ", press ",
 StyleBox["Esc", "KeyEvent"],
 ", type a comma, press ",
 StyleBox["Esc", "KeyEvent"],
 ", and type ",
 Cell[BoxData["3"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->471055982],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"2", "\[InvisibleComma]", 
   RowBox[{"3", "\[VerticalSeparator]"}]}]]], "Input",
 CellTags->"superscripts",
 CellID->462199010],

Cell[TextData[{
 "Get out of the superscript position up to the baseline by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time."
}], "Text",
 CellID->519109369],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->480983623],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"2", "\[InvisibleComma]", "3"}]], 
  "\[VerticalSeparator]"}]], "Input",
 CellTags->"superscripts",
 CellID->125500677]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Typing",
 " Superscript ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    SubscriptBox["n", "i"]], TraditionalForm]]]
}], "Section",
 CellID->45444],

Cell["Type the symbol that will have the superscript. ", "Text",
 CellID->754628176],

Cell[TextData[{
 "Type ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->130291500],

Cell[BoxData[
 RowBox[{"x", "\[VerticalSeparator]"}]], "Input",
 CellTags->"overview",
 CellID->323662930],

Cell[TextData[{
 "Create a superscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["6", "KeyEvent"],
 " key (or the ",
 StyleBox["^", "KeyEvent"],
 " key) at the same time. "
}], "Text",
 CellID->393118739],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->432066457],

Cell[BoxData[
 SuperscriptBox["x", 
  StyleBox["\[Placeholder]",
   DrawHighlighted->1]]], "Input",
 CellTags->"overview",
 CellID->398582889],

Cell["\<\
Type the superscript into the placeholder (which is already selected). \
\>", "Text",
 CellID->136734598],

Cell[TextData[{
 "Type ",
 Cell[BoxData["n"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->70308935],

Cell[BoxData[
 SuperscriptBox["X", 
  RowBox[{"n", "|"}]]], "Input",
 CellID->478276063],

Cell[TextData[{
 "Create a subscript of a superscript by pressing the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["_", "KeyEvent"],
 " key at the same time. "
}], "Text",
 CellID->23446096],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->355747621],

Cell[BoxData[
 SuperscriptBox["x", 
  SubscriptBox["n", 
   StyleBox["\[Placeholder]",
    DrawHighlighted->1]]]], "Input",
 CellTags->"superscripts",
 CellID->1027149],

Cell[TextData[{
 "Type ",
 Cell[BoxData["i"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->287626859],

Cell[BoxData[
 SuperscriptBox["x", 
  SubscriptBox["n", 
   RowBox[{"i", "\[VerticalSeparator]"}]]]], "Input",
 CellTags->"superscripts",
 CellID->643944686],

Cell[TextData[{
 "Press the ",
 StyleBox["Control", "KeyEvent"],
 " key and the ",
 StyleBox["Space", "KeyEvent"],
 " bar at the same time twice to get down to the baseline. "
}], "Text",
 CellTags->"superscripts",
 CellID->401037874],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->221190212],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{
   SubscriptBox["n", "i"], "|"}]]], "Input",
 CellTags->"superscripts",
 CellID->41192049],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 "."
}], "MathCaption",
 CellID->364770891],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   SubscriptBox["n", "i"]], "\[VerticalSeparator]"}]], "Input",
 CellTags->"superscripts",
 CellID->366478376],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->6695601],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Typing Superscripts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Entering Two-Dimensional Expressions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingMatrices"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TypingSubscripts"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 35.6724250}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Type the symbol that will have the superscript. Type x. Create a \
superscript by pressing the Control key and the 6 key at the same time. ", 
    "synonyms" -> {}, "title" -> "Typing Superscripts", "type" -> "Tutorial", 
    "uri" -> "tutorial/TypingSuperscripts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "overview"->{
  Cell[1738, 68, 106, 3, 70, "Input",
   CellTags->"overview",
   CellID->253008179],
  Cell[2320, 95, 141, 5, 70, "Input",
   CellTags->"overview",
   CellID->49594275],
  Cell[3753, 166, 106, 3, 70, "Input",
   CellTags->"overview",
   CellID->270001251],
  Cell[4335, 193, 141, 5, 70, "Input",
   CellTags->"overview",
   CellID->20159620],
  Cell[6183, 277, 105, 3, 70, "Input",
   CellTags->"overview",
   CellID->40054363],
  Cell[6764, 304, 142, 5, 70, "Input",
   CellTags->"overview",
   CellID->336065413],
  Cell[8628, 388, 106, 3, 70, "Input",
   CellTags->"overview",
   CellID->323662930],
  Cell[9257, 417, 142, 5, 70, "Input",
   CellTags->"overview",
   CellID->398582889]},
 "superscripts"->{
  Cell[5023, 221, 158, 5, 70, "Input",
   CellTags->"superscripts",
   CellID->737743858],
  Cell[5593, 246, 157, 5, 70, "Input",
   CellTags->"superscripts",
   CellID->71275620],
  Cell[7455, 332, 174, 5, 70, "Input",
   CellTags->"superscripts",
   CellID->462199010],
  Cell[8041, 357, 177, 6, 70, "Input",
   CellTags->"superscripts",
   CellID->125500677],
  Cell[10102, 459, 168, 6, 70, "Input",
   CellTags->"superscripts",
   CellID->1027149],
  Cell[10383, 474, 157, 5, 70, "Input",
   CellTags->"superscripts",
   CellID->643944686],
  Cell[10543, 481, 234, 8, 70, "Text",
   CellTags->"superscripts",
   CellID->401037874],
  Cell[10953, 500, 137, 5, 70, "Input",
   CellTags->"superscripts",
   CellID->41192049],
  Cell[11266, 516, 157, 5, 70, "Input",
   CellTags->"superscripts",
   CellID->366478376]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"overview", 13920, 589},
 {"superscripts", 14631, 614}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 56, 1, 70, "Title",
 CellID->453224886],
Cell[CellGroupData[{
Cell[1390, 49, 149, 7, 70, "Section",
 CellID->45111],
Cell[1542, 58, 83, 1, 70, "Text",
 CellID->27935537],
Cell[1628, 61, 107, 5, 70, "MathCaption",
 CellID->232727688],
Cell[1738, 68, 106, 3, 70, "Input",
 CellTags->"overview",
 CellID->253008179],
Cell[1847, 73, 196, 7, 70, "Text",
 CellID->806053681],
Cell[2046, 82, 271, 11, 70, "MathCaption",
 CellID->280147577],
Cell[2320, 95, 141, 5, 70, "Input",
 CellTags->"overview",
 CellID->49594275],
Cell[2464, 102, 114, 3, 70, "Text",
 CellID->22524654],
Cell[2581, 107, 107, 5, 70, "MathCaption",
 CellID->545404410],
Cell[2691, 114, 107, 3, 70, "Input",
 CellID->588772911],
Cell[2801, 119, 258, 8, 70, "Text",
 CellID->14040892],
Cell[3062, 129, 170, 7, 70, "MathCaption",
 CellID->430304506],
Cell[3235, 138, 107, 3, 70, "Input",
 CellID->250385489]
}, Open  ]],
Cell[CellGroupData[{
Cell[3379, 146, 174, 8, 70, "Section",
 CellID->45222],
Cell[3556, 156, 84, 1, 70, "Text",
 CellID->430164509],
Cell[3643, 159, 107, 5, 70, "MathCaption",
 CellID->498119332],
Cell[3753, 166, 106, 3, 70, "Input",
 CellTags->"overview",
 CellID->270001251],
Cell[3862, 171, 196, 7, 70, "Text",
 CellID->634110214],
Cell[4061, 180, 271, 11, 70, "MathCaption",
 CellID->395488844],
Cell[4335, 193, 141, 5, 70, "Input",
 CellTags->"overview",
 CellID->20159620],
Cell[4479, 200, 279, 6, 70, "Text",
 CellID->157841407],
Cell[4761, 208, 259, 11, 70, "MathCaption",
 CellID->2116010],
Cell[5023, 221, 158, 5, 70, "Input",
 CellTags->"superscripts",
 CellID->737743858],
Cell[5184, 228, 233, 7, 70, "Text",
 CellID->212075838],
Cell[5420, 237, 170, 7, 70, "MathCaption",
 CellID->415000221],
Cell[5593, 246, 157, 5, 70, "Input",
 CellTags->"superscripts",
 CellID->71275620]
}, Open  ]],
Cell[CellGroupData[{
Cell[5787, 256, 196, 9, 70, "Section",
 CellID->45333],
Cell[5986, 267, 84, 1, 70, "Text",
 CellID->748722706],
Cell[6073, 270, 107, 5, 70, "MathCaption",
 CellID->287354178],
Cell[6183, 277, 105, 3, 70, "Input",
 CellTags->"overview",
 CellID->40054363],
Cell[6291, 282, 196, 7, 70, "Text",
 CellID->415893885],
Cell[6490, 291, 271, 11, 70, "MathCaption",
 CellID->232578087],
Cell[6764, 304, 142, 5, 70, "Input",
 CellTags->"overview",
 CellID->336065413],
Cell[6909, 311, 279, 6, 70, "Text",
 CellID->418650168],
Cell[7191, 319, 261, 11, 70, "MathCaption",
 CellID->471055982],
Cell[7455, 332, 174, 5, 70, "Input",
 CellTags->"superscripts",
 CellID->462199010],
Cell[7632, 339, 233, 7, 70, "Text",
 CellID->519109369],
Cell[7868, 348, 170, 7, 70, "MathCaption",
 CellID->480983623],
Cell[8041, 357, 177, 6, 70, "Input",
 CellTags->"superscripts",
 CellID->125500677]
}, Open  ]],
Cell[CellGroupData[{
Cell[8255, 368, 173, 8, 70, "Section",
 CellID->45444],
Cell[8431, 378, 84, 1, 70, "Text",
 CellID->754628176],
Cell[8518, 381, 107, 5, 70, "MathCaption",
 CellID->130291500],
Cell[8628, 388, 106, 3, 70, "Input",
 CellTags->"overview",
 CellID->323662930],
Cell[8737, 393, 243, 9, 70, "Text",
 CellID->393118739],
Cell[8983, 404, 271, 11, 70, "MathCaption",
 CellID->432066457],
Cell[9257, 417, 142, 5, 70, "Input",
 CellTags->"overview",
 CellID->398582889],
Cell[9402, 424, 115, 3, 70, "Text",
 CellID->136734598],
Cell[9520, 429, 106, 5, 70, "MathCaption",
 CellID->70308935],
Cell[9629, 436, 88, 3, 70, "Input",
 CellID->478276063],
Cell[9720, 441, 210, 7, 70, "Text",
 CellID->23446096],
Cell[9933, 450, 166, 7, 70, "MathCaption",
 CellID->355747621],
Cell[10102, 459, 168, 6, 70, "Input",
 CellTags->"superscripts",
 CellID->1027149],
Cell[10273, 467, 107, 5, 70, "MathCaption",
 CellID->287626859],
Cell[10383, 474, 157, 5, 70, "Input",
 CellTags->"superscripts",
 CellID->643944686],
Cell[10543, 481, 234, 8, 70, "Text",
 CellTags->"superscripts",
 CellID->401037874],
Cell[10780, 491, 170, 7, 70, "MathCaption",
 CellID->221190212],
Cell[10953, 500, 137, 5, 70, "Input",
 CellTags->"superscripts",
 CellID->41192049],
Cell[11093, 507, 170, 7, 70, "MathCaption",
 CellID->364770891],
Cell[11266, 516, 157, 5, 70, "Input",
 CellTags->"superscripts",
 CellID->366478376],
Cell[CellGroupData[{
Cell[11448, 525, 70, 1, 70, "RelatedTutorialsSection",
 CellID->6695601],
Cell[11521, 528, 204, 5, 70, "RelatedTutorials",
 CellID->161747686]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[11764, 538, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

