(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10710,        318]
NotebookOptionsPosition[      6824,        212]
NotebookOutlinePosition[      9772,        285]
CellTagsIndexPosition[      9703,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Solving Nonlinear Equations", "Title",
 CellTags->"b:0.3.0",
 CellID->771134545],

Cell[TextData[{
 "There are some close connections between finding a \"",
 ButtonBox["local minimum",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationIntroductionLocalMinimization"],
 "\" and solving a set of nonlinear equations. Given a set of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " equations in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " unknowns, seeking a solution ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "(", "x", ")"}], " ", "\[Equal]", " ", "0"}], 
   TraditionalForm]], "InlineMath"],
 " is equivalent to minimizing the sum of squares ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "(", "x", ")"}], ".", " ", 
    RowBox[{"r", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 " when the residual is zero at the minimum, so there is a particularly close \
connection to the ",
 ButtonBox["Gauss\[Dash]Newton",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationGaussNewtonMethods"],
 " methods. In fact, the Gauss\[Dash]Newton step for local minimization and \
the ",
 ButtonBox["Newton",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationNewtonsMethodRoot"],
 " step for nonlinear equations are exactly the same. Also, for a smooth \
function, \"",
 ButtonBox["Newton\[CloseCurlyQuote]s method",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationNewtonsMethodMinimum"],
 "\" for local minimization is the same as Newton\[CloseCurlyQuote]s method \
for the nonlinear equations ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Del]", "f"}], "=", "0"}], TraditionalForm]], "InlineMath"],
 ". Not surprisingly, many aspects of the algorithms are similar, however, \
there are also important differences."
}], "Text",
 CellTags->"b:0.3.0",
 CellID->394488170],

Cell[TextData[{
 "Another thing in common with minimization algorithms is the need for some \
kind of \"",
 ButtonBox["step control",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationIntroductionStepControl"],
 "\". Typically, step control is based on the same methods as minimization \
except that they are applied to a merit function, usually the smooth 2-norm \
squared, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "(", "x", ")"}], ".", " ", 
    RowBox[{"r", "(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellTags->"b:0.3.0",
 CellID->880654901],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[StyleBox["\"Newton\"", "MR"]]], Cell["\<\
use the exact Jacobian or a finite difference approximation to solve for the \
step based on a locally linear model\
\>", "Text"]},
    {Cell[TextData[StyleBox["\"Secant\"", "MR"]]], Cell[TextData[{
      "Work without derivatives by constructing a secant approximation to the \
Jacobian using ",
      Cell[BoxData[
       StyleBox["n", "TI"]], "InlineFormula"],
      " past steps, require two starting conditions in each dimension"
     }], "Text"]},
    {Cell[TextData[StyleBox["\"Brent\"", "MR"]]], Cell["\<\
method in one dimension that maintains bracketing of roots, requires two \
starting conditions that bracket a root\
\>", "Text"]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.3.0",
 CellID->709625983],

Cell[TextData[{
 "Basic method choices for ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.3.0",
 CellID->1707204490],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->221292953],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->65630308],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Solving Nonlinear Equations - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 44, 44.9851634}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "There are some close connections between finding a \"local minimum\" and \
solving a set of nonlinear equations. Given a set of n equations in n \
unknowns, seeking a solution r(x) == 0 is equivalent to minimizing the sum of \
squares r(x). r(x) when the residual is zero at the minimum, so there is a \
particularly close connection to the Gauss-Newton methods. In fact, the \
Gauss-Newton step for local minimization and the Newton step for nonlinear \
equations are exactly the same. Also, for a smooth function, \"Newton's \
method\" for local minimization is the same as Newton's method for the \
nonlinear equations \\[Del]f=0. Not surprisingly, many aspects of the \
algorithms are similar, however, there are also important differences. \
Another thing in common with minimization algorithms is the need for some \
kind of \"step control\". Typically, step control is based on the same \
methods as minimization except that they are applied to a merit function, \
usually the smooth 2-norm squared, r(x). r(x). use the exact Jacobian or a \
finite difference approximation to solve for the step based on a locally \
linear model", "synonyms" -> {}, "title" -> 
    "Introduction to Solving Nonlinear Equations", "type" -> "Tutorial", 
    "uri" -> "tutorial/\
UnconstrainedOptimizationIntroductionNonlinearEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0.3.0"->{
  Cell[2234, 67, 102, 2, 70, "Title",
   CellTags->"b:0.3.0",
   CellID->771134545],
  Cell[2339, 71, 1864, 50, 70, "Text",
   CellTags->"b:0.3.0",
   CellID->394488170],
  Cell[4206, 123, 620, 18, 70, "Text",
   CellTags->"b:0.3.0",
   CellID->880654901],
  Cell[4829, 143, 815, 19, 70, "DefinitionBox",
   CellTags->"b:0.3.0",
   CellID->709625983],
  Cell[5647, 164, 227, 9, 70, "Caption",
   CellTags->"b:0.3.0",
   CellID->1707204490]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0.3.0", 9238, 261}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1609, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 67, 102, 2, 70, "Title",
 CellTags->"b:0.3.0",
 CellID->771134545],
Cell[2339, 71, 1864, 50, 70, "Text",
 CellTags->"b:0.3.0",
 CellID->394488170],
Cell[4206, 123, 620, 18, 70, "Text",
 CellTags->"b:0.3.0",
 CellID->880654901],
Cell[4829, 143, 815, 19, 70, "DefinitionBox",
 CellTags->"b:0.3.0",
 CellID->709625983],
Cell[5647, 164, 227, 9, 70, "Caption",
 CellTags->"b:0.3.0",
 CellID->1707204490],
Cell[CellGroupData[{
Cell[5899, 177, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->221292953],
Cell[5968, 180, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[6114, 185, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[6281, 190, 195, 4, 70, "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],
Cell[CellGroupData[{
Cell[6513, 199, 71, 1, 70, "RelatedTutorialsSection",
 CellID->65630308],
Cell[6587, 202, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],
Cell[6797, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

