(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35987,       1051]
NotebookOptionsPosition[     26906,        761]
NotebookOutlinePosition[     32520,        925]
CellTagsIndexPosition[     32404,        918]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Symbolic Evaluation", "Title",
 CellTags->{"t:25", "c:25", "b:0.5.4"},
 CellID->147397427],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " have the ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " attribute and so have special semantics for evaluation of their arguments. \
First, the variables are determined from the second argument, then they are \
localized. Next, the function is evaluated symbolically, then processed into \
an efficient form for numerical evaluation. Finally, during the execution of \
the command, the function is repeatedly evaluated with different numerical \
values. Here is a list showing these steps with additional description."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->1259910598],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell["Determine variables"], Cell["\<\
This will be done by processing the second argument. If the second argument \
is not of the correct form (a list of variables and starting values), it will \
be evaluated to get the correct form.\
\>", "Text"]},
    {
     RowBox[{"Localize", " ", "variables"}], Cell[TextData[{
      "In a manner similar to ",
      StyleBox["Block", "MR"],
      " and ",
      StyleBox["Table", "MR"],
      ", add rules to the variables so that any assignments given to them \
will not affect your ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      " session beyond the scope of the ",
      StyleBox["Find", "MR"],
      " command and so that previous assignments do not affect the value (the \
variable will evaluate to itself at this stage)"
     }], "Text"]},
    {
     RowBox[{"Evaluate", " ", "the", " ", "function"}], Cell[TextData[{
      "With the locally undefined (symbolic) values of the variables, \
evaluate the first argument (function or equations). Note: this is a change \
which was instituted in ",
      StyleBox["Mathematica",
       FontSlant->"Italic"],
      " 5, so some adjustments may be necessary for code that ran in previous \
versions. If your function is such that symbolic evaluation will not keep the \
function as intended or will be prohibitively slow, you should define your \
function so that it only evaluates for numerical values of the variables. The \
simplest way to do this is by defining your function using ",
      StyleBox["PatternTest", "MR"],
      " (?), as in ",
      StyleBox["f[x_?NumberQ]:= ", "MR"],
      StyleBox["definition", "MR",
       FontSlant->"Italic"],
      ". "
     }], "Text"]},
    {
     RowBox[{"Preprocess", " ", "the", " ", "function"}], Cell["\<\
Analyze the function to help determine the algorithm to use (e.g., sum of \
squares -> Levenberg\[Dash]Marquardt). Optimize and compile the function for \
faster numerical evaluation if possible. For FindRoot this first involves \
going from equations to a function.\
\>", "Text"]},
    {
     RowBox[{"Compute", " ", "derivatives"}], Cell["\<\
Compute any needed symbolic derivatives if possible; otherwise, do \
preprocessing needed to compute derivatives using finite differences.\
\>", "Text"]},
    {
     RowBox[{"Evaluate", " ", "numerically"}], Cell["\<\
Repeatedly evaluate the function (and derivatives when required) with \
different numerical values.\
\>", "Text"]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.5.4",
 CellID->1128661166],

Cell[TextData[{
 "Steps in processing the function for the \"",
 StyleBox["Find\"", "MR"],
 " commands."
}], "Caption",
 CellTags->"b:0.5.4",
 CellID->685163011],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " does not have the ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " attribute, so its arguments are all evaluated before the commands begin. \
However, it uses all of the stages described above, except instead of \
evaluating the function, it constructs a function to minimize from the model \
function, variables, and provided data."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->727410663],

Cell["\<\
You will sometimes want to prevent symbolic evaluation, most often when your \
function is not an explicit formula, but a value derived through running \
through a program. An example of what happens and how to prevent the symbolic \
evaluation is shown.\
\>", "Text",
 CellTags->"b:0.5.4",
 CellID->2114094317],

Cell["\<\
This attempts to solve a simple boundary value problem numerically using \
shooting.\
\>", "MathCaption",
 CellTags->"b:0.5.4",
 CellID->1466246204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], " ", "/.", " ", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "[", "t", "]"}], " ", 
               RowBox[{"UnitStep", "[", "t", "]"}]}], " ", "+", "1"}], ")"}], 
            
            RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", " ", "0"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"-", "1"}], "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "'"}], "[", 
           RowBox[{"-", "1"}], "]"}], " ", "\[Equal]", " ", "xp"}]}], "}"}], 
       ",", "x", ",", " ", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"xp", ",", " ", "Pi"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[5]:=",
 CellID->825101303],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndinnt\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Initial condition \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(xp\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is not a number or a \
rectangular array of numbers.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/NDSolve/ndinnt\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:0.5.4",
 CellLabel->"During evaluation of In[5]:=",
 CellID->1809013754],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceAll", "::", "\<\"reps\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(NDSolve[\\(\\(\\(\\({\\(\\(\\(\\(\\(\\(\\(\\(x[t]\\)\\)\
\\\\ \\(\\((1 + \\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(\\*SuperscriptBox[\\\
\"x\\\", \\\"\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[t]\\)\
\\)\\)\\) \[Equal] 0\\)\\), \\(\\(\\(\\(x[\\(\\(-1\\)\\)]\\)\\) \[Equal] 0\\)\
\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(-1\\)\\)]\\)\\) \[Equal] xp\\)\\)}\
\\)\\), x, \\(\\({t, \\(\\(-1\\)\\), 1}\\)\\)\\)\\)]\\)}\\)\\!\\(\\*StyleBox[\
\\\"\\\\\\\" is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:Symbols/System/ReplaceAll\\\"]\\)\"\
\>"}]], "Message", "MSG",
 CellTags->"b:0.5.4",
 CellLabel->"During evaluation of In[5]:=",
 CellID->20689252],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"nlnum\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The function value \\\\\\\"\\\", \\\
\"MSG\\\"]\\)\\!\\({\\(x[1.`]\\)}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is not a \
list of numbers with dimensions \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({1}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" at \\\\\\\"\\\", \\\
\"MSG\\\"]\\)\\!\\({xp}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" = \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({3.141592653589793`}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\
\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/General/nlnum\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:0.5.4",
 CellLabel->"During evaluation of In[5]:=",
 CellID->1979391197],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndinnt\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Initial condition \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(xp\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is not a number or a \
rectangular array of numbers.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/NDSolve/ndinnt\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:0.5.4",
 CellLabel->"During evaluation of In[5]:=",
 CellID->958672302],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceAll", "::", "\<\"reps\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(NDSolve[\\(\\(\\(\\({\\(\\(\\(\\(\\(\\(\\(\\(x[t]\\)\\)\
\\\\ \\(\\((1 + \\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(\\*SuperscriptBox[\\\
\"x\\\", \\\"\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[t]\\)\
\\)\\)\\) \[Equal] 0\\)\\), \\(\\(\\(\\(x[\\(\\(-1\\)\\)]\\)\\) \[Equal] 0\\)\
\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(-1\\)\\)]\\)\\) \[Equal] xp\\)\\)}\
\\)\\), x, \\(\\({t, \\(\\(-1\\)\\), 1}\\)\\)\\)\\)]\\)}\\)\\!\\(\\*StyleBox[\
\\\"\\\\\\\" is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:Symbols/System/ReplaceAll\\\"]\\)\"\
\>"}]], "Message", "MSG",
 CellTags->"b:0.5.4",
 CellLabel->"During evaluation of In[5]:=",
 CellID->1983059920],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"nlnum\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The function value \\\\\\\"\\\", \\\
\"MSG\\\"]\\)\\!\\({\\(x[1.`]\\)}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is not a \
list of numbers with dimensions \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({1}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" at \\\\\\\"\\\", \\\
\"MSG\\\"]\\)\\!\\({xp}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" = \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\({3.141592653589793`}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\
\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/General/nlnum\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:0.5.4",
 CellLabel->"During evaluation of In[5]:=",
 CellID->341874000],

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], "/.", "\[InvisibleSpace]", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            SuperscriptBox["x", "\[Prime]\[Prime]",
             MultilineFunction->None], "[", "t", "]"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "[", "t", "]"}], " ", 
               RowBox[{"UnitStep", "[", "t", "]"}]}], "+", "1"}], ")"}], " ", 
            
            RowBox[{"x", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"-", "1"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{
           SuperscriptBox["x", "\[Prime]",
            MultilineFunction->None], "[", 
           RowBox[{"-", "1"}], "]"}], "\[Equal]", "xp"}]}], "}"}], ",", "x", 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"xp", ",", "\[Pi]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{575, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[5]=",
 CellID->1357562275]
}, Open  ]],

Cell[TextData[{
 "The command fails because of the symbolic evaluation of the function. You \
can see what happens when you evaluate it inside of ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->1684681963],

Cell[TextData[{
 "This evaluates the function given to ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " with a local (undefined) value of ",
 Cell[BoxData["xp"], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.5.4",
 CellID->2025350093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "xp", "}"}], ",", " ", 
   RowBox[{"First", "[", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], " ", "/.", " ", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"x", "[", "t", "]"}], " ", 
               RowBox[{"UnitStep", "[", "t", "]"}]}], " ", "+", "1"}], ")"}], 
            
            RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", " ", "0"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"-", "1"}], "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "'"}], "[", 
           RowBox[{"-", "1"}], "]"}], " ", "\[Equal]", " ", "xp"}]}], "}"}], 
       ",", "x", ",", " ", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[6]:=",
 CellID->295724454],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndinnt\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Initial condition \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(xp\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is not a number or a \
rectangular array of numbers.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/NDSolve/ndinnt\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellTags->"b:0.5.4",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1682890197],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceAll", "::", "\<\"reps\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(NDSolve[\\(\\(\\(\\({\\(\\(\\(\\(\\(\\(\\(\\(x[t]\\)\\)\
\\\\ \\(\\((1 + \\(\\(Times[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\))\\)\\)\\)\\) + \\(\\(\\(\\(\\*SuperscriptBox[\\\
\"x\\\", \\\"\[Prime]\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[t]\\)\
\\)\\)\\) \[Equal] 0\\)\\), \\(\\(\\(\\(x[\\(\\(-1\\)\\)]\\)\\) \[Equal] 0\\)\
\\), \\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(-1\\)\\)]\\)\\) \[Equal] xp\\)\\)}\
\\)\\), x, \\(\\({t, \\(\\(-1\\)\\), 1}\\)\\)\\)\\)]\\)}\\)\\!\\(\\*StyleBox[\
\\\"\\\\\\\" is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:Symbols/System/ReplaceAll\\\"]\\)\"\
\>"}]], "Message", "MSG",
 CellTags->"b:0.5.4",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1975909989],

Cell[BoxData[
 RowBox[{"x", "[", "1", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[6]=",
 CellID->432067915]
}, Open  ]],

Cell[TextData[{
 "Of course, this is not at all what was intended for the function; it does \
not even depend on ",
 Cell[BoxData["xp"], "InlineFormula"],
 ". What happened is that without a numerical value for ",
 Cell[BoxData["xp"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " fails, so ",
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{"(", "/.", ")"}]], "InlineFormula"],
 " fails because there are no rules. ",
 Cell[BoxData[
  ButtonBox["First",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/First"]], "InlineFormula"],
 " just returns its first argument, which is ",
 Cell[BoxData[
  RowBox[{"x", "[", "1", "]"}]], "InlineFormula"],
 ". Since the function is meaningless unless ",
 Cell[BoxData["xp"], "InlineFormula"],
 " has numerical values, it should be defined as such."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->1804079559],

Cell[TextData[{
 "This defines a function that returns the value ",
 Cell[BoxData[
  RowBox[{"x", "[", "1", "]"}]], "InlineFormula"],
 " as a function of a numerical value for the ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "'"}], "[", "t", "]"}]], "InlineFormula"],
 " at ",
 Cell[BoxData[
  RowBox[{"t", "=", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.5.4",
 CellID->843536120],

Cell[BoxData[
 RowBox[{
  RowBox[{"fx1", "[", 
   RowBox[{"xp_", "?", "NumberQ"}], "]"}], " ", ":=", "  ", 
  RowBox[{"First", "[", 
   RowBox[{
    RowBox[{"x", "[", "1", "]"}], " ", "/.", " ", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", "  ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "[", "t", "]"}], 
              RowBox[{"UnitStep", "[", "t", "]"}]}], " ", "+", "1"}], ")"}], 
           RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", " ", "0"}], ",",
         " ", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"-", "1"}], "]"}], " ", "\[Equal]", " ", "0"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", 
          RowBox[{"-", "1"}], "]"}], " ", "\[Equal]", " ", "xp"}]}], "}"}], 
      ",", "x", ",", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[7]:=",
 CellID->1772014993],

Cell[TextData[{
 "An advantage of having a simple function definition outside of ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " is that it can independently be tested to make sure that it is what you \
really intended."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->952770755],

Cell[TextData[{
 "This makes a plot of ",
 Cell[BoxData["fx1"], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->"b:0.5.4",
 CellID->1580007253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"fx1", "[", "xp", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"xp", ",", " ", "0", ",", " ", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[9]:=",
 CellID->1546606016],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WEtMnFUUvgwzzExpy6CtjFDa8U0XJvhIxFccja1jUxU1jTQ1DdhHpgst
0qqoUVKj4hujMSRucMeSTROWLFmyZMmSJUuW43fOuXfu/x9Of6RVSWDunfud
77zvg9cmrjcvvT9x/cqFidorUxOTzSsXrtVOXp3CV50dzrmb+L1YdRi3MOLf
m60WPvvobyfN+cf9aX77B8+3t7dXV1dpmMtANZvN+fn5NCoHkKyurKzU63Ue
mhy/B03Dw8Pr6+sun4Ganp6enZ2loY36jedra2sjIyNgdIUMFNQBSMOIIqtl
FWqgjIZdJsevPIe9oCFNxQwUjPFRtFFzSmPJRP2iNJZTVs8pTWWT42elaR+j
yCoC5RSaeLvUdz8pK7qZoaRQnOl8nDuJcQLxY8g6agMmu/0CkxLhn1yY7pk3
NzMzc2APdhHgB1U5e5FPIr4PfvlqPnhHPLHeD7YzFbJiZee7VrrjeswqYMLO
ra2toaGhzc1NV0lVknCMjo4uLS3RsGJyfMtztD2an4a9JuobVS13maivVczu
zkBNTk7OzXGxRxRZLaswGYbT8JDJ8RXP4TM0keeHM1AIIQJJQxt1w1daX8qO
G4xCRaOOaNhnys6EDMCOjY0NV81ANRqN5eVlGtqoL70d/ebqFzwHAWhoGFFk
razCAtgBa9yAyfF5yA98Qoe4Ixmo8fHxhYUFGgoqVGyyk0N36+r9jOdIL5JM
w0HGMirVK0Ulp3eJT0MOkEKquqMta2/x236kNXlpOq2q5tht2vVJiKPf82q3
4Cm07O4W+XjaZskn5fT841a6d+9LZSp8aqmPQiWhwyiq96cqSVbRvagRqqQH
zBq51krX/YMmakrF6aEM1NjY2OLiIg1t1Ic8j/vowymrZRUFi7Kl4SMmx1Xl
+ZCJ+oDn6A9YTRE4bqL6fU3RJyVtwM95v6JORPyoxnTug5x97xkw0MluO6rW
KyEP0EY7rq7cQTXvSEXtyC7atXRP0IbI0P7R5X3XVkUtWexae7+3qjdUDbKE
XKV8ohgc+1e06XXxLe7RJW/NoP/8Z/m6t6V7WMeG7yOJ3bWc0LNjzzGrLmQu
fNJyj2LtNrxv797t/DeV1LCp87JCPWaiLinU4ybqokI9wSjqmb94P2/jfR+b
98Y9zPN3KP9fz037ijJHB6AcfaCMffx/seXWfSYb9o6+OrwLi8aL1tjth3bB
J6ygPmsfQecZJ3sT8YxEXEGk4z3i3QSWzqWn21i+T5DJcqi6c4yU3Zx2vGci
a1fbJvzIWX6W0WD0999nI7qYRMcT8R2WwG3XnzXPpWPsfZb3XLy3nOE5ror+
HHvelJLIx3PsrRBpZA6y7oWU11Jd8WwcTXhOea6bOkQK6+Ck4euBRR7l7kVT
Ss7E+Ho9HfxBvZOlL5lSfJ8B6FTIHtDkx8smuuTRjZATvJGoLk6kvN4XNPub
6olgmT+9T5rcIoX7LbymWLG9/s4El1zDlOoOsUKEyct60IVYUS28akrtDxH1
JzznOi/vEuiC+lOm3IGETagvqdw89MJT+e/C6VQkesI6rBPep5gBZV2r1eCr
5HaHnkrCC7LvSeaRCkBXgPANlgvnqfV+0Dtbb7AdHGCWEycvlYykY/AmS/PN
IPPmrv8Twu/WPJyDi1IQj4Z4wm+ow0vx7dvk5p0rD6thIsgwOB5iAbslDWf2
wE3TexgJQRiLIxGe8027gLBKYqALJss+YvCGF4iOML9A8zhb4LLcefgNUsAA
aqrVKlJH9/qzGbxZZ0d/YAM52FBztBvw7aiI6KMJRI0ccNRD51JVEt4umpdP
gyI6EwUJ08Egdwli56opITJQi/Qi4KVSCR2KZQicT1U7e1vG1/JkABWwyBLG
2AxovytSWMuIPOYIBtaAqFQqsBglSf36ntkP/F4qwCPIgxzSMMEVIe8KqArM
kTiskc+XTQb7/7jyrev4G1uO3Ps=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[9]=",
 CellID->66914695]
}, Open  ]],

Cell[TextData[{
 "From the plot, you can deduce two bracketing values for the root, so it is \
possible to take advantage of ",
 ButtonBox["Brent\[CloseCurlyQuote]s",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationBrentsMethod"],
 " method to quickly and accurately solve the problem."
}], "Text",
 CellTags->"b:0.5.4",
 CellID->1016950286],

Cell["This solves the shooting problem.", "MathCaption",
 CellTags->"b:0.5.4",
 CellID->61110329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"fx1", "[", "xp", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"xp", ",", " ", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellTags->"b:0.5.4",
 CellLabel->"In[43]:=",
 CellID->584116237],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"xp", "\[Rule]", "3.3437150916108536`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.4",
 CellLabel->"Out[43]=",
 CellID->1093844822]
}, Open  ]],

Cell[TextData[{
 "It may seem that symbolic evaluation just creates a bother since you have \
to define the function specifically to prevent it. However, without symbolic \
evaluation, it is hard for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to take advantage of its unique combination of numerical and symbolic \
power. Symbolic evaluation means that the commands can consistently take \
advantage of benefits that come from symbolic analysis, such as algorithm \
determination, automatic computation of derivatives, automatic optimization \
and compilation, and structural analysis. "
}], "Text",
 CellTags->"b:0.5.4",
 CellID->1789905034],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->744458482],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->371088505]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->485608771],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Symbolic Evaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 23.3298950}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The functions FindMinimum, FindMaximum, and FindRoot have the HoldAll \
attribute and so have special semantics for evaluation of their arguments. \
First, the variables are determined from the second argument, then they are \
localized. Next, the function is evaluated symbolically, then processed into \
an efficient form for numerical evaluation. Finally, during the execution of \
the command, the function is repeatedly evaluated with different numerical \
values. Here is a list showing these steps with additional description. This \
will be done by processing the second argument. If the second argument is not \
of the correct form (a list of variables and starting values), it will be \
evaluated to get the correct form. In a manner similar to Block and Table, \
add rules to the variables so that any assignments given to them will not \
affect your Mathematica session beyond the scope of the Find command and so \
that previous assignments do not affect the value (the variable will evaluate \
to itself at this stage)", "synonyms" -> {}, "title" -> "Symbolic Evaluation",
     "type" -> "Tutorial", "uri" -> 
    "tutorial/UnconstrainedOptimizationSymbolicEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:25"->{
  Cell[2234, 67, 96, 2, 70, "Title",
   CellTags->{"t:25", "c:25", "b:0.5.4"},
   CellID->147397427]},
 "c:25"->{
  Cell[2234, 67, 96, 2, 70, "Title",
   CellTags->{"t:25", "c:25", "b:0.5.4"},
   CellID->147397427]},
 "b:0.5.4"->{
  Cell[2234, 67, 96, 2, 70, "Title",
   CellTags->{"t:25", "c:25", "b:0.5.4"},
   CellID->147397427],
  Cell[2333, 71, 1074, 29, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->1259910598],
  Cell[3410, 102, 2564, 60, 70, "DefinitionBox",
   CellTags->"b:0.5.4",
   CellID->1128661166],
  Cell[5977, 164, 161, 6, 70, "Caption",
   CellTags->"b:0.5.4",
   CellID->685163011],
  Cell[6141, 172, 597, 16, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->727410663],
  Cell[6741, 190, 321, 7, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->2114094317],
  Cell[7065, 199, 158, 5, 70, "MathCaption",
   CellTags->"b:0.5.4",
   CellID->1466246204],
  Cell[7248, 208, 1252, 38, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->825101303],
  Cell[8503, 248, 559, 12, 70, "Message",
   CellTags->"b:0.5.4",
   CellID->1809013754],
  Cell[9065, 262, 1091, 18, 70, "Message",
   CellTags->"b:0.5.4",
   CellID->20689252],
  Cell[10159, 282, 807, 15, 70, "Message",
   CellTags->"b:0.5.4",
   CellID->1979391197],
  Cell[10969, 299, 558, 12, 70, "Message",
   CellTags->"b:0.5.4",
   CellID->958672302],
  Cell[11530, 313, 1093, 18, 70, "Message",
   CellTags->"b:0.5.4",
   CellID->1983059920],
  Cell[12626, 333, 806, 15, 70, "Message",
   CellTags->"b:0.5.4",
   CellID->341874000],
  Cell[13435, 350, 1389, 42, 71, "Output",
   CellTags->"b:0.5.4",
   CellID->1357562275],
  Cell[14839, 395, 321, 10, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->1684681963],
  Cell[15163, 407, 322, 11, 70, "MathCaption",
   CellTags->"b:0.5.4",
   CellID->2025350093],
  Cell[15510, 422, 1221, 38, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->295724454],
  Cell[16734, 462, 559, 12, 70, "Message",
   CellTags->"b:0.5.4",
   CellID->1682890197],
  Cell[17296, 476, 1093, 18, 70, "Message",
   CellTags->"b:0.5.4",
   CellID->1975909989],
  Cell[18392, 496, 207, 7, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->432067915],
  Cell[18614, 506, 1048, 32, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->1804079559],
  Cell[19665, 540, 422, 15, 70, "MathCaption",
   CellTags->"b:0.5.4",
   CellID->843536120],
  Cell[20090, 557, 1184, 36, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->1772014993],
  Cell[21277, 595, 351, 10, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->952770755],
  Cell[21631, 607, 148, 6, 70, "MathCaption",
   CellTags->"b:0.5.4",
   CellID->1580007253],
  Cell[21804, 617, 253, 8, 28, "Input",
   CellTags->"b:0.5.4",
   CellID->1546606016],
  Cell[22060, 627, 2214, 41, 121, "Output",
   Evaluatable->False,
   CellTags->"b:0.5.4",
   CellID->66914695],
  Cell[24289, 671, 370, 9, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->1016950286],
  Cell[24662, 682, 97, 2, 70, "MathCaption",
   CellTags->"b:0.5.4",
   CellID->61110329],
  Cell[24784, 688, 247, 8, 70, "Input",
   CellTags->"b:0.5.4",
   CellID->584116237],
  Cell[25034, 698, 252, 8, 36, "Output",
   CellTags->"b:0.5.4",
   CellID->1093844822],
  Cell[25301, 709, 654, 13, 70, "Text",
   CellTags->"b:0.5.4",
   CellID->1789905034]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:25", 29149, 806},
 {"c:25", 29263, 810},
 {"b:0.5.4", 29380, 814}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1609, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 67, 96, 2, 70, "Title",
 CellTags->{"t:25", "c:25", "b:0.5.4"},
 CellID->147397427],
Cell[2333, 71, 1074, 29, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->1259910598],
Cell[3410, 102, 2564, 60, 70, "DefinitionBox",
 CellTags->"b:0.5.4",
 CellID->1128661166],
Cell[5977, 164, 161, 6, 70, "Caption",
 CellTags->"b:0.5.4",
 CellID->685163011],
Cell[6141, 172, 597, 16, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->727410663],
Cell[6741, 190, 321, 7, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->2114094317],
Cell[7065, 199, 158, 5, 70, "MathCaption",
 CellTags->"b:0.5.4",
 CellID->1466246204],
Cell[CellGroupData[{
Cell[7248, 208, 1252, 38, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->825101303],
Cell[8503, 248, 559, 12, 70, "Message",
 CellTags->"b:0.5.4",
 CellID->1809013754],
Cell[9065, 262, 1091, 18, 70, "Message",
 CellTags->"b:0.5.4",
 CellID->20689252],
Cell[10159, 282, 807, 15, 70, "Message",
 CellTags->"b:0.5.4",
 CellID->1979391197],
Cell[10969, 299, 558, 12, 70, "Message",
 CellTags->"b:0.5.4",
 CellID->958672302],
Cell[11530, 313, 1093, 18, 70, "Message",
 CellTags->"b:0.5.4",
 CellID->1983059920],
Cell[12626, 333, 806, 15, 70, "Message",
 CellTags->"b:0.5.4",
 CellID->341874000],
Cell[13435, 350, 1389, 42, 71, "Output",
 CellTags->"b:0.5.4",
 CellID->1357562275]
}, Open  ]],
Cell[14839, 395, 321, 10, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->1684681963],
Cell[15163, 407, 322, 11, 70, "MathCaption",
 CellTags->"b:0.5.4",
 CellID->2025350093],
Cell[CellGroupData[{
Cell[15510, 422, 1221, 38, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->295724454],
Cell[16734, 462, 559, 12, 70, "Message",
 CellTags->"b:0.5.4",
 CellID->1682890197],
Cell[17296, 476, 1093, 18, 70, "Message",
 CellTags->"b:0.5.4",
 CellID->1975909989],
Cell[18392, 496, 207, 7, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->432067915]
}, Open  ]],
Cell[18614, 506, 1048, 32, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->1804079559],
Cell[19665, 540, 422, 15, 70, "MathCaption",
 CellTags->"b:0.5.4",
 CellID->843536120],
Cell[20090, 557, 1184, 36, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->1772014993],
Cell[21277, 595, 351, 10, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->952770755],
Cell[21631, 607, 148, 6, 70, "MathCaption",
 CellTags->"b:0.5.4",
 CellID->1580007253],
Cell[CellGroupData[{
Cell[21804, 617, 253, 8, 28, "Input",
 CellTags->"b:0.5.4",
 CellID->1546606016],
Cell[22060, 627, 2214, 41, 121, "Output",
 Evaluatable->False,
 CellTags->"b:0.5.4",
 CellID->66914695]
}, Open  ]],
Cell[24289, 671, 370, 9, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->1016950286],
Cell[24662, 682, 97, 2, 70, "MathCaption",
 CellTags->"b:0.5.4",
 CellID->61110329],
Cell[CellGroupData[{
Cell[24784, 688, 247, 8, 70, "Input",
 CellTags->"b:0.5.4",
 CellID->584116237],
Cell[25034, 698, 252, 8, 36, "Output",
 CellTags->"b:0.5.4",
 CellID->1093844822]
}, Open  ]],
Cell[25301, 709, 654, 13, 70, "Text",
 CellTags->"b:0.5.4",
 CellID->1789905034],
Cell[CellGroupData[{
Cell[25980, 726, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->744458482],
Cell[26049, 729, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[26195, 734, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[26362, 739, 195, 4, 70, "TutorialMoreAbout",
 CellID->371088505]
}, Open  ]],
Cell[CellGroupData[{
Cell[26594, 748, 72, 1, 70, "RelatedTutorialsSection",
 CellID->485608771],
Cell[26669, 751, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],
Cell[26879, 759, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

