(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57892,       1782]
NotebookOptionsPosition[     45822,       1376]
NotebookOutlinePosition[     52467,       1584]
CellTagsIndexPosition[     52321,       1576]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindMinimum" :> 
          Documentation`HelpLookup["paclet:ref/FindMinimum"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FindMinimum\"\>", 2->"\<\"FindRoot\"\>", 
       3->"\<\"Log\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Test Problems", "Title",
 CellTags->{"t:28", "c:28", "b:0.6.2"},
 CellID->1407764050],

Cell[TextData[{
 "All of the test problems presented in [",
 ButtonBox["MGH81",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationReferences#395837416"],
 "] have been coded into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the ",
 StyleBox["Optimization`UnconstrainedProblems`", "MR"],
 " package. A data structure is used so that the problems can be processed \
for solution and testing with ",
 StyleBox["FindMinimum", "MR"],
 " and ",
 StyleBox["FindRoot", "MR"],
 " in a seamless way. The lists of problems for ",
 StyleBox["FindMinimum", "MR"],
 " and ",
 StyleBox["FindRoot", "MR"],
 " are in ",
 StyleBox["$FindMinimumProblems", "MR"],
 " and ",
 StyleBox["$FindRootProblems", "MR"],
 ", respectively, and a problem can be accessed using ",
 StyleBox["GetFindMinimumProblem", "MR"],
 " and ",
 StyleBox["GetFindRootProblem", "MR"],
 "."
}], "Text",
 CellTags->"b:0.6.2",
 CellID->1463049351],

Cell[BoxData[GridBox[{
   {"$FindMinimumProblems", Cell[TextData[{
     "List of problems that are appropriate for ",
     Cell[BoxData[
      ButtonBox["FindMinimum",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"GetFindMinimumProblem", "[", 
     StyleBox["prob", "TI"], "]"}], Cell[TextData[{
     "Get the problem ",
     Cell[BoxData[
      StyleBox["prob", "TI"]], "InlineFormula"],
     " using the default size and starting values in a ",
     Cell[BoxData["FindMinimumProblem"], "InlineFormula"],
     " data structure "
    }], "TableText"]},
   {
    RowBox[{"GetFindMinimumProblem", "[", 
     RowBox[{
      StyleBox["prob", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Get the problem prob with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " variables such that it is a sum of ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " squares in a ",
     Cell[BoxData["FindMinimumProblem"], "InlineFormula"],
     " data structure"
    }], "TableText"]},
   {
    RowBox[{"GetFindMinimumProblem", "[", 
     RowBox[{
      StyleBox["prob", "TI"], ",", 
      StyleBox["size", "TI"], ",", 
      StyleBox["start", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "Get the problem ",
     Cell[BoxData[
      StyleBox["prob", "TI"]], "InlineFormula"],
     " with given ",
     Cell[BoxData[
      StyleBox["size", "TI"]], "InlineFormula"],
     " and starting value ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     " in a ",
     Cell[BoxData["FindMinimumProblem"], "InlineFormula"],
     " data structure"
    }], "TableText"]},
   {
    RowBox[{"FindMinimumProblem", "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["vars", "TI"], ",", 
      StyleBox["opts", "TI"], ",", 
      StyleBox["prob", "TI"], ",", 
      StyleBox["size", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "A data structure that contains a minimization problem to be solved by ",
     
     Cell[BoxData[
      ButtonBox["FindMinimum",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->255000699],

Cell[TextData[{
 "Accessing ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " problems. "
}], "Caption",
 CellTags->"b:0.6.2",
 CellID->1234448474],

Cell[BoxData[GridBox[{
   {"$FindRootProblems", Cell[TextData[{
     "List of problems that are appropriate for ",
     Cell[BoxData[
      ButtonBox["FindRoot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"GetFindRootProblem", "[", 
     StyleBox["prob", "TI"], "]"}], Cell[TextData[{
     "Get the problem ",
     Cell[BoxData[
      StyleBox["prob", "TI"]], "InlineFormula"],
     " using the default size and starting values in a ",
     Cell[BoxData["FindRootProblem"], "InlineFormula"],
     " data structure "
    }], "TableText"]},
   {
    RowBox[{"GetFindRootProblem", "[", 
     RowBox[{
      StyleBox["prob", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "Get the problem ",
     Cell[BoxData[
      StyleBox["prob", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " variables (and ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " equations) in a ",
     Cell[BoxData["FindRootProblem"], "InlineFormula"],
     " data structure"
    }], "TableText"]},
   {
    RowBox[{"GetFindRootProblem", "[", 
     RowBox[{
      StyleBox["prob", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["start", "TI"]}], "]"}], Cell[TextData[{
     "Get the problem ",
     Cell[BoxData[
      StyleBox["prob", "TI"]], "InlineFormula"],
     " with size ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and starting value ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     " in a ",
     Cell[BoxData["FindRootProblem"], "InlineFormula"],
     " data structure"
    }], "TableText"]},
   {
    RowBox[{"FindRootProblem", "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["vars", "TI"], ",", 
      StyleBox["opts", "TI"], ",", 
      StyleBox["prob", "TI"], ",", 
      StyleBox["size", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "A data structure that contains a minimization problem to be solved by ",
     
     Cell[BoxData[
      ButtonBox["FindRoot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->400685411],

Cell[TextData[{
 "Accessing ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " problems. "
}], "Caption",
 CellTags->"b:0.6.2",
 CellID->1818203239],

Cell[TextData[{
 StyleBox["GetFindMinimumProblem", "MR"],
 " and ",
 StyleBox["GetFindRootProblem", "MR"],
 " are both pass options to be used by other commands. They also accept the \
option ",
 StyleBox["Variables->", "MR"],
 StyleBox["vars", "TI"],
 " which is used to specify what variables to use for the problems."
}], "Text",
 CellTags->"b:0.6.2",
 CellID->1997024710],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["Variables",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Variables"], 
    RowBox[{
     SubscriptBox["X", "#"], "&"}], Cell[TextData[{
     "A function that is applied to the integers ",
     Cell[BoxData[
      FormBox[
       RowBox[{"1", ",", 
        RowBox[{"\[Ellipsis]", " ", "n"}]}], TraditionalForm]], "InlineMath"],
     
     " to generate the variables for a problem with ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " variables or a list of length ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " containing the variables"
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.2.3",
 CellID->204030633],

Cell["Specifying variable names.", "Caption",
 CellTags->"b:0.6.2",
 CellID->473837979],

Cell[TextData[StyleBox["This loads the package.",
 FontSize->11,
 FontWeight->"Plain"]], "MathCaption",
 CellID->18098],

Cell[BoxData[
 RowBox[{"<<", "Optimization`UnconstrainedProblems`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23546],

Cell[TextData[{
 "This gets the Beale problem in a ",
 StyleBox["FindMinimumProblem", "MR"],
 " data structure."
}], "MathCaption",
 CellTags->"b:0.6.2",
 CellID->925549977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"beale", " ", "=", " ", 
  RowBox[{"GetFindMinimumProblem", "[", "Beale", "]"}]}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[45]:=",
 CellID->1494408218],

Cell[BoxData[
 RowBox[{"FindMinimumProblem", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["3", "2"], "-", 
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SubscriptBox["X", "2"]}], ")"}]}]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["9", "4"], "-", 
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SubsuperscriptBox["X", "2", "2"]}], ")"}]}]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["21", "8"], "-", 
       RowBox[{
        SubscriptBox["X", "1"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SubsuperscriptBox["X", "2", "3"]}], ")"}]}]}], ")"}], "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["X", "1"], ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["X", "2"], ",", "1.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "}"}], ",", "Beale", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Output",
 ImageSize->{491, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[45]=",
 CellID->1330215276]
}, Open  ]],

Cell[TextData[{
 "This gets the Powell singular function problem in a ",
 StyleBox["FindRootProblem", "MR"],
 " data structure."
}], "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1242728585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ps", " ", "=", " ", 
  RowBox[{"GetFindRootProblem", "[", 
   RowBox[{"PowellSingular", ",", " ", 
    RowBox[{"Variables", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[46]:=",
 CellID->113377373],

Cell[BoxData[
 RowBox[{"FindRootProblem", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"10", " ", "y"}]}], ",", 
     RowBox[{
      SqrtBox["5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "w"}], "+", "z"}], ")"}]}], ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"y", "-", 
        RowBox[{"2", " ", "z"}]}], ")"}], "2"], ",", 
     RowBox[{
      SqrtBox["10"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "w"}], "+", "x"}], ")"}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "3.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "1.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "}"}], ",", "PowellSingular", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "]"}]], "Output",
 ImageSize->{436, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[46]=",
 CellID->1623378462]
}, Open  ]],

Cell[TextData[{
 "Once you have a ",
 StyleBox["FindMinimumProblem", "MR"],
 " or ",
 StyleBox["FindRootProblem", "MR"],
 " object, in addition to simply solving the problem, there are various tests \
that you can run. "
}], "Text",
 CellTags->"b:0.6.2",
 CellID->1868101901],

Cell[BoxData[GridBox[{
   {
    RowBox[{"ProblemSolve", "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "Solve the problem in ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     ", giving the same output as ",
     Cell[BoxData[
      ButtonBox["FindMinimum",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["FindRoot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"ProblemStatistics", "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "Solve the problem, giving a list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["sol", "TI"], ",", 
        StyleBox["stats", "TI"]}], "}"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["sol", "TI"]], "InlineFormula"],
     " is the output of ",
     Cell[BoxData[
      RowBox[{"ProblemSolve", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["evals", "TI"]], "InlineFormula"],
     " is a list of rules indicating the number steps and evaluations used"
    }], "TableText"]},
   {
    RowBox[{"ProblemTime", "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "Solve the problem giving a list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["sol", "TI"], ",", 
        RowBox[{"Time", "->", 
         StyleBox["time", "TI"]}]}], "}"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["sol", "TI"]], "InlineFormula"],
     " is the output of ",
     Cell[BoxData[
      RowBox[{"ProblemSolve", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["time", "TI"]], "InlineFormula"],
     " is time taken to solve the problem. If ",
     Cell[BoxData[
      StyleBox["time", "TI"]], "InlineFormula"],
     " is less than a second, the problem will be solved multiple times to \
get an average timing"
    }], "TableText"]},
   {
    RowBox[{"ProblemTest", "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "Solve the problem, giving a list of rules including the step and \
evaluation statistics and time from ",
     Cell[BoxData[
      RowBox[{"ProblemStatistics", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{"ProblemTime", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " along with rules indicating the accuracy and precision of the solution \
as compared with a reference solution"
    }], "TableText"]},
   {
    RowBox[{"FindMinimumPlot", "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "Plot the steps and evaluation points for solving a ",
     Cell[BoxData["FindMinimumProblem"], "InlineFormula"],
     " ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"FindRootPlot", "[", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "Plot the steps and evaluation points for solving a ",
     Cell[BoxData["FindRootProblem"], "InlineFormula"],
     " ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->651974677],

Cell[TextData[{
 "Operations with ",
 Cell[BoxData["FindMinimumProblem"], "InlineFormula"],
 " and ",
 Cell[BoxData["FindRootProblem"], "InlineFormula"],
 " data objects."
}], "Caption",
 CellTags->"b:0.6.2",
 CellID->179495525],

Cell[TextData[{
 "Any of the previous commands shown can take options that are passed on \
directly to ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " and override any options for these functions which may have been specified \
when the problem was set up."
}], "Text",
 CellTags->"b:0.6.2",
 CellID->1714248287],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to solve the Powell singular function problem and gives the root."
}], "MathCaption",
 CellTags->"b:0.6.2",
 CellID->730351457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProblemSolve", "[", "ps", "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[47]:=",
 CellID->411547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "8.869738805861697`*^-9"}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"-", "8.869738805861696`*^-10"}]}], ",", 
   RowBox[{"z", "\[Rule]", "1.419158208937872`*^-9"}], ",", 
   RowBox[{"w", "\[Rule]", "1.419158208937872`*^-9"}]}], "}"}]], "Output",
 ImageSize->{496, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[47]=",
 CellID->342075699]
}, Open  ]],

Cell["\<\
This does the same as above, but includes statistics on steps and evaluations \
required.\
\>", "MathCaption",
 CellTags->"b:0.6.2",
 CellID->2109037152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProblemStatistics", "[", "ps", "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[48]:=",
 CellID->222336282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "8.869738805861697`*^-9"}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"-", "8.869738805861696`*^-10"}]}], ",", 
   RowBox[{"z", "\[Rule]", "1.419158208937872`*^-9"}], ",", 
   RowBox[{"w", "\[Rule]", "1.419158208937872`*^-9"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"Steps\"\>", "\[Rule]", "28"}], ",", 
     RowBox[{"\<\"Function\"\>", "\[Rule]", "29"}], ",", 
     RowBox[{"\<\"Jacobian\"\>", "\[Rule]", "28"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{411, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[48]=",
 CellID->452550074]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " to solve the Beale problem and averages the timing over several trials to \
get the average time it takes to solve the problem."
}], "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1628340784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProblemTime", "[", "beale", "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[49]:=",
 CellID->2139442967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2.637920267074046`*^-19", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox["X", "1"], "\[Rule]", "2.999999999831437`"}], ",", 
       RowBox[{
        SubscriptBox["X", "2"], "\[Rule]", "0.5000000000642252`"}]}], "}"}]}],
     "}"}], ",", 
   RowBox[{"\<\"Time\"\>", "\[Rule]", 
    RowBox[{"0.002014283203124967`", " ", "Second"}]}]}], "}"}]], "Output",
 ImageSize->{421, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[49]=",
 CellID->1769499691]
}, Open  ]],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " to solve the Beale problem, compares the result with a reference solution, \
and gives a list of rules indicating the results of the test."
}], "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1584054818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProblemTest", "[", "beale", "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[50]:=",
 CellID->854554267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"FunctionAccuracy\"\>", "\[Rule]", "18.578738335436007`"}], 
   ",", 
   RowBox[{"\<\"FunctionPrecision\"\>", "\[Rule]", "Indeterminate"}], ",", 
   RowBox[{"\<\"SpatialAccuracy\"\>", "\[Rule]", "9.743802309918907`"}], ",", 
   
   RowBox[{"\<\"SpatialPrecision\"\>", "\[Rule]", "9.853246384896568`"}], ",",
    
   RowBox[{"\<\"Time\"\>", "\[Rule]", 
    RowBox[{"0.002029626953125002`", " ", "Second"}]}], ",", 
   RowBox[{"\<\"Steps\"\>", "\[Rule]", "6"}], ",", 
   RowBox[{"\<\"Residual\"\>", "\[Rule]", "8"}], ",", 
   RowBox[{"\<\"Jacobian\"\>", "\[Rule]", "7"}], ",", 
   RowBox[{"Messages", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 ImageSize->{524, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[50]=",
 CellID->1627762981]
}, Open  ]],

Cell[TextData[{
 StyleBox["ProblemTest", "MR"],
 " gives a way to easily compare two different methods for the same problem."
}], "Text",
 CellTags->"b:0.6.2",
 CellID->278066317],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " to solve the Beale problem using ",
 ButtonBox["Newton\[CloseCurlyQuote]s",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationNewtonsMethodMinimum"],
 " method, compares the result with a reference solution, and gives a list of \
rules indicating the results of the test."
}], "MathCaption",
 CellTags->"b:0.6.2",
 CellID->536173947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ProblemTest", "[", 
  RowBox[{"beale", ",", " ", 
   RowBox[{"Method", "->", "\"\<Newton\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[51]:=",
 CellID->634144417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"FunctionAccuracy\"\>", "\[Rule]", "25.558118756424783`"}], 
   ",", 
   RowBox[{"\<\"FunctionPrecision\"\>", "\[Rule]", "Indeterminate"}], ",", 
   RowBox[{"\<\"SpatialAccuracy\"\>", "\[Rule]", "12.384026228158403`"}], ",",
    
   RowBox[{"\<\"SpatialPrecision\"\>", "\[Rule]", "12.644427868369332`"}], 
   ",", 
   RowBox[{"\<\"Time\"\>", "\[Rule]", 
    RowBox[{"0.002975263671874978`", " ", "Second"}]}], ",", 
   RowBox[{"\<\"Steps\"\>", "\[Rule]", "8"}], ",", 
   RowBox[{"\<\"Function\"\>", "\[Rule]", "9"}], ",", 
   RowBox[{"\<\"Gradient\"\>", "\[Rule]", "9"}], ",", 
   RowBox[{"\<\"Hessian\"\>", "\[Rule]", "9"}], ",", 
   RowBox[{"Messages", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 ImageSize->{540, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[51]=",
 CellID->1018242534]
}, Open  ]],

Cell["\<\
Most of the rules returned by these functions are self-explanatory, but a few \
require some description. Here is a table clarifying those rules.\
\>", "Text",
 CellTags->"b:0.6.2",
 CellID->2094908242],

Cell[BoxData[GridBox[{
   {"\"\<FunctionAccuracy\>\"", Cell[TextData[{
     "The accuracy of the function value ",
     Cell[BoxData[
      RowBox[{"-", 
       RowBox[{
        ButtonBox["Log",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Log"], "[", 
        RowBox[{"10", ",", 
         RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox[
           RowBox[{"error", " ", "in", " ", "f"}], "TI"], 
          "\[RightDoubleBracketingBar]"}]}], "]"}]}]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<FunctionPrecision\>\"", Cell[TextData[{
     "The precision of the function value ",
     Cell[BoxData[
      RowBox[{"-", 
       RowBox[{
        ButtonBox["Log",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Log"], "[", 
        RowBox[{"10", ",", " ", 
         RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox[
           RowBox[{"relative", " ", "error", " ", "in", " ", "f"}], "TI"], 
          "\[RightDoubleBracketingBar]"}]}], "]"}]}]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<SpatialAccuracy\>\"", Cell[TextData[{
     "The accuracy in the position of the minimizer or root ",
     Cell[BoxData[
      RowBox[{"-", 
       RowBox[{
        ButtonBox["Log",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Log"], "[", 
        RowBox[{"10", ",", 
         RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox[
           RowBox[{"error", " ", "in", " ", "x"}], "TI"], 
          "\[RightDoubleBracketingBar]"}]}], "]"}]}]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<SpatialPrecision\>\"", Cell[TextData[{
     "The precision in the position of the minimizer or root ",
     Cell[BoxData[
      RowBox[{"-", 
       RowBox[{
        ButtonBox["Log",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Log"], "[", 
        RowBox[{"10", ",", 
         RowBox[{"\[LeftDoubleBracketingBar]", 
          StyleBox[
           RowBox[{"relative", " ", "error", " ", "in", " ", "x"}], "TI"], 
          "\[RightDoubleBracketingBar]"}]}], "]"}]}]], "InlineFormula"]
    }], "TableText"]},
   {"\"\<Messages\>\"", Cell[
    "A list of messages issued during the solution of the problem", 
     "TableText"]}
  }]], "DefinitionBox",
 CellID->396741122],

Cell[TextData[{
 "A very useful comparison is to see how a list of methods affect on a \
particular problem. This is easy to do by setting up a ",
 Cell[BoxData["FindMinimumProblem"], "InlineFormula"],
 " object and mapping a problem test over a list of methods."
}], "Caption",
 CellTags->"b:0.6.2",
 CellID->1107175646],

Cell["\<\
This gets the Chebyquad problem. The output has been abbreviated to save \
space.\
\>", "MathCaption",
 CellTags->"b:0.6.2",
 CellID->355281067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"cq", " ", "=", " ", 
    RowBox[{"GetFindMinimumProblem", "[", "Chebyquad", "]"}]}], ",", " ", 
   "5"}], "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[52]:=",
 CellID->1204354409],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{515, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[52]//Short=",
 CellID->77277490]
}, Open  ]],

Cell["Here is a list of possible methods.", "MathCaption",
 CellTags->"b:0.6.2",
 CellID->215457436],

Cell[BoxData[
 RowBox[{
  RowBox[{"methods", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"Automatic", ",", " ", "\"\<QuasiNewton\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<QuasiNewton\>\"", ",", " ", 
       RowBox[{"\"\<StepMemory\>\"", "\[Rule]", "10"}]}], "}"}], ",", " ", 
     "\"\<Newton\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Newton\>\"", ",", " ", 
       RowBox[{"\"\<StepControl\>\"", "->", "\"\<TrustRegion\>\""}]}], "}"}], 
     ",", " ", "\"\<ConjugateGradient\>\""}], "}"}]}], ";"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[53]:=",
 CellID->535698010],

Cell["\<\
This makes a table comparing the different methods in terms of accuracy and \
computation time.\
\>", "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1225005846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", "#", "}"}], ",", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\"\<Time\>\"", ",", " ", "\"\<FunctionAccuracy\>\"", ",", " ", 
          "\"\<SpatialAccuracy\>\""}], "}"}], " ", "/.", " ", 
        RowBox[{"ProblemTest", "[", 
         RowBox[{"cq", ",", " ", 
          RowBox[{"Method", "\[Rule]", "#"}]}], "]"}]}]}], "]"}], "&"}], ",", 
    " ", "methods"}], "]"}], "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[54]:=",
 CellID->747529933],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"Automatic", "0.028889656250000062`", "20.06629848918288`", 
     "9.946661475818496`"},
    {"\<\"QuasiNewton\"\>", "0.03172159375000039`", "17.178463074429114`", 
     "8.377701127963027`"},
    {GridBox[{
       {"\<\"QuasiNewton\"\>"},
       {
        RowBox[{"\<\"StepMemory\"\>", "\[Rule]", "10"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "0.03234884374999991`", 
     "16.411927734518187`", "7.4730357628911035`"},
    {"\<\"Newton\"\>", "0.07690762499999959`", "20.02495243905534`", 
     "9.34313812375534`"},
    {GridBox[{
       {"\<\"Newton\"\>"},
       {
        RowBox[{"\<\"StepControl\"\>", "\[Rule]", "\<\"TrustRegion\"\>"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "0.07611275000000006`", 
     "21.828066398328158`", "10.661383907869425`"},
    {"\<\"ConjugateGradient\"\>", "0.038890375000000255`", 
     "15.793063451102228`", "7.722192373005087`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[2.1]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{
    Automatic, 0.0288896562500001, 20.0662984891829, 9.9466614758185}, {
    "QuasiNewton", 0.0317215937500004, 17.1784630744291, 8.37770112796303}, {{
     "QuasiNewton", "StepMemory" -> 10}, 0.0323488437499999, 16.4119277345182,
      7.4730357628911}, {
    "Newton", 0.0769076249999996, 20.0249524390553, 9.34313812375534}, {{
     "Newton", "StepControl" -> "TrustRegion"}, 0.0761127500000001, 
     21.8280663983282, 10.6613839078694}, {
    "ConjugateGradient", 0.0388903750000003, 15.7930634511022, 
     7.72219237300509}}]]], "Output",
 ImageSize->{410, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[54]//TableForm=",
 CellID->1536852576]
}, Open  ]],

Cell[TextData[{
 "It is possible to generate tables of how a particular method does on a \
variety of problems by mapping over the names in ",
 StyleBox["$FindMinimumProblems", "MR"],
 " or ",
 StyleBox["$FindRootProblems", "MR"],
 "."
}], "Text",
 CellTags->"b:0.6.2",
 CellID->2056493166],

Cell[TextData[{
 "This sets up a function that tests a problem with ",
 StyleBox["FindMinimum", "MR"],
 " using its default settings except with a large setting for ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 " so that the default (Levenberg\[Dash]Marquardt) method can run to \
convergence."
}], "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1878826144],

Cell[BoxData[
 RowBox[{
  RowBox[{"TestDefault", "[", "problem_", "]"}], " ", ":=", " ", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Name\>\"", "\[Rule]", "problem"}], "}"}], ",", " ", 
    RowBox[{"ProblemTest", "[", 
     RowBox[{"GetFindMinimumProblem", "[", 
      RowBox[{"problem", ",", " ", 
       RowBox[{"MaxIterations", "\[Rule]", "1000"}]}], "]"}], "]"}]}], 
   "]"}]}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[55]:=",
 CellID->831456720],

Cell[TextData[{
 "This makes a table showing some of the results from testing all the \
problems in ",
 StyleBox["$FindMinimumProblems", "MR"],
 ". It may take several minutes to run."
}], "MathCaption",
 CellTags->"b:0.6.2",
 CellID->617002011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<Name\>\"", ",", " ", "\"\<Time\>\"", ",", " ", 
         "\"\<Residual\>\"", ",", " ", "\"\<Jacobian\>\"", ",", " ", 
         "\"\<FunctionAccuracy\>\"", ",", " ", "\"\<SpatialAccuracy\>\""}], 
        "}"}], " ", "/.", " ", 
       RowBox[{"TestDefault", "[", "#", "]"}]}], ")"}], "&"}], ",", " ", 
    "$FindMinimumProblems"}], "]"}], "]"}]], "Input",
 CellTags->"b:0.6.2",
 CellLabel->"In[56]:=",
 CellID->1901751161],

Cell[BoxData[
 TagBox[GridBox[{
    {"Rosenbrock", "0.0028403359374999937`", "21", "16", 
     "15.954589770191003`", "15.954589770191003`"},
    {"FreudensteinRoth", "0.004425589843750133`", "35", "17", 
     "14.148409796207115`", "8.479699007773906`"},
    {"PowellBadlyScaled", "0.0027684101562500674`", "18", "17", 
     "29.909167294873757`", "12.430323501423688`"},
    {"BrownBadlyScaled", "0.0018218808593750135`", "10", "10", 
     "20.53453550019821`", "16.267268807192238`"},
    {"Beale", "0.001998667968750034`", "8", "7", "18.578738335436007`", 
     "9.743802309918907`"},
    {"JennrichSampson", "0.008280539062500036`", "34", "20", 
     "13.370258545823472`", "8.872611017721132`"},
    {"HelicalValley", "0.0021818183593749763`", "11", "9", 
     "32.005531106687805`", "17.20458568498579`"},
    {"Bard", "0.0067373203125000725`", "7", "7", "16.915671704160633`", 
     "8.007510114845546`"},
    {"Gauss", "0.007865460937499957`", "3", "3", "21.101941760842394`", 
     "11.07328661488218`"},
    {"Meyer", "0.02646767187500032`", "126", "116", "11.508923306938529`", 
     "9.958138801086468`"},
    {"Gulf", "0.01202292968749985`", "89", "17", "31.10897814925529`", 
     "13.542983113549669`"},
    {"Box3D", "0.007150449218749966`", "6", "6", "18.944674728147852`", 
     "8.685792037456054`"},
    {"PowellSingular", "0.0034850957031249963`", "28", "28", 
     "30.30441365572415`", "7.738160553134715`"},
    {"Wood", "0.00791267968749998`", "69", "64", "23.53657895279385`", 
     "13.053639692807808`"},
    {"KowalikOsborne", "0.010428984375000061`", "36", "35", 
     "18.663859731166834`", "8.335068508177288`"},
    {"BrownDennis", "0.08992787500000077`", "412", "375", 
     "9.138109839567303`", "6.114093812915031`"},
    {"Osborne1", "0.022469781249999876`", "20", "17", "17.47970085036312`", 
     "9.359701514679955`"},
    {"BiggsExp6", "0.023161390625000333`", "50", "36", "30.226553302012185`", 
     "14.49245012716006`"},
    {"Osborne2", "0.12158312499999724`", "20", "17", "17.158709752846928`", 
     "7.903039844088677`"},
    {"Watson", "0.07365468750000126`", "11", "9", "18.817793718364445`", 
     "6.68864621371462`"},
    {"ExtendedRosenbrock", "0.09541131249999957`", "21", "16", 
     "29.909179540382006`", "15.954589770191001`"},
    {"ExtendedPowell", "0.12323562499999952`", "27", "27", 
     "29.909179537538225`", "7.210745929153543`"},
    {"PenaltyFunctionI", "0.024908437500000602`", "117", "94", 
     "18.13558595399979`", "6.966133548183285`"},
    {"PenaltyFunctionII", "0.02719259375000016`", "109", "72", 
     "15.954589770191003`", "7.6208893395420825`"},
    {"VariablyDimensionedFunction", "0.13075637500000425`", "17", "17", 
     "15.954589770191003`", "15.954589770191003`"},
    {"TrigonometricFunction", "0.007740070312500014`", "7", "7", 
     "28.02381832035049`", "14.654614137076134`"},
    {"BrownAlmostLinear", "0.005573324218750009`", "14", "13", 
     "29.148757056958793`", "0.6680588640088803`"},
    {"DiscreteBoundaryValue", "0.005470867187500006`", "4", "4", 
     "30.51945986195666`", "14.295927070420062`"},
    {"DiscreteIntegralEquation", "0.010587781249999928`", "4", "4", 
     "29.39852982287158`", "14.882497329994886`"},
    {"BroydenTridiagonal", "0.00479374218749995`", "5", "5", 
     "17.947489556802598`", "9.446850542926747`"},
    {"BroydenBanded", "0.008255976562499878`", "8", "7", 
     "28.056699546745143`", "15.50304477669503`"},
    {"LinearFullRank", "0.0037073359375000003`", "2", "2", 
     "14.750469787535076`", "14.634846525556709`"},
    {"LinearRank1", "0.009382843750000092`", "55", "2", 
     "15.05149978319906`", "\<\"ERROR\"\>"},
    {"LinearRank1Z", "0.007422339843749959`", "37", "2", 
     "15.05149978319906`", "\<\"ERROR\"\>"},
    {"Chebyquad", "0.02801479687499997`", "11", "9", "20.06629848918288`", 
     "9.946661475818496`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.28], {
        Offset[0.7]}, 
       Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{450, 523},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.6.2",
 CellLabel->"Out[56]//TableForm=",
 CellID->1566144516]
}, Open  ]],

Cell[TextData[{
 "The two cases where the spatial accuracy is shown as ",
 StyleBox["ERROR", "MR"],
 " are for linear problems, which do not have an isolated minimizer. The one \
case, which has a spatial accuracy that is quite poor, has multiple \
minimizers, and the method goes to a different minimum than the reference \
one.",
 " ",
 "Many of these functions have multiple local minima, so be aware that the \
error may be reported as large only because a method went to a different \
minimum than the reference one."
}], "Text",
 CellTags->"b:0.6.2",
 CellID->679975862],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->211233812],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->371088505]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->388000978],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Test Problems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 25.4862002}", "context" -> 
    "Optimization`UnconstrainedProblems`", "keywords" -> {}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "All of the test problems presented in [MGH81] have been coded into \
Mathematica in the Optimization`UnconstrainedProblems` package. A data \
structure is used so that the problems can be processed for solution and \
testing with FindMinimum and FindRoot in a seamless way. The lists of \
problems for FindMinimum and FindRoot are in $FindMinimumProblems and \
$FindRootProblems, respectively, and a problem can be accessed using \
GetFindMinimumProblem and GetFindRootProblem. Accessing FindMinimum problems. \
Accessing FindRoot problems. ", "synonyms" -> {}, "title" -> "Test Problems", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/UnconstrainedOptimizationTestProblems"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:28"->{
  Cell[2957, 84, 91, 2, 70, "Title",
   CellTags->{"t:28", "c:28", "b:0.6.2"},
   CellID->1407764050]},
 "c:28"->{
  Cell[2957, 84, 91, 2, 70, "Title",
   CellTags->{"t:28", "c:28", "b:0.6.2"},
   CellID->1407764050]},
 "b:0.6.2"->{
  Cell[2957, 84, 91, 2, 70, "Title",
   CellTags->{"t:28", "c:28", "b:0.6.2"},
   CellID->1407764050],
  Cell[3051, 88, 943, 31, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->1463049351],
  Cell[6441, 197, 228, 9, 70, "Caption",
   CellTags->"b:0.6.2",
   CellID->1234448474],
  Cell[8998, 282, 222, 9, 70, "Caption",
   CellTags->"b:0.6.2",
   CellID->1818203239],
  Cell[9223, 293, 375, 11, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->1997024710],
  Cell[10616, 337, 87, 2, 70, "Caption",
   CellTags->"b:0.6.2",
   CellID->473837979],
  Cell[10949, 351, 173, 6, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->925549977],
  Cell[11147, 361, 182, 5, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->1494408218],
  Cell[11332, 368, 1370, 47, 74, "Output",
   CellTags->"b:0.6.2",
   CellID->1330215276],
  Cell[12717, 418, 190, 6, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->1242728585],
  Cell[12932, 428, 329, 10, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->113377373],
  Cell[13264, 440, 1176, 41, 65, "Output",
   CellTags->"b:0.6.2",
   CellID->1623378462],
  Cell[14455, 484, 275, 9, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->1868101901],
  Cell[18402, 608, 228, 8, 70, "Caption",
   CellTags->"b:0.6.2",
   CellID->179495525],
  Cell[18633, 618, 523, 16, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->1714248287],
  Cell[19159, 636, 280, 9, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->730351457],
  Cell[19464, 649, 129, 4, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->411547],
  Cell[19596, 655, 472, 13, 39, "Output",
   CellTags->"b:0.6.2",
   CellID->342075699],
  Cell[20083, 671, 163, 5, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->2109037152],
  Cell[20271, 680, 137, 4, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->222336282],
  Cell[20411, 686, 685, 19, 58, "Output",
   CellTags->"b:0.6.2",
   CellID->452550074],
  Cell[21111, 708, 349, 10, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->1628340784],
  Cell[21485, 722, 135, 4, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->2139442967],
  Cell[21623, 728, 607, 19, 39, "Output",
   CellTags->"b:0.6.2",
   CellID->1769499691],
  Cell[22245, 750, 360, 10, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->1584054818],
  Cell[22630, 764, 134, 4, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->854554267],
  Cell[22767, 770, 866, 22, 71, "Output",
   CellTags->"b:0.6.2",
   CellID->1627762981],
  Cell[23648, 795, 179, 5, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->278066317],
  Cell[23830, 802, 523, 15, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->536173947],
  Cell[24378, 821, 205, 6, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->634144417],
  Cell[24586, 829, 922, 23, 71, "Output",
   CellTags->"b:0.6.2",
   CellID->1018242534],
  Cell[25523, 855, 212, 5, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->2094908242],
  Cell[27988, 925, 321, 7, 70, "Caption",
   CellTags->"b:0.6.2",
   CellID->1107175646],
  Cell[28312, 934, 154, 5, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->355281067],
  Cell[28491, 943, 250, 8, 28, "Input",
   CellTags->"b:0.6.2",
   CellID->1204354409],
  Cell[28744, 953, 4699, 82, 187, "Output",
   Evaluatable->False,
   CellTags->"b:0.6.2",
   CellID->77277490],
  Cell[33458, 1038, 100, 2, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->215457436],
  Cell[33561, 1042, 602, 15, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->535698010],
  Cell[34166, 1059, 169, 5, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->1225005846],
  Cell[34360, 1068, 629, 19, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->747529933],
  Cell[34992, 1089, 2717, 68, 144, "Output",
   CellTags->"b:0.6.2",
   CellID->1536852576],
  Cell[37724, 1160, 290, 9, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->2056493166],
  Cell[38017, 1171, 443, 12, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->1878826144],
  Cell[38463, 1185, 487, 14, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->831456720],
  Cell[38953, 1201, 245, 7, 70, "MathCaption",
   CellTags->"b:0.6.2",
   CellID->617002011],
  Cell[39223, 1212, 596, 17, 70, "Input",
   CellTags->"b:0.6.2",
   CellID->1901751161],
  Cell[39822, 1231, 4458, 90, 558, "Output",
   CellTags->"b:0.6.2",
   CellID->1566144516],
  Cell[44295, 1324, 576, 13, 70, "Text",
   CellTags->"b:0.6.2",
   CellID->679975862]},
 "b:0.2.3"->{
  Cell[9601, 306, 1012, 29, 70, "DefinitionBox3Col",
   CellTags->"b:0.2.3",
   CellID->204030633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:28", 47591, 1415},
 {"c:28", 47706, 1419},
 {"b:0.6.2", 47824, 1423},
 {"b:0.2.3", 52197, 1569}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2332, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2957, 84, 91, 2, 70, "Title",
 CellTags->{"t:28", "c:28", "b:0.6.2"},
 CellID->1407764050],
Cell[3051, 88, 943, 31, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->1463049351],
Cell[3997, 121, 2441, 74, 70, "DefinitionBox",
 CellID->255000699],
Cell[6441, 197, 228, 9, 70, "Caption",
 CellTags->"b:0.6.2",
 CellID->1234448474],
Cell[6672, 208, 2323, 72, 70, "DefinitionBox",
 CellID->400685411],
Cell[8998, 282, 222, 9, 70, "Caption",
 CellTags->"b:0.6.2",
 CellID->1818203239],
Cell[9223, 293, 375, 11, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->1997024710],
Cell[9601, 306, 1012, 29, 70, "DefinitionBox3Col",
 CellTags->"b:0.2.3",
 CellID->204030633],
Cell[10616, 337, 87, 2, 70, "Caption",
 CellTags->"b:0.6.2",
 CellID->473837979],
Cell[10706, 341, 119, 3, 70, "MathCaption",
 CellID->18098],
Cell[10828, 346, 118, 3, 70, "Input",
 CellID->23546],
Cell[10949, 351, 173, 6, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->925549977],
Cell[CellGroupData[{
Cell[11147, 361, 182, 5, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->1494408218],
Cell[11332, 368, 1370, 47, 74, "Output",
 CellTags->"b:0.6.2",
 CellID->1330215276]
}, Open  ]],
Cell[12717, 418, 190, 6, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1242728585],
Cell[CellGroupData[{
Cell[12932, 428, 329, 10, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->113377373],
Cell[13264, 440, 1176, 41, 65, "Output",
 CellTags->"b:0.6.2",
 CellID->1623378462]
}, Open  ]],
Cell[14455, 484, 275, 9, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->1868101901],
Cell[14733, 495, 3666, 111, 70, "DefinitionBox",
 CellID->651974677],
Cell[18402, 608, 228, 8, 70, "Caption",
 CellTags->"b:0.6.2",
 CellID->179495525],
Cell[18633, 618, 523, 16, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->1714248287],
Cell[19159, 636, 280, 9, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->730351457],
Cell[CellGroupData[{
Cell[19464, 649, 129, 4, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->411547],
Cell[19596, 655, 472, 13, 39, "Output",
 CellTags->"b:0.6.2",
 CellID->342075699]
}, Open  ]],
Cell[20083, 671, 163, 5, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->2109037152],
Cell[CellGroupData[{
Cell[20271, 680, 137, 4, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->222336282],
Cell[20411, 686, 685, 19, 58, "Output",
 CellTags->"b:0.6.2",
 CellID->452550074]
}, Open  ]],
Cell[21111, 708, 349, 10, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1628340784],
Cell[CellGroupData[{
Cell[21485, 722, 135, 4, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->2139442967],
Cell[21623, 728, 607, 19, 39, "Output",
 CellTags->"b:0.6.2",
 CellID->1769499691]
}, Open  ]],
Cell[22245, 750, 360, 10, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1584054818],
Cell[CellGroupData[{
Cell[22630, 764, 134, 4, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->854554267],
Cell[22767, 770, 866, 22, 71, "Output",
 CellTags->"b:0.6.2",
 CellID->1627762981]
}, Open  ]],
Cell[23648, 795, 179, 5, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->278066317],
Cell[23830, 802, 523, 15, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->536173947],
Cell[CellGroupData[{
Cell[24378, 821, 205, 6, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->634144417],
Cell[24586, 829, 922, 23, 71, "Output",
 CellTags->"b:0.6.2",
 CellID->1018242534]
}, Open  ]],
Cell[25523, 855, 212, 5, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->2094908242],
Cell[25738, 862, 2247, 61, 70, "DefinitionBox",
 CellID->396741122],
Cell[27988, 925, 321, 7, 70, "Caption",
 CellTags->"b:0.6.2",
 CellID->1107175646],
Cell[28312, 934, 154, 5, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->355281067],
Cell[CellGroupData[{
Cell[28491, 943, 250, 8, 28, "Input",
 CellTags->"b:0.6.2",
 CellID->1204354409],
Cell[28744, 953, 4699, 82, 187, "Output",
 Evaluatable->False,
 CellTags->"b:0.6.2",
 CellID->77277490]
}, Open  ]],
Cell[33458, 1038, 100, 2, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->215457436],
Cell[33561, 1042, 602, 15, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->535698010],
Cell[34166, 1059, 169, 5, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1225005846],
Cell[CellGroupData[{
Cell[34360, 1068, 629, 19, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->747529933],
Cell[34992, 1089, 2717, 68, 144, "Output",
 CellTags->"b:0.6.2",
 CellID->1536852576]
}, Open  ]],
Cell[37724, 1160, 290, 9, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->2056493166],
Cell[38017, 1171, 443, 12, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->1878826144],
Cell[38463, 1185, 487, 14, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->831456720],
Cell[38953, 1201, 245, 7, 70, "MathCaption",
 CellTags->"b:0.6.2",
 CellID->617002011],
Cell[CellGroupData[{
Cell[39223, 1212, 596, 17, 70, "Input",
 CellTags->"b:0.6.2",
 CellID->1901751161],
Cell[39822, 1231, 4458, 90, 558, "Output",
 CellTags->"b:0.6.2",
 CellID->1566144516]
}, Open  ]],
Cell[44295, 1324, 576, 13, 70, "Text",
 CellTags->"b:0.6.2",
 CellID->679975862],
Cell[CellGroupData[{
Cell[44896, 1341, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->211233812],
Cell[44965, 1344, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[45111, 1349, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[45278, 1354, 195, 4, 70, "TutorialMoreAbout",
 CellID->371088505]
}, Open  ]],
Cell[CellGroupData[{
Cell[45510, 1363, 72, 1, 70, "RelatedTutorialsSection",
 CellID->388000978],
Cell[45585, 1366, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]],
Cell[45795, 1374, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

