(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36533,       1232]
NotebookOptionsPosition[     27017,        915]
NotebookOutlinePosition[     32677,       1092]
CellTagsIndexPosition[     32513,       1083]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unconstrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UnconstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Unconstrained Optimization\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Optimization\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Variables and Starting Conditions", "Title",
 CellTags->{"t:22", "c:22", "b:0.5.2"},
 CellID->1302289373],

Cell[TextData[{
 "All of the functions ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " take variable specifications of the same form. The function ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " uses the same for its parameter specifications."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->424161787],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      StyleBox["FindMinimum", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       RowBox[{"f", ",", " ", "vars"}], "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "Find a local",
      " ",
      "minimum of ",
      StyleBox["f",
       FontSlant->"Italic"],
      " with respect to the variables given in ",
      StyleBox["vars",
       FontSlant->"Italic"],
      "."
     }], "Text"]},
    {
     RowBox[{
      StyleBox["FindMinimum", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       RowBox[{"f", ",", " ", "vars"}], "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "Find a local",
      " ",
      "maximum of ",
      StyleBox["f",
       FontSlant->"Italic"],
      " with respect to the variables given in ",
      StyleBox["vars",
       FontSlant->"Italic"],
      "."
     }], "Text"]},
    {
     RowBox[{
      StyleBox["FindRoot", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       RowBox[{"f", ",", " ", "vars"}], "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "Find a root",
      " ",
      StyleBox["f",
       FontSlant->"Italic"],
      " = 0 with respect to the variables given in ",
      StyleBox["vars",
       FontSlant->"Italic"],
      "."
     }], "Text"]},
    {
     RowBox[{
      StyleBox["FindRoot", "MR"], 
      StyleBox["[", "MR"], 
      StyleBox[
       RowBox[{"eqns", ",", " ", "vars"}], "TI"], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "Find a root",
      " ",
      "of the equations ",
      StyleBox["eqns",
       FontSlant->"Italic"],
      " with respect to the variables given in ",
      StyleBox["vars",
       FontSlant->"Italic"],
      "."
     }]]},
    {
     RowBox[{
      StyleBox["FindFit", "MR"], 
      StyleBox["[", "MR"], 
      RowBox[{
       StyleBox["data", "TI"], 
       StyleBox[",", "MR"], " ", 
       StyleBox["expr", "TI"], 
       StyleBox[",", "MR"], " ", 
       StyleBox["pars", "TI"], 
       StyleBox[",", "MR"], " ", 
       StyleBox["vars", "TI"]}], 
      StyleBox["]", "MR"]}], Cell[TextData[{
      "Find values of the parameters ",
      StyleBox["pars", "TI"],
      " that make ",
      StyleBox["expr", "TI"],
      " give a best fit to ",
      StyleBox["data", "TI"],
      " as a function of ",
      StyleBox["vars", "TI"],
      "."
     }], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.5.2",
 CellID->1388929716],

Cell[TextData[{
 "Variables and parameters in the \[OpenCurlyDoubleQuote]",
 StyleBox["Find", "MR"],
 "\[CloseCurlyDoubleQuote] functions. "
}], "Caption",
 CellTags->"b:0.5.2",
 CellID->594493922],

Cell[TextData[{
 "The list ",
 StyleBox["vars",
  FontSlant->"Italic"],
 " (",
 StyleBox["pars",
  FontSlant->"Italic"],
 " for ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 ") should be a list of individual variable specifications. Each variable \
specification should be of the following form."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->1565421210],

Cell[BoxData[
 FormBox[GridBox[{
    {
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        StyleBox["var",
         FontSlant->"Italic"], ",", " ", 
        StyleBox["st",
         FontSlant->"Italic"]}], "}"}], "MR"], Cell[TextData[{
      "Variable ",
      StyleBox["var",
       FontSlant->"Italic"],
      " has starting value ",
      StyleBox["st",
       FontSlant->"Italic"],
      "."
     }], "Text"]},
    {
     RowBox[{
      StyleBox["{", "MR"], 
      RowBox[{
       StyleBox["var", "MR",
        FontSlant->"Italic"], 
       StyleBox[",", "MR"], 
       StyleBox[" ", "MR"], 
       SubscriptBox[
        StyleBox["st", "MR",
         FontSlant->"Italic"], "1"], 
       StyleBox[",", "MR",
        FontSlant->"Italic"], 
       StyleBox[" ", "MR",
        FontSlant->"Italic"], 
       SubscriptBox[
        StyleBox["st", "MR",
         FontSlant->"Italic"], "2"]}], 
      StyleBox["}", "MR"]}], Cell[TextData[{
      "Variable ",
      StyleBox["var",
       FontSlant->"Italic"],
      " has two staring values ",
      Cell[BoxData[
       FormBox[
        StyleBox[
         SubscriptBox["st", "1"],
         FontSlant->"Italic"], TraditionalForm]]],
      "and ",
      Cell[BoxData[
       FormBox[
        SubscriptBox["st", "2"], TraditionalForm]],
       FontSlant->"Italic"],
      ". ",
      "The second starting condition is only used with the principal axis and \
secant methods."
     }], "Text"]},
    {
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        StyleBox["var",
         FontSlant->"Italic"], ",", " ", 
        StyleBox["st",
         FontSlant->"Italic"], 
        StyleBox[",",
         FontSlant->"Italic"], 
        StyleBox[" ",
         FontSlant->"Italic"], 
        StyleBox["rl",
         FontSlant->"Italic"], 
        StyleBox[",",
         FontSlant->"Italic"], 
        StyleBox[" ",
         FontSlant->"Italic"], 
        StyleBox["ru",
         FontSlant->"Italic"]}], "}"}], "MR"], Cell[TextData[{
      "Variable ",
      StyleBox["var",
       FontSlant->"Italic"],
      " has starting value ",
      StyleBox["st",
       FontSlant->"Italic"],
      ". ",
      "The search will be terminated when the value of ",
      StyleBox["var",
       FontSlant->"Italic"],
      " goes outside of the interval [",
      StyleBox["rl",
       FontSlant->"Italic"],
      ", ",
      StyleBox["ru",
       FontSlant->"Italic"],
      "]."
     }], "Text"]},
    {
     RowBox[{
      StyleBox["{", "MR"], 
      RowBox[{
       StyleBox["var", "MR",
        FontSlant->"Italic"], 
       StyleBox[",", "MR"], 
       StyleBox[" ", "MR"], 
       SubscriptBox[
        StyleBox["st", "MR",
         FontSlant->"Italic"], "1"], 
       StyleBox[",", "MR",
        FontSlant->"Italic"], 
       StyleBox[" ", "MR",
        FontSlant->"Italic"], 
       SubscriptBox[
        StyleBox["st", "MR",
         FontSlant->"Italic"], "2"], 
       StyleBox[",", "MR",
        FontSlant->"Italic"], 
       StyleBox[" ", "MR",
        FontSlant->"Italic"], 
       StyleBox["rl", "MR",
        FontSlant->"Italic"], 
       StyleBox[",", "MR",
        FontSlant->"Italic"], 
       StyleBox[" ", "MR",
        FontSlant->"Italic"], 
       StyleBox["ru", "MR",
        FontSlant->"Italic"]}], 
      StyleBox["}", "MR"]}], Cell[TextData[{
      "Variable var has two staring values ",
      Cell[BoxData[
       FormBox[
        StyleBox[
         SubscriptBox["st", "1"],
         FontSlant->"Italic"], TraditionalForm]]],
      "and",
      StyleBox[" ",
       FontSlant->"Italic"],
      Cell[BoxData[
       FormBox[
        SubscriptBox["st", "2"], TraditionalForm]],
       FontSlant->"Italic"],
      ". ",
      "The search will be terminated when the value of ",
      StyleBox["var",
       FontSlant->"Italic"],
      " goes outside of the interval [",
      StyleBox["rl",
       FontSlant->"Italic"],
      ", ",
      StyleBox["ru",
       FontSlant->"Italic"],
      "]."
     }], "Text"]}
   }], TextForm]], "DefinitionBox",
 CellTags->"b:0.5.2",
 CellID->1212117073],

Cell[TextData[{
 "Individual variable specifications in the \[OpenCurlyDoubleQuote]",
 StyleBox["Find", "MR"],
 "\[CloseCurlyDoubleQuote] functions. "
}], "Caption",
 CellTags->"b:0.5.2",
 CellID->1021770469],

Cell[TextData[{
 "The specifications in ",
 StyleBox["vars",
  FontSlant->"Italic"],
 " all need to have the same number of starting values. When region bounds \
are not specified, they are taken to be unbounded, i.e., ",
 StyleBox["rl",
  FontSlant->"Italic"],
 " = -\[Infinity], ",
 StyleBox["ru",
  FontSlant->"Italic"],
 " = \[Infinity]."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->1617031071],

Cell[CellGroupData[{

Cell["Vector and Matrix Valued Variables", "Subsection",
 CellTags->{"t:23", "c:23", "b:0.5.2"},
 CellID->1035657512],

Cell[TextData[{
 "The most common use of variables is to represent numbers. However, the \
variable input syntax supports variables that are treated as vectors, \
matrices, or higher rank tensors. In general, the ",
 StyleBox["Find", "MR"],
 " commands, with the exception of ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 ", which currently only works with scalar variables, will consider a \
variable to take on values with the same rectangular structure as the \
starting conditions given for it. "
}], "Text",
 CellTags->"b:0.5.2",
 CellID->940845249],

Cell["Here is a matrix.", "MathCaption",
 CellTags->"b:0.5.2",
 CellID->864007082],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", " ", "=", " ", 
   RowBox[{"(", GridBox[{
      {"0", "1", "2"},
      {"3", "4", "5"},
      {"6", "7", "8"}
     }], ")"}]}], ";"}]], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[1]:=",
 CellID->82606160],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to find an eigenvalue and corresponding normalized eigenvector for ",
 StyleBox["A", "MR"],
 "."
}], "MathCaption",
 CellTags->"b:0.5.2",
 CellID->1087295158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"A", ".", "x"}], " ", "\[Equal]", " ", 
      RowBox[{"\[Lambda]", " ", "x"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", ".", "x"}], " ", "\[Equal]", " ", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", " ", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[2]:=",
 CellID->1231368183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Lambda]", "\[Rule]", "13.348469228349535`"}], ",", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "0.1647638172823028`", ",", "0.505774475900566`", ",", 
      "0.8467851345188292`"}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.2",
 CellLabel->"Out[2]=",
 CellID->231068342]
}, Open  ]],

Cell[TextData[{
 "Of course, this is not the best way to compute the eigenvalue, but it does \
show how the variable dimensions are picked up from the starting values. \
Since \[Lambda] has a starting value of 1, it is taken to be a scalar. On the \
other hand, ",
 StyleBox["x",
  FontSlant->"Italic"],
 " is given a starting value, which is a vector of length 3, so it is always \
taken to be a vector of length 3."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->390175358],

Cell["\<\
If you use multiple starting values for variables, it is necessary that the \
values have consistent dimensions and that each component of the starting \
values are distinct.\
\>", "Text",
 CellTags->"b:0.5.2",
 CellID->1409667615],

Cell["\<\
This finds a different eigenvalue using two starting conditions for each \
variable.\
\>", "MathCaption",
 CellTags->"b:0.5.2",
 CellID->1244011601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"A", ".", "x"}], " ", "\[Equal]", " ", 
      RowBox[{"\[Lambda]", " ", "x"}]}], ",", " ", 
     RowBox[{
      RowBox[{"x", ".", "x"}], " ", "\[Equal]", " ", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", " ", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[3]:=",
 CellID->202190815],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Lambda]", "\[Rule]", 
    RowBox[{"-", "1.3484692283494921`"}]}], ",", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.7996996631117717`"}], ",", 
      RowBox[{"-", "0.10420578771936177`"}], ",", "0.5912880876736021`"}], 
     "}"}]}]}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.2",
 CellLabel->"Out[3]=",
 CellID->157687551]
}, Open  ]],

Cell["\<\
One advantage of variables that can take on vector and matrix values is that \
it allows you to write functions, which can be very efficient for larger \
problems and/or handle problems of different sizes automatically.\
\>", "Text",
 CellTags->"b:0.5.2",
 CellID->1262643331],

Cell[TextData[{
 "This defines a function that gives an objective function equivalent to the \
",
 StyleBox["ExtendedRosenbrock", "MR"],
 " problem in the ",
 ButtonBox["UnconstrainedProblems",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UnconstrainedOptimizationTestProblems"],
 " package. The function expects a value of ",
 StyleBox["x",
  FontSlant->"Italic"],
 " which is a matrix with two rows. "
}], "MathCaption",
 CellTags->"b:0.5.2",
 CellID->1960548110],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtendedRosenbrockObjective", "[", 
   RowBox[{"x_", " ", "/;", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Length", "[", "x", "]"}], " ", "\[Equal]", " ", "2"}], ")"}],
       " ", "&&", " ", 
      RowBox[{"MatrixQ", "[", "x", "]"}]}], ")"}]}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1", ",", " ", "x2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", " ", "x2"}], "}"}], " ", "=", " ", "x"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"x2", " ", "-=", " ", 
      RowBox[{"x1", "^", "2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"x1", " ", "-=", " ", "1"}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"x1", ".", "x1"}], " ", "+", " ", 
      RowBox[{"100", " ", 
       RowBox[{"x2", ".", "x2"}]}]}]}]}], "]"}]}]], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[4]:=",
 CellID->2090488849],

Cell[TextData[{
 "Note that since the value of the function would be meaningless unless ",
 StyleBox["x", "MR"],
 " had the correct structure, the definition is restricted to arguments with \
that structure. For example, if you defined the function for any pattern ",
 StyleBox["x_", "MR"],
 ", then evaluating with an undefined symbol ",
 StyleBox["x", "MR"],
 " (which is what ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " does) gives meaningless unintended results. It is often the case that when \
working with functions for vector valued variables, you will have to restrict \
the definitions. Note that the definition above does not rule out symbolic \
values with the right structure. For example, ",
 StyleBox["ExtendedRosenbrockObjective[{{x11, x12}, {x21, x22}}]", "MR"],
 " gives a symbolic representation of the function for scalar ",
 StyleBox["x11", "MR"],
 ", ..."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->2013620223],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " to solve the problem given a generic value for the problem size. You can \
change the value of ",
 StyleBox["n",
  FontSlant->"Italic"],
 " without changing anything else to solve problems of different size."
}], "MathCaption",
 CellTags->"b:0.5.2",
 CellID->720294888],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"start", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"-", "1.2"}], ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], ",", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"1.", ",", " ", 
       RowBox[{"{", "n", "}"}]}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"ExtendedRosenbrockObjective", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "start"}], "}"}]}], "]"}]}], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[5]:=",
 CellID->630864477],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindMinimum/lstol\\\", ButtonNote -> \
\\\"FindMinimum::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"b:0.5.2",
 CellLabel->"During evaluation of In[5]:=",
 CellID->696245285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.0008109811178126`*^-10", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0.9999955258065126`", ",", "0.9999955257278559`", ",", 
         "0.9999955258324762`", ",", "0.999995532512538`", ",", 
         "0.9999955257530396`", ",", "0.9999955258071028`", ",", 
         "0.9999955258040406`", ",", "0.9999955325400809`", ",", 
         "0.9999955258075126`", ",", "0.9999955260587445`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "0.9999910473269565`", ",", "0.9999910471693243`", ",", 
         "0.9999910473789849`", ",", "0.999991060765647`", ",", 
         "0.9999910472197958`", ",", "0.9999910473281406`", ",", 
         "0.9999910473220032`", ",", "0.9999910608208515`", ",", 
         "0.9999910473289603`", ",", "0.9999910478324221`"}], "}"}]}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{522, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.2",
 CellLabel->"Out[7]=",
 CellID->11903922]
}, Open  ]],

Cell[TextData[{
 "The solution did not achieve the default tolerances due to the fact that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " was not able to get symbolic derivatives for the function, so it had to \
fall back on finite differences that are not as accurate. "
}], "Text",
 CellTags->"b:0.5.2",
 CellID->869701089],

Cell[TextData[{
 "A disadvantage of using vector and matrix valued variables is that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot currently compute symbolic derivatives for them. Sometimes it is \
not difficult to develop a function that gives the correct derivative. \
(Failing that, if you really need greater accuracy, you can use ",
 ButtonBox["higher-order finite differences",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationSpecifyingDerivatives"],
 ".)"
}], "Text",
 CellTags->"b:0.5.2",
 CellID->1292501341],

Cell[TextData[{
 "This defines a function that returns the gradient for the ",
 StyleBox["ExtendedRosenbrockObjective", "MR"],
 " function. Note that the gradient is a vector obtained by flattening the \
matrix corresponding to the variable positions."
}], "MathCaption",
 CellTags->"b:0.5.2",
 CellID->1272948782],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExtendedRosenbrockGradient", "[", 
   RowBox[{"x_", " ", "/;", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Length", "[", "x", "]"}], " ", "\[Equal]", " ", "2"}], ")"}],
       " ", "&&", " ", 
      RowBox[{"MatrixQ", "[", "x", "]"}]}], ")"}]}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x1", ",", " ", "x2"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", " ", "x2"}], "}"}], " ", "=", " ", "x"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"x2", " ", "-=", " ", 
      RowBox[{"x1", "^", "2"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"x1", " ", "-", " ", "1"}], ")"}]}], " ", "-", " ", 
         RowBox[{"400", " ", "x1", " ", "x2"}]}], ",", " ", 
        RowBox[{"200", " ", "x2"}]}], "}"}], "]"}]}]}], "]"}]}]], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[8]:=",
 CellID->1218087660],

Cell["\<\
This solves the problem using the symbolic value of the gradient.\
\>", "MathCaption",
 CellTags->"b:0.5.2",
 CellID->437694769],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"start", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"-", "1.2"}], ",", 
       RowBox[{"{", "n", "}"}]}], "]"}], ",", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"1.", ",", " ", 
       RowBox[{"{", "n", "}"}]}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"ExtendedRosenbrockObjective", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "start"}], "}"}], ",", " ", 
   RowBox[{"Gradient", "\[Rule]", 
    RowBox[{"ExtendedRosenbrockGradient", "[", "x", "]"}]}]}], 
  "]"}]}], "Input",
 CellTags->"b:0.5.2",
 CellLabel->"In[9]:=",
 CellID->1204491608],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWclOwzAQTbMQ2rJVIFoOoF74BEBCPcOJA5w4cIkqpPaAQKWfVr6AE/wC
/EvwJDF1H5M6SxdXtFKcvBmPZ3UcuzfBsPf4FAz73aB9PQheev3ua/vqeSBI
TsWy7EvLsk5blngOxVN0yV9HXGN4Ji5bsL0J6gUh51fKsjNwj4DqAt4DfDhj
3Cwpj/bWNPaX1Tdv+xF7gOOstTRSjTCuj2bGe2sKXR3XSegY5YZmnKL6dNFB
nC061MsTUHqzAfwNw/n+kvVjPDdzxnfZ9q9afGdT9YhV7XSvGs7Hd84i9WMc
uf66+C7T/lWLb/7qx3VYt46a9h2zBXhbY79p3zFof94sVsIi7zDTslgHvKux
37Qsov2LWYnWWVxncZ3FdRazROF/ZlF3SkO9ZrHfl3dczRsp+sru99P0FTsV
CZNfkXMwyeVP1jpaJHcFknoeUR3QVYb7ABi/16n5SJXkvvCp+WQlCBOUXnkK
nnaPouYpYaAzzIgr97vU6wC0RecHripFOmWN4Qyi5o212ma1y32Gy3J5mfJU
tUIJ+5ls3Q/5vZI9GSHxgPsDakYRywYOavYXGgfu7EMfh2PoJeuQbK8mZL4G
uLMc07N+Ar1kxe4AnZoR67WMTy2HreocdxLsps7hbHlDT/7WLb7pqTEgk5q1
LsXT1HcW4XfWK3606px8Q+34bwgvRZF2GGmuHqevH/VQv144SaWr64ysxXjg
eDqpOoiFvlDDr3931PjgZTIKoe8SUnLm3YJ1NuCxxD2XA/DjK5aq/ABDrRk0
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{570, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.5.2",
 CellLabel->"Out[11]=",
 CellID->645896791]
}, Open  ]],

Cell[TextData[{
 "Jacobian and Hessian derivatives are often sparse. You can also ",
 ButtonBox["specify the structural sparsity",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UnconstrainedOptimizationSpecifyingDerivatives"],
 " of these derivatives when appropriate, which can reduce overall solution \
complexity by quite a bit."
}], "Text",
 CellTags->"b:0.5.2",
 CellID->2047251225],

Cell["", "Text",
 CellTags->"b:0.5.2",
 CellID->1168346341],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->459501322],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "TutorialMoreAbout",
 CellID->48539711],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "TutorialMoreAbout",
 CellID->21321],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->211443811],

Cell[TextData[ButtonBox["Unconstrained Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/UnconstrainedOptimizationOverview"]], "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Variables and Starting Conditions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 40.4240826}", "context" -> 
    "Optimization`UnconstrainedProblems`", "keywords" -> {}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "All of the functions FindMinimum, FindMaximum, and FindRoot take \
variable specifications of the same form. The function FindFit uses the same \
for its parameter specifications. Find a local minimum of f with respect to \
the variables given in vars. Find a local maximum of f with respect to the \
variables given in vars.", "synonyms" -> {}, "title" -> 
    "Variables and Starting Conditions", "type" -> "Tutorial", "uri" -> 
    "tutorial/UnconstrainedOptimizationVariablesAndStartingConditions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:22"->{
  Cell[2234, 67, 111, 2, 70, "Title",
   CellTags->{"t:22", "c:22", "b:0.5.2"},
   CellID->1302289373]},
 "c:22"->{
  Cell[2234, 67, 111, 2, 70, "Title",
   CellTags->{"t:22", "c:22", "b:0.5.2"},
   CellID->1302289373]},
 "b:0.5.2"->{
  Cell[2234, 67, 111, 2, 70, "Title",
   CellTags->{"t:22", "c:22", "b:0.5.2"},
   CellID->1302289373],
  Cell[2348, 71, 717, 24, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->424161787],
  Cell[3068, 97, 2447, 94, 70, "DefinitionBox",
   CellTags->"b:0.5.2",
   CellID->1388929716],
  Cell[5518, 193, 197, 6, 70, "Caption",
   CellTags->"b:0.5.2",
   CellID->594493922],
  Cell[5718, 201, 426, 16, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->1565421210],
  Cell[6147, 219, 4047, 151, 70, "DefinitionBox",
   CellTags->"b:0.5.2",
   CellID->1212117073],
  Cell[10197, 372, 208, 6, 70, "Caption",
   CellTags->"b:0.5.2",
   CellID->1021770469],
  Cell[10408, 380, 397, 14, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->1617031071],
  Cell[10830, 398, 117, 2, 70, "Subsection",
   CellTags->{"t:23", "c:23", "b:0.5.2"},
   CellID->1035657512],
  Cell[10950, 402, 629, 15, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->940845249],
  Cell[11582, 419, 82, 2, 70, "MathCaption",
   CellTags->"b:0.5.2",
   CellID->864007082],
  Cell[11667, 423, 247, 10, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->82606160],
  Cell[11917, 435, 311, 11, 70, "MathCaption",
   CellTags->"b:0.5.2",
   CellID->1087295158],
  Cell[12253, 450, 622, 21, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->1231368183],
  Cell[12878, 473, 439, 14, 36, "Output",
   CellTags->"b:0.5.2",
   CellID->231068342],
  Cell[13332, 490, 471, 11, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->390175358],
  Cell[13806, 503, 241, 6, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->1409667615],
  Cell[14050, 511, 158, 5, 70, "MathCaption",
   CellTags->"b:0.5.2",
   CellID->1244011601],
  Cell[14233, 520, 779, 26, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->202190815],
  Cell[15015, 548, 498, 16, 36, "Output",
   CellTags->"b:0.5.2",
   CellID->157687551],
  Cell[15528, 567, 286, 6, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->1262643331],
  Cell[15817, 575, 472, 14, 70, "MathCaption",
   CellTags->"b:0.5.2",
   CellID->1960548110],
  Cell[16292, 591, 1018, 29, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->2090488849],
  Cell[17313, 622, 1019, 23, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->2013620223],
  Cell[18335, 647, 428, 13, 70, "MathCaption",
   CellTags->"b:0.5.2",
   CellID->720294888],
  Cell[18788, 664, 664, 21, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->630864477],
  Cell[19455, 687, 682, 13, 70, "Message",
   CellTags->"b:0.5.2",
   CellID->696245285],
  Cell[20140, 702, 1093, 27, 92, "Output",
   CellTags->"b:0.5.2",
   CellID->11903922],
  Cell[21248, 732, 333, 8, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->869701089],
  Cell[21584, 742, 566, 14, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->1292501341],
  Cell[22153, 758, 314, 7, 70, "MathCaption",
   CellTags->"b:0.5.2",
   CellID->1272948782],
  Cell[22470, 767, 1138, 33, 70, "Input",
   CellTags->"b:0.5.2",
   CellID->1218087660],
  Cell[23611, 802, 138, 4, 70, "MathCaption",
   CellTags->"b:0.5.2",
   CellID->437694769],
  Cell[23774, 810, 775, 24, 83, "Input",
   CellTags->"b:0.5.2",
   CellID->1204491608],
  Cell[24552, 836, 1028, 22, 58, "Output",
   Evaluatable->False,
   CellTags->"b:0.5.2",
   CellID->645896791],
  Cell[25595, 861, 397, 10, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->2047251225],
  Cell[25995, 873, 59, 2, 70, "Text",
   CellTags->"b:0.5.2",
   CellID->1168346341]},
 "t:23"->{
  Cell[10830, 398, 117, 2, 70, "Subsection",
   CellTags->{"t:23", "c:23", "b:0.5.2"},
   CellID->1035657512]},
 "c:23"->{
  Cell[10830, 398, 117, 2, 70, "Subsection",
   CellTags->{"t:23", "c:23", "b:0.5.2"},
   CellID->1035657512]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:22", 28628, 951},
 {"c:22", 28744, 955},
 {"b:0.5.2", 28863, 959},
 {"t:23", 32255, 1072},
 {"c:23", 32378, 1076}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1609, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 67, 111, 2, 70, "Title",
 CellTags->{"t:22", "c:22", "b:0.5.2"},
 CellID->1302289373],
Cell[2348, 71, 717, 24, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->424161787],
Cell[3068, 97, 2447, 94, 70, "DefinitionBox",
 CellTags->"b:0.5.2",
 CellID->1388929716],
Cell[5518, 193, 197, 6, 70, "Caption",
 CellTags->"b:0.5.2",
 CellID->594493922],
Cell[5718, 201, 426, 16, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->1565421210],
Cell[6147, 219, 4047, 151, 70, "DefinitionBox",
 CellTags->"b:0.5.2",
 CellID->1212117073],
Cell[10197, 372, 208, 6, 70, "Caption",
 CellTags->"b:0.5.2",
 CellID->1021770469],
Cell[10408, 380, 397, 14, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->1617031071],
Cell[CellGroupData[{
Cell[10830, 398, 117, 2, 70, "Subsection",
 CellTags->{"t:23", "c:23", "b:0.5.2"},
 CellID->1035657512],
Cell[10950, 402, 629, 15, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->940845249],
Cell[11582, 419, 82, 2, 70, "MathCaption",
 CellTags->"b:0.5.2",
 CellID->864007082],
Cell[11667, 423, 247, 10, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->82606160],
Cell[11917, 435, 311, 11, 70, "MathCaption",
 CellTags->"b:0.5.2",
 CellID->1087295158],
Cell[CellGroupData[{
Cell[12253, 450, 622, 21, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->1231368183],
Cell[12878, 473, 439, 14, 36, "Output",
 CellTags->"b:0.5.2",
 CellID->231068342]
}, Open  ]],
Cell[13332, 490, 471, 11, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->390175358],
Cell[13806, 503, 241, 6, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->1409667615],
Cell[14050, 511, 158, 5, 70, "MathCaption",
 CellTags->"b:0.5.2",
 CellID->1244011601],
Cell[CellGroupData[{
Cell[14233, 520, 779, 26, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->202190815],
Cell[15015, 548, 498, 16, 36, "Output",
 CellTags->"b:0.5.2",
 CellID->157687551]
}, Open  ]],
Cell[15528, 567, 286, 6, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->1262643331],
Cell[15817, 575, 472, 14, 70, "MathCaption",
 CellTags->"b:0.5.2",
 CellID->1960548110],
Cell[16292, 591, 1018, 29, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->2090488849],
Cell[17313, 622, 1019, 23, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->2013620223],
Cell[18335, 647, 428, 13, 70, "MathCaption",
 CellTags->"b:0.5.2",
 CellID->720294888],
Cell[CellGroupData[{
Cell[18788, 664, 664, 21, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->630864477],
Cell[19455, 687, 682, 13, 70, "Message",
 CellTags->"b:0.5.2",
 CellID->696245285],
Cell[20140, 702, 1093, 27, 92, "Output",
 CellTags->"b:0.5.2",
 CellID->11903922]
}, Open  ]],
Cell[21248, 732, 333, 8, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->869701089],
Cell[21584, 742, 566, 14, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->1292501341],
Cell[22153, 758, 314, 7, 70, "MathCaption",
 CellTags->"b:0.5.2",
 CellID->1272948782],
Cell[22470, 767, 1138, 33, 70, "Input",
 CellTags->"b:0.5.2",
 CellID->1218087660],
Cell[23611, 802, 138, 4, 70, "MathCaption",
 CellTags->"b:0.5.2",
 CellID->437694769],
Cell[CellGroupData[{
Cell[23774, 810, 775, 24, 83, "Input",
 CellTags->"b:0.5.2",
 CellID->1204491608],
Cell[24552, 836, 1028, 22, 58, "Output",
 Evaluatable->False,
 CellTags->"b:0.5.2",
 CellID->645896791]
}, Open  ]],
Cell[25595, 861, 397, 10, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->2047251225],
Cell[25995, 873, 59, 2, 70, "Text",
 CellTags->"b:0.5.2",
 CellID->1168346341],
Cell[CellGroupData[{
Cell[26079, 879, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->459501322],
Cell[26148, 882, 143, 3, 70, "TutorialMoreAbout",
 CellID->48539711],
Cell[26294, 887, 164, 3, 70, "TutorialMoreAbout",
 CellID->21321],
Cell[26461, 892, 195, 4, 70, "TutorialMoreAbout",
 CellID->776025961]
}, Open  ]],
Cell[CellGroupData[{
Cell[26693, 901, 72, 1, 70, "RelatedTutorialsSection",
 CellID->211443811],
Cell[26768, 904, 183, 4, 70, "RelatedTutorials",
 CellID->20683583]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[26990, 913, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

