(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30645,       1123]
NotebookOptionsPosition[     22498,        861]
NotebookOutlinePosition[     25758,        942]
CellTagsIndexPosition[     25666,        936]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hold" :> Documentation`HelpLookup["paclet:ref/Hold"], 
          "LinkClose" :> Documentation`HelpLookup["paclet:ref/LinkClose"], 
          "LinkConnect" :> Documentation`HelpLookup["paclet:ref/LinkConnect"],
           "LinkCreate" :> Documentation`HelpLookup["paclet:ref/LinkCreate"], 
          "LinkRead" :> Documentation`HelpLookup["paclet:ref/LinkRead"], 
          "LinkReadyQ" :> Documentation`HelpLookup["paclet:ref/LinkReadyQ"], 
          "LinkWrite" :> Documentation`HelpLookup["paclet:ref/LinkWrite"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Hold\"\>", 
       2->"\<\"LinkClose\"\>", 3->"\<\"LinkConnect\"\>", 
       4->"\<\"LinkCreate\"\>", 5->"\<\"LinkRead\"\>", 
       6->"\<\"LinkReadyQ\"\>", 7->"\<\"LinkWrite\"\>"}, "\<\"functions\"\>", 
       
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to Communicate between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Sessions"
}], "Title",
 CellTags->{"S2.13.6", "6.1"},
 CellID->20648],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LinkCreate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkCreate"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "create a link for another program to connect to", "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkConnect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkConnect"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], Cell[
    "connect to a link created by another program", "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkClose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkClose"], "[", 
     StyleBox["link", "TI"], "]"}], Cell[TextData[{
     "close a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkWrite",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkWrite"], "[", 
     StyleBox["link", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "write an expression to a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkRead"], "[", 
     StyleBox["link", "TI"], "]"}], Cell[TextData[{
     "read an expression from a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkRead",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkRead"], "[", 
     StyleBox["link", "TI"], ",", 
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "]"}], Cell[TextData[{
     "read an expression and immediately wrap it with ",
     Cell[BoxData[
      ButtonBox["Hold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hold"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkReadyQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkReadyQ"], "[", 
     StyleBox["link", "TI"], "]"}], Cell[
    "find out whether there is data ready to be read from a link", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkReadyQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkReadyQ"], "[", 
     RowBox[{
      StyleBox["link", "TI"], ",", 
      StyleBox["t", "TI"]}], "]"}], Cell[TextData[{
     "wait for up to ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " seconds to see if an expression becomes ready to read"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkReadyQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkReadyQ"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["link", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["link", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell["\<\
find out whether there is data ready to be read from one of the links\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkReadyQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkReadyQ"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["link", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["link", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["t", "TI"]}], "]"}], Cell[TextData[{
     "wait for up to ",
     Cell[BoxData[
      FormBox["t", TraditionalForm]], "InlineMath"],
     " seconds to see if an expression becomes ready to read"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, False, False, True, {False}}, 
   "RowsIndexed" -> {}}},
 CellID->20547],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions. "
}], "Caption",
 CellID->5555],

Cell["Session A", "SessionLabel",
 CellID->10832],

Cell["This starts up a link on port number 8000. ", "MathCaption",
 CellID->26781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkCreate", "[", 
   RowBox[{"\"\<8000\>\"", ",", 
    RowBox[{"LinkProtocol", "\[Rule]", "\"\<TCPIP\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->30837],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"8000@frog.wolfram.com,4470@frog.wolfram.com\"\>", ",", "17", 
   ",", "5"}], "]"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->817094723]
}, Open  ]],

Cell["Session B", "SessionLabel",
 CellID->25896],

Cell["This connects to the link on port 8000. ", "MathCaption",
 CellID->5859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Link", "=", 
  RowBox[{"LinkConnect", "[", 
   RowBox[{"\"\<8000\>\"", ",", 
    RowBox[{"LinkProtocol", "\[Rule]", "\"\<TCPIP\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->8324],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{
   RowBox[{"\<\"8000@\"\>", 
    RowBox[{"frog", ".", "wolfram", ".", "com"}], "\<\"\"\>"}], ",", "11", 
   ",", "4"}], "]"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{285, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->52441926]
}, Open  ]],

Cell["Session A", "SessionLabel",
 CellID->15653],

Cell[TextData[{
 "This evaluates ",
 Cell[BoxData[
  RowBox[{"15", "!"}]], "InlineFormula"],
 " and writes it to the link. "
}], "MathCaption",
 CellID->7701],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"15", "!"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28841],

Cell["Session B", "SessionLabel",
 CellID->4404],

Cell[TextData[{
 "This reads from the link, getting the ",
 Cell[BoxData[
  RowBox[{"15", "!"}]], "InlineFormula"],
 " that was sent. "
}], "MathCaption",
 CellID->15729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "Link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19215],

Cell["1307674368000", "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30565]
}, Open  ]],

Cell["This writes data back on the link. ", "MathCaption",
 CellID->3650],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"N", "[", 
    RowBox[{"%", "^", "6"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25532],

Cell["Session A", "SessionLabel",
 CellID->3083],

Cell["And this reads the data written in session B. ", "MathCaption",
 CellID->29719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18296],

Cell[BoxData["5.000318485342659`*^72"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->24439]
}, Open  ]],

Cell[TextData[{
 "One use of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions is simply as a way to transfer data without using intermediate \
files. "
}], "Text",
 CellID->778],

Cell["\<\
Another use is as a way to dispatch different parts of a computation to \
different sessions. \
\>", "Text",
 CellID->12238],

Cell["Session A", "SessionLabel",
 CellID->5241],

Cell[TextData[{
 "This writes the expression ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 " without evaluating it. "
}], "MathCaption",
 CellID->20803],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"2", "+", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6006],

Cell["Session B", "SessionLabel",
 CellID->22620],

Cell[TextData[{
 "This reads the expression from the link, immediately wrapping it in ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", 
  RowBox[{"Link", ",", "Hold"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7849],

Cell["Hold[2 + 2]", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->19205]
}, Open  ]],

Cell["This evaluates the expression. ", "MathCaption",
 CellID->4524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->25078],

Cell["4", "Output",
 ImageSize->{7, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->11787]
}, Open  ]],

Cell[TextData[{
 "When you call ",
 Cell[BoxData[
  ButtonBox["LinkWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkWrite"]], "InlineFormula"],
 ", it writes an expression to the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection and immediately returns. But when you call ",
 Cell[BoxData[
  ButtonBox["LinkRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkRead"]], "InlineFormula"],
 ", it will not return until it has read a complete expression from the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection. "
}], "Text",
 CellID->21984],

Cell[TextData[{
 "You can tell whether anything is ready to be read by calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  ButtonBox["LinkReadyQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", then you can safely call ",
 Cell[BoxData[
  ButtonBox["LinkRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkRead"]], "InlineFormula"],
 " and expect immediately to start reading an expression. But if ",
 Cell[BoxData[
  ButtonBox["LinkReadyQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["LinkRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkRead"]], "InlineFormula"],
 " would block until an expression for it to read had been written by a ",
 Cell[BoxData[
  ButtonBox["LinkWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkWrite"]], "InlineFormula"],
 " in your other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->12629],

Cell["Session A", "SessionLabel",
 CellID->139],

Cell[TextData[{
 "There is nothing waiting to be read on the link, so if ",
 Cell[BoxData[
  ButtonBox["LinkRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkRead"]], "InlineFormula"],
 " were to be called, it would block. "
}], "MathCaption",
 CellID->7898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkReadyQ", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19973],

Cell["False", "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->22638]
}, Open  ]],

Cell["Session B", "SessionLabel",
 CellID->3815],

Cell["This writes an expression to the link. ", "MathCaption",
 CellID->21002],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"Link", ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->24041],

Cell["Session A", "SessionLabel",
 CellID->24485],

Cell["Now there is an expression waiting to be read on the link. ", \
"MathCaption",
 CellID->15063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkReadyQ", "[", "link", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->22211],

Cell["True", "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->20066]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkRead"]], "InlineFormula"],
 " can thus be called without fear of blocking. "
}], "MathCaption",
 CellID->18827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->9583],

Cell["x + y", "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->3930]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkReadyQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFormula"],
 " can take a list of link objects, evaluating each link in parallel to \
determine if there is data to read. As in the case of a single link, a second \
argument specifies a time out period, causing ",
 Cell[BoxData[
  ButtonBox["LinkReadyQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFormula"],
 " to wait until one of the links is ready to use. "
}], "Text",
 CellID->935629401],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LinkCreate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkCreate"], "[", 
     RowBox[{"LinkProtocol", "->", "\"\<TCPIP\>\""}], "]"}], Cell[
    "pick any unused port on your computer", "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkCreate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkCreate"], "[", 
     StyleBox[
      RowBox[{"\"\<\!\(\*
StyleBox[\"number\", \"TI\"]\)\>\"", ",", 
       RowBox[{"LinkProtocol", "->", "\"\<TCPIP\>\""}]}],
      ShowStringCharacters->True], "]"}], "\[SpanFromLeft]"},
   {"", Cell["use a specific port", "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkConnect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkConnect"], "[", 
     StyleBox[
      RowBox[{"\"\<\!\(\*
StyleBox[\"number\", \"TI\"]\)\>\"", ",", 
       RowBox[{"LinkProtocol", "->", "\"\<TCPIP\>\""}]}],
      ShowStringCharacters->True], "]"}], "\[SpanFromLeft]"},
   {"", Cell["connect to a port on the same computer", "TableText"]},
   {
    RowBox[{
     ButtonBox["LinkConnect",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LinkConnect"], "[", 
     StyleBox[
      RowBox[{"\"\<\!\(\*
StyleBox[\"number\", \"TI\"]\)@\!\(\*
StyleBox[\"host\", \"TI\"]\)\>\"", ",", 
       RowBox[{"LinkProtocol", "->", "\"\<TCPIP\>\""}]}],
      ShowStringCharacters->True], "]"}], "\[SpanFromLeft]"},
   {"", Cell["connect a port on another computer", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.45], {
      Scaled[0.55]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->26565],

Cell[TextData[{
 "Ways to set up ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " links over TCP/IP. "
}], "Caption",
 CellID->12082],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " can use whatever mechanism for interprogram communication your computer \
system supports. In setting up connections between concurrent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions, a common mechanism is internet TCP ports."
}], "Text",
 CellID->27982],

Cell["\<\
Most computer systems have a few thousand possible numbered ports, some of \
which are typically allocated to standard system services. \
\>", "Text",
 CellID->8831],

Cell[TextData[{
 "You can use any of the unallocated ports for ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections. "
}], "Text",
 CellID->28235],

Cell[TextData[{
 "Session on ",
 StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
 CellID->23290],

Cell[TextData[{
 "This finds an unallocated port on ",
 Cell[BoxData[
  RowBox[{"frog", ".", "wolfram", ".", "com"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkCreate", "[", 
   RowBox[{"LinkProtocol", "\[Rule]", "\"\<TCPIP\>\""}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->3256],

Cell["\<\
LinkObject[\"2981@frog.wolfram.com,2982@frog.wolfram.com\", 5, 5]\
\>", "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->15802]
}, Open  ]],

Cell[TextData[{
 "Session on ",
 StyleBox["toad.wolfram.com", "MR"]
}], "SessionLabel",
 CellID->1448],

Cell[TextData[{
 "This connects to the port on ",
 Cell[BoxData[
  RowBox[{"frog", ".", "wolfram", ".", "com"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkConnect", "[", 
   RowBox[{"\"\<2981@frog.wolfram.com,2982@frog.wolfram.com\>\"", ",", 
    RowBox[{"LinkProtocol", "\[Rule]", "\"\<TCPIP\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[7]:=",
 CellID->26126],

Cell["\<\
LinkObject[\"2981@frog.wolfram.com,2982@frog.wolfram.com\", 5, 5]\
\>", "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->18497]
}, Open  ]],

Cell["This sends the current machine name over the link. ", "MathCaption",
 CellID->27064],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", "$MachineName"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->3215],

Cell[TextData[{
 "Session on ",
 StyleBox["frog.wolfram.com", "MR"]
}], "SessionLabel",
 CellID->12293],

Cell[TextData[{
 "This reads the expression written on ",
 Cell[BoxData["toad"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->8437],

Cell["toad", "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->18418]
}, Open  ]],

Cell[TextData[{
 "By using internet ports for ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections, you can easily transfer data between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions on different machines. All that is needed is that an internet \
connection exists between the machines. "
}], "Text",
 CellID->16338],

Cell[TextData[{
 "Note that because ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is completely system independent, the computers at each end of a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection do not have to be of the same type. ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " nevertheless notices when they are, and optimizes data transmission in \
this case. "
}], "Text",
 CellID->22424],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->58988936],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Using MathLink to Communicate between Mathematica Sessions - \
Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/CallingSubsidiaryMathematicaProcesses"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 43.1429022}", "context" -> "", 
    "keywords" -> {
     "bind name", "close", "concurrent Mathematica sessions", "connect link", 
      "cooperating Mathematica session", "create link", 
      "dispatching computations", "distributed processing", "find link", 
      "internet ports", "LinkClose", "LinkConnect", "LinkCreate", "linking", 
      "LinkRead", "LinkReadyQ", "LinkWrite", "listen on link", 
      "parallel Mathematica sessions", "ports", "processes", "publish link", 
      "read", "ready", "register link", "remote computers", "sessions", 
      "sockets", "subscribe to link", "synchronization", "TCP ports", 
      "transferring expressions", "write"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "MathLink connections between Mathematica sessions. This starts up a link \
on port number 8000. This connects to the link on port 8000. ", 
    "synonyms" -> {"2.13.6"}, "title" -> 
    "Using MathLink to Communicate between Mathematica Sessions", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.6"->{
  Cell[2488, 68, 223, 10, 70, "Title",
   CellTags->{"S2.13.6", "6.1"},
   CellID->20648]},
 "6.1"->{
  Cell[2488, 68, 223, 10, 70, "Title",
   CellTags->{"S2.13.6", "6.1"},
   CellID->20648]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.6", 25449, 925},
 {"6.1", 25551, 929}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1863, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2488, 68, 223, 10, 70, "Title",
 CellTags->{"S2.13.6", "6.1"},
 CellID->20648],
Cell[2714, 80, 3934, 128, 70, "DefinitionBox",
 CellID->20547],
Cell[6651, 210, 181, 8, 70, "Caption",
 CellID->5555],
Cell[6835, 220, 49, 1, 70, "SessionLabel",
 CellID->10832],
Cell[6887, 223, 82, 1, 70, "MathCaption",
 CellID->26781],
Cell[CellGroupData[{
Cell[6994, 228, 219, 7, 28, "Input",
 CellID->30837],
Cell[7216, 237, 333, 10, 36, "Output",
 CellID->817094723]
}, Open  ]],
Cell[7564, 250, 49, 1, 70, "SessionLabel",
 CellID->25896],
Cell[7616, 253, 78, 1, 70, "MathCaption",
 CellID->5859],
Cell[CellGroupData[{
Cell[7719, 258, 219, 7, 28, "Input",
 CellID->8324],
Cell[7941, 267, 371, 12, 36, "Output",
 CellID->52441926]
}, Open  ]],
Cell[8327, 282, 49, 1, 70, "SessionLabel",
 CellID->15653],
Cell[8379, 285, 158, 6, 70, "MathCaption",
 CellID->7701],
Cell[8540, 293, 147, 5, 70, "Input",
 CellID->28841],
Cell[8690, 300, 48, 1, 70, "SessionLabel",
 CellID->4404],
Cell[8741, 303, 170, 6, 70, "MathCaption",
 CellID->15729],
Cell[CellGroupData[{
Cell[8936, 313, 103, 3, 70, "Input",
 CellID->19215],
Cell[9042, 318, 157, 5, 36, "Output",
 CellID->30565]
}, Open  ]],
Cell[9214, 326, 73, 1, 70, "MathCaption",
 CellID->3650],
Cell[9290, 329, 181, 6, 70, "Input",
 CellID->25532],
Cell[9474, 337, 48, 1, 70, "SessionLabel",
 CellID->3083],
Cell[9525, 340, 85, 1, 70, "MathCaption",
 CellID->29719],
Cell[CellGroupData[{
Cell[9635, 345, 103, 3, 70, "Input",
 CellID->18296],
Cell[9741, 350, 176, 5, 36, "Output",
 CellID->24439]
}, Open  ]],
Cell[9932, 358, 264, 10, 70, "Text",
 CellID->778],
Cell[10199, 370, 134, 4, 70, "Text",
 CellID->12238],
Cell[10336, 376, 48, 1, 70, "SessionLabel",
 CellID->5241],
Cell[10387, 379, 171, 6, 70, "MathCaption",
 CellID->20803],
Cell[10561, 387, 190, 6, 70, "Input",
 CellID->6006],
Cell[10754, 395, 49, 1, 70, "SessionLabel",
 CellID->22620],
Cell[10806, 398, 240, 8, 70, "MathCaption",
 CellID->32670],
Cell[CellGroupData[{
Cell[11071, 410, 128, 4, 70, "Input",
 CellID->7849],
Cell[11202, 416, 155, 5, 36, "Output",
 CellID->19205]
}, Open  ]],
Cell[11372, 424, 69, 1, 70, "MathCaption",
 CellID->4524],
Cell[CellGroupData[{
Cell[11466, 429, 103, 3, 70, "Input",
 CellID->25078],
Cell[11572, 434, 144, 5, 36, "Output",
 CellID->11787]
}, Open  ]],
Cell[11731, 442, 584, 19, 70, "Text",
 CellID->21984],
Cell[12318, 463, 1423, 48, 70, "Text",
 CellID->12629],
Cell[13744, 513, 47, 1, 70, "SessionLabel",
 CellID->139],
Cell[13794, 516, 268, 8, 70, "MathCaption",
 CellID->7898],
Cell[CellGroupData[{
Cell[14087, 528, 105, 3, 70, "Input",
 CellID->19973],
Cell[14195, 533, 149, 5, 36, "Output",
 CellID->22638]
}, Open  ]],
Cell[14359, 541, 48, 1, 70, "SessionLabel",
 CellID->3815],
Cell[14410, 544, 78, 1, 70, "MathCaption",
 CellID->21002],
Cell[14491, 547, 151, 5, 70, "Input",
 CellID->24041],
Cell[14645, 554, 49, 1, 70, "SessionLabel",
 CellID->24485],
Cell[14697, 557, 100, 2, 70, "MathCaption",
 CellID->15063],
Cell[CellGroupData[{
Cell[14822, 563, 105, 3, 70, "Input",
 CellID->22211],
Cell[14930, 568, 148, 5, 36, "Output",
 CellID->20066]
}, Open  ]],
Cell[15093, 576, 219, 7, 70, "MathCaption",
 CellID->18827],
Cell[CellGroupData[{
Cell[15337, 587, 102, 3, 70, "Input",
 CellID->9583],
Cell[15442, 592, 148, 5, 36, "Output",
 CellID->3930]
}, Open  ]],
Cell[15605, 600, 549, 14, 70, "Text",
 CellID->935629401],
Cell[16157, 616, 1835, 52, 70, "DefinitionBox",
 CellID->26565],
Cell[17995, 670, 136, 6, 70, "Caption",
 CellID->12082],
Cell[18134, 678, 336, 9, 70, "Text",
 CellID->27982],
Cell[18473, 689, 175, 4, 70, "Text",
 CellID->8831],
Cell[18651, 695, 157, 6, 70, "Text",
 CellID->28235],
Cell[18811, 703, 103, 4, 70, "SessionLabel",
 CellID->23290],
Cell[18917, 709, 177, 6, 70, "MathCaption",
 CellID->11812],
Cell[CellGroupData[{
Cell[19119, 719, 180, 5, 70, "Input",
 CellID->3256],
Cell[19302, 726, 268, 9, 36, "Output",
 CellID->15802]
}, Open  ]],
Cell[19585, 738, 102, 4, 70, "SessionLabel",
 CellID->1448],
Cell[19690, 744, 171, 6, 70, "MathCaption",
 CellID->6513],
Cell[CellGroupData[{
Cell[19886, 754, 259, 7, 70, "Input",
 CellID->26126],
Cell[20148, 763, 268, 9, 36, "Output",
 CellID->18497]
}, Open  ]],
Cell[20431, 775, 90, 1, 70, "MathCaption",
 CellID->27064],
Cell[20524, 778, 137, 4, 70, "Input",
 CellID->3215],
Cell[20664, 784, 103, 4, 70, "SessionLabel",
 CellID->12293],
Cell[20770, 790, 139, 5, 70, "MathCaption",
 CellID->31907],
Cell[CellGroupData[{
Cell[20934, 799, 102, 3, 70, "Input",
 CellID->8437],
Cell[21039, 804, 148, 5, 36, "Output",
 CellID->18418]
}, Open  ]],
Cell[21202, 812, 345, 10, 70, "Text",
 CellID->16338],
Cell[21550, 824, 417, 13, 70, "Text",
 CellID->22424],
Cell[CellGroupData[{
Cell[21992, 841, 71, 1, 70, "RelatedTutorialsSection",
 CellID->58988936],
Cell[22066, 844, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[22471, 859, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

