(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11019,        371]
NotebookOptionsPosition[      7107,        251]
NotebookOutlinePosition[      9649,        318]
CellTagsIndexPosition[      9560,        312]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Building Up Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BuildingUpCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Building Up Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Out" :> Documentation`HelpLookup["paclet:ref/Out"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Out\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Using Previous Results", "Title",
 CellTags->{"S1.2.1", "1.1"},
 CellID->70],

Cell[TextData[{
 "In doing calculations, you will often need to use previous results that you \
have got. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData["%"], "InlineFormula"],
 " always stands for your last result. "
}], "Text",
 CellID->11183],

Cell[BoxData[GridBox[{
   {"%", Cell["the last result generated", "TableText"]},
   {"%%", Cell["the next\[Hyphen]to\[Hyphen]last result", "TableText"]},
   {
    RowBox[{"%%", 
     StyleBox["\[Ellipsis]", "TR"], "%", Cell[" (", "TableText"], 
     StyleBox["k", "TI"], Cell[" times)", "TableText"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " previous result"
    }], "TableText"]},
   {
    RowBox[{"%", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the result on output line ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Out",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Out"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " (to be used with care)"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6345],

Cell["Ways to refer to your previous results. ", "Caption",
 CellID->9328],

Cell["Here is the first result. ", "MathCaption",
 CellID->26059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"77", "^", "2"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->7483],

Cell[BoxData["5929"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->19221]
}, Open  ]],

Cell["This adds 1 to the last result. ", "MathCaption",
 CellID->12537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "+", "1"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->11560],

Cell[BoxData["5930"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->31349]
}, Open  ]],

Cell["This uses both the last result, and the result before that. ", \
"MathCaption",
 CellID->10923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "%"}], "+", 
  RowBox[{"%", "^", "2"}], "+", "%%"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->30883],

Cell[BoxData["35188619"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->15905]
}, Open  ]],

Cell[TextData[{
 "You will have noticed that all the input and output lines in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are numbered. You can use these numbers to refer to previous results. "
}], "Text",
 CellID->15847],

Cell[TextData[{
 "This adds the results on lines ",
 Cell[BoxData["2"], "InlineFormula"],
 " and ",
 Cell[BoxData["3"], "InlineFormula"],
 " above. "
}], "MathCaption",
 CellID->29313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%2", "+", "%3"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->2786],

Cell[BoxData["35194549"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->26984]
}, Open  ]],

Cell[TextData[{
 "If you use a text\[Hyphen]based interface to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then successive input and output lines will always appear in order. \
However, if you use a notebook interface to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", as discussed in \"",
 ButtonBox["Notebook Interfaces",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NotebookInterfaces"],
 "\", then successive input and output lines need not appear in order. You \
can for example \[OpenCurlyDoubleQuote]scroll back\[CloseCurlyDoubleQuote] \
and insert your next calculation wherever you want in the notebook. You \
should realize that ",
 Cell[BoxData["%"], "InlineFormula"],
 " is always defined to be the last result that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " generated. This may or may not be the result that appears immediately \
above your present position in the notebook. With a notebook interface, the \
only way to tell when a particular result was generated is to look at the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " label that it has. Because you can insert and delete anywhere in a \
notebook, the textual ordering of results in a notebook need have no relation \
to the order in which the results were generated. "
}], "Text",
 CellID->14409],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->102205859],

Cell[TextData[ButtonBox["Building Up Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BuildingUpCalculationsOverview"]], "RelatedTutorials",
 CellID->71949343]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Using Previous Results - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Building Up Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/BuildingUpCalculationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DefiningVariables"]}], "Text",
       FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 44.9398232}", "context" -> "", 
    "keywords" -> {
     "%%", "%", "copying", "current expression", "history", "In", 
      "input lines", "labels", "last result", "line numbers", "lines", 
      "notebooks", "Out", "output lines", "percent", "percent", 
      "previous results", "results", "reviewing results", "script files", 
      "scrolling back"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In doing calculations, you will often need to use previous results that \
you have got. In Mathematica, % always stands for your last result. Ways to \
refer to your previous results. Here is the first result. ", 
    "synonyms" -> {"1.2.1", "%2", "%3"}, "title" -> "Using Previous Results", 
    "type" -> "Tutorial", "uri" -> "tutorial/UsingPreviousResults"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.2.1"->{
  Cell[1793, 57, 82, 2, 70, "Title",
   CellTags->{"S1.2.1", "1.1"},
   CellID->70]},
 "1.1"->{
  Cell[1793, 57, 82, 2, 70, "Title",
   CellTags->{"S1.2.1", "1.1"},
   CellID->70]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.2.1", 9355, 301},
 {"1.1", 9451, 305}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1168, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1793, 57, 82, 2, 70, "Title",
 CellTags->{"S1.2.1", "1.1"},
 CellID->70],
Cell[1878, 61, 274, 9, 70, "Text",
 CellID->11183],
Cell[2155, 72, 1234, 35, 70, "DefinitionBox",
 CellID->6345],
Cell[3392, 109, 74, 1, 70, "Caption",
 CellID->9328],
Cell[3469, 112, 65, 1, 70, "MathCaption",
 CellID->26059],
Cell[CellGroupData[{
Cell[3559, 117, 89, 3, 28, "Input",
 CellID->7483],
Cell[3651, 122, 158, 5, 36, "Output",
 CellID->19221]
}, Open  ]],
Cell[3824, 130, 71, 1, 70, "MathCaption",
 CellID->12537],
Cell[CellGroupData[{
Cell[3920, 135, 89, 3, 28, "Input",
 CellID->11560],
Cell[4012, 140, 158, 5, 36, "Output",
 CellID->31349]
}, Open  ]],
Cell[4185, 148, 101, 2, 70, "MathCaption",
 CellID->10923],
Cell[CellGroupData[{
Cell[4311, 154, 141, 5, 70, "Input",
 CellID->30883],
Cell[4455, 161, 162, 5, 36, "Output",
 CellID->15905]
}, Open  ]],
Cell[4632, 169, 233, 6, 70, "Text",
 CellID->15847],
Cell[4868, 177, 184, 7, 70, "MathCaption",
 CellID->29313],
Cell[CellGroupData[{
Cell[5077, 188, 90, 3, 70, "Input",
 CellID->2786],
Cell[5170, 193, 162, 5, 36, "Output",
 CellID->26984]
}, Open  ]],
Cell[5347, 201, 1428, 33, 70, "Text",
 CellID->14409],
Cell[CellGroupData[{
Cell[6800, 238, 72, 1, 70, "RelatedTutorialsSection",
 CellID->102205859],
Cell[6875, 241, 178, 4, 70, "RelatedTutorials",
 CellID->71949343]
}, Open  ]]
}, Open  ]],
Cell[7080, 249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

