(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11313,        425]
NotebookOptionsPosition[      6631,        278]
NotebookOutlinePosition[      9299,        346]
CellTagsIndexPosition[      9208,        340]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Algebraic Calculations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/AlgebraicCalculationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Algebraic Calculations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Using Symbols to Tag Objects", "Title",
 CellTags->{"S1.4.10", "10.1"},
 CellID->10234],

Cell[TextData[{
 "There are many ways to use symbols in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Here we use symbols as \
\[OpenCurlyDoubleQuote]tags\[CloseCurlyDoubleQuote] for different types of \
objects. "
}], "Text",
 CellID->12500],

Cell["\<\
Working with physical units gives one simple example. When you specify the \
length of an object, you want to give not only a number, but also the units \
in which the length is measured. In standard notation, you might write a \
length as 12 meters. \
\>", "Text",
 CellID->839],

Cell[TextData[{
 "You can imitate this notation almost directly in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can for example simply use a symbol ",
 Cell[BoxData["meters"], "InlineFormula"],
 " to indicate the units of our measurement. "
}], "Text",
 CellID->21157],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData["meters"], "InlineFormula"],
 " here acts as a tag, which indicates the units used. "
}], "MathCaption",
 CellID->5668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"12", " ", "meters"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->3856],

Cell[BoxData[
 RowBox[{"12", " ", "meters"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4485]
}, Open  ]],

Cell["You can add lengths like this. ", "MathCaption",
 CellID->23592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "+", 
  RowBox[{"5.3", " ", "meters"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->31022],

Cell[BoxData[
 RowBox[{"17.3`", " ", "meters"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->4733]
}, Open  ]],

Cell["This gives a speed. ", "MathCaption",
 CellID->32735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/", 
  RowBox[{"(", 
   RowBox[{"25", " ", "seconds"}], ")"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->11383],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.6920000000000001`", " ", "meters"}], "seconds"]], "Output",
 ImageSize->{89, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->9827]
}, Open  ]],

Cell["This converts to a speed in feet per second. ", "MathCaption",
 CellID->24499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"meters", "->", 
   RowBox[{"3.28084", " ", "feet"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->3061],

Cell[BoxData[
 FractionBox[
  RowBox[{"2.2703412800000002`", " ", "feet"}], "seconds"]], "Output",
 ImageSize->{89, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22090]
}, Open  ]],

Cell[TextData[{
 "There is in fact a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package that allows you to work with units. The package defines many \
symbols that represent standard types of units. "
}], "Text",
 CellID->17135],

Cell[TextData[{
 "Load the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package for handling units. "
}], "MathCaption",
 CellID->12100],

Cell[BoxData[
 RowBox[{"<<", "Units`"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->21479],

Cell["The package uses standardized names for units. ", "MathCaption",
 CellID->26573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"12", " ", 
  RowBox[{"Meter", "/", "Second"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->10906],

Cell[BoxData[
 FractionBox[
  RowBox[{"12", " ", "Meter"}], "Second"]], "Output",
 ImageSize->{61, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->6885]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{"Convert", "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["units", "TI"]}], "]"}]], "InlineFormula"],
 " converts to the specified units. "
}], "MathCaption",
 CellID->17245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convert", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Mile", "/", "Hour"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->13209],

Cell[BoxData[
 FractionBox[
  RowBox[{"37500", " ", "Mile"}], 
  RowBox[{"1397", " ", "Hour"}]]], "Output",
 ImageSize->{77, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->25836]
}, Open  ]],

Cell["\<\
Usually you have to give prefixes for units as separate words.\
\>", "MathCaption",
 CellID->19981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convert", "[", 
  RowBox[{
   RowBox[{"3", " ", "Kilo", " ", 
    RowBox[{"Meter", "/", "Hour"}]}], ",", 
   RowBox[{"Inch", "/", "Minute"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->20939],

Cell[BoxData[
 FractionBox[
  RowBox[{"250000", " ", "Inch"}], 
  RowBox[{"127", " ", "Minute"}]]], "Output",
 ImageSize->{84, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->9699]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->657063021],

Cell[TextData[ButtonBox["Algebraic Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicCalculationsOverview"]], "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Using Symbols to Tag Objects - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheLimitsOfMathematica"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 45.4242106}", "context" -> "", 
    "keywords" -> {
     "conversion", "convert", "dimensions", "measures", "symbols", 
      "tagged data", "units"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "There are many ways to use symbols in Mathematica. Here we use symbols \
as 'tags' for different types of objects. Working with physical units gives \
one simple example. When you specify the length of an object, you want to \
give not only a number, but also the units in which the length is measured. \
In standard notation, you might write a length as 12 meters. You can imitate \
this notation almost directly in Mathematica. You can for example simply use \
a symbol meters to indicate the units of our measurement. ", 
    "synonyms" -> {"1.4.10"}, "title" -> "Using Symbols to Tag Objects", 
    "type" -> "Tutorial", "uri" -> "tutorial/UsingSymbolsToTagObjects"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.4.10"->{
  Cell[1266, 43, 93, 2, 70, "Title",
   CellTags->{"S1.4.10", "10.1"},
   CellID->10234]},
 "10.1"->{
  Cell[1266, 43, 93, 2, 70, "Title",
   CellTags->{"S1.4.10", "10.1"},
   CellID->10234]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.4.10", 8992, 329},
 {"10.1", 9094, 333}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 93, 2, 70, "Title",
 CellTags->{"S1.4.10", "10.1"},
 CellID->10234],
Cell[1362, 47, 252, 8, 70, "Text",
 CellID->12500],
Cell[1617, 57, 289, 6, 70, "Text",
 CellID->839],
Cell[1909, 65, 283, 8, 70, "Text",
 CellID->21157],
Cell[2195, 75, 165, 5, 70, "MathCaption",
 CellID->5668],
Cell[CellGroupData[{
Cell[2385, 84, 94, 3, 28, "Input",
 CellID->3856],
Cell[2482, 89, 182, 6, 36, "Output",
 CellID->4485]
}, Open  ]],
Cell[2679, 98, 70, 1, 70, "MathCaption",
 CellID->23592],
Cell[CellGroupData[{
Cell[2774, 103, 119, 4, 28, "Input",
 CellID->31022],
Cell[2896, 109, 185, 6, 36, "Output",
 CellID->4733]
}, Open  ]],
Cell[3096, 118, 59, 1, 70, "MathCaption",
 CellID->32735],
Cell[CellGroupData[{
Cell[3180, 123, 143, 5, 70, "Input",
 CellID->11383],
Cell[3326, 130, 226, 7, 51, "Output",
 CellID->9827]
}, Open  ]],
Cell[3567, 140, 84, 1, 70, "MathCaption",
 CellID->24499],
Cell[CellGroupData[{
Cell[3676, 145, 151, 5, 70, "Input",
 CellID->3061],
Cell[3830, 152, 225, 7, 51, "Output",
 CellID->22090]
}, Open  ]],
Cell[4070, 162, 240, 7, 70, "Text",
 CellID->17135],
Cell[4313, 171, 146, 6, 70, "MathCaption",
 CellID->12100],
Cell[4462, 179, 90, 3, 70, "Input",
 CellID->21479],
Cell[4555, 184, 86, 1, 70, "MathCaption",
 CellID->26573],
Cell[CellGroupData[{
Cell[4666, 189, 122, 4, 70, "Input",
 CellID->10906],
Cell[4791, 195, 207, 7, 51, "Output",
 CellID->6885]
}, Open  ]],
Cell[5013, 205, 251, 9, 70, "MathCaption",
 CellID->17245],
Cell[CellGroupData[{
Cell[5289, 218, 153, 5, 70, "Input",
 CellID->13209],
Cell[5445, 225, 234, 8, 52, "Output",
 CellID->25836]
}, Open  ]],
Cell[5694, 236, 109, 3, 70, "MathCaption",
 CellID->19981],
Cell[CellGroupData[{
Cell[5828, 243, 224, 7, 70, "Input",
 CellID->20939],
Cell[6055, 252, 235, 8, 52, "Output",
 CellID->9699]
}, Open  ]],
Cell[CellGroupData[{
Cell[6327, 265, 72, 1, 70, "RelatedTutorialsSection",
 CellID->657063021],
Cell[6402, 268, 175, 4, 70, "RelatedTutorials",
 CellID->20816390]
}, Open  ]]
}, Open  ]],
Cell[6604, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

