(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36788,       1371]
NotebookOptionsPosition[     27828,       1083]
NotebookOutlinePosition[     31345,       1164]
CellTagsIndexPosition[     31252,       1158]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Modularity and the Naming of Things\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function" :> Documentation`HelpLookup["paclet:ref/Function"], 
          "Module" :> Documentation`HelpLookup["paclet:ref/Module"], "With" :> 
          Documentation`HelpLookup["paclet:ref/With"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function\"\>", 2->"\<\"Module\"\>", 
       3->"\<\"With\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Variables in Pure Functions and Rules", "Title",
 CellTags->{"S2.7.4", "4.1"},
 CellID->1131],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " allow you to give a specific list of symbols whose names you want to treat \
as local. In some situations, however, you want to automatically treat \
certain symbol names as local. "
}], "Text",
 CellID->19570],

Cell[TextData[{
 "For example, if you use a pure function such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"x", "+", "a"}]}], "]"}]], "InlineFormula"],
 ", you want ",
 Cell[BoxData["x"], "InlineFormula"],
 " to be treated as a \[OpenCurlyDoubleQuote]formal parameter\
\[CloseCurlyDoubleQuote], whose specific name is local. The same is true of \
the ",
 Cell[BoxData["x"], "InlineFormula"],
 " that appears in a rule like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "->", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 ", or a definition like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->23754],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a uniform scheme to make sure that the names of formal parameters \
which appear in constructs like pure functions and rules are kept local, and \
are never confused with global names. The basic idea is to replace formal \
parameters when necessary by symbols with names of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "$"}]]], "InlineFormula"],
 ". By convention, ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "$"}]]], "InlineFormula"],
 " is never used as a global name. "
}], "Text",
 CellID->23535],

Cell["Here is a nested pure function. ", "MathCaption",
 CellID->20903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "y", "}"}], ",", 
     RowBox[{"x", "+", "y"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19445],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "y", "}"}], ",", 
     RowBox[{"x", "+", "y"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27609]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " renames the formal parameter ",
 Cell[BoxData["y"], "InlineFormula"],
 " in the inner function to avoid conflict with the global object ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"2", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->26032],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "y$", "}"}], ",", 
   RowBox[{
    RowBox[{"2", " ", "y"}], "+", "y$"}]}], "]"}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->22917]
}, Open  ]],

Cell["The resulting pure function behaves as it should. ", "MathCaption",
 CellID->11630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "a", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->25318],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"2", " ", "y"}]}]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->12432]
}, Open  ]],

Cell[TextData[{
 "In general, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " renames the formal parameters in an object like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"], "[", 
   RowBox[{
    StyleBox["vars", "TI"], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " whenever ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 " is modified in any way by the action of another pure function. "
}], "Text",
 CellID->14413],

Cell[TextData[{
 "The formal parameter ",
 Cell[BoxData["y"], "InlineFormula"],
 " is renamed because the body of the inner pure function was changed. "
}], "MathCaption",
 CellID->24090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "y", "}"}], ",", 
      RowBox[{"x", "+", "y"}]}], "]"}]}], "]"}], "[", "a", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->18461],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "y$", "}"}], ",", 
   RowBox[{"a", "+", "y$"}]}], "]"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->132]
}, Open  ]],

Cell["\<\
Since the body of the inner function does not change, the formal parameter is \
not renamed. \
\>", "MathCaption",
 CellID->6635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"x", "+", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "y", "}"}], ",", 
       RowBox[{"y", "^", "2"}]}], "]"}]}]}], "]"}], "[", "a", "]"}]], "Input",\

 CellLabel->"In[5]:= ",
 CellID->21517],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "y", "}"}], ",", 
    SuperscriptBox["y", "2"]}], "]"}]}]], "Output",
 ImageSize->{139, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->26645]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " renames formal parameters in pure functions more liberally than is \
strictly necessary. In principle, renaming could be avoided if the names of \
the formal parameters in a particular function do not actually conflict with \
parts of expressions substituted into the body of the pure function. For \
uniformity, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " still renames formal parameters even in such cases. "
}], "Text",
 CellID->9321],

Cell[TextData[{
 "In this case, the formal parameter ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the inner function shields the body of the function, so no renaming is \
needed."
}], "MathCaption",
 CellID->1818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"x", "+", "y"}]}], "]"}]}], "]"}], "[", "a", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->21805],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->4333]
}, Open  ]],

Cell["Here are three nested functions. ", "MathCaption",
 CellID->4721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "y", "}"}], ",", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "z", "}"}], ",", 
       RowBox[{"x", "+", "y", "+", "z"}]}], "]"}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[7]:= ",
 CellID->15246],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "y", "}"}], ",", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "z", "}"}], ",", 
       RowBox[{"x", "+", "y", "+", "z"}]}], "]"}]}], "]"}]}], "]"}]], "Output",\

 ImageSize->{357, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->4970]
}, Open  ]],

Cell["Both inner functions are renamed in this case. ", "MathCaption",
 CellID->15788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "a", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->26394],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "y$", "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "z$", "}"}], ",", 
     RowBox[{"a", "+", "y$", "+", "z$"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->31008]
}, Open  ]],

Cell[TextData[{
 "As mentioned in\[NonBreakingSpace]\"",
 ButtonBox["Pure Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PureFunctions"],
 "\", pure functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are like ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " expressions in formal logic. The renaming of formal parameters allows ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pure functions to reproduce all the semantics of standard ",
 Cell[BoxData[
  FormBox["\[Lambda]", TraditionalForm]], "InlineMath"],
 " expressions faithfully. "
}], "Text",
 CellID->17227],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Function",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Function"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell["local parameters", "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], Cell[
     " \[ThinSpace]and \[ThinSpace]", "TableText"], 
     StyleBox["lhs", "TI"], ":>", 
     StyleBox["rhs", "TI"]}], Cell["local pattern names", "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], "=", 
     StyleBox["rhs", "TI"], Cell[
     " \[ThinSpace]and \[ThinSpace]", "TableText"], 
     StyleBox["lhs", "TI"], ":=", 
     StyleBox["rhs", "TI"]}], Cell["local pattern names", "TableText"]},
   {
    RowBox[{
     ButtonBox["With",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/With"], "[", "{", 
     StyleBox["x", "TI"], "=", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell["local constants", "TableText"]},
   {
    RowBox[{
     ButtonBox["Module",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Module"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["body", "TI"], "]"}], Cell["local variables", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8835],

Cell[TextData[{
 "Scoping constructs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->20577],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has several \[OpenCurlyDoubleQuote]scoping constructs\
\[CloseCurlyDoubleQuote] in which certain names are treated as local. When \
you mix these constructs in any way, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does appropriate renamings to avoid conflicts. "
}], "Text",
 CellID->5675],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " renames the formal parameter of the pure function to avoid a conflict. "
}], "MathCaption",
 CellID->205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "a"}], "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"a", "+", "x"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->20050],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "a$", "}"}], ",", 
   RowBox[{"a$", "+", "a"}]}], "]"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->14642]
}, Open  ]],

Cell[TextData[{
 "Here the local constant in the inner ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is renamed to avoid a conflict. "
}], "MathCaption",
 CellID->19254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "y"}], "}"}], ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", "=", "4"}], "}"}], ",", 
      RowBox[{"x", "+", "y"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->30318],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"y$", "=", "4"}], "}"}], ",", 
    RowBox[{"y", "+", "y$"}]}], "]"}], "]"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->1390]
}, Open  ]],

Cell["\<\
There is no conflict between names in this case, so no renaming is done. \
\>", "MathCaption",
 CellID->18724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "y"}], "}"}], ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"z", "=", 
        RowBox[{"x", "+", "2"}]}], "}"}], ",", 
      RowBox[{"z", "+", "2"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->979],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"z", "=", 
      RowBox[{"y", "+", "2"}]}], "}"}], ",", 
    RowBox[{"z", "+", "2"}]}], "]"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->31365]
}, Open  ]],

Cell[TextData[{
 "The local variable ",
 Cell[BoxData["y"], "InlineFormula"],
 " in the module is renamed to avoid a conflict. "
}], "MathCaption",
 CellID->14754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "y"}], "}"}], ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "y", "}"}], ",", 
      RowBox[{"x", "+", "y"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->3171],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "y$", "}"}], ",", 
    RowBox[{"y", "+", "y$"}]}], "]"}], "]"}]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->14022]
}, Open  ]],

Cell["\<\
If you execute the module, however, the local variable is renamed again to \
make its name unique. \
\>", "MathCaption",
 CellID->5844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->17267],

Cell[BoxData[
 RowBox[{"y", "+", "y$1"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->22509]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats transformation rules as scoping constructs, in which the names you \
give to patterns are local. You can set up named patterns either using ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_"}]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "__"}]]], "InlineFormula"],
 " and so on, or using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ":", 
   StyleBox["patt", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->2410],

Cell[TextData[{
 "The ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the ",
 Cell[BoxData["h"], "InlineFormula"],
 " goes with the ",
 Cell[BoxData["x_"], "InlineFormula"],
 ", and is considered local to the rule. "
}], "MathCaption",
 CellID->11872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "5"}], "}"}], ",", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x_", ",", "x"}], "]"}], "->", 
    RowBox[{"h", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->16552],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"x_", ",", "5"}], "]"}], "\[Rule]", 
  RowBox[{"h", "[", "x", "]"}]}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->15874]
}, Open  ]],

Cell[TextData[{
 "In a rule like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "->", 
   RowBox[{"x", "+", "y"}]}]], "InlineFormula"],
 ", the ",
 Cell[BoxData["x"], "InlineFormula"],
 " which appears on the right\[Hyphen]hand side goes with the name of the ",
 Cell[BoxData["x_"], "InlineFormula"],
 " pattern. As a result, this ",
 Cell[BoxData["x"], "InlineFormula"],
 " is treated as a variable local to the rule, and cannot be modified by \
other scoping constructs. "
}], "Text",
 CellID->16977],

Cell[TextData[{
 "The ",
 Cell[BoxData["y"], "InlineFormula"],
 ", on the other hand, is not local to the rule, and ",
 StyleBox["can",
  FontSlant->"Italic"],
 " be modified by other scoping constructs. When this happens, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " renames the patterns in the rule to prevent the possibility of a conflict. \
"
}], "Text",
 CellID->13697],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " renames the ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the rule to prevent a conflict. "
}], "MathCaption",
 CellID->15370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"w", "=", "x"}], "}"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], "->", 
    RowBox[{"w", "+", "x"}]}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->9941],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x$_", "]"}], "\[Rule]", 
  RowBox[{"x", "+", "x$"}]}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->20267]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " on a scoping construct, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically performs appropriate renamings. In some cases, however, you \
may want to make substitutions inside scoping constructs, without any \
renaming. You can do this using the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator. "
}], "Text",
 CellID->12341],

Cell[TextData[{
 "When you substitute for ",
 Cell[BoxData["y"], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 ", the ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the pure function is renamed to prevent a conflict. "
}], "MathCaption",
 CellID->617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "=", 
     RowBox[{"x", "+", "a"}]}], "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"x", "+", "y"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->24968],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x$", "}"}], ",", 
   RowBox[{"x$", "+", 
    RowBox[{"(", 
     RowBox[{"a", "+", "x"}], ")"}]}]}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->25065]
}, Open  ]],

Cell[TextData[{
 "If you use ",
 Cell[BoxData["/."], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 ", no such renaming is done. "
}], "MathCaption",
 CellID->27321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"x", "+", "y"}]}], "]"}], "/.", 
  RowBox[{"y", "->", 
   RowBox[{"a", "+", "x"}]}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->18655],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"(", 
     RowBox[{"a", "+", "x"}], ")"}]}]}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->16727]
}, Open  ]],

Cell[TextData[{
 "When you apply a rule such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox[
     RowBox[{
      StyleBox["x", "TI"], "_"}]], "]"}], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ", or use a definition such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox[
     RowBox[{
      StyleBox["x", "TI"], "_"}]], "]"}], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " implicitly has to substitute for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " everywhere in the expression ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 ". It effectively does this using the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator. As a result, such substitution does not respect scoping \
constructs. However, when the insides of a scoping construct are modified by \
the substitution, the other variables in the scoping construct are renamed. "
}], "Text",
 CellID->26914],

Cell["This defines a function for creating pure functions. ", "MathCaption",
 CellID->8283],

Cell[BoxData[
 RowBox[{
  RowBox[{"mkfun", "[", 
   RowBox[{"var_", ",", "body_"}], "]"}], ":=", 
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "var", "}"}], ",", "body"}], "]"}]}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->2137],

Cell[TextData[{
 "The ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"x", "^", "2"}]], "InlineFormula"],
 " are explicitly inserted into the pure function, effectively by using the \
",
 Cell[BoxData["/."], "InlineFormula"],
 " operator. "
}], "MathCaption",
 CellID->6932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mkfun", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->26549],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   SuperscriptBox["x", "2"]}], "]"}]], "Output",
 ImageSize->{119, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->1162]
}, Open  ]],

Cell["\<\
This defines a function that creates a pair of nested pure functions. \
\>", "MathCaption",
 CellID->12882],

Cell[BoxData[
 RowBox[{
  RowBox[{"mkfun2", "[", 
   RowBox[{"var_", ",", "body_"}], "]"}], ":=", 
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "var", "}"}], ",", 
      RowBox[{"body", "+", "x"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->14035],

Cell[TextData[{
 "The ",
 Cell[BoxData["x"], "InlineFormula"],
 " in the outer pure function is renamed in this case. "
}], "MathCaption",
 CellID->28592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mkfun2", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->25135],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "x$", "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "x$"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{255, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->8930]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->646054669],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->23976899],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->255532132],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->275800204]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Variables in Pure Functions and Rules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/HowModulesWork"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/DummyVariablesInMathematics"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 47.8461476}", "context" -> "", 
    "keywords" -> {
     "arguments", "blanks", "bound variables", "formal parameters", 
      "function", "module", "parameters", "passing of arguments", "patterns", 
      "pattern variables", "pure functions", "renaming", "rule", "rules", 
      "scoping", "scoping constructs", "set", "substitution semantics", 
      "transformation rules", "variables", "with"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Module and With allow you to give a specific list of symbols whose names \
you want to treat as local. In some situations, however, you want to \
automatically treat certain symbol names as local. For example, if you use a \
pure function such as Function[{x},x+a], you want x to be treated as a \
'formal parameter', whose specific name is local. The same is true of the x \
that appears in a rule like f[x_]->x^2, or a definition like f[x_]:=x^2. \
Mathematica uses a uniform scheme to make sure that the names of formal \
parameters which appear in constructs like pure functions and rules are kept \
local, and are never confused with global names. The basic idea is to replace \
formal parameters when necessary by symbols with names of the form x$. By \
convention, x$ is never used as a global name. ", "synonyms" -> {"2.7.4"}, 
    "title" -> "Variables in Pure Functions and Rules", "type" -> "Tutorial", 
    "uri" -> "tutorial/VariablesInPureFunctionsAndRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.4"->{
  Cell[2025, 61, 99, 2, 70, "Title",
   CellTags->{"S2.7.4", "4.1"},
   CellID->1131]},
 "4.1"->{
  Cell[2025, 61, 99, 2, 70, "Title",
   CellTags->{"S2.7.4", "4.1"},
   CellID->1131]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.4", 31043, 1147},
 {"4.1", 31141, 1151}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1400, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2025, 61, 99, 2, 70, "Title",
 CellTags->{"S2.7.4", "4.1"},
 CellID->1131],
Cell[2127, 65, 465, 14, 70, "Text",
 CellID->19570],
Cell[2595, 81, 860, 28, 70, "Text",
 CellID->23754],
Cell[3458, 111, 627, 18, 70, "Text",
 CellID->23535],
Cell[4088, 131, 71, 1, 70, "MathCaption",
 CellID->20903],
Cell[CellGroupData[{
Cell[4184, 136, 261, 9, 28, "Input",
 CellID->19445],
Cell[4448, 147, 350, 12, 36, "Output",
 CellID->27609]
}, Open  ]],
Cell[4813, 162, 285, 9, 70, "MathCaption",
 CellID->15414],
Cell[CellGroupData[{
Cell[5123, 175, 112, 4, 28, "Input",
 CellID->26032],
Cell[5238, 181, 288, 10, 36, "Output",
 CellID->22917]
}, Open  ]],
Cell[5541, 194, 89, 1, 70, "MathCaption",
 CellID->11630],
Cell[CellGroupData[{
Cell[5655, 199, 94, 3, 70, "Input",
 CellID->25318],
Cell[5752, 204, 200, 7, 36, "Output",
 CellID->12432]
}, Open  ]],
Cell[5967, 214, 528, 18, 70, "Text",
 CellID->14413],
Cell[6498, 234, 187, 5, 70, "MathCaption",
 CellID->24090],
Cell[CellGroupData[{
Cell[6710, 243, 295, 10, 70, "Input",
 CellID->18461],
Cell[7008, 255, 261, 9, 36, "Output",
 CellID->132]
}, Open  ]],
Cell[7284, 267, 139, 4, 70, "MathCaption",
 CellID->6635],
Cell[CellGroupData[{
Cell[7448, 275, 326, 12, 70, "Input",
 CellID->21517],
Cell[7777, 289, 288, 10, 39, "Output",
 CellID->26645]
}, Open  ]],
Cell[8080, 302, 525, 12, 70, "Text",
 CellID->9321],
Cell[8608, 316, 215, 6, 70, "MathCaption",
 CellID->1818],
Cell[CellGroupData[{
Cell[8848, 326, 295, 10, 70, "Input",
 CellID->21805],
Cell[9146, 338, 260, 9, 36, "Output",
 CellID->4333]
}, Open  ]],
Cell[9421, 350, 71, 1, 70, "MathCaption",
 CellID->4721],
Cell[CellGroupData[{
Cell[9517, 355, 368, 13, 70, "Input",
 CellID->15246],
Cell[9888, 370, 456, 16, 36, "Output",
 CellID->4970]
}, Open  ]],
Cell[10359, 389, 86, 1, 70, "MathCaption",
 CellID->15788],
Cell[CellGroupData[{
Cell[10470, 394, 94, 3, 70, "Input",
 CellID->26394],
Cell[10567, 399, 364, 12, 36, "Output",
 CellID->31008]
}, Open  ]],
Cell[10946, 414, 635, 19, 70, "Text",
 CellID->17227],
Cell[11584, 435, 1746, 50, 70, "DefinitionBox",
 CellID->8835],
Cell[13333, 487, 128, 6, 70, "Caption",
 CellID->20577],
Cell[13464, 495, 367, 10, 70, "Text",
 CellID->5675],
Cell[13834, 507, 173, 5, 70, "MathCaption",
 CellID->205],
Cell[CellGroupData[{
Cell[14032, 516, 282, 10, 70, "Input",
 CellID->20050],
Cell[14317, 528, 263, 9, 36, "Output",
 CellID->14642]
}, Open  ]],
Cell[14595, 540, 240, 8, 70, "MathCaption",
 CellID->19254],
Cell[CellGroupData[{
Cell[14860, 552, 343, 12, 70, "Input",
 CellID->30318],
Cell[15206, 566, 319, 11, 36, "Output",
 CellID->1390]
}, Open  ]],
Cell[15540, 580, 120, 3, 70, "MathCaption",
 CellID->18724],
Cell[CellGroupData[{
Cell[15685, 587, 370, 13, 70, "Input",
 CellID->979],
Cell[16058, 602, 345, 12, 36, "Output",
 CellID->31365]
}, Open  ]],
Cell[16418, 617, 163, 5, 70, "MathCaption",
 CellID->14754],
Cell[CellGroupData[{
Cell[16606, 626, 316, 11, 70, "Input",
 CellID->3171],
Cell[16925, 639, 296, 10, 36, "Output",
 CellID->14022]
}, Open  ]],
Cell[17236, 652, 145, 4, 70, "MathCaption",
 CellID->5844],
Cell[CellGroupData[{
Cell[17406, 660, 105, 3, 70, "Input",
 CellID->17267],
Cell[17514, 665, 180, 6, 36, "Output",
 CellID->22509]
}, Open  ]],
Cell[17709, 674, 570, 21, 70, "Text",
 CellID->2410],
Cell[18282, 697, 250, 9, 70, "MathCaption",
 CellID->11872],
Cell[CellGroupData[{
Cell[18557, 710, 282, 10, 70, "Input",
 CellID->16552],
Cell[18842, 722, 266, 9, 36, "Output",
 CellID->15874]
}, Open  ]],
Cell[19123, 734, 518, 15, 70, "Text",
 CellID->16977],
Cell[19644, 751, 384, 12, 70, "Text",
 CellID->13697],
Cell[20031, 765, 195, 7, 70, "MathCaption",
 CellID->15370],
Cell[CellGroupData[{
Cell[20251, 776, 250, 9, 70, "Input",
 CellID->9941],
Cell[20504, 787, 238, 8, 36, "Output",
 CellID->20267]
}, Open  ]],
Cell[20757, 798, 495, 15, 70, "Text",
 CellID->12341],
Cell[21255, 815, 347, 12, 70, "MathCaption",
 CellID->617],
Cell[CellGroupData[{
Cell[21627, 831, 309, 11, 70, "Input",
 CellID->24968],
Cell[21939, 844, 315, 11, 36, "Output",
 CellID->25065]
}, Open  ]],
Cell[22269, 858, 266, 10, 70, "MathCaption",
 CellID->27321],
Cell[CellGroupData[{
Cell[22560, 872, 248, 9, 70, "Input",
 CellID->18655],
Cell[22811, 883, 313, 11, 36, "Output",
 CellID->16727]
}, Open  ]],
Cell[23139, 897, 1054, 34, 70, "Text",
 CellID->26914],
Cell[24196, 933, 91, 1, 70, "MathCaption",
 CellID->8283],
Cell[24290, 936, 242, 8, 70, "Input",
 CellID->2137],
Cell[24535, 946, 302, 11, 70, "MathCaption",
 CellID->6932],
Cell[CellGroupData[{
Cell[24862, 961, 146, 5, 70, "Input",
 CellID->26549],
Cell[25011, 968, 262, 9, 39, "Output",
 CellID->1162]
}, Open  ]],
Cell[25288, 980, 117, 3, 70, "MathCaption",
 CellID->12882],
Cell[25408, 985, 361, 12, 70, "Input",
 CellID->14035],
Cell[25772, 999, 154, 5, 70, "MathCaption",
 CellID->28592],
Cell[CellGroupData[{
Cell[25951, 1008, 147, 5, 70, "Input",
 CellID->25135],
Cell[26101, 1015, 380, 13, 39, "Output",
 CellID->8930]
}, Open  ]],
Cell[CellGroupData[{
Cell[26518, 1033, 72, 1, 70, "RelatedTutorialsSection",
 CellID->646054669],
Cell[26593, 1036, 200, 5, 70, "RelatedTutorials",
 CellID->405226890]
}, Open  ]],
Cell[CellGroupData[{
Cell[26830, 1046, 97, 1, 70, "TutorialRelatedLinksSection",
 CellID->23976899],
Cell[26930, 1049, 414, 13, 70, "TutorialRelatedLinks",
 CellID->255532132],
Cell[27347, 1064, 427, 13, 70, "TutorialRelatedLinks",
 CellID->275800204]
}, Open  ]]
}, Open  ]],
Cell[27801, 1081, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

