(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17036,        676]
NotebookOptionsPosition[     12680,        528]
NotebookOutlinePosition[     14057,        566]
CellTagsIndexPosition[     14014,        563]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Norm" :> Documentation`HelpLookup["paclet:ref/Norm"], 
         "Normalize" :> Documentation`HelpLookup["paclet:ref/Normalize"], 
         "Orthogonalize" :> 
         Documentation`HelpLookup["paclet:ref/Orthogonalize"], "Part" :> 
         Documentation`HelpLookup["paclet:ref/Part"], "Projection" :> 
         Documentation`HelpLookup["paclet:ref/Projection"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Norm\"\>", 2->"\<\"Normalize\"\>", 
      3->"\<\"Orthogonalize\"\>", 4->"\<\"Part\"\>", 
      5->"\<\"Projection\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Vector Operations", "Title",
 CellID->509267359],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      StyleBox["v", "TI"], "[", 
      RowBox[{"[", 
       StyleBox["i", "TI"], "]"}], "]"}], Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     RowBox[{
      ButtonBox["Part",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Part"], "[", 
      RowBox[{
       StyleBox["v", "TI"], ",", 
       StyleBox["i", "TI"]}], "]"}]}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element in the vector ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["c", "TI"], " ", 
     StyleBox["v", "TI"]}], Cell[TextData[{
     "scalar multiplication of ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " times the vector ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["u", "TI"], ".", 
     StyleBox["v", "TI"]}], Cell["dot product of two vectors", "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["v", "TI"], "]"}], Cell[TextData[{
     "give the norm of ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Normalize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Normalize"], "[", 
     StyleBox["v", "TI"], "]"}], Cell[TextData[{
     "give a unit vector in in the direction of ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2096742444],

Cell["Basic vector operations.", "Caption",
 CellID->1891092685],

Cell["This is a vector in three dimensions.", "MathCaption",
 CellID->250229237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", " ", "=", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "2"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137065841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384141049]
}, Open  ]],

Cell[TextData[{
 "This gives a vector ",
 Cell[BoxData[Cell["u", "InlineFormula"]], "InlineFormula"],
 " in the direction opposite to ",
 Cell[BoxData["v"], "InlineFormula"],
 " with twice the magnitude."
}], "MathCaption",
 CellID->296820217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", " ", "=", " ", 
  RowBox[{
   RowBox[{"-", "2"}], " ", "v"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3124989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "6"}], ",", 
   RowBox[{"-", "4"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->779950190]
}, Open  ]],

Cell[TextData[{
 "This reassigns the first component of ",
 Cell[BoxData["u"], "InlineFormula"],
 " to be its negative."
}], "MathCaption",
 CellID->664550638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"[", "1", "]"}], "]"}], " ", "=", " ", 
   RowBox[{"-", 
    RowBox[{"u", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";", " ", "u"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->180048426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"-", "6"}], ",", 
   RowBox[{"-", "4"}]}], "}"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->522856007]
}, Open  ]],

Cell[TextData[{
 "This gives the dot product of ",
 Cell[BoxData["u"], "InlineFormula"],
 " and ",
 Cell[BoxData["v"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->273564590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", ".", "v"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->619350674],

Cell[BoxData[
 RowBox[{"-", "24"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->209786678]
}, Open  ]],

Cell[TextData[{
 "This is the norm of ",
 Cell[BoxData["v"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->510933053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "v", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->283143585],

Cell[BoxData[
 SqrtBox["14"]], "Output",
 ImageSize->{35, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->343774443]
}, Open  ]],

Cell[TextData[{
 "This is the unit vector in the same direction as ",
 Cell[BoxData["v"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->732644467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normalize", "[", "v", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->366735156],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox["14"]], ",", 
   FractionBox["3", 
    SqrtBox["14"]], ",", 
   SqrtBox[
    FractionBox["2", "7"]]}], "}"}]], "Output",
 ImageSize->{142, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->560654453]
}, Open  ]],

Cell["This verifies that the norm is 1.", "MathCaption",
 CellID->88077450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->552582269],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->136936007]
}, Open  ]],

Cell["\<\
Two vectors are orthogonal if their dot product is zero. A set of vectors is \
orthonormal if they are all unit vectors and are pairwise orthogonal.\
\>", "Text",
 CellID->365126883],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Projection",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Projection"], "[", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["v", "TI"]}], "]"}], Cell[TextData[{
     "give the orthogonal projection of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " onto ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Orthogonalize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Orthogonalize"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         RowBox[{
          StyleBox["2", "TR"], ","}]], 
        StyleBox["\[Ellipsis]", "TR"]}]}], "}"}], "]"}], Cell[
    "generate an orthonormal set from the given list of vectors", 
     "TableText"]}
  }]], "DefinitionBox",
 CellID->272045044],

Cell["Orthogonal vector operations.", "Caption",
 CellID->775250595],

Cell[TextData[{
 "This gives the projection of ",
 Cell[BoxData["u"], "InlineFormula"],
 " onto ",
 Cell[BoxData["v"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->508512167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{"Projection", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1950942664],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["12", "7"]}], ",", 
   RowBox[{"-", 
    FractionBox["36", "7"]}], ",", 
   RowBox[{"-", 
    FractionBox["24", "7"]}]}], "}"}]], "Output",
 ImageSize->{118, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->430980345]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["p"], "InlineFormula"],
 " is a scalar multiple of ",
 Cell[BoxData["v"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->891052950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "/", "v"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1799958882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["12", "7"]}], ",", 
   RowBox[{"-", 
    FractionBox["12", "7"]}], ",", 
   RowBox[{"-", 
    FractionBox["12", "7"]}]}], "}"}]], "Output",
 ImageSize->{118, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->22875208]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"u", "-", "p"}]], "InlineFormula"],
 " is orthogonal to ",
 Cell[BoxData["v"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->97930175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"u", " ", "-", " ", "p"}], ")"}], ".", "v"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->270361038],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->149256970]
}, Open  ]],

Cell[TextData[{
 "Starting from the set of vectors ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"u", ",", "v"}], "}"}]], "InlineFormula"],
 ", this finds an orthonormal set of two vectors."
}], "MathCaption",
 CellID->11548385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Orthogonalize", "[", 
  RowBox[{"{", 
   RowBox[{"u", ",", "v"}], "}"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->104219121],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["14"]], ",", 
     RowBox[{"-", 
      FractionBox["3", 
       SqrtBox["14"]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "7"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      FractionBox["13", "14"]], ",", 
     FractionBox["3", 
      SqrtBox["182"]], ",", 
     SqrtBox[
      FractionBox["2", "91"]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{337, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->95116554]
}, Open  ]],

Cell["\<\
When one of the vectors is linearly dependent on the vectors preceding it, \
the corresponding position in the result will be a zero vector.\
\>", "MathCaption",
 CellID->129368987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Orthogonalize", "[", 
  RowBox[{"{", 
   RowBox[{"v", ",", " ", "p", ",", " ", "u"}], "}"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->308146159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SqrtBox["14"]], ",", 
     FractionBox["3", 
      SqrtBox["14"]], ",", 
     SqrtBox[
      FractionBox["2", "7"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      FractionBox["13", "14"]], ",", 
     RowBox[{"-", 
      FractionBox["3", 
       SqrtBox["182"]]}], ",", 
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", "91"]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{405, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->241592652]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Vector Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 48.8617986}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Basic vector operations. This is a vector in three dimensions. This \
gives a vector u in the direction opposite to v with twice the magnitude.", 
    "synonyms" -> {}, "title" -> "Vector Operations", "type" -> "Tutorial", 
    "uri" -> "tutorial/VectorOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 951, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1576, 47, 54, 1, 70, "Title",
 CellID->509267359],
Cell[1633, 50, 1774, 61, 70, "DefinitionBox",
 CellID->2096742444],
Cell[3410, 113, 64, 1, 70, "Caption",
 CellID->1891092685],
Cell[3477, 116, 80, 1, 70, "MathCaption",
 CellID->250229237],
Cell[CellGroupData[{
Cell[3582, 121, 159, 5, 28, "Input",
 CellID->137065841],
Cell[3744, 128, 213, 7, 36, "Output",
 CellID->384141049]
}, Open  ]],
Cell[3972, 138, 243, 7, 70, "MathCaption",
 CellID->296820217],
Cell[CellGroupData[{
Cell[4240, 149, 142, 5, 28, "Input",
 CellID->3124989],
Cell[4385, 156, 270, 10, 36, "Output",
 CellID->779950190]
}, Open  ]],
Cell[4670, 169, 159, 5, 70, "MathCaption",
 CellID->664550638],
Cell[CellGroupData[{
Cell[4854, 178, 259, 9, 28, "Input",
 CellID->180048426],
Cell[5116, 189, 251, 9, 36, "Output",
 CellID->522856007]
}, Open  ]],
Cell[5382, 201, 180, 7, 70, "MathCaption",
 CellID->273564590],
Cell[CellGroupData[{
Cell[5587, 212, 92, 3, 70, "Input",
 CellID->619350674],
Cell[5682, 217, 176, 6, 36, "Output",
 CellID->209786678]
}, Open  ]],
Cell[5873, 226, 122, 5, 70, "MathCaption",
 CellID->510933053],
Cell[CellGroupData[{
Cell[6020, 235, 100, 3, 70, "Input",
 CellID->283143585],
Cell[6123, 240, 170, 6, 38, "Output",
 CellID->343774443]
}, Open  ]],
Cell[6308, 249, 151, 5, 70, "MathCaption",
 CellID->732644467],
Cell[CellGroupData[{
Cell[6484, 258, 105, 3, 70, "Input",
 CellID->366735156],
Cell[6592, 263, 324, 13, 62, "Output",
 CellID->560654453]
}, Open  ]],
Cell[6931, 279, 75, 1, 70, "MathCaption",
 CellID->88077450],
Cell[CellGroupData[{
Cell[7031, 284, 100, 3, 70, "Input",
 CellID->552582269],
Cell[7134, 289, 158, 5, 36, "Output",
 CellID->136936007]
}, Open  ]],
Cell[7307, 297, 192, 4, 70, "Text",
 CellID->365126883],
Cell[7502, 303, 1022, 35, 70, "DefinitionBox",
 CellID->272045044],
Cell[8527, 340, 68, 1, 70, "Caption",
 CellID->775250595],
Cell[8598, 343, 180, 7, 70, "MathCaption",
 CellID->508512167],
Cell[CellGroupData[{
Cell[8803, 354, 164, 5, 70, "Input",
 CellID->1950942664],
Cell[8970, 361, 343, 13, 51, "Output",
 CellID->430980345]
}, Open  ]],
Cell[9328, 377, 165, 6, 70, "MathCaption",
 CellID->891052950],
Cell[CellGroupData[{
Cell[9518, 387, 93, 3, 70, "Input",
 CellID->1799958882],
Cell[9614, 392, 342, 13, 51, "Output",
 CellID->22875208]
}, Open  ]],
Cell[9971, 408, 180, 7, 70, "MathCaption",
 CellID->97930175],
Cell[CellGroupData[{
Cell[10176, 419, 150, 5, 70, "Input",
 CellID->270361038],
Cell[10329, 426, 159, 5, 36, "Output",
 CellID->149256970]
}, Open  ]],
Cell[10503, 434, 227, 7, 70, "MathCaption",
 CellID->11548385],
Cell[CellGroupData[{
Cell[10755, 445, 157, 5, 70, "Input",
 CellID->104219121],
Cell[10915, 452, 615, 25, 62, "Output",
 CellID->95116554]
}, Open  ]],
Cell[11545, 480, 191, 4, 70, "MathCaption",
 CellID->129368987],
Cell[CellGroupData[{
Cell[11761, 488, 177, 5, 70, "Input",
 CellID->308146159],
Cell[11941, 495, 685, 27, 62, "Output",
 CellID->241592652]
}, Open  ]]
}, Open  ]],
Cell[12653, 526, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

