(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49873,       1845]
NotebookOptionsPosition[     39810,       1506]
NotebookOutlinePosition[     42910,       1582]
CellTagsIndexPosition[     42817,       1576]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], "Array" :> 
          Documentation`HelpLookup["paclet:ref/Array"], "Column" :> 
          Documentation`HelpLookup["paclet:ref/Column"], "Cross" :> 
          Documentation`HelpLookup["paclet:ref/Cross"], "Det" :> 
          Documentation`HelpLookup["paclet:ref/Det"], "DiagonalMatrix" :> 
          Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], "Dimensions" :> 
          Documentation`HelpLookup["paclet:ref/Dimensions"], "Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"], "Eigenvectors" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvectors"], 
          "IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"], "Inverse" :> 
          Documentation`HelpLookup["paclet:ref/Inverse"], "Length" :> 
          Documentation`HelpLookup["paclet:ref/Length"], "MatrixForm" :> 
          Documentation`HelpLookup["paclet:ref/MatrixForm"], "MatrixPower" :> 
          Documentation`HelpLookup["paclet:ref/MatrixPower"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Range" :> 
          Documentation`HelpLookup["paclet:ref/Range"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "Tr" :> 
          Documentation`HelpLookup["paclet:ref/Tr"], "Transpose" :> 
          Documentation`HelpLookup["paclet:ref/Transpose"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"All\"\>", 2->"\<\"Array\"\>", 
       3->"\<\"Column\"\>", 4->"\<\"Cross\"\>", 5->"\<\"Det\"\>", 
       6->"\<\"DiagonalMatrix\"\>", 7->"\<\"Dimensions\"\>", 
       8->"\<\"Eigenvalues\"\>", 9->"\<\"Eigenvectors\"\>", 
       10->"\<\"IdentityMatrix\"\>", 11->"\<\"Inverse\"\>", 
       12->"\<\"Length\"\>", 13->"\<\"MatrixForm\"\>", 
       14->"\<\"MatrixPower\"\>", 15->"\<\"Norm\"\>", 16->"\<\"Part\"\>", 
       17->"\<\"Range\"\>", 18->"\<\"Table\"\>", 19->"\<\"Tr\"\>", 
       20->"\<\"Transpose\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Vectors and Matrices", "Title",
 CellTags->{"S1.8.3", "3.1"},
 CellID->2534],

Cell[TextData[{
 "Vectors and matrices in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are simply represented by lists and by lists of lists, respectively. "
}], "Text",
 CellID->17520],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["c", "TI"], "}"}], Cell[TextData[{
     "vector ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"a", ",", "b", ",", "c"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{"{", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", ",", "{", 
     StyleBox["c", "TI"], ",", 
     StyleBox["d", "TI"], "}", "}"}], Cell[TextData[{
     "matrix ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", GridBox[{
          {"a", "b"},
          {"c", "d"}
         }], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17728],

Cell["The representation of vectors and matrices by lists. ", "Caption",
 CellID->29688],

Cell["This is a 2x2 matrix. ", "MathCaption",
 CellID->19724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55309506]
}, Open  ]],

Cell["Here is the first row.", "MathCaption",
 CellID->5603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->152615785]
}, Open  ]],

Cell[TextData[{
 "Here is the element ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", "12"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->12782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20760],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153145472]
}, Open  ]],

Cell["\<\
This is a two\[Hyphen]component vector.\
\>", "MathCaption",
 CellID->31930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1819655]
}, Open  ]],

Cell[TextData[{
 "The objects ",
 Cell[BoxData["p"], "InlineFormula"],
 " and ",
 Cell[BoxData["q"], "InlineFormula"],
 " are treated as scalars."
}], "MathCaption",
 CellID->23322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p", " ", "v"}], "+", "q"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4486],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"q", "+", 
    RowBox[{"p", " ", "x"}]}], ",", 
   RowBox[{"q", "+", 
    RowBox[{"p", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->102493914]
}, Open  ]],

Cell["Vectors are added component by component. ", "MathCaption",
 CellID->14638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "+", 
  RowBox[{"{", 
   RowBox[{"xp", ",", "yp"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"xpp", ",", "ypp"}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->8631],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", "xp", "+", "xpp"}], ",", 
   RowBox[{"y", "+", "yp", "+", "ypp"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->626737950]
}, Open  ]],

Cell["This gives the dot (scalar) product of two vectors.", "MathCaption",
 CellID->6426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{"xp", ",", "yp"}], "}"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->4362],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "xp"}], "+", 
  RowBox[{"y", " ", "yp"}]}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->16412460]
}, Open  ]],

Cell["You can also multiply a matrix by a vector. ", "MathCaption",
 CellID->8378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", "v"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->14419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->330276974]
}, Open  ]],

Cell["Or a matrix by a matrix. ", "MathCaption",
 CellID->8741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", "m"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->25315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{"b", " ", "c"}]}], ",", 
     RowBox[{
      RowBox[{"a", " ", "b"}], "+", 
      RowBox[{"b", " ", "d"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "c"}], "+", 
      RowBox[{"c", " ", "d"}]}], ",", 
     RowBox[{
      RowBox[{"b", " ", "c"}], "+", 
      SuperscriptBox["d", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{258, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->18170913]
}, Open  ]],

Cell["Or a vector by a matrix. ", "MathCaption",
 CellID->21168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", ".", "m"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->11521],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->146019677]
}, Open  ]],

Cell["This combination makes a scalar. ", "MathCaption",
 CellID->19587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", ".", "m", ".", "v"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->20531],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "+", 
     RowBox[{"c", " ", "y"}]}], ")"}]}], "+", 
  RowBox[{"y", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"d", " ", "y"}]}], ")"}]}]}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->373681994]
}, Open  ]],

Cell[TextData[{
 "Because of the way ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses lists to represent vectors and matrices, you never have to \
distinguish between \[OpenCurlyDoubleQuote]row\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]column\[CloseCurlyDoubleQuote] vectors."
}], "Text",
 CellID->8339],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "build a length\[Hyphen]",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vector by evaluating ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " with ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"i", "=", "1"}], ",", "2", ",", "\[Ellipsis]", ",", "n"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "build a length\[Hyphen]",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " vector of the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "[", "1", "]"}], ",", 
         RowBox[{"a", "[", "2", "]"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Range"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "create the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "\[Ellipsis]", ",", "n"}], 
        "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Range"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], "]"}], Cell[TextData[{
     "create the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["n", "1"], ",", 
         RowBox[{
          SubscriptBox["n", "1"], "+", "1"}], ",", "\[Ellipsis]", ",", 
         SubscriptBox["n", "t"]}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Range",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Range"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["dn", "TI"], "]"}], Cell[TextData[{
     "create the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["n", "1"], ",", 
         RowBox[{
          SubscriptBox["n", "1"], "+", 
          RowBox[{"d", "\[InvisibleSpace]", "n"}]}], ",", "\[Ellipsis]", ",", 
         
         SubscriptBox["n", "t"]}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["list", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element in the vector ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Length",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Length"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "give the number of elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Column",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Column",
      ButtonNote->"ObsLink: ColumnForm -> Column"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "display the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " in a column"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["c", "TI"], " ", 
     StyleBox["v", "TI"]}], Cell[
    "multiply a vector by a scalar", "TableText"]},
   {
    RowBox[{
     StyleBox["a", "TI"], ".", 
     StyleBox["b", "TI"]}], Cell["dot product of two vectors", "TableText"]},
   {
    RowBox[{
     ButtonBox["Cross",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cross"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "cross product of two vectors (also input as ",
     Cell[BoxData[
      FormBox[
       RowBox[{"a", "\[Cross]", "b"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["v", "TI"], "]"}], Cell[
    "Euclidean norm of a vector", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, True, False, 
     False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20552],

Cell["Functions for vectors. ", "Caption",
 CellID->26830],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["i", "TI"], ",", 
     StyleBox["m", "TI"], "}", ",", "{", 
     StyleBox["j", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      FormBox[
       RowBox[{"m", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
     " matrix by evaluating ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " with ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     " ranging from ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     " ranging from ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Array"], "[", 
     StyleBox["a", "TI"], ",", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[TextData[{
     "build an ",
     Cell[BoxData[
      FormBox[
       RowBox[{"m", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
     " matrix with",
     " ",
     Cell[BoxData[
      FormBox[
       RowBox[{"i", ",", "j"}], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element ",
     Cell[BoxData[
      FormBox[
       RowBox[{"a", "[", 
        RowBox[{"i", ",", "j"}], "]"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IdentityMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IdentityMatrix"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "generate an ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
     " identity matrix"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DiagonalMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DiagonalMatrix"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "generate a square matrix with the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " on the main diagonal"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["list", "TI"], "[", "[", 
     StyleBox["i", "TI"], "]", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["i", "TI"], "]"}], Cell[TextData[{
     "give the",
     " ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " row in the matrix ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["list", "TI"], "[", "[", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["j", "TI"], "]", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], ",", 
     StyleBox["j", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the",
     " ",
     Cell[BoxData[
      FormBox["j", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " column in the matrix ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["list", "TI"], "[", "[", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]", "]", Cell[
     " \[ThinSpace]or \[ThinSpace]", "TableText"], 
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], "]"}], Cell[TextData[{
     "give the",
     " ",
     Cell[BoxData[
      FormBox[
       RowBox[{"i", ",", "j"}], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element in the matrix ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dimensions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dimensions"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "give the dimensions of a matrix represented by ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixForm"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "display ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " in matrix form"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, {False}, 
     False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20474],

Cell["Functions for matrices. ", "Caption",
 CellID->20781],

Cell[TextData[{
 "This builds a 3x3 matrix ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " with elements ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["s", 
     RowBox[{"i", "\[InvisibleSpace]", "j"}]], "=", "i", "+", "j"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->3742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "+", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->9118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->188997074]
}, Open  ]],

Cell[TextData[{
 "This displays ",
 Cell[BoxData["s"], "InlineFormula"],
 " in standard two\[Hyphen]dimensional matrix format. "
}], "MathCaption",
 CellID->29700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->24234],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "3", "4"},
     {"3", "4", "5"},
     {"4", "5", "6"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]//MatrixForm=",
 CellID->935065]
}, Open  ]],

Cell["\<\
This gives a vector with symbolic elements. You can use this in deriving \
general formulas that are valid with any choice of vector components. \
\>", "MathCaption",
 CellID->10680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"a", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->9790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], ",", 
   RowBox[{"a", "[", "2", "]"}], ",", 
   RowBox[{"a", "[", "3", "]"}], ",", 
   RowBox[{"a", "[", "4", "]"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->233247999]
}, Open  ]],

Cell[TextData[{
 "This gives a 3x2 matrix with symbolic elements. \"",
 ButtonBox["Building Lists from Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/BuildingListsFromFunctions"],
 "\" will discuss how you can produce other kinds of elements with ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"p", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->8168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"3", ",", "1"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"3", ",", "2"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->16707125]
}, Open  ]],

Cell["Here are the dimensions of the matrix on the previous line. ", \
"MathCaption",
 CellID->19634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", "%", "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->25455],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->19866810]
}, Open  ]],

Cell["This generates a 3x3 diagonal matrix. ", "MathCaption",
 CellID->2444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagonalMatrix", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->30708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->25324556]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["c", "TI"], " ", 
     StyleBox["m", "TI"]}], Cell[
    "multiply a matrix by a scalar", "TableText"]},
   {
    RowBox[{
     StyleBox["a", "TI"], ".", 
     StyleBox["b", "TI"]}], Cell[
    "dot product of two matrices", "TableText"]},
   {
    RowBox[{
     ButtonBox["Inverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inverse"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["matrix inverse", "TableText"]},
   {
    RowBox[{
     ButtonBox["MatrixPower",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MatrixPower"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " power of a matrix"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Det",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Det"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["determinant", "TableText"]},
   {
    RowBox[{
     ButtonBox["Tr",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tr"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["trace", "TableText"]},
   {
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["transpose", "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvalues",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvalues"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["eigenvalues", "TableText"]},
   {
    RowBox[{
     ButtonBox["Eigenvectors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Eigenvectors"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["eigenvectors", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25219],

Cell["Some mathematical operations on matrices. ", "Caption",
 CellID->30518],

Cell["\<\
Here is the 2x2 matrix of symbolic variables that was defined above. \
\>", "MathCaption",
 CellID->16349],

Cell[CellGroupData[{

Cell[BoxData["m"], "Input",
 CellLabel->"In[18]:=",
 CellID->28947],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->427385362]
}, Open  ]],

Cell["This gives its determinant. ", "MathCaption",
 CellID->29299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "m", "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->21448],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "b"}], " ", "c"}], "+", 
  RowBox[{"a", " ", "d"}]}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->287052853]
}, Open  ]],

Cell[TextData[{
 "Here is the transpose of ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", "m", "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->29132],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->15889440]
}, Open  ]],

Cell[TextData[{
 "This gives the inverse of ",
 Cell[BoxData["m"], "InlineFormula"],
 " in symbolic form. "
}], "MathCaption",
 CellID->11888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", "m", "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->9770],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["d", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "c"}], "+", 
       RowBox[{"a", " ", "d"}]}]], ",", 
     RowBox[{"-", 
      FractionBox["b", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["c", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", "c"}], "+", 
        RowBox[{"a", " ", "d"}]}]]}], ",", 
     FractionBox["a", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], " ", "c"}], "+", 
       RowBox[{"a", " ", "d"}]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{329, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->377620273]
}, Open  ]],

Cell["Here is a 3x3 rational matrix.", "MathCaption",
 CellID->21433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"i", "+", "j", "-", "1"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[22]:=",
 CellID->15140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "4"], ",", 
     FractionBox["1", "5"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->455468053]
}, Open  ]],

Cell["This gives its inverse. ", "MathCaption",
 CellID->14545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", "h", "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->5540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "36"}], ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "36"}], ",", "192", ",", 
     RowBox[{"-", "180"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", 
     RowBox[{"-", "180"}], ",", "180"}], "}"}]}], "}"}]], "Output",
 ImageSize->{328, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->28385949]
}, Open  ]],

Cell["\<\
Taking the dot product of the inverse with the original matrix gives the \
identity matrix. \
\>", "MathCaption",
 CellID->18250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", "h"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->21082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->61652733]
}, Open  ]],

Cell["Here is a 3x3 matrix. ", "MathCaption",
 CellID->28099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "+", "j", "+", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[25]:=",
 CellID->20050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->5196055]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Eigenvalues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvalues"]], "InlineFormula"],
 " gives the eigenvalues of the matrix. "
}], "MathCaption",
 CellID->8396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "r", "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->28304],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"15", "+", 
      SqrtBox["249"]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"15", "-", 
      SqrtBox["249"]}], ")"}]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{233, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->952869762]
}, Open  ]],

Cell["This gives a numerical approximation to the matrix. ", "MathCaption",
 CellID->18805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rn", "=", 
  RowBox[{"N", "[", "r", "]"}]}]], "Input",
 CellLabel->"In[27]:=",
 CellID->28051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.`", ",", "4.`", ",", "5.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "5.`", ",", "6.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "6.`", ",", "7.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->1056555]
}, Open  ]],

Cell["Here are numerical approximations to the eigenvalues.", "MathCaption",
 CellID->6767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "rn", "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->24370],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"15.389866919029751`", ",", 
   RowBox[{"-", "0.3898669190297496`"}], ",", 
   RowBox[{"-", "1.499553248501123`*^-16"}]}], "}"}]], "Output",
 ImageSize->{251, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->112105837]
}, Open  ]],

Cell[TextData[{
 "\"",
 ButtonBox["Linear Algebra",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LinearAlgebraOverview"],
 "\" discusses many other matrix operations that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->10143],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->51754350],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->292819594],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->18046984]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Vectors and Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MakingTablesOfValues"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GettingPiecesOfLists"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 49.4399384}", "context" -> "", 
    "keywords" -> {
     ".", "array", "columns", "column vectors", "Cross", "Det", 
      "determinants", "DiagonalMatrix", "diagonal matrix", "dimensions", 
      "Dot", "dot product", "Eigenvalues", "Eigenvectors", "format", 
      "Hilbert matrices", "IdentityMatrix", "inner products", "Inverse", 
      "inverse of a matrix", "iota in APL", "length", "lists", "matrices", 
      "MatrixForm", "metric", "multiplication", "norm", 
      "perpendicular vector", "product", "range", "rows", 
      "scalar multiplication", "scalar product", "scalars", "sequence", 
      "shape", "similarity transformation", "size", "symbolic vectors", 
      "table", "transpose", "vector product", "vectors"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Vectors and matrices in Mathematica are simply represented by lists and \
by lists of lists, respectively. The representation of vectors and matrices \
by lists. This is a 2x2 matrix. ", "synonyms" -> {"1.8.3"}, "title" -> 
    "Vectors and Matrices", "type" -> "Tutorial", "uri" -> 
    "tutorial/VectorsAndMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.3"->{
  Cell[3628, 84, 82, 2, 70, "Title",
   CellTags->{"S1.8.3", "3.1"},
   CellID->2534]},
 "3.1"->{
  Cell[3628, 84, 82, 2, 70, "Title",
   CellTags->{"S1.8.3", "3.1"},
   CellID->2534]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.3", 42608, 1565},
 {"3.1", 42706, 1569}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3003, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3628, 84, 82, 2, 70, "Title",
 CellTags->{"S1.8.3", "3.1"},
 CellID->2534],
Cell[3713, 88, 195, 6, 70, "Text",
 CellID->17520],
Cell[3911, 96, 1042, 35, 70, "DefinitionBox",
 CellID->17728],
Cell[4956, 133, 88, 1, 70, "Caption",
 CellID->29688],
Cell[5047, 136, 61, 1, 70, "MathCaption",
 CellID->19724],
Cell[CellGroupData[{
Cell[5133, 141, 237, 9, 28, "Input",
 CellID->26634],
Cell[5373, 152, 301, 11, 36, "Output",
 CellID->55309506]
}, Open  ]],
Cell[5689, 166, 60, 1, 70, "MathCaption",
 CellID->5603],
Cell[CellGroupData[{
Cell[5774, 171, 116, 4, 28, "Input",
 CellID->17125],
Cell[5893, 177, 203, 7, 36, "Output",
 CellID->152615785]
}, Open  ]],
Cell[6111, 187, 168, 7, 70, "MathCaption",
 CellID->12782],
Cell[CellGroupData[{
Cell[6304, 198, 140, 5, 70, "Input",
 CellID->20760],
Cell[6447, 205, 158, 5, 36, "Output",
 CellID->153145472]
}, Open  ]],
Cell[6620, 213, 86, 3, 70, "MathCaption",
 CellID->31930],
Cell[CellGroupData[{
Cell[6731, 220, 135, 5, 70, "Input",
 CellID->28264],
Cell[6869, 227, 201, 7, 36, "Output",
 CellID->1819655]
}, Open  ]],
Cell[7085, 237, 181, 7, 70, "MathCaption",
 CellID->23322],
Cell[CellGroupData[{
Cell[7291, 248, 110, 4, 70, "Input",
 CellID->4486],
Cell[7404, 254, 302, 11, 36, "Output",
 CellID->102493914]
}, Open  ]],
Cell[7721, 268, 81, 1, 70, "MathCaption",
 CellID->14638],
Cell[CellGroupData[{
Cell[7827, 273, 197, 7, 70, "Input",
 CellID->8631],
Cell[8027, 282, 278, 9, 36, "Output",
 CellID->626737950]
}, Open  ]],
Cell[8320, 294, 89, 1, 70, "MathCaption",
 CellID->6426],
Cell[CellGroupData[{
Cell[8434, 299, 183, 7, 70, "Input",
 CellID->4362],
Cell[8620, 308, 227, 8, 36, "Output",
 CellID->16412460]
}, Open  ]],
Cell[8862, 319, 82, 1, 70, "MathCaption",
 CellID->8378],
Cell[CellGroupData[{
Cell[8969, 324, 88, 3, 70, "Input",
 CellID->14419],
Cell[9060, 329, 352, 13, 36, "Output",
 CellID->330276974]
}, Open  ]],
Cell[9427, 345, 63, 1, 70, "MathCaption",
 CellID->8741],
Cell[CellGroupData[{
Cell[9515, 350, 88, 3, 70, "Input",
 CellID->25315],
Cell[9606, 355, 623, 23, 39, "Output",
 CellID->18170913]
}, Open  ]],
Cell[10244, 381, 64, 1, 70, "MathCaption",
 CellID->21168],
Cell[CellGroupData[{
Cell[10333, 386, 89, 3, 70, "Input",
 CellID->11521],
Cell[10425, 391, 353, 13, 36, "Output",
 CellID->146019677]
}, Open  ]],
Cell[10793, 407, 72, 1, 70, "MathCaption",
 CellID->19587],
Cell[CellGroupData[{
Cell[10890, 412, 99, 3, 70, "Input",
 CellID->20531],
Cell[10992, 417, 430, 16, 36, "Output",
 CellID->373681994]
}, Open  ]],
Cell[11437, 436, 325, 8, 70, "Text",
 CellID->8339],
Cell[11765, 446, 5392, 175, 70, "DefinitionBox",
 CellID->20552],
Cell[17160, 623, 58, 1, 70, "Caption",
 CellID->26830],
Cell[17221, 626, 5955, 193, 70, "DefinitionBox",
 CellID->20474],
Cell[23179, 821, 59, 1, 70, "Caption",
 CellID->20781],
Cell[23241, 824, 337, 13, 70, "MathCaption",
 CellID->3742],
Cell[CellGroupData[{
Cell[23603, 841, 281, 10, 70, "Input",
 CellID->9118],
Cell[23887, 853, 392, 13, 36, "Output",
 CellID->188997074]
}, Open  ]],
Cell[24294, 869, 163, 5, 70, "MathCaption",
 CellID->29700],
Cell[CellGroupData[{
Cell[24482, 878, 103, 3, 70, "Input",
 CellID->24234],
Cell[24588, 883, 723, 23, 78, "Output",
 CellID->935065]
}, Open  ]],
Cell[25326, 909, 192, 4, 70, "MathCaption",
 CellID->10680],
Cell[CellGroupData[{
Cell[25543, 917, 120, 4, 70, "Input",
 CellID->9790],
Cell[25666, 923, 341, 11, 36, "Output",
 CellID->233247999]
}, Open  ]],
Cell[26022, 937, 420, 12, 70, "MathCaption",
 CellID->17399],
Cell[CellGroupData[{
Cell[26467, 953, 169, 6, 70, "Input",
 CellID->8168],
Cell[26639, 961, 709, 25, 36, "Output",
 CellID->16707125]
}, Open  ]],
Cell[27363, 989, 101, 2, 70, "MathCaption",
 CellID->19634],
Cell[CellGroupData[{
Cell[27489, 995, 103, 3, 70, "Input",
 CellID->25455],
Cell[27595, 1000, 203, 7, 36, "Output",
 CellID->19866810]
}, Open  ]],
Cell[27813, 1010, 76, 1, 70, "MathCaption",
 CellID->2444],
Cell[CellGroupData[{
Cell[27914, 1015, 164, 5, 70, "Input",
 CellID->30708],
Cell[28081, 1022, 391, 13, 36, "Output",
 CellID->25324556]
}, Open  ]],
Cell[28487, 1038, 2201, 71, 70, "DefinitionBox",
 CellID->25219],
Cell[30691, 1111, 77, 1, 70, "Caption",
 CellID->30518],
Cell[30771, 1114, 116, 3, 70, "MathCaption",
 CellID->16349],
Cell[CellGroupData[{
Cell[30912, 1121, 67, 2, 70, "Input",
 CellID->28947],
Cell[30982, 1125, 303, 11, 36, "Output",
 CellID->427385362]
}, Open  ]],
Cell[31300, 1139, 67, 1, 70, "MathCaption",
 CellID->29299],
Cell[CellGroupData[{
Cell[31392, 1144, 96, 3, 70, "Input",
 CellID->21448],
Cell[31491, 1149, 246, 9, 36, "Output",
 CellID->287052853]
}, Open  ]],
Cell[31752, 1161, 124, 5, 70, "MathCaption",
 CellID->26119],
Cell[CellGroupData[{
Cell[31901, 1170, 102, 3, 70, "Input",
 CellID->29132],
Cell[32006, 1175, 302, 11, 36, "Output",
 CellID->15889440]
}, Open  ]],
Cell[32323, 1189, 142, 5, 70, "MathCaption",
 CellID->11888],
Cell[CellGroupData[{
Cell[32490, 1198, 99, 3, 70, "Input",
 CellID->9770],
Cell[32592, 1203, 879, 33, 52, "Output",
 CellID->377620273]
}, Open  ]],
Cell[33486, 1239, 69, 1, 70, "MathCaption",
 CellID->21433],
Cell[CellGroupData[{
Cell[33580, 1244, 345, 12, 70, "Input",
 CellID->15140],
Cell[33928, 1258, 584, 21, 51, "Output",
 CellID->455468053]
}, Open  ]],
Cell[34527, 1282, 63, 1, 70, "MathCaption",
 CellID->14545],
Cell[CellGroupData[{
Cell[34615, 1287, 99, 3, 70, "Input",
 CellID->5540],
Cell[34717, 1292, 487, 17, 36, "Output",
 CellID->28385949]
}, Open  ]],
Cell[35219, 1312, 139, 4, 70, "MathCaption",
 CellID->18250],
Cell[CellGroupData[{
Cell[35383, 1320, 89, 3, 70, "Input",
 CellID->21082],
Cell[35475, 1325, 391, 13, 36, "Output",
 CellID->61652733]
}, Open  ]],
Cell[35881, 1341, 61, 1, 70, "MathCaption",
 CellID->28099],
Cell[CellGroupData[{
Cell[35967, 1346, 292, 10, 70, "Input",
 CellID->20050],
Cell[36262, 1358, 390, 13, 36, "Output",
 CellID->5196055]
}, Open  ]],
Cell[36667, 1374, 216, 7, 70, "MathCaption",
 CellID->8396],
Cell[CellGroupData[{
Cell[36908, 1385, 104, 3, 70, "Input",
 CellID->28304],
Cell[37015, 1390, 449, 17, 51, "Output",
 CellID->952869762]
}, Open  ]],
Cell[37479, 1410, 91, 1, 70, "MathCaption",
 CellID->18805],
Cell[CellGroupData[{
Cell[37595, 1415, 118, 4, 70, "Input",
 CellID->28051],
Cell[37716, 1421, 408, 13, 36, "Output",
 CellID->1056555]
}, Open  ]],
Cell[38139, 1437, 91, 1, 70, "MathCaption",
 CellID->6767],
Cell[CellGroupData[{
Cell[38255, 1442, 105, 3, 70, "Input",
 CellID->24370],
Cell[38363, 1447, 311, 9, 39, "Output",
 CellID->112105837]
}, Open  ]],
Cell[38689, 1459, 278, 10, 70, "Text",
 CellID->10143],
Cell[CellGroupData[{
Cell[38992, 1473, 71, 1, 70, "RelatedTutorialsSection",
 CellID->51754350],
Cell[39066, 1476, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]],
Cell[CellGroupData[{
Cell[39242, 1484, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->292819594],
Cell[39343, 1487, 413, 13, 70, "TutorialRelatedLinks",
 CellID->18046984]
}, Open  ]]
}, Open  ]],
Cell[39783, 1504, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

