(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8022,        276]
NotebookOptionsPosition[      4729,        179]
NotebookOutlinePosition[      7201,        245]
CellTagsIndexPosition[      7110,        239]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Verbatim" :> 
          Documentation`HelpLookup["paclet:ref/Verbatim"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Verbatim\"\>"}, "\<\"functions\"\>",
        
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Verbatim Patterns", "Title",
 CellTags->{"S2.3.12", "12.1"},
 CellID->30556],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Verbatim",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Verbatim"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "an expression that must be matched verbatim", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17973],

Cell["Verbatim patterns. ", "Caption",
 CellID->27116],

Cell[TextData[{
 "Here the ",
 Cell[BoxData["x_"], "InlineFormula"],
 " in the rule matches any expression. "
}], "MathCaption",
 CellID->11957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "2", "]"}], ",", 
    RowBox[{"f", "[", "a", "]"}], ",", 
    RowBox[{"f", "[", "x_", "]"}], ",", 
    RowBox[{"f", "[", "y_", "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "->", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->28286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   SuperscriptBox["a", "2"], ",", 
   SuperscriptBox["x_", "2"], ",", 
   SuperscriptBox["y_", "2"]}], "}"}]], "Output",
 ImageSize->{111, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27366]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Verbatim",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Verbatim"]], "InlineFormula"],
 " tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that only the exact expression ",
 Cell[BoxData["x_"], "InlineFormula"],
 " should be matched. "
}], "MathCaption",
 CellID->20433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "2", "]"}], ",", 
    RowBox[{"f", "[", "a", "]"}], ",", 
    RowBox[{"f", "[", "x_", "]"}], ",", 
    RowBox[{"f", "[", "y_", "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Verbatim", "[", "x_", "]"}], "]"}], "->", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->10843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "a", "]"}], ",", 
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"f", "[", "y_", "]"}]}], "}"}]], "Output",
 ImageSize->{156, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->30672]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->83591613],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Verbatim Patterns - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RepeatedPatterns"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PatternsForSomeCommonTypesOfExpression"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 45, 50.4243386}", "context" -> "", 
    "keywords" -> {"disabling patterns", "literal patterns", "verbatim"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Verbatim patterns. Here the x_ in the rule matches any expression. The \
Verbatim tells Mathematica that only the exact expression x_ should be \
matched. ", "synonyms" -> {"2.3.12"}, "title" -> "Verbatim Patterns", "type" -> 
    "Tutorial", "uri" -> "tutorial/VerbatimPatterns"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.12"->{
  Cell[1770, 58, 82, 2, 70, "Title",
   CellTags->{"S2.3.12", "12.1"},
   CellID->30556]},
 "12.1"->{
  Cell[1770, 58, 82, 2, 70, "Title",
   CellTags->{"S2.3.12", "12.1"},
   CellID->30556]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.12", 6894, 228},
 {"12.1", 6996, 232}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1145, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1770, 58, 82, 2, 70, "Title",
 CellTags->{"S2.3.12", "12.1"},
 CellID->30556],
Cell[1855, 62, 566, 16, 70, "DefinitionBox",
 CellID->17973],
Cell[2424, 80, 54, 1, 70, "Caption",
 CellID->27116],
Cell[2481, 83, 144, 5, 70, "MathCaption",
 CellID->11957],
Cell[CellGroupData[{
Cell[2650, 92, 357, 12, 28, "Input",
 CellID->28286],
Cell[3010, 106, 298, 10, 39, "Output",
 CellID->27366]
}, Open  ]],
Cell[3323, 119, 339, 13, 70, "MathCaption",
 CellID->20433],
Cell[CellGroupData[{
Cell[3687, 136, 394, 13, 28, "Input",
 CellID->10843],
Cell[4084, 151, 334, 11, 39, "Output",
 CellID->30672]
}, Open  ]],
Cell[CellGroupData[{
Cell[4455, 167, 71, 1, 70, "RelatedTutorialsSection",
 CellID->83591613],
Cell[4529, 170, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[4702, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

