(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13345,        458]
NotebookOptionsPosition[      8709,        322]
NotebookOutlinePosition[     11641,        395]
CellTagsIndexPosition[     11548,        389]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using the Mathematica System" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UsingTheMathematicaSystemOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Using the Mathematica System\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function" :> Documentation`HelpLookup["paclet:ref/Function"], 
          "Off" :> Documentation`HelpLookup["paclet:ref/Off"], "On" :> 
          Documentation`HelpLookup["paclet:ref/On"], "Quiet" :> 
          Documentation`HelpLookup["paclet:ref/Quiet"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function\"\>", 2->"\<\"Off\"\>", 3->"\<\"On\"\>",
        4->"\<\"Quiet\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Warnings and Messages", "Title",
 CellTags->{"S1.3.11", "11.1"},
 CellID->19814],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " usually goes about its work silently, giving output only when it has \
finished doing the calculations you asked for. "
}], "Text",
 CellID->21298],

Cell[TextData[{
 "However, if it looks as if ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is doing something you definitely did not intend, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will usually print a message to warn you."
}], "Text",
 CellID->11471],

Cell[TextData[{
 "The square root function should have only one argument. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a message to warn you that you have given two arguments here. "
}], "MathCaption",
 CellID->8937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"4", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11261],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sqrt\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sqrt::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[1]:=",
 CellID->364098229],

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"4", ",", "5"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181149350]
}, Open  ]],

Cell[TextData[{
 "You can suppress the message for one evaluation using ",
 Cell[BoxData[
  ButtonBox["Quiet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quiet"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->398654761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quiet", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"4", ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->209160854],

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"4", ",", "5"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63239275]
}, Open  ]],

Cell[TextData[{
 "The message reappears without the use of ",
 Cell[BoxData[
  ButtonBox["Quiet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quiet"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->542844271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"4", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->107601472],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sqrt\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sqrt::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[3]:=",
 CellID->692291194],

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"4", ",", "5"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->303406674]
}, Open  ]],

Cell[TextData[{
 "Each message has a name. You can switch off messages for all evaluations \
using ",
 Cell[BoxData[
  ButtonBox["Off",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Off"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23586],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"Sqrt", "::", "argx"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17327],

Cell[TextData[{
 "The message ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "::", "argx"}]], "InlineFormula"],
 " has now been switched off, and will no longer appear. "
}], "MathCaption",
 CellID->28441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"4", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->9053],

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"4", ",", "5"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->405125509]
}, Open  ]],

Cell[TextData[{
 "This switches ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "::", "argx"}]], "InlineFormula"],
 " back on again. "
}], "MathCaption",
 CellID->32528],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{"Sqrt", "::", "argx"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5491],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Quiet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quiet"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " without printing any messages"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Off",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Off"], "[", 
     StyleBox[
      ButtonBox["Function",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Function"], "TI"], "::", 
     StyleBox["tag", "TI"], "]"}], Cell[
    "switch off (suppress) a message", "TableText"]},
   {
    RowBox[{
     ButtonBox["On",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/On"], "[", 
     StyleBox[
      ButtonBox["Function",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Function"], "TI"], "::", 
     StyleBox["tag", "TI"], "]"}], Cell["switch on a message", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24597],

Cell["Functions for controlling message output.", "Caption",
 CellID->7099],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->302861427],

Cell[TextData[{
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"]
}], "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Warnings and Messages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Using the Mathematica System", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/UsingTheMathematicaSystemOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MathematicaPackages"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/InterruptingCalculations"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 31.8941502}", "context" -> "", 
    "keywords" -> {
     "abend", "arguments", "condition codes", "error messages", "explanation",
       "messages", "off", "on", "output", "verbosity", "warning messages"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica usually goes about its work silently, giving output only \
when it has finished doing the calculations you asked for. However, if it \
looks as if Mathematica is doing something you definitely did not intend, \
Mathematica will usually print a message to warn you. The square root \
function should have only one argument. Mathematica prints a message to warn \
you that you have given two arguments here. ", "synonyms" -> {"1.3.11"}, 
    "title" -> "Warnings and Messages", "type" -> "Tutorial", "uri" -> 
    "tutorial/WarningsAndMessages"}, "SearchTextTranslated" -> "", 
  "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.3.11"->{
  Cell[2078, 62, 86, 2, 70, "Title",
   CellTags->{"S1.3.11", "11.1"},
   CellID->19814]},
 "11.1"->{
  Cell[2078, 62, 86, 2, 70, "Title",
   CellTags->{"S1.3.11", "11.1"},
   CellID->19814]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.3.11", 11332, 378},
 {"11.1", 11434, 382}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1453, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2078, 62, 86, 2, 70, "Title",
 CellTags->{"S1.3.11", "11.1"},
 CellID->19814],
Cell[2167, 66, 215, 6, 70, "Text",
 CellID->21298],
Cell[2385, 74, 275, 9, 70, "Text",
 CellID->11471],
Cell[2663, 85, 233, 6, 70, "MathCaption",
 CellID->8937],
Cell[CellGroupData[{
Cell[2921, 95, 119, 4, 70, "Input",
 CellID->11261],
Cell[3043, 101, 435, 9, 19, "Message",
 CellID->364098229],
Cell[3481, 112, 211, 7, 36, "Output",
 CellID->181149350]
}, Open  ]],
Cell[3707, 122, 231, 8, 70, "MathCaption",
 CellID->398654761],
Cell[CellGroupData[{
Cell[3963, 134, 156, 5, 28, "Input",
 CellID->209160854],
Cell[4122, 141, 210, 7, 36, "Output",
 CellID->63239275]
}, Open  ]],
Cell[4347, 151, 219, 8, 70, "MathCaption",
 CellID->542844271],
Cell[CellGroupData[{
Cell[4591, 163, 123, 4, 70, "Input",
 CellID->107601472],
Cell[4717, 169, 435, 9, 70, "Message",
 CellID->692291194],
Cell[5155, 180, 211, 7, 36, "Output",
 CellID->303406674]
}, Open  ]],
Cell[5381, 190, 251, 9, 70, "MathCaption",
 CellID->23586],
Cell[5635, 201, 125, 4, 70, "Input",
 CellID->17327],
Cell[5763, 207, 267, 9, 70, "MathCaption",
 CellID->28441],
Cell[CellGroupData[{
Cell[6055, 220, 118, 4, 70, "Input",
 CellID->9053],
Cell[6176, 226, 211, 7, 36, "Output",
 CellID->405125509]
}, Open  ]],
Cell[6402, 236, 230, 9, 70, "MathCaption",
 CellID->32528],
Cell[6635, 247, 123, 4, 70, "Input",
 CellID->5491],
Cell[6761, 253, 1285, 41, 70, "DefinitionBox",
 CellID->24597],
Cell[8049, 296, 75, 1, 70, "Caption",
 CellID->7099],
Cell[CellGroupData[{
Cell[8149, 301, 72, 1, 70, "RelatedTutorialsSection",
 CellID->302861427],
Cell[8224, 304, 431, 12, 70, "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],
Cell[8682, 320, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

