(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10168,        318]
NotebookOptionsPosition[      5823,        193]
NotebookOutlinePosition[      9448,        292]
CellTagsIndexPosition[      9273,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]}, \
#, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "What is ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 "?"
}], "Title",
 CellTags->{"b:0.2", "net: 1", "i:4"},
 CellID->82281324],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " administers licenses for organizations running multiple instances of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " with a network license. Network licenses provide a convenient and \
cost-effective way of making ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " available to multiple client machines in a networked environment. Instead \
of a separate license for each machine, a network license allows a specified \
number of copies of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to run concurrently on the network. ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " automates the task of making sure you conform to the license agreement."
}], "Text",
 CellTags->"b:0.2",
 CellID->71829910],

Cell[TextData[{
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is installed on a single machine, known as the license server. Once ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is running, it acts as a gatekeeper for new ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions. ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " sets up the appropriate number of process slots for each class of computer \
covered by the network license. ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " monitors the number of copies of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in use and issues licenses to clients until all available licenses are in \
use."
}], "Text",
 CellTags->{"b:0.2", "i:3"},
 CellID->75421702],

Cell["\<\
The number of concurrent processes that may run over the entire network is \
printed on your license certificate. You can increase the number of processes \
allowed with a license upgrade from Wolfram Research.\
\>", "Text",
 CellTags->{"b:0.2", "i:2"},
 CellID->599150284],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " consists of two components, the kernel and the front end. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel performs computations. The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end is the graphical notebook interface. ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " keeps track of kernel and front end processes separately. The number ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " of processes printed on your license certificate generally gives you ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " front end process slots and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " kernel process slots."
}], "Text",
 CellTags->{"b:0.2", "i:1"},
 CellID->103208352],

Cell[TextData[{
 "A client ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process must request a license from ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " before it starts taking user input or performing calculations. In order \
for clients to run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " must be running on the license server at all times. If the client machine \
making the request is not of a type covered by the license, or if all of the \
process slots are already in use, the client ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process cannot be started."
}], "Text",
 CellTags->"b:0.2",
 CellID->28227277],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->143393031],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"What is MathLM? - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 33.0973060}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MathLM administers licenses for organizations running multiple instances \
of Mathematica with a network license. Network licenses provide a convenient \
and cost-effective way of making Mathematica available to multiple client \
machines in a networked environment. Instead of a separate license for each \
machine, a network license allows a specified number of copies of Mathematica \
to run concurrently on the network. MathLM automates the task of making sure \
you conform to the license agreement. MathLM is installed on a single \
machine, known as the license server. Once MathLM is running, it acts as a \
gatekeeper for new Mathematica sessions. MathLM sets up the appropriate \
number of process slots for each class of computer covered by the network \
license. MathLM monitors the number of copies of Mathematica in use and \
issues licenses to clients until all available licenses are in use. The \
number of concurrent processes that may run over the entire network is \
printed on your license certificate. You can increase the number of processes \
allowed with a license upgrade from Wolfram Research.", "synonyms" -> {}, 
    "title" -> "What is MathLM?", "type" -> "Tutorial", "uri" -> 
    "tutorial/WhatIsMathLM"}, "SearchTextTranslated" -> "", "SearchText" -> 
  ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:0.2"->{
  Cell[1319, 44, 148, 7, 70, "Title",
   CellTags->{"b:0.2", "net: 1", "i:4"},
   CellID->82281324],
  Cell[1470, 53, 928, 25, 70, "Text",
   CellTags->"b:0.2",
   CellID->71829910],
  Cell[2401, 80, 1028, 31, 70, "Text",
   CellTags->{"b:0.2", "i:3"},
   CellID->75421702],
  Cell[3432, 113, 283, 6, 70, "Text",
   CellTags->{"b:0.2", "i:2"},
   CellID->599150284],
  Cell[3718, 121, 884, 26, 70, "Text",
   CellTags->{"b:0.2", "i:1"},
   CellID->103208352],
  Cell[4605, 149, 850, 26, 70, "Text",
   CellTags->"b:0.2",
   CellID->28227277]},
 "net: 1"->{
  Cell[1319, 44, 148, 7, 70, "Title",
   CellTags->{"b:0.2", "net: 1", "i:4"},
   CellID->82281324]},
 "i:4"->{
  Cell[1319, 44, 148, 7, 70, "Title",
   CellTags->{"b:0.2", "net: 1", "i:4"},
   CellID->82281324]},
 "i:3"->{
  Cell[2401, 80, 1028, 31, 70, "Text",
   CellTags->{"b:0.2", "i:3"},
   CellID->75421702]},
 "i:2"->{
  Cell[3432, 113, 283, 6, 70, "Text",
   CellTags->{"b:0.2", "i:2"},
   CellID->599150284]},
 "i:1"->{
  Cell[3718, 121, 884, 26, 70, "Text",
   CellTags->{"b:0.2", "i:1"},
   CellID->103208352]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:0.2", 8169, 240},
 {"net: 1", 8726, 259},
 {"i:4", 8838, 263},
 {"i:3", 8950, 267},
 {"i:2", 9053, 271},
 {"i:1", 9156, 275}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 694, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1319, 44, 148, 7, 70, "Title",
 CellTags->{"b:0.2", "net: 1", "i:4"},
 CellID->82281324],
Cell[1470, 53, 928, 25, 70, "Text",
 CellTags->"b:0.2",
 CellID->71829910],
Cell[2401, 80, 1028, 31, 70, "Text",
 CellTags->{"b:0.2", "i:3"},
 CellID->75421702],
Cell[3432, 113, 283, 6, 70, "Text",
 CellTags->{"b:0.2", "i:2"},
 CellID->599150284],
Cell[3718, 121, 884, 26, 70, "Text",
 CellTags->{"b:0.2", "i:1"},
 CellID->103208352],
Cell[4605, 149, 850, 26, 70, "Text",
 CellTags->"b:0.2",
 CellID->28227277],
Cell[CellGroupData[{
Cell[5480, 179, 72, 1, 70, "RelatedTutorialsSection",
 CellID->143393031],
Cell[5555, 182, 214, 5, 70, "RelatedTutorials",
 CellID->13855348]
}, Open  ]]
}, Open  ]],
Cell[5796, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

