(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26768,        909]
NotebookOptionsPosition[     19844,        689]
NotebookOutlinePosition[     22878,        764]
CellTagsIndexPosition[     22786,        758]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"The Internals of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheInternalsOfMathematicaOverview"], 
         "Basic Internal Architecture" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/BasicInternalArchitecture"], 
         "The Algorithms of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheAlgorithmsOfMathematica"], 
         "The Software Engineering of Mathematica" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TheSoftwareEngineeringOfMathematica"], 
         "Testing and Verification" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TestingAndVerification"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"The Internals of Mathematica\"\>", 
      2->"\<\"Basic Internal Architecture\"\>", 
      3->"\<\"The Algorithms of Mathematica\"\>", 
      4->"\<\"The Software Engineering of Mathematica\"\>", 
      5->"\<\"Testing and Verification\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Why You Do Not Usually Need to Know about Internals", "Title",
 CellTags->{"S1.12.1", "1.1"},
 CellID->1881],

Cell[TextData[{
 "Most of the documentation provided for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is concerned with explaining ",
 StyleBox["what",
  FontSlant->"Italic"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does, not ",
 StyleBox["how",
  FontSlant->"Italic"],
 " it does it. But the purpose of this page is to say at least a little about \
how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does what it does. ",
 ButtonBox["Some Notes on Internal Implementation",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html"], None}],
 " gives some more details. "
}], "Text",
 CellID->21823],

Cell[TextData[{
 "You should realize at the outset that while knowing about the internals of \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may be of intellectual interest, it is usually much less important in \
practice than one might at first suppose. "
}], "Text",
 CellID->13310],

Cell[TextData[{
 "Indeed, one of the main points of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that it provides an environment where you can perform mathematical and \
other operations without having to think in detail about how these operations \
are actually carried out inside your computer. "
}], "Text",
 CellID->3671],

Cell[TextData[{
 "Thus, for example, if you want to factor the polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "15"], "-", "1"}], TraditionalForm]], "InlineMath"],
 ", you can do this just by giving ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the command ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"], "[", 
   RowBox[{
    RowBox[{"x", "^", "15"}], "-", "1"}], "]"}]], "InlineFormula"],
 "; you do not have to know the fairly complicated details of how such a \
factorization is actually carried out by the internal code of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->27578],

Cell[TextData[{
 "Indeed, in almost all practical uses of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", issues about how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " works inside turn out to be largely irrelevant. For most purposes it \
suffices to view ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " simply as an abstract system which performs certain specified mathematical \
and other operations. "
}], "Text",
 CellID->23993],

Cell[TextData[{
 "You might think that knowing how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " works inside would be necessary in determining what answers it will give. \
But this is only very rarely the case. For the vast majority of the \
computations that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does are completely specified by the definitions of mathematical or other \
operations. "
}], "Text",
 CellID->15090],

Cell[TextData[{
 "Thus, for example, ",
 Cell[BoxData[
  RowBox[{"3", "^", "40"}]], "InlineFormula"],
 " will always be ",
 Cell[BoxData["12157665459056928801"], "InlineFormula"],
 ", regardless of how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " internally computes this result. "
}], "Text",
 CellID->21653],

Cell[TextData[{
 "There are some situations, however, where several different answers are all \
equally consistent with the formal mathematical definitions. Thus, for \
example, in computing symbolic integrals, there are often several different \
expressions which all yield the same derivative. Which of these expressions \
is actually generated by ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can then depend on how ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " works inside. "
}], "Text",
 CellID->21234],

Cell[TextData[{
 "Here is the answer generated by ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"x", "^", "2"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24247],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "x"]}], "+", 
  RowBox[{"Log", "[", "x", "]"}]}]], "Output",
 ImageSize->{78, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169487728]
}, Open  ]],

Cell[TextData[{
 "This is an equivalent expression that might have been generated if ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " worked differently inside. "
}], "MathCaption",
 CellID->27422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10745],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"Log", "[", "x", "]"}]}]}], "x"]], "Output",
 ImageSize->{88, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->255510281]
}, Open  ]],

Cell[TextData[{
 "In numerical computations, a similar phenomenon occurs. Thus, for example, \
",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " gives you a root of a function. But if there are several roots, which root \
is actually returned depends on the details of how ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " works inside. "
}], "Text",
 CellID->23488],

Cell[TextData[{
 "This finds a particular root of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", "x", ")"}], "+", "sin", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->3022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23377],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "14.922565104551518`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->106921246]
}, Open  ]],

Cell["\<\
With a different starting point, a different root is found. Which root is \
found with each starting point depends in detail on the internal algorithm \
used. \
\>", "MathCaption",
 CellID->24083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "10.8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->15966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "11.780972450961725`"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->672806277]
}, Open  ]],

Cell["\<\
The dependence on the details of internal algorithms can be more significant \
if you push approximate numerical computations to the limits of their \
validity. \
\>", "Text",
 CellID->2794],

Cell[TextData[{
 "Thus, for example, if you give ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " a pathological integrand, whether it yields a meaningful answer or not can \
depend on the details of the internal algorithm that it uses. "
}], "Text",
 CellID->7646],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " knows that this result is unreliable, and can depend on the details of the \
internal algorithm, so it prints warning messages. "
}], "MathCaption",
 CellID->8324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->13441],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[5]:=",
 CellID->74941149],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({0.005338597278545624`}\\). NIntegrate obtained \
\\!\\(0.5038782627066661`\\) and \\!\\(0.0011134563535424439`\\) for the \
integral and error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[5]:=",
 CellID->818823447],

Cell[BoxData["0.5038782627066661`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->21289308]
}, Open  ]],

Cell["\<\
Traditional numerical computation systems have tended to follow the idea that \
all computations should yield results that at least nominally have the same \
precision. A consequence of this idea is that it is not sufficient just to \
look at a result to know whether it is accurate; you typically also have to \
analyze the internal algorithm by which the result was found. This fact has \
tended to make people believe that it is always important to know internal \
algorithms for numerical computations. \
\>", "Text",
 CellID->12066],

Cell[TextData[{
 "But with the approach that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes, this is rarely the case. For ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can usually use its arbitrary\[Hyphen]precision numerical computation \
capabilities to give results where every digit that is generated follows the \
exact mathematical specification of the operation being performed. "
}], "Text",
 CellID->6460],

Cell[TextData[{
 "Even though this is an approximate numerical computation, every digit is \
determined by the mathematical definition for ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->20391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "30"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->30573],

Cell[BoxData["3.141592653589793238462643383279502884197169399375`30."], \
"Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->293842404]
}, Open  ]],

Cell[TextData[{
 "Once again, every digit here is determined by the mathematical definition \
for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->26605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"10", "^", "50"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->26806],

Cell[BoxData[
 RowBox[{"-", "0.78967249342931008271028953991740775626`20."}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->56970498]
}, Open  ]],

Cell[TextData[{
 "If you use machine\[Hyphen]precision numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot give a reliable result, and the answer depends on the details of \
the internal algorithm used. "
}], "MathCaption",
 CellID->16396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"10.", "^", "50"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->27518],

Cell[BoxData["0.6693693999244401`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->34074531]
}, Open  ]],

Cell[TextData[{
 "It is a general characteristic that whenever the results you get can be \
affected by the details of internal algorithms, you should not depend on \
these results. For if nothing else, different versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may exhibit differences in these results, either because the algorithms \
operate slightly differently on different computer systems, or because \
fundamentally different algorithms are used in versions released at different \
times. "
}], "Text",
 CellID->27944],

Cell[TextData[{
 "This is the result for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     SuperscriptBox["10", "50"], ")"}]}], TraditionalForm]], "InlineMath"],
 " on one type of computer. "
}], "MathCaption",
 CellID->21726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"10.", "^", "50"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->17015],

Cell[BoxData["0.6693693999244401`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->34765716]
}, Open  ]],

Cell["Here is the same calculation on another type of computer. ", \
"MathCaption",
 CellID->19323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"10.", "^", "50"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->3569],

Cell[BoxData["0.6693693999244401`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->505162264]
}, Open  ]],

Cell[TextData[{
 "And here is the result obtained in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Version 1. "
}], "MathCaption",
 CellID->4218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"10.", "^", "50"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->25369],

Cell[BoxData["0.6693693999244401`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->205883866]
}, Open  ]],

Cell[TextData[{
 "Particularly in more advanced applications of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it may sometimes seem worthwhile to try to analyze internal algorithms in \
order to predict which way of doing a given computation will be the most \
efficient. And there are indeed occasionally major improvements that you will \
be able to make in specific computations as a result of such analyses."
}], "Text",
 CellID->1670],

Cell[TextData[{
 "But most often the analyses will not be worthwhile. For the internals of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are quite complicated, and even given a basic description of the algorithm \
used for a particular purpose, it is usually extremely difficult to reach a \
reliable conclusion about how the detailed implementation of this algorithm \
will actually behave in particular circumstances. "
}], "Text",
 CellID->27161],

Cell[TextData[{
 "A typical problem is that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has many internal optimizations, and the efficiency of a computation can \
be greatly affected by whether the details of the computation do or do not \
allow a given internal optimization to be used. "
}], "Text",
 CellID->28015],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->419807088],

Cell[TextData[{
 ButtonBox["The Internals of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheInternalsOfMathematicaOverview"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->666254040],

Cell[TextData[ButtonBox["Basic Internal Architecture",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicInternalArchitecture"]], "RelatedTutorials",\

 CellID->255800466],

Cell[TextData[{
 ButtonBox["The Algorithms of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheAlgorithmsOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->820035495],

Cell[TextData[{
 ButtonBox["The Software Engineering of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSoftwareEngineeringOfMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheSoftwareEngineeringOfMathematica"],
  FontSlant->"Italic"]
}], "RelatedTutorials",
 CellID->889871574],

Cell[TextData[ButtonBox["Testing and Verification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndVerification"]], "RelatedTutorials",
 CellID->449263826]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Why You Do Not Usually Need to Know about Internals - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Internals of Mathematica", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheInternalsOfMathematicaOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/BasicInternalArchitecture"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 33.2848108}", "context" -> "", 
    "keywords" -> {
     "algorithms", "efficiency of algorithms", "performance analysis", 
      "speed", "timings"}, "index" -> True, "label" -> "Mathematica Tutorial",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Most of the documentation provided for Mathematica is concerned with \
explaining what Mathematica does, not how it does it. But the purpose of this \
page is to say at least a little about how Mathematica does what it does. \
Some Notes on Internal Implementation gives some more details. You should \
realize at the outset that while knowing about the internals of Mathematica \
may be of intellectual interest, it is usually much less important in \
practice than one might at first suppose. Indeed, one of the main points of \
Mathematica is that it provides an environment where you can perform \
mathematical and other operations without having to think in detail about how \
these operations are actually carried out inside your computer. ", 
    "synonyms" -> {"1.12.1"}, "title" -> 
    "Why You Do Not Usually Need to Know about Internals", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/WhyYouDoNotUsuallyNeedToKnowAboutInternals"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.12.1"->{
  Cell[2041, 58, 114, 2, 70, "Title",
   CellTags->{"S1.12.1", "1.1"},
   CellID->1881]},
 "1.1"->{
  Cell[2041, 58, 114, 2, 70, "Title",
   CellTags->{"S1.12.1", "1.1"},
   CellID->1881]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.12.1", 22573, 747},
 {"1.1", 22673, 751}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1416, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2041, 58, 114, 2, 70, "Title",
 CellTags->{"S1.12.1", "1.1"},
 CellID->1881],
Cell[2158, 62, 717, 25, 70, "Text",
 CellID->21823],
Cell[2878, 89, 293, 8, 70, "Text",
 CellID->13310],
Cell[3174, 99, 338, 8, 70, "Text",
 CellID->3671],
Cell[3515, 109, 715, 23, 70, "Text",
 CellID->27578],
Cell[4233, 134, 457, 14, 70, "Text",
 CellID->23993],
Cell[4693, 150, 442, 12, 70, "Text",
 CellID->15090],
Cell[5138, 164, 319, 11, 70, "Text",
 CellID->21653],
Cell[5460, 177, 670, 17, 70, "Text",
 CellID->21234],
Cell[6133, 196, 213, 8, 70, "MathCaption",
 CellID->6266],
Cell[CellGroupData[{
Cell[6371, 208, 224, 8, 70, "Input",
 CellID->24247],
Cell[6598, 218, 250, 9, 51, "Output",
 CellID->169487728]
}, Open  ]],
Cell[6863, 230, 275, 8, 70, "MathCaption",
 CellID->27422],
Cell[CellGroupData[{
Cell[7163, 242, 100, 3, 70, "Input",
 CellID->10745],
Cell[7266, 247, 276, 10, 51, "Output",
 CellID->255510281]
}, Open  ]],
Cell[7557, 260, 516, 15, 70, "Text",
 CellID->23488],
Cell[8076, 277, 244, 9, 70, "MathCaption",
 CellID->3022],
Cell[CellGroupData[{
Cell[8345, 290, 263, 9, 70, "Input",
 CellID->23377],
Cell[8611, 301, 227, 7, 36, "Output",
 CellID->106921246]
}, Open  ]],
Cell[8853, 311, 206, 5, 70, "MathCaption",
 CellID->24083],
Cell[CellGroupData[{
Cell[9084, 320, 263, 9, 70, "Input",
 CellID->15966],
Cell[9350, 331, 227, 7, 36, "Output",
 CellID->672806277]
}, Open  ]],
Cell[9592, 341, 200, 5, 70, "Text",
 CellID->2794],
Cell[9795, 348, 345, 9, 70, "Text",
 CellID->7646],
Cell[10143, 359, 305, 8, 70, "MathCaption",
 CellID->8324],
Cell[CellGroupData[{
Cell[10473, 371, 240, 8, 70, "Input",
 CellID->13441],
Cell[10716, 381, 565, 10, 70, "Message",
 CellID->74941149],
Cell[11284, 393, 666, 12, 70, "Message",
 CellID->818823447],
Cell[11953, 407, 175, 5, 36, "Output",
 CellID->21289308]
}, Open  ]],
Cell[12143, 415, 547, 9, 70, "Text",
 CellID->12066],
Cell[12693, 426, 437, 11, 70, "Text",
 CellID->6460],
Cell[13133, 439, 250, 7, 70, "MathCaption",
 CellID->20391],
Cell[CellGroupData[{
Cell[13408, 450, 118, 4, 70, "Input",
 CellID->30573],
Cell[13529, 456, 214, 6, 36, "Output",
 CellID->293842404]
}, Open  ]],
Cell[13758, 465, 251, 9, 70, "MathCaption",
 CellID->26605],
Cell[CellGroupData[{
Cell[14034, 478, 175, 6, 70, "Input",
 CellID->26806],
Cell[14212, 486, 218, 6, 36, "Output",
 CellID->56970498]
}, Open  ]],
Cell[14445, 495, 258, 7, 70, "MathCaption",
 CellID->16396],
Cell[CellGroupData[{
Cell[14728, 506, 121, 4, 70, "Input",
 CellID->27518],
Cell[14852, 512, 175, 5, 36, "Output",
 CellID->34074531]
}, Open  ]],
Cell[15042, 520, 543, 11, 70, "Text",
 CellID->27944],
Cell[15588, 533, 247, 9, 70, "MathCaption",
 CellID->21726],
Cell[CellGroupData[{
Cell[15860, 546, 121, 4, 70, "Input",
 CellID->17015],
Cell[15984, 552, 175, 5, 36, "Output",
 CellID->34765716]
}, Open  ]],
Cell[16174, 560, 99, 2, 70, "MathCaption",
 CellID->19323],
Cell[CellGroupData[{
Cell[16298, 566, 121, 4, 70, "Input",
 CellID->3569],
Cell[16422, 572, 177, 5, 36, "Output",
 CellID->505162264]
}, Open  ]],
Cell[16614, 580, 154, 6, 70, "MathCaption",
 CellID->4218],
Cell[CellGroupData[{
Cell[16793, 590, 122, 4, 70, "Input",
 CellID->25369],
Cell[16918, 596, 177, 5, 36, "Output",
 CellID->205883866]
}, Open  ]],
Cell[17110, 604, 449, 9, 70, "Text",
 CellID->1670],
Cell[17562, 615, 458, 9, 70, "Text",
 CellID->27161],
Cell[18023, 626, 328, 8, 70, "Text",
 CellID->28015],
Cell[CellGroupData[{
Cell[18376, 638, 72, 1, 70, "RelatedTutorialsSection",
 CellID->419807088],
Cell[18451, 641, 327, 9, 70, "RelatedTutorials",
 CellID->666254040],
Cell[18781, 652, 176, 4, 70, "RelatedTutorials",
 CellID->255800466],
Cell[18960, 658, 314, 9, 70, "RelatedTutorials",
 CellID->820035495],
Cell[19277, 669, 342, 9, 70, "RelatedTutorials",
 CellID->889871574],
Cell[19622, 680, 168, 3, 70, "RelatedTutorials",
 CellID->449263826]
}, Open  ]]
}, Open  ]],
Cell[19817, 687, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

