(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    418212,       8025]
NotebookOptionsPosition[    308051,       5597]
NotebookOutlinePosition[    401850,       7602]
CellTagsIndexPosition[    399614,       7528]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Working with Cells and Notebooks", "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["Working with Cells and Notebooks", "Section",
 PageBreakAbove->True,
 CellTags->{
  "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
   "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
   "Section cells", "Types of cells", "Notebooks", "Close a group of cells", 
   "Open a group of cells", "Print notebooks", 
   "Notebooks: change overall style", "Styles of entire notebooks", 
   "Style sheets", "Notebooks: formatting", "TraditionalForm", 
   "notebooksandcells", "gs:0.8", "i:24"}],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks consist of sequences of cells. The various kinds of cells \
associated with a notebook's style sheet are listed in ",
 StyleBox[ButtonBox["Format",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Style",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Style"], "MenuName"],
 "."
}], "Text",
 CellTags->{"notebooksandcells", "i:14", "gs:0.8", "i:120"}],

Cell[CellGroupData[{

Cell["To create a new cell:", "Subsection",
 CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],

Cell[CellGroupData[{

Cell["\<\
Move the pointer in the notebook window until it becomes a horizontal I-beam. \
\
\>", "ItemizedText",
 CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1u00AQ3qx/8kOTCEGVE1Iu/AiKxJHyAFAJApzgHFWgFAkVlb4Ej5Dn
ACR4iJx5kXLooRjP7Hp2vZk4DaTOunUkT8azm5nv27HHuxuPxseTdx/Hxwf7
4+Gzo/GnycH+5+HTw6PUFDSEaIRCiDdDAXqSqlrgJwIhRKDOUnNDCXUSZFb9
i8Xts9lM/Emm06nk2+HrDHsF0It8/m9PCT1PQZWr/cbp+RtliP3SVjyK2bhe
wHaCMsrObU+idlUFV/dRBuQKzrYY249Kh3zAuO8wtp/rC7kDcgtOH4HWFyoa
yOwIGFsE8rB85g8TQkS2L+uDcd6c71wJGJPafe3+CrrH6UZvlUq4xwB6DzJK
tvtnkrSBbyA/KBtgI1vI2LYvEHgaB4+AsXkPnBvxPPCbTD5ikK83RAHhBoAS
NQma1ER0XCsfIdm0HZnh0wgfRrteclR8epQiOzUF3xn3QN81DnUzIF3NwX4a
PwZ5q/Ks+YS3wRJTwqtPsyC5bQcvEUk/Tzxh3zkve6nu5cRukgWJ7uhINvkc
7xFoIVCMS2MbsWwjQ8POr3Rp5/pf06AzgH4k1dTkFvMUdPOl7aYSy3yKXilb
SSlaaRJSXDhfOnCBqHcU9gjuSHuwoHk56AbxCw3DRlzSQE8IxHPQ4hJGyoR8
WweqAyW6zg5Iq0NWMyTWjQHVkg0E7zK1trkIEFbdqISCtzq0DUx4qgOyRTNJ
bm/CT7hqEU9jKp1xJuA4D8YFXVNDs6dkEbXe9oig1JdJ0UJPZSpmV3fZnBm5
IwBJ2sJRcPpVczzm1npoRqtZQLRAQ3Qx2e5dDrp4yXeJVZtJdpNa714OzibF
vXyKHeItar3jHfEwRzRb3PO7Hzb33O3eJ4I3SPPvNs7X7YCt5fN7GqaWO3Wq
z9g40qXtFRRTVdxCm1uSmZEjlinclrpOGne9bmALAd13hLlc9AGfNijfE9VW
7j7BUljfdKwNbAYsxfYVtPjC/j1bGv/X+mL5+UZN7ap2hbb0+NfX7E5Vp3l/
5b1oqJ76+YEpeE1SKgs26HcsReMvJN9OjA==\
\>"], "ItemizedPicture",
 ImageSize->{260, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}]
}, Open  ]],

Cell[TextData[{
 "Click, and a cell insertion bar will appear; start typing. By default, new \
cells are ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input cells."
}], "ItemizedText",
 CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["To create a new cell to hold ordinary text:", "Subsection",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],

Cell["Click in the notebook to get a cell insertion bar.", "ItemizedText",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Format",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Style",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Style"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Text", "MenuName"],
 StyleBox[".", "SR"]
}], "ItemizedText",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],

Cell[" \[LongDash] or \[LongDash] ", "ItemizedTextParagraph",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],

Cell[TextData[{
 "Use the keyboard shortcut ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["7", "KeyEvent"],
 " on Windows, ",
 StyleBox["Command", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["7", "KeyEvent"],
 " on Macintosh, or ",
 StyleBox["Mod1", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["7", "KeyEvent"],
 " on Unix."
}], "ItemizedTextParagraph",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],

Cell["When you start typing, a text cell bracket appears.", "ItemizedText",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["To change the style of a cell:", "Subsection",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],

Cell[CellGroupData[{

Cell["Click the cell bracket. The bracket is highlighted. ", "ItemizedText",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0tv1DAQTp3HNvSxLS2iIFUU8ScQQqJCCLhw5ryqkNoDApXyOzj3THn8
gwKiIG5c+gdA/BQImfF71slm2yTrVIlqx52MZ+absR0/Nk9GB7vPno8O9nZG
W4/2Ry9393ZebT18sZ+TwrkgmFsLguD1VgDlLC+KLMv/snXIgiCEG5JXIJvj
VE4O5FX2/PT0NH9+eHi4DBlzM8E9A9Yl5A+BVUmvhZ0BJwJLIWPTVSSc+DTG
YoRMwAKpHCEVxWHkORcSK6IhLujl9fJ6eb08T+S9gXwzT9nTzgjdhhLKvNyE
+HtQGgB9tTHx+VO4/mXXMIUiV1HO07A+5fchxzp3oYR6Fm2DuB5uh6y2UrMF
BkC47hDxMsG10Kp1D4h1kG57Y92CihlTJTJhS3gmoxyqEtZI7LqxKoUlGMMi
XfOOUCJHCqXIVs3ZIkuAZCBymZtVG6qh5VzE5NaCsehoKsxhk3QAcRSl6eoJ
rW6LKZDujt0ZtESFVSYDiB18UTWfTHTf2dxi2xK7WRO/G85YG2dV48T/c4qO
lSA9WowZX9C/CS0lvhnnnyL6LuPPG3ou3WE9pEFXgi+upEhCVOIRPWySd0Mw
oI1rYrhDbUWDMXdX1y+/SY3Clhkpm/2NdEfeD9OIK1LhblaVeoEgl75V6nhV
TDG0RH60K903yKxLD/XlsyfpVl0JJ3Kir5uX6Qxmqxift8Ul7iSmkSlewQiI
DHq0Q1ZfRnGbtlHeHJcdVQYO2rrbeZccrJut+iGt3p+ul7tio3OwsW/QCS+k
Vd0XYtoX8H5VMawRm0xOZEgV6w0boWj+jW4WkJ0KuYKTThX35rZGpA+lQkNp
Oxsy3MeNNiWiPGk1os1tbW2rXtjIxlyNm4m+b8v6Lg+HuJsQlD+90G4I5cyZ
HF9+1awjCJVoSIsOWuigYd0ESL99M+iEj2ZXhn+ZKtU4rk0yMteGKXTQtJE/
BBCgSimRg1bjy6uK4S7vemJ4ZBmewQwn1yeWHzLY3AgFR66bJE3QNRq9p/7Z
D1wSUj5vlloL7pnFHlOMGjkCde1Dfeo25JKw6uOTCx7Wsu2dL55BT4ogM95X
M/MR00DdIS7YEvENtK3VaLhmrBn1gvSEhkvPD+A6DvABtIX2EWZiABbHiip4
kGjwBJ0Mu2ym8TrvLMM1oB6rOLYSkPNC+E6MhHsnDP9mdyNpfBu23wL9J+J/
U1GbDkQjvqI7WsX9s1fks6LHoOjtRUJ08RThkIZbymmrKpe4okwqgTTwzQy9
cm9jSKtg0KwWu2gPzqyYMZVEI+UcyycjiSJGfOqRuUwEuGwRZqxWLAjiHisk
hma4cC3iOhDkExegvOsG9rFllzjDzUsu4ORc14We2Xxd9YNuxRrLPB+0AvPH
Oh87io/EWZ/tp47ADtTTD7OHG1nw5Jra2G4xUJb3av1LWPqLWUjz6un72YN2
bS7QoXh8U0E3Yt0113zqmg5YHEdk4sgkWeMpHJeGjjHoSMltbbLBfwth7aPA
ldqjCr5HVlXpiFjX1iKzmsUzXIpXM3DWa/VqVurFfHNnVrjGqfu0rhGhdR+m
Zrwz9fJ6eZ2Xh3TIzvjdM34DnnLOccmz+CQcvSPW4ZbbSj5yH0LGZwu8vvhM
Ppj7Dw5bOZ8=\
\>"], "ItemizedPicture",
 ImageSize->{275, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Select a style from ",
 StyleBox[ButtonBox["Format",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Style",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Style"], "MenuName"],
 ". The cell will immediately reflect the change."
}], "ItemizedText",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM2O1TYU9uT/zlBmGCpEEYwGSivY8BAs6KoPUFiNUCVYVEVAN1UfZV4E
aJ+g7fQNqm76EIDEJf459vHJsZNckpswSjRxHOfk/H4+tuPR/f7k5ZMffzp5
+fTxyfF3z0+ePXn6+MXxg5+f103pjhA7d4QQvxwLWV/XVVOs67/1XVkIkcqL
av5GFju6VTcLOGLPz87O6uenp6dfyyLhieR1LUlvKfpUklrug5AnklIZdiSL
pN+LhFI9vaaqmSKSJPKMW0hZaTPq8itVzW0jYicWfgu/hd/Cb+HXnV8iC8Xu
cGDOiryUTZeG4/yrLFN1m+rxcq2EiYeqTC1fTaFLeQ90NwydZnhVnakprfr1
uT+wzhmj8w9GFzxeZozO122MjKrA+WA4JX8jusjrIw0QrRZWHMbuoy0otifL
lbyrrDoZU0v8WgQKYEmB6OBIGPcnQTrfK01N8o6ahOlyj874XjjTU98JacQk
zKSw76Y4xkQW51dVKyMewZ5rRil1/deJsxwC9MYL+JCv9bL48qyh2pYBFEAK
3sMFY20Ah21iso50DjlMaOS9Q1UaUjHnMrl+V2BYBvFXMIpxjq78dwm2yqiS
h/NFDe1vRm3VXIQ6NSTuBocwAUFRL7GUgEShFTytauoUXnq9H9j0wFMPf3Hx
QOMAXtm2vrRRZL6cJSQhc4BA63jn2oqp8UOKx6AKPeDcS3IXF/ULJMdZ9xgw
YQiZKwcZDjycs1iUmPD0gxb/0rVZwqHruJb5vqsYLqMMYGjqkHnJAwGJH08r
hxQnxs5GCIaA8xAYikxUXVtrFyWGTJ9MWufQqmY6vO77jYksF7E8JKHZhQjM
4rKCTx0XwBUODUlQTVzFVPWGJ5KjgCtu7oq1ri6jvRCn4rgFrQmtc8abBVK7
zpQCy2WaNrSKzYzFzu/aZAaj50mPEVAErzxFDaW9Bw7hGSnmnZsokVzrRnP0
XncUb+LL1glXOFHEOKC5LKZJoyJmMacrjVw+L/UYdHFsM96hHdaqieEJehs/
cau9LqO9vvOD4OTbgZv/ekSZYrVh+RtGdEERDfetoOZkY8PdPKlDeDxizDnv
Y+70K+HaO9wyT3VTP3HRDND0ySd/+gtPep0nEHrZwNAUFlIC+hJ41xzelzsI
FX7G6V0SmTZtuj6CZi5teO37HTAcwnDgNuO0yRfDK1uA+HUG2PeCWPK3JK7a
pxds7Sbz7oGt3Ze1DJ6OuMWhdqUq6zqX8VxHvv0JVt6IopDYC9MJF0F1HXAT
akBrv93MRt0HcmsjsnNIQ90+nkg9GW7VMUovcXKLcXE73kblyJurc99WXvgt
/BZ+LL93OikcVJAe6tqA6eGD0Om65mozZsa0DZiur+hcV3PPbO2/idToIPLf
7au2K0vFPbUeSohIeYVPh54a1Xpfv14fZ9vXfaXKPY896Bu6wlKIe4e3uy73
zAPb8erz7/Nnr8VDcd4DWhKd4ZTHP1PZvdvV7gT1SHgEC2TSP78wzdjQ+vhL
VhRxsQ3L+OjkvMqJNZHDJ2ySgoCJIubS5oqom3nRghSZ2B6VbMHr94iT5Pkn
0xdGVuM9H+CRpb6LQG5k0W9lWWzBxrUWtMhYZCwyzrEMtyIbWdAEa7MJRKqv
aGQ5+P9EanQQeVEjTLjtDIu9Nf7P29fbN0GviMrozFxzKejwD9eLOgSC27Zp
2EnoZm1xY8KjmlXrrrWg0j1b4P9++OOzsurQ6r1iolbap79/Vla5WLlNnoqx
z22ovJnKvsZKo+9S2EXw8vQ9y2efMm3BNSGXSfaZtle6Nv5oGrQotk68pJEn
zGZPZjVeFm2jinaLtlG+eit9Z/zRf+G38Fv48fxUuyw2/JkI9R9WR5qyyXmK
X9BQ3rllEip2W+Q3QW7LQg9a+n3zqyJi5yNzMJf+\
\>"], "ItemizedPicture",
 ImageSize->{296, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tips", "Subsubsection",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
 CellID->184729763],

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Window",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/WindowMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Show Toolbar",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowToolbar"], "MenuName"],
 " to get a toolbar at the top of the notebook."
}], "Notes",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
 CellID->798966666],

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Window",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/WindowMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Show Ruler",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowRuler"], "MenuName"],
 " to get a ruler at the top of the notebook."
}], "Notes",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
 CellID->17510771]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To close a group of cells:", "Subsection",
 PageBreakAbove->True,
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],

Cell["Double-click the outermost cell bracket of the group. ", "Text",
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXV/MJMdRn9uZ3f2+853vzmf7zndn/N1dbEKEEmRC7CSQIOWUPEF48RMS
woriJBIBFIIsIJF4s3gA+Q0bQR74I7CA50h+S5z4n+w7SwHeLEBCigDhd3hZ
tntmurprftXTPTO72/ttr7T7zdfTXVVdXdVdXdV/funZb371y19/9ptf+9Kz
J1/4xrO//dWvfel3Tj7/W99YJ5VniuLML6y/Pz4p1POqKNqf2Up/1o+fVj9n
mn/KNrXOpX4/hd+rP6vVyy+//LT6mfkyvfvuu0+pn/WLdVYDfZLsMytn89Ev
Vj+jfmaD4DjV/5h+rHTm9957T2XrqTAHZUg6Vj9L9bzUieWqfluXrlhajbZo
wBcG1EL/ztv/baKKcKqKGub692ImSCboD9XvTP33FfVUqqfbadBHoL6lSdW0
1Vxcf78M0m6lRvhXAJEP7Gtljo2ArClt8Fp0VyatSddSVcx5sv47owxuufbd
Otlmhq9IT/IMPFkVMAURuS0JVLzsy8VA60K6LgvzJBA6B0JAlGmwS4n40qTr
zEuDa+YCoDSLwc1HZ5ibp6O+mupXC1yh0qRaGN2qPTRWvrXY1ryYG8hrIS+U
/GohV4lniighP+sRPguNLf69wtdlNecHyipg7jRDBGYg/jUduvqwcjJhw0ot
fbXsZ4irK7HIkRgGVQMVEaD3QApGRCyeDnkEpJHJV5NU7vsitREqkqe9gqTS
bQQLhViuksrxEcPf0m7vJeVHcOvSwWxYgDRchxiR6mHuUbjKR7Ro5eFcBEcQ
FYsDVb+lwxn+d0j1eac5FRdl1cDCCc2scK0r0YtI1fNVHqmgptZXaA4q0T5X
HobMXDbAuhmCmT0SO1gxvnvZlRXLL0Q1/4mNvN37zVFfuTGaJ0tFhB2NrUnL
hPbTtRS5FQohYjwSh32mLnW+DZp+kQiIwgikQW2I7BLE/lV3Nh8giynrtmSc
Uv/dyKb9setOueeMYU0ODs51MpTuW+rTsQnaBaBLLNgLI/yEHPk/uH+p+Uvu
DuTigSVtYpAqzU0hAq7TkONlBtjRYdtKGJRsGAHsI/sixqHm6AL20VxJUujP
Sb0kebcEw+oqKHkJpF0BaYLh8ATIyrVSfe8HaUdiP9ifdgLSHk6yue4DWnds
0m6Aepwzb6+yZu2oyOMmw/lApi9dcnyOOAQSOejT5Lum7WwmbQ9Ic/rkmc5U
6mxtWj24Zvoyfbum72nTh99Nl8hPgk763UzuROTS8IwmbSts7HLrvk5rM8vB
wDrNm6Wm2KGJRvVjg2hp0lgU1BdxLd1CM5diAllJJdA8vZ4vhIeJWezVN2/h
Mw5P1Xx1v7wP0ie7FqYIgPU7aDfjRAzypwz2iY3ztJmWGOuUG+PnmcQrOEnb
hXvv47xgPrgDBHLS9hu9PG3DPUOPo3tY/+DzKWy+L0AaHNSmNBRWUWgDo6We
rAuDOa7CzLEmOXmjwPWFzn3x21Q0kbwkhK1iaXWN2moXpvwiSV3zBA19zbIT
bYPr4jwNy+zAjte6iFoeAD3ppvRmBvkedHH652lq5O5PekjU/z2SmjYih7MY
NekPfoWakaMZPyAOt1nzOG54CY04CshOkykcFzrfsCHsC4WNbDOKDCWl+pgZ
IatX4UzaMIU8NDCE2OTnQWNBBJpX5D5hgH3iiArxEcQ0b29IeC4VF/0rEqfq
tG7+wnZYMSQzxLMGYEAQnGykI4wY6oDd/mFMurZ/oi7MZFzBfhCkoZDyeQzy
Ok6+iZMvA8AoCo36wCs+TAm1C9z6UwtiN82yZjvx1ocDW4ZcgAw4b5vmcyKq
r/qKCwCoB9RPvDmaT3LNoVFeylTtOVV67YJCuVrsnJY0OaQ76HkaHLqaKcgU
ZAoyBZmCTEGmIB0KPqueNLa31NPuzYVfVE+69F1Ghvru1KpKmDQ9aT8y2Ngc
89g0Mk3XBL+Iz7lTBRWmoxosP4pL1Fn18xep8VA7Q7SD6chUFG52MC8KHgHq
cqrs45l/64joVnTeLQBi7r3Euyd8mx7+fB8aiFbKzwETSokd7K3VShL/EbeX
ADlq1D3jZAWqihgxmpPENSLIX0yzcy96jiND7q7YGdCBCT3Ld/aBwWyciWew
v7/1M/i44UlLagMDFQoYOP5sH/iNYgVItIWFu7IDfMypURTs0fnPAsVhbaJL
JNchPwxUF43qtFnsMsiHgrdIJf4y3eqL8WfEDRT8QBvQmEFQunxOmC8PGoml
SDMZ8z9t0vyrrLodfHIVTdiNniZVOfwRHv4wCwpWhTv+lFsl6FpLRkaZUWaU
GaV+Wzko11999naZUY9DrYGeZIQZYSxCbTdfWxn5LdpPeWhEnP62zggzwvQR
nmsRWjOZnjnNxgl7VANV/xin6Oo/i7q/KjzzQJRWE7w9shk5c5D24/SrQh4A
49RaGVcWSUXrQmvxEu3t+0tt8eKfR9d6Ywb0eUDGrEOGvbfPqaSv/iUAowEg
9+I/ZRY16Rczd/oESLtq56dKs3haXFdzwTC3sNKLf9lv7tTIZLHRXEIqxM/f
U58fqSfo2N0RB2icMcGnFeKAfnGpzZJymz7N2K6+PzJ1S4TtGtH9HbwtjjTo
oz1gjtSnROI5T3eUEp1auRapcS+R/byZlkxLpiXTcjC0kMsnkdFAn+nC/D3/
E0DaLsmFJrqb9t/pVoGvqijkySl5lbo2DjLVtXTp5X3oTg66mvB7p547ldEz
tB5M5A7Ld/r59ICp61HLMWtF3g9Off1JTmiJ6TGQDtoR8Nq+8aSHAyVmGk34
0fpgUqrv7w87jJazNNGNQ0tx6WmPugRT31DXDnV8F0BawjX/uPrVOC6Zp++Z
midiaWlE2fFzgI4fiunuYE2vRvQTGW/Gm/FmvBlvxnvAePVKZb1gpxv1PhQK
9FyG1prtihY9xSgbTG3m5iVt6aMnjVS8WLNkL9T331mlNCU7qu3FBqBNn1WJ
kJOLpWryNCnff+wPOypAvu/0YyQWoSzYwfTgIqhK+0yoSSNmLI3YMZ0k7IoN
s4Ia3KJ7VwqxAzaQrwU1MeoKaXM86j/Xn5BVrluo2e2AxlHf/0qD3FuGy2iz
eiJEakQpRTQzLZmWTMv4dYuzGtGq6dT/2KR9Pg0iP2VQcpvMTfsTkPa5/arC
74I0dEZ7ItUiO0rnXRpsZBPMzQsyJXyXu5VGDin/DKRVTZ0ZDN+0Dtm21rUW
uFDvEYY9UPnbFhotiWBZ2MkyBO/YPCHDpjRlKymfj2VU0sSlgXUnHgDjgGFo
6UKG3Ru7ffNgfPwWNCRHzagJTKc5LKfC6Em7UKmIq9C8bBnGzE3cJBXDYyHr
5oirRdhTPIg+6hd8/ggBYK1vS1ik/StPaEWmCOylESsBjUetHNoOQqtRx8yo
WAawuUfOFhJs1LUGirenhj3UTNVTuFn58XIR+tmfJvCEWx+jVdGSUftvdI+T
ldIyYIYMWJ0RtIosApqnZkEPipEDjq/CUfT0w+/R74ihKlAnLf4EARqvk8OU
IqtlYaulYDdw/hQdkJW/7hsx14i+SEyUhjuaGjS+zBLNoVpwgSQR9fEoRpnB
/c0YNO3YoQ2ciJILDZ22hmtfjRC1scQX6DV2c6zsIZuMublJ4/4Pw3aa4TIA
yM9jKYndRgw/r5fdImwxcRjAuYSkQoAslNaxuqyygmDqrEtQSHCxwDqFtagh
moZn8kWJcUDGgIfSEOdPAOW8DtIuYdajG0GfwFnRmS1oowbC/hBIo9tQ95KB
zecqZhYy72mnD5NFOnocXad+zby9At4mwkWNKJFgzqmm5e7du5mWTMs2aPlT
9at7m4+Ypy+mQdpLBiX1hB8Bab+cyR21MBR6eNWHGYJLk0ZOJ5+NLVusDQ0U
2/RFORnaDo3uWw8prKROW7gYZiaNqi26d1aemCYszmeN3ix1u61so5qFR9GU
jZCjQCld7rFT0UMLM4krNTL7ncW1uJBGnMvAR1BUAEqeg2NPfWR9pnBZRAdT
gmoT7d3YGARE7oA2HJkc5Ckc3AhHnlpFMGfK60c22imAns4KEYe2CfWk816M
E2m9v7PpNvOu9B4vz/C6aDvJR4ej16FN7RHBs6dQhXF1/TbOKIHZlh57LLmV
P6Q7NGIZN0gyv2qnvyzGBor3XTtjA7UJaue9e/dGaSe5+vfKxp4ohBg3lEUA
lmOOQRHSOLWEcdsA5RLvhmTC099SEUHrKAo3ay/z48goX1Rdp1ziO1adA2wQ
FoAUvDCig6LrUNEJR/gdVFabpwsXI/I6kfeCGcnEDRk3CmX6g32Vmxn5mCyF
q3itwqKXEeHTLiy+Pj0AcwUA98ZleZzPFJJZqT57pg+CkXoWZH0CpKHg3cdB
GoououDqeUzOeU+/9FgaDNcOZN1XU8wTMfzYvH3cPAm1/llQHA2tKNKMmHtO
ktlzRqy7/Qg/NGNH7NWIpgwSZVoyLZmWndLyqOl27pinL5o+6tfSIJL6P+pI
74C0XwFpv5puFa6BtJ/cr2rRqkayLJkJWRoKaEzDRvbKNgsXNfUOqEVhEk2x
VSccOfdkZdHH+Ajnwn2LttyyyLTP+4iXuDo8ZHydIixtlbR5P2eF1N8pF8+O
tqSD17fX/0Heh8zMY9LEiPek3qpBlUw6UjhN/IggCVlHu3pX/ojePF4wfZ1C
ZJv14I3aD4IEmVbppqz93vhev17JkTMsPOxagRg3r4tksXHl7Xc99IYDZUCT
+KzxUWheP3XAphErli5KDboJYlNx8J7j7rCckXWYgPJ5jqyL2K/ITUHDc26v
SOKK4wVxWjg46rj1YJ+45bz0AJqzDOEa1gM4NM7tCEffesMBOEsJGpIuBGDK
UW17B4OaxvfFMrjEeBk/1pIFQZ3+2KK3agEgexiwQ1s2sB8gVrfpQ+yAEStV
Ed+nMGCnim4nZbVOsuGT2SRi8K8jam026vIoTVNP62sErwhCw6D17rmGgUBH
FyeM+PUu4Re3yRKrvUFaENkluGLM06EMuWQ2EztGvjNq/SktxNEDmauDl0Da
AyDt50CaEIm7BbKikCbyqqIQKbrdKpGugw4GpjgmXUSFwoqXQRritxh+vGle
3DBP183TeQCKLkZLRA41otO6/zLTkmk5QFr0ra+63/m/NAhCo8v/ZtJ6SLOu
/HBtTCpUU8HejY7UsX2UvnOufGa0aDdjj5YMKMbEbj6+6ZZgfvuSobErLS5k
sw+hZui0WhE0zHrkMtSHjKYWKPaq35KBlIBdvMHNBjvxakT7L4VI10Rr/b2O
3DDfZ5Pui4/LPOvFbGGIxgyUiFpmoi060VIyaPcBytcrZMNq2FNKmhgeQlcx
WTwwFO0Ra5H2E9Zggm4fR+pobKx2UEy/vzaiOzg2AD1EIDa1UXeFHWFZdQe3
1ObCiTwyyAfroiv67ceB6gn3iYBrhi8dwPzv+AGqP5Q4BrrQHW1DfT0zlmH6
hlY/HKbm4v5MinQkFHUcsENTyn3kILOfBwnnaGVHMVMf533WdlSLTTJlitKF
QK+Ab59xUBx+CoPcC/rUdQz9bO3rLCYMiw7dEtoA9LXczAtV3KHM/ENNRvvj
srnN7XMWWeCkICrzDyGfEVSbjvL3ZuCwwBy8cjPLBhYgH3nHRPOJ4m/JKQaK
PAoR3NsgK7pdjftrsR2FjhD+eZEYN028BSPNDonc5w8CIsWY7i3z4op5oo6E
NsHeAECfMm/vN08XXSgsMrxTDmlEicSsMi2Zlr2mRXcyCtFqkbmx0gPcfJfc
4Nv/M96MN+PNeDPenePVF0trHP+6feSfVr+6zL8dGHK91OnI4GCOArpjh71F
vjRC081P0xzmsCjsaf/CoINLgtTnrPr5a5W0K0NCz+K0M47tX6WnuakCWlPF
1kF1ONvDKRYlrCTgQlzX52f7W8bNGkoSHBbWmwUwmb0V2Y2YSyuz5xLQMnHG
ocX5G+Ha3EWJbk9A4v93ibOOScTmGMbeRnQLr6TLQnS9WOWyS+wE/b2jn6N8
ZUsDAxVCGBjFf5M4g1EPFc/W+gUe06u6ei2Gs/36oEsk0i/ecJkkRKqJgbRd
h1/w7coF2rT2j6lVWQNlFgnyUyO1RB1TIhW8ZoSMtm6Sufohk+Zfv9PtTBOp
XnLOu0xLpiWGluz6tmkh17eZIK4Kdwwut0DGSYs8I8qIMqKMKB7R2NN6M6KM
KCPKiDKiPUOk16xpW1l7f7S5+m2T9u0tUIDWGqLpPXJ5/0Fg2d9PvB7odgy0
fvPDIO3RQLxfb3kwbrIyiawJQTDfO+Tg9Ds98Wrhlb0sGQdBfQDoLflI6aka
XAuES2dbAmitMFuedo+Dl8CgSE0JECdyeD7SqLj9td7kqIP0oncYjYY+4LS/
qK2AwVll4qbY01Kn+Q8tHnICZH8dpry8Y+wVrJYqbla2WRR8RHmKIrBKyq08
xZEMKzsAMqEEejajDmgcYtOvpyFlF/oq2WVzKb3rS3ZVD4XYvLIXuX8awVrh
I7N7utS4Jj5mPJq81xvQHYhM2hspRGziFlhNqI2rVTZrlx3i6OEM7P0sE4jD
G99h8S3KddxpI8kN7JpIZoF3AAitzsx1tqyyJnRhirQfmzss+s/uHPcv2WE4
/eQTWQGZae3JQsTRmfWg+RrRnkgn9zgQSTTBF/TgBGRFt54h9ftWGhz4kGlC
NPhfCNP/5nOCc9PFpGRqMcp+Lw1maERTRq0zLZgWhSLTkmnZAi2/YfocWpGn
O6rSfbqTBrm/aVBSH4qOhkeXcKLh6HP7Xy104j06EB7lQ0c6PJYGS/S9AuT1
JeMx6nJO5t9mG3i6c+0akGffUMVq2H4NdGZnVu5Tr3OGVcLv3dZvI+4/JUMG
ve3Y7AIA7q+ySRV2ANC7m2lIFz74BzGhKyYivySQU9x92eN2lJFjh17wpJWL
XV9Wy1aOdY5EOU1luvpbZYgTPspdGuGdnCpZPL0pGMLtNDQThcrQ3EuQGRbB
DFMJITnoXkmh1NzOGaQ5rPFqMH7/U++QgvhII2kPdKROLGhyAErELA3G0SmH
s3feeWdypbFG96BhBikNuaW8euIJdpDJwTXZQBXDDxaw2MqgIIxPPaJ7jMj4
zqGoDDO691FvJvHeCyyTz/KMivHJ4R6/d5VIGGPseeu2Ecsvvg0kpAuQ5o3F
RZ0sO1gTEUFRmNOyASdWSzEa6BMhGnNK1r7NR4zsoDsg2TDGi9X/tUAXLnj9
NHfT0FGvlCZC9okqH6tBh8QFq80QBF/wM8BQGV7pFwdYPGdF9JjotFtpyLHv
3HFh9oDWwP4USEMqgg4zQH0dCuuhazzR9ZNohEGexUQG+EtITEw9kAaTG/x2
YPXpsFTUAIQIOWVR2iltCo1oyqhHpiV9Wt5+++1MS6Yl07I7WmgItGwmfCo/
mXEUVRMNraXJIlqq5PxBp21RbAku2moZJREbY8I2H99kSLBCfckz8ITqKNSi
pNROMI04gp58dazclmMLi1AsFc2syLzcqewi82iAIyYyeEZpA7BscDWoF0GQ
6+kQ79Dsafwg2Ri0XpnSxjRZtL97U7dQkS7uW5fA76YM4IsrZy5zJnHj82D5
GBHxLchADQs1yCMN274mswdfj8YGlUZaGns7aaAXlhouqDcnwaAbYBJVuL6I
n88pK4v3BpRNDpWEr70hP+fpvNwySG16A54D1A50AGxjB8tCfnIkP7FB4tS1
LGLHk9CjcFYFtFas9dkfrOq3L0RpYNxDHu1qrF4itPtwDyWNFl0R2YZl22Nz
xYWNT7nl6t0thNeLsZXLzIsD3SZuFjo0t9+10dCEnCvtaw4Tu2AoaJf4nZJW
TXjzdTN3gHabgT11Kt4lowKQUTC1N8idyDDmlXGXHei2RrQ7EO15IMbE3huJ
4qvy1j437Sau3CMJsV479OiaSFSLB3EtzoKsDxhA5Mf0Xyb5CEgjLaNI6S2k
eQkxUyNKxIGfaTlAWt56661TQ8v4o7ZPEzfG3zI5loKht6dlvBlvxpvxZrwZ
r433zTff3De8dK0kLdamzeHW1Nxz+ClbaXGfoXhlZS48LgT9Vt8vN8ocGMEG
/12RNHE7Bmlo9Yt/0bnlrAT+Kq87SsqPnv6e8VF9hxp7E/MW3YuGOMrqexTD
QssN1rfK6/RxqnLzle4TKXfphUIOzH84dRxC6u3poYBiNh+/KOpqT3lX2ba4
J7JBCJnS8dUBfBcWaeD8Be5Pp7xNc6si2VFVp0MS3dwre5Ho0jwxH3oiXdkN
wAvfnY5UlQug03rjNFbqfvP03TSqRzc1suOBzhlyl25lEiF8ctdWpiXTsk1a
xjuGTxM3JrqDcSwZJy3yjCgjyogyoowoI8qIdoHojTfeyIgyoozoUBBdaxEN
MfzHIh8ahst4g/FqZxI7wLo9Mu2DDz4wza2eaxgFdpSKXvw1wueff94Aonzt
Itf333+/eOaZZ5q3dW3V/yq9zlGT88orrxQXL17UOdRfdaqIhWahaWwBqc+T
Tz6pMll+3EXx6quvFjdv3jR51PNLL71UeiktAylFPPijnbfp+q3ihPqo2reV
UexsuYQID2jaErxdQ7blpl0e38qP+q7bhILUDQud/O0LRW77aXn23HPPGUAM
/0zEXzr4U2yhF154Qb9V1SsZX5RQDmwh5umuW+jYQFbS3wqv+ttqhnrfcvPO
nTs6Tf2daT5SmotnDV5VQxVrVNFRz7aQAt42x1oIRWJnscSm2K6qk+KyqNIE
WRzYpLMGfsue9qv+50HAysm1fkagmRY5MUFbleaAolkkRYm0WLszqB1iDHLE
6zHtNA8si9LQuotZIOQEuLs0yrwec3VK2++pdKoSGzB8XBeywjU+FRfHKfVG
WOkwtbYI9U2icVuTQvX0KqXt8VVjO81gDwFrCfA1LsoKG/e8k1V9NzPKcfN2
YfCEkjpsYBN4kUDDV85YIQtqezRXKx51WYcrPEv9X/uWJrwrg3IBcDkGpjAn
sQfmll/K0OpijbItUR1f2GUTHTVA2ymALXSW7bDQDGkztRnXNYNquZRyN21a
sE5Q5W6luuVk6LTPnrGpsVl1MmLX207zFEJbfRWAdevS6pwxkzuZWTtQxsca
UPbMVX3U/7RbkjZgXjNPD5unv9od2bYaqo9q7VCyqUf9zvYroD1wupO4bMj4
sHm6vkvSDs2HlfFuEe/1tgs9JIcw9IKrP5X+RZv3J/b1a7uCHy0wFvLNtlrG
SpgK8kc3DO/111/P8DK8DC/Dy/AOAN4Pf/DDDC/D4/B0uvr5mH6sOKwAUOpZ
gVNf/fRR/TgvXnzxxeLevXs622uvvdZHmr5i9BM6d6XXY1k0Tldi/fuUfix1
OTm74cwn1U/tc6nLf6bJc+b/Adm25jI=\
\>"], "Picture",
 ImageSize->{317, 487},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],

Cell["\<\
When a group is closed, only the first cell in the group is displayed by \
default. The group bracket is shown with a triangular flag at the bottom. \
\>", "Text",
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnL1uE0EQgM9nOwYJUAQSRZDA6agApeBXUEVQUeYBIkQEBQKFSHmEiC5l
0tBQ5RXShvzK+XmB1HR5hWNn7na9d7lz7GDnjuQ76dZ7u7PfzM7M3p+dvJ9d
+PTxy+zC5w+z7Xfzs98+ff7wvf3267xpqteCoPba7H/agdSjILBFGOlmqq+k
qCUHddsaS0n5Mr9fPqJodXX1uRRhL6H9/f1nUpgOI+roQxEPPclk047oiRTh
uTip6T/WakOFj46OROyMCWdRzqRHWm3aRh8XwIMHDx48ePDgwYMHDx48ePDg
wYMHDx48ePDgwYMHDx48ePDgwYMHDx48ePDgwYMHDx48ePDgwYMHDx48ePDg
wYuig4MDePDgXRDv8PAQHjx48OBVkFf1+zV48ODBgwcPHjx48ODBgwcPHjx4
8ODBgwfvf+BV/fsAePDgwYNXzd/TwINXJk9Y8ODBy+d1Oh148C4Nb29vDx48
ePDgXQHe7u4uPHjw4MGrIG9nZwcePHjw4MGDBw8ePHiXhLe9vQ1vAN6kFIq7
NmRyW4qWtLWGTJ6wNkfeiEDHBwklcCPGhqz8vlZFU2QHxHpDPag7RbHa0SsP
7fiLUd7wlcveKGnezZL0NkpKshHrvSXldTlUaGhDK/iTkxMbba3HDCsQpgeF
6eHdNqNwcXHRLdauXDPpPT4+jmZmZrpZbdrkWNpjidictbW1aHx8XEny2el0
Ak/NmNqYgHSfmpoSIbdSRGZ9fT2anJx0MlJfWVmp97S03qeleT74UXpMTa94
QnrN7N1kxJ2Jl3IN7yO09ZxeQ/byJp6Q6UnyRzcTk5afHl7MYnnbIcGyHdZn
c3NzlhNk9IeF+uu+/mwOVyJCS0tL2mum5yJk/WKS8rwR6qavF6HrjizZnySv
ftqVYfqdN6enp7XNfJo240evLb1MDF6mIVuyFFPL0w4S5TYcJgkLjQ0HNbaK
cZUflmRzUdoKcvGcIQ0TvnWP3cxxkBlpBvhSpp6Hzqwib3h6KTWL4jaARRWJ
WCtRbi8xTnmer/8lTs0+x+a1Xevp797kCni35RazuebqaHvek0XcnVLmgtHL
6wWieSHIpH40UJaeuW7ywjWC1VIw30oE195SyJleNnvGN8FOh8G/BJgM6BXc
PNHc4N5Mico2mqtc9vZ2zOnp19TzXdgKfFGBwDdSTwrFidpKzLLpEY9NeSUr
Eh/Z3qabV2RVmnmd1pW6wSx4JvEvzNZfcvd/WutA95Z5c1wqM0T2/Y59BPCS
zr93GFOHWCEvm3OXZatIOolp9iQo0klWO0/2+9jnP7HJtdmcZIrvIOxjnij0
lq8CTHR1SMa8wR/uip1VwmJ8kKC8J1fd5aHhtjP5hqtNuNpdV/tVntneMtRd
nlD7Nbt7Rv158RPQ95x6krjjzHjoavfKNE0FrtA7LBVQj+tbSm9ErPbyTjr3
lbiUF/F2VlfASN70j+7biap/L3PVeVtbW/DgwYMH7wrwNn9vwoOX5QXaYYrH
Wm1kWX2gZBOcaNbaI602o+XlZffvSjY2Ns4yTf/W/alCG/qzJc/G4Y0w2zOt
1tUu64PT4s4zL6SI36XE498kIrW/eSg7Bg==\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{317, 487},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],

Cell["\<\
To specify which cells remain visible when the cell group is closed, select \
those cells and double-click to close the group. The closed group bracket is \
shown with triangular flags at the top and bottom if the visible cells are \
within a cell group, or with a triangular flag at the top if they are at the \
end of a cell group.\
\>", "Text"],

Cell[CellGroupData[{

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{504, 396},
 ImageMargins->0,
 CellID->597271799],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{504, 367},
 ImageMargins->0,
 CellID->1977836416]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To open a group of cells:", "Subsection",
 CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],

Cell["\<\
Double-click a closed group\[CloseCurlyQuote]s cell bracket. \
\>", "Text",
 CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["To print a notebook:", "Subsection",
 CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Print",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Print"], "MenuName"],
 ". The notebook style will be automatically optimized for printing."
}], "Text",
 CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["To change the overall look of a notebook:", "Subsection",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{331, 464},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],

Cell[TextData[{
 "Choose ",
 StyleBox["Format \[FilledRightTriangle] ", "MenuName"],
 StyleBox[ButtonBox["Stylesheet",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Stylesheet"], "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],

Cell[CellGroupData[{

Cell["\<\
Select a stylesheet from the menu. All cells in the notebook will change \
appearance, based on the definitions in the new stylesheet.\
\>", "ItemizedText",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Picture",
 ImageSize->{367, 464},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tips", "Subsubsection",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " comes with a collection of color and black-and-white stylesheets."
}], "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->1639256826],

Cell[TextData[{
 "Use ",
 StyleBox["Format \[FilledRightTriangle] ", "MenuName"],
 StyleBox[ButtonBox["Edit Stylesheet",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EditStylesheet"], "MenuName"],
 " to customize stylesheets for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks."
}], "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->921767219],

Cell[TextData[{
 "Changes to a notebook that only involve opening or closing cell groups will \
not cause the front end to ask you if you want to save such changes when you \
close the notebook before saving. To save these changes, use ",
 StyleBox[ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Save",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Save"], "MenuName"],
 " before you close the notebook or quit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->194620275],

Cell["\<\
To close a notebook, click the Close button in the title bar. You will be \
prompted to save any unsaved changes.\
\>", "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->365367544],

Cell[TextData[{
 StyleBox["Windows:",
  FontWeight->"Bold"],
 " To close notebooks without being prompted to save, hold down the ",
 StyleBox["Shift", "KeyEvent"],
 " key when clicking the Close box."
}], "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->1076565235]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Word Processing in Notebooks", "Section",
 PageBreakAbove->True,
 CellTags->{
  "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
   "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
   "Section cells", "Types of cells", "Notebooks", "Close a group of cells", 
   "Open a group of cells", "Print notebooks", 
   "Notebooks: change overall style", "Styles of entire notebooks", 
   "Style sheets", "Notebooks: formatting", "TraditionalForm", "textcreation",
    "i:56", "gs:0.9"},
 CellID->76230939],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " includes many commands for word processing and formatting."
}], "Text",
 CellTags->{"textcreation", "gs:0.9"},
 CellID->161474001],

Cell[TextData[{
 "You can set the following cell options from the ",
 StyleBox[ButtonBox["Format",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
 " menu:"
}], "Text",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->198042704],

Cell["style", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->472724620],

Cell["font", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->46084352],

Cell["face", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->100191046],

Cell["size", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->480238683],

Cell["text color", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->846422307],

Cell["background color", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->95034122],

Cell["cell dingbat", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->230583829],

Cell["magnification", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->63371158],

Cell["text alignment", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->1635454],

Cell["text justification", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->772480255],

Cell["word wrapping.", "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->202989947],

Cell[CellGroupData[{

Cell["To apply an option:", "Subsection",
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->366665031],

Cell[CellGroupData[{

Cell["Select the cell bracket or some text.", "ItemizedText",
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->83982296],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWrlSwzAQ3VjOwX2EioLJN1DwCVDR0mcYZqBgYID/4OjyAVx/wPEN+QJg
ho4fgCIFGK+Ola0oCYctJyBPvFrvym93dXkVe715tL212zza2Ww21g6a+9s7
m4eN1b2DWMRKAKUQADYagHwUs5JE8S8qIwFgWHBxSRBxxWQpjn76drsNH9Bq
tQK7Hst3XothLcL8bc0Aa3aQDb53j1HzjdOQ61GLZ/9oTBSUvXJapusEEngo
D+WhPJSHGgT1iBSR4jVdcZPZwT9zyvCKc3iGFtl4diaXkOI9ESPuviA3DHhm
kd26d62OlKVbKEi3WsI4lrPqDrhy7+48p1MpeOXYoJJJBw1dqIc5Izt4Xo5i
eOm+mkKu8sf6qma4qHEBrosKc/yrYeq5ZvTVNIUMyZAuKO6KizjK1jjKFn/1
KkHgQjltzKWC+kWvbDXyNCDZrJKJmRE4aOAVyxpzbmnYnN14MqaWNJuz1cc+
oytn0w9IKw5ifPHwHv4fwtO+wclMruKV+UDKwxAt1eJkkqo6okb+bggkYV0p
cn50LiI1tk13Rfryhb3TTUH+LXBaJXhbychct45nSzxFr6YGXSTvUdrjoY+P
dct4ljGmxpBOGXvHatQbtajnyPMaeV4h2dmIRaP7cIJiGLP0XJW0p4VGmN4v
gsz3Y5eTVns1gNF1Roi0h4CTQkMcvBDatmR18l5zxU4tSxw9d2h6OZjptUSE
Sub4Cb1MxueIO1EhiPdaqmF54SJvCcgS0KF4x3mT6BXnQ0zu+NKjAW0l/uvL
OCGdzw5Up9P17ECH842Dh/JQQwyFxw8/UOiISt147j7ReJeLbLJh+nxgInIl
sSDLr1Og9AkaEg8P\
\>"], "ItemizedPicture",
 ImageSize->{260, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->237510254]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Choose the option desired from the ",
 StyleBox[ButtonBox["Format",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
 " menu, such as the background color."
}], "ItemizedText",
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->252512777],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktuE0EQLU977AnxOAkfiQULHyBLzgArtuytCClZIFDIGQhIXMAH4Cex
Y4U4gw9AkNhxg2SRRTJMVffUTJfbDoj5tJO2PNXVH1e91+2umSn1k+nR/rPn
06ODvenk8eH05f7B3qvJoxeHeZPqAfT6APB0AqhnuWpEln+zGAWAwoKae1ro
mjKl/qzqn8/ncAmz2Sxy92N5QaMUjmKb/zsywpHnqEb/9hsx8oxkn/qxF6/V
bKQVbDslGXO9YgmCqRtm6kTvr7wSsTauz/wvkgprpOHVd7SN6nP5QO+zvKJY
+94RDGFeOdq+tQ9tB6WyZyiyZ63iHMvt4hfwqX245BxSy3wB7KpSGYCijxpG
DBvY5sd1pGevVYra4JqtVSIglnYBPndF89bf0iz3mlirMVOGKqUPzHvQBo/Y
ySN24C2jBBvXnWOxlzpalzKyJYw04rbtok3vjKiFCX7oiDHvHRPbMIyfYmsZ
tw17PVnx72rY9Q+UgxY4/g7mg/kbaJ7fG1rZyUOsyRtSzY52UX6Bd18za7B+
3wYRw11P8k1jAShQKCiasK/he2rAErAELAFLU1juoxT5mtQ3fMK8K/xveoT5
Nskhm3eVit0t9hGXTeRCiYShYYUf1PCKuff1unFWi23lyzaxJtcRa0v5i3Fr
PhO060bMJkHNPOIVbW/Xm6FY65R5bThWeMi9b3xibSfIwCQ4cgZVr8smhTb2
2F5iQTvh3mOfaF8dgF15KYKxxYzu+LlVHdxE6ipdFpq2/A1DuxxOKMG5w5on
/yufHoICloDl2mExYSnrMHuSWID0AKtsL6nUt6Bk+n7lw1KV69MtFhyPl8y3
oX966KnxXEKZVbxbn9EyJ3qvPqN+HhsJpho/tXWuBy3aa+/c2oWJANWJWXHq
Tr+I6GhhjuxB7w+bm7x/\
\>"], "ItemizedPicture",
 ImageSize->{260, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->116242518]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To spell check a notebook:", "Subsection",
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->348446821],

Cell[TextData[{
 "Click ",
 StyleBox[ButtonBox["Edit",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EditMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Check Spelling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CheckSpelling"], "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->2803423],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " begins to spell check the notebook at the position of the cursor. At any \
misspelling or unknown word, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " displays the word and recommends a replacement."
}], "ItemizedText",
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->302877301],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "ItemizedPicture",
 Evaluatable->False,
 ImageSize->{524, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->902498814],

Cell["\<\
You can use the pop-up menu to add a word to the dictionary associated with \
the notebook, session, cell, or your global preferences.\
\>", "Text",
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->556406272]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tip", "Subsubsection",
 CellTags->"i:122",
 CellID->192434058],

Cell[TextData[{
 "Click ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Page Break",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PageBreak"], "MenuName"],
 " to insert a page break in a notebook."
}], "Notes",
 CellTags->"i:122",
 CellID->1725992692]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To type a formula into a text cell:", "Subsection",
 PageBreakAbove->True,
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->27436672],

Cell[CellGroupData[{

Cell[TextData[{
 "Place the cursor in the text cell where you want to enter the formula. \
Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["(", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["9", "KeyEvent"],
 ". A placeholder box appears in the cell."
}], "ItemizedText",
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->124289792],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1u00AQ3ti7TtvQIlpUpKaHgBDlAgL6AuUCJyS4wimqkNoDApW+Ekh5
Ch6ASr3ldYxnbe+fZ2wn8cZusBVv1p93vtmZnd0dJ/4wvb74+m16fXk+nby/
mv64uDz/OXn3/SqBwgFjg8eMsY8TBvU4qWZFnHziJ1AAgtcFfMnmR1CEKRoq
9NhFkxKO+XzOZrNZwpWUj6AIiJZQg9ayPJTVUIrmx8oy3JJJTmngARRBlaxw
ZTOrkuOBvMXdm0U7I5SDZY6+X6Kn5+q5eq6eq2kuYIl3GiTkanGWl/Lcaob/
NYBDFv+5+bsZStjZqUclIwDlLinHRErmopmExALVzrhLiqUSLMsHoOdnp6rn
t56tMTbwrD+BI2Vap24TUqEF12LCRLQL4Fte3fjzw64alIoOC9x0jsOhouUt
GDVytC9qlKBCOGrLmD5S2T09KNwaFCuANWGoBszB3Ij0vNIcI/7bh9L3gl2i
2O92NFZOf7gOdWvZYn0nIz1/u/yfkcny25+6L4i6X/7U7arFj8zOpKzc+KL0
MsZzPPfXkjg28z48vStK6PxA1wKl3FHJVZ+NFJJbTXLAtUyJO7qwDJRMV0PM
e8JqnNdJJwgEw3hJDbkWjLzCrsJ2KdOCE3/htofGSDoWJsaKwYFhWNhR7Qg1
RJq6ROrjmo6K1Mq7hONsk62iY5FDB4dorGMVyt3fPitHkmhaqy+EssXgYHlP
143Ppx2aTTacLw3Ys05sPSbVnTVRiTsF2dla4zr0MSeWdh0zHhYKDCuE092f
EHgYPevkJMiOYQlsPxcadFz3cMF45yXjuoYod3IL74Fdqa/FWMZFsCT4eYcC
+P/NiYIFhODosyG021XUG5cP6eXH+SOCI5iONE7J4o9alqzzHEst9YVdp5xf
9khQmoj9Dfup0x3o/FAOrLBYBZKwKQ1yNxRU/01lVU/fRPhqQ1rJLGxsgmAj
BNsrCwS76TaCuYsZnCcIto9gYwR76c9zpf9M2HHxtr5TPnXEsG2oYanVFoK9
oGJbz0pswN4g2I6SOFK1V/5slWQDKGB07sp/95Ks8ZcNuvpWRc/Vc20mVxNv
QSJvYSbtDtLGADX81udqMvKE8jC7kcukV1pGOmGsfUC+SWvW2eAfiyaUgg==
\
\>"], "ItemizedPicture",
 ImageSize->{289, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->720190720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Using keystrokes, enter the formula (see \"",
 ButtonBox["Entering Notation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EnteringInputInNotebooks#310290317"],
 "\")."
}], "ItemizedText",
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->337585897],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztG8tu1DDQm9c+W2C3UGjVskiIcgEh/oALXODAEW6rCqk9IFDp7yDEoZz6
C/2EHvs7hMzEsR1nJo8lj1bNSvU643l5HvY4635YnR59+bo6PT5cLd+drL4f
HR/+WL79dhKB3IEQgz0hxPulgH4YdWWDn31ohHDjpwi8A81APrgJVFLw41dX
V9H4+fn5Q2gcGgm+QkDdRnwXUBX3WtAdwETIAhqnGqGFiaN3sOshMvCGv/wZ
2qziaUSfTez6CdBkJ3p+Pb+eX89vTX6voJ2E4cVltFQh8OIS/6L+DDou9Lag
9xNQQSjg1yp/CuyRcBM1cU1NxALa34gNA2HyEaOa1ZgRwn1oPcmkO9WQZmy5
SX7j2KRL7Qy5sOdN6XAaKWXvt6UY5bMpARt2aT1KybGy1bIFNSaxGkKWK0id
IYt6jsKzCjySTCBF1PhVXHHXgikuDoGsRMKztMuvFmyVBHfCX5pGBDY4PcxQ
uSa4HCeChDLwSK3gcxnn1tphmZkyffPhN1PRUzB3n7aiR4Ndxdbj7LOHbWCv
VMm3p7KwDTNM0vpWNoNMs2wSBtz0cVYPJG2hIawVvSWD3JRU25flApVY7cbR
VMeBZ8YBdHWWOYoZogYEjE2bx2pZiadmDppLsgSLhie8S/hpzun+hFjkhi14
pZKSuvK+p+rPNpTcUVGwxam2QcB22yqVPMJ5VNXemkK+CvlO1ZgrNfbaErno
aL6hDMxeRrGMT4q9XnP+NCvyMyHyrFmRs9iSIud8gls81kdBerOz2Gt/mDt+
asvMHHCyFLrw1D1HCbdEekpn4xDlmSjGVsyQW7KoMxh7YNPbvWE930RO+rwR
fAJG8WUlaPcyjPh5ZUoc3CwPlFsSr9QachtknMT+EKbMbIDkBk0JPEYMcwZa
o8J1y5CUKq99y+AGepFiAWENvzbFCoS75TiJIqGldGGEVQPHjNeydNn4fKpg
mkuXGeXZk9WvmpgxJkUYcJBjUp9VtpRvhzms186LtU2nTEBx+I+QuvlJQYfR
M6WvprweiSDiTXCYA9aFhiXC04asGPNejm9biHSrzmg8uAvldRjPNAlVED9X
Smr0vj5SYE45rUht9ZFTgUjk5sWtqoy4M9qtqo30MmT9POcRMB1tHkdLH79S
tNbZllvyM7tPPn/UyOckMfsc9cradrZE1QYsmHGYBJOfZmkwt8NBCO49e87J
lXJoaiKdVRlp2JKATQnYpuUiKX9IoI4JmL2owdMBAZsTMOrF+stmrZf7w1Q6
Pt6UN8zHazS5scoBS/iIgL2AlopznaGU414TMP0bqP4pQl8xaWS+iAAOqvNa
EyI0/Hb3L7R138dChGt8X63n1/Prip/AAbH21W685r6IMbOcu7j1jg/b2E2b
Lece/yO91cX08j8BxOAf3/ylCA==\
\>"], "ItemizedPicture",
 ImageSize->{285, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->380209]
}, Open  ]],

Cell[TextData[{
 "Press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[")", "KeyEvent"],
 " or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["0", "KeyEvent"],
 " to end the formula. "
}], "ItemizedText",
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->927649]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inline cells", "Subsection",
 CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
 CellID->322561406],

Cell["\<\
You can copy and paste entire cells into other cells. For example, you can \
include typeset formulas from input cells or embed graphics in a text cell. \
\>", "Text",
 CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
 CellID->60550783]
}, Open  ]],

Cell[CellGroupData[{

Cell["To paste one cell inside another:", "Subsection",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->60125091],

Cell[CellGroupData[{

Cell["Select the cell bracket.", "ItemizedText",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->392481106],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUtOwzAQnSRtWlhQRJEKqK1yGlggDhFVSO0CgUqvlbvwkbJBXXMKCJ7n
xLRuFQFynCg4kicz4/F7Hiep7fomXs1v7+LVYhZHV8v4Yb6YPUaX90vhCjwi
b0JE1xGxngk1F0GGS6gXLLzcCAqvjCqpT9NU1CdJcsbC3x/Et4xDR4gPOFSh
Gwn3ORKeIQv/dw21SNQOoHYQzNhcyjPUoWQa4jqC2i2cm3Dk8Byew3N4Dq8V
eJ8sgXRoDvSDZY/NA8OgwidtFLQi5ZMQPcOUQJJMqqJvjuOEZchmuJWgbIjp
HK58Zic55XN5ttC7U5Zo09/Tu66q1RZgL1a7Fiq2UA3Xa+2D06S+NORBDdSQ
1PM241vrsPluNW8bbDZ+qxzHzzmOWU7YfGpJRo7j/3GMWWJ18maBbcoSbdaO
zSQb5jwfbSpbLGuU39N8kSDuBjcEY5XZWlFjpaPWFIVuklVLc2NDQhjj6j/5
sNrnWMnmrZJtJgIavLd2eO3FI1TQn/92xxHEUEbuItdxIgFjBHV72ErOWM6L
eSXLR3Oah3hfXCYkvQ==\
\>"], "ItemizedPicture",
 ImageSize->{285, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->524443848]
}, Open  ]],

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Edit",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EditMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Copy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Copy"], "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->71653346],

Cell[CellGroupData[{

Cell["Position the cursor or select some text.", "ItemizedText",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->442807251],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWUtOwzAQdeI0KiwAUaQColUWnAUWiENEVaV2gUCl18ppEFnyW3MFMJ7n
xPnQRqJynAjZUicznuf37ImbJs1tvF7M7+L1chZH16v4YbGcPUZX9yvZxT3G
vAlj7CZi5AvpZoYLNOmek/GygOe9CtWQT9NU5pMkOSXjbwbRQRB0DDwnqGY3
AvcJiZ4RGf9vA2tIZA/hBgATN32aV1inUsuQ7QDuIO8s0zHH5/gcn+NzfI7P
At83WWIS++ZIL8nuUfiMmIuME9HQnNAx2ZDCUAtpJTW+JKQTOXcN/9TuZE/I
Ysxw22SR9TdkfQvFLOaHYg70KF71rE1ja5l6N6GenLf6dUGrdbPh8e0M9MRs
XBCKWny2KwQAdxp90TgiO7Gww/5LwZxGvzQuyOJW5q1doSlZjPlwQrsKveee
ydvmgr6+BeSRGRTCXsMP8yvioFyw1hb1oklFpRle3BfZ0PAqAOjxY5zjc3xd
8TEk2M7/kONtwUghfzN38fIAwRhutWwNr0POyKhHQDV+mkG8H4wgh1o=\
\>"], "ItemizedPicture",
 ImageSize->{285, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->691614683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Edit",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EditMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Paste",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Paste"], "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->151303034],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWctKAzEUzTxaiwuVVqgVlC5ERCj+hS7EjxiK0C5Eqf2t+QwXogsRHB87
P0Rj7slkOo2laElMZRLomZvcm3PuTcMwMzlLxoPzi2Q87Cfdk1FyNRj2r7vH
lyMxFAWMBTuMsdMuI5sLM4eIowlzmyDIO5EalVFz/FmWCX+aplsE4ewgunAK
bSM+otCC3Uh4SJEYaRGEv5uoRcK7DjNGMHHTb36FOpUsQ7Q1mDU1WKZjns/z
eb6l5fskJCa+ajhJhAlHTodew5zGgUpceJVQoSTJtLv8nd2EDoFxOQ25DCpF
WPd/kYS+FoQremJFn7lJq0bo7H+azuXJriT2KhSf7QpxKWRVo0lYp259xkq+
2xXfJMSchktxVF4rrCZZt5Wo3Kl4u1j2B7uS2OO4lXdm1GtZfFKvA/GjSkj2
CKH4aFeISyGv8QONDcIedW/+fzFeo3oae4R4MnqxK7RPiDlvXmhRoVdlmXzz
ndDrW0BcmUEh7DU8ochXiri8YNaKygpSPtUMF/dBWDdcBQKW+EuM5/N8rvgY
HGzhQwEckLRk5HdmF+cl6OB9UVu2OSdAHQL5tUzO381Dgi95zyPM\
\>"], "ItemizedPicture",
 ImageSize->{285, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->182193520]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyphenation", "Subsection",
 CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
 CellID->340052456],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can automatically hyphenate words in text cells. When command names are \
long, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a special continuation character (",
 Cell[BoxData["\[DescendingEllipsis]"], "InlineFormula"],
 ") to break the name. You can control hyphenation using the Option Inspector \
(see \"",
 ButtonBox["Option Inspector",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/OptionInspector"],
 "\")."
}], "Text",
 CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
 CellID->827926029],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "ItemizedPicture",
 ImageSize->{252, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
 CellID->117325894],

Cell[CellGroupData[{

Cell["Tip", "Subsubsection",
 CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
 CellID->122462755],

Cell[TextData[{
 "To create a new cell in the most recent style, press ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 ". The new cell will appear below the most recent cell."
}], "Notes",
 CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
 CellID->122297441]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating and Using Hyperlinks", "Section",
 PageBreakAbove->True,
 CellTags->{
  "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
   "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
   "Celltags: creating", "Creating cell tags", "Tags for cells", 
   "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
 CellID->35878200],

Cell["\<\
A hyperlink is a special kind of button that jumps to a different cell in a \
notebook, a different notebook, or a URL.\
\>", "Text",
 CellTags->{"hyperlinks", "i:11", "gs:0.10"},
 CellID->167643723],

Cell[CellGroupData[{

Cell["To create a cell tag for the destination of a hyperlink:", "Subsection",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->406317831],

Cell[CellGroupData[{

Cell["\<\
Select the cell that will be the destination of the hyperlink. \
\>", "ItemizedText",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->140303210],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "ItemizedPicture",
 ImageSize->{323, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->162327058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Cell",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CellMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Cell Tags",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CellTags"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Add/Remove Cell Tags",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AddRemoveCellTags"], "MenuName"],
 ". A dialog box appears. "
}], "ItemizedText",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->330821102],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "ItemizedPicture",
 Evaluatable->False,
 ImageSize->{456, 374},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->244938124]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Type a word or phrase that will identify the current cell. Click ",
 StyleBox["Add", "DialogElementName"],
 ". The phrase is now a cell tag. The new tag is shown in the list of tags \
for the current cell and for the entire notebook."
}], "ItemizedText",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->379618602],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "ItemizedPicture",
 Evaluatable->False,
 ImageSize->{456, 374},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->111599595]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tip", "Subsubsection",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
 CellID->466062922],

Cell[TextData[{
 "You can use the keyboard shortcut ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["J", "KeyEvent"],
 " to open the ",
 StyleBox["Edit Cell Tags", "DialogElementName"],
 " dialog box."
}], "Notes",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
 CellID->311240708]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["To create a hyperlink:", "Subsection",
 PageBreakAbove->True,
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->410966860],

Cell["Go to the cell where the hyperlink will be placed.", "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->257750023],

Cell[CellGroupData[{

Cell["Select the words that will represent the link.", "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->627630235],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXF9rFDEQT7u7d23VWtTaioInioigX0BFRGoFreijqA9FBH0QRX32+/QL
9UW/y3rJ7ibZ2d9Mstc7msM92lxukvmbmWxmctzB4a/Pn74e/vry8XCy/+Pw
++cvH39Onn37MQVlK0qtvFBKHUyU7pfTbt2U07/ypW6UyvSbAT/XzUoFrcCq
eUnjx8fH0/Gjo6Onulk1nzPdtdhdHP1e6pl7i5pu5DB6PtFNvFhophl9ZLq5
maSn6H+jcDSpSo1p+9B0Cwv0yKmB3kBvoPff0Put23396a3uaZrTzarb21gE
yw/mc6bhlXLT/zwStjY/gdYseWXJT3Rr6LxJTdx1IO51AtOv18sg+A0Ae5Wa
4BtASBMaBpRbV+mQaqbUAjavZv6qwyxamE2fWszyGFn0jDB23NryZpYLkqgh
kYXprhL0+j2vF4KowIoyMt1RR+X6PbOsiFydZQADrBJ2VYigLV6ez/iCvUvJ
F7GIGV4DZDdxKgPGTJGP0lUPkgax1Z2asXqACIGwHtxZzxyhIKjH6S5QfYqa
6uToTMVerFr7x4gihflE8Ubo79OIBOR4kqMyXlXMEAmsc4wJf/8duWDpPwm4
3XMBgcAqUCyD8/egWtlu3Jrqm2Nw/TjXL5lnsLNunNPXL/G0sAB/B4eGMedd
SAje6wsMHjz8ZB5ekRrTRWhptuDjTtiPZthfUzgFpbr542N8d/Jw9qlI0czR
t4AzKFqZnEjiY67aCUH6Lklj9kWXhJF0mcBG0KcbDq7XfZAUnAgK554oe21J
C5+q8j7U93kZyGOFR7hLUhk9DDiRqsk+ULMAMFRdORs5z0ixo5SiHr4JYBsA
dj5xg12INM6Wbu8ABa8lpOBjILjbaS7a3jnbM+qfB2pt68bExBYYPZOQ0smV
uweBQgIZgjcHWagsF2xcllVcpiMVecT+BTvN/TTEvQRE+wNg99IQ15BCB2SF
j23zuBdhbkMcQfYeo2ydFuWzh8Umh1HmxIszHKAisoydwacfgHLvXKWgYGVV
Y87IUj4qpnqhGy0293Brl7UnZ2LPu58J575BEZHJd9IIuHVCyo8AWmnzx3pX
QwI1il5cApUDtEb01t3Nk2qY0picZVmYq/6hzQBK1K9yWlCwt38IPtlNbnm1
gpw9Dr05g8Atm217hlQ4au2i/LaYyQWiSF9OP/jRM2Xmon8g+APDbdvFXOUT
uaUrg7BOMT6IaqmSXaXri6gtYdQzhqV7P4QUtW5sUYnFY4tkeYSpmW2wx6OI
xk4opBmOu/9Z+GLbyhXHPMKL5h+rwhdtqiH0kAElonkF6BiSCRi91z3RjGR6
bALMvWl7VT3VcoGLFKs5Wv5QhEoGWIIwLYiXgCCZ+1EbuW/4yiBAGpFh09IA
rDIkI2/MicFl7ZBTQIn5hzJQjSk6hA/WEt5JYp09xwRWov/pW9Kjb/gv65mb
xlaDKpWESHUiotAhEULo3fOkJxS+8GSyPQaFHqh9qZzRWmrColfZbEgM+zVL
wwiC0m/CoRqUv9fiZktfw4G1tOpTa5SULhnbywUraacYAyRCssvzSkpBgreB
qyCA0Pf6dwDsDIBtCrzYr+J7VR2MuQswtwAMbQfbAt3by7lADyIXA11Aj63B
Xf183cKuAQx0ZY0MfQXAbqVhYHcR4mJ21/Ye2t5Z29sUfXUfYDh6iXiVIZjI
7aMhONGN3iTL0WCN8rpuitO0xt2B78B34DvwHfgOfE+Pr4HrZsZfyTA/IPKk
mtmlfBo/IGLMs1dbzDev8Asp5jt0VR5Z4de/saJW/gHk8eZ8\
\>"], "ItemizedPicture",
 ImageSize->{331, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->54001265]
}, Open  ]],

Cell[TextData[{
 "Choose ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Hyperlink",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Hyperlink"], "MenuName"],
 "."
}], "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->625424405],

Cell["Choose the type of hyperlink you want.", "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->549712507],

Cell[TextData[{
 "\[Bullet] To link to a web page, select ",
 StyleBox["Other notebook or URL", "DialogElementName"],
 " and type in the URL of the web page."
}], "ItemizedTextParagraph",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->125044020],

Cell[TextData[{
 "\[Bullet] To link to another notebook, select ",
 StyleBox["Other notebook or URL", "DialogElementName"],
 ", click ",
 StyleBox["Browse", "DialogElementName"],
 ", and locate the target notebook."
}], "ItemizedTextParagraph",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->45672800],

Cell[CellGroupData[{

Cell["\<\
\[Bullet] To link to another cell in the current notebook, select a cell tag \
from the list of tags in the dialog box.\
\>", "ItemizedTextParagraph",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->193422084],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "ItemizedPicture",
 Evaluatable->False,
 ImageSize->{380, 311},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->282059674]
}, Open  ]],

Cell[TextData[{
 "Click ",
 StyleBox["OK", "DialogElementName"],
 ". "
}], "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->1005432286],

Cell[CellGroupData[{

Cell["Tip", "Subsubsection",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->4542761],

Cell["\<\
Once a hyperlink is created, the link is always active. To edit the text of a \
hyperlink, click near the link. Using the arrow keys, move the cursor into \
the hyperlink text and make your changes.\
\>", "Notes",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->1899898911]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Working with Cells and Notebooks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 34.4567158}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "Mathematica notebooks consist of sequences of cells. The various kinds \
of cells associated with a notebook's style sheet are listed in Format > \
Style. Double-click the outermost cell bracket of the group. When a group is \
closed, only the first cell in the group is displayed by default. The group \
bracket is shown with a triangular flag at the bottom. ", "synonyms" -> {}, 
    "title" -> "Working with Cells and Notebooks", "type" -> "Tutorial", 
    "uri" -> "tutorial/WorkingWithCellsAndNotebooks"}, "SearchTextTranslated" -> 
  "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Cells: formatting"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Toolbar: display in notebook"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Cells: styles of"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Styles of cells"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Format menu"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Creating new cells"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Text cells"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Section cells"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Types of cells"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Notebooks"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Close a group of cells"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Open a group of cells"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Print notebooks"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Notebooks: change overall style"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Styles of entire notebooks"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Style sheets"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "Notebooks: formatting"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "TraditionalForm"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "notebooksandcells"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[1364, 45, 546, 14, 70, "Text",
   CellTags->{"notebooksandcells", "i:14", "gs:0.8", "i:120"}],
  Cell[1935, 63, 113, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2073, 68, 182, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2258, 74, 1300, 23, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[3573, 100, 263, 7, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[3873, 112, 135, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4011, 115, 144, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4158, 118, 502, 13, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4663, 133, 131, 1, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4797, 136, 489, 15, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[5289, 153, 145, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[5471, 159, 122, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5618, 164, 146, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5767, 167, 1887, 33, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[7691, 205, 454, 11, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[8148, 218, 2159, 37, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[10344, 260, 119, 2, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->184729763],
  Cell[10466, 264, 465, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->798966666],
  Cell[10934, 278, 458, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->17510771],
  Cell[11441, 296, 141, 2, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11585, 300, 140, 1, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11728, 303, 9646, 160, 70, "Picture",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21377, 465, 243, 4, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21623, 471, 1863, 33, 70, "Picture",
   Evaluatable->False,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[215791, 3675, 117, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
  Cell[215911, 3678, 155, 3, 70, "Text",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
  Cell[216103, 3686, 112, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
  Cell[216218, 3689, 448, 11, 70, "Text",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
  Cell[216703, 3705, 133, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[216839, 3708, 8821, 147, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225663, 3857, 296, 8, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225984, 3869, 236, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[226223, 3875, 11480, 190, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237740, 4070, 99, 1, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237842, 4073, 238, 6, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1639256826],
  Cell[238083, 4081, 409, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->921767219],
  Cell[238495, 4095, 706, 17, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->194620275],
  Cell[239204, 4114, 228, 5, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->365367544],
  Cell[239435, 4121, 304, 8, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1076565235]},
 "gs:0.8"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}],
  Cell[1364, 45, 546, 14, 70, "Text",
   CellTags->{"notebooksandcells", "i:14", "gs:0.8", "i:120"}],
  Cell[1935, 63, 113, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2073, 68, 182, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2258, 74, 1300, 23, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[3573, 100, 263, 7, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[3873, 112, 135, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4011, 115, 144, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4158, 118, 502, 13, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4663, 133, 131, 1, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4797, 136, 489, 15, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[5289, 153, 145, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[5471, 159, 122, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5618, 164, 146, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5767, 167, 1887, 33, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[7691, 205, 454, 11, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[8148, 218, 2159, 37, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[10344, 260, 119, 2, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->184729763],
  Cell[10466, 264, 465, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->798966666],
  Cell[10934, 278, 458, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->17510771],
  Cell[11441, 296, 141, 2, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11585, 300, 140, 1, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11728, 303, 9646, 160, 70, "Picture",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21377, 465, 243, 4, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21623, 471, 1863, 33, 70, "Picture",
   Evaluatable->False,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[215791, 3675, 117, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
  Cell[215911, 3678, 155, 3, 70, "Text",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
  Cell[216103, 3686, 112, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
  Cell[216218, 3689, 448, 11, 70, "Text",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
  Cell[216703, 3705, 133, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[216839, 3708, 8821, 147, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225663, 3857, 296, 8, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225984, 3869, 236, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[226223, 3875, 11480, 190, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237740, 4070, 99, 1, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237842, 4073, 238, 6, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1639256826],
  Cell[238083, 4081, 409, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->921767219],
  Cell[238495, 4095, 706, 17, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->194620275],
  Cell[239204, 4114, 228, 5, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->365367544],
  Cell[239435, 4121, 304, 8, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1076565235]},
 "i:24"->{
  Cell[822, 34, 539, 9, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "notebooksandcells", "gs:0.8", "i:24"}]},
 "i:14"->{
  Cell[1364, 45, 546, 14, 70, "Text",
   CellTags->{"notebooksandcells", "i:14", "gs:0.8", "i:120"}]},
 "i:120"->{
  Cell[1364, 45, 546, 14, 70, "Text",
   CellTags->{"notebooksandcells", "i:14", "gs:0.8", "i:120"}],
  Cell[1935, 63, 113, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2073, 68, 182, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2258, 74, 1300, 23, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[3573, 100, 263, 7, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[3873, 112, 135, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4011, 115, 144, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4158, 118, 502, 13, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4663, 133, 131, 1, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4797, 136, 489, 15, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[5289, 153, 145, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[5471, 159, 122, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5618, 164, 146, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5767, 167, 1887, 33, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[7691, 205, 454, 11, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[8148, 218, 2159, 37, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[10344, 260, 119, 2, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->184729763],
  Cell[10466, 264, 465, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->798966666],
  Cell[10934, 278, 458, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->17510771],
  Cell[11441, 296, 141, 2, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11585, 300, 140, 1, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11728, 303, 9646, 160, 70, "Picture",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21377, 465, 243, 4, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21623, 471, 1863, 33, 70, "Picture",
   Evaluatable->False,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[215791, 3675, 117, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
  Cell[215911, 3678, 155, 3, 70, "Text",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
  Cell[216103, 3686, 112, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
  Cell[216218, 3689, 448, 11, 70, "Text",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
  Cell[216703, 3705, 133, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[216839, 3708, 8821, 147, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225663, 3857, 296, 8, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225984, 3869, 236, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[226223, 3875, 11480, 190, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237740, 4070, 99, 1, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237842, 4073, 238, 6, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1639256826],
  Cell[238083, 4081, 409, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->921767219],
  Cell[238495, 4095, 706, 17, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->194620275],
  Cell[239204, 4114, 228, 5, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->365367544],
  Cell[239435, 4121, 304, 8, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1076565235]},
 "i:48"->{
  Cell[1935, 63, 113, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2073, 68, 182, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2258, 74, 1300, 23, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[3573, 100, 263, 7, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}]},
 "b:7.0"->{
  Cell[1935, 63, 113, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2073, 68, 182, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[2258, 74, 1300, 23, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
  Cell[3573, 100, 263, 7, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}]},
 "i:49"->{
  Cell[3873, 112, 135, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4011, 115, 144, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4158, 118, 502, 13, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4663, 133, 131, 1, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4797, 136, 489, 15, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[5289, 153, 145, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}]},
 "b:7.1"->{
  Cell[3873, 112, 135, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4011, 115, 144, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4158, 118, 502, 13, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4663, 133, 131, 1, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[4797, 136, 489, 15, 70, "ItemizedTextParagraph",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
  Cell[5289, 153, 145, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}]},
 "i:50"->{
  Cell[5471, 159, 122, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5618, 164, 146, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5767, 167, 1887, 33, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[7691, 205, 454, 11, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[8148, 218, 2159, 37, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[10344, 260, 119, 2, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->184729763],
  Cell[10466, 264, 465, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->798966666],
  Cell[10934, 278, 458, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->17510771],
  Cell[293571, 5290, 120, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->466062922],
  Cell[293694, 5294, 339, 10, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->311240708]},
 "b:7.2"->{
  Cell[5471, 159, 122, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5618, 164, 146, 1, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[5767, 167, 1887, 33, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[7691, 205, 454, 11, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[8148, 218, 2159, 37, 70, "ItemizedPicture",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
  Cell[10344, 260, 119, 2, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->184729763],
  Cell[10466, 264, 465, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->798966666],
  Cell[10934, 278, 458, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
   CellID->17510771]},
 "i:51"->{
  Cell[11441, 296, 141, 2, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11585, 300, 140, 1, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11728, 303, 9646, 160, 70, "Picture",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21377, 465, 243, 4, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21623, 471, 1863, 33, 70, "Picture",
   Evaluatable->False,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[271701, 4894, 170, 2, 70, "Subsection",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->406317831],
  Cell[271896, 4900, 187, 4, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->140303210],
  Cell[272086, 4906, 3942, 67, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->162327058],
  Cell[276065, 4978, 637, 16, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->330821102],
  Cell[276705, 4996, 7952, 133, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->244938124],
  Cell[284694, 5134, 364, 7, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->379618602],
  Cell[285061, 5143, 8473, 142, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->111599595]},
 "b:7.3"->{
  Cell[11441, 296, 141, 2, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11585, 300, 140, 1, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[11728, 303, 9646, 160, 70, "Picture",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21377, 465, 243, 4, 70, "Text",
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
  Cell[21623, 471, 1863, 33, 70, "Picture",
   Evaluatable->False,
   CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}]},
 "i:52"->{
  Cell[215791, 3675, 117, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
  Cell[215911, 3678, 155, 3, 70, "Text",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}]},
 "b:7.4"->{
  Cell[215791, 3675, 117, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
  Cell[215911, 3678, 155, 3, 70, "Text",
   CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}]},
 "i:53"->{
  Cell[216103, 3686, 112, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
  Cell[216218, 3689, 448, 11, 70, "Text",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}]},
 "b:7.5"->{
  Cell[216103, 3686, 112, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
  Cell[216218, 3689, 448, 11, 70, "Text",
   CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}]},
 "i:55"->{
  Cell[216703, 3705, 133, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[216839, 3708, 8821, 147, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225663, 3857, 296, 8, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225984, 3869, 236, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[226223, 3875, 11480, 190, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237740, 4070, 99, 1, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237842, 4073, 238, 6, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1639256826],
  Cell[238083, 4081, 409, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->921767219],
  Cell[238495, 4095, 706, 17, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->194620275],
  Cell[239204, 4114, 228, 5, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->365367544],
  Cell[239435, 4121, 304, 8, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1076565235]},
 "b:7.6"->{
  Cell[216703, 3705, 133, 1, 70, "Subsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[216839, 3708, 8821, 147, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225663, 3857, 296, 8, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[225984, 3869, 236, 4, 70, "ItemizedText",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[226223, 3875, 11480, 190, 70, "Picture",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237740, 4070, 99, 1, 70, "Subsubsection",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
  Cell[237842, 4073, 238, 6, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1639256826],
  Cell[238083, 4081, 409, 12, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->921767219],
  Cell[238495, 4095, 706, 17, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->194620275],
  Cell[239204, 4114, 228, 5, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->365367544],
  Cell[239435, 4121, 304, 8, 70, "Notes",
   CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
   CellID->1076565235]},
 "textcreation"->{
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939],
  Cell[240352, 4148, 198, 6, 70, "Text",
   CellTags->{"textcreation", "gs:0.9"},
   CellID->161474001],
  Cell[240553, 4156, 263, 8, 70, "Text",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->198042704],
  Cell[240819, 4166, 96, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->472724620],
  Cell[240918, 4170, 94, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->46084352],
  Cell[241015, 4174, 95, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->100191046],
  Cell[241113, 4178, 95, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->480238683],
  Cell[241211, 4182, 101, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->846422307],
  Cell[241315, 4186, 106, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->95034122],
  Cell[241424, 4190, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->230583829],
  Cell[241530, 4194, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->63371158],
  Cell[241636, 4198, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->1635454],
  Cell[241742, 4202, 109, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->772480255],
  Cell[241854, 4206, 105, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->202989947],
  Cell[241984, 4212, 117, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->366665031],
  Cell[242126, 4218, 136, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->83982296],
  Cell[242265, 4222, 1103, 21, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->237510254],
  Cell[243405, 4248, 297, 8, 70, "ItemizedText",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->252512777],
  Cell[243705, 4258, 1168, 22, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->116242518],
  Cell[244922, 4286, 124, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->348446821],
  Cell[245049, 4290, 411, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->2803423],
  Cell[245485, 4306, 371, 10, 70, "ItemizedText",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->302877301],
  Cell[245859, 4318, 10852, 181, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->902498814],
  Cell[256714, 4501, 234, 5, 70, "Text",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->556406272],
  Cell[257509, 4533, 155, 3, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->27436672],
  Cell[257689, 4540, 440, 13, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->124289792],
  Cell[258132, 4555, 1392, 26, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->720190720],
  Cell[259561, 4586, 289, 8, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->337585897],
  Cell[259853, 4596, 1661, 30, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->380209],
  Cell[261529, 4629, 345, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->927649],
  Cell[261911, 4646, 110, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
   CellID->322561406],
  Cell[262024, 4650, 252, 5, 70, "Text",
   CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
   CellID->60550783],
  Cell[262313, 4660, 130, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->60125091],
  Cell[262468, 4666, 124, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->392481106],
  Cell[262595, 4670, 802, 16, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->524443848],
  Cell[263412, 4689, 394, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->71653346],
  Cell[263831, 4705, 140, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->442807251],
  Cell[263974, 4709, 777, 15, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->691614683],
  Cell[264788, 4729, 397, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->151303034],
  Cell[265188, 4743, 834, 16, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->182193520],
  Cell[266071, 4765, 109, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->340052456],
  Cell[266183, 4769, 590, 17, 70, "Text",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->827926029],
  Cell[266776, 4788, 3804, 65, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->117325894],
  Cell[270605, 4857, 104, 2, 70, "Subsubsection",
   CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
   CellID->122462755],
  Cell[270712, 4861, 319, 8, 70, "Notes",
   CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
   CellID->122297441]},
 "i:56"->{
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939]},
 "gs:0.9"->{
  Cell[239800, 4136, 549, 10, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
     "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
     "Section cells", "Types of cells", "Notebooks", "Close a group of cells",
      "Open a group of cells", "Print notebooks", 
     "Notebooks: change overall style", "Styles of entire notebooks", 
     "Style sheets", "Notebooks: formatting", "TraditionalForm", 
     "textcreation", "i:56", "gs:0.9"},
   CellID->76230939],
  Cell[240352, 4148, 198, 6, 70, "Text",
   CellTags->{"textcreation", "gs:0.9"},
   CellID->161474001],
  Cell[240553, 4156, 263, 8, 70, "Text",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->198042704],
  Cell[240819, 4166, 96, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->472724620],
  Cell[240918, 4170, 94, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->46084352],
  Cell[241015, 4174, 95, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->100191046],
  Cell[241113, 4178, 95, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->480238683],
  Cell[241211, 4182, 101, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->846422307],
  Cell[241315, 4186, 106, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->95034122],
  Cell[241424, 4190, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->230583829],
  Cell[241530, 4194, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->63371158],
  Cell[241636, 4198, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->1635454],
  Cell[241742, 4202, 109, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->772480255],
  Cell[241854, 4206, 105, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->202989947],
  Cell[241984, 4212, 117, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->366665031],
  Cell[242126, 4218, 136, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->83982296],
  Cell[242265, 4222, 1103, 21, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->237510254],
  Cell[243405, 4248, 297, 8, 70, "ItemizedText",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->252512777],
  Cell[243705, 4258, 1168, 22, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->116242518],
  Cell[244922, 4286, 124, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->348446821],
  Cell[245049, 4290, 411, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->2803423],
  Cell[245485, 4306, 371, 10, 70, "ItemizedText",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->302877301],
  Cell[245859, 4318, 10852, 181, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->902498814],
  Cell[256714, 4501, 234, 5, 70, "Text",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->556406272],
  Cell[257509, 4533, 155, 3, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->27436672],
  Cell[257689, 4540, 440, 13, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->124289792],
  Cell[258132, 4555, 1392, 26, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->720190720],
  Cell[259561, 4586, 289, 8, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->337585897],
  Cell[259853, 4596, 1661, 30, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->380209],
  Cell[261529, 4629, 345, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->927649],
  Cell[261911, 4646, 110, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
   CellID->322561406],
  Cell[262024, 4650, 252, 5, 70, "Text",
   CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
   CellID->60550783],
  Cell[262313, 4660, 130, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->60125091],
  Cell[262468, 4666, 124, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->392481106],
  Cell[262595, 4670, 802, 16, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->524443848],
  Cell[263412, 4689, 394, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->71653346],
  Cell[263831, 4705, 140, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->442807251],
  Cell[263974, 4709, 777, 15, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->691614683],
  Cell[264788, 4729, 397, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->151303034],
  Cell[265188, 4743, 834, 16, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->182193520],
  Cell[266071, 4765, 109, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->340052456],
  Cell[266183, 4769, 590, 17, 70, "Text",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->827926029],
  Cell[266776, 4788, 3804, 65, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->117325894],
  Cell[270605, 4857, 104, 2, 70, "Subsubsection",
   CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
   CellID->122462755],
  Cell[270712, 4861, 319, 8, 70, "Notes",
   CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
   CellID->122297441]},
 "i:15"->{
  Cell[240553, 4156, 263, 8, 70, "Text",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->198042704],
  Cell[240819, 4166, 96, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->472724620],
  Cell[240918, 4170, 94, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->46084352],
  Cell[241015, 4174, 95, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->100191046],
  Cell[241113, 4178, 95, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->480238683],
  Cell[241211, 4182, 101, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->846422307],
  Cell[241315, 4186, 106, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->95034122],
  Cell[241424, 4190, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->230583829],
  Cell[241530, 4194, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->63371158],
  Cell[241636, 4198, 103, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->1635454],
  Cell[241742, 4202, 109, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->772480255],
  Cell[241854, 4206, 105, 2, 70, "BulletedText",
   CellTags->{"textcreation", "i:15", "gs:0.9"},
   CellID->202989947]},
 "i:57"->{
  Cell[241984, 4212, 117, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->366665031],
  Cell[242126, 4218, 136, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->83982296],
  Cell[242265, 4222, 1103, 21, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->237510254],
  Cell[243405, 4248, 297, 8, 70, "ItemizedText",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->252512777],
  Cell[243705, 4258, 1168, 22, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->116242518]},
 "b:8.0"->{
  Cell[241984, 4212, 117, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->366665031],
  Cell[242126, 4218, 136, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->83982296],
  Cell[242265, 4222, 1103, 21, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->237510254],
  Cell[243405, 4248, 297, 8, 70, "ItemizedText",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->252512777],
  Cell[243705, 4258, 1168, 22, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
   CellID->116242518]},
 "i:58"->{
  Cell[244922, 4286, 124, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->348446821],
  Cell[245049, 4290, 411, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->2803423],
  Cell[245485, 4306, 371, 10, 70, "ItemizedText",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->302877301],
  Cell[245859, 4318, 10852, 181, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->902498814],
  Cell[256714, 4501, 234, 5, 70, "Text",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->556406272]},
 "b:8.1"->{
  Cell[244922, 4286, 124, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->348446821],
  Cell[245049, 4290, 411, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->2803423],
  Cell[245485, 4306, 371, 10, 70, "ItemizedText",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->302877301],
  Cell[245859, 4318, 10852, 181, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->902498814],
  Cell[256714, 4501, 234, 5, 70, "Text",
   CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
   CellID->556406272]},
 "i:122"->{
  Cell[256985, 4511, 68, 2, 70, "Subsubsection",
   CellTags->"i:122",
   CellID->192434058],
  Cell[257056, 4515, 404, 12, 70, "Notes",
   CellTags->"i:122",
   CellID->1725992692]},
 "i:59"->{
  Cell[257509, 4533, 155, 3, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->27436672],
  Cell[257689, 4540, 440, 13, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->124289792],
  Cell[258132, 4555, 1392, 26, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->720190720],
  Cell[259561, 4586, 289, 8, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->337585897],
  Cell[259853, 4596, 1661, 30, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->380209],
  Cell[261529, 4629, 345, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->927649]},
 "b:8.2"->{
  Cell[257509, 4533, 155, 3, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->27436672],
  Cell[257689, 4540, 440, 13, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->124289792],
  Cell[258132, 4555, 1392, 26, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->720190720],
  Cell[259561, 4586, 289, 8, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->337585897],
  Cell[259853, 4596, 1661, 30, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->380209],
  Cell[261529, 4629, 345, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
   CellID->927649]},
 "i:60"->{
  Cell[261911, 4646, 110, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
   CellID->322561406],
  Cell[262024, 4650, 252, 5, 70, "Text",
   CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
   CellID->60550783]},
 "b:8.3"->{
  Cell[261911, 4646, 110, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
   CellID->322561406],
  Cell[262024, 4650, 252, 5, 70, "Text",
   CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
   CellID->60550783]},
 "i:61"->{
  Cell[262313, 4660, 130, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->60125091],
  Cell[262468, 4666, 124, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->392481106],
  Cell[262595, 4670, 802, 16, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->524443848],
  Cell[263412, 4689, 394, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->71653346],
  Cell[263831, 4705, 140, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->442807251],
  Cell[263974, 4709, 777, 15, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->691614683],
  Cell[264788, 4729, 397, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->151303034],
  Cell[265188, 4743, 834, 16, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->182193520]},
 "b:8.4"->{
  Cell[262313, 4660, 130, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->60125091],
  Cell[262468, 4666, 124, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->392481106],
  Cell[262595, 4670, 802, 16, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->524443848],
  Cell[263412, 4689, 394, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->71653346],
  Cell[263831, 4705, 140, 2, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->442807251],
  Cell[263974, 4709, 777, 15, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->691614683],
  Cell[264788, 4729, 397, 12, 70, "ItemizedText",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->151303034],
  Cell[265188, 4743, 834, 16, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
   CellID->182193520]},
 "i:62"->{
  Cell[266071, 4765, 109, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->340052456],
  Cell[266183, 4769, 590, 17, 70, "Text",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->827926029],
  Cell[266776, 4788, 3804, 65, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->117325894],
  Cell[270605, 4857, 104, 2, 70, "Subsubsection",
   CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
   CellID->122462755],
  Cell[270712, 4861, 319, 8, 70, "Notes",
   CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
   CellID->122297441]},
 "b:8.5"->{
  Cell[266071, 4765, 109, 2, 70, "Subsection",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->340052456],
  Cell[266183, 4769, 590, 17, 70, "Text",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->827926029],
  Cell[266776, 4788, 3804, 65, 70, "ItemizedPicture",
   CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
   CellID->117325894],
  Cell[270605, 4857, 104, 2, 70, "Subsubsection",
   CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
   CellID->122462755],
  Cell[270712, 4861, 319, 8, 70, "Notes",
   CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
   CellID->122297441]},
 "Hyperlinks"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "Links: in text"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "Create Hyperlink menu item"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "Dialog box: hyperlinks"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "Active elements in cells: hyperlinks"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "Celltags: creating"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "Creating cell tags"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "Tags for cells"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "Underlined text: hyperlinks"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200]},
 "hyperlinks"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200],
  Cell[271467, 4885, 209, 5, 70, "Text",
   CellTags->{"hyperlinks", "i:11", "gs:0.10"},
   CellID->167643723],
  Cell[271701, 4894, 170, 2, 70, "Subsection",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->406317831],
  Cell[271896, 4900, 187, 4, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->140303210],
  Cell[272086, 4906, 3942, 67, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->162327058],
  Cell[276065, 4978, 637, 16, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->330821102],
  Cell[276705, 4996, 7952, 133, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->244938124],
  Cell[284694, 5134, 364, 7, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->379618602],
  Cell[285061, 5143, 8473, 142, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->111599595],
  Cell[293571, 5290, 120, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->466062922],
  Cell[293694, 5294, 339, 10, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->311240708],
  Cell[294082, 5310, 142, 3, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->410966860],
  Cell[294227, 5315, 149, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->257750023],
  Cell[294401, 5321, 145, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->627630235],
  Cell[294549, 5325, 2048, 36, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->54001265],
  Cell[296612, 5364, 408, 12, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->625424405],
  Cell[297023, 5378, 137, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->549712507],
  Cell[297163, 5382, 262, 6, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->125044020],
  Cell[297428, 5390, 318, 8, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->45672800],
  Cell[297771, 5402, 235, 5, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->193422084],
  Cell[298009, 5409, 9355, 157, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->282059674],
  Cell[307379, 5569, 166, 6, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->1005432286],
  Cell[307570, 5579, 101, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->4542761],
  Cell[307674, 5583, 299, 6, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->1899898911]},
 "i:11"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200],
  Cell[271467, 4885, 209, 5, 70, "Text",
   CellTags->{"hyperlinks", "i:11", "gs:0.10"},
   CellID->167643723]},
 "gs:0.10"->{
  Cell[271092, 4876, 372, 7, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
     "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
     "Celltags: creating", "Creating cell tags", "Tags for cells", 
     "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
   CellID->35878200],
  Cell[271467, 4885, 209, 5, 70, "Text",
   CellTags->{"hyperlinks", "i:11", "gs:0.10"},
   CellID->167643723],
  Cell[271701, 4894, 170, 2, 70, "Subsection",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->406317831],
  Cell[271896, 4900, 187, 4, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->140303210],
  Cell[272086, 4906, 3942, 67, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->162327058],
  Cell[276065, 4978, 637, 16, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->330821102],
  Cell[276705, 4996, 7952, 133, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->244938124],
  Cell[284694, 5134, 364, 7, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->379618602],
  Cell[285061, 5143, 8473, 142, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->111599595],
  Cell[293571, 5290, 120, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->466062922],
  Cell[293694, 5294, 339, 10, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->311240708],
  Cell[294082, 5310, 142, 3, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->410966860],
  Cell[294227, 5315, 149, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->257750023],
  Cell[294401, 5321, 145, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->627630235],
  Cell[294549, 5325, 2048, 36, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->54001265],
  Cell[296612, 5364, 408, 12, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->625424405],
  Cell[297023, 5378, 137, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->549712507],
  Cell[297163, 5382, 262, 6, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->125044020],
  Cell[297428, 5390, 318, 8, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->45672800],
  Cell[297771, 5402, 235, 5, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->193422084],
  Cell[298009, 5409, 9355, 157, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->282059674],
  Cell[307379, 5569, 166, 6, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->1005432286],
  Cell[307570, 5579, 101, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->4542761],
  Cell[307674, 5583, 299, 6, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->1899898911]},
 "i:64"->{
  Cell[271701, 4894, 170, 2, 70, "Subsection",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->406317831],
  Cell[271896, 4900, 187, 4, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->140303210],
  Cell[272086, 4906, 3942, 67, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->162327058],
  Cell[276065, 4978, 637, 16, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->330821102],
  Cell[276705, 4996, 7952, 133, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->244938124],
  Cell[284694, 5134, 364, 7, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->379618602],
  Cell[285061, 5143, 8473, 142, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->111599595]},
 "b:9.0"->{
  Cell[271701, 4894, 170, 2, 70, "Subsection",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->406317831],
  Cell[271896, 4900, 187, 4, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->140303210],
  Cell[272086, 4906, 3942, 67, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->162327058],
  Cell[276065, 4978, 637, 16, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->330821102],
  Cell[276705, 4996, 7952, 133, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->244938124],
  Cell[284694, 5134, 364, 7, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->379618602],
  Cell[285061, 5143, 8473, 142, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->111599595],
  Cell[293571, 5290, 120, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->466062922],
  Cell[293694, 5294, 339, 10, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->311240708]},
 "b:9.1"->{
  Cell[271701, 4894, 170, 2, 70, "Subsection",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->406317831],
  Cell[271896, 4900, 187, 4, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->140303210],
  Cell[272086, 4906, 3942, 67, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->162327058],
  Cell[276065, 4978, 637, 16, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->330821102],
  Cell[276705, 4996, 7952, 133, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->244938124],
  Cell[284694, 5134, 364, 7, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->379618602],
  Cell[285061, 5143, 8473, 142, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
   CellID->111599595],
  Cell[293571, 5290, 120, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->466062922],
  Cell[293694, 5294, 339, 10, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->311240708],
  Cell[294082, 5310, 142, 3, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->410966860],
  Cell[294227, 5315, 149, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->257750023],
  Cell[294401, 5321, 145, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->627630235],
  Cell[294549, 5325, 2048, 36, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->54001265],
  Cell[296612, 5364, 408, 12, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->625424405],
  Cell[297023, 5378, 137, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->549712507],
  Cell[297163, 5382, 262, 6, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->125044020],
  Cell[297428, 5390, 318, 8, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->45672800],
  Cell[297771, 5402, 235, 5, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->193422084],
  Cell[298009, 5409, 9355, 157, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->282059674],
  Cell[307379, 5569, 166, 6, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->1005432286],
  Cell[307570, 5579, 101, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->4542761],
  Cell[307674, 5583, 299, 6, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->1899898911]},
 "i:65"->{
  Cell[293571, 5290, 120, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->466062922],
  Cell[293694, 5294, 339, 10, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
   CellID->311240708],
  Cell[294082, 5310, 142, 3, 70, "Subsection",
   PageBreakAbove->True,
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->410966860],
  Cell[294227, 5315, 149, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->257750023],
  Cell[294401, 5321, 145, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->627630235],
  Cell[294549, 5325, 2048, 36, 70, "ItemizedPicture",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->54001265],
  Cell[296612, 5364, 408, 12, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->625424405],
  Cell[297023, 5378, 137, 2, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->549712507],
  Cell[297163, 5382, 262, 6, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->125044020],
  Cell[297428, 5390, 318, 8, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->45672800],
  Cell[297771, 5402, 235, 5, 70, "ItemizedTextParagraph",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->193422084],
  Cell[298009, 5409, 9355, 157, 70, "ItemizedPicture",
   Evaluatable->False,
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->282059674],
  Cell[307379, 5569, 166, 6, 70, "ItemizedText",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->1005432286],
  Cell[307570, 5579, 101, 2, 70, "Subsubsection",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->4542761],
  Cell[307674, 5583, 299, 6, 70, "Notes",
   CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
   CellID->1899898911]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Cells: formatting", 309683, 5633},
 {"Toolbar: display in notebook", 310833, 5655},
 {"Cells: styles of", 311971, 5677},
 {"Styles of cells", 313108, 5699},
 {"Format menu", 314241, 5721},
 {"Creating new cells", 315381, 5743},
 {"Text cells", 316513, 5765},
 {"Section cells", 317648, 5787},
 {"Types of cells", 318784, 5809},
 {"Notebooks", 319915, 5831},
 {"Close a group of cells", 321059, 5853},
 {"Open a group of cells", 322202, 5875},
 {"Print notebooks", 323339, 5897},
 {"Notebooks: change overall style", 324492, 5919},
 {"Styles of entire notebooks", 325640, 5941},
 {"Style sheets", 326774, 5963},
 {"Notebooks: formatting", 327917, 5985},
 {"TraditionalForm", 329054, 6007},
 {"notebooksandcells", 330193, 6029},
 {"gs:0.8", 335591, 6128},
 {"i:24", 340987, 6227},
 {"i:14", 341545, 6238},
 {"i:120", 341660, 6241},
 {"i:48", 346510, 6330},
 {"b:7.0", 346999, 6339},
 {"i:49", 347487, 6348},
 {"b:7.1", 348232, 6361},
 {"i:50", 348976, 6374},
 {"b:7.2", 350294, 6400},
 {"i:51", 351324, 6420},
 {"b:7.3", 353046, 6456},
 {"i:52", 353683, 6469},
 {"b:7.4", 353930, 6474},
 {"i:53", 354176, 6479},
 {"b:7.5", 354424, 6484},
 {"i:55", 354671, 6489},
 {"b:7.6", 356100, 6517},
 {"textcreation", 357536, 6545},
 {"i:56", 363730, 6691},
 {"gs:0.9", 364312, 6703},
 {"i:15", 370506, 6849},
 {"i:57", 371953, 6886},
 {"b:8.0", 372623, 6902},
 {"i:58", 373292, 6918},
 {"b:8.1", 373975, 6935},
 {"i:122", 374658, 6952},
 {"i:59", 374853, 6959},
 {"b:8.2", 375674, 6979},
 {"i:60", 376494, 6999},
 {"b:8.3", 376756, 7006},
 {"i:61", 377017, 7013},
 {"b:8.4", 378080, 7038},
 {"i:62", 379142, 7063},
 {"b:8.5", 379795, 7079},
 {"Hyperlinks", 380453, 7095},
 {"Links: in text", 380858, 7104},
 {"Create Hyperlink menu item", 381275, 7113},
 {"Dialog box: hyperlinks", 381688, 7122},
 {"Active elements in cells: hyperlinks", 382115, 7131},
 {"Celltags: creating", 382524, 7140},
 {"Creating cell tags", 382933, 7149},
 {"Tags for cells", 383338, 7158},
 {"Underlined text: hyperlinks", 383756, 7167},
 {"hyperlinks", 384157, 7176},
 {"i:11", 387789, 7258},
 {"gs:0.10", 388299, 7270},
 {"i:64", 391931, 7352},
 {"b:9.0", 393028, 7376},
 {"b:9.1", 394412, 7406},
 {"i:65", 397549, 7477}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 69, 1, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[822, 34, 539, 9, 70, "Section",
 PageBreakAbove->True,
 CellTags->{
  "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
   "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
   "Section cells", "Types of cells", "Notebooks", "Close a group of cells", 
   "Open a group of cells", "Print notebooks", 
   "Notebooks: change overall style", "Styles of entire notebooks", 
   "Style sheets", "Notebooks: formatting", "TraditionalForm", 
   "notebooksandcells", "gs:0.8", "i:24"}],
Cell[1364, 45, 546, 14, 70, "Text",
 CellTags->{"notebooksandcells", "i:14", "gs:0.8", "i:120"}],
Cell[CellGroupData[{
Cell[1935, 63, 113, 1, 70, "Subsection",
 CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
Cell[CellGroupData[{
Cell[2073, 68, 182, 4, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}],
Cell[2258, 74, 1300, 23, 70, "ItemizedPicture",
 CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}]
}, Open  ]],
Cell[3573, 100, 263, 7, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:48", "b:7.0", "gs:0.8", "i:120"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[3873, 112, 135, 1, 70, "Subsection",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
Cell[4011, 115, 144, 1, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
Cell[4158, 118, 502, 13, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
Cell[4663, 133, 131, 1, 70, "ItemizedTextParagraph",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
Cell[4797, 136, 489, 15, 70, "ItemizedTextParagraph",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}],
Cell[5289, 153, 145, 1, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:49", "b:7.1", "gs:0.8", "i:120"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[5471, 159, 122, 1, 70, "Subsection",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
Cell[CellGroupData[{
Cell[5618, 164, 146, 1, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
Cell[5767, 167, 1887, 33, 70, "ItemizedPicture",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[7691, 205, 454, 11, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}],
Cell[8148, 218, 2159, 37, 70, "ItemizedPicture",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[10344, 260, 119, 2, 70, "Subsubsection",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
 CellID->184729763],
Cell[10466, 264, 465, 12, 70, "Notes",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
 CellID->798966666],
Cell[10934, 278, 458, 12, 70, "Notes",
 CellTags->{"notebooksandcells", "i:50", "b:7.2", "gs:0.8", "i:120"},
 CellID->17510771]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11441, 296, 141, 2, 70, "Subsection",
 PageBreakAbove->True,
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
Cell[11585, 300, 140, 1, 70, "Text",
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
Cell[11728, 303, 9646, 160, 70, "Picture",
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
Cell[21377, 465, 243, 4, 70, "Text",
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
Cell[21623, 471, 1863, 33, 70, "Picture",
 Evaluatable->False,
 CellTags->{"notebooksandcells", "i:51", "b:7.3", "gs:0.8", "i:120"}],
Cell[23489, 506, 357, 6, 70, "Text"],
Cell[CellGroupData[{
Cell[23871, 516, 98532, 1618, 70, "Picture",
 CellID->597271799],
Cell[122406, 2136, 93336, 1533, 70, "Picture",
 CellID->1977836416]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[215791, 3675, 117, 1, 70, "Subsection",
 CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}],
Cell[215911, 3678, 155, 3, 70, "Text",
 CellTags->{"notebooksandcells", "i:52", "b:7.4", "gs:0.8", "i:120"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[216103, 3686, 112, 1, 70, "Subsection",
 CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}],
Cell[216218, 3689, 448, 11, 70, "Text",
 CellTags->{"notebooksandcells", "i:53", "b:7.5", "gs:0.8", "i:120"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[216703, 3705, 133, 1, 70, "Subsection",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
Cell[216839, 3708, 8821, 147, 70, "Picture",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
Cell[225663, 3857, 296, 8, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
Cell[CellGroupData[{
Cell[225984, 3869, 236, 4, 70, "ItemizedText",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
Cell[226223, 3875, 11480, 190, 70, "Picture",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[237740, 4070, 99, 1, 70, "Subsubsection",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"}],
Cell[237842, 4073, 238, 6, 70, "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->1639256826],
Cell[238083, 4081, 409, 12, 70, "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->921767219],
Cell[238495, 4095, 706, 17, 70, "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->194620275],
Cell[239204, 4114, 228, 5, 70, "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->365367544],
Cell[239435, 4121, 304, 8, 70, "Notes",
 CellTags->{"notebooksandcells", "i:55", "b:7.6", "gs:0.8", "i:120"},
 CellID->1076565235]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[239800, 4136, 549, 10, 70, "Section",
 PageBreakAbove->True,
 CellTags->{
  "Cells: formatting", "Toolbar: display in notebook", "Cells: styles of", 
   "Styles of cells", "Format menu", "Creating new cells", "Text cells", 
   "Section cells", "Types of cells", "Notebooks", "Close a group of cells", 
   "Open a group of cells", "Print notebooks", 
   "Notebooks: change overall style", "Styles of entire notebooks", 
   "Style sheets", "Notebooks: formatting", "TraditionalForm", "textcreation",
    "i:56", "gs:0.9"},
 CellID->76230939],
Cell[240352, 4148, 198, 6, 70, "Text",
 CellTags->{"textcreation", "gs:0.9"},
 CellID->161474001],
Cell[240553, 4156, 263, 8, 70, "Text",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->198042704],
Cell[240819, 4166, 96, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->472724620],
Cell[240918, 4170, 94, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->46084352],
Cell[241015, 4174, 95, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->100191046],
Cell[241113, 4178, 95, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->480238683],
Cell[241211, 4182, 101, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->846422307],
Cell[241315, 4186, 106, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->95034122],
Cell[241424, 4190, 103, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->230583829],
Cell[241530, 4194, 103, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->63371158],
Cell[241636, 4198, 103, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->1635454],
Cell[241742, 4202, 109, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->772480255],
Cell[241854, 4206, 105, 2, 70, "BulletedText",
 CellTags->{"textcreation", "i:15", "gs:0.9"},
 CellID->202989947],
Cell[CellGroupData[{
Cell[241984, 4212, 117, 2, 70, "Subsection",
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->366665031],
Cell[CellGroupData[{
Cell[242126, 4218, 136, 2, 70, "ItemizedText",
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->83982296],
Cell[242265, 4222, 1103, 21, 70, "ItemizedPicture",
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->237510254]
}, Open  ]],
Cell[CellGroupData[{
Cell[243405, 4248, 297, 8, 70, "ItemizedText",
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->252512777],
Cell[243705, 4258, 1168, 22, 70, "ItemizedPicture",
 CellTags->{"textcreation", "i:57", "b:8.0", "gs:0.9"},
 CellID->116242518]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[244922, 4286, 124, 2, 70, "Subsection",
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->348446821],
Cell[245049, 4290, 411, 12, 70, "ItemizedText",
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->2803423],
Cell[CellGroupData[{
Cell[245485, 4306, 371, 10, 70, "ItemizedText",
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->302877301],
Cell[245859, 4318, 10852, 181, 70, "ItemizedPicture",
 Evaluatable->False,
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->902498814],
Cell[256714, 4501, 234, 5, 70, "Text",
 CellTags->{"textcreation", "i:58", "b:8.1", "gs:0.9"},
 CellID->556406272]
}, Open  ]],
Cell[CellGroupData[{
Cell[256985, 4511, 68, 2, 70, "Subsubsection",
 CellTags->"i:122",
 CellID->192434058],
Cell[257056, 4515, 404, 12, 70, "Notes",
 CellTags->"i:122",
 CellID->1725992692]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[257509, 4533, 155, 3, 70, "Subsection",
 PageBreakAbove->True,
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->27436672],
Cell[CellGroupData[{
Cell[257689, 4540, 440, 13, 70, "ItemizedText",
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->124289792],
Cell[258132, 4555, 1392, 26, 70, "ItemizedPicture",
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->720190720]
}, Open  ]],
Cell[CellGroupData[{
Cell[259561, 4586, 289, 8, 70, "ItemizedText",
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->337585897],
Cell[259853, 4596, 1661, 30, 70, "ItemizedPicture",
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->380209]
}, Open  ]],
Cell[261529, 4629, 345, 12, 70, "ItemizedText",
 CellTags->{"textcreation", "i:59", "b:8.2", "gs:0.9"},
 CellID->927649]
}, Open  ]],
Cell[CellGroupData[{
Cell[261911, 4646, 110, 2, 70, "Subsection",
 CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
 CellID->322561406],
Cell[262024, 4650, 252, 5, 70, "Text",
 CellTags->{"textcreation", "i:60", "b:8.3", "gs:0.9"},
 CellID->60550783]
}, Open  ]],
Cell[CellGroupData[{
Cell[262313, 4660, 130, 2, 70, "Subsection",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->60125091],
Cell[CellGroupData[{
Cell[262468, 4666, 124, 2, 70, "ItemizedText",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->392481106],
Cell[262595, 4670, 802, 16, 70, "ItemizedPicture",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->524443848]
}, Open  ]],
Cell[263412, 4689, 394, 12, 70, "ItemizedText",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->71653346],
Cell[CellGroupData[{
Cell[263831, 4705, 140, 2, 70, "ItemizedText",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->442807251],
Cell[263974, 4709, 777, 15, 70, "ItemizedPicture",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->691614683]
}, Open  ]],
Cell[CellGroupData[{
Cell[264788, 4729, 397, 12, 70, "ItemizedText",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->151303034],
Cell[265188, 4743, 834, 16, 70, "ItemizedPicture",
 CellTags->{"textcreation", "i:61", "b:8.4", "gs:0.9"},
 CellID->182193520]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[266071, 4765, 109, 2, 70, "Subsection",
 CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
 CellID->340052456],
Cell[266183, 4769, 590, 17, 70, "Text",
 CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
 CellID->827926029],
Cell[266776, 4788, 3804, 65, 70, "ItemizedPicture",
 CellTags->{"textcreation", "i:62", "b:8.5", "gs:0.9"},
 CellID->117325894],
Cell[CellGroupData[{
Cell[270605, 4857, 104, 2, 70, "Subsubsection",
 CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
 CellID->122462755],
Cell[270712, 4861, 319, 8, 70, "Notes",
 CellTags->{"b:8.5", "gs:0.9", "i:62", "textcreation"},
 CellID->122297441]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[271092, 4876, 372, 7, 70, "Section",
 PageBreakAbove->True,
 CellTags->{
  "Hyperlinks", "Links: in text", "Create Hyperlink menu item", 
   "Dialog box: hyperlinks", "Active elements in cells: hyperlinks", 
   "Celltags: creating", "Creating cell tags", "Tags for cells", 
   "Underlined text: hyperlinks", "hyperlinks", "i:11", "gs:0.10"},
 CellID->35878200],
Cell[271467, 4885, 209, 5, 70, "Text",
 CellTags->{"hyperlinks", "i:11", "gs:0.10"},
 CellID->167643723],
Cell[CellGroupData[{
Cell[271701, 4894, 170, 2, 70, "Subsection",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->406317831],
Cell[CellGroupData[{
Cell[271896, 4900, 187, 4, 70, "ItemizedText",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->140303210],
Cell[272086, 4906, 3942, 67, 70, "ItemizedPicture",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->162327058]
}, Open  ]],
Cell[CellGroupData[{
Cell[276065, 4978, 637, 16, 70, "ItemizedText",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->330821102],
Cell[276705, 4996, 7952, 133, 70, "ItemizedPicture",
 Evaluatable->False,
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->244938124]
}, Open  ]],
Cell[CellGroupData[{
Cell[284694, 5134, 364, 7, 70, "ItemizedText",
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->379618602],
Cell[285061, 5143, 8473, 142, 70, "ItemizedPicture",
 Evaluatable->False,
 CellTags->{"hyperlinks", "i:64", "b:9.0", "gs:0.10", "b:9.1", "i:51"},
 CellID->111599595]
}, Open  ]],
Cell[CellGroupData[{
Cell[293571, 5290, 120, 2, 70, "Subsubsection",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
 CellID->466062922],
Cell[293694, 5294, 339, 10, 70, "Notes",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10", "b:9.0", "i:50"},
 CellID->311240708]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[294082, 5310, 142, 3, 70, "Subsection",
 PageBreakAbove->True,
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->410966860],
Cell[294227, 5315, 149, 2, 70, "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->257750023],
Cell[CellGroupData[{
Cell[294401, 5321, 145, 2, 70, "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->627630235],
Cell[294549, 5325, 2048, 36, 70, "ItemizedPicture",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->54001265]
}, Open  ]],
Cell[296612, 5364, 408, 12, 70, "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->625424405],
Cell[297023, 5378, 137, 2, 70, "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->549712507],
Cell[297163, 5382, 262, 6, 70, "ItemizedTextParagraph",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->125044020],
Cell[297428, 5390, 318, 8, 70, "ItemizedTextParagraph",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->45672800],
Cell[CellGroupData[{
Cell[297771, 5402, 235, 5, 70, "ItemizedTextParagraph",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->193422084],
Cell[298009, 5409, 9355, 157, 70, "ItemizedPicture",
 Evaluatable->False,
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->282059674]
}, Open  ]],
Cell[307379, 5569, 166, 6, 70, "ItemizedText",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->1005432286],
Cell[CellGroupData[{
Cell[307570, 5579, 101, 2, 70, "Subsubsection",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->4542761],
Cell[307674, 5583, 299, 6, 70, "Notes",
 CellTags->{"hyperlinks", "i:65", "b:9.1", "gs:0.10"},
 CellID->1899898911]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[308024, 5595, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

