(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10183,        317]
NotebookOptionsPosition[      5535,        187]
NotebookOutlinePosition[      9374,        285]
CellTagsIndexPosition[      9285,        279]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Differential Equation Solving with DSolve" :> 
         Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 2]& ,
        Evaluator -> Automatic], {
      1->"\<\"Differential Equation Solving with DSolve\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Introduction to Working with DSolve", "Title",
 CellTags->{"c:51", "b:5.0"},
 CellID->19420],

Cell[TextData[{
 "The aim of these tutorials is to provide a self-contained working guide for \
solving different types of problems with ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". Hence, the ideas will be developed without any reference to material",
 " ",
 "covered elsewhere in the documentation."
}], "Text",
 CellTags->"b:5.0",
 CellID->19770],

Cell[TextData[{
 "The first step in using ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is to set up the problem correctly. The next step is to use ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to get an expression for the solution. Once the solution has been found, \
it can be verified using symbolic or numerical techniques, or it can be \
plotted using a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function such as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 ". Plots often reveal information about the solution that might not be",
 " ",
 "evident from its closed-form expression."
}], "Text",
 CellTags->"b:5.0",
 CellID->19022],

Cell[TextData[{
 "If no boundary conditions are specified for a problem, the output from ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is some form of a general solution containing arbitrary parameters. The ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " option can be used to label these arbitrary parameters."
}], "Text",
 CellTags->"b:5.0",
 CellID->9273],

Cell[TextData[{
 "In many applications, differential equations contain symbolic parameters, \
such as the rate of growth in the logistic equation. A differential equation \
can also contain inexact quantities, such as machine numbers arising from \
previous calculations. Both symbolic parameters and inexact quantities are \
allowed by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", but it is good to be aware of their presence and interpret the solution",
 " ",
 "correctly. "
}], "Text",
 CellTags->"b:5.0",
 CellID->25841],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " makes any assumptions or encounters difficulty during a calculation, it \
issues a warning message outlining the problem. These messages can usually be \
ignored, but sometimes they point to serious limitations in the answer \
given",
 " ",
 "for the problem. "
}], "Text",
 CellTags->"b:5.0",
 CellID->12686],

Cell[TextData[{
 "It is helpful to analyze the statement of the problem for possible",
 " ",
 "ambiguities\[LongDash]in other words, to make sure that the problem is \
well-posed\[LongDash]so that meaningful answers can be obtained from ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:5.0",
 CellID->28888],

Cell[TextData[{
 "All these aspects of working with ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " are discussed in the following tutorials. "
}], "Text",
 CellTags->"b:5.0",
 CellID->3917],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->161357452],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Introduction to Working with DSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Differential Equation Solving with DSolve", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> "paclet:tutorial/DSolveOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolvePiecewiseBVPs"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DSolveSettingUpTheProblem"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 35.2379858}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The aim of these tutorials is to provide a self-contained working guide \
for solving different types of problems with DSolve. Hence, the ideas will be \
developed without any reference to material covered elsewhere in the \
documentation. The first step in using DSolve is to set up the problem \
correctly. The next step is to use DSolve to get an expression for the \
solution. Once the solution has been found, it can be verified using symbolic \
or numerical techniques, or it can be plotted using a Mathematica function \
such as Plot, Plot3D, or ContourPlot. Plots often reveal information about \
the solution that might not be evident from its closed-form expression. If no \
boundary conditions are specified for a problem, the output from DSolve is \
some form of a general solution containing arbitrary parameters. The \
GeneratedParameters option can be used to label these arbitrary parameters.", 
    "synonyms" -> {}, "title" -> "Introduction to Working with DSolve", 
    "type" -> "Tutorial", "uri" -> "tutorial/WorkingWithDSolveIntroduction"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "c:51"->{
  Cell[1280, 43, 98, 2, 70, "Title",
   CellTags->{"c:51", "b:5.0"},
   CellID->19420]},
 "b:5.0"->{
  Cell[1280, 43, 98, 2, 70, "Title",
   CellTags->{"c:51", "b:5.0"},
   CellID->19420],
  Cell[1381, 47, 426, 12, 70, "Text",
   CellTags->"b:5.0",
   CellID->19770],
  Cell[1810, 61, 1123, 36, 70, "Text",
   CellTags->"b:5.0",
   CellID->19022],
  Cell[2936, 99, 532, 14, 70, "Text",
   CellTags->"b:5.0",
   CellID->9273],
  Cell[3471, 115, 601, 15, 70, "Text",
   CellTags->"b:5.0",
   CellID->25841],
  Cell[4075, 132, 453, 14, 70, "Text",
   CellTags->"b:5.0",
   CellID->12686],
  Cell[4531, 148, 407, 12, 70, "Text",
   CellTags->"b:5.0",
   CellID->28888],
  Cell[4941, 162, 263, 9, 70, "Text",
   CellTags->"b:5.0",
   CellID->3917]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"c:51", 8517, 247},
 {"b:5.0", 8618, 251}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 655, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1280, 43, 98, 2, 70, "Title",
 CellTags->{"c:51", "b:5.0"},
 CellID->19420],
Cell[1381, 47, 426, 12, 70, "Text",
 CellTags->"b:5.0",
 CellID->19770],
Cell[1810, 61, 1123, 36, 70, "Text",
 CellTags->"b:5.0",
 CellID->19022],
Cell[2936, 99, 532, 14, 70, "Text",
 CellTags->"b:5.0",
 CellID->9273],
Cell[3471, 115, 601, 15, 70, "Text",
 CellTags->"b:5.0",
 CellID->25841],
Cell[4075, 132, 453, 14, 70, "Text",
 CellTags->"b:5.0",
 CellID->12686],
Cell[4531, 148, 407, 12, 70, "Text",
 CellTags->"b:5.0",
 CellID->28888],
Cell[4941, 162, 263, 9, 70, "Text",
 CellTags->"b:5.0",
 CellID->3917],
Cell[CellGroupData[{
Cell[5229, 175, 72, 1, 70, "RelatedTutorialsSection",
 CellID->161357452],
Cell[5304, 178, 177, 3, 70, "RelatedTutorials",
 CellID->439091251]
}, Open  ]]
}, Open  ]],
Cell[5508, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

