(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27831,       1035]
NotebookOptionsPosition[     21081,        805]
NotebookOutlinePosition[     23337,        864]
CellTagsIndexPosition[     23244,        858]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"D" :> Documentation`HelpLookup["paclet:ref/D"], "FindRoot" :> 
         Documentation`HelpLookup["paclet:ref/FindRoot"], "FullSimplify" :> 
         Documentation`HelpLookup["paclet:ref/FullSimplify"], 
         "FunctionExpand" :> 
         Documentation`HelpLookup["paclet:ref/FunctionExpand"], "Integrate" :> 
         Documentation`HelpLookup["paclet:ref/Integrate"], "N" :> 
         Documentation`HelpLookup["paclet:ref/N"], "NIntegrate" :> 
         Documentation`HelpLookup["paclet:ref/NIntegrate"], "Series" :> 
         Documentation`HelpLookup["paclet:ref/Series"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"D\"\>", 2->"\<\"FindRoot\"\>", 
      3->"\<\"FullSimplify\"\>", 4->"\<\"FunctionExpand\"\>", 
      5->"\<\"Integrate\"\>", 6->"\<\"N\"\>", 7->"\<\"NIntegrate\"\>", 
      8->"\<\"Series\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Working with Special Functions", "Title",
 CellTags->{"S3.2.14", "14.1"},
 CellID->19448],

Cell[BoxData[GridBox[{
   {Cell["automatic evaluation", "TableText"], Cell[
    "exact results for specific arguments", "TableText"]},
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[
    "numerical approximations to any precision", "TableText"]},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[
    "exact results for derivatives", "TableText"]},
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "]", "]"}], Cell[
    "numerical approximations to derivatives", "TableText"]},
   {
    RowBox[{
     ButtonBox["Series",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Series"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["n", "TI"], "}", "]"}], Cell[
    "series expansions", "TableText"]},
   {
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[
    "exact results for integrals", "TableText"]},
   {
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[
    "numerical approximations to integrals", "TableText"]},
   {
    RowBox[{
     ButtonBox["FindRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindRoot"], "[", 
     StyleBox["expr", "TI"], "==", "0", ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], "}", "]"}], Cell[
    "numerical approximations to roots", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, True, True, False, {True}, False}, 
   "RowsIndexed" -> {}}},
 CellID->26392],

Cell["Some common operations on special functions. ", "Caption",
 CellID->13531],

Cell[TextData[{
 "Most special functions have simpler forms when given certain specific \
arguments. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically simplify special functions in such cases. "
}], "Text",
 CellID->10204],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically writes this in terms of standard mathematical constants. "
}], "MathCaption",
 CellID->19695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyLog", "[", 
  RowBox[{"2", ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27294],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[Pi]", "2"], "12"], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Log", "[", "2", "]"}], "2"], "2"]}]], "Output",
 ImageSize->{87, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->631478761]
}, Open  ]],

Cell[TextData[{
 "Here again ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reduces a special case of the Airy function to an expression involving \
gamma functions. "
}], "MathCaption",
 CellID->19149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAi", "[", "0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1951],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox["3", 
    RowBox[{"2", "/", "3"}]], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["2", "3"], "]"}]}]]], "Output",
 ImageSize->{93, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399352653]
}, Open  ]],

Cell[TextData[{
 "For most choices of arguments, no exact reductions of special functions are \
possible. But in such cases, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to find numerical approximations to any degree of precision. \
The algorithms that are built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cover essentially all values of parameters\[LongDash]real and complex\
\[LongDash]for which the special functions are defined. "
}], "Text",
 CellID->31598],

Cell["There is no exact result known here. ", "MathCaption",
 CellID->21845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAi", "[", "1", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13675],

Cell[BoxData[
 RowBox[{"AiryAi", "[", "1", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1033642096]
}, Open  ]],

Cell["\<\
This gives a numerical approximation to 40 digits of precision. \
\>", "MathCaption",
 CellID->31584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AiryAi", "[", "1", "]"}], ",", "40"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21433],

Cell[BoxData["0.1352924163128814155241474235154663061749441429881387584841`40.\
"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1427486889]
}, Open  ]],

Cell[TextData[{
 "The result here is a huge complex number, but ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can still find it. "
}], "MathCaption",
 CellID->14399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"AiryAi", "[", 
   RowBox[{"1000", " ", "I"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21567],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4.780266637767026637834102826`15.954589770191005*^6472"}], 
  "+", 
  RowBox[{
  "3.674920907226875313534285024`15.954589770191005*^6472", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{365, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->84839139]
}, Open  ]],

Cell[TextData[{
 "Most special functions have derivatives that can be expressed in terms of \
elementary functions or other special functions. But even in cases where this \
is not so, you can still use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to find numerical approximations to derivatives."
}], "Text",
 CellID->26009],

Cell["This derivative comes out in terms of elementary functions. ", \
"MathCaption",
 CellID->8941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->26231],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  FractionBox[
   RowBox[{"\[Pi]", " ", 
    SuperscriptBox["x", "2"]}], "2"], "]"}]], "Output",
 ImageSize->{67, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2109751212]
}, Open  ]],

Cell["\<\
This evaluates the derivative of the gamma function at the point 3. \
\>", "MathCaption",
 CellID->4898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "'"}], "[", "3", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->10974],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["3", "2"], "-", "EulerGamma"}], ")"}]}]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1486124467]
}, Open  ]],

Cell["\<\
There is no exact formula for this derivative of the zeta function. \
\>", "MathCaption",
 CellID->759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Zeta", "'"}], "[", "Pi", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->31262],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["Zeta", "\[Prime]",
   MultilineFunction->None], "[", "\[Pi]", "]"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->2059102259]
}, Open  ]],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " gives a numerical approximation. "
}], "MathCaption",
 CellID->15729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->13659],

Cell[BoxData[
 RowBox[{"-", "0.16760309736344522`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->632695608]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " incorporates a vast amount of knowledge about special \
functions\[LongDash]including essentially all the results that have been \
derived over the years. You access this knowledge whenever you do operations \
on special functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->767],

Cell["Here is a series expansion for a Fresnel function. ", "MathCaption",
 CellID->4966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->3968],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["x", "3"]}], "6"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "3"], " ", 
     SuperscriptBox["x", "7"]}], "336"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "5"], " ", 
     SuperscriptBox["x", "11"]}], "42240"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "7"], " ", 
     SuperscriptBox["x", "15"]}], "9676800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "16"],
    SeriesData[$CellContext`x, 0, {}, 3, 16, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Rational[1, 6] Pi, 0, 0, 0, Rational[-1, 336] Pi^3, 0, 0, 0, 
    Rational[1, 42240] Pi^5, 0, 0, 0, Rational[-1, 9676800] Pi^7}, 3, 16, 1],
  Editable->False]], "Output",
 ImageSize->{253, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1523547359]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows how to do a vast range of integrals involving special functions. "
}], "MathCaption",
 CellID->2094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AiryAi", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->10849],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox["3", 
    RowBox[{"2", "/", "3"}]], " ", 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     FractionBox["1", "3"], "]"}], "2"]}]]], "Output",
 ImageSize->{99, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1812939532]
}, Open  ]],

Cell["\<\
One feature of working with special functions is that there are a large \
number of relations between different functions, and these relations can \
often be used in simplifying expressions. \
\>", "Text",
 CellID->29542],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FullSimplify",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullSimplify"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "try to simplify ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " using a range of transformation rules"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17923],

Cell["Simplifying expressions involving special functions. ", "Caption",
 CellID->27396],

Cell["This uses the reflection formula for the gamma function. ", \
"MathCaption",
 CellID->5417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->15411],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"Csc", "[", 
   RowBox[{"\[Pi]", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->1576730688]
}, Open  ]],

Cell["\<\
This makes use of a representation for Chebyshev polynomials. \
\>", "MathCaption",
 CellID->12048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ChebyshevT", "[", 
    RowBox[{"n", ",", "z"}], "]"}], "-", 
   RowBox[{"k", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"n", " ", 
      RowBox[{"ArcCos", "[", "z", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->15781],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "k"}], ")"}]}], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{"n", " ", 
    RowBox[{"ArcCos", "[", "z", "]"}]}], "]"}]}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->164469236]
}, Open  ]],

Cell["The Airy functions are related to Bessel functions. ", "MathCaption",
 CellID->10574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"3", " ", 
    RowBox[{"AiryAi", "[", "1", "]"}]}], "+", 
   RowBox[{
    RowBox[{"Sqrt", "[", "3", "]"}], " ", 
    RowBox[{"AiryBi", "[", "1", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->24688],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"BesselI", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "3"]}], ",", 
    FractionBox["2", "3"]}], "]"}]}]], "Output",
 ImageSize->{119, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->422995763]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FunctionExpand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FunctionExpand"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "try to expand out special functions", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7668],

Cell["Manipulating expressions involving special functions. ", "Caption",
 CellID->10468],

Cell[TextData[{
 "This expands out the ",
 Cell[BoxData[
  ButtonBox["PolyGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyGamma"]], "InlineFormula"],
 ", yielding a function with a simpler argument. "
}], "MathCaption",
 CellID->2425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"PolyGamma", "[", 
   RowBox[{"2", ",", 
    RowBox[{"2", "+", "x"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->6204],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["x", "3"]], "+", 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "3"]]}], ")"}]}], "+", 
  RowBox[{"PolyGamma", "[", 
   RowBox[{"2", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{223, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1118917171]
}, Open  ]],

Cell["Here is an example involving Bessel functions. ", "MathCaption",
 CellID->30921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"BesselY", "[", 
   RowBox[{"n", ",", 
    RowBox[{"I", " ", "x"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->14960],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", " ", "x"}], ")"}], 
      RowBox[{"-", "n"}]], " ", 
     SuperscriptBox["x", "n"], " ", 
     RowBox[{"BesselK", "[", 
      RowBox[{"n", ",", "x"}], "]"}]}], "\[Pi]"]}], "+", 
  RowBox[{
   RowBox[{"BesselI", "[", 
    RowBox[{"n", ",", "x"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", " ", "x"}], ")"}], 
        RowBox[{"-", "n"}]]}], " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", " ", "x"}], ")"}], "n"], " ", 
      SuperscriptBox["x", 
       RowBox[{"-", "n"}]], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"n", " ", "\[Pi]"}], "]"}]}]}], ")"}], " ", 
   RowBox[{"Csc", "[", 
    RowBox[{"n", " ", "\[Pi]"}], "]"}]}]}]], "Output",
 ImageSize->{542, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->126596218]
}, Open  ]],

Cell[TextData[{
 "In this case the final result does not even involve ",
 Cell[BoxData[
  ButtonBox["PolyGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyGamma"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Im", "[", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"0", ",", 
     RowBox[{"3", " ", "I"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->19951],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Pi]", " ", 
   RowBox[{"Coth", "[", 
    RowBox[{"3", " ", "\[Pi]"}], "]"}]}]}]], "Output",
 ImageSize->{113, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1693825396]
}, Open  ]],

Cell["\<\
This finds an expression for a derivative of the Hurwitz zeta function. \
\>", "MathCaption",
 CellID->10342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Derivative", "[", 
     RowBox[{"1", ",", "0"}], "]"}], "[", "Zeta", "]"}], "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->275310297],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", "2", "]"}]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"Log", "[", "3", "]"}]}], "-", 
  RowBox[{"Log", "[", "Glaisher", "]"}]}]], "Output",
 ImageSize->{255, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->1080205940]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Working with Special Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 46, 36.5505194}", "context" -> "", 
    "keywords" -> {
     "approximate differentiation", "compound arguments", "derivatives", 
      "differentiation", "expanding", "formulas", "FullSimplify", 
      "FunctionExpand", "identities", "numerical derivatives", 
      "numerical differentiation", "reduction formulas", "reflection formula",
       "relations", "simplification", "special functions", "tables", 
      "transformations"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Some common operations on special functions. Most special functions have \
simpler forms when given certain specific arguments. Mathematica will \
automatically simplify special functions in such cases. Mathematica \
automatically writes this in terms of standard mathematical constants. ", 
    "synonyms" -> {"3.2.14"}, "title" -> "Working with Special Functions", 
    "type" -> "Tutorial", "uri" -> "tutorial/WorkingWithSpecialFunctions"}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.14"->{
  Cell[1862, 51, 95, 2, 70, "Title",
   CellTags->{"S3.2.14", "14.1"},
   CellID->19448]},
 "14.1"->{
  Cell[1862, 51, 95, 2, 70, "Title",
   CellTags->{"S3.2.14", "14.1"},
   CellID->19448]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.14", 23028, 847},
 {"14.1", 23130, 851}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1237, 24, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1862, 51, 95, 2, 70, "Title",
 CellTags->{"S3.2.14", "14.1"},
 CellID->19448],
Cell[1960, 55, 2324, 73, 70, "DefinitionBox",
 CellID->26392],
Cell[4287, 130, 80, 1, 70, "Caption",
 CellID->13531],
Cell[4370, 133, 246, 7, 70, "Text",
 CellID->10204],
Cell[4619, 142, 175, 5, 70, "MathCaption",
 CellID->19695],
Cell[CellGroupData[{
Cell[4819, 151, 146, 5, 28, "Input",
 CellID->27294],
Cell[4968, 158, 309, 11, 54, "Output",
 CellID->631478761]
}, Open  ]],
Cell[5292, 172, 210, 7, 70, "MathCaption",
 CellID->19149],
Cell[CellGroupData[{
Cell[5527, 183, 97, 3, 28, "Input",
 CellID->1951],
Cell[5627, 188, 307, 11, 60, "Output",
 CellID->399352653]
}, Open  ]],
Cell[5949, 202, 500, 12, 70, "Text",
 CellID->31598],
Cell[6452, 216, 76, 1, 70, "MathCaption",
 CellID->21845],
Cell[CellGroupData[{
Cell[6553, 221, 98, 3, 70, "Input",
 CellID->13675],
Cell[6654, 226, 191, 6, 36, "Output",
 CellID->1033642096]
}, Open  ]],
Cell[6860, 235, 111, 3, 70, "MathCaption",
 CellID->31584],
Cell[CellGroupData[{
Cell[6996, 242, 151, 5, 70, "Input",
 CellID->21433],
Cell[7150, 249, 225, 6, 36, "Output",
 CellID->1427486889]
}, Open  ]],
Cell[7390, 258, 174, 6, 70, "MathCaption",
 CellID->14399],
Cell[CellGroupData[{
Cell[7589, 268, 153, 5, 70, "Input",
 CellID->21567],
Cell[7745, 275, 349, 11, 36, "Output",
 CellID->84839139]
}, Open  ]],
Cell[8109, 289, 391, 10, 70, "Text",
 CellID->26009],
Cell[8503, 301, 100, 2, 70, "MathCaption",
 CellID->8941],
Cell[CellGroupData[{
Cell[8628, 307, 152, 5, 70, "Input",
 CellID->26231],
Cell[8783, 314, 263, 9, 54, "Output",
 CellID->2109751212]
}, Open  ]],
Cell[9061, 326, 114, 3, 70, "MathCaption",
 CellID->4898],
Cell[CellGroupData[{
Cell[9200, 333, 115, 4, 70, "Input",
 CellID->10974],
Cell[9318, 339, 261, 9, 51, "Output",
 CellID->1486124467]
}, Open  ]],
Cell[9594, 351, 113, 3, 70, "MathCaption",
 CellID->759],
Cell[CellGroupData[{
Cell[9732, 358, 115, 4, 70, "Input",
 CellID->31262],
Cell[9850, 364, 252, 8, 36, "Output",
 CellID->2059102259]
}, Open  ]],
Cell[10117, 375, 207, 8, 70, "MathCaption",
 CellID->15729],
Cell[CellGroupData[{
Cell[10349, 387, 93, 3, 70, "Input",
 CellID->13659],
Cell[10445, 392, 194, 6, 36, "Output",
 CellID->632695608]
}, Open  ]],
Cell[10654, 401, 385, 11, 70, "Text",
 CellID->767],
Cell[11042, 414, 89, 1, 70, "MathCaption",
 CellID->4966],
Cell[CellGroupData[{
Cell[11156, 419, 217, 7, 70, "Input",
 CellID->3968],
Cell[11376, 428, 989, 31, 54, "Output",
 CellID->1523547359]
}, Open  ]],
Cell[12380, 462, 174, 5, 70, "MathCaption",
 CellID->2094],
Cell[CellGroupData[{
Cell[12579, 471, 250, 8, 70, "Input",
 CellID->10849],
Cell[12832, 481, 336, 12, 61, "Output",
 CellID->1812939532]
}, Open  ]],
Cell[13183, 496, 231, 5, 70, "Text",
 CellID->29542],
Cell[13417, 503, 680, 20, 70, "DefinitionBox",
 CellID->17923],
Cell[14100, 525, 88, 1, 70, "Caption",
 CellID->27396],
Cell[14191, 528, 97, 2, 70, "MathCaption",
 CellID->5417],
Cell[CellGroupData[{
Cell[14313, 534, 219, 7, 70, "Input",
 CellID->15411],
Cell[14535, 543, 244, 8, 36, "Output",
 CellID->1576730688]
}, Open  ]],
Cell[14794, 554, 109, 3, 70, "MathCaption",
 CellID->12048],
Cell[CellGroupData[{
Cell[14928, 561, 310, 10, 70, "Input",
 CellID->15781],
Cell[15241, 573, 359, 13, 36, "Output",
 CellID->164469236]
}, Open  ]],
Cell[15615, 589, 91, 1, 70, "MathCaption",
 CellID->10574],
Cell[CellGroupData[{
Cell[15731, 594, 279, 9, 70, "Input",
 CellID->24688],
Cell[16013, 605, 307, 11, 51, "Output",
 CellID->422995763]
}, Open  ]],
Cell[16335, 619, 569, 16, 70, "DefinitionBox",
 CellID->7668],
Cell[16907, 637, 89, 1, 70, "Caption",
 CellID->10468],
Cell[16999, 640, 247, 8, 70, "MathCaption",
 CellID->2425],
Cell[CellGroupData[{
Cell[17271, 652, 191, 6, 70, "Input",
 CellID->6204],
Cell[17465, 660, 476, 17, 55, "Output",
 CellID->1118917171]
}, Open  ]],
Cell[17956, 680, 86, 1, 70, "MathCaption",
 CellID->30921],
Cell[CellGroupData[{
Cell[18067, 685, 190, 6, 70, "Input",
 CellID->14960],
Cell[18260, 693, 1130, 38, 52, "Output",
 CellID->126596218]
}, Open  ]],
Cell[19405, 734, 234, 8, 70, "MathCaption",
 CellID->23922],
Cell[CellGroupData[{
Cell[19664, 746, 224, 7, 70, "Input",
 CellID->19951],
Cell[19891, 755, 324, 11, 51, "Output",
 CellID->1693825396]
}, Open  ]],
Cell[20230, 769, 119, 3, 70, "MathCaption",
 CellID->10342],
Cell[CellGroupData[{
Cell[20374, 776, 280, 9, 70, "Input",
 CellID->275310297],
Cell[20657, 787, 370, 12, 51, "Output",
 CellID->1080205940]
}, Open  ]]
}, Open  ]],
Cell[21054, 803, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

