(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11050,        370]
NotebookOptionsPosition[      7166,        268]
NotebookOutlinePosition[      9252,        311]
CellTagsIndexPosition[      9209,        308]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell[TextData[{
 "Java Objects in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 Cell[TextData[ButtonBox["LoadJavaClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/LoadJavaClass"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " load and set up a Java class for use from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->1389774262],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expression that represents a Java class"
}], "GuideText",
 CellID->840169863],

Cell["\t", "GuideDelimiter",
 CellID->1485202105],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaNew",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a Java object of a specified class"
}], "GuideText",
 CellID->1163720099],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expression that represents a Java class"
}], "GuideText",
 CellID->1589349654],

Cell[TextData[{
 Cell[TextData[ButtonBox["MakeJavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/MakeJavaObject"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MakeJavaExpr",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/MakeJavaExpr"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a Java object that represents an expression"
}], "GuideText",
 CellID->751041527],

Cell["\t", "GuideDelimiter",
 CellID->1129659147],

Cell[TextData[{
 Cell[TextData[ButtonBox["Constructors",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/Constructors"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Methods",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/Methods"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Fields",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/Fields"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " information about classes"
}], "GuideText",
 CellID->358177342],

Cell["\t", "GuideDelimiter",
 CellID->1245246613],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaObjectQ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaObjectQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether an expression is a valid Java object reference"
}], "GuideText",
 CellID->65867459],

Cell[TextData[{
 Cell[TextData[ButtonBox["InstanceOf",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/InstanceOf"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether an object is an instance of a certain class or interface"
}], "GuideText",
 CellID->1080305208],

Cell[TextData[{
 Cell[TextData[ButtonBox["SameObjectQ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/SameObjectQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether two ",
 Cell[TextData[ButtonBox["JavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFunctionSans"],
 " expressions reference the same Java object"
}], "GuideText",
 CellID->1862879118],

Cell["\t", "GuideDelimiter",
 CellID->1029908416],

Cell[TextData[{
 Cell[TextData[ButtonBox["LoadedJavaObjects",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/LoadedJavaObjects"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["LoadedJavaClasses",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/LoadedJavaClasses"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " list all Java objects or classes in use"
}], "GuideText",
 CellID->1036261045],

Cell["\t", "GuideDelimiter",
 CellID->157338760],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClassName",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/ClassName"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " get the fully qualified name of a class"
}], "GuideText",
 CellID->1811297830],

Cell[TextData[{
 Cell[TextData[ButtonBox["GetClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/GetClass"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ParentClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/ParentClass"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " get the ",
 Cell[TextData[ButtonBox["JavaClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFunctionSans"],
 " representing a Java object's class or parent class"
}], "GuideText",
 CellID->1901932585],

Cell["\t", "GuideDelimiter",
 CellID->2071414556],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReturnAsJavaObject",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " return an object reference instead of its value"
}], "GuideText",
 CellID->489924453],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaObjectToExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaObjectToExpression"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert an object reference into its value"
}], "GuideText",
 CellID->707978973],

Cell["\t", "GuideDelimiter",
 CellID->344221041],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImplementJavaInterface",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/ImplementJavaInterface"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " implement a Java interface via callbacks to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->1943194831]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "GuideTutorial",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Java Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Java Objects in Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Java Objects in Mathematica", "summary" -> 
    "LoadJavaClass -- load and set up a Java class for use from Mathematica, \
JavaClass -- expression that represents a Java class, JavaNew -- create a \
Java object of a specified class, JavaObject -- expression that represents a \
Java class, MakeJavaObject, MakeJavaExpr -- create a Java object that \
represents an expression, Constructors, Methods, Fields -- information about \
classes, JavaObjectQ -- whether an expression is a valid Java object \
reference, InstanceOf -- whether an object is an instance of a certain class \
or interface, SameObjectQ -- whether two JavaObject expressions reference the \
same Java object, LoadedJavaObjects, LoadedJavaClasses -- list all Java \
objects or classes in use, ClassName -- get the fully qualified name of a \
class, GetClass, ParentClass -- get the JavaClass representing a Java \
object's class or parent class, ReturnAsJavaObject -- return an object \
reference instead of its value, JavaObjectToExpression -- convert an object \
reference into its value, ImplementJavaInterface -- implement a Java \
interface via callbacks to Mathematica", "uri" -> 
    "JLink/guide/JavaClassesAndObjects", "type" -> "Guide", "label" -> 
    "J Link Guide", "paclet" -> "JLink", "context" -> "", "keywords" -> {}, 
    "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 28, 56.4244238}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 122, 5, 70, "GuideTitle",
 CellID->942062912],
Cell[744, 32, 332, 10, 70, "GuideText",
 CellID->1389774262],
Cell[1079, 44, 271, 8, 70, "GuideText",
 CellID->840169863],
Cell[1353, 54, 49, 1, 70, "GuideDelimiter",
 CellID->1485202105],
Cell[1405, 57, 270, 8, 70, "GuideText",
 CellID->1163720099],
Cell[1678, 67, 274, 8, 70, "GuideText",
 CellID->1589349654],
Cell[1955, 77, 433, 12, 70, "GuideText",
 CellID->751041527],
Cell[2391, 91, 49, 1, 70, "GuideDelimiter",
 CellID->1129659147],
Cell[2443, 94, 523, 16, 70, "GuideText",
 CellID->358177342],
Cell[2969, 112, 49, 1, 70, "GuideDelimiter",
 CellID->1245246613],
Cell[3021, 115, 289, 8, 70, "GuideText",
 CellID->65867459],
Cell[3313, 125, 299, 8, 70, "GuideText",
 CellID->1080305208],
Cell[3615, 135, 427, 12, 70, "GuideText",
 CellID->1862879118],
Cell[4045, 149, 49, 1, 70, "GuideDelimiter",
 CellID->1029908416],
Cell[4097, 152, 439, 12, 70, "GuideText",
 CellID->1036261045],
Cell[4539, 166, 48, 1, 70, "GuideDelimiter",
 CellID->157338760],
Cell[4590, 169, 272, 8, 70, "GuideText",
 CellID->1811297830],
Cell[4865, 179, 562, 16, 70, "GuideText",
 CellID->1901932585],
Cell[5430, 197, 49, 1, 70, "GuideDelimiter",
 CellID->2071414556],
Cell[5482, 200, 297, 8, 70, "GuideText",
 CellID->489924453],
Cell[5782, 210, 303, 9, 70, "GuideText",
 CellID->707978973],
Cell[6088, 221, 48, 1, 70, "GuideDelimiter",
 CellID->344221041],
Cell[6139, 224, 355, 11, 70, "GuideText",
 CellID->1943194831]
}, Open  ]],
Cell[CellGroupData[{
Cell[6531, 240, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6596, 243, 275, 9, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[6908, 257, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6973, 260, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[7139, 266, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

