(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7962,        272]
NotebookOptionsPosition[      4951,        189]
NotebookOutlinePosition[      6655,        227]
CellTagsIndexPosition[      6612,        224]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Java Connection Management", "GuideTitle",
 CellID->942062912],

Cell[CellGroupData[{

Cell["Launching Java", "GuideFunctionsSubsection",
 CellID->30399314],

Cell[TextData[{
 Cell[TextData[ButtonBox["InstallJava",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " launch the Java runtime and prepare it for use from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->1276285089],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReinstallJava",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/ReinstallJava"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " quit and restart the Java runtime"
}], "GuideText",
 CellID->1967646059],

Cell[TextData[{
 Cell[TextData[ButtonBox["UninstallJava",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/UninstallJava"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " quit the Java runtime"
}], "GuideText",
 CellID->1126633460],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaLink",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaLink"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the link to the Java runtime"
}], "GuideText",
 CellID->965246621],

Cell["\t", "GuideDelimiterSubsection",
 CellID->2114834855]
}, Open  ]],

Cell[CellGroupData[{

Cell["Configuration", "GuideFunctionsSubsection",
 CellID->652524377],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaClassPath",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaClassPath"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["AddToClassPath",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/AddToClassPath"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the directories and jar files searched for classes"
}], "GuideText",
 CellID->897859357],

Cell[TextData[{
 Cell[TextData[ButtonBox["GetComplexClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/GetComplexClass"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SetComplexClass",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/SetComplexClass"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the class for representing complex numbers"
}], "GuideText",
 CellID->1152669042],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetInternetProxy",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/SetInternetProxy"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " configure a proxy for connecting to the internet"
}], "GuideText",
 CellID->125353185],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowJavaConsole",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/ShowJavaConsole"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " display ",
 StyleBox["System.out", "InlineCode"],
 " and ",
 StyleBox["System.err", "InlineCode"],
 " output in a separate window"
}], "GuideText",
 CellID->129522588],

Cell[TextData[{
 Cell[TextData[ButtonBox["AllowRaggedArrays",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/AllowRaggedArrays"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to allow non rectangular arrays to be sent to Java"
}], "GuideText",
 CellID->1157504594],

Cell[TextData[{
 Cell[TextData[ButtonBox["$RelaxedTypeChecking",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/$RelaxedTypeChecking"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to suspend type checking of arrays sent to Java"
}], "GuideText",
 CellID->1571550785]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "GuideTutorial",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Java Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Java Connection Management - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Java Connection Management", "summary" -> 
    "InstallJava -- launch the Java runtime and prepare it for use from \
Mathematica, ReinstallJava -- quit and restart the Java runtime, \
UninstallJava -- quit the Java runtime, JavaLink -- the link to the Java \
runtime, JavaClassPath, AddToClassPath -- the directories and jar files \
searched for classes, GetComplexClass, SetComplexClass -- the class for \
representing complex numbers, SetInternetProxy -- configure a proxy for \
connecting to the internet, ShowJavaConsole -- display System.out and \
System.err output in a separate window, AllowRaggedArrays -- whether to allow \
non rectangular arrays to be sent to Java, $RelaxedTypeChecking -- whether to \
suspend type checking of arrays sent to Java", "uri" -> 
    "JLink/guide/JavaConnectionManagement", "type" -> "Guide", "label" -> 
    "J Link Guide", "paclet" -> "JLink", "context" -> "", "keywords" -> {}, 
    "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 28, 58.3773293}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 68, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[CellGroupData[{
Cell[712, 30, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->30399314],
Cell[784, 33, 338, 10, 70, "GuideText",
 CellID->1276285089],
Cell[1125, 45, 274, 8, 70, "GuideText",
 CellID->1967646059],
Cell[1402, 55, 262, 8, 70, "GuideText",
 CellID->1126633460],
Cell[1667, 65, 258, 8, 70, "GuideText",
 CellID->965246621],
Cell[1928, 75, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->2114834855]
}, Open  ]],
Cell[CellGroupData[{
Cell[2024, 81, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->652524377],
Cell[2096, 84, 435, 12, 70, "GuideText",
 CellID->897859357],
Cell[2534, 98, 434, 12, 70, "GuideText",
 CellID->1152669042],
Cell[2971, 112, 294, 8, 70, "GuideText",
 CellID->125353185],
Cell[3268, 122, 373, 12, 70, "GuideText",
 CellID->129522588],
Cell[3644, 136, 307, 8, 70, "GuideText",
 CellID->1157504594],
Cell[3954, 146, 313, 9, 70, "GuideText",
 CellID->1571550785]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4316, 161, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4381, 164, 275, 9, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[4693, 178, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4758, 181, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[4924, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

