(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4140,        149]
NotebookOptionsPosition[      2322,         95]
NotebookOutlinePosition[      3501,        126]
CellTagsIndexPosition[      3458,        123]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Java Exception Handling", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 Cell[TextData[ButtonBox["GetJavaException",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/GetJavaException"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " get the exception object thrown in the most recent Java call"
}], "GuideText",
 CellID->1941320418],

Cell[TextData[{
 Cell[TextData[ButtonBox["JavaThrow",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/JavaThrow"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " throw a Java exception"
}], "GuideText",
 CellID->1053216455],

Cell["\t", "GuideDelimiter",
 CellID->911088266],

Cell[TextData[{
 Cell[TextData[ButtonBox["$JavaExceptionHandler",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/ref/$JavaExceptionHandler"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " how Java exceptions are handled in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->1848740611]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "GuideTutorial",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Java Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Java Exception Handling - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Java Exception Handling", "summary" -> 
    "GetJavaException -- get the exception object thrown in the most recent \
Java call, JavaThrow -- throw a Java exception, $JavaExceptionHandler -- how \
Java exceptions are handled in Mathematica", "uri" -> 
    "JLink/guide/JavaExceptionHandling", "type" -> "Guide", "label" -> 
    "J Link Guide", "paclet" -> "JLink", "context" -> "", "keywords" -> {}, 
    "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 0.1299368}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 307, 8, 70, "GuideText",
 CellID->1941320418],
Cell[997, 38, 255, 8, 70, "GuideText",
 CellID->1053216455],
Cell[1255, 48, 48, 1, 70, "GuideDelimiter",
 CellID->911088266],
Cell[1306, 51, 344, 11, 70, "GuideText",
 CellID->1848740611]
}, Open  ]],
Cell[CellGroupData[{
Cell[1687, 67, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[1752, 70, 275, 9, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[2064, 84, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[2129, 87, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[2295, 93, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

