(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7339,        244]
NotebookOptionsPosition[      5467,        189]
NotebookOutlinePosition[      6669,        219]
CellTagsIndexPosition[      6626,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"J/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConnectToFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ConnectToFrontEnd"], 
          "UseFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/UseFrontEnd"], 
          "CloseFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/CloseFrontEnd"], 
          "$FrontEndLaunchCommand" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/$FrontEndLaunchCommand"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ConnectToFrontEnd\"\>", 2->"\<\"UseFrontEnd\"\>",
        3->"\<\"CloseFrontEnd\"\>", 
       4->"\<\"$FrontEndLaunchCommand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$FrontEndInitializationFunction", "ObjectName",
 CellID->643719032],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$FrontEndInitializationFunction"], "InlineFormula"],
     " \[LineSeparator]is a function that you can assign to execute when the \
front end link is first established by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["ConnectToFrontEnd",
        BaseStyle->"Link",
        ButtonData->"paclet:JLink/ref/ConnectToFrontEnd"], "[", "]"}]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->492134073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Your function will be passed the link to the front end, and it should \
return ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " to indicate that your initialization was not successful and the front end \
connection should be abandoned. Any other return value will allow the front \
end connection to proceed normally."
}], "Notes",
 CellID->19553798]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->32883291],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConnectToFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ConnectToFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UseFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/CloseFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$FrontEndLaunchCommand",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/$FrontEndLaunchCommand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->66132330]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->453792922],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$FrontEndInitializationFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "$FrontEndInitializationFunction", "summary" -> 
    "$FrontEndInitializationFunction is a function that you can assign to \
execute when the front end link is first established by ConnectToFrontEnd[].",
     "uri" -> "JLink/ref/$FrontEndInitializationFunction", "type" -> "Symbol",
     "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"front end initialization function"}, 
    "status" -> "None", "built" -> "{2007, 4, 20, 15, 31, 13.4082260}", 
    "index" -> True}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1675, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2298, 71, 73, 1, 70, "ObjectName",
 CellID->643719032],
Cell[2374, 74, 626, 18, 70, "Usage",
 CellID->492134073]
}, Open  ]],
Cell[CellGroupData[{
Cell[3037, 97, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3496, 113, 438, 11, 70, "Notes",
 CellID->19553798]
}, Closed]],
Cell[CellGroupData[{
Cell[3971, 129, 53, 1, 70, "SeeAlsoSection",
 CellID->32883291],
Cell[4027, 132, 1030, 35, 70, "SeeAlso",
 CellID->66132330]
}, Open  ]],
Cell[CellGroupData[{
Cell[5094, 172, 57, 1, 70, "TutorialsSection",
 CellID->453792922],
Cell[5154, 175, 271, 9, 70, "Tutorials",
 CellID->281642142]
}, Open  ]],
Cell[5440, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

