(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8331,        282]
NotebookOptionsPosition[      6177,        215]
NotebookOutlinePosition[      7321,        245]
CellTagsIndexPosition[      7278,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaClassPath" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaClassPath"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"JavaClassPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaConnectionManagement"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Java Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AddToClassPath", "ObjectName",
 CellID->353475979],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AddToClassPath", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["path", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["path", "TI"], 
         StyleBox["2", "TR"]], ",", "..."}], "]"}]], "InlineFormula"],
     " \[LineSeparator]adds the specified full paths to directories and jar \
or zip files to the ",
     StyleBox["J/Link",
      FontSlant->"Italic"],
     " class search path. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23256093]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
If you specify a directory, it will be searched automatically for .jar and \
.zip files, in addition to appropriately nested .class files, so you do not \
have to name .jar or .zip files explicitly. \
\>", "Notes",
 CellID->477240847],

Cell["\<\
Changes take effect immediately and apply only to the currently running Java \
runtime. \
\>", "Notes",
 CellID->366530072],

Cell[TextData[{
 "If you quit and restart Java, you will need to call ",
 Cell[BoxData["AddToClassPath"], "InlineFormula"],
 " again."
}], "Notes",
 CellID->127275562]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->480976160],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["JavaClassPath",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaClassPath"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->42291537]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->33395433],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->579956749],

Cell[TextData[ButtonBox["Java Connection Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaConnectionManagement"]], "MoreAbout",
 CellID->96365605]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AddToClassPath - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "AddToClassPath", "summary" -> 
    "AddToClassPath[Subscript[path, 1], Subscript[path, 2], ...] adds the \
specified full paths to directories and jar or zip files to the J/Link class \
search path. ", "uri" -> "JLink/ref/AddToClassPath", "type" -> "Symbol", 
    "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"add to class path"}, "status" -> "None",
     "built" -> "{2007, 4, 20, 15, 29, 10.0947623}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2079, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2702, 83, 56, 1, 70, "ObjectName",
 CellID->353475979],
Cell[2761, 86, 701, 22, 70, "Usage",
 CellID->23256093]
}, Open  ]],
Cell[CellGroupData[{
Cell[3499, 113, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3958, 129, 244, 5, 70, "Notes",
 CellID->477240847],
Cell[4205, 136, 133, 4, 70, "Notes",
 CellID->366530072],
Cell[4341, 142, 167, 5, 70, "Notes",
 CellID->127275562]
}, Closed]],
Cell[CellGroupData[{
Cell[4545, 152, 54, 1, 70, "SeeAlsoSection",
 CellID->480976160],
Cell[4602, 155, 215, 6, 70, "SeeAlso",
 CellID->42291537]
}, Open  ]],
Cell[CellGroupData[{
Cell[4854, 166, 56, 1, 70, "TutorialsSection",
 CellID->33395433],
Cell[4913, 169, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5187, 180, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[5907, 204, 58, 1, 70, "MoreAboutSection",
 CellID->579956749],
Cell[5968, 207, 167, 3, 70, "MoreAbout",
 CellID->96365605]
}, Open  ]],
Cell[6150, 213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

