(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8720,        297]
NotebookOptionsPosition[      6625,        232]
NotebookOutlinePosition[      7765,        262]
CellTagsIndexPosition[      7722,        259]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$RelaxedTypeChecking" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/$RelaxedTypeChecking"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$RelaxedTypeChecking\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaConnectionManagement"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Java Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AllowRaggedArrays", "ObjectName",
 CellID->305509530],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AllowRaggedArrays", "[", 
       ButtonBox["True",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/True"], "]"}]], "InlineFormula"],
     " \[LineSeparator]lets you pass ragged (i.e., non rectangular) arrays to \
Java."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"AllowRaggedArrays", "[", 
       ButtonBox["False",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/False"], "]"}]], "InlineFormula"],
     " \[LineSeparator]restores the default behavior."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->47905168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"AllowRaggedArrays", "[", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "]"}]], "InlineFormula"],
 ", a method that takes ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"int", "[", "]"}], "[", "]"}]], "InlineFormula"],
 " could be passed ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", "3", "}"}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->450817103],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"AllowRaggedArrays", "[", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "]"}]], "InlineFormula"],
 " can drastically reduce the speed with which large arrays are passed back \
and forth between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and Java. "
}], "Notes",
 CellID->285668349]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->147837345],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["$RelaxedTypeChecking",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/$RelaxedTypeChecking"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->220219721]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->39736697],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->122621320],

Cell[TextData[ButtonBox["Java Connection Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaConnectionManagement"]], "MoreAbout",
 CellID->96365605]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AllowRaggedArrays - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "AllowRaggedArrays", "summary" -> 
    "AllowRaggedArrays[True] lets you pass ragged (i.e., non rectangular) \
arrays to Java.  AllowRaggedArrays[False] restores the default behavior.", 
    "uri" -> "JLink/ref/AllowRaggedArrays", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"allow ragged arrays"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 29, 12.4883234}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2103, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2726, 83, 59, 1, 70, "ObjectName",
 CellID->305509530],
Cell[2788, 86, 767, 23, 70, "Usage",
 CellID->47905168]
}, Open  ]],
Cell[CellGroupData[{
Cell[3592, 114, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4051, 130, 518, 20, 70, "Notes",
 CellID->450817103],
Cell[4572, 152, 369, 12, 70, "Notes",
 CellID->285668349]
}, Closed]],
Cell[CellGroupData[{
Cell[4978, 169, 54, 1, 70, "SeeAlsoSection",
 CellID->147837345],
Cell[5035, 172, 230, 6, 70, "SeeAlso",
 CellID->220219721]
}, Open  ]],
Cell[CellGroupData[{
Cell[5302, 183, 56, 1, 70, "TutorialsSection",
 CellID->39736697],
Cell[5361, 186, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5635, 197, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6355, 221, 58, 1, 70, "MoreAboutSection",
 CellID->122621320],
Cell[6416, 224, 167, 3, 70, "MoreAbout",
 CellID->96365605]
}, Open  ]],
Cell[6598, 230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

