(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9022,        301]
NotebookOptionsPosition[      6985,        238]
NotebookOutlinePosition[      8125,        268]
CellTagsIndexPosition[      8082,        265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EndJavaBlock" :> 
          Documentation`HelpLookup["paclet:JLink/ref/EndJavaBlock"], 
          "JavaBlock" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaBlock"], 
          "ReleaseJavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ReleaseJavaObject"], 
          "KeepJavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/KeepJavaObject"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"EndJavaBlock\"\>", 
       2->"\<\"JavaBlock\"\>", 3->"\<\"ReleaseJavaObject\"\>", 
       4->"\<\"KeepJavaObject\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Memory Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaMemoryManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Memory Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BeginJavaBlock", "ObjectName",
 CellID->274840459],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BeginJavaBlock", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]begins an evaluation block equivalent to a ",
     Cell[BoxData[
      ButtonBox["JavaBlock",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
     ", except that it works across a larger span than the evaluation of a \
single expression."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->139118246]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Every ",
 Cell[BoxData["BeginJavaBlock"], "InlineFormula"],
 " must have a paired ",
 Cell[BoxData[
  ButtonBox["EndJavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/EndJavaBlock"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->86146772]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17887150],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EndJavaBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/EndJavaBlock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaBlock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseJavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ReleaseJavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KeepJavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/KeepJavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->303720632]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->576888698],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->47420475],

Cell[TextData[ButtonBox["Java Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaMemoryManagement"]], "MoreAbout",
 CellID->14965421]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BeginJavaBlock - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "BeginJavaBlock", "summary" -> 
    "BeginJavaBlock[] begins an evaluation block equivalent to a JavaBlock, \
except that it works across a larger span than the evaluation of a single \
expression.", "uri" -> "JLink/ref/BeginJavaBlock", "type" -> "Symbol", 
    "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"begin java block"}, "status" -> "None", 
    "built" -> "{2007, 4, 20, 15, 29, 16.7446559}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2462, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3085, 90, 56, 1, 70, "ObjectName",
 CellID->274840459],
Cell[3144, 93, 619, 17, 70, "Usage",
 CellID->139118246]
}, Open  ]],
Cell[CellGroupData[{
Cell[3800, 115, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4259, 131, 272, 10, 70, "Notes",
 CellID->86146772]
}, Closed]],
Cell[CellGroupData[{
Cell[4568, 146, 53, 1, 70, "SeeAlsoSection",
 CellID->17887150],
Cell[4624, 149, 1009, 35, 70, "SeeAlso",
 CellID->303720632]
}, Open  ]],
Cell[CellGroupData[{
Cell[5670, 189, 57, 1, 70, "TutorialsSection",
 CellID->576888698],
Cell[5730, 192, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6004, 203, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6724, 227, 57, 1, 70, "MoreAboutSection",
 CellID->47420475],
Cell[6784, 230, 159, 3, 70, "MoreAbout",
 CellID->14965421]
}, Open  ]],
Cell[6958, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

