(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9251,        308]
NotebookOptionsPosition[      7112,        243]
NotebookOutlinePosition[      8354,        275]
CellTagsIndexPosition[      8311,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Methods" :> 
          Documentation`HelpLookup["paclet:JLink/ref/Methods"], "Fields" :> 
          Documentation`HelpLookup["paclet:JLink/ref/Fields"], "InstanceOf" :> 
          Documentation`HelpLookup["paclet:JLink/ref/InstanceOf"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Methods\"\>", 2->"\<\"Fields\"\>", 
       3->"\<\"InstanceOf\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Constructors", "ObjectName",
 CellID->268767646],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Constructors", "[", 
       StyleBox["javaclass", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns a list of the Java declarations for all \
constructors of the specified ",
     Cell[BoxData[
      ButtonBox["JavaClass",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaClass"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Constructors", "[", "\"\<\!\(\*
StyleBox[\"classname\", \"TI\"]\)\!\(\*
StyleBox[\"\\\"\<\>\", \"TI\"]\)\>", "]"}]], "InlineFormula"],
     " \[LineSeparator]lists the constructor for the named class."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"Constructors", "[", 
        StyleBox["javaobject", "TI"], "]"}], " "}]], "InlineFormula"],
     " \[LineSeparator]lists the constructors for the class of the specified \
",
     Cell[BoxData[
      ButtonBox["JavaObject",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->489578829]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The resulting lists are returned in ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->464818926]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->315770962],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Methods",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Methods"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fields",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Fields"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstanceOf",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/InstanceOf"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->522480834]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->48441375],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->53147523],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constructors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Constructors", "summary" -> 
    "Constructors[javaclass] returns a list of the Java declarations for all \
constructors of the specified JavaClass. Constructors[\"classname\"] lists \
the constructor for the named class.  Constructors[javaobject] lists the \
constructors for the class of the specified JavaObject.", "uri" -> 
    "JLink/ref/Constructors", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 29, 25.6378871}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2259, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2882, 85, 54, 1, 70, "ObjectName",
 CellID->268767646],
Cell[2939, 88, 1298, 38, 70, "Usage",
 CellID->489578829]
}, Open  ]],
Cell[CellGroupData[{
Cell[4274, 131, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4733, 147, 215, 8, 70, "Notes",
 CellID->464818926]
}, Closed]],
Cell[CellGroupData[{
Cell[4985, 160, 54, 1, 70, "SeeAlsoSection",
 CellID->315770962],
Cell[5042, 163, 716, 26, 70, "SeeAlso",
 CellID->522480834]
}, Open  ]],
Cell[CellGroupData[{
Cell[5795, 194, 56, 1, 70, "TutorialsSection",
 CellID->48441375],
Cell[5854, 197, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6128, 208, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6848, 232, 57, 1, 70, "MoreAboutSection",
 CellID->53147523],
Cell[6908, 235, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[7085, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

