(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6527,        230]
NotebookOptionsPosition[      4799,        176]
NotebookOutlinePosition[      5857,        205]
CellTagsIndexPosition[      5814,        202]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"J/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UseFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/UseFrontEnd"], 
          "ConnectToFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ConnectToFrontEnd"], 
          "CloseFrontEnd" :> 
          Documentation`HelpLookup["paclet:JLink/ref/CloseFrontEnd"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"UseFrontEnd\"\>", 
       2->"\<\"ConnectToFrontEnd\"\>", 
       3->"\<\"CloseFrontEnd\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FrontEndLink", "ObjectName",
 CellID->295979372],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FrontEndLink", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the link to the front end that will be used by \
",
     Cell[BoxData[
      RowBox[{
       ButtonBox["UseFrontEnd",
        BaseStyle->"Link",
        ButtonData->"paclet:JLink/ref/UseFrontEnd"], "[", "]"}]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->130720066]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["FrontEndLink"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if no link to the front end has been established."
}], "Notes",
 CellID->577362611]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->138967815],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UseFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConnectToFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ConnectToFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CloseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/CloseFrontEnd"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23790112]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->351757847],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrontEndLink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "FrontEndLink", "summary" -> 
    "FrontEndLink[] returns the link to the front end that will be used by \
UseFrontEnd[].", "uri" -> "JLink/ref/FrontEndLink", "type" -> "Symbol", 
    "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"front end link"}, "status" -> "None", 
    "built" -> "{2007, 4, 20, 15, 29, 36.3237854}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1508, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2131, 68, 54, 1, 70, "ObjectName",
 CellID->295979372],
Cell[2188, 71, 584, 19, 70, "Usage",
 CellID->130720066]
}, Open  ]],
Cell[CellGroupData[{
Cell[2809, 95, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3268, 111, 276, 9, 70, "Notes",
 CellID->577362611]
}, Closed]],
Cell[CellGroupData[{
Cell[3581, 125, 54, 1, 70, "SeeAlsoSection",
 CellID->138967815],
Cell[3638, 128, 751, 26, 70, "SeeAlso",
 CellID->23790112]
}, Open  ]],
Cell[CellGroupData[{
Cell[4426, 159, 57, 1, 70, "TutorialsSection",
 CellID->351757847],
Cell[4486, 162, 271, 9, 70, "Tutorials",
 CellID->281642142]
}, Open  ]],
Cell[4772, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

