(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6594,        233]
NotebookOptionsPosition[      4869,        179]
NotebookOutlinePosition[      5920,        208]
CellTagsIndexPosition[      5877,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"J/Link User Guide\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UseJVM" :> Documentation`HelpLookup["paclet:JLink/ref/UseJVM"],
           "InstallJava" :> 
          Documentation`HelpLookup["paclet:JLink/ref/InstallJava"], "JVM" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JVM"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"UseJVM\"\>", 
       2->"\<\"InstallJava\"\>", 3->"\<\"JVM\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GetJVM", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GetJVM", "[", 
       StyleBox["link", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the ",
     Cell[BoxData[
      ButtonBox["JVM",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JVM"]], "InlineFormula"],
     " expression that corresponds to ",
     Cell[BoxData[
      StyleBox["link", "TI"]], "InlineFormula"],
     ", which was returned from ",
     Cell[BoxData[
      ButtonBox["InstallJava",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "\:f3b5",
 Cell[BoxData["GetJVM"], "InlineFormula"],
 " will only be used by advanced programmers who want to have more than one \
Java runtime installed into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UseJVM",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UseJVM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/InstallJava"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JVM",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JVM"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GetJVM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "GetJVM", "summary" -> 
    "GetJVM[link] returns the JVM expression that corresponds to link, which \
was returned from InstallJava.", "uri" -> "JLink/ref/GetJVM", "type" -> 
    "Symbol", "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> 
    "JLink`", "keywords" -> {}, "synonyms" -> {"get JVM"}, "status" -> "None",
     "built" -> "{2007, 4, 20, 15, 29, 46.6090877}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1414, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2037, 65, 49, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2089, 68, 803, 25, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2929, 98, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3388, 114, 266, 9, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[3691, 128, 55, 1, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[3749, 131, 710, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[4496, 162, 57, 1, 70, "TutorialsSection",
 CellID->250839057],
Cell[4556, 165, 271, 9, 70, "Tutorials",
 CellID->281642142]
}, Open  ]],
Cell[4842, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

