(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10082,        332]
NotebookOptionsPosition[      7945,        264]
NotebookOutlinePosition[      8998,        293]
CellTagsIndexPosition[      8955,        290]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReinstallJava" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ReinstallJava"], 
          "UninstallJava" :> 
          Documentation`HelpLookup["paclet:JLink/ref/UninstallJava"], 
          "JavaLink" :> Documentation`HelpLookup["paclet:JLink/ref/JavaLink"],
           "AddToClassPath" :> 
          Documentation`HelpLookup["paclet:JLink/ref/AddToClassPath"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ReinstallJava\"\>", 
       2->"\<\"UninstallJava\"\>", 3->"\<\"JavaLink\"\>", 
       4->"\<\"AddToClassPath\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Java Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaConnectionManagement"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"External Operations\"\>", 
       2->"\<\"Java Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InstallJava", "ObjectName",
 CellID->189405016],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InstallJava", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]launches the Java runtime and prepares it to be used \
from ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->375378712]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Only one Java runtime is ever launched; subsequent calls to ",
 Cell[BoxData["InstallJava"], "InlineFormula"],
 " after the first have no effect."
}], "Notes",
 CellID->76920335],

Cell["The following options can be given:", "Notes",
 CellID->1625013806],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "ClassPath", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "use the specified directories and .jar files", "TableText"]},
   {Cell["      ", "TableRowIcon"], "CommandLine", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "specify a command line to launch the ",
     Cell[BoxData[
      ButtonBox["JVM",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JVM"]], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->122381246]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->135176994],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReinstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ReinstallJava"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UninstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UninstallJava"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaLink",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddToClassPath",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/AddToClassPath"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->689486982]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->78111769],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->94581969],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->16962270],

Cell[TextData[ButtonBox["Java Connection Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaConnectionManagement"]], "MoreAbout",
 CellID->96365605]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InstallJava - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "InstallJava", "summary" -> 
    "InstallJava[] launches the Java runtime and prepares it to be used from \
Mathematica.", "uri" -> "JLink/ref/InstallJava", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"install java"}, "status" -> "None", 
    "built" -> "{2007, 4, 20, 15, 29, 50.8854500}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2593, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3216, 91, 53, 1, 70, "ObjectName",
 CellID->189405016],
Cell[3272, 94, 459, 15, 70, "Usage",
 CellID->375378712]
}, Open  ]],
Cell[CellGroupData[{
Cell[3768, 114, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4227, 130, 196, 5, 70, "Notes",
 CellID->76920335],
Cell[4426, 137, 73, 1, 70, "Notes",
 CellID->1625013806],
Cell[4502, 140, 838, 22, 70, "3ColumnTableMod",
 CellID->122381246]
}, Closed]],
Cell[CellGroupData[{
Cell[5377, 167, 54, 1, 70, "SeeAlsoSection",
 CellID->135176994],
Cell[5434, 170, 1001, 35, 70, "SeeAlso",
 CellID->689486982]
}, Open  ]],
Cell[CellGroupData[{
Cell[6472, 210, 56, 1, 70, "TutorialsSection",
 CellID->78111769],
Cell[6531, 213, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6805, 224, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[7525, 248, 57, 1, 70, "MoreAboutSection",
 CellID->94581969],
Cell[7585, 251, 148, 3, 70, "MoreAbout",
 CellID->16962270],
Cell[7736, 256, 167, 3, 70, "MoreAbout",
 CellID->96365605]
}, Open  ]],
Cell[7918, 262, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

