(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8172,        281]
NotebookOptionsPosition[      6221,        219]
NotebookOutlinePosition[      7278,        248]
CellTagsIndexPosition[      7235,        245]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InstallJava" :> 
          Documentation`HelpLookup["paclet:JLink/ref/InstallJava"], 
          "UninstallJava" :> 
          Documentation`HelpLookup["paclet:JLink/ref/UninstallJava"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"InstallJava\"\>", 
       2->"\<\"UninstallJava\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaConnectionManagement"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Java Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JavaLink", "ObjectName",
 CellID->207054792],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaLink", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]returns the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " ",
     Cell[BoxData[
      ButtonBox["LinkObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
     " that is used to communicate with the ",
     StyleBox["J/Link",
      FontSlant->"Italic"],
     " Java runtime. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26041941]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["JavaLink"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if Java is not running."
}], "Notes",
 CellID->197183249]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->342831795],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/InstallJava"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UninstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/UninstallJava"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->64869951]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->4501793],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->520276400],

Cell[TextData[ButtonBox["Java Connection Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaConnectionManagement"]], "MoreAbout",
 CellID->96365605]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JavaLink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "JavaLink", "summary" -> 
    "JavaLink[] returns the MathLink LinkObject that is used to communicate \
with the J/Link Java runtime. ", "uri" -> "JLink/ref/JavaLink", "type" -> 
    "Symbol", "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> 
    "JLink`", "keywords" -> {}, "synonyms" -> {"java link"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 30, 2.0520635}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2202, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2825, 85, 50, 1, 70, "ObjectName",
 CellID->207054792],
Cell[2878, 88, 666, 22, 70, "Usage",
 CellID->26041941]
}, Open  ]],
Cell[CellGroupData[{
Cell[3581, 115, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4040, 131, 246, 9, 70, "Notes",
 CellID->197183249]
}, Closed]],
Cell[CellGroupData[{
Cell[4323, 145, 54, 1, 70, "SeeAlsoSection",
 CellID->342831795],
Cell[4380, 148, 482, 17, 70, "SeeAlso",
 CellID->64869951]
}, Open  ]],
Cell[CellGroupData[{
Cell[4899, 170, 55, 1, 70, "TutorialsSection",
 CellID->4501793],
Cell[4957, 173, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5231, 184, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[5951, 208, 58, 1, 70, "MoreAboutSection",
 CellID->520276400],
Cell[6012, 211, 167, 3, 70, "MoreAbout",
 CellID->96365605]
}, Open  ]],
Cell[6194, 217, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

