(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9164,        305]
NotebookOptionsPosition[      7053,        240]
NotebookOutlinePosition[      8208,        270]
CellTagsIndexPosition[      8165,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReturnAsJavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ReturnAsJavaObject"], 
          "JavaNew" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaNew"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ReturnAsJavaObject\"\>", 
       2->"\<\"JavaNew\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JavaObjectToExpression", "ObjectName",
 CellID->135682756],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaObjectToExpression", "[", 
       StyleBox["javaobject", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts the specified Java object reference into its \
value as a \"native\" ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29193099]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Normally, all Java objects that have a meaningful \"by value\" \
representation in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "  are returned by value to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically. Such objects include strings, arrays (these become lists), \
and instances of so-called wrapper classes like ",
 StyleBox["java.lang.Integer", "InlineCode"],
 ". However, you can get a reference form of one of these types if you \
explicitly call ",
 Cell[BoxData[
  ButtonBox["JavaNew",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaNew"]], "InlineFormula"],
 " or use the ",
 Cell[BoxData[
  ButtonBox["ReturnAsJavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"]], "InlineFormula"],
 " function. In such cases, you can use ",
 Cell[BoxData["JavaObjectToExpression"], "InlineFormula"],
 " to retrieve the value. "
}], "Notes",
 CellID->222591795],

Cell[TextData[{
 Cell[BoxData["JavaObjectToExpression"], "InlineFormula"],
 " has no effect on objects that have no meaningful \"value\" representation \
in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->268343431]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->663788108],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnAsJavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ReturnAsJavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaNew",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaNew"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->565648878]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->522010348],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->518916671],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JavaObjectToExpression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "JavaObjectToExpression", "summary" -> 
    "JavaObjectToExpression[javaobject] converts the specified Java object \
reference into its value as a \"native\" Mathematica expression. ", "uri" -> 
    "JLink/ref/JavaObjectToExpression", "type" -> "Symbol", "label" -> 
    "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"java object to expression"}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 30, 10.4645795}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2197, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2820, 85, 64, 1, 70, "ObjectName",
 CellID->135682756],
Cell[2887, 88, 537, 16, 70, "Usage",
 CellID->29193099]
}, Open  ]],
Cell[CellGroupData[{
Cell[3461, 109, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3920, 125, 949, 26, 70, "Notes",
 CellID->222591795],
Cell[4872, 153, 246, 8, 70, "Notes",
 CellID->268343431]
}, Closed]],
Cell[CellGroupData[{
Cell[5155, 166, 54, 1, 70, "SeeAlsoSection",
 CellID->663788108],
Cell[5212, 169, 485, 17, 70, "SeeAlso",
 CellID->565648878]
}, Open  ]],
Cell[CellGroupData[{
Cell[5734, 191, 57, 1, 70, "TutorialsSection",
 CellID->522010348],
Cell[5794, 194, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6068, 205, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6788, 229, 58, 1, 70, "MoreAboutSection",
 CellID->518916671],
Cell[6849, 232, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[7026, 238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

