(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9152,        304]
NotebookOptionsPosition[      6983,        235]
NotebookOutlinePosition[      8077,        265]
CellTagsIndexPosition[      8034,        262]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DoModal" :> 
          Documentation`HelpLookup["paclet:JLink/ref/DoModal"], 
          "ShowJavaConsole" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ShowJavaConsole"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DoModal\"\>", 
       2->"\<\"ShowJavaConsole\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "Java User Interfaces" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaUserInterfaces"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"Java User Interfaces\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JavaShow", "ObjectName",
 CellID->879115387],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaShow", "[", 
       StyleBox["window", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]causes the specified Java window to be brought to the \
foreground, so that it appears in front of notebook windows. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->97585887]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["window", "TI"]], "InlineFormula"],
 " must be an object of a class that can represent a top-level window (i.e., \
an instance of the ",
 StyleBox["java.awt.Window", "InlineCode"],
 " class or a subclass)."
}], "Notes",
 CellID->369130259],

Cell[TextData[{
 "Use this function in place of standard Java window methods like ",
 StyleBox["setVisible", "InlineCode"],
 " (or its deprecated equivalent, ",
 StyleBox["show", "InlineCode"],
 ") and ",
 StyleBox["toFront", "InlineCode"],
 ". The effects those methods have are unfortunately not identical on \
different Java virtual machines and operating systems."
}], "Notes",
 CellID->230157405],

Cell[TextData[{
 Cell[BoxData["JavaShow"], "InlineFormula"],
 " performs the required steps in VM-specific ways, so programs that use it \
will work identically on different configurations."
}], "Notes",
 CellID->786314696]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->31480474],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DoModal",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/DoModal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowJavaConsole",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ShowJavaConsole"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->161650694]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->478772080],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->160982364],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->406864826],

Cell[TextData[ButtonBox["Java User Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaUserInterfaces"]], "MoreAbout",
 CellID->82071812]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JavaShow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "JavaShow", "summary" -> 
    "JavaShow[window] causes the specified Java window to be brought to the \
foreground, so that it appears in front of notebook windows. ", "uri" -> 
    "JLink/ref/JavaShow", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"java show"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 30, 12.6478277}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2337, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2960, 87, 50, 1, 70, "ObjectName",
 CellID->879115387],
Cell[3013, 90, 479, 13, 70, "Usage",
 CellID->97585887]
}, Open  ]],
Cell[CellGroupData[{
Cell[3529, 108, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3988, 124, 281, 8, 70, "Notes",
 CellID->369130259],
Cell[4272, 134, 401, 10, 70, "Notes",
 CellID->230157405],
Cell[4676, 146, 223, 5, 70, "Notes",
 CellID->786314696]
}, Closed]],
Cell[CellGroupData[{
Cell[4936, 156, 53, 1, 70, "SeeAlsoSection",
 CellID->31480474],
Cell[4992, 159, 479, 17, 70, "SeeAlso",
 CellID->161650694]
}, Open  ]],
Cell[CellGroupData[{
Cell[5508, 181, 57, 1, 70, "TutorialsSection",
 CellID->478772080],
Cell[5568, 184, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5842, 195, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6562, 219, 58, 1, 70, "MoreAboutSection",
 CellID->160982364],
Cell[6623, 222, 160, 3, 70, "MoreAbout",
 CellID->406864826],
Cell[6786, 227, 155, 3, 70, "MoreAbout",
 CellID->82071812]
}, Open  ]],
Cell[6956, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

