(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9172,        301]
NotebookOptionsPosition[      6902,        233]
NotebookOutlinePosition[      8215,        266]
CellTagsIndexPosition[      8172,        263]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$JavaExceptionHandler" :> 
          Documentation`HelpLookup["paclet:JLink/ref/$JavaExceptionHandler"], 
          "GetJavaException" :> 
          Documentation`HelpLookup["paclet:JLink/ref/GetJavaException"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"$JavaExceptionHandler\"\>", 
       2->"\<\"GetJavaException\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Exception Handling" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaExceptionHandling"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Exception Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JavaThrow", "ObjectName",
 CellID->245632748],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaThrow", "[", "\"\<\!\(\*
StyleBox[\"exception\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]causes an exception of the specified class to be \
thrown in the Java thread that called the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " program in which ",
     Cell[BoxData["JavaThrow"], "InlineFormula"],
     " occurred."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaThrow", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"exception\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"message\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]specifies an optional detail message for the \
exception."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"JavaThrow", "[", 
       StyleBox["object", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]causes the specified Java ",
     StyleBox["Exception", "InlineCode"],
     " object to be thrown."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27002307]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["JavaThrow"], "InlineFormula"],
 " is a specialized function that few programmers will have any use for."
}], "Notes",
 CellID->206473039],

Cell["\<\
It is up to the user to ensure that the exception being created has an \
appropriate constructor.\
\>", "Notes",
 CellID->74951713]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->244052588],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$JavaExceptionHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/$JavaExceptionHandler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GetJavaException",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/GetJavaException"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->660154099]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->1009364324],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->122339586],

Cell[TextData[ButtonBox["Java Exception Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaExceptionHandling"]], "MoreAbout",
 CellID->449049073]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JavaThrow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "JavaThrow", "summary" -> 
    "JavaThrow[\"  exception\"] causes an exception of the specified class to \
be thrown in the Java thread that called the Mathematica program in which \
JavaThrow occurred.  JavaThrow[\"  exception\", \"  message\"] specifies an \
optional detail message for the exception.  JavaThrow[object] causes the \
specified Java Exception object to be thrown.", "uri" -> 
    "JLink/ref/JavaThrow", "type" -> "Symbol", "label" -> "J Link Symbol", 
    "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"java throw"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 30, 14.9512547}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2232, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2855, 85, 51, 1, 70, "ObjectName",
 CellID->245632748],
Cell[2909, 88, 1225, 35, 70, "Usage",
 CellID->27002307]
}, Open  ]],
Cell[CellGroupData[{
Cell[4171, 128, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4630, 144, 168, 4, 70, "Notes",
 CellID->206473039],
Cell[4801, 150, 141, 4, 70, "Notes",
 CellID->74951713]
}, Closed]],
Cell[CellGroupData[{
Cell[4979, 159, 54, 1, 70, "SeeAlsoSection",
 CellID->244052588],
Cell[5036, 162, 509, 17, 70, "SeeAlso",
 CellID->660154099]
}, Open  ]],
Cell[CellGroupData[{
Cell[5582, 184, 58, 1, 70, "TutorialsSection",
 CellID->1009364324],
Cell[5643, 187, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5917, 198, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6637, 222, 58, 1, 70, "MoreAboutSection",
 CellID->122339586],
Cell[6698, 225, 162, 3, 70, "MoreAbout",
 CellID->449049073]
}, Open  ]],
Cell[6875, 231, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

