(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9945,        328]
NotebookOptionsPosition[      7638,        259]
NotebookOutlinePosition[      8932,        291]
CellTagsIndexPosition[      8889,        288]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ReleaseJavaObject" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ReleaseJavaObject"], 
          "JavaBlock" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaBlock"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ReleaseJavaObject\"\>", 
       2->"\<\"JavaBlock\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Memory Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaMemoryManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Java Memory Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KeepJavaObject", "ObjectName",
 CellID->668498572],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KeepJavaObject", "[", 
       StyleBox["object", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]causes the specified object or objects not to be \
released when the current ",
     Cell[BoxData[
      ButtonBox["JavaBlock",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
     " ends."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"KeepJavaObject", "[", 
       RowBox[{
        StyleBox["object", "TI"], ",", 
        ButtonBox["Manual",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Manual"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]causes the specified object to escape from all \
enclosing ",
     Cell[BoxData[
      ButtonBox["JavaBlock",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
     " blocks, meaning that the object will only be released if you manually \
call ",
     Cell[BoxData[
      ButtonBox["ReleaseJavaObject",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/ReleaseJavaObject"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->386680391]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["KeepJavaObject"], "InlineFormula"],
 " allows an object to \"escape\" from the current ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->355842167],

Cell[TextData[{
 Cell[BoxData["KeepJavaObject"], "InlineFormula"],
 " only has an effect if the object was in fact slated to be released by the \
current block."
}], "Notes",
 CellID->266603514],

Cell[TextData[{
 Cell[BoxData["KeepJavaObject"], "InlineFormula"],
 " causes the object to be promoted to the \"release\" list of the \
next-enclosing ",
 Cell[BoxData[
  ButtonBox["JavaBlock",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaBlock"]], "InlineFormula"],
 ", if there is one, so it will be released when that block ends (unless you \
call ",
 Cell[BoxData["KeepJavaObject"], "InlineFormula"],
 " again in the outer block)."
}], "Notes",
 CellID->65073969]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->252213884],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseJavaObject",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ReleaseJavaObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaBlock",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaBlock"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->202817256]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->6336230],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->113468739],

Cell[TextData[ButtonBox["Java Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaMemoryManagement"]], "MoreAbout",
 CellID->14965421]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KeepJavaObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "KeepJavaObject", "summary" -> 
    "KeepJavaObject[object] causes the specified object or objects not to be \
released when the current JavaBlock ends.  KeepJavaObject[object, Manual] \
causes the specified object to escape from all enclosing JavaBlock blocks, \
meaning that the object will only be released if you manually call \
ReleaseJavaObject.", "uri" -> "JLink/ref/KeepJavaObject", "type" -> "Symbol", 
    "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"keep java object"}, "status" -> "None", 
    "built" -> "{2007, 4, 20, 15, 30, 21.3708056}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2195, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2818, 85, 56, 1, 70, "ObjectName",
 CellID->668498572],
Cell[2877, 88, 1367, 40, 70, "Usage",
 CellID->386680391]
}, Open  ]],
Cell[CellGroupData[{
Cell[4281, 133, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4740, 149, 285, 9, 70, "Notes",
 CellID->355842167],
Cell[5028, 160, 194, 5, 70, "Notes",
 CellID->266603514],
Cell[5225, 167, 481, 13, 70, "Notes",
 CellID->65073969]
}, Closed]],
Cell[CellGroupData[{
Cell[5743, 185, 54, 1, 70, "SeeAlsoSection",
 CellID->252213884],
Cell[5800, 188, 487, 17, 70, "SeeAlso",
 CellID->202817256]
}, Open  ]],
Cell[CellGroupData[{
Cell[6324, 210, 55, 1, 70, "TutorialsSection",
 CellID->6336230],
Cell[6382, 213, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6656, 224, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[7376, 248, 58, 1, 70, "MoreAboutSection",
 CellID->113468739],
Cell[7437, 251, 159, 3, 70, "MoreAbout",
 CellID->14965421]
}, Open  ]],
Cell[7611, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

