(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10572,        347]
NotebookOptionsPosition[      8264,        274]
NotebookOutlinePosition[      9372,        304]
CellTagsIndexPosition[      9329,        301]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JavaNew" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaNew"], "InstallJava" :> 
          Documentation`HelpLookup["paclet:JLink/ref/InstallJava"], 
          "JavaClass" :> 
          Documentation`HelpLookup["paclet:JLink/ref/JavaClass"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JavaNew\"\>", 
       2->"\<\"InstallJava\"\>", 3->"\<\"JavaClass\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "Java Interface" :> 
          Documentation`HelpLookup["paclet:JLink/guide/JavaInterface"], 
          "Java Classes and Objects" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaClassesAndObjects"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"Java Interface\"\>", 
       3->"\<\"Java Classes and Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LoadJavaClass", "ObjectName",
 CellID->744478894],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"LoadJavaClass", "[", 
       StyleBox["classname", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]loads the specified class into Java and sets up \
definitions so that it can be used from ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->274942774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You must specify the fully qualified class name, for example ",
 StyleBox["\"java.awt.Frame\"", "InlineCode"],
 ". "
}], "Notes",
 CellID->564281262],

Cell[TextData[{
 "It is safe to call ",
 Cell[BoxData["LoadJavaClass"], "InlineFormula"],
 " multiple times on the same class; it simply returns right away without \
doing anything."
}], "Notes",
 CellID->61210602],

Cell["The following options can be given:", "Notes",
 CellID->560743505],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "StaticsVisible", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether static methods/fields are accessible by name or in a special context\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "AllowShortContext", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether static methods/fields can be accessed by name or by full context\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "UseTypeChecking", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to suppress the type checking normally inserted in definitions for \
calls to Java\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->48407827]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->63749765],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaNew",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaNew"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/InstallJava"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JavaClass",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/JavaClass"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1091546]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->43037084],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->276494879],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->85279003],

Cell[TextData[ButtonBox["Java Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaInterface"]], "MoreAbout",
 CellID->302967447],

Cell[TextData[ButtonBox["Java Classes and Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaClassesAndObjects"]], "MoreAbout",
 CellID->82588414]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LoadJavaClass - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "LoadJavaClass", "summary" -> 
    "LoadJavaClass[classname] loads the specified class into Java and sets up \
definitions so that it can be used from Mathematica.", "uri" -> 
    "JLink/ref/LoadJavaClass", "type" -> "Symbol", "label" -> "J Link Symbol",
     "paclet" -> "JLink", "context" -> "JLink`", "keywords" -> {}, 
    "synonyms" -> {"load java class"}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 30, 27.9205502}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2590, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3213, 92, 55, 1, 70, "ObjectName",
 CellID->744478894],
Cell[3271, 95, 528, 16, 70, "Usage",
 CellID->274942774]
}, Open  ]],
Cell[CellGroupData[{
Cell[3836, 116, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4295, 132, 167, 5, 70, "Notes",
 CellID->564281262],
Cell[4465, 139, 214, 6, 70, "Notes",
 CellID->61210602],
Cell[4682, 147, 72, 1, 70, "Notes",
 CellID->560743505],
Cell[4757, 150, 1027, 26, 70, "3ColumnTableMod",
 CellID->48407827]
}, Closed]],
Cell[CellGroupData[{
Cell[5821, 181, 53, 1, 70, "SeeAlsoSection",
 CellID->63749765],
Cell[5877, 184, 722, 26, 70, "SeeAlso",
 CellID->1091546]
}, Open  ]],
Cell[CellGroupData[{
Cell[6636, 215, 56, 1, 70, "TutorialsSection",
 CellID->43037084],
Cell[6695, 218, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[6969, 229, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[7689, 253, 58, 1, 70, "MoreAboutSection",
 CellID->276494879],
Cell[7750, 256, 159, 3, 70, "MoreAbout",
 CellID->85279003],
Cell[7912, 261, 145, 3, 70, "MoreAbout",
 CellID->302967447],
Cell[8060, 266, 162, 3, 70, "MoreAbout",
 CellID->82588414]
}, Open  ]],
Cell[8237, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

