(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8349,        285]
NotebookOptionsPosition[      6502,        227]
NotebookOutlinePosition[      7558,        256]
CellTagsIndexPosition[      7515,        253]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Periodicals" :> 
          Documentation`HelpLookup["paclet:JLink/ref/Periodicals"], 
          "AddPeriodical" :> 
          Documentation`HelpLookup["paclet:JLink/ref/AddPeriodical"], 
          "RemovePeriodical" :> 
          Documentation`HelpLookup["paclet:JLink/ref/RemovePeriodical"], 
          "SetPeriodicalInterval" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/SetPeriodicalInterval"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Periodicals\"\>", 2->"\<\"AddPeriodical\"\>", 
       3->"\<\"RemovePeriodical\"\>", 
       4->"\<\"SetPeriodicalInterval\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Periodical", "ObjectName",
 CellID->498633584],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Periodical", "[", 
       StyleBox["id", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator] returns information about the periodical task \
corresponding to the specified integer ",
     Cell[BoxData[
      StyleBox["id", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3547700]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Periodical"], "InlineFormula"],
 " returns a list with the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["id", "TI"], ",", " ", 
    StyleBox["code", "TI"], ",", " ", 
    StyleBox["seconds", "TI"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->204547870],

Cell[TextData[{
 "The ID number must be one returned by ",
 Cell[BoxData[
  ButtonBox["AddPeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddPeriodical"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Periodicals",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/Periodicals"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20798645]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->61407139],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Periodicals",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Periodicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddPeriodical",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/AddPeriodical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RemovePeriodical",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/RemovePeriodical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPeriodicalInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/SetPeriodicalInterval"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->721064275]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->11378588],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Periodical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Periodical", "summary" -> 
    "Periodical[id] returns information about the periodical task \
corresponding to the specified integer id. ", "uri" -> "JLink/ref/Periodical",
     "type" -> "Symbol", "label" -> "J Link Symbol", "paclet" -> "JLink", 
    "context" -> "JLink`", "keywords" -> {}, "synonyms" -> {}, "status" -> 
    "None", "built" -> "{2007, 4, 20, 15, 30, 38.9569700}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1903, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2526, 75, 52, 1, 70, "ObjectName",
 CellID->498633584],
Cell[2581, 78, 524, 16, 70, "Usage",
 CellID->3547700]
}, Open  ]],
Cell[CellGroupData[{
Cell[3142, 99, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3601, 115, 313, 11, 70, "Notes",
 CellID->204547870],
Cell[3917, 128, 370, 13, 70, "Notes",
 CellID->20798645]
}, Closed]],
Cell[CellGroupData[{
Cell[4324, 146, 53, 1, 70, "SeeAlsoSection",
 CellID->61407139],
Cell[4380, 149, 1027, 35, 70, "SeeAlso",
 CellID->721064275]
}, Open  ]],
Cell[CellGroupData[{
Cell[5444, 189, 56, 1, 70, "TutorialsSection",
 CellID->11378588],
Cell[5503, 192, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5777, 203, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[6475, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

