(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8095,        272]
NotebookOptionsPosition[      6217,        215]
NotebookOutlinePosition[      7358,        245]
CellTagsIndexPosition[      7315,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Periodical" :> 
          Documentation`HelpLookup["paclet:JLink/ref/Periodical"], 
          "Periodicals" :> 
          Documentation`HelpLookup["paclet:JLink/ref/Periodicals"], 
          "AddPeriodical" :> 
          Documentation`HelpLookup["paclet:JLink/ref/AddPeriodical"], 
          "SetPeriodicalInterval" :> 
          Documentation`HelpLookup[
           "paclet:JLink/ref/SetPeriodicalInterval"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Periodical\"\>", 2->"\<\"Periodicals\"\>", 
       3->"\<\"AddPeriodical\"\>", 
       4->"\<\"SetPeriodicalInterval\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RemovePeriodical", "ObjectName",
 CellID->191049928],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RemovePeriodical", "[", 
       StyleBox["id", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]removes the computation corresponding to the integer ",
     
     Cell[BoxData[
      StyleBox["id", "TI"]], "InlineFormula"],
     " from the set of operations that are periodically performed \
automatically."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->501260601]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ID number must be one returned by ",
 Cell[BoxData[
  ButtonBox["AddPeriodical",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/AddPeriodical"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Periodicals",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/Periodicals"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->417186556]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->535122642],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Periodical",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Periodical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Periodicals",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/Periodicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddPeriodical",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/AddPeriodical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPeriodicalInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/SetPeriodicalInterval"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->259417694]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->19084659],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RemovePeriodical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "RemovePeriodical", "summary" -> 
    "RemovePeriodical[id] removes the computation corresponding to the \
integer id from the set of operations that are periodically performed \
automatically.", "uri" -> "JLink/ref/RemovePeriodical", "type" -> "Symbol", 
    "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"remove periodical"}, "status" -> "None",
     "built" -> "{2007, 4, 20, 15, 30, 48.2608121}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1885, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2508, 75, 58, 1, 70, "ObjectName",
 CellID->191049928],
Cell[2569, 78, 577, 17, 70, "Usage",
 CellID->501260601]
}, Open  ]],
Cell[CellGroupData[{
Cell[3183, 100, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3642, 116, 371, 13, 70, "Notes",
 CellID->417186556]
}, Closed]],
Cell[CellGroupData[{
Cell[4050, 134, 54, 1, 70, "SeeAlsoSection",
 CellID->535122642],
Cell[4107, 137, 1015, 35, 70, "SeeAlso",
 CellID->259417694]
}, Open  ]],
Cell[CellGroupData[{
Cell[5159, 177, 56, 1, 70, "TutorialsSection",
 CellID->19084659],
Cell[5218, 180, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5492, 191, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[6190, 213, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

