(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8441,        286]
NotebookOptionsPosition[      6336,        220]
NotebookOutlinePosition[      7429,        249]
CellTagsIndexPosition[      7386,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MachineDomains" :> 
          Documentation`HelpLookup["paclet:ref/$MachineDomains"], 
          "$MachineAddresses" :> 
          Documentation`HelpLookup["paclet:ref/$MachineAddresses"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MachineDomains\"\>", 
       2->"\<\"$MachineAddresses\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaConnectionManagement"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Java Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetInternetProxy", "ObjectName",
 CellID->559695350],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetInternetProxy", "[", 
       RowBox[{
        StyleBox["host", "TI"], ",", 
        StyleBox["port", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets proxy information in your Java session for \
accessing the internet. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->378182404]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
If you use a proxy for accessing the internet, you may need to call this \
function to enable Java code to use the internet. \
\>", "Notes",
 CellID->174275791],

Cell["Consult your network administrator for proxy settings. ", "Notes",
 CellID->275922022],

Cell[TextData[{
 "A typical example would look like ",
 Cell[BoxData[
  RowBox[{"SetInternetProxy", "[", 
   RowBox[{"\"\<proxy.mycompany.com\>\"", ",", " ", "8080"}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->107016118]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->18115571],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineDomains",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineDomains"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineAddresses",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineAddresses"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->469771275]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->182885610],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->128480666],

Cell[TextData[ButtonBox["Java Connection Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaConnectionManagement"]], "MoreAbout",
 CellID->96365605]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetInternetProxy - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "SetInternetProxy", "summary" -> 
    "SetInternetProxy[host, port] sets proxy information in your Java session \
for accessing the internet. ", "uri" -> "JLink/ref/SetInternetProxy", "type" -> 
    "Symbol", "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> 
    "JLink`", "keywords" -> {}, "synonyms" -> {"set internet proxy"}, 
    "status" -> "None", "built" -> "{2007, 4, 20, 15, 30, 59.2171127}", 
    "index" -> True}, "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2213, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2836, 85, 58, 1, 70, "ObjectName",
 CellID->559695350],
Cell[2897, 88, 500, 15, 70, "Usage",
 CellID->378182404]
}, Open  ]],
Cell[CellGroupData[{
Cell[3434, 108, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3893, 124, 170, 4, 70, "Notes",
 CellID->174275791],
Cell[4066, 130, 92, 1, 70, "Notes",
 CellID->275922022],
Cell[4161, 133, 234, 8, 70, "Notes",
 CellID->107016118]
}, Closed]],
Cell[CellGroupData[{
Cell[4432, 146, 53, 1, 70, "SeeAlsoSection",
 CellID->18115571],
Cell[4488, 149, 487, 17, 70, "SeeAlso",
 CellID->469771275]
}, Open  ]],
Cell[CellGroupData[{
Cell[5012, 171, 57, 1, 70, "TutorialsSection",
 CellID->182885610],
Cell[5072, 174, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5346, 185, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6066, 209, 58, 1, 70, "MoreAboutSection",
 CellID->128480666],
Cell[6127, 212, 167, 3, 70, "MoreAbout",
 CellID->96365605]
}, Open  ]],
Cell[6309, 218, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

