(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8563,        288]
NotebookOptionsPosition[      6559,        224]
NotebookOutlinePosition[      7612,        253]
CellTagsIndexPosition[      7569,        250]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Symbol"
    }], "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"J/Link User Guide" :> 
          Documentation`HelpLookup["paclet:JLink/tutorial/Overview"], 
          "Calling Java from Mathematica in J/Link User Guide" :> 
          Documentation`HelpLookup[
           "paclet:JLink/tutorial/CallingJavaFromMathematica"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"J/Link User Guide\"\>", 
       2->"\<\"Calling Java from Mathematica in J/Link User Guide\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InstallJava" :> 
          Documentation`HelpLookup["paclet:JLink/ref/InstallJava"], 
          "ReinstallJava" :> 
          Documentation`HelpLookup["paclet:JLink/ref/ReinstallJava"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"InstallJava\"\>", 
       2->"\<\"ReinstallJava\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Java Connection Management" :> 
          Documentation`HelpLookup[
           "paclet:JLink/guide/JavaConnectionManagement"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Java Connection Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UninstallJava", "ObjectName",
 CellID->80780918],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"UninstallJava", "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]shuts down the Java runtime that was started by ",
     Cell[BoxData[
      ButtonBox["InstallJava",
       BaseStyle->"Link",
       ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->150444853]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["UninstallJava"], "InlineFormula"],
 " is provided mainly for developers who are actively recompiling Java \
classes for use in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and therefore need to shut down and restart the Java runtime to reload the \
modified classes. "
}], "Notes",
 CellID->22157622],

Cell[TextData[{
 "Users generally have no reason to call ",
 Cell[BoxData["UninstallJava"], "InlineFormula"],
 ". The Java runtime is a shared resource used by potentially many ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs. You should leave it running unless you are absolutely sure you \
need to shut it down."
}], "Notes",
 CellID->36781863]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->42782092],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/InstallJava"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReinstallJava",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/ReinstallJava"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->266624868]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30394587],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"]
}], "Tutorials",
 CellID->281642142],

Cell[TextData[{
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ButtonBox[" User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"]
}], "Tutorials",
 CellID->1676109154]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->436284763],

Cell[TextData[ButtonBox["Java Connection Management",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaConnectionManagement"]], "MoreAbout",
 CellID->96365605]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UninstallJava - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "UninstallJava", "summary" -> 
    "UninstallJava[] shuts down the Java runtime that was started by \
InstallJava. ", "uri" -> "JLink/ref/UninstallJava", "type" -> "Symbol", 
    "label" -> "J Link Symbol", "paclet" -> "JLink", "context" -> "JLink`", 
    "keywords" -> {}, "synonyms" -> {"uninstall java"}, "status" -> "None", 
    "built" -> "{2007, 4, 20, 15, 31, 5.9972000}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2202, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2825, 85, 54, 1, 70, "ObjectName",
 CellID->80780918],
Cell[2882, 88, 540, 16, 70, "Usage",
 CellID->150444853]
}, Open  ]],
Cell[CellGroupData[{
Cell[3459, 109, 456, 14, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3918, 125, 341, 9, 70, "Notes",
 CellID->22157622],
Cell[4262, 136, 361, 9, 70, "Notes",
 CellID->36781863]
}, Closed]],
Cell[CellGroupData[{
Cell[4660, 150, 53, 1, 70, "SeeAlsoSection",
 CellID->42782092],
Cell[4716, 153, 483, 17, 70, "SeeAlso",
 CellID->266624868]
}, Open  ]],
Cell[CellGroupData[{
Cell[5236, 175, 56, 1, 70, "TutorialsSection",
 CellID->30394587],
Cell[5295, 178, 271, 9, 70, "Tutorials",
 CellID->281642142],
Cell[5569, 189, 683, 19, 70, "Tutorials",
 CellID->1676109154]
}, Open  ]],
Cell[CellGroupData[{
Cell[6289, 213, 58, 1, 70, "MoreAboutSection",
 CellID->436284763],
Cell[6350, 216, 167, 3, 70, "MoreAbout",
 CellID->96365605]
}, Open  ]],
Cell[6532, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

