(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57258,       1996]
NotebookOptionsPosition[     43266,       1556]
NotebookOutlinePosition[     44334,       1585]
CellTagsIndexPosition[     44291,       1582]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Tutorial"
    }], "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[TextData[{
 StyleBox["J/Link ",
  FontSlant->"Italic"],
 "User Guide"
}], "TOCDocumentTitle"],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Introduction to ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Introduction"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Introduction"],
  FontSlant->"Italic"]
}], "TOCChapter",
 CellID->66849275],

Cell[TextData[{
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Introduction#25629"],
  FontSlant->"Italic"],
 ButtonBox[" and ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Introduction#25629"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Introduction#25629"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Introduction#25629"]
}], "TOCSubsection",
 CellID->185971111]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Calling Java From ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"]
}], "TOCChapter",
 CellID->263069685],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Basics"
}], "TOCSection",
 CellID->1687036525],

Cell[TextData[ButtonBox["Preamble",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#23811"]], "TOCSubsection",\

 CellID->232511722],

Cell[TextData[{
 ButtonBox["Loading the ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#19690"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#19690"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#19690"]
}], "TOCSubsection",
 CellID->147136816],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Launching the Java Runtime",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#21634"]], "TOCSubsection",\

 CellID->1118479],

Cell[TextData[ButtonBox["InstallJava",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#10893"]], \
"TOCSubsubsection",
 CellID->151891135],

Cell[TextData[ButtonBox["Controlling the Command Used to Launch Java",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#14256"]], \
"TOCSubsubsection",
 CellID->798800886],

Cell[TextData[ButtonBox["Overriding the Class Path",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#27109"]], \
"TOCSubsubsection",
 CellID->77897190]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Loading Classes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#24948"]], "TOCSubsection",\

 CellID->26322733],

Cell[TextData[ButtonBox["LoadJavaClass",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#1282"]], \
"TOCSubsubsection",
 CellID->174940147],

Cell[TextData[ButtonBox["When to Call LoadJavaClass",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#22619"]], \
"TOCSubsubsection",
 CellID->796012776],

Cell[TextData[ButtonBox["Contexts and Visibility of Static Members",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#12722"]], \
"TOCSubsubsection",
 CellID->19162505],

Cell[TextData[ButtonBox["Inner Classes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#3959"]], \
"TOCSubsubsection",
 CellID->809916710]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Conversion of Types Between Java and ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17780"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17780"],
  FontSlant->"Italic"]
}], "TOCSubsection",
 CellID->553266198],

Cell[TextData[ButtonBox["Creating Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#900"]], "TOCSubsection",
 CellID->849582867],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Calling Methods and Accessing Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#15615"]], "TOCSubsection",\

 CellID->232630658],

Cell[TextData[ButtonBox["Syntax",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#20528"]], \
"TOCSubsubsection",
 CellID->361217163],

Cell[TextData[ButtonBox["Underscores in Java Names",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#10004"]], \
"TOCSubsubsection",
 CellID->123624998]
}, Open  ]],

Cell[TextData[ButtonBox["Getting Information About Classes and Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#8526"]], "TOCSubsection",
 CellID->88703548],

Cell[TextData[ButtonBox["Quitting or Restarting Java",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#23439"]], "TOCSubsection",\

 CellID->352201552],

Cell[TextData[ButtonBox["Version Information",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#31163"]], "TOCSubsection",\

 CellID->796284334]
}, Open  ]],

Cell[CellGroupData[{

Cell["Advanced Topics in J/Link", "TOCSection",
 CellID->32713434],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Controlling the Class Path: How ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#19629"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#19629"],
  FontSlant->"Italic"],
 ButtonBox[" Finds Classes",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#19629"]
}], "TOCSubsection",
 CellID->21292546],

Cell[TextData[ButtonBox["The Java Class Path",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#12623"]], \
"TOCSubsubsection",
 CellID->790208577],

Cell[TextData[ButtonBox["Overriding the Startup Class Path",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#11840"]], \
"TOCSubsubsection",
 CellID->356363007],

Cell[TextData[ButtonBox["Dynamically Modifying the Class Path",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#11323"]], \
"TOCSubsubsection",
 CellID->753693084],

Cell[TextData[ButtonBox["Examining the Class Path",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#29658"]], \
"TOCSubsubsection",
 CellID->451859136],

Cell[TextData[{
 ButtonBox["Using ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2306"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2306"],
  FontSlant->"Italic"],
 ButtonBox["\[CloseCurlyQuote]s Class Loader Directly",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2306"]
}], "TOCSubsubsection",
 CellID->81960272]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Performance Issues",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#28396"]], "TOCSubsection",\

 CellID->298406779],

Cell[TextData[ButtonBox["Overhead of Calls to Java",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#7572"]], \
"TOCSubsubsection",
 CellID->237029824],

Cell[TextData[ButtonBox["Speeding up Sending Large Arrays",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#16074"]], \
"TOCSubsubsection",
 CellID->545120415],

Cell[TextData[ButtonBox["An Optimization Example",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#17968"]], \
"TOCSubsubsection",
 CellID->322807609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Reference Counts and Memory Management",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#12158"]], "TOCSubsection",\

 CellID->718862413],

Cell[TextData[{
 ButtonBox["Object References in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12022"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12022"],
  FontSlant->"Italic"]
}], "TOCSubsubsection",
 CellID->163918297],

Cell[TextData[ButtonBox["ReleaseJavaObject",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#22336"]], \
"TOCSubsubsection",
 CellID->466936461],

Cell[TextData[ButtonBox["JavaBlock",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#25162"]], \
"TOCSubsubsection",
 CellID->181446597],

Cell[TextData[ButtonBox["JavaGC",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#27663"]], \
"TOCSubsubsection",
 CellID->113344518],

Cell[TextData[ButtonBox["PeekObjects and PeekClasses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#24515"]], \
"TOCSubsubsection",
 CellID->469765809]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Exceptions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#10195"]], "TOCSubsection",\

 CellID->436480035],

Cell[TextData[ButtonBox["How Exceptions are Handled",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#32525"]], \
"TOCSubsubsection",
 CellID->246930166],

Cell[TextData[ButtonBox["The JavaThrow Function",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#29011"]], \
"TOCSubsubsection",
 CellID->42846754]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Returning Objects ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#31497"],
 StyleBox[ButtonBox["\[OpenCurlyDoubleQuote]",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#31497"],
  FontSlant->"Italic"],
 ButtonBox["By Value",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#31497"],
 StyleBox[ButtonBox["\[CloseCurlyDoubleQuote]",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#31497"],
  FontSlant->"Italic"],
 ButtonBox[" and ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#31497"],
 StyleBox[ButtonBox["\[OpenCurlyDoubleQuote]",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#31497"],
  FontSlant->"Italic"],
 ButtonBox["By Reference",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#31497"],
 StyleBox[ButtonBox["\[CloseCurlyDoubleQuote]",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#31497"],
  FontSlant->"Italic"]
}], "TOCSubsection",
 CellID->212447078],

Cell[TextData[ButtonBox["References and Values",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#2785"]], \
"TOCSubsubsection",
 CellID->9513249],

Cell[TextData[ButtonBox["ReturnAsJavaObject",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#13210"]], \
"TOCSubsubsection",
 CellID->353945401],

Cell[TextData[ButtonBox["JavaObjectToExpression",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#6477"]], \
"TOCSubsubsection",
 CellID->638227959]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MakeJavaObject and MakeJavaExpr",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#29288"]], "TOCSubsection",\

 CellID->212685550],

Cell[TextData[ButtonBox["Preamble",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#28082"]], \
"TOCSubsubsection",
 CellID->1087938],

Cell[TextData[ButtonBox["MakeJavaObject",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#16085"]], \
"TOCSubsubsection",
 CellID->9057082],

Cell[TextData[ButtonBox["MakeJavaExpr",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#2598"]], \
"TOCSubsubsection",
 CellID->210821758]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Creating Windows and Other User Interface Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#4596"]], "TOCSubsection",
 CellID->58683154],

Cell[TextData[ButtonBox["Preamble",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#24021"]], \
"TOCSubsubsection",
 CellID->692113893],

Cell[TextData[ButtonBox["Interactive and Non-Interactive Interfaces",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#314330245"]], \
"TOCSubsubsection",
 CellID->628756229],

Cell[TextData[ButtonBox["Modal versus Modeless Operation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#467"]], "TOCSubsubsection",\

 CellID->390868588],

Cell[TextData[{
 ButtonBox["Handling Events with ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
  FontSlant->"Italic"],
 ButtonBox[" Code: The \[OpenCurlyDoubleQuote]MathListener\
\[CloseCurlyDoubleQuote] Classes",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"]
}], "TOCSubsubsection",
 CellID->439538915],

Cell[TextData[ButtonBox["Bringing Java Windows to the Foreground",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#6224"]], \
"TOCSubsubsection",
 CellID->65013376],

Cell[TextData[ButtonBox["Modal Windows",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#32702"]], \
"TOCSubsubsection",
 CellID->102062813],

Cell[TextData[ButtonBox["MathFrame and MathJFrame",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#19156"]], \
"TOCSubsubsection",
 CellID->349029875],

Cell[TextData[ButtonBox["Modeless Windows: Sharing the Kernel with Java",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#16202"]], \
"TOCSubsubsection",
 CellID->80357433],

Cell[TextData[ButtonBox["Sharing the Front End",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#10021"]], \
"TOCSubsubsection",
 CellID->599164313],

Cell[TextData[ButtonBox["Summary of Modal and Modeless Operation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#13401"]], \
"TOCSubsubsection",
 CellID->276168535],

Cell[TextData[ButtonBox["\[OpenCurlyDoubleQuote]Manual\[CloseCurlyDoubleQuote]\
 Interfaces: The ServiceJava Function",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#10585"]], \
"TOCSubsubsection",
 CellID->128708671],

Cell[TextData[ButtonBox["Using a GUI Builder",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#2154"]], \
"TOCSubsubsection",
 CellID->120892770]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Drawing and Displaying ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#23775"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#23775"],
  FontSlant->"Italic"],
 ButtonBox[" Images in Java Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#23775"]
}], "TOCSubsection",
 CellID->248924152],

Cell[TextData[ButtonBox["The MathCanvas and MathGraphicsJPanel classes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#20608"]], \
"TOCSubsubsection",
 CellID->120258694],

Cell[TextData[{
 ButtonBox["Showing ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#29556"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#29556"],
  FontSlant->"Italic"],
 ButtonBox[" Graphics and Typeset Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#29556"]
}], "TOCSubsubsection",
 CellID->52698311],

Cell[TextData[ButtonBox["Drawing Using Java\[CloseCurlyQuote]s Graphics \
Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#15759"]], \
"TOCSubsubsection",
 CellID->629281192],

Cell[TextData[ButtonBox["Bitmaps",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#32604"]], \
"TOCSubsubsection",
 CellID->153834171]
}, Open  ]],

Cell[TextData[ButtonBox["The Java Console Window",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#22549"]], "TOCSubsection",\

 CellID->960838394],

Cell[TextData[ButtonBox["Using JavaBeans",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#15748"]], "TOCSubsection",\

 CellID->145043512],

Cell[TextData[ButtonBox["Hosting Applets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#13169"]], "TOCSubsection",\

 CellID->209618864],

Cell[TextData[ButtonBox["Periodical Tasks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#28255"]], "TOCSubsection",\

 CellID->402944500],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Some Special Number Classes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#10938"]], "TOCSubsection",\

 CellID->165998893],

Cell[TextData[ButtonBox["Preamble",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#1881"]], \
"TOCSubsubsection",
 CellID->262545129],

Cell[TextData[ButtonBox["The \[OpenCurlyDoubleQuote]Wrapper\
\[CloseCurlyDoubleQuote] Classes: Integer, Float, Boolean, and Others",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#28614"]], \
"TOCSubsubsection",
 CellID->3443152],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#26063"]], \
"TOCSubsubsection",
 CellID->359644624],

Cell[TextData[ButtonBox["BigInteger and BigDecimal",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#13330"]], \
"TOCSubsubsection",
 CellID->97902395]
}, Open  ]],

Cell[TextData[ButtonBox["Ragged Arrays",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#1908"]], "TOCSubsection",
 CellID->796779760],

Cell[TextData[{
 ButtonBox["Implementing a Java Interface with ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7619"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7619"],
  FontSlant->"Italic"],
 ButtonBox[" Code",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#7619"]
}], "TOCSubsection",
 CellID->375906611],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Writing Your Own Installable Java Classes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#4680"]], "TOCSubsection",
 CellID->175201727],

Cell[TextData[ButtonBox["Preamble",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#9198"]], \
"TOCSubsubsection",
 CellID->621552842],

Cell[TextData[ButtonBox["Installable Functions\[LongDash]The Old Way",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#8670"]], \
"TOCSubsubsection",
 CellID->86471611],

Cell[TextData[ButtonBox["Installable Functions in Java",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#25249"]], \
"TOCSubsubsection",
 CellID->772359685],

Cell[TextData[{
 ButtonBox["Setting up Definitions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12105"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12105"],
  FontSlant->"Italic"],
 ButtonBox[" When Your Class is Loaded",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#12105"]
}], "TOCSubsubsection",
 CellID->732465541],

Cell[TextData[{
 ButtonBox["Manually Returning a Result to ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#27753"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#27753"],
  FontSlant->"Italic"]
}], "TOCSubsubsection",
 CellID->144674171],

Cell[TextData[{
 ButtonBox["Requesting Evaluations by ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#10168"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#10168"],
  FontSlant->"Italic"]
}], "TOCSubsubsection",
 CellID->924526168],

Cell[TextData[ButtonBox["Throwing Exceptions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#20640"]], \
"TOCSubsubsection",
 CellID->7436634],

Cell[TextData[ButtonBox["Making a Method Interruptible",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#236"]], "TOCSubsubsection",\

 CellID->14818192],

Cell[TextData[ButtonBox["Writing Your Own Event Handler Code",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#27065"]], \
"TOCSubsubsection",
 CellID->103278012],

Cell[TextData[ButtonBox["Debugging Your Java Classes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#22214"]], \
"TOCSubsubsection",
 CellID->557354842]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Deploying Applications that use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17189"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#17189"],
  FontSlant->"Italic"]
}], "TOCSubsection",
 CellID->549107595],

Cell[TextData[ButtonBox["Coding Tips",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#10555"]], \
"TOCSubsubsection",
 CellID->333760312]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Example Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#16139"]], "TOCSection",
 CellID->79753027],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#12423"]], "TOCSubsection",\

 CellID->264239549],

Cell[TextData[ButtonBox["A Beep Function",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#12529"]], "TOCSubsection",\

 CellID->29246290],

Cell[TextData[ButtonBox["Formatting Dates",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#16105"]], "TOCSubsection",\

 CellID->60586840],

Cell[TextData[ButtonBox["A Progress Bar",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#5535"]], "TOCSubsection",
 CellID->38303629],

Cell[TextData[ButtonBox["A Simple Modal Input Dialog",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#7391"]], "TOCSubsection",
 CellID->130440572],

Cell[TextData[ButtonBox["A File Chooser Dialog Box",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#24372"]], "TOCSubsection",\

 CellID->288843346],

Cell[TextData[ButtonBox["Sharing the Front End: Palette-Type Buttons",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#8177"]], "TOCSubsection",
 CellID->331959025],

Cell[TextData[ButtonBox["Real-Time Algebra: A Mini-Application",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#142"]], "TOCSubsection",
 CellID->21270874],

Cell[TextData[ButtonBox["GraphicsDlg: Graphics and Typeset Output in a \
Window",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#4678"]], "TOCSubsection",
 CellID->83050866],

Cell[TextData[ButtonBox["BouncingBalls: Drawing in a Window",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#3487"]], "TOCSubsection",
 CellID->399614172],

Cell[TextData[ButtonBox["Spirograph",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#25423"]], "TOCSubsection",\

 CellID->245322079],

Cell[TextData[ButtonBox["A Piano Keyboard",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/CallingJavaFromMathematica#3737"]], "TOCSubsection",
 CellID->55824909]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Writing Java Programs That Use ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica"],
  FontSlant->"Italic"]
}], "TOCChapter",
 CellID->599564637],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#15141"]], \
"TOCSection",
 CellID->215463686],

Cell[TextData[{
 ButtonBox["What Is ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32757"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32757"],
  FontSlant->"Italic"],
 ButtonBox["?",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32757"]
}], "TOCSection",
 CellID->432385560],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["Overview of the Main ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#9741"],
 StyleBox[ButtonBox["J/Link",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#9741"],
  FontSlant->"Italic"],
 ButtonBox[" Interfaces and Classes",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#9741"]
}], "TOCSection",
 CellID->33033505],

Cell[TextData[ButtonBox["Preamble",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#27529"]], \
"TOCSubsection",
 CellID->839414143],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#12316"],
  FontSlant->"Italic"],
 ButtonBox[" and KernelLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#12316"]
}], "TOCSubsection",
 CellID->469498988],

Cell[TextData[ButtonBox["MathLinkFactory",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#30106"]], \
"TOCSubsection",
 CellID->21228148],

Cell[TextData[ButtonBox["MathLinkException",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8942"]], \
"TOCSubsection",
 CellID->351682708],

Cell[TextData[ButtonBox["Expr",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#23805"]], \
"TOCSubsection",
 CellID->162479414],

Cell[TextData[ButtonBox["PacketListener",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#6729"]], \
"TOCSubsection",
 CellID->240723138],

Cell[TextData[ButtonBox["High-Level User Interface Classes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#31101"]], \
"TOCSubsection",
 CellID->81789619]
}, Open  ]],

Cell[TextData[ButtonBox["Sample Program",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#30556"]], \
"TOCSection",
 CellID->110775015],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Creating Links with MathLinkFactory",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#15574"]], \
"TOCSection",
 CellID->38640928],

Cell[TextData[ButtonBox["Using Listen and Connect Modes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32209"]], \
"TOCSubsection",
 CellID->338003272],

Cell[TextData[ButtonBox["Using a Remote Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#24221"]], \
"TOCSubsection",
 CellID->753923304]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 ButtonBox["The ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29087"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29087"],
  FontSlant->"Italic"],
 ButtonBox[" Interface",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29087"]
}], "TOCSection",
 CellID->519082423],

Cell[TextData[ButtonBox["Managing Links",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#5686"]], \
"TOCSubsection",
 CellID->56686862],

Cell[TextData[ButtonBox["Packet Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#11662"]], \
"TOCSubsection",
 CellID->52758476],

Cell[TextData[ButtonBox["Error Handling",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#6064"]], \
"TOCSubsection",
 CellID->14359412],

Cell[TextData[ButtonBox["Link State",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#20415"]], \
"TOCSubsection",
 CellID->777890456],

Cell[TextData[ButtonBox["Putting",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29873"]], \
"TOCSubsection",
 CellID->356612959],

Cell[TextData[ButtonBox["Getting",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#12290"]], \
"TOCSubsection",
 CellID->91323356],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#6995"]], \
"TOCSubsection",
 CellID->514657044],

Cell[TextData[ButtonBox["Marks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#7479"]], \
"TOCSubsection",
 CellID->634597207],

Cell[TextData[ButtonBox["Complex Class",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#26423"]], \
"TOCSubsection",
 CellID->13301165],

Cell[TextData[ButtonBox["Yield and Message Handlers",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#17659"]], \
"TOCSubsection",
 CellID->48322183],

Cell[TextData[ButtonBox["Constants",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21196"]], \
"TOCSubsection",
 CellID->42840508]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["The KernelLink Interface",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21948"]], \
"TOCSection",
 CellID->355574326],

Cell[TextData[ButtonBox["Evaluate",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#20426"]], \
"TOCSubsection",
 CellID->12487648],

Cell[TextData[ButtonBox["Waiting for the Result",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#24429"]], \
"TOCSubsection",
 CellID->642013853],

Cell[TextData[ButtonBox["The \[OpenCurlyDoubleQuote]evaluateTo\
\[CloseCurlyDoubleQuote] Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#19375"]], \
"TOCSubsection",
 CellID->437317677],

Cell[TextData[ButtonBox["Sending Java Object References",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#16036"]], \
"TOCSubsection",
 CellID->581017613],

Cell[TextData[ButtonBox["Interrupting, Aborting, and Abandoning Evaluations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#23936"]], \
"TOCSubsection",
 CellID->45625580],

Cell[TextData[ButtonBox["Support for PacketListeners",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#1355"]], \
"TOCSubsection",
 CellID->448671759],

Cell[TextData[ButtonBox["The handlePacket() Method (Advanced Users Only)",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#18230"]], \
"TOCSubsection",
 CellID->255374566],

Cell[TextData[ButtonBox["Methods Valid Only for \
\[OpenCurlyDoubleQuote]StdLinks\[CloseCurlyDoubleQuote]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#2011"]], \
"TOCSubsection",
 CellID->106708110]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Sending Computations and Reading Results",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21991"]], \
"TOCSection",
 CellID->6051962],

Cell[TextData[{
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32196"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32196"],
  FontSlant->"Italic"],
 ButtonBox[" Packets",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32196"]
}], "TOCSubsection",
 CellID->8520203],

Cell[TextData[{
 ButtonBox["The ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
  FontSlant->"Italic"],
 ButtonBox[" \[OpenCurlyDoubleQuote]Packet Loop",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
 ButtonBox["\[CloseCurlyDoubleQuote]",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"]
}], "TOCSubsection",
 CellID->34536613],

Cell[TextData[ButtonBox["Sending an Evaluation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#9508"]], \
"TOCSubsection",
 CellID->156431327],

Cell[TextData[ButtonBox["Reading the Result",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8850"]], \
"TOCSubsection",
 CellID->4627110],

Cell[TextData[ButtonBox["The \[OpenCurlyDoubleQuote]evaluateTo\
\[CloseCurlyDoubleQuote] Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#25472"]], \
"TOCSubsection",
 CellID->198902693],

Cell[TextData[ButtonBox["Using the PacketListener Interface",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8823"]], \
"TOCSubsection",
 CellID->202032617],

Cell[TextData[ButtonBox["The PacketPrinter Class for Debugging",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#7926"]], \
"TOCSubsection",
 CellID->433501527],

Cell[TextData[ButtonBox["Using EnterTextPacket",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#7213"]], \
"TOCSubsection",
 CellID->173652115]
}, Open  ]],

Cell[TextData[ButtonBox["Handling MathLinkExceptions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#10040"]], \
"TOCSection",
 CellID->282925070],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Graphics and Typeset Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#24041"]], \
"TOCSection",
 CellID->161354972],

Cell[TextData[ButtonBox["Preamble",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#24423"]], \
"TOCSubsection",
 CellID->544498701],

Cell[TextData[ButtonBox["MathCanvas and MathGraphicsJPanel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#24229"]], \
"TOCSubsection",
 CellID->109927846],

Cell[TextData[ButtonBox["A Sample Program that Displays Graphics and Typeset \
Results",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#14369"]], \
"TOCSubsection",
 CellID->690196554],

Cell[TextData[ButtonBox["evaluateToImage() and evaluateToTypeset()",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#911"]], \
"TOCSubsection",
 CellID->208218375]
}, Open  ]],

Cell[TextData[ButtonBox["Aborting and Interrupting Computations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#19718"]], \
"TOCSection",
 CellID->195730939],

Cell[TextData[ButtonBox["Using Marks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8483"]], \
"TOCSection",
 CellID->31243541],

Cell[TextData[ButtonBox["Using Loopback Links",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#58"]], \
"TOCSection",
 CellID->481646157],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Using Expr Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#30188"]], \
"TOCSection",
 CellID->103930631],

Cell[TextData[ButtonBox["Motivation for the Expr Class",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21763"]], \
"TOCSubsection",
 CellID->459887251],

Cell[TextData[{
 ButtonBox["Methods in the ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#18958"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#18958"],
  FontSlant->"Italic"],
 ButtonBox[" Interface for Reading and Writing Exprs",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#18958"]
}], "TOCSubsection",
 CellID->83343394],

Cell[TextData[ButtonBox["Exprs as Replacements for Loopback Links",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#13007"]], \
"TOCSubsection",
 CellID->278487959],

Cell[TextData[ButtonBox["Exprs as a Means to Get String Representations of \
Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#6439"]], \
"TOCSubsection",
 CellID->4312443],

Cell[TextData[ButtonBox["Exprs as Arguments to KernelLink Methods",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#2324"]], \
"TOCSubsection",
 CellID->610735702],

Cell[TextData[ButtonBox["Examining and Manipulating Exprs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21113"]], \
"TOCSubsection",
 CellID->303907547],

Cell[TextData[ButtonBox["Disposing of Exprs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32356"]], \
"TOCSubsection",
 CellID->517492829]
}, Open  ]],

Cell[TextData[ButtonBox["Threads, Blocking, and Yielding ",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#189"]], \
"TOCSection",
 CellID->589137562],

Cell[TextData[{
 ButtonBox["Sending Object References to ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#26222"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#26222"],
  FontSlant->"Italic"]
}], "TOCSection",
 CellID->135694023],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["Some Special User Interface Classes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8928"]], \
"TOCSection",
 CellID->285034810],

Cell[TextData[ButtonBox["Introduction",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29492"]], \
"TOCSubsection",
 CellID->125374232],

Cell[TextData[ButtonBox["ConsoleWindow",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#23840"]], \
"TOCSubsection",
 CellID->36630164],

Cell[TextData[ButtonBox["MathSessionPane",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#11599"]], \
"TOCSubsection",
 CellID->20936232],

Cell[TextData[ButtonBox["BracketMatcher and SyntaxTokenizer",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#31244"]], \
"TOCSubsection",
 CellID->559441696],

Cell[TextData[ButtonBox["InterruptDialog",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#17432"]], \
"TOCSubsection",
 CellID->428223897]
}, Open  ]],

Cell[TextData[ButtonBox["Writing Applets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#20615"]], \
"TOCSection",
 CellID->680496758]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"J/Link User Guide - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "J/Link User Guide", "summary" -> 
    "Introduction to J/Link Calling Java From Mathematica Writing Java \
Programs That Use Mathematica", "uri" -> "JLink/tutorial/Overview", "type" -> 
    "Tutorial", "label" -> "J Link Tutorial", "paclet" -> "JLink", "context" -> 
    "JLink`", "keywords" -> {}, "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 31, 42.7218383}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 176, 7, 70, "AnchorBarGrid"],
Cell[779, 32, 98, 4, 70, "TOCDocumentTitle"],
Cell[CellGroupData[{
Cell[902, 40, 284, 9, 70, "TOCChapter",
 CellID->66849275],
Cell[1189, 51, 521, 16, 70, "TOCSubsection",
 CellID->185971111]
}, Open  ]],
Cell[CellGroupData[{
Cell[1747, 72, 320, 9, 70, "TOCChapter",
 CellID->263069685],
Cell[CellGroupData[{
Cell[2092, 85, 109, 5, 70, "TOCSection",
 CellID->1687036525],
Cell[2204, 92, 170, 5, 70, "TOCSubsection",
 CellID->232511722],
Cell[2377, 99, 441, 12, 70, "TOCSubsection",
 CellID->147136816],
Cell[CellGroupData[{
Cell[2843, 115, 186, 5, 70, "TOCSubsection",
 CellID->1118479],
Cell[3032, 122, 176, 5, 70, "TOCSubsubsection",
 CellID->151891135],
Cell[3211, 129, 208, 5, 70, "TOCSubsubsection",
 CellID->798800886],
Cell[3422, 136, 189, 5, 70, "TOCSubsubsection",
 CellID->77897190]
}, Open  ]],
Cell[CellGroupData[{
Cell[3648, 146, 176, 5, 70, "TOCSubsection",
 CellID->26322733],
Cell[3827, 153, 177, 5, 70, "TOCSubsubsection",
 CellID->174940147],
Cell[4007, 160, 191, 5, 70, "TOCSubsubsection",
 CellID->796012776],
Cell[4201, 167, 205, 5, 70, "TOCSubsubsection",
 CellID->19162505],
Cell[4409, 174, 177, 5, 70, "TOCSubsubsection",
 CellID->809916710]
}, Open  ]],
Cell[4601, 182, 354, 9, 70, "TOCSubsection",
 CellID->553266198],
Cell[4958, 193, 174, 4, 70, "TOCSubsection",
 CellID->849582867],
Cell[CellGroupData[{
Cell[5157, 201, 198, 5, 70, "TOCSubsection",
 CellID->232630658],
Cell[5358, 208, 171, 5, 70, "TOCSubsubsection",
 CellID->361217163],
Cell[5532, 215, 190, 5, 70, "TOCSubsubsection",
 CellID->123624998]
}, Open  ]],
Cell[5737, 223, 203, 4, 70, "TOCSubsection",
 CellID->88703548],
Cell[5943, 229, 189, 5, 70, "TOCSubsection",
 CellID->352201552],
Cell[6135, 236, 181, 5, 70, "TOCSubsection",
 CellID->796284334]
}, Open  ]],
Cell[CellGroupData[{
Cell[6353, 246, 66, 1, 70, "TOCSection",
 CellID->32713434],
Cell[CellGroupData[{
Cell[6444, 251, 466, 12, 70, "TOCSubsection",
 CellID->21292546],
Cell[6913, 265, 184, 5, 70, "TOCSubsubsection",
 CellID->790208577],
Cell[7100, 272, 198, 5, 70, "TOCSubsubsection",
 CellID->356363007],
Cell[7301, 279, 201, 5, 70, "TOCSubsubsection",
 CellID->753693084],
Cell[7505, 286, 189, 5, 70, "TOCSubsubsection",
 CellID->451859136],
Cell[7697, 293, 467, 12, 70, "TOCSubsubsection",
 CellID->81960272]
}, Open  ]],
Cell[CellGroupData[{
Cell[8201, 310, 180, 5, 70, "TOCSubsection",
 CellID->298406779],
Cell[8384, 317, 189, 5, 70, "TOCSubsubsection",
 CellID->237029824],
Cell[8576, 324, 197, 5, 70, "TOCSubsubsection",
 CellID->545120415],
Cell[8776, 331, 188, 5, 70, "TOCSubsubsection",
 CellID->322807609]
}, Open  ]],
Cell[CellGroupData[{
Cell[9001, 341, 200, 5, 70, "TOCSubsection",
 CellID->718862413],
Cell[9204, 348, 341, 9, 70, "TOCSubsubsection",
 CellID->163918297],
Cell[9548, 359, 182, 5, 70, "TOCSubsubsection",
 CellID->466936461],
Cell[9733, 366, 174, 5, 70, "TOCSubsubsection",
 CellID->181446597],
Cell[9910, 373, 171, 5, 70, "TOCSubsubsection",
 CellID->113344518],
Cell[10084, 380, 192, 5, 70, "TOCSubsubsection",
 CellID->469765809]
}, Open  ]],
Cell[CellGroupData[{
Cell[10313, 390, 172, 5, 70, "TOCSubsection",
 CellID->436480035],
Cell[10488, 397, 191, 5, 70, "TOCSubsubsection",
 CellID->246930166],
Cell[10682, 404, 186, 5, 70, "TOCSubsubsection",
 CellID->42846754]
}, Open  ]],
Cell[CellGroupData[{
Cell[10905, 414, 1196, 30, 70, "TOCSubsection",
 CellID->212447078],
Cell[12104, 446, 183, 5, 70, "TOCSubsubsection",
 CellID->9513249],
Cell[12290, 453, 183, 5, 70, "TOCSubsubsection",
 CellID->353945401],
Cell[12476, 460, 186, 5, 70, "TOCSubsubsection",
 CellID->638227959]
}, Open  ]],
Cell[CellGroupData[{
Cell[12699, 470, 193, 5, 70, "TOCSubsection",
 CellID->212685550],
Cell[12895, 477, 171, 5, 70, "TOCSubsubsection",
 CellID->1087938],
Cell[13069, 484, 177, 5, 70, "TOCSubsubsection",
 CellID->9057082],
Cell[13249, 491, 176, 5, 70, "TOCSubsubsection",
 CellID->210821758]
}, Open  ]],
Cell[CellGroupData[{
Cell[13462, 501, 208, 4, 70, "TOCSubsection",
 CellID->58683154],
Cell[13673, 507, 173, 5, 70, "TOCSubsubsection",
 CellID->692113893],
Cell[13849, 514, 211, 5, 70, "TOCSubsubsection",
 CellID->628756229],
Cell[14063, 521, 194, 5, 70, "TOCSubsubsection",
 CellID->390868588],
Cell[14260, 528, 527, 13, 70, "TOCSubsubsection",
 CellID->439538915],
Cell[14790, 543, 202, 5, 70, "TOCSubsubsection",
 CellID->65013376],
Cell[14995, 550, 178, 5, 70, "TOCSubsubsection",
 CellID->102062813],
Cell[15176, 557, 189, 5, 70, "TOCSubsubsection",
 CellID->349029875],
Cell[15368, 564, 210, 5, 70, "TOCSubsubsection",
 CellID->80357433],
Cell[15581, 571, 186, 5, 70, "TOCSubsubsection",
 CellID->599164313],
Cell[15770, 578, 204, 5, 70, "TOCSubsubsection",
 CellID->276168535],
Cell[15977, 585, 257, 6, 70, "TOCSubsubsection",
 CellID->128708671],
Cell[16237, 593, 183, 5, 70, "TOCSubsubsection",
 CellID->120892770]
}, Open  ]],
Cell[CellGroupData[{
Cell[16457, 603, 472, 12, 70, "TOCSubsection",
 CellID->248924152],
Cell[16932, 617, 210, 5, 70, "TOCSubsubsection",
 CellID->120258694],
Cell[17145, 624, 469, 12, 70, "TOCSubsubsection",
 CellID->52698311],
Cell[17617, 638, 223, 6, 70, "TOCSubsubsection",
 CellID->629281192],
Cell[17843, 646, 172, 5, 70, "TOCSubsubsection",
 CellID->153834171]
}, Open  ]],
Cell[18030, 654, 185, 5, 70, "TOCSubsection",
 CellID->960838394],
Cell[18218, 661, 177, 5, 70, "TOCSubsection",
 CellID->145043512],
Cell[18398, 668, 177, 5, 70, "TOCSubsection",
 CellID->209618864],
Cell[18578, 675, 178, 5, 70, "TOCSubsection",
 CellID->402944500],
Cell[CellGroupData[{
Cell[18781, 684, 189, 5, 70, "TOCSubsection",
 CellID->165998893],
Cell[18973, 691, 172, 5, 70, "TOCSubsubsection",
 CellID->262545129],
Cell[19148, 698, 268, 6, 70, "TOCSubsubsection",
 CellID->3443152],
Cell[19419, 706, 180, 5, 70, "TOCSubsubsection",
 CellID->359644624],
Cell[19602, 713, 189, 5, 70, "TOCSubsubsection",
 CellID->97902395]
}, Open  ]],
Cell[19806, 721, 172, 4, 70, "TOCSubsection",
 CellID->796779760],
Cell[19981, 727, 463, 12, 70, "TOCSubsection",
 CellID->375906611],
Cell[CellGroupData[{
Cell[20469, 743, 200, 4, 70, "TOCSubsection",
 CellID->175201727],
Cell[20672, 749, 172, 5, 70, "TOCSubsubsection",
 CellID->621552842],
Cell[20847, 756, 206, 5, 70, "TOCSubsubsection",
 CellID->86471611],
Cell[21056, 763, 194, 5, 70, "TOCSubsubsection",
 CellID->772359685],
Cell[21253, 770, 481, 12, 70, "TOCSubsubsection",
 CellID->732465541],
Cell[21737, 784, 351, 9, 70, "TOCSubsubsection",
 CellID->144674171],
Cell[22091, 795, 346, 9, 70, "TOCSubsubsection",
 CellID->924526168],
Cell[22440, 806, 182, 5, 70, "TOCSubsubsection",
 CellID->7436634],
Cell[22625, 813, 191, 5, 70, "TOCSubsubsection",
 CellID->14818192],
Cell[22819, 820, 200, 5, 70, "TOCSubsubsection",
 CellID->103278012],
Cell[23022, 827, 192, 5, 70, "TOCSubsubsection",
 CellID->557354842]
}, Open  ]],
Cell[CellGroupData[{
Cell[23251, 837, 344, 9, 70, "TOCSubsection",
 CellID->549107595],
Cell[23598, 848, 176, 5, 70, "TOCSubsubsection",
 CellID->333760312]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23823, 859, 172, 4, 70, "TOCSection",
 CellID->79753027],
Cell[23998, 865, 174, 5, 70, "TOCSubsection",
 CellID->264239549],
Cell[24175, 872, 176, 5, 70, "TOCSubsection",
 CellID->29246290],
Cell[24354, 879, 177, 5, 70, "TOCSubsection",
 CellID->60586840],
Cell[24534, 886, 172, 4, 70, "TOCSubsection",
 CellID->38303629],
Cell[24709, 892, 186, 4, 70, "TOCSubsection",
 CellID->130440572],
Cell[24898, 898, 187, 5, 70, "TOCSubsection",
 CellID->288843346],
Cell[25088, 905, 202, 4, 70, "TOCSubsection",
 CellID->331959025],
Cell[25293, 911, 194, 4, 70, "TOCSubsection",
 CellID->21270874],
Cell[25490, 917, 212, 5, 70, "TOCSubsection",
 CellID->83050866],
Cell[25705, 924, 193, 4, 70, "TOCSubsection",
 CellID->399614172],
Cell[25901, 930, 172, 5, 70, "TOCSubsection",
 CellID->245322079],
Cell[26076, 937, 174, 4, 70, "TOCSubsection",
 CellID->55824909]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26299, 947, 355, 9, 70, "TOCChapter",
 CellID->599564637],
Cell[26657, 958, 182, 5, 70, "TOCSection",
 CellID->215463686],
Cell[26842, 965, 474, 15, 70, "TOCSection",
 CellID->432385560],
Cell[CellGroupData[{
Cell[27341, 984, 503, 15, 70, "TOCSection",
 CellID->33033505],
Cell[27847, 1001, 181, 5, 70, "TOCSubsection",
 CellID->839414143],
Cell[28031, 1008, 359, 11, 70, "TOCSubsection",
 CellID->469498988],
Cell[28393, 1021, 187, 5, 70, "TOCSubsection",
 CellID->21228148],
Cell[28583, 1028, 189, 5, 70, "TOCSubsection",
 CellID->351682708],
Cell[28775, 1035, 177, 5, 70, "TOCSubsection",
 CellID->162479414],
Cell[28955, 1042, 186, 5, 70, "TOCSubsection",
 CellID->240723138],
Cell[29144, 1049, 205, 5, 70, "TOCSubsection",
 CellID->81789619]
}, Open  ]],
Cell[29364, 1057, 184, 5, 70, "TOCSection",
 CellID->110775015],
Cell[CellGroupData[{
Cell[29573, 1066, 204, 5, 70, "TOCSection",
 CellID->38640928],
Cell[29780, 1073, 203, 5, 70, "TOCSubsection",
 CellID->338003272],
Cell[29986, 1080, 194, 5, 70, "TOCSubsection",
 CellID->753923304]
}, Open  ]],
Cell[CellGroupData[{
Cell[30217, 1090, 479, 15, 70, "TOCSection",
 CellID->519082423],
Cell[30699, 1107, 185, 5, 70, "TOCSubsection",
 CellID->56686862],
Cell[30887, 1114, 188, 5, 70, "TOCSubsection",
 CellID->52758476],
Cell[31078, 1121, 185, 5, 70, "TOCSubsection",
 CellID->14359412],
Cell[31266, 1128, 183, 5, 70, "TOCSubsection",
 CellID->777890456],
Cell[31452, 1135, 180, 5, 70, "TOCSubsection",
 CellID->356612959],
Cell[31635, 1142, 179, 5, 70, "TOCSubsection",
 CellID->91323356],
Cell[31817, 1149, 180, 5, 70, "TOCSubsection",
 CellID->514657044],
Cell[32000, 1156, 177, 5, 70, "TOCSubsection",
 CellID->634597207],
Cell[32180, 1163, 185, 5, 70, "TOCSubsection",
 CellID->13301165],
Cell[32368, 1170, 198, 5, 70, "TOCSubsection",
 CellID->48322183],
Cell[32569, 1177, 181, 5, 70, "TOCSubsection",
 CellID->42840508]
}, Open  ]],
Cell[CellGroupData[{
Cell[32787, 1187, 194, 5, 70, "TOCSection",
 CellID->355574326],
Cell[32984, 1194, 180, 5, 70, "TOCSubsection",
 CellID->12487648],
Cell[33167, 1201, 195, 5, 70, "TOCSubsection",
 CellID->642013853],
Cell[33365, 1208, 244, 6, 70, "TOCSubsection",
 CellID->437317677],
Cell[33612, 1216, 203, 5, 70, "TOCSubsection",
 CellID->581017613],
Cell[33818, 1223, 222, 5, 70, "TOCSubsection",
 CellID->45625580],
Cell[34043, 1230, 199, 5, 70, "TOCSubsection",
 CellID->448671759],
Cell[34245, 1237, 220, 5, 70, "TOCSubsection",
 CellID->255374566],
Cell[34468, 1244, 252, 6, 70, "TOCSubsection",
 CellID->106708110]
}, Open  ]],
Cell[CellGroupData[{
Cell[34757, 1255, 208, 5, 70, "TOCSection",
 CellID->6051962],
Cell[34968, 1262, 475, 15, 70, "TOCSubsection",
 CellID->8520203],
Cell[35446, 1279, 654, 19, 70, "TOCSubsection",
 CellID->34536613],
Cell[36103, 1300, 193, 5, 70, "TOCSubsection",
 CellID->156431327],
Cell[36299, 1307, 188, 5, 70, "TOCSubsection",
 CellID->4627110],
Cell[36490, 1314, 244, 6, 70, "TOCSubsection",
 CellID->198902693],
Cell[36737, 1322, 206, 5, 70, "TOCSubsection",
 CellID->202032617],
Cell[36946, 1329, 209, 5, 70, "TOCSubsection",
 CellID->433501527],
Cell[37158, 1336, 193, 5, 70, "TOCSubsection",
 CellID->173652115]
}, Open  ]],
Cell[37366, 1344, 197, 5, 70, "TOCSection",
 CellID->282925070],
Cell[CellGroupData[{
Cell[37588, 1353, 197, 5, 70, "TOCSection",
 CellID->161354972],
Cell[37788, 1360, 181, 5, 70, "TOCSubsection",
 CellID->544498701],
Cell[37972, 1367, 206, 5, 70, "TOCSubsection",
 CellID->109927846],
Cell[38181, 1374, 234, 6, 70, "TOCSubsection",
 CellID->690196554],
Cell[38418, 1382, 212, 5, 70, "TOCSubsection",
 CellID->208218375]
}, Open  ]],
Cell[38645, 1390, 208, 5, 70, "TOCSection",
 CellID->195730939],
Cell[38856, 1397, 179, 5, 70, "TOCSection",
 CellID->31243541],
Cell[39038, 1404, 187, 5, 70, "TOCSection",
 CellID->481646157],
Cell[CellGroupData[{
Cell[39250, 1413, 188, 5, 70, "TOCSection",
 CellID->103930631],
Cell[39441, 1420, 202, 5, 70, "TOCSubsection",
 CellID->459887251],
Cell[39646, 1427, 522, 15, 70, "TOCSubsection",
 CellID->83343394],
Cell[40171, 1444, 213, 5, 70, "TOCSubsection",
 CellID->278487959],
Cell[40387, 1451, 233, 6, 70, "TOCSubsection",
 CellID->4312443],
Cell[40623, 1459, 212, 5, 70, "TOCSubsection",
 CellID->610735702],
Cell[40838, 1466, 205, 5, 70, "TOCSubsection",
 CellID->303907547],
Cell[41046, 1473, 191, 5, 70, "TOCSubsection",
 CellID->517492829]
}, Open  ]],
Cell[41252, 1481, 200, 5, 70, "TOCSection",
 CellID->589137562],
Cell[41455, 1488, 373, 11, 70, "TOCSection",
 CellID->135694023],
Cell[CellGroupData[{
Cell[41853, 1503, 204, 5, 70, "TOCSection",
 CellID->285034810],
Cell[42060, 1510, 185, 5, 70, "TOCSubsection",
 CellID->125374232],
Cell[42248, 1517, 185, 5, 70, "TOCSubsection",
 CellID->36630164],
Cell[42436, 1524, 187, 5, 70, "TOCSubsection",
 CellID->20936232],
Cell[42626, 1531, 207, 5, 70, "TOCSubsection",
 CellID->559441696],
Cell[42836, 1538, 188, 5, 70, "TOCSubsection",
 CellID->428223897]
}, Open  ]],
Cell[43039, 1546, 185, 5, 70, "TOCSection",
 CellID->680496758]
}, Open  ]],
Cell[43239, 1554, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

