(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    390593,      12406]
NotebookOptionsPosition[    289576,       9208]
NotebookOutlinePosition[    350623,      11011]
CellTagsIndexPosition[    345599,      10879]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["J Link",
      FontSlant->"Italic"],
     " ",
     "Tutorial"
    }], "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Writing Java Programs that Use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->{"jlug:6.1.0.0", "TableOfContents_1.6.1"},
 CellID->15141],

Cell[TextData[{
 "The first part of this ",
 ButtonBox["User Guide",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/Overview"],
 " describes using ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to allow you to call from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into Java, thereby extending the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " environment to include the functionality in all existing and future Java \
classes. This part shows you how to use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " in the opposite direction, as a means to write Java programs that use the \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel as a computational engine."
}], "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->7711],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " uses ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", Wolfram Research\[CloseCurlyQuote]s protocol for sending data and \
commands between programs. Many of the concepts and techniques in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programming are the same as those for programming with the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C-language API. The ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " documentation is not intended to be an encyclopedic compendium of \
everything you need to know to write Java programs that use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". Programmers may have to rely a little on the general documentation of ",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" programming",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 ". Many of the functions ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides have C-language counterparts that are identical or nearly so."
}], "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->28253],

Cell[TextData[{
 "If you have not read ",
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ", you should at least skim it at some point. Your Java \
\[OpenCurlyDoubleQuote]front end\[CloseCurlyDoubleQuote] can use the same \
techniques for calling Java methods from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code and passing Java objects as arguments that programmers use when \
running the kernel from the notebook front end. This allows you to have a \
very high-level interface between Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". When you are writing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs in C, you have to think about passing and returning simple things \
like strings and integers. With ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " you can pass Java objects back and forth between Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " truly obliterates the boundary between Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->6868],

Cell[TextData[{
 "Although Java is quite useful as a web-related development language, such \
as for writing applets or servlets, it is by no means restricted to this \
domain, and this User Guide does not address the specifics of these types of \
programs. We treat generic issues in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programming, leaving the application of these concepts in specific types \
of programs up to the reader. In other words, if you are looking for a \
worked-out example program showing how a suite of servlets running on a web \
or application server can allow remote Java clients to share a cluster of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernels, you won\[CloseCurlyQuote]t find it here. But ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is just the sort of tool you will need if you embark on such a project."
}], "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->25547],

Cell[TextData[{
 "This half of the manual is organized as follows. ",
 ButtonBox["What Is ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32757"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32757"],
  FontSlant->"Italic"],
 ButtonBox["?",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32757"],
 " is a very brief introduction to ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". The section ",
 ButtonBox["Preamble",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#27529"],
 " introduces the most important ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " interfaces and classes. ",
 ButtonBox["Sample Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#30556"],
 " presents a simple example program. ",
 ButtonBox["Creating Links with MathLinkFactory",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#15574"],
 " shows how to launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and create links. ",
 ButtonBox["The ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29087"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29087"],
  FontSlant->"Italic"],
 ButtonBox[" Interface",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29087"],
 " and ",
 ButtonBox["The KernelLink Interface",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21948"],
 " give a listing of methods in the large and all-important ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " interfaces. The methods are grouped by function, and there is some \
commentary mixed in. This treatment does not replace the actual JavaDoc help \
files for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", found in the ",
 StyleBox["JLink/Documentation/JavaDoc", "MR"],
 " directory. The JavaDoc files are the main method-by-method reference for \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", and they include all the classes and interfaces that programmers will \
use. The remaining sections of this User Guide present discussions of a \
number of important topics in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programming, including how to handle exceptions and get graphics and \
typeset output."
}], "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->27644],

Cell[TextData[{
 "When you are reading this text, or programming in Java or ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", remember that the entire source code for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is provided. If you want to see how anything works (or why it doesn\
\[CloseCurlyQuote]t), you can always consult the source code directly."
}], "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->32662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "What Is ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "?"
}], "Section",
 CellTags->{"2.1", "jlug:6.2.0.0", "TableOfContents_1.6.2"},
 CellID->32757],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is a platform-independent protocol for communicating between programs. In \
more concrete terms, it is a means to send and receive ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is the means by which the notebook front end and kernel communicate with \
each other. It is also used by a large number of commercial and freeware \
applications and utilities that link ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and other programs or languages."
}], "Text",
 CellTags->"jlug:6.2.0.0",
 CellID->20037],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is implemented as a library of C-language functions. Using it from another \
language (such as Java) typically requires writing some type of \
\[OpenCurlyDoubleQuote]glue\[CloseCurlyDoubleQuote] code that translates \
between the data types and calling conventions of that language and C. At the \
core of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is just such a translation layer\[LongDash]a library built using Java\
\[CloseCurlyQuote]s JNI (Java Native Interface) specification."
}], "Text",
 CellTags->"jlug:6.2.0.0",
 CellID->12859],

Cell[TextData[{
 "Throughout this part of the manual, the term ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will be used in two ways\[LongDash]as a generic term for the capability ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has to communicate with other programs, and as the name for one specific \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " interface. It will always be written in the special font used for Java \
names when the interface name is being used."
}], "Text",
 CellTags->"jlug:6.2.0.0",
 CellID->8723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Overview of the Main ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " Interfaces and Classes"
}], "Section",
 CellTags->{"2.3", "jlug:6.3.0.0", "TableOfContents_1.6.3"},
 CellID->9741],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellTags->{"jlug:6.3.0.1", "TableOfContents_1.6.3.1"},
 CellID->27529],

Cell[TextData[{
 "The ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " classes are written in an object-oriented style intended to maximize their \
extensibility in the future without requiring users\[CloseCurlyQuote] code to \
change. This requires a clean separation between interface and \
implementation. This is accomplished by exposing the main link functionality \
through interfaces, not classes. The names of the concrete classes that \
implement these interfaces will hardly be mentioned because programmers do \
not need to know or care what they are. Rather, you will use objects that \
belong to one of the interface types. You do not need to know what the actual \
classes are because you will never create an instance directly; instead, you \
use a \[OpenCurlyDoubleQuote]factory method\[CloseCurlyDoubleQuote] to create \
an instance of a link class. This will become clear further on."
}], "Text",
 CellTags->"jlug:6.3.0.1",
 CellID->778]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLink and KernelLink", "Subsection",
 CellTags->{"jlug:6.3.0.2", "TableOfContents_1.6.3.2"},
 CellID->12316],

Cell[TextData[{
 "The two most important link interfaces you need to know about are ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface is essentially a port of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API into Java. Most of the method names will be familiar to experienced \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programmers. ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " extends ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and adds some important high-level convenience methods that are only \
meaningful if the other side of the link is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel (for example, the method ",
 StyleBox["waitForAnswer()", "MR"],
 ", which assumes the other side of the link will respond with a defined \
series of packets)."
}], "Text",
 CellTags->"jlug:6.3.0.2",
 CellID->3035],

Cell[TextData[{
 "The basic idea is that the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface encompasses all the operations that can be performed on a link \
without making any assumptions about what program is on the other side of the \
link. ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " adds the assumption that the other side is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. In the future, other interfaces could be added that also extend ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and encapsulate other conventions for communicating over a link."
}], "Text",
 CellTags->"jlug:6.3.0.2",
 CellID->22190],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " is the most important interface, as most programmers will work exclusively \
with ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 ". Of course, since ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " extends ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 ", many of the methods you will use on your ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " objects are declared and documented in the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface."
}], "Text",
 CellTags->"jlug:6.3.0.2",
 CellID->1842],

Cell[TextData[{
 "The most important class that implements ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " is ",
 StyleBox["NativeLink", "MR"],
 ", so named because it uses native methods to call into Wolfram Research\
\[CloseCurlyQuote]s ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. In the future, other classes could be added that do not rely on \
native methods\[LongDash]for example, one that uses RMI to communicate across \
a network. As discussed above, most programmers do not need to be concerned \
about what these classes are, because they will never type a link class name \
in their code."
}], "Text",
 CellTags->"jlug:6.3.0.2",
 CellID->288]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkFactory", "Subsection",
 CellTags->{"jlug:6.3.0.3", "TableOfContents_1.6.3.3"},
 CellID->30106],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathLinkFactory",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkFactory"]], "InlineFormula"],
 " is the class that you use to create link objects. It contains the static \
methods ",
 StyleBox["createMathLink()", "MR"],
 ", ",
 StyleBox["createKernelLink()", "MR"],
 ", and ",
 StyleBox["createLoopbackLink()", "MR"],
 ", which take various argument sequences. These are the equivalents of \
calling ",
 StyleBox["MLOpen", "MR"],
 " in a C program. The ",
 Cell[BoxData[
  ButtonBox["MathLinkFactory",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkFactory"]], "InlineFormula"],
 " methods are discussed in detail in ",
 ButtonBox["Creating Links with MathLinkFactory",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#15574"],
 "."
}], "Text",
 CellTags->"jlug:6.3.0.3",
 CellID->9040]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathLinkException", "Subsection",
 CellTags->{"jlug:6.3.0.4", "TableOfContents_1.6.3.4"},
 CellID->8942],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " is the exception class that is thrown by many of the methods in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 ". The ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " API uses exceptions to indicate errors, rather than function return values \
like the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API. In C, you write code that checks the return values like this:"
}], "Text",
 CellTags->"jlug:6.3.0.4",
 CellID->19264],

Cell["\<\
\t// C code
\tif (!MLPutInteger(link, 42)) {
\t\t// was error; print message and clean up.
\t}\
\>", "Program",
 CellTags->"jlug:6.3.0.4",
 CellID->22648],

Cell[TextData[{
 "In ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", you wrap ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " calls in a ",
 StyleBox["try", "MR"],
 " block and catch ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:6.3.0.4",
 CellID->27446]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expr", "Subsection",
 CellTags->{"jlug:6.3.0.5", "TableOfContents_1.6.3.5"},
 CellID->23805],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class provides a direct representation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in Java. ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " has a number of methods that provide information about the structure of \
the expression and that let you extract components. These methods have names \
and behaviors that will be familiar to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers\[LongDash]for example, ",
 StyleBox["length()", "MR"],
 ", ",
 StyleBox["part()", "MR"],
 ", ",
 StyleBox["numberQ()", "MR"],
 ", ",
 StyleBox["vectorQ()", "MR"],
 ", ",
 StyleBox["take()", "MR"],
 ", ",
 StyleBox["delete()", "MR"],
 ", and so on. When reading from a link, instead of using the low-level ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface methods for discovering the structure and properties of the \
incoming expression, you can just read an entire expression from the link \
using ",
 StyleBox["getExpr()", "MR"],
 ", and then use ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " methods to inspect it or decompose it. For writing to a link, ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects can be used as arguments to some of the most important ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods. The ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class is discussed in detail in ",
 ButtonBox["Motivation for the Expr Class",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21763"],
 "."
}], "Text",
 CellTags->"jlug:6.3.0.5",
 CellID->15890]
}, Open  ]],

Cell[CellGroupData[{

Cell["PacketListener", "Subsection",
 CellTags->{"jlug:6.3.0.6", "TableOfContents_1.6.3.6"},
 CellID->6729],

Cell[TextData[{
 "A central component of a standard C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program is a packet-reading loop, which typically consists of calling the \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API functions ",
 StyleBox["MLNextPacket", "InlineCode"],
 " and ",
 StyleBox["MLNewPacket", "InlineCode"],
 " until a desired packet is encountered. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs will typically not include such a loop\[LongDash]instead, you \
call the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods ",
 StyleBox["waitForAnswer()", "MR"],
 " or ",
 StyleBox["discardAnswer()", "MR"],
 ", which hide the packet loop within them. Not only is this a convenience to \
avoid having to put the same boilerplate code into every program, it is \
necessary since in some circumstances programmers ",
 StyleBox["cannot",
  FontSlant->"Italic"],
 " write a correct packet because special packets may arrive that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " needs to handle internally. It is therefore necessary to hide the details \
of the packet loop from programmers. In some cases, though, programmers will \
want to observe and/or operate on the incoming flow of packets. A typical \
example would be to display ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output or messages generated by a computation. These outputs are side \
effects of a computation and not the \[OpenCurlyDoubleQuote]answer,\
\[CloseCurlyDoubleQuote] and they are normally discarded by ",
 StyleBox["waitForAnswer()", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.3.0.6",
 CellID->24370],

Cell[TextData[{
 "To accommodate this need, ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " objects fire a ",
 Cell[BoxData[
  ButtonBox["PacketArrivedEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketArrivedEvent"]], 
  "InlineFormula"],
 " for each packet that is encountered while running an internal packet loop. \
You can register your interest in receiving notifications of these packets by \
creating a class that implements the ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface and registering an object of this class with the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " object. The ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface has only one method, ",
 StyleBox["packetArrived()", "MR"],
 ", which will be called for each packet. Your ",
 StyleBox["packetArrived()", "MR"],
 " method can consume or ignore the packet ",
 StyleBox["without affecting the internal packet loop in any way",
  FontSlant->"Italic"],
 ". Very advanced programmers can optionally indicate that the internal \
packet loop should not see the packet. "
}], "Text",
 CellTags->"jlug:6.3.0.6",
 CellID->15350],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface is discussed in greater detail in ",
 ButtonBox["Using the PacketListener Interface",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8823"],
 "."
}], "Text",
 CellTags->"jlug:6.3.0.6",
 CellID->15006]
}, Open  ]],

Cell[CellGroupData[{

Cell["High-Level User Interface Classes", "Subsection",
 CellTags->{"jlug:6.3.0.7", "TableOfContents_1.6.3.7"},
 CellID->31101],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " includes several classes that are useful for creating programs that have \
user interfaces. The ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " classes provide an easy way to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and typeset expressions. These classes are often used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, as described in ",
 ButtonBox["The MathCanvas and MathGraphicsJPanel classes",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#20608"],
 ", but they are just as useful in Java programs. They are discussed in ",
 ButtonBox["MathCanvas and MathGraphicsJPanel",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#24229"],
 ". The various \[OpenCurlyDoubleQuote]MathListener\[CloseCurlyDoubleQuote] \
classes (",
 ButtonBox["Handling Events with ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
  FontSlant->"Italic"],
 ButtonBox[" Code: The \[OpenCurlyDoubleQuote]MathListener\
\[CloseCurlyDoubleQuote] Classes",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#2421"],
 ") can be be used from Java code to trigger evaluations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when user interface actions occur."
}], "Text",
 CellTags->"jlug:6.3.0.7",
 CellID->24393],

Cell[TextData[{
 "New in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0 are the classes in the ",
 StyleBox["com.wolfram.jlink.ui", "MR"],
 " package. These classes provide some very high-level user interface \
elements. There is the ",
 Cell[BoxData[
  ButtonBox["ConsoleWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/ConsoleWindow"]], "InlineFormula"],
 " class, which gives you a console output window (this is the class used to \
implement the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["ShowJavaConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ShowJavaConsole"]], "InlineFormula"],
 ", discussed in ",
 ButtonBox["The Java Console Window",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#22549"],
 "). The ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " class gives you an \[OpenCurlyDoubleQuote]Interrupt Evaluation\
\[CloseCurlyDoubleQuote] dialog similar to the one you see in the notebook \
front end when you choose ",
 StyleBox[ButtonBox["Interrupt Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InterruptEvaluation"], "MenuName"],
 " from the ",
 StyleBox["Evaluation", "MenuName"],
 " menu. The ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " class provides an ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "MR"]], "InlineFormula"],
 StyleBox["/", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "MR"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session window complete with a full set of editing functions including \
cut/copy/paste/undo/redo, support for graphics, syntax coloring, and \
customizable font styles. The auxiliary classes ",
 Cell[BoxData[
  ButtonBox["SyntaxTokenizer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/SyntaxTokenizer"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BracketMatcher",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/BracketMatcher"]], "InlineFormula"],
 " are used by ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " but can also be used separately to provide these services in your own \
programs. All these classes are discussed in the section ",
 ButtonBox["Some Special User Interface Classes: Introduction",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29492"],
 "."
}], "Text",
 CellTags->"jlug:6.3.0.7",
 CellID->3548]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sample Program", "Section",
 CellTags->{"jlug:6.4.0.0", "TableOfContents_1.6.4"},
 CellID->30556],

Cell[TextData[{
 "Here is a basic Java program that launches the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, uses it for some computations, and then shuts it down. This \
program is provided in source code and compiled form in the ",
 StyleBox["JLink/Examples/Part2", "MR"],
 " directory. The usual ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " arguments including the path to the kernel are given on the command line \
you use to launch the program, and some typical examples are given below. You \
will have to adjust the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel path for your system. If you have your ",
 StyleBox["CLASSPATH", "MR"],
 " environment variable set to include ",
 StyleBox["JLink.jar", "MR"],
 ", then you can leave off the ",
 StyleBox["-classpath", "MR"],
 " specification in these command lines. It is assumed that these commands \
are executed from the ",
 StyleBox["JLink/Examples/Part2", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:6.4.0.0",
 CellID->30974],

Cell["\<\
(Windows)
java -classpath .;..\\..\\JLink.jar SampleProgram -linkmode launch -linkname \
\"c:\\program files\\wolfram research\\mathematica\\6.0\\mathkernel.exe\"

(Unix)
java -classpath .:../../JLink.jar SampleProgram -linkmode launch -linkname \
'math -mathlink'

(Mac OS X from a terminal window)
java -classpath .:../../JLink.jar SampleProgram -linkmode launch -linkname \
'\"/Applications/Mathematica.app/Contents/MacOS/MathKernel\" -mathlink'
\
\>", "Program",
 CellTags->"jlug:6.4.0.0",
 CellID->3447],

Cell[TextData[{
 "Here is the code from ",
 StyleBox["SampleProgram.java", "MR"],
 ". This program demonstrates launching the kernel with ",
 Cell[BoxData[
  ButtonBox["MathLinkFactory",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkFactory"]], "InlineFormula"],
 StyleBox[".createKernelLink()", "MR"],
 ", and several different ways to send computations to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and read the result."
}], "Text",
 CellTags->"jlug:6.4.0.0",
 CellID->5021],

Cell["\<\
import com.wolfram.jlink.*;

public class SampleProgram {

\tpublic static void main(String[] argv) {

\t\tKernelLink ml = null;

\t\ttry {
\t\t\tml = MathLinkFactory.createKernelLink(argv);
\t\t} catch (MathLinkException e) {
\t\t\tSystem.out.println(\"Fatal error opening link: \" + e.getMessage());
\t\t\treturn;
\t\t}

\t\ttry {
\t\t\t// Get rid of the initial InputNamePacket the kernel will send
\t\t\t// when it is launched.
\t\t\tml.discardAnswer();

\t\t\tml.evaluate(\"<<MyPackage.m\");
\t\t\tml.discardAnswer();

\t\t\tml.evaluate(\"2+2\");
\t\t\tml.waitForAnswer();

\t\t\tint result = ml.getInteger();
\t\t\tSystem.out.println(\"2 + 2 = \" + result);

\t\t\t// Here's how to send the same input, but not as a string:
\t\t\tml.putFunction(\"EvaluatePacket\", 1);
\t\t\tml.putFunction(\"Plus\", 2);
\t\t\tml.put(3);
\t\t\tml.put(3);
\t\t\tml.endPacket();
\t\t\tml.waitForAnswer();
\t\t\tresult = ml.getInteger();
\t\t\tSystem.out.println(\"3 + 3 = \" + result);

\t\t\t// If you want the result back as a string, use evaluateToInputForm
\t\t\t// or evaluateToOutputForm. The second arg for either is the
\t\t\t// requested page width for formatting the string. Pass 0 for
\t\t\t// PageWidth->Infinity. These methods get the result in one
\t\t\t// step--no need to call waitForAnswer.
\t\t\tString strResult = ml.evaluateToOutputForm(\"4+4\", 0);
\t\t\tSystem.out.println(\"4 + 4 = \" + strResult);

\t\t} catch (MathLinkException e) {
\t\t\tSystem.out.println(\"MathLinkException occurred: \" + e.getMessage());
\t\t} finally {
\t\t\tml.close();
\t\t}
\t}
}\
\>", "Program",
 CellTags->"jlug:6.4.0.0",
 CellID->18283]
}, Open  ]],

Cell[CellGroupData[{

Cell["Creating Links with MathLinkFactory", "Section",
 CellTags->{"2.5", "jlug:6.5.0.0", "TableOfContents_1.6.5"},
 CellID->15574],

Cell[TextData[{
 "To isolate clients of the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " classes from implementation details it is required that clients never \
explicitly name a link class in their code. This means that programs will \
never call ",
 StyleBox["new", "MR"],
 " to create an instance of a link class. Instead, a so-called \
\[OpenCurlyDoubleQuote]factory method\[CloseCurlyDoubleQuote] is supplied \
that creates an appropriate instance for you, based on the arguments you pass \
in. This factory method takes the place of calling ",
 StyleBox["MLOpen", "MR"],
 " in a C program."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->4031],

Cell[TextData[{
 "The method that creates a ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " is a static method called ",
 StyleBox["createKernelLink()", "MR"],
 " in the ",
 Cell[BoxData[
  ButtonBox["MathLinkFactory",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkFactory"]], "InlineFormula"],
 " class:"
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->12052],

Cell["\<\
public static KernelLink createKernelLink(String cmdLine) throws \
MathLinkException
\t
public static KernelLink createKernelLink(String[] argv) throws \
MathLinkException
\t
. . . plus a few more of limited usefulness\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->27350],

Cell[TextData[{
 "There are also two functions called ",
 StyleBox["createMathLink()", "MR"],
 " that take the same arguments but create a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " instead of a ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 ". Very few programmers will need to use ",
 StyleBox["createMathLink()", "MR"],
 " because the only reason to do so is if you are connecting to a program \
other than the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. See the JavaDoc files for a complete listing of the methods."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->1150],

Cell[TextData[{
 "The second signature of ",
 StyleBox["createKernelLink()", "MR"],
 " is convenient if you are using the command line parameters that your \
program was launched with, which are, of course, provided to your ",
 StyleBox["main()", "MR"],
 " function as an array of strings. An example of this use can be found in \
the sample program in the section ",
 ButtonBox["Sample Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#30556"],
 ". Other times it will be convenient to specify the parameters as a single \
string, for example:"
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->16941],

Cell["\<\
KernelLink ml = MathLinkFactory.createKernelLink(\"-linkmode launch -linkname \
'c:\\\\program files\\\\wolfram research\\\\mathematica\\\\6.0\\\\mathkernel'\
\");\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->21724],

Cell[TextData[{
 "Note that the linkname argument is wrapped in single quotation marks ('). \
This is because ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " parses this string as a complete command line, and wrapping it in single \
quotation marks is an easy way to force it to be seen as just a filename. \
Also note that it is required to type two backslashes to indicate a Windows \
directory separator character when you are typing a literal string in your \
Java code because Java, like C and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", treats the \\ as a meta-character that quotes the character following."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->13966],

Cell[TextData[{
 "Here are some typical arguments for ",
 StyleBox["createKernelLink()", "MR"],
 " on various platforms when given as a single string. Note the use of quote \
characters (' and \"):"
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->3430],

Cell["\<\
// Typical launch on Windows
KernelLink ml = MathLinkFactory.createKernelLink(\"-linkmode launch -linkname \
'c:\\\\program files\\\\wolfram \
research\\\\mathematica\\\\math42\\\\mathkernel.exe'\");

// Typical launch on Unix
KernelLink ml = MathLinkFactory.createKernelLink(\"-linkmode launch -linkname \
'math -mathlink'\");

// Typical launch on Mac OS X
KernelLink ml = MathLinkFactory.createKernelLink(\"-linkmode launch -linkname \
'\\\"/Applications/Mathematica.app/Contents/MacOS/MathKernel\\\" \
-mathlink'\");

// Typical \"listen\" link on any platform:
KernelLink ml = MathLinkFactory.createKernelLink(\"-linkmode listen -linkname \
1234 -linkprotocol tcp\");

// Windows can use the default protocol for listen/connect links:
KernelLink ml = MathLinkFactory.createKernelLink(\"-linkmode listen -linkname \
foo\");\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->31107],

Cell[TextData[{
 "Here are typical arguments for ",
 StyleBox["createKernelLink()", "MR"],
 " when given as an array of strings:"
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->30191],

Cell["\<\
// Typical launch on Windows:
String[] argv = {\"-linkmode\", \"launch\", \"-linkname\", \"c:\\\\program \
files\\\\wolfram research\\\\mathematica\\\\6.0\\\\mathkernel\"};

// Typical launch on UNIX:
String[] argv = {\"-linkmode\", \"launch\", \"-linkname\", \"math \
-mathlink\"};

// Typical launch on Mac OS X:
String[] argv = {\"-linkmode\", \"launch\", \"-linkname\", \
\"\\\"/Applications/Mathematica.app/Contents/MacOS/MathKernel\\\" \
-mathlink\"};

// Typical \"listen\" link on any platform:
String[] argv = {\"-linkmode\", \"listen\", \"-linkname\", \"1234\", \
\"-linkprotocol\", \"tcp\"};

// Windows can use the default protocol for listen/connect links:
String[] argv = {\"-linkmode\", \"listen\", \"-linkname\", \"foo\"};\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->18007],

Cell[TextData[{
 "The arguments for ",
 StyleBox["createKernelLink()", "MR"],
 " and ",
 StyleBox["createMathLink()", "MR"],
 " (e.g., -linkmode, -linkprotocol, ",
 "and so on",
 ") are identical to those used for ",
 StyleBox["MLOpen", "MR"],
 " in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API. Consult the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " documentation for more information."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->11337],

Cell[TextData[{
 "The ",
 StyleBox["createKernelLink()", "MR"],
 " and ",
 StyleBox["createMathLink()", "MR"],
 " methods will always return a non-",
 StyleBox["null", "MR"],
 " link object or throw a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ". You do not need to test whether the returned link is ",
 StyleBox["null", "MR"],
 ". Because these methods throw a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " on failure, you need to wrap the call in a ",
 StyleBox["try", "MR"],
 " block:"
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->15457],

Cell["\<\
KernelLink ml = null;
try {
\tml = MathLinkFactory.createKernelLink(\"-linkmode launch -linkname \
'c:\\\\program files\\\\wolfram research\\\\mathematica\\\\6.0\\\\mathkernel'\
\");
} catch (MathLinkException e) {
\t// This is equivalent to MLOpen returning NULL in a C program.
\tSystem.out.println(e.getMessage());
\tSystem.exit(1);
}\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->12287],

Cell[TextData[{
 "The fact that ",
 StyleBox["createKernelLink()", "MR"],
 " succeeds does not mean that the link is connected and functioning \
properly. There are a lot of things that could be wrong. For example, if you \
launch a program that knows nothing about ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", ",
 StyleBox["createKernelLink()", "MR"],
 " will still succeed. There is a difference between creating a link (which \
involves setting up your side) and connecting one (which verifies that the \
other side is alive and well)."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->27753],

Cell[TextData[{
 "If a link has not been connected yet, ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will automatically try to connect it the first time you try to read or \
write something. Alternatively, you can call the ",
 StyleBox["connect()", "MR"],
 " method to explicitly connect the link after creating it. If the link \
cannot be connected, then the attempt to connect, whether made explicitly by \
you or internally by ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", will fail or even hang indefinitely. It can hang because the attempt to \
connect will block until the connection succeeds or until it detects a fatal \
problem with the link. In some cases, neither will happen\[LongDash]for \
example, if you mistakenly launch a program that is not ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-aware. Dealing with blocking in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " methods is discussed more thoroughly later, but in the case of connecting \
the link we have an easy solution. The ",
 StyleBox["connect()", "MR"],
 " method has a second signature that takes a ",
 StyleBox["long", "MR"],
 " argument specifying the number of milliseconds to wait before abandoning \
the attempt to connect: ",
 StyleBox["connect(long timeoutMillis)", "MR"],
 ". You do not need to explicitly call ",
 StyleBox["connect()", "MR"],
 " on a link",
 "\[LongDash]",
 "it will be connected for you the first time you try to read something. You \
can use a call to ",
 StyleBox["connect()", "MR"],
 " to catch failures at a well-defined place, or if you want to use the \
automatic time out feature. Here is a code fragment that demonstrates how to \
implement a time out in ",
 StyleBox["connect()", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->10383],

Cell["\<\
KernelLink ml = null;
try {
\tml = MathLinkFactory.createKernelLink(\"-linkmode launch -linkname \
'c:\\\\program files\\\\wolfram research\\\\mathematica\\\\6.0\\\\mathkernel'\
\");
} catch (MathLinkException e) {
\tSystem.out.println(\"Link could not be created: \" + e.getMessage());
\treturn; // Or whatever is appropriate.
}

try {
\tconnect(10000); // Wait at most 10 seconds
} catch (MathLinkException e) {
\t// If the timeout expires, a MathLinkException will be thrown.
\tSystem.out.println(\"Failure to connect link: \" + e.getMessage());
\tml.close();
\treturn; // Or whatever is appropriate.
}\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->14945],

Cell[TextData[{
 "When you are finished with a link, call its ",
 StyleBox["close()", "MR"],
 " method. Although the finalizer for a link object will close the link, you \
cannot guarantee that the finalizer will be called in a timely fashion, or \
even at all, so you should always manually close a link when you are done."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->8909],

Cell[CellGroupData[{

Cell["Using Listen and Connect Modes", "Subsection",
 CellTags->{"jlug:6.5.0.0", "TableOfContents_1.6.5.1"},
 CellID->32209],

Cell[TextData[{
 "You can use the listen and connect linkmodes, instead of launch, if you \
want to connect to an already-running program. Using listen and connect \
linkmodes in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " works in the same way as with C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs. See the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Tutorial (",
 ButtonBox["http://library.wolfram.com/infocenter/TechNotes/174/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://library.wolfram.com/infocenter/TechNotes/174/"], None}],
 ") or ",
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
 " for more information. "
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->9758]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using a Remote Kernel", "Subsection",
 CellTags->{"jlug:6.5.0.0", "TableOfContents_1.6.5.1"},
 CellID->24221],

Cell[TextData[{
 "To attach a remote ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel to a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " program, open the link using the listen/connect style. On the remote Unix \
machine, launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and have it listen on a link by executing the following on a command \
line."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->18588],

Cell["\<\
math -mathlink -linkmode listen -linkname 1234 -linkprotocol tcpip\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->6422],

Cell[TextData[{
 "Note the use of the TCPIP ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " protocol above. The TCPIP protocol is an improved version of the TCP \
protocol that is only supported in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.0 and later. If you are launching ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.x, use ",
 StyleBox["tcp", "MR"],
 " as the protocol name instead of ",
 StyleBox["tcpip", "MR"],
 " (also in the line below)."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->24946],

Cell["Then in your Java program:", "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->27506],

Cell["\<\
KernelLink ml = MathLinkFactory.createKernelLink(\"-linkmode connect \
-linkprotocol tcpip -linkname 1234@remotemachinename\");\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->13030],

Cell[TextData[{
 "The drawback to the listen/connect technique is that you must manually log \
into the remote machine and launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can have the Java program automatically launch ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on the remote machine by using an ",
 StyleBox["rsh", "MR"],
 " or ",
 StyleBox["ssh", "MR"],
 " client program. Unix machines have ",
 StyleBox["rsh", "MR"],
 " and ",
 StyleBox["ssh", "MR"],
 " built in, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ships with the ",
 StyleBox["winrsh", "MR"],
 " client program for Windows. Here is an example of using ",
 StyleBox["winrsh", "MR"],
 " to launch and connect to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on a remote Unix machine."
}], "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->16413],

Cell["\<\
KernelLink ml = MathLinkFactory.createKernelLink(\"-linkmode listen \
-linkprotocol tcpip -linkname 1234\");
Runtime.exec(\"c:\\\\program files\\\\wolfram \
research\\\\mathematica\\\\6.0\\\\systemfiles\\\\frontend\\\\binaries\\\\\
windows\\\\winrsh -m -q -h -l YourUsername -'math -mathlink -linkmode connect \
-linkprotocol tcpip -linkname 1234@localmachinename'\");\
\>", "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->29168]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The MathLink Interface", "Section",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6"},
 CellID->29087],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " is the low-level interface that is the root of all link objects in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ". The methods in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " correspond roughly to a subset of those in the C-language ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API. Most programmers will deal instead with objects of type ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 ", a higher-level interface that extends ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and incorporates the assumption that the program on the other side of the \
link is a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->27681],

Cell[TextData[{
 "We will not have much to say here about most of these methods, as they \
behave like their C API counterparts in most respects. ",
 StyleBox["The JavaDoc help files are the main method-by-method documentation \
for all the J/Link classes and interfaces",
  FontSlant->"Italic"],
 ". They can be found in the ",
 StyleBox["JLink/Documentation/JavaDoc", "MR"],
 " directory. This section is provided mainly for those who want to skim a \
traditional printed listing."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->19964],

Cell[TextData[{
 "These are all public methods (the ",
 StyleBox["public", "MR"],
 " has been left off to keep lines short)."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->1340],

Cell[CellGroupData[{

Cell["Managing Links", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.1"},
 CellID->5686],

Cell["\<\
void close();

void connect() throws MathLinkException;

// Wait at most timeoutMillis for the connect to occur, then throw a \
MathLinkException
void connect(long timeoutMillis) throws MathLinkException;

//A synonym for connect. This is the newer name.
void activate() throws MathLinkException; \
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->6021]
}, Open  ]],

Cell[CellGroupData[{

Cell["Packet Functions", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.2"},
 CellID->11662],

Cell["\<\
//Does not throw exception because it will often be needed in a catch block.
void newPacket();

int nextPacket() throws MathLinkException;

void endPacket() throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->14721]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error Handling", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.3"},
 CellID->6064],

Cell["\<\
int error();

boolean clearError();

String errorMessage();

void setError(int err);\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->29309]
}, Open  ]],

Cell[CellGroupData[{

Cell["Link State", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.4"},
 CellID->20415],

Cell["boolean ready() throws MathLinkException;", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->17902]
}, Open  ]],

Cell[CellGroupData[{

Cell["Putting", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.5"},
 CellID->29873],

Cell[TextData[{
 "Putting expressions on the link is a bit different in Java than C because \
Java lets you overload functions. Thus, there is no need to have methods with \
names like the C functions ",
 Cell[BoxData[
  ButtonBox["MLPutInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLPutInteger"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MLPutDouble",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLPutDouble"]], "InlineFormula"],
 "; it suffices to have a single function named ",
 StyleBox["put()", "MR"],
 " that has different definitions for each argument type. The only exceptions \
to this are the few cases where the argument needs to be interpreted in a \
special way. For example, there are three \[OpenCurlyDoubleQuote]put\
\[CloseCurlyDoubleQuote] methods that take a single string argument: ",
 StyleBox["put()", "MR"],
 " (equivalent to the C-language function ",
 Cell[BoxData[
  ButtonBox["MLPutUCS2String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLPutUCS2String"]], "InlineFormula"],
 "), ",
 StyleBox["putSymbol()", "MR"],
 " (equivalent to ",
 Cell[BoxData[
  ButtonBox["MLPutUCS2Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLPutUCS2Symbol"]], "InlineFormula"],
 "), and ",
 StyleBox["putByteString()", "MR"],
 " (equivalent to ",
 Cell[BoxData[
  ButtonBox["MLPutByteString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLPutByteString"]], "InlineFormula"],
 ")."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->17124],

Cell[TextData[{
 "For numeric types, there are the following methods (there is no need to \
provide a ",
 StyleBox["put()", "MR"],
 " method for ",
 StyleBox["byte", "MR"],
 ", ",
 StyleBox["char", "MR"],
 ", and ",
 StyleBox["short", "MR"],
 " types, as these can be automatically promoted to ",
 StyleBox["int", "MR"],
 "):"
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->23941],

Cell["\<\
void put(int i) throws MathLinkException;

void put(long i) throws MathLinkException;

void put(double d) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->32745],

Cell["For strings and symbols:", "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->31762],

Cell["\<\
void put(String s) throws MathLinkException;

void putByteString(byte[] b) throws MathLinkException;

void putSymbol(String s) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->28423],

Cell[TextData[{
 "All the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " methods that put or get strings use Unicode, which is the native format \
for Java strings.."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->27531],

Cell[TextData[{
 "For booleans, a Java ",
 StyleBox["true", "MR"],
 " is sent as the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbol ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"], "MR"]], "InlineFormula"],
 " for Java ",
 StyleBox["false", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->4806],

Cell["void put(boolean b) throws MathLinkException;", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->12268],

Cell[TextData[{
 "There is also a ",
 StyleBox["put()", "MR"],
 " method for arbitrary Java objects. In the default implementation, this \
does not do anything very useful for most objects (what it does is send ",
 StyleBox["obj.toString()", "MR"],
 "). A handful of objects, however, have a meaningful representation to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". These are arrays, strings, ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects (discussed elsewhere), and instances of the so-called \
\[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote] classes (",
 StyleBox["Integer", "MR"],
 ", ",
 StyleBox["Double", "MR"],
 ", ",
 StyleBox["Character", "MR"],
 ", and so on), which hold single numeric values. Arrays are sent as lists, \
strings are sent as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " strings, and the wrapper classes are sent as their numeric value. (The \
last case is for complex numbers, which will be discussed later.)"
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->9318],

Cell["void put(Object obj) throws MathLinkException;", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->5602],

Cell[TextData[{
 "There is a special method for arrays that lets you specify the heads of the \
array in each dimension. The heads are passed as an array of strings. Note \
that unlike the C counterparts (",
 Cell[BoxData[
  ButtonBox["MLPutInteger32Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLPutInteger32Array"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MLPutReal64Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLPutReal64Array"]], "InlineFormula"],
 ", and so on), you do not have to specify the depth or dimensions because \
they can be inferred from the array itself:"
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->31907],

Cell["\<\
void put(Object array, String[] heads) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->24307],

Cell[TextData[{
 "For putting ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions:"
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->23481],

Cell["\<\
void putFunction(String f, int argCount) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->1012],

Cell["\<\
For transferring expressions from one link to another (the \
\[OpenCurlyQuote]this\[CloseCurlyQuote] link is the destination):\
\>", "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->21136],

Cell["\<\
void transferExpression(MathLink source) throws MathLinkException;

void transferToEndOfLoopbackLink(LoopbackLink source) throws \
MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->26630],

Cell["Low-level \[OpenCurlyDoubleQuote]textual interface\
\[CloseCurlyDoubleQuote]:", "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->24114],

Cell["\<\
void putNext(int type) throws MathLinkException;

void putArgCount(int argCount) throws MathLinkException;

void putSize(int size) throws MathLinkException;

int bytesToPut() throws MathLinkException;

void putData(byte[] data) throws MathLinkException;

void putData(byte[] data, int len) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->26809],

Cell["Flushing:", "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->4084],

Cell["void flush();", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->23556]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.6"},
 CellID->12290],

Cell[TextData[{
 "Because you cannot overload methods on the basis of return type, there is \
no catchall ",
 StyleBox["get()", "MR"],
 " method for reading from the link, as is the case with the ",
 StyleBox["put()", "MR"],
 " method. Instead, there are separate methods for each data type. Notice \
that unlike their counterparts in the C API, these methods return the actual \
data that was read, not an error code (exceptions are used for errors, as \
with all the methods)."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->21293],

Cell["\<\
int getInteger() throws MathLinkException;

long getLongInteger() throws MathLinkException;

double getDouble() throws MathLinkException;

String getString() throws MathLinkException;

byte[] getByteString(int missing) throws MathLinkException;

String getSymbol() throws MathLinkException;

boolean getBoolean() throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->29996],

Cell[TextData[{
 "Arrays of the nine basic types (",
 StyleBox["boolean", "MR"],
 ", ",
 StyleBox["byte", "MR"],
 ", ",
 StyleBox["char", "MR"],
 ", ",
 StyleBox["short", "MR"],
 ", ",
 StyleBox["int", "MR"],
 ", ",
 StyleBox["long", "MR"],
 ", ",
 StyleBox["float", "MR"],
 ", ",
 StyleBox["double", "MR"],
 ", ",
 StyleBox["String", "MR"],
 "), as well as complex numbers, can be read with a set of methods of the \
form ",
 StyleBox["getXXXArrayN()", "MR"],
 ", where ",
 StyleBox["XXX", "MR"],
 " is the data type and ",
 StyleBox["N", "MR"],
 " specifies the depth of the array. For each type there are two methods like \
the following examples for ",
 StyleBox["int", "MR"],
 ". There is no way to get the heads of the array using these functions (it \
will typically be \[OpenCurlyDoubleQuote]",
 StyleBox["List", "MR"],
 "\[CloseCurlyDoubleQuote] at every level). If you need to get the heads as \
well, you should use ",
 StyleBox["getExpr()", "MR"],
 " to read the expression as an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " and then examine it using the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " methods."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->29152],

Cell["\<\
int[] getIntArray1() throws MathLinkException;

int[][] getIntArray2() throws MathLinkException;

... and others for all the eight primitive types and String and the complex \
class\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->1054],

Cell[TextData[{
 "Note that you do not have to know exactly how deep the array is to use \
these functions. If you call, say, ",
 StyleBox["getFloatArray1()", "MR"],
 ", and what is actually on the link is a matrix of reals, then the data will \
be flattened into the requested depth (a one-dimensional array in this case). \
Unfortunately, if you do this you cannot determine what the original depth of \
the data was. If you call a function that expects an array of depth greater \
than the actual depth of the array on the link, it will throw a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->25345],

Cell[TextData[{
 "If you need to read an array of depth greater than 2 (but a maximum of 5) , \
you can use the ",
 StyleBox["getArray()", "MR"],
 " method. The ",
 StyleBox["getXXXArrayN()", "MR"],
 " methods discussed above are just convenience methods that use ",
 StyleBox["getArray()", "MR"],
 " internally. The ",
 StyleBox["type", "MR"],
 " argument must be one of ",
 StyleBox["TYPE_BOOLEAN, TYPE_BYTE, TYPE_CHAR, TYPE_SHORT, TYPE_INT, \
TYPE_LONG, TYPE_FLOAT, TYPE_DOUBLE, TYPE_STRING, TYPE_EXPR, TYPE_BIGINTEGER, \
TYPE_BIGDECIMAL, ", "MR"],
 "or ",
 StyleBox["TYPE_COMPLEX", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->14708],

Cell[TextData[{
 "Object getArray(int type, int depth) throws MathLinkException;\n\n// New in \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0:\nObject getArray(int type, int depth, String[] heads) throws \
MathLinkException;"
}], "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->248],

Cell[TextData[{
 "New in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0 is ",
 StyleBox["getArray(int type, int depth, String[] heads)", "MR"],
 ". It reads an array and also tells you the heads at each level. See the \
JavaDocs for more information."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->7491],

Cell[TextData[{
 "Unlike the C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API, there are no methods for \[OpenCurlyDoubleQuote]disowning\
\[CloseCurlyDoubleQuote] strings or arrays because this is not necessary. \
When you read a string or array off the link, your program gets its own copy \
of the data, so you can write into it if you desire (although Java strings \
are immutable)."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->13712],

Cell[TextData[{
 "The ",
 StyleBox["getFunction()", "MR"],
 " method needs to return two things: the head and the argument count. Thus, \
there is a special class called ",
 Cell[BoxData[
  ButtonBox["MLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MLFunction"]], "InlineFormula"],
 " that encapsulates both these pieces of information, and this is what ",
 StyleBox["getFunction()", "MR"],
 " returns. The ",
 Cell[BoxData[
  ButtonBox["MLFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MLFunction"]], "InlineFormula"],
 " class is documented later."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->5131],

Cell["\<\
MLFunction getFunction() throws MathLinkException;

// Returns the function's argument count. Throws MathLinkException if the \
function
// is not the specified one.
int checkFunction(String f) throws MathLinkException;

//Throws an exception if the incoming function does not have this head and \
arg count.
void checkFunctionWithArgCount(String f, int argCount) throws \
MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->30114],

Cell["\<\
These methods support the low-level interface for reading from a link.\
\>", "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->16439],

Cell["\<\
int getNext() throws MathLinkException;

int getType() throws MathLinkException;

int getArgCount() throws MathLinkException;

int bytesToGet() throws MathLinkException;

byte[] getData(int len) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->7958],

Cell[TextData[{
 "Reading ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects:"
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->24722],

Cell["\<\
public Expr getExpr() throws MathLinkException;

// Gets an expression off the link, then resets the link to the state
// prior to reading the expr. You can \"peek\" ahead without consuming \
anything
// off the link.
public Expr peekExpr() throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->29704]
}, Open  ]],

Cell[CellGroupData[{

Cell["Messages", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.7"},
 CellID->6995],

Cell[TextData[{
 "The messages referred to by the following functions are not ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " warning messages, but a low-level type of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " communication used mainly to send interrupt and abort requests. The ",
 StyleBox["getMessage()", "MR"],
 " and ",
 StyleBox["messageReady()", "MR"],
 " methods no longer function in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0 and later. You must use ",
 StyleBox["setMessageHandler()", "MR"],
 " if you want to receive messages from ",
 StyleBox["Mathematica.",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->1052],

Cell["\<\
int getMessage() throws MathLinkException;

void putMessage(int msg) throws MathLinkException;

boolean messageReady() throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->25269]
}, Open  ]],

Cell[CellGroupData[{

Cell["Marks", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.8"},
 CellID->7479],

Cell["\<\
long createMark() throws MathLinkException;

//Next two don't throw, since they are often used in cleanup operations in \
catch handlers.

void seekMark(long mark);

void destroyMark(long mark);\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->18238]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Class", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.9"},
 CellID->26423],

Cell[TextData[{
 "The ",
 StyleBox["setComplexClass()", "MR"],
 " method lets you assign the class that will be mapped to complex numbers in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". \[OpenCurlyDoubleQuote]Mapped\[CloseCurlyDoubleQuote] means that the",
 StyleBox[" put(Object)", "MR"],
 " method will send a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " complex number when you call it with an object of your complex class, and \
",
 StyleBox["getComplex()", "MR"],
 " will return an instance of this class. For further discussion about this \
subject and the restrictions on the classes that can be used as the complex \
class, see ",
 ButtonBox["Complex Numbers",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#26063"],
 "."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->27918],

Cell["\<\
public boolean setComplexClass(Class cls);

public Class getComplexClass();

public Object getComplex() throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->10866]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yield and Message Handlers", "Subsection",
 CellTags->{"jlug:6.6.0.0", "Null", "TableOfContents_1.6.6.10"},
 CellID->17659],

Cell[TextData[{
 "The ",
 StyleBox["setYieldFunction()", "MR"],
 " and ",
 StyleBox["addMessageHandler()", "MR"],
 " methods take a class, an object, and a method name as a string. The class \
is the class that contains the named method, and the object is the object of \
that class on which to call the method. Pass ",
 StyleBox["null", "MR"],
 " for the object if it is a static method. The signature of the method you \
use in ",
 StyleBox["setYieldFunction()", "MR"],
 " must be V(Z); for ",
 StyleBox["addMessageHandler()", "MR"],
 " it must be II(V). See ",
 ButtonBox["Threads, Blocking, and Yielding ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#189"],
 " for more information and examples."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->32498],

Cell["\<\
public boolean setYieldFunction(Class cls, Object obj, String methName);

public boolean addMessageHandler(Class cls, Object obj, String methName);

public boolean removeMessageHandler(String methName);\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->28486]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constants", "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.11"},
 CellID->21196],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " class also includes the full set of user-level constants from ",
 StyleBox["MathLink.h", "MR"],
 ". They have exactly the same names in Java as in C. In addition, there are \
some ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "-specific constants."
}], "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->7462],

Cell["\<\
static int ILLEGALPKT;
static int CALLPKT;
static int EVALUATEPKT;
static int RETURNPKT;
static int INPUTNAMEPKT;
static int ENTERTEXTPKT;
static int ENTEREXPRPKT;
static int OUTPUTNAMEPKT;
static int RETURNTEXTPKT;
static int RETURNEXPRPKT;
static int DISPLAYPKT;
static int DISPLAYENDPKT;
static int MESSAGEPKT;
static int TEXTPKT;
static int INPUTPKT;
static int INPUTSTRPKT;
static int MENUPKT;
static int SYNTAXPKT;
static int SUSPENDPKT;
static int RESUMEPKT;
static int BEGINDLGPKT;
static int ENDDLGPKT;
static int FIRSTUSERPKT;
static int LASTUSERPKT;

//These next two are unique to J/Link.
static int FEPKT;
static int EXPRESSIONPKT;

static int MLTERMINATEMESSAGE;
static int MLINTERRUPTMESSAGE;
static int MLABORTMESSAGE;

static int MLTKFUNC;
static int MLTKSTR;
static int MLTKSYM;
static int MLTKREAL;
static int MLTKINT;
static int MLTKERR;

//Constants for use in getArray()
static int TYPE_BOOLEAN;
static int TYPE_BYTE;
static int TYPE_CHAR;
static int TYPE_SHORT;
static int TYPE_INT;
static int TYPE_LONG;
static int TYPE_FLOAT;
static int TYPE_DOUBLE;
static int TYPE_STRING;
static int TYPE_BIGINTEGER;
static int TYPE_BIGDECIMAL;
static int TYPE_EXPR;
static int TYPE_COMPLEX;\
\>", "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->26633]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The KernelLink Interface", "Section",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7"},
 CellID->21948],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " is the interface that you will probably use for the links in your \
programs. These are all public methods, as is always the case with a Java \
interface. This section provides only a brief summary of the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods; it is intended mainly for those who want to skim a traditional \
printed listing. ",
 StyleBox["The JavaDoc help files are the main method-by-method documentation \
for all the J/Link classes and interfaces",
  FontSlant->"Italic"],
 ". They can be found in the ",
 StyleBox["JLink/Documentation/JavaDoc", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->25072],

Cell[CellGroupData[{

Cell["Evaluate", "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.1"},
 CellID->20426],

Cell[TextData[{
 "The ",
 StyleBox["evaluate()", "MR"],
 " method encapsulates the steps needed to put an expression to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a string or ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " and get the answer back as an expression. Internally, it uses an ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " for sending the expression. The answer comes back in a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 ", although the ",
 StyleBox["waitForAnswer()", "MR"],
 " method opens up the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 "\[LongDash]all you have to do is read out its contents. You should always \
use ",
 StyleBox["waitForAnswer()", "MR"],
 " or ",
 StyleBox["discardAnswer()", "MR"],
 " instead of spinning your own packet loop waiting for a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 ". See ",
 ButtonBox["The ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
  FontSlant->"Italic"],
 ButtonBox[" \[OpenCurlyDoubleQuote]Packet Loop\[CloseCurlyDoubleQuote]",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
 "."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->14606],

Cell["\<\
void evaluate(String s) throws MathLinkException;

void evaluate(Expr e) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->26173]
}, Open  ]],

Cell[CellGroupData[{

Cell["Waiting for the Result", "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.2"},
 CellID->24429],

Cell[TextData[{
 "Call ",
 StyleBox["waitForAnswer()", "MR"],
 " right after ",
 StyleBox["evaluate()", "MR"],
 " (or if you manually send calculations wrapped in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 "). It will read packets off the link until it encounters a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 ", which will hold the result. See ",
 ButtonBox["The ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
  FontSlant->"Italic"],
 ButtonBox[" \[OpenCurlyDoubleQuote]Packet Loop\[CloseCurlyDoubleQuote]",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#29426"],
 "."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->32404],

Cell["void waitForAnswer() throws MathLinkException;", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->6705],

Cell[TextData[{
 "The ",
 StyleBox["discardAnswer()", "MR"],
 " method just throws away all the results from the calculation, so the link \
will be ready for the next calculation. As you may have guessed, it is \
nothing more than ",
 StyleBox["waitForAnswer()", "MR"],
 " followed by ",
 StyleBox["newPacket()", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->20626],

Cell["void discardAnswer() throws MathLinkException;", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->29812]
}, Open  ]],

Cell[CellGroupData[{

Cell["The \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] Methods", \
"Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.3"},
 CellID->19375],

Cell[TextData[{
 "The next set of methods are extensions of ",
 StyleBox["evaluate()", "MR"],
 " that perform the put and the reading of the result. You do not call ",
 StyleBox["waitForAnswer()", "MR"],
 " and then read the result yourself. They also do not throw ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 "\[LongDash]if there is an error, they clean up for you and return ",
 StyleBox["null", "MR"],
 ". The \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] in their \
names indicates that the methods perform the entire process themselves. ",
 StyleBox["evaluateToInputForm()", "MR"],
 " returns a string formatted in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"], "MR"]], "InlineFormula"],
 " at the specified page width. Specify 0 for the page width to get ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"], "MR"]], "InlineFormula"],
 ". ",
 StyleBox["evaluateToOutputForm()", "MR"],
 " is exactly like ",
 StyleBox["evaluateToInputForm()", "MR"],
 " except that it returns a string formatted in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputForm"], "MR"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputForm"], "MR"]], "InlineFormula"],
 " results are more attractive for display to the user, but ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"], "MR"]], "InlineFormula"],
 " is required if you want to pass the string back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to be used in further computations. The ",
 StyleBox["evaluateToImage()", "MR"],
 " method will return a",
 StyleBox[" byte[]", "MR"],
 " of GIF data if you give it an expression that returns a graphic, for \
example, a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"], "MR"]], "InlineFormula"],
 " command. Pass 0 for the ",
 StyleBox["dpi", "MR"],
 ", ",
 StyleBox["int", "MR"],
 ", and ",
 StyleBox["width", "MR"],
 " arguments if you want their ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"], "MR"]], "InlineFormula"],
 " settings in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 StyleBox["evaluateToTypeset()", "MR"],
 " returns a ",
 StyleBox["byte[]", "MR"],
 " of GIF data of the result of the computation, typeset in either ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"], "MR"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"], "MR"]], "InlineFormula"],
 ". These methods are discussed in detail in ",
 ButtonBox["evaluateToImage() and evaluateToTypeset()",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#911"]
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->30093],

Cell["\<\
String evaluateToInputForm(String s, int pageWidth);
String evaluateToInputForm(Expr e, int pageWidth);

String evaluateToOutputForm(String s, int pageWidth);
String evaluateToOutputForm(Expr e, int pageWidth);

byte[] evaluateToImage(String s, int width, int height);
byte[] evaluateToImage(Expr e, int width, int height);
byte[] evaluateToImage(String s, int width, int height, int dpi, boolean \
useFrontEnd);
byte[] evaluateToImage(Expr e, int width, int height, int dpi, boolean \
useFrontEnd);

byte[] evaluateToTypeset(String s, int pageWidth, boolean useStdForm);
byte[] evaluateToTypeset(Expr e, int pageWidth, boolean useStdForm);

// Returns the exception that caused the most recent \"evaluateTo\" method to \
return null
Throwable getLastError();\
\>", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->16565]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sending Java Object References", "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.4"},
 CellID->16036],

Cell[TextData[{
 "If you want to send Java objects \[OpenCurlyDoubleQuote]by reference\
\[CloseCurlyDoubleQuote] to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " so that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code can call back into your Java runtime via the \
\[OpenCurlyDoubleQuote]installable Java\[CloseCurlyDoubleQuote] facility \
described in ",
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ", you must first call the ",
 StyleBox["enableObjectReferences()", "MR"],
 " method. This is described in ",
 ButtonBox["Sending Object References to ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#26222"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#26222"],
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->14736],

Cell["void enableObjectReferences() throws MathLinkException;", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->29141],

Cell[TextData[{
 "Like the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface, ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " has a ",
 StyleBox["put()", "MR"],
 " method that sends objects. The ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " version of this method only sends objects \[OpenCurlyDoubleQuote]by value.\
\[CloseCurlyDoubleQuote] The ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " version behaves just like the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " version for those objects that can be sent by value. In addition, though, \
it sends all other objects by reference. You must have called ",
 StyleBox["enableObjectReferences()", "MR"],
 " before calling ",
 StyleBox["put()", "MR"],
 " on an object that will be sent by reference. See ",
 ButtonBox["Sending Object References to ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#26222"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#26222"],
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->30814],

Cell["void put(Object obj) throws MathLinkException;", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->5994],

Cell[TextData[{
 "The next methods are for putting and getting objects by reference (you must \
have called ",
 StyleBox["enableObjectReferences()", "MR"],
 " to use these methods)."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->8256],

Cell["\<\
public void putReference(Object obj) throws MathLinkException;

Object getObject() throws MathLinkException;

// These two methods from the MathLink interface are enhanced to return \
MLTKOBJECT if a Java
// object reference is waiting to be read.
int getNext() throws MathLinkException;
int getType() throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->6652]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interrupting, Aborting, and Abandoning Evaluations", "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.5"},
 CellID->23936],

Cell[TextData[{
 "These methods are for aborting and interrupting evaluations. They are \
discussed in ",
 ButtonBox["Aborting and Interrupting Computations",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#19718"],
 "."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->30838],

Cell["\<\
void abortEvaluation();
void interruptEvaluation()\t
void abandonEvaluation();

void terminateKernel();\
\>", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->20482]
}, Open  ]],

Cell[CellGroupData[{

Cell["Support for PacketListeners", "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.6"},
 CellID->1355],

Cell[TextData[{
 "These methods support the registering and notification of ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " objects. They are discussed in ",
 ButtonBox["Using the PacketListener Interface",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8823"],
 "."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->21015],

Cell["\<\
void addPacketListener(PacketListener listener);
void removePacketListener(PacketListener listener);

boolean notifyPacketListeners(int pkt);\
\>", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->1131]
}, Open  ]],

Cell[CellGroupData[{

Cell["The handlePacket() Method (Advanced Users Only)", "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.7"},
 CellID->18230],

Cell[TextData[{
 "The ",
 StyleBox["handlePacket()", "MR"],
 " method is for very advanced users who are writing their own packet loop \
instead of calling ",
 StyleBox["waitForAnswer()", "MR"],
 ", ",
 StyleBox["discardAnswer()", "MR"],
 ", or any of the \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] \
methods. See the JavaDocs for more information."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->17841],

Cell["void handlePacket(int pkt) throws MathLinkException;", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->14625]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Methods Valid Only for \
\[OpenCurlyDoubleQuote]StdLinks\[CloseCurlyDoubleQuote]\
\>", "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.8"},
 CellID->2011],

Cell[TextData[{
 "Finally, there are some methods that are meaningful only in methods that \
are themselves called from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " via the \[OpenCurlyDoubleQuote]installable Java\[CloseCurlyDoubleQuote] \
functionality described in ",
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ". These methods are documented in ",
 ButtonBox["Writing Your Own Installable Java Classes",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#4680"],
 ". You will not use them if you are writing a program that uses ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a computational engine."
}], "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->32637],

Cell["\<\
public void print(String s);
public void message(String symtag, String[] args);
public void message(String symtag, String arg);
public void beginManual();
\t
public boolean wasInterrupted();
public void clearInterrupt();\
\>", "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->4186]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sending Computations and Reading Results", "Section",
 CellTags->{"2.8", "jlug:6.8.0.0", "TableOfContents_1.6.8"},
 CellID->21991],

Cell[CellGroupData[{

Cell[TextData[{
 " ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Packets"
}], "Subsection",
 CellTags->{"jlug:6.8.0.1", "TableOfContents_1.6.8.1"},
 CellID->32196],

Cell[TextData[{
 "Communication with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel generally takes place in the form of \
\[OpenCurlyDoubleQuote]packets.\[CloseCurlyDoubleQuote] A ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " packet is just a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function, albeit one from a set that is recognized and treated specially \
by ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". When you send something to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to be evaluated, you wrap it in a packet that tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that this is a request for something to be computed, and also tells \
something about how it is to be computed. All output you receive from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", including the result and any other side effect output like messages, ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output, and graphics, will also arrive wrapped in a packet. The type of \
packet tells you about the contents."
}], "Text",
 CellTags->"jlug:6.8.0.1",
 CellID->7783],

Cell[TextData[{
 "A ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program typically sends a computation to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " wrapped in a special packet, and then reads a succession of packets \
arriving from the kernel until the one containing the result of the \
computation arrives. Along the way, packets that do not contain the result \
can be either discarded without bothering to examine them or they can be \
\[OpenCurlyDoubleQuote]opened\[CloseCurlyDoubleQuote] and operated on. Such \
nonresult packets include ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextPacket"], "MR"]], "InlineFormula"],
 " expressions containing ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output, ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessagePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessagePacket"], "MR"]], "InlineFormula"],
 " expressions containing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " warning messages, ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DisplayPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DisplayPacket"], "MR"]], "InlineFormula"],
 " expressions containing PostScript, and several other types."
}], "Text",
 CellTags->"jlug:6.8.0.1",
 CellID->16828],

Cell[TextData[{
 "You can look at existing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " documentation for information on the various packet types for sending \
things to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and for what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sends back. In particular, you should look at this \
author\[CloseCurlyQuote]s ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Tutorial (",
 ButtonBox["http://library.wolfram.com/infocenter/TechNotes/174/",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://library.wolfram.com/infocenter/TechNotes/174/"], None}],
 "). For most uses, ",
 StyleBox["J/Lin",
  FontSlant->"Italic"],
 "k hides all the details of packet types and how to send and receive them. \
You only need to read about packet types if you want to do something beyond \
what the built-in behavior of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides. This can be useful for many programs."
}], "Text",
 CellTags->"jlug:6.8.0.1",
 CellID->7727]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " \[OpenCurlyDoubleQuote]Packet Loop",
 "\[CloseCurlyDoubleQuote]"
}], "Subsection",
 CellTags->{"jlug:6.8.0.2", "TableOfContents_1.6.8.2"},
 CellID->29426],

Cell[TextData[{
 "In a C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program, a typical code fragment for sending a computation to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and throwing away the result might look like this:"
}], "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->15871],

Cell["\<\
// C code
MLPutFunction(ml, \"EvaluatePacket\", 1);
MLPutFunction(ml, \"ToExpression\", 1);
MLPutString(ml, \"Needs[\\\"MyPackage`\\\"]\");
MLEndPacket(ml);
while (MLNextPacket(ml) != RETURNPKT)
\tMLNewPacket(ml);
MLNewPacket();\
\>", "Program",
 CellTags->"jlug:6.8.0.2",
 CellID->10697],

Cell[TextData[{
 "After sending the computation (wrapped in an ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 "), the code enters a ",
 StyleBox["while", "MR"],
 " loop that reads and discards packets until it encounters the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 ", which will contain the result (which will be the symbol ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Null",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Null"], "MR"]], "InlineFormula"],
 " here). Then it calls ",
 Cell[BoxData[
  ButtonBox["MLNewPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLNewPacket"]], "InlineFormula"],
 " once again to discard the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->17612],

Cell[TextData[{
 "A ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program will typically do this same basic operation many times, so ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " hides it within some higher-level methods in the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " interface. Here is the",
 StyleBox[" J/Link",
  FontSlant->"Italic"],
 " equivalent:"
}], "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->18703],

Cell["\<\
ml.evaluate(\"Needs[\\\"MyPackage`\\\"]\");
ml.discardAnswer();\
\>", "Program",
 CellTags->"jlug:6.8.0.2",
 CellID->11027],

Cell[TextData[{
 "The ",
 StyleBox["discardAnswer()", "MR"],
 " method discards all packets generated by the computation until it \
encounters the one containing the result, and then discards that one too. \
There is a related method, ",
 StyleBox["waitForAnswer()", "MR"],
 ", that discards everything up until the result is encountered. When ",
 StyleBox["waitForAnswer()", "MR"],
 " returns, the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 " has been opened and you are ready to read out its contents. You can \
probably guess that ",
 StyleBox["discardAnswer()", "MR"],
 " is just ",
 StyleBox["waitForAnswer()", "MR"],
 " followed by ",
 StyleBox["newPacket()", "MR"],
 ". "
}], "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->11408],

Cell[TextData[{
 "Not only is it a convenience to hide the packet loop within ",
 StyleBox["waitForAnswer()", "MR"],
 " and ",
 StyleBox["discardAnswer()", "MR"],
 ", it is necessary in some circumstances, since special packets may arrive \
that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " needs to handle internally. Although ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has ",
 StyleBox["nextPacket()", "MR"],
 " and ",
 StyleBox["newPacket()", "MR"],
 " methods, programmers should not write ",
 StyleBox["nextPacket()", "MR"],
 "/",
 StyleBox["newPacket()", "MR"],
 " loops like the one in the C code fragment above. Stick to calling ",
 StyleBox["waitForAnswer()", "MR"],
 ", ",
 StyleBox["discardAnswer()", "MR"],
 ", or using the \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] \
methods discussed in the next section. If you really need to know about all \
the packets that arrive in your program, use the ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface, discussed ",
 ButtonBox["later",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8823"],
 "."
}], "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->5545]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sending an Evaluation", "Subsection",
 CellTags->{"jlug:6.8.0.3", "TableOfContents_1.6.8.3"},
 CellID->9508],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides three main ways to send an expression to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for evaluation. All three techniques are demonstrated in the sample \
program in the section ",
 ButtonBox["Sample Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#30556"],
 "."
}], "Text",
 CellTags->"jlug:6.8.0.3",
 CellID->7185],

Cell[TextData[{
 "If you do not care about the result of the evaluation, or if you want the \
result to arrive in a form other than a string or image, you can use the ",
 StyleBox["evaluate()", "MR"],
 " method."
}], "Text",
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{36, Inherited}, {Inherited, Inherited}},
 CellTags->"jlug:6.8.0.3",
 CellID->30238],

Cell[TextData[{
 "You can send the expression \[OpenCurlyDoubleQuote]manually\
\[CloseCurlyDoubleQuote] like in a traditional C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program, by putting the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " head followed by the parts of the expression using low-level methods from \
the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface."
}], "Text",
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{36, Inherited}, {Inherited, Inherited}},
 CellTags->"jlug:6.8.0.3",
 CellID->24237],

Cell["\<\
If you want the result back as a string or image, you can use the \
\[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] methods, which \
provide a very high-level and convenient interface.\
\>", "Text",
 CellDingbat->"\[FilledSmallCircle]",
 CellMargins->{{36, Inherited}, {Inherited, Inherited}},
 CellTags->"jlug:6.8.0.3",
 CellID->26443],

Cell[TextData[{
 "The \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] methods are \
recommended for their convenience, if you want the result back in one of the \
formats that that they provide. These methods are discussed in ",
 ButtonBox["The \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] \
Methods",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#25472"],
 ". If the expression you want evaluated is in the form of a string or ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " (the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class is discussed in ",
 ButtonBox["Motivation for the Expr Class",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21763"],
 "), or can be easily converted into one, then you will want to use the ",
 StyleBox["evaluate()", "MR"],
 " method. If none of these convenience methods are appropriate, you can put \
the expression piece by piece similar to a traditional C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program. You do this by sending pieces in a structure that mirrors the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullForm"], "MR"]], "InlineFormula"],
 " of the expression. Here is a comparison of using these three techniques \
for sending the computation ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"], "MR"]], "InlineFormula"],
 StyleBox["[x^2 + y^2, {x,-1,1}, {y,-1,1}]", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:6.8.0.3",
 CellID->21313],

Cell[TextData[{
 StyleBox["String strResult = ml.evaluateToInputForm(\"", "DisplayMath"],
 "NIntegrate[x^2 + y^2, {x,-1,1}, {y,-1,1}]",
 StyleBox["\");\n\nml.evaluate(\"", "DisplayMath"],
 "NIntegrate[x^2 + y^2, {x,-1,1}, {y,-1,1}]",
 StyleBox["\");\nml.waitForAnswer();\ndouble doubleResult1 = ml.getDouble();\n\
\n// It is convenient to use indentation to indicate the structure\n\
ml.putFunction(\"EvaluatePacket\", 1);\n  ml.putFunction(\"NIntegrate\", 3);\n\
    ml.putFunction(\"Plus\", 2);\n      ml.putFunction(\"Power\", 2);\n       \
 ml.putSymbol(\"x\");\n        ml.put(2);\n      ml.putFunction(\"Power\", \
2);\n        ml.putSymbol(\"y\");\n        ml.put(2);\n    \
ml.putFunction(\"List\", 3);\n      ml.putSymbol(\"x\");\n      ml.put(-1);\n \
     ml.put(1);\n    ml.putFunction(\"List\", 3);\n      ml.putSymbol(\"y\");\
\n      ml.put(-1);\n      ml.put(1);\nml.endPacket();\nml.waitForAnswer();\n\
double doubleResult2 = ml.getDouble();", "DisplayMath"]
}], "Program",
 CellTags->"jlug:6.8.0.3",
 CellID->22501]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reading the Result", "Subsection",
 CellTags->{"jlug:6.8.0.4", "TableOfContents_1.6.8.4"},
 CellID->8850],

Cell[TextData[{
 "Before we dive into reading expressions from a link, keep in mind that if \
you just want the result back as a string or an image, then you are better \
off using one of the \
\[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] methods described \
in the next section. These methods send a computation and return the answer \
as a string or image, so you do not have to read it off the link yourself. \
Also, if you are not interested in the result, you will use ",
 StyleBox["discardAnswer()", "MR"],
 " and thus not have to bother reading it."
}], "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->25128],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides a number of methods for reading expressions from a link. Many of \
these methods are essentially identical to functions in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API, so to some extent you can learn how to use them by reading standard \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " documentation. You should also consult the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " JavaDoc files for more information. The reading methods generally begin \
with \[OpenCurlyDoubleQuote]get.\[CloseCurlyDoubleQuote] Examples are ",
 StyleBox["getInteger()", "MR"],
 ", ",
 StyleBox["getString()", "MR"],
 ", ",
 StyleBox["getFunction()", "MR"],
 ", and ",
 StyleBox["getDoubleArray2()", "MR"],
 ". There are also two type-testing methods that will tell you the type of \
the next thing waiting to be read off the link. These methods are ",
 StyleBox["getType()", "MR"],
 " and ",
 StyleBox["getNext()", "MR"],
 ". "
}], "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->2111],

Cell[TextData[{
 "As stated earlier, one method you will generally ",
 StyleBox["not",
  FontSlant->"Italic"],
 " call is ",
 StyleBox["nextPacket()", "MR"],
 ". When ",
 StyleBox["waitForAnswer()", "MR"],
 " returns, ",
 StyleBox["nextPacket()", "MR"],
 " has already been called internally on the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 " that holds the answer, so this final packet has already been \
\[OpenCurlyDoubleQuote]opened\[CloseCurlyDoubleQuote] and you can start \
reading its contents right away."
}], "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->23650],

Cell[TextData[{
 StyleBox["The vast majority of ",
  FontWeight->"Bold"],
 StyleBox["MathLinkException", "MR",
  FontWeight->"Bold"],
 StyleBox["s in ",
  FontWeight->"Bold"],
 StyleBox["J/Link",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" programs are caused by trying to read the incoming expression in \
a manner that is not appropriate for its type",
  FontWeight->"Bold"],
 ". A typical example is calling a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that you expect to return an integer, but you call it with \
incorrect arguments and therefore it returns unevaluated. You call ",
 StyleBox["getInteger()", "MR"],
 " to read an integer, but what is waiting on the link is a function like ",
 StyleBox["foo[badArgument]", "MR"],
 ". There are several general ways for dealing with problems like this. The \
first technique is to avoid the exception by using ",
 StyleBox["getNext()", "MR"],
 " to determine the type of the expression waiting. For example:"
}], "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->28149],

Cell[TextData[{
 StyleBox["ml.evaluate(\"", "DisplayMath"],
 "SomeFunction[]",
 StyleBox["\");\nml.waitForAnswer();\nint result;\nint type = ml.getNext();\n\
if (type == MathLink.MLTKINT) {\n\tresult = ml.getInteger();\n} else {\n\t// \
What you do here is up to you.\n\tSystem.out.println(\"Unexpected result: \" \
+ ml.getExpr().toString());\n\t// Throw away the packet contents.\n\t\
ml.newPacket();\n}", "DisplayMath"]
}], "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->11192],

Cell[TextData[{
 "A related technique is to read the result as an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " and examine it using the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " methods. The ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class is discussed in ",
 ButtonBox["Motivation for the Expr Class",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21763"],
 "."
}], "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->1454],

Cell[TextData[{
 StyleBox["ml.evaluate(\"", "DisplayMath"],
 "SomeFunction[]",
 StyleBox["\");\nml.waitForAnswer();\nint result;\nExpr e = ml.getExpr();\nif \
(e.integerQ()) {\n\tresult = e.asInt();\n} else {\n\t// What you do here is \
up to you.\n\tSystem.out.println(\"Unexpected result: \" + e.toString());\n}",
   "DisplayMath"]
}], "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->15869],

Cell[TextData[{
 "A final technique is to just go ahead and read the expression in the form \
that you expect, but catch and handle any ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ". (Remember that the entire code fragment below must be wrapped in a ",
 StyleBox["try", "MR"],
 "/",
 StyleBox["catch", "MR"],
 " block for ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " objects, but we are only seeing an inner ",
 StyleBox["try", "MR"],
 "/",
 StyleBox["catch", "MR"],
 " block for ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " objects known to be thrown during the read.)"
}], "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->681],

Cell[TextData[{
 StyleBox["ml.evaluate(\"", "DisplayMath"],
 "SomeFunction[]",
 StyleBox["\");\nml.waitForAnswer();\nint result;\ntry {\n\tresult = \
ml.getInteger();\n} catch (MathLinkException e) {\n\tml.clearError();\n\t\
System.out.println(\"Unexpected result: \" + ml.getExpr().toString());\n\t\
ml.newPacket(); // Not strictly necessary because of the getExpr() above\n}", 
  "DisplayMath"]
}], "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->27465],

Cell[TextData[{
 "Another tip for avoiding bugs in code that reads from a link is to use the \
",
 StyleBox["newPacket()", "MR"],
 " method liberally. ",
 StyleBox["A second very common cause of ",
  FontWeight->"Bold"],
 StyleBox["MathLinkException", "MR",
  FontWeight->"Bold"],
 StyleBox["s is forgetting to read the entire contents of a packet before \
going on to the next computation",
  FontWeight->"Bold"],
 ". The ",
 StyleBox["newPacket()", "MR"],
 " method causes the currently opened packet to be discarded. Another way of \
saying this is that it throws away all unread parts of the expression that is \
currently being read. It is a clean-up method that ensures that there are no \
remnants left over from the last packet when you go on to the next \
evaluation. Consider the following code:"
}], "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->20267],

Cell[TextData[{
 StyleBox["ml.evaluate(\"", "DisplayMath"],
 "SomeFunction[]",
 StyleBox["\");\nml.waitForAnswer();\nint result;\ntry {\n\tresult = \
ml.getInteger();\n} catch (MathLinkException e) {\n\tml.clearError();\n\t\
System.out.println(\"Unexpected result\");\n\t// Oops. Forgot to call \
newPacket() to throw away the contents.\n}\n\n// Boom. The next line causes a \
MathLinkException if the previous getInteger()\n// call failed, because \
nextPacket() will be called before the previous packet\n// was emptied.\n\
ml.evaluate(\"", "DisplayMath"],
 "AnotherFunction[]",
 StyleBox["\");\nml.discardAnswer();", "DisplayMath"]
}], "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->17713],

Cell[TextData[{
 "This code will cause a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " to be thrown at the indicated point if the previous call to ",
 StyleBox["getInteger()", "InlineCode"],
 " had failed because the programmer forgot to either finish reading the \
result or call ",
 StyleBox["newPacket()", "InlineCode"],
 ". Here is an even simpler example of this error:"
}], "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->19793],

Cell[TextData[{
 StyleBox["ml.evaluate(\"", "DisplayMath"],
 "SomeFunction[]",
 StyleBox["\");\nml.waitForAnswer();\n// Oops. Forgot to read or throw away \
the result.\n// Probably meant to call discardAnswer() instead of\n// \
waitForAnswer().\n\nml.evaluate(\"", "DisplayMath"],
 "AnotherFunction[]",
 StyleBox["\");\nml.discardAnswer();   // MathLinkException here!", 
  "DisplayMath"]
}], "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->18634]
}, Open  ]],

Cell[CellGroupData[{

Cell["The \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] Methods", \
"Subsection",
 CellTags->{"jlug:6.8.0.5", "TableOfContents_1.6.8.5"},
 CellID->25472],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides another set of convenience methods that hide the packet loop \
within them. These methods perform the entire procedure of sending something \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and returning the result in one form or another. They have names that \
begin with \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] to \
indicate that they actually return the result, rather than merely send it, as \
with the ",
 StyleBox["evaluate()", "MR"],
 " method."
}], "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->20972],

Cell[TextData[{
 StyleBox["String evaluateToInputForm(String s,int pageWidth);\nString \
evaluateToInputForm(Expr e,int pageWidth);\n\nString \
evaluateToOutputForm(String s,int pageWidth);\nString \
evaluateToOutputForm(Expr e,int pageWidth);\n\n", "DisplayMath"],
 "byte[] evaluateToImage(String s, int width, int height);\nbyte[] \
evaluateToImage(Expr e, int width, int height);\nbyte[] \
evaluateToImage(String s, int width, int height, int dpi, boolean useFE);\n\
byte[] evaluateToImage(Expr e, int width, int height, int dpi, boolean \
useFE);\n\nbyte[] evaluateToTypeset(String s, int width, boolean useStdForm);\
\nbyte[] evaluateToTypeset(Expr e, int width, boolean useStdForm);"
}], "Program",
 CellTags->"jlug:6.8.0.5",
 CellID->22830],

Cell[TextData[{
 "We will only discuss ",
 StyleBox["evaluateToInputForm()", "MR"],
 " and ",
 StyleBox["evaluateToOutputForm()", "MR"],
 " in this section, deferring consideration of ",
 StyleBox["evaluateToImage()", "MR"],
 " and ",
 StyleBox["evaluateToTypeset()", "MR"],
 " until the section ",
 ButtonBox["evaluateToImage() and evaluateToTypeset()",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#911"],
 ", \[OpenCurlyDoubleQuote]Graphics and Typeset Output.\
\[CloseCurlyDoubleQuote]  The ",
 StyleBox["evaluateToInputForm()", "MR"],
 " and ",
 StyleBox["evaluateToOutputForm()", "MR"],
 " methods encapsulate the very common need of sending some code as a string \
and getting the result back as a formatted string. They differ only in \
whether the string is formatted in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"], "MR"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputForm"], "MR"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputForm"], "MR"]], "InlineFormula"],
 " is good when you want to display the string to the user, and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"], "MR"]], "InlineFormula"],
 " is good if you need to send the expression back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " or if you need to save it to file or splice it into another expression. \
These methods take a ",
 StyleBox["pageWidth", "MR"],
 " argument to specify how many character widths you want the maximum line \
length to be. Pass in 0 for a page width of infinity."
}], "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->24901],

Cell[TextData[{
 "The ",
 StyleBox["evaluateTo", "MR"],
 " methods do not throw a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ". Instead, they return ",
 StyleBox["null", "MR"],
 " to indicate that a problem occurred. This is not very likely unless there \
is a serious problem, such as if the kernel has unexpectedly quit. In the \
event that ",
 StyleBox["null", "MR"],
 " is returned from one of these methods, you can call ",
 StyleBox["getLastError()", "MR"],
 " to get the ",
 StyleBox["Throwable", "MR"],
 " object that represents the exception thrown to cause the unexpected \
result. Generally, it will be a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ", but there are some other rare cases (like an ",
 StyleBox["OutOfMemoryError", "MR"],
 " if an image was returned that would have been too big to handle)."
}], "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->28442],

Cell[TextData[StyleBox["// Give the (caught) exception that prevented a \
normal return from the last\n// call to an \"evaluateTo\" method.\nThrowable \
getLastError();", "DisplayMath"]], "Program",
 CellTags->"jlug:6.8.0.5",
 CellID->5177],

Cell[TextData[{
 "All the ",
 StyleBox["evaluateTo", "MR"],
 " methods take the input to evaluate in the form of a string or an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ". Although a full discussion of the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class is deferred until ",
 ButtonBox["Motivation for the Expr Class",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21763"],
 ", we will briefly discuss how and why you might want to send the input as \
an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ". It is often convenient to specify ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input as a string, particularly if it is taken directly from a user, such \
as the contents of a text field. There are times, though, when it is \
difficult or unwieldy to work with strings. This is particularly true if the \
expression to evaluate is built up programmatically, or if it is being read \
off one link to be written onto the link to the kernel. One way to deal with \
this circumstance is to forgo the convenience of using, say, ",
 StyleBox["evaluateToOutputForm()", "MR"],
 " and instead hand-code the entire operation of sending the input so that \
the answer will come back formatted in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputForm"], "MR"]], "InlineFormula"],
 ". You would have to send the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " head and use the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"], "MR"]], "InlineFormula"],
 " function to get the output as a string:"
}], "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->13877],

Cell["\<\
// This duplicates the following:
// String output = ml.evaluateToOutputForm(\"Integrate[5 x^n a^x, x]\", 0);

// As an expression, we send ToString[Integrate[5 x^n a^x, x], \
PageWidth->Infinity]
ml.putFunction(\"EvaluatePacket\", 1);
    ml.putFunction(\"ToString\", 2);
\tml.putFunction(\"Integrate\", 2);
\t      ml.putFunction(\"Times\", 3);
\t          ml.put(5);
\t          ml.putFunction(\"Power\", 2);
\t              ml.putSymbol(\"x\");
\t              ml.putSymbol(\"n\");
\t          ml.putFunction(\"Power\", 2);
\t              ml.putSymbol(\"a\");
\t              ml.putSymbol(\"x\");
\t      ml.putSymbol(\"x\");
\t   ml.putFunction(\"Rule\", 2);
\t      ml.putSymbol(\"PageWidth\");
\t      ml.putSymbol(\"x\");
ml.endPacket();
ml.waitForAnswer();
String output = ml.getString();\
\>", "Program",
 CellTags->"jlug:6.8.0.5",
 CellID->25770],

Cell[TextData[{
 "This version is considerably more verbose, but most of the code comes from \
our deliberate decision to send the expression piece-by-piece, not as a \
single string. There are a few extra lines that ensure that the answer comes \
back as a properly formatted string and that read the result from the link. \
It is no great loss to have to do it all by hand. But what if you wanted to \
do the equivalent with ",
 StyleBox["evaluateToTypeset()", "MR"],
 "? Most programmers would have no idea how to perform all the work to get \
the answer in the desired form. If all the ",
 StyleBox["evaluateTo", "MR"],
 " methods took only strings, then ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programmers would have to either compose all their input as strings or \
figure out the difficult steps that are already handled for them by the \
internals of the various ",
 StyleBox["evaluateTo", "MR"],
 " methods."
}], "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->702],

Cell[TextData[{
 "The solution to this is to allow ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " arguments as an alternative to strings. Although ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " has a set of constructors, the easiest way to create a complicated one is \
to build the expression on a loopback link and read it off the link as an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ". You can then pass that ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " to the desired ",
 StyleBox["evaluateTo", "MR"],
 " method:"
}], "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->14364],

Cell["\<\
LoopbackLink loop = MathLinkFactory.createLoopbackLink();

// Create the expression EvaluatePacket[Integrate[5 x^n a^x, x]] on the \
loopback link
loop.putFunction(\"Integrate\", 2);
\tloop.putFunction(\"Times\", 3);
\t\tloop.put(5);
\t\tloop.putFunction(\"Power\", 2);
\t\t\tloop.putSymbol(\"x\");
\t\t\tloop.putSymbol(\"n\");
\t\tloop.putFunction(\"Power\", 2);
\t\t\tloop.putSymbol(\"a\");
\t\t\tloop.putSymbol(\"x\");
    loop.putSymbol(\"x\");
loop.endPacket();

// Now read the Expr off the loopback link
Expr e = loop.getExpr();
// We are done with the loopback link now.
loop.close();
String result = ml.evaluateToOutputForm(e, 0);
e.dispose();\
\>", "Program",
 CellTags->"jlug:6.8.0.5",
 CellID->1381],

Cell[TextData[{
 "In this way, you can build expressions manually with a series of \
\[OpenCurlyDoubleQuote]put\[CloseCurlyDoubleQuote] calls and still have the \
convenience of using the high-level ",
 StyleBox["evaluateTo", "MR"],
 " methods."
}], "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->16590]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using the PacketListener Interface", "Subsection",
 CellTags->{"jlug:6.8.0.6", "TableOfContents_1.6.8.6"},
 CellID->8823],

Cell[TextData[{
 "A central component of a standard C ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program is a packet-reading loop, which typically consists of calling the \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API functions ",
 Cell[BoxData[
  ButtonBox["MLNextPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLNextPacket"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MLNewPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/c/MLNewPacket"]], "InlineFormula"],
 " until a desired packet is encountered. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs will typically not include such a loop\[LongDash]instead, you \
call the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods ",
 StyleBox["waitForAnswer()", "MR"],
 ", ",
 StyleBox["discardAnswer()", "MR"],
 ", or one of the \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] \
methods, which hide the packet loop within them. In some cases, though, \
programmers will want to observe and/or operate on the incoming flow of \
packets. A typical example would be to display ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output or messages generated by a computation. These outputs are side \
effects of a computation and not part of the \[OpenCurlyDoubleQuote]answer,\
\[CloseCurlyDoubleQuote] and they are normally discarded by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s internal packet loop."
}], "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->2237],

Cell[TextData[{
 "To accommodate this need, ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " objects fire a ",
 Cell[BoxData[
  ButtonBox["PacketArrivedEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketArrivedEvent"]], 
  "InlineFormula"],
 " when the internal packet loop reads a packet (that is, right after ",
 StyleBox["nextPacket()", "MR"],
 " has been called). You can register your interest in receiving \
notifications when packets arrive by creating a class that implements the ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface and registering it with the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " object. This event notification is done according to the standard Java \
design pattern for events and event listeners. You create a class that \
implements ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 ", and then call the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " method ",
 StyleBox["addPacketListener()", "MR"],
 " to register this object to receive notifications."
}], "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->8023],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface contains only one method, ",
 StyleBox["packetArrived()", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->32179],

Cell["\<\
public boolean packetArrived(PacketArrivedEvent evt) throws \
MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.8.0.6",
 CellID->16595],

Cell[TextData[{
 "Your ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " object will have its ",
 StyleBox["packetArrived()", "MR"],
 " method called for every incoming packet. At the time ",
 StyleBox["packetArrived()", "MR"],
 " is called, the packet has been opened with ",
 StyleBox["nextPacket()", "MR"],
 ". Your code can begin reading the packet contents. The argument to ",
 StyleBox["packetArrived()", "MR"],
 " is a ",
 Cell[BoxData[
  ButtonBox["PacketArrivedEvent",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketArrivedEvent"]], 
  "InlineFormula"],
 ", from which you can extract the link and the packet type (see the example \
below)."
}], "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->20169],

Cell[TextData[{
 "The really nice thing about your ",
 StyleBox["packetArrived()", "MR"],
 " implementation is that you can consume or ignore the packet ",
 StyleBox["without affecting the internal packet loop in any way",
  FontSlant->"Italic"],
 ". You do not need to be concerned about interfering with any other ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " or  ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s own internal handling of packets. You can read all, \
some, or none of the contents of any packet."
}], "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->2327],

Cell[TextData[{
 "The ",
 StyleBox["packetArrived()", "MR"],
 " method returns a boolean to indicate whether you want to prevent ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s internal code from seeing the packet. This very \
advanced option lets you completely override ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s own handling of packets. At this time, the internals of \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s packet handling are undocumented, so programmers will \
have no use for the override ability. Your ",
 StyleBox["packetArrived()", "MR"],
 " method should always return ",
 StyleBox["true", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->12042],

Cell[TextData[{
 "Here is a sample ",
 StyleBox["packetArrived()", "MR"],
 " implementation that looks only for ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextPacket"], "MR"]], "InlineFormula"],
 " expressions, printing their contents to the ",
 StyleBox["System.out", "MR"],
 " stream."
}], "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->31310],

Cell["\<\
public boolean packetArrived(PacketArrivedEvent evt) throws MathLinkException \
{
\tif (evt.getPktType() == MathLink.TEXTPKT) {
\t\tKernelLink ml = (KernelLink) evt.getSource();
\t\tSystem.out.println(ml.getString()); 
\t}
\treturn true;
}\
\>", "Program",
 CellTags->"jlug:6.8.0.6",
 CellID->28182],

Cell[TextData[{
 "This design pattern of using an event listener that gets a callback for \
every packet received allows your program to be very flexible in its handling \
of packets. You do not have to significantly change your program to implement \
different policies, such as ignoring non-result packets, printing them to the \
",
 StyleBox["System.out", "MR"],
 " stream, writing them to a file, displaying them in a window, and so on. \
Just slot in different ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " objects with different behavior, and leave all the program logic \
unchanged. You can use as many ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " objects as you want."
}], "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->11058]
}, Open  ]],

Cell[CellGroupData[{

Cell["The PacketPrinter Class for Debugging", "Subsection",
 CellTags->{"jlug:6.8.0.7", "TableOfContents_1.6.8.7"},
 CellID->7926],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides one implementation of the ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface that is designed to simplify debugging ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs. The ",
 Cell[BoxData[
  ButtonBox["PacketPrinter",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketPrinter"]], "InlineFormula"],
 " class prints out the contents of each packet on a stream you specify. Here \
is the constructor:"
}], "Text",
 CellTags->"jlug:6.8.0.7",
 CellID->9487],

Cell["public PacketPrinter(PrintStream strm);", "Program",
 CellTags->"jlug:6.8.0.7",
 CellID->1670],

Cell["Here is a code fragment showing a typical use:", "Text",
 CellTags->"jlug:6.8.0.7",
 CellID->32528],

Cell["\<\
PacketListener stdoutPrinter = new PacketPrinter(System.out);
ml.addPacketListener(stdoutPrinter);
...
String result = ml.evaluateToOutputForm(\"Integrate[x^n a^x, x]\", 72);\
\>", "Program",
 CellTags->"jlug:6.8.0.7",
 CellID->5651],

Cell[TextData[{
 "It is especially useful to see ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " messages that were generated during the computation. Using a ",
 Cell[BoxData[
  ButtonBox["PacketPrinter",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketPrinter"]], "InlineFormula"],
 " to see exactly what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is sending back is an extremely useful debugging technique. It is no \
exaggeration to say that ",
 StyleBox["the vast majority of problems with ",
  FontWeight->"Bold"],
 StyleBox["J/Link",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" programs can be identified simply by adding one line of code that \
creates and installs a ",
  FontWeight->"Bold"],
 StyleBox["PacketPrinter", "MR",
  FontWeight->"Bold"],
 ". When you are satisfied that your program is behaving as expected, just \
take out the ",
 StyleBox["addPacketListener()", "MR"],
 " line. No other code changes are required."
}], "Text",
 CellTags->"jlug:6.8.0.7",
 CellID->2258]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using EnterTextPacket", "Subsection",
 CellTags->{"jlug:6.8.0.8", "TableOfContents_1.6.8.8"},
 CellID->7213],

Cell[TextData[{
 "As noted earlier, when you send something to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to be evaluated, you wrap it in a packet. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports three different packets for sending computations, but the two \
that are most important are ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EnterTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterTextPacket"], "MR"]], "InlineFormula"],
 ". We have used ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 " manually in a few code fragments, and they are used internally by the ",
 StyleBox["evaluate()", "MR"],
 " and ",
 StyleBox["evaluateTo", "MR"],
 " methods. When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " receives something wrapped in ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 ", it evaluates it and sends the result back in a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 ". Side effects like ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output and PostScript for graphics are sent in their own packets prior to \
the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnPacket"], "MR"]], "InlineFormula"],
 ". In contrast, when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " receives something in an ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EnterTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterTextPacket"], "MR"]], "InlineFormula"],
 ", it runs its full \[OpenCurlyDoubleQuote]main \
loop,\[CloseCurlyDoubleQuote] which includes, among other things, generating \
",
 Cell[BoxData[
  StyleBox[
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "MR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "MR"]], "InlineFormula"],
 " prompts, applying the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Pre",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Pre"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PrePrint"], "MR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Post",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Post"], "MR"]], "InlineFormula"],
 " functions, and keeping an input and output history. This is how the \
notebook front end uses the kernel. You might want to look at the more \
detailed discussion of the properties of these packets in this author\
\[CloseCurlyQuote]s ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Tutorial, available on ",
 StyleBox["MathSource",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->9860],

Cell[TextData[{
 "If you are using the kernel as a computational engine, you probably want to \
use ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 ". Use ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EnterTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterTextPacket"], "MR"]], "InlineFormula"],
 " instead when you want to present your users with an interactive \
\[OpenCurlyDoubleQuote]session\[CloseCurlyDoubleQuote] where previous outputs \
can be retrieved by number or ",
 StyleBox["%", "MR"],
 ". An example is if you are providing functionality similar to the notebook \
front end, or the kernel\[CloseCurlyQuote]s stand alone \
\[OpenCurlyDoubleQuote]terminal\[CloseCurlyDoubleQuote] interface. The use of \
",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EnterTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterTextPacket"], "MR"]], "InlineFormula"],
 " as the wrapper packet for computations is not as well supported in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", since it will be used much more rarely. You cannot use the ",
 StyleBox["evaluateTo", "MR"],
 " methods, since they use ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "MR"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->25783],

Cell[TextData[{
 "The packet sequence you get in return from an ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EnterTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterTextPacket"], "MR"]], "InlineFormula"],
 " computation will not always have a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnTextPacket"], "MR"]], "InlineFormula"],
 " in it. If the computation returns ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Null",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Null"], "MR"]], "InlineFormula"],
 ", or if there is a syntax error, no ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnTextPacket"], "MR"]], "InlineFormula"],
 " will be sent. The final packet that will always be sent is ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNamePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNamePacket"], "MR"]], "InlineFormula"],
 ", containing the input prompt to use for the next computation. This means \
that the ",
 StyleBox["waitForAnswer()", "MR"],
 " method must accommodate two situations: for most computations, the answer \
will be in a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnTextPacket"], "MR"]], "InlineFormula"],
 ", but for some computations, there will be no answer at all. Therefore ",
 StyleBox["waitForAnswer()", "MR"],
 " returns when either a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnTextPacket"], "MR"]], "InlineFormula"],
 " or an ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNamePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNamePacket"], "MR"]], "InlineFormula"],
 " is encountered. This is why ",
 StyleBox["waitForAnswer()", "MR"],
 " returns an ",
 StyleBox["int", "MR"],
 "\[LongDash]this is the packet type that caused ",
 StyleBox["waitForAnswer()", "MR"],
 " to return. If your call to ",
 StyleBox["waitForAnswer()", "MR"],
 " returns ",
 StyleBox["MathLink.RETURNTEXTPKT", "MR"],
 ", then you can read the answer (it will be a string), and then you call ",
 StyleBox["waitForAnswer()", "MR"],
 " again to receive the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNamePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNamePacket"], "MR"]], "InlineFormula"],
 " that will come afterwards. You can read the prompt string with ",
 StyleBox["getString()", "MR"],
 " (it will be something like \[OpenCurlyDoubleQuote]In[1]:=\
\[CloseCurlyDoubleQuote]). If the original ",
 StyleBox["waitForAnswer()", "MR"],
 " returns ",
 StyleBox["MathLink.INPUTNAMEPKT", "MR"],
 ", then there was no result to display, and you can just call ",
 StyleBox["getString()", "MR"],
 " to read the input prompt string. In the first case, where a ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnTextPacket"], "MR"]], "InlineFormula"],
 " does come, instead of calling ",
 StyleBox["waitForAnswer()", "MR"],
 " a second time to read off the subsequent ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNamePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNamePacket"], "MR"]], "InlineFormula"],
 ", you could simply call ",
 StyleBox["nextPacket()", "MR"],
 ", because the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNamePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNamePacket"], "MR"]], "InlineFormula"],
 " will always immediately follow the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnTextPacket"], "MR"]], "InlineFormula"],
 ". Although it might look a little weird, calling ",
 StyleBox["waitForAnswer()", "MR"],
 " has the advantage of triggering notification of all registered ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " objects, which would not happen if you manually read a packet with ",
 StyleBox["nextPacket()", "MR"],
 ". In other words, it is better to let all packets be read by ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s internal loop."
}], "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->21286],

Cell["Here is an example:", "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->2742],

Cell["\<\
String inputString = getStringFromUser();
ml.putFunction(\"EnterTextPacket\", 1);
ml.put(inputString);
String result = null;
int pkt = ml.waitForAnswer();
if (pkt == MathLink.RETURNTEXTPKT) {
\t// Mathematica computation returned a non-Null result, so a RETURNTEXTPKT
\t// was generated. Read its contents (a string).
\tresult = ml.getString();
\t// Now call waitForAnswer() again, which will return after opening the
\t// InputNamePacket that will always follow. It is essentially
\t// nothing more than a call to nextPacket() in this circumstance:
\tml.waitForAnswer();
}
// At this point, a call to waitForAnswer() has returned \
MathLink.INPUTNAMEPKT,
// so we just read out the contents, which is the next input prompt.
String nextPrompt = ml.getString();\
\>", "Program",
 CellTags->"jlug:6.8.0.8",
 CellID->8610],

Cell[TextData[{
 "You will probably want to use a ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " when you are using ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EnterTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterTextPacket"], "MR"]], "InlineFormula"],
 ", because you probably want to show your users the full stream of output \
arriving from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", which might include messages and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"], "MR"]], "InlineFormula"],
 " output. Your ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " implementation could write the incoming packets to your input/output \
session window. In fact, if you have such a ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 ", you might want to let it handle ",
 StyleBox["all",
  FontSlant->"Italic"],
 " output, including the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReturnTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReturnTextPacket"], "MR"]], "InlineFormula"],
 " containing the result and the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNamePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNamePacket"], "MR"]], "InlineFormula"],
 " containing the next prompt. Then you would just call ",
 StyleBox["discardAnswer()", "MR"],
 " in your main program and let your ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " handle everything."
}], "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->4472]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Handling MathLinkExceptions", "Section",
 CellTags->{"2.9", "jlug:6.9.0.0", "TableOfContents_1.6.9"},
 CellID->10040],

Cell[TextData[{
 "Most of the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods throw a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " if a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " error occurs. This is in contrast to the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " C API, where functions return an error code. The methods that do not throw \
a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " are generally ones that will often need to be used within a ",
 StyleBox["catch", "MR"],
 " block handling a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " that had already been thrown. If these methods threw their own exceptions, \
then you would need to nest another ",
 StyleBox["try/catch", "MR"],
 " block within the ",
 StyleBox["catch", "MR"],
 " block."
}], "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->9313],

Cell[TextData[{
 "A well-formed ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " program will typically not throw a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " except in the case of fatal ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " errors, such as the kernel unexpectedly quitting. What is meant by \
\[OpenCurlyDoubleQuote]well-formed\[CloseCurlyDoubleQuote] is that you do not \
make any overt mistakes when putting or getting expressions, such as \
specifying an argument count of three in a ",
 StyleBox["putFunction()", "MR"],
 " call but only sending two, or calling ",
 StyleBox["nextPacket()", "MR"],
 " before you have finished reading the contents of the current packet. The \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " API helps you avoid such mistakes by providing high-level functions like \
",
 StyleBox["waitForAnswer()", "MR"],
 " and ",
 StyleBox["evaluateToOutputForm()", "MR"],
 " that hide the low-level interaction with the link, but in all but the most \
trivial ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs it is still possible to make such errors. Just remember that the \
vast majority of ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " objects thrown represent logic errors in the code of the program, not user \
errors or runtime anomalies. They are just bugs to which the programmer needs \
to be alerted so that they can be fixed."
}], "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->875],

Cell[TextData[{
 "In a small, well-formed ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " program, you may be able to put a lot of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " calls, perhaps even the entire program, within a single ",
 StyleBox["try/catch", "MR"],
 " block because there is no need to know exactly what the program was doing \
when the error occurred\[LongDash]all you are going to do is print a message \
and exit. The example program in the section ",
 ButtonBox["Sample Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#30556"],
 " has this structure. Many ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programs will need to be a little more refined in their treatment of ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " objects than just quitting. No matter what type of program you are \
writing, it is strongly recommended that while you are developing the \
program, you use ",
 StyleBox["try/catch", "MR"],
 " blocks in a fine-grained way (that is, only wrapping small, meaningful \
units of code in each ",
 StyleBox["try/catch", "MR"],
 " block), and always put code in your ",
 StyleBox["catch", "MR"],
 " block that prints a message or alerts you in some way. Many hours of \
debugging have been wasted because programmers did not realize a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " error had occurred, or they incorrectly identified the region of code \
where it happened."
}], "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->20072],

Cell[TextData[{
 "Here is a sample of how to handle a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " in the case where you want to try to recover. The first thing is to call \
",
 StyleBox["clearError()", "MR"],
 ", as other ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " calls will fail until the error state is cleared. If ",
 StyleBox["clearError()", "MR"],
 " returns ",
 StyleBox["false", "MR"],
 " then there is nothing to do but close the link. An example of the type of \
error that ",
 StyleBox["clearError()", "MR"],
 " will fix is the very common mistake of calling ",
 StyleBox["nextPacket()", "MR"],
 " before the current packet has been completely read. After ",
 StyleBox["clearError()", "MR"],
 " is called, the link is reset to the state it was in before the offending \
",
 StyleBox["nextPacket()", "MR"],
 ". You can then read the rest of the current packet or call ",
 StyleBox["newPacket()", "MR"],
 " to throw it away. Another example of a class of errors where ",
 StyleBox["clearError()", "MR"],
 " will work is calling an incorrect \[OpenCurlyDoubleQuote]get\
\[CloseCurlyDoubleQuote] method for the type of data waiting on the link\
\[LongDash]for example, calling ",
 StyleBox["getFunction()", "MR"],
 " when an integer is waiting. After calling ",
 StyleBox["clearError()", "MR"],
 ", you can read the integer."
}], "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->12818],

Cell["\<\
try {
\t...
} catch (MathLinkException e) {
\tSystem.err.println(e.toString());
\tif (ml.clearError() != true)\t{
\t\tSystem.err.println(\"MathLinkException was unrecoverable; closing \
link.\");
\t\tml.close();
\t\treturn;  // Or whatever cleanup is appropriate
\t}
\t// How you respond after clearError is up to you.
}\
\>", "Program",
 CellTags->"jlug:6.9.0.0",
 CellID->610],

Cell[TextData[{
 "What you do in your ",
 StyleBox["catch", "MR"],
 " block after calling ",
 StyleBox["clearError()", "MR"],
 " will depend on what you were doing when the exception was thrown. About \
the only useful general guideline we can provide is that if you are reading \
from the link when the exception is thrown, call ",
 StyleBox["newPacket", "MR"],
 StyleBox["()", "MR"],
 " to abandon the rest of the packet. At least then you will know that you \
are ready to read a fresh packet, even if you have lost the contents of the \
previous packet."
}], "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->1017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " has a few useful methods that will tell you about the cause of the \
exception. The ",
 StyleBox["getErrCode()", "MR"],
 " method will give you the internal ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " error code, which can be looked up in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " documentation. It is probably more useful to get the internal message \
associated with the error, which is given by ",
 StyleBox["getMessage()", "MR"],
 ". The ",
 StyleBox["toString()", "MR"],
 " method gives you all this information, and will be the most useful output \
for debugging."
}], "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->14932],

Cell["\<\
// Some useful MathLinkException methods.
public int getErrCode();
public String getMessage();
public String toString();
public Throwable getCause();\
\>", "Program",
 CellTags->"jlug:6.9.0.0",
 CellID->28112],

Cell[TextData[{
 "Some ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " exceptions might not be \[OpenCurlyDoubleQuote]native\
\[CloseCurlyDoubleQuote] ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " errors, but rather special exceptions thrown by implementations of the \
various link interfaces. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " follows the standard \[OpenCurlyDoubleQuote]exception chaining\
\[CloseCurlyDoubleQuote] idiom by allowing link implementations to catch \
these exceptions internally, wrap them in a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ", and re-throw them. As an example, consider a ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " implementation built on top of Java Remote Method Invocation (RMI). \
Methods called via RMI can throw a ",
 StyleBox["RemoteException", "MR"],
 ", so such a link implementation might choose to catch internally every ",
 StyleBox["RemoteException", "MR"],
 " and wrap it in a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ". If it did not do this, and instead all its methods could throw a ",
 StyleBox["RemoteException", "MR"],
 " in addition to ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ", all client code that used it would have to be modified. What all this \
means is that if you catch a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ", it might be \[OpenCurlyDoubleQuote]wrapping\[CloseCurlyDoubleQuote] \
another exception, instead of representing an internal ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " problem. You can use the ",
 StyleBox["getCause()", "MR"],
 " method on the ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " instance to retrieve the wrapped exception that was the actual cause of \
the problem. The ",
 StyleBox["getCause()", "MR"],
 " method will return ",
 StyleBox["null", "MR"],
 " in the typical case where the ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " is not wrapping another type of exception."
}], "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->30695]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics and Typeset Output", "Section",
 CellTags->{"2.10", "jlug:6.10.0.0", "TableOfContents_1.6.10"},
 CellID->24041],

Cell[CellGroupData[{

Cell["Preamble", "Subsection",
 CellTags->{"jlug:6.10.0.1", "TableOfContents_1.6.10.1"},
 CellID->24423],

Cell[TextData[{
 "Many developers who are writing Java programs that use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will want to produce ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and typeset expressions. This is a relatively complex subject, \
although ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has some very high-level methods designed to make obtaining and displaying \
these images very simple. If you want to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " images in a Java window, you can use the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " components, discussed in the next ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#24229"],
 ". If you want a little more control over the process, or if you want to do \
something with the image data other than display it (like write it to a file \
or stream), you should read the ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#911"],
 " on the ",
 StyleBox["evaluateToImage()", "MR"],
 " and ",
 StyleBox["evaluateToTypeset()", "MR"],
 " methods."
}], "Text",
 CellTags->"jlug:6.10.0.1",
 CellID->24129]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathCanvas and MathGraphicsJPanel", "Subsection",
 CellTags->{"jlug:6.10.0.2", "TableOfContents_1.6.10.2"},
 CellID->24229],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " classes were discussed in ",
 ButtonBox["The MathCanvas and MathGraphicsJPanel classes",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#20608"],
 " because they are often used from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs. They are just as useful in Java programs. Each is a simple \
graphical component (a JavaBean, in fact), that can display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and typeset expressions. ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " is a subclass of the AWT ",
 StyleBox["Canvas", "MR"],
 " class, and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " is a sublcass of the Swing ",
 StyleBox["JPanel", "MR"],
 " class. They are conceptually identical and have the same set of extra \
methods for dealing with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics. You use ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " when you want an AWT component and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " when you want a Swing component."
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->4565],

Cell["\<\
Programmers who want to see how they work are strongly encouraged to examine \
the source code. The most important methods from these classes are as \
follows:\
\>", "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->6559],

Cell["\<\
public void setMathCommand(String cmd);
public void setImageType(int type);
public void setUsesFE(boolean useFE);
public void setUsesTraditionalForm(boolean useTradForm);

public void setImage(Image im);

public void recompute();

public void repaintNow();\
\>", "Program",
 CellTags->"jlug:6.10.0.2",
 CellID->8932],

Cell[TextData[{
 "Important methods from the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " classes"
}], "Caption",
 CellTags->"jlug:6.10.0.2",
 CellID->22296],

Cell[TextData[{
 "For brevity, the discussion below will refer only to ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 "; everything said applies equally to ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 ". Use ",
 StyleBox["setMathCommand()", "MR"],
 " to specify arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code that will be evaluated and have its result displayed. If you are \
using your ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " to display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics, the result of the computation must be a graphics object  (that \
is, an expression with head ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "MR"]], "InlineFormula"],
 ", and so on). It is not enough that the command ",
 StyleBox["produces",
  FontSlant->"Italic"],
 " a graphic\[LongDash]it must ",
 StyleBox["return",
  FontSlant->"Italic"],
 " a graphic. ",
 StyleBox["Thus, ",
  FontColor->GrayLevel[0]],
 StyleBox["setMathCommand(\"Plot[x,{x,0,1}]\")", "MR",
  FontColor->GrayLevel[0]],
 StyleBox[" will work, but ",
  FontColor->GrayLevel[0]],
 StyleBox["setMathCommand(\"Plot[x,{x,0,1}];\")", "MR",
  FontColor->GrayLevel[0]],
 StyleBox[" will not because the trailing semicolon causes the expression to \
evaluate to ",
  FontColor->GrayLevel[0]],
 StyleBox["Null", "MR",
  FontColor->GrayLevel[0]],
 StyleBox[". ",
  FontColor->GrayLevel[0]],
 "If you are using the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " to display typeset output, then the result of executing the code supplied \
in ",
 StyleBox["setMathCommand()", "MR"],
 " can be anything. Its typeset form will be displayed. Within the code that \
you specify via ",
 StyleBox["setMathCommand()", "MR"],
 ", quotation marks and other characters that have special meanings inside \
Java strings must be escaped by preceding them with a backslash, as in ",
 StyleBox["setMathCommand(\"", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"], "MR"]], "InlineFormula"],
 StyleBox["[x,{x,0,1},", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotLabel"], "MR"]], "InlineFormula"],
 StyleBox["->\\\"A Plot\\\"]\")", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->29855],

Cell[TextData[{
 "The ",
 StyleBox["setImageType()", "MR"],
 " method is what toggles between displaying a graphic and displaying a \
typeset expression. Call ",
 StyleBox["setImageType(", "MR"],
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 StyleBox[".GRAPHICS)", "MR"],
 " or ",
 StyleBox["setImageType(", "MR"],
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 StyleBox[".TYPESET)", "MR"],
 " to toggle between the two modes."
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->12053],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " can create images of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics in two ways, either by using only the kernel or by using the \
kernel along with some extra services from the front end. The front end \
generally can do a better job, but there are some trade-offs involved. If you \
want to use the front end, call ",
 StyleBox["setUsesFE(true)", "MR"],
 ". When you call ",
 StyleBox["setUsesFE(true)", "MR"],
 ", the front end may be launched, or an already running copy may be used. \
The exact behavior depends on what operating system and version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you have. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0 and later, all graphics output requires the front end, so the ",
 StyleBox["setUsesFE()", "MR"],
 " mehod has no effect\[LongDash]it is always ",
 StyleBox["true", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->16962],

Cell[TextData[{
 "For typeset output, the default is ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"], "MR"]], "InlineFormula"],
 ". To change to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"], "MR"]], "InlineFormula"],
 " call ",
 StyleBox["setUsesTraditionalForm(true)", "MR"],
 ".  When generating typeset output (that is, if you have called ",
 StyleBox["setImageType(MathCanvas.TYPESET)", "MR"],
 "), the front end is always involved in generating typeset output, so make \
sure you understand the issues discussed in \[OpenCurlyDoubleQuote]Using the \
Front End as a Service.\[CloseCurlyDoubleQuote]"
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->3584],

Cell[TextData[{
 "When you call ",
 StyleBox["setMathCommand()", "MR"],
 ", the command is executed immediately and the resulting image is cached and \
used every time the window is repainted. Sometimes the code in your math \
command depends on variables that will change. To force the command to be \
recomputed and the new image displayed, call ",
 StyleBox["recompute()", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->29734],

Cell[TextData[{
 "The ",
 StyleBox["repaintNow()", "MR"],
 " method is like a \[OpenCurlyDoubleQuote]smart\[CloseCurlyDoubleQuote] \
version of the ",
 StyleBox["JComponent", "MR"],
 " method ",
 StyleBox["paintImmediately()", "MR"],
 ", and you use it in the same circumstances as ",
 StyleBox["paintImmediately()", "MR"],
 ". It knows about the image that needs to be drawn and it will block until \
all the pixels are ready. You can use this method to force an immediate \
redraw when you want the image to be updated instantly in response to some \
user action like dragging a slider that controls a variable upon which the \
plot depends. If you call the standard method ",
 StyleBox["repaint()", "MR"],
 " instead, Java might not get around to repainting the image until many \
frames have gone by, and the plot will appear to jump from one value to \
another, rather than being redrawn for every change in the variable\
\[CloseCurlyQuote]s value."
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->6654],

Cell[TextData[{
 "The preceding discussion described how you can easily get display ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output in a ",
 StyleBox["MathCanvas", "MR"],
 " simply by supplying some code to ",
 StyleBox["setMathCommand()", "MR"],
 ". Another way to get an image displayed in a ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " is to create a Java ",
 StyleBox["Image", "MR"],
 " object yourself and call the ",
 StyleBox["setImage()", "MR"],
 " method. You might want to do this is if your image is a bitmap created \
with some ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " data, or if you have drawn into an offscreen image using the Java graphics \
API. The ",
 StyleBox["setImage()", "MR"],
 " method was created mainly for use from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, and it is somewhat less important for Java programmers because you \
already have other ways to draw into your own components. It can still be \
useful in Java programs, though, since it can save you from having to write \
your own subclass of an AWT component just to override its ",
 StyleBox["paint()", "MR"],
 " method, which is the usual technique for drawing your own content in \
components. When used with the ",
 StyleBox["setImage()", "MR"],
 " method, a ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " is really just a useful AWT component\[LongDash]it has nothing directly to \
do with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->16972],

Cell[TextData[{
 "The next section presents a sample program that uses a ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " to display graphics and typeset output."
}], "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->21457]
}, Open  ]],

Cell[CellGroupData[{

Cell["A Sample Program that Displays Graphics and Typeset Results", \
"Subsection",
 CellTags->{"jlug:6.10.0.3", "TableOfContents_1.6.10.3"},
 CellID->14369],

Cell[TextData[{
 "Here is the code for a simple program that presents a window that displays \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and typeset output. It is an example of how to use the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " class. The code and compiled class files for this program are available in \
the ",
 StyleBox["JLink/Examples/Part2/GraphicsApp", "MR"],
 " directory. Launch the program with the pathname to the kernel executable \
as an argument (note the use of the quote marks \" and '):"
}], "Text",
 CellTags->"jlug:6.10.0.3",
 CellID->22532],

Cell["\<\
(Windows)
java -classpath GraphicsApp.jar;..\\..\\..\\JLink.jar GraphicsApp \
\"c:\\program files\\wolfram research\\mathematica\\6.0\\mathkernel\"

(Unix)
java -classpath GraphicsApp.jar:../../../JLink.jar GraphicsApp 'math \
-mathlink'

(Mac OSX command line)
java -classpath GraphicsApp.jar:../../../JLink.jar GraphicsApp \
'\"/Applications/Mathematica.app/Contents/MacOS/MathKernel\" -mathlink'\
\>", "Program",
 CellTags->"jlug:6.10.0.3",
 CellID->2963],

Cell["Here is the code.", "Text",
 CellTags->"jlug:6.10.0.3",
 CellID->2607],

Cell["\<\
import com.wolfram.jlink.*;
import java.awt.*;
import java.awt.event.*;

public class GraphicsApp extends Frame {
    
\tstatic GraphicsApp app;
\tstatic KernelLink ml;
\t
\tMathCanvas mathCanvas;
\tTextArea inputTextArea;
\tButton evalButton;
\tCheckbox useFEButton;
\tCheckbox graphicsButton;
\tCheckbox typesetButton;

\tpublic static void main(String[] argv) {

\t\ttry {
\t\t\tString[] mlArgs = {\"-linkmode\", \"launch\", \"-linkname\", argv[0]};
\t\t\tml = MathLinkFactory.createKernelLink(mlArgs);
\t\t\tml.discardAnswer();
\t\t} catch (MathLinkException e) {
\t\t\tSystem.out.println(\"An error occurred connecting to the kernel.\");
\t\t\tif (ml != null)
\t\t\t\tml.close();
\t\t\treturn;
\t\t}
\t\tapp = new GraphicsApp();
\t}
    
\tpublic GraphicsApp() {
\t\t
\t\tsetLayout(null);
\t\tsetTitle(\"Graphics App\");
\t\tmathCanvas = new MathCanvas(ml);
\t\tadd(mathCanvas);
\t\tmathCanvas.setBackground(Color.white);
\t\tinputTextArea = new TextArea(\"\", 2, 40, \
TextArea.SCROLLBARS_VERTICAL_ONLY);
\t\tadd(inputTextArea);
\t\tevalButton = new Button(\"Evaluate\");
\t\tadd(evalButton);
\t\tevalButton.addActionListener(new BnAdptr());
\t\tuseFEButton = new Checkbox(\"Use front end\", false);
\t\tCheckboxGroup cg = new CheckboxGroup();
\t\tgraphicsButton = new Checkbox(\"Show graphics output\", true, cg);
\t\ttypesetButton = new Checkbox(\"Show typeset result\", false, cg);
\t\tadd(useFEButton);
\t\tadd(graphicsButton);
\t\tadd(typesetButton);
\t\t
\t\tsetSize(300, 400);
\t\tsetLocation(100,100);
\t\tmathCanvas.setBounds(10, 25, 280, 240);
\t\tinputTextArea.setBounds(10, 270, 210, 60);
\t\tevalButton.setBounds(230, 290, 60, 30);
\t\tgraphicsButton.setBounds(20, 340, 160, 20);
\t\ttypesetButton.setBounds(20, 365, 160, 20);
\t\tuseFEButton.setBounds(180, 340, 100, 20);
\t\t
\t\taddWindowListener(new WnAdptr());
\t\tsetBackground(Color.lightGray);
\t\tsetResizable(false);
\t\t
\t\t// Although this code would automatically be called in
\t\t// evaluateToImage or evaluateToTypeset, it can cause the
\t\t// front end window to come in front of this Java window.
\t\t// Thus, it is best to get it out of the way at the start
\t\t// and call toFront to put this window back in front.
\t\t// KernelLink.PACKAGE_CONTEXT is just \"JLink`\", but it is
\t\t// preferable to use this symbolic constant instead of
\t\t// hard-coding the package context.
\t\tml.evaluateToInputForm(\"Needs[\\\"\" + KernelLink.PACKAGE_CONTEXT + \"\\\
\"]\", 0);
\t\tml.evaluateToInputForm(\"ConnectToFrontEnd[]\", 0);
\t\t
\t\tsetVisible(true);
\t\ttoFront();
\t}

    
\tclass BnAdptr implements ActionListener {
\t\tpublic void actionPerformed(ActionEvent e) {
\t\t\tmathCanvas.setImageType(
\t\t\t\tgraphicsButton.getState() ? MathCanvas.GRAPHICS : \
MathCanvas.TYPESET);
\t\t\tmathCanvas.setUsesFE(useFEButton.getState());
\t\t\tmathCanvas.setMathCommand(inputTextArea.getText());
\t\t}
\t}
\t
\tclass WnAdptr extends WindowAdapter {
\t\tpublic void windowClosing(WindowEvent event) {
\t\t\tif (ml != null) {
\t\t\t\t// Because we used the front end, it is important
\t\t\t\t// to call CloseFrontEnd[] before closing the link.
\t\t\t\t// Counterintuitively, this is not because we want
\t\t\t\t// to force the front end to quit, but because we
\t\t\t\t// _don't_ want to do this if the user has begun
\t\t\t\t// working in the front end session we started.
\t\t\t\t// CloseFrontEnd knows how to politely disengage
\t\t\t\t// from the front end if necessary. The need for
\t\t\t\t// this will go away in future releases of
\t\t\t\t// Mathematica.
\t\t\t\tml.evaluateToInputForm(\"CloseFrontEnd[]\", 0);
\t\t\t\tml.close();
\t\t\t}
\t\t\tdispose();
\t\t\tSystem.exit(0);
\t\t}
\t}
}\
\>", "Program",
 CellTags->"jlug:6.10.0.3",
 CellID->2483]
}, Open  ]],

Cell[CellGroupData[{

Cell["evaluateToImage() and evaluateToTypeset()", "Subsection",
 CellTags->{"jlug:6.10.0.4", "TableOfContents_1.6.10.4"},
 CellID->911],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " classes described in the preceding two sections are not suitable for your \
needs, you can manually produce images of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics and typeset expressions using the ",
 StyleBox["evaluateToImage()", "MR"],
 " and ",
 StyleBox["evaluateToTypeset()", "MR"],
 " methods in the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " interface."
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->11635],

Cell[TextData[{
 "There are multiple signatures for each. For ",
 StyleBox["evaluateToImage()", "MR"],
 ", one set takes a simpler argument list and uses default values for the \
less commonly used arguments."
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->10067],

Cell[TextData[Cell[BoxData[
 RowBox[{"\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"byte", "[", "]"}], " ", "evaluateToImage", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"String", " ", "s"}], ",", 
       RowBox[{"int", " ", "width"}], ",", 
       RowBox[{"int", " ", "height"}]}], ")"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"byte", "[", "]"}], " ", "evaluateToImage", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Expr", " ", "e"}], ",", 
       RowBox[{"int", " ", "width"}], ",", 
       RowBox[{"int", " ", "height"}]}], ")"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"byte", "[", "]"}], " ", "evaluateToImage", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"String", " ", "s"}], ",", 
       RowBox[{"int", " ", "width"}], ",", 
       RowBox[{"int", " ", "height"}], ",", "\[IndentingNewLine]", 
       "\t\t\t\t\t", 
       RowBox[{"int", " ", "dpi"}], ",", 
       RowBox[{"boolean", " ", "useFrontEnd"}]}], ")"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"byte", "[", "]"}], " ", "evaluateToImage", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Expr", " ", "e"}], ",", 
       RowBox[{"int", " ", "width"}], ",", 
       RowBox[{"int", " ", "height"}], ",", "\[IndentingNewLine]", 
       "\t\t\t\t\t", 
       RowBox[{"int", " ", "dpi"}], ",", 
       RowBox[{"boolean", " ", "useFrontEnd"}]}], ")"}]}], ";"}], "\n", "\n", 
   
   RowBox[{
    RowBox[{
     RowBox[{"byte", "[", "]"}], " ", "evaluateToTypeset", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"String", " ", "s"}], ",", 
       RowBox[{"int", " ", "pageWidth"}], ",", 
       RowBox[{"boolean", " ", "useStdForm"}]}], ")"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"byte", "[", "]"}], " ", "evaluateToTypeset", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Expr", " ", "e"}], ",", 
       RowBox[{"int", " ", "pageWidth"}], ",", 
       RowBox[{"boolean", " ", "useStdForm"}]}], ")"}]}], 
    ";"}]}]}]], "DisplayMath",
 CellTags->"jlug:6.10.0.4"]], "Program",
 CellTags->"jlug:6.10.0.4",
 CellID->22848],

Cell["\<\
Graphics and typesetting methods from the KernelLink interface.\
\>", "Caption",
 CellTags->"jlug:6.10.0.4",
 CellID->4675],

Cell[TextData[{
 "The ",
 StyleBox["evaluateToImage()", "MR"],
 " method takes the input as a string or ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ", and a width and height of the resulting graphic in pixels. The extended \
versions let you specify a dots-per-inch value, and whether to use the \
notebook front end or not (as discussed later). The short versions use the \
values of 0 for the dpi and ",
 StyleBox["false", "MR"],
 " for whether to use the front end. Specifying 0 for dpi causes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to use its default value. The image will be sized to fit within a box of \
width x height, without changing its aspect ratio. In other words, the image \
might not have exactly these dimensions, but it will never be larger in \
either dimension and it will never be stretched in one dimension to make it \
fit better. Pass 0 for the width and height to get their ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"], "MR"]], "InlineFormula"],
 " values. If the input does not evaluate to a graphics expression, then ",
 StyleBox["null", "MR"],
 " is returned. It is not enough that the computation causes a plot to be \
generated\[LongDash]the ",
 StyleBox["return value",
  FontSlant->"Italic"],
 " of the computation must have head ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "MR"]], "InlineFormula"],
 " (or ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "MR"]], "InlineFormula"],
 ", etc.). If the ",
 StyleBox["useFrontEnd", "MR"],
 " argument is true, ",
 StyleBox["evaluateToImage()", "MR"],
 " will launch the notebook front end if it is not already running. Note that \
the ",
 StyleBox["useFrontEnd", "MR"],
 " argument is irrelevant when using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5.1 and later\[LongDash]the front end is always used for graphics."
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->12938],

Cell[TextData[{
 "The ",
 StyleBox["evaluateToTypeset()", "MR"],
 " method takes the input as a string or ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ", a page width to wrap the output to before it is typeset, and a flag \
specifying whether to use ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"], "MR"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"], "MR"]], "InlineFormula"],
 ". The units for the page width is pixels (use 0 for a page width of \
infinity). The ",
 StyleBox["evaluateToTypeset()", "MR"],
 " method requires the services of the notebook front end, which will be \
launched if it is not already running."
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->2223],

Cell[TextData[{
 "The result of both of these methods is a byte array of GIF data. The GIF \
format is well-suited to most ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics, but for some 3D graphics the color usage is not ideal. If you \
want to change to using JPEG format, you can set ",
 Cell[BoxData["$DefaultImageFormat"], "InlineFormula"],
 " to ",
 StyleBox["\"JPEG\"", "MR"],
 " in the kernel:"
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->22142],

Cell["\<\
// Specifies JPEG format for subsequent calls to evaluateToImage()
// and evaluateToTypeset().
ml.evaluateToOutputForm(\"$DefaultImageFormat = \\\"JPEG\\\"\", 0);\
\>", "Program",
 CellTags->"jlug:6.10.0.4",
 CellID->23754],

Cell[TextData[{
 "These methods are like ",
 StyleBox["evaluateToInputForm()", "MR"],
 " and ",
 StyleBox["evaluateToOutputForm()", "MR"],
 " in that they perform the computation and return the result in a single \
step. Together, all these methods are referred to as the \
\[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] methods. They all \
return ",
 StyleBox["null", "MR"],
 " in the unlikely event that a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " occurred."
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->6511],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MathGraphicsJPanel",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathGraphicsJPanel"]], 
  "InlineFormula"],
 " classes use these methods internally, so their source code is a good place \
to look for examples of calling the methods. The ",
 Cell[BoxData[
  ButtonBox["MathCanvas",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathCanvas"]], "InlineFormula"],
 " code demonstrates how to take the byte array of GIF or JPEG data and turn \
it into a Java ",
 StyleBox["Image", "MR"],
 " for display."
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->22741],

Cell[TextData[{
 "The ",
 StyleBox["Typesetter", "MR"],
 " sample program below is another example. It takes a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression supplied on the command line, calls ",
 StyleBox["evaluateToTypeset()", "MR"],
 ", and writes the image data out to a GIF file. You would invoke it from the \
command line like this:"
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->20175],

Cell["\<\
(Windows)
java Typesetter \"c:\\program files\\wolfram \
research\\mathematica\\6.0\\mathkernel\" \"Sqrt[z]\" test.gif

(Unix)
java Typesetter 'math -mathlink' \"Sqrt[z]\" test.gif

(Mac OSX command line)
java Typesetter '\"/Applications/Mathematica.app/Contents/MacOS/MathKernel\" \
-mathlink' \"Sqrt[z]\" test.gif\
\>", "Program",
 CellTags->"jlug:6.10.0.4",
 CellID->21459],

Cell[TextData[{
 "The first argument is the command line to launch the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, the second argument is the expression to typeset, and the third \
argument is the filename to create. This program is not intended to be \
particularly useful\[LongDash]it is just a simple demonstration."
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->17825],

Cell["\<\
import com.wolfram.jlink.*;
import java.io.*;

public class Typesetter {
\t
\tpublic static void main(String[] argv) throws MathLinkException {
\t
\t\tKernelLink ml;\t\t
\t\ttry {
\t\t\tString[] mlArgs = {\"-linkmode\", \"launch\", \"-linkname\", argv[0]};
\t\t\tml = MathLinkFactory.createKernelLink(mlArgs);
\t\t\tml.discardAnswer();
\t\t} catch (MathLinkException e) {
\t\t\tSystem.err.println(\"FATAL ERROR: link creation failed.\");
\t\t\treturn;
\t\t}\t\t
\t\tbyte[] gifData = ml.evaluateToTypeset(argv[1], 0, false);
\t\ttry {
\t\t\tFileOutputStream s = new FileOutputStream(new File(argv[2]));
\t\t\ts.write(gifData);
\t\t\ts.close();
\t\t} catch (IOException e) {}
\t\t// ALWAYS execute CloseFrontEnd[] before killing the kernel if you used
\t\t// evaluateToTypeset(), or evaluateToImage() with the useFE parameter
\t\t// set to true:
\t\tml.evaluateToOutputForm(\"CloseFrontEnd[]\", 0);
\t\tml.close();
\t}
}\
\>", "Program",
 CellTags->"jlug:6.10.0.4",
 CellID->3221],

Cell[TextData[{
 "It is very important to note that we execute ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CloseFrontEnd",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/CloseFrontEnd"], "[", "]"}]], 
  "InlineFormula"],
 " before closing the link to the kernel. This is essential to prevent the \
front end from quitting in circumstances where it should \
not\[LongDash]specifically, if an already-running copy was used and the user \
has open documents."
}], "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->17870]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aborting and Interrupting Computations", "Section",
 CellTags->{"jlug:6.11.0.0", "TableOfContents_1.6.11"},
 CellID->19718],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides two ways in which you can interrupt or abort computations. The \
first technique uses the low-level ",
 StyleBox["putMessage()", "MR"],
 " function to send the desired ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " message. The second and preferred technique is to use a new set of ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods introduced in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " 2.0. These are listed below."
}], "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->19895],

Cell["\<\
void abortEvaluation();
void interruptEvaluation()\t
void abandonEvaluation();
void terminateKernel();\
\>", "Program",
 CellTags->"jlug:6.11.0.0",
 CellID->5447],

Cell[TextData[{
 "The ",
 StyleBox["abortEvaluation()", "MR"],
 " method will send an abort request to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", identical to what happens in the notebook front end when you select the \
",
 StyleBox["Evaluation ", "MenuName"],
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 StyleBox[" ", "MenuName"],
 StyleBox[ButtonBox["Abort Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AbortEvaluation"], "MenuName"],
 " menu command. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " responds to this command by terminating the current evaluation and \
returning the symbol ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Aborted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Aborted"], "MR"]], "InlineFormula"],
 ". Be aware that sometimes the kernel is in a state where it cannot respond \
immediately to interrupts or aborts."
}], "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->21726],

Cell[TextData[{
 "The ",
 StyleBox["interruptEvaluation()", "MR"],
 " method will send an interrupt request to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", identical to what happens in the notebook front end when you select the \
",
 StyleBox["Evaluation ", "MenuName"],
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 StyleBox[" ", "MenuName"],
 StyleBox[ButtonBox["Interrupt Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InterruptEvaluation"], "MenuName"],
 " menu command. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " responds to this command by interrupting the current evaluation and \
sending back a special packet that contains choices for what to do next. The \
choices can depend on what the kernel is doing at the moment, but in most \
cases they include aborting, continuing, or entering a dialog. It is not \
likely that you will want to have to deal with this list of choices on your \
own, so you might choose instead to call ",
 StyleBox["abortEvaluation()", "MR"],
 " and just stop the computation. If you are developing an interactive front \
end, however, you might decide that you want your users to see the same types \
of choices that the notebook front end provides. If this is the case, then \
you can use the new ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " class, which provides a dialog box very similar to the front end\
\[CloseCurlyQuote]s \[OpenCurlyDoubleQuote]Interrupt Evaluation\
\[CloseCurlyDoubleQuote] dialog. The ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " class is discussed in a later ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#17432"],
 "."
}], "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->14771],

Cell[TextData[{
 "The ",
 StyleBox["abandonEvaluation()", "MR"],
 " method does exactly what its name suggests\[LongDash]it causes any command \
that is currently waiting for something to arrive on the link to back out \
immediately and throw a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ". This ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " is recoverable (meaning that ",
 StyleBox["clearError()", "MR"],
 " will return ",
 StyleBox["true", "MR"],
 "), so in theory you could call ",
 StyleBox["waitForAnswer()", "MR"],
 " again later and get the result when it arrives. In practice, however, you \
should generally not use this method unless you plan to close the link. You \
should think of ",
 StyleBox["abandonEvaluation()", "MR"],
 " method is an \[OpenCurlyDoubleQuote]emergency exit\[CloseCurlyDoubleQuote] \
function that lets your program back out of waiting for a result no matter \
what state the kernel is in. Remember that the ",
 StyleBox["abortEvaluation()", "MR"],
 " method simply sends an abort request to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and thus it requires some cooperation from the kernel; there is no \
guarantee that the current evaluation will abort in a timely manner, if ever. \
If you call ",
 StyleBox["close()", "MR"],
 " right after ",
 StyleBox["abandonEvaluation()", "MR"],
 ", the kernel will typically not die, because it is still busy with a \
computation. You should call ",
 StyleBox["terminateKernel()", "MR"],
 " before ",
 StyleBox["close()", "MR"],
 " to ensure that the kernel shuts down. A code fragment below demonstrates \
this."
}], "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->11538],

Cell[TextData[{
 "The ",
 StyleBox["terminateKernel()", "MR"],
 " method will send a terminate request to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It does this by sending the low-level ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " message ",
 StyleBox["MLTERMINATEMESSAGE", "MR"],
 ". This is the strongest step you can take to tell the kernel to shut down, \
short of killing the kernel process with operating system commands. In \
\[OpenCurlyDoubleQuote]normal\[CloseCurlyDoubleQuote] operation of the \
kernel, when you call ",
 StyleBox["close()", "MR"],
 " on the link, the kernel will quit. In some cases, however, generally only \
if the kernel is currently busy computing, it will not quit. In such cases \
you can generally force the kernel to quit immediately by calling ",
 StyleBox["terminateKernel()", "MR"],
 ". You should always call ",
 StyleBox["close()", "MR"],
 " immediately afterward. In a server environment, where a Java program that \
starts and stops ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernels needs to run unattended for a very long period of time with the \
highest reliability possible, you might consider always calling ",
 StyleBox["terminateKernel()", "MR"],
 " before ",
 StyleBox["close()", "MR"],
 ", if there is any chance that ",
 StyleBox["close()", "MR"],
 " needs to be called while the kernel is still busy. In some rare \
circumstances (generally only if something has gone wrong with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ")",
 ", even calling ",
 StyleBox["terminateKernel()", "MR"],
 " will not force the kernel to quit, and you might need to use facilities of \
your operating system (perhaps invoked via Java\[CloseCurlyQuote]s ",
 StyleBox["Runtime.exec()", "MR"],
 " method) to kill the kernel process."
}], "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->1869],

Cell[TextData[{
 "If you want to be able to abort, interrupt, or abandon computations, your \
program will need to have at least two threads. The thread on which the \
computation is called will probably look like all the sample programs we have \
seen. You would call one of the \[OpenCurlyDoubleQuote]evaluateTo\
\[CloseCurlyDoubleQuote] methods, or perhaps ",
 StyleBox["evaluate()", "MR"],
 " followed by ",
 StyleBox["waitForAnswer()", "MR"],
 ". This thread will block, waiting for the result. On a separate thread, \
such as the user interface thread, you could periodically check for some \
event, like a time out period elapsing. Or, you could use an event listener \
to be notified when the \[EscapeKey] key was pressed. Whichever way you want \
to detect the abort request, all you need to do is call ",
 StyleBox["putMessage(MathLink.MLABORTMESSAGE)", "MR"],
 ". If the kernel receives the message before it finishes, and it is doing \
something that can be aborted, the computation will end and return the symbol \
",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Aborted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Aborted"], "MR"]], "InlineFormula"],
 ". You typically will not need to do anything special in the computation \
thread. You wait for the answer as usual; it might come back as ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Aborted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Aborted"], "MR"]], "InlineFormula"],
 " instead of the final result, that\[CloseCurlyQuote]s all. Here are some \
typical code fragments that demonstrate aborting a computation:"
}], "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->19912],

Cell["\<\
// On thread 1
ml.evaluate(\"Do[2+2, {20000000}]\");
ml.waitForAnswer();
// If user aborted, the result will be the symbol $Aborted.
\t
// On thread 2
if (userPressedEscKey() || timeoutElapsed())
\tml.abortEvaluation();\
\>", "Program",
 CellTags->"jlug:6.11.0.0",
 CellID->25667],

Cell["\<\
Here is some code that demonstrates how to abandon a computation and force an \
immediate shutdown of the kernel:\
\>", "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->26299],

Cell["\<\
// On thread 1
try {
\tml.evaluate(\"While[True]\");
\tml.discardAnswer();
} catch (MathLinkException e) {
\t// We will get here when abandonEvaluation() is called on the other thread.
\tSystem.err.println(\"MathLinkException occurred: \" + e.toString());
\tif (!ml.clearError()) {
\t\t// clearError() will always fail when abandonEvaluation() was called.
\t\tml.terminateKernel();
\t\tml.close();
\t}
}
\t
// On thread 2
if (timeoutElapsedAndReallyNeedToShutdownKernel())
\tml.abandonEvaluation();\
\>", "Program",
 CellTags->"jlug:6.11.0.0",
 CellID->17035],

Cell[TextData[{
 "The discussion so far has focused on the high-level interface for \
interrupting and aborting computations. The alternative is to use the \
low-level method ",
 StyleBox["putMessage()", "MR"],
 " and pass one of the constants ",
 StyleBox["MathLink.MLINTERRUPTMESSAGE", "MR"],
 ", ",
 StyleBox["MathLink.MLABORTMESSAGE", "MR"],
 ", or ",
 StyleBox["MathLink.MLTERMINATEMESSAGE", "MR"],
 ". There is no reason to do this, however, as ",
 StyleBox["interruptEvaluation()", "MR"],
 ", ",
 StyleBox["abortEvaluation()", "MR"],
 ", and ",
 StyleBox["terminateKernel()", "MR"],
 " are just one-line methods that put the appropriate message. The \
\[OpenCurlyDoubleQuote]messages\[CloseCurlyDoubleQuote] referred to in the ",
 StyleBox["MathLink", "MR"],
 " method ",
 StyleBox["putMessage()", "MR"],
 " are not related to the familiar ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " error and warning messages. Instead, they are a special type of \
communication between two ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs. This communication takes place on a different channel from the \
normal flow of expressions, which is why you can call ",
 StyleBox["putMessage()", "MR"],
 " while the kernel is in the middle of a computation and not reading from \
the link."
}], "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->9894],

Cell[TextData[{
 "There are several other ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " methods with \[OpenCurlyDoubleQuote]message\[CloseCurlyDoubleQuote] in \
their names. These are ",
 StyleBox["messageReady()", "MR"],
 ", ",
 StyleBox["getMessage()", "MR"],
 ", ",
 StyleBox["addMessageHandler()", "MR"],
 ", and ",
 StyleBox["removeMessageHandler()", "MR"],
 ". These methods are only useful if you want to be able to detect messages \
the kernel sends to you. ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programmers will rarely want to do this, so we will not discuss them in \
detail. Please note that ",
 StyleBox["messageReady()", "MR"],
 " and ",
 StyleBox["getMessage()", "MR"],
 " ",
 StyleBox["no longer function in ",
  FontWeight->"Bold"],
 StyleBox["J/Link",
  FontWeight->"Bold",
  FontSlant->"Italic"],
 StyleBox[" 2.0 and later",
  FontWeight->"Bold"],
 ". If you want to be able to receive messages from ",
 StyleBox["Mathematica,",
  FontSlant->"Italic"],
 " you must use ",
 StyleBox["addMessageHandler()", "MR"],
 " and ",
 StyleBox["removeMessageHandler()", "MR"],
 ". There is more information in the JavaDocs for these methods."
}], "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->28703]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Marks", "Section",
 CellTags->{"jlug:6.12.0.0", "TableOfContents_1.6.12"},
 CellID->8483],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " allows you to set a \[OpenCurlyDoubleQuote]mark\[CloseCurlyDoubleQuote] in \
a link, so that you can read more data and then seek back to the mark, \
restoring the link to the state it was in before you read the data. Thus, \
marks let you read data off a link and not have the data consumed, so you can \
read it again later. There are three mark-related methods in the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface:"
}], "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->5538],

Cell["\<\
// In the MathLink interface:
long createMark() throws MathLinkException;
void seekMark(long mark);
void destroyMark(long mark);\
\>", "Program",
 CellTags->"jlug:6.12.0.0",
 CellID->7492],

Cell[TextData[{
 "One common reason to use a mark is if you want to examine an incoming \
expression and branch to different code depending on some property of the \
expression. You want the code that actually handles the expression to see the \
entire expression, but you will need to read at least a little bit of the \
expression to decide how it must be handled (perhaps just calling ",
 StyleBox["getFunction()", "MR"],
 " to see the head). Here is a code fragment demonstrating this technique:"
}], "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->6193],

Cell["\<\
String head = null;
long mark = ml.createMark();
try {
\thead = ml.getFunction().name;
\tml.seekMark(mark);
} finally {
\tml.destroyMark(mark);
}
if (head.equals(\"foo\"))
\thandleFoo(ml);
else if (head.equals(\"bar\"))
\thandleBar(ml);\
\>", "Program",
 CellTags->"jlug:6.12.0.0",
 CellID->28252],

Cell[TextData[{
 "Because we seek back to the mark after calling ",
 StyleBox["getFunction()", "MR"],
 ", the link will be reset to the beginning of the expression when the ",
 StyleBox["handleFoo()", "MR"],
 " and ",
 StyleBox["handleBar()", "MR"],
 " methods are entered. Note the use of a ",
 StyleBox["try/finally", "MR"],
 " block to ensure that the mark is always destroyed, whether or not an \
exception of any kind is thrown after it is created. You should always use \
marks in this way. Right after calling ",
 StyleBox["createMark()", "MR"],
 ", start a ",
 StyleBox["try", "MR"],
 " block whose ",
 StyleBox["finally", "MR"],
 " clause calls ",
 StyleBox["destroyMark()", "MR"],
 ". It is important that no other code intervenes between ",
 StyleBox["createMark()", "MR"],
 " and the ",
 StyleBox["try", "MR"],
 " block, especially ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " calls (which can throw ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 "). If a mark is created and not destroyed, a memory leak will result \
because incoming data will pile up on the link, never to be freed."
}], "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->25011],

Cell[TextData[{
 "Another common use for marks is to allow you to read an expression one way, \
and if a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " is thrown, go back and try reading it a different way. For example, you \
might be expecting a list of real numbers to be waiting on the link. You can \
set a mark and then call ",
 StyleBox["getDoubleArray1()", "MR"],
 ". If the data on the link cannot be coerced to a list of reals, ",
 StyleBox["getDoubleArray1()", "MR"],
 " will throw a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 ". You can then seek back to the mark and try a different method of reading \
the data. "
}], "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->1560],

Cell["\<\
double[] data = null;
long mark = ml.createMark();
ty {
\tdata = ml.getDoubleArray1();
} catch (MathLinkException e) {
\tml.clearError();
\tml.seekMark(mark);
\t// Here, try a different way of reading the data:
\tswitch (ml.getNext()) {
\t\t... 
\t}
} finally {
\tml.destroyMark(mark);
}\
\>", "Program",
 CellTags->"jlug:6.12.0.0",
 CellID->15834],

Cell[TextData[{
 "Much of the functionality of marks is subsumed by the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class, described in ",
 ButtonBox["Motivation for the Expr Class",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21763"],
 ". ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects allow you to easily examine an expression over and over in \
different ways, and with the ",
 StyleBox["peekExpr()", "MR"],
 " method you can look at the upcoming expression without consuming it off \
the link."
}], "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->1840]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Loopback Links", "Section",
 CellTags->{"jlug:6.13.0.0", "TableOfContents_1.6.13"},
 CellID->58],

Cell[TextData[{
 "In addition to the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " interfaces, there is one other link interface: ",
 Cell[BoxData[
  ButtonBox["LoopbackLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/LoopbackLink"]], "InlineFormula"],
 ". Loopback links are a feature of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " that allow a program to conveniently store ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. Say you want to read an expression off a link, keep it around \
for awhile, and then write it back onto the same or a different link. How \
would you do this? If you read it with the standard reading functions (",
 StyleBox["getFunction()", "MR"],
 ", ",
 StyleBox["getInteger()", "MR"],
 ", and so on), you will have broken the expression down into its atomic \
components, of which there might be very many. Then you will have to \
reconstruct it later with the corresponding series of \
\[OpenCurlyDoubleQuote]",
 StyleBox["put", "MR"],
 "\[CloseCurlyDoubleQuote] methods. What you really need is a temporary place \
to transfer the expression in its entirety, where it can be read later or \
transferred again to a different link. A loopback link serves this purpose."
}], "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->14700],

Cell[TextData[{
 "Before we go on to examine loopback links, please note that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class is used for the same sorts of things that a loopback link is used \
for. ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects use loopback links internally, and are a much richer extension of \
the functionality that loopback links provide. You should consider using ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects instead of loopback links in your programs."
}], "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->13971],

Cell[TextData[{
 "If a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is like a pipe, then a loopback link is a pipe that bends around to point \
back at you. You manage both ends of the link, writing into one \
\[OpenCurlyDoubleQuote]end\[CloseCurlyDoubleQuote] and reading out the other, \
in FIFO order. To create a loopback link in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", use the ",
 Cell[BoxData[
  ButtonBox["MathLinkFactory",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkFactory"]], "InlineFormula"],
 " method ",
 StyleBox["createLoopbackLink()", "MR"],
 ":"
}], "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->26264],

Cell["\<\
// In class MathLinkFactory:
public static LoopbackLink createLoopbackLink() throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.13.0.0",
 CellID->15117],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["LoopbackLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/LoopbackLink"]], "InlineFormula"],
 " interface extends the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface, so all the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " methods can be used on loopback links. ",
 Cell[BoxData[
  ButtonBox["LoopbackLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/LoopbackLink"]], "InlineFormula"],
 " adds no methods beyond those in the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface. Why have a separate interface then? It can be useful to have a \
separate type for this kind of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", because it has different behavior than a normal one-sided ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". Furthermore, there is one method in the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface (",
 StyleBox["transferToEndOfLoopbackLink()", "MR"],
 ") that requires, as an argument, a loopback link. Thus, it provides a small \
measure of type safety within ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " and your own programs to have a separate ",
 Cell[BoxData[
  ButtonBox["LoopbackLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/LoopbackLink"]], "InlineFormula"],
 " type."
}], "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->16215],

Cell[TextData[{
 "You will probably use the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " method ",
 StyleBox["transferExpression()", "MR"],
 ", or its variant ",
 StyleBox["transferToEndOfLoopbackLink()", "MR"],
 ", in conjunction with loopback links. You will need ",
 StyleBox["transferExpression()", "MR"],
 " either to move an expression from another link onto a loopback link or to \
move an expression you have manually placed on a loopback link onto another \
link. Here are the declarations of these two methods:"
}], "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->24555],

Cell["\<\
// In the MathLink interface
void transferExpression(MathLink source) throws MathLinkException;
void transferToEndOfLoopbackLink(LoopbackLink source) throws \
MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.13.0.0",
 CellID->7815],

Cell[TextData[{
 "Note that the source link is the argument and the destination is the ",
 StyleBox["this", "MR"],
 " link. The ",
 StyleBox["transferExpression()", "MR"],
 " method reads one expression from the source link and puts it on the \
destination link, and the ",
 StyleBox["transferToEndOfLoopbackLink()", "MR"],
 " method moves all the expressions on the source link (which must be a ",
 Cell[BoxData[
  ButtonBox["LoopbackLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/LoopbackLink"]], "InlineFormula"],
 ") to the destination link."
}], "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->18330],

Cell[TextData[{
 "We already mentioned a common case where loopback links are convenient\
\[LongDash]temporary storage of an expression for later writing to a \
different link. This is done more simply using an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object, however (",
 ButtonBox["Motivation for the Expr Class",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#21763"],
 "). Another use for loopback links is to allow you to begin sending an \
expression before you know how long it will be. Recall that the ",
 StyleBox["putFunction()", "MR"],
 " method requires you to specify the number of arguments (i.e., the length). \
There are times, though, when you don\[CloseCurlyQuote]t know ahead of time \
how long the expression will be. Consider the following code fragment. We \
need to send a list of random numbers to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the length of which depends on a test whose outcome cannot be known at \
compile time. We can create a loopback link and push the numbers onto it as \
they are generated, counting them as we go. When the loop finishes, we know \
how many were generated, so we call ",
 StyleBox["putFunction()", "MR"],
 " and then just \[OpenCurlyDoubleQuote]pour out\[CloseCurlyDoubleQuote] the \
contents of the loopback link onto the destination link. In this example, it \
would be easy to store the accumulating numbers in a Java array or ",
 StyleBox["Vector", "MR"],
 " rather than a loopback link. But if we were sending complicated \
expressions it might not be so easy to store them in native Java structures. \
It is often easier just to write them on a link as you go, and leave the \
storage issues up to the internals of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->3039],

Cell[TextData[StyleBox["// Here we demonstrate sending an expression (a list \
of reals)\n// whose length is unknown at the start.\ntry {\n\t...\n\t\
LoopbackLink loop = MathLinkFactory.createLoopbackLink();\n\tint count = 0;\n\
\twhile (someTest) {\n\t\tloop.put(Math.random());\n\t\tcount++;\n\t}\n\t\
ml.putFunction(\"List\", count);\n\tml.transferToEndOfLoopbackLink(loop);\n\t\
loop.close();\n\t...\n} catch (MathLinkException e) {}", "DisplayMath"]], \
"Program",
 CellTags->"jlug:6.13.0.0",
 CellID->30212]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using Expr Objects", "Section",
 CellTags->{"2.14", "jlug:6.14.0.0", "TableOfContents_1.6.14"},
 CellID->30188],

Cell[CellGroupData[{

Cell["Motivation for the Expr Class", "Subsection",
 CellTags->{"jlug:6.14.0.1", "TableOfContents_1.6.14.1"},
 CellID->21763],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class provides a direct representation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in Java. We can guess that this will be useful, since \
everything in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is an expression and ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is all about communicating ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions between programs."
}], "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->4940],

Cell[TextData[{
 "You have several ways of handling ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program. First, you can send and/or receive them as strings. This is often \
convenient, particularly if you are taking input typed by a user, or \
displaying results to the user. Many of the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods can take input as a string and return the result as a string. A \
second way of handling ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions is to put them on the link or read them off the link a piece \
at a time with a series of \[OpenCurlyDoubleQuote]put\[CloseCurlyDoubleQuote] \
or \[OpenCurlyDoubleQuote]get\[CloseCurlyDoubleQuote] calls. A third way is \
to store them on a loopback link and shuttle them around between links. Each \
of these methods has advantages and disadvantages."
}], "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->20851],

Cell[TextData[{
 "Loopback links were described in the previous ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#58"],
 ", but it is worthwhile to summarize them here, as it provides some of the \
background to understanding the motivation for the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class. Basically, a loopback link provides a means to store a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression without having tediously to read it off the link, disassembling \
it into its component atoms in the process. Loopback links, then, let you ",
 StyleBox["store",
  FontSlant->"Italic"],
 " expressions for later reading or just dumping onto another link. If you \
eventually want to read and examine the expression, however, you are still \
stuck with the difficult task of dissecting an arbitrary expression off a \
link with the correct sequence of \[OpenCurlyDoubleQuote]get\
\[CloseCurlyDoubleQuote] calls. This is where the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class comes in. Like a loopback link, an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object stores an arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. The ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class goes further, though, and provides a set of methods for examining \
the structure of the expression, extracting parts of it, and building new \
ones. The names and operation of these methods will be familiar to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers: ",
 StyleBox["head()", "MR"],
 ", ",
 StyleBox["length()", "MR"],
 ", ",
 StyleBox["dimensions()", "MR"],
 ", ",
 StyleBox["part()", "MR"],
 ", ",
 StyleBox["stringQ()", "MR"],
 ", ",
 StyleBox["vectorQ()", "MR"],
 ", ",
 StyleBox["matrixQ()", "MR"],
 ", ",
 StyleBox["insert()", "MR"],
 ", ",
 StyleBox["delete()", "MR"],
 ", and many others."
}], "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->18662],

Cell[TextData[{
 "The advantage of an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " over a loopback link, then, is that you are not restricted to using the \
low-level ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API for examining an expression. Consider the task of receiving an \
arbitrary expression from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and determining if its element at position [[2, 3]] (in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notation) is a vector (a list with no sublists). This can be done with an \
",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object as follows:"
}], "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->13829],

Cell["\<\
ml.evaluate(\"some code\");
ml.waitForAnswer();
Expr e = ml.getExpr();
Expr part23 = e.part(new int[] {2, 3});
boolean isVector = part23.vectorQ();\
\>", "Program",
 CellTags->"jlug:6.14.0.1",
 CellID->30900],

Cell[TextData[{
 "This task would be much more difficult with the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " API. The ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class provides a minimal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-like functional interface for examining and dissecting expressions."
}], "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->611242602]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Methods in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Interface for Reading and Writing Exprs"
}], "Subsection",
 CellTags->{"jlug:6.14.0.2", "TableOfContents_1.6.14.2"},
 CellID->18958],

Cell[TextData[{
 "There are three methods in the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface for dealing with ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects. This is in addition to the numerous methods in the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class itself, which deal with composing and decomposing ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects. The ",
 StyleBox["getExpr()", "MR"],
 " and ",
 StyleBox["peekExpr()", "MR"],
 " methods read an expression off a link, but ",
 StyleBox["peekExpr()", "MR"],
 " resets the link to the beginning of the expression\[LongDash]it \
\[OpenCurlyDoubleQuote]peeks\[CloseCurlyDoubleQuote] ahead at the upcoming \
expression without consuming it. This is quite useful for debugging. The ",
 StyleBox["put()", "MR"],
 " method will send an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object as its corresponding ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression."
}], "Text",
 CellTags->"jlug:6.14.0.2",
 CellID->17578],

Cell["\<\
// In the MathLink interface:
Expr getExpr() throws MathLinkException;
Expr peekExpr() throws MathLinkException;
void put(Object obj) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.14.0.2",
 CellID->8365]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exprs as Replacements for Loopback Links", "Subsection",
 CellTags->{"jlug:6.14.0.3", "TableOfContents_1.6.14.3"},
 CellID->13007],

Cell[TextData[{
 "One way to use ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " is as a simple replacement for a loopback link. You can use the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " method ",
 StyleBox["getExpr()", "MR"],
 " to read any type of expression off a link and store it in the resulting ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object. To write the expression onto a link, use the ",
 StyleBox["put()", "MR"],
 " method. Compare the following two code fragments:"
}], "Text",
 CellTags->"jlug:6.14.0.3",
 CellID->11477],

Cell["\<\
// Old way, using a loopback link
\tLoopbackLink loop = MathLinkFactory.createLoopbackLink();
\t// Read expr off of link and store it on loopback
\tloop.transferExpression(ml);
\t...
\t// Later, write the expr back on the link
\tml.transferExpression(loop);
\tloop.close();

// New way, using an Expr
\tExpr e = ml.getExpr();
\t...
\t// Later, write the expression back on the link
\tml.put(e);
\te.dispose();\
\>", "Program",
 CellTags->"jlug:6.14.0.3",
 CellID->1200],

Cell[TextData[{
 "Note the call to ",
 StyleBox["dispose()", "MR"],
 " at the end. The ",
 StyleBox["dispose()", "MR"],
 " method tells an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object to release certain resources that it might be using internally. You \
should generally use ",
 StyleBox["dispose()", "MR"],
 " on an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " when you are finished with it. The ",
 StyleBox["dispose()", "MR"],
 " method is discussed in more detail in ",
 ButtonBox["Disposing of Exprs",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#32356"],
 "."
}], "Text",
 CellTags->"jlug:6.14.0.3",
 CellID->26058]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Exprs as a Means to Get String Representations of Expressions\
\>", "Subsection",
 CellTags->{"jlug:6.14.0.4", "TableOfContents_1.6.14.4"},
 CellID->6439],

Cell[TextData[{
 "A particularly useful method in the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class is ",
 StyleBox["toString()", "MR"],
 ", which produces an ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"], "MR"]], "InlineFormula"],
 "-type string representation of the expression (without involving the \
kernel, of course). This is particularly handy for debugging purposes, when \
you want a quick way to see what is arriving on the link. In ",
 ButtonBox["The PacketPrinter Class for Debugging",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#7926"],
 " it was mentioned that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has a class ",
 Cell[BoxData[
  ButtonBox["PacketPrinter",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketPrinter"]], "InlineFormula"],
 " that implements the ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface and can be used to easily print out the contents of packets as \
they arrive in your program, without modifying your program. Below is the ",
 StyleBox["packetArrived()", "MR"],
 " method of that class, which uses an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object and its ",
 StyleBox["toString()", "MR"],
 " method to get the printable text representation of an arbitrary \
expression."
}], "Text",
 CellTags->"jlug:6.14.0.4",
 CellID->2303],

Cell["\<\
public boolean packetArrived(PacketArrivedEvent evt) throws MathLinkException \
{
\tKernelLink ml = (KernelLink) evt.getSource();
\tExpr e = ml.getExpr();
\tstrm.println(\"Packet type was \" + pktToName(evt.getPktType()) + 
\t\t\t\t\t\". Contents follows.\"); 
\tstrm.println(e.toString());
\te.dispose();
\treturn true;
}\
\>", "Program",
 CellTags->"jlug:6.14.0.4",
 CellID->12760],

Cell[TextData[{
 "Whether you use the ",
 Cell[BoxData[
  ButtonBox["PacketPrinter",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketPrinter"]], "InlineFormula"],
 " class or not, this technique is useful to see what expressions are being \
passed around. This is often used in conjunction with the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 StyleBox[" peekExpr()", "MR"],
 " method, which reads an expression off the link but then resets the link so \
that the expression is not consumed. In this way, you can look at expressions \
arriving on links without interfering with the rest of the link-reading code \
in your program. The ",
 Cell[BoxData[
  ButtonBox["PacketPrinter",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketPrinter"]], "InlineFormula"],
 " code above does not use ",
 StyleBox["peekExpr()", "MR"],
 ", but it has the same effect since the resetting of the link is handled \
elsewhere."
}], "Text",
 CellTags->"jlug:6.14.0.4",
 CellID->19357]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exprs as Arguments to KernelLink Methods", "Subsection",
 CellTags->{"jlug:6.14.0.5", "TableOfContents_1.6.14.5"},
 CellID->2324],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods ",
 StyleBox["evaluate()", "MR"],
 ", ",
 StyleBox["evaluateToInputForm()", "MR"],
 ", ",
 StyleBox["evaluateToOutputForm()", "MR"],
 ", ",
 StyleBox["evaluateToImage()", "MR"],
 ", and ",
 StyleBox["evaluateToTypeset()", "MR"],
 " take the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression to evaluate as either a string or an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ". ",
 ButtonBox["The \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] \
Methods",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#25472"],
 " discusses why and how you would use an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object to provide the input instead of a string. Here we examine one \
trivial example comparing how you would send 2+2 to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as both a string and as an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ". In the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " case we build the expression on a loopback link and then read the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " off this link. For all but the simplest expressions, this is generally \
easier than trying to use the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " constructors."
}], "Text",
 CellTags->"jlug:6.14.0.5",
 CellID->6477],

Cell["\<\
// Send input as a string:
\tString result = MathLink.evaluateToOutputForm(\"2+2\", 0);
\t
// Send input as an Expr:
\tLoopbackLink loop = MathLinkFactory.createLoopbackLink();
\t// Create the expression 2+2 on the loopback link
\tloop.putFunction(\"Plus\", 2);
\t\tloop.put(2);
\t\tloop.put(2);
\tloop.endPacket();
\t// Now read the Expr off the loopback link
\tExpr e = loop.getExpr();
\t// We are done with the loopback link now.
\tloop.close();
\tString result = ml.evaluateToOutputForm(e, 0);
\te.dispose();\
\>", "Program",
 CellTags->"jlug:6.14.0.5",
 CellID->5108]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examining and Manipulating Exprs", "Subsection",
 CellTags->{"jlug:6.14.0.6", "TableOfContents_1.6.14.6"},
 CellID->21113],

Cell[TextData[{
 "Like expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects are ",
 StyleBox["immutable",
  FontSlant->"Italic"],
 ", meaning that they cannot be modified once they have been created. \
Operations that might appear to modify an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ", like the ",
 StyleBox["insert()", "MR"],
 " method, actually copy the original , modify this copy, and then return a \
new immutable object. One consequence of being immutable is that the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class is ",
 StyleBox["thread-safe",
  FontSlant->"Italic"],
 "\[LongDash]multiple threads can operate on the same ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " without worrying about synchronization."
}], "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->14887],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class provides a minimal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-like API for examination and manipulation. The functions are generally \
named after their ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " counterparts, and they operate in the same way. This section will only \
provide a brief review of the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " API. Consult the JavaDocs (found in the ",
 StyleBox["JLink/Documentation/JavaDoc", "MR"],
 " directory) for more information about these methods."
}], "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->19801],

Cell[TextData[{
 "Here are some methods for learning about the structure of an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ": "
}], "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->22850],

Cell["\<\
public Expr head();
public Expr[] args();
public int length();
public int[] dimensions();\
\>", "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->14460],

Cell[TextData[{
 "There are a number of methods whose names end in \[OpenCurlyDoubleQuote]Q\
\[CloseCurlyDoubleQuote], following the same naming pattern as in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for functions that return ",
 StyleBox["true", "MR"],
 " or ",
 StyleBox["false", "MR"],
 ". This is not the complete list:"
}], "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->22428],

Cell["\<\
// A sampling of the \"Q\" methods
public boolean atomQ();
public boolean stringQ();
public boolean integerQ();
public boolean numberQ();
public boolean trueQ();
public boolean listQ();
public boolean vectorQ();
public boolean matrixQ();\
\>", "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->12993],

Cell[TextData[{
 "There are several methods for taking apart and building up an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ". Like in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", part numbers and indices are 1-based. You can also supply negative \
numbers to count backwards from the end. Many ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " methods throw an ",
 StyleBox["IllegalArgumentException", "MR"],
 " if they are called with invalid input, such as a part index larger than \
the length of the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ". These exceptions parallel the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " error messages you would get if you made the same error in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code."
}], "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->27384],

Cell["\<\
public Expr part(int index);
public Expr part(int[] indices);
public Expr take(int n);
public Expr delete(int n);
public Expr insert(Expr e, int n);\
\>", "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->19405],

Cell[TextData[{
 "Here is some very simple code that demonstrates a few ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " operations."
}], "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->6540],

Cell["\<\
ml.evaluate(\"Expand[(x + y)^4]\");
ml.waitForAnswer();
Expr e1 = ml.getExpr();

System.out.println(\"e1 is:  \" + e1.toString());
System.out.println(\"the length is:  \" + e1.length());
System.out.println(\"the head is:  \" + e1.head().toString());
System.out.println(\"part [[2]] is:  \" + e1.part(2));
System.out.println(\"part [[-1]] is:  \" + e1.part(-1));
System.out.println(\"part [[2, 2]] is:  \" + e1.part(new int[]{2, 2}));
System.out.println(\"drop the last element:  \" + e1.delete(-1).toString());
System.out.println(\"e1 is unmodified:  \" + e1.toString());
Expr e2 = e1.insert(new Expr(new double[] {1.0, 2.0, 3.0}), 1);
System.out.println(\"e2 is:  \" + e2.toString());\
\>", "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->31111],

Cell["That code prints the following:", "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->28704],

Cell["\<\
e1 is:  Plus[Power[x,3],Times[3,Power[x,2],y],Times[3,x,Power[y,2]],Power[y,3]\
]
the length is:  4
the head is:  Plus
part [[2]] is:  Times[3,Power[x,2],y]
part [[-1]] is:  Power[y,3]
part [[2, 2]] is:  Power[x,2]
drop the last element:  \
Plus[Power[x,3],Times[3,Power[x,2],y],Times[3,x,Power[y,2]]]
e1 is unmodified:  \
Plus[Power[x,3],Times[3,Power[x,2],y],Times[3,x,Power[y,2]],Power[y,3]]
e2 is:  Plus[{1.0,2.0,3.0},Power[x,3],Times[3,Power[x,2],y],Times[3,x,Power[y,\
2]],Power[y,3]]\
\>", "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->12835]
}, Open  ]],

Cell[CellGroupData[{

Cell["Disposing of Exprs", "Subsection",
 CellTags->{"jlug:6.14.0.7", "TableOfContents_1.6.14.7"},
 CellID->32356],

Cell[TextData[{
 "We have seen the ",
 StyleBox["dispose()", "MR"],
 " method used frequently in this discussion of the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class. An ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object might make use of a loopback ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " internally, and any time a Java class holds such a non-Java resource it is \
important to provide programmers with a ",
 StyleBox["dispose()", "MR"],
 " method that causes the resource be released. Although the finalizer for \
the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " class will call ",
 StyleBox["dispose()", "MR"],
 ", you cannot rely on the finalizer ever being called. Although it is good \
style to always call ",
 StyleBox["dispose()", "MR"],
 " on an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " when you are finished using it, you should know that many of the \
operations you can perform on an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " will cause it to be \[OpenCurlyDoubleQuote]unwound\[CloseCurlyDoubleQuote] \
off its internal loopback link and cause that link to be closed. After this \
happens, the ",
 StyleBox["dispose()", "MR"],
 " method is unnecessary. Calling the ",
 StyleBox["toString()", "MR"],
 " method is an example of an operation that makes ",
 StyleBox["dispose()", "MR"],
 " unnecessary, and in fact virtually any operation that queries the \
structure of an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " or extracts a part will have this effect. This is useful to know since it \
allows shorthand code like this:"
}], "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->6072],

Cell["\<\
System.out.println(\"the result was \" + ml.getExpr().toString());\
\>", "Program",
 CellTags->"jlug:6.14.0.7",
 CellID->29350],

Cell["instead of the more verbose:", "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->18823],

Cell["\<\
Expr e = ml.getExpr();
System.out.println(\"the result was \" + e.toString());
e.dispose();\
\>", "Program",
 CellTags->"jlug:6.14.0.7",
 CellID->14485],

Cell[TextData[{
 "You should get in the habit of calling ",
 StyleBox["dispose()", "MR"],
 " explicitly on ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects. In cases where it is inconvenient to store an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " in a named variable, and you know that the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " does not need to be disposed, then you can skip calling it."
}], "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->20556],

Cell[TextData[{
 "Because extracting any piece of an existing expression will make ",
 StyleBox["dispose()", "MR"],
 " unnecessary, you do not have to worry about calling ",
 StyleBox["dispose()", "MR"],
 " on ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects that are obtained as parts of another one:"
}], "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->23216],

Cell["\<\
Expr e = ml.getExpr();
// The moment that head() or part() are called on e below, you know that \
neither
// e, e2, nor e3 need to be disposed.
Expr e2 = e.head();
Expr e3 = e.part(1);\
\>", "Program",
 CellTags->"jlug:6.14.0.7",
 CellID->9383296],

Cell[TextData[{
 "You cannot reliably use an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " object after ",
 StyleBox["dispose()", "MR"],
 " has been called on it. We have already seen that ",
 StyleBox["dispose()", "MR"],
 " is often unnecessary because many ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " objects have already had their internal loopback links closed. For such an \
",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 ", ",
 StyleBox["dispose()", "MR"],
 " will have no effect at all and there would be no problem continuing to use \
the ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " after ",
 StyleBox["dispose()", "MR"],
 " had been called. That being said, it is ",
 StyleBox["horrible",
  FontSlant->"Italic"],
 " style to ever try to use an ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " after calling ",
 StyleBox["dispose()", "MR"],
 ". A call to ",
 StyleBox["dispose()", "MR"],
 " should always be an unambiguous indicator that you have no further use for \
the given ",
 Cell[BoxData[
  ButtonBox["Expr",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/Expr"]], "InlineFormula"],
 " or any part of it."
}], "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->9357]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Threads, Blocking, and Yielding ", "Section",
 CellTags->{"2.15", "jlug:6.15.0.0", "TableOfContents_1.6.15"},
 CellID->189],

Cell[TextData[{
 "The classes that implement the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " interfaces are not thread-safe. This means that if you write a ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " program in which one link object is used by more than one thread, you need \
to pay careful attention to concurrency issues. The relevant methods in the \
link implementation classes are synchronized, so at the individual method \
level there is no chance that two threads can try to use the link at the same \
time. However, this is not enough to guarantee thread safety because \
interactions with the link typically involve an entire transaction, \
encompassing a multistep write and read of the result. This entire \
transaction must be guarded. This is done by using ",
 StyleBox["synchronized", "MR"],
 " blocks to ensure that the threads do not interfere with each other\
\[CloseCurlyQuote]s use of the link. "
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->16100],

Cell[TextData[{
 "The \[OpenCurlyDoubleQuote]evaluateTo\[CloseCurlyDoubleQuote] methods are \
",
 StyleBox["synchronized", "MR"],
 ", and they encapsulate an entire transaction within one call, so if you use \
only these methods you will have no concerns. On the other hand, if you use \
",
 StyleBox["evaluate()", "MR"],
 " and ",
 StyleBox["waitForAnswer()", "MR"],
 ", or any other technique that splits up a single transaction across \
multiple method calls, you should wrap the transaction in a ",
 StyleBox["synchronized", "MR"],
 " block, as follows:"
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->19812],

Cell["\<\
synchronized (ml) {
\tml.evaluate(\"2+2\");
\tml.waitForAnswer();
\tint result = ml.getInteger();
}\
\>", "Program",
 CellTags->"jlug:6.15.0.0",
 CellID->30648],

Cell["\<\
Synchronization is only an issue if you have multiple threads using the same \
link.\
\>", "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->9523],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " functions that read from a link will block until data arrives on that \
link. For example, when you call ",
 StyleBox["evaluateToOutputForm()", "MR"],
 ", it will not return until ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has computed and returned the result. This might be a problem if the \
thread on which ",
 StyleBox["evaluateToOutputForm()", "MR"],
 " was called needs to stay active\[LongDash]for example, if it is the AWT \
thread, which processes user interface events."
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->19851],

Cell[TextData[{
 "How to handle blocking is a general programming problem, and there are a \
number of solutions. The Java environment is multithreaded, and thus an \
obvious solution is simply to make ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " calls on a thread that does not need to be continuously responsive to \
other events in the system."
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->24474],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " has the notion of a \[OpenCurlyDoubleQuote]yield function,\
\[CloseCurlyDoubleQuote] which is a function you can designate to be called \
from the internals of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " while ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is blocking, waiting for input to arrive from the other side. A primary \
use for yield functions was to solve the blocking problem on operating \
systems that did not have threads, or for programming languages that did not \
have portable threading libraries. The way this would typically work is that \
your single-threaded program would install a yield function that ran its main \
event loop, so that the program could process user interface events even \
while it was waiting for ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " data. "
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->28633],

Cell[TextData[{
 "With Java, this motivation goes away. Rather than using a yield function to \
allow your program\[CloseCurlyQuote]s only thread to still handle events \
while blocking, you simply start a separate thread from the user interface \
thread and let it happily block inside ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " calls. Despite the limited usefulness of yield functions in Java programs, \
",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " provides the ability to use them anyway."
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->29891],

Cell["\<\
// From the MathLink interface
public boolean setYieldFunction(Class cls, Object obj, String methName);\
\>", "Program",
 CellTags->"jlug:6.15.0.0",
 CellID->27200],

Cell[TextData[{
 "The ",
 StyleBox["setYieldFunction()", "MR"],
 " method in the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface takes three arguments that identify the function to be called. \
These arguments are designed to accommodate static and nonstatic methods, so \
only two of the three need to be specified. For a static method, supply the \
method\[CloseCurlyQuote]s ",
 StyleBox["Class", "MR"],
 " and its name, leaving the second argument ",
 StyleBox["null", "MR"],
 ". For a nonstatic method, supply the object on which you want the method \
called and the method\[CloseCurlyQuote]s name, leaving the ",
 StyleBox["Class", "MR"],
 " argument ",
 StyleBox["null", "MR"],
 ". The function must be public, take no arguments, and return a ",
 StyleBox["boolean", "MR"],
 ", for example:"
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->19854],

Cell["public boolean myYielder();", "Program",
 CellTags->"jlug:6.15.0.0",
 CellID->9990],

Cell[TextData[{
 "The function you specify will be called periodically while ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is blocking in a call that tries to read from the link. The return value \
is used to indicate whether ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " should back out of the read call and return right away. Backing out of a \
read call will cause a ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " to be thrown by the method that is reading from the link. This ",
 Cell[BoxData[
  ButtonBox["MathLinkException",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkException"]], "InlineFormula"],
 " is recoverable (meaning that ",
 StyleBox["clearError()", "MR"],
 " will return ",
 StyleBox["true", "MR"],
 "), so you could call ",
 StyleBox["waitForAnswer()", "MR"],
 " again later and get the result when it arrives if you want. Return ",
 StyleBox["false", "MR"],
 " from the yield function to indicate that no action should be taken (thus \
",
 StyleBox["false", "MR"],
 " is the normal return value for a yield function), and return ",
 StyleBox["true", "MR"],
 " to indicate that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " should back out of the reading call. To turn off the yield function, call \
",
 StyleBox["setYieldFunction(null, null, null)", "MR"],
 "."
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->25697],

Cell[TextData[{
 "Very few ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programmers will have any need for yield functions. They are a solution to \
a problem that is better handled in Java by using multiple threads. About the \
only reasonable motivation for using a yield function is to be able to back \
out of a computation that is taking too long and either resists attempts to \
abort it, or you know you want to close the link anyway. This can also be \
done by calling ",
 StyleBox["abandonEvaluation()", "MR"],
 " on a separate thread. The ",
 StyleBox["abandonEvaluation()", "MR"],
 " method is described in ",
 ButtonBox["Aborting and Interrupting Computations.",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#19718"],
 " Note that ",
 StyleBox["abandonEvaluation()", "MR"],
 " uses a yield function internally, so calling it will wipe out any yield \
function you might have installed on your own."
}], "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->4919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Sending Object References to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellTags->{"2.15", "jlug:6.16.0.0", "TableOfContents_1.6.16"},
 CellID->26222],

Cell[TextData[{
 "Part 1 of this User Guide describes how to use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to allow ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to launch a Java runtime, load Java classes and directly execute Java \
methods. What this means for you, the reader of this tutorial, who is \
probably writing his or her own program to launch and communicate with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, is that you can have a very high-level interaction with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can send your own objects to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and use them in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code, but you have to take a special step to enable this type of \
interaction."
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->29331],

Cell[TextData[{
 "Consider what happens if you have written a Java front end to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel and a user of your program calls a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function that uses the \[OpenCurlyDoubleQuote]installable Java\
\[CloseCurlyDoubleQuote] features of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " and thus calls ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " launches a separate Java runtime and proceeds to direct all ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " traffic to that Java runtime. The kernel is blissfully unconcerned whether \
the front end that is driving it is the notebook front end or your Java \
program\[LongDash]it does the same thing in each case. This is fine and it is \
what many ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " programmers will want. You do not have to worry about doing anything \
special if some ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code happens to invoke the \[OpenCurlyDoubleQuote]installable Java\
\[CloseCurlyDoubleQuote] features of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 ", because a separate Java runtime will be used."
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->2376],

Cell[TextData[{
 "But what if ",
 StyleBox["you",
  FontSlant->"Italic"],
 " want to make use of the ability that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " gives ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to interact with Java objects? You might want to send Java object \
references to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and operate on them with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \[OpenCurlyDoubleQuote]operates\[CloseCurlyDoubleQuote] on Java objects by \
calling into Java, so any callbacks for such objects must be directed to ",
 StyleBox["your",
  FontSlant->"Italic"],
 " Java runtime. A further detail of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " is that it only supports one active Java runtime for all installable Java \
uses. What this all adds up to is that if you want to pass references to your \
own objects into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", then you must call ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 " and specify the link to ",
 StyleBox["your",
  FontSlant->"Italic"],
 " Java runtime, and you must do this before any function is executed that \
itself calls ",
 Cell[BoxData[
  ButtonBox["InstallJava",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/InstallJava"]], "InlineFormula"],
 ". Actually, a number of steps need to be taken to enable ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " callbacks into your Java environment, so ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " includes a special method in the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " interface, ",
 StyleBox["enableObjectReferences()", "MR"],
 ", that takes care of everything for you."
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->28583],

Cell["\<\
public void enableObjectReferences() throws MathLinkException;

// For sending object references:
public void put(Object obj) throws MathLinkException;
public void putReference(Object obj) throws MathLinkException;\
\>", "Program",
 CellTags->"jlug:6.16.0.0",
 CellID->26948],

Cell[TextData[{
 "After calling ",
 StyleBox["enableObjectReferences()", "MR"],
 ", you can use the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " interface\[CloseCurlyQuote]s ",
 StyleBox["put()", "MR"],
 " or  ",
 StyleBox["putReference()", "MR"],
 " methods to send Java objects to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and they will arrive as ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expressions that can be used in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code as described throughout ",
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ". Recall that the difference between the ",
 StyleBox["put()", "MR"],
 " and ",
 StyleBox["putReference()", "MR"],
 " methods is that ",
 StyleBox["put()", "MR"],
 " sends objects that have meaningful \[OpenCurlyDoubleQuote]value\
\[CloseCurlyDoubleQuote] representations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " (like arrays and strings) by value, and all others by reference. The ",
 StyleBox["putReference()", "MR"],
 " method sends everything as a reference. If you want to use ",
 StyleBox["enableObjectReferences()", "MR"],
 ", call it early on in your program, before you call ",
 StyleBox["putReference()", "MR"],
 ". It requires that the ",
 StyleBox["JLink.m", "MR"],
 " file be present in the expected location, which means that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " must be installed in the standard way on the machine that is running the \
kernel."
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->12723],

Cell[TextData[{
 "Once you have called ",
 StyleBox["enableObjectReferences()", "MR"],
 ", not only can you send Java objects to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can also read Java object references that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sends back to Java. The ",
 StyleBox["getObject()", "MR"],
 " method is used for this purpose. If a valid ",
 Cell[BoxData[
  ButtonBox["JavaObject",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/JavaObject"]], "InlineFormula"],
 " expression is waiting on the link, ",
 StyleBox["getObject()", "MR"],
 " will return the object that it refers to."
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->17982],

Cell["public Object getObject() throws MathLinkException;", "Program",
 CellTags->"jlug:6.16.0.0",
 CellID->22018],

Cell[TextData[{
 "If you call ",
 StyleBox["enableObjectReferences()", "MR"],
 " in your program, it is imperative that you do not try to write your own \
packet loop. Instead, you must use the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " methods that encapsulate the reading and handling of packets until a \
result is received. These methods are ",
 StyleBox["waitForAnswer()", "MR"],
 ", ",
 StyleBox["discardAnswer()", "MR"],
 ", ",
 StyleBox["evaluateToInputForm()", "MR"],
 ", ",
 StyleBox["evaluateToOutputForm()", "MR"],
 ", ",
 StyleBox["evaluateToImage()", "MR"],
 ", and ",
 StyleBox["evaluateToTypeset()", "MR"],
 ". If you want to see all the incoming packets yourself, use a ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " object in conjunction with one of these methods. This is discussed in ",
 ButtonBox["Using the PacketListener Interface",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8823"],
 "."
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->14776],

Cell[TextData[{
 "It is worthwhile to examine in more detail the question of why you would \
want to use ",
 StyleBox["enableObjectReferences()", "MR"],
 ". Traditionally, ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programmers have worked with the C API, which limits the types of data \
that can be passed back and forth between C and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions are not generally meaningful in a C program, this translates \
basically to numbers, strings, and arrays of these things. The native \
structures that are meaningful in your C or C++ program (structs, objects, \
functions, and so on) are not meaningful in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 StyleBox[".", "TI"],
 " As a result, programmers tend to use a simplistic one-way communication \
with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", decomposing the native data structures and objects into simple components \
like numbers and strings. Program logic and behavior is coded entirely in C \
or C++, with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " used solely for mathematical computations."
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->9220],

Cell[TextData[{
 "In contrast, ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " allows Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code to collaborate in a high-level way. You can easily code algorithms \
and other program behavior in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " if it is easier for you. As an example, say you are writing a Java servlet \
that needs to use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel in some way. Your servlet\[CloseCurlyQuote]s ",
 StyleBox["doGet()", "MR"],
 " method will be called with ",
 StyleBox["HttpServletRequest", "MR"],
 " and ",
 StyleBox["HttpServletResponse", "MR"],
 " objects as arguments. One approach would be to extract the information you \
need out of these objects, package it up in some way for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and send the desired computation for evaluation. But another approach \
would be simply to ",
 StyleBox["send the ",
  FontSlant->"Italic"],
 StyleBox["HttpServletRequest", "MR",
  FontSlant->"Italic"],
 StyleBox[" and ",
  FontSlant->"Italic"],
 StyleBox["HttpServletResponse", "MR",
  FontSlant->"Italic"],
 StyleBox[" objects themselves",
  FontSlant->"Italic"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can then use the features and syntax described in ",
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 " to code the behavior of the servlet in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", rather than in Java. Of course, these are just two extremes of a \
continuum. At one end you have the servlet behavior hard-coded into a \
compiled Java class file, and you make use of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a limited way, using a very narrow pipeline (narrow in the logical \
sense, passing only simple things like numbers, strings, or arrays). At the \
other end of the continuum you have a completely generic servlet that does \
nothing but forward all the work into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The behavior of the servlet is written completely in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can use this approach even if you do not need ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a mathematics engine\[LongDash]you might just find it easier to develop \
and debug your servlet logic in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. You can draw the line between Java and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " anywhere you like along the continuum, doing whatever amount of work you \
prefer in each language."
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->234550603],

Cell[TextData[{
 "In case you are wondering what such a generic servlet might look like, here \
is the ",
 StyleBox["doGet()", "MR"],
 " method:"
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->32182],

Cell["\<\
// ml.enableObjectReferences() must have been called prior, for example
// in the servlet's init method.
public void doGet(HttpServletRequest req, HttpServletResponse res)
                    throws ServletException, IOException {
\ttry {
\t\tml.putFunction(\"EvaluatePacket\", 1);
\t\tml.putFunction(\"DoGet\", 2);
\t\t// We could also use plain 'put' here, as these objects would be put
\t\t// by reference anyway.
\t\tml.putReference(req);
\t\tml.putReference(res);
\t\tml.endPacket();
\t\tml.discardAnswer();
\t} catch (MathLinkException e) {}
}\
\>", "Program",
 CellTags->"jlug:6.16.0.0",
 CellID->23856],

Cell[TextData[{
 "This would be accompanied by a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 StyleBox["DoGet", "MR"],
 " that takes the two Java object arguments and implements the servlet \
behavior. The syntax is explained in ",
 ButtonBox["Calling Java from ",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica"],
  FontSlant->"Italic"],
 ":"
}], "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->19490],

Cell["\<\
doGet[req_, resp_] :=
     JavaBlock[
\t\tModule[{outStream},
\t\t\toutStream = resp@getOutputStream[];
\t\t\toutStream@print[\"<HTML> <BODY>\"];
\t\t\toutStream@print[\"Hello World\"];
\t\t\toutStream@print[\"</BODY> </HTML>\"];
\t\t]
\t]
]\
\>", "Program",
 CellTags->"jlug:6.16.0.0",
 CellID->8925]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some Special User Interface Classes", "Section",
 CellTags->{"2.17", "jlug:6.17.0.0", "TableOfContents_1.6.17"},
 CellID->8928],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
 CellTags->{"jlug:6.17.0.1", "TableOfContents_1.6.17.1"},
 CellID->29492],

Cell[TextData[{
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " has several classes that provide some very high-level user interface \
components for your Java programs. They are discussed individually in the \
next subsections. These classes are in the new ",
 StyleBox["com.wolfram.jlink.ui", "MR"],
 " package, so do not forget to import that package if you want to use the \
classes."
}], "Text",
 CellTags->"jlug:6.17.0.1",
 CellID->12433]
}, Open  ]],

Cell[CellGroupData[{

Cell["ConsoleWindow", "Subsection",
 CellTags->{"jlug:6.17.0.2", "TableOfContents_1.6.17.2"},
 CellID->23840],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ConsoleWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/ConsoleWindow"]], "InlineFormula"],
 " class gives you a top-level frame window that displays output printed to \
the ",
 StyleBox["System.out", "MR"],
 " and/or ",
 StyleBox["System.err", "MR"],
 " streams. It has no input facilities. This is the class used to implement \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["ShowJavaConsole",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/ShowJavaConsole"]], "InlineFormula"],
 ", discussed in ",
 ButtonBox["The Java Console Window",
  BaseStyle->"Link",
  ButtonData->"paclet:JLink/tutorial/CallingJavaFromMathematica#22549"],
 ". This class is quite useful for debugging Java programs that do not have a \
convenient place for console output. An example is a servlet\[LongDash]rather \
than digging around in your servlet container\[CloseCurlyQuote]s log files \
after every run, you can just display a ",
 Cell[BoxData[
  ButtonBox["ConsoleWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/ConsoleWindow"]], "InlineFormula"],
 " and see debugging output as it happens."
}], "Text",
 CellTags->"jlug:6.17.0.2",
 CellID->6766],

Cell[TextData[{
 "This class is a singleton, meaning that there is only ever one instance in \
existence. It has no public constructors. You call the static ",
 StyleBox["getInstance()", "MR"],
 " method to acquire the sole ",
 Cell[BoxData[
  ButtonBox["ConsoleWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/ConsoleWindow"]], "InlineFormula"],
 " object. Here is a code fragment that demonstrates how to use ",
 Cell[BoxData[
  ButtonBox["ConsoleWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/ConsoleWindow"]], "InlineFormula"],
 ". You can find more information on this class in its JavaDoc page."
}], "Text",
 CellTags->"jlug:6.17.0.2",
 CellID->1735],

Cell["\<\
// Don't forget to import it (a different package than the rest of J/Link):
// import com.wolfram.jlink.ui.ConsoleWindow;

ConsoleWindow cw = ConsoleWindow.getInstance();
cw.setLocation(100, 100);
cw.setSize(450, 400);
cw.show();
// Sepcify that we want to capture System.out and System.err.
cw.setCapture(ConsoleWindow.STDOUT | ConsoleWindow.STDERR);
System.out.println(\"hello world from stdout\");
System.err.println(\"hello world from stderr\");\
\>", "Program",
 CellTags->"jlug:6.17.0.2",
 CellID->19810]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathSessionPane", "Subsection",
 CellTags->{"jlug:6.17.0.3", "TableOfContents_1.6.17.3"},
 CellID->11599],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " class provides an ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "MR"]], "InlineFormula"],
 StyleBox["/", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "MR"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session window complete with a full set of editing functions including \
cut/copy/paste/undo/redo, support for graphics, syntax coloring, and \
customizable font styles. It is a bit like the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel\[CloseCurlyQuote]s \[OpenCurlyDoubleQuote]terminal\
\[CloseCurlyDoubleQuote] interface, but much more sophisticated. You can \
easily drop it into any Java program that needs a full command-line interface \
to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The class is a Java Bean and will work nicely in a GUI builder \
environment. It has a very large number of properties that allow its look and \
behavior to be customized."
}], "Text",
 CellTags->"jlug:6.17.0.3",
 CellID->11837],

Cell[TextData[{
 "The best way to familiarize yourself with the features of ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " is to run the ",
 StyleBox["SimpleFrontEnd", "MR"],
 " example program, found in the ",
 StyleBox["JLink/Examples/Part2/SimpleFrontEnd", "MR"],
 " directory. ",
 StyleBox["SimpleFrontEnd", "MR"],
 " is little more than a frame and menu bar that host a ",
 StyleBox["MathSessionPane", "MR"],
 ". Essentially all the features you see are built into ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 ", including the keyboard commands and the properties settable via the ",
 StyleBox["Options", "MenuName"],
 " menu.To run this example, go to the ",
 StyleBox["SimpleFrontEnd", "MR"],
 " directory and execute the following command line:"
}], "Text",
 CellTags->"jlug:6.17.0.3",
 CellID->31982],

Cell["\<\
(Windows)
java -classpath SimpleFrontEnd.jar;..\\..\\..\\JLink.jar SimpleFrontEnd

(Linux, Unix, Mac OS X):
java -classpath SimpleFrontEnd.jar:../../../JLink.jar SimpleFrontEnd\
\>", "Program",
 CellTags->"jlug:6.17.0.3",
 CellID->7328],

Cell[TextData[{
 "The application window will appear and you will be prompted to enter a path \
to a kernel to launch. Once ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is running, try various computations, including plots. Experiment with the \
numerous settings and commands on the menus. One feature of ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " not exposed via the ",
 StyleBox["SimpleFrontEnd", "MR"],
 " menu bar is a highly customizable syntax coloring capability. The default \
behavior is to color built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols, but you can get as fancy as you like, such as specifying that \
symbols from a certain list should always appear in red, and symbols from a \
certain package should always appear in blue."
}], "Text",
 CellTags->"jlug:6.17.0.3",
 CellID->29352],

Cell[TextData[{
 "The methods and properties of ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " are described in greater detail in the JavaDocs, which are found in the ",
 StyleBox["JLink/Documentation/JavaDoc", "MR"],
 " directory."
}], "Text",
 CellTags->"jlug:6.17.0.3",
 CellID->11369]
}, Open  ]],

Cell[CellGroupData[{

Cell["BracketMatcher and SyntaxTokenizer", "Subsection",
 CellTags->{"jlug:6.17.0.4", "TableOfContents_1.6.17.4"},
 CellID->31244],

Cell[TextData[{
 "The auxiliary classes ",
 Cell[BoxData[
  ButtonBox["BracketMatcher",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/BracketMatcher"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SyntaxTokenizer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/SyntaxTokenizer"]], "InlineFormula"],
 " are used by ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " but can also be used separately to provide these services in your own \
programs. An example of the sort of program that would find these classes \
useful is a text-editor component that needs to have special features for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programmers."
}], "Text",
 CellTags->"jlug:6.17.0.4",
 CellID->21794],

Cell[TextData[{
 "These classes are described in greater detail in their JavaDoc pages. The \
JavaDocs for ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " are found in the ",
 StyleBox["JLink/Documentation/JavaDoc", "MR"],
 " directory. You can also look to see how they are used in the source code \
for the ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " class (",
 StyleBox["MathSessionPane.java", "MR"],
 ")."
}], "Text",
 CellTags->"jlug:6.17.0.4",
 CellID->6608],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["BracketMatcher",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/BracketMatcher"]], "InlineFormula"],
 " class locates matching bracket pairs (any of (), {}, [], and (**)) in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code. It ignores brackets within strings and within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " comments, and it can accommodate nested comments. It searches in the \
typical way\[LongDash]expanding the current selection left and right to find \
the first enclosing matching brackets. To see its behavior in action, simply \
run the ",
 StyleBox["SimpleFrontEnd", "MR"],
 " sample program discussed in the previous ",
 ButtonBox["section",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#11599"],
 " on ",
 Cell[BoxData[
  ButtonBox["MathSessionPane",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathSessionPane"]], "InlineFormula"],
 " and experiment with its bracket-matching feature."
}], "Text",
 CellTags->"jlug:6.17.0.4",
 CellID->9252],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SyntaxTokenizer",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/SyntaxTokenizer"]], "InlineFormula"],
 " is a utility class that can break up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code into 4 syntax classes: strings, comments, symbols, and normal \
(meaning everything else). You can use it to implement syntax coloring or a \
code analysis tool that can extract all comments or symbols from a file of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " code."
}], "Text",
 CellTags->"jlug:6.17.0.4",
 CellID->11647]
}, Open  ]],

Cell[CellGroupData[{

Cell["InterruptDialog", "Subsection",
 CellTags->{"jlug:6.17.0.5", "TableOfContents_1.6.17.5"},
 CellID->17432],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " class gives you an \[OpenCurlyDoubleQuote]Interrupt Evaluation\
\[CloseCurlyDoubleQuote] dialog box similar to the one you see in the \
notebook front end when you choose ",
 StyleBox[ButtonBox["Interrupt Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/InterruptEvaluation"], "MenuName"],
 " from the ",
 StyleBox["Evaluation", "MenuName"],
 " menu. The dialog box that appears has choices for aborting, quitting the \
kernel, and so on, depending on what the kernel is doing at the time."
}], "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->9535],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " constructor takes a ",
 StyleBox["Dialog", "MR"],
 " or ",
 StyleBox["Frame", "MR"],
 " instance that will be the parent window of the dialog box. What you supply \
for this argument will typically be the main top-level window in your \
application. ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " implements the ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface, and you use it like any other ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 ": "
}], "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->7208],

Cell["\<\
// Don't forget to import it (a different package than the rest of J/Link):
// import com.wolfram.jlink.ui.InterruptDialog;

ml.addPacketListener(new InterruptDialog(myParentFrame));\
\>", "Program",
 CellTags->"jlug:6.17.0.5",
 CellID->3264],

Cell[TextData[{
 "After the above line of code is executed, whenever you interrupt a \
computation (by sending an ",
 StyleBox["MLINTERRUPTMESSAGE", "MR"],
 " or, more commonly, by calling the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " ",
 StyleBox["interruptEvaluation()", "MR"],
 " method), a modal dialog box will appear with choices for how to proceed."
}], "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->3497],

Cell[TextData[{
 "The ",
 StyleBox["SimpleFrontEnd", "MR"],
 " sample program discussed in the section ",
 ButtonBox["MathSessionPane",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#11599"],
 " makes use of an ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 ". To see it in action, launch that sample program and execute the following \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " statement:"
}], "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->23243],

Cell[BoxData[
 RowBox[{"While", "[", "True", "]"}]], "Input",
 CellTags->"jlug:6.17.0.5",
 CellID->27649],

Cell[TextData[{
 "Then select ",
 StyleBox["Interrupt Evaluation", "SR"],
 " from the ",
 StyleBox["Kernel", "SR"],
 " menu. The ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " dialog box will appear and you can click the ",
 StyleBox["Abort Command Being Evaluated", "SR"],
 " button to stop the computation. To use an ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " in your own program, your user interface must provide a means for users to \
send an interrupt request, such as an ",
 StyleBox["Interrupt", "SR"],
 " button or special key combination. In response to this action, your \
program would call the ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " ",
 StyleBox["interruptEvaluation()", "MR"],
 " method."
}], "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->22015],

Cell[TextData[{
 "That a behavior as complex as a complete Interrupt Evaluation dialog box \
can be plugged into a Java program with only a single line of code is a \
testament to the versatility of the ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 " interface, described in ",
 ButtonBox["Using the PacketListener Interface",
  BaseStyle->"Link",
  ButtonData->
   "paclet:JLink/tutorial/WritingJavaProgramsThatUseMathematica#8823"],
 ". The ",
 Cell[BoxData[
  ButtonBox["InterruptDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/InterruptDialog"]], "InlineFormula"],
 " class works by monitoring the incoming flow of packets from the kernel and \
detecting the special type of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MenuPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MenuPacket"], "MR"]], "InlineFormula"],
 " that the kernel sends after an interrupt request. Anytime you have some \
application logic that needs to know about packets that arrive from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you should implement it as a ",
 Cell[BoxData[
  ButtonBox["PacketListener",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/PacketListener"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->26841]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Writing Applets", "Section",
 CellTags->{"jlug:6.18.0.0", "TableOfContents_1.6.18"},
 CellID->20615],

Cell[TextData[{
 "This User Guide has presented a lot of information about how to use ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " to enable ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functionality in Java programs, whether those Java programs are \
applications, JavaBeans, servlets, applets, or anything else. If you want to \
write an applet that makes use of a local ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, you have some special considerations because you will need to \
escape the Java security \[OpenCurlyDoubleQuote]sandbox\
\[CloseCurlyDoubleQuote] within which the browser runs applets."
}], "Text",
 CellTags->"jlug:6.18.0.0",
 CellID->10904],

Cell[TextData[{
 "The only thing that ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " needs special browser security permission for is to load the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " native library. The only reason the native library is required, or even \
exists at all, is to perform the translation between Java calls in the ",
 StyleBox["NativeLink", "MR"],
 " class and Wolfram Research\[CloseCurlyQuote]s platform-dependent ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. ",
 StyleBox["NativeLink", "MR"],
 " is the class that implements the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " interface in terms of native methods. Currently, every time you call ",
 Cell[BoxData[
  ButtonBox["MathLinkFactory",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkFactory"]], "InlineFormula"],
 StyleBox[".createMathLink()", "MR"],
 " or ",
 Cell[BoxData[
  ButtonBox["MathLinkFactory",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/MathLinkFactory"]], "InlineFormula"],
 StyleBox[".createKernelLink()", "MR"],
 ", an instance of the ",
 StyleBox["NativeLink", "MR"],
 " class is created, so the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " native library must be loaded. In other words, the only thing in ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " that needs the native library is the ",
 StyleBox["NativeLink", "MR"],
 " class, but currently all ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["MathLink",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/java/MathLink"],
   FontSlant->"Plain"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["KernelLink",
   BaseStyle->"Link",
   ButtonData->"paclet:JLink/ref/java/KernelLink"]], "InlineFormula"],
 " objects use a ",
 StyleBox["NativeLink", "MR"],
 " object. You cannot do anything with ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " without requiring the native library to be loaded."
}], "Text",
 CellTags->"jlug:6.18.0.0",
 CellID->2599],

Cell[TextData[{
 "Different browsers have different requirements for allowing applets to load \
native libraries. In many cases, the applet must be \
\[OpenCurlyDoubleQuote]signed,\[CloseCurlyDoubleQuote] and the browser must \
have certain settings enabled. Note that letting Java applets launch local \
kernels is an extreme breach of security, since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can read sensitive files, delete files, and so on. It is probably not a \
very good idea in general for users to allow applets to blast such an \
enormous hole in their browser\[CloseCurlyQuote]s security sandbox. A better \
choice is to have Java applets use a kernel residing on the server. In this \
scenario, the browser\[CloseCurlyQuote]s Java runtime does not need to load \
any local native libraries, so there are no security issues to overcome. This \
requires significant support on both the client and server side. This support \
is not part of ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " itself, but it is a good example of the sort of programs ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " can be used to create."
}], "Text",
 CellTags->"jlug:6.18.0.0",
 CellID->20136]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Writing Java Programs that Use Mathematica - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "title" -> "Writing Java Programs that Use Mathematica", "summary" -> 
    "The first part of this User Guide describes using J/Link to allow you to \
call from Mathematica into Java, thereby extending the Mathematica \
environment to include the functionality in all existing and future Java \
classes. This part shows you how to use J/Link in the opposite direction, as \
a means to write Java programs that use the Mathematica kernel as a \
computational engine. J/Link uses MathLink, Wolfram Research's protocol for \
sending data and commands between programs. Many of the concepts and \
techniques in J/Link programming are the same as those for programming with \
the MathLink C-language API. The J/Link documentation is not intended to be \
an encyclopedic compendium of everything you need to know to write Java \
programs that use MathLink. Programmers may have to rely a little on the \
general documentation of MathLink programming. Many of the functions J/Link \
provides have C-language counterparts that are identical or nearly so. If you \
have not read Calling Java from Mathematica, you should at least skim it at \
some point. Your Java 'front end' can use the same techniques for calling \
Java methods from Mathematica code and passing Java objects as arguments that \
programmers use when running the kernel from the notebook front end. This \
allows you to have a very high-level interface between Java and Mathematica. \
When you are writing MathLink programs in C, you have to think about passing \
and returning simple things like strings and integers. With J/Link you can \
pass Java objects back and forth between Java and Mathematica. J/Link truly \
obliterates the boundary between Java and Mathematica.", "uri" -> 
    "JLink/tutorial/WritingJavaProgramsThatUseMathematica", "type" -> 
    "Tutorial", "label" -> "J Link Tutorial", "paclet" -> "JLink", "context" -> 
    "", "keywords" -> {}, "synonyms" -> {}, "status" -> "None", "built" -> 
    "{2007, 4, 20, 15, 31, 48.2600780}", "index" -> True}, 
  "SearchTextTranslated" -> "", "SearchText" -> ""},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 19, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "jlug:6.1.0.0"->{
  Cell[958, 43, 101, 2, 70, "Section",
   CellTags->{"jlug:6.1.0.0", "TableOfContents_1.6.1"},
   CellID->15141],
  Cell[1062, 47, 761, 25, 70, "Text",
   CellTags->"jlug:6.1.0.0",
   CellID->7711],
  Cell[1826, 74, 1239, 36, 70, "Text",
   CellTags->"jlug:6.1.0.0",
   CellID->28253],
  Cell[3068, 112, 1341, 38, 70, "Text",
   CellTags->"jlug:6.1.0.0",
   CellID->6868],
  Cell[4412, 152, 921, 19, 70, "Text",
   CellTags->"jlug:6.1.0.0",
   CellID->25547],
  Cell[5336, 173, 3048, 92, 70, "Text",
   CellTags->"jlug:6.1.0.0",
   CellID->27644],
  Cell[8387, 267, 418, 11, 70, "Text",
   CellTags->"jlug:6.1.0.0",
   CellID->32662]},
 "TableOfContents_1.6.1"->{
  Cell[958, 43, 101, 2, 70, "Section",
   CellTags->{"jlug:6.1.0.0", "TableOfContents_1.6.1"},
   CellID->15141]},
 "2.1"->{
  Cell[8842, 283, 171, 7, 70, "Section",
   CellTags->{"2.1", "jlug:6.2.0.0", "TableOfContents_1.6.2"},
   CellID->32757]},
 "jlug:6.2.0.0"->{
  Cell[8842, 283, 171, 7, 70, "Section",
   CellTags->{"2.1", "jlug:6.2.0.0", "TableOfContents_1.6.2"},
   CellID->32757],
  Cell[9016, 292, 646, 18, 70, "Text",
   CellTags->"jlug:6.2.0.0",
   CellID->20037],
  Cell[9665, 312, 610, 14, 70, "Text",
   CellTags->"jlug:6.2.0.0",
   CellID->12859],
  Cell[10278, 328, 539, 15, 70, "Text",
   CellTags->"jlug:6.2.0.0",
   CellID->8723]},
 "TableOfContents_1.6.2"->{
  Cell[8842, 283, 171, 7, 70, "Section",
   CellTags->{"2.1", "jlug:6.2.0.0", "TableOfContents_1.6.2"},
   CellID->32757]},
 "2.3"->{
  Cell[10854, 348, 203, 7, 70, "Section",
   CellTags->{"2.3", "jlug:6.3.0.0", "TableOfContents_1.6.3"},
   CellID->9741]},
 "jlug:6.3.0.0"->{
  Cell[10854, 348, 203, 7, 70, "Section",
   CellTags->{"2.3", "jlug:6.3.0.0", "TableOfContents_1.6.3"},
   CellID->9741]},
 "TableOfContents_1.6.3"->{
  Cell[10854, 348, 203, 7, 70, "Section",
   CellTags->{"2.3", "jlug:6.3.0.0", "TableOfContents_1.6.3"},
   CellID->9741]},
 "jlug:6.3.0.1"->{
  Cell[11082, 359, 102, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.1", "TableOfContents_1.6.3.1"},
   CellID->27529],
  Cell[11187, 363, 956, 17, 70, "Text",
   CellTags->"jlug:6.3.0.1",
   CellID->778]},
 "TableOfContents_1.6.3.1"->{
  Cell[11082, 359, 102, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.1", "TableOfContents_1.6.3.1"},
   CellID->27529]},
 "jlug:6.3.0.2"->{
  Cell[12180, 385, 117, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.2", "TableOfContents_1.6.3.2"},
   CellID->12316],
  Cell[12300, 389, 1650, 55, 70, "Text",
   CellTags->"jlug:6.3.0.2",
   CellID->3035],
  Cell[13953, 446, 1068, 32, 70, "Text",
   CellTags->"jlug:6.3.0.2",
   CellID->22190],
  Cell[15024, 480, 1261, 42, 70, "Text",
   CellTags->"jlug:6.3.0.2",
   CellID->1842],
  Cell[16288, 524, 838, 23, 70, "Text",
   CellTags->"jlug:6.3.0.2",
   CellID->288]},
 "TableOfContents_1.6.3.2"->{
  Cell[12180, 385, 117, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.2", "TableOfContents_1.6.3.2"},
   CellID->12316]},
 "jlug:6.3.0.3"->{
  Cell[17163, 552, 109, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.3", "TableOfContents_1.6.3.3"},
   CellID->30106],
  Cell[17275, 556, 924, 28, 70, "Text",
   CellTags->"jlug:6.3.0.3",
   CellID->9040]},
 "TableOfContents_1.6.3.3"->{
  Cell[17163, 552, 109, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.3", "TableOfContents_1.6.3.3"},
   CellID->30106]},
 "jlug:6.3.0.4"->{
  Cell[18236, 589, 110, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.4", "TableOfContents_1.6.3.4"},
   CellID->8942],
  Cell[18349, 593, 907, 29, 70, "Text",
   CellTags->"jlug:6.3.0.4",
   CellID->19264],
  Cell[19259, 624, 164, 7, 70, "Program",
   CellTags->"jlug:6.3.0.4",
   CellID->22648],
  Cell[19426, 633, 400, 17, 70, "Text",
   CellTags->"jlug:6.3.0.4",
   CellID->27446]},
 "TableOfContents_1.6.3.4"->{
  Cell[18236, 589, 110, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.4", "TableOfContents_1.6.3.4"},
   CellID->8942]},
 "jlug:6.3.0.5"->{
  Cell[19863, 655, 98, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.5", "TableOfContents_1.6.3.5"},
   CellID->23805],
  Cell[19964, 659, 2288, 72, 70, "Text",
   CellTags->"jlug:6.3.0.5",
   CellID->15890]},
 "TableOfContents_1.6.3.5"->{
  Cell[19863, 655, 98, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.5", "TableOfContents_1.6.3.5"},
   CellID->23805]},
 "jlug:6.3.0.6"->{
  Cell[22289, 736, 107, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.6", "TableOfContents_1.6.3.6"},
   CellID->6729],
  Cell[22399, 740, 1814, 49, 70, "Text",
   CellTags->"jlug:6.3.0.6",
   CellID->24370],
  Cell[24216, 791, 1521, 40, 70, "Text",
   CellTags->"jlug:6.3.0.6",
   CellID->15350],
  Cell[25740, 833, 433, 14, 70, "Text",
   CellTags->"jlug:6.3.0.6",
   CellID->15006]},
 "TableOfContents_1.6.3.6"->{
  Cell[22289, 736, 107, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.6", "TableOfContents_1.6.3.6"},
   CellID->6729]},
 "jlug:6.3.0.7"->{
  Cell[26210, 852, 127, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.7", "TableOfContents_1.6.3.7"},
   CellID->31101],
  Cell[26340, 856, 1854, 49, 70, "Text",
   CellTags->"jlug:6.3.0.7",
   CellID->24393],
  Cell[28197, 907, 2895, 84, 70, "Text",
   CellTags->"jlug:6.3.0.7",
   CellID->3548]},
 "TableOfContents_1.6.3.7"->{
  Cell[26210, 852, 127, 2, 70, "Subsection",
   CellTags->{"jlug:6.3.0.7", "TableOfContents_1.6.3.7"},
   CellID->31101]},
 "jlug:6.4.0.0"->{
  Cell[31141, 997, 103, 2, 70, "Section",
   CellTags->{"jlug:6.4.0.0", "TableOfContents_1.6.4"},
   CellID->30556],
  Cell[31247, 1001, 1032, 27, 70, "Text",
   CellTags->"jlug:6.4.0.0",
   CellID->30974],
  Cell[32282, 1030, 518, 15, 70, "Program",
   CellTags->"jlug:6.4.0.0",
   CellID->3447],
  Cell[32803, 1047, 510, 15, 70, "Text",
   CellTags->"jlug:6.4.0.0",
   CellID->5021],
  Cell[33316, 1064, 1638, 57, 70, "Program",
   CellTags->"jlug:6.4.0.0",
   CellID->18283]},
 "TableOfContents_1.6.4"->{
  Cell[31141, 997, 103, 2, 70, "Section",
   CellTags->{"jlug:6.4.0.0", "TableOfContents_1.6.4"},
   CellID->30556]},
 "2.5"->{
  Cell[34991, 1126, 131, 2, 70, "Section",
   CellTags->{"2.5", "jlug:6.5.0.0", "TableOfContents_1.6.5"},
   CellID->15574]},
 "jlug:6.5.0.0"->{
  Cell[34991, 1126, 131, 2, 70, "Section",
   CellTags->{"2.5", "jlug:6.5.0.0", "TableOfContents_1.6.5"},
   CellID->15574],
  Cell[35125, 1130, 655, 16, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->4031],
  Cell[35783, 1148, 474, 16, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->12052],
  Cell[36260, 1166, 288, 10, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->27350],
  Cell[36551, 1178, 855, 26, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->1150],
  Cell[37409, 1206, 660, 16, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->16941],
  Cell[38072, 1224, 233, 6, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->21724],
  Cell[38308, 1232, 685, 15, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->13966],
  Cell[38996, 1249, 252, 7, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->3430],
  Cell[39251, 1258, 897, 24, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->31107],
  Cell[40151, 1284, 184, 6, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->30191],
  Cell[40338, 1292, 808, 22, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->18007],
  Cell[41149, 1316, 468, 18, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->11337],
  Cell[41620, 1336, 760, 24, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->15457],
  Cell[42383, 1362, 407, 13, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->12287],
  Cell[42793, 1377, 602, 15, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->27753],
  Cell[43398, 1394, 1784, 43, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->10383],
  Cell[45185, 1439, 675, 21, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->14945],
  Cell[45863, 1462, 378, 8, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->8909],
  Cell[46266, 1474, 124, 2, 70, "Subsection",
   CellTags->{"jlug:6.5.0.0", "TableOfContents_1.6.5.1"},
   CellID->32209],
  Cell[46393, 1478, 988, 30, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->9758],
  Cell[47418, 1513, 115, 2, 70, "Subsection",
   CellTags->{"jlug:6.5.0.0", "TableOfContents_1.6.5.1"},
   CellID->24221],
  Cell[47536, 1517, 433, 15, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->18588],
  Cell[47972, 1534, 135, 4, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->6422],
  Cell[48110, 1540, 532, 18, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->24946],
  Cell[48645, 1560, 85, 2, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->27506],
  Cell[48733, 1564, 197, 5, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->13030],
  Cell[48933, 1571, 855, 29, 70, "Text",
   CellTags->"jlug:6.5.0.0",
   CellID->16413],
  Cell[49791, 1602, 438, 9, 70, "Program",
   CellTags->"jlug:6.5.0.0",
   CellID->29168]},
 "TableOfContents_1.6.5"->{
  Cell[34991, 1126, 131, 2, 70, "Section",
   CellTags->{"2.5", "jlug:6.5.0.0", "TableOfContents_1.6.5"},
   CellID->15574]},
 "TableOfContents_1.6.5.1"->{
  Cell[46266, 1474, 124, 2, 70, "Subsection",
   CellTags->{"jlug:6.5.0.0", "TableOfContents_1.6.5.1"},
   CellID->32209],
  Cell[47418, 1513, 115, 2, 70, "Subsection",
   CellTags->{"jlug:6.5.0.0", "TableOfContents_1.6.5.1"},
   CellID->24221]},
 "jlug:6.6.0.0"->{
  Cell[50278, 1617, 111, 2, 70, "Section",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6"},
   CellID->29087],
  Cell[50392, 1621, 1345, 45, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->27681],
  Cell[51740, 1668, 538, 12, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->19964],
  Cell[52281, 1682, 179, 6, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->1340],
  Cell[52485, 1692, 107, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.1"},
   CellID->5686],
  Cell[52595, 1696, 366, 13, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->6021],
  Cell[52998, 1714, 110, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.2"},
   CellID->11662],
  Cell[53111, 1718, 252, 9, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->14721],
  Cell[53400, 1732, 107, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.3"},
   CellID->6064],
  Cell[53510, 1736, 154, 10, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->29309],
  Cell[53701, 1751, 104, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.4"},
   CellID->20415],
  Cell[53808, 1755, 103, 2, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->17902],
  Cell[53948, 1762, 101, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.5"},
   CellID->29873],
  Cell[54052, 1766, 1511, 42, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->17124],
  Cell[55566, 1810, 381, 15, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->23941],
  Cell[55950, 1827, 201, 8, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->32745],
  Cell[56154, 1837, 83, 2, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->31762],
  Cell[56240, 1841, 222, 8, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->28423],
  Cell[56465, 1851, 224, 8, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->27531],
  Cell[56692, 1861, 528, 23, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->4806],
  Cell[57223, 1886, 107, 2, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->12268],
  Cell[57333, 1890, 1108, 29, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->9318],
  Cell[58444, 1921, 107, 2, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->5602],
  Cell[58554, 1925, 671, 17, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->31907],
  Cell[59228, 1944, 134, 4, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->24307],
  Cell[59365, 1950, 151, 7, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->23481],
  Cell[59519, 1959, 135, 4, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->1012],
  Cell[59657, 1965, 193, 5, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->21136],
  Cell[59853, 1972, 219, 7, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->26630],
  Cell[60075, 1981, 136, 3, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->24114],
  Cell[60214, 1986, 385, 14, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->26809],
  Cell[60602, 2002, 67, 2, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->4084],
  Cell[60672, 2006, 75, 2, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->23556],
  Cell[60784, 2013, 101, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.6"},
   CellID->12290],
  Cell[60888, 2017, 534, 12, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->21293],
  Cell[61425, 2031, 408, 16, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->29996],
  Cell[61836, 2049, 1342, 48, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->29152],
  Cell[63181, 2099, 250, 9, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->1054],
  Cell[63434, 2110, 758, 16, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->25345],
  Cell[64195, 2128, 652, 19, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->14708],
  Cell[64850, 2149, 289, 9, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->248],
  Cell[65142, 2160, 312, 10, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->7491],
  Cell[65457, 2172, 450, 11, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->13712],
  Cell[65910, 2185, 653, 19, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->5131],
  Cell[66566, 2206, 461, 14, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->30114],
  Cell[67030, 2222, 137, 4, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->16439],
  Cell[67170, 2228, 289, 12, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->7958],
  Cell[67462, 2242, 218, 9, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->24722],
  Cell[67683, 2253, 336, 10, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->29704],
  Cell[68056, 2268, 101, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.7"},
   CellID->6995],
  Cell[68160, 2272, 681, 22, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->1052],
  Cell[68844, 2296, 214, 8, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->25269],
  Cell[69095, 2309, 98, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.8"},
   CellID->7479],
  Cell[69196, 2313, 264, 11, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->18238],
  Cell[69497, 2329, 107, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.9"},
   CellID->26423],
  Cell[69607, 2333, 845, 24, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->27918],
  Cell[70455, 2359, 199, 8, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->10866],
  Cell[70691, 2372, 129, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "Null", "TableOfContents_1.6.6.10"},
   CellID->17659],
  Cell[70823, 2376, 811, 22, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->32498],
  Cell[71637, 2400, 272, 8, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->28486],
  Cell[71946, 2413, 104, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.11"},
   CellID->21196],
  Cell[72053, 2417, 378, 13, 70, "Text",
   CellTags->"jlug:6.6.0.0",
   CellID->7462],
  Cell[72434, 2432, 1271, 57, 70, "Program",
   CellTags->"jlug:6.6.0.0",
   CellID->26633]},
 "TableOfContents_1.6.6"->{
  Cell[50278, 1617, 111, 2, 70, "Section",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6"},
   CellID->29087]},
 "TableOfContents_1.6.6.1"->{
  Cell[52485, 1692, 107, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.1"},
   CellID->5686]},
 "TableOfContents_1.6.6.2"->{
  Cell[52998, 1714, 110, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.2"},
   CellID->11662]},
 "TableOfContents_1.6.6.3"->{
  Cell[53400, 1732, 107, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.3"},
   CellID->6064]},
 "TableOfContents_1.6.6.4"->{
  Cell[53701, 1751, 104, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.4"},
   CellID->20415]},
 "TableOfContents_1.6.6.5"->{
  Cell[53948, 1762, 101, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.5"},
   CellID->29873]},
 "TableOfContents_1.6.6.6"->{
  Cell[60784, 2013, 101, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.6"},
   CellID->12290]},
 "TableOfContents_1.6.6.7"->{
  Cell[68056, 2268, 101, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.7"},
   CellID->6995]},
 "TableOfContents_1.6.6.8"->{
  Cell[69095, 2309, 98, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.8"},
   CellID->7479]},
 "TableOfContents_1.6.6.9"->{
  Cell[69497, 2329, 107, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.9"},
   CellID->26423]},
 "Null"->{
  Cell[70691, 2372, 129, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "Null", "TableOfContents_1.6.6.10"},
   CellID->17659]},
 "TableOfContents_1.6.6.10"->{
  Cell[70691, 2372, 129, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "Null", "TableOfContents_1.6.6.10"},
   CellID->17659]},
 "TableOfContents_1.6.6.11"->{
  Cell[71946, 2413, 104, 2, 70, "Subsection",
   CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.11"},
   CellID->21196]},
 "jlug:6.7.0.0"->{
  Cell[73754, 2495, 113, 2, 70, "Section",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7"},
   CellID->21948],
  Cell[73870, 2499, 889, 22, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->25072],
  Cell[74784, 2525, 102, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.1"},
   CellID->20426],
  Cell[74889, 2529, 1902, 59, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->14606],
  Cell[76794, 2590, 168, 6, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->26173],
  Cell[76999, 2601, 116, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.2"},
   CellID->24429],
  Cell[77118, 2605, 1106, 34, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->32404],
  Cell[78227, 2641, 107, 2, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->6705],
  Cell[78337, 2645, 379, 12, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->20626],
  Cell[78719, 2659, 108, 2, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->29812],
  Cell[78864, 2666, 165, 3, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.3"},
   CellID->19375],
  Cell[79032, 2671, 3333, 101, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->30093],
  Cell[82368, 2774, 829, 22, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->16565],
  Cell[83234, 2801, 124, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.4"},
   CellID->16036],
  Cell[83361, 2805, 1136, 33, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->14736],
  Cell[84500, 2840, 117, 2, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->29141],
  Cell[84620, 2844, 1835, 59, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->30814],
  Cell[86458, 2905, 107, 2, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->5994],
  Cell[86568, 2909, 236, 7, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->8256],
  Cell[86807, 2918, 396, 12, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->6652],
  Cell[87240, 2935, 144, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.5"},
   CellID->23936],
  Cell[87387, 2939, 327, 10, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->30838],
  Cell[87717, 2951, 173, 8, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->20482],
  Cell[87927, 2964, 120, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.6"},
   CellID->1355],
  Cell[88050, 2968, 474, 14, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->21015],
  Cell[88527, 2984, 210, 7, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->1131],
  Cell[88774, 2996, 141, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.7"},
   CellID->18230],
  Cell[88918, 3000, 419, 12, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->17841],
  Cell[89340, 3014, 114, 2, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->14625],
  Cell[89491, 3021, 181, 5, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.8"},
   CellID->2011],
  Cell[89675, 3028, 937, 24, 70, "Text",
   CellTags->"jlug:6.7.0.0",
   CellID->32637],
  Cell[90615, 3054, 289, 10, 70, "Program",
   CellTags->"jlug:6.7.0.0",
   CellID->4186]},
 "TableOfContents_1.6.7"->{
  Cell[73754, 2495, 113, 2, 70, "Section",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7"},
   CellID->21948]},
 "TableOfContents_1.6.7.1"->{
  Cell[74784, 2525, 102, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.1"},
   CellID->20426]},
 "TableOfContents_1.6.7.2"->{
  Cell[76999, 2601, 116, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.2"},
   CellID->24429]},
 "TableOfContents_1.6.7.3"->{
  Cell[78864, 2666, 165, 3, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.3"},
   CellID->19375]},
 "TableOfContents_1.6.7.4"->{
  Cell[83234, 2801, 124, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.4"},
   CellID->16036]},
 "TableOfContents_1.6.7.5"->{
  Cell[87240, 2935, 144, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.5"},
   CellID->23936]},
 "TableOfContents_1.6.7.6"->{
  Cell[87927, 2964, 120, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.6"},
   CellID->1355]},
 "TableOfContents_1.6.7.7"->{
  Cell[88774, 2996, 141, 2, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.7"},
   CellID->18230]},
 "TableOfContents_1.6.7.8"->{
  Cell[89491, 3021, 181, 5, 70, "Subsection",
   CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.8"},
   CellID->2011]},
 "2.8"->{
  Cell[90953, 3070, 136, 2, 70, "Section",
   CellTags->{"2.8", "jlug:6.8.0.0", "TableOfContents_1.6.8"},
   CellID->21991]},
 "jlug:6.8.0.0"->{
  Cell[90953, 3070, 136, 2, 70, "Section",
   CellTags->{"2.8", "jlug:6.8.0.0", "TableOfContents_1.6.8"},
   CellID->21991]},
 "TableOfContents_1.6.8"->{
  Cell[90953, 3070, 136, 2, 70, "Section",
   CellTags->{"2.8", "jlug:6.8.0.0", "TableOfContents_1.6.8"},
   CellID->21991]},
 "jlug:6.8.0.1"->{
  Cell[91114, 3076, 169, 7, 70, "Subsection",
   CellTags->{"jlug:6.8.0.1", "TableOfContents_1.6.8.1"},
   CellID->32196],
  Cell[91286, 3085, 1215, 35, 70, "Text",
   CellTags->"jlug:6.8.0.1",
   CellID->7783],
  Cell[92504, 3122, 1412, 42, 70, "Text",
   CellTags->"jlug:6.8.0.1",
   CellID->16828],
  Cell[93919, 3166, 1030, 31, 70, "Text",
   CellTags->"jlug:6.8.0.1",
   CellID->7727]},
 "TableOfContents_1.6.8.1"->{
  Cell[91114, 3076, 169, 7, 70, "Subsection",
   CellTags->{"jlug:6.8.0.1", "TableOfContents_1.6.8.1"},
   CellID->32196]},
 "jlug:6.8.0.2"->{
  Cell[94986, 3202, 228, 8, 70, "Subsection",
   CellTags->{"jlug:6.8.0.2", "TableOfContents_1.6.8.2"},
   CellID->29426],
  Cell[95217, 3212, 300, 10, 70, "Text",
   CellTags->"jlug:6.8.0.2",
   CellID->15871],
  Cell[95520, 3224, 298, 11, 70, "Program",
   CellTags->"jlug:6.8.0.2",
   CellID->10697],
  Cell[95821, 3237, 1077, 35, 70, "Text",
   CellTags->"jlug:6.8.0.2",
   CellID->17612],
  Cell[96901, 3274, 518, 18, 70, "Text",
   CellTags->"jlug:6.8.0.2",
   CellID->18703],
  Cell[97422, 3294, 133, 5, 70, "Program",
   CellTags->"jlug:6.8.0.2",
   CellID->11027],
  Cell[97558, 3301, 843, 25, 70, "Text",
   CellTags->"jlug:6.8.0.2",
   CellID->11408],
  Cell[98404, 3328, 1293, 39, 70, "Text",
   CellTags->"jlug:6.8.0.2",
   CellID->5545]},
 "TableOfContents_1.6.8.2"->{
  Cell[94986, 3202, 228, 8, 70, "Subsection",
   CellTags->{"jlug:6.8.0.2", "TableOfContents_1.6.8.2"},
   CellID->29426]},
 "jlug:6.8.0.3"->{
  Cell[99734, 3372, 114, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.3", "TableOfContents_1.6.8.3"},
   CellID->9508],
  Cell[99851, 3376, 460, 15, 70, "Text",
   CellTags->"jlug:6.8.0.3",
   CellID->7185],
  Cell[100314, 3393, 362, 9, 70, "Text",
   CellTags->"jlug:6.8.0.3",
   CellID->30238],
  Cell[100679, 3404, 819, 26, 70, "Text",
   CellTags->"jlug:6.8.0.3",
   CellID->24237],
  Cell[101501, 3432, 356, 8, 70, "Text",
   CellTags->"jlug:6.8.0.3",
   CellID->26443],
  Cell[101860, 3442, 1817, 47, 70, "Text",
   CellTags->"jlug:6.8.0.3",
   CellID->21313],
  Cell[103680, 3491, 1033, 17, 70, "Program",
   CellTags->"jlug:6.8.0.3",
   CellID->22501]},
 "TableOfContents_1.6.8.3"->{
  Cell[99734, 3372, 114, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.3", "TableOfContents_1.6.8.3"},
   CellID->9508]},
 "jlug:6.8.0.4"->{
  Cell[104750, 3513, 111, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.4", "TableOfContents_1.6.8.4"},
   CellID->8850],
  Cell[104864, 3517, 624, 12, 70, "Text",
   CellTags->"jlug:6.8.0.4",
   CellID->25128],
  Cell[105491, 3531, 1057, 31, 70, "Text",
   CellTags->"jlug:6.8.0.4",
   CellID->2111],
  Cell[106551, 3564, 679, 21, 70, "Text",
   CellTags->"jlug:6.8.0.4",
   CellID->23650],
  Cell[107233, 3587, 1051, 27, 70, "Text",
   CellTags->"jlug:6.8.0.4",
   CellID->28149],
  Cell[108287, 3616, 480, 10, 70, "Program",
   CellTags->"jlug:6.8.0.4",
   CellID->11192],
  Cell[108770, 3628, 724, 24, 70, "Text",
   CellTags->"jlug:6.8.0.4",
   CellID->1454],
  Cell[109497, 3654, 391, 9, 70, "Program",
   CellTags->"jlug:6.8.0.4",
   CellID->15869],
  Cell[109891, 3665, 949, 28, 70, "Text",
   CellTags->"jlug:6.8.0.4",
   CellID->681],
  Cell[110843, 3695, 454, 10, 70, "Program",
   CellTags->"jlug:6.8.0.4",
   CellID->27465],
  Cell[111300, 3707, 861, 21, 70, "Text",
   CellTags->"jlug:6.8.0.4",
   CellID->20267],
  Cell[112164, 3730, 692, 14, 70, "Program",
   CellTags->"jlug:6.8.0.4",
   CellID->17713],
  Cell[112859, 3746, 538, 14, 70, "Text",
   CellTags->"jlug:6.8.0.4",
   CellID->19793],
  Cell[113400, 3762, 447, 11, 70, "Program",
   CellTags->"jlug:6.8.0.4",
   CellID->18634]},
 "TableOfContents_1.6.8.4"->{
  Cell[104750, 3513, 111, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.4", "TableOfContents_1.6.8.4"},
   CellID->8850]},
 "jlug:6.8.0.5"->{
  Cell[113884, 3778, 165, 3, 70, "Subsection",
   CellTags->{"jlug:6.8.0.5", "TableOfContents_1.6.8.5"},
   CellID->25472],
  Cell[114052, 3783, 607, 16, 70, "Text",
   CellTags->"jlug:6.8.0.5",
   CellID->20972],
  Cell[114662, 3801, 747, 13, 70, "Program",
   CellTags->"jlug:6.8.0.5",
   CellID->22830],
  Cell[115412, 3816, 1919, 55, 70, "Text",
   CellTags->"jlug:6.8.0.5",
   CellID->24901],
  Cell[117334, 3873, 1089, 29, 70, "Text",
   CellTags->"jlug:6.8.0.5",
   CellID->28442],
  Cell[118426, 3904, 240, 4, 70, "Program",
   CellTags->"jlug:6.8.0.5",
   CellID->5177],
  Cell[118669, 3910, 2101, 56, 70, "Text",
   CellTags->"jlug:6.8.0.5",
   CellID->13877],
  Cell[120773, 3968, 868, 26, 70, "Program",
   CellTags->"jlug:6.8.0.5",
   CellID->25770],
  Cell[121644, 3996, 980, 21, 70, "Text",
   CellTags->"jlug:6.8.0.5",
   CellID->702],
  Cell[122627, 4019, 901, 27, 70, "Text",
   CellTags->"jlug:6.8.0.5",
   CellID->14364],
  Cell[123531, 4048, 721, 25, 70, "Program",
   CellTags->"jlug:6.8.0.5",
   CellID->1381],
  Cell[124255, 4075, 300, 8, 70, "Text",
   CellTags->"jlug:6.8.0.5",
   CellID->16590]},
 "TableOfContents_1.6.8.5"->{
  Cell[113884, 3778, 165, 3, 70, "Subsection",
   CellTags->{"jlug:6.8.0.5", "TableOfContents_1.6.8.5"},
   CellID->25472]},
 "jlug:6.8.0.6"->{
  Cell[124592, 4088, 127, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.6", "TableOfContents_1.6.8.6"},
   CellID->8823],
  Cell[124722, 4092, 1689, 48, 70, "Text",
   CellTags->"jlug:6.8.0.6",
   CellID->2237],
  Cell[126414, 4142, 1549, 42, 70, "Text",
   CellTags->"jlug:6.8.0.6",
   CellID->8023],
  Cell[127966, 4186, 304, 11, 70, "Text",
   CellTags->"jlug:6.8.0.6",
   CellID->32179],
  Cell[128273, 4199, 150, 5, 70, "Program",
   CellTags->"jlug:6.8.0.6",
   CellID->16595],
  Cell[128426, 4206, 822, 24, 70, "Text",
   CellTags->"jlug:6.8.0.6",
   CellID->20169],
  Cell[129251, 4232, 690, 18, 70, "Text",
   CellTags->"jlug:6.8.0.6",
   CellID->2327],
  Cell[129944, 4252, 745, 22, 70, "Text",
   CellTags->"jlug:6.8.0.6",
   CellID->12042],
  Cell[130692, 4276, 407, 14, 70, "Text",
   CellTags->"jlug:6.8.0.6",
   CellID->31310],
  Cell[131102, 4292, 309, 11, 70, "Program",
   CellTags->"jlug:6.8.0.6",
   CellID->28182],
  Cell[131414, 4305, 936, 22, 70, "Text",
   CellTags->"jlug:6.8.0.6",
   CellID->11058]},
 "TableOfContents_1.6.8.6"->{
  Cell[124592, 4088, 127, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.6", "TableOfContents_1.6.8.6"},
   CellID->8823]},
 "jlug:6.8.0.7"->{
  Cell[132387, 4332, 130, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.7", "TableOfContents_1.6.8.7"},
   CellID->7926],
  Cell[132520, 4336, 656, 20, 70, "Text",
   CellTags->"jlug:6.8.0.7",
   CellID->9487],
  Cell[133179, 4358, 100, 2, 70, "Program",
   CellTags->"jlug:6.8.0.7",
   CellID->1670],
  Cell[133282, 4362, 105, 2, 70, "Text",
   CellTags->"jlug:6.8.0.7",
   CellID->32528],
  Cell[133390, 4366, 243, 7, 70, "Program",
   CellTags->"jlug:6.8.0.7",
   CellID->5651],
  Cell[133636, 4375, 1040, 30, 70, "Text",
   CellTags->"jlug:6.8.0.7",
   CellID->2258]},
 "TableOfContents_1.6.8.7"->{
  Cell[132387, 4332, 130, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.7", "TableOfContents_1.6.8.7"},
   CellID->7926]},
 "jlug:6.8.0.8"->{
  Cell[134713, 4410, 114, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.8", "TableOfContents_1.6.8.8"},
   CellID->7213],
  Cell[134830, 4414, 3354, 111, 70, "Text",
   CellTags->"jlug:6.8.0.8",
   CellID->9860],
  Cell[138187, 4527, 1457, 41, 70, "Text",
   CellTags->"jlug:6.8.0.8",
   CellID->25783],
  Cell[139647, 4570, 4412, 125, 70, "Text",
   CellTags->"jlug:6.8.0.8",
   CellID->21286],
  Cell[144062, 4697, 77, 2, 70, "Text",
   CellTags->"jlug:6.8.0.8",
   CellID->2742],
  Cell[144142, 4701, 829, 21, 70, "Program",
   CellTags->"jlug:6.8.0.8",
   CellID->8610],
  Cell[144974, 4724, 1926, 58, 70, "Text",
   CellTags->"jlug:6.8.0.8",
   CellID->4472]},
 "TableOfContents_1.6.8.8"->{
  Cell[134713, 4410, 114, 2, 70, "Subsection",
   CellTags->{"jlug:6.8.0.8", "TableOfContents_1.6.8.8"},
   CellID->7213]},
 "2.9"->{
  Cell[146949, 4788, 123, 2, 70, "Section",
   CellTags->{"2.9", "jlug:6.9.0.0", "TableOfContents_1.6.9"},
   CellID->10040]},
 "jlug:6.9.0.0"->{
  Cell[146949, 4788, 123, 2, 70, "Section",
   CellTags->{"2.9", "jlug:6.9.0.0", "TableOfContents_1.6.9"},
   CellID->10040],
  Cell[147075, 4792, 1464, 47, 70, "Text",
   CellTags->"jlug:6.9.0.0",
   CellID->9313],
  Cell[148542, 4841, 1659, 43, 70, "Text",
   CellTags->"jlug:6.9.0.0",
   CellID->875],
  Cell[150204, 4886, 1644, 41, 70, "Text",
   CellTags->"jlug:6.9.0.0",
   CellID->20072],
  Cell[151851, 4929, 1506, 39, 70, "Text",
   CellTags->"jlug:6.9.0.0",
   CellID->12818],
  Cell[153360, 4970, 388, 15, 70, "Program",
   CellTags->"jlug:6.9.0.0",
   CellID->610],
  Cell[153751, 4987, 612, 15, 70, "Text",
   CellTags->"jlug:6.9.0.0",
   CellID->1017],
  Cell[154366, 5004, 814, 23, 70, "Text",
   CellTags->"jlug:6.9.0.0",
   CellID->14932],
  Cell[155183, 5029, 219, 8, 70, "Program",
   CellTags->"jlug:6.9.0.0",
   CellID->28112],
  Cell[155405, 5039, 2811, 73, 70, "Text",
   CellTags->"jlug:6.9.0.0",
   CellID->30695]},
 "TableOfContents_1.6.9"->{
  Cell[146949, 4788, 123, 2, 70, "Section",
   CellTags->{"2.9", "jlug:6.9.0.0", "TableOfContents_1.6.9"},
   CellID->10040]},
 "2.10"->{
  Cell[158253, 5117, 126, 2, 70, "Section",
   CellTags->{"2.10", "jlug:6.10.0.0", "TableOfContents_1.6.10"},
   CellID->24041]},
 "jlug:6.10.0.0"->{
  Cell[158253, 5117, 126, 2, 70, "Section",
   CellTags->{"2.10", "jlug:6.10.0.0", "TableOfContents_1.6.10"},
   CellID->24041]},
 "TableOfContents_1.6.10"->{
  Cell[158253, 5117, 126, 2, 70, "Section",
   CellTags->{"2.10", "jlug:6.10.0.0", "TableOfContents_1.6.10"},
   CellID->24041]},
 "jlug:6.10.0.1"->{
  Cell[158404, 5123, 104, 2, 70, "Subsection",
   CellTags->{"jlug:6.10.0.1", "TableOfContents_1.6.10.1"},
   CellID->24423],
  Cell[158511, 5127, 1520, 45, 70, "Text",
   CellTags->"jlug:6.10.0.1",
   CellID->24129]},
 "TableOfContents_1.6.10.1"->{
  Cell[158404, 5123, 104, 2, 70, "Subsection",
   CellTags->{"jlug:6.10.0.1", "TableOfContents_1.6.10.1"},
   CellID->24423]},
 "jlug:6.10.0.2"->{
  Cell[160068, 5177, 129, 2, 70, "Subsection",
   CellTags->{"jlug:6.10.0.2", "TableOfContents_1.6.10.2"},
   CellID->24229],
  Cell[160200, 5181, 1839, 56, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->4565],
  Cell[162042, 5239, 226, 6, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->6559],
  Cell[162271, 5247, 326, 13, 70, "Program",
   CellTags->"jlug:6.10.0.2",
   CellID->8932],
  Cell[162600, 5262, 415, 15, 70, "Caption",
   CellTags->"jlug:6.10.0.2",
   CellID->22296],
  Cell[163018, 5279, 2918, 90, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->29855],
  Cell[165939, 5371, 660, 21, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->12053],
  Cell[166602, 5394, 995, 27, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->16962],
  Cell[167600, 5423, 821, 22, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->3584],
  Cell[168424, 5447, 443, 11, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->29734],
  Cell[168870, 5460, 1009, 22, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->6654],
  Cell[169882, 5484, 1729, 47, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->16972],
  Cell[171614, 5533, 309, 9, 70, "Text",
   CellTags->"jlug:6.10.0.2",
   CellID->21457]},
 "TableOfContents_1.6.10.2"->{
  Cell[160068, 5177, 129, 2, 70, "Subsection",
   CellTags->{"jlug:6.10.0.2", "TableOfContents_1.6.10.2"},
   CellID->24229]},
 "jlug:6.10.0.3"->{
  Cell[171960, 5547, 157, 3, 70, "Subsection",
   CellTags->{"jlug:6.10.0.3", "TableOfContents_1.6.10.3"},
   CellID->14369],
  Cell[172120, 5552, 684, 17, 70, "Text",
   CellTags->"jlug:6.10.0.3",
   CellID->22532],
  Cell[172807, 5571, 468, 14, 70, "Program",
   CellTags->"jlug:6.10.0.3",
   CellID->2963],
  Cell[173278, 5587, 76, 2, 70, "Text",
   CellTags->"jlug:6.10.0.3",
   CellID->2607],
  Cell[173357, 5591, 3749, 116, 70, "Program",
   CellTags->"jlug:6.10.0.3",
   CellID->2483]},
 "TableOfContents_1.6.10.3"->{
  Cell[171960, 5547, 157, 3, 70, "Subsection",
   CellTags->{"jlug:6.10.0.3", "TableOfContents_1.6.10.3"},
   CellID->14369]},
 "jlug:6.10.0.4"->{
  Cell[177143, 5712, 135, 2, 70, "Subsection",
   CellTags->{"jlug:6.10.0.4", "TableOfContents_1.6.10.4"},
   CellID->911],
  Cell[177281, 5716, 859, 28, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->11635],
  Cell[178143, 5746, 265, 7, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->10067],
  Cell[178411, 5755, 2079, 61, 70, "Program",
   CellTags->"jlug:6.10.0.4",
   CellID->22848],
  Cell[180493, 5818, 133, 4, 70, "Caption",
   CellTags->"jlug:6.10.0.4",
   CellID->4675],
  Cell[180629, 5824, 2182, 57, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->12938],
  Cell[182814, 5883, 946, 28, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->2223],
  Cell[183763, 5913, 472, 13, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->22142],
  Cell[184238, 5928, 233, 6, 70, "Program",
   CellTags->"jlug:6.10.0.4",
   CellID->23754],
  Cell[184474, 5936, 638, 18, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->6511],
  Cell[185115, 5956, 783, 24, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->22741],
  Cell[185901, 5982, 416, 12, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->20175],
  Cell[186320, 5996, 386, 13, 70, "Program",
   CellTags->"jlug:6.10.0.4",
   CellID->21459],
  Cell[186709, 6011, 394, 9, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->17825],
  Cell[187106, 6022, 988, 32, 70, "Program",
   CellTags->"jlug:6.10.0.4",
   CellID->3221],
  Cell[188097, 6056, 521, 14, 70, "Text",
   CellTags->"jlug:6.10.0.4",
   CellID->17870]},
 "TableOfContents_1.6.10.4"->{
  Cell[177143, 5712, 135, 2, 70, "Subsection",
   CellTags->{"jlug:6.10.0.4", "TableOfContents_1.6.10.4"},
   CellID->911]},
 "jlug:6.11.0.0"->{
  Cell[188667, 6076, 129, 2, 70, "Section",
   CellTags->{"jlug:6.11.0.0", "TableOfContents_1.6.11"},
   CellID->19718],
  Cell[188799, 6080, 656, 20, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->19895],
  Cell[189458, 6102, 172, 7, 70, "Program",
   CellTags->"jlug:6.11.0.0",
   CellID->5447],
  Cell[189633, 6111, 960, 28, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->21726],
  Cell[190596, 6141, 1978, 47, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->14771],
  Cell[192577, 6190, 1873, 47, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->11538],
  Cell[194453, 6239, 1862, 46, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->1869],
  Cell[196318, 6287, 1653, 34, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->19912],
  Cell[197974, 6323, 290, 11, 70, "Program",
   CellTags->"jlug:6.11.0.0",
   CellID->25667],
  Cell[198267, 6336, 181, 5, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->26299],
  Cell[198451, 6343, 569, 20, 70, "Program",
   CellTags->"jlug:6.11.0.0",
   CellID->17035],
  Cell[199023, 6365, 1353, 36, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->9894],
  Cell[200379, 6403, 1385, 46, 70, "Text",
   CellTags->"jlug:6.11.0.0",
   CellID->28703]},
 "TableOfContents_1.6.11"->{
  Cell[188667, 6076, 129, 2, 70, "Section",
   CellTags->{"jlug:6.11.0.0", "TableOfContents_1.6.11"},
   CellID->19718]},
 "jlug:6.12.0.0"->{
  Cell[201801, 6454, 101, 2, 70, "Section",
   CellTags->{"jlug:6.12.0.0", "TableOfContents_1.6.12"},
   CellID->8483],
  Cell[201905, 6458, 717, 19, 70, "Text",
   CellTags->"jlug:6.12.0.0",
   CellID->5538],
  Cell[202625, 6479, 198, 7, 70, "Program",
   CellTags->"jlug:6.12.0.0",
   CellID->7492],
  Cell[202826, 6488, 555, 10, 70, "Text",
   CellTags->"jlug:6.12.0.0",
   CellID->6193],
  Cell[203384, 6500, 307, 15, 70, "Program",
   CellTags->"jlug:6.12.0.0",
   CellID->28252],
  Cell[203694, 6517, 1266, 35, 70, "Text",
   CellTags->"jlug:6.12.0.0",
   CellID->25011],
  Cell[204963, 6554, 897, 22, 70, "Text",
   CellTags->"jlug:6.12.0.0",
   CellID->1560],
  Cell[205863, 6578, 358, 17, 70, "Program",
   CellTags->"jlug:6.12.0.0",
   CellID->15834],
  Cell[206224, 6597, 782, 23, 70, "Text",
   CellTags->"jlug:6.12.0.0",
   CellID->1840]},
 "TableOfContents_1.6.12"->{
  Cell[201801, 6454, 101, 2, 70, "Section",
   CellTags->{"jlug:6.12.0.0", "TableOfContents_1.6.12"},
   CellID->8483]},
 "jlug:6.13.0.0"->{
  Cell[207043, 6625, 108, 2, 70, "Section",
   CellTags->{"jlug:6.13.0.0", "TableOfContents_1.6.13"},
   CellID->58],
  Cell[207154, 6629, 1611, 42, 70, "Text",
   CellTags->"jlug:6.13.0.0",
   CellID->14700],
  Cell[208768, 6673, 867, 24, 70, "Text",
   CellTags->"jlug:6.13.0.0",
   CellID->13971],
  Cell[209638, 6699, 661, 20, 70, "Text",
   CellTags->"jlug:6.13.0.0",
   CellID->26264],
  Cell[210302, 6721, 173, 5, 70, "Program",
   CellTags->"jlug:6.13.0.0",
   CellID->15117],
  Cell[210478, 6728, 2071, 68, 70, "Text",
   CellTags->"jlug:6.13.0.0",
   CellID->16215],
  Cell[212552, 6798, 747, 21, 70, "Text",
   CellTags->"jlug:6.13.0.0",
   CellID->24555],
  Cell[213302, 6821, 247, 7, 70, "Program",
   CellTags->"jlug:6.13.0.0",
   CellID->7815],
  Cell[213552, 6830, 622, 16, 70, "Text",
   CellTags->"jlug:6.13.0.0",
   CellID->18330],
  Cell[214177, 6848, 1944, 40, 70, "Text",
   CellTags->"jlug:6.13.0.0",
   CellID->3039],
  Cell[216124, 6890, 513, 8, 70, "Program",
   CellTags->"jlug:6.13.0.0",
   CellID->30212]},
 "TableOfContents_1.6.13"->{
  Cell[207043, 6625, 108, 2, 70, "Section",
   CellTags->{"jlug:6.13.0.0", "TableOfContents_1.6.13"},
   CellID->58]},
 "2.14"->{
  Cell[216674, 6903, 117, 2, 70, "Section",
   CellTags->{"2.14", "jlug:6.14.0.0", "TableOfContents_1.6.14"},
   CellID->30188]},
 "jlug:6.14.0.0"->{
  Cell[216674, 6903, 117, 2, 70, "Section",
   CellTags->{"2.14", "jlug:6.14.0.0", "TableOfContents_1.6.14"},
   CellID->30188]},
 "TableOfContents_1.6.14"->{
  Cell[216674, 6903, 117, 2, 70, "Section",
   CellTags->{"2.14", "jlug:6.14.0.0", "TableOfContents_1.6.14"},
   CellID->30188]},
 "jlug:6.14.0.1"->{
  Cell[216816, 6909, 125, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.1", "TableOfContents_1.6.14.1"},
   CellID->21763],
  Cell[216944, 6913, 624, 22, 70, "Text",
   CellTags->"jlug:6.14.0.1",
   CellID->4940],
  Cell[217571, 6937, 1079, 25, 70, "Text",
   CellTags->"jlug:6.14.0.1",
   CellID->20851],
  Cell[218653, 6964, 2316, 67, 70, "Text",
   CellTags->"jlug:6.14.0.1",
   CellID->18662],
  Cell[220972, 7033, 842, 26, 70, "Text",
   CellTags->"jlug:6.14.0.1",
   CellID->13829],
  Cell[221817, 7061, 218, 8, 70, "Program",
   CellTags->"jlug:6.14.0.1",
   CellID->30900],
  Cell[222038, 7071, 463, 15, 70, "Text",
   CellTags->"jlug:6.14.0.1",
   CellID->611242602]},
 "TableOfContents_1.6.14.1"->{
  Cell[216816, 6909, 125, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.1", "TableOfContents_1.6.14.1"},
   CellID->21763]},
 "jlug:6.14.0.2"->{
  Cell[222538, 7091, 217, 7, 70, "Subsection",
   CellTags->{"jlug:6.14.0.2", "TableOfContents_1.6.14.2"},
   CellID->18958],
  Cell[222758, 7100, 1508, 46, 70, "Text",
   CellTags->"jlug:6.14.0.2",
   CellID->17578],
  Cell[224269, 7148, 229, 7, 70, "Program",
   CellTags->"jlug:6.14.0.2",
   CellID->8365]},
 "TableOfContents_1.6.14.2"->{
  Cell[222538, 7091, 217, 7, 70, "Subsection",
   CellTags->{"jlug:6.14.0.2", "TableOfContents_1.6.14.2"},
   CellID->18958]},
 "jlug:6.14.0.3"->{
  Cell[224535, 7160, 136, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.3", "TableOfContents_1.6.14.3"},
   CellID->13007],
  Cell[224674, 7164, 874, 27, 70, "Text",
   CellTags->"jlug:6.14.0.3",
   CellID->11477],
  Cell[225551, 7193, 479, 18, 70, "Program",
   CellTags->"jlug:6.14.0.3",
   CellID->1200],
  Cell[226033, 7213, 849, 28, 70, "Text",
   CellTags->"jlug:6.14.0.3",
   CellID->26058]},
 "TableOfContents_1.6.14.3"->{
  Cell[224535, 7160, 136, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.3", "TableOfContents_1.6.14.3"},
   CellID->13007]},
 "jlug:6.14.0.4"->{
  Cell[226919, 7246, 164, 4, 70, "Subsection",
   CellTags->{"jlug:6.14.0.4", "TableOfContents_1.6.14.4"},
   CellID->6439],
  Cell[227086, 7252, 1709, 48, 70, "Text",
   CellTags->"jlug:6.14.0.4",
   CellID->2303],
  Cell[228798, 7302, 393, 13, 70, "Program",
   CellTags->"jlug:6.14.0.4",
   CellID->12760],
  Cell[229194, 7317, 1168, 31, 70, "Text",
   CellTags->"jlug:6.14.0.4",
   CellID->19357]},
 "TableOfContents_1.6.14.4"->{
  Cell[226919, 7246, 164, 4, 70, "Subsection",
   CellTags->{"jlug:6.14.0.4", "TableOfContents_1.6.14.4"},
   CellID->6439]},
 "jlug:6.14.0.5"->{
  Cell[230399, 7353, 135, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.5", "TableOfContents_1.6.14.5"},
   CellID->2324],
  Cell[230537, 7357, 1974, 63, 70, "Text",
   CellTags->"jlug:6.14.0.5",
   CellID->6477],
  Cell[232514, 7422, 582, 19, 70, "Program",
   CellTags->"jlug:6.14.0.5",
   CellID->5108]},
 "TableOfContents_1.6.14.5"->{
  Cell[230399, 7353, 135, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.5", "TableOfContents_1.6.14.5"},
   CellID->2324]},
 "jlug:6.14.0.6"->{
  Cell[233133, 7446, 128, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.6", "TableOfContents_1.6.14.6"},
   CellID->21113],
  Cell[233264, 7450, 1182, 37, 70, "Text",
   CellTags->"jlug:6.14.0.6",
   CellID->14887],
  Cell[234449, 7489, 810, 24, 70, "Text",
   CellTags->"jlug:6.14.0.6",
   CellID->19801],
  Cell[235262, 7515, 265, 9, 70, "Text",
   CellTags->"jlug:6.14.0.6",
   CellID->22850],
  Cell[235530, 7526, 160, 7, 70, "Program",
   CellTags->"jlug:6.14.0.6",
   CellID->14460],
  Cell[235693, 7535, 394, 12, 70, "Text",
   CellTags->"jlug:6.14.0.6",
   CellID->22428],
  Cell[236090, 7549, 308, 12, 70, "Program",
   CellTags->"jlug:6.14.0.6",
   CellID->12993],
  Cell[236401, 7563, 1066, 32, 70, "Text",
   CellTags->"jlug:6.14.0.6",
   CellID->27384],
  Cell[237470, 7597, 219, 8, 70, "Program",
   CellTags->"jlug:6.14.0.6",
   CellID->19405],
  Cell[237692, 7607, 267, 9, 70, "Text",
   CellTags->"jlug:6.14.0.6",
   CellID->6540],
  Cell[237962, 7618, 756, 17, 70, "Program",
   CellTags->"jlug:6.14.0.6",
   CellID->31111],
  Cell[238721, 7637, 91, 2, 70, "Text",
   CellTags->"jlug:6.14.0.6",
   CellID->28704],
  Cell[238815, 7641, 561, 16, 70, "Program",
   CellTags->"jlug:6.14.0.6",
   CellID->12835]},
 "TableOfContents_1.6.14.6"->{
  Cell[233133, 7446, 128, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.6", "TableOfContents_1.6.14.6"},
   CellID->21113]},
 "jlug:6.14.0.7"->{
  Cell[239413, 7662, 114, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.7", "TableOfContents_1.6.14.7"},
   CellID->32356],
  Cell[239530, 7666, 2115, 59, 70, "Text",
   CellTags->"jlug:6.14.0.7",
   CellID->6072],
  Cell[241648, 7727, 137, 4, 70, "Program",
   CellTags->"jlug:6.14.0.7",
   CellID->29350],
  Cell[241788, 7733, 88, 2, 70, "Text",
   CellTags->"jlug:6.14.0.7",
   CellID->18823],
  Cell[241879, 7737, 162, 6, 70, "Program",
   CellTags->"jlug:6.14.0.7",
   CellID->14485],
  Cell[242044, 7745, 705, 21, 70, "Text",
   CellTags->"jlug:6.14.0.7",
   CellID->20556],
  Cell[242752, 7768, 445, 13, 70, "Text",
   CellTags->"jlug:6.14.0.7",
   CellID->23216],
  Cell[243200, 7783, 257, 9, 70, "Program",
   CellTags->"jlug:6.14.0.7",
   CellID->9383296],
  Cell[243460, 7794, 1596, 52, 70, "Text",
   CellTags->"jlug:6.14.0.7",
   CellID->9357]},
 "TableOfContents_1.6.14.7"->{
  Cell[239413, 7662, 114, 2, 70, "Subsection",
   CellTags->{"jlug:6.14.0.7", "TableOfContents_1.6.14.7"},
   CellID->32356]},
 "2.15"->{
  Cell[245105, 7852, 129, 2, 70, "Section",
   CellTags->{"2.15", "jlug:6.15.0.0", "TableOfContents_1.6.15"},
   CellID->189],
  Cell[253852, 8109, 192, 6, 70, "Section",
   CellTags->{"2.15", "jlug:6.16.0.0", "TableOfContents_1.6.16"},
   CellID->26222]},
 "jlug:6.15.0.0"->{
  Cell[245105, 7852, 129, 2, 70, "Section",
   CellTags->{"2.15", "jlug:6.15.0.0", "TableOfContents_1.6.15"},
   CellID->189],
  Cell[245237, 7856, 1294, 31, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->16100],
  Cell[246534, 7889, 614, 16, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->19812],
  Cell[247151, 7907, 170, 8, 70, "Program",
   CellTags->"jlug:6.15.0.0",
   CellID->30648],
  Cell[247324, 7917, 151, 5, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->9523],
  Cell[247478, 7924, 611, 16, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->19851],
  Cell[248092, 7942, 408, 10, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->24474],
  Cell[248503, 7954, 935, 23, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->28633],
  Cell[249441, 7979, 561, 14, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->29891],
  Cell[250005, 7995, 174, 5, 70, "Program",
   CellTags->"jlug:6.15.0.0",
   CellID->27200],
  Cell[250182, 8002, 1030, 29, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->19854],
  Cell[251215, 8033, 89, 2, 70, "Program",
   CellTags->"jlug:6.15.0.0",
   CellID->9990],
  Cell[251307, 8037, 1481, 41, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->25697],
  Cell[252791, 8080, 1024, 24, 70, "Text",
   CellTags->"jlug:6.15.0.0",
   CellID->4919]},
 "TableOfContents_1.6.15"->{
  Cell[245105, 7852, 129, 2, 70, "Section",
   CellTags->{"2.15", "jlug:6.15.0.0", "TableOfContents_1.6.15"},
   CellID->189]},
 "jlug:6.16.0.0"->{
  Cell[253852, 8109, 192, 6, 70, "Section",
   CellTags->{"2.15", "jlug:6.16.0.0", "TableOfContents_1.6.16"},
   CellID->26222],
  Cell[254047, 8117, 873, 25, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->29331],
  Cell[254923, 8144, 1535, 44, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->2376],
  Cell[256461, 8190, 1999, 62, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->28583],
  Cell[258463, 8254, 285, 8, 70, "Program",
   CellTags->"jlug:6.16.0.0",
   CellID->26948],
  Cell[258751, 8264, 1928, 56, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->12723],
  Cell[260682, 8322, 698, 21, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->17982],
  Cell[261383, 8345, 114, 2, 70, "Program",
   CellTags->"jlug:6.16.0.0",
   CellID->22018],
  Cell[261500, 8349, 1222, 35, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->14776],
  Cell[262725, 8386, 1332, 36, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->9220],
  Cell[264060, 8424, 2921, 79, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->234550603],
  Cell[266984, 8505, 201, 7, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->32182],
  Cell[267188, 8514, 620, 18, 70, "Program",
   CellTags->"jlug:6.16.0.0",
   CellID->23856],
  Cell[267811, 8534, 583, 18, 70, "Text",
   CellTags->"jlug:6.16.0.0",
   CellID->19490],
  Cell[268397, 8554, 311, 13, 70, "Program",
   CellTags->"jlug:6.16.0.0",
   CellID->8925]},
 "TableOfContents_1.6.16"->{
  Cell[253852, 8109, 192, 6, 70, "Section",
   CellTags->{"2.15", "jlug:6.16.0.0", "TableOfContents_1.6.16"},
   CellID->26222]},
 "2.17"->{
  Cell[268745, 8572, 133, 2, 70, "Section",
   CellTags->{"2.17", "jlug:6.17.0.0", "TableOfContents_1.6.17"},
   CellID->8928]},
 "jlug:6.17.0.0"->{
  Cell[268745, 8572, 133, 2, 70, "Section",
   CellTags->{"2.17", "jlug:6.17.0.0", "TableOfContents_1.6.17"},
   CellID->8928]},
 "TableOfContents_1.6.17"->{
  Cell[268745, 8572, 133, 2, 70, "Section",
   CellTags->{"2.17", "jlug:6.17.0.0", "TableOfContents_1.6.17"},
   CellID->8928]},
 "jlug:6.17.0.1"->{
  Cell[268903, 8578, 108, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.1", "TableOfContents_1.6.17.1"},
   CellID->29492],
  Cell[269014, 8582, 443, 11, 70, "Text",
   CellTags->"jlug:6.17.0.1",
   CellID->12433]},
 "TableOfContents_1.6.17.1"->{
  Cell[268903, 8578, 108, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.1", "TableOfContents_1.6.17.1"},
   CellID->29492]},
 "jlug:6.17.0.2"->{
  Cell[269494, 8598, 109, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.2", "TableOfContents_1.6.17.2"},
   CellID->23840],
  Cell[269606, 8602, 1283, 35, 70, "Text",
   CellTags->"jlug:6.17.0.2",
   CellID->6766],
  Cell[270892, 8639, 698, 17, 70, "Text",
   CellTags->"jlug:6.17.0.2",
   CellID->1735],
  Cell[271593, 8658, 520, 14, 70, "Program",
   CellTags->"jlug:6.17.0.2",
   CellID->19810]},
 "TableOfContents_1.6.17.2"->{
  Cell[269494, 8598, 109, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.2", "TableOfContents_1.6.17.2"},
   CellID->23840]},
 "jlug:6.17.0.3"->{
  Cell[272150, 8677, 111, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.3", "TableOfContents_1.6.17.3"},
   CellID->11599],
  Cell[272264, 8681, 1280, 37, 70, "Text",
   CellTags->"jlug:6.17.0.3",
   CellID->11837],
  Cell[273547, 8720, 1015, 26, 70, "Text",
   CellTags->"jlug:6.17.0.3",
   CellID->31982],
  Cell[274565, 8748, 246, 8, 70, "Program",
   CellTags->"jlug:6.17.0.3",
   CellID->7328],
  Cell[274814, 8758, 941, 22, 70, "Text",
   CellTags->"jlug:6.17.0.3",
   CellID->29352],
  Cell[275758, 8782, 391, 11, 70, "Text",
   CellTags->"jlug:6.17.0.3",
   CellID->11369]},
 "TableOfContents_1.6.17.3"->{
  Cell[272150, 8677, 111, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.3", "TableOfContents_1.6.17.3"},
   CellID->11599]},
 "jlug:6.17.0.4"->{
  Cell[276186, 8798, 130, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.4", "TableOfContents_1.6.17.4"},
   CellID->31244],
  Cell[276319, 8802, 850, 24, 70, "Text",
   CellTags->"jlug:6.17.0.4",
   CellID->21794],
  Cell[277172, 8828, 572, 18, 70, "Text",
   CellTags->"jlug:6.17.0.4",
   CellID->6608],
  Cell[277747, 8848, 1116, 30, 70, "Text",
   CellTags->"jlug:6.17.0.4",
   CellID->9252],
  Cell[278866, 8880, 594, 16, 70, "Text",
   CellTags->"jlug:6.17.0.4",
   CellID->11647]},
 "TableOfContents_1.6.17.4"->{
  Cell[276186, 8798, 130, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.4", "TableOfContents_1.6.17.4"},
   CellID->31244]},
 "jlug:6.17.0.5"->{
  Cell[279497, 8901, 111, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.5", "TableOfContents_1.6.17.5"},
   CellID->17432],
  Cell[279611, 8905, 737, 18, 70, "Text",
   CellTags->"jlug:6.17.0.5",
   CellID->9535],
  Cell[280351, 8925, 981, 30, 70, "Text",
   CellTags->"jlug:6.17.0.5",
   CellID->7208],
  Cell[281335, 8957, 252, 7, 70, "Program",
   CellTags->"jlug:6.17.0.5",
   CellID->3264],
  Cell[281590, 8966, 509, 14, 70, "Text",
   CellTags->"jlug:6.17.0.5",
   CellID->3497],
  Cell[282102, 8982, 613, 20, 70, "Text",
   CellTags->"jlug:6.17.0.5",
   CellID->23243],
  Cell[282718, 9004, 105, 3, 70, "Input",
   CellTags->"jlug:6.17.0.5",
   CellID->27649],
  Cell[282826, 9009, 1068, 31, 70, "Text",
   CellTags->"jlug:6.17.0.5",
   CellID->22015],
  Cell[283897, 9042, 1383, 37, 70, "Text",
   CellTags->"jlug:6.17.0.5",
   CellID->26841]},
 "TableOfContents_1.6.17.5"->{
  Cell[279497, 8901, 111, 2, 70, "Subsection",
   CellTags->{"jlug:6.17.0.5", "TableOfContents_1.6.17.5"},
   CellID->17432]},
 "jlug:6.18.0.0"->{
  Cell[285329, 9085, 106, 2, 70, "Section",
   CellTags->{"jlug:6.18.0.0", "TableOfContents_1.6.18"},
   CellID->20615],
  Cell[285438, 9089, 689, 17, 70, "Text",
   CellTags->"jlug:6.18.0.0",
   CellID->10904],
  Cell[286130, 9108, 2189, 68, 70, "Text",
   CellTags->"jlug:6.18.0.0",
   CellID->2599],
  Cell[288322, 9178, 1200, 24, 70, "Text",
   CellTags->"jlug:6.18.0.0",
   CellID->20136]},
 "TableOfContents_1.6.18"->{
  Cell[285329, 9085, 106, 2, 70, "Section",
   CellTags->{"jlug:6.18.0.0", "TableOfContents_1.6.18"},
   CellID->20615]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"jlug:6.1.0.0", 292238, 9254},
 {"TableOfContents_1.6.1", 292902, 9276},
 {"2.1", 293027, 9280},
 {"jlug:6.2.0.0", 293170, 9284},
 {"TableOfContents_1.6.2", 293583, 9297},
 {"2.3", 293717, 9301},
 {"jlug:6.3.0.0", 293860, 9305},
 {"TableOfContents_1.6.3", 294012, 9309},
 {"jlug:6.3.0.1", 294155, 9313},
 {"TableOfContents_1.6.3.1", 294394, 9320},
 {"jlug:6.3.0.2", 294536, 9324},
 {"TableOfContents_1.6.3.2", 295040, 9340},
 {"jlug:6.3.0.3", 295182, 9344},
 {"TableOfContents_1.6.3.3", 295422, 9351},
 {"jlug:6.3.0.4", 295564, 9355},
 {"TableOfContents_1.6.3.4", 295982, 9368},
 {"jlug:6.3.0.5", 296123, 9372},
 {"TableOfContents_1.6.3.5", 296364, 9379},
 {"jlug:6.3.0.6", 296505, 9383},
 {"TableOfContents_1.6.3.6", 296923, 9396},
 {"jlug:6.3.0.7", 297064, 9400},
 {"TableOfContents_1.6.3.7", 297394, 9410},
 {"jlug:6.4.0.0", 297536, 9414},
 {"TableOfContents_1.6.4", 298044, 9430},
 {"2.5", 298172, 9434},
 {"jlug:6.5.0.0", 298317, 9438},
 {"TableOfContents_1.6.5", 301044, 9526},
 {"TableOfContents_1.6.5.1", 301200, 9530},
 {"jlug:6.6.0.0", 301466, 9537},
 {"TableOfContents_1.6.6", 307545, 9727},
 {"TableOfContents_1.6.6.1", 307694, 9731},
 {"TableOfContents_1.6.6.2", 307847, 9735},
 {"TableOfContents_1.6.6.3", 308001, 9739},
 {"TableOfContents_1.6.6.4", 308154, 9743},
 {"TableOfContents_1.6.6.5", 308308, 9747},
 {"TableOfContents_1.6.6.6", 308462, 9751},
 {"TableOfContents_1.6.6.7", 308616, 9755},
 {"TableOfContents_1.6.6.8", 308769, 9759},
 {"TableOfContents_1.6.6.9", 308921, 9763},
 {"Null", 309056, 9767},
 {"TableOfContents_1.6.6.10", 309220, 9771},
 {"TableOfContents_1.6.6.11", 309384, 9775},
 {"jlug:6.7.0.0", 309528, 9779},
 {"TableOfContents_1.6.7", 312728, 9876},
 {"TableOfContents_1.6.7.1", 312877, 9880},
 {"TableOfContents_1.6.7.2", 313031, 9884},
 {"TableOfContents_1.6.7.3", 313185, 9888},
 {"TableOfContents_1.6.7.4", 313339, 9892},
 {"TableOfContents_1.6.7.5", 313493, 9896},
 {"TableOfContents_1.6.7.6", 313647, 9900},
 {"TableOfContents_1.6.7.7", 313800, 9904},
 {"TableOfContents_1.6.7.8", 313954, 9908},
 {"2.8", 314087, 9912},
 {"jlug:6.8.0.0", 314232, 9916},
 {"TableOfContents_1.6.8", 314386, 9920},
 {"jlug:6.8.0.1", 314531, 9924},
 {"TableOfContents_1.6.8.1", 314953, 9937},
 {"jlug:6.8.0.2", 315096, 9941},
 {"TableOfContents_1.6.8.2", 315879, 9966},
 {"jlug:6.8.0.3", 316022, 9970},
 {"TableOfContents_1.6.8.3", 316716, 9992},
 {"jlug:6.8.0.4", 316858, 9996},
 {"TableOfContents_1.6.8.4", 318194, 10039},
 {"jlug:6.8.0.5", 318337, 10043},
 {"TableOfContents_1.6.8.5", 319491, 10080},
 {"jlug:6.8.0.6", 319635, 10084},
 {"TableOfContents_1.6.8.6", 320693, 10118},
 {"jlug:6.8.0.7", 320836, 10122},
 {"TableOfContents_1.6.8.7", 321440, 10141},
 {"jlug:6.8.0.8", 321583, 10145},
 {"TableOfContents_1.6.8.8", 322280, 10167},
 {"2.9", 322414, 10171},
 {"jlug:6.9.0.0", 322560, 10175},
 {"TableOfContents_1.6.9", 323529, 10206},
 {"2.10", 323667, 10210},
 {"jlug:6.10.0.0", 323817, 10214},
 {"TableOfContents_1.6.10", 323976, 10218},
 {"jlug:6.10.0.1", 324126, 10222},
 {"TableOfContents_1.6.10.1", 324376, 10229},
 {"jlug:6.10.0.2", 324523, 10233},
 {"TableOfContents_1.6.10.2", 325776, 10273},
 {"jlug:6.10.0.3", 325923, 10277},
 {"TableOfContents_1.6.10.3", 326448, 10293},
 {"jlug:6.10.0.4", 326595, 10297},
 {"TableOfContents_1.6.10.4", 328125, 10346},
 {"jlug:6.11.0.0", 328270, 10350},
 {"TableOfContents_1.6.11", 329523, 10390},
 {"jlug:6.12.0.0", 329665, 10394},
 {"TableOfContents_1.6.12", 330547, 10422},
 {"jlug:6.13.0.0", 330688, 10426},
 {"TableOfContents_1.6.13", 331753, 10460},
 {"2.14", 331883, 10464},
 {"jlug:6.14.0.0", 332033, 10468},
 {"TableOfContents_1.6.14", 332192, 10472},
 {"jlug:6.14.0.1", 332342, 10476},
 {"TableOfContents_1.6.14.1", 333053, 10498},
 {"jlug:6.14.0.2", 333200, 10502},
 {"TableOfContents_1.6.14.2", 333542, 10512},
 {"jlug:6.14.0.3", 333689, 10516},
 {"TableOfContents_1.6.14.3", 334122, 10529},
 {"jlug:6.14.0.4", 334269, 10533},
 {"TableOfContents_1.6.14.4", 334703, 10546},
 {"jlug:6.14.0.5", 334849, 10550},
 {"TableOfContents_1.6.14.5", 335190, 10560},
 {"jlug:6.14.0.6", 335336, 10564},
 {"TableOfContents_1.6.14.6", 336596, 10604},
 {"jlug:6.14.0.7", 336743, 10608},
 {"TableOfContents_1.6.14.7", 337635, 10636},
 {"2.15", 337773, 10640},
 {"jlug:6.15.0.0", 338050, 10647},
 {"TableOfContents_1.6.15", 339395, 10690},
 {"jlug:6.16.0.0", 339543, 10694},
 {"TableOfContents_1.6.16", 340992, 10740},
 {"2.17", 341133, 10744},
 {"jlug:6.17.0.0", 341282, 10748},
 {"TableOfContents_1.6.17", 341440, 10752},
 {"jlug:6.17.0.1", 341589, 10756},
 {"TableOfContents_1.6.17.1", 341838, 10763},
 {"jlug:6.17.0.2", 341985, 10767},
 {"TableOfContents_1.6.17.2", 342418, 10780},
 {"jlug:6.17.0.3", 342565, 10784},
 {"TableOfContents_1.6.17.3", 343181, 10803},
 {"jlug:6.17.0.4", 343328, 10807},
 {"TableOfContents_1.6.17.4", 343849, 10823},
 {"jlug:6.17.0.5", 343996, 10827},
 {"TableOfContents_1.6.17.5", 344882, 10855},
 {"jlug:6.18.0.0", 345029, 10859},
 {"TableOfContents_1.6.18", 345454, 10872}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 176, 7, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[801, 34, 132, 5, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[958, 43, 101, 2, 70, "Section",
 CellTags->{"jlug:6.1.0.0", "TableOfContents_1.6.1"},
 CellID->15141],
Cell[1062, 47, 761, 25, 70, "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->7711],
Cell[1826, 74, 1239, 36, 70, "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->28253],
Cell[3068, 112, 1341, 38, 70, "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->6868],
Cell[4412, 152, 921, 19, 70, "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->25547],
Cell[5336, 173, 3048, 92, 70, "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->27644],
Cell[8387, 267, 418, 11, 70, "Text",
 CellTags->"jlug:6.1.0.0",
 CellID->32662]
}, Open  ]],
Cell[CellGroupData[{
Cell[8842, 283, 171, 7, 70, "Section",
 CellTags->{"2.1", "jlug:6.2.0.0", "TableOfContents_1.6.2"},
 CellID->32757],
Cell[9016, 292, 646, 18, 70, "Text",
 CellTags->"jlug:6.2.0.0",
 CellID->20037],
Cell[9665, 312, 610, 14, 70, "Text",
 CellTags->"jlug:6.2.0.0",
 CellID->12859],
Cell[10278, 328, 539, 15, 70, "Text",
 CellTags->"jlug:6.2.0.0",
 CellID->8723]
}, Open  ]],
Cell[CellGroupData[{
Cell[10854, 348, 203, 7, 70, "Section",
 CellTags->{"2.3", "jlug:6.3.0.0", "TableOfContents_1.6.3"},
 CellID->9741],
Cell[CellGroupData[{
Cell[11082, 359, 102, 2, 70, "Subsection",
 CellTags->{"jlug:6.3.0.1", "TableOfContents_1.6.3.1"},
 CellID->27529],
Cell[11187, 363, 956, 17, 70, "Text",
 CellTags->"jlug:6.3.0.1",
 CellID->778]
}, Open  ]],
Cell[CellGroupData[{
Cell[12180, 385, 117, 2, 70, "Subsection",
 CellTags->{"jlug:6.3.0.2", "TableOfContents_1.6.3.2"},
 CellID->12316],
Cell[12300, 389, 1650, 55, 70, "Text",
 CellTags->"jlug:6.3.0.2",
 CellID->3035],
Cell[13953, 446, 1068, 32, 70, "Text",
 CellTags->"jlug:6.3.0.2",
 CellID->22190],
Cell[15024, 480, 1261, 42, 70, "Text",
 CellTags->"jlug:6.3.0.2",
 CellID->1842],
Cell[16288, 524, 838, 23, 70, "Text",
 CellTags->"jlug:6.3.0.2",
 CellID->288]
}, Open  ]],
Cell[CellGroupData[{
Cell[17163, 552, 109, 2, 70, "Subsection",
 CellTags->{"jlug:6.3.0.3", "TableOfContents_1.6.3.3"},
 CellID->30106],
Cell[17275, 556, 924, 28, 70, "Text",
 CellTags->"jlug:6.3.0.3",
 CellID->9040]
}, Open  ]],
Cell[CellGroupData[{
Cell[18236, 589, 110, 2, 70, "Subsection",
 CellTags->{"jlug:6.3.0.4", "TableOfContents_1.6.3.4"},
 CellID->8942],
Cell[18349, 593, 907, 29, 70, "Text",
 CellTags->"jlug:6.3.0.4",
 CellID->19264],
Cell[19259, 624, 164, 7, 70, "Program",
 CellTags->"jlug:6.3.0.4",
 CellID->22648],
Cell[19426, 633, 400, 17, 70, "Text",
 CellTags->"jlug:6.3.0.4",
 CellID->27446]
}, Open  ]],
Cell[CellGroupData[{
Cell[19863, 655, 98, 2, 70, "Subsection",
 CellTags->{"jlug:6.3.0.5", "TableOfContents_1.6.3.5"},
 CellID->23805],
Cell[19964, 659, 2288, 72, 70, "Text",
 CellTags->"jlug:6.3.0.5",
 CellID->15890]
}, Open  ]],
Cell[CellGroupData[{
Cell[22289, 736, 107, 2, 70, "Subsection",
 CellTags->{"jlug:6.3.0.6", "TableOfContents_1.6.3.6"},
 CellID->6729],
Cell[22399, 740, 1814, 49, 70, "Text",
 CellTags->"jlug:6.3.0.6",
 CellID->24370],
Cell[24216, 791, 1521, 40, 70, "Text",
 CellTags->"jlug:6.3.0.6",
 CellID->15350],
Cell[25740, 833, 433, 14, 70, "Text",
 CellTags->"jlug:6.3.0.6",
 CellID->15006]
}, Open  ]],
Cell[CellGroupData[{
Cell[26210, 852, 127, 2, 70, "Subsection",
 CellTags->{"jlug:6.3.0.7", "TableOfContents_1.6.3.7"},
 CellID->31101],
Cell[26340, 856, 1854, 49, 70, "Text",
 CellTags->"jlug:6.3.0.7",
 CellID->24393],
Cell[28197, 907, 2895, 84, 70, "Text",
 CellTags->"jlug:6.3.0.7",
 CellID->3548]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31141, 997, 103, 2, 70, "Section",
 CellTags->{"jlug:6.4.0.0", "TableOfContents_1.6.4"},
 CellID->30556],
Cell[31247, 1001, 1032, 27, 70, "Text",
 CellTags->"jlug:6.4.0.0",
 CellID->30974],
Cell[32282, 1030, 518, 15, 70, "Program",
 CellTags->"jlug:6.4.0.0",
 CellID->3447],
Cell[32803, 1047, 510, 15, 70, "Text",
 CellTags->"jlug:6.4.0.0",
 CellID->5021],
Cell[33316, 1064, 1638, 57, 70, "Program",
 CellTags->"jlug:6.4.0.0",
 CellID->18283]
}, Open  ]],
Cell[CellGroupData[{
Cell[34991, 1126, 131, 2, 70, "Section",
 CellTags->{"2.5", "jlug:6.5.0.0", "TableOfContents_1.6.5"},
 CellID->15574],
Cell[35125, 1130, 655, 16, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->4031],
Cell[35783, 1148, 474, 16, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->12052],
Cell[36260, 1166, 288, 10, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->27350],
Cell[36551, 1178, 855, 26, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->1150],
Cell[37409, 1206, 660, 16, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->16941],
Cell[38072, 1224, 233, 6, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->21724],
Cell[38308, 1232, 685, 15, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->13966],
Cell[38996, 1249, 252, 7, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->3430],
Cell[39251, 1258, 897, 24, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->31107],
Cell[40151, 1284, 184, 6, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->30191],
Cell[40338, 1292, 808, 22, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->18007],
Cell[41149, 1316, 468, 18, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->11337],
Cell[41620, 1336, 760, 24, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->15457],
Cell[42383, 1362, 407, 13, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->12287],
Cell[42793, 1377, 602, 15, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->27753],
Cell[43398, 1394, 1784, 43, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->10383],
Cell[45185, 1439, 675, 21, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->14945],
Cell[45863, 1462, 378, 8, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->8909],
Cell[CellGroupData[{
Cell[46266, 1474, 124, 2, 70, "Subsection",
 CellTags->{"jlug:6.5.0.0", "TableOfContents_1.6.5.1"},
 CellID->32209],
Cell[46393, 1478, 988, 30, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->9758]
}, Open  ]],
Cell[CellGroupData[{
Cell[47418, 1513, 115, 2, 70, "Subsection",
 CellTags->{"jlug:6.5.0.0", "TableOfContents_1.6.5.1"},
 CellID->24221],
Cell[47536, 1517, 433, 15, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->18588],
Cell[47972, 1534, 135, 4, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->6422],
Cell[48110, 1540, 532, 18, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->24946],
Cell[48645, 1560, 85, 2, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->27506],
Cell[48733, 1564, 197, 5, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->13030],
Cell[48933, 1571, 855, 29, 70, "Text",
 CellTags->"jlug:6.5.0.0",
 CellID->16413],
Cell[49791, 1602, 438, 9, 70, "Program",
 CellTags->"jlug:6.5.0.0",
 CellID->29168]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50278, 1617, 111, 2, 70, "Section",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6"},
 CellID->29087],
Cell[50392, 1621, 1345, 45, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->27681],
Cell[51740, 1668, 538, 12, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->19964],
Cell[52281, 1682, 179, 6, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->1340],
Cell[CellGroupData[{
Cell[52485, 1692, 107, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.1"},
 CellID->5686],
Cell[52595, 1696, 366, 13, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->6021]
}, Open  ]],
Cell[CellGroupData[{
Cell[52998, 1714, 110, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.2"},
 CellID->11662],
Cell[53111, 1718, 252, 9, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->14721]
}, Open  ]],
Cell[CellGroupData[{
Cell[53400, 1732, 107, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.3"},
 CellID->6064],
Cell[53510, 1736, 154, 10, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->29309]
}, Open  ]],
Cell[CellGroupData[{
Cell[53701, 1751, 104, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.4"},
 CellID->20415],
Cell[53808, 1755, 103, 2, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->17902]
}, Open  ]],
Cell[CellGroupData[{
Cell[53948, 1762, 101, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.5"},
 CellID->29873],
Cell[54052, 1766, 1511, 42, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->17124],
Cell[55566, 1810, 381, 15, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->23941],
Cell[55950, 1827, 201, 8, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->32745],
Cell[56154, 1837, 83, 2, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->31762],
Cell[56240, 1841, 222, 8, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->28423],
Cell[56465, 1851, 224, 8, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->27531],
Cell[56692, 1861, 528, 23, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->4806],
Cell[57223, 1886, 107, 2, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->12268],
Cell[57333, 1890, 1108, 29, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->9318],
Cell[58444, 1921, 107, 2, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->5602],
Cell[58554, 1925, 671, 17, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->31907],
Cell[59228, 1944, 134, 4, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->24307],
Cell[59365, 1950, 151, 7, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->23481],
Cell[59519, 1959, 135, 4, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->1012],
Cell[59657, 1965, 193, 5, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->21136],
Cell[59853, 1972, 219, 7, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->26630],
Cell[60075, 1981, 136, 3, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->24114],
Cell[60214, 1986, 385, 14, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->26809],
Cell[60602, 2002, 67, 2, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->4084],
Cell[60672, 2006, 75, 2, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->23556]
}, Open  ]],
Cell[CellGroupData[{
Cell[60784, 2013, 101, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.6"},
 CellID->12290],
Cell[60888, 2017, 534, 12, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->21293],
Cell[61425, 2031, 408, 16, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->29996],
Cell[61836, 2049, 1342, 48, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->29152],
Cell[63181, 2099, 250, 9, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->1054],
Cell[63434, 2110, 758, 16, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->25345],
Cell[64195, 2128, 652, 19, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->14708],
Cell[64850, 2149, 289, 9, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->248],
Cell[65142, 2160, 312, 10, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->7491],
Cell[65457, 2172, 450, 11, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->13712],
Cell[65910, 2185, 653, 19, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->5131],
Cell[66566, 2206, 461, 14, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->30114],
Cell[67030, 2222, 137, 4, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->16439],
Cell[67170, 2228, 289, 12, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->7958],
Cell[67462, 2242, 218, 9, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->24722],
Cell[67683, 2253, 336, 10, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->29704]
}, Open  ]],
Cell[CellGroupData[{
Cell[68056, 2268, 101, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.7"},
 CellID->6995],
Cell[68160, 2272, 681, 22, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->1052],
Cell[68844, 2296, 214, 8, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->25269]
}, Open  ]],
Cell[CellGroupData[{
Cell[69095, 2309, 98, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.8"},
 CellID->7479],
Cell[69196, 2313, 264, 11, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->18238]
}, Open  ]],
Cell[CellGroupData[{
Cell[69497, 2329, 107, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.9"},
 CellID->26423],
Cell[69607, 2333, 845, 24, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->27918],
Cell[70455, 2359, 199, 8, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->10866]
}, Open  ]],
Cell[CellGroupData[{
Cell[70691, 2372, 129, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "Null", "TableOfContents_1.6.6.10"},
 CellID->17659],
Cell[70823, 2376, 811, 22, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->32498],
Cell[71637, 2400, 272, 8, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->28486]
}, Open  ]],
Cell[CellGroupData[{
Cell[71946, 2413, 104, 2, 70, "Subsection",
 CellTags->{"jlug:6.6.0.0", "TableOfContents_1.6.6.11"},
 CellID->21196],
Cell[72053, 2417, 378, 13, 70, "Text",
 CellTags->"jlug:6.6.0.0",
 CellID->7462],
Cell[72434, 2432, 1271, 57, 70, "Program",
 CellTags->"jlug:6.6.0.0",
 CellID->26633]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73754, 2495, 113, 2, 70, "Section",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7"},
 CellID->21948],
Cell[73870, 2499, 889, 22, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->25072],
Cell[CellGroupData[{
Cell[74784, 2525, 102, 2, 70, "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.1"},
 CellID->20426],
Cell[74889, 2529, 1902, 59, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->14606],
Cell[76794, 2590, 168, 6, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->26173]
}, Open  ]],
Cell[CellGroupData[{
Cell[76999, 2601, 116, 2, 70, "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.2"},
 CellID->24429],
Cell[77118, 2605, 1106, 34, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->32404],
Cell[78227, 2641, 107, 2, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->6705],
Cell[78337, 2645, 379, 12, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->20626],
Cell[78719, 2659, 108, 2, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->29812]
}, Open  ]],
Cell[CellGroupData[{
Cell[78864, 2666, 165, 3, 70, "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.3"},
 CellID->19375],
Cell[79032, 2671, 3333, 101, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->30093],
Cell[82368, 2774, 829, 22, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->16565]
}, Open  ]],
Cell[CellGroupData[{
Cell[83234, 2801, 124, 2, 70, "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.4"},
 CellID->16036],
Cell[83361, 2805, 1136, 33, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->14736],
Cell[84500, 2840, 117, 2, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->29141],
Cell[84620, 2844, 1835, 59, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->30814],
Cell[86458, 2905, 107, 2, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->5994],
Cell[86568, 2909, 236, 7, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->8256],
Cell[86807, 2918, 396, 12, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->6652]
}, Open  ]],
Cell[CellGroupData[{
Cell[87240, 2935, 144, 2, 70, "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.5"},
 CellID->23936],
Cell[87387, 2939, 327, 10, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->30838],
Cell[87717, 2951, 173, 8, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->20482]
}, Open  ]],
Cell[CellGroupData[{
Cell[87927, 2964, 120, 2, 70, "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.6"},
 CellID->1355],
Cell[88050, 2968, 474, 14, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->21015],
Cell[88527, 2984, 210, 7, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->1131]
}, Open  ]],
Cell[CellGroupData[{
Cell[88774, 2996, 141, 2, 70, "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.7"},
 CellID->18230],
Cell[88918, 3000, 419, 12, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->17841],
Cell[89340, 3014, 114, 2, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->14625]
}, Open  ]],
Cell[CellGroupData[{
Cell[89491, 3021, 181, 5, 70, "Subsection",
 CellTags->{"jlug:6.7.0.0", "TableOfContents_1.6.7.8"},
 CellID->2011],
Cell[89675, 3028, 937, 24, 70, "Text",
 CellTags->"jlug:6.7.0.0",
 CellID->32637],
Cell[90615, 3054, 289, 10, 70, "Program",
 CellTags->"jlug:6.7.0.0",
 CellID->4186]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90953, 3070, 136, 2, 70, "Section",
 CellTags->{"2.8", "jlug:6.8.0.0", "TableOfContents_1.6.8"},
 CellID->21991],
Cell[CellGroupData[{
Cell[91114, 3076, 169, 7, 70, "Subsection",
 CellTags->{"jlug:6.8.0.1", "TableOfContents_1.6.8.1"},
 CellID->32196],
Cell[91286, 3085, 1215, 35, 70, "Text",
 CellTags->"jlug:6.8.0.1",
 CellID->7783],
Cell[92504, 3122, 1412, 42, 70, "Text",
 CellTags->"jlug:6.8.0.1",
 CellID->16828],
Cell[93919, 3166, 1030, 31, 70, "Text",
 CellTags->"jlug:6.8.0.1",
 CellID->7727]
}, Open  ]],
Cell[CellGroupData[{
Cell[94986, 3202, 228, 8, 70, "Subsection",
 CellTags->{"jlug:6.8.0.2", "TableOfContents_1.6.8.2"},
 CellID->29426],
Cell[95217, 3212, 300, 10, 70, "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->15871],
Cell[95520, 3224, 298, 11, 70, "Program",
 CellTags->"jlug:6.8.0.2",
 CellID->10697],
Cell[95821, 3237, 1077, 35, 70, "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->17612],
Cell[96901, 3274, 518, 18, 70, "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->18703],
Cell[97422, 3294, 133, 5, 70, "Program",
 CellTags->"jlug:6.8.0.2",
 CellID->11027],
Cell[97558, 3301, 843, 25, 70, "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->11408],
Cell[98404, 3328, 1293, 39, 70, "Text",
 CellTags->"jlug:6.8.0.2",
 CellID->5545]
}, Open  ]],
Cell[CellGroupData[{
Cell[99734, 3372, 114, 2, 70, "Subsection",
 CellTags->{"jlug:6.8.0.3", "TableOfContents_1.6.8.3"},
 CellID->9508],
Cell[99851, 3376, 460, 15, 70, "Text",
 CellTags->"jlug:6.8.0.3",
 CellID->7185],
Cell[100314, 3393, 362, 9, 70, "Text",
 CellTags->"jlug:6.8.0.3",
 CellID->30238],
Cell[100679, 3404, 819, 26, 70, "Text",
 CellTags->"jlug:6.8.0.3",
 CellID->24237],
Cell[101501, 3432, 356, 8, 70, "Text",
 CellTags->"jlug:6.8.0.3",
 CellID->26443],
Cell[101860, 3442, 1817, 47, 70, "Text",
 CellTags->"jlug:6.8.0.3",
 CellID->21313],
Cell[103680, 3491, 1033, 17, 70, "Program",
 CellTags->"jlug:6.8.0.3",
 CellID->22501]
}, Open  ]],
Cell[CellGroupData[{
Cell[104750, 3513, 111, 2, 70, "Subsection",
 CellTags->{"jlug:6.8.0.4", "TableOfContents_1.6.8.4"},
 CellID->8850],
Cell[104864, 3517, 624, 12, 70, "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->25128],
Cell[105491, 3531, 1057, 31, 70, "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->2111],
Cell[106551, 3564, 679, 21, 70, "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->23650],
Cell[107233, 3587, 1051, 27, 70, "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->28149],
Cell[108287, 3616, 480, 10, 70, "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->11192],
Cell[108770, 3628, 724, 24, 70, "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->1454],
Cell[109497, 3654, 391, 9, 70, "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->15869],
Cell[109891, 3665, 949, 28, 70, "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->681],
Cell[110843, 3695, 454, 10, 70, "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->27465],
Cell[111300, 3707, 861, 21, 70, "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->20267],
Cell[112164, 3730, 692, 14, 70, "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->17713],
Cell[112859, 3746, 538, 14, 70, "Text",
 CellTags->"jlug:6.8.0.4",
 CellID->19793],
Cell[113400, 3762, 447, 11, 70, "Program",
 CellTags->"jlug:6.8.0.4",
 CellID->18634]
}, Open  ]],
Cell[CellGroupData[{
Cell[113884, 3778, 165, 3, 70, "Subsection",
 CellTags->{"jlug:6.8.0.5", "TableOfContents_1.6.8.5"},
 CellID->25472],
Cell[114052, 3783, 607, 16, 70, "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->20972],
Cell[114662, 3801, 747, 13, 70, "Program",
 CellTags->"jlug:6.8.0.5",
 CellID->22830],
Cell[115412, 3816, 1919, 55, 70, "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->24901],
Cell[117334, 3873, 1089, 29, 70, "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->28442],
Cell[118426, 3904, 240, 4, 70, "Program",
 CellTags->"jlug:6.8.0.5",
 CellID->5177],
Cell[118669, 3910, 2101, 56, 70, "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->13877],
Cell[120773, 3968, 868, 26, 70, "Program",
 CellTags->"jlug:6.8.0.5",
 CellID->25770],
Cell[121644, 3996, 980, 21, 70, "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->702],
Cell[122627, 4019, 901, 27, 70, "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->14364],
Cell[123531, 4048, 721, 25, 70, "Program",
 CellTags->"jlug:6.8.0.5",
 CellID->1381],
Cell[124255, 4075, 300, 8, 70, "Text",
 CellTags->"jlug:6.8.0.5",
 CellID->16590]
}, Open  ]],
Cell[CellGroupData[{
Cell[124592, 4088, 127, 2, 70, "Subsection",
 CellTags->{"jlug:6.8.0.6", "TableOfContents_1.6.8.6"},
 CellID->8823],
Cell[124722, 4092, 1689, 48, 70, "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->2237],
Cell[126414, 4142, 1549, 42, 70, "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->8023],
Cell[127966, 4186, 304, 11, 70, "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->32179],
Cell[128273, 4199, 150, 5, 70, "Program",
 CellTags->"jlug:6.8.0.6",
 CellID->16595],
Cell[128426, 4206, 822, 24, 70, "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->20169],
Cell[129251, 4232, 690, 18, 70, "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->2327],
Cell[129944, 4252, 745, 22, 70, "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->12042],
Cell[130692, 4276, 407, 14, 70, "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->31310],
Cell[131102, 4292, 309, 11, 70, "Program",
 CellTags->"jlug:6.8.0.6",
 CellID->28182],
Cell[131414, 4305, 936, 22, 70, "Text",
 CellTags->"jlug:6.8.0.6",
 CellID->11058]
}, Open  ]],
Cell[CellGroupData[{
Cell[132387, 4332, 130, 2, 70, "Subsection",
 CellTags->{"jlug:6.8.0.7", "TableOfContents_1.6.8.7"},
 CellID->7926],
Cell[132520, 4336, 656, 20, 70, "Text",
 CellTags->"jlug:6.8.0.7",
 CellID->9487],
Cell[133179, 4358, 100, 2, 70, "Program",
 CellTags->"jlug:6.8.0.7",
 CellID->1670],
Cell[133282, 4362, 105, 2, 70, "Text",
 CellTags->"jlug:6.8.0.7",
 CellID->32528],
Cell[133390, 4366, 243, 7, 70, "Program",
 CellTags->"jlug:6.8.0.7",
 CellID->5651],
Cell[133636, 4375, 1040, 30, 70, "Text",
 CellTags->"jlug:6.8.0.7",
 CellID->2258]
}, Open  ]],
Cell[CellGroupData[{
Cell[134713, 4410, 114, 2, 70, "Subsection",
 CellTags->{"jlug:6.8.0.8", "TableOfContents_1.6.8.8"},
 CellID->7213],
Cell[134830, 4414, 3354, 111, 70, "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->9860],
Cell[138187, 4527, 1457, 41, 70, "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->25783],
Cell[139647, 4570, 4412, 125, 70, "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->21286],
Cell[144062, 4697, 77, 2, 70, "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->2742],
Cell[144142, 4701, 829, 21, 70, "Program",
 CellTags->"jlug:6.8.0.8",
 CellID->8610],
Cell[144974, 4724, 1926, 58, 70, "Text",
 CellTags->"jlug:6.8.0.8",
 CellID->4472]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[146949, 4788, 123, 2, 70, "Section",
 CellTags->{"2.9", "jlug:6.9.0.0", "TableOfContents_1.6.9"},
 CellID->10040],
Cell[147075, 4792, 1464, 47, 70, "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->9313],
Cell[148542, 4841, 1659, 43, 70, "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->875],
Cell[150204, 4886, 1644, 41, 70, "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->20072],
Cell[151851, 4929, 1506, 39, 70, "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->12818],
Cell[153360, 4970, 388, 15, 70, "Program",
 CellTags->"jlug:6.9.0.0",
 CellID->610],
Cell[153751, 4987, 612, 15, 70, "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->1017],
Cell[154366, 5004, 814, 23, 70, "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->14932],
Cell[155183, 5029, 219, 8, 70, "Program",
 CellTags->"jlug:6.9.0.0",
 CellID->28112],
Cell[155405, 5039, 2811, 73, 70, "Text",
 CellTags->"jlug:6.9.0.0",
 CellID->30695]
}, Open  ]],
Cell[CellGroupData[{
Cell[158253, 5117, 126, 2, 70, "Section",
 CellTags->{"2.10", "jlug:6.10.0.0", "TableOfContents_1.6.10"},
 CellID->24041],
Cell[CellGroupData[{
Cell[158404, 5123, 104, 2, 70, "Subsection",
 CellTags->{"jlug:6.10.0.1", "TableOfContents_1.6.10.1"},
 CellID->24423],
Cell[158511, 5127, 1520, 45, 70, "Text",
 CellTags->"jlug:6.10.0.1",
 CellID->24129]
}, Open  ]],
Cell[CellGroupData[{
Cell[160068, 5177, 129, 2, 70, "Subsection",
 CellTags->{"jlug:6.10.0.2", "TableOfContents_1.6.10.2"},
 CellID->24229],
Cell[160200, 5181, 1839, 56, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->4565],
Cell[162042, 5239, 226, 6, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->6559],
Cell[162271, 5247, 326, 13, 70, "Program",
 CellTags->"jlug:6.10.0.2",
 CellID->8932],
Cell[162600, 5262, 415, 15, 70, "Caption",
 CellTags->"jlug:6.10.0.2",
 CellID->22296],
Cell[163018, 5279, 2918, 90, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->29855],
Cell[165939, 5371, 660, 21, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->12053],
Cell[166602, 5394, 995, 27, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->16962],
Cell[167600, 5423, 821, 22, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->3584],
Cell[168424, 5447, 443, 11, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->29734],
Cell[168870, 5460, 1009, 22, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->6654],
Cell[169882, 5484, 1729, 47, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->16972],
Cell[171614, 5533, 309, 9, 70, "Text",
 CellTags->"jlug:6.10.0.2",
 CellID->21457]
}, Open  ]],
Cell[CellGroupData[{
Cell[171960, 5547, 157, 3, 70, "Subsection",
 CellTags->{"jlug:6.10.0.3", "TableOfContents_1.6.10.3"},
 CellID->14369],
Cell[172120, 5552, 684, 17, 70, "Text",
 CellTags->"jlug:6.10.0.3",
 CellID->22532],
Cell[172807, 5571, 468, 14, 70, "Program",
 CellTags->"jlug:6.10.0.3",
 CellID->2963],
Cell[173278, 5587, 76, 2, 70, "Text",
 CellTags->"jlug:6.10.0.3",
 CellID->2607],
Cell[173357, 5591, 3749, 116, 70, "Program",
 CellTags->"jlug:6.10.0.3",
 CellID->2483]
}, Open  ]],
Cell[CellGroupData[{
Cell[177143, 5712, 135, 2, 70, "Subsection",
 CellTags->{"jlug:6.10.0.4", "TableOfContents_1.6.10.4"},
 CellID->911],
Cell[177281, 5716, 859, 28, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->11635],
Cell[178143, 5746, 265, 7, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->10067],
Cell[178411, 5755, 2079, 61, 70, "Program",
 CellTags->"jlug:6.10.0.4",
 CellID->22848],
Cell[180493, 5818, 133, 4, 70, "Caption",
 CellTags->"jlug:6.10.0.4",
 CellID->4675],
Cell[180629, 5824, 2182, 57, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->12938],
Cell[182814, 5883, 946, 28, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->2223],
Cell[183763, 5913, 472, 13, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->22142],
Cell[184238, 5928, 233, 6, 70, "Program",
 CellTags->"jlug:6.10.0.4",
 CellID->23754],
Cell[184474, 5936, 638, 18, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->6511],
Cell[185115, 5956, 783, 24, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->22741],
Cell[185901, 5982, 416, 12, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->20175],
Cell[186320, 5996, 386, 13, 70, "Program",
 CellTags->"jlug:6.10.0.4",
 CellID->21459],
Cell[186709, 6011, 394, 9, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->17825],
Cell[187106, 6022, 988, 32, 70, "Program",
 CellTags->"jlug:6.10.0.4",
 CellID->3221],
Cell[188097, 6056, 521, 14, 70, "Text",
 CellTags->"jlug:6.10.0.4",
 CellID->17870]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[188667, 6076, 129, 2, 70, "Section",
 CellTags->{"jlug:6.11.0.0", "TableOfContents_1.6.11"},
 CellID->19718],
Cell[188799, 6080, 656, 20, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->19895],
Cell[189458, 6102, 172, 7, 70, "Program",
 CellTags->"jlug:6.11.0.0",
 CellID->5447],
Cell[189633, 6111, 960, 28, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->21726],
Cell[190596, 6141, 1978, 47, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->14771],
Cell[192577, 6190, 1873, 47, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->11538],
Cell[194453, 6239, 1862, 46, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->1869],
Cell[196318, 6287, 1653, 34, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->19912],
Cell[197974, 6323, 290, 11, 70, "Program",
 CellTags->"jlug:6.11.0.0",
 CellID->25667],
Cell[198267, 6336, 181, 5, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->26299],
Cell[198451, 6343, 569, 20, 70, "Program",
 CellTags->"jlug:6.11.0.0",
 CellID->17035],
Cell[199023, 6365, 1353, 36, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->9894],
Cell[200379, 6403, 1385, 46, 70, "Text",
 CellTags->"jlug:6.11.0.0",
 CellID->28703]
}, Open  ]],
Cell[CellGroupData[{
Cell[201801, 6454, 101, 2, 70, "Section",
 CellTags->{"jlug:6.12.0.0", "TableOfContents_1.6.12"},
 CellID->8483],
Cell[201905, 6458, 717, 19, 70, "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->5538],
Cell[202625, 6479, 198, 7, 70, "Program",
 CellTags->"jlug:6.12.0.0",
 CellID->7492],
Cell[202826, 6488, 555, 10, 70, "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->6193],
Cell[203384, 6500, 307, 15, 70, "Program",
 CellTags->"jlug:6.12.0.0",
 CellID->28252],
Cell[203694, 6517, 1266, 35, 70, "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->25011],
Cell[204963, 6554, 897, 22, 70, "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->1560],
Cell[205863, 6578, 358, 17, 70, "Program",
 CellTags->"jlug:6.12.0.0",
 CellID->15834],
Cell[206224, 6597, 782, 23, 70, "Text",
 CellTags->"jlug:6.12.0.0",
 CellID->1840]
}, Open  ]],
Cell[CellGroupData[{
Cell[207043, 6625, 108, 2, 70, "Section",
 CellTags->{"jlug:6.13.0.0", "TableOfContents_1.6.13"},
 CellID->58],
Cell[207154, 6629, 1611, 42, 70, "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->14700],
Cell[208768, 6673, 867, 24, 70, "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->13971],
Cell[209638, 6699, 661, 20, 70, "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->26264],
Cell[210302, 6721, 173, 5, 70, "Program",
 CellTags->"jlug:6.13.0.0",
 CellID->15117],
Cell[210478, 6728, 2071, 68, 70, "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->16215],
Cell[212552, 6798, 747, 21, 70, "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->24555],
Cell[213302, 6821, 247, 7, 70, "Program",
 CellTags->"jlug:6.13.0.0",
 CellID->7815],
Cell[213552, 6830, 622, 16, 70, "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->18330],
Cell[214177, 6848, 1944, 40, 70, "Text",
 CellTags->"jlug:6.13.0.0",
 CellID->3039],
Cell[216124, 6890, 513, 8, 70, "Program",
 CellTags->"jlug:6.13.0.0",
 CellID->30212]
}, Open  ]],
Cell[CellGroupData[{
Cell[216674, 6903, 117, 2, 70, "Section",
 CellTags->{"2.14", "jlug:6.14.0.0", "TableOfContents_1.6.14"},
 CellID->30188],
Cell[CellGroupData[{
Cell[216816, 6909, 125, 2, 70, "Subsection",
 CellTags->{"jlug:6.14.0.1", "TableOfContents_1.6.14.1"},
 CellID->21763],
Cell[216944, 6913, 624, 22, 70, "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->4940],
Cell[217571, 6937, 1079, 25, 70, "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->20851],
Cell[218653, 6964, 2316, 67, 70, "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->18662],
Cell[220972, 7033, 842, 26, 70, "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->13829],
Cell[221817, 7061, 218, 8, 70, "Program",
 CellTags->"jlug:6.14.0.1",
 CellID->30900],
Cell[222038, 7071, 463, 15, 70, "Text",
 CellTags->"jlug:6.14.0.1",
 CellID->611242602]
}, Open  ]],
Cell[CellGroupData[{
Cell[222538, 7091, 217, 7, 70, "Subsection",
 CellTags->{"jlug:6.14.0.2", "TableOfContents_1.6.14.2"},
 CellID->18958],
Cell[222758, 7100, 1508, 46, 70, "Text",
 CellTags->"jlug:6.14.0.2",
 CellID->17578],
Cell[224269, 7148, 229, 7, 70, "Program",
 CellTags->"jlug:6.14.0.2",
 CellID->8365]
}, Open  ]],
Cell[CellGroupData[{
Cell[224535, 7160, 136, 2, 70, "Subsection",
 CellTags->{"jlug:6.14.0.3", "TableOfContents_1.6.14.3"},
 CellID->13007],
Cell[224674, 7164, 874, 27, 70, "Text",
 CellTags->"jlug:6.14.0.3",
 CellID->11477],
Cell[225551, 7193, 479, 18, 70, "Program",
 CellTags->"jlug:6.14.0.3",
 CellID->1200],
Cell[226033, 7213, 849, 28, 70, "Text",
 CellTags->"jlug:6.14.0.3",
 CellID->26058]
}, Open  ]],
Cell[CellGroupData[{
Cell[226919, 7246, 164, 4, 70, "Subsection",
 CellTags->{"jlug:6.14.0.4", "TableOfContents_1.6.14.4"},
 CellID->6439],
Cell[227086, 7252, 1709, 48, 70, "Text",
 CellTags->"jlug:6.14.0.4",
 CellID->2303],
Cell[228798, 7302, 393, 13, 70, "Program",
 CellTags->"jlug:6.14.0.4",
 CellID->12760],
Cell[229194, 7317, 1168, 31, 70, "Text",
 CellTags->"jlug:6.14.0.4",
 CellID->19357]
}, Open  ]],
Cell[CellGroupData[{
Cell[230399, 7353, 135, 2, 70, "Subsection",
 CellTags->{"jlug:6.14.0.5", "TableOfContents_1.6.14.5"},
 CellID->2324],
Cell[230537, 7357, 1974, 63, 70, "Text",
 CellTags->"jlug:6.14.0.5",
 CellID->6477],
Cell[232514, 7422, 582, 19, 70, "Program",
 CellTags->"jlug:6.14.0.5",
 CellID->5108]
}, Open  ]],
Cell[CellGroupData[{
Cell[233133, 7446, 128, 2, 70, "Subsection",
 CellTags->{"jlug:6.14.0.6", "TableOfContents_1.6.14.6"},
 CellID->21113],
Cell[233264, 7450, 1182, 37, 70, "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->14887],
Cell[234449, 7489, 810, 24, 70, "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->19801],
Cell[235262, 7515, 265, 9, 70, "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->22850],
Cell[235530, 7526, 160, 7, 70, "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->14460],
Cell[235693, 7535, 394, 12, 70, "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->22428],
Cell[236090, 7549, 308, 12, 70, "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->12993],
Cell[236401, 7563, 1066, 32, 70, "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->27384],
Cell[237470, 7597, 219, 8, 70, "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->19405],
Cell[237692, 7607, 267, 9, 70, "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->6540],
Cell[237962, 7618, 756, 17, 70, "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->31111],
Cell[238721, 7637, 91, 2, 70, "Text",
 CellTags->"jlug:6.14.0.6",
 CellID->28704],
Cell[238815, 7641, 561, 16, 70, "Program",
 CellTags->"jlug:6.14.0.6",
 CellID->12835]
}, Open  ]],
Cell[CellGroupData[{
Cell[239413, 7662, 114, 2, 70, "Subsection",
 CellTags->{"jlug:6.14.0.7", "TableOfContents_1.6.14.7"},
 CellID->32356],
Cell[239530, 7666, 2115, 59, 70, "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->6072],
Cell[241648, 7727, 137, 4, 70, "Program",
 CellTags->"jlug:6.14.0.7",
 CellID->29350],
Cell[241788, 7733, 88, 2, 70, "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->18823],
Cell[241879, 7737, 162, 6, 70, "Program",
 CellTags->"jlug:6.14.0.7",
 CellID->14485],
Cell[242044, 7745, 705, 21, 70, "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->20556],
Cell[242752, 7768, 445, 13, 70, "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->23216],
Cell[243200, 7783, 257, 9, 70, "Program",
 CellTags->"jlug:6.14.0.7",
 CellID->9383296],
Cell[243460, 7794, 1596, 52, 70, "Text",
 CellTags->"jlug:6.14.0.7",
 CellID->9357]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[245105, 7852, 129, 2, 70, "Section",
 CellTags->{"2.15", "jlug:6.15.0.0", "TableOfContents_1.6.15"},
 CellID->189],
Cell[245237, 7856, 1294, 31, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->16100],
Cell[246534, 7889, 614, 16, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->19812],
Cell[247151, 7907, 170, 8, 70, "Program",
 CellTags->"jlug:6.15.0.0",
 CellID->30648],
Cell[247324, 7917, 151, 5, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->9523],
Cell[247478, 7924, 611, 16, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->19851],
Cell[248092, 7942, 408, 10, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->24474],
Cell[248503, 7954, 935, 23, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->28633],
Cell[249441, 7979, 561, 14, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->29891],
Cell[250005, 7995, 174, 5, 70, "Program",
 CellTags->"jlug:6.15.0.0",
 CellID->27200],
Cell[250182, 8002, 1030, 29, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->19854],
Cell[251215, 8033, 89, 2, 70, "Program",
 CellTags->"jlug:6.15.0.0",
 CellID->9990],
Cell[251307, 8037, 1481, 41, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->25697],
Cell[252791, 8080, 1024, 24, 70, "Text",
 CellTags->"jlug:6.15.0.0",
 CellID->4919]
}, Open  ]],
Cell[CellGroupData[{
Cell[253852, 8109, 192, 6, 70, "Section",
 CellTags->{"2.15", "jlug:6.16.0.0", "TableOfContents_1.6.16"},
 CellID->26222],
Cell[254047, 8117, 873, 25, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->29331],
Cell[254923, 8144, 1535, 44, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->2376],
Cell[256461, 8190, 1999, 62, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->28583],
Cell[258463, 8254, 285, 8, 70, "Program",
 CellTags->"jlug:6.16.0.0",
 CellID->26948],
Cell[258751, 8264, 1928, 56, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->12723],
Cell[260682, 8322, 698, 21, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->17982],
Cell[261383, 8345, 114, 2, 70, "Program",
 CellTags->"jlug:6.16.0.0",
 CellID->22018],
Cell[261500, 8349, 1222, 35, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->14776],
Cell[262725, 8386, 1332, 36, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->9220],
Cell[264060, 8424, 2921, 79, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->234550603],
Cell[266984, 8505, 201, 7, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->32182],
Cell[267188, 8514, 620, 18, 70, "Program",
 CellTags->"jlug:6.16.0.0",
 CellID->23856],
Cell[267811, 8534, 583, 18, 70, "Text",
 CellTags->"jlug:6.16.0.0",
 CellID->19490],
Cell[268397, 8554, 311, 13, 70, "Program",
 CellTags->"jlug:6.16.0.0",
 CellID->8925]
}, Open  ]],
Cell[CellGroupData[{
Cell[268745, 8572, 133, 2, 70, "Section",
 CellTags->{"2.17", "jlug:6.17.0.0", "TableOfContents_1.6.17"},
 CellID->8928],
Cell[CellGroupData[{
Cell[268903, 8578, 108, 2, 70, "Subsection",
 CellTags->{"jlug:6.17.0.1", "TableOfContents_1.6.17.1"},
 CellID->29492],
Cell[269014, 8582, 443, 11, 70, "Text",
 CellTags->"jlug:6.17.0.1",
 CellID->12433]
}, Open  ]],
Cell[CellGroupData[{
Cell[269494, 8598, 109, 2, 70, "Subsection",
 CellTags->{"jlug:6.17.0.2", "TableOfContents_1.6.17.2"},
 CellID->23840],
Cell[269606, 8602, 1283, 35, 70, "Text",
 CellTags->"jlug:6.17.0.2",
 CellID->6766],
Cell[270892, 8639, 698, 17, 70, "Text",
 CellTags->"jlug:6.17.0.2",
 CellID->1735],
Cell[271593, 8658, 520, 14, 70, "Program",
 CellTags->"jlug:6.17.0.2",
 CellID->19810]
}, Open  ]],
Cell[CellGroupData[{
Cell[272150, 8677, 111, 2, 70, "Subsection",
 CellTags->{"jlug:6.17.0.3", "TableOfContents_1.6.17.3"},
 CellID->11599],
Cell[272264, 8681, 1280, 37, 70, "Text",
 CellTags->"jlug:6.17.0.3",
 CellID->11837],
Cell[273547, 8720, 1015, 26, 70, "Text",
 CellTags->"jlug:6.17.0.3",
 CellID->31982],
Cell[274565, 8748, 246, 8, 70, "Program",
 CellTags->"jlug:6.17.0.3",
 CellID->7328],
Cell[274814, 8758, 941, 22, 70, "Text",
 CellTags->"jlug:6.17.0.3",
 CellID->29352],
Cell[275758, 8782, 391, 11, 70, "Text",
 CellTags->"jlug:6.17.0.3",
 CellID->11369]
}, Open  ]],
Cell[CellGroupData[{
Cell[276186, 8798, 130, 2, 70, "Subsection",
 CellTags->{"jlug:6.17.0.4", "TableOfContents_1.6.17.4"},
 CellID->31244],
Cell[276319, 8802, 850, 24, 70, "Text",
 CellTags->"jlug:6.17.0.4",
 CellID->21794],
Cell[277172, 8828, 572, 18, 70, "Text",
 CellTags->"jlug:6.17.0.4",
 CellID->6608],
Cell[277747, 8848, 1116, 30, 70, "Text",
 CellTags->"jlug:6.17.0.4",
 CellID->9252],
Cell[278866, 8880, 594, 16, 70, "Text",
 CellTags->"jlug:6.17.0.4",
 CellID->11647]
}, Open  ]],
Cell[CellGroupData[{
Cell[279497, 8901, 111, 2, 70, "Subsection",
 CellTags->{"jlug:6.17.0.5", "TableOfContents_1.6.17.5"},
 CellID->17432],
Cell[279611, 8905, 737, 18, 70, "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->9535],
Cell[280351, 8925, 981, 30, 70, "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->7208],
Cell[281335, 8957, 252, 7, 70, "Program",
 CellTags->"jlug:6.17.0.5",
 CellID->3264],
Cell[281590, 8966, 509, 14, 70, "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->3497],
Cell[282102, 8982, 613, 20, 70, "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->23243],
Cell[282718, 9004, 105, 3, 70, "Input",
 CellTags->"jlug:6.17.0.5",
 CellID->27649],
Cell[282826, 9009, 1068, 31, 70, "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->22015],
Cell[283897, 9042, 1383, 37, 70, "Text",
 CellTags->"jlug:6.17.0.5",
 CellID->26841]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[285329, 9085, 106, 2, 70, "Section",
 CellTags->{"jlug:6.18.0.0", "TableOfContents_1.6.18"},
 CellID->20615],
Cell[285438, 9089, 689, 17, 70, "Text",
 CellTags->"jlug:6.18.0.0",
 CellID->10904],
Cell[286130, 9108, 2189, 68, 70, "Text",
 CellTags->"jlug:6.18.0.0",
 CellID->2599],
Cell[288322, 9178, 1200, 24, 70, "Text",
 CellTags->"jlug:6.18.0.0",
 CellID->20136]
}, Open  ]]
}, Open  ]],
Cell[289549, 9206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

