(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5287,        141]
NotebookOptionsPosition[      4554,        111]
NotebookOutlinePosition[      4947,        128]
CellTagsIndexPosition[      4904,        125]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "J/Link Example: A File Chooser Dialog\n\n",
 StyleBox["Code for the file chooser dialog from section 1.3.6 of the J/Link \
User Guide.\n\nYou need the Swing classes installed to run this example. \
Swing is a standard part of the JDK 1.2 version, but 1.1.x versions may have \
it as well. If you get a lot of LoadJavaClass::fail messages, you either do \
not have Swing, or you do not have a recent-enough version of it.\n\nTo try \
this example, evaluate all the initialization cells (you can do this with the \
menu command Kernel/Evaluation/Evaluate Initialization). Then go to the \
Examples section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell[TextData[{
 "Needs[\"JLink`\"]\n\nFileChooserDialog[] := FileChooserDialog[\"Select a \
file:\", \"Open\", Directory[]]\n\nFileChooserDialog[title_String, \
okText_String, dir_String] :=\n\tJavaBlock[\n\t\tModule[{dlg, frm, dummy, \
chosenFile, result = Null},\n\t\t\tInstallJava[];\n\t\t\tdlg = \
JavaNew[\"javax.swing.JFileChooser\"];\n\t\t\tIf[!JavaObjectQ[dlg],\n\t\t\t\t\
Print[\"You must have the Swing classes installed for this example.\"];\n\t\t\
\t\tReturn[$Failed]\n\t\t\t];\n\t\t\t\
dlg@setCurrentDirectory[JavaNew[\"java.io.File\", dir]];\n\t\t\t\
dlg@setDialogTitle[title];\n\t\t\t(* We cannot call JavaShow to display the \
JFileChooser dialog because it is not\n\t\t\t   a subclass of Window, and \
also because it has its own special showDialog()\n\t\t\t   method that should \
be invoked to display it and run its modal event loop.\n\t\t\t   Recall that \
on some platforms (notably Mac and Windows), JavaShow performs\n\t\t\t   some \
internal low-level steps to allow Java windows to come to the foreground\n\t\t\
\t   in front of the notebook window. Because we cannot call JavaShow here, \
the\n\t\t\t   dialog window does not reliably come to the foreground on all \
platforms\n\t\t\t   without a little help. The trick is to create a small \
window that we\n\t\t\t   can call JavaShow on before we display the dialog. \
The \"dummy\" window on\n\t\t\t   which we will call JavaShow is of type \
Dialog, because if it was a Frame\n\t\t\t   it would show up in the taskbar \
on Windows, which we want to avoid.\n\t\t\t*)\n\t\t\tfrm = \
JavaNew[\"java.awt.Frame\"]; (* Need a frame to host the dummy dialog. *)\n\t\
\t\tdummy = JavaNew[\"java.awt.Dialog\", frm];\n\t\t\t(* Put it offscreen. *)\
\n\t\t\tdummy@setLocation[-500, -500];\n",
 StyleBox["\t\t\tJavaShow[",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontFamily->"Courier New"],
 "dummy",
 StyleBox["];\n",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontFamily->"Courier New"],
 "\t\t\t(* On Linux and perhaps other UNIX platforms, we cannot put a dialog \
truly\n\t\t\t   offscreen until after it is shown. Thus we repeat the \
setLocation().\n\t\t\t*)\n\t\t\tdummy@setLocation[-500, -500];\n\t\t\t\
If[dlg@showDialog[Null, okText] === JFileChooser`APPROVEUOPTION,\n\t\t\t\t(* \
showDialog will not return until the dialog is dismissed. *)\n\t\t\t\t\
chosenFile = dlg@getSelectedFile[];\n\t\t\t\tIf[chosenFile =!= Null,\n\t\t\t\t\
\tresult = chosenFile@getPath[]\n\t\t\t\t]\n\t\t\t];\n\t\t\tfrm@dispose[];\n\t\
\t\tdummy@dispose[];\n\t\t\tresult\n\t\t]\n\t]"
}], "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["\<\
These examples just return the full path of the selected file. They do not \
perform any actual file operations..\
\>", "Text"],

Cell["This is a simple \"Open\"-style dialog:", "Text"],

Cell["FileChooserDialog[]", "Input"],

Cell["This is a simple \"Save\"-style dialog:", "Text"],

Cell["FileChooserDialog[\"Save data as:\", \"Save\", Directory[]]", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{747, 492},
WindowMargins->{{5, Automatic}, {Automatic, 2}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 720, 13, 307, "Title"],
Cell[CellGroupData[{
Cell[1335, 40, 26, 0, 34, "Subsection"],
Cell[1364, 42, 2721, 47, 876, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[4122, 94, 30, 0, 26, "Subsection"],
Cell[4155, 96, 137, 3, 26, "Text"],
Cell[4295, 101, 55, 0, 26, "Text"],
Cell[4353, 103, 36, 0, 24, "Input"],
Cell[4392, 105, 55, 0, 26, "Text"],
Cell[4450, 107, 76, 0, 24, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

