(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4975,        146]
NotebookOptionsPosition[      4385,        120]
NotebookOutlinePosition[      4778,        137]
CellTagsIndexPosition[      4735,        134]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "J/Link Example: A ProgressBar Dialog\n\n",
 StyleBox["Code for the progress-bar dialog from section 1.3.4 of the J/Link \
User Guide.\n\nThis example demonstrates a simple ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["\"non-interactive\"",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" user interface created from ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica ",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["(as described in section 1.2.7 of the User Guide). It makes no \
calls back to ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" and does not return a result to ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[".\n\nYou need the Swing classes installed to run this example. \
Swing is a standard part of the JDK 1.2 version, but 1.1.x versions may have \
it as well. If you get a lot of LoadClass::fail messages, you either do not \
have Swing, or you do not have a recent-enough version of it.\n\nTo try this \
example, evaluate all the initialization cells (you can do this with the menu \
command Kernel/Evaluation/Evaluate Initialization). Then go to the Example \
section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell[TextData[{
 "Needs[\"JLink`\"]\n\nShowProgressBar[title_String:\"Computation Progress\", \
caption_String:\"Percent complete:\", percent_Integer:0] :=\n\tModule[{frame, \
panel, label, bar},\n\t\tJavaBlock[\n\t\t\tInstallJava[];\n\t\t\tbar = \
JavaNew[\"javax.swing.JProgressBar\"];\n\t\t\tIf[!JavaObjectQ[bar],\n\t\t\t\t\
Print[\"You must have the Swing classes installed for this example.\"];\n\t\t\
\t\tReturn[$Failed]\n\t\t\t];\n\t\t\tframe = JavaNew[\"javax.swing.JFrame\", \
title];\n\t\t\tframe@setSize[300, 110];\n\t\t\tframe@setResizable[False];\n\t\
\t\tframe@setLocation[400, 400];\n\t\t\tpanel = \
JavaNew[\"javax.swing.JPanel\"];\n\t\t\tpanel@setLayout[Null];\n\t\t\t\
frame@getContentPane[]@add[panel];\n\t\t\tlabel = \
JavaNew[\"javax.swing.JLabel\", caption];\n\t\t\tlabel@setBounds[20, 10, 260, \
20];\n\t\t\tpanel@add[label];\n\t\t\tbar@setBounds[20, 40, 260, 30];\n\t\t\t\
bar@setMinimum[0];\n\t\t\tbar@setMaximum[100];\n\t\t\tbar@setValue[percent];\n\
\t\t\tpanel@add[bar];\n\t\t\tJavaShow[frame];\n\t\t\tbar\n\t\t]\n\t]\n\n\
DestroyProgressBar[bar_?JavaObjectQ] :=\n\tJavaBlock[\n\t\t\
LoadClass[\"javax.swing.SwingUtilities\"];\n\t\t\
SwingUtilities`windowForComponent[bar]@dispose[];\n\t\tRelease",
 "Java",
 "Object[bar]\n\t]\n\n\n",
 StyleBox["ProgressBarDemo[] :=\n\tModule[{bar, n},\n\t\tbar = \
ShowProgressBar[];\n\t\tbar@setString[\"0%\"];\n\t\t\
bar@setStringPainted[True];\n\t\tn = 0;\n\t\tWhile[n <= 5,\n\t\t\t\
bar@setValue[n/5 * 100];\n\t\t\tbar@setString[ToString[n/5 * 100] <> \"%\"];\n\
\t\t\tPause[1]; (* This simulates the time-consuming computation. *)\n\t\t\t\
n++\n\t\t];\n\t\tDestroyProgressBar[bar];\n\t]",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}], "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["ProgressBarDemo[]", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{786, 565},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 1778, 48, 353, "Title"],
Cell[CellGroupData[{
Cell[2393, 75, 26, 0, 34, "Subsection"],
Cell[2422, 77, 1832, 32, 966, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[4291, 114, 29, 0, 26, "Subsection"],
Cell[4323, 116, 34, 0, 24, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

