(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4685,        160]
NotebookOptionsPosition[      3986,        131]
NotebookOutlinePosition[      4379,        148]
CellTagsIndexPosition[      4336,        145]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "J/Link Example: Scribble\n\n",
 StyleBox["Code for the Scribble example from section 1.2.7 of the J/Link \
User Guide.\n",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["\nThis example is a simple demonstration of drawing into a Java \
window with ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" code.\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
Needs[\"JLink`\"]

Scribble[] :=
\tJavaBlock[
\t\tModule[{frame, mathCanvas, offscreen, g, mml, pts, mouseDraggedFunc},
\t\t\tInstallJava[];
\t\t\tframe = JavaNew[\"com.wolfram.jlink.MathFrame\", \"Scribble\"];
\t\t\tframe@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
\t\t\tmathCanvas = JavaNew[\"com.wolfram.jlink.MathCanvas\"];
\t\t\tframe@add[\"Center\", mathCanvas];
\t\t\tframe@setSize[400, 400];
\t\t\tframe@layout[];
\t\t\tJavaShow[frame];
\t\t\t(* Now create the offscreen image and the graphics context
\t\t\t   for drawing into it.
\t\t\t*)
\t\t\toffscreen = mathCanvas@createImage[mathCanvas@getSize[]@width,
                                  \t\t mathCanvas@getSize[]@height];
\t\t\tg = offscreen@getGraphics[];
\t\t\t(* Now create the MathMouseMotionListener that will do the drawing
\t\t\t   and set its mouseDragged event handler callback.
\t\t\t*)
\t\t\tmml = JavaNew[\"com.wolfram.jlink.MathMouseMotionListener\"];
\t\t\t(* Because mouseDraggedFunc is local to this Module, its name is not
\t\t\t   really 'mouseDraggedFunc', but rather something link \
'mouseDraggedFunc$123'.
\t\t\t   We use the ToString trick to capture its true name.
\t\t\t*)
\t\t\tmml@setHandler[\"mouseDragged\", ToString[mouseDraggedFunc]];
\t\t\tmathCanvas@addMouseMotionListener[mml];
\t\t\tmouseDraggedFunc[_, x_, y_, _] :=
\t\t\t\t(g@drawLine[pts[[-1, 1]], pts[[-1, 2]], x, y];
\t\t\t\t mathCanvas@setImage[offscreen];
\t\t\t\t mathCanvas@repaintNow[];
\t\t\t\t AppendTo[pts, {x,y}];);
\t\t\t(* Initialize the pts list and run the program modally. *)
\t\t\tpts = {{0,0}};
\t\t\tframe@setModal[];
\t\t\tDoModal[];
\t\t\tpts
\t\t]
\t]\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["pts = Scribble[];", "Input"],

Cell["Click or drag the mouse to draw in the window.", "Text"],

Cell[TextData[{
 "Java's coordinate system has (0, 0) at the top left of the image, whereas \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has (0, 0) at the bottom left. Therefore to have ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " render the drawing, we need to flip the points in the y direction: "
}], "Text"],

Cell["Show[Graphics[Line[({1, -1} * #)& /@ pts]], AspectRatio->1]", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{814, 520},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 996, 30, 267, "Title"],
Cell[CellGroupData[{
Cell[1611, 57, 26, 0, 34, "Subsection"],
Cell[1640, 59, 1735, 46, 750, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[3412, 110, 29, 0, 26, "Subsection"],
Cell[3444, 112, 34, 0, 24, "Input"],
Cell[3481, 114, 62, 0, 26, "Text"],
Cell[3546, 116, 333, 9, 41, "Text"],
Cell[3882, 127, 76, 0, 24, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

