(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55158,       1836]
NotebookOptionsPosition[     37979,       1409]
NotebookOutlinePosition[     38456,       1430]
CellTagsIndexPosition[     38413,       1427]
MenuPosition->0
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Title"],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style. Make modifications to any definition using commands in the \
Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "SlideShow"],
 PageWidth->WindowWidth,
 ScrollingOptions->{"PagewiseDisplay"->True,
 "VerticalScrollRange"->Fit},
 ShowCellBracket->False,
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
 PageWidth->PaperWidth,
 ShowCellLabel->False,
 ShowAutoStyles->False,
 ImageSize->{200, 200},
 PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the Notebook level.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Notebook"],
 PageHeaders->{{
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"], None, 
    Cell[
     TextData[{
       ValueBox["FileName"]}], "Header"]}, {
    Cell[
     TextData[{
       ValueBox["FileName"]}], "Header"], None, 
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"]}},
 PageHeaderLines->{True, True},
 PrintingOptions->{"FacingPages"->True,
 "FirstPageHeader"->False},
 CellLabelAutoDelete->False,
 CellFrameLabelMargins->6,
 StyleMenuListing->None],

Cell[StyleData["Notebook", "Presentation"],
 FontSize->12]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
 CellFrame->{{0, 0}, {0, 0.25}},
 CellMargins->{{18, 30}, {4, 20}},
 CellGroupingRules->{"TitleGrouping", 0},
 PageBreakBelow->False,
 CellFrameMargins->9,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 LineSpacing->{0.95, 11},
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 FontSize->36],

Cell[StyleData["Title", "Presentation"],
 CellMargins->{{25, 30}, {40, 30}},
 CellFrameMargins->{{6, 10}, {10, 14}},
 FontSize->54],

Cell[StyleData["Title", "Printout"],
 CellMargins->{{18, 30}, {4, 0}},
 CellFrameMargins->4,
 FontSize->30]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
 CellMargins->{{18, 30}, {0, 10}},
 CellGroupingRules->{"TitleGrouping", 10},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 LineSpacing->{1, 0},
 CounterIncrements->"Subtitle",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 FontSize->24,
 FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Presentation"],
 CellMargins->{{25, 40}, {55, 10}},
 FontSize->36],

Cell[StyleData["Subtitle", "Printout"],
 CellMargins->{{18, 30}, {0, 10}},
 FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionFirst"],
 CellFrame->{{0, 0}, {0, 3}},
 CellMargins->{{18, 30}, {4, 30}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 CellFrameMargins->3,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["SectionFirst", "Presentation"],
 CellFrame->{{0, 0}, {0, 8}},
 CellMargins->{{25, 30}, {65, 10}},
 FontSize->27],

Cell[StyleData["SectionFirst", "Printout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellMargins->{{18, 30}, {4, 30}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
 CellMargins->{{25, 30}, {30, 15}},
 FontSize->27],

Cell[StyleData["Section", "Printout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
 CellDingbat->"\[FilledSquare]",
 CellMargins->{{18, 30}, {4, 20}},
 CellGroupingRules->{"SectionGrouping", 50},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
 CellMargins->{{25, 30}, {30, 20}},
 FontSize->21],

Cell[StyleData["Subsection", "Printout"],
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{18, 30}, {4, 12}},
 CellGroupingRules->{"SectionGrouping", 60},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Subsubsection",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
 CellMargins->{{25, 30}, {10, 10}},
 FontSize->18],

Cell[StyleData["Subsubsection", "Printout"],
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{18, 10}, {Inherited, 6}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 TextJustification->1,
 LineSpacing->{1, 2},
 CounterIncrements->"Text"],

Cell[StyleData["Text", "Presentation"],
 CellMargins->{{25, 10}, {6, 20}},
 FontSize->18],

Cell[StyleData["Text", "Printout"],
 CellMargins->{{18, 30}, {Inherited, 4}},
 Hyphenation->True,
 LineSpacing->{1, 3},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
 CellMargins->{{55, 50}, {5, 5}},
 PageBreakAbove->False,
 FontSize->10],

Cell[StyleData["Caption", "Presentation"],
 CellMargins->{{80, 50}, {8, 14}},
 FontSize->15],

Cell[StyleData["Caption", "Printout"],
 CellMargins->{{55, 55}, {5, 2}},
 Hyphenation->True,
 FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
 CellMargins->{{55, 10}, {5, 8}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 LinebreakAdjustments->{0.85, 2, 10, 0, 1},
 CounterIncrements->"Input",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
 CellMargins->{{80, 10}, {8, 15}},
 FontSize->18],

Cell[StyleData["Input", "Printout"],
 CellMargins->{{55, 55}, {0, 10}},
 ShowCellLabel->False,
 LinebreakAdjustments->{0.85, 2, 10, 1, 1},
 FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
 CellMargins->{{55, 10}, {8, 5}},
 CellEditDuplicate->True,
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabelPositioning->Left,
 CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
 CellMargins->{{80, 10}, {30, 12}},
 FontSize->16],

Cell[StyleData["Output", "Printout"],
 CellMargins->{{55, 55}, {10, 10}},
 ShowCellLabel->False,
 FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
 CellDingbat->"\[LongDash]",
 CellMargins->{{55, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 AutoStyleOptions->{"SyntaxErrorStyle"->None},
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 CounterIncrements->"Message",
 StyleMenuListing->None,
 FontSize->10,
 FontSlant->"Italic"],

Cell[StyleData["Message", "Presentation"],
 CellMargins->{{80, 10}, {15, 8}},
 FontSize->15],

Cell[StyleData["Message", "Printout"],
 CellMargins->{{55, 55}, {0, 3}},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
 CellMargins->{{55, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 TextAlignment->Left,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 FormatType->InputForm,
 CounterIncrements->"Print",
 StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
 CellMargins->{{80, 10}, {12, 8}},
 FontSize->16],

Cell[StyleData["Print", "Printout"],
 CellMargins->{{54, 72}, {2, 10}},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
 CellMargins->{{55, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 FormatType->InputForm,
 CounterIncrements->"Graphics",
 StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
 CellMargins->{{80, 10}, {10, 10}},
 FontSize->16],

Cell[StyleData["Graphics", "Printout"],
 CellMargins->{{55, 55}, {0, 15}},
 ImageSize->{0.0625, 0.0625},
 ImageMargins->{{35, Inherited}, {Inherited, 0}},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
 CellMargins->{{9, Inherited}, {Inherited, Inherited}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontSlant->"Oblique"],

Cell[StyleData["CellLabel", "Presentation"],
 FontSize->14],

Cell[StyleData["CellLabel", "Printout"],
 CellMargins->{{0, Inherited}, {Inherited, Inherited}},
 FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],

Cell[StyleData["RM"],
 StyleMenuListing->None,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["BF"],
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["IT"],
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["TR"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["TB"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TBI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MR"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MO"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MB"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MBO"],
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SR"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SB"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->7,
 FontWeight->"Plain",
 FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Inert"],
 StyleMenuListing->None,
 Background->RGBColor[0.870588235294118, 0.905882352941176, 0.972549019607843]
  ],

Cell[StyleData["Inert", "Printout"],
 StyleMenuListing->None,
 Background->GrayLevel[1]]
}, Closed]],

Cell[StyleData["Small"],
 StyleMenuListing->None,
 FontSize->9],

Cell[StyleData["Medium"],
 StyleMenuListing->None,
 FontSize->12],

Cell[StyleData["Large"],
 StyleMenuListing->None,
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
 CellMargins->{{45, Inherited}, {2, 20}},
 CellGroupingRules->{"TitleGrouping", 20},
 PageBreakBelow->False,
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Author", "Presentation"],
 CellMargins->{{65, 30}, {4, 30}},
 FontSize->21],

Cell[StyleData["Author", "Printout"],
 CellMargins->{{36, Inherited}, {2, 30}},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Address"],
 CellMargins->{{45, Inherited}, {2, 2}},
 CellGroupingRules->{"TitleGrouping", 30},
 PageBreakBelow->False,
 LineSpacing->{1, 1},
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 FontSize->12,
 FontSlant->"Italic"],

Cell[StyleData["Address", "Presentation"],
 CellMargins->{{65, 30}, {40, 2}},
 FontSize->18],

Cell[StyleData["Address", "Printout"],
 CellMargins->{{36, Inherited}, {2, 2}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Abstract"],
 CellMargins->{{45, 75}, {Inherited, 30}},
 LineSpacing->{1, 0}],

Cell[StyleData["Abstract", "Presentation"],
 CellMargins->{{65, 30}, {8, 25}},
 FontSize->18],

Cell[StyleData["Abstract", "Printout"],
 CellMargins->{{36, 67}, {Inherited, 50}},
 Hyphenation->True,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
 CellMargins->{{18, 40}, {2, 2}},
 TextJustification->1,
 LineSpacing->{1, 0}],

Cell[StyleData["Reference", "Presentation"],
 CellMargins->{{25, 40}, {2, 2}},
 FontSize->18],

Cell[StyleData["Reference", "Printout"],
 CellMargins->{{18, 40}, {Inherited, 0}},
 Hyphenation->True,
 FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext ButtonBoxes.  The \
\"Hyperlink\" style is for links within the same Notebook, or between \
Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line help \
system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["MainBook", #]}]& )}],

Cell[StyleData["MainBookLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["AddOns", #]}]& )}],

Cell[StyleData["AddOnsLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["RefGuide", #]}]& )}],

Cell[StyleData["RefGuideLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["GettingStarted", #]}]& )}],

Cell[StyleData["GettingStartedLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Demos", #]}]& )}],

Cell[StyleData["DemosLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Tour", #]}]& )}],

Cell[StyleData["TourLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["OtherInformation", #]}]& )}],

Cell[StyleData["OtherInformationLink", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["MasterIndex", #]}]& )}],

Cell[StyleData["MasterIndexLink", "Printout"],
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, for use \
in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["Evaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["EvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionMove[
     FrontEnd`InputNotebook[], All, Cell, 1], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
 Editable->False,
 CellFrame->True,
 CellMargins->{{0, 0}, {3, 3}},
 CellElementSpacings->{"CellMinHeight"->0.8125},
 CellGroupingRules->{"SectionGrouping", -5},
 CellFrameMargins->False,
 CellFrameColor->GrayLevel[1],
 CellFrameLabelMargins->False,
 TextAlignment->Center,
 CounterIncrements->"SlideShowNavigationBar",
 StyleMenuListing->None,
 FontSize->10,
 Magnification->1,
 Background->GrayLevel[0.8],
 GridBoxOptions->{
 ColumnAlignments->{
  Center, Center, Center, Center, Center, Center, Right, Center},
 ColumnSpacings->0,
 ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
 GridBaseline->Center,
 RowAlignments->Baseline,
 RowSpacings->0}],

Cell[StyleData["SlideShowNavigationBar", "Presentation"]],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{-1, -1}, {-1, -1}},
 PageBreakAbove->True,
 CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
 CellMargins->{{18, 4}, {4, 4}},
 LineSpacing->{1, 3},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{0, 0}, {10, 0}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 CellFrameMargins->{{12, 4}, {6, 12}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->18,
 FontWeight->"Plain",
 FontColor->GrayLevel[1],
 Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
 CellFrameMargins->{{18, 10}, {10, 18}},
 FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
 ShowCellBracket->False,
 PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
 CellMargins->{{18, 30}, {0, 30}},
 CellFrameMargins->5,
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontSize->26,
 FontColor->GrayLevel[0.400015],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Presentation"],
 CellMargins->{{10, 10}, {10, 12}},
 FontSize->36],

Cell[StyleData["SlideHyperlink", "SlideShow"],
 FontSize->26],

Cell[StyleData["SlideHyperlink", "Printout"],
 FontSize->10,
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PreviousNext"],
 CellMargins->{{60, 10}, {7, 7}},
 TextAlignment->0.75,
 LineSpacing->{1, 3},
 CounterIncrements->"PreviousNext",
 FontFamily->"Helvetica",
 FontSize->10,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["PreviousNext", "Presentation"],
 CellMargins->{{24, 50}, {10, 10}},
 LineSpacing->{1, 5},
 FontSize->12],

Cell[StyleData["PreviousNext", "SlideShow"],
 CellMargins->{{50, 50}, {50, 15}},
 FontSize->12],

Cell[StyleData["PreviousNext", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 Hyphenation->True,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlidePreviousNextLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontVariations->{"Underline"->False},
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlidePreviousNextLink", "Presentation"]],

Cell[StyleData["SlidePreviousNextLink", "SlideShow"]],

Cell[StyleData["SlidePreviousNextLink", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
 CellMargins->{{24, Inherited}, {Inherited, Inherited}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Helvetica",
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->1.5,
 ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "Presentation"],
 CellMargins->{{35, 10}, {15, 12}},
 FontSize->18],

Cell[StyleData["SlideTOCLink", "SlideShow"],
 FontSize->12],

Cell[StyleData["SlideTOCLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
 CellDingbat->"\[Bullet]",
 CellMargins->{{18, Inherited}, {Inherited, Inherited}},
 StyleMenuListing->None,
 FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "Presentation"],
 CellMargins->{{25, 10}, {10, 10}},
 FontSize->18],

Cell[StyleData["SlideTOC", "SlideShow"],
 FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, etc.  They \
automatically give the cell a FrameLabel containing a reference to a \
particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
 CellMargins->{{55, 10}, {0, 10}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["NumberedEquation"], ")"}]]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 CounterIncrements->"NumberedEquation",
 FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Presentation"],
 CellMargins->{{80, 10}, {0, 20}},
 FontSize->18],

Cell[StyleData["NumberedEquation", "Printout"],
 CellMargins->{{55, 55}, {0, 10}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
 CellMargins->{{55, 145}, {2, 10}},
 CellHorizontalScrolling->True,
 CellFrameLabels->{{None, None}, {
    Cell[
     TextData[{"Figure ", 
       CounterBox["NumberedFigure"]}], FontWeight -> "Bold"], None}},
 CounterIncrements->"NumberedFigure",
 FormatTypeAutoConvert->False],

Cell[StyleData["NumberedFigure", "Presentation"],
 CellMargins->{{80, 10}, {0, 20}},
 FontSize->18],

Cell[StyleData["NumberedFigure", "Printout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
 CellMargins->{{55, 145}, {2, 10}},
 CellFrameLabels->{{None, None}, {
    Cell[
     TextData[{"Table ", 
       CounterBox["NumberedTable"]}], FontWeight -> "Bold"], None}},
 TextAlignment->Center,
 CounterIncrements->"NumberedTable",
 FormatTypeAutoConvert->False],

Cell[StyleData["NumberedTable", "Presentation"],
 CellMargins->{{80, 10}, {0, 20}},
 FontSize->18],

Cell[StyleData["NumberedTable", "Printout"],
 CellMargins->{{18, Inherited}, {Inherited, Inherited}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
 CellMargins->{{55, 10}, {2, 10}},
 CellHorizontalScrolling->True,
 DefaultFormatType->DefaultInputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 LanguageCategory->"Formula",
 ScriptLevel->0,
 SingleLetterItalics->True,
 UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
 CellMargins->{{80, 10}, {5, 25}},
 FontSize->18],

Cell[StyleData["DisplayFormula", "Printout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
 CellMargins->{{55, 10}, {2, 10}},
 DefaultFormatType->DefaultInputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 LanguageCategory->"Formula",
 AutoSpacing->False,
 ScriptBaselineShifts->{0.6, Automatic},
 ScriptLevel->1,
 SingleLetterItalics->False,
 ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Presentation"],
 CellMargins->{{80, 10}, {5, 15}},
 FontSize->18],

Cell[StyleData["ChemicalFormula", "Printout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
 CellMargins->{{18, 10}, {Inherited, 6}},
 Hyphenation->False,
 LanguageCategory->"Formula",
 FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
 CellMargins->{{25, 10}, {8, 20}},
 FontSize->16],

Cell[StyleData["Program", "Printout"],
 CellMargins->{{18, 30}, {Inherited, 4}},
 FontSize->9.5]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit)",
WindowToolbars->{},
WindowSize->{500, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingOptions->{"FacingPages"->True,
"FirstPageFace"->Right,
"FirstPageFooter"->True,
"FirstPageHeader"->False},
MenuPosition->None,
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[606, 24, 34, 0, 76, "Title"],
Cell[643, 26, 192, 4, 56, "Text"],
Cell[CellGroupData[{
Cell[860, 34, 42, 0, 67, "Section"],
Cell[905, 36, 74, 2, 70, 31, 0, "StyleData", "All", "Working"],
Cell[982, 40, 79, 2, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[1064, 44, 201, 6, 70, 33, 0, "StyleData", "All", "SlideShow"],
Cell[1268, 52, 173, 5, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[1478, 62, 35, 0, 37, "Section"],
Cell[1516, 64, 99, 2, 70, "Text"],
Cell[CellGroupData[{
Cell[1640, 70, 520, 19, 70, 27, 0, "StyleData", "Notebook", "All",
 StyleMenuListing->None],
Cell[2163, 91, 58, 1, 70, 43, 0, "StyleData", "Notebook", "Presentation"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[2270, 98, 38, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[2333, 102, 1288, 32, 70, 24, 0, "StyleData", "Title", "All",
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3624, 136, 131, 3, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3758, 141, 107, 3, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[3902, 149, 1258, 31, 70, 27, 0, "StyleData", "Subtitle", "All",
 CounterIncrements->"Subtitle",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[5163, 182, 94, 2, 70, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[5260, 186, 89, 2, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[5386, 193, 1285, 32, 70, 31, 0, "StyleData", "SectionFirst", "All",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[6674, 227, 128, 3, 70, 47, 0, "StyleData", "SectionFirst", \
"Presentation"],
Cell[6805, 232, 58, 1, 70, 43, 0, "StyleData", "SectionFirst", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[6900, 238, 1228, 30, 70, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[8131, 270, 93, 2, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[8227, 274, 53, 1, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[8317, 280, 1248, 31, 70, 29, 0, "StyleData", "Subsection", "All",
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}}],
Cell[9568, 313, 96, 2, 70, 45, 0, "StyleData", "Subsection", "Presentation"],
Cell[9667, 317, 56, 1, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[9760, 323, 1214, 30, 70, 32, 0, "StyleData", "Subsubsection", "All",
 CounterIncrements->"Subsubsection"],
Cell[10977, 355, 99, 2, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[11079, 359, 59, 1, 70, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11187, 366, 39, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[11251, 370, 1105, 27, 70, 23, 0, "StyleData", "Text", "All",
 CounterIncrements->"Text"],
Cell[12359, 399, 89, 2, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[12451, 403, 134, 4, 70, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[12622, 412, 99, 3, 70, 26, 0, "StyleData", "Caption", "All"],
Cell[12724, 417, 92, 2, 70, 42, 0, "StyleData", "Caption", "Presentation"],
Cell[12819, 421, 106, 3, 70, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[12974, 430, 42, 0, 37, "Section"],
Cell[13019, 432, 246, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[13290, 440, 679, 20, 70, 24, 0, "StyleData", "Input", "All",
 CounterIncrements->"Input"],
Cell[13972, 462, 90, 2, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[14065, 466, 154, 4, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14256, 475, 614, 17, 70, 25, 0, "StyleData", "Output", "All",
 CounterIncrements->"Output"],
Cell[14873, 494, 92, 2, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[14968, 498, 112, 3, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15117, 506, 683, 19, 70, 26, 0, "StyleData", "Message", "All",
 CounterIncrements->"Message",
 StyleMenuListing->None],
Cell[15803, 527, 92, 2, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[15898, 531, 86, 2, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16021, 538, 620, 17, 70, 24, 0, "StyleData", "Print", "All",
 CounterIncrements->"Print",
 StyleMenuListing->None],
Cell[16644, 557, 90, 2, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[16737, 561, 85, 2, 70, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16859, 568, 378, 11, 70, 27, 0, "StyleData", "Graphics", "All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[17240, 581, 94, 2, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[17337, 585, 168, 4, 70, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[17542, 594, 172, 5, 70, 28, 0, "StyleData", "CellLabel", "All",
 StyleMenuListing->None],
Cell[17717, 601, 59, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[17779, 604, 110, 2, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[17938, 612, 36, 0, 37, "Section"],
Cell[17977, 614, 121, 3, 70, "Text"],
Cell[18101, 619, 89, 3, 70, 21, 0, "StyleData", "RM", "All",
 StyleMenuListing->None],
Cell[18193, 624, 67, 2, 70, 21, 0, "StyleData", "BF", "All",
 StyleMenuListing->None],
Cell[18263, 628, 68, 2, 70, 21, 0, "StyleData", "IT", "All",
 StyleMenuListing->None],
Cell[18334, 632, 111, 4, 70, 21, 0, "StyleData", "TR", "All",
 StyleMenuListing->None],
Cell[18448, 638, 112, 4, 70, 21, 0, "StyleData", "TI", "All",
 StyleMenuListing->None],
Cell[18563, 644, 110, 4, 70, 21, 0, "StyleData", "TB", "All",
 StyleMenuListing->None],
Cell[18676, 650, 112, 4, 70, 22, 0, "StyleData", "TBI", "All",
 StyleMenuListing->None],
Cell[18791, 656, 227, 6, 70, 21, 0, "StyleData", "MR", "All",
 StyleMenuListing->None],
Cell[19021, 664, 228, 6, 70, 21, 0, "StyleData", "MO", "All",
 StyleMenuListing->None],
Cell[19252, 672, 226, 6, 70, 21, 0, "StyleData", "MB", "All",
 StyleMenuListing->None],
Cell[19481, 680, 228, 6, 70, 22, 0, "StyleData", "MBO", "All",
 StyleMenuListing->None],
Cell[19712, 688, 115, 4, 70, 21, 0, "StyleData", "SR", "All",
 StyleMenuListing->None],
Cell[19830, 694, 116, 4, 70, 21, 0, "StyleData", "SO", "All",
 StyleMenuListing->None],
Cell[19949, 700, 114, 4, 70, 21, 0, "StyleData", "SB", "All",
 StyleMenuListing->None],
Cell[20066, 706, 116, 4, 70, 22, 0, "StyleData", "SBO", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[20207, 714, 133, 5, 70, 23, 0, "StyleData", "SO10", "All",
 StyleMenuListing->None],
Cell[20343, 721, 144, 5, 70, 35, 0, "StyleData", "SO10", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[20524, 731, 132, 3, 70, 24, 0, "StyleData", "Inert", "All",
 StyleMenuListing->None],
Cell[20659, 736, 88, 2, 70, 36, 0, "StyleData", "Inert", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[20762, 741, 63, 2, 70, 24, 0, "StyleData", "Small", "All",
 StyleMenuListing->None],
Cell[20828, 745, 65, 2, 70, 25, 0, "StyleData", "Medium", "All",
 StyleMenuListing->None],
Cell[20896, 749, 64, 2, 70, 24, 0, "StyleData", "Large", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[20997, 756, 32, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[21054, 760, 241, 6, 70, 25, 0, "StyleData", "Author", "All",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[21298, 768, 91, 2, 70, 41, 0, "StyleData", "Author", "Presentation"],
Cell[21392, 772, 94, 2, 70, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[21523, 779, 264, 7, 70, 26, 0, "StyleData", "Address", "All",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[21790, 788, 92, 2, 70, 42, 0, "StyleData", "Address", "Presentation"],
Cell[21885, 792, 94, 2, 70, 38, 0, "StyleData", "Address", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[22016, 799, 92, 2, 70, 27, 0, "StyleData", "Abstract", "All"],
Cell[22111, 803, 93, 2, 70, 43, 0, "StyleData", "Abstract", "Presentation"],
Cell[22207, 807, 117, 3, 70, 39, 0, "StyleData", "Abstract", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[22361, 815, 107, 3, 70, 28, 0, "StyleData", "Reference", "All"],
Cell[22471, 820, 93, 2, 70, 44, 0, "StyleData", "Reference", "Presentation"],
Cell[22567, 824, 116, 3, 70, 40, 0, "StyleData", "Reference", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[22732, 833, 35, 0, 37, "Section"],
Cell[22770, 835, 184, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[22979, 843, 254, 7, 70, 28, 0, "StyleData", "Hyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[23236, 852, 81, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[23332, 857, 104, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[23461, 864, 268, 7, 70, 31, 0, "StyleData", "MainBookLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[23732, 873, 84, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[23853, 880, 288, 8, 70, 29, 0, "StyleData", "AddOnsLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[24144, 890, 82, 2, 70, 41, 0, "StyleData", "AddOnsLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24263, 897, 292, 8, 70, 31, 0, "StyleData", "RefGuideLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[24558, 907, 84, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24679, 914, 280, 7, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[24962, 923, 90, 2, 70, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25089, 930, 262, 7, 70, 28, 0, "StyleData", "DemosLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[25354, 939, 66, 1, 70, 40, 0, "StyleData", "DemosLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25457, 945, 260, 7, 70, 27, 0, "StyleData", "TourLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[25720, 954, 65, 1, 70, 39, 0, "StyleData", "TourLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25822, 960, 284, 7, 70, 39, 0, "StyleData", "OtherInformationLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[26109, 969, 92, 2, 70, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26238, 976, 274, 7, 70, 34, 0, "StyleData", "MasterIndexLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[26515, 985, 72, 1, 70, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26636, 992, 33, 0, 37, "Section"],
Cell[26672, 994, 121, 3, 70, "Text"],
Cell[26796, 999, 216, 5, 70, 24, 0, "StyleData", "Paste", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[27015, 1006, 287, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[27305, 1015, 376, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[27684, 1026, 363, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[28050, 1037, 377, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic]
}, Closed]],
Cell[CellGroupData[{
Cell[28464, 1051, 36, 0, 37, "Section"],
Cell[CellGroupData[{
Cell[28525, 1055, 689, 22, 70, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
 CounterIncrements->"SlideShowNavigationBar",
 StyleMenuListing->None],
Cell[29217, 1079, 57, 0, 70, 57, 0, "StyleData", "SlideShowNavigationBar", \
"Presentation"],
Cell[29277, 1081, 194, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[29474, 1088, 123, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[29634, 1096, 1432, 36, 70, 35, 0, "StyleData", "SlideShowSection", "All",
 
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 StyleMenuListing->None],
Cell[31069, 1134, 107, 2, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[31179, 1138, 96, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[31278, 1142, 119, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[31434, 1150, 315, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[31752, 1162, 100, 2, 70, 49, 0, "StyleData", "SlideHyperlink", \
"Presentation"],
Cell[31855, 1166, 61, 1, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[31919, 1169, 125, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[32081, 1177, 219, 7, 70, 31, 0, "StyleData", "PreviousNext", "All",
 CounterIncrements->"PreviousNext"],
Cell[32303, 1186, 120, 3, 70, 47, 0, "StyleData", "PreviousNext", \
"Presentation"],
Cell[32426, 1191, 95, 2, 70, 44, 0, "StyleData", "PreviousNext", \
"SlideShow"],
Cell[32524, 1195, 135, 4, 70, 43, 0, "StyleData", "PreviousNext", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[32696, 1204, 313, 9, 70, 40, 0, "StyleData", "SlidePreviousNextLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[33012, 1215, 56, 0, 70, 56, 0, "StyleData", "SlidePreviousNextLink", \
"Presentation"],
Cell[33071, 1217, 53, 0, 70, 53, 0, "StyleData", "SlidePreviousNextLink", \
"SlideShow"],
Cell[33127, 1219, 52, 0, 70, 52, 0, "StyleData", "SlidePreviousNextLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[33216, 1224, 330, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[33549, 1235, 98, 2, 70, 47, 0, "StyleData", "SlideTOCLink", \
"Presentation"],
Cell[33650, 1239, 59, 1, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[33712, 1242, 108, 2, 70, 43, 0, "StyleData", "SlideTOCLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[33857, 1249, 162, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
 StyleMenuListing->None],
Cell[34022, 1255, 94, 2, 70, 43, 0, "StyleData", "SlideTOC", "Presentation"],
Cell[34119, 1259, 55, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[34177, 1262, 80, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34306, 1270, 49, 0, 37, "Section"],
Cell[34358, 1272, 225, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[34608, 1280, 420, 10, 70, 35, 0, "StyleData", "NumberedEquation", "All",
 CounterIncrements->"NumberedEquation"],
Cell[35031, 1292, 101, 2, 70, 51, 0, "StyleData", "NumberedEquation", \
"Presentation"],
Cell[35135, 1296, 97, 2, 70, 47, 0, "StyleData", "NumberedEquation", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35269, 1303, 312, 8, 70, 33, 0, "StyleData", "NumberedFigure", "All",
 CounterIncrements->"NumberedFigure"],
Cell[35584, 1313, 99, 2, 70, 49, 0, "StyleData", "NumberedFigure", \
"Presentation"],
Cell[35686, 1317, 60, 1, 70, 45, 0, "StyleData", "NumberedFigure", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35783, 1323, 300, 8, 70, 32, 0, "StyleData", "NumberedTable", "All",
 CounterIncrements->"NumberedTable"],
Cell[36086, 1333, 98, 2, 70, 48, 0, "StyleData", "NumberedTable", \
"Presentation"],
Cell[36187, 1337, 116, 2, 70, 44, 0, "StyleData", "NumberedTable", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[36352, 1345, 43, 0, 23, "Section"],
Cell[CellGroupData[{
Cell[36420, 1349, 388, 9, 70, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[36811, 1360, 99, 2, 70, 49, 0, "StyleData", "DisplayFormula", \
"Presentation"],
Cell[36913, 1364, 60, 1, 70, 45, 0, "StyleData", "DisplayFormula", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[37010, 1370, 388, 10, 70, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[37401, 1382, 100, 2, 70, 50, 0, "StyleData", "ChemicalFormula", \
"Presentation"],
Cell[37504, 1386, 61, 1, 70, 46, 0, "StyleData", "ChemicalFormula", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[37602, 1392, 143, 4, 70, 26, 0, "StyleData", "Program", "All"],
Cell[37748, 1398, 92, 2, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[37843, 1402, 96, 2, 70, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
