(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    206807,       6741]
NotebookOptionsPosition[    131192,       4956]
NotebookOutlinePosition[    131638,       4974]
CellTagsIndexPosition[    131595,       4971]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[StyleData[StyleDefinitions -> "PublicationDefault.nb"]],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style. 
Make modifications to any definition using commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
 ReturnCreatesNewCell->True,
 DefaultNewCellStyle->"Title"],

Cell["\"AllowsIndexedHeadersFooters\"->False", "MiscSettings"],

Cell["\"LaTeXCompatibilityWarning\"->True", "MiscSettings"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Styles for Publication\[Hyphen]ready Documents\
\>", "Section"],

Cell[CellGroupData[{

Cell["Frontmatter", "Subsection"],

Cell[CellGroupData[{

Cell["Author", "Subsubsection"],

Cell[StyleData["Author"],
 CellMargins->{{36, 144}, {0, 24}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\author{", "}"}},
 DefaultNewCellStyle->"Section",
 DefaultReturnCreatedCellStyle->"Institution",
 MenuPosition->2000,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell["Table of Contents", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell["Book", "Subsubsubsection"],

Cell[CellGroupData[{

Cell["Title Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookHeading"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"\n\n\\tableofcontents", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 LineSpacing->{1, 2},
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookHeading", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 TextAlignment->Center],

Cell[StyleData["TOCHeading", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21],

Cell[StyleData["TOCBookHeading", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontSize->21],

Cell[StyleData["TOCBookHeading", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustrations"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"\n\n\\listoffigures", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookIllustrations", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 TextAlignment->Center],

Cell[StyleData["TOCIllustrations", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21],

Cell[StyleData["TOCBookIllustrations", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontSize->21],

Cell[StyleData["TOCBookIllustrations", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 PageBreakAbove->True,
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTables"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"\n\n\\listoftables", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookTables", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 TextAlignment->Center],

Cell[StyleData["TOCBookTables", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21],

Cell[StyleData["TOCBookTables", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontSize->21],

Cell[StyleData["TOCBookTables", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Contents Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFrontmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCBookFrontmatterHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookFrontmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookFrontmatterHeading", "Centered"]],

Cell[StyleData["TOCBookFrontmatterHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookFrontmatterHeading", "CenteredPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookFrontmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookBackmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCBookBackmatterHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookBackmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookBackmatterHeading", "Centered"]],

Cell[StyleData["TOCBookBackmatterHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookBackmatterHeading", "CenteredPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookBackmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFrontBackHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {"<p class=\"TOCBookFrontBackHeading\">", "</p>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookFrontBackHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookFrontBackHeading", "Centered"]],

Cell[StyleData["TOCBookFrontBackHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookFrontBackHeading", "CenteredPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookFrontBackHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPartTitle"],
 CellMargins->{{36, 12}, {1, 12}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookPartTitle'><span \
class='Ignore'>Part `1` &nbsp;</span>", "TOCBookPartTitle"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Part ", 
       CounterBox["TOCBookPartTitle"]}], "TOCBookPartTitleLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"TOCBookPartTitle",
 CounterAssignments->{{"TOCBookChapterTitle", 0}},
 FontSize->16,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookPartTitle", "Centered"]],

Cell[StyleData["TOCBookPartTitle", "Printout"],
 CellMargins->{{22, 2}, {0, 10}},
 FontSize->14],

Cell[StyleData["TOCBookPartTitle", "CenteredPrintout"],
 CellMargins->{{22, 2}, {0, 10}},
 FontSize->14],

Cell[StyleData["TOCBookPartTitle", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 10}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookChapterTitle"],
 CellMargins->{{12, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookChapterTitle'><span \
class='Ignore'>`1` &nbsp;</span>", "TOCBookChapterTitle"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"]}], "TOCBookChapterTitleLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->54,
 CounterIncrements->"TOCBookChapterTitle",
 CounterAssignments->{{"TOCBookSection", 0}},
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookChapterTitle", "Centered"]],

Cell[StyleData["TOCBookChapterTitle", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookChapterTitle", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46,
 FontSize->12],

Cell[StyleData["TOCBookChapterTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSection"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookSection'><span \
class='Ignore'>`1`.`2` &nbsp;</span>", "TOCBookChapterTitle", 
      "TOCBookSection"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"], ".", 
       CounterBox["TOCBookSection"]}], "TOCBookSectionLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->49.87,
 CounterIncrements->"TOCBookSection",
 CounterAssignments->{{"TOCBookSubsection", 0}}],

Cell[StyleData["TOCBookSection", "Centered"]],

Cell[StyleData["TOCBookSection", "Printout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->41.8,
 FontSize->10],

Cell[StyleData["TOCBookSection", "CenteredPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->41.8,
 FontSize->10],

Cell[StyleData["TOCBookSection", "DoubleSpacedPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->41.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSubsection"],
 CellMargins->{{60, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 60},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookSubsection'><span \
class='Ignore'>`1`.`2`.`3` &nbsp;</span>", "TOCBookChapterTitle", 
      "TOCBookSection", "TOCBookSubsection"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"], ".", 
       CounterBox["TOCBookSection"], ".", 
       CounterBox["TOCBookSubsection"]}], "TOCBookSubsectionLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->45.8,
 CounterIncrements->"TOCBookSubsection"],

Cell[StyleData["TOCBookSubsection", "Centered"]],

Cell[StyleData["TOCBookSubsection", "Printout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->36.7,
 FontSize->10],

Cell[StyleData["TOCBookSubsection", "CenteredPrintout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->36.7,
 FontSize->10],

Cell[StyleData["TOCBookSubsection", "DoubleSpacedPrintout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->36.7,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFigure"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookFigure'><span \
class='Ignore'>Fig. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookFigure"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Fig. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookFigure"], "."}], "TOCBookFigureLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookFigure"],

Cell[StyleData["TOCBookFigure", "Centered"]],

Cell[StyleData["TOCBookFigure", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookFigure", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookFigure", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSupplemental"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookSupplemental'><span \
class='Ignore'>Supp. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookSupplemental"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Supp. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookSupplemental"], "."}], "TOCBookSupplementalLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookSupplemental"],

Cell[StyleData["TOCBookSupplemental", "Centered"]],

Cell[StyleData["TOCBookSupplemental", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookSupplemental", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookSupplemental", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPicture"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookPicture'><span \
class='Ignore'>Pict. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookPicture"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Pict. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookPicture"], "."}], "TOCBookPictureLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookPicture"],

Cell[StyleData["TOCBookPicture", "Centered"]],

Cell[StyleData["TOCBookPicture", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookPicture", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookPicture", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustration"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookIllustration'><span \
class='Ignore'>Illus. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookIllustration"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Illus. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookIllustration"], "."}], "TOCBookIllustrationLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookIllustration"],

Cell[StyleData["TOCBookIllustration", "Centered"]],

Cell[StyleData["TOCBookIllustration", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookIllustration", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookIllustration", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookProgram"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookProgram'><span \
class='Ignore'>Pgm. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookProgram"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Pgm. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookProgram"], "."}], "TOCBookProgramLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookProgram"],

Cell[StyleData["TOCBookProgram", "Centered"]],

Cell[StyleData["TOCBookProgram", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookProgram", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookProgram", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTable"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookTable'><span \
class='Ignore'>Table `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookTable"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Table ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookTable"], "."}], "TOCBookTableLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookTable"],

Cell[StyleData["TOCBookTable", "Centered"]],

Cell[StyleData["TOCBookTable", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookTable", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookTable", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Labels and misc", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSpacer"],
 CellMargins->{{12, 12}, {0, 0}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["TOCBookSpacer", "Centered"],
 CellMargins->{{12, 12}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "Printout"],
 CellMargins->{{2, 2}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPartTitleLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{42, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "Centered"]],

Cell[StyleData["TOCBookPartTitleLabel", "Printout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "CenteredPrintout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookChapterTitleLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{18, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookChapterTitleLabel", "Centered"]],

Cell[StyleData["TOCBookChapterTitleLabel", "Printout"],
 CellSize->{14, Inherited}],

Cell[StyleData["TOCBookChapterTitleLabel", "CenteredPrintout"],
 CellSize->{14, Inherited}],

Cell[StyleData["TOCBookChapterTitleLabel", "DoubleSpacedPrintout"],
 CellSize->{14, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{32, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSectionLabel", "Centered"]],

Cell[StyleData["TOCBookSectionLabel", "Printout"],
 CellSize->{24, Inherited}],

Cell[StyleData["TOCBookSectionLabel", "CenteredPrintout"],
 CellSize->{24, Inherited}],

Cell[StyleData["TOCBookSectionLabel", "DoubleSpacedPrintout"],
 CellSize->{24, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSubsectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{44, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSubsectionLabel", "Centered"]],

Cell[StyleData["TOCBookSubsectionLabel", "Printout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookSubsectionLabel", "CenteredPrintout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookSubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFigureLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookFigureLabel", "Centered"]],

Cell[StyleData["TOCBookFigureLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookFigureLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookFigureLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSupplementalLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSupplementalLabel", "Centered"]],

Cell[StyleData["TOCBookSupplementalLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookSupplementalLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookSupplementalLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPictureLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookPictureLabel", "Centered"]],

Cell[StyleData["TOCBookPictureLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookPictureLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookPictureLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustrationLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookIllustrationLabel", "Centered"]],

Cell[StyleData["TOCBookIllustrationLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookIllustrationLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookIllustrationLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookProgramLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookProgramLabel", "Centered"]],

Cell[StyleData["TOCBookProgramLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookProgramLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookProgramLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTableLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookTableLabel", "Centered"]],

Cell[StyleData["TOCBookTableLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookTableLabel", "CenteredPrintout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookTableLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookLeader"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 TabFilling->". ",
 FontSize->12,
 FontWeight->"Plain"],

Cell[StyleData["TOCBookLeader", "Centered"]],

Cell[StyleData["TOCBookLeader", "Printout"],
 FontSize->10],

Cell[StyleData["TOCBookLeader", "CenteredPrintout"],
 FontSize->10],

Cell[StyleData["TOCBookLeader", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPageNumber"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {
    "</p></td><td class=\"TOCPage\"><p class=\"TOCBookPageNumber\">", 
     "</p>"}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TOCBookPageNumber", "Centered"]],

Cell[StyleData["TOCBookPageNumber", "Printout"],
 CellSize->{21, Inherited}],

Cell[StyleData["TOCBookPageNumber", "CenteredPrintout"],
 CellSize->{21, Inherited}],

Cell[StyleData["TOCBookPageNumber", "DoubleSpacedPrintout"],
 CellSize->{21, Inherited}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mainmatter", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellMargins->{{36, 12}, {8, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "TeX" -> {"\n\\section{", "}"}, 
   "HTML" -> {"<h3 class=\"Section\">", "</h3>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "Section"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Section"}, "StyleSheetApplicability" -> False},
 PageBreakBelow->False,
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->15,
 FontWeight->"Bold"],

Cell[StyleData["Section", "Centered"],
 CellMargins->{{12, 12}, {8, 24}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["Section", "Printout"],
 CellMargins->{{18, 2}, {6, 21}},
 FontSize->13],

Cell[StyleData["Section", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 21}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->15],

Cell[StyleData["Section", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 21}},
 LineSpacing->{2, 1},
 FontSize->13]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
 CellMargins->{{36, 12}, {8, 20}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{
  "TeX" -> {"\n\\subsection{", "}"}, 
   "HTML" -> {"<h4 class=\"Subsection\">", "</h4>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {
      "BookChapterLabel", ".", "Section", ".", "Subsection"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Section"}, "StyleSheetApplicability" -> False},
 PageBreakBelow->False,
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->13,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Centered"],
 CellMargins->{{12, 12}, {8, 20}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
 CellMargins->{{18, 2}, {6, 18}},
 FontSize->11],

Cell[StyleData["Subsection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 18}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->12],

Cell[StyleData["Subsection", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 18}},
 LineSpacing->{2, 1},
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
 CellMargins->{{36, 12}, {5, 18}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{
  "TeX" -> {"\n\\subsubsection{", "}"}, 
   "HTML" -> {"<h5 class=\"Subsubsection\">", "</h5>"}},
 PageBreakBelow->False,
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"},
 FontFamily->"Helvetica",
 FontSize->11,
 FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Centered"],
 CellMargins->{{12, 12}, {8, 18}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
 CellMargins->{{18, 2}, {4, 16}},
 FontSize->9],

Cell[StyleData["Subsubsection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 16}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->10],

Cell[StyleData["Subsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {4, 16}},
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsubsection"],
 CellMargins->{{36, 12}, {5, 7}},
 CellGroupingRules->{"SectionGrouping", 60},
 ConversionRules:>{
  "TeX" -> {"\n\\subsubsubsection{", "}"}, 
   "HTML" -> {"<h6 class=\"Subsubsubsection\">", "</h6>"}},
 CounterIncrements->{"Subsubsubsection", "SubsubsubsectionHeader"},
 FontFamily->"Helvetica",
 FontSize->11,
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["Subsubsubsection", "Centered"],
 CellMargins->{{12, 12}, {7, 7}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["Subsubsubsection", "Printout"],
 CellMargins->{{18, 2}, {4, 6}},
 FontSize->9],

Cell[StyleData["Subsubsubsection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->10],

Cell[StyleData["Subsubsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {4, 6}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Section Heading Inline Cells", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SectionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 TextAlignment->Left],

Cell[StyleData["SectionLabel", "Centered"]],

Cell[StyleData["SectionLabel", "Printout"]],

Cell[StyleData["SectionLabel", "CenteredPrintout"]],

Cell[StyleData["SectionLabel", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 TextAlignment->Left],

Cell[StyleData["SubsectionLabel", "Centered"]],

Cell[StyleData["SubsectionLabel", "Printout"]],

Cell[StyleData["SubsectionLabel", "CenteredPrintout"]],

Cell[StyleData["SubsectionLabel", "DoubleSpacedPrintout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Alternate Headings", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SectionAlt"],
 CellMargins->{{36, 12}, {8, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "TeX" -> {"\n\\section*{", "}"}, 
   "HTML" -> {"<h3 class=\"Section\">", "</h3>"}},
 PageBreakBelow->False,
 FontFamily->"Helvetica",
 FontSize->15,
 FontWeight->"Bold"],

Cell[StyleData["SectionAlt", "Centered"],
 CellMargins->{{12, 12}, {8, 24}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->17,
 FontWeight->"Bold"],

Cell[StyleData["SectionAlt", "Printout"],
 CellMargins->{{18, 2}, {6, 21}},
 FontSize->13],

Cell[StyleData["SectionAlt", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 21}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->15],

Cell[StyleData["SectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 21}},
 LineSpacing->{2, 1},
 FontSize->13]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionAlt"],
 CellMargins->{{36, 12}, {8, 20}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{
  "TeX" -> {"\n\\subsection*{", "}"}, 
   "HTML" -> {"<h4 class=\"Subsection\">", "</h4>"}},
 PageBreakBelow->False,
 FontFamily->"Helvetica",
 FontSize->13,
 FontWeight->"Bold"],

Cell[StyleData["SubsectionAlt", "Centered"],
 CellMargins->{{12, 12}, {8, 20}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["SubsectionAlt", "Printout"],
 CellMargins->{{18, 2}, {6, 18}},
 FontSize->11],

Cell[StyleData["SubsectionAlt", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 18}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->12],

Cell[StyleData["SubsectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 18}},
 LineSpacing->{2, 1},
 FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Body Text", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{12, 10}, {1, 1}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextJustification->1,
 Hyphenation->True,
 ParagraphIndent->24,
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["Text", "Centered"]],

Cell[StyleData["Text", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->16,
 FontSize->10],

Cell[StyleData["Text", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->10,
 FontSize->10],

Cell[StyleData["Text", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 LineSpacing->{2, 1},
 ParagraphIndent->16,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextNoIndent"],
 CellMargins->{{12, 10}, {1, 1}},
 ConversionRules:>{"TeX" -> {"\\noindent ", "\n"}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextJustification->1,
 Hyphenation->True,
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["TextNoIndent", "Centered"]],

Cell[StyleData["TextNoIndent", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 FontSize->10],

Cell[StyleData["TextNoIndent", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 FontSize->10],

Cell[StyleData["TextNoIndent", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextContinuation"],
 CellMargins->{{12, 10}, {1, 1}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n", Automatic, ""}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextAlignment->Left,
 TextJustification->1,
 Hyphenation->True,
 CounterIncrements->"TextContinuation",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["TextContinuation", "Centered"]],

Cell[StyleData["TextContinuation", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 FontSize->10],

Cell[StyleData["TextContinuation", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 FontSize->10],

Cell[StyleData["TextContinuation", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Itemized Lists", "Subsection"],

Cell[CellGroupData[{

Cell["Bulleted Lists", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1"],
 CellMargins->{{36, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 30}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item1Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item1",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],

Cell[StyleData["Item1", "Centered"]],

Cell[StyleData["Item1", "Printout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1", "CenteredPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2"],
 CellMargins->{{60, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 40}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item2Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item2",
 CounterAssignments->{{"Item3Numbered", 0}}],

Cell[StyleData["Item2", "Centered"]],

Cell[StyleData["Item2", "Printout"],
 CellMargins->{{36, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2", "CenteredPrintout"],
 CellMargins->{{36, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2", "DoubleSpacedPrintout"],
 CellMargins->{{36, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3"],
 CellMargins->{{84, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 50}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item3Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item3"],

Cell[StyleData["Item3", "Centered"]],

Cell[StyleData["Item3", "Printout"],
 CellMargins->{{56, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3", "CenteredPrintout"],
 CellMargins->{{56, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3", "DoubleSpacedPrintout"],
 CellMargins->{{56, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1Label"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain"],

Cell[StyleData["Item1Label", "Centered"]],

Cell[StyleData["Item1Label", "Printout"],
 CellSize->{18, Inherited},
 FontSize->10],

Cell[StyleData["Item1Label", "CenteredPrintout"],
 CellSize->{18, Inherited},
 FontSize->10],

Cell[StyleData["Item1Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Label"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain"],

Cell[StyleData["Item2Label", "Centered"]],

Cell[StyleData["Item2Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2Label", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Label"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain"],

Cell[StyleData["Item3Label", "Centered"]],

Cell[StyleData["Item3Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3Label", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Lists", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Numbered"],
 CellMargins->{{36, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 30}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item1Numbered"], "."}], "Item1NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],

Cell[StyleData["Item1Numbered", "Centered"]],

Cell[StyleData["Item1Numbered", "Printout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Numbered", "CenteredPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Numbered"],
 CellMargins->{{60, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 40}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{"(", 
       CounterBox["Item2Numbered"], ")"}], "Item2NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item2Numbered",
 CounterAssignments->{{"Item3Numbered", 0}},
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Item2Numbered", "Centered"]],

Cell[StyleData["Item2Numbered", "Printout"],
 CellMargins->{{36, 2}, {1, 2}},
 FontSize->10],

Cell[StyleData["Item2Numbered", "CenteredPrintout"],
 CellMargins->{{36, 2}, {1, 2}},
 FontSize->10],

Cell[StyleData["Item2Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{36, 2}, {1, 2}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Numbered"],
 CellMargins->{{84, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 50}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item3Numbered"], "."}], "Item3NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item3Numbered",
 CounterBoxOptions->{CounterFunction:>RomanNumeral}],

Cell[StyleData["Item3Numbered", "Centered"]],

Cell[StyleData["Item3Numbered", "Printout"],
 CellMargins->{{56, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Numbered", "CenteredPrintout"],
 CellMargins->{{56, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{56, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item1NumberedLabel", "Centered"]],

Cell[StyleData["Item1NumberedLabel", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item1NumberedLabel", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item1NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item2NumberedLabel", "Centered"]],

Cell[StyleData["Item2NumberedLabel", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2NumberedLabel", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item3NumberedLabel", "Centered"]],

Cell[StyleData["Item3NumberedLabel", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3NumberedLabel", "CenteredPrintout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["List Paragraphs", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Paragraph"],
 CellMargins->{{64, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}}],

Cell[StyleData["Item1Paragraph", "Centered"]],

Cell[StyleData["Item1Paragraph", "Printout"],
 CellMargins->{{40, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Paragraph", "CenteredPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Paragraph"],
 CellMargins->{{88, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}}],

Cell[StyleData["Item2Paragraph", "Centered"]],

Cell[StyleData["Item2Paragraph", "Printout"],
 CellMargins->{{58, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2Paragraph", "CenteredPrintout"],
 CellMargins->{{58, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{58, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Paragraph"],
 CellMargins->{{112, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}}],

Cell[StyleData["Item3Paragraph", "Centered"]],

Cell[StyleData["Item3Paragraph", "Printout"],
 CellMargins->{{78, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Paragraph", "CenteredPrintout"],
 CellMargins->{{78, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{78, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Illustrations and Examples", "Subsection"],

Cell[CellGroupData[{

Cell["Figure", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Figure"],
 Editable->False,
 CellMargins->{{36, 12}, {7, 7}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\begin{center}", 
     $CellContext`ExtractFigure[], "\n\\end{center}"}},
 TaggingRules:>{
  "CounterSettings" -> {"CounterTarget" -> "Style:FigureCaption"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakWithin->False,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 LanguageCategory->None,
 CounterIncrements->"Figure",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 FontFamily->"Courier",
 FontSize->10],

Cell[StyleData["Figure", "Centered"],
 TextAlignment->Center],

Cell[StyleData["Figure", "Printout"],
 CellMargins->{{23, 2}, {6, 6}},
 Magnification->0.8],

Cell[StyleData["Figure", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 Magnification->0.8],

Cell[StyleData["Figure", "DoubleSpacedPrintout"],
 CellMargins->{{23, 2}, {6, 6}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FigureCaption"],
 CellMargins->{{36, 12}, {7, 3}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", "}"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "Figure"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Figure"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 TextJustification->1,
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}},
 FontSize->10],

Cell[StyleData["FigureCaption", "Centered"],
 CellMargins->{{54, 54}, {Inherited, Inherited}},
 TextAlignment->Center],

Cell[StyleData["FigureCaption", "Printout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["FigureCaption", "CenteredPrintout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextAlignment->Center,
 TextJustification->1,
 FontSize->9],

Cell[StyleData["FigureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[StyleData["FigureCaptionLabel"],
 Editable->False,
 CellGroupingRules->{"GraphicsGrouping", 0},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Picture", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
 Editable->False,
 CellMargins->{{36, 12}, {7, 7}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\begin{center}", 
     $CellContext`ExtractFigure[], "\n\\end{center}"}},
 TaggingRules:>{
  "CounterSettings" -> {"CounterTarget" -> "Style:PictureCaption"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 LanguageCategory->None,
 CounterIncrements->"Picture",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 FontFamily->"Courier",
 FontSize->10],

Cell[StyleData["Picture", "Centered"],
 TextAlignment->Center],

Cell[StyleData["Picture", "Printout"],
 CellMargins->{{23, 2}, {6, 6}},
 Magnification->0.8],

Cell[StyleData["Picture", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextAlignment->Center,
 Magnification->0.8],

Cell[StyleData["Picture", "DoubleSpacedPrintout"],
 CellMargins->{{23, 2}, {6, 6}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureCaption"],
 CellMargins->{{36, 12}, {7, 3}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", "}"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "Picture"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Picture"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 TextJustification->1,
 CounterIncrements->"PictureCaption",
 CounterAssignments->{{"Nil", 0}},
 FontSize->10],

Cell[StyleData["PictureCaption", "Centered"],
 CellMargins->{{54, 54}, {Inherited, Inherited}},
 TextAlignment->Center],

Cell[StyleData["PictureCaption", "Printout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["PictureCaption", "CenteredPrintout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextAlignment->Center,
 TextJustification->1,
 FontSize->9],

Cell[StyleData["PictureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[StyleData["PictureCaptionLabel"],
 Editable->False,
 CellGroupingRules->{"GraphicsGrouping", 0},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Program/Script", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Program"],
 CellMargins->{{36, 10}, {2, 5}},
 CellGroupingRules->"InputGrouping",
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "Program"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Program"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 CounterIncrements->"Program",
 FontFamily->"Courier"],

Cell[StyleData["Program", "Centered"],
 CellMargins->{{54, 54}, {2, 5}}],

Cell[StyleData["Program", "Printout"],
 CellMargins->{{18, 2}, {1, 4}},
 FontSize->10],

Cell[StyleData["Program", "CenteredPrintout"],
 CellMargins->{{48, 48}, {1, 4}},
 FontSize->10],

Cell[StyleData["Program", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 4}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramCaption"],
 CellMargins->{{36, 10}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\\caption{", "}\n"}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "Program"}, "CounterTarget" -> 
     "CellGroup"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"ProgramCaption",
 CounterAssignments->{{"Nil", 0}},
 FontSize->10],

Cell[StyleData["ProgramCaption", "Centered"],
 CellMargins->{{54, 54}, {Inherited, Inherited}}],

Cell[StyleData["ProgramCaption", "Printout"],
 CellMargins->{{18, 2}, {2, 4}},
 FontSize->9],

Cell[StyleData["ProgramCaption", "CenteredPrintout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["ProgramCaption", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[StyleData["ProgramCaptionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableTitle"],
 PageWidth->WindowWidth,
 CellMargins->{{36, 12}, {1, 7}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", Automatic, "} "}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "table"}}, 
   "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "TableTitle"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Table"}},
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitle",
 CounterAssignments->{{"Nil", 0}},
 FontWeight->"Plain",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitle", "Centered"],
 CellMargins->{{12, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["TableTitle", "Printout"],
 CellMargins->{{18, 2}, {1, 5}},
 FontSize->10],

Cell[StyleData["TableTitle", "CenteredPrintout"],
 CellMargins->{{2, 2}, {1, 5}},
 FontSize->10],

Cell[StyleData["TableTitle", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableTitleLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitleLabel",
 FontWeight->"Bold",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitleLabel", "Centered"]],

Cell[StyleData["TableTitleLabel", "Printout"],
 FontSize->10],

Cell[StyleData["TableTitleLabel", "CenteredPrintout"],
 FontSize->10],

Cell[StyleData["TableTitleLabel", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Table"],
 Editable->False,
 PageWidth->WindowWidth,
 CellMargins->{{36, 12}, {4, 1}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\begin{tabular}\n", Automatic, "\n\\end{tabular}"}, 
   "HTML" -> {{"", Automatic, ""}, {"", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> "table"}}, 
   "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "TableTitle"}, 
     "CounterTarget" -> "CellGroup"}},
 CellHorizontalScrolling->True,
 CounterIncrements->"Table",
 CounterAssignments->{{"TableNote", 0}},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {False, {False}, False}, "ColumnsIndexed" -> {}, "Rows" -> {
     AbsoluteThickness[2], {False}, 
     AbsoluteThickness[0.5]}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.503]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["Table", "Centered"],
 CellMargins->{{12, 12}, {4, 1}}],

Cell[StyleData["Table", "Printout"],
 PageWidth->PaperWidth,
 CellMargins->{{18, 2}, {3, 1}},
 FontSize->10],

Cell[StyleData["Table", "CenteredPrintout"],
 PageWidth->PaperWidth,
 CellMargins->{{2, 2}, {3, 1}},
 FontSize->10],

Cell[StyleData["Table", "DoubleSpacedPrintout"],
 PageWidth->PaperWidth,
 CellMargins->{{18, 2}, {3, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableNote"],
 Editable->False,
 CellMargins->{{36, 12}, {7, -3}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Table"}, "CounterTarget" -> "CellGroup"}},
 LineSpacing->{1, 1},
 ParagraphSpacing->{0.3, 0},
 CounterIncrements->"TableNote",
 FontSize->10,
 FontColor->GrayLevel[0.300008]],

Cell[StyleData["TableNote", "Centered"],
 CellMargins->{{12, 12}, {7, -3}}],

Cell[StyleData["TableNote", "Printout"],
 CellMargins->{{18, 2}, {5, 1}},
 FontSize->9],

Cell[StyleData["TableNote", "Printout"],
 CellMargins->{{2, 2}, {5, -2}},
 FontSize->9],

Cell[StyleData["TableNote", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {5, -2}},
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Table Styles", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableColumnHead"],
 Editable->True,
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 FontSlant->"Italic",
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableColumnHead", "Centered"]],

Cell[StyleData["TableColumnHead", "Printout"],
 FontSize->10],

Cell[StyleData["TableColumnHead", "CenteredPrintout"],
 FontSize->10],

Cell[StyleData["TableColumnHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanHead"],
 Editable->True,
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 TextAlignment->Center,
 FontSlant->"Italic",
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableSpanHead", "Printout"],
 FontSize->10],

Cell[StyleData["TableSpanHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableText"],
 Editable->True,
 TextAlignment->Left,
 LineSpacing->{1, 1},
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableText", "Centered"]],

Cell[StyleData["TableText", "Printout"],
 FontSize->10],

Cell[StyleData["TableText", "CenteredPrintout"],
 FontSize->10],

Cell[StyleData["TableText", "DoubleSpacedPrintout"],
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanText"],
 Editable->True,
 TextAlignment->Center,
 LineSpacing->{1, 1},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableSpanText", "Printout"],
 FontSize->10],

Cell[StyleData["TableSpanText", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[StyleData["TableSubGrid"],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{0.1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.27999999999999997`]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["TableMasterGrid"],
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.004]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableLineElement"],
 Editable->False,
 CellFrame->{{0, 0}, {0.5, 0}},
 CellElementSpacings->{"CellMinHeight"->1},
 ConversionRules:>{"HTML" -> {{"&nbsp;", 
      $CellContext`NoOutput[], ""}, {"", Automatic, ""}}},
 CellSize->{Inherited, 1.25},
 TabFilling->" ",
 TabSpacings->1000,
 FontSize->1],

Cell[StyleData["TableBlankElement"],
 Editable->False,
 CellElementSpacings->{"CellMinHeight"->1},
 CellSize->{Inherited, 1.25},
 FontSize->1],

Cell[CellGroupData[{

Cell[StyleData["SpanLeft"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanLeft", "Printout"],
 FontSize->14],

Cell[StyleData["SpanLeft", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanCenter"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanCenter", "Printout"],
 FontSize->14],

Cell[StyleData["SpanCenter", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanRight"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanRight", "Printout"],
 FontSize->14],

Cell[StyleData["SpanRight", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Caption", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
 CellMargins->{{36, 12}, {7, 3}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\\caption{", "}\n"}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 PageBreakAbove->False,
 TextJustification->1,
 CounterIncrements->"Caption",
 FontSize->10],

Cell[StyleData["Caption", "Centered"],
 CellMargins->{{54, 54}, {Inherited, Inherited}}],

Cell[StyleData["Caption", "Printout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["Caption", "CenteredPrintout"],
 CellMargins->{{48, 48}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["Caption", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {6, 2}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematics", "Subsection"],

Cell[CellGroupData[{

Cell["Equations", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Equation"],
 CellMargins->{{36, 10}, {7, 7}},
 ConversionRules:>{"HTML" -> {{"", ""}, {"<p class=\"Equation\">", "</p>"}}},
 CellHorizontalScrolling->True,
 DefaultFormatType->DefaultInputFormatType,
 InputAutoReplacements->{},
 CounterIncrements->"Equation",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["Equation", "Centered"],
 CellMargins->{{12, 12}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center],

Cell[StyleData["Equation", "Printout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10],

Cell[StyleData["Equation", "CenteredPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["Equation", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroup"],
 CellMargins->{{36, 10}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 1, "Numbered" -> False}, 
     "TeX" -> {"CellGroupEnvironment" -> "gather*"}}},
 DefaultFormatType->DefaultInputFormatType,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroup", "Centered"],
 CellMargins->{{12, 6}, {0, 2}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center],

Cell[StyleData["EquationGroup", "Printout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroup", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroup", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAligned"],
 CellMargins->{{36, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 1, "Numbered" -> False}, 
     "TeX" -> {"CellGroupEnvironment" -> "align*"}}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 SpanMinSize->2,
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAligned", "Centered"],
 CellMargins->{{12, 6}, {0, 2}},
 TextAlignment->Center],

Cell[StyleData["EquationGroupAligned", "Printout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupAligned", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupAligned", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Equations", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["EquationNumbered"],
 CellMargins->{{36, 12}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationNumbered'><tr><td>", Automatic, 
      $CellContext`IncludeCount[
      "</td><td class='EquationNumberedLabel'>(`1`.`2`)</td></tr></table>", 
       "BookChapterLabel", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}},
 CellHorizontalScrolling->True,
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 InputAutoReplacements->{},
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationNumbered", "Centered"],
 CellMargins->{{12, 12}, {7, 7}},
 TextAlignment->Center],

Cell[StyleData["EquationNumbered", "Printout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10],

Cell[StyleData["EquationNumbered", "CenteredPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupNumbered"],
 CellMargins->{{36, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationGroupNumbered'><tr><td>", Automatic, 
      $CellContext`IncludeCount[
      "</td><td \
class='EquationGroupNumberedLabel'>(`1`.`2`)</td></tr></table>", 
       "BookChapterLabel", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {
    "General" -> {"Numbered" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "gather"}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroupNumbered", "Centered"],
 CellMargins->{{12, 6}, {0, 2}},
 TextAlignment->Center],

Cell[StyleData["EquationGroupNumbered", "Printout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupNumbered", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAlignedNumbered"],
 CellMargins->{{36, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationGroupAlignedNumbered'><tr><td>", Automatic, 
      $CellContext`IncludeCount[
      "</td><td \
class='EquationGroupAlignedNumberedLabel'>(`1`)</td></tr></table>", 
       "BookChapterLabel", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {
    "General" -> {"Numbered" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "align"}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 SpanMinSize->2,
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAlignedNumbered", "Centered"],
 CellMargins->{{12, 6}, {0, 2}},
 TextAlignment->Center],

Cell[StyleData["EquationGroupAlignedNumbered", "Printout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupAlignedNumbered", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["EquationGroupAlignedNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right],

Cell[StyleData["EquationNumber", "Centered"],
 CellSize->{36, Inherited}],

Cell[StyleData["EquationNumber", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EquationNumber", "CenteredPrintout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EquationNumber", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equation Grid Tag Styles", "Subsubsection"],

Cell[StyleData["EquationGrid"]],

Cell[StyleData["SplitEquation"]],

Cell[StyleData["Piecewise"]],

Cell[StyleData["Matrix"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cross-References", "Subsection"],

Cell[StyleData["XRef"],
 ConversionRules:>{"TeX" -> {"\\ref{", 
     $CellContext`ExtractButtonData["CounterTag"], "}"}, 
   "HTML" -> {"", $CellContext`XRefToHtmlHyperlink, ""}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Backmatter", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["BackmatterGroup"],
 Editable->False,
 CellMargins->{{12, 10}, {7, 24}},
 CellGroupingRules->{"SectionGrouping", 5},
 ConversionRules:>{{"TeX" -> {"\n\n\\appendix", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["BackmatterGroup", "Centered"]],

Cell[StyleData["BackmatterGroup", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["BackmatterGroup", "CenteredPrintout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["BackmatterGroup", "DoubleSpacedPrintout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["AppendixSectionLabel"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{12, 12}, {3, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->4,
 LineSpacing->{1, 2},
 CounterIncrements->"AppendixSectionLabel",
 CounterAssignments->{{"Section", 0}, {"AppendixEquation", 0}, {
   "FigureCaption", 0}, {"TableTitle", 0}},
 FontFamily->"Helvetica",
 FontSize->13,
 FontWeight->"Plain",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["AppendixSectionLabel", "Centered"],
 CellMargins->{{12, 12}, {3, 72}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->13,
 FontWeight->"Plain"],

Cell[StyleData["AppendixSectionLabel", "Printout"],
 CellMargins->{{2, 2}, {2, 60}},
 FontSize->11],

Cell[StyleData["AppendixSectionLabel", "CenteredPrintout"],
 CellMargins->{{2, 2}, {2, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->11],

Cell[StyleData["AppendixSectionLabel", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 60}},
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixSectionNumber"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 FontFamily->"Helvetica",
 FontSize->19,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSectionNumber", "Centered"],
 FontFamily->"Times",
 FontSize->21,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSectionNumber", "Printout"],
 FontSize->17],

Cell[StyleData["AppendixSectionNumber", "CenteredPrintout"],
 FontFamily->"Times",
 FontSize->17],

Cell[StyleData["AppendixSectionNumber", "DoubleSpacedPrintout"],
 FontSize->17]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixSection"],
 CellMargins->{{12, 12}, {98, 12}},
 ConversionRules:>{{"TeX" -> {"\n\\chapter{", "}"}}, {
   "HTML" -> {"<p class=\"AppendixSection\">", "</p>"}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"AppendixSection"}, "XRefPrefix" -> "Appendix", 
     "CounterTarget" -> "CellGroup"}},
 PageBreakAbove->False,
 PageBreakBelow->False,
 LineSpacing->{1, 2},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["AppendixSection", "Centered"],
 CellMargins->{{54, 54}, {98, 12}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSection", "Printout"],
 CellMargins->{{2, 2}, {78, 10}},
 LineSpacing->{1, 2},
 FontSize->21],

Cell[StyleData["AppendixSection", "CenteredPrintout"],
 CellMargins->{{48, 48}, {78, 10}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["AppendixSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 10}},
 LineSpacing->{1, 2},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Appendix"],
 CellMargins->{{12, 10}, {1, 1}},
 InputAutoReplacements->{"-" -> "\[Hyphen]", Inherited},
 TextJustification->1,
 Hyphenation->True,
 ParagraphIndent->24,
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["Appendix", "Centered"]],

Cell[StyleData["Appendix", "Printout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->16,
 FontSize->10],

Cell[StyleData["Appendix", "CenteredPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 ParagraphIndent->10,
 FontSize->10],

Cell[StyleData["Appendix", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}},
 LineSpacing->{2, 1},
 ParagraphIndent->16,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixEquation"],
 CellMargins->{{36, 12}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='AppendixEquation'><tr><td>", Automatic, 
      $CellContext`IncludeCount[
      "</td><td class='AppendixEquationLabel'>(`1`.`2`)</td></tr></table>", 
       "AppendixSection", "AppendixEquation"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"AppendixSection", ".", "AppendixEquation"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["AppendixSection"], ".", 
       CounterBox["AppendixEquation"], ")"}]]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 CounterIncrements->"AppendixEquation"],

Cell[StyleData["AppendixEquation", "Centered"],
 CellMargins->{{12, 12}, {7, 7}},
 TextAlignment->Center],

Cell[StyleData["AppendixEquation", "Printout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10],

Cell[StyleData["AppendixEquation", "CenteredPrintout"],
 CellMargins->{{2, 2}, {Inherited, Inherited}},
 TextAlignment->Center,
 FontSize->10],

Cell[StyleData["AppendixEquation", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {5, 5}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Endnotes", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["EndnoteSection"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {
   "HTML" -> {"<p class=\"EndnoteSection\">", "</p>"}}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], "\n"}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21],

Cell[StyleData["EndnoteSection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["EndnoteSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Endnote"],
 CellMargins->{{12, 10}, {2, 2}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"Endnote\"><tr valign=\"top\">", "</td></tr></table>"}},
 Hyphenation->True,
 LineSpacing->{1, 2},
 ParagraphIndent->-38,
 CounterIncrements->"Endnote"],

Cell[StyleData["Endnote", "Centered"]],

Cell[StyleData["Endnote", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 FontSize->10],

Cell[StyleData["Endnote", "CenteredPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 FontSize->10],

Cell[StyleData["Endnote", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteLabel"],
 ConversionRules:>{"HTML" -> {"<td class=\"EndnoteLabel\" align=\"right\">", 
     $CellContext`ConvertTextSubOrSuperscriptToHTML["sup"], 
     "&nbsp;</td><td>"}},
 CellSize->{36, Inherited},
 TextAlignment->Right,
 SpanMaxSize->1,
 CounterIncrements->"EndnoteLabel"],

Cell[StyleData["EndnoteLabel", "Centered"]],

Cell[StyleData["EndnoteLabel", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EndnoteLabel", "CenteredPrintout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EndnoteLabel", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right,
 CounterIncrements->"EndnoteNumber"],

Cell[StyleData["EndnoteNumber", "Centered"]],

Cell[StyleData["EndnoteNumber", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EndnoteNumber", "CenteredPrintout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EndnoteNumber", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NoteKey"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`EditNote[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["NoteKey", "Centered"]],

Cell[StyleData["NoteKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["NoteKey", "CenteredPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["NoteKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteReturnLink"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["EndnoteReturnLink", "Centered"]],

Cell[StyleData["EndnoteReturnLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]],

Cell[StyleData["EndnoteReturnLink", "CenteredPrintout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]],

Cell[StyleData["EndnoteReturnLink", "DoubleSpacedPrintout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[StyleData["Note"],
 Editable->False,
 Deletable->False,
 ConversionRules:>{"TeX" -> {{"\\footnote{", Convert[
       ExtractButtonData[1][#]]& , "}"}, {"", Automatic, ""}}, 
   "HTML" -> {"", 
     ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SpanMaxSize->1,
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[CellGroupData[{

Cell[StyleData["Note"],
 Editable->False,
 Deletable->False,
 ConversionRules:>{"TeX" -> {{"\\footnote{", $CellContext`Convert[
       $CellContext`ExtractButtonData[1][#]]& , "}"}, {"", Automatic, ""}}, 
   "HTML" -> {"", 
     $CellContext`ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SpanMaxSize->1,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Note", "Printout"],
 ScriptMinSize->8],

Cell[StyleData["Note", "DoubleSpacedPrintout"],
 ScriptMinSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSection"],
 CellMargins->{{12, 12}, {98, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{{"TeX" -> {"\\begin{thebibliography}{000}\n\n", 
      $CellContext`NoOutput[], ""}}, {
   "HTML" -> {"<p class=\"ReferenceSection\">", "</p>"}}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CounterIncrements->"ReferenceSection",
 CounterAssignments->{{"ReferenceText", 0}, {"BiblioEquation", 0}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "Centered"],
 CellMargins->{{12, 12}, {98, 72}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "Printout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21],

Cell[StyleData["ReferenceSection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["ReferenceSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 60}},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
 CellMargins->{{18, 10}, {1, 1}},
 ConversionRules:>{{"TeX" -> {"\n\n", 
      $CellContext`ConvertAsNatbib[], ""}}, {
   "HTML" -> {
     "<table class=\"Reference\"><tr valign=\"top\">", 
      "</td></tr></table>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "TeX" -> {
      "NestingLevel" -> 1, 
       "CellGroupEnvironment" -> {"thebibliography", "{000}"}}}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 ParagraphIndent->-8,
 CounterIncrements->"BibliographyItem",
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Reference", "Centered"]],

Cell[StyleData["Reference", "Printout"],
 CellMargins->{{2, 2}, {2, 0}},
 LineSpacing->{1, 2},
 ParagraphIndent->-5,
 FontSize->10],

Cell[StyleData["Reference", "CenteredPrintout"],
 CellMargins->{{2, 2}, {2, 0}},
 LineSpacing->{1, 2},
 ParagraphIndent->-5,
 FontSize->10],

Cell[StyleData["Reference", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 0}},
 LineSpacing->{2, 1},
 ParagraphIndent->-5,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLabel"],
 ConversionRules:>{
  "HTML" -> {
    "<td class=\"ReferenceLabel\" align=\"right\">", "&nbsp;</td><td>"}},
 CellSize->{36, Inherited},
 TextAlignment->Right,
 SpanMaxSize->1,
 CounterIncrements->"RefDingbat"],

Cell[StyleData["ReferenceLabel", "Centered"]],

Cell[StyleData["ReferenceLabel", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["ReferenceLabel", "CenteredPrintout"],
 CellSize->{32, Inherited}],

Cell[StyleData["ReferenceLabel", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]],

Cell[StyleData["RefSep"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}}],

Cell[CellGroupData[{

Cell[StyleData["RefReturnPointer"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {"<td>", 
     $CellContext`NoOutput[], ""}},
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnPointer", "Printout"],
 FontColor->GrayLevel[1]],

Cell[StyleData["RefReturnPointer", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefReturnLink"],
 ConversionRules:>{"TeX" -> {"\n\\bibitem{", 
     $CellContext`ExtractRefLinkData[], "}"}},
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnLink", "Centered"]],

Cell[StyleData["RefReturnLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnLink", "CenteredPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnLink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSourceLink"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontSize->1,
 FontColor->GrayLevel[1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["ReferenceSourceLink", "Centered"]],

Cell[StyleData["ReferenceSourceLink", "Printout"],
 FontColor->GrayLevel[1]],

Cell[StyleData["ReferenceSourceLink", "CenteredPrintout"],
 FontColor->GrayLevel[1]],

Cell[StyleData["ReferenceSourceLink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[StyleData["ReferenceSourceURL"]],

Cell[CellGroupData[{

Cell[StyleData["Citation"],
 ConversionRules:>{"TeX" -> {{"", 
      $CellContext`ExtractCitationData[], ""}, {"", Automatic, ""}}},
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`ListDataLink[#2]& ),
 Evaluator->Automatic}],

Cell[StyleData["Citation", "Centered"]],

Cell[StyleData["Citation", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Citation", "CenteredPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Citation", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefKey"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`EditRef[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["RefKey", "Centered"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(Symbol["EditRef"][#]& ),
 Evaluator->Automatic}],

Cell[StyleData["RefKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefKey", "CenteredPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["References Templates", "Subsubsubsection",
 StyleMenuListing->None],

Cell["FirstAuthor:<Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["OtherAuthors:, <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["LastAuthor:, & <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["FirstEditor:<FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["OtherEditors:, <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["LastEditor: & <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["Sorting:Author", "ReferenceTemplate"],

Cell["ReferenceAuthorMax:4", "ReferenceTemplate"],

Cell["ReferenceEditorMax:4", "ReferenceTemplate"],

Cell["ReferenceAuthorMin:1", "ReferenceTemplate"],

Cell["ReferenceEditorMin:1", "ReferenceTemplate"],

Cell["AbbreviatedAuthors:, et al.", "ReferenceTemplate"],

Cell["AbbreviatedEditors:, et al.", "ReferenceTemplate"],

Cell[CellGroupData[{

Cell["Article Templates", "Subsubsubsubsection"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Article\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["In Book Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"InBook\" references.)\
\>", "Text"],

Cell["\<\
InBook:<Author> (<Year>). <Title>. In <Editor> (Ed.), <BookTitle> (pp. \
<PageRange>). <City>: <Publisher>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Whole Book Templates", "Subsubsubsubsection"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>. Retrieved \
<RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>.\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Book\" references that \
don't match any of the above templates.)\
\>", "Text"],

Cell["WholeBook:<Author> (<Year>). <BookTitle>. <Publisher>.", \
"ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Thesis Templates", "Subsubsubsubsection"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
PhdThesis:<Author> (<Year>). <BookTitle>. Unpublished doctoral dissertation, \
<School>, <City>.\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"PhdThesis\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Technical Report Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"TechReport\" \
references.)\
\>", "Text"],

Cell["\<\
TechReport:<Author> (<Year>). <Title>. <School>, <City>. <ReportNumber>, \
<Submittedby>\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Online Source Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"OnlineSource\" \
references.)\
\>", "Text"],

Cell["\<\
OnlineSource:<Author>, <Title>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Preprint Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"Preprint\" references.)\
\
\>", "Text"],

Cell["Preprint:<Author> (<Year>). <Title>. <PublicationStatus>", \
"ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plain Insertion Template", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \
\[OpenCurlyDoubleQuote]PlainInsert\" references.)\
\>", "Text"],

Cell["PlainInsert:<InsertedBibText>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Note Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"Note\" references.)\
\>", "Text"],

Cell["Note:<NoteText>", "ReferenceTemplate"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefTitle"],
 ConversionRules:>{"TeX" -> {"\\textit{", "}"}},
 FontSlant->"Italic"],

Cell[StyleData["RefType"],
 CellSize->{1, 12}],

Cell[StyleData["RefURL"]],

Cell[StyleData["RefRetrievalDate"]],

Cell[StyleData["RefSourceOfAbstract"]],

Cell[StyleData["RefInsertedBibText"]],

Cell[StyleData["RefNote"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefBookTitle"],
 ConversionRules:>{"TeX" -> {"\\textit{", "}"}},
 FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell["Journal Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefJournalTitle"]],

Cell[StyleData["RefJournalVolume"],
 ConversionRules:>{"TeX" -> {"\\textbf{", "}"}},
 FontWeight->"Bold"],

Cell[StyleData["RefJournalNumber"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Publisher Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefPublisher"]],

Cell[StyleData["RefCity"],
 ParagraphIndent->0]
}, Closed]],

Cell[CellGroupData[{

Cell["Author Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefAuthorGroup"]],

Cell[StyleData["RefAuthorFN"]],

Cell[StyleData["RefAuthorLN"]],

Cell[StyleData["RefAuthorMN"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Editor Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefEditorGroup"]],

Cell[StyleData["RefEditorFN"]],

Cell[StyleData["RefEditorMN"]],

Cell[StyleData["RefEditorLN"]]
}, Closed]],

Cell[CellGroupData[{

Cell["School Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefSchool"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Publication Date Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefDay"]],

Cell[StyleData["RefMonth"]],

Cell[StyleData["RefYear"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Data Field Styles: Auto Generated and Contiguous Pages", \
"Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefFirstPage"],
 ParagraphIndent->0],

Cell[StyleData["RefLastPage"],
 ParagraphIndent->0]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Elements", "Subsection"],

Cell[CellGroupData[{

Cell["Chapter", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["BookChapterLabel"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{12, 12}, {3, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterTarget" -> "Cell", "XRefPrefix" -> "Chapter"}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->4,
 LineSpacing->{1, 2},
 CounterIncrements->"BookChapterLabel",
 CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"EquationNumbered", 0}, {"FigureCaption", 0}, {
   "PictureCaption", 0}, {"ProgramCaption", 0}, {"TableTitle", 0}, {
   "Figure", 0}, {"Picture", 0}, {"Program", 0}, {"Table", 0}},
 FontFamily->"Helvetica",
 FontSize->13,
 FontWeight->"Plain"],

Cell[StyleData["BookChapterLabel", "Centered"],
 CellMargins->{{12, 12}, {3, 72}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->13,
 FontWeight->"Plain"],

Cell[StyleData["BookChapterLabel", "Printout"],
 CellMargins->{{2, 2}, {2, 60}},
 FontSize->11],

Cell[StyleData["BookChapterLabel", "CenteredPrintout"],
 CellMargins->{{2, 2}, {2, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->11],

Cell[StyleData["BookChapterLabel", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 60}},
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookChapterNumber"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 FontFamily->"Helvetica",
 FontSize->19,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterNumber", "Centered"],
 FontFamily->"Times",
 FontSize->21,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterNumber", "Printout"],
 FontSize->17],

Cell[StyleData["BookChapterNumber", "CenteredPrintout"],
 FontFamily->"Times",
 FontSize->17],

Cell[StyleData["BookChapterNumber", "DoubleSpacedPrintout"],
 FontSize->17]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookChapterTitle"],
 CellMargins->{{12, 12}, {98, 12}},
 ConversionRules:>{"TeX" -> {"\\chapter{", "}\n"}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 PageBreakAbove->False,
 PageBreakBelow->False,
 LineSpacing->{1, 2},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["BookChapterTitle", "Centered"],
 CellMargins->{{54, 54}, {98, 12}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterTitle", "Printout"],
 CellMargins->{{2, 2}, {78, 10}},
 LineSpacing->{1, 2},
 FontSize->21],

Cell[StyleData["BookChapterTitle", "CenteredPrintout"],
 CellMargins->{{48, 48}, {78, 10}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->21],

Cell[StyleData["BookChapterTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 10}},
 LineSpacing->{1, 2},
 FontSize->21]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Epigraph", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Epigraph"],
 CellMargins->{{36, 54}, {0, 24}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {"\\epigraph{", "}\n"}},
 TextJustification->1,
 FontSlant->"Italic"],

Cell[StyleData["Epigraph", "Centered"]],

Cell[StyleData["Epigraph", "Printout"],
 CellMargins->{{18, 48}, {0, 21}},
 FontSize->10],

Cell[StyleData["Epigraph", "CenteredPrintout"],
 CellMargins->{{48, 48}, {0, 21}},
 FontSize->10],

Cell[StyleData["Epigraph", "DoubleSpacedPrintout"],
 CellMargins->{{18, 48}, {0, 21}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EpigraphAuthor"],
 CellMargins->{{36, 54}, {24, 12}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {"\\epigraphauthor{", "}\n"}}],

Cell[StyleData["EpigraphAuthor", "Centered"]],

Cell[StyleData["EpigraphAuthor", "Printout"],
 CellMargins->{{18, 48}, {21, 10}},
 FontSize->10],

Cell[StyleData["EpigraphAuthor", "CenteredPrintout"],
 CellMargins->{{48, 48}, {21, 10}},
 FontSize->10],

Cell[StyleData["EpigraphAuthor", "DoubleSpacedPrintout"],
 CellMargins->{{18, 48}, {21, 10}},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Headers and Footers", "Subsection"],

Cell[StyleData["Header"],
 CellMargins->{{0, 0}, {4, 1}},
 FontSize->10,
 FontSlant->"Italic"],

Cell[StyleData["Footer"],
 CellMargins->{{0, 0}, {0, 4}},
 FontSize->9,
 FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
 CellMargins->{{0, 0}, {4, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Miscellaneous", "Subsection"],

Cell[StyleData["TextSuperscript"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`ConvertTextSuperscriptToLaTeX[], ""}, "HTML" -> {"", 
     $CellContext`ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SingleLetterItalics->False],

Cell[StyleData["TextSubscript"],
 ConversionRules:>{"HTML" -> {"", 
     $CellContext`ConvertTextSubOrSuperscriptToHTML["sub"], ""}},
 ScriptMinSize->10,
 SingleLetterItalics->False],

Cell[StyleData["Nil"]],

Cell[StyleData["Verbatim"]],

Cell[StyleData["TeXName"],
 ConversionRules:>{"TeX" -> {"\\TeX\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["LaTeXName"],
 ConversionRules:>{"TeX" -> {"\\LaTeX\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["LaTeXeName"],
 ConversionRules:>{"TeX" -> {"\\LaTeXe\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["ChemicalElement"],
 SingleLetterItalics->False,
 ZeroWidthTimes->True],

Cell[StyleData["CustomCharacter"],
 SingleLetterItalics->False],

Cell[StyleData["Palette"]],

Cell[CellGroupData[{

Cell[StyleData["PageBreak"],
 Editable->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellBracketOptions->{"Color"->RGBColor[0.500008, 0.500008, 1],
 "Margins"->{Inherited, 3},
 "Thickness"->1,
 "Widths"->{5, 5}},
 CellElementSpacings->{"CellMinHeight"->1},
 ConversionRules:>{"TeX" -> {"\n\n\\pagebreak", 
     $CellContext`NoOutput[], ""}, "HTML" -> {"<br class=\"PageBreak\">", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 CellSize->{Inherited, 6},
 TabFilling->"- ",
 TabSpacings->1000,
 FontSize->6,
 FontColor->GrayLevel[0.700008]],

Cell[StyleData["PageBreak", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 CellSize->{Inherited, 2},
 TabFilling->""]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CreationDate"],
 CellFrame->0.5,
 CellMargins->{{10, 10}, {4, 4}},
 TextAlignment->Center,
 FontFamily->"Helvetica",
 FontSize->10],

Cell[StyleData["CreationDate", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 LineSpacing->{1, 1},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell["Lines and Spacers", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SingleLine"],
 CellMargins->{{2, 10}, {1, 1}},
 CellGroupingRules->{"GraphicsGrouping", 0},
 FontSize->2],

Cell[StyleData["SingleLine", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 CellGroupingRules->{"GraphicsGrouping", 0},
 FontSize->2]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DoubleLine"],
 Editable->False,
 PageWidth->400,
 CellFrame->{{0, 0}, {0.25, 0.25}},
 CellMargins->{{12, 10}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->0},
 CellFrameMargins->{{2, 10}, {0, 0}},
 FontSize->4],

Cell[StyleData["DoubleLine", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->2]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ThinLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["ThinLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MediumLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["MediumLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ThickLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["ThickLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Spacer"],
 CellMargins->{{Inherited, Inherited}, {4, 4}}],

Cell[StyleData["Spacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextSpacer"]],

Cell[StyleData["TextSpacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionSpacer"]],

Cell[StyleData["SectionSpacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GraphicsSpacer"]],

Cell[StyleData["GraphicsSpacer", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Vita", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["VitaSection"],
 CellMargins->{{12, 12}, {28, 72}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"\\chapter{", "}\n"}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 LineSpacing->{1, 2},
 ButtonStyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["VitaSection", "Centered"],
 CellMargins->{{12, 12}, {28, 72}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 FontFamily->"Times",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["VitaSection", "Printout"],
 CellMargins->{{2, 2}, {24, 60}},
 FontSize->24],

Cell[StyleData["VitaSection", "CenteredPrintout"],
 CellMargins->{{2, 2}, {24, 60}},
 TextAlignment->Center,
 FontFamily->"Times",
 FontSize->24],

Cell[StyleData["VitaSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {24, 60}},
 FontSize->24]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Outline", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Outline1"],
 CellMargins->{{12, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline1"], ". "}], "Outline1Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}},
 FontSize->18,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["Outline1", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->16],

Cell[StyleData["Outline1", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline1Label"],
 CellSize->{40, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline1Label", "Printout"],
 CellSize->{36, Inherited}],

Cell[StyleData["Outline1Label", "DoubleSpacedPrintout"],
 CellSize->{36, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2"],
 CellMargins->{{32, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 40},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline2"], ". "}], "Outline2Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}},
 FontSize->16,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["Outline2", "Printout"],
 CellMargins->{{22, 2}, {6, 6}},
 FontSize->14],

Cell[StyleData["Outline2", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {6, 6}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2Label"],
 CellSize->{30, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline2Label", "Printout"],
 CellSize->{27, Inherited}],

Cell[StyleData["Outline2Label", "DoubleSpacedPrintout"],
 CellSize->{27, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3"],
 CellMargins->{{52, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline3"], ". "}], "Outline3Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}},
 FontSize->14,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Outline3", "Printout"],
 CellMargins->{{42, 2}, {6, 6}},
 FontSize->12],

Cell[StyleData["Outline3", "DoubleSpacedPrintout"],
 CellMargins->{{42, 2}, {6, 6}},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3Label"],
 CellSize->{21, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline3Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Outline3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4"],
 CellMargins->{{67, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 60},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline4"], ". "}], "Outline4Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline4",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Outline4", "Printout"],
 CellMargins->{{57, 2}, {6, 6}},
 FontSize->10],

Cell[StyleData["Outline4", "DoubleSpacedPrintout"],
 CellMargins->{{57, 2}, {6, 6}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4Label"],
 CellSize->{18, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline4Label", "Printout"],
 CellSize->{16, Inherited}],

Cell[StyleData["Outline4Label", "DoubleSpacedPrintout"],
 CellSize->{16, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OutlineText"],
 CellMargins->{{91, 12}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 CounterIncrements->"Text"],

Cell[StyleData["OutlineText", "Printout"],
 CellMargins->{{79, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["OutlineText", "DoubleSpacedPrintout"],
 CellMargins->{{79, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
 Editable->False,
 CellFrame->True,
 CellMargins->{{0, 0}, {3, 3}},
 CellElementSpacings->{"CellMinHeight"->0.8125},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameMargins->False,
 CellFrameColor->GrayLevel[1],
 CellFrameLabelMargins->False,
 TextAlignment->Center,
 CounterIncrements->"SlideShowNavigationBar",
 CounterAssignments->{{"Item1Numbered", 0}},
 FontSize->10,
 Magnification->1,
 Background->GrayLevel[0.8],
 GridBoxOptions->{BaselinePosition->Center,
 GridBoxAlignment->{
  "Columns" -> {
    Center, Center, Center, Center, Center, Center, Right, {Center}}, 
   "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {3.5, 3.5, 3.5, 3.5, 13, 5, {4}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{1.}}, "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{-1, -1}, {-1, -1}},
 PageBreakAbove->True,
 CellFrameMargins->{{1, 1}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
 ButtonStyleMenuListing->None,
 FontSize->26,
 FontColor->GrayLevel[0.400015],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Printout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["SlideHyperlink", "CenteredPrintout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["SlideHyperlink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Inline", "Subsection"],

Cell[CellGroupData[{

Cell["General Text Attributes", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RM"],
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["BF"],
 ConversionRules:>{"TeX" -> {"\\textbf{", "}"}},
 FontWeight->"Bold"],

Cell[StyleData["IT"],
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 FontSlant->"Italic"],

Cell[StyleData["SmallCaps"],
 ConversionRules:>{"TeX" -> {{"", 
      $CellContext`ChangeCase["Lower"], ""}, {"", Automatic, ""}}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell["Font Specific Text Attributes", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["TR"],
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TI"],
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["TB"],
 ConversionRules:>{
  "TeX" -> {{"\\textbf{", Automatic, "}"}, {"", Automatic, ""}}},
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TBI"],
 ConversionRules:>{
  "TeX" -> {{"\\textbf{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MR"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{", Automatic, "}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MO"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MB"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textbf{", Automatic, "}}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MBO"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textbf{\\textit{", Automatic, "}}}"}, {
     "", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SR"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{", Automatic, "}"}, {"", Automatic, ""}}},
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SB"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textbf{", Automatic, "}}"}, {"", Automatic, ""}}},
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBO"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textbf{\\textit{", Automatic, "}}}"}, {
     "", Automatic, ""}}},
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["PlainGreekWin"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 CharacterEncoding->"Unicode"],

Cell[StyleData["PlainGreekMac"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 FontFamily->"Symbol"],

Cell[StyleData["PlainGreekLin"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 FontFamily->"Symbol"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlinks", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 ConversionRules:>{"TeX" -> {{"", 
      $CellContext`ExportAsHyperRef[], ""}, {"", Automatic, ""}}},
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
 FontSize->10,
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["XMLWebLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>($CellContext`OpenAllTypes[#]& ),
 ButtonNote->ButtonData,
 Evaluator->Automatic}],

Cell[StyleData["XMLWebLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["On-line Help System Links", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["UserGuideLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["UserGuide", #]}]& )}],

Cell[StyleData["UserGuideLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Reference", #]}]& )}],

Cell[StyleData["ReferenceLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["System", "Subsection"],

Cell[CellGroupData[{

Cell["Format Type Style", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that are mixed in with the styles of 
most cells.  If a cell's FormatType matches the name of one of the styles 
defined below, then that style is applied between the cell's style and its 
own options. This is particularly true of Input and Output.
\
\>", "Text"],

Cell[StyleData["CellExpression"],
 PageWidth->DirectedInfinity[1],
 CellMargins->{{6, Inherited}, {Inherited, Inherited}},
 ShowCellLabel->False,
 ShowSpecialCharacters->False,
 AllowInlineCells->False,
 AutoItalicWords->{},
 FontFamily->"Courier",
 FontSize->12,
 Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
 AllowInlineCells->False,
 FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
 PageWidth->DirectedInfinity[1],
 TextAlignment->Left,
 LineSpacing->{0.6, 1},
 FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
 LineSpacing->{1.25, 0},
 FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
 LineSpacing->{1.25, 0},
 SingleLetterItalics->True,
 TraditionalFunctionNotation->True,
 DelimiterMatching->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Document Settings and Templates", "Subsubsection"],

Cell[StyleData["ReferenceTemplate"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["AuthorFormCustomizationTemplate"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["CSSDefinitions"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["LaTeXPreamble"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["DOCTYPEFormat"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["ValidationSetting"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["XRefPaletteSettings"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["MiscSettings"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Cells", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The style defined below is mixed in to any cell that is in an 
inline cell within another.
\
\>", "Text"],

Cell[StyleData["InlineCell"],
 InputAutoReplacements->{"-" -> "-"},
 ScriptLevel->1],

Cell[StyleData["InlineCellEditing"],
 Background->RGBColor[0.880003, 0.899992, 0.959991]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that define standard ButtonFunctions, 
for use in palette buttons.
\
\>", "Text"],

Cell[StyleData["Paste"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["StyleApply"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>($CellContext`CellWriteStyle[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["StyleApplyWithVerification"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{
 ButtonFunction:>(($CellContext`CheckDocStyleMatch[]; \
$CellContext`CellWriteStyle[#])& ),
 Evaluator->Automatic}],

Cell[StyleData["ConvertCharacter"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`ExtractButtonData["TeX"], ""}, "HTML" :> {"", 
     $CellContext`ExtractButtonData["HTML"], ""}},
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFrame->"None",
 Evaluator->Automatic}]
}, Closed]],

Cell[CellGroupData[{

Cell["Automatic", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that are used to affect the display 
of certain types of objects in typeset expressions.  For example, 
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and 
parenthesis characters are displayed (typically by coloring them to make them \

stand out).
\
\>", "Text"],

Cell[StyleData["UnmatchedBracket"],
 FontColor->RGBColor[0.760006, 0.330007, 0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell["DialogEffects", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["DialogStyleSheetMisapplicationEscape"],
 ShowCellBracket->False,
 CellMargins->{{12, 12}, {2000, 40}},
 CellOpen->True,
 TextAlignment->Center]
}, Closed]]
}, Closed]]
}, Closed]]
},
WindowSize->{696, 663},
WindowMargins->{{35, Automatic}, {Automatic, 15}},
TaggingRules:>("StyleSheetName" -> "Book2.nb"),
ShowCellTags->True,
TrackCellChangeTimes->False,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 3, 2007)",
StyleDefinitions->"StylesheetFormatting.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 60, 0, 35, 60, 0, "StyleData", "StyleDefinitions", ""],
Cell[631, 23, 191, 4, 57, "Text"],
Cell[CellGroupData[{
Cell[847, 31, 35, 0, 50, "Section"],
Cell[885, 33, 99, 2, 42, "Text"],
Cell[987, 37, 87, 2, 35, 27, 0, "StyleData", "Notebook", "All"],
Cell[1077, 41, 62, 0, 20, "MiscSettings"],
Cell[1142, 43, 59, 0, 20, "MiscSettings"]
}, Closed]],
Cell[CellGroupData[{
Cell[1238, 48, 73, 2, 34, "Section"],
Cell[CellGroupData[{
Cell[1336, 54, 33, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[1394, 58, 31, 0, 45, "Subsubsection"],
Cell[1428, 60, 335, 9, 52, 25, 0, "StyleData", "Author", "All",
 MenuPosition->2000]
}, Closed]],
Cell[CellGroupData[{
Cell[1800, 74, 67, 1, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[1892, 79, 32, 0, 43, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[1949, 83, 45, 0, 42, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[2019, 87, 439, 12, 211, 33, 0, "StyleData", "TOCBookHeading", "All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[2461, 101, 105, 2, 197, 45, 0, "StyleData", "TOCBookHeading", \
"Centered"],
Cell[2569, 105, 90, 2, 174, 41, 0, "StyleData", "TOCHeading", "Printout"],
Cell[2662, 109, 126, 3, 174, 53, 0, "StyleData", "TOCBookHeading", \
"CenteredPrintout"],
Cell[2791, 114, 106, 2, 174, 57, 0, "StyleData", "TOCBookHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[2934, 121, 397, 10, 143, 39, 0, "StyleData", "TOCBookIllustrations", \
"All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[3334, 133, 111, 2, 197, 51, 0, "StyleData", "TOCBookIllustrations", \
"Centered"],
Cell[3448, 137, 96, 2, 174, 47, 0, "StyleData", "TOCIllustrations", \
"Printout"],
Cell[3547, 141, 132, 3, 174, 59, 0, "StyleData", "TOCBookIllustrations", \
"CenteredPrintout"],
Cell[3682, 146, 135, 3, 174, 63, 0, "StyleData", "TOCBookIllustrations", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[3854, 154, 389, 10, 143, 32, 0, "StyleData", "TOCBookTables", "All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[4246, 166, 104, 2, 197, 44, 0, "StyleData", "TOCBookTables", \
"Centered"],
Cell[4353, 170, 93, 2, 174, 44, 0, "StyleData", "TOCBookTables", "Printout"],
Cell[4449, 174, 125, 3, 174, 52, 0, "StyleData", "TOCBookTables", \
"CenteredPrintout"],
Cell[4577, 179, 105, 2, 174, 56, 0, "StyleData", "TOCBookTables", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[4731, 187, 48, 0, 42, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[4804, 191, 613, 14, 31, 44, 0, "StyleData", "TOCBookFrontmatterHeading", \
"All",
 CounterIncrements->"TOCBookFrontmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[5420, 207, 56, 0, 31, 56, 0, "StyleData", "TOCBookFrontmatterHeading", \
"Centered"],
Cell[5479, 209, 122, 3, 27, 56, 0, "StyleData", "TOCBookFrontmatterHeading", \
"Printout"],
Cell[5604, 214, 130, 3, 27, 64, 0, "StyleData", "TOCBookFrontmatterHeading", \
"CenteredPrintout"],
Cell[5737, 219, 134, 3, 27, 68, 0, "StyleData", "TOCBookFrontmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[5908, 227, 610, 14, 31, 43, 0, "StyleData", "TOCBookBackmatterHeading", \
"All",
 CounterIncrements->"TOCBookBackmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[6521, 243, 55, 0, 31, 55, 0, "StyleData", "TOCBookBackmatterHeading", \
"Centered"],
Cell[6579, 245, 121, 3, 27, 55, 0, "StyleData", "TOCBookBackmatterHeading", \
"Printout"],
Cell[6703, 250, 129, 3, 27, 63, 0, "StyleData", "TOCBookBackmatterHeading", \
"CenteredPrintout"],
Cell[6835, 255, 133, 3, 27, 67, 0, "StyleData", "TOCBookBackmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[7005, 263, 553, 12, 31, 42, 0, "StyleData", "TOCBookFrontBackHeading", \
"All",
 CounterIncrements->"TOCBookFrontBackHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[7561, 277, 54, 0, 31, 54, 0, "StyleData", "TOCBookFrontBackHeading", \
"Centered"],
Cell[7618, 279, 120, 3, 27, 54, 0, "StyleData", "TOCBookFrontBackHeading", \
"Printout"],
Cell[7741, 284, 128, 3, 27, 62, 0, "StyleData", "TOCBookFrontBackHeading", \
"CenteredPrintout"],
Cell[7872, 289, 132, 3, 27, 66, 0, "StyleData", "TOCBookFrontBackHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[8041, 297, 709, 17, 36, 35, 0, "StyleData", "TOCBookPartTitle", "All",
 CounterIncrements->"TOCBookPartTitle",
 CounterAssignments->{{"TOCBookChapterTitle", 0}}],
Cell[8753, 316, 47, 0, 44, 47, 0, "StyleData", "TOCBookPartTitle", \
"Centered"],
Cell[8803, 318, 96, 2, 33, 47, 0, "StyleData", "TOCBookPartTitle", \
"Printout"],
Cell[8902, 322, 104, 2, 39, 55, 0, "StyleData", "TOCBookPartTitle", \
"CenteredPrintout"],
Cell[9009, 326, 108, 2, 39, 59, 0, "StyleData", "TOCBookPartTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[9154, 333, 725, 18, 31, 38, 0, "StyleData", "TOCBookChapterTitle", "All",
 
 CounterIncrements->"TOCBookChapterTitle",
 CounterAssignments->{{"TOCBookSection", 0}}],
Cell[9882, 353, 50, 0, 31, 50, 0, "StyleData", "TOCBookChapterTitle", \
"Centered"],
Cell[9935, 355, 139, 4, 29, 50, 0, "StyleData", "TOCBookChapterTitle", \
"Printout"],
Cell[10077, 361, 147, 4, 29, 58, 0, "StyleData", "TOCBookChapterTitle", \
"CenteredPrintout"],
Cell[10227, 367, 151, 4, 29, 62, 0, "StyleData", "TOCBookChapterTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[10415, 376, 741, 17, 29, 33, 0, "StyleData", "TOCBookSection", "All",
 CounterIncrements->"TOCBookSection",
 CounterAssignments->{{"TOCBookSubsection", 0}}],
Cell[11159, 395, 45, 0, 29, 45, 0, "StyleData", "TOCBookSection", \
"Centered"],
Cell[11207, 397, 137, 4, 28, 45, 0, "StyleData", "TOCBookSection", \
"Printout"],
Cell[11347, 403, 145, 4, 28, 53, 0, "StyleData", "TOCBookSection", \
"CenteredPrintout"],
Cell[11495, 409, 149, 4, 28, 57, 0, "StyleData", "TOCBookSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[11681, 418, 774, 17, 29, 36, 0, "StyleData", "TOCBookSubsection", "All",
 CounterIncrements->"TOCBookSubsection"],
Cell[12458, 437, 48, 0, 29, 48, 0, "StyleData", "TOCBookSubsection", \
"Centered"],
Cell[12509, 439, 140, 4, 28, 48, 0, "StyleData", "TOCBookSubsection", \
"Printout"],
Cell[12652, 445, 148, 4, 28, 56, 0, "StyleData", "TOCBookSubsection", \
"CenteredPrintout"],
Cell[12803, 451, 152, 4, 28, 60, 0, "StyleData", "TOCBookSubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[12992, 460, 668, 15, 29, 32, 0, "StyleData", "TOCBookFigure", "All",
 CounterIncrements->"TOCBookFigure"],
Cell[13663, 477, 44, 0, 29, 44, 0, "StyleData", "TOCBookFigure", "Centered"],
Cell[13710, 479, 111, 3, 28, 44, 0, "StyleData", "TOCBookFigure", \
"Printout"],
Cell[13824, 484, 119, 3, 28, 52, 0, "StyleData", "TOCBookFigure", \
"CenteredPrintout"],
Cell[13946, 489, 123, 3, 28, 56, 0, "StyleData", "TOCBookFigure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14106, 497, 706, 15, 29, 38, 0, "StyleData", "TOCBookSupplemental", \
"All",
 CounterIncrements->"TOCBookSupplemental"],
Cell[14815, 514, 50, 0, 29, 50, 0, "StyleData", "TOCBookSupplemental", \
"Centered"],
Cell[14868, 516, 117, 3, 28, 50, 0, "StyleData", "TOCBookSupplemental", \
"Printout"],
Cell[14988, 521, 125, 3, 28, 58, 0, "StyleData", "TOCBookSupplemental", \
"CenteredPrintout"],
Cell[15116, 526, 129, 3, 28, 62, 0, "StyleData", "TOCBookSupplemental", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15282, 534, 676, 15, 29, 33, 0, "StyleData", "TOCBookPicture", "All",
 CounterIncrements->"TOCBookPicture"],
Cell[15961, 551, 45, 0, 29, 45, 0, "StyleData", "TOCBookPicture", \
"Centered"],
Cell[16009, 553, 112, 3, 28, 45, 0, "StyleData", "TOCBookPicture", \
"Printout"],
Cell[16124, 558, 120, 3, 28, 53, 0, "StyleData", "TOCBookPicture", \
"CenteredPrintout"],
Cell[16247, 563, 124, 3, 28, 57, 0, "StyleData", "TOCBookPicture", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16408, 571, 708, 15, 29, 38, 0, "StyleData", "TOCBookIllustration", \
"All",
 CounterIncrements->"TOCBookIllustration"],
Cell[17119, 588, 50, 0, 29, 50, 0, "StyleData", "TOCBookIllustration", \
"Centered"],
Cell[17172, 590, 117, 3, 28, 50, 0, "StyleData", "TOCBookIllustration", \
"Printout"],
Cell[17292, 595, 125, 3, 28, 58, 0, "StyleData", "TOCBookIllustration", \
"CenteredPrintout"],
Cell[17420, 600, 129, 3, 28, 62, 0, "StyleData", "TOCBookIllustration", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[17586, 608, 674, 15, 29, 33, 0, "StyleData", "TOCBookProgram", "All",
 CounterIncrements->"TOCBookProgram"],
Cell[18263, 625, 45, 0, 29, 45, 0, "StyleData", "TOCBookProgram", \
"Centered"],
Cell[18311, 627, 112, 3, 28, 45, 0, "StyleData", "TOCBookProgram", \
"Printout"],
Cell[18426, 632, 120, 3, 28, 53, 0, "StyleData", "TOCBookProgram", \
"CenteredPrintout"],
Cell[18549, 637, 124, 3, 28, 57, 0, "StyleData", "TOCBookProgram", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[18710, 645, 664, 15, 29, 31, 0, "StyleData", "TOCBookTable", "All",
 CounterIncrements->"TOCBookTable"],
Cell[19377, 662, 43, 0, 29, 43, 0, "StyleData", "TOCBookTable", "Centered"],
Cell[19423, 664, 110, 3, 28, 43, 0, "StyleData", "TOCBookTable", "Printout"],
Cell[19536, 669, 118, 3, 28, 51, 0, "StyleData", "TOCBookTable", \
"CenteredPrintout"],
Cell[19657, 674, 122, 3, 28, 55, 0, "StyleData", "TOCBookTable", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19828, 683, 46, 0, 42, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[19899, 687, 136, 3, 27, 32, 0, "StyleData", "TOCBookSpacer", "All"],
Cell[20038, 692, 78, 1, 27, 44, 0, "StyleData", "TOCBookSpacer", "Centered"],
Cell[20119, 695, 76, 1, 27, 44, 0, "StyleData", "TOCBookSpacer", "Printout"],
Cell[20198, 698, 84, 1, 27, 52, 0, "StyleData", "TOCBookSpacer", \
"CenteredPrintout"],
Cell[20285, 701, 88, 1, 27, 56, 0, "StyleData", "TOCBookSpacer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20410, 707, 138, 3, 35, 40, 0, "StyleData", "TOCBookPartTitleLabel", \
"All"],
Cell[20551, 712, 52, 0, 35, 52, 0, "StyleData", "TOCBookPartTitleLabel", \
"Centered"],
Cell[20606, 714, 80, 1, 35, 52, 0, "StyleData", "TOCBookPartTitleLabel", \
"Printout"],
Cell[20689, 717, 88, 1, 35, 60, 0, "StyleData", "TOCBookPartTitleLabel", \
"CenteredPrintout"],
Cell[20780, 720, 92, 1, 35, 64, 0, "StyleData", "TOCBookPartTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20909, 726, 164, 4, 35, 43, 0, "StyleData", "TOCBookChapterTitleLabel", \
"All"],
Cell[21076, 732, 55, 0, 35, 55, 0, "StyleData", "TOCBookChapterTitleLabel", \
"Centered"],
Cell[21134, 734, 83, 1, 35, 55, 0, "StyleData", "TOCBookChapterTitleLabel", \
"Printout"],
Cell[21220, 737, 91, 1, 35, 63, 0, "StyleData", "TOCBookChapterTitleLabel", \
"CenteredPrintout"],
Cell[21314, 740, 95, 1, 35, 67, 0, "StyleData", "TOCBookChapterTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[21446, 746, 159, 4, 35, 38, 0, "StyleData", "TOCBookSectionLabel", \
"All"],
Cell[21608, 752, 50, 0, 35, 50, 0, "StyleData", "TOCBookSectionLabel", \
"Centered"],
Cell[21661, 754, 78, 1, 35, 50, 0, "StyleData", "TOCBookSectionLabel", \
"Printout"],
Cell[21742, 757, 86, 1, 35, 58, 0, "StyleData", "TOCBookSectionLabel", \
"CenteredPrintout"],
Cell[21831, 760, 90, 1, 35, 62, 0, "StyleData", "TOCBookSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[21958, 766, 162, 4, 35, 41, 0, "StyleData", "TOCBookSubsectionLabel", \
"All"],
Cell[22123, 772, 53, 0, 35, 53, 0, "StyleData", "TOCBookSubsectionLabel", \
"Centered"],
Cell[22179, 774, 81, 1, 35, 53, 0, "StyleData", "TOCBookSubsectionLabel", \
"Printout"],
Cell[22263, 777, 89, 1, 35, 61, 0, "StyleData", "TOCBookSubsectionLabel", \
"CenteredPrintout"],
Cell[22355, 780, 93, 1, 35, 65, 0, "StyleData", "TOCBookSubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[22485, 786, 158, 4, 35, 37, 0, "StyleData", "TOCBookFigureLabel", \
"All"],
Cell[22646, 792, 49, 0, 35, 49, 0, "StyleData", "TOCBookFigureLabel", \
"Centered"],
Cell[22698, 794, 77, 1, 35, 49, 0, "StyleData", "TOCBookFigureLabel", \
"Printout"],
Cell[22778, 797, 85, 1, 35, 57, 0, "StyleData", "TOCBookFigureLabel", \
"CenteredPrintout"],
Cell[22866, 800, 89, 1, 35, 61, 0, "StyleData", "TOCBookFigureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[22992, 806, 164, 4, 35, 43, 0, "StyleData", "TOCBookSupplementalLabel", \
"All"],
Cell[23159, 812, 55, 0, 35, 55, 0, "StyleData", "TOCBookSupplementalLabel", \
"Centered"],
Cell[23217, 814, 83, 1, 35, 55, 0, "StyleData", "TOCBookSupplementalLabel", \
"Printout"],
Cell[23303, 817, 91, 1, 35, 63, 0, "StyleData", "TOCBookSupplementalLabel", \
"CenteredPrintout"],
Cell[23397, 820, 95, 1, 35, 67, 0, "StyleData", "TOCBookSupplementalLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[23529, 826, 159, 4, 35, 38, 0, "StyleData", "TOCBookPictureLabel", \
"All"],
Cell[23691, 832, 50, 0, 35, 50, 0, "StyleData", "TOCBookPictureLabel", \
"Centered"],
Cell[23744, 834, 78, 1, 35, 50, 0, "StyleData", "TOCBookPictureLabel", \
"Printout"],
Cell[23825, 837, 86, 1, 35, 58, 0, "StyleData", "TOCBookPictureLabel", \
"CenteredPrintout"],
Cell[23914, 840, 90, 1, 35, 62, 0, "StyleData", "TOCBookPictureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24041, 846, 164, 4, 35, 43, 0, "StyleData", "TOCBookIllustrationLabel", \
"All"],
Cell[24208, 852, 55, 0, 35, 55, 0, "StyleData", "TOCBookIllustrationLabel", \
"Centered"],
Cell[24266, 854, 83, 1, 35, 55, 0, "StyleData", "TOCBookIllustrationLabel", \
"Printout"],
Cell[24352, 857, 91, 1, 35, 63, 0, "StyleData", "TOCBookIllustrationLabel", \
"CenteredPrintout"],
Cell[24446, 860, 95, 1, 35, 67, 0, "StyleData", "TOCBookIllustrationLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24578, 866, 159, 4, 35, 38, 0, "StyleData", "TOCBookProgramLabel", \
"All"],
Cell[24740, 872, 50, 0, 35, 50, 0, "StyleData", "TOCBookProgramLabel", \
"Centered"],
Cell[24793, 874, 78, 1, 35, 50, 0, "StyleData", "TOCBookProgramLabel", \
"Printout"],
Cell[24874, 877, 86, 1, 35, 58, 0, "StyleData", "TOCBookProgramLabel", \
"CenteredPrintout"],
Cell[24963, 880, 90, 1, 35, 62, 0, "StyleData", "TOCBookProgramLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25090, 886, 157, 4, 35, 36, 0, "StyleData", "TOCBookTableLabel", "All"],
Cell[25250, 892, 48, 0, 35, 48, 0, "StyleData", "TOCBookTableLabel", \
"Centered"],
Cell[25301, 894, 76, 1, 35, 48, 0, "StyleData", "TOCBookTableLabel", \
"Printout"],
Cell[25380, 897, 84, 1, 35, 56, 0, "StyleData", "TOCBookTableLabel", \
"CenteredPrintout"],
Cell[25467, 900, 88, 1, 35, 60, 0, "StyleData", "TOCBookTableLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25592, 906, 158, 5, 35, 32, 0, "StyleData", "TOCBookLeader", "All"],
Cell[25753, 913, 44, 0, 35, 44, 0, "StyleData", "TOCBookLeader", "Centered"],
Cell[25800, 915, 59, 1, 34, 44, 0, "StyleData", "TOCBookLeader", "Printout"],
Cell[25862, 918, 67, 1, 34, 52, 0, "StyleData", "TOCBookLeader", \
"CenteredPrintout"],
Cell[25932, 921, 71, 1, 34, 56, 0, "StyleData", "TOCBookLeader", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26040, 927, 301, 9, 35, 36, 0, "StyleData", "TOCBookPageNumber", "All"],
Cell[26344, 938, 48, 0, 35, 48, 0, "StyleData", "TOCBookPageNumber", \
"Centered"],
Cell[26395, 940, 76, 1, 35, 48, 0, "StyleData", "TOCBookPageNumber", \
"Printout"],
Cell[26474, 943, 84, 1, 35, 56, 0, "StyleData", "TOCBookPageNumber", \
"CenteredPrintout"],
Cell[26561, 946, 88, 1, 35, 60, 0, "StyleData", "TOCBookPageNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26734, 956, 32, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[26791, 960, 689, 17, 69, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[27483, 979, 155, 5, 64, 38, 0, "StyleData", "Section", "Centered"],
Cell[27641, 986, 87, 2, 55, 38, 0, "StyleData", "Section", "Printout"],
Cell[27731, 990, 140, 4, 57, 46, 0, "StyleData", "Section", \
"CenteredPrintout"],
Cell[27874, 996, 121, 3, 55, 50, 0, "StyleData", "Section", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[28032, 1004, 691, 18, 41, 29, 0, "StyleData", "Subsection", "All",
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}}],
Cell[28726, 1024, 158, 5, 57, 41, 0, "StyleData", "Subsection", "Centered"],
Cell[28887, 1031, 90, 2, 50, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[28980, 1035, 143, 4, 51, 49, 0, "StyleData", "Subsection", \
"CenteredPrintout"],
Cell[29126, 1041, 124, 3, 50, 53, 0, "StyleData", "Subsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[29287, 1049, 407, 11, 36, 32, 0, "StyleData", "Subsubsection", "All",
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"}],
Cell[29697, 1062, 146, 4, 53, 44, 0, "StyleData", "Subsubsection", \
"Centered"],
Cell[29846, 1068, 92, 2, 45, 44, 0, "StyleData", "Subsubsection", \
"Printout"],
Cell[29941, 1072, 146, 4, 48, 52, 0, "StyleData", "Subsubsection", \
"CenteredPrintout"],
Cell[30090, 1078, 126, 3, 45, 56, 0, "StyleData", "Subsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[30253, 1086, 390, 10, 36, 35, 0, "StyleData", "Subsubsubsection", "All",
 CounterIncrements->{"Subsubsubsection", "SubsubsubsectionHeader"}],
Cell[30646, 1098, 170, 5, 41, 47, 0, "StyleData", "Subsubsubsection", \
"Centered"],
Cell[30819, 1105, 94, 2, 35, 47, 0, "StyleData", "Subsubsubsection", \
"Printout"],
Cell[30916, 1109, 148, 4, 38, 55, 0, "StyleData", "Subsubsubsection", \
"CenteredPrintout"],
Cell[31067, 1115, 106, 2, 35, 59, 0, "StyleData", "Subsubsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[31210, 1122, 53, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[31288, 1126, 141, 4, 35, 31, 0, "StyleData", "SectionLabel", "All"],
Cell[31432, 1132, 43, 0, 35, 43, 0, "StyleData", "SectionLabel", "Centered"],
Cell[31478, 1134, 43, 0, 35, 43, 0, "StyleData", "SectionLabel", "Printout"],
Cell[31524, 1136, 51, 0, 35, 51, 0, "StyleData", "SectionLabel", \
"CenteredPrintout"],
Cell[31578, 1138, 55, 0, 35, 55, 0, "StyleData", "SectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[31670, 1143, 144, 4, 35, 34, 0, "StyleData", "SubsectionLabel", "All"],
Cell[31817, 1149, 46, 0, 35, 46, 0, "StyleData", "SubsectionLabel", \
"Centered"],
Cell[31866, 1151, 46, 0, 35, 46, 0, "StyleData", "SubsectionLabel", \
"Printout"],
Cell[31915, 1153, 54, 0, 35, 54, 0, "StyleData", "SubsectionLabel", \
"CenteredPrintout"],
Cell[31972, 1155, 58, 0, 35, 58, 0, "StyleData", "SubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[32079, 1161, 43, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[32147, 1165, 302, 9, 67, 29, 0, "StyleData", "SectionAlt", "All"],
Cell[32452, 1176, 158, 5, 64, 41, 0, "StyleData", "SectionAlt", "Centered"],
Cell[32613, 1183, 90, 2, 55, 41, 0, "StyleData", "SectionAlt", "Printout"],
Cell[32706, 1187, 143, 4, 57, 49, 0, "StyleData", "SectionAlt", \
"CenteredPrintout"],
Cell[32852, 1193, 124, 3, 55, 53, 0, "StyleData", "SectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[33013, 1201, 311, 9, 49, 32, 0, "StyleData", "SubsectionAlt", "All"],
Cell[33327, 1212, 161, 5, 57, 44, 0, "StyleData", "SubsectionAlt", \
"Centered"],
Cell[33491, 1219, 93, 2, 50, 44, 0, "StyleData", "SubsectionAlt", \
"Printout"],
Cell[33587, 1223, 146, 4, 51, 52, 0, "StyleData", "SubsectionAlt", \
"CenteredPrintout"],
Cell[33736, 1229, 127, 3, 50, 56, 0, "StyleData", "SubsectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[33912, 1238, 34, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[33971, 1242, 252, 7, 29, 23, 0, "StyleData", "Text", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[34226, 1251, 35, 0, 29, 35, 0, "StyleData", "Text", "Centered"],
Cell[34264, 1253, 104, 3, 26, 35, 0, "StyleData", "Text", "Printout"],
Cell[34371, 1258, 112, 3, 26, 43, 0, "StyleData", "Text", \
"CenteredPrintout"],
Cell[34486, 1263, 138, 4, 26, 47, 0, "StyleData", "Text", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[34661, 1272, 362, 8, 29, 31, 0, "StyleData", "TextNoIndent", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[35026, 1282, 43, 0, 29, 43, 0, "StyleData", "TextNoIndent", "Centered"],
Cell[35072, 1284, 90, 2, 26, 43, 0, "StyleData", "TextNoIndent", "Printout"],
Cell[35165, 1288, 98, 2, 26, 51, 0, "StyleData", "TextNoIndent", \
"CenteredPrintout"],
Cell[35266, 1292, 124, 3, 26, 55, 0, "StyleData", "TextNoIndent", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35427, 1300, 423, 9, 29, 35, 0, "StyleData", "TextContinuation", "All",
 CounterIncrements->"TextContinuation",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[35853, 1311, 47, 0, 29, 47, 0, "StyleData", "TextContinuation", \
"Centered"],
Cell[35903, 1313, 94, 2, 26, 47, 0, "StyleData", "TextContinuation", \
"Printout"],
Cell[36000, 1317, 102, 2, 26, 55, 0, "StyleData", "TextContinuation", \
"CenteredPrintout"],
Cell[36105, 1321, 128, 3, 32, 59, 0, "StyleData", "TextContinuation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[36294, 1331, 36, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[36355, 1335, 64, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[36444, 1340, 637, 15, 30, 24, 0, "StyleData", "Item1", "All",
 CounterIncrements->"Item1",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],
Cell[37084, 1357, 36, 0, 30, 36, 0, "StyleData", "Item1", "Centered"],
Cell[37123, 1359, 84, 2, 28, 36, 0, "StyleData", "Item1", "Printout"],
Cell[37210, 1363, 92, 2, 28, 44, 0, "StyleData", "Item1", \
"CenteredPrintout"],
Cell[37305, 1367, 118, 3, 28, 48, 0, "StyleData", "Item1", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[37460, 1375, 615, 15, 30, 24, 0, "StyleData", "Item2", "All",
 CounterIncrements->"Item2",
 CounterAssignments->{{"Item3Numbered", 0}}],
Cell[38078, 1392, 36, 0, 30, 36, 0, "StyleData", "Item2", "Centered"],
Cell[38117, 1394, 84, 2, 28, 36, 0, "StyleData", "Item2", "Printout"],
Cell[38204, 1398, 92, 2, 28, 44, 0, "StyleData", "Item2", \
"CenteredPrintout"],
Cell[38299, 1402, 118, 3, 28, 48, 0, "StyleData", "Item2", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[38454, 1410, 570, 14, 30, 24, 0, "StyleData", "Item3", "All",
 CounterIncrements->"Item3"],
Cell[39027, 1426, 36, 0, 30, 36, 0, "StyleData", "Item3", "Centered"],
Cell[39066, 1428, 84, 2, 28, 36, 0, "StyleData", "Item3", "Printout"],
Cell[39153, 1432, 92, 2, 28, 44, 0, "StyleData", "Item3", \
"CenteredPrintout"],
Cell[39248, 1436, 118, 3, 28, 48, 0, "StyleData", "Item3", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[39403, 1444, 229, 6, 35, 29, 0, "StyleData", "Item1Label", "All"],
Cell[39635, 1452, 41, 0, 35, 41, 0, "StyleData", "Item1Label", "Centered"],
Cell[39679, 1454, 84, 2, 34, 41, 0, "StyleData", "Item1Label", "Printout"],
Cell[39766, 1458, 92, 2, 34, 49, 0, "StyleData", "Item1Label", \
"CenteredPrintout"],
Cell[39861, 1462, 96, 2, 34, 53, 0, "StyleData", "Item1Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[39994, 1469, 229, 6, 35, 29, 0, "StyleData", "Item2Label", "All"],
Cell[40226, 1477, 41, 0, 35, 41, 0, "StyleData", "Item2Label", "Centered"],
Cell[40270, 1479, 69, 1, 35, 41, 0, "StyleData", "Item2Label", "Printout"],
Cell[40342, 1482, 77, 1, 35, 49, 0, "StyleData", "Item2Label", \
"CenteredPrintout"],
Cell[40422, 1485, 81, 1, 35, 53, 0, "StyleData", "Item2Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[40540, 1491, 229, 6, 35, 29, 0, "StyleData", "Item3Label", "All"],
Cell[40772, 1499, 41, 0, 35, 41, 0, "StyleData", "Item3Label", "Centered"],
Cell[40816, 1501, 69, 1, 35, 41, 0, "StyleData", "Item3Label", "Printout"],
Cell[40888, 1504, 77, 1, 35, 49, 0, "StyleData", "Item3Label", \
"CenteredPrintout"],
Cell[40968, 1507, 81, 1, 35, 53, 0, "StyleData", "Item3Label", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41098, 1514, 64, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[41187, 1519, 700, 17, 30, 32, 0, "StyleData", "Item1Numbered", "All",
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],
Cell[41890, 1538, 44, 0, 30, 44, 0, "StyleData", "Item1Numbered", \
"Centered"],
Cell[41937, 1540, 92, 2, 28, 44, 0, "StyleData", "Item1Numbered", \
"Printout"],
Cell[42032, 1544, 100, 2, 28, 52, 0, "StyleData", "Item1Numbered", \
"CenteredPrintout"],
Cell[42135, 1548, 126, 3, 28, 56, 0, "StyleData", "Item1Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[42298, 1556, 765, 19, 30, 32, 0, "StyleData", "Item2Numbered", "All",
 CounterIncrements->"Item2Numbered",
 CounterAssignments->{{"Item3Numbered", 0}}],
Cell[43066, 1577, 44, 0, 30, 44, 0, "StyleData", "Item2Numbered", \
"Centered"],
Cell[43113, 1579, 92, 2, 29, 44, 0, "StyleData", "Item2Numbered", \
"Printout"],
Cell[43208, 1583, 100, 2, 29, 52, 0, "StyleData", "Item2Numbered", \
"CenteredPrintout"],
Cell[43311, 1587, 126, 3, 29, 56, 0, "StyleData", "Item2Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[43474, 1595, 686, 17, 30, 32, 0, "StyleData", "Item3Numbered", "All",
 CounterIncrements->"Item3Numbered"],
Cell[44163, 1614, 44, 0, 30, 44, 0, "StyleData", "Item3Numbered", \
"Centered"],
Cell[44210, 1616, 92, 2, 28, 44, 0, "StyleData", "Item3Numbered", \
"Printout"],
Cell[44305, 1620, 100, 2, 28, 52, 0, "StyleData", "Item3Numbered", \
"CenteredPrintout"],
Cell[44408, 1624, 126, 3, 28, 56, 0, "StyleData", "Item3Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[44571, 1632, 211, 5, 35, 37, 0, "StyleData", "Item1NumberedLabel", \
"All"],
Cell[44785, 1639, 49, 0, 35, 49, 0, "StyleData", "Item1NumberedLabel", \
"Centered"],
Cell[44837, 1641, 77, 1, 34, 49, 0, "StyleData", "Item1NumberedLabel", \
"Printout"],
Cell[44917, 1644, 85, 1, 35, 57, 0, "StyleData", "Item1NumberedLabel", \
"CenteredPrintout"],
Cell[45005, 1647, 89, 1, 35, 61, 0, "StyleData", "Item1NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[45131, 1653, 211, 5, 35, 37, 0, "StyleData", "Item2NumberedLabel", \
"All"],
Cell[45345, 1660, 49, 0, 35, 49, 0, "StyleData", "Item2NumberedLabel", \
"Centered"],
Cell[45397, 1662, 77, 1, 35, 49, 0, "StyleData", "Item2NumberedLabel", \
"Printout"],
Cell[45477, 1665, 85, 1, 35, 57, 0, "StyleData", "Item2NumberedLabel", \
"CenteredPrintout"],
Cell[45565, 1668, 89, 1, 35, 61, 0, "StyleData", "Item2NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[45691, 1674, 211, 5, 35, 37, 0, "StyleData", "Item3NumberedLabel", \
"All"],
Cell[45905, 1681, 49, 0, 35, 49, 0, "StyleData", "Item3NumberedLabel", \
"Centered"],
Cell[45957, 1683, 77, 1, 35, 49, 0, "StyleData", "Item3NumberedLabel", \
"Printout"],
Cell[46037, 1686, 85, 1, 35, 57, 0, "StyleData", "Item3NumberedLabel", \
"CenteredPrintout"],
Cell[46125, 1689, 89, 1, 35, 61, 0, "StyleData", "Item3NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[46263, 1696, 65, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[46353, 1701, 271, 5, 29, 33, 0, "StyleData", "Item1Paragraph", "All"],
Cell[46627, 1708, 45, 0, 29, 45, 0, "StyleData", "Item1Paragraph", \
"Centered"],
Cell[46675, 1710, 93, 2, 28, 45, 0, "StyleData", "Item1Paragraph", \
"Printout"],
Cell[46771, 1714, 101, 2, 28, 53, 0, "StyleData", "Item1Paragraph", \
"CenteredPrintout"],
Cell[46875, 1718, 127, 3, 28, 57, 0, "StyleData", "Item1Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[47039, 1726, 271, 5, 29, 33, 0, "StyleData", "Item2Paragraph", "All"],
Cell[47313, 1733, 45, 0, 29, 45, 0, "StyleData", "Item2Paragraph", \
"Centered"],
Cell[47361, 1735, 93, 2, 28, 45, 0, "StyleData", "Item2Paragraph", \
"Printout"],
Cell[47457, 1739, 101, 2, 28, 53, 0, "StyleData", "Item2Paragraph", \
"CenteredPrintout"],
Cell[47561, 1743, 127, 3, 28, 57, 0, "StyleData", "Item2Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[47725, 1751, 272, 5, 29, 33, 0, "StyleData", "Item3Paragraph", "All"],
Cell[48000, 1758, 45, 0, 29, 45, 0, "StyleData", "Item3Paragraph", \
"Centered"],
Cell[48048, 1760, 93, 2, 28, 45, 0, "StyleData", "Item3Paragraph", \
"Printout"],
Cell[48144, 1764, 101, 2, 28, 53, 0, "StyleData", "Item3Paragraph", \
"CenteredPrintout"],
Cell[48248, 1768, 127, 3, 28, 57, 0, "StyleData", "Item3Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[48436, 1778, 48, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[48509, 1782, 31, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[48565, 1786, 713, 18, 40, 25, 0, "StyleData", "Figure", "All",
 CounterIncrements->"Figure"],
Cell[49281, 1806, 61, 1, 35, 37, 0, "StyleData", "Figure", "Centered"],
Cell[49345, 1809, 91, 2, 34, 37, 0, "StyleData", "Figure", "Printout"],
Cell[49439, 1813, 122, 3, 34, 45, 0, "StyleData", "Figure", \
"CenteredPrintout"],
Cell[49564, 1818, 103, 2, 34, 49, 0, "StyleData", "Figure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[49704, 1825, 589, 15, 36, 32, 0, "StyleData", "FigureCaption", "All",
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[50296, 1842, 118, 2, 35, 44, 0, "StyleData", "FigureCaption", \
"Centered"],
Cell[50417, 1846, 114, 3, 33, 44, 0, "StyleData", "FigureCaption", \
"Printout"],
Cell[50534, 1851, 147, 4, 33, 52, 0, "StyleData", "FigureCaption", \
"CenteredPrintout"],
Cell[50684, 1857, 148, 4, 33, 56, 0, "StyleData", "FigureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[50847, 1864, 170, 4, 35, 37, 0, "StyleData", "FigureCaptionLabel", \
"All"]
}, Closed]],
Cell[CellGroupData[{
Cell[51054, 1873, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[51111, 1877, 764, 20, 40, 26, 0, "StyleData", "Picture", "All",
 CounterIncrements->"Picture"],
Cell[51878, 1899, 62, 1, 35, 38, 0, "StyleData", "Picture", "Centered"],
Cell[51943, 1902, 92, 2, 34, 38, 0, "StyleData", "Picture", "Printout"],
Cell[52038, 1906, 123, 3, 34, 46, 0, "StyleData", "Picture", \
"CenteredPrintout"],
Cell[52164, 1911, 104, 2, 34, 50, 0, "StyleData", "Picture", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[52305, 1918, 593, 15, 36, 33, 0, "StyleData", "PictureCaption", "All",
 CounterIncrements->"PictureCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[52901, 1935, 119, 2, 35, 45, 0, "StyleData", "PictureCaption", \
"Centered"],
Cell[53023, 1939, 115, 3, 33, 45, 0, "StyleData", "PictureCaption", \
"Printout"],
Cell[53141, 1944, 148, 4, 33, 53, 0, "StyleData", "PictureCaption", \
"CenteredPrintout"],
Cell[53292, 1950, 149, 4, 33, 57, 0, "StyleData", "PictureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[53456, 1957, 171, 4, 35, 38, 0, "StyleData", "PictureCaptionLabel", \
"All"]
}, Closed]],
Cell[CellGroupData[{
Cell[53664, 1966, 39, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[53728, 1970, 487, 11, 52, 26, 0, "StyleData", "Program", "All",
 CounterIncrements->"Program"],
Cell[54218, 1983, 72, 1, 34, 38, 0, "StyleData", "Program", "Centered"],
Cell[54293, 1986, 86, 2, 31, 38, 0, "StyleData", "Program", "Printout"],
Cell[54382, 1990, 95, 2, 31, 46, 0, "StyleData", "Program", \
"CenteredPrintout"],
Cell[54480, 1994, 98, 2, 31, 50, 0, "StyleData", "Program", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[54615, 2001, 593, 15, 34, 33, 0, "StyleData", "ProgramCaption", "All",
 CounterIncrements->"ProgramCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[55211, 2018, 95, 1, 35, 45, 0, "StyleData", "ProgramCaption", \
"Centered"],
Cell[55309, 2021, 92, 2, 31, 45, 0, "StyleData", "ProgramCaption", \
"Printout"],
Cell[55404, 2025, 124, 3, 33, 53, 0, "StyleData", "ProgramCaption", \
"CenteredPrintout"],
Cell[55531, 2030, 149, 4, 33, 57, 0, "StyleData", "ProgramCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[55695, 2037, 126, 3, 35, 38, 0, "StyleData", "ProgramCaptionLabel", \
"All"]
}, Closed]],
Cell[CellGroupData[{
Cell[55858, 2045, 31, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[55914, 2049, 879, 22, 35, 29, 0, "StyleData", "TableTitle", "All",
 CounterIncrements->"TableTitle",
 CounterAssignments->{{"Nil", 0}}],
Cell[56796, 2073, 98, 1, 35, 41, 0, "StyleData", "TableTitle", "Centered"],
Cell[56897, 2076, 89, 2, 32, 41, 0, "StyleData", "TableTitle", "Printout"],
Cell[56989, 2080, 96, 2, 32, 49, 0, "StyleData", "TableTitle", \
"CenteredPrintout"],
Cell[57088, 2084, 101, 2, 32, 53, 0, "StyleData", "TableTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[57226, 2091, 455, 13, 35, 34, 0, "StyleData", "TableTitleLabel", "All",
 CounterIncrements->"TableTitleLabel"],
Cell[57684, 2106, 46, 0, 35, 46, 0, "StyleData", "TableTitleLabel", \
"Centered"],
Cell[57733, 2108, 61, 1, 34, 46, 0, "StyleData", "TableTitleLabel", \
"Printout"],
Cell[57797, 2111, 69, 1, 34, 54, 0, "StyleData", "TableTitleLabel", \
"CenteredPrintout"],
Cell[57869, 2114, 73, 1, 34, 58, 0, "StyleData", "TableTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[57979, 2120, 1157, 29, 32, 24, 0, "StyleData", "Table", "All",
 CounterIncrements->"Table",
 CounterAssignments->{{"TableNote", 0}}],
Cell[59139, 2151, 70, 1, 32, 36, 0, "StyleData", "Table", "Centered"],
Cell[59212, 2154, 108, 3, 30, 36, 0, "StyleData", "Table", "Printout"],
Cell[59323, 2159, 115, 3, 30, 44, 0, "StyleData", "Table", \
"CenteredPrintout"],
Cell[59441, 2164, 120, 3, 30, 48, 0, "StyleData", "Table", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[59598, 2172, 431, 13, 30, 28, 0, "StyleData", "TableNote", "All",
 CounterIncrements->"TableNote"],
Cell[60032, 2187, 75, 1, 31, 40, 0, "StyleData", "TableNote", "Centered"],
Cell[60110, 2190, 87, 2, 31, 40, 0, "StyleData", "TableNote", "Printout"],
Cell[60200, 2194, 87, 2, 28, 40, 0, "StyleData", "TableNote", "Printout"],
Cell[60290, 2198, 122, 3, 28, 52, 0, "StyleData", "TableNote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[60449, 2206, 47, 0, 27, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[60521, 2210, 899, 24, 35, 34, 0, "StyleData", "TableColumnHead", "All"],
Cell[61423, 2236, 46, 0, 35, 46, 0, "StyleData", "TableColumnHead", \
"Centered"],
Cell[61472, 2238, 61, 1, 34, 46, 0, "StyleData", "TableColumnHead", \
"Printout"],
Cell[61536, 2241, 69, 1, 34, 54, 0, "StyleData", "TableColumnHead", \
"CenteredPrintout"],
Cell[61608, 2244, 73, 1, 34, 58, 0, "StyleData", "TableColumnHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[61718, 2250, 921, 25, 35, 32, 0, "StyleData", "TableSpanHead", "All"],
Cell[62642, 2277, 59, 1, 34, 44, 0, "StyleData", "TableSpanHead", \
"Printout"],
Cell[62704, 2280, 71, 1, 34, 56, 0, "StyleData", "TableSpanHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[62812, 2286, 829, 23, 35, 28, 0, "StyleData", "TableText", "All"],
Cell[63644, 2311, 40, 0, 35, 40, 0, "StyleData", "TableText", "Centered"],
Cell[63687, 2313, 55, 1, 34, 40, 0, "StyleData", "TableText", "Printout"],
Cell[63745, 2316, 63, 1, 34, 48, 0, "StyleData", "TableText", \
"CenteredPrintout"],
Cell[63811, 2319, 89, 2, 34, 52, 0, "StyleData", "TableText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[63937, 2326, 599, 17, 35, 32, 0, "StyleData", "TableSpanText", "All"],
Cell[64539, 2345, 59, 1, 34, 44, 0, "StyleData", "TableSpanText", \
"Printout"],
Cell[64601, 2348, 71, 1, 34, 56, 0, "StyleData", "TableSpanText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[64687, 2352, 735, 18, 35, 31, 0, "StyleData", "TableSubGrid", "All"],
Cell[65425, 2372, 441, 10, 35, 34, 0, "StyleData", "TableMasterGrid", "All"],
Cell[65869, 2384, 312, 9, 17, 35, 0, "StyleData", "TableLineElement", "All"],
Cell[66184, 2395, 142, 4, 9, 36, 0, "StyleData", "TableBlankElement", "All"],
Cell[CellGroupData[{
Cell[66351, 2403, 103, 4, 39, 27, 0, "StyleData", "SpanLeft", "All"],
Cell[66457, 2409, 54, 1, 37, 39, 0, "StyleData", "SpanLeft", "Printout"],
Cell[66514, 2412, 66, 1, 37, 51, 0, "StyleData", "SpanLeft", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[66617, 2418, 105, 4, 39, 29, 0, "StyleData", "SpanCenter", "All"],
Cell[66725, 2424, 56, 1, 37, 41, 0, "StyleData", "SpanCenter", "Printout"],
Cell[66784, 2427, 68, 1, 37, 53, 0, "StyleData", "SpanCenter", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[66889, 2433, 104, 4, 39, 28, 0, "StyleData", "SpanRight", "All"],
Cell[66996, 2439, 55, 1, 37, 40, 0, "StyleData", "SpanRight", "Printout"],
Cell[67054, 2442, 67, 1, 37, 52, 0, "StyleData", "SpanRight", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[67182, 2450, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[67239, 2454, 340, 8, 36, 26, 0, "StyleData", "Caption", "All",
 CounterIncrements->"Caption"],
Cell[67582, 2464, 88, 1, 35, 38, 0, "StyleData", "Caption", "Centered"],
Cell[67673, 2467, 108, 3, 33, 38, 0, "StyleData", "Caption", "Printout"],
Cell[67784, 2472, 117, 3, 33, 46, 0, "StyleData", "Caption", \
"CenteredPrintout"],
Cell[67904, 2477, 142, 4, 33, 50, 0, "StyleData", "Caption", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[68107, 2488, 33, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[68165, 2492, 34, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[68224, 2496, 317, 7, 41, 27, 0, "StyleData", "Equation", "All",
 CounterIncrements->"Equation"],
Cell[68544, 2505, 172, 4, 41, 39, 0, "StyleData", "Equation", "Centered"],
Cell[68719, 2511, 87, 2, 36, 39, 0, "StyleData", "Equation", "Printout"],
Cell[68809, 2515, 193, 5, 36, 47, 0, "StyleData", "Equation", \
"CenteredPrintout"],
Cell[69005, 2522, 99, 2, 36, 51, 0, "StyleData", "Equation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[69141, 2529, 356, 8, 29, 32, 0, "StyleData", "EquationGroup", "All"],
Cell[69500, 2539, 176, 4, 29, 44, 0, "StyleData", "EquationGroup", \
"Centered"],
Cell[69679, 2545, 92, 2, 27, 44, 0, "StyleData", "EquationGroup", \
"Printout"],
Cell[69774, 2549, 198, 5, 27, 52, 0, "StyleData", "EquationGroup", \
"CenteredPrintout"],
Cell[69975, 2556, 104, 2, 27, 56, 0, "StyleData", "EquationGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[70116, 2563, 662, 15, 29, 39, 0, "StyleData", "EquationGroupAligned", \
"All"],
Cell[70781, 2580, 108, 2, 29, 51, 0, "StyleData", "EquationGroupAligned", \
"Centered"],
Cell[70892, 2584, 99, 2, 27, 51, 0, "StyleData", "EquationGroupAligned", \
"Printout"],
Cell[70994, 2588, 130, 3, 27, 59, 0, "StyleData", "EquationGroupAligned", \
"CenteredPrintout"],
Cell[71127, 2593, 111, 2, 27, 63, 0, "StyleData", "EquationGroupAligned", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[71287, 2601, 43, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[71355, 2605, 885, 22, 41, 35, 0, "StyleData", "EquationNumbered", "All",
 CounterIncrements->"EquationNumbered"],
Cell[72243, 2629, 105, 2, 41, 47, 0, "StyleData", "EquationNumbered", \
"Centered"],
Cell[72351, 2633, 95, 2, 36, 47, 0, "StyleData", "EquationNumbered", \
"Printout"],
Cell[72449, 2637, 126, 3, 36, 55, 0, "StyleData", "EquationNumbered", \
"CenteredPrintout"],
Cell[72578, 2642, 107, 2, 36, 59, 0, "StyleData", "EquationNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[72722, 2649, 1006, 25, 29, 40, 0, "StyleData", "EquationGroupNumbered", \
"All",
 CounterIncrements->"EquationNumbered"],
Cell[73731, 2676, 109, 2, 29, 52, 0, "StyleData", "EquationGroupNumbered", \
"Centered"],
Cell[73843, 2680, 100, 2, 27, 52, 0, "StyleData", "EquationGroupNumbered", \
"Printout"],
Cell[73946, 2684, 131, 3, 27, 60, 0, "StyleData", "EquationGroupNumbered", \
"CenteredPrintout"],
Cell[74080, 2689, 112, 2, 27, 64, 0, "StyleData", "EquationGroupNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[74229, 2696, 1248, 30, 29, 47, 0, "StyleData", \
"EquationGroupAlignedNumbered", "All",
 CounterIncrements->"EquationNumbered"],
Cell[75480, 2728, 116, 2, 29, 59, 0, "StyleData", \
"EquationGroupAlignedNumbered", "Centered"],
Cell[75599, 2732, 107, 2, 27, 59, 0, "StyleData", \
"EquationGroupAlignedNumbered", "Printout"],
Cell[75709, 2736, 138, 3, 27, 67, 0, "StyleData", \
"EquationGroupAlignedNumbered", "CenteredPrintout"],
Cell[75850, 2741, 119, 2, 27, 71, 0, "StyleData", \
"EquationGroupAlignedNumbered", "DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[76006, 2748, 84, 2, 35, 33, 0, "StyleData", "EquationNumber", "All"],
Cell[76093, 2752, 73, 1, 35, 45, 0, "StyleData", "EquationNumber", \
"Centered"],
Cell[76169, 2755, 73, 1, 35, 45, 0, "StyleData", "EquationNumber", \
"Printout"],
Cell[76245, 2758, 81, 1, 35, 53, 0, "StyleData", "EquationNumber", \
"CenteredPrintout"],
Cell[76329, 2761, 85, 1, 35, 57, 0, "StyleData", "EquationNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[76463, 2768, 49, 0, 45, "Subsubsection"],
Cell[76515, 2770, 31, 0, 35, 31, 0, "StyleData", "EquationGrid", "All"],
Cell[76549, 2772, 32, 0, 35, 32, 0, "StyleData", "SplitEquation", "All"],
Cell[76584, 2774, 28, 0, 35, 28, 0, "StyleData", "Piecewise", "All"],
Cell[76615, 2776, 25, 0, 35, 25, 0, "StyleData", "Matrix", "All"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[76689, 2782, 38, 0, 30, "Subsection"],
Cell[76730, 2784, 179, 3, 35, 23, 0, "StyleData", "XRef", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[76946, 2792, 32, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[77003, 2796, 345, 9, 56, 34, 0, "StyleData", "BackmatterGroup", "All"],
Cell[77351, 2807, 46, 0, 56, 46, 0, "StyleData", "BackmatterGroup", \
"Centered"],
Cell[77400, 2809, 118, 3, 16, 46, 0, "StyleData", "BackmatterGroup", \
"Printout"],
Cell[77521, 2814, 126, 3, 16, 54, 0, "StyleData", "BackmatterGroup", \
"CenteredPrintout"],
Cell[77650, 2819, 130, 3, 16, 58, 0, "StyleData", "BackmatterGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[77817, 2827, 33, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[77875, 2831, 610, 17, 107, 39, 0, "StyleData", "AppendixSectionLabel", \
"All",
 CounterIncrements->"AppendixSectionLabel",
 CounterAssignments->{{"Section", 0}, {"AppendixEquation", 0}, {
   "FigureCaption", 0}, {"TableTitle", 0}}],
Cell[78488, 2850, 169, 5, 103, 51, 0, "StyleData", "AppendixSectionLabel", \
"Centered"],
Cell[78660, 2857, 99, 2, 88, 51, 0, "StyleData", "AppendixSectionLabel", \
"Printout"],
Cell[78762, 2861, 153, 4, 88, 59, 0, "StyleData", "AppendixSectionLabel", \
"CenteredPrintout"],
Cell[78918, 2867, 111, 2, 88, 63, 0, "StyleData", "AppendixSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[79066, 2874, 172, 5, 44, 40, 0, "StyleData", "AppendixSectionNumber", \
"All"],
Cell[79241, 2881, 110, 3, 44, 52, 0, "StyleData", "AppendixSectionNumber", \
"Centered"],
Cell[79354, 2886, 67, 1, 40, 52, 0, "StyleData", "AppendixSectionNumber", \
"Printout"],
Cell[79424, 2889, 97, 2, 40, 60, 0, "StyleData", "AppendixSectionNumber", \
"CenteredPrintout"],
Cell[79524, 2893, 79, 1, 40, 64, 0, "StyleData", "AppendixSectionNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[79640, 2899, 551, 15, 146, 34, 0, "StyleData", "AppendixSection", \
"All"],
Cell[80194, 2916, 164, 5, 152, 46, 0, "StyleData", "AppendixSection", \
"Centered"],
Cell[80361, 2923, 117, 3, 124, 46, 0, "StyleData", "AppendixSection", \
"Printout"],
Cell[80481, 2928, 173, 5, 124, 54, 0, "StyleData", "AppendixSection", \
"CenteredPrintout"],
Cell[80657, 2935, 129, 3, 124, 58, 0, "StyleData", "AppendixSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[80823, 2943, 260, 7, 29, 27, 0, "StyleData", "Appendix", "All",
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[81086, 2952, 39, 0, 29, 39, 0, "StyleData", "Appendix", "Centered"],
Cell[81128, 2954, 108, 3, 26, 39, 0, "StyleData", "Appendix", "Printout"],
Cell[81239, 2959, 116, 3, 26, 47, 0, "StyleData", "Appendix", \
"CenteredPrintout"],
Cell[81358, 2964, 142, 4, 26, 51, 0, "StyleData", "Appendix", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[81537, 2973, 758, 18, 38, 35, 0, "StyleData", "AppendixEquation", "All",
 CounterIncrements->"AppendixEquation"],
Cell[82298, 2993, 105, 2, 41, 47, 0, "StyleData", "AppendixEquation", \
"Centered"],
Cell[82406, 2997, 95, 2, 36, 47, 0, "StyleData", "AppendixEquation", \
"Printout"],
Cell[82504, 3001, 142, 3, 34, 55, 0, "StyleData", "AppendixEquation", \
"CenteredPrintout"],
Cell[82649, 3006, 107, 2, 36, 59, 0, "StyleData", "AppendixEquation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[82805, 3014, 58, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[82888, 3019, 354, 10, 214, 33, 0, "StyleData", "EndnoteSection", "All"],
Cell[83245, 3031, 314, 10, 212, 45, 0, "StyleData", "EndnoteSection", \
"Centered"],
Cell[83562, 3043, 94, 2, 118, 45, 0, "StyleData", "EndnoteSection", \
"Printout"],
Cell[83659, 3047, 148, 4, 174, 53, 0, "StyleData", "EndnoteSection", \
"CenteredPrintout"],
Cell[83810, 3053, 106, 2, 174, 57, 0, "StyleData", "EndnoteSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[83953, 3060, 317, 9, 31, 26, 0, "StyleData", "Endnote", "All",
 CounterIncrements->"Endnote"],
Cell[84273, 3071, 38, 0, 31, 38, 0, "StyleData", "Endnote", "Centered"],
Cell[84314, 3073, 110, 3, 38, 38, 0, "StyleData", "Endnote", "Printout"],
Cell[84427, 3078, 118, 3, 38, 46, 0, "StyleData", "Endnote", \
"CenteredPrintout"],
Cell[84548, 3083, 119, 3, 38, 50, 0, "StyleData", "Endnote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[84704, 3091, 300, 7, 35, 31, 0, "StyleData", "EndnoteLabel", "All",
 CounterIncrements->"EndnoteLabel"],
Cell[85007, 3100, 43, 0, 35, 43, 0, "StyleData", "EndnoteLabel", "Centered"],
Cell[85053, 3102, 71, 1, 35, 43, 0, "StyleData", "EndnoteLabel", "Printout"],
Cell[85127, 3105, 79, 1, 35, 51, 0, "StyleData", "EndnoteLabel", \
"CenteredPrintout"],
Cell[85209, 3108, 83, 1, 35, 55, 0, "StyleData", "EndnoteLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[85329, 3114, 120, 3, 35, 32, 0, "StyleData", "EndnoteNumber", "All",
 CounterIncrements->"EndnoteNumber"],
Cell[85452, 3119, 44, 0, 35, 44, 0, "StyleData", "EndnoteNumber", \
"Centered"],
Cell[85499, 3121, 72, 1, 35, 44, 0, "StyleData", "EndnoteNumber", \
"Printout"],
Cell[85574, 3124, 80, 1, 35, 52, 0, "StyleData", "EndnoteNumber", \
"CenteredPrintout"],
Cell[85657, 3127, 84, 1, 35, 56, 0, "StyleData", "EndnoteNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[85778, 3133, 222, 6, 35, 26, 0, "StyleData", "NoteKey", "All",
 ButtonStyleMenuListing->None],
Cell[86003, 3141, 38, 0, 35, 38, 0, "StyleData", "NoteKey", "Centered"],
Cell[86044, 3143, 64, 1, 35, 38, 0, "StyleData", "NoteKey", "Printout"],
Cell[86111, 3146, 72, 1, 35, 46, 0, "StyleData", "NoteKey", \
"CenteredPrintout"],
Cell[86186, 3149, 76, 1, 35, 50, 0, "StyleData", "NoteKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[86299, 3155, 232, 6, 35, 36, 0, "StyleData", "EndnoteReturnLink", "All",
 ButtonStyleMenuListing->None],
Cell[86534, 3163, 48, 0, 35, 48, 0, "StyleData", "EndnoteReturnLink", \
"Centered"],
Cell[86585, 3165, 113, 2, 35, 48, 0, "StyleData", "EndnoteReturnLink", \
"Printout"],
Cell[86701, 3169, 121, 2, 35, 56, 0, "StyleData", "EndnoteReturnLink", \
"CenteredPrintout"],
Cell[86825, 3173, 125, 2, 35, 60, 0, "StyleData", "EndnoteReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[86965, 3178, 361, 10, 35, 23, 0, "StyleData", "Note", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[87351, 3192, 375, 9, 35, 23, 0, "StyleData", "Note", "All"],
Cell[87729, 3203, 54, 1, 35, 35, 0, "StyleData", "Note", "Printout"],
Cell[87786, 3206, 66, 1, 35, 47, 0, "StyleData", "Note", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[87901, 3213, 35, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[87961, 3217, 499, 12, 214, 35, 0, "StyleData", "ReferenceSection", "All",
 
 CounterIncrements->"ReferenceSection",
 CounterAssignments->{{"ReferenceText", 0}, {"BiblioEquation", 0}}],
Cell[88463, 3231, 165, 5, 212, 47, 0, "StyleData", "ReferenceSection", \
"Centered"],
Cell[88631, 3238, 96, 2, 174, 47, 0, "StyleData", "ReferenceSection", \
"Printout"],
Cell[88730, 3242, 150, 4, 174, 55, 0, "StyleData", "ReferenceSection", \
"CenteredPrintout"],
Cell[88883, 3248, 108, 2, 174, 59, 0, "StyleData", "ReferenceSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[89028, 3255, 560, 16, 29, 28, 0, "StyleData", "Reference", "All",
 CounterIncrements->"BibliographyItem"],
Cell[89591, 3273, 40, 0, 29, 40, 0, "StyleData", "Reference", "Centered"],
Cell[89634, 3275, 131, 4, 28, 40, 0, "StyleData", "Reference", "Printout"],
Cell[89768, 3281, 139, 4, 28, 48, 0, "StyleData", "Reference", \
"CenteredPrintout"],
Cell[89910, 3287, 143, 4, 28, 52, 0, "StyleData", "Reference", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[90090, 3296, 243, 7, 35, 33, 0, "StyleData", "ReferenceLabel", "All",
 CounterIncrements->"RefDingbat"],
Cell[90336, 3305, 45, 0, 35, 45, 0, "StyleData", "ReferenceLabel", \
"Centered"],
Cell[90384, 3307, 73, 1, 35, 45, 0, "StyleData", "ReferenceLabel", \
"Printout"],
Cell[90460, 3310, 81, 1, 35, 53, 0, "StyleData", "ReferenceLabel", \
"CenteredPrintout"],
Cell[90544, 3313, 85, 1, 35, 57, 0, "StyleData", "ReferenceLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[90644, 3317, 95, 2, 35, 25, 0, "StyleData", "RefSep", "All"],
Cell[CellGroupData[{
Cell[90764, 3323, 403, 10, 37, 35, 0, "StyleData", "RefReturnPointer", "All",
 ButtonStyleMenuListing->None],
Cell[91170, 3335, 73, 1, 35, 47, 0, "StyleData", "RefReturnPointer", \
"Printout"],
Cell[91246, 3338, 85, 1, 35, 59, 0, "StyleData", "RefReturnPointer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[91368, 3344, 325, 8, 35, 32, 0, "StyleData", "RefReturnLink", "All",
 ButtonStyleMenuListing->None],
Cell[91696, 3354, 44, 0, 35, 44, 0, "StyleData", "RefReturnLink", \
"Centered"],
Cell[91743, 3356, 70, 1, 35, 44, 0, "StyleData", "RefReturnLink", \
"Printout"],
Cell[91816, 3359, 78, 1, 35, 52, 0, "StyleData", "RefReturnLink", \
"CenteredPrintout"],
Cell[91897, 3362, 82, 1, 35, 56, 0, "StyleData", "RefReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[92016, 3368, 374, 10, 24, 38, 0, "StyleData", "ReferenceSourceLink", \
"All",
 ButtonStyleMenuListing->None],
Cell[92393, 3380, 50, 0, 24, 50, 0, "StyleData", "ReferenceSourceLink", \
"Centered"],
Cell[92446, 3382, 76, 1, 35, 50, 0, "StyleData", "ReferenceSourceLink", \
"Printout"],
Cell[92525, 3385, 84, 1, 35, 58, 0, "StyleData", "ReferenceSourceLink", \
"CenteredPrintout"],
Cell[92612, 3388, 88, 1, 35, 62, 0, "StyleData", "ReferenceSourceLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[92715, 3392, 37, 0, 35, 37, 0, "StyleData", "ReferenceSourceURL", \
"All"],
Cell[CellGroupData[{
Cell[92777, 3396, 333, 8, 35, 27, 0, "StyleData", "Citation", "All",
 ButtonStyleMenuListing->None],
Cell[93113, 3406, 39, 0, 35, 39, 0, "StyleData", "Citation", "Centered"],
Cell[93155, 3408, 65, 1, 35, 39, 0, "StyleData", "Citation", "Printout"],
Cell[93223, 3411, 73, 1, 35, 47, 0, "StyleData", "Citation", \
"CenteredPrintout"],
Cell[93299, 3414, 77, 1, 35, 51, 0, "StyleData", "Citation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[93413, 3420, 220, 6, 35, 25, 0, "StyleData", "RefKey", "All",
 ButtonStyleMenuListing->None],
Cell[93636, 3428, 229, 6, 35, 37, 0, "StyleData", "RefKey", "Centered",
 ButtonStyleMenuListing->None],
Cell[93868, 3436, 63, 1, 35, 37, 0, "StyleData", "RefKey", "Printout"],
Cell[93934, 3439, 71, 1, 35, 45, 0, "StyleData", "RefKey", \
"CenteredPrintout"],
Cell[94008, 3442, 75, 1, 35, 49, 0, "StyleData", "RefKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[94120, 3448, 73, 1, 27, "Subsubsubsection"],
Cell[94196, 3451, 83, 1, 20, "ReferenceTemplate"],
Cell[94282, 3454, 86, 1, 20, "ReferenceTemplate"],
Cell[94371, 3457, 86, 1, 20, "ReferenceTemplate"],
Cell[94460, 3460, 82, 1, 20, "ReferenceTemplate"],
Cell[94545, 3463, 85, 1, 20, "ReferenceTemplate"],
Cell[94633, 3466, 84, 1, 20, "ReferenceTemplate"],
Cell[94720, 3469, 43, 0, 20, "ReferenceTemplate"],
Cell[94766, 3471, 49, 0, 20, "ReferenceTemplate"],
Cell[94818, 3473, 49, 0, 20, "ReferenceTemplate"],
Cell[94870, 3475, 49, 0, 20, "ReferenceTemplate"],
Cell[94922, 3477, 49, 0, 20, "ReferenceTemplate"],
Cell[94974, 3479, 56, 0, 20, "ReferenceTemplate"],
Cell[95033, 3481, 56, 0, 20, "ReferenceTemplate"],
Cell[CellGroupData[{
Cell[95114, 3485, 48, 0, 42, "Subsubsubsubsection"],
Cell[95165, 3487, 191, 4, 33, "ReferenceTemplate"],
Cell[95359, 3493, 152, 3, 20, "ReferenceTemplate"],
Cell[95514, 3498, 177, 3, 20, "ReferenceTemplate"],
Cell[95694, 3503, 139, 3, 20, "ReferenceTemplate"],
Cell[95836, 3508, 172, 3, 20, "ReferenceTemplate"],
Cell[96011, 3513, 136, 3, 20, "ReferenceTemplate"],
Cell[96150, 3518, 159, 3, 20, "ReferenceTemplate"],
Cell[96312, 3523, 123, 3, 20, "ReferenceTemplate"],
Cell[96438, 3528, 185, 4, 33, "ReferenceTemplate"],
Cell[96626, 3534, 146, 3, 20, "ReferenceTemplate"],
Cell[96775, 3539, 171, 3, 20, "ReferenceTemplate"],
Cell[96949, 3544, 133, 3, 20, "ReferenceTemplate"],
Cell[97085, 3549, 166, 3, 20, "ReferenceTemplate"],
Cell[97254, 3554, 130, 3, 20, "ReferenceTemplate"],
Cell[97387, 3559, 153, 3, 20, "ReferenceTemplate"],
Cell[97543, 3564, 117, 3, 20, "ReferenceTemplate"],
Cell[97663, 3569, 176, 4, 20, "ReferenceTemplate"],
Cell[97842, 3575, 137, 3, 20, "ReferenceTemplate"],
Cell[97982, 3580, 162, 3, 20, "ReferenceTemplate"],
Cell[98147, 3585, 124, 3, 20, "ReferenceTemplate"],
Cell[98274, 3590, 157, 3, 20, "ReferenceTemplate"],
Cell[98434, 3595, 121, 3, 20, "ReferenceTemplate"],
Cell[98558, 3600, 144, 3, 20, "ReferenceTemplate"],
Cell[98705, 3605, 106, 2, 20, "ReferenceTemplate"],
Cell[98814, 3609, 146, 3, 42, "Text"],
Cell[98963, 3614, 152, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[99152, 3622, 48, 0, 42, "Subsubsubsubsection"],
Cell[99203, 3624, 99, 2, 42, "Text"],
Cell[99305, 3628, 144, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[99486, 3636, 51, 0, 42, "Subsubsubsubsection"],
Cell[99540, 3638, 138, 3, 20, "ReferenceTemplate"],
Cell[99681, 3643, 99, 2, 20, "ReferenceTemplate"],
Cell[99783, 3647, 117, 3, 20, "ReferenceTemplate"],
Cell[99903, 3652, 143, 3, 42, "Text"],
Cell[100049, 3657, 85, 1, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[100171, 3663, 47, 0, 42, "Subsubsubsubsection"],
Cell[100221, 3665, 168, 3, 20, "ReferenceTemplate"],
Cell[100392, 3670, 133, 3, 20, "ReferenceTemplate"],
Cell[100528, 3675, 148, 3, 42, "Text"],
Cell[100679, 3680, 168, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[100884, 3688, 57, 0, 42, "Subsubsubsubsection"],
Cell[100944, 3690, 105, 3, 42, "Text"],
Cell[101052, 3695, 125, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[101214, 3703, 54, 0, 42, "Subsubsubsubsection"],
Cell[101271, 3705, 107, 3, 42, "Text"],
Cell[101381, 3710, 105, 2, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[101523, 3717, 49, 0, 42, "Subsubsubsubsection"],
Cell[101575, 3719, 103, 3, 42, "Text"],
Cell[101681, 3724, 87, 1, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[101805, 3730, 55, 0, 42, "Subsubsubsubsection"],
Cell[101863, 3732, 127, 3, 42, "Text"],
Cell[101993, 3737, 58, 0, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[102088, 3742, 45, 0, 42, "Subsubsubsubsection"],
Cell[102136, 3744, 97, 2, 42, "Text"],
Cell[102236, 3748, 44, 0, 20, "ReferenceTemplate"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[102329, 3754, 77, 1, 43, "Subsubsubsection"],
Cell[102409, 3757, 98, 2, 35, 27, 0, "StyleData", "RefTitle", "All"],
Cell[102510, 3761, 46, 1, 20, 26, 0, "StyleData", "RefType", "All"],
Cell[102559, 3764, 25, 0, 35, 25, 0, "StyleData", "RefURL", "All"],
Cell[102587, 3766, 35, 0, 35, 35, 0, "StyleData", "RefRetrievalDate", "All"],
Cell[102625, 3768, 38, 0, 35, 38, 0, "StyleData", "RefSourceOfAbstract", \
"All"],
Cell[102666, 3770, 37, 0, 35, 37, 0, "StyleData", "RefInsertedBibText", \
"All"],
Cell[102706, 3772, 26, 0, 35, 26, 0, "StyleData", "RefNote", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[102769, 3777, 75, 1, 43, "Subsubsubsection"],
Cell[102847, 3780, 102, 2, 35, 31, 0, "StyleData", "RefBookTitle", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[102986, 3787, 78, 1, 43, "Subsubsubsection"],
Cell[103067, 3790, 34, 0, 35, 34, 0, "StyleData", "RefJournalTitle", "All"],
Cell[103104, 3792, 105, 2, 35, 35, 0, "StyleData", "RefJournalVolume", \
"All"],
Cell[103212, 3796, 35, 0, 35, 35, 0, "StyleData", "RefJournalNumber", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[103284, 3801, 80, 1, 43, "Subsubsubsection"],
Cell[103367, 3804, 31, 0, 35, 31, 0, "StyleData", "RefPublisher", "All"],
Cell[103401, 3806, 47, 1, 35, 26, 0, "StyleData", "RefCity", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[103485, 3812, 77, 1, 43, "Subsubsubsection"],
Cell[103565, 3815, 33, 0, 35, 33, 0, "StyleData", "RefAuthorGroup", "All"],
Cell[103601, 3817, 30, 0, 35, 30, 0, "StyleData", "RefAuthorFN", "All"],
Cell[103634, 3819, 30, 0, 35, 30, 0, "StyleData", "RefAuthorLN", "All"],
Cell[103667, 3821, 30, 0, 35, 30, 0, "StyleData", "RefAuthorMN", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[103734, 3826, 77, 1, 43, "Subsubsubsection"],
Cell[103814, 3829, 33, 0, 35, 33, 0, "StyleData", "RefEditorGroup", "All"],
Cell[103850, 3831, 30, 0, 35, 30, 0, "StyleData", "RefEditorFN", "All"],
Cell[103883, 3833, 30, 0, 35, 30, 0, "StyleData", "RefEditorMN", "All"],
Cell[103916, 3835, 30, 0, 35, 30, 0, "StyleData", "RefEditorLN", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[103983, 3840, 77, 1, 43, "Subsubsubsection"],
Cell[104063, 3843, 28, 0, 35, 28, 0, "StyleData", "RefSchool", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[104128, 3848, 87, 1, 43, "Subsubsubsection"],
Cell[104218, 3851, 25, 0, 35, 25, 0, "StyleData", "RefDay", "All"],
Cell[104246, 3853, 27, 0, 35, 27, 0, "StyleData", "RefMonth", "All"],
Cell[104276, 3855, 26, 0, 35, 26, 0, "StyleData", "RefYear", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[104339, 3860, 114, 2, 43, "Subsubsubsection"],
Cell[104456, 3864, 52, 1, 35, 31, 0, "StyleData", "RefFirstPage", "All"],
Cell[104511, 3867, 51, 1, 35, 30, 0, "StyleData", "RefLastPage", "All"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[104623, 3875, 35, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[104683, 3879, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[104740, 3883, 778, 20, 107, 35, 0, "StyleData", "BookChapterLabel", \
"All",
 CounterIncrements->"BookChapterLabel",
 CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"EquationNumbered", 0}, {"FigureCaption", 0}, {
   "PictureCaption", 0}, {"ProgramCaption", 0}, {"TableTitle", 0}, {
   "Figure", 0}, {"Picture", 0}, {"Program", 0}, {"Table", 0}}],
Cell[105521, 3905, 165, 5, 103, 47, 0, "StyleData", "BookChapterLabel", \
"Centered"],
Cell[105689, 3912, 95, 2, 88, 47, 0, "StyleData", "BookChapterLabel", \
"Printout"],
Cell[105787, 3916, 149, 4, 88, 55, 0, "StyleData", "BookChapterLabel", \
"CenteredPrintout"],
Cell[105939, 3922, 107, 2, 88, 59, 0, "StyleData", "BookChapterLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[106083, 3929, 168, 5, 44, 36, 0, "StyleData", "BookChapterNumber", \
"All"],
Cell[106254, 3936, 106, 3, 44, 48, 0, "StyleData", "BookChapterNumber", \
"Centered"],
Cell[106363, 3941, 63, 1, 40, 48, 0, "StyleData", "BookChapterNumber", \
"Printout"],
Cell[106429, 3944, 93, 2, 40, 56, 0, "StyleData", "BookChapterNumber", \
"CenteredPrintout"],
Cell[106525, 3948, 75, 1, 40, 60, 0, "StyleData", "BookChapterNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[106637, 3954, 376, 10, 143, 35, 0, "StyleData", "BookChapterTitle", \
"All"],
Cell[107016, 3966, 165, 5, 152, 47, 0, "StyleData", "BookChapterTitle", \
"Centered"],
Cell[107184, 3973, 118, 3, 124, 47, 0, "StyleData", "BookChapterTitle", \
"Printout"],
Cell[107305, 3978, 174, 5, 124, 55, 0, "StyleData", "BookChapterTitle", \
"CenteredPrintout"],
Cell[107482, 3985, 130, 3, 124, 59, 0, "StyleData", "BookChapterTitle", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[107661, 3994, 58, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[107744, 3999, 200, 5, 51, 27, 0, "StyleData", "Epigraph", "All"],
Cell[107947, 4006, 39, 0, 51, 39, 0, "StyleData", "Epigraph", "Centered"],
Cell[107989, 4008, 89, 2, 47, 39, 0, "StyleData", "Epigraph", "Printout"],
Cell[108081, 4012, 97, 2, 47, 47, 0, "StyleData", "Epigraph", \
"CenteredPrintout"],
Cell[108181, 4016, 123, 3, 47, 51, 0, "StyleData", "Epigraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[108341, 4024, 168, 3, 55, 33, 0, "StyleData", "EpigraphAuthor", "All"],
Cell[108512, 4029, 45, 0, 63, 45, 0, "StyleData", "EpigraphAuthor", \
"Centered"],
Cell[108560, 4031, 96, 2, 57, 45, 0, "StyleData", "EpigraphAuthor", \
"Printout"],
Cell[108659, 4035, 104, 2, 57, 53, 0, "StyleData", "EpigraphAuthor", \
"CenteredPrintout"],
Cell[108766, 4039, 108, 2, 57, 57, 0, "StyleData", "EpigraphAuthor", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[108935, 4048, 41, 0, 30, "Subsection"],
Cell[108979, 4050, 94, 3, 32, 25, 0, "StyleData", "Header", "All"],
Cell[109076, 4055, 93, 3, 30, 25, 0, "StyleData", "Footer", "All"],
Cell[109172, 4060, 76, 2, 32, 29, 0, "StyleData", "PageNumber", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[109285, 4067, 35, 0, 30, "Subsection"],
Cell[109323, 4069, 255, 5, 35, 34, 0, "StyleData", "TextSuperscript", "All"],
Cell[109581, 4076, 182, 4, 35, 32, 0, "StyleData", "TextSubscript", "All"],
Cell[109766, 4082, 22, 0, 35, 22, 0, "StyleData", "Nil", "All"],
Cell[109791, 4084, 27, 0, 35, 27, 0, "StyleData", "Verbatim", "All"],
Cell[109821, 4086, 103, 2, 35, 26, 0, "StyleData", "TeXName", "All"],
Cell[109927, 4090, 107, 2, 35, 28, 0, "StyleData", "LaTeXName", "All"],
Cell[110037, 4094, 109, 2, 35, 29, 0, "StyleData", "LaTeXeName", "All"],
Cell[110149, 4098, 86, 2, 35, 34, 0, "StyleData", "ChemicalElement", "All"],
Cell[110238, 4102, 63, 1, 35, 34, 0, "StyleData", "CustomCharacter", "All"],
Cell[110304, 4105, 26, 0, 35, 26, 0, "StyleData", "Palette", "All"],
Cell[CellGroupData[{
Cell[110355, 4109, 547, 16, 7, 28, 0, "StyleData", "PageBreak", "All"],
Cell[110905, 4127, 116, 3, 12, 40, 0, "StyleData", "PageBreak", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[111058, 4135, 147, 5, 51, 31, 0, "StyleData", "CreationDate", "All"],
Cell[111208, 4142, 111, 3, 23, 43, 0, "StyleData", "CreationDate", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[111356, 4150, 42, 0, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[111423, 4154, 121, 3, 19, 29, 0, "StyleData", "SingleLine", "All"],
Cell[111547, 4159, 133, 3, 19, 41, 0, "StyleData", "SingleLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[111717, 4167, 230, 7, 21, 29, 0, "StyleData", "DoubleLine", "All"],
Cell[111950, 4176, 88, 2, 19, 41, 0, "StyleData", "DoubleLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[112075, 4183, 253, 8, 12, 27, 0, "StyleData", "ThinLine", "All"],
Cell[112331, 4193, 39, 0, 12, 39, 0, "StyleData", "ThinLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[112407, 4198, 253, 8, 14, 29, 0, "StyleData", "MediumLine", "All"],
Cell[112663, 4208, 41, 0, 14, 41, 0, "StyleData", "MediumLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[112741, 4213, 252, 8, 15, 28, 0, "StyleData", "ThickLine", "All"],
Cell[112996, 4223, 40, 0, 15, 40, 0, "StyleData", "ThickLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[113073, 4228, 73, 1, 35, 25, 0, "StyleData", "Spacer", "All"],
Cell[113149, 4231, 37, 0, 35, 37, 0, "StyleData", "Spacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[113223, 4236, 29, 0, 35, 29, 0, "StyleData", "TextSpacer", "All"],
Cell[113255, 4238, 41, 0, 35, 41, 0, "StyleData", "TextSpacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[113333, 4243, 32, 0, 35, 32, 0, "StyleData", "SectionSpacer", "All"],
Cell[113368, 4245, 44, 0, 35, 44, 0, "StyleData", "SectionSpacer", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[113449, 4250, 33, 0, 35, 33, 0, "StyleData", "GraphicsSpacer", "All"],
Cell[113485, 4252, 45, 0, 35, 45, 0, "StyleData", "GraphicsSpacer", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[113579, 4258, 29, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[113633, 4262, 325, 10, 145, 30, 0, "StyleData", "VitaSection", "All",
 ButtonStyleMenuListing->None],
Cell[113961, 4274, 182, 6, 142, 42, 0, "StyleData", "VitaSection", \
"Centered"],
Cell[114146, 4282, 91, 2, 123, 42, 0, "StyleData", "VitaSection", \
"Printout"],
Cell[114240, 4286, 145, 4, 123, 50, 0, "StyleData", "VitaSection", \
"CenteredPrintout"],
Cell[114388, 4292, 103, 2, 123, 54, 0, "StyleData", "VitaSection", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[114540, 4300, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[114597, 4304, 447, 12, 47, 27, 0, "StyleData", "Outline1", "All",
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}}],
Cell[115047, 4318, 86, 2, 43, 39, 0, "StyleData", "Outline1", "Printout"],
Cell[115136, 4322, 98, 2, 43, 51, 0, "StyleData", "Outline1", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[115271, 4329, 104, 3, 35, 32, 0, "StyleData", "Outline1Label", "All"],
Cell[115378, 4334, 72, 1, 35, 44, 0, "StyleData", "Outline1Label", \
"Printout"],
Cell[115453, 4337, 84, 1, 35, 56, 0, "StyleData", "Outline1Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[115574, 4343, 469, 13, 42, 27, 0, "StyleData", "Outline2", "All",
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}}],
Cell[116046, 4358, 87, 2, 41, 39, 0, "StyleData", "Outline2", "Printout"],
Cell[116136, 4362, 99, 2, 41, 51, 0, "StyleData", "Outline2", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[116272, 4369, 104, 3, 35, 32, 0, "StyleData", "Outline2Label", "All"],
Cell[116379, 4374, 72, 1, 35, 44, 0, "StyleData", "Outline2Label", \
"Printout"],
Cell[116454, 4377, 84, 1, 35, 56, 0, "StyleData", "Outline2Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[116575, 4383, 415, 11, 40, 27, 0, "StyleData", "Outline3", "All",
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}}],
Cell[116993, 4396, 87, 2, 39, 39, 0, "StyleData", "Outline3", "Printout"],
Cell[117083, 4400, 99, 2, 39, 51, 0, "StyleData", "Outline3", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[117219, 4407, 104, 3, 35, 32, 0, "StyleData", "Outline3Label", "All"],
Cell[117326, 4412, 72, 1, 35, 44, 0, "StyleData", "Outline3Label", \
"Printout"],
Cell[117401, 4415, 84, 1, 35, 56, 0, "StyleData", "Outline3Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[117522, 4421, 393, 10, 38, 27, 0, "StyleData", "Outline4", "All",
 CounterIncrements->"Outline4"],
Cell[117918, 4433, 87, 2, 38, 39, 0, "StyleData", "Outline4", "Printout"],
Cell[118008, 4437, 99, 2, 38, 51, 0, "StyleData", "Outline4", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[118144, 4444, 104, 3, 35, 32, 0, "StyleData", "Outline4Label", "All"],
Cell[118251, 4449, 72, 1, 35, 44, 0, "StyleData", "Outline4Label", \
"Printout"],
Cell[118326, 4452, 84, 1, 35, 56, 0, "StyleData", "Outline4Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[118447, 4458, 213, 5, 34, 30, 0, "StyleData", "OutlineText", "All",
 CounterIncrements->"Text"],
Cell[118663, 4465, 135, 4, 32, 42, 0, "StyleData", "OutlineText", \
"Printout"],
Cell[118801, 4471, 147, 4, 32, 54, 0, "StyleData", "OutlineText", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[118997, 4481, 35, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[119057, 4485, 1077, 29, 11, 41, 0, "StyleData", \
"SlideShowNavigationBar", "All",
 CounterIncrements->"SlideShowNavigationBar",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[120137, 4516, 193, 5, 25, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[120367, 4526, 285, 9, 49, 33, 0, "StyleData", "SlideHyperlink", "All",
 ButtonStyleMenuListing->None],
Cell[120655, 4537, 115, 2, 35, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"],
Cell[120773, 4541, 123, 2, 35, 53, 0, "StyleData", "SlideHyperlink", \
"CenteredPrintout"],
Cell[120899, 4545, 127, 2, 35, 57, 0, "StyleData", "SlideHyperlink", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[121087, 4554, 35, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[121147, 4558, 73, 1, 45, "Subsubsection"],
Cell[121223, 4561, 64, 2, 35, 21, 0, "StyleData", "RM", "All"],
Cell[121290, 4565, 91, 2, 35, 21, 0, "StyleData", "BF", "All"],
Cell[121384, 4569, 129, 3, 35, 21, 0, "StyleData", "IT", "All"],
Cell[121516, 4574, 152, 3, 31, 28, 0, "StyleData", "SmallCaps", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[121705, 4582, 79, 1, 45, "Subsubsection"],
Cell[121787, 4585, 86, 3, 35, 21, 0, "StyleData", "TR", "All"],
Cell[121876, 4590, 173, 5, 35, 21, 0, "StyleData", "TI", "All"],
Cell[122052, 4597, 171, 5, 35, 21, 0, "StyleData", "TB", "All"],
Cell[122226, 4604, 183, 5, 35, 22, 0, "StyleData", "TBI", "All"],
Cell[122412, 4611, 260, 7, 36, 21, 0, "StyleData", "MR", "All"],
Cell[122675, 4620, 271, 7, 36, 21, 0, "StyleData", "MO", "All"],
Cell[122949, 4629, 269, 7, 36, 21, 0, "StyleData", "MB", "All"],
Cell[123221, 4638, 287, 8, 36, 22, 0, "StyleData", "MBO", "All"],
Cell[123511, 4648, 176, 5, 35, 21, 0, "StyleData", "SR", "All"],
Cell[123690, 4655, 187, 5, 36, 21, 0, "StyleData", "SO", "All"],
Cell[123880, 4662, 185, 5, 36, 21, 0, "StyleData", "SB", "All"],
Cell[124068, 4669, 203, 6, 36, 22, 0, "StyleData", "SBO", "All"],
Cell[124274, 4677, 122, 2, 35, 32, 0, "StyleData", "PlainGreekWin", "All"],
Cell[124399, 4681, 114, 2, 39, 32, 0, "StyleData", "PlainGreekMac", "All"],
Cell[124516, 4685, 114, 2, 39, 32, 0, "StyleData", "PlainGreekLin", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[124667, 4692, 35, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[124727, 4696, 364, 9, 35, 28, 0, "StyleData", "Hyperlink", "All",
 ButtonStyleMenuListing->None],
Cell[125094, 4707, 120, 3, 34, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[125251, 4715, 263, 7, 35, 29, 0, "StyleData", "XMLWebLink", "All",
 ButtonStyleMenuListing->None],
Cell[125517, 4724, 106, 2, 35, 41, 0, "StyleData", "XMLWebLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[125660, 4731, 53, 0, 27, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[125738, 4735, 278, 7, 35, 32, 0, "StyleData", "UserGuideLink", "All",
 ButtonStyleMenuListing->None],
Cell[126019, 4744, 109, 2, 35, 44, 0, "StyleData", "UserGuideLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[126165, 4751, 278, 7, 35, 32, 0, "StyleData", "ReferenceLink", "All",
 ButtonStyleMenuListing->None],
Cell[126446, 4760, 109, 2, 35, 44, 0, "StyleData", "ReferenceLink", \
"Printout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[126628, 4770, 28, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[126681, 4774, 67, 1, 45, "Subsubsection"],
Cell[126751, 4777, 304, 7, 117, "Text"],
Cell[127058, 4786, 290, 9, 52, 33, 0, "StyleData", "CellExpression", "All"],
Cell[127351, 4797, 78, 2, 36, 28, 0, "StyleData", "InputForm", "All"],
Cell[127432, 4801, 132, 4, 41, 29, 0, "StyleData", "OutputForm", "All"],
Cell[127567, 4807, 80, 2, 36, 31, 0, "StyleData", "StandardForm", "All"],
Cell[127650, 4811, 149, 4, 35, 34, 0, "StyleData", "TraditionalForm", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[127836, 4820, 56, 0, 45, "Subsubsection"],
Cell[127895, 4822, 122, 3, 42, 36, 0, "StyleData", "ReferenceTemplate", \
"All"],
Cell[128020, 4827, 136, 3, 42, 50, 0, "StyleData", \
"AuthorFormCustomizationTemplate", "All"],
Cell[128159, 4832, 119, 3, 42, 33, 0, "StyleData", "CSSDefinitions", "All"],
Cell[128281, 4837, 118, 3, 42, 32, 0, "StyleData", "LaTeXPreamble", "All"],
Cell[128402, 4842, 118, 3, 42, 32, 0, "StyleData", "DOCTYPEFormat", "All"],
Cell[128523, 4847, 122, 3, 42, 36, 0, "StyleData", "ValidationSetting", \
"All"],
Cell[128648, 4852, 124, 3, 42, 38, 0, "StyleData", "XRefPaletteSettings", \
"All"],
Cell[128775, 4857, 117, 3, 42, 31, 0, "StyleData", "MiscSettings", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[128929, 4865, 62, 1, 45, "Subsubsection"],
Cell[128994, 4868, 116, 5, 87, "Text"],
Cell[129113, 4875, 84, 2, 35, 29, 0, "StyleData", "InlineCell", "All"],
Cell[129200, 4879, 89, 1, 51, 36, 0, "StyleData", "InlineCellEditing", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[129326, 4885, 57, 1, 45, "Subsubsection"],
Cell[129386, 4888, 122, 5, 87, "Text"],
Cell[129511, 4895, 191, 4, 39, 24, 0, "StyleData", "Paste", "All",
 ButtonStyleMenuListing->Automatic],
Cell[129705, 4901, 161, 3, 35, 29, 0, "StyleData", "StyleApply", "All",
 ButtonStyleMenuListing->Automatic],
Cell[129869, 4906, 218, 5, 35, 45, 0, "StyleData", \
"StyleApplyWithVerification", "All",
 ButtonStyleMenuListing->Automatic],
Cell[130090, 4913, 286, 6, 35, 35, 0, "StyleData", "ConvertCharacter", "All",
 ButtonStyleMenuListing->Automatic]
}, Closed]],
Cell[CellGroupData[{
Cell[130413, 4924, 59, 1, 45, "Subsubsection"],
Cell[130475, 4927, 330, 9, 132, "Text"],
Cell[130808, 4938, 82, 1, 35, 35, 0, "StyleData", "UnmatchedBracket", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[130927, 4944, 63, 1, 45, "Subsubsection"],
Cell[130993, 4947, 159, 4, 2067, 55, 0, "StyleData", \
"DialogStyleSheetMisapplicationEscape", "All"]
}, Closed]]
}, Closed]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
