(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    211031,       7383]
NotebookOptionsPosition[    138204,       5494]
NotebookOutlinePosition[    138905,       5522]
CellTagsIndexPosition[    138794,       5516]
MenuPosition->0
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[StyleData[StyleDefinitions -> "Default.nb"]],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style. 
Make modifications to any definition using commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["TeX Configuration", "Section"],

Cell["\<\

\\documentclass{book}

\\usepackage{graphicx,amscd,amsmath,amssymb,verbatim}
\\usepackage[dvips]{hyperref}
\\usepackage{textcomp}
\\usepackage[OT1,T1]{fontenc}
\
\>", "Text",
 ShowCellTags->True,
 CellTags->"TeXPreamble"]
}, Closed]],

Cell[CellGroupData[{

Cell["CSS", "Section"],

Cell["\<\
<style type=\"text/css\">
/* global */
body { margin: 10pt; background-color: #FFFFFF; }

p.NoSpace { margin: 0pt }

img { vertical-align: middle;  } 

/* Frontmatter */

h1 { margin: 20pt 2pt 4pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 21pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: center;
\tcolor: #000000;
\t}

.Subtitle { margin: 4pt 2pt 4pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 16pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: center;
\tcolor: #000000;
\t}

.Subsubtitle { margin: 4pt 2pt 4pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 14pt;
\tfont-weight: normal;
\tfont-style: italic;
\ttext-align: center;
\tcolor: #000000;
\t}

.Date { margin: 3pt 2pt 3pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 13pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: center;
\tcolor: #000000;
\t}

.Author { margin: 18pt 2pt 0pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 13pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: center;
\tcolor: #000000;
\t}

.AbstractSection { margin: 2pt 42pt 2pt 42pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 9pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: center;
\tcolor: #000000;
\ttext-indent: 9pt;
\t}

.Abstract { margin: 5pt 42pt 5pt 42pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 9pt;
\tfont-weight: normal;
\tfont-style: normal;
\tcolor: #000000;
\ttext-indent: 9pt;
\ttext-align: justify;
\t}

.AbstractContinuation { margin: 5pt 42pt 5pt 42pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 9pt;
\tfont-weight: normal;
\tfont-style: normal;
\tcolor: #000000;
\ttext-align: justify;
\t}

.AbstractMath, {
\tmargin: 7pt 2pt 5pt 2pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 9pt;
\tfont-weight: normal; 
\ttext-align: center; 
\tfont-style: normal; 
\tcolor: #000000;
\t}

.TOCBookFrontmatterHeading, .TOCBookBackmatterHeading, 
.TOCBookFrontBackHeading, .TOCBookChapterTitle, 
\t{ margin: 1pt 2pt 1pt 2pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.TOCBookSection, .TOCBookFigure, .TOCBookSupplemental, 
.TOCBookPicture, .TOCBookIllustration, .TOCBookProgram, 
.TOCBookTable
\t{ margin: 1pt 2pt 1pt 24pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.TOCBookSubsection
\t{ margin: 1pt 2pt 1pt 48pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.TOCBookPageNumber
\t{
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\t}

.TOCBookSpacer
\t{ margin: 0pt 2pt 0pt 2pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.TOCBookHeading, .TOCBookIllustrations, .TOCBookTables, 
.AppendixSection, .EndnoteSection, .ReferenceSection
\t{ margin: 48pt 2pt 14pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 27pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.TOCBookPartTitle, 
\t{ margin: 1pt 2pt 1pt 2pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 12pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

table.TOC {
\twidth: 98%;
\tmargin: 0pt 0pt 0pt 0pt;
\tpadding: 0pt 0pt 0pt 0pt;
\t }

td.TOCPage { 
\twidth: 4%; 
\ttext-align: right;
\t}

/* mainmatter */

h3 { margin: 27pt 2pt 16pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 16pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

h4 { margin: 23pt 2pt 12pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 13pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

h5 { margin: 20pt 2pt 12pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 10pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.Subsubsubsection {
\tfont-family: Times New Roman, Times;
\tfont-size: 10pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.Text { margin: 2pt 2pt 2pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\ttext-indent: 10pt;
\ttext-align: justify;
\t}

.TextNoIndent, .TextContinuation, .SubsubsubsectionText { margin: 2pt 2pt 2pt \
2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\ttext-align: justify;
\t}

/* Itemized Lists */

li { margin: 3pt 2pt 3pt 2pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size:10pt;
\t}

ul, ol { margin-left:18pt; margin-top: 3pt; margin-bottom: 3pt; }
ul ul, ul ul ul, ol ol, ol ol ol { margin-left:18pt }

ul { list-style: disc; }

ol ol { list-style: lower-alpha; }

ol ol ol{ list-style: lower-roman; }

.Item1Paragraph, .Item2Paragraph, .Item3Paragraph { margin-top: 3pt \
margin-bottom: 3pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

/* Illustrations */

.Figure, .Picture, .Graphics { margin: 7pt 2pt 7pt 2pt; }

.FigureCaption { margin: 3pt 2pt 7pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 9pt;
\tfont-weight: normal;
\tfont-style: normal;
\tcolor: #000000;
\ttext-align: justify;
\t}

table { margin: 1pt 2pt 1pt 2pt; }

table.TableMasterGrid { width:100%; 
\tmargin: 3pt 2pt 3pt 2pt;
\tborder-bottom: 1pt solid #000000;
\tborder-top: 1pt solid #000000;
\t}

table.TableMasterGrid td.TableLineElement {
\tborder-bottom: solid 1pt #000000;
\tfont-size: 1pt;
\tpadding: 0pt;
\tmargin:0pt;
\tline-height: 0pt;
\t}

.TableTitle { margin: 7pt 2pt 12pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\ttext-indent: 12pt;
\t}

.TableNote { margin: 0pt 2pt 6pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 7pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.TableColumnHead, .TableSpanHead { 
\tfont-family: Times New Roman, Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: italic; 
\tcolor: #000000;
\t}

.TableText, .TableSpanText {
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal; 
\tcolor: #000000;
\t}

/* mathematics */

.Equation, .EquationWide, 
.EquationNumbered, .EquationWideNumbered, 
.AppendixEquation,
.EquationGroupAlignedNumbered, .EquationGroupAligned,
.EquationGroupNumbered, .EquationGroup {
\tmargin: 7pt 2pt 7pt 2pt;
\tfont-family: \"Times New Roman\", Times;
\tfont-size: 10pt;
\tfont-weight: normal; 
\ttext-align: center; 
\tfont-style: normal; 
\tcolor: #000000;
\t}

table.EquationNumbered {
\twidth: 100%;
\t}

table.AppendixEquation {
\twidth: 100%;
\t}

table.AppendixEquation td.AppendixEquationLabel {
\twidth: 4%;
\tfont-size: 10pt;
\tpadding: 0pt;
\t}

table.EquationNumbered td.EquationNumberedLabel {
\twidth: 4%;
\tfont-size: 10pt;
\tpadding: 0pt;
\t}

table.EquationGroup,
table.EquationGroupNumbered {
\twidth: 100%;
\tpadding-top: 0pt;
\tpadding-bottom: 0pt;
\tmargin-top: 0pt;
\tmargin-bottom: 0pt;
\t}

p.EquationGroup {
\tpadding-left: 4.5%;
\t}

table.EquationGroupNumbered td.EquationGroupNumberedLabel {
\twidth: 4%;
\tfont-size: 10pt;
\tpadding: 0pt;
\t}

.EquationGroupAligned table {
\twidth: 100%;
\tpadding-top: 0pt;
\tpadding-bottom: 0pt;
\tpadding-left: 4.5%;
\tmargin-top: 0pt;
\tmargin-bottom: 0pt;
\t}

.EquationGroupAligned table td,
.EquationGroupAligned table th {
\tpadding: 0pt;
\t}

table.EquationGroupAlignedNumbered {
\twidth: 100%;
\tpadding-top: 0pt;
\tpadding-bottom: 0pt;
\tmargin-top: 0pt;
\tmargin-bottom: 0pt;
\t}

table.EquationGroupAlignedNumbered td,
table.EquationGroupAlignedNumbered th {
\tpadding: 0pt;
\t}

table.EquationGroupAlignedNumbered td.EquationGroupAlignedNumberedLabel {
\twidth: 4%;
\tfont-size: 10pt;
\tpadding: 0pt;
\t}

/* Cross-References */

.XRef { color: #000000; text-decoration:none }
.DkBlue { color: #000080; }

/* Backmatter */

.Reference, .Endnote { margin: 1pt 2pt 1pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

td.EndnoteLabel { width: 32px; }
td.ReferenceLabel { width: 32px; }

.RefJournalVolume { font-weight:bold; }
.RefTitle,.RefBookTitle { font-style:italic; }

/* Book Elements */

.BookPartLabel { margin: 72pt 2pt 7pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 27pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: center;
\tcolor: #000000;
\t}

.BookPartTitle { margin: 7pt 2pt 14pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 32pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: center;
\tcolor: #000000;
\t}

.BookChapterLabel { margin: 48pt 2pt 7pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 21pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

.BookChapterTitle { margin: 7pt 2pt 14pt 2pt;
\tfont-family: Times New Roman, Times;
\tfont-size: 27pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}

/* miscellaneous */

.PageBreak { page-break-before:always; }

/* Common Inline */

.RM  { font-style: normal; font-weight: normal }
.BF  { font-style: normal; font-weight: bold }
.IT  { font-style: italic; font-weight: normal }
.TR  { font-family: \"Times New Roman\", Times; font-style: normal; \
font-weight: normal }
.TI  { font-family: \"Times New Roman\", Times; font-style: italic; \
font-weight: normal }
.TB  { font-family: \"Times New Roman\", Times; font-style: normal; \
font-weight: bold }
.TBI { font-family: \"Times New Roman\", Times; font-style: italic; \
font-weight: bold }
.MR  { font-family: \"Courier New\", Courier; font-style: normal; \
font-weight: normal }
.MO  { font-family: \"Courier New\", Courier; font-style: italic; \
font-weight: normal }
.MB  { font-family: \"Courier New\", Courier; font-style: normal; \
font-weight: normal }
.MBO { font-family: \"Courier New\", Courier; font-style: italic; \
font-weight: bold }
.SR  { font-family: Helvetica, Arial; font-style: normal; font-weight: normal \
}
.SO  { font-family: Helvetica, Arial; font-style: italic; font-weight: normal \
}
.SB  { font-family: Helvetica, Arial; font-style: normal; font-weight: bold }
.SBO { font-family: Helvetica, Arial; font-style: italic; font-weight: bold }

/* conformance */

.Input { margin: 7pt 12pt 7pt 48pt;
\tfont-family: Courier New, Courier;
\tfont-size: 10pt;
\tfont-weight: bold;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}
.Output { margin: 7pt 12pt 7pt 48pt;
\tfont-family: Courier New, Courier;
\tfont-size: 10pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #000000;
\t}
.CellLabel { margin: 7pt 2pt 2pt 24pt;
\tfont-family: Helvetica, Arial;
\tfont-size: 7pt;
\tfont-weight: normal;
\tfont-style: normal;
\ttext-align: left;
\tcolor: #0000ff;
\t}

</style>\
\>", "Text",
 CellTags->"CSSDefinitions"]
}, Closed]],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Screen"],
 CellBracketOptions->{"Color"->RGBColor[0, 0.2, 1]},
 ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
 PageWidth->WindowWidth,
 ScrollingOptions->{"PagewiseDisplay"->True},
 ShowCellBracket->False,
 ShowGroupOpenCloseIcon->True,
 CellLabelMargins->{{24, Inherited}, {Inherited, Inherited}},
 ScriptMinSize->12],

Cell[StyleData[All, "Printout"],
 PageWidth->PaperWidth,
 Hyphenation->True,
 PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "DoubleSpacedPrintout"],
 PageWidth->PaperWidth,
 Hyphenation->True,
 LineSpacing->{2, 1},
 PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
  The options defined for the style below will be used at the Notebook level. \
\
\>", "Text"],

Cell[StyleData["Notebook"],
 PageHeaders->{{None, 
    Cell[
     TextData[{
       ValueBox["FileName"]}], "Header"], None}, {None, 
    Cell[
     TextData[{
       ValueBox["FileName"]}], "Header"], None}},
 PageFooters->{{None, 
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"], None}, {None, 
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"], None}},
 PageHeaderLines->{False, False},
 PrintingOptions->{"FacingPages"->True,
 "FirstPageFooter"->True,
 "FirstPageHeader"->False,
 "PageFooterMargins"->{54, 54},
 "PageHeaderMargins"->{104, 104},
 "PrintingMargins"->{{106, 106}, {108, 132}},
 "RestPagesFooter"->True,
 "RestPagesHeader"->True},
 CellElementSpacings->{"ClosedCellHeight"->9},
 CellLabelAutoDelete->False,
 CellFrameLabelMargins->6,
 SpanMaxSize->Infinity,
 SpanCharacterRounding->Round,
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Frontmatter", "Section"],

Cell[CellGroupData[{

Cell[StyleData["FrontmatterGroup"],
 Editable->False,
 CellMargins->{{12, 10}, {7, 24}},
 CellGroupingRules->{"SectionGrouping", 5},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["FrontmatterGroup", "Presentation"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["FrontmatterGroup", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["FrontmatterGroup", "DoubleSpacedPrintout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["Table of Contents", "Subsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell["Book", "Subsubsection"],

Cell[CellGroupData[{

Cell["Title Headings", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookHeading"],
 CellMargins->{{12, 12}, {14, 48}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"\n\n\\tableofcontents", 
     NoOutput[], ""}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->{{0, 0}, {3, 0}},
 LineSpacing->{1, 2},
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookHeading", "Printout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontColor->GrayLevel[0]],

Cell[StyleData["TOCBookHeading", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustrations"],
 CellMargins->{{12, 12}, {14, 48}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"\n\n\\listoffigures", 
     NoOutput[], ""}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->{{0, 0}, {3, 0}},
 LineSpacing->{1, 2},
 CounterAssignments->{{"TOCBookItem", 0}},
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookIllustrations", "Printout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontColor->GrayLevel[0]],

Cell[StyleData["TOCBookIllustrations", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTables"],
 CellMargins->{{12, 12}, {14, 48}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"\n\n\\listoftables", 
     NoOutput[], ""}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->{{0, 0}, {3, 0}},
 LineSpacing->{1, 2},
 CounterAssignments->{{"TOCBookItem", 0}},
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookTables", "Printout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontColor->GrayLevel[0]],

Cell[StyleData["TOCBookTables", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contents Headings", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFrontmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCBookFrontmatterHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookFrontmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookTable", 0}},
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["TOCBookFrontmatterHeading", "Printout"],
 CellMargins->{{22, 2}, {1, 1}},
 TabSpacings->47.14,
 FontSize->10],

Cell[StyleData["TOCBookFrontmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {1, 1}},
 TabSpacings->47.14,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookBackmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCBookBackmatterHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookBackmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookTable", 0}},
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["TOCBookBackmatterHeading", "Printout"],
 CellMargins->{{22, 2}, {1, 1}},
 TabSpacings->47.14,
 FontSize->10],

Cell[StyleData["TOCBookBackmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {1, 1}},
 TabSpacings->47.14,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFrontBackHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCBookFrontBackHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookFrontBackHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookTable", 0}},
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["TOCBookFrontBackHeading", "Printout"],
 CellMargins->{{22, 2}, {1, 1}},
 TabSpacings->47.14,
 FontSize->10],

Cell[StyleData["TOCBookFrontBackHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {1, 1}},
 TabSpacings->47.14,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPartTitle"],
 CellMargins->{{36, 12}, {1, 12}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookPartTitle'><span \
class='Ignore'>Part `1` &nbsp;</span>", "TOCBookPartTitle"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Part ", 
       CounterBox["TOCBookPartTitle"]}], "TOCBookPartTitleLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"TOCBookPartTitle",
 CounterAssignments->{{"TOCBookChapterTitle", 0}},
 StyleMenuListing->None,
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookPartTitle", "Printout"],
 CellMargins->{{22, 2}, {0, 10}}],

Cell[StyleData["TOCBookPartTitle", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 10}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookChapterTitle"],
 CellMargins->{{12, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookChapterTitle'><span \
class='Ignore'>`1` &nbsp;</span>", "TOCBookChapterTitle"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"]}], "TOCBookChapterTitleLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->54,
 CounterIncrements->"TOCBookChapterTitle",
 CounterAssignments->{{"TOCBookSection", 0}},
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["TOCBookChapterTitle", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->47.14,
 FontSize->10],

Cell[StyleData["TOCBookChapterTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->47.14,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSection"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookSection'><span \
class='Ignore'>`1`.`2` &nbsp;</span>", "TOCBookChapterTitle", 
      "TOCBookSection"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"], ".", 
       CounterBox["TOCBookSection"]}], "TOCBookSectionLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->49.87,
 CounterIncrements->"TOCBookSection",
 CounterAssignments->{{"TOCBookSubsection", 0}},
 StyleMenuListing->None],

Cell[StyleData["TOCBookSection", "Printout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->42.9,
 FontSize->10],

Cell[StyleData["TOCBookSection", "DoubleSpacedPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->42.9,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSubsection"],
 CellMargins->{{60, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 60},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookSubsection'><span \
class='Ignore'>`1`.`2`.`3` &nbsp;</span>", "TOCBookChapterTitle", 
      "TOCBookSection", "TOCBookSubsection"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"], ".", 
       CounterBox["TOCBookSection"], ".", 
       CounterBox["TOCBookSubsection"]}], "TOCBookSubsectionLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->45.8,
 CounterIncrements->"TOCBookSubsection",
 StyleMenuListing->None],

Cell[StyleData["TOCBookSubsection", "Printout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->37.85,
 FontSize->10],

Cell[StyleData["TOCBookSubsection", "DoubleSpacedPrintout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->37.85,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFigure"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookFigure'><span \
class='Ignore'>Fig. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookFigure"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Fig. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookFigure"], "."}], "TOCBookFigureLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->50.2,
 CounterIncrements->"TOCBookFigure",
 StyleMenuListing->None],

Cell[StyleData["TOCBookFigure", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->43.4,
 FontSize->10],

Cell[StyleData["TOCBookFigure", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->43.4,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTable"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {
     IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookTable'><span \
class='Ignore'>Table `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookTable"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Table ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookTable"], "."}], "TOCBookTableLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->50.2,
 CounterIncrements->"TOCBookTable",
 StyleMenuListing->None],

Cell[StyleData["TOCBookTable", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->43.4,
 FontSize->10],

Cell[StyleData["TOCBookTable", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->43.4,
 FontSize->10]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Labels and misc", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSpacer"],
 CellMargins->{{12, 12}, {0, 0}},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[StyleData["TOCBookSpacer", "Printout"],
 CellMargins->{{2, 2}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPartTitleLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{42, Inherited},
 StyleMenuListing->None],

Cell[StyleData["TOCBookPartTitleLabel", "Printout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookChapterTitleLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{18, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCBookChapterTitleLabel", "Printout"],
 CellSize->{14, Inherited}],

Cell[StyleData["TOCBookChapterTitleLabel", "DoubleSpacedPrintout"],
 CellSize->{14, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{32, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCBookSectionLabel", "Printout"],
 CellSize->{24, Inherited}],

Cell[StyleData["TOCBookSectionLabel", "DoubleSpacedPrintout"],
 CellSize->{24, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSubsectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{44, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCBookSubsectionLabel", "Printout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookSubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFigureLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{53, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCBookFigureLabel", "Printout"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCBookFigureLabel", "DoubleSpacedPrintout"],
 CellSize->{42, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTableLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{53, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["TOCBookTableLabel", "Printout"],
 CellSize->{42, Inherited}],

Cell[StyleData["TOCBookTableLabel", "DoubleSpacedPrintout"],
 CellSize->{42, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookLeader"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 TabFilling->". ",
 StyleMenuListing->None,
 FontSize->12,
 FontWeight->"Plain"],

Cell[StyleData["TOCBookLeader", "Printout"],
 FontSize->10],

Cell[StyleData["TOCBookLeader", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPageNumber"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {
    "</p></td><td class=\"TOCBookPage\"><p class=\"TOCBookPageNumber\">", 
     "</p>"}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TOCBookPageNumber", "Printout"],
 CellSize->{21, Inherited}],

Cell[StyleData["TOCBookPageNumber", "DoubleSpacedPrintout"],
 CellSize->{21, Inherited}]
}, Closed]]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mainmatter", "Section"],

Cell[CellGroupData[{

Cell[StyleData["MainmatterGroup"],
 Editable->False,
 CellMargins->{{12, 10}, {7, 24}},
 CellGroupingRules->{"SectionGrouping", 5},
 ConversionRules:>{"TeX" -> {"\n\\maketitle", 
     NoOutput[], ""}, "HTML" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["MainmatterGroup", "Presentation"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["MainmatterGroup", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["MainmatterGroup", "DoubleSpacedPrintout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellMargins->{{12, 12}, {16, 27}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"\\section{", Automatic, "}\n"}, "HTML" -> {
     IncludeCount[
     "<h3 class='Section'><span class='Ignore'>`1`.`2` &nbsp;</span>", 
      "BookChapterLabel", "Section"], "</h3>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "Section"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Section"}},
 PageBreakBelow->False,
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["Section"]}], "SectionLabel", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 TextAlignment->Left,
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}},
 StyleMenuListing->None,
 FontSize->18,
 FontWeight->"Plain"],

Cell[StyleData["Section", "Presentation"],
 CellMargins->{{12, 12}, {24, 41}},
 FontSize->27,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["Section", "Printout"],
 CellMargins->{{2, 2}, {14, 24}},
 FontSize->16,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["Section", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {14, 24}},
 FontSize->16,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
 CellDingbat->None,
 CellMargins->{{12, 12}, {12, 23}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"\\subsection{", Automatic, "}\n"}, "HTML" -> {
     IncludeCount[
     "<h4 class='Subsection'><span class='Ignore'>`1`.`2`.`3` &nbsp;</span>", 
      "BookChapterLabel", "Section", "Subsection"], "</h4>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {
      "BookChapterLabel", ".", "Section", ".", "Subsection"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Section"}},
 PageBreakBelow->False,
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["Section"], ".", 
       CounterBox["Subsection"]}], "SubsectionLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->6,
 TextAlignment->Left,
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}},
 StyleMenuListing->None,
 FontSize->15,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
 CellMargins->{{12, 12}, {18, 35}},
 FontSize->22,
 FontColor->GrayLevel[0]],

Cell[StyleData["Subsection", "Printout"],
 CellMargins->{{2, 2}, {10, 20}},
 FontSize->13,
 FontColor->GrayLevel[0]],

Cell[StyleData["Subsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {10, 20}},
 FontSize->13,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
 CellMargins->{{12, 12}, {12, 20}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{
  "TeX" -> {"\\subsubsection{", Automatic, "}\n"}, 
   "HTML" -> {"<h5 class=\"Subsubsection\">", Automatic, "</h5>"}},
 PageBreakBelow->False,
 TextAlignment->Left,
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsubsection", 0}},
 StyleMenuListing->None,
 FontWeight->"Bold",
 FontSlant->"Plain",
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Subsubsection", "Presentation"],
 CellMargins->{{12, 12}, {18, 30}},
 FontSize->18,
 FontColor->GrayLevel[0]],

Cell[StyleData["Subsubsection", "Printout"],
 CellMargins->{{2, 2}, {10, 18}},
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["Subsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {10, 18}},
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsubsection"],
 CellMargins->{{12, 12}, {12, 20}},
 ConversionRules:>{
  "TeX" -> {"\\paragraph{", Automatic, "}"}, 
   "HTML" -> {"<span class=\"Subsubsubsection\">", Automatic, "</span>"}},
 StyleMenuListing->None,
 FontWeight->"Bold",
 FontSlant->"Plain",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Subsubsubsection", "Presentation"],
 CellMargins->{{12, 12}, {18, 30}},
 FontSize->18],

Cell[StyleData["Subsubsubsection", "Printout"],
 CellMargins->{{2, 2}, {10, 18}},
 FontSize->10],

Cell[StyleData["Subsubsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {10, 18}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Section Heading Inline Cells", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["SectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{40, Inherited},
 StyleMenuListing->None],

Cell[StyleData["SectionLabel", "Presentation"],
 CellSize->{60, Inherited}],

Cell[StyleData["SectionLabel", "Printout"],
 CellSize->{35, Inherited}],

Cell[StyleData["SectionLabel", "DoubleSpacedPrintout"],
 CellSize->{35, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CellSize->{50, Inherited},
 StyleMenuListing->None],

Cell[StyleData["SubsectionLabel", "Presentation"],
 CellSize->{75, Inherited}],

Cell[StyleData["SubsectionLabel", "Printout"],
 CellSize->{45, Inherited}],

Cell[StyleData["SubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{45, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[StyleData["SubsubsectionLabel", "Presentation"]],

Cell[StyleData["SubsubsectionLabel", "Printout"]],

Cell[StyleData["SubsubsectionLabel", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsubsectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None,
 FontSlant->"Plain"],

Cell[StyleData["SubsubsubsectionLabel", "Presentation"]],

Cell[StyleData["SubsubsubsectionLabel", "Printout"]],

Cell[StyleData["SubsubsubsectionLabel", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsubsectionText"],
 CellMargins->{{12, 10}, {2, 2}},
 CellGroupingRules->{"SectionGrouping", 60},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->{"SubsubsubsectionText", "SubsubsubsectionHeader"},
 StyleMenuListing->None,
 FontSize->12],

Cell[StyleData["SubsubsubsectionText", "Presentation"],
 CellMargins->{{12, 10}, {3, 3}},
 FontSize->17],

Cell[StyleData["SubsubsubsectionText", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10],

Cell[StyleData["SubsubsubsectionText", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Alternate Headings", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["SectionAlt"],
 CellMargins->{{12, 12}, {16, 27}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "TeX" -> {"\\section*{", Automatic, "}\n"}, 
   "HTML" -> {"<h3 class=\"Section\">", Automatic, "</h3>"}},
 PageBreakBelow->False,
 TextAlignment->Left,
 StyleMenuListing->None,
 FontSize->18,
 FontWeight->"Plain"],

Cell[StyleData["SectionAlt", "Presentation"],
 CellMargins->{{12, 12}, {24, 41}},
 FontSize->27,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["SectionAlt", "Printout"],
 CellMargins->{{2, 2}, {14, 24}},
 FontSize->16,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["SectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {14, 24}},
 FontSize->16,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionAlt"],
 CellDingbat->None,
 CellMargins->{{12, 12}, {12, 23}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{
  "TeX" -> {"\\subsection*{", Automatic, "}\n"}, 
   "HTML" -> {"<h4 class=\"Subsection\">", Automatic, "</h4>"}},
 PageBreakBelow->False,
 CellFrameLabelMargins->6,
 TextAlignment->Left,
 StyleMenuListing->None,
 FontSize->15,
 FontWeight->"Bold"],

Cell[StyleData["SubsubsectionAlt", "Presentation"],
 CellMargins->{{12, 12}, {18, 35}},
 FontSize->18,
 FontColor->GrayLevel[0]],

Cell[StyleData["SubsectionAlt", "Printout"],
 CellMargins->{{2, 2}, {10, 20}},
 FontSize->13,
 FontColor->GrayLevel[0]],

Cell[StyleData["SubsectionAlt", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {10, 20}},
 FontSize->13,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Body Text", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{12, 10}, {2, 2}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 ParagraphIndent->12,
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Text", "Presentation"],
 CellMargins->{{12, 10}, {3, 3}},
 ParagraphIndent->18,
 FontSize->17],

Cell[StyleData["Text", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10],

Cell[StyleData["Text", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextNoIndent"],
 CellMargins->{{12, 10}, {2, 2}},
 ConversionRules:>{
  "TeX" -> {{"\\noindent ", Automatic, ""}, {
     "\n\n\\noindent ", Automatic, ""}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["TextNoIndent", "Presentation"],
 CellMargins->{{12, 10}, {3, 3}},
 FontSize->17],

Cell[StyleData["TextNoIndent", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10],

Cell[StyleData["TextNoIndent", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextContinuation"],
 CellMargins->{{12, 10}, {2, 2}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n", Automatic, ""}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["TextContinuation", "Presentation"],
 CellMargins->{{12, 10}, {3, 3}},
 FontSize->17],

Cell[StyleData["TextContinuation", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10],

Cell[StyleData["TextContinuation", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Itemized Lists", "Section"],

Cell[CellGroupData[{

Cell["Bulleted Lists", "Subsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1"],
 CellMargins->{{12, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\item ", Automatic, ""}, 
   "HTML" -> {"<li>", Automatic, "</li>"}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 30}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item1Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item1",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Item1", "Presentation"],
 CellMargins->{{23, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2"],
 CellMargins->{{36, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\item ", Automatic, ""}, 
   "HTML" -> {"<li>", Automatic, "</li>"}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 40}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item2Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item2",
 CounterAssignments->{{"Item3Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Item2", "Presentation"],
 CellMargins->{{59, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2", "Printout"],
 CellMargins->{{20, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item2", "DoubleSpacedPrintout"],
 CellMargins->{{20, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3"],
 CellMargins->{{60, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\item ", Automatic, ""}, 
   "HTML" -> {"<li>", Automatic, "</li>"}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 50}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "Item3Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item3",
 StyleMenuListing->None],

Cell[StyleData["Item3", "Presentation"],
 CellMargins->{{95, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3", "Printout"],
 CellMargins->{{40, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item3", "DoubleSpacedPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1Label"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"", 
     NoOutput[], ""}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["Item1Label", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1Label", "Printout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Label"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"", 
     NoOutput[], ""}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["Item2Label", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2Label", "Printout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None],

Cell[StyleData["Item2Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Label"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"", 
     NoOutput[], ""}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["Item3Label", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3Label", "Printout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None],

Cell[StyleData["Item3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Lists", "Subsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Numbered"],
 CellMargins->{{12, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\item ", Automatic, ""}, 
   "HTML" -> {"<li>", Automatic, "</li>"}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 30}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item1Numbered"], "."}], "Item1NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Item1Numbered", "Presentation"],
 CellMargins->{{23, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1Numbered", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Numbered"],
 CellMargins->{{36, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\item ", Automatic, ""}, 
   "HTML" -> {"<li>", Automatic, "</li>"}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 40}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{"(", 
       CounterBox["Item2Numbered"], ")"}], "Item2NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item2Numbered",
 CounterAssignments->{{"Item3Numbered", 0}},
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Item2Numbered", "Presentation"],
 CellMargins->{{59, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2Numbered", "Printout"],
 CellMargins->{{20, 2}, {1, 2}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item2Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{20, 2}, {1, 2}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Numbered"],
 CellMargins->{{60, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\item ", Automatic, ""}, 
   "HTML" -> {"<li>", Automatic, "</li>"}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 50}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item3Numbered"], "."}], "Item3NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item3Numbered",
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>RomanNumeral}],

Cell[StyleData["Item3Numbered", "Presentation"],
 CellMargins->{{95, 12}, {2, 3}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3Numbered", "Printout"],
 CellMargins->{{40, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item3Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1NumberedLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"<!--", Automatic, "-->"}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["Item1NumberedLabel", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1NumberedLabel", "Printout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2NumberedLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"<!--", Automatic, "-->"}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["Item2NumberedLabel", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2NumberedLabel", "Printout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None],

Cell[StyleData["Item2NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3NumberedLabel"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"<!--", Automatic, "-->"}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["Item3NumberedLabel", "Presentation"],
 CellSize->{36, Inherited},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3NumberedLabel", "Printout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None],

Cell[StyleData["Item3NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["List Paragraphs", "Subsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Paragraph"],
 CellMargins->{{40, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}},
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Item1Paragraph", "Presentation"],
 CellMargins->{{63, 12}, {2, 2}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item1Paragraph", "Printout"],
 CellMargins->{{24, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item1Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Paragraph"],
 CellMargins->{{64, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}},
 CounterAssignments->{{"Item3Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Item2Paragraph", "Presentation"],
 CellMargins->{{99, 12}, {2, 2}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item2Paragraph", "Printout"],
 CellMargins->{{42, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item2Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{42, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Paragraph"],
 CellMargins->{{88, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}},
 StyleMenuListing->None],

Cell[StyleData["Item3Paragraph", "Presentation"],
 CellMargins->{{135, 12}, {2, 2}},
 StyleMenuListing->None,
 FontSize->17],

Cell[StyleData["Item3Paragraph", "Printout"],
 CellMargins->{{62, 2}, {1, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Item3Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{62, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Illustrations and Examples", "Section"],

Cell[CellGroupData[{

Cell["Figure", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Figure"],
 Editable->False,
 CellMargins->{{12, 12}, {7, 7}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\begin{center}", 
     ExtractFigure[], "\n\\end{center}"}},
 TaggingRules:>{
  "CounterSettings" -> {"CounterTarget" -> "Style:FigureCaption"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakWithin->False,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 TextAlignment->Center,
 LanguageCategory->None,
 CounterIncrements->"Figure",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->10],

Cell[StyleData["Figure", "Presentation"],
 ImageMargins->{{12, 12}, {9, 9}},
 Magnification->1.5],

Cell[StyleData["Figure", "Printout"],
 ImageMargins->{{2, 2}, {6, 6}},
 Magnification->0.8],

Cell[StyleData["Figure", "DoubleSpacedPrintout"],
 ImageMargins->{{2, 2}, {6, 6}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FigureCaption"],
 CellMargins->{{12, 12}, {7, 3}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", "}"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "Figure"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Figure"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 TextAlignment->Center,
 TextJustification->1,
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["FigureCaption", "Presentation"],
 CellMargins->{{12, 12}, {10, 5}},
 TextJustification->1,
 FontSize->14],

Cell[StyleData["FigureCaption", "Printout"],
 CellMargins->{{2, 2}, {6, 2}},
 TextJustification->1,
 FontSize->9],

Cell[StyleData["FigureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 2}},
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[StyleData["FigureCaptionLabel"],
 Editable->False,
 CellGroupingRules->{"GraphicsGrouping", 0},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Table"],
 Editable->False,
 PageWidth->WindowWidth,
 CellMargins->{{12, 10}, {1, 1}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\begin{center}", Automatic, "\n\\end{center}"}, 
   "HTML" -> {{"", Automatic, ""}, {"", Automatic, ""}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "TableTitle"}, 
     "CounterTarget" -> "CellGroup"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> "table"}}},
 CellHorizontalScrolling->True,
 CounterIncrements->"Table",
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {False, {False}, False}, "ColumnsIndexed" -> {}, 
   "Rows" -> {True, {False}, True}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.503]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["Table", "Presentation"],
 CellMargins->{{12, 10}, {2, 2}},
 FontSize->17],

Cell[StyleData["Table", "Printout"],
 PageWidth->PaperWidth,
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10],

Cell[StyleData["Table", "DoubleSpacedPrintout"],
 PageWidth->PaperWidth,
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableTitle"],
 CellMargins->{{14, 12}, {12, 7}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", Automatic, "}"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "TableTitle"}, 
     "CounterTarget" -> "CellGroup", "XRefPrefix" -> "Table"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "table"}}},
 TextAlignment->Center,
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitle",
 CounterAssignments->{{"Nil", 0}},
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitle", "Presentation"],
 CellMargins->{{12, 12}, {18, 9}},
 FontSize->17],

Cell[StyleData["TableTitle", "Printout"],
 CellMargins->{{2, 2}, {10, 6}},
 FontSize->10],

Cell[StyleData["TableTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {10, 6}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableTitleLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 CounterIncrements->"TableTitle",
 StyleMenuListing->None],

Cell[StyleData["TableTitleLabel", "Presentation"],
 FontSize->17],

Cell[StyleData["TableTitleLabel", "Printout"],
 FontSize->10],

Cell[StyleData["TableTitleLabel", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Styles for Tables", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableColumnHead"],
 Editable->True,
 CounterIncrements->"Table",
 StyleMenuListing->None,
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.56]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableColumnHead", "Presentation"],
 FontSize->17],

Cell[StyleData["TableColumnHead", "Printout"],
 FontSize->10],

Cell[StyleData["TableColumnHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanHead"],
 Editable->True,
 TextAlignment->Center,
 StyleMenuListing->None,
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.56]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableSpanHead", "Presentation"],
 FontSize->17],

Cell[StyleData["TableSpanHead", "Printout"],
 FontSize->10],

Cell[StyleData["TableSpanHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableText"],
 Editable->True,
 TextAlignment->Left,
 LineSpacing->{1, 1},
 StyleMenuListing->None,
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.56]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableText", "Presentation"],
 FontSize->17],

Cell[StyleData["TableText", "Printout"],
 FontSize->10],

Cell[StyleData["TableText", "DoubleSpacedPrintout"],
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanText"],
 Editable->True,
 TextAlignment->Center,
 LineSpacing->{1, 1},
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableSpanText", "Presentation"],
 FontSize->17],

Cell[StyleData["TableSpanText", "Printout"],
 FontSize->10],

Cell[StyleData["TableSpanText", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[StyleData["TableSubGrid"],
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{0.1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.56]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.28]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["TableMasterGrid"],
 StyleMenuListing->None,
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.56]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.004]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableLineElement"],
 Editable->False,
 CellFrame->{{0, 0}, {0.5, 0}},
 CellElementSpacings->{"CellMinHeight"->1},
 ConversionRules:>{"HTML" -> {{"&nbsp;", 
      NoOutput[], ""}, {"", Automatic, ""}}},
 CellSize->{Inherited, 1.25},
 TabFilling->" ",
 TabSpacings->1000,
 StyleMenuListing->None,
 FontSize->1],

Cell[StyleData["TableBlankElement"],
 Editable->False,
 CellElementSpacings->{"CellMinHeight"->1},
 CellSize->{Inherited, 1.25},
 StyleMenuListing->None,
 FontSize->1],

Cell[CellGroupData[{

Cell[StyleData["SpanLeft"],
 Editable->False,
 StyleMenuListing->None,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanLeft", "Presentation"],
 FontSize->24],

Cell[StyleData["SpanLeft", "Printout"],
 FontSize->14],

Cell[StyleData["SpanLeft", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanCenter"],
 Editable->False,
 StyleMenuListing->None,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanCenter", "Presentation"],
 FontSize->24],

Cell[StyleData["SpanCenter", "Printout"],
 FontSize->14],

Cell[StyleData["SpanCenter", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanRight"],
 Editable->False,
 StyleMenuListing->None,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanRight", "Presentation"],
 FontSize->24],

Cell[StyleData["SpanRight", "Printout"],
 FontSize->14],

Cell[StyleData["SpanRight", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematics", "Section"],

Cell[CellGroupData[{

Cell["Equations", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Equation"],
 CellMargins->{{12, 12}, {7, 7}},
 ConversionRules:>{"HTML" -> {{"", ""}, {"<p class=\"Equation\">", "</p>"}}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"Equation",
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["Equation", "Presentation"],
 CellMargins->{{22, 12}, {10, 10}},
 FontSize->19],

Cell[StyleData["Equation", "Printout"],
 CellMargins->{{2, 2}, {5, 5}},
 FontSize->10],

Cell[StyleData["Equation", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroup"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 1, "Numbered" -> False}, 
     "TeX" -> {"CellGroupEnvironment" -> "gather*"}}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroup", "Presentation"],
 CellMargins->{{22, 12}, {0, 3}},
 FontSize->19],

Cell[StyleData["EquationGroup", "Printout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroup", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAligned"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 1, "Numbered" -> False}, 
     "TeX" -> {"CellGroupEnvironment" -> "align*"}}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAligned", "Presentation"],
 CellMargins->{{22, 12}, {0, 3}},
 FontSize->19],

Cell[StyleData["EquationGroupAligned", "Printout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupAligned", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Equations", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["EquationNumbered"],
 CellMargins->{{12, 12}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationNumbered'><tr><td>", Automatic, 
      IncludeCount[
      "</td><td class='EquationNumberedLabel'>(`1`.`2`)</td></tr></table>", 
       "BookChapterLabel", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {"General" -> {"Numbered" -> True}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationNumbered", "Presentation"],
 CellMargins->{{22, 12}, {10, 10}},
 FontSize->19],

Cell[StyleData["EquationNumbered", "Printout"],
 CellMargins->{{2, 2}, {5, 5}},
 FontSize->10],

Cell[StyleData["EquationNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupNumbered"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationGroupNumbered'><tr><td>", Automatic, 
      IncludeCount[
      "</td><td   \
class='EquationGroupNumberedLabel'>(`1`.`2`)</td></tr></table>", 
       "BookChapterLabel", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {
    "General" -> {"Numbered" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "gather"}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroupNumbered", "Presentation"],
 CellMargins->{{22, 12}, {0, 3}},
 FontSize->19],

Cell[StyleData["EquationGroupNumbered", "Printout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAlignedNumbered"],
 CellMargins->{{12, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationGroupNumbered'><tr><td>", Automatic, 
      IncludeCount[
      "</td><td   \
class='EquationGroupNumberedLabel'>(`1`.`2`)</td></tr></table>", 
       "BookChapterLabel", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {
    "General" -> {"Numbered" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "align"}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterLabel"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None,
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAlignedNumbered", "Presentation"],
 CellMargins->{{22, 12}, {0, 3}},
 FontSize->19],

Cell[StyleData["EquationGroupAlignedNumbered", "Printout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupAlignedNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None],

Cell[StyleData["EquationNumber", "Presentation"],
 CellSize->{54, Inherited}],

Cell[StyleData["EquationNumber", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EquationNumber", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equation Grid Tag Styles", "Subsection"],

Cell[StyleData["EquationGrid"],
 StyleMenuListing->None],

Cell[StyleData["SplitEquation"],
 StyleMenuListing->None],

Cell[StyleData["Piecewise"],
 StyleMenuListing->None],

Cell[StyleData["Matrix"],
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cross-References", "Section"],

Cell[StyleData["XRef"],
 ConversionRules:>{"TeX" -> {"\\ref{", 
     ExtractButtonData["CounterTag"], "}"}, 
   "HTML" -> {"", XRefToHtmlHyperlink, ""}},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Backmatter", "Section"],

Cell[CellGroupData[{

Cell[StyleData["BackmatterGroup"],
 Editable->False,
 CellMargins->{{12, 10}, {7, 24}},
 CellGroupingRules->{"SectionGrouping", 5},
 ConversionRules:>{{"TeX" -> {"\n\n\\appendix", 
      NoOutput[], ""}}, {"HTML" -> {"", 
      NoOutput[], ""}}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["BackmatterGroup", "Presentation"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["BackmatterGroup", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["BackmatterGroup", "DoubleSpacedPrintout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["AppendixSection"],
 CellMargins->{{12, 12}, {14, 7}},
 ConversionRules:>{
  "TeX" -> {"\\chapter{", Automatic, "}\n"}, 
   "HTML" -> {"<h3 class=\"AppendixSection\">", Automatic, "</h3>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"AppendixSection"}, "CounterTarget" -> "CellGroup"}},
 PageBreakBelow->False,
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSection", "Printout"],
 CellMargins->{{2, 2}, {12, 6}},
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {12, 6}},
 FontSize->27,
 FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixSectionLabel"],
 CellMargins->{{12, 12}, {7, 48}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 TextAlignment->Left,
 CounterIncrements->"AppendixSectionLabel",
 CounterAssignments->{{"Section", 0}, {"AppendixEquation", 0}, {
   "FigureCaption", 0}, {"TableTitle", 0}},
 StyleMenuListing->None,
 FontSize->24,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["AppendixSectionLabel", "Printout"],
 CellMargins->{{2, 2}, {6, 42}},
 FontSize->21,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSectionLabel", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 42}},
 FontSize->21,
 FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Appendix"],
 CellMargins->{{12, 10}, {2, 2}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 ParagraphIndent->12,
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Appendix", "Presentation"],
 CellMargins->{{12, 10}, {3, 3}},
 ParagraphIndent->18,
 FontSize->17],

Cell[StyleData["Appendix", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10],

Cell[StyleData["Appendix", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixEquation"],
 CellMargins->{{26, 6}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='AppendixEquation'><tr><td>", Automatic, 
      IncludeCount[
      "</td><td class='AppendixEquationLabel'>(`1``2`)</td></tr></table>", 
       "AppendixSection", "AppendixEquation"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"AppendixSection", "", "AppendixEquation"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["AppendixSectionLabel"], 
       CounterBox["AppendixEquation"], ")"}]]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"AppendixEquation",
 StyleMenuListing->None],

Cell[StyleData["AppendixEquation", "Printout"],
 FontSize->10],

Cell[StyleData["AppendixEquation", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Endnotes", "Subsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["EndnoteSection"],
 CellMargins->{{12, 12}, {14, 48}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {"<h3 class=\"EndnoteSection\">", Automatic, "</h3>"}},
 PageBreakBelow->False,
 DefaultNewInlineCellStyle->"None",
 LineSpacing->{1, 7},
 LanguageCategory->"NaturalLanguage",
 SpanSymmetric->True,
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}, {
   "Endnote", 0}},
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "Printout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Endnote"],
 CellMargins->{{12, 10}, {2, 2}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"", 
      NoOutput[], ""}}, 
   "HTML" -> {
    "<table class=\"Endnote\"><tr valign=\"top\">", "</td></tr></table>"}},
 Hyphenation->True,
 LineSpacing->{1, 2},
 ParagraphIndent->-38,
 CounterIncrements->"Endnote",
 StyleMenuListing->None],

Cell[StyleData["Endnote", "Presentation"],
 CellMargins->{{12, 10}, {3, 3}},
 FontSize->17],

Cell[StyleData["Endnote", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 FontSize->10],

Cell[StyleData["Endnote", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteLabel"],
 ConversionRules:>{"HTML" -> {"<td class=\"EndnoteLabel\" align=\"right\">", 
     ConvertTextSubOrSuperscriptToHTML["sup"], "&nbsp;</td><td>"}},
 CellSize->{36, Inherited},
 TextAlignment->Right,
 SpanMaxSize->1,
 CounterIncrements->"EndnoteLabel",
 StyleMenuListing->None],

Cell[StyleData["EndnoteLabel", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right,
 CounterIncrements->"EndnoteNumber",
 StyleMenuListing->None],

Cell[StyleData["EndnoteNumber", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NoteKey"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(EditNote[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["NoteKey", "Presentation"],
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["NoteKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["NoteKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteReturnLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["EndnoteReturnLink", "Presentation"],
 FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["EndnoteReturnLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]],

Cell[StyleData["EndnoteReturnLink", "DoubleSpacedPrintout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Note"],
 Editable->False,
 Deletable->False,
 ConversionRules:>{"TeX" -> {{"\\footnote{", Convert[
       ExtractButtonData[1][#]]& , "}"}, {"", Automatic, ""}}, 
   "HTML" -> {"", 
     ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SpanMaxSize->1,
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Note", "Printout"],
 ScriptMinSize->8],

Cell[StyleData["Note", "DoubleSpacedPrintout"],
 ScriptMinSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSection"],
 CellMargins->{{12, 12}, {14, 48}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, 
   "HTML" -> {"<h3 class=\"ReferenceSection\">", Automatic, "</h3>"}},
 PageBreakBelow->False,
 CounterIncrements->"ReferenceSection",
 CounterAssignments->{{"ReferenceText", 0}, {"BiblioEquation", 0}},
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "Printout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {12, 42}},
 FontSize->27,
 FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
 CellMargins->{{18, 10}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "TeX" -> {"", Automatic, ""}, 
   "HTML" -> {
    "<table class=\"Reference\"><tr valign=\"top\">", Automatic, 
     "</td></tr></table>"}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "TeX" -> {
      "NestingLevel" -> 1, 
       "CellGroupEnvironment" -> {"thebibliography", "{000}"}}}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 ParagraphIndent->-36,
 CounterIncrements->"BibliographyItem",
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Reference", "Presentation"],
 CellMargins->{{29, 10}, {2, 2}},
 LineSpacing->{1, 2},
 ParagraphIndent->-54,
 FontSize->17],

Cell[StyleData["Reference", "Printout"],
 CellMargins->{{2, 2}, {2, 0}},
 LineSpacing->{1, 2},
 ParagraphIndent->-32,
 FontSize->10],

Cell[StyleData["Reference", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 0}},
 LineSpacing->{2, 1},
 ParagraphIndent->-32,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLabel"],
 ConversionRules:>{
  "HTML" -> {
    "<td class=\"ReferenceLabel\" align=\"right\">", Automatic, 
     "&nbsp;</td><td>"}},
 CellSize->{36, Inherited},
 TextAlignment->Right,
 SpanMaxSize->1,
 CounterIncrements->"RefDingbat",
 StyleMenuListing->None],

Cell[StyleData["ReferenceLabel", "Presentation"],
 CellSize->{54, Inherited}],

Cell[StyleData["ReferenceLabel", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["ReferenceLabel", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]],

Cell[StyleData["RefSep"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefReturnLink"],
 ConversionRules:>{"TeX" -> {"\n\\bibitem{", 
     ExtractRefLinkData[], "}"}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnLink", "Presentation"],
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["RefReturnLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnLink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefReturnPointer"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}, "HTML" -> {"<td>", 
     NoOutput[], ""}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnPointer", "Presentation"]],

Cell[StyleData["RefReturnPointer", "Printout"],
 FontColor->GrayLevel[1]],

Cell[StyleData["RefReturnPointer", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSourceLink"],
 ConversionRules:>{{"TeX" -> {"", 
      NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontSize->1,
 FontColor->GrayLevel[1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["ReferenceSourceLink", "Printout"],
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[StyleData["ReferenceSourceURL"],
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Citation"],
 ConversionRules:>{"TeX" -> {{"", 
      ExtractCitationData[], ""}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(ListDataLink[#2]& ),
 Evaluator->Automatic}],

Cell[StyleData["Citation", "Presentation"],
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Citation", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Citation", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefKey"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.500008],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(EditRef[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["RefKey", "Presentation"],
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["RefKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["References Templates", "Subsubsection",
 StyleMenuListing->None],

Cell["FirstAuthor:<Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["OtherAuthors:, <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["LastAuthor:, & <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["FirstEditor:<FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["OtherEditors:, <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["LastEditor: & <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["Sorting:None", "ReferenceTemplate"],

Cell["ReferenceAuthorMax:4", "ReferenceTemplate"],

Cell["ReferenceEditorMax:4", "ReferenceTemplate"],

Cell["ReferenceAuthorMin:1", "ReferenceTemplate"],

Cell["ReferenceEditorMin:1", "ReferenceTemplate"],

Cell["AbbreviatedAuthors:, et al.", "ReferenceTemplate"],

Cell["AbbreviatedEditors:, et al.", "ReferenceTemplate"],

Cell[CellGroupData[{

Cell["Article Templates", "Subsubsubsection"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Article\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["In Book Templates", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \"InBook\" references.)\
\>", "Text"],

Cell["\<\
InBook:<Author> (<Year>). <Title>. In <Editor> (Ed.), <BookTitle> (pp. \
<PageRange>). <City>: <Publisher>.\
\>", "ReferenceTemplate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Whole Book Templates", "Subsubsubsection"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>. Retrieved \
<RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>.\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Book\" references that \
don't match any of the above templates.)\
\>", "Text"],

Cell["WholeBook:<Author> (<Year>). <BookTitle>. <Publisher>.", \
"ReferenceTemplate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Thesis Templates", "Subsubsubsection"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
PhdThesis:<Author> (<Year>). <BookTitle>. Unpublished doctoral dissertation, \
<School>, <City>.\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"PhdThesis\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Technical Report Templates", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \"TechReport\" \
references.)\
\>", "Text"],

Cell["\<\
TechReport:<Author> (<Year>). <Title>. <School>, <City>. <ReportNumber>, \
<Submittedby>\
\>", "ReferenceTemplate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preprint Templates", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \"Preprint\" references.)\
\
\>", "Text"],

Cell["Preprint:<Author> (<Year>). <Title>. <PublicationStatus>", \
"ReferenceTemplate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plain Insertion Template", "Subsubsubsection"],

Cell["\<\
(The following template is the default template for \
\[OpenCurlyDoubleQuote]PlainInsert\" references.)\
\>", "Text"],

Cell["PlainInsert:<InsertedBibText>", "ReferenceTemplate"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefTitle"],
 ConversionRules:>{"TeX" -> {"\\textit{", Automatic, "}"}},
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["RefTitle", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefType"],
 StyleMenuListing->None],

Cell[StyleData["RefType", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefURL"],
 StyleMenuListing->None],

Cell[StyleData["RefURL", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefRetrievalDate"],
 StyleMenuListing->None],

Cell[StyleData["RefRetrievalDate", "Printout"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefSourceOfAbstract"],
 StyleMenuListing->None],

Cell[StyleData["RefSourceOfAbstract", "Printout"],
 StyleMenuListing->None]
}, Closed]],

Cell[StyleData["RefInsertedBibText"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefBookTitle"],
 ConversionRules:>{"TeX" -> {"\\textit{", Automatic, "}"}},
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["RefBookTitle", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Journal Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefJournalTitle"],
 StyleMenuListing->None],

Cell[StyleData["RefJournalTitle", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefJournalVolume"],
 ConversionRules:>{"TeX" -> {"\\textbf{", Automatic, "}"}},
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["RefJournalVolume", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefJournalNumber"],
 StyleMenuListing->None],

Cell[StyleData["RefJournalNumber", "Printout"],
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Publisher Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefPublisher"],
 StyleMenuListing->None],

Cell[StyleData["RefPublisher", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefCity"],
 ParagraphIndent->0,
 StyleMenuListing->None],

Cell[StyleData["RefCity", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Author Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefAuthorGroup"],
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefAuthorFN"],
 StyleMenuListing->None],

Cell[StyleData["RefAuthorFN", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefAuthorLN"],
 StyleMenuListing->None],

Cell[StyleData["RefAuthorLN", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefAuthorMN"],
 StyleMenuListing->None],

Cell[StyleData["RefAuthorMN", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Editor Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefEditorGroup"],
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefEditorFN"],
 StyleMenuListing->None],

Cell[StyleData["RefEditorFN", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefEditorMN"],
 StyleMenuListing->None],

Cell[StyleData["RefEditorMN", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefEditorLN"],
 StyleMenuListing->None],

Cell[StyleData["RefEditorLN", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["School Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefSchool"],
 StyleMenuListing->None],

Cell[StyleData["RefSchool", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Publication Date Data Field Styles", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefDay"],
 StyleMenuListing->None],

Cell[StyleData["RefDay", "Printout"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefMonth"],
 StyleMenuListing->None],

Cell[StyleData["RefMonth", "Printout"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefYear"],
 StyleMenuListing->None],

Cell[StyleData["RefYear", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Data Field Styles: Auto Generated and Contiguous Pages", \
"Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["RefFirstPage"],
 ParagraphIndent->0,
 StyleMenuListing->None],

Cell[StyleData["RefFirstPage", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefLastPage"],
 ParagraphIndent->0,
 StyleMenuListing->None],

Cell[StyleData["RefLastPage", "Printout"]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Elements", "Section"],

Cell[CellGroupData[{

Cell["Part", "Subsection",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["BookPartLabel"],
 CellMargins->{{12, 12}, {7, 72}},
 CellGroupingRules->{"SectionGrouping", 10},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 PageBreakBelow->False,
 TextAlignment->Center,
 CounterAssignments->{{"Chapter", 0}},
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["BookPartLabel", "Printout"],
 CellMargins->{{2, 2}, {6, 60}},
 TextAlignment->Center,
 FontSize->27,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["BookPartLabel", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 60}},
 TextAlignment->Center,
 FontSize->27,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookPartNumber"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 PageBreakBelow->False,
 TextAlignment->Left,
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["BookPartNumber", "Printout"],
 FontSize->27,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["BookPartNumber", "DoubleSpacedPrintout"],
 FontSize->27,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookPartTitle"],
 CellMargins->{{12, 12}, {14, 7}},
 ConversionRules:>{"TeX" -> {"\\part{", Automatic, "}\n"}},
 PageBreakAbove->True,
 PageBreakBelow->True,
 CellFrameLabels->{{Inherited, Inherited}, {Inherited, 
    Cell[
     TextData[{
       StyleBox["Part ", "BookPartLabel"], 
       StyleBox[
        CounterBox["Part"], "BookPartNumber"]}], "BookPartLabel"]}},
 TextAlignment->Center,
 CounterIncrements->"Part",
 StyleMenuListing->None,
 FontSize->36,
 FontWeight->"Bold"],

Cell[StyleData["BookPartTitle", "Printout"],
 CellMargins->{{2, 2}, {12, 6}},
 TextAlignment->Center,
 FontSize->32,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["BookPartTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {12, 6}},
 TextAlignment->Center,
 FontSize->32,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter", "Subsection",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["BookChapterLabel"],
 CellMargins->{{12, 12}, {7, 48}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterTarget" -> "Cell", "XRefPrefix" -> "Chapter"}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 TextAlignment->Left,
 CounterIncrements->"BookChapterLabel",
 CounterAssignments->{{"Section", 0}, {"EquationNumbered", 0}, {
   "FigureCaption", 0}, {"Figure", 0}, {"TableTitle", 0}, {"Table", 0}},
 StyleMenuListing->None,
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterLabel", "Printout"],
 CellMargins->{{2, 2}, {6, 42}},
 FontSize->21,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterLabel", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 42}},
 FontSize->21,
 FontWeight->"Bold"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookChapterNumber"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 PageBreakBelow->False,
 TextAlignment->Left,
 StyleMenuListing->None,
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterNumber", "Printout"],
 FontSize->21,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[StyleData["BookChapterNumber", "DoubleSpacedPrintout"],
 FontSize->21,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookChapterTitle"],
 CellMargins->{{12, 12}, {14, 7}},
 ConversionRules:>{"TeX" -> {"\n\\chapter{", Automatic, "}\n"}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 PageBreakBelow->False,
 TextAlignment->Left,
 StyleMenuListing->None,
 FontSize->30,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterTitle", "Printout"],
 CellMargins->{{2, 2}, {12, 6}},
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["BookChapterTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {12, 6}},
 FontSize->27,
 FontWeight->"Bold"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Headers and Footers", "Section"],

Cell[StyleData["Header"],
 CellMargins->{{0, 0}, {4, 1}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["Footer"],
 CellMargins->{{0, 0}, {0, 4}},
 StyleMenuListing->None,
 FontSize->9],

Cell[StyleData["PageNumber"],
 CellMargins->{{0, 0}, {0, 0}},
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Miscellaneous", "Section"],

Cell[StyleData["TextSuperscript"],
 ConversionRules:>{"TeX" -> {"", 
     ConvertTextSuperscriptToLaTeX[], ""}, "HTML" -> {"", 
     ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SingleLetterItalics->False,
 StyleMenuListing->None],

Cell[StyleData["TextSubscript"],
 ConversionRules:>{"HTML" -> {"", 
     ConvertTextSubOrSuperscriptToHTML["sub"], ""}},
 ScriptMinSize->10,
 SingleLetterItalics->False,
 StyleMenuListing->None],

Cell[StyleData["Nil"],
 ConversionRules:>{"TeX" -> {"", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[StyleData["Verbatim"],
 StyleMenuListing->None],

Cell[StyleData["TeXName"],
 ConversionRules:>{"TeX" -> {"\\TeX\\", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[StyleData["LaTeXName"],
 ConversionRules:>{"TeX" -> {"\\LaTeX\\", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[StyleData["LaTeXeName"],
 ConversionRules:>{"TeX" -> {"\\LaTeXe\\", 
     NoOutput[], ""}},
 StyleMenuListing->None],

Cell[StyleData["ChemicalElement"],
 SingleLetterItalics->False,
 ZeroWidthTimes->True,
 StyleMenuListing->None],

Cell[StyleData["CustomCharacter"],
 SingleLetterItalics->False,
 StyleMenuListing->None],

Cell[StyleData["Palette"],
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["PageBreak"],
 Editable->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellBracketOptions->{"Color"->RGBColor[0.500008, 0.500008, 1],
 "Margins"->{Inherited, 3},
 "Thickness"->1,
 "Widths"->{5, 5}},
 CellElementSpacings->{"CellMinHeight"->1},
 ConversionRules:>{"TeX" -> {"\n\n\\pagebreak", 
     NoOutput[], ""}, "HTML" -> {"<br class=\"PageBreak\">", 
     NoOutput[], ""}},
 PageBreakAbove->True,
 CellSize->{Inherited, 6},
 TabFilling->"- ",
 TabSpacings->1000,
 StyleMenuListing->None,
 FontSize->6,
 FontColor->GrayLevel[0.700008]],

Cell[StyleData["PageBreak", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 CellSize->{Inherited, 2},
 TabFilling->""]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CreationDate"],
 CellFrame->0.5,
 CellMargins->{{10, 10}, {4, 4}},
 TextAlignment->Center,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10],

Cell[StyleData["CreationDate", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 LineSpacing->{1, 1},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell["Lines and Spacers", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["SingleLine"],
 CellMargins->{{2, 10}, {1, 1}},
 CellGroupingRules->{"GraphicsGrouping", 0},
 StyleMenuListing->None,
 FontSize->2],

Cell[StyleData["SingleLine", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 CellGroupingRules->{"GraphicsGrouping", 0},
 FontSize->2]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DoubleLine"],
 Editable->False,
 PageWidth->400,
 CellFrame->{{0, 0}, {0.25, 0.25}},
 CellMargins->{{12, 10}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->0},
 CellFrameMargins->{{2, 10}, {0, 0}},
 StyleMenuListing->None,
 FontSize->4],

Cell[StyleData["DoubleLine", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->2]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ThinLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8},
 StyleMenuListing->None],

Cell[StyleData["ThinLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MediumLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8},
 StyleMenuListing->None],

Cell[StyleData["MediumLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ThickLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8},
 StyleMenuListing->None],

Cell[StyleData["ThickLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Spacer"],
 CellMargins->{{Inherited, Inherited}, {4, 4}},
 StyleMenuListing->None],

Cell[StyleData["Spacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextSpacer"],
 StyleMenuListing->None],

Cell[StyleData["TextSpacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionSpacer"],
 StyleMenuListing->None],

Cell[StyleData["SectionSpacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GraphicsSpacer"],
 StyleMenuListing->None],

Cell[StyleData["GraphicsSpacer", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Outline", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Outline1"],
 CellMargins->{{12, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline1"], ". "}], "Outline1Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}},
 StyleMenuListing->None,
 FontSize->18,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["Outline1", "Presentation"],
 ShowGroupOpenCloseIcon->False,
 CellMargins->{{12, 12}, {7, 7}},
 FontSize->27],

Cell[StyleData["Outline1", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->16],

Cell[StyleData["Outline1", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline1Label"],
 CellSize->{40, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["Outline1Label", "Presentation"],
 CellSize->{60, Inherited}],

Cell[StyleData["Outline1Label", "Printout"],
 CellSize->{36, Inherited}],

Cell[StyleData["Outline1Label", "DoubleSpacedPrintout"],
 CellSize->{36, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2"],
 CellMargins->{{32, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 40},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline2"], ". "}], "Outline2Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}},
 StyleMenuListing->None,
 FontSize->16,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["Outline2", "Presentation"],
 CellMargins->{{52, 12}, {11, 11}},
 FontSize->24],

Cell[StyleData["Outline2", "Printout"],
 CellMargins->{{22, 2}, {6, 6}},
 FontSize->14],

Cell[StyleData["Outline2", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {6, 6}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2Label"],
 CellSize->{30, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["Outline2Label", "Presentation"],
 CellSize->{45, Inherited}],

Cell[StyleData["Outline2Label", "Printout"],
 CellSize->{27, Inherited}],

Cell[StyleData["Outline2Label", "DoubleSpacedPrintout"],
 CellSize->{27, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3"],
 CellMargins->{{52, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline3"], ". "}], "Outline3Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}},
 StyleMenuListing->None,
 FontSize->14,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Outline3", "Presentation"],
 CellMargins->{{92, 12}, {11, 11}},
 FontSize->21],

Cell[StyleData["Outline3", "Printout"],
 CellMargins->{{42, 2}, {6, 6}},
 FontSize->12],

Cell[StyleData["Outline3", "DoubleSpacedPrintout"],
 CellMargins->{{42, 2}, {6, 6}},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3Label"],
 CellSize->{21, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["Outline3Label", "Presentation"],
 CellSize->{32, Inherited}],

Cell[StyleData["Outline3Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Outline3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4"],
 CellMargins->{{67, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 60},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline4"], ". "}], "Outline4Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline4",
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Outline4", "Presentation"],
 CellMargins->{{122, 12}, {11, 11}},
 FontSize->17],

Cell[StyleData["Outline4", "Printout"],
 CellMargins->{{57, 2}, {6, 6}},
 FontSize->10],

Cell[StyleData["Outline4", "DoubleSpacedPrintout"],
 CellMargins->{{57, 2}, {6, 6}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4Label"],
 CellSize->{18, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["Outline4Label", "Presentation"],
 CellSize->{27, Inherited}],

Cell[StyleData["Outline4Label", "Printout"],
 CellSize->{16, Inherited}],

Cell[StyleData["Outline4Label", "DoubleSpacedPrintout"],
 CellSize->{16, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OutlineText"],
 CellMargins->{{91, 12}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 CounterIncrements->"Text",
 StyleMenuListing->None],

Cell[StyleData["OutlineText", "Presentation"],
 CellMargins->{{155, 12}, {5, 8}},
 FontSize->17],

Cell[StyleData["OutlineText", "Printout"],
 CellMargins->{{79, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["OutlineText", "DoubleSpacedPrintout"],
 CellMargins->{{79, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
 Editable->False,
 CellFrame->True,
 CellMargins->{{0, 0}, {3, 3}},
 CellElementSpacings->{"CellMinHeight"->0.8125},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameMargins->False,
 CellFrameColor->GrayLevel[1],
 CellFrameLabelMargins->False,
 TextAlignment->Center,
 CounterIncrements->"SlideShowNavigationBar",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None,
 FontSize->10,
 Magnification->1,
 Background->GrayLevel[0.8],
 GridBoxOptions->{BaselinePosition->Center,
 GridBoxAlignment->{
  "Columns" -> {
    Center, Center, Center, Center, Center, Center, Right, {Center}}, 
   "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {3.5, 3.5, 3.5, 3.5, 13, 5, {4}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{1.}}, "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{-1, -1}, {-1, -1}},
 PageBreakAbove->True,
 CellFrameMargins->{{1, 1}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontSize->26,
 FontColor->GrayLevel[0.400015],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Printout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["SlideHyperlink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Inline", "Section"],

Cell[CellGroupData[{

Cell["General Text Attributes", "Subsection",
 StyleMenuListing->None],

Cell[StyleData["RM"],
 StyleMenuListing->None,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["BF"],
 ConversionRules:>{"TeX" -> {"\\textbf{", "}"}},
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["IT"],
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["SmallCaps"],
 ConversionRules:>{"TeX" -> {{"", 
      ChangeCase["Lower"], ""}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell["Font Specific Text Attributes", "Subsection",
 StyleMenuListing->None],

Cell[StyleData["TR"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TI"],
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["TB"],
 ConversionRules:>{
  "TeX" -> {{"\\textbf{", Automatic, "}"}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TBI"],
 ConversionRules:>{
  "TeX" -> {{"\\textbf{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MR"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{", Automatic, "}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MO"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MB"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textbf{", Automatic, "}}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MBO"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textbf{\\textit{", Automatic, "}}}"}, {
     "", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SR"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{", Automatic, "}"}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SB"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textbf{", Automatic, "}}"}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBO"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textbf{\\textit{", Automatic, "}}}"}, {
     "", Automatic, ""}}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["PlainGreekWin"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 CharacterEncoding->"Unicode"],

Cell[StyleData["PlainGreekMac"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 FontFamily->"Symbol"],

Cell[StyleData["PlainGreekLin"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 FontFamily->"Symbol"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlinks", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 ConversionRules:>{"TeX" -> {{"", 
      ExportAsHyperRef[], ""}, {"", Automatic, ""}}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
 FontSize->10,
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["XMLWebLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(OpenAllTypes[#]& ),
 ButtonNote->ButtonData,
 Evaluator->Automatic}],

Cell[StyleData["XMLWebLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["On-line Help System Links", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["UserGuideLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["UserGuide", #]}]& )}],

Cell[StyleData["UserGuideLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Reference", #]}]& )}],

Cell[StyleData["ReferenceLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["System", "Section"],

Cell[CellGroupData[{

Cell["Format Type Style", "Subsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that are mixed in with the styles of 
most cells.  If a cell's FormatType matches the name of one of the styles 
defined below, then that style is applied between the cell's style and its 
own options. This is particularly true of Input and Output.
\
\>", "Text"],

Cell[StyleData["CellExpression"],
 PageWidth->Infinity,
 CellMargins->{{6, Inherited}, {Inherited, Inherited}},
 ShowCellLabel->False,
 ShowSpecialCharacters->False,
 AllowInlineCells->False,
 AutoItalicWords->{},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->12,
 Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
 AllowInlineCells->False,
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
 PageWidth->Infinity,
 TextAlignment->Left,
 LineSpacing->{0.6, 1},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
 InputAutoReplacements->{
  "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", ">=" -> 
   "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]", Inherited},
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 LineSpacing->{1.25, 0},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
 LineSpacing->{1.25, 0},
 SingleLetterItalics->True,
 TraditionalFunctionNotation->True,
 DelimiterMatching->None,
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Document Settings and Templates", "Subsection"],

Cell[StyleData["ReferenceTemplate"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["AuthorFormCustomizationTemplate"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["CSSDefinitions"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["LaTeXPreamble"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["DOCTYPEFormat"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["ValidationSetting"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["XRefPaletteSettings"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["MiscSettings"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 StyleMenuListing->None,
 FontFamily->"Courier"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Cells", "Subsection",
 StyleMenuListing->None],

Cell["\<\

The style defined below is mixed in to any cell that is in an 
inline cell within another.
\
\>", "Text"],

Cell[StyleData["InlineCell"],
 InputAutoReplacements->{"-" -> "-"},
 ScriptLevel->1,
 StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
 StyleMenuListing->None,
 Background->RGBColor[0.880003, 0.899992, 0.959991]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette", "Subsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that define standard ButtonFunctions, 
for use in palette buttons.
\
\>", "Text"],

Cell[StyleData["Paste"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["StyleApply"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(CellWriteStyle[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["StyleApplyWithVerification"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{
 ButtonFunction:>((CheckDocStyleMatch[]; CellWriteStyle[#])& ),
 Evaluator->Automatic}],

Cell[StyleData["ConvertCharacter"],
 ConversionRules:>{"TeX" -> {"", 
     ExtractButtonData["TeX"], ""}, "HTML" :> {"", 
     ExtractButtonData["HTML"], ""}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFrame->"None",
 Evaluator->Automatic}]
}, Closed]],

Cell[CellGroupData[{

Cell["Automatic", "Subsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that are used to affect the display 
of certain types of objects in typeset expressions.  For example, 
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and 
parenthesis characters are displayed (typically by coloring them to make them \

stand out).
\
\>", "Text"],

Cell[StyleData["UnmatchedBracket"],
 StyleMenuListing->None,
 FontColor->RGBColor[0.760006, 0.330007, 0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell["DialogEffects", "Subsection",
 StyleMenuListing->None],

Cell[StyleData["DialogStyleSheetMisapplicationEscape"],
 ShowCellBracket->False,
 CellMargins->{{12, 12}, {2000, 40}},
 CellOpen->True,
 TextAlignment->Center,
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Conformance", "Section"],

Cell[CellGroupData[{

Cell["Input/Output", "Subsection",
 StyleMenuListing->None],

Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names. \
Some attributes for these styles are actually set in FormatType Styles (in \
the last section of this stylesheet). \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
 CellMargins->{{72, 72}, {6, 8}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->StandardForm,
 InputAutoReplacements->{},
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 SpanMaxSize->Automatic,
 LinebreakAdjustments->{0.85, 2, 10, 0, 1},
 CounterIncrements->"Input",
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["Input", "Printout"],
 CellMargins->{{21, 6}, {3, 6}},
 LinebreakAdjustments->{0.85, 2, 10, 1, 1},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputNumbered"],
 CellMargins->{{72, 6}, {6, 8}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellFrameLabels->{{None, 
    Cell[
     BoxData[
      StyleBox[
       RowBox[{"(", 
         CounterBox["Input"], ")"}], FontWeight -> "Plain", FontFamily -> 
       "Times"]]]}, {None, None}},
 CellFrameLabelMargins->{{0, 42}, {0, 0}},
 DefaultFormatType->StandardForm,
 InputAutoReplacements->{},
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 SpanMaxSize->Automatic,
 LinebreakAdjustments->{0.85, 2, 10, 0, 1},
 CounterIncrements->"Input",
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["InputNumbered", "Printout"],
 CellMargins->{{21, 6}, {3, 6}},
 LinebreakAdjustments->{0.85, 2, 10, 1, 1},
 FontSize->9]
}, Closed]],

Cell[StyleData["InputOnly"],
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 DefaultFormatType->StandardForm,
 AutoItalicWords->{},
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 SpanMaxSize->Automatic,
 CounterIncrements->"Input",
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
 CellMargins->{{72, 72}, {7, 5}},
 CellEditDuplicate->True,
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->StandardForm,
 InputAutoReplacements->{},
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 SpanMaxSize->Automatic,
 CounterIncrements->"Output",
 StyleMenuListing->None],

Cell[StyleData["Output", "Printout"],
 CellMargins->{{21, 0}, {6, 3}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
 CellMargins->{{45, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->StandardForm,
 AutoItalicWords->{},
 FormatType->InputForm,
 SpanMaxSize->Automatic,
 CounterIncrements->"Message",
 StyleMenuListing->None,
 FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Printout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontSize->8,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
 CellMargins->{{12, 10}, {2, 2}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->StandardForm,
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 ParagraphIndent->12,
 AutoItalicWords->{},
 FormatType->InputForm,
 SpanMaxSize->Automatic,
 CounterIncrements->"Print",
 StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
 CellMargins->{{12, 10}, {3, 3}},
 ParagraphIndent->18,
 FontSize->17],

Cell[StyleData["Print", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->10],

Cell[StyleData["Print", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell["\<\
Do not remove TextAlignment->Left from \"Graphics\" style definitions or else \
graphics may behave badly as inline cells:\
\>", "Text",
 CellMargins->{{72, Inherited}, {Inherited, Inherited}},
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->GrayLevel[0.500008]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
 Editable->True,
 CellMargins->{{36, Inherited}, {0, 7}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->False,
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->StandardForm,
 InputAutoReplacements->{},
 TextAlignment->Left,
 LanguageCategory->None,
 FormatType->InputForm,
 SpanMaxSize->Automatic,
 CounterIncrements->"Graphics",
 ImageMargins->{{0, 0}, {0, 0}},
 StyleMenuListing->None],

Cell[StyleData["Graphics", "Printout"],
 CellMargins->{{27, 0}, {6, 3}},
 ImageMargins->{{0, 0}, {0, 0}},
 FontSize->9,
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
 SpanMaxSize->Automatic,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Printout"],
 FontFamily->"Courier",
 FontSize->8,
 FontSlant->"Italic",
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Help Browser Styles", "Subsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
 StyleMenuListing->None],

Cell[StyleData["MathCaption", "Printout"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["UserTips"],
 StyleMenuListing->None],

Cell[StyleData["UserTips", "Printout"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["UserTipsList"],
 StyleMenuListing->None],

Cell[StyleData["UserTipsList", "Printout"],
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndentedText"],
 StyleMenuListing->None],

Cell[StyleData["IndentedText", "Printout"],
 StyleMenuListing->None]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Alternative Item Styles", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Item1NumberedNew"],
 CellMargins->{{12, 10}, {3, 5}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item1Numbered"], ". "}], "Item1NumberedLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 ParagraphIndent->-24,
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Item1NumberedNew", "Printout"],
 CellMargins->{{0, 12}, {1, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 ParagraphIndent->-18,
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2NumberedNew"],
 CellMargins->{{24, 10}, {3, 5}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item2Numbered"], ". "}], "Item2NumberedLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 ParagraphIndent->-24,
 CounterIncrements->"Item2Numbered",
 CounterAssignments->{{"Item2Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Item2NumberedNew", "Printout"],
 CellMargins->{{12, 12}, {1, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 ParagraphIndent->-18,
 StyleMenuListing->None,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3NumberedNew"],
 CellMargins->{{36, 10}, {3, 5}},
 CellGroupingRules->"GraphicsGrouping",
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item3Numbered"], ". "}], "Item3NumberedLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 ParagraphIndent->-24,
 CounterIncrements->"Item3Numbered",
 CounterAssignments->{{"Item3Numbered", 0}},
 StyleMenuListing->None],

Cell[StyleData["Item3NumberedNew", "Printout"],
 CellMargins->{{24, 12}, {1, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 ParagraphIndent->-18,
 StyleMenuListing->None,
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]]
},
WindowSize->{718, 680},
WindowMargins->{{7, Automatic}, {Automatic, 1}},
TaggingRules:>("StyleSheetName" -> "LaTeX_Book.nb"),
TrackCellChangeTimes->False,
MenuPosition->None,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 3, 2007)",
StyleDefinitions->"StylesheetFormatting.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TeXPreamble"->{
  Cell[891, 34, 232, 11, 174, "Text",
   CellTags->"TeXPreamble"]},
 "CSSDefinitions"->{
  Cell[1185, 52, 11456, 537, 9945, "Text",
   CellTags->"CSSDefinitions"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TeXPreamble", 138606, 5507},
 {"CSSDefinitions", 138695, 5510}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[584, 22, 49, 0, 35, 49, 0, "StyleData", "StyleDefinitions", ""],
Cell[636, 24, 191, 4, 57, "Text"],
Cell[CellGroupData[{
Cell[852, 32, 36, 0, 50, "Section"],
Cell[891, 34, 232, 11, 174, "Text",
 CellTags->"TeXPreamble"]
}, Closed]],
Cell[CellGroupData[{
Cell[1160, 50, 22, 0, 34, "Section"],
Cell[1185, 52, 11456, 537, 9945, "Text",
 CellTags->"CSSDefinitions"]
}, Closed]],
Cell[CellGroupData[{
Cell[12678, 594, 42, 0, 34, "Section"],
Cell[12723, 596, 102, 2, 40, 30, 0, "StyleData", "All", "Screen"],
Cell[12828, 600, 245, 6, 40, 36, 0, "StyleData", "All", "Presentation"],
Cell[13076, 608, 122, 3, 38, 32, 0, "StyleData", "All", "Printout"],
Cell[13201, 613, 156, 4, 38, 44, 0, "StyleData", "All", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[13394, 622, 35, 0, 34, "Section"],
Cell[13432, 624, 104, 3, 84, "Text"],
Cell[13539, 629, 870, 29, 521, 27, 0, "StyleData", "Notebook", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[14446, 663, 30, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[14501, 667, 325, 10, 60, 35, 0, "StyleData", "FrontmatterGroup", "All",
 StyleMenuListing->None],
Cell[14829, 679, 123, 3, 84, 51, 0, "StyleData", "FrontmatterGroup", \
"Presentation"],
Cell[14955, 684, 119, 3, 84, 47, 0, "StyleData", "FrontmatterGroup", \
"Printout"],
Cell[15077, 689, 131, 3, 84, 59, 0, "StyleData", "FrontmatterGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15245, 697, 64, 1, 35, "Subsection"],
Cell[CellGroupData[{
Cell[15334, 702, 29, 0, 31, "Subsubsection"],
Cell[CellGroupData[{
Cell[15388, 706, 42, 0, 28, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[15455, 710, 359, 11, 236, 33, 0, "StyleData", "TOCBookHeading", "All",
 StyleMenuListing->None],
Cell[15817, 723, 120, 3, 84, 45, 0, "StyleData", "TOCBookHeading", \
"Printout"],
Cell[15940, 728, 132, 3, 84, 57, 0, "StyleData", "TOCBookHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16109, 736, 406, 12, 255, 39, 0, "StyleData", "TOCBookIllustrations", \
"All",
 CounterAssignments->{{"TOCBookItem", 0}},
 StyleMenuListing->None],
Cell[16518, 750, 126, 3, 84, 51, 0, "StyleData", "TOCBookIllustrations", \
"Printout"],
Cell[16647, 755, 138, 3, 84, 63, 0, "StyleData", "TOCBookIllustrations", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16822, 763, 398, 12, 255, 32, 0, "StyleData", "TOCBookTables", "All",
 CounterAssignments->{{"TOCBookItem", 0}},
 StyleMenuListing->None],
Cell[17223, 777, 119, 3, 84, 44, 0, "StyleData", "TOCBookTables", \
"Printout"],
Cell[17345, 782, 131, 3, 84, 56, 0, "StyleData", "TOCBookTables", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17525, 791, 45, 0, 26, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[17595, 795, 481, 12, 34, 44, 0, "StyleData", \
"TOCBookFrontmatterHeading", "All",
 CounterIncrements->"TOCBookFrontmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookTable", 0}},
 StyleMenuListing->None],
Cell[18079, 809, 125, 3, 84, 56, 0, "StyleData", "TOCBookFrontmatterHeading", \
"Printout"],
Cell[18207, 814, 137, 3, 84, 68, 0, "StyleData", "TOCBookFrontmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[18381, 822, 478, 12, 37, 43, 0, "StyleData", "TOCBookBackmatterHeading", \
"All",
 CounterIncrements->"TOCBookBackmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookTable", 0}},
 StyleMenuListing->None],
Cell[18862, 836, 124, 3, 84, 55, 0, "StyleData", "TOCBookBackmatterHeading", \
"Printout"],
Cell[18989, 841, 136, 3, 84, 67, 0, "StyleData", "TOCBookBackmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19162, 849, 475, 12, 37, 42, 0, "StyleData", "TOCBookFrontBackHeading", \
"All",
 CounterIncrements->"TOCBookFrontBackHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookTable", 0}},
 StyleMenuListing->None],
Cell[19640, 863, 123, 3, 84, 54, 0, "StyleData", "TOCBookFrontBackHeading", \
"Printout"],
Cell[19766, 868, 135, 3, 84, 66, 0, "StyleData", "TOCBookFrontBackHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19938, 876, 708, 18, 39, 35, 0, "StyleData", "TOCBookPartTitle", "All",
 CounterIncrements->"TOCBookPartTitle",
 CounterAssignments->{{"TOCBookChapterTitle", 0}},
 StyleMenuListing->None],
Cell[20649, 896, 81, 1, 44, 47, 0, "StyleData", "TOCBookPartTitle", \
"Printout"],
Cell[20733, 899, 93, 1, 44, 59, 0, "StyleData", "TOCBookPartTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20863, 905, 710, 18, 34, 38, 0, "StyleData", "TOCBookChapterTitle", \
"All",
 CounterIncrements->"TOCBookChapterTitle",
 CounterAssignments->{{"TOCBookSection", 0}},
 StyleMenuListing->None],
Cell[21576, 925, 142, 4, 103, 50, 0, "StyleData", "TOCBookChapterTitle", \
"Printout"],
Cell[21721, 931, 154, 4, 103, 62, 0, "StyleData", "TOCBookChapterTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[21912, 940, 740, 18, 37, 33, 0, "StyleData", "TOCBookSection", "All",
 CounterIncrements->"TOCBookSection",
 CounterAssignments->{{"TOCBookSubsection", 0}},
 StyleMenuListing->None],
Cell[22655, 960, 137, 4, 31, 45, 0, "StyleData", "TOCBookSection", \
"Printout"],
Cell[22795, 966, 149, 4, 31, 57, 0, "StyleData", "TOCBookSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[22981, 975, 773, 18, 37, 36, 0, "StyleData", "TOCBookSubsection", "All",
 CounterIncrements->"TOCBookSubsection",
 StyleMenuListing->None],
Cell[23757, 995, 141, 4, 31, 48, 0, "StyleData", "TOCBookSubsection", \
"Printout"],
Cell[23901, 1001, 153, 4, 31, 60, 0, "StyleData", "TOCBookSubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24091, 1010, 667, 16, 37, 32, 0, "StyleData", "TOCBookFigure", "All",
 CounterIncrements->"TOCBookFigure",
 StyleMenuListing->None],
Cell[24761, 1028, 111, 3, 31, 44, 0, "StyleData", "TOCBookFigure", \
"Printout"],
Cell[24875, 1033, 123, 3, 31, 56, 0, "StyleData", "TOCBookFigure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25035, 1041, 663, 16, 37, 31, 0, "StyleData", "TOCBookTable", "All",
 CounterIncrements->"TOCBookTable",
 StyleMenuListing->None],
Cell[25701, 1059, 110, 3, 31, 43, 0, "StyleData", "TOCBookTable", \
"Printout"],
Cell[25814, 1064, 122, 3, 31, 55, 0, "StyleData", "TOCBookTable", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25985, 1073, 43, 0, 28, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[26053, 1077, 148, 4, 32, 32, 0, "StyleData", "TOCBookSpacer", "All",
 StyleMenuListing->None],
Cell[26204, 1083, 76, 1, 46, 44, 0, "StyleData", "TOCBookSpacer", \
"Printout"],
Cell[26283, 1086, 88, 1, 46, 56, 0, "StyleData", "TOCBookSpacer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26408, 1092, 150, 4, 40, 40, 0, "StyleData", "TOCBookPartTitleLabel", \
"All",
 StyleMenuListing->None],
Cell[26561, 1098, 80, 1, 40, 52, 0, "StyleData", "TOCBookPartTitleLabel", \
"Printout"],
Cell[26644, 1101, 92, 1, 40, 64, 0, "StyleData", "TOCBookPartTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26773, 1107, 176, 5, 40, 43, 0, "StyleData", "TOCBookChapterTitleLabel", \
"All",
 StyleMenuListing->None],
Cell[26952, 1114, 83, 1, 40, 55, 0, "StyleData", "TOCBookChapterTitleLabel", \
"Printout"],
Cell[27038, 1117, 95, 1, 40, 67, 0, "StyleData", "TOCBookChapterTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27170, 1123, 171, 5, 122, 38, 0, "StyleData", "TOCBookSectionLabel", \
"All",
 StyleMenuListing->None],
Cell[27344, 1130, 78, 1, 40, 50, 0, "StyleData", "TOCBookSectionLabel", \
"Printout"],
Cell[27425, 1133, 90, 1, 46, 62, 0, "StyleData", "TOCBookSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27552, 1139, 174, 5, 122, 41, 0, "StyleData", "TOCBookSubsectionLabel", \
"All",
 StyleMenuListing->None],
Cell[27729, 1146, 81, 1, 46, 53, 0, "StyleData", "TOCBookSubsectionLabel", \
"Printout"],
Cell[27813, 1149, 93, 1, 46, 65, 0, "StyleData", "TOCBookSubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[27943, 1155, 170, 5, 122, 37, 0, "StyleData", "TOCBookFigureLabel", \
"All",
 StyleMenuListing->None],
Cell[28116, 1162, 77, 1, 46, 49, 0, "StyleData", "TOCBookFigureLabel", \
"Printout"],
Cell[28196, 1165, 89, 1, 46, 61, 0, "StyleData", "TOCBookFigureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[28322, 1171, 169, 5, 122, 36, 0, "StyleData", "TOCBookTableLabel", "All",
 
 StyleMenuListing->None],
Cell[28494, 1178, 76, 1, 46, 48, 0, "StyleData", "TOCBookTableLabel", \
"Printout"],
Cell[28573, 1181, 88, 1, 46, 60, 0, "StyleData", "TOCBookTableLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[28698, 1187, 170, 6, 141, 32, 0, "StyleData", "TOCBookLeader", "All",
 StyleMenuListing->None],
Cell[28871, 1195, 59, 1, 46, 44, 0, "StyleData", "TOCBookLeader", \
"Printout"],
Cell[28933, 1198, 71, 1, 46, 56, 0, "StyleData", "TOCBookLeader", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[29041, 1204, 317, 10, 198, 36, 0, "StyleData", "TOCBookPageNumber", \
"All",
 StyleMenuListing->None],
Cell[29361, 1216, 76, 1, 46, 48, 0, "StyleData", "TOCBookPageNumber", \
"Printout"],
Cell[29440, 1219, 88, 1, 46, 60, 0, "StyleData", "TOCBookPageNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29613, 1229, 29, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[29667, 1233, 337, 10, 56, 34, 0, "StyleData", "MainmatterGroup", "All",
 StyleMenuListing->None],
Cell[30007, 1245, 122, 3, 84, 50, 0, "StyleData", "MainmatterGroup", \
"Presentation"],
Cell[30132, 1250, 118, 3, 84, 46, 0, "StyleData", "MainmatterGroup", \
"Printout"],
Cell[30253, 1255, 130, 3, 84, 58, 0, "StyleData", "MainmatterGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[30420, 1263, 971, 25, 53, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}},
 StyleMenuListing->None],
Cell[31394, 1290, 140, 4, 103, 42, 0, "StyleData", "Section", \
"Presentation"],
Cell[31537, 1296, 134, 4, 103, 38, 0, "StyleData", "Section", "Printout"],
Cell[31674, 1302, 146, 4, 103, 50, 0, "StyleData", "Section", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[31857, 1311, 1154, 30, 54, 29, 0, "StyleData", "Subsection", "All",
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}},
 StyleMenuListing->None],
Cell[33014, 1343, 122, 3, 84, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[33139, 1348, 116, 3, 84, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[33258, 1353, 128, 3, 84, 53, 0, "StyleData", "Subsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[33423, 1361, 606, 15, 51, 32, 0, "StyleData", "Subsubsection", "All",
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsubsection", 0}},
 StyleMenuListing->None],
Cell[34032, 1378, 125, 3, 84, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[34160, 1383, 119, 3, 84, 44, 0, "StyleData", "Subsubsection", \
"Printout"],
Cell[34282, 1388, 131, 3, 84, 56, 0, "StyleData", "Subsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[34450, 1396, 361, 9, 43, 35, 0, "StyleData", "Subsubsubsection", "All",
 StyleMenuListing->None],
Cell[34814, 1407, 102, 2, 65, 51, 0, "StyleData", "Subsubsubsection", \
"Presentation"],
Cell[34919, 1411, 96, 2, 65, 47, 0, "StyleData", "Subsubsubsection", \
"Printout"],
Cell[35018, 1415, 108, 2, 65, 59, 0, "StyleData", "Subsubsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35163, 1422, 50, 0, 28, "Subsection"],
Cell[CellGroupData[{
Cell[35238, 1426, 141, 4, 103, 31, 0, "StyleData", "SectionLabel", "All",
 StyleMenuListing->None],
Cell[35382, 1432, 75, 1, 70, 47, 0, "StyleData", "SectionLabel", \
"Presentation"],
Cell[35460, 1435, 71, 1, 46, 43, 0, "StyleData", "SectionLabel", "Printout"],
Cell[35534, 1438, 83, 1, 46, 55, 0, "StyleData", "SectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35654, 1444, 144, 4, 103, 34, 0, "StyleData", "SubsectionLabel", "All",
 StyleMenuListing->None],
Cell[35801, 1450, 78, 1, 46, 50, 0, "StyleData", "SubsectionLabel", \
"Presentation"],
Cell[35882, 1453, 74, 1, 46, 46, 0, "StyleData", "SubsectionLabel", \
"Printout"],
Cell[35959, 1456, 86, 1, 46, 58, 0, "StyleData", "SubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36082, 1462, 119, 3, 84, 37, 0, "StyleData", "SubsubsectionLabel", "All",
 
 StyleMenuListing->None],
Cell[36204, 1467, 53, 0, 27, 53, 0, "StyleData", "SubsubsectionLabel", \
"Presentation"],
Cell[36260, 1469, 49, 0, 27, 49, 0, "StyleData", "SubsubsectionLabel", \
"Printout"],
Cell[36312, 1471, 61, 0, 27, 61, 0, "StyleData", "SubsubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36410, 1476, 143, 4, 103, 40, 0, "StyleData", "SubsubsubsectionLabel", \
"All",
 StyleMenuListing->None],
Cell[36556, 1482, 56, 0, 27, 56, 0, "StyleData", "SubsubsubsectionLabel", \
"Presentation"],
Cell[36615, 1484, 52, 0, 27, 52, 0, "StyleData", "SubsubsubsectionLabel", \
"Printout"],
Cell[36670, 1486, 64, 0, 27, 64, 0, "StyleData", "SubsubsubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36771, 1491, 297, 8, 179, 39, 0, "StyleData", "SubsubsubsectionText", \
"All",
 CounterIncrements->{"SubsubsubsectionText", "SubsubsubsectionHeader"},
 StyleMenuListing->None],
Cell[37071, 1501, 104, 2, 65, 55, 0, "StyleData", "SubsubsubsectionText", \
"Presentation"],
Cell[37178, 1505, 99, 2, 65, 51, 0, "StyleData", "SubsubsubsectionText", \
"Printout"],
Cell[37280, 1509, 111, 2, 65, 63, 0, "StyleData", "SubsubsubsectionText", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37440, 1517, 40, 0, 28, "Subsection"],
Cell[CellGroupData[{
Cell[37505, 1521, 347, 10, 198, 29, 0, "StyleData", "SectionAlt", "All",
 StyleMenuListing->None],
Cell[37855, 1533, 143, 4, 103, 45, 0, "StyleData", "SectionAlt", \
"Presentation"],
Cell[38001, 1539, 137, 4, 103, 41, 0, "StyleData", "SectionAlt", "Printout"],
Cell[38141, 1545, 149, 4, 103, 53, 0, "StyleData", "SectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[38327, 1554, 454, 13, 255, 32, 0, "StyleData", "SubsectionAlt", "All",
 StyleMenuListing->None],
Cell[38784, 1569, 128, 3, 84, 51, 0, "StyleData", "SubsubsectionAlt", \
"Presentation"],
Cell[38915, 1574, 119, 3, 84, 44, 0, "StyleData", "SubsectionAlt", \
"Printout"],
Cell[39037, 1579, 131, 3, 84, 56, 0, "StyleData", "SubsectionAlt", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[39217, 1588, 31, 0, 28, "Subsection"],
Cell[CellGroupData[{
Cell[39273, 1592, 321, 9, 31, 23, 0, "StyleData", "Text", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],
Cell[39597, 1603, 110, 3, 38, 39, 0, "StyleData", "Text", "Presentation"],
Cell[39710, 1608, 83, 2, 28, 35, 0, "StyleData", "Text", "Printout"],
Cell[39796, 1612, 117, 3, 28, 47, 0, "StyleData", "Text", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[39950, 1620, 410, 11, 31, 31, 0, "StyleData", "TextNoIndent", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],
Cell[40363, 1633, 96, 2, 65, 47, 0, "StyleData", "TextNoIndent", \
"Presentation"],
Cell[40462, 1637, 91, 2, 65, 43, 0, "StyleData", "TextNoIndent", "Printout"],
Cell[40556, 1641, 125, 3, 84, 55, 0, "StyleData", "TextNoIndent", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[40718, 1649, 381, 9, 31, 35, 0, "StyleData", "TextContinuation", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],
Cell[41102, 1660, 100, 2, 65, 51, 0, "StyleData", "TextContinuation", \
"Presentation"],
Cell[41205, 1664, 95, 2, 65, 47, 0, "StyleData", "TextContinuation", \
"Printout"],
Cell[41303, 1668, 129, 3, 84, 59, 0, "StyleData", "TextContinuation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41493, 1678, 33, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[41551, 1682, 61, 1, 46, "Subsection"],
Cell[CellGroupData[{
Cell[41637, 1687, 683, 17, 293, 24, 0, "StyleData", "Item1", "All",
 CounterIncrements->"Item1",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}},
 StyleMenuListing->None],
Cell[42323, 1706, 114, 3, 84, 40, 0, "StyleData", "Item1", "Presentation",
 StyleMenuListing->None],
Cell[42440, 1711, 108, 3, 70, 36, 0, "StyleData", "Item1", "Printout",
 StyleMenuListing->None],
Cell[42551, 1716, 117, 3, 70, 48, 0, "StyleData", "Item1", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[42705, 1724, 661, 17, 70, 24, 0, "StyleData", "Item2", "All",
 CounterIncrements->"Item2",
 CounterAssignments->{{"Item3Numbered", 0}},
 StyleMenuListing->None],
Cell[43369, 1743, 114, 3, 70, 40, 0, "StyleData", "Item2", "Presentation",
 StyleMenuListing->None],
Cell[43486, 1748, 109, 3, 70, 36, 0, "StyleData", "Item2", "Printout",
 StyleMenuListing->None],
Cell[43598, 1753, 118, 3, 70, 48, 0, "StyleData", "Item2", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[43753, 1761, 616, 16, 70, 24, 0, "StyleData", "Item3", "All",
 CounterIncrements->"Item3",
 StyleMenuListing->None],
Cell[44372, 1779, 114, 3, 70, 40, 0, "StyleData", "Item3", "Presentation",
 StyleMenuListing->None],
Cell[44489, 1784, 109, 3, 70, 36, 0, "StyleData", "Item3", "Printout",
 StyleMenuListing->None],
Cell[44601, 1789, 118, 3, 70, 48, 0, "StyleData", "Item3", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[44756, 1797, 222, 7, 70, 29, 0, "StyleData", "Item1Label", "All",
 StyleMenuListing->None],
Cell[44981, 1806, 113, 3, 70, 45, 0, "StyleData", "Item1Label", \
"Presentation",
 StyleMenuListing->None],
Cell[45097, 1811, 109, 3, 70, 41, 0, "StyleData", "Item1Label", "Printout",
 StyleMenuListing->None],
Cell[45209, 1816, 121, 3, 70, 53, 0, "StyleData", "Item1Label", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[45367, 1824, 222, 7, 70, 29, 0, "StyleData", "Item2Label", "All",
 StyleMenuListing->None],
Cell[45592, 1833, 113, 3, 70, 45, 0, "StyleData", "Item2Label", \
"Presentation",
 StyleMenuListing->None],
Cell[45708, 1838, 94, 2, 70, 41, 0, "StyleData", "Item2Label", "Printout",
 StyleMenuListing->None],
Cell[45805, 1842, 106, 2, 70, 53, 0, "StyleData", "Item2Label", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[45948, 1849, 222, 7, 70, 29, 0, "StyleData", "Item3Label", "All",
 StyleMenuListing->None],
Cell[46173, 1858, 113, 3, 70, 45, 0, "StyleData", "Item3Label", \
"Presentation",
 StyleMenuListing->None],
Cell[46289, 1863, 94, 2, 70, 41, 0, "StyleData", "Item3Label", "Printout",
 StyleMenuListing->None],
Cell[46386, 1867, 106, 2, 70, 53, 0, "StyleData", "Item3Label", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[46541, 1875, 61, 1, 70, "Subsection"],
Cell[CellGroupData[{
Cell[46627, 1880, 746, 19, 70, 32, 0, "StyleData", "Item1Numbered", "All",
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}},
 StyleMenuListing->None],
Cell[47376, 1901, 122, 3, 70, 48, 0, "StyleData", "Item1Numbered", \
"Presentation",
 StyleMenuListing->None],
Cell[47501, 1906, 116, 3, 70, 44, 0, "StyleData", "Item1Numbered", "Printout",
 
 StyleMenuListing->None],
Cell[47620, 1911, 125, 3, 70, 56, 0, "StyleData", "Item1Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[47782, 1919, 811, 21, 70, 32, 0, "StyleData", "Item2Numbered", "All",
 CounterIncrements->"Item2Numbered",
 CounterAssignments->{{"Item3Numbered", 0}},
 StyleMenuListing->None],
Cell[48596, 1942, 122, 3, 70, 48, 0, "StyleData", "Item2Numbered", \
"Presentation",
 StyleMenuListing->None],
Cell[48721, 1947, 117, 3, 70, 44, 0, "StyleData", "Item2Numbered", "Printout",
 
 StyleMenuListing->None],
Cell[48841, 1952, 126, 3, 70, 56, 0, "StyleData", "Item2Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[49004, 1960, 732, 19, 70, 32, 0, "StyleData", "Item3Numbered", "All",
 CounterIncrements->"Item3Numbered",
 StyleMenuListing->None],
Cell[49739, 1981, 122, 3, 70, 48, 0, "StyleData", "Item3Numbered", \
"Presentation",
 StyleMenuListing->None],
Cell[49864, 1986, 117, 3, 70, 44, 0, "StyleData", "Item3Numbered", "Printout",
 
 StyleMenuListing->None],
Cell[49984, 1991, 126, 3, 70, 56, 0, "StyleData", "Item3Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[50147, 1999, 230, 6, 70, 37, 0, "StyleData", "Item1NumberedLabel", "All",
 
 StyleMenuListing->None],
Cell[50380, 2007, 121, 3, 70, 53, 0, "StyleData", "Item1NumberedLabel", \
"Presentation",
 StyleMenuListing->None],
Cell[50504, 2012, 117, 3, 70, 49, 0, "StyleData", "Item1NumberedLabel", \
"Printout",
 StyleMenuListing->None],
Cell[50624, 2017, 129, 3, 70, 61, 0, "StyleData", "Item1NumberedLabel", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[50790, 2025, 230, 6, 70, 37, 0, "StyleData", "Item2NumberedLabel", "All",
 
 StyleMenuListing->None],
Cell[51023, 2033, 121, 3, 70, 53, 0, "StyleData", "Item2NumberedLabel", \
"Presentation",
 StyleMenuListing->None],
Cell[51147, 2038, 102, 2, 70, 49, 0, "StyleData", "Item2NumberedLabel", \
"Printout",
 StyleMenuListing->None],
Cell[51252, 2042, 114, 2, 70, 61, 0, "StyleData", "Item2NumberedLabel", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[51403, 2049, 230, 6, 70, 37, 0, "StyleData", "Item3NumberedLabel", "All",
 
 StyleMenuListing->None],
Cell[51636, 2057, 121, 3, 70, 53, 0, "StyleData", "Item3NumberedLabel", \
"Presentation",
 StyleMenuListing->None],
Cell[51760, 2062, 102, 2, 70, 49, 0, "StyleData", "Item3NumberedLabel", \
"Printout",
 StyleMenuListing->None],
Cell[51865, 2066, 114, 2, 70, 61, 0, "StyleData", "Item3NumberedLabel", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[52028, 2074, 62, 1, 70, "Subsection"],
Cell[CellGroupData[{
Cell[52115, 2079, 363, 7, 70, 33, 0, "StyleData", "Item1Paragraph", "All",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}},
 StyleMenuListing->None],
Cell[52481, 2088, 123, 3, 70, 49, 0, "StyleData", "Item1Paragraph", \
"Presentation",
 StyleMenuListing->None],
Cell[52607, 2093, 118, 3, 70, 45, 0, "StyleData", "Item1Paragraph", \
"Printout",
 StyleMenuListing->None],
Cell[52728, 2098, 127, 3, 70, 57, 0, "StyleData", "Item1Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[52892, 2106, 341, 7, 70, 33, 0, "StyleData", "Item2Paragraph", "All",
 CounterAssignments->{{"Item3Numbered", 0}},
 StyleMenuListing->None],
Cell[53236, 2115, 123, 3, 70, 49, 0, "StyleData", "Item2Paragraph", \
"Presentation",
 StyleMenuListing->None],
Cell[53362, 2120, 118, 3, 70, 45, 0, "StyleData", "Item2Paragraph", \
"Printout",
 StyleMenuListing->None],
Cell[53483, 2125, 127, 3, 70, 57, 0, "StyleData", "Item2Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[53647, 2133, 296, 6, 70, 33, 0, "StyleData", "Item3Paragraph", "All",
 StyleMenuListing->None],
Cell[53946, 2141, 124, 3, 70, 49, 0, "StyleData", "Item3Paragraph", \
"Presentation",
 StyleMenuListing->None],
Cell[54073, 2146, 118, 3, 70, 45, 0, "StyleData", "Item3Paragraph", \
"Printout",
 StyleMenuListing->None],
Cell[54194, 2151, 127, 3, 70, 57, 0, "StyleData", "Item3Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[54382, 2161, 45, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[54452, 2165, 28, 0, 39, "Subsection"],
Cell[CellGroupData[{
Cell[54505, 2169, 749, 20, 43, 25, 0, "StyleData", "Figure", "All",
 CounterIncrements->"Figure",
 StyleMenuListing->None],
Cell[55257, 2191, 97, 2, 70, 41, 0, "StyleData", "Figure", "Presentation"],
Cell[55357, 2195, 91, 2, 70, 37, 0, "StyleData", "Figure", "Printout"],
Cell[55451, 2199, 103, 2, 70, 49, 0, "StyleData", "Figure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[55591, 2206, 638, 17, 40, 32, 0, "StyleData", "FigureCaption", "All",
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}},
 StyleMenuListing->None],
Cell[56232, 2225, 121, 3, 48, 48, 0, "StyleData", "FigureCaption", \
"Presentation"],
Cell[56356, 2230, 113, 3, 37, 44, 0, "StyleData", "FigureCaption", \
"Printout"],
Cell[56472, 2235, 124, 3, 37, 56, 0, "StyleData", "FigureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[56611, 2241, 182, 5, 40, 37, 0, "StyleData", "FigureCaptionLabel", "All",
 
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[56830, 2251, 28, 0, 39, "Subsection"],
Cell[CellGroupData[{
Cell[56883, 2255, 1103, 28, 34, 24, 0, "StyleData", "Table", "All",
 CounterIncrements->"Table",
 StyleMenuListing->None],
Cell[57989, 2285, 89, 2, 70, 40, 0, "StyleData", "Table", "Presentation"],
Cell[58081, 2289, 108, 3, 84, 36, 0, "StyleData", "Table", "Printout"],
Cell[58192, 2294, 120, 3, 70, 48, 0, "StyleData", "Table", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[58349, 2302, 886, 22, 48, 29, 0, "StyleData", "TableTitle", "All",
 CounterIncrements->"TableTitle",
 CounterAssignments->{{"Nil", 0}},
 StyleMenuListing->None],
Cell[59238, 2326, 95, 2, 65, 45, 0, "StyleData", "TableTitle", \
"Presentation"],
Cell[59336, 2330, 89, 2, 65, 41, 0, "StyleData", "TableTitle", "Printout"],
Cell[59428, 2334, 123, 3, 84, 53, 0, "StyleData", "TableTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[59588, 2342, 168, 5, 40, 34, 0, "StyleData", "TableTitleLabel", "All",
 CounterIncrements->"TableTitle",
 StyleMenuListing->None],
Cell[59759, 2349, 65, 1, 46, 50, 0, "StyleData", "TableTitleLabel", \
"Presentation"],
Cell[59827, 2352, 61, 1, 46, 46, 0, "StyleData", "TableTitleLabel", \
"Printout"],
Cell[59891, 2355, 73, 1, 46, 58, 0, "StyleData", "TableTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[60001, 2361, 49, 0, 34, "Subsubsection"],
Cell[CellGroupData[{
Cell[60075, 2365, 799, 23, 40, 34, 0, "StyleData", "TableColumnHead", "All",
 CounterIncrements->"Table",
 StyleMenuListing->None],
Cell[60877, 2390, 65, 1, 46, 50, 0, "StyleData", "TableColumnHead", \
"Presentation"],
Cell[60945, 2393, 61, 1, 46, 46, 0, "StyleData", "TableColumnHead", \
"Printout"],
Cell[61009, 2396, 73, 1, 46, 58, 0, "StyleData", "TableColumnHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[61119, 2402, 792, 23, 40, 32, 0, "StyleData", "TableSpanHead", "All",
 StyleMenuListing->None],
Cell[61914, 2427, 63, 1, 46, 48, 0, "StyleData", "TableSpanHead", \
"Presentation"],
Cell[61980, 2430, 59, 1, 46, 44, 0, "StyleData", "TableSpanHead", \
"Printout"],
Cell[62042, 2433, 71, 1, 46, 56, 0, "StyleData", "TableSpanHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[62150, 2439, 808, 24, 40, 28, 0, "StyleData", "TableText", "All",
 StyleMenuListing->None],
Cell[62961, 2465, 59, 1, 46, 44, 0, "StyleData", "TableText", \
"Presentation"],
Cell[63023, 2468, 55, 1, 46, 40, 0, "StyleData", "TableText", "Printout"],
Cell[63081, 2471, 89, 2, 65, 52, 0, "StyleData", "TableText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[63207, 2478, 592, 18, 40, 32, 0, "StyleData", "TableSpanText", "All",
 StyleMenuListing->None],
Cell[63802, 2498, 63, 1, 46, 48, 0, "StyleData", "TableSpanText", \
"Presentation"],
Cell[63868, 2501, 59, 1, 46, 44, 0, "StyleData", "TableSpanText", \
"Printout"],
Cell[63930, 2504, 71, 1, 46, 56, 0, "StyleData", "TableSpanText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[64016, 2508, 698, 19, 40, 31, 0, "StyleData", "TableSubGrid", "All",
 StyleMenuListing->None],
Cell[64717, 2529, 420, 11, 40, 34, 0, "StyleData", "TableMasterGrid", "All",
 StyleMenuListing->None],
Cell[65140, 2542, 324, 10, 17, 35, 0, "StyleData", "TableLineElement", "All",
 StyleMenuListing->None],
Cell[65467, 2554, 167, 5, 9, 36, 0, "StyleData", "TableBlankElement", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[65659, 2563, 128, 5, 44, 27, 0, "StyleData", "SpanLeft", "All",
 StyleMenuListing->None],
Cell[65790, 2570, 58, 1, 70, 43, 0, "StyleData", "SpanLeft", "Presentation"],
Cell[65851, 2573, 54, 1, 70, 39, 0, "StyleData", "SpanLeft", "Printout"],
Cell[65908, 2576, 66, 1, 70, 51, 0, "StyleData", "SpanLeft", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[66011, 2582, 130, 5, 44, 29, 0, "StyleData", "SpanCenter", "All",
 StyleMenuListing->None],
Cell[66144, 2589, 60, 1, 70, 45, 0, "StyleData", "SpanCenter", \
"Presentation"],
Cell[66207, 2592, 56, 1, 70, 41, 0, "StyleData", "SpanCenter", "Printout"],
Cell[66266, 2595, 68, 1, 70, 53, 0, "StyleData", "SpanCenter", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[66371, 2601, 129, 5, 44, 28, 0, "StyleData", "SpanRight", "All",
 StyleMenuListing->None],
Cell[66503, 2608, 59, 1, 70, 44, 0, "StyleData", "SpanRight", \
"Presentation"],
Cell[66565, 2611, 55, 1, 70, 40, 0, "StyleData", "SpanRight", "Printout"],
Cell[66623, 2614, 67, 1, 70, 52, 0, "StyleData", "SpanRight", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[66763, 2623, 30, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[66818, 2627, 31, 0, 39, "Subsection"],
Cell[CellGroupData[{
Cell[66874, 2631, 381, 9, 46, 27, 0, "StyleData", "Equation", "All",
 CounterIncrements->"Equation",
 StyleMenuListing->None],
Cell[67258, 2642, 94, 2, 58, 43, 0, "StyleData", "Equation", "Presentation"],
Cell[67355, 2646, 86, 2, 39, 39, 0, "StyleData", "Equation", "Printout"],
Cell[67444, 2650, 98, 2, 39, 51, 0, "StyleData", "Equation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[67579, 2657, 479, 12, 36, 32, 0, "StyleData", "EquationGroup", "All",
 StyleMenuListing->None],
Cell[68061, 2671, 97, 2, 41, 48, 0, "StyleData", "EquationGroup", \
"Presentation"],
Cell[68161, 2675, 91, 2, 30, 44, 0, "StyleData", "EquationGroup", \
"Printout"],
Cell[68255, 2679, 103, 2, 30, 56, 0, "StyleData", "EquationGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[68395, 2686, 694, 16, 36, 39, 0, "StyleData", "EquationGroupAligned", \
"All",
 StyleMenuListing->None],
Cell[69092, 2704, 104, 2, 41, 55, 0, "StyleData", "EquationGroupAligned", \
"Presentation"],
Cell[69199, 2708, 98, 2, 30, 51, 0, "StyleData", "EquationGroupAligned", \
"Printout"],
Cell[69300, 2712, 110, 2, 30, 63, 0, "StyleData", "EquationGroupAligned", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[69459, 2720, 40, 0, 39, "Subsection"],
Cell[CellGroupData[{
Cell[69524, 2724, 928, 23, 46, 35, 0, "StyleData", "EquationNumbered", "All",
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None],
Cell[70455, 2749, 102, 2, 58, 51, 0, "StyleData", "EquationNumbered", \
"Presentation"],
Cell[70560, 2753, 94, 2, 39, 47, 0, "StyleData", "EquationNumbered", \
"Printout"],
Cell[70657, 2757, 131, 3, 39, 59, 0, "StyleData", "EquationNumbered", \
"DoubleSpacedPrintout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[70825, 2765, 1044, 27, 36, 40, 0, "StyleData", "EquationGroupNumbered", \
"All",
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None],
Cell[71872, 2794, 105, 2, 41, 56, 0, "StyleData", "EquationGroupNumbered", \
"Presentation"],
Cell[71980, 2798, 99, 2, 30, 52, 0, "StyleData", "EquationGroupNumbered", \
"Printout"],
Cell[72082, 2802, 111, 2, 30, 64, 0, "StyleData", "EquationGroupNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[72230, 2809, 1259, 31, 36, 47, 0, "StyleData", \
"EquationGroupAlignedNumbered", "All",
 CounterIncrements->"EquationNumbered",
 StyleMenuListing->None],
Cell[73492, 2842, 112, 2, 41, 63, 0, "StyleData", \
"EquationGroupAlignedNumbered", "Presentation"],
Cell[73607, 2846, 106, 2, 30, 59, 0, "StyleData", \
"EquationGroupAlignedNumbered", "Printout"],
Cell[73716, 2850, 118, 2, 30, 71, 0, "StyleData", \
"EquationGroupAlignedNumbered", "DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[73871, 2857, 109, 3, 40, 33, 0, "StyleData", "EquationNumber", "All",
 StyleMenuListing->None],
Cell[73983, 2862, 77, 1, 40, 49, 0, "StyleData", "EquationNumber", \
"Presentation"],
Cell[74063, 2865, 73, 1, 40, 45, 0, "StyleData", "EquationNumber", \
"Printout"],
Cell[74139, 2868, 85, 1, 40, 57, 0, "StyleData", "EquationNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[74273, 2875, 46, 0, 39, "Subsection"],
Cell[74322, 2877, 56, 1, 40, 31, 0, "StyleData", "EquationGrid", "All",
 StyleMenuListing->None],
Cell[74381, 2880, 57, 1, 40, 32, 0, "StyleData", "SplitEquation", "All",
 StyleMenuListing->None],
Cell[74441, 2883, 53, 1, 40, 28, 0, "StyleData", "Piecewise", "All",
 StyleMenuListing->None],
Cell[74497, 2886, 50, 1, 40, 25, 0, "StyleData", "Matrix", "All",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[74596, 2893, 35, 0, 34, "Section"],
Cell[74634, 2895, 178, 4, 103, 23, 0, "StyleData", "XRef", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[74849, 2904, 29, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[74903, 2908, 344, 10, 56, 34, 0, "StyleData", "BackmatterGroup", "All",
 StyleMenuListing->None],
Cell[75250, 2920, 122, 3, 84, 50, 0, "StyleData", "BackmatterGroup", \
"Presentation"],
Cell[75375, 2925, 118, 3, 84, 46, 0, "StyleData", "BackmatterGroup", \
"Printout"],
Cell[75496, 2930, 130, 3, 84, 58, 0, "StyleData", "BackmatterGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[75663, 2938, 30, 0, 26, "Subsection"],
Cell[CellGroupData[{
Cell[75718, 2942, 410, 11, 73, 34, 0, "StyleData", "AppendixSection", "All",
 StyleMenuListing->None],
Cell[76131, 2955, 115, 3, 84, 46, 0, "StyleData", "AppendixSection", \
"Printout"],
Cell[76249, 2960, 127, 3, 84, 58, 0, "StyleData", "AppendixSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[76413, 2968, 541, 15, 54, 39, 0, "StyleData", "AppendixSectionLabel", \
"All",
 CounterIncrements->"AppendixSectionLabel",
 CounterAssignments->{{"Section", 0}, {"AppendixEquation", 0}, {
   "FigureCaption", 0}, {"TableTitle", 0}},
 StyleMenuListing->None],
Cell[76957, 2985, 120, 3, 84, 51, 0, "StyleData", "AppendixSectionLabel", \
"Printout"],
Cell[77080, 2990, 132, 3, 84, 63, 0, "StyleData", "AppendixSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[77249, 2998, 329, 9, 38, 27, 0, "StyleData", "Appendix", "All",
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],
Cell[77581, 3009, 114, 3, 42, 43, 0, "StyleData", "Appendix", \
"Presentation"],
Cell[77698, 3014, 87, 2, 31, 39, 0, "StyleData", "Appendix", "Printout"],
Cell[77788, 3018, 121, 3, 31, 51, 0, "StyleData", "Appendix", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[77946, 3026, 791, 20, 43, 35, 0, "StyleData", "AppendixEquation", "All",
 CounterIncrements->"AppendixEquation",
 StyleMenuListing->None],
Cell[78740, 3048, 62, 1, 46, 47, 0, "StyleData", "AppendixEquation", \
"Printout"],
Cell[78805, 3051, 74, 1, 46, 59, 0, "StyleData", "AppendixEquation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[78928, 3058, 55, 1, 26, "Subsection"],
Cell[CellGroupData[{
Cell[79008, 3063, 558, 16, 331, 33, 0, "StyleData", "EndnoteSection", "All",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}, {
   "Endnote", 0}},
 StyleMenuListing->None],
Cell[79569, 3081, 115, 3, 84, 45, 0, "StyleData", "EndnoteSection", \
"Printout"],
Cell[79687, 3086, 127, 3, 84, 57, 0, "StyleData", "EndnoteSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[79851, 3094, 353, 10, 198, 26, 0, "StyleData", "Endnote", "All",
 CounterIncrements->"Endnote",
 StyleMenuListing->None],
Cell[80207, 3106, 91, 2, 65, 42, 0, "StyleData", "Endnote", "Presentation"],
Cell[80301, 3110, 110, 3, 84, 38, 0, "StyleData", "Endnote", "Printout"],
Cell[80414, 3115, 144, 4, 103, 50, 0, "StyleData", "Endnote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[80595, 3124, 306, 7, 179, 31, 0, "StyleData", "EndnoteLabel", "All",
 CounterIncrements->"EndnoteLabel",
 StyleMenuListing->None],
Cell[80904, 3133, 43, 0, 27, 43, 0, "StyleData", "EndnoteLabel", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[80984, 3138, 145, 4, 103, 32, 0, "StyleData", "EndnoteNumber", "All",
 CounterIncrements->"EndnoteNumber",
 StyleMenuListing->None],
Cell[81132, 3144, 44, 0, 27, 44, 0, "StyleData", "EndnoteNumber", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[81213, 3149, 234, 7, 160, 26, 0, "StyleData", "NoteKey", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[81450, 3158, 80, 1, 70, 42, 0, "StyleData", "NoteKey", "Presentation"],
Cell[81533, 3161, 64, 1, 46, 38, 0, "StyleData", "NoteKey", "Printout"],
Cell[81600, 3164, 76, 1, 70, 50, 0, "StyleData", "NoteKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[81713, 3170, 257, 7, 160, 36, 0, "StyleData", "EndnoteReturnLink", "All",
 
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[81973, 3179, 83, 1, 46, 52, 0, "StyleData", "EndnoteReturnLink", \
"Presentation"],
Cell[82059, 3182, 113, 2, 65, 48, 0, "StyleData", "EndnoteReturnLink", \
"Printout"],
Cell[82175, 3186, 125, 2, 65, 60, 0, "StyleData", "EndnoteReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[82337, 3193, 361, 10, 217, 23, 0, "StyleData", "Note", "All",
 StyleMenuListing->None],
Cell[82701, 3205, 54, 1, 46, 35, 0, "StyleData", "Note", "Printout"],
Cell[82758, 3208, 66, 1, 46, 47, 0, "StyleData", "Note", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[82873, 3215, 32, 0, 26, "Subsection"],
Cell[CellGroupData[{
Cell[82930, 3219, 437, 11, 107, 35, 0, "StyleData", "ReferenceSection", "All",
 
 CounterIncrements->"ReferenceSection",
 CounterAssignments->{{"ReferenceText", 0}, {"BiblioEquation", 0}},
 StyleMenuListing->None],
Cell[83370, 3232, 117, 3, 84, 47, 0, "StyleData", "ReferenceSection", \
"Printout"],
Cell[83490, 3237, 129, 3, 84, 59, 0, "StyleData", "ReferenceSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[83656, 3245, 602, 18, 29, 28, 0, "StyleData", "Reference", "All",
 CounterIncrements->"BibliographyItem",
 StyleMenuListing->None],
Cell[84261, 3265, 138, 4, 103, 44, 0, "StyleData", "Reference", \
"Presentation"],
Cell[84402, 3271, 132, 4, 103, 40, 0, "StyleData", "Reference", "Printout"],
Cell[84537, 3277, 144, 4, 103, 52, 0, "StyleData", "Reference", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[84718, 3286, 285, 9, 35, 33, 0, "StyleData", "ReferenceLabel", "All",
 CounterIncrements->"RefDingbat",
 StyleMenuListing->None],
Cell[85006, 3297, 77, 1, 46, 49, 0, "StyleData", "ReferenceLabel", \
"Presentation"],
Cell[85086, 3300, 73, 1, 46, 45, 0, "StyleData", "ReferenceLabel", \
"Printout"],
Cell[85162, 3303, 85, 1, 46, 57, 0, "StyleData", "ReferenceLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[85262, 3307, 107, 3, 35, 25, 0, "StyleData", "RefSep", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[85394, 3314, 337, 9, 35, 32, 0, "StyleData", "RefReturnLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[85734, 3325, 86, 1, 46, 48, 0, "StyleData", "RefReturnLink", \
"Presentation"],
Cell[85823, 3328, 70, 1, 46, 44, 0, "StyleData", "RefReturnLink", \
"Printout"],
Cell[85896, 3331, 82, 1, 46, 56, 0, "StyleData", "RefReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[86015, 3337, 388, 11, 37, 35, 0, "StyleData", "RefReturnPointer", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[86406, 3350, 51, 0, 27, 51, 0, "StyleData", "RefReturnPointer", \
"Presentation"],
Cell[86460, 3352, 73, 1, 46, 47, 0, "StyleData", "RefReturnPointer", \
"Printout"],
Cell[86536, 3355, 85, 1, 46, 59, 0, "StyleData", "RefReturnPointer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[86658, 3361, 386, 11, 24, 38, 0, "StyleData", "ReferenceSourceLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[87047, 3374, 76, 1, 70, 50, 0, "StyleData", "ReferenceSourceLink", \
"Printout"]
}, Closed]],
Cell[87138, 3378, 62, 1, 35, 37, 0, "StyleData", "ReferenceSourceURL", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[87225, 3383, 332, 9, 35, 27, 0, "StyleData", "Citation", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[87560, 3394, 81, 1, 70, 43, 0, "StyleData", "Citation", "Presentation"],
Cell[87644, 3397, 65, 1, 70, 39, 0, "StyleData", "Citation", "Printout"],
Cell[87712, 3400, 77, 1, 70, 51, 0, "StyleData", "Citation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[87826, 3406, 232, 7, 35, 25, 0, "StyleData", "RefKey", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[88061, 3415, 79, 1, 70, 41, 0, "StyleData", "RefKey", "Presentation"],
Cell[88143, 3418, 63, 1, 70, 37, 0, "StyleData", "RefKey", "Printout"],
Cell[88209, 3421, 75, 1, 70, 49, 0, "StyleData", "RefKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[88321, 3427, 70, 1, 18, "Subsubsection"],
Cell[88394, 3430, 83, 1, 33, "ReferenceTemplate"],
Cell[88480, 3433, 86, 1, 33, "ReferenceTemplate"],
Cell[88569, 3436, 86, 1, 33, "ReferenceTemplate"],
Cell[88658, 3439, 82, 1, 33, "ReferenceTemplate"],
Cell[88743, 3442, 85, 1, 33, "ReferenceTemplate"],
Cell[88831, 3445, 84, 1, 33, "ReferenceTemplate"],
Cell[88918, 3448, 41, 0, 33, "ReferenceTemplate"],
Cell[88962, 3450, 49, 0, 33, "ReferenceTemplate"],
Cell[89014, 3452, 49, 0, 33, "ReferenceTemplate"],
Cell[89066, 3454, 49, 0, 33, "ReferenceTemplate"],
Cell[89118, 3456, 49, 0, 33, "ReferenceTemplate"],
Cell[89170, 3458, 56, 0, 33, "ReferenceTemplate"],
Cell[89229, 3460, 56, 0, 33, "ReferenceTemplate"],
Cell[CellGroupData[{
Cell[89310, 3464, 45, 0, 28, "Subsubsubsection"],
Cell[89358, 3466, 191, 4, 70, "ReferenceTemplate"],
Cell[89552, 3472, 152, 3, 70, "ReferenceTemplate"],
Cell[89707, 3477, 177, 3, 70, "ReferenceTemplate"],
Cell[89887, 3482, 139, 3, 70, "ReferenceTemplate"],
Cell[90029, 3487, 172, 3, 70, "ReferenceTemplate"],
Cell[90204, 3492, 136, 3, 70, "ReferenceTemplate"],
Cell[90343, 3497, 159, 3, 70, "ReferenceTemplate"],
Cell[90505, 3502, 123, 3, 70, "ReferenceTemplate"],
Cell[90631, 3507, 185, 4, 70, "ReferenceTemplate"],
Cell[90819, 3513, 146, 3, 70, "ReferenceTemplate"],
Cell[90968, 3518, 166, 3, 70, "ReferenceTemplate"],
Cell[91137, 3523, 133, 3, 70, "ReferenceTemplate"],
Cell[91273, 3528, 166, 3, 70, "ReferenceTemplate"],
Cell[91442, 3533, 130, 3, 70, "ReferenceTemplate"],
Cell[91575, 3538, 153, 3, 70, "ReferenceTemplate"],
Cell[91731, 3543, 117, 3, 70, "ReferenceTemplate"],
Cell[91851, 3548, 176, 4, 70, "ReferenceTemplate"],
Cell[92030, 3554, 137, 3, 70, "ReferenceTemplate"],
Cell[92170, 3559, 162, 3, 70, "ReferenceTemplate"],
Cell[92335, 3564, 124, 3, 70, "ReferenceTemplate"],
Cell[92462, 3569, 157, 3, 70, "ReferenceTemplate"],
Cell[92622, 3574, 121, 3, 70, "ReferenceTemplate"],
Cell[92746, 3579, 144, 3, 70, "ReferenceTemplate"],
Cell[92893, 3584, 106, 2, 70, "ReferenceTemplate"],
Cell[93002, 3588, 146, 3, 70, "Text"],
Cell[93151, 3593, 152, 3, 70, "ReferenceTemplate"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93340, 3601, 45, 0, 26, "Subsubsubsection"],
Cell[93388, 3603, 99, 2, 70, "Text"],
Cell[93490, 3607, 144, 3, 70, "ReferenceTemplate"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93671, 3615, 48, 0, 26, "Subsubsubsection"],
Cell[93722, 3617, 138, 3, 52, "ReferenceTemplate"],
Cell[93863, 3622, 99, 2, 33, "ReferenceTemplate"],
Cell[93965, 3626, 117, 3, 52, "ReferenceTemplate"],
Cell[94085, 3631, 143, 3, 46, "Text"],
Cell[94231, 3636, 85, 1, 33, "ReferenceTemplate"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94353, 3642, 44, 0, 28, "Subsubsubsection"],
Cell[94400, 3644, 168, 3, 70, "ReferenceTemplate"],
Cell[94571, 3649, 133, 3, 70, "ReferenceTemplate"],
Cell[94707, 3654, 148, 3, 70, "Text"],
Cell[94858, 3659, 168, 3, 70, "ReferenceTemplate"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95063, 3667, 54, 0, 26, "Subsubsubsection"],
Cell[95120, 3669, 105, 3, 70, "Text"],
Cell[95228, 3674, 125, 3, 70, "ReferenceTemplate"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95390, 3682, 46, 0, 26, "Subsubsubsection"],
Cell[95439, 3684, 103, 3, 70, "Text"],
Cell[95545, 3689, 87, 1, 70, "ReferenceTemplate"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95669, 3695, 52, 0, 26, "Subsubsubsection"],
Cell[95724, 3697, 127, 3, 70, "Text"],
Cell[95854, 3702, 58, 0, 70, "ReferenceTemplate"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95961, 3708, 74, 1, 18, "Subsubsection"],
Cell[CellGroupData[{
Cell[96060, 3713, 134, 3, 35, 27, 0, "StyleData", "RefTitle", "All",
 StyleMenuListing->None],
Cell[96197, 3718, 39, 0, 70, 39, 0, "StyleData", "RefTitle", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[96273, 3723, 51, 1, 35, 26, 0, "StyleData", "RefType", "All",
 StyleMenuListing->None],
Cell[96327, 3726, 38, 0, 70, 38, 0, "StyleData", "RefType", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[96402, 3731, 50, 1, 35, 25, 0, "StyleData", "RefURL", "All",
 StyleMenuListing->None],
Cell[96455, 3734, 37, 0, 70, 37, 0, "StyleData", "RefURL", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[96529, 3739, 60, 1, 35, 35, 0, "StyleData", "RefRetrievalDate", "All",
 StyleMenuListing->None],
Cell[96592, 3742, 72, 1, 70, 47, 0, "StyleData", "RefRetrievalDate", \
"Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[96701, 3748, 63, 1, 35, 38, 0, "StyleData", "RefSourceOfAbstract", "All",
 
 StyleMenuListing->None],
Cell[96767, 3751, 75, 1, 70, 50, 0, "StyleData", "RefSourceOfAbstract", \
"Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[96857, 3755, 62, 1, 35, 37, 0, "StyleData", "RefInsertedBibText", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[96956, 3761, 72, 1, 18, "Subsubsection"],
Cell[CellGroupData[{
Cell[97053, 3766, 138, 3, 70, 31, 0, "StyleData", "RefBookTitle", "All",
 StyleMenuListing->None],
Cell[97194, 3771, 43, 0, 70, 43, 0, "StyleData", "RefBookTitle", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[97286, 3777, 75, 1, 18, "Subsubsection"],
Cell[CellGroupData[{
Cell[97386, 3782, 59, 1, 70, 34, 0, "StyleData", "RefJournalTitle", "All",
 StyleMenuListing->None],
Cell[97448, 3785, 46, 0, 70, 46, 0, "StyleData", "RefJournalTitle", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[97531, 3790, 141, 3, 70, 35, 0, "StyleData", "RefJournalVolume", "All",
 StyleMenuListing->None],
Cell[97675, 3795, 47, 0, 70, 47, 0, "StyleData", "RefJournalVolume", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[97759, 3800, 60, 1, 70, 35, 0, "StyleData", "RefJournalNumber", "All",
 StyleMenuListing->None],
Cell[97822, 3803, 72, 1, 70, 47, 0, "StyleData", "RefJournalNumber", \
"Printout",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[97943, 3810, 77, 1, 18, "Subsubsection"],
Cell[CellGroupData[{
Cell[98045, 3815, 56, 1, 70, 31, 0, "StyleData", "RefPublisher", "All",
 StyleMenuListing->None],
Cell[98104, 3818, 43, 0, 70, 43, 0, "StyleData", "RefPublisher", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[98184, 3823, 72, 2, 70, 26, 0, "StyleData", "RefCity", "All",
 StyleMenuListing->None],
Cell[98259, 3827, 38, 0, 70, 38, 0, "StyleData", "RefCity", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[98346, 3833, 74, 1, 18, "Subsubsection"],
Cell[98423, 3836, 58, 1, 70, 33, 0, "StyleData", "RefAuthorGroup", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[98506, 3841, 55, 1, 70, 30, 0, "StyleData", "RefAuthorFN", "All",
 StyleMenuListing->None],
Cell[98564, 3844, 42, 0, 70, 42, 0, "StyleData", "RefAuthorFN", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[98643, 3849, 55, 1, 70, 30, 0, "StyleData", "RefAuthorLN", "All",
 StyleMenuListing->None],
Cell[98701, 3852, 42, 0, 70, 42, 0, "StyleData", "RefAuthorLN", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[98780, 3857, 55, 1, 70, 30, 0, "StyleData", "RefAuthorMN", "All",
 StyleMenuListing->None],
Cell[98838, 3860, 42, 0, 70, 42, 0, "StyleData", "RefAuthorMN", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[98929, 3866, 74, 1, 18, "Subsubsection"],
Cell[99006, 3869, 58, 1, 70, 33, 0, "StyleData", "RefEditorGroup", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[99089, 3874, 55, 1, 70, 30, 0, "StyleData", "RefEditorFN", "All",
 StyleMenuListing->None],
Cell[99147, 3877, 42, 0, 70, 42, 0, "StyleData", "RefEditorFN", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[99226, 3882, 55, 1, 70, 30, 0, "StyleData", "RefEditorMN", "All",
 StyleMenuListing->None],
Cell[99284, 3885, 42, 0, 70, 42, 0, "StyleData", "RefEditorMN", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[99363, 3890, 55, 1, 70, 30, 0, "StyleData", "RefEditorLN", "All",
 StyleMenuListing->None],
Cell[99421, 3893, 42, 0, 70, 42, 0, "StyleData", "RefEditorLN", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[99512, 3899, 74, 1, 18, "Subsubsection"],
Cell[CellGroupData[{
Cell[99611, 3904, 53, 1, 46, 28, 0, "StyleData", "RefSchool", "All",
 StyleMenuListing->None],
Cell[99667, 3907, 40, 0, 70, 40, 0, "StyleData", "RefSchool", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[99756, 3913, 84, 1, 18, "Subsubsection"],
Cell[CellGroupData[{
Cell[99865, 3918, 50, 1, 46, 25, 0, "StyleData", "RefDay", "All",
 StyleMenuListing->None],
Cell[99918, 3921, 62, 1, 46, 37, 0, "StyleData", "RefDay", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[100017, 3927, 52, 1, 46, 27, 0, "StyleData", "RefMonth", "All",
 StyleMenuListing->None],
Cell[100072, 3930, 64, 1, 46, 39, 0, "StyleData", "RefMonth", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[100173, 3936, 51, 1, 46, 26, 0, "StyleData", "RefYear", "All",
 StyleMenuListing->None],
Cell[100227, 3939, 38, 0, 27, 38, 0, "StyleData", "RefYear", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[100314, 3945, 111, 2, 18, "Subsubsection"],
Cell[CellGroupData[{
Cell[100450, 3951, 77, 2, 65, 31, 0, "StyleData", "RefFirstPage", "All",
 StyleMenuListing->None],
Cell[100530, 3955, 43, 0, 27, 43, 0, "StyleData", "RefFirstPage", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[100610, 3960, 76, 2, 65, 30, 0, "StyleData", "RefLastPage", "All",
 StyleMenuListing->None],
Cell[100689, 3964, 42, 0, 27, 42, 0, "StyleData", "RefLastPage", "Printout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[100804, 3972, 32, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[100861, 3976, 101, 3, 84, "Subsection"],
Cell[CellGroupData[{
Cell[100987, 3983, 377, 11, 236, 32, 0, "StyleData", "BookPartLabel", "All",
 CounterAssignments->{{"Chapter", 0}},
 StyleMenuListing->None],
Cell[101367, 3996, 163, 5, 122, 44, 0, "StyleData", "BookPartLabel", \
"Printout"],
Cell[101533, 4003, 175, 5, 122, 56, 0, "StyleData", "BookPartLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[101745, 4013, 197, 7, 160, 33, 0, "StyleData", "BookPartNumber", "All",
 StyleMenuListing->None],
Cell[101945, 4022, 107, 3, 84, 45, 0, "StyleData", "BookPartNumber", \
"Printout"],
Cell[102055, 4027, 119, 3, 84, 57, 0, "StyleData", "BookPartNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[102211, 4035, 498, 15, 293, 32, 0, "StyleData", "BookPartTitle", "All",
 CounterIncrements->"Part",
 StyleMenuListing->None],
Cell[102712, 4052, 163, 5, 122, 44, 0, "StyleData", "BookPartTitle", \
"Printout"],
Cell[102878, 4059, 175, 5, 122, 56, 0, "StyleData", "BookPartTitle", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[103102, 4070, 104, 3, 84, "Subsection"],
Cell[CellGroupData[{
Cell[103231, 4077, 582, 16, 312, 35, 0, "StyleData", "BookChapterLabel", \
"All",
 CounterIncrements->"BookChapterLabel",
 CounterAssignments->{{"Section", 0}, {"EquationNumbered", 0}, {
   "FigureCaption", 0}, {"Figure", 0}, {"TableTitle", 0}, {"Table", 0}},
 StyleMenuListing->None],
Cell[103816, 4095, 116, 3, 84, 47, 0, "StyleData", "BookChapterLabel", \
"Printout"],
Cell[103935, 4100, 128, 3, 84, 59, 0, "StyleData", "BookChapterLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[104100, 4108, 200, 7, 160, 36, 0, "StyleData", "BookChapterNumber", \
"All",
 StyleMenuListing->None],
Cell[104303, 4117, 110, 3, 84, 48, 0, "StyleData", "BookChapterNumber", \
"Printout"],
Cell[104416, 4122, 122, 3, 84, 60, 0, "StyleData", "BookChapterNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[104575, 4130, 314, 8, 179, 35, 0, "StyleData", "BookChapterTitle", "All",
 
 StyleMenuListing->None],
Cell[104892, 4140, 116, 3, 84, 47, 0, "StyleData", "BookChapterTitle", \
"Printout"],
Cell[105011, 4145, 128, 3, 84, 59, 0, "StyleData", "BookChapterTitle", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[105200, 4155, 38, 0, 34, "Section"],
Cell[105241, 4157, 97, 3, 84, 25, 0, "StyleData", "Header", "All",
 StyleMenuListing->None],
Cell[105341, 4162, 96, 3, 84, 25, 0, "StyleData", "Footer", "All",
 StyleMenuListing->None],
Cell[105440, 4167, 101, 3, 84, 29, 0, "StyleData", "PageNumber", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[105578, 4175, 32, 0, 34, "Section"],
Cell[105613, 4177, 254, 6, 40, 34, 0, "StyleData", "TextSuperscript", "All",
 StyleMenuListing->None],
Cell[105870, 4185, 194, 5, 40, 32, 0, "StyleData", "TextSubscript", "All",
 StyleMenuListing->None],
Cell[106067, 4192, 104, 3, 40, 22, 0, "StyleData", "Nil", "All",
 StyleMenuListing->None],
Cell[106174, 4197, 52, 1, 40, 27, 0, "StyleData", "Verbatim", "All",
 StyleMenuListing->None],
Cell[106229, 4200, 115, 3, 40, 26, 0, "StyleData", "TeXName", "All",
 StyleMenuListing->None],
Cell[106347, 4205, 119, 3, 40, 28, 0, "StyleData", "LaTeXName", "All",
 StyleMenuListing->None],
Cell[106469, 4210, 121, 3, 40, 29, 0, "StyleData", "LaTeXeName", "All",
 StyleMenuListing->None],
Cell[106593, 4215, 111, 3, 40, 34, 0, "StyleData", "ChemicalElement", "All",
 StyleMenuListing->None],
Cell[106707, 4220, 88, 2, 40, 34, 0, "StyleData", "CustomCharacter", "All",
 StyleMenuListing->None],
Cell[106798, 4224, 51, 1, 40, 26, 0, "StyleData", "Palette", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[106874, 4229, 546, 17, 8, 28, 0, "StyleData", "PageBreak", "All",
 StyleMenuListing->None],
Cell[107423, 4248, 116, 3, 70, 40, 0, "StyleData", "PageBreak", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[107576, 4256, 172, 6, 55, 31, 0, "StyleData", "CreationDate", "All",
 StyleMenuListing->None],
Cell[107751, 4264, 111, 3, 70, 43, 0, "StyleData", "CreationDate", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[107899, 4272, 39, 0, 35, "Subsection"],
Cell[CellGroupData[{
Cell[107963, 4276, 146, 4, 70, 29, 0, "StyleData", "SingleLine", "All",
 StyleMenuListing->None],
Cell[108112, 4282, 133, 3, 70, 41, 0, "StyleData", "SingleLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[108282, 4290, 255, 8, 70, 29, 0, "StyleData", "DoubleLine", "All",
 StyleMenuListing->None],
Cell[108540, 4300, 88, 2, 70, 41, 0, "StyleData", "DoubleLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[108665, 4307, 278, 9, 70, 27, 0, "StyleData", "ThinLine", "All",
 StyleMenuListing->None],
Cell[108946, 4318, 39, 0, 70, 39, 0, "StyleData", "ThinLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[109022, 4323, 278, 9, 70, 29, 0, "StyleData", "MediumLine", "All",
 StyleMenuListing->None],
Cell[109303, 4334, 41, 0, 70, 41, 0, "StyleData", "MediumLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[109381, 4339, 277, 9, 70, 28, 0, "StyleData", "ThickLine", "All",
 StyleMenuListing->None],
Cell[109661, 4350, 40, 0, 70, 40, 0, "StyleData", "ThickLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[109738, 4355, 98, 2, 70, 25, 0, "StyleData", "Spacer", "All",
 StyleMenuListing->None],
Cell[109839, 4359, 37, 0, 70, 37, 0, "StyleData", "Spacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[109913, 4364, 54, 1, 70, 29, 0, "StyleData", "TextSpacer", "All",
 StyleMenuListing->None],
Cell[109970, 4367, 41, 0, 70, 41, 0, "StyleData", "TextSpacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[110048, 4372, 57, 1, 70, 32, 0, "StyleData", "SectionSpacer", "All",
 StyleMenuListing->None],
Cell[110108, 4375, 44, 0, 70, 44, 0, "StyleData", "SectionSpacer", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[110189, 4380, 58, 1, 70, 33, 0, "StyleData", "GraphicsSpacer", "All",
 StyleMenuListing->None],
Cell[110250, 4383, 45, 0, 70, 45, 0, "StyleData", "GraphicsSpacer", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[110344, 4389, 29, 0, 35, "Subsection"],
Cell[CellGroupData[{
Cell[110398, 4393, 472, 13, 51, 27, 0, "StyleData", "Outline1", "All",
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}},
 StyleMenuListing->None],
Cell[110873, 4408, 124, 3, 70, 43, 0, "StyleData", "Outline1", \
"Presentation"],
Cell[111000, 4413, 86, 2, 70, 39, 0, "StyleData", "Outline1", "Printout"],
Cell[111089, 4417, 98, 2, 70, 51, 0, "StyleData", "Outline1", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[111224, 4424, 129, 4, 40, 32, 0, "StyleData", "Outline1Label", "All",
 StyleMenuListing->None],
Cell[111356, 4430, 76, 1, 70, 48, 0, "StyleData", "Outline1Label", \
"Presentation"],
Cell[111435, 4433, 72, 1, 70, 44, 0, "StyleData", "Outline1Label", \
"Printout"],
Cell[111510, 4436, 84, 1, 70, 56, 0, "StyleData", "Outline1Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[111631, 4442, 494, 14, 47, 27, 0, "StyleData", "Outline2", "All",
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}},
 StyleMenuListing->None],
Cell[112128, 4458, 94, 2, 70, 43, 0, "StyleData", "Outline2", \
"Presentation"],
Cell[112225, 4462, 87, 2, 70, 39, 0, "StyleData", "Outline2", "Printout"],
Cell[112315, 4466, 99, 2, 70, 51, 0, "StyleData", "Outline2", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[112451, 4473, 129, 4, 40, 32, 0, "StyleData", "Outline2Label", "All",
 StyleMenuListing->None],
Cell[112583, 4479, 76, 1, 70, 48, 0, "StyleData", "Outline2Label", \
"Presentation"],
Cell[112662, 4482, 72, 1, 70, 44, 0, "StyleData", "Outline2Label", \
"Printout"],
Cell[112737, 4485, 84, 1, 70, 56, 0, "StyleData", "Outline2Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[112858, 4491, 440, 12, 44, 27, 0, "StyleData", "Outline3", "All",
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}},
 StyleMenuListing->None],
Cell[113301, 4505, 94, 2, 70, 43, 0, "StyleData", "Outline3", \
"Presentation"],
Cell[113398, 4509, 87, 2, 70, 39, 0, "StyleData", "Outline3", "Printout"],
Cell[113488, 4513, 99, 2, 70, 51, 0, "StyleData", "Outline3", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[113624, 4520, 129, 4, 40, 32, 0, "StyleData", "Outline3Label", "All",
 StyleMenuListing->None],
Cell[113756, 4526, 76, 1, 70, 48, 0, "StyleData", "Outline3Label", \
"Presentation"],
Cell[113835, 4529, 72, 1, 46, 44, 0, "StyleData", "Outline3Label", \
"Printout"],
Cell[113910, 4532, 84, 1, 70, 56, 0, "StyleData", "Outline3Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[114031, 4538, 418, 11, 43, 27, 0, "StyleData", "Outline4", "All",
 CounterIncrements->"Outline4",
 StyleMenuListing->None],
Cell[114452, 4551, 95, 2, 65, 43, 0, "StyleData", "Outline4", \
"Presentation"],
Cell[114550, 4555, 87, 2, 65, 39, 0, "StyleData", "Outline4", "Printout"],
Cell[114640, 4559, 99, 2, 65, 51, 0, "StyleData", "Outline4", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[114776, 4566, 129, 4, 40, 32, 0, "StyleData", "Outline4Label", "All",
 StyleMenuListing->None],
Cell[114908, 4572, 76, 1, 46, 48, 0, "StyleData", "Outline4Label", \
"Presentation"],
Cell[114987, 4575, 72, 1, 46, 44, 0, "StyleData", "Outline4Label", \
"Printout"],
Cell[115062, 4578, 84, 1, 46, 56, 0, "StyleData", "Outline4Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[115183, 4584, 238, 6, 39, 30, 0, "StyleData", "OutlineText", "All",
 CounterIncrements->"Text",
 StyleMenuListing->None],
Cell[115424, 4592, 96, 2, 65, 46, 0, "StyleData", "OutlineText", \
"Presentation"],
Cell[115523, 4596, 135, 4, 103, 42, 0, "StyleData", "OutlineText", \
"Printout"],
Cell[115661, 4602, 147, 4, 103, 54, 0, "StyleData", "OutlineText", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[115857, 4612, 32, 0, 35, "Subsection"],
Cell[CellGroupData[{
Cell[115914, 4616, 1070, 30, 445, 41, 0, "StyleData", \
"SlideShowNavigationBar", "All",
 CounterIncrements->"SlideShowNavigationBar",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],
Cell[116987, 4648, 193, 5, 27, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[117217, 4658, 310, 10, 54, 33, 0, "StyleData", "SlideHyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[117530, 4670, 115, 2, 54, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"],
Cell[117648, 4674, 127, 2, 54, 57, 0, "StyleData", "SlideHyperlink", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[117836, 4683, 32, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[117893, 4687, 70, 1, 39, "Subsection"],
Cell[117966, 4690, 89, 3, 40, 21, 0, "StyleData", "RM", "All",
 StyleMenuListing->None],
Cell[118058, 4695, 116, 3, 40, 21, 0, "StyleData", "BF", "All",
 StyleMenuListing->None],
Cell[118177, 4700, 154, 4, 40, 21, 0, "StyleData", "IT", "All",
 StyleMenuListing->None],
Cell[118334, 4706, 164, 4, 35, 28, 0, "StyleData", "SmallCaps", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[118535, 4715, 76, 1, 39, "Subsection"],
Cell[118614, 4718, 111, 4, 40, 21, 0, "StyleData", "TR", "All",
 StyleMenuListing->None],
Cell[118728, 4724, 198, 6, 40, 21, 0, "StyleData", "TI", "All",
 StyleMenuListing->None],
Cell[118929, 4732, 196, 6, 40, 21, 0, "StyleData", "TB", "All",
 StyleMenuListing->None],
Cell[119128, 4740, 208, 6, 40, 22, 0, "StyleData", "TBI", "All",
 StyleMenuListing->None],
Cell[119339, 4748, 285, 8, 40, 21, 0, "StyleData", "MR", "All",
 StyleMenuListing->None],
Cell[119627, 4758, 296, 8, 41, 21, 0, "StyleData", "MO", "All",
 StyleMenuListing->None],
Cell[119926, 4768, 294, 8, 41, 21, 0, "StyleData", "MB", "All",
 StyleMenuListing->None],
Cell[120223, 4778, 312, 9, 41, 22, 0, "StyleData", "MBO", "All",
 StyleMenuListing->None],
Cell[120538, 4789, 201, 6, 40, 21, 0, "StyleData", "SR", "All",
 StyleMenuListing->None],
Cell[120742, 4797, 212, 6, 40, 21, 0, "StyleData", "SO", "All",
 StyleMenuListing->None],
Cell[120957, 4805, 210, 6, 40, 21, 0, "StyleData", "SB", "All",
 StyleMenuListing->None],
Cell[121170, 4813, 228, 7, 40, 22, 0, "StyleData", "SBO", "All",
 StyleMenuListing->None],
Cell[121401, 4822, 122, 2, 40, 32, 0, "StyleData", "PlainGreekWin", "All"],
Cell[121526, 4826, 114, 2, 40, 32, 0, "StyleData", "PlainGreekMac", "All"],
Cell[121643, 4830, 114, 2, 40, 32, 0, "StyleData", "PlainGreekLin", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[121794, 4837, 32, 0, 39, "Subsection"],
Cell[CellGroupData[{
Cell[121851, 4841, 376, 10, 70, 28, 0, "StyleData", "Hyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[122230, 4853, 120, 3, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[122387, 4861, 275, 8, 70, 29, 0, "StyleData", "XMLWebLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[122665, 4871, 106, 2, 70, 41, 0, "StyleData", "XMLWebLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[122808, 4878, 50, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[122883, 4882, 303, 8, 70, 32, 0, "StyleData", "UserGuideLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[123189, 4892, 109, 2, 70, 44, 0, "StyleData", "UserGuideLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[123335, 4899, 303, 8, 70, 32, 0, "StyleData", "ReferenceLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[123641, 4909, 109, 2, 70, 44, 0, "StyleData", "ReferenceLink", \
"Printout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[123823, 4919, 25, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[123873, 4923, 64, 1, 39, "Subsection"],
Cell[123940, 4926, 304, 7, 122, "Text"],
Cell[124247, 4935, 304, 10, 40, 33, 0, "StyleData", "CellExpression", "All",
 StyleMenuListing->None],
Cell[124554, 4947, 103, 3, 40, 28, 0, "StyleData", "InputForm", "All",
 StyleMenuListing->None],
Cell[124660, 4952, 146, 5, 40, 29, 0, "StyleData", "OutputForm", "All",
 StyleMenuListing->None],
Cell[124809, 4959, 336, 7, 40, 31, 0, "StyleData", "StandardForm", "All",
 StyleMenuListing->None],
Cell[125148, 4968, 174, 5, 40, 34, 0, "StyleData", "TraditionalForm", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[125359, 4978, 53, 0, 39, "Subsection"],
Cell[125415, 4980, 147, 4, 46, 36, 0, "StyleData", "ReferenceTemplate", "All",
 
 StyleMenuListing->None],
Cell[125565, 4986, 161, 4, 46, 50, 0, "StyleData", \
"AuthorFormCustomizationTemplate", "All",
 StyleMenuListing->None],
Cell[125729, 4992, 144, 4, 46, 33, 0, "StyleData", "CSSDefinitions", "All",
 StyleMenuListing->None],
Cell[125876, 4998, 143, 4, 46, 32, 0, "StyleData", "LaTeXPreamble", "All",
 StyleMenuListing->None],
Cell[126022, 5004, 143, 4, 46, 32, 0, "StyleData", "DOCTYPEFormat", "All",
 StyleMenuListing->None],
Cell[126168, 5010, 147, 4, 46, 36, 0, "StyleData", "ValidationSetting", "All",
 
 StyleMenuListing->None],
Cell[126318, 5016, 149, 4, 46, 38, 0, "StyleData", "XRefPaletteSettings", \
"All",
 StyleMenuListing->None],
Cell[126470, 5022, 142, 4, 46, 31, 0, "StyleData", "MiscSettings", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[126649, 5031, 59, 1, 35, "Subsection"],
Cell[126711, 5034, 116, 5, 70, "Text"],
Cell[126830, 5041, 109, 3, 70, 29, 0, "StyleData", "InlineCell", "All",
 StyleMenuListing->None],
Cell[126942, 5046, 114, 2, 70, 36, 0, "StyleData", "InlineCellEditing", "All",
 
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[127093, 5053, 54, 1, 35, "Subsection"],
Cell[127150, 5056, 122, 5, 70, "Text"],
Cell[127275, 5063, 216, 5, 70, 24, 0, "StyleData", "Paste", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[127494, 5070, 173, 4, 70, 29, 0, "StyleData", "StyleApply", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[127670, 5076, 215, 5, 70, 45, 0, "StyleData", \
"StyleApplyWithVerification", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[127888, 5083, 285, 7, 70, 35, 0, "StyleData", "ConvertCharacter", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic]
}, Closed]],
Cell[CellGroupData[{
Cell[128210, 5095, 56, 1, 35, "Subsection"],
Cell[128269, 5098, 330, 9, 70, "Text"],
Cell[128602, 5109, 107, 2, 70, 35, 0, "StyleData", "UnmatchedBracket", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[128746, 5116, 60, 1, 35, "Subsection"],
Cell[128809, 5119, 184, 5, 70, 55, 0, "StyleData", \
"DialogStyleSheetMisapplicationEscape", "All",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[129042, 5130, 30, 0, 34, "Section"],
Cell[CellGroupData[{
Cell[129097, 5134, 59, 1, 36, "Subsection"],
Cell[129159, 5137, 364, 6, 71, "Text"],
Cell[CellGroupData[{
Cell[129548, 5147, 661, 20, 41, 24, 0, "StyleData", "Input", "All",
 CounterIncrements->"Input",
 StyleMenuListing->None],
Cell[130212, 5169, 127, 3, 70, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[130376, 5177, 847, 27, 37, 32, 0, "StyleData", "InputNumbered", "All",
 CounterIncrements->"Input",
 StyleMenuListing->None],
Cell[131226, 5206, 135, 3, 70, 44, 0, "StyleData", "InputNumbered", \
"Printout"]
}, Closed]],
Cell[131376, 5212, 314, 11, 35, 28, 0, "StyleData", "InputOnly", "All",
 CounterIncrements->"Input",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[131715, 5227, 604, 18, 39, 25, 0, "StyleData", "Output", "All",
 CounterIncrements->"Output",
 StyleMenuListing->None],
Cell[132322, 5247, 84, 2, 70, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[132443, 5254, 501, 15, 35, 26, 0, "StyleData", "Message", "All",
 CounterIncrements->"Message",
 StyleMenuListing->None],
Cell[132947, 5271, 135, 3, 70, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[133119, 5279, 532, 18, 31, 24, 0, "StyleData", "Print", "All",
 CounterIncrements->"Print",
 StyleMenuListing->None],
Cell[133654, 5299, 111, 3, 38, 40, 0, "StyleData", "Print", "Presentation"],
Cell[133768, 5304, 84, 2, 28, 36, 0, "StyleData", "Print", "Printout"],
Cell[133855, 5308, 118, 3, 28, 48, 0, "StyleData", "Print", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[133988, 5314, 276, 7, 37, "Text"],
Cell[CellGroupData[{
Cell[134289, 5325, 502, 17, 34, 27, 0, "StyleData", "Graphics", "All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[134794, 5344, 140, 4, 32, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[134971, 5353, 149, 5, 33, 28, 0, "StyleData", "CellLabel", "All",
 StyleMenuListing->None],
Cell[135123, 5360, 126, 4, 33, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[135298, 5370, 66, 1, 36, "Subsection"],
Cell[CellGroupData[{
Cell[135389, 5375, 55, 1, 40, 30, 0, "StyleData", "MathCaption", "All",
 StyleMenuListing->None],
Cell[135447, 5378, 67, 1, 40, 42, 0, "StyleData", "MathCaption", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[135551, 5384, 52, 1, 40, 27, 0, "StyleData", "UserTips", "All",
 StyleMenuListing->None],
Cell[135606, 5387, 64, 1, 40, 39, 0, "StyleData", "UserTips", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[135707, 5393, 56, 1, 40, 31, 0, "StyleData", "UserTipsList", "All",
 StyleMenuListing->None],
Cell[135766, 5396, 68, 1, 40, 43, 0, "StyleData", "UserTipsList", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[135871, 5402, 56, 1, 40, 31, 0, "StyleData", "IndentedText", "All",
 StyleMenuListing->None],
Cell[135930, 5405, 68, 1, 40, 43, 0, "StyleData", "IndentedText", "Printout",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[136047, 5412, 45, 0, 28, "Subsection"],
Cell[CellGroupData[{
Cell[136117, 5416, 466, 13, 40, 35, 0, "StyleData", "Item1NumberedNew", "All",
 
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item1Numbered", 0}},
 StyleMenuListing->None],
Cell[136586, 5431, 188, 6, 34, 47, 0, "StyleData", "Item1NumberedNew", \
"Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[136811, 5442, 466, 13, 39, 35, 0, "StyleData", "Item2NumberedNew", "All",
 
 CounterIncrements->"Item2Numbered",
 CounterAssignments->{{"Item2Numbered", 0}},
 StyleMenuListing->None],
Cell[137280, 5457, 189, 6, 34, 47, 0, "StyleData", "Item2NumberedNew", \
"Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[137506, 5468, 466, 13, 39, 35, 0, "StyleData", "Item3NumberedNew", "All",
 
 CounterIncrements->"Item3Numbered",
 CounterAssignments->{{"Item3Numbered", 0}},
 StyleMenuListing->None],
Cell[137975, 5483, 189, 6, 34, 47, 0, "StyleData", "Item3NumberedNew", \
"Printout",
 StyleMenuListing->None]
}, Closed]]
}, Closed]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
