(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    174506,       5757]
NotebookOptionsPosition[    114838,       4309]
NotebookOutlinePosition[    115235,       4326]
CellTagsIndexPosition[    115192,       4323]
MenuPosition->1100
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[StyleData[StyleDefinitions -> "PublicationDefault.nb"]],

Cell["\<\
Modify the definitions below to change the default appearance of all cells in \
a given style. 
Make modifications to any definition using commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
 ReturnCreatesNewCell->True,
 DefaultNewCellStyle->"Title"],

Cell["\"LaTeXCompatibilityWarning\"->True", "MiscSettings"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Styles for Publication\[Hyphen]ready Documents\
\>", "Section"],

Cell[CellGroupData[{

Cell["Frontmatter", "Subsection"],

Cell[CellGroupData[{

Cell["Author", "Subsubsection"],

Cell[StyleData["Author"],
 CellMargins->{{36, 144}, {0, 24}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\author{", "}"}},
 DefaultNewCellStyle->"Section",
 DefaultReturnCreatedCellStyle->"Institution",
 MenuPosition->2000,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell["Table of Contents", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell["Book", "Subsubsubsection"],

Cell[CellGroupData[{

Cell["Title Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookHeading"],
 CellMargins->{{12, 12}, {98, 149}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"\n\n\\tableofcontents", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 LineSpacing->{1, 2},
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["TOCHeading", "Printout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24],

Cell[StyleData["TOCBookHeading", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 118}},
 PageBreakAbove->True,
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustrations"],
 CellMargins->{{12, 12}, {98, 149}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"\n\n\\listoffigures", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["TOCIllustrations", "Printout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24],

Cell[StyleData["TOCBookIllustrations", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTables"],
 CellMargins->{{12, 12}, {98, 149}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"\n\n\\listoftables", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}},
 FontFamily->"Helvetica",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookTables", "Printout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24],

Cell[StyleData["TOCBookTables", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Contents Headings", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFrontmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCBookFrontmatterHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookFrontmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["TOCBookFrontmatterHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->10],

Cell[StyleData["TOCBookFrontmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookBackmatterHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"TOC\"><tr><td><p class=\"TOCBookBackmatterHeading\">", 
     "</td></tr></table>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookBackmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["TOCBookBackmatterHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->10],

Cell[StyleData["TOCBookBackmatterHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFrontBackHeading"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {"<p class=\"TOCBookFrontBackHeading\">", "</p>"}},
 TabSpacings->54,
 CounterIncrements->"TOCBookFrontBackHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}},
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["TOCBookFrontBackHeading", "Printout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->10],

Cell[StyleData["TOCBookFrontBackHeading", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 0}},
 TabSpacings->46,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPartTitle"],
 CellMargins->{{36, 12}, {1, 12}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookPartTitle'><span \
class='Ignore'>Part `1` &nbsp;</span>", "TOCBookPartTitle"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Part ", 
       CounterBox["TOCBookPartTitle"]}], "TOCBookPartTitleLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"TOCBookPartTitle",
 CounterAssignments->{{"TOCBookChapterTitle", 0}},
 FontFamily->"Helvetica",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["TOCBookPartTitle", "Printout"],
 CellMargins->{{22, 2}, {0, 10}},
 FontSize->12],

Cell[StyleData["TOCBookPartTitle", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 10}},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookChapterTitle"],
 CellMargins->{{12, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookChapterTitle'><span \
class='Ignore'>`1` &nbsp;</span>", "TOCBookChapterTitle"], 
     "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"]}], "TOCBookChapterTitleLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->54,
 CounterIncrements->"TOCBookChapterTitle",
 CounterAssignments->{{"TOCBookSection", 0}},
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["TOCBookChapterTitle", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46,
 FontSize->10],

Cell[StyleData["TOCBookChapterTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->46,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSection"],
 CellMargins->{{36, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookSection'><span \
class='Ignore'>`1`.`2` &nbsp;</span>", "TOCBookChapterTitle", 
      "TOCBookSection"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"], ".", 
       CounterBox["TOCBookSection"]}], "TOCBookSectionLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->49.87,
 CounterIncrements->"TOCBookSection",
 CounterAssignments->{{"TOCBookSubsection", 0}}],

Cell[StyleData["TOCBookSection", "Printout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->41.8,
 FontSize->10],

Cell[StyleData["TOCBookSection", "DoubleSpacedPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->41.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSubsection"],
 CellMargins->{{60, 12}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 60},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookSubsection'><span \
class='Ignore'>`1`.`2`.`3` &nbsp;</span>", "TOCBookChapterTitle", 
      "TOCBookSection", "TOCBookSubsection"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["TOCBookChapterTitle"], ".", 
       CounterBox["TOCBookSection"], ".", 
       CounterBox["TOCBookSubsection"]}], "TOCBookSubsectionLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->45.8,
 CounterIncrements->"TOCBookSubsection"],

Cell[StyleData["TOCBookSubsection", "Printout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->36.7,
 FontSize->10],

Cell[StyleData["TOCBookSubsection", "DoubleSpacedPrintout"],
 CellMargins->{{48, 2}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->36.7,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFigure"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookFigure'><span \
class='Ignore'>Fig. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookFigure"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Fig. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookFigure"], "."}], "TOCBookFigureLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookFigure"],

Cell[StyleData["TOCBookFigure", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookFigure", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSupplemental"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookSupplemental'><span \
class='Ignore'>Supp. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookSupplemental"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Supp. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookSupplemental"], "."}], "TOCBookSupplementalLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookSupplemental"],

Cell[StyleData["TOCBookSupplemental", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookSupplemental", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPicture"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookPicture'><span \
class='Ignore'>Pict. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookPicture"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Pict. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookPicture"], "."}], "TOCBookPictureLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookPicture"],

Cell[StyleData["TOCBookPicture", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookPicture", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustration"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookIllustration'><span \
class='Ignore'>Illus. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookIllustration"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Illus. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookIllustration"], "."}], "TOCBookIllustrationLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookIllustration"],

Cell[StyleData["TOCBookIllustration", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookIllustration", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookProgram"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookProgram'><span \
class='Ignore'>Pgm. `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookProgram"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Pgm. ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookProgram"], "."}], "TOCBookProgramLabel", 
     CellBaseline -> Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookProgram"],

Cell[StyleData["TOCBookProgram", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookProgram", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTable"],
 CellMargins->{{12, 12}, {1, 1}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {
     $CellContext`IncludeCount[
     "<table class=\"TOC\"><tr><td><p class='TOCBookTable'><span \
class='Ignore'>Table `1`.`2`. &nbsp;</span>", "TOCBookFrontBackHeading", 
      "TOCBookTable"], "</td></tr></table>"}},
 CellFrameLabels->{{
    Cell[
     TextData[{"Table ", 
       CounterBox["TOCBookFrontBackHeading"], ".", 
       CounterBox["TOCBookTable"], "."}], "TOCBookTableLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 TabSpacings->48.5,
 CounterIncrements->"TOCBookTable"],

Cell[StyleData["TOCBookTable", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10],

Cell[StyleData["TOCBookTable", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 TabSpacings->40.8,
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Labels and misc", "Subsubsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSpacer"],
 CellMargins->{{12, 12}, {0, 0}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["TOCBookSpacer", "Printout"],
 CellMargins->{{2, 2}, {0, 0}}],

Cell[StyleData["TOCBookSpacer", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPartTitleLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{42, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "Printout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookPartTitleLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookChapterTitleLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{18, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookChapterTitleLabel", "Printout"],
 CellSize->{14, Inherited}],

Cell[StyleData["TOCBookChapterTitleLabel", "DoubleSpacedPrintout"],
 CellSize->{14, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{32, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSectionLabel", "Printout"],
 CellSize->{24, Inherited}],

Cell[StyleData["TOCBookSectionLabel", "DoubleSpacedPrintout"],
 CellSize->{24, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSubsectionLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{44, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSubsectionLabel", "Printout"],
 CellSize->{38, Inherited}],

Cell[StyleData["TOCBookSubsectionLabel", "DoubleSpacedPrintout"],
 CellSize->{38, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookFigureLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookFigureLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookFigureLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookSupplementalLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookSupplementalLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookSupplementalLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPictureLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookPictureLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookPictureLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookIllustrationLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookIllustrationLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookIllustrationLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookProgramLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookProgramLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookProgramLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookTableLabel"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 CellSize->{68, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCBookTableLabel", "Printout"],
 CellSize->{53, Inherited}],

Cell[StyleData["TOCBookTableLabel", "DoubleSpacedPrintout"],
 CellSize->{53, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookLeader"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 TabFilling->". ",
 FontSize->12,
 FontWeight->"Plain"],

Cell[StyleData["TOCBookLeader", "Printout"],
 FontSize->10],

Cell[StyleData["TOCBookLeader", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCBookPageNumber"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {
    "</p></td><td class=\"TOCPage\"><p class=\"TOCBookPageNumber\">", 
     "</p>"}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TOCBookPageNumber", "Printout"],
 CellSize->{21, Inherited}],

Cell[StyleData["TOCBookPageNumber", "DoubleSpacedPrintout"],
 CellSize->{21, Inherited}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mainmatter", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellFrame->{{6, 0}, {0, 1}},
 CellMargins->{{12, 12}, {3, 24}},
 CellGroupingRules->{"SectionGrouping", 30},
 ConversionRules:>{
  "TeX" -> {"\n\\section{", "}"}, 
   "HTML" -> {"<h3 class=\"Section\">", "</h3>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterNumber", ".", "Section"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Section"}},
 PageBreakBelow->False,
 CellFrameMargins->{{8, 8}, {4, 6}},
 CellFrameColor->RGBColor[0.500008, 0.500008, 0.749996],
 TabSpacings->2.1,
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}, {
   "Subsubsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->16,
 FontWeight->"Bold",
 Background->GrayLevel[0.999985]],

Cell[StyleData["Section", "Printout"],
 CellFrame->{{4, 0}, {0, 0.5}},
 CellMargins->{{2, 2}, {3, 21}},
 CellFrameMargins->{{6, 6}, {3, 5}},
 CellFrameColor->GrayLevel[0.6],
 FontSize->14],

Cell[StyleData["Section", "DoubleSpacedPrintout"],
 CellFrame->{{4, 0}, {0, 0.5}},
 CellMargins->{{2, 2}, {3, 21}},
 CellFrameMargins->{{6, 6}, {3, 5}},
 CellFrameColor->GrayLevel[0.6],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
 CellDingbat->None,
 CellMargins->{{12, 12}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 40},
 ConversionRules:>{
  "TeX" -> {"\n\\subsection{", "}"}, 
   "HTML" -> {"<h4 class=\"Subsection\">", "</h4>"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {
      "BookChapterNumber", ".", "Section", ".", "Subsection"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Section"}},
 PageBreakBelow->False,
 TabSpacings->1.7,
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}, {"Subsubsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->13,
 FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
 CellMargins->{{2, 2}, {0, 16}},
 FontSize->11],

Cell[StyleData["Subsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 16}},
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
 CellMargins->{{12, 12}, {0, 6}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 50},
 ConversionRules:>{
  "TeX" -> {"\n\\subsubsection{", "}"}, 
   "HTML" -> {"<h5 class=\"Subsubsection\">", "</h5>"}},
 PageBreakBelow->False,
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->11,
 FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
 CellMargins->{{2, 2}, {0, 5}},
 FontSize->9],

Cell[StyleData["Subsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 5}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsubsection"],
 CellMargins->{{12, 12}, {0, 6}},
 CellGroupingRules->{"SectionGrouping", 60},
 ConversionRules:>{
  "TeX" -> {"\n\\subsubsubsection{", "}"}, 
   "HTML" -> {"<h6 class=\"Subsubsubsection\">", "</h6>"}},
 CounterIncrements->{"Subsubsubsection", "SubsubsubsectionHeader"},
 FontFamily->"Helvetica",
 FontSize->11,
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["Subsubsubsection", "Printout"],
 CellMargins->{{2, 2}, {0, 5}},
 FontSize->9],

Cell[StyleData["Subsubsubsection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {0, 5}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Body Text", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{12, 10}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["Text", "Printout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["Text", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextNoIndent"],
 CellMargins->{{12, 10}, {3, 5}},
 ConversionRules:>{
  "TeX" -> {{"\\noindent ", Automatic, ""}, {
     "\n\n\\noindent ", Automatic, ""}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["TextNoIndent", "Printout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["TextNoIndent", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextContinuation"],
 CellMargins->{{12, 10}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n", Automatic, ""}}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 TextAlignment->Left,
 TextJustification->1,
 Hyphenation->True,
 LineSpacing->{1, 3},
 CounterIncrements->"TextContinuation",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["TextContinuation", "Printout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["TextContinuation", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Itemized Lists", "Subsection"],

Cell[CellGroupData[{

Cell["Bulleted Lists", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1"],
 CellMargins->{{10, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 30}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallSquare]", "Item1Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->6,
 CounterIncrements->"Item1"],

Cell[StyleData["Item1", "Printout"],
 CellMargins->{{0, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1", "DoubleSpacedPrintout"],
 CellMargins->{{0, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2"],
 CellMargins->{{34, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 40}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallSquare]", "Item2Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->6,
 CounterIncrements->"Item2"],

Cell[StyleData["Item2", "Printout"],
 CellMargins->{{18, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2", "DoubleSpacedPrintout"],
 CellMargins->{{18, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3"],
 CellMargins->{{58, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 50}, 
     "TeX" -> {"CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallSquare]", "Item3Label", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->6,
 CounterIncrements->"Item3"],

Cell[StyleData["Item3", "Printout"],
 CellMargins->{{38, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3", "DoubleSpacedPrintout"],
 CellMargins->{{38, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1Label"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Plain"],

Cell[StyleData["Item1Label", "Printout"],
 CellSize->{18, Inherited},
 FontSize->10],

Cell[StyleData["Item1Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Label"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right],

Cell[StyleData["Item2Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Label"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right],

Cell[StyleData["Item3Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Lists", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Numbered"],
 CellMargins->{{12, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 30}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item1Numbered"], "."}], "Item1NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],

Cell[StyleData["Item1Numbered", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Numbered"],
 CellMargins->{{36, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 40}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item2Numbered"], "."}], "Item2NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item2Numbered",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Item2Numbered", "Printout"],
 CellMargins->{{20, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{20, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Numbered"],
 CellMargins->{{60, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\n\\item ", ""}}, {
   "HTML" -> {"<li>", "</li>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 50}, 
     "TeX" -> {"CellGroupEnvironment" -> "enumerate"}, 
     "HTML" -> {"CellGroupEnvironment" -> "ol"}}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Item3Numbered"], "."}], "Item3NumberedLabel", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4,
 CounterIncrements->"Item3Numbered",
 CounterBoxOptions->{CounterFunction:>RomanNumeral}],

Cell[StyleData["Item3Numbered", "Printout"],
 CellMargins->{{40, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Numbered", "DoubleSpacedPrintout"],
 CellMargins->{{40, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item1NumberedLabel", "Printout"],
 CellSize->{18, Inherited},
 FontSize->10],

Cell[StyleData["Item1NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item2NumberedLabel", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item2NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3NumberedLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Item3NumberedLabel", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Item3NumberedLabel", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["List Paragraphs", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Item1Paragraph"],
 CellMargins->{{40, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}}],

Cell[StyleData["Item1Paragraph", "Printout"],
 CellMargins->{{24, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item1Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{24, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Paragraph"],
 CellMargins->{{64, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}}],

Cell[StyleData["Item2Paragraph", "Printout"],
 CellMargins->{{42, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item2Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{42, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Paragraph"],
 CellMargins->{{88, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {"General" -> {"RestartList" -> False}}}],

Cell[StyleData["Item3Paragraph", "Printout"],
 CellMargins->{{62, 2}, {1, 1}},
 FontSize->10],

Cell[StyleData["Item3Paragraph", "DoubleSpacedPrintout"],
 CellMargins->{{62, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Illustrations and Examples", "Subsection"],

Cell[CellGroupData[{

Cell["Figure", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Figure"],
 Editable->False,
 CellMargins->{{12, Inherited}, {8, 6}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\begin{center}", 
     $CellContext`ExtractFigure[], "\n\\end{center}"}},
 TaggingRules:>{
  "CounterSettings" -> {"CounterTarget" -> "Style:FigureCaption"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"Figure",
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["Figure", "Printout"],
 CellMargins->{{2, Inherited}, {6, 4}},
 Magnification->0.8],

Cell[StyleData["Figure", "DoubleSpacedPrintout"],
 CellMargins->{{2, Inherited}, {6, 4}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FigureCaption"],
 CellMargins->{{12, 10}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", "}"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterNumber", ".", "Figure"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Figure"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}},
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["FigureCaption", "Printout"],
 CellMargins->{{2, 2}, {4, 1}},
 FontSize->7],

Cell[StyleData["FigureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {4, 1}},
 LineSpacing->{2, 1},
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FigureCaptionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 FontWeight->"Bold"],

Cell[StyleData["FigureCaptionLabel", "Printout"]],

Cell[StyleData["FigureCaptionLabel", "DoubleSpacedPrintout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Picture", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
 Editable->False,
 CellMargins->{{12, Inherited}, {8, 6}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\begin{center}", 
     $CellContext`ExtractFigure[], "\n\\end{center}"}},
 TaggingRules:>{
  "CounterSettings" -> {"CounterTarget" -> "Style:PictureCaption"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 CounterIncrements->"Picture"],

Cell[StyleData["Picture", "Printout"],
 CellMargins->{{2, Inherited}, {6, 4}},
 Magnification->0.8],

Cell[StyleData["Picture", "DoubleSpacedPrintout"],
 CellMargins->{{2, Inherited}, {6, 4}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureCaption"],
 CellMargins->{{12, 10}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", "}"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterNumber", ".", "Picture"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Picture"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"PictureCaption",
 CounterAssignments->{{"Nil", 0}},
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["PictureCaption", "Printout"],
 CellMargins->{{2, 2}, {4, 1}},
 FontSize->7],

Cell[StyleData["PictureCaption", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {4, 1}},
 LineSpacing->{2, 1},
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureCaptionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 FontWeight->"Bold"],

Cell[StyleData["PictureCaptionLabel", "Printout"]],

Cell[StyleData["PictureCaptionLabel", "DoubleSpacedPrintout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Program/Script", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Program"],
 CellMargins->{{12, 10}, {2, 5}},
 CellGroupingRules->"InputGrouping",
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterNumber", ".", "Program"}, "CounterTarget" -> 
     "Cell", "XRefPrefix" -> "Program"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 CounterIncrements->"Program",
 FontFamily->"Courier"],

Cell[StyleData["Program", "Printout"],
 CellMargins->{{2, 2}, {1, 4}},
 FontSize->10],

Cell[StyleData["Program", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 4}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramCaption"],
 CellMargins->{{12, 10}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\\caption{", "}\n"}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterNumber", ".", "Program"}, "CounterTarget" -> 
     "CellGroup"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> {"figure", "[h]"}}}},
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"ProgramCaption",
 CounterAssignments->{{"Nil", 0}},
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["ProgramCaption", "Printout"],
 CellMargins->{{2, 2}, {2, 4}},
 FontSize->7],

Cell[StyleData["ProgramCaption", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 LineSpacing->{2, 1},
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramCaptionLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 FontWeight->"Bold"],

Cell[StyleData["ProgramCaptionLabel", "Printout"]],

Cell[StyleData["ProgramCaptionLabel", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramNumber"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 FontWeight->"Bold"],

Cell[StyleData["ProgramNumber", "Printout"]],

Cell[StyleData["ProgramNumber", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ProgramText"],
 CellMargins->{{26, 10}, {12, 0}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\programtext{", Automatic, "}"}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Chapter", ".", "Program"}, "CounterTarget" -> 
     "CellGroup"}, 
   "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> "program"}}},
 PageBreakAbove->False,
 TextJustification->1,
 Hyphenation->True,
 CounterIncrements->"ProgramText",
 FontSize->9],

Cell[StyleData["ProgramText", "Printout"],
 CellMargins->{{22, 2}, {12, 0}},
 FontSize->7],

Cell[StyleData["ProgramText", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {12, 0}},
 LineSpacing->{2, 1},
 FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableTitle"],
 PageWidth->530,
 CellMargins->{{12, 10}, {1, 7}},
 CellGroupingRules->"InputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", Automatic, "} "}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90, "AlwaysStartEnvironment" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "table"}}, 
   "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterNumber", ".", "TableTitle"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Table"}},
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitle",
 FontWeight->"Plain",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitle", "Printout"],
 CellMargins->{{2, 10}, {1, 5}},
 FontSize->10],

Cell[StyleData["TableTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {1, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableTitleLabel"],
 Editable->False,
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 LineSpacing->{1, 2},
 CounterIncrements->"TableTitleLabel",
 CounterAssignments->{{"Nil", 0}},
 FontWeight->"Bold",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{40}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["TableTitleLabel", "Printout"],
 FontSize->10],

Cell[StyleData["TableTitleLabel", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Table"],
 Editable->False,
 PageWidth->WindowWidth,
 CellMargins->{{12, 10}, {4, 1}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{
  "TeX" -> {"\n\\begin{tabular}\n", Automatic, "\n\\end{tabular}"}, 
   "HTML" -> {{"", Automatic, ""}, {"", Automatic, ""}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 90}, 
     "TeX" -> {"CellGroupEnvironment" -> "table"}}, 
   "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterNumber", ".", "TableTitle"}, 
     "CounterTarget" -> "CellGroup"}},
 CellHorizontalScrolling->True,
 CounterIncrements->"Table",
 CounterAssignments->{{"TableNote", 0}},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {False, {False}, False}, "ColumnsIndexed" -> {}, "Rows" -> {
     AbsoluteThickness[2], {False}, 
     AbsoluteThickness[0.5]}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.503]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["Table", "Printout"],
 PageWidth->PaperWidth,
 CellMargins->{{2, 10}, {3, 1}},
 FontSize->10],

Cell[StyleData["Table", "DoubleSpacedPrintout"],
 PageWidth->PaperWidth,
 CellMargins->{{2, 10}, {3, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableNote"],
 Editable->False,
 CellMargins->{{12, 10}, {7, -3}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"Table"}, "CounterTarget" -> "CellGroup"}},
 LineSpacing->{1, 1},
 ParagraphSpacing->{0.3, 0},
 CounterIncrements->"TableNote",
 FontSize->10,
 FontColor->GrayLevel[0.300008]],

Cell[StyleData["TableNote", "Printout"],
 CellMargins->{{2, 10}, {5, -2}},
 FontSize->9],

Cell[StyleData["TableNote", "DoubleSpacedPrintout"],
 CellMargins->{{2, 10}, {5, -2}},
 LineSpacing->{2, 1},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Table Styles", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TableColumnHead"],
 Editable->True,
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 FontSlant->"Italic",
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableColumnHead", "Printout"],
 FontSize->10],

Cell[StyleData["TableColumnHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanHead"],
 Editable->True,
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 TextAlignment->Center,
 FontSlant->"Italic",
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableSpanHead", "Printout"],
 FontSize->10],

Cell[StyleData["TableSpanHead", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableText"],
 Editable->True,
 TextAlignment->Left,
 LineSpacing->{1, 1},
 GridBoxOptions->{BaselinePosition->Axis,
 ColumnsEqual->False,
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>"\[Placeholder]",
 RowsEqual->False}],

Cell[StyleData["TableText", "Printout"],
 FontSize->10],

Cell[StyleData["TableText", "DoubleSpacedPrintout"],
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableSpanText"],
 Editable->True,
 TextAlignment->Center,
 LineSpacing->{1, 1},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableSpanText", "Printout"],
 FontSize->10],

Cell[StyleData["TableSpanText", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]],

Cell[StyleData["TableSubGrid"],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{0.1}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.27999999999999997`]}, 
     Offset[0.2]}, "RowsIndexed" -> {}},
 GridDefaultElement:>Cell["Data", "TableText"]}],

Cell[StyleData["TableMasterGrid"],
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.5599999999999999]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.004]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TableLineElement"],
 Editable->False,
 CellFrame->{{0, 0}, {0.5, 0}},
 CellElementSpacings->{"CellMinHeight"->1},
 ConversionRules:>{"HTML" -> {{"&nbsp;", 
      $CellContext`NoOutput[], ""}, {"", Automatic, ""}}},
 CellSize->{Inherited, 1.25},
 TabFilling->" ",
 TabSpacings->1000,
 FontSize->1],

Cell[StyleData["TableBlankElement"],
 Editable->False,
 CellElementSpacings->{"CellMinHeight"->1},
 CellSize->{Inherited, 1.25},
 FontSize->1],

Cell[CellGroupData[{

Cell[StyleData["SpanLeft"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanLeft", "Printout"],
 FontSize->14],

Cell[StyleData["SpanLeft", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanCenter"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanCenter", "Printout"],
 FontSize->14],

Cell[StyleData["SpanCenter", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SpanRight"],
 Editable->False,
 FontSize->16,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SpanRight", "Printout"],
 FontSize->14],

Cell[StyleData["SpanRight", "DoubleSpacedPrintout"],
 FontSize->14]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Caption", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
 CellMargins->{{12, 10}, {6, 2}},
 CellGroupingRules->"OutputGrouping",
 ConversionRules:>{"TeX" -> {"\n\\caption{", "}"}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 PageBreakAbove->False,
 Hyphenation->True,
 CounterIncrements->"Caption",
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["Caption", "Printout"],
 CellMargins->{{2, 2}, {4, 1}},
 FontSize->7],

Cell[StyleData["Caption", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {4, 1}},
 LineSpacing->{2, 1},
 FontSize->7]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematics", "Subsection"],

Cell[CellGroupData[{

Cell["Equations", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Equation"],
 CellMargins->{{26, 10}, {7, 7}},
 ConversionRules:>{"HTML" -> {{"", ""}, {"<p class=\"Equation\">", "</p>"}}},
 CellHorizontalScrolling->True,
 DefaultFormatType->DefaultInputFormatType,
 InputAutoReplacements->{},
 CounterIncrements->"Equation",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["Equation", "Printout"],
 CellMargins->{{22, 2}, {5, 5}},
 FontSize->10],

Cell[StyleData["Equation", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroup"],
 CellMargins->{{26, 10}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 1, "Numbered" -> False}, 
     "TeX" -> {"CellGroupEnvironment" -> "gather*"}}},
 DefaultFormatType->DefaultInputFormatType,
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroup", "Printout"],
 CellMargins->{{22, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroup", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAligned"],
 CellMargins->{{26, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "General" -> {"NestingLevel" -> 1, "Numbered" -> False}, 
     "TeX" -> {"CellGroupEnvironment" -> "align*"}}},
 CellFrameLabels->{{None, 
    Cell["", "EquationNumber"]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 SpanMinSize->2,
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAligned", "Printout"],
 CellMargins->{{22, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupAligned", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 1}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbered Equations", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["EquationNumbered"],
 CellMargins->{{26, 12}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationNumbered'><tr><td>", Automatic, 
      $CellContext`IncludeCount[
      "</td><td class='EquationNumberedLabel'>(`1`.`2`)</td></tr></table>", 
       "BookChapterNumber", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterNumber", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}},
 CellHorizontalScrolling->True,
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterNumber"], ".", 
       CounterBox["EquationNumbered"], ")"}]]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 InputAutoReplacements->{},
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationNumbered", "Printout"],
 CellMargins->{{22, 2}, {5, 5}},
 FontSize->10],

Cell[StyleData["EquationNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {5, 5}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupNumbered"],
 CellMargins->{{26, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationGroupNumbered'><tr><td>", Automatic, 
      $CellContext`IncludeCount[
      "</td><td \
class='EquationGroupNumberedLabel'>(`1`.`2`)</td></tr></table>", 
       "BookChapterNumber", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {
    "General" -> {"Numbered" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "gather"}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterNumber"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["EquationGroupNumbered", "Printout"],
 CellMargins->{{22, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationGroupAlignedNumbered"],
 CellMargins->{{26, 6}, {0, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='EquationGroupAlignedNumbered'><tr><td>", Automatic, 
      $CellContext`IncludeCount[
      "</td><td \
class='EquationGroupAlignedNumberedLabel'>(`1`.`2`)</td></tr></table>", 
       "BookChapterNumber", "EquationNumbered"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"BookChapterLabel", ".", "EquationNumbered"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}, 
   "ExtraConversionRules" -> {
    "General" -> {"Numbered" -> True}, 
     "TeX" -> {"CellGroupEnvironment" -> "align"}}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["BookChapterNumber"], ".", 
       CounterBox["EquationNumbered"], ")"}], "EquationNumber"]}, {
   None, None}},
 DefaultFormatType->DefaultInputFormatType,
 SpanMinSize->2,
 CounterIncrements->"EquationNumbered",
 ButtonBoxOptions->{ButtonFrame->"None"},
 UnderoverscriptBoxOptions->{LimitsPositioning->False},
 UnderscriptBoxOptions->{LimitsPositioning->False},
 OverscriptBoxOptions->{LimitsPositioning->False},
 GridBoxOptions->{AllowScriptLevelChange->False}],

Cell[StyleData["EquationGroupAlignedNumbered", "Printout"],
 CellMargins->{{22, 2}, {0, 1}},
 FontSize->10],

Cell[StyleData["EquationGroupAlignedNumbered", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {0, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right],

Cell[StyleData["EquationNumber", "Printout"],
 CellSize->{32, Inherited}],

Cell[StyleData["EquationNumber", "DoubleSpacedPrintout"],
 CellSize->{32, Inherited}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Equation Grid Tag Styles", "Subsubsection"],

Cell[StyleData["EquationGrid"]],

Cell[StyleData["SplitEquation"]],

Cell[StyleData["Piecewise"]],

Cell[StyleData["Matrix"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cross-References", "Subsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["XRef"],
 ConversionRules:>{"TeX" -> {"\\ref{", 
     $CellContext`ExtractButtonData["CounterTag"], "}"}, 
   "HTML" -> {"", $CellContext`XRefToHtmlHyperlink, ""}},
 ButtonStyleMenuListing->None,
 FontColor->GrayLevel[0],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["XRef", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["XRef", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageRef"]],

Cell[StyleData["PageRef", "Printout"]],

Cell[StyleData["PageRef", "DoubleSpacedPrintout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Backmatter", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["BackmatterGroup"],
 Editable->False,
 CellMargins->{{12, 10}, {7, 24}},
 CellGroupingRules->{"SectionGrouping", 5},
 ConversionRules:>{{"TeX" -> {"\n\n\\appendix", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["BackmatterGroup", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]],

Cell[StyleData["BackmatterGroup", "DoubleSpacedPrintout"],
 CellMargins->{{0, 0}, {0, 0}},
 FontSize->1,
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["AppendixSection"],
 CellMargins->{{12, 12}, {98, 0}},
 ConversionRules:>{{"TeX" -> {"\n\\chapter{", "}"}}, {
   "HTML" -> {"<p class=\"AppendixSection\">", "</p>"}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"AppendixSection"}, "XRefPrefix" -> "Appendix", 
     "CounterTarget" -> "CellGroup"}},
 PageBreakBelow->False,
 FontFamily->"Helvetica",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["AppendixSection", "Printout"],
 CellMargins->{{2, 2}, {78, 0}},
 FontSize->24,
 FontColor->GrayLevel[0]],

Cell[StyleData["AppendixSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 0}},
 FontSize->24,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixSectionNumber"],
 CellFrame->{{6, 0}, {0, 0}},
 CellMargins->{{12, 350}, {4, 0}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->{{8, 8}, {0, 72}},
 CounterIncrements->"AppendixSectionNumber",
 CounterAssignments->{{"Section", 0}, {"AppendixEquation", 0}, {
   "FigureCaption", 0}, {"TableTitle", 0}},
 FontFamily->"Helvetica",
 FontSize->60,
 FontWeight->"Bold",
 FontColor->GrayLevel[1],
 Background->RGBColor[0.500008, 0.500008, 0.749996],
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["AppendixSectionNumber", "Printout"],
 CellFrame->{{4, 0}, {0, 0}},
 CellMargins->{{2, 240}, {3, 0}},
 CellFrameMargins->{{6, 6}, {0, 60}},
 FontSize->48,
 Background->GrayLevel[0.6]],

Cell[StyleData["AppendixSectionNumber", "DoubleSpacedPrintout"],
 CellFrame->{{4, 0}, {0, 0}},
 CellMargins->{{2, 240}, {3, 0}},
 CellFrameMargins->{{6, 6}, {0, 60}},
 FontSize->48,
 Background->GrayLevel[0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Appendix"],
 CellMargins->{{12, 10}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 TextJustification->1,
 LineSpacing->{1, 3},
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}}],

Cell[StyleData["Appendix", "Printout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["Appendix", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AppendixEquation"],
 CellMargins->{{12, 12}, {7, 7}},
 ConversionRules:>{
  "HTML" -> {{"", ""}, {
     "<table class='AppendixEquation'><tr><td>", Automatic, 
      $CellContext`IncludeCount[
      "</td><td class='AppendixEquationLabel'>(`1`.`2`)</td></tr></table>", 
       "AppendixSection", "AppendixEquation"]}}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterFormat" -> {"AppendixSection", ".", "AppendixEquation"}, 
     "CounterTarget" -> "Cell", "XRefPrefix" -> "Equation"}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["AppendixSectionNumber"], ".", 
       CounterBox["AppendixEquation"], ")"}]]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 TextAlignment->Center,
 CounterIncrements->"AppendixEquation"],

Cell[StyleData["AppendixEquation", "Printout"],
 FontSize->10],

Cell[StyleData["AppendixEquation", "DoubleSpacedPrintout"],
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Endnotes", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["EndnoteSection"],
 CellMargins->{{12, 12}, {98, 149}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {
   "HTML" -> {"<p class=\"EndnoteSection\">", "</p>"}}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 DefaultNewInlineCellStyle->"None",
 LanguageCategory->"NaturalLanguage",
 SpanSymmetric->True,
 FontFamily->"Helvetica",
 FontSize->27,
 FontWeight->"Bold"],

Cell[StyleData["EndnoteSection", "Printout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24],

Cell[StyleData["EndnoteSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Endnote"],
 CellMargins->{{12, 10}, {2, 2}},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, 
   "HTML" -> {
    "<table class=\"Endnote\"><tr valign=\"top\">", "</td></tr></table>"}},
 Hyphenation->True,
 LineSpacing->{1, 2},
 ParagraphIndent->-38,
 CounterIncrements->"Endnote"],

Cell[StyleData["Endnote", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 TextJustification->0.5,
 FontSize->10],

Cell[StyleData["Endnote", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteLabel"],
 ConversionRules:>{"HTML" -> {"<td class=\"EndnoteLabel\" align=\"right\">", 
     $CellContext`ConvertTextSubOrSuperscriptToHTML["sup"], 
     "&nbsp;</td><td>"}},
 CellSize->{36, Inherited},
 TextAlignment->Right,
 SpanMaxSize->1,
 CounterIncrements->"EndnoteLabel"],

Cell[StyleData["EndnoteLabel", "Printout"],
 CellSize->{24, Inherited}],

Cell[StyleData["EndnoteLabel", "DoubleSpacedPrintout"],
 CellSize->{24, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteNumber"],
 CellSize->{36, Inherited},
 TextAlignment->Right,
 CounterIncrements->"EndnoteNumber"],

Cell[StyleData["EndnoteNumber", "Printout"]],

Cell[StyleData["EndnoteNumber", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NoteKey"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`EditNote[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["NoteKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["NoteKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EndnoteReturnLink"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["EndnoteReturnLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]],

Cell[StyleData["EndnoteReturnLink", "DoubleSpacedPrintout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TableNoteKey"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`EditTableNote[#, #2]& ),
 ButtonSource->ButtonContents,
 Evaluator->Automatic}],

Cell[StyleData["TableNoteKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["TableNoteKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[StyleData["Note"],
 Editable->False,
 Deletable->False,
 ConversionRules:>{"TeX" -> {{"\\footnote{", Convert[
       ExtractButtonData[1][#]]& , "}"}, {"", Automatic, ""}}, 
   "HTML" -> {"", 
     ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SpanMaxSize->1,
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[CellGroupData[{

Cell[StyleData["Note"],
 Editable->False,
 Deletable->False,
 ConversionRules:>{"TeX" -> {{"\\footnote{", $CellContext`Convert[
       $CellContext`ExtractButtonData[1][#]]& , "}"}, {"", Automatic, ""}}, 
   "HTML" -> {"", 
     $CellContext`ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SpanMaxSize->1,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Note", "Printout"],
 ScriptMinSize->8],

Cell[StyleData["Note", "DoubleSpacedPrintout"],
 ScriptMinSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["References", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSection"],
 CellMargins->{{12, 12}, {98, 149}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {
   "HTML" -> {"<p class=\"ReferenceSection\">", "</p>"}}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CounterIncrements->"ReferenceSection",
 CounterAssignments->{{"ReferenceText", 0}, {"BiblioEquation", 0}},
 FontFamily->"Helvetica",
 FontSize->27,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["ReferenceSection", "Printout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24],

Cell[StyleData["ReferenceSection", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 118}},
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
 CellMargins->{{12, 10}, {1, 1}},
 ConversionRules:>{{"TeX" -> {"\n\n", 
      $CellContext`ConvertAsNatbib[], ""}}, {
   "HTML" -> {
     "<table class=\"Reference\"><tr valign=\"top\">", 
      "</td></tr></table>"}}},
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "TeX" -> {
      "NestingLevel" -> 1, 
       "CellGroupEnvironment" -> {"thebibliography", "{000}"}}}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 ParagraphIndent->-8,
 CounterIncrements->"BibliographyItem",
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Reference", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{1, 2},
 ParagraphIndent->-5,
 FontSize->10],

Cell[StyleData["Reference", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{2, 1},
 ParagraphIndent->-5,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLabel"],
 ConversionRules:>{
  "HTML" -> {
    "<td class=\"ReferenceLabel\" align=\"right\">", "&nbsp;</td><td>"}},
 CellSize->{36, Inherited},
 TextAlignment->Left,
 SpanMaxSize->1,
 CounterIncrements->"RefDingbat"],

Cell[StyleData["ReferenceLabel", "Printout"],
 CellSize->{27, Inherited}],

Cell[StyleData["ReferenceLabel", "DoubleSpacedPrintout"],
 CellSize->{27, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefSep"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["RefSep", "Printout"]],

Cell[StyleData["RefSep", "DoubleSpacedPrintout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefReturnLink"],
 ConversionRules:>{"TeX" -> {"\n\\bibitem{", 
     $CellContext`ExtractRefLinkData[], "}"}},
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefReturnLink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefReturnPointer"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}, "HTML" -> {"<td>", 
     $CellContext`NoOutput[], ""}},
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["RefReturnPointer", "Printout"],
 FontColor->GrayLevel[1]],

Cell[StyleData["RefReturnPointer", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSourceLink"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"<!--", "-->"}}},
 ButtonStyleMenuListing->None,
 FontFamily->"Mathematica4",
 FontSize->1,
 FontColor->GrayLevel[1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["ReferenceSourceLink", "Printout"],
 FontColor->GrayLevel[1]]
}, Closed]],

Cell[StyleData["ReferenceSourceURL"]],

Cell[CellGroupData[{

Cell[StyleData["Citation"],
 ConversionRules:>{"TeX" -> {{"", 
      $CellContext`ExtractCitationData[], ""}, {"", Automatic, ""}}},
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`ListDataLink[#2]& ),
 Evaluator->Automatic}],

Cell[StyleData["Citation", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Citation", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefKey"],
 ButtonStyleMenuListing->None,
 FontColor->RGBColor[0.300008, 0.300008, 0.549996],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>($CellContext`EditRef[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["RefKey", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefKey", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["References Templates", "Subsubsubsection",
 StyleMenuListing->None],

Cell["FirstAuthor:<Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["OtherAuthors:, <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["LastAuthor:, & <Last>, <FirstInitial>. <MiddleInitial>.", \
"ReferenceTemplate"],

Cell["FirstEditor:<FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["OtherEditors:, <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["LastEditor: & <FirstInitial>. <MiddleInitial>. <Last>", \
"ReferenceTemplate"],

Cell["Sorting:AuthorNoIbid", "ReferenceTemplate"],

Cell["ReferenceAuthorMax:4", "ReferenceTemplate"],

Cell["ReferenceEditorMax:4", "ReferenceTemplate"],

Cell["ReferenceAuthorMin:1", "ReferenceTemplate"],

Cell["ReferenceEditorMin:1", "ReferenceTemplate"],

Cell["AbbreviatedAuthors:, et al.", "ReferenceTemplate"],

Cell["AbbreviatedEditors:, et al.", "ReferenceTemplate"],

Cell[CellGroupData[{

Cell["Article Templates", "Subsubsubsubsection"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>, <PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>, <Month>). <Title>. <JournalTitle>, <JournalVolume>. \
\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).  Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>).\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>, \
<PageRange>. \
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
Article:<Author> (<Year>). <Title>. <JournalTitle>, <JournalVolume>. \
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Article\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
Article:<Author> (<Year>, <Month> <Day>). <Title>. <JournalTitle>, \
<JournalVolume>(<JournalNumber>), <PageRange>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["In Book Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"InBook\" references.)\
\>", "Text"],

Cell["\<\
InBook:<Author> (<Year>). <Title>. In <Editor> (Ed.), <BookTitle> (pp. \
<PageRange>). <City>: <Publisher>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Whole Book Templates", "Subsubsubsubsection"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>. Retrieved \
<RetrievalDate> from <URL>\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. <City>: <Publisher>.\
\>", "ReferenceTemplate"],

Cell["\<\
WholeBook:<Author> (<Year>). <BookTitle>. Retrieved <RetrievalDate> from \
<URL>\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"Book\" references that \
don't match any of the above templates.)\
\>", "Text"],

Cell["WholeBook:<Author> (<Year>). <BookTitle>. <Publisher>.", \
"ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Thesis Templates", "Subsubsubsubsection"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"],

Cell["\<\
PhdThesis:<Author> (<Year>). <BookTitle>. Unpublished doctoral dissertation, \
<School>, <City>.\
\>", "ReferenceTemplate"],

Cell["\<\
(The following template is the default template for \"PhdThesis\" references \
that don't match any of the above templates.)\
\>", "Text"],

Cell["\<\
PhdThesis:<Author> (<Year>). <Title> (Doctoral Dissertation, <School>, \
<City>). <SourceOfAbstract>, <JournalVolume>, <PageRange>.\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Technical Report Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"TechReport\" \
references.)\
\>", "Text"],

Cell["\<\
TechReport:<Author> (<Year>). <Title>. <School>, <City>. <ReportNumber>, \
<Submittedby>\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Online Source Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"OnlineSource\" \
references.)\
\>", "Text"],

Cell["\<\
OnlineSource:<Author>, <Title>. Retrieved <RetrievalDate> from <URL>\
\>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Preprint Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"Preprint\" references.)\
\
\>", "Text"],

Cell["Preprint:<Author> (<Year>). <Title>. <PublicationStatus>", \
"ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plain Insertion Template", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \
\[OpenCurlyDoubleQuote]PlainInsert\" references.)\
\>", "Text"],

Cell["PlainInsert:<InsertedBibText>", "ReferenceTemplate"]
}, Closed]],

Cell[CellGroupData[{

Cell["Note Templates", "Subsubsubsubsection"],

Cell["\<\
(The following template is the default template for \"Note\" references.)\
\>", "Text"],

Cell["Note:<NoteText>", "ReferenceTemplate"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefTitle"],
 ConversionRules:>{"TeX" -> {"\\textit{", "}"}},
 FontSlant->"Italic"],

Cell[StyleData["RefType"],
 CellSize->{1, 12}],

Cell[StyleData["RefURL"]],

Cell[StyleData["RefRetrievalDate"]],

Cell[StyleData["RefSourceOfAbstract"]],

Cell[StyleData["RefInsertedBibText"]],

Cell[StyleData["RefNote"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefBookTitle"],
 ConversionRules:>{"TeX" -> {"\\textit{", "}"}},
 FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell["Journal Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefJournalTitle"]],

Cell[StyleData["RefJournalVolume"],
 ConversionRules:>{"TeX" -> {"\\textbf{", "}"}},
 FontWeight->"Bold"],

Cell[StyleData["RefJournalNumber"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Publisher Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefPublisher"]],

Cell[StyleData["RefCity"],
 ParagraphIndent->0]
}, Closed]],

Cell[CellGroupData[{

Cell["Author Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefAuthorGroup"]],

Cell[StyleData["RefAuthorFN"]],

Cell[StyleData["RefAuthorLN"]],

Cell[StyleData["RefAuthorMN"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Editor Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefEditorGroup"]],

Cell[StyleData["RefEditorFN"]],

Cell[StyleData["RefEditorMN"]],

Cell[StyleData["RefEditorLN"]]
}, Closed]],

Cell[CellGroupData[{

Cell["School Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefSchool"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Publication Date Data Field Styles", "Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefDay"]],

Cell[StyleData["RefMonth"]],

Cell[StyleData["RefYear"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Data Field Styles: Auto Generated and Contiguous Pages", \
"Subsubsubsection",
 StyleMenuListing->None],

Cell[StyleData["RefFirstPage"],
 ParagraphIndent->0],

Cell[StyleData["RefLastPage"],
 ParagraphIndent->0]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Book Elements", "Subsection"],

Cell[CellGroupData[{

Cell["Chapter", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["BookChapterNumber"],
 CellFrame->{{6, 0}, {0, 0}},
 CellMargins->{{12, 350}, {4, 0}},
 CellGroupingRules->{"SectionGrouping", 20},
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`NoOutput[], ""}},
 TaggingRules:>{
  "CounterSettings" -> {
    "CounterTarget" -> "Cell", "XRefPrefix" -> "Chapter"}},
 PageBreakAbove->True,
 PageBreakBelow->False,
 CellFrameMargins->{{8, 8}, {0, 72}},
 CounterIncrements->"BookChapterNumber",
 CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"EquationNumbered", 0}, {"FigureCaption", 0}, {
   "PictureCaption", 0}, {"ProgramCaption", 0}, {"TableTitle", 0}, {
   "Figure", 0}, {"Picture", 0}, {"Program", 0}, {"Table", 0}},
 FontFamily->"Helvetica",
 FontSize->60,
 FontWeight->"Bold",
 FontColor->GrayLevel[1],
 Background->RGBColor[0.500008, 0.500008, 0.749996]],

Cell[StyleData["BookChapterNumber", "Printout"],
 CellFrame->{{4, 0}, {0, 0}},
 CellMargins->{{2, 312}, {3, 0}},
 CellFrameMargins->{{6, 6}, {0, 60}},
 FontSize->48,
 Background->GrayLevel[0.6]],

Cell[StyleData["BookChapterNumber", "DoubleSpacedPrintout"],
 CellFrame->{{4, 0}, {0, 0}},
 CellMargins->{{2, 312}, {3, 0}},
 CellFrameMargins->{{6, 6}, {0, 60}},
 FontSize->48,
 Background->GrayLevel[0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BookChapterTitle"],
 CellMargins->{{12, 12}, {98, 0}},
 ConversionRules:>{"TeX" -> {"\n\\chapter{", "}"}},
 TaggingRules:>{"CounterSettings" -> {"CounterTarget" -> "CellGroup"}},
 PageBreakAbove->False,
 PageBreakBelow->False,
 LineSpacing->{1, 2},
 FontFamily->"Helvetica",
 FontSize->27,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["BookChapterTitle", "Printout"],
 CellMargins->{{2, 2}, {78, 0}},
 FontSize->24],

Cell[StyleData["BookChapterTitle", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {78, 0}},
 FontSize->24]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Epigraph", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["Epigraph"],
 CellMargins->{{12, 54}, {0, 24}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {"\\epigraph{", "}\n"}},
 FontSlant->"Italic"],

Cell[StyleData["Epigraph", "Printout"],
 CellMargins->{{2, 48}, {0, 21}},
 FontSize->10],

Cell[StyleData["Epigraph", "DoubleSpacedPrintout"],
 CellMargins->{{2, 48}, {0, 21}},
 LineSpacing->{2, 1},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EpigraphAuthor"],
 CellMargins->{{12, 54}, {24, 12}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{"TeX" -> {"\\epigraphauthor{", "}\n"}}],

Cell[StyleData["EpigraphAuthor", "Printout"],
 CellMargins->{{2, 48}, {21, 10}},
 FontSize->10],

Cell[StyleData["EpigraphAuthor", "DoubleSpacedPrintout"],
 CellMargins->{{2, 48}, {21, 10}},
 FontSize->10]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Headers and Footers", "Subsection"],

Cell[StyleData["Header"],
 CellMargins->{{0, 0}, {4, 1}},
 FontSize->10,
 FontSlant->"Italic"],

Cell[StyleData["Footer"],
 CellMargins->{{0, 0}, {0, 4}},
 FontSize->9,
 FontSlant->"Plain"],

Cell[StyleData["PageNumber"],
 CellMargins->{{0, 0}, {4, 1}},
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell["Miscellaneous", "Subsection"],

Cell[StyleData["TextSuperscript"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`ConvertTextSuperscriptToLaTeX[], ""}, "HTML" -> {"", 
     $CellContext`ConvertTextSubOrSuperscriptToHTML["sup"], ""}},
 ScriptMinSize->10,
 SingleLetterItalics->False],

Cell[StyleData["TextSubscript"],
 ConversionRules:>{"HTML" -> {"", 
     $CellContext`ConvertTextSubOrSuperscriptToHTML["sub"], ""}},
 ScriptMinSize->10,
 SingleLetterItalics->False],

Cell[StyleData["Nil"]],

Cell[StyleData["Verbatim"]],

Cell[StyleData["TeXName"],
 ConversionRules:>{"TeX" -> {"\\TeX\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["LaTeXName"],
 ConversionRules:>{"TeX" -> {"\\LaTeX\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["LaTeXeName"],
 ConversionRules:>{"TeX" -> {"\\LaTeXe\\", 
     $CellContext`NoOutput[], ""}}],

Cell[StyleData["ChemicalElement"],
 SingleLetterItalics->False,
 ZeroWidthTimes->True],

Cell[StyleData["CustomCharacter"],
 SingleLetterItalics->False],

Cell[StyleData["Palette"]],

Cell[CellGroupData[{

Cell[StyleData["PageBreak"],
 Editable->False,
 CellMargins->{{0, 0}, {1, 1}},
 CellBracketOptions->{"Color"->RGBColor[0.500008, 0.500008, 1],
 "Margins"->{Inherited, 3},
 "Thickness"->1,
 "Widths"->{5, 5}},
 CellElementSpacings->{"CellMinHeight"->1},
 ConversionRules:>{"TeX" -> {"\n\n\\pagebreak", 
     $CellContext`NoOutput[], ""}, "HTML" -> {"<br class=\"PageBreak\">", 
     $CellContext`NoOutput[], ""}},
 PageBreakAbove->True,
 CellSize->{Inherited, 6},
 TabFilling->"- ",
 TabSpacings->1000,
 FontSize->6,
 FontColor->GrayLevel[0.700008]],

Cell[StyleData["PageBreak", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 CellSize->{Inherited, 2},
 TabFilling->""]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CreationDate"],
 CellFrame->0.5,
 CellMargins->{{10, 10}, {4, 4}},
 TextAlignment->Center,
 FontFamily->"Helvetica",
 FontSize->10],

Cell[StyleData["CreationDate", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 LineSpacing->{1, 1},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell["Lines and Spacers", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SingleLine"],
 CellMargins->{{2, 10}, {1, 1}},
 CellGroupingRules->{"GraphicsGrouping", 0},
 FontSize->2],

Cell[StyleData["SingleLine", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 CellGroupingRules->{"GraphicsGrouping", 0},
 FontSize->2]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DoubleLine"],
 Editable->False,
 PageWidth->400,
 CellFrame->{{0, 0}, {0.25, 0.25}},
 CellMargins->{{12, 10}, {1, 1}},
 CellElementSpacings->{"CellMinHeight"->0},
 CellFrameMargins->{{2, 10}, {0, 0}},
 FontSize->4],

Cell[StyleData["DoubleLine", "Printout"],
 CellMargins->{{2, 10}, {1, 1}},
 FontSize->2]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ThinLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["ThinLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MediumLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 2}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["MediumLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ThickLine"],
 Editable->False,
 Selectable->False,
 CellFrame->{{0, 0}, {0, 3}},
 ShowCellBracket->False,
 CellMargins->{{12, 10}, {2, 2}},
 CellElementSpacings->{"CellMinHeight"->1},
 CellFrameMargins->False,
 CellSize->{Inherited, 8}],

Cell[StyleData["ThickLine", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Spacer"],
 CellMargins->{{Inherited, Inherited}, {4, 4}}],

Cell[StyleData["Spacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextSpacer"]],

Cell[StyleData["TextSpacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionSpacer"]],

Cell[StyleData["SectionSpacer", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GraphicsSpacer"]],

Cell[StyleData["GraphicsSpacer", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Vita", "Subsubsection",
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell[StyleData["VitaGroup"],
 CellMargins->{{14, 10}, {7, 24}},
 CellGroupingRules->{"SectionGrouping", 1},
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 FontFamily->"Helvetica",
 FontSize->9,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["VitaGroup", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["VitaAuthor"],
 CellMargins->{{12, 10}, {7, 7}}],

Cell[StyleData["VitaAuthor", "Printout"],
 CellMargins->{{2, Inherited}, {5, 5}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["VitaContactInformation"],
 CellMargins->{{12, 10}, {7, 7}}],

Cell[StyleData["VitaContactInformation", "Printout"],
 CellMargins->{{2, Inherited}, {5, 5}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["VitaSection"],
 CellMargins->{{12, 12}, {24, 4}},
 CellGroupingRules->{"SectionGrouping", 7},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold"],

Cell[StyleData["VitaSection", "Printout"],
 CellMargins->{{2, 2}, {21, 3}},
 FontSize->21]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["VitaSubsection"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{12, 12}, {4, 24}},
 CellGroupingRules->{"SectionGrouping", 10},
 CellFrameMargins->{{0, 0}, {3, 0}},
 FontFamily->"Helvetica",
 FontSize->16,
 FontWeight->"Bold"],

Cell[StyleData["VitaSubsection", "Printout"],
 CellMargins->{{2, 2}, {3, 21}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["VitaItem"],
 CellMargins->{{12, 12}, {1, 2}},
 CellGroupingRules->"GraphicsGrouping",
 ConversionRules:>{{"TeX" -> {"\\item ", ""}}, {"HTML" -> {"<li>", "</li>"}}},
 
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "TeX" -> {"NestingLevel" -> 1, "CellGroupEnvironment" -> "itemize"}, 
     "HTML" -> {"NestingLevel" -> 1, "CellGroupEnvironment" -> "ul"}}},
 CellFrameLabels->{{
    Cell["\[FilledSmallCircle]", "VitaItemLabel", CellBaseline -> Baseline], 
    Inherited}, {Inherited, Inherited}},
 CellFrameLabelMargins->4],

Cell[StyleData["VitaItem", "Printout"],
 CellMargins->{{2, 2}, {1, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["VitaItemLabel"],
 ConversionRules:>{{"TeX" -> {"", 
      $CellContext`NoOutput[], ""}}, {"HTML" -> {"", 
      $CellContext`NoOutput[], ""}}},
 CellSize->{24, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["VitaItemLabel", "Printout"],
 CellSize->{18, Inherited},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["VitaItemParagraph"],
 CellMargins->{{40, 12}, {1, 1}},
 CellGroupingRules->"GraphicsGrouping",
 TaggingRules:>{
  "ExtraConversionRules" -> {
    "TeX" -> {"NestingLevel" -> 1, "CellGroupEnvironment" -> "enumerate"}}},
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],

Cell[StyleData["VitaItemParagraph", "Printout"],
 CellMargins->{{24, 2}, {1, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Vita"],
 CellMargins->{{12, 10}, {7, 7}}],

Cell[StyleData["Vita", "Printout"],
 CellMargins->{{2, Inherited}, {5, 5}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Outline", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Outline1"],
 CellMargins->{{12, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline1"], ". "}], "Outline1Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}},
 FontSize->18,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["Outline1", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->16],

Cell[StyleData["Outline1", "DoubleSpacedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline1Label"],
 CellSize->{40, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline1Label", "Printout"],
 CellSize->{36, Inherited}],

Cell[StyleData["Outline1Label", "DoubleSpacedPrintout"],
 CellSize->{36, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2"],
 CellMargins->{{32, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 40},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline2"], ". "}], "Outline2Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}},
 FontSize->16,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["Outline2", "Printout"],
 CellMargins->{{22, 2}, {6, 6}},
 FontSize->14],

Cell[StyleData["Outline2", "DoubleSpacedPrintout"],
 CellMargins->{{22, 2}, {6, 6}},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2Label"],
 CellSize->{30, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline2Label", "Printout"],
 CellSize->{27, Inherited}],

Cell[StyleData["Outline2Label", "DoubleSpacedPrintout"],
 CellSize->{27, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3"],
 CellMargins->{{52, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline3"], ". "}], "Outline3Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}},
 FontSize->14,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Outline3", "Printout"],
 CellMargins->{{42, 2}, {6, 6}},
 FontSize->12],

Cell[StyleData["Outline3", "DoubleSpacedPrintout"],
 CellMargins->{{42, 2}, {6, 6}},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3Label"],
 CellSize->{21, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline3Label", "Printout"],
 CellSize->{18, Inherited}],

Cell[StyleData["Outline3Label", "DoubleSpacedPrintout"],
 CellSize->{18, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4"],
 CellMargins->{{67, 12}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 60},
 CellFrameLabels->{{
    Cell[
     TextData[{
       CounterBox["Outline4"], ". "}], "Outline4Label", CellBaseline -> 
     Baseline], Inherited}, {Inherited, Inherited}},
 CounterIncrements->"Outline4",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Outline4", "Printout"],
 CellMargins->{{57, 2}, {6, 6}},
 FontSize->10],

Cell[StyleData["Outline4", "DoubleSpacedPrintout"],
 CellMargins->{{57, 2}, {6, 6}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4Label"],
 CellSize->{18, Inherited},
 TextAlignment->Right,
 FontWeight->"Bold"],

Cell[StyleData["Outline4Label", "Printout"],
 CellSize->{16, Inherited}],

Cell[StyleData["Outline4Label", "DoubleSpacedPrintout"],
 CellSize->{16, Inherited}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OutlineText"],
 CellMargins->{{91, 12}, {3, 5}},
 ConversionRules:>{"TeX" -> {{"", Automatic, ""}, {"\n\n", Automatic, ""}}},
 TextAlignment->Left,
 LineSpacing->{1, 3},
 CounterIncrements->"Text"],

Cell[StyleData["OutlineText", "Printout"],
 CellMargins->{{79, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10],

Cell[StyleData["OutlineText", "DoubleSpacedPrintout"],
 CellMargins->{{79, 2}, {2, 4}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
 Editable->False,
 CellFrame->True,
 CellMargins->{{0, 0}, {3, 3}},
 CellElementSpacings->{"CellMinHeight"->0.8125},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameMargins->False,
 CellFrameColor->GrayLevel[1],
 CellFrameLabelMargins->False,
 TextAlignment->Center,
 CounterIncrements->"SlideShowNavigationBar",
 CounterAssignments->{{"Item1Numbered", 0}},
 FontSize->10,
 Magnification->1,
 Background->GrayLevel[0.8],
 GridBoxOptions->{BaselinePosition->Center,
 GridBoxAlignment->{
  "Columns" -> {
    Center, Center, Center, Center, Center, Center, Right, {Center}}, 
   "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {3.5, 3.5, 3.5, 3.5, 13, 5, {4}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{1.}}, "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.27999999999999997`], {
      Offset[0.]}, 
     Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{-1, -1}, {-1, -1}},
 PageBreakAbove->True,
 CellFrameMargins->{{1, 1}, {0, 0}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
 ButtonStyleMenuListing->None,
 FontSize->26,
 FontColor->GrayLevel[0.400015],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "Printout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}],

Cell[StyleData["SlideHyperlink", "DoubleSpacedPrintout"],
 FontColor->GrayLevel[0.8],
 ButtonBoxOptions->{ButtonFrame->"None"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Common Inline", "Subsection"],

Cell[CellGroupData[{

Cell["General Text Attributes", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["RM"],
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["BF"],
 ConversionRules:>{"TeX" -> {"\\textbf{", "}"}},
 FontWeight->"Bold"],

Cell[StyleData["IT"],
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 FontSlant->"Italic"],

Cell[StyleData["SmallCaps"],
 ConversionRules:>{"TeX" -> {{"", 
      $CellContext`ChangeCase["Lower"], ""}, {"", Automatic, ""}}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell["Font Specific Text Attributes", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["TR"],
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TI"],
 ConversionRules:>{
  "TeX" -> {{"\\textit{", Automatic, "}"}, {"", Automatic, ""}}},
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["TB"],
 ConversionRules:>{
  "TeX" -> {{"\\textbf{", Automatic, "}"}, {"", Automatic, ""}}},
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TBI"],
 ConversionRules:>{
  "TeX" -> {{"\\textbf{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MR"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{", Automatic, "}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MO"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MB"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textbf{", Automatic, "}}"}, {"", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MBO"],
 ConversionRules:>{
  "TeX" -> {{"\\texttt{\\textbf{\\textit{", Automatic, "}}}"}, {
     "", Automatic, ""}}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SR"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{", Automatic, "}"}, {"", Automatic, ""}}},
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textit{", Automatic, "}}"}, {"", Automatic, ""}}},
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SB"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textbf{", Automatic, "}}"}, {"", Automatic, ""}}},
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBO"],
 ConversionRules:>{
  "TeX" -> {{"\\textsf{\\textbf{\\textit{", Automatic, "}}}"}, {
     "", Automatic, ""}}},
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["PlainGreekWin"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 CharacterEncoding->"Unicode"],

Cell[StyleData["PlainGreekMac"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 FontFamily->"Symbol"],

Cell[StyleData["PlainGreekLin"],
 ConversionRules:>{"HTML" -> {"", ConvertPlainGreek, ""}},
 FontFamily->"Symbol"]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlinks", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 ConversionRules:>{"TeX" -> {{"", 
      $CellContext`ExportAsHyperRef[], ""}, {"", Automatic, ""}}},
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
 FontSize->10,
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["XMLWebLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>($CellContext`OpenAllTypes[#]& ),
 ButtonNote->ButtonData,
 Evaluator->Automatic}],

Cell[StyleData["XMLWebLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell["On-line Help System Links", "Subsubsubsection"],

Cell[CellGroupData[{

Cell[StyleData["UserGuideLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["UserGuide", #]}]& )}],

Cell[StyleData["UserGuideLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceLink"],
 ButtonStyleMenuListing->None,
 FontVariations->{"Underline"->True},
 FontColor->RGBColor[0, 0, 1],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup["Reference", #]}]& )}],

Cell[StyleData["ReferenceLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["System", "Subsection"],

Cell[CellGroupData[{

Cell["Format Type Style", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that are mixed in with the styles of 
most cells.  If a cell's FormatType matches the name of one of the styles 
defined below, then that style is applied between the cell's style and its 
own options. This is particularly true of Input and Output.
\
\>", "Text"],

Cell[StyleData["CellExpression"],
 PageWidth->DirectedInfinity[1],
 CellMargins->{{6, Inherited}, {Inherited, Inherited}},
 ShowCellLabel->False,
 ShowSpecialCharacters->False,
 AllowInlineCells->False,
 AutoItalicWords->{},
 FontFamily->"Courier",
 FontSize->12,
 Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
 AllowInlineCells->False,
 FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
 PageWidth->DirectedInfinity[1],
 TextAlignment->Left,
 LineSpacing->{0.6, 1},
 FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
 LineSpacing->{1.25, 0},
 FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
 LineSpacing->{1.25, 0},
 SingleLetterItalics->True,
 TraditionalFunctionNotation->True,
 DelimiterMatching->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Document Settings and Templates", "Subsubsection"],

Cell[StyleData["ReferenceTemplate"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["AuthorFormCustomizationTemplate"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["CSSDefinitions"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["LaTeXPreamble"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["DOCTYPEFormat"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["ValidationSetting"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["XRefPaletteSettings"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"],

Cell[StyleData["MiscSettings"],
 CellMargins->{{12, 10}, {7, 7}},
 InputAutoReplacements->{},
 FontFamily->"Courier"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Cells", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The style defined below is mixed in to any cell that is in an 
inline cell within another.
\
\>", "Text"],

Cell[StyleData["InlineCell"],
 InputAutoReplacements->{"-" -> "-"},
 ScriptLevel->1],

Cell[StyleData["InlineCellEditing"],
 Background->RGBColor[0.880003, 0.899992, 0.959991]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that define standard ButtonFunctions, 
for use in palette buttons.
\
\>", "Text"],

Cell[StyleData["Paste"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["StyleApply"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>($CellContext`CellWriteStyle[#]& ),
 Evaluator->Automatic}],

Cell[StyleData["StyleApplyWithVerification"],
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{
 ButtonFunction:>(($CellContext`CheckDocStyleMatch[]; \
$CellContext`CellWriteStyle[#])& ),
 Evaluator->Automatic}],

Cell[StyleData["ConvertCharacter"],
 ConversionRules:>{"TeX" -> {"", 
     $CellContext`ExtractButtonData["TeX"], ""}, "HTML" :> {"", 
     $CellContext`ExtractButtonData["HTML"], ""}},
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFrame->"None",
 Evaluator->Automatic}]
}, Closed]],

Cell[CellGroupData[{

Cell["Automatic", "Subsubsection",
 StyleMenuListing->None],

Cell["\<\

The cells below define styles that are used to affect the display 
of certain types of objects in typeset expressions.  For example, 
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and 
parenthesis characters are displayed (typically by coloring them to make them \

stand out).
\
\>", "Text"],

Cell[StyleData["UnmatchedBracket"],
 FontColor->RGBColor[0.760006, 0.330007, 0.8]]
}, Closed]],

Cell[CellGroupData[{

Cell["DialogEffects", "Subsubsection",
 StyleMenuListing->None],

Cell[StyleData["DialogStyleSheetMisapplicationEscape"],
 ShowCellBracket->False,
 CellMargins->{{12, 12}, {2000, 40}},
 CellOpen->True,
 TextAlignment->Center]
}, Closed]]
}, Closed]]
}, Closed]]
},
WindowSize->{781, 702},
WindowMargins->{{67, Automatic}, {Automatic, 0}},
TrackCellChangeTimes->False,
MenuPosition->1100,
FrontEndVersion->"6.0 for Mac OS X x86 (32-bit) (April 3, 2007)",
StyleDefinitions->"StylesheetFormatting.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[587, 22, 60, 0, 35, 60, 0, "StyleData", "StyleDefinitions", ""],
Cell[650, 24, 191, 4, 57, "Text"],
Cell[CellGroupData[{
Cell[866, 32, 35, 0, 50, "Section"],
Cell[904, 34, 99, 2, 42, "Text"],
Cell[1006, 38, 87, 2, 35, 27, 0, "StyleData", "Notebook", "All"],
Cell[1096, 42, 59, 0, 20, "MiscSettings"]
}, Closed]],
Cell[CellGroupData[{
Cell[1192, 47, 73, 2, 34, "Section"],
Cell[CellGroupData[{
Cell[1290, 53, 33, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[1348, 57, 31, 0, 45, "Subsubsection"],
Cell[1382, 59, 335, 9, 52, 25, 0, "StyleData", "Author", "All",
 MenuPosition->2000]
}, Closed]],
Cell[CellGroupData[{
Cell[1754, 73, 67, 1, 29, "Subsubsection"],
Cell[CellGroupData[{
Cell[1846, 78, 32, 0, 43, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[1903, 82, 45, 0, 42, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[1973, 86, 440, 12, 292, 33, 0, "StyleData", "TOCBookHeading", "All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[2416, 100, 91, 2, 235, 41, 0, "StyleData", "TOCHeading", "Printout"],
Cell[2510, 104, 130, 3, 235, 57, 0, "StyleData", "TOCBookHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[2677, 112, 398, 10, 292, 39, 0, "StyleData", "TOCBookIllustrations", \
"All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[3078, 124, 97, 2, 235, 47, 0, "StyleData", "TOCIllustrations", \
"Printout"],
Cell[3178, 128, 113, 2, 235, 63, 0, "StyleData", "TOCBookIllustrations", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[3328, 135, 390, 10, 292, 32, 0, "StyleData", "TOCBookTables", "All",
 CounterAssignments->{{"TOCBookFrontBackHeading", 0}, {
   "TOCBookChapterTitle", 0}, {"TOCItem", 0}}],
Cell[3721, 147, 94, 2, 235, 44, 0, "StyleData", "TOCBookTables", "Printout"],
Cell[3818, 151, 106, 2, 235, 56, 0, "StyleData", "TOCBookTables", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[3973, 159, 48, 0, 26, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[4046, 163, 624, 14, 33, 44, 0, "StyleData", "TOCBookFrontmatterHeading", \
"All",
 CounterIncrements->"TOCBookFrontmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[4673, 179, 122, 3, 26, 56, 0, "StyleData", "TOCBookFrontmatterHeading", \
"Printout"],
Cell[4798, 184, 134, 3, 26, 68, 0, "StyleData", "TOCBookFrontmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[4969, 192, 621, 14, 33, 43, 0, "StyleData", "TOCBookBackmatterHeading", \
"All",
 CounterIncrements->"TOCBookBackmatterHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[5593, 208, 121, 3, 26, 55, 0, "StyleData", "TOCBookBackmatterHeading", \
"Printout"],
Cell[5717, 213, 133, 3, 26, 67, 0, "StyleData", "TOCBookBackmatterHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[5887, 221, 564, 12, 33, 42, 0, "StyleData", "TOCBookFrontBackHeading", \
"All",
 CounterIncrements->"TOCBookFrontBackHeading",
 CounterAssignments->{{"TOCBookFigure", 0}, {"TOCBookSupplemental", 0}, {
   "TOCBookPicture", 0}, {"TOCBookIllustration", 0}, {"TOCBookProgram", 0}, {
   "TOCBookTable", 0}, {"TOCBookItem", 0}}],
Cell[6454, 235, 120, 3, 26, 54, 0, "StyleData", "TOCBookFrontBackHeading", \
"Printout"],
Cell[6577, 240, 132, 3, 26, 66, 0, "StyleData", "TOCBookFrontBackHeading", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[6746, 248, 735, 18, 44, 35, 0, "StyleData", "TOCBookPartTitle", "All",
 CounterIncrements->"TOCBookPartTitle",
 CounterAssignments->{{"TOCBookChapterTitle", 0}}],
Cell[7484, 268, 96, 2, 37, 47, 0, "StyleData", "TOCBookPartTitle", \
"Printout"],
Cell[7583, 272, 108, 2, 37, 59, 0, "StyleData", "TOCBookPartTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[7728, 279, 736, 18, 33, 38, 0, "StyleData", "TOCBookChapterTitle", "All",
 
 CounterIncrements->"TOCBookChapterTitle",
 CounterAssignments->{{"TOCBookSection", 0}}],
Cell[8467, 299, 139, 4, 28, 50, 0, "StyleData", "TOCBookChapterTitle", \
"Printout"],
Cell[8609, 305, 151, 4, 28, 62, 0, "StyleData", "TOCBookChapterTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[8797, 314, 741, 17, 29, 33, 0, "StyleData", "TOCBookSection", "All",
 CounterIncrements->"TOCBookSection",
 CounterAssignments->{{"TOCBookSubsection", 0}}],
Cell[9541, 333, 137, 4, 28, 45, 0, "StyleData", "TOCBookSection", \
"Printout"],
Cell[9681, 339, 149, 4, 28, 57, 0, "StyleData", "TOCBookSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[9867, 348, 774, 17, 29, 36, 0, "StyleData", "TOCBookSubsection", "All",
 CounterIncrements->"TOCBookSubsection"],
Cell[10644, 367, 140, 4, 28, 48, 0, "StyleData", "TOCBookSubsection", \
"Printout"],
Cell[10787, 373, 152, 4, 28, 60, 0, "StyleData", "TOCBookSubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[10976, 382, 668, 15, 29, 32, 0, "StyleData", "TOCBookFigure", "All",
 CounterIncrements->"TOCBookFigure"],
Cell[11647, 399, 111, 3, 28, 44, 0, "StyleData", "TOCBookFigure", \
"Printout"],
Cell[11761, 404, 123, 3, 28, 56, 0, "StyleData", "TOCBookFigure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[11921, 412, 706, 15, 29, 38, 0, "StyleData", "TOCBookSupplemental", \
"All",
 CounterIncrements->"TOCBookSupplemental"],
Cell[12630, 429, 117, 3, 28, 50, 0, "StyleData", "TOCBookSupplemental", \
"Printout"],
Cell[12750, 434, 129, 3, 28, 62, 0, "StyleData", "TOCBookSupplemental", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[12916, 442, 676, 15, 29, 33, 0, "StyleData", "TOCBookPicture", "All",
 CounterIncrements->"TOCBookPicture"],
Cell[13595, 459, 112, 3, 28, 45, 0, "StyleData", "TOCBookPicture", \
"Printout"],
Cell[13710, 464, 124, 3, 28, 57, 0, "StyleData", "TOCBookPicture", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[13871, 472, 708, 15, 29, 38, 0, "StyleData", "TOCBookIllustration", \
"All",
 CounterIncrements->"TOCBookIllustration"],
Cell[14582, 489, 117, 3, 28, 50, 0, "StyleData", "TOCBookIllustration", \
"Printout"],
Cell[14702, 494, 129, 3, 28, 62, 0, "StyleData", "TOCBookIllustration", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14868, 502, 674, 15, 29, 33, 0, "StyleData", "TOCBookProgram", "All",
 CounterIncrements->"TOCBookProgram"],
Cell[15545, 519, 112, 3, 28, 45, 0, "StyleData", "TOCBookProgram", \
"Printout"],
Cell[15660, 524, 124, 3, 28, 57, 0, "StyleData", "TOCBookProgram", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[15821, 532, 664, 15, 29, 31, 0, "StyleData", "TOCBookTable", "All",
 CounterIncrements->"TOCBookTable"],
Cell[16488, 549, 110, 3, 28, 43, 0, "StyleData", "TOCBookTable", "Printout"],
Cell[16601, 554, 122, 3, 28, 55, 0, "StyleData", "TOCBookTable", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[16772, 563, 46, 0, 26, "Subsubsubsubsection"],
Cell[CellGroupData[{
Cell[16843, 567, 136, 3, 27, 32, 0, "StyleData", "TOCBookSpacer", "All"],
Cell[16982, 572, 76, 1, 27, 44, 0, "StyleData", "TOCBookSpacer", "Printout"],
Cell[17061, 575, 88, 1, 27, 56, 0, "StyleData", "TOCBookSpacer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[17186, 581, 138, 3, 35, 40, 0, "StyleData", "TOCBookPartTitleLabel", \
"All"],
Cell[17327, 586, 80, 1, 35, 52, 0, "StyleData", "TOCBookPartTitleLabel", \
"Printout"],
Cell[17410, 589, 92, 1, 35, 64, 0, "StyleData", "TOCBookPartTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[17539, 595, 164, 4, 35, 43, 0, "StyleData", "TOCBookChapterTitleLabel", \
"All"],
Cell[17706, 601, 83, 1, 35, 55, 0, "StyleData", "TOCBookChapterTitleLabel", \
"Printout"],
Cell[17792, 604, 95, 1, 35, 67, 0, "StyleData", "TOCBookChapterTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[17924, 610, 159, 4, 35, 38, 0, "StyleData", "TOCBookSectionLabel", \
"All"],
Cell[18086, 616, 78, 1, 35, 50, 0, "StyleData", "TOCBookSectionLabel", \
"Printout"],
Cell[18167, 619, 90, 1, 35, 62, 0, "StyleData", "TOCBookSectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[18294, 625, 162, 4, 35, 41, 0, "StyleData", "TOCBookSubsectionLabel", \
"All"],
Cell[18459, 631, 81, 1, 35, 53, 0, "StyleData", "TOCBookSubsectionLabel", \
"Printout"],
Cell[18543, 634, 93, 1, 35, 65, 0, "StyleData", "TOCBookSubsectionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[18673, 640, 158, 4, 35, 37, 0, "StyleData", "TOCBookFigureLabel", \
"All"],
Cell[18834, 646, 77, 1, 35, 49, 0, "StyleData", "TOCBookFigureLabel", \
"Printout"],
Cell[18914, 649, 89, 1, 35, 61, 0, "StyleData", "TOCBookFigureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19040, 655, 164, 4, 35, 43, 0, "StyleData", "TOCBookSupplementalLabel", \
"All"],
Cell[19207, 661, 83, 1, 35, 55, 0, "StyleData", "TOCBookSupplementalLabel", \
"Printout"],
Cell[19293, 664, 95, 1, 35, 67, 0, "StyleData", "TOCBookSupplementalLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19425, 670, 159, 4, 35, 38, 0, "StyleData", "TOCBookPictureLabel", \
"All"],
Cell[19587, 676, 78, 1, 35, 50, 0, "StyleData", "TOCBookPictureLabel", \
"Printout"],
Cell[19668, 679, 90, 1, 35, 62, 0, "StyleData", "TOCBookPictureLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[19795, 685, 164, 4, 35, 43, 0, "StyleData", "TOCBookIllustrationLabel", \
"All"],
Cell[19962, 691, 83, 1, 35, 55, 0, "StyleData", "TOCBookIllustrationLabel", \
"Printout"],
Cell[20048, 694, 95, 1, 35, 67, 0, "StyleData", "TOCBookIllustrationLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20180, 700, 159, 4, 35, 38, 0, "StyleData", "TOCBookProgramLabel", \
"All"],
Cell[20342, 706, 78, 1, 35, 50, 0, "StyleData", "TOCBookProgramLabel", \
"Printout"],
Cell[20423, 709, 90, 1, 35, 62, 0, "StyleData", "TOCBookProgramLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20550, 715, 157, 4, 35, 36, 0, "StyleData", "TOCBookTableLabel", "All"],
Cell[20710, 721, 76, 1, 35, 48, 0, "StyleData", "TOCBookTableLabel", \
"Printout"],
Cell[20789, 724, 88, 1, 35, 60, 0, "StyleData", "TOCBookTableLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[20914, 730, 158, 5, 35, 32, 0, "StyleData", "TOCBookLeader", "All"],
Cell[21075, 737, 59, 1, 34, 44, 0, "StyleData", "TOCBookLeader", "Printout"],
Cell[21137, 740, 71, 1, 34, 56, 0, "StyleData", "TOCBookLeader", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[21245, 746, 301, 9, 35, 36, 0, "StyleData", "TOCBookPageNumber", "All"],
Cell[21549, 757, 76, 1, 35, 48, 0, "StyleData", "TOCBookPageNumber", \
"Printout"],
Cell[21628, 760, 88, 1, 35, 60, 0, "StyleData", "TOCBookPageNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[21801, 770, 32, 0, 46, "Subsection"],
Cell[CellGroupData[{
Cell[21858, 774, 860, 23, 71, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->{
  "Section", "SectionHeader", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}, {
   "Subsubsubsection", 0}}],
Cell[22721, 799, 188, 5, 58, 38, 0, "StyleData", "Section", "Printout"],
Cell[22912, 806, 200, 5, 58, 50, 0, "StyleData", "Section", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[23149, 816, 772, 21, 47, 29, 0, "StyleData", "Subsection", "All",
 CounterIncrements->{
  "Subsection", "SubsectionHeader", "SubsubsectionHeader", 
   "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsection", 0}, {"Subsubsubsection", 0}}],
Cell[23924, 839, 89, 2, 42, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[24016, 843, 101, 2, 42, 53, 0, "StyleData", "Subsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24154, 850, 506, 13, 33, 32, 0, "StyleData", "Subsubsection", "All",
 CounterIncrements->{
  "Subsubsection", "SubsubsectionHeader", "SubsubsubsectionHeader"},
 CounterAssignments->{{"Subsubsubsection", 0}}],
Cell[24663, 865, 90, 2, 30, 44, 0, "StyleData", "Subsubsection", "Printout"],
Cell[24756, 869, 102, 2, 30, 56, 0, "StyleData", "Subsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[24895, 876, 390, 10, 33, 35, 0, "StyleData", "Subsubsubsection", "All",
 CounterIncrements->{"Subsubsubsection", "SubsubsubsectionHeader"}],
Cell[25288, 888, 93, 2, 30, 47, 0, "StyleData", "Subsubsubsection", \
"Printout"],
Cell[25384, 892, 105, 2, 30, 59, 0, "StyleData", "Subsubsubsection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[25526, 899, 34, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[25585, 903, 274, 7, 35, 23, 0, "StyleData", "Text", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[25862, 912, 127, 4, 32, 35, 0, "StyleData", "Text", "Printout"],
Cell[25992, 918, 139, 4, 32, 47, 0, "StyleData", "Text", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26168, 927, 385, 10, 35, 31, 0, "StyleData", "TextNoIndent", "All",
 CounterIncrements->"Text",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[26556, 939, 135, 4, 32, 43, 0, "StyleData", "TextNoIndent", "Printout"],
Cell[26694, 945, 147, 4, 32, 55, 0, "StyleData", "TextNoIndent", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[26878, 954, 388, 9, 35, 35, 0, "StyleData", "TextContinuation", "All",
 CounterIncrements->"TextContinuation",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[27269, 965, 139, 4, 32, 47, 0, "StyleData", "TextContinuation", \
"Printout"],
Cell[27411, 971, 151, 4, 32, 59, 0, "StyleData", "TextContinuation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27623, 982, 36, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[27684, 986, 64, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[27773, 991, 570, 14, 30, 24, 0, "StyleData", "Item1", "All",
 CounterIncrements->"Item1"],
Cell[28346, 1007, 83, 2, 28, 36, 0, "StyleData", "Item1", "Printout"],
Cell[28432, 1011, 117, 3, 28, 48, 0, "StyleData", "Item1", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[28586, 1019, 570, 14, 30, 24, 0, "StyleData", "Item2", "All",
 CounterIncrements->"Item2"],
Cell[29159, 1035, 84, 2, 28, 36, 0, "StyleData", "Item2", "Printout"],
Cell[29246, 1039, 118, 3, 28, 48, 0, "StyleData", "Item2", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[29401, 1047, 570, 14, 30, 24, 0, "StyleData", "Item3", "All",
 CounterIncrements->"Item3"],
Cell[29974, 1063, 84, 2, 28, 36, 0, "StyleData", "Item3", "Printout"],
Cell[30061, 1067, 118, 3, 28, 48, 0, "StyleData", "Item3", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[30216, 1075, 229, 6, 35, 29, 0, "StyleData", "Item1Label", "All"],
Cell[30448, 1083, 84, 2, 34, 41, 0, "StyleData", "Item1Label", "Printout"],
Cell[30535, 1087, 96, 2, 34, 53, 0, "StyleData", "Item1Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[30668, 1094, 207, 5, 35, 29, 0, "StyleData", "Item2Label", "All"],
Cell[30878, 1101, 69, 1, 35, 41, 0, "StyleData", "Item2Label", "Printout"],
Cell[30950, 1104, 81, 1, 35, 53, 0, "StyleData", "Item2Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[31068, 1110, 207, 5, 35, 29, 0, "StyleData", "Item3Label", "All"],
Cell[31278, 1117, 69, 1, 35, 41, 0, "StyleData", "Item3Label", "Printout"],
Cell[31350, 1120, 81, 1, 35, 53, 0, "StyleData", "Item3Label", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31480, 1127, 64, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[31569, 1132, 700, 17, 30, 32, 0, "StyleData", "Item1Numbered", "All",
 CounterIncrements->"Item1Numbered",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],
Cell[32272, 1151, 91, 2, 28, 44, 0, "StyleData", "Item1Numbered", \
"Printout"],
Cell[32366, 1155, 125, 3, 28, 56, 0, "StyleData", "Item1Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[32528, 1163, 715, 18, 30, 32, 0, "StyleData", "Item2Numbered", "All",
 CounterIncrements->"Item2Numbered"],
Cell[33246, 1183, 92, 2, 28, 44, 0, "StyleData", "Item2Numbered", \
"Printout"],
Cell[33341, 1187, 126, 3, 28, 56, 0, "StyleData", "Item2Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[33504, 1195, 686, 17, 30, 32, 0, "StyleData", "Item3Numbered", "All",
 CounterIncrements->"Item3Numbered"],
Cell[34193, 1214, 92, 2, 28, 44, 0, "StyleData", "Item3Numbered", \
"Printout"],
Cell[34288, 1218, 126, 3, 28, 56, 0, "StyleData", "Item3Numbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[34451, 1226, 211, 5, 35, 37, 0, "StyleData", "Item1NumberedLabel", \
"All"],
Cell[34665, 1233, 92, 2, 34, 49, 0, "StyleData", "Item1NumberedLabel", \
"Printout"],
Cell[34760, 1237, 104, 2, 34, 61, 0, "StyleData", "Item1NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[34901, 1244, 211, 5, 35, 37, 0, "StyleData", "Item2NumberedLabel", \
"All"],
Cell[35115, 1251, 77, 1, 35, 49, 0, "StyleData", "Item2NumberedLabel", \
"Printout"],
Cell[35195, 1254, 89, 1, 35, 61, 0, "StyleData", "Item2NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[35321, 1260, 211, 5, 35, 37, 0, "StyleData", "Item3NumberedLabel", \
"All"],
Cell[35535, 1267, 77, 1, 35, 49, 0, "StyleData", "Item3NumberedLabel", \
"Printout"],
Cell[35615, 1270, 89, 1, 35, 61, 0, "StyleData", "Item3NumberedLabel", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[35753, 1277, 65, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[35843, 1282, 271, 5, 29, 33, 0, "StyleData", "Item1Paragraph", "All"],
Cell[36117, 1289, 93, 2, 28, 45, 0, "StyleData", "Item1Paragraph", \
"Printout"],
Cell[36213, 1293, 127, 3, 28, 57, 0, "StyleData", "Item1Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36377, 1301, 271, 5, 29, 33, 0, "StyleData", "Item2Paragraph", "All"],
Cell[36651, 1308, 93, 2, 28, 45, 0, "StyleData", "Item2Paragraph", \
"Printout"],
Cell[36747, 1312, 127, 3, 28, 57, 0, "StyleData", "Item2Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[36911, 1320, 271, 5, 29, 33, 0, "StyleData", "Item3Paragraph", "All"],
Cell[37185, 1327, 93, 2, 28, 45, 0, "StyleData", "Item3Paragraph", \
"Printout"],
Cell[37281, 1331, 127, 3, 28, 57, 0, "StyleData", "Item3Paragraph", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37469, 1341, 48, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[37542, 1345, 31, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[37598, 1349, 597, 15, 39, 25, 0, "StyleData", "Figure", "All",
 CounterIncrements->"Figure"],
Cell[38198, 1366, 98, 2, 32, 37, 0, "StyleData", "Figure", "Printout"],
Cell[38299, 1370, 110, 2, 32, 49, 0, "StyleData", "Figure", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[38446, 1377, 612, 16, 33, 32, 0, "StyleData", "FigureCaption", "All",
 CounterIncrements->"FigureCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[39061, 1395, 90, 2, 27, 44, 0, "StyleData", "FigureCaption", \
"Printout"],
Cell[39154, 1399, 124, 3, 27, 56, 0, "StyleData", "FigureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[39315, 1407, 146, 4, 35, 37, 0, "StyleData", "FigureCaptionLabel", \
"All"],
Cell[39464, 1413, 49, 0, 35, 49, 0, "StyleData", "FigureCaptionLabel", \
"Printout"],
Cell[39516, 1415, 61, 0, 35, 61, 0, "StyleData", "FigureCaptionLabel", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[39626, 1421, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[39683, 1425, 516, 11, 41, 26, 0, "StyleData", "Picture", "All",
 CounterIncrements->"Picture"],
Cell[40202, 1438, 99, 2, 32, 38, 0, "StyleData", "Picture", "Printout"],
Cell[40304, 1442, 111, 2, 32, 50, 0, "StyleData", "Picture", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[40452, 1449, 616, 16, 33, 33, 0, "StyleData", "PictureCaption", "All",
 CounterIncrements->"PictureCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[41071, 1467, 91, 2, 27, 45, 0, "StyleData", "PictureCaption", \
"Printout"],
Cell[41165, 1471, 125, 3, 27, 57, 0, "StyleData", "PictureCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[41327, 1479, 147, 4, 35, 38, 0, "StyleData", "PictureCaptionLabel", \
"All"],
Cell[41477, 1485, 50, 0, 35, 50, 0, "StyleData", "PictureCaptionLabel", \
"Printout"],
Cell[41530, 1487, 62, 0, 35, 62, 0, "StyleData", "PictureCaptionLabel", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41641, 1493, 39, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[41705, 1497, 488, 11, 52, 26, 0, "StyleData", "Program", "All",
 CounterIncrements->"Program"],
Cell[42196, 1510, 85, 2, 31, 38, 0, "StyleData", "Program", "Printout"],
Cell[42284, 1514, 97, 2, 31, 50, 0, "StyleData", "Program", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[42418, 1521, 619, 16, 33, 33, 0, "StyleData", "ProgramCaption", "All",
 CounterIncrements->"ProgramCaption",
 CounterAssignments->{{"Nil", 0}}],
Cell[43040, 1539, 91, 2, 28, 45, 0, "StyleData", "ProgramCaption", \
"Printout"],
Cell[43134, 1543, 125, 3, 28, 57, 0, "StyleData", "ProgramCaption", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[43296, 1551, 147, 4, 35, 38, 0, "StyleData", "ProgramCaptionLabel", \
"All"],
Cell[43446, 1557, 50, 0, 35, 50, 0, "StyleData", "ProgramCaptionLabel", \
"Printout"],
Cell[43499, 1559, 62, 0, 35, 62, 0, "StyleData", "ProgramCaptionLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[43598, 1564, 123, 3, 35, 32, 0, "StyleData", "ProgramNumber", "All"],
Cell[43724, 1569, 44, 0, 35, 44, 0, "StyleData", "ProgramNumber", \
"Printout"],
Cell[43771, 1571, 56, 0, 35, 56, 0, "StyleData", "ProgramNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[43864, 1576, 548, 15, 37, 30, 0, "StyleData", "ProgramText", "All",
 CounterIncrements->"ProgramText"],
Cell[44415, 1593, 90, 2, 34, 42, 0, "StyleData", "ProgramText", "Printout"],
Cell[44508, 1597, 124, 3, 34, 54, 0, "StyleData", "ProgramText", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[44681, 1606, 31, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[44737, 1610, 837, 21, 35, 29, 0, "StyleData", "TableTitle", "All",
 CounterIncrements->"TableTitle"],
Cell[45577, 1633, 89, 2, 32, 41, 0, "StyleData", "TableTitle", "Printout"],
Cell[45669, 1637, 101, 2, 32, 53, 0, "StyleData", "TableTitle", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[45807, 1644, 490, 14, 35, 34, 0, "StyleData", "TableTitleLabel", "All",
 CounterIncrements->"TableTitleLabel",
 CounterAssignments->{{"Nil", 0}}],
Cell[46300, 1660, 61, 1, 34, 46, 0, "StyleData", "TableTitleLabel", \
"Printout"],
Cell[46364, 1663, 73, 1, 34, 58, 0, "StyleData", "TableTitleLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[46474, 1669, 1158, 29, 32, 24, 0, "StyleData", "Table", "All",
 CounterIncrements->"Table",
 CounterAssignments->{{"TableNote", 0}}],
Cell[47635, 1700, 108, 3, 30, 36, 0, "StyleData", "Table", "Printout"],
Cell[47746, 1705, 120, 3, 30, 48, 0, "StyleData", "Table", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[47903, 1713, 431, 13, 30, 28, 0, "StyleData", "TableNote", "All",
 CounterIncrements->"TableNote"],
Cell[48337, 1728, 88, 2, 28, 40, 0, "StyleData", "TableNote", "Printout"],
Cell[48428, 1732, 122, 3, 28, 52, 0, "StyleData", "TableNote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[48587, 1740, 47, 0, 43, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[48659, 1744, 899, 24, 35, 34, 0, "StyleData", "TableColumnHead", "All"],
Cell[49561, 1770, 61, 1, 34, 46, 0, "StyleData", "TableColumnHead", \
"Printout"],
Cell[49625, 1773, 73, 1, 34, 58, 0, "StyleData", "TableColumnHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[49735, 1779, 921, 25, 35, 32, 0, "StyleData", "TableSpanHead", "All"],
Cell[50659, 1806, 59, 1, 34, 44, 0, "StyleData", "TableSpanHead", \
"Printout"],
Cell[50721, 1809, 71, 1, 34, 56, 0, "StyleData", "TableSpanHead", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[50829, 1815, 829, 23, 35, 28, 0, "StyleData", "TableText", "All"],
Cell[51661, 1840, 55, 1, 34, 40, 0, "StyleData", "TableText", "Printout"],
Cell[51719, 1843, 89, 2, 34, 52, 0, "StyleData", "TableText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[51845, 1850, 599, 17, 35, 32, 0, "StyleData", "TableSpanText", "All"],
Cell[52447, 1869, 59, 1, 34, 44, 0, "StyleData", "TableSpanText", \
"Printout"],
Cell[52509, 1872, 71, 1, 34, 56, 0, "StyleData", "TableSpanText", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[52595, 1876, 735, 18, 35, 31, 0, "StyleData", "TableSubGrid", "All"],
Cell[53333, 1896, 441, 10, 35, 34, 0, "StyleData", "TableMasterGrid", "All"],
Cell[53777, 1908, 312, 9, 17, 35, 0, "StyleData", "TableLineElement", "All"],
Cell[54092, 1919, 142, 4, 9, 36, 0, "StyleData", "TableBlankElement", "All"],
Cell[CellGroupData[{
Cell[54259, 1927, 103, 4, 39, 27, 0, "StyleData", "SpanLeft", "All"],
Cell[54365, 1933, 54, 1, 37, 39, 0, "StyleData", "SpanLeft", "Printout"],
Cell[54422, 1936, 66, 1, 37, 51, 0, "StyleData", "SpanLeft", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[54525, 1942, 105, 4, 39, 29, 0, "StyleData", "SpanCenter", "All"],
Cell[54633, 1948, 56, 1, 37, 41, 0, "StyleData", "SpanCenter", "Printout"],
Cell[54692, 1951, 68, 1, 37, 53, 0, "StyleData", "SpanCenter", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[54797, 1957, 104, 4, 39, 28, 0, "StyleData", "SpanRight", "All"],
Cell[54904, 1963, 55, 1, 37, 40, 0, "StyleData", "SpanRight", "Printout"],
Cell[54962, 1966, 67, 1, 37, 52, 0, "StyleData", "SpanRight", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[55090, 1974, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[55147, 1978, 337, 9, 33, 26, 0, "StyleData", "Caption", "All",
 CounterIncrements->"Caption"],
Cell[55487, 1989, 84, 2, 27, 38, 0, "StyleData", "Caption", "Printout"],
Cell[55574, 1993, 118, 3, 27, 50, 0, "StyleData", "Caption", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[55753, 2003, 33, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[55811, 2007, 59, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[55895, 2012, 317, 7, 41, 27, 0, "StyleData", "Equation", "All",
 CounterIncrements->"Equation"],
Cell[56215, 2021, 87, 2, 36, 39, 0, "StyleData", "Equation", "Printout"],
Cell[56305, 2025, 99, 2, 36, 51, 0, "StyleData", "Equation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[56441, 2032, 356, 8, 29, 32, 0, "StyleData", "EquationGroup", "All"],
Cell[56800, 2042, 92, 2, 27, 44, 0, "StyleData", "EquationGroup", \
"Printout"],
Cell[56895, 2046, 104, 2, 27, 56, 0, "StyleData", "EquationGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[57036, 2053, 662, 15, 29, 39, 0, "StyleData", "EquationGroupAligned", \
"All"],
Cell[57701, 2070, 99, 2, 27, 51, 0, "StyleData", "EquationGroupAligned", \
"Printout"],
Cell[57803, 2074, 111, 2, 27, 63, 0, "StyleData", "EquationGroupAligned", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[57963, 2082, 43, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[58031, 2086, 866, 21, 41, 35, 0, "StyleData", "EquationNumbered", "All",
 CounterIncrements->"EquationNumbered"],
Cell[58900, 2109, 95, 2, 36, 47, 0, "StyleData", "EquationNumbered", \
"Printout"],
Cell[58998, 2113, 107, 2, 36, 59, 0, "StyleData", "EquationNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[59142, 2120, 1008, 25, 29, 40, 0, "StyleData", "EquationGroupNumbered", \
"All",
 CounterIncrements->"EquationNumbered"],
Cell[60153, 2147, 100, 2, 27, 52, 0, "StyleData", "EquationGroupNumbered", \
"Printout"],
Cell[60256, 2151, 112, 2, 27, 64, 0, "StyleData", "EquationGroupNumbered", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[60405, 2158, 1254, 30, 29, 47, 0, "StyleData", \
"EquationGroupAlignedNumbered", "All",
 CounterIncrements->"EquationNumbered"],
Cell[61662, 2190, 107, 2, 27, 59, 0, "StyleData", \
"EquationGroupAlignedNumbered", "Printout"],
Cell[61772, 2194, 119, 2, 27, 71, 0, "StyleData", \
"EquationGroupAlignedNumbered", "DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[61928, 2201, 84, 2, 35, 33, 0, "StyleData", "EquationNumber", "All"],
Cell[62015, 2205, 73, 1, 35, 45, 0, "StyleData", "EquationNumber", \
"Printout"],
Cell[62091, 2208, 85, 1, 35, 57, 0, "StyleData", "EquationNumber", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[62225, 2215, 49, 0, 45, "Subsubsection"],
Cell[62277, 2217, 31, 0, 35, 31, 0, "StyleData", "EquationGrid", "All"],
Cell[62311, 2219, 32, 0, 35, 32, 0, "StyleData", "SplitEquation", "All"],
Cell[62346, 2221, 28, 0, 35, 28, 0, "StyleData", "Piecewise", "All"],
Cell[62377, 2223, 25, 0, 35, 25, 0, "StyleData", "Matrix", "All"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[62451, 2229, 63, 1, 30, "Subsection"],
Cell[CellGroupData[{
Cell[62539, 2234, 367, 9, 35, 23, 0, "StyleData", "XRef", "All",
 ButtonStyleMenuListing->None],
Cell[62909, 2245, 61, 1, 35, 35, 0, "StyleData", "XRef", "Printout"],
Cell[62973, 2248, 73, 1, 35, 47, 0, "StyleData", "XRef", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[63083, 2254, 26, 0, 35, 26, 0, "StyleData", "PageRef", "All"],
Cell[63112, 2256, 38, 0, 35, 38, 0, "StyleData", "PageRef", "Printout"],
Cell[63153, 2258, 50, 0, 35, 50, 0, "StyleData", "PageRef", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[63252, 2264, 32, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[63309, 2268, 345, 9, 56, 34, 0, "StyleData", "BackmatterGroup", "All"],
Cell[63657, 2279, 118, 3, 16, 46, 0, "StyleData", "BackmatterGroup", \
"Printout"],
Cell[63778, 2284, 130, 3, 16, 58, 0, "StyleData", "BackmatterGroup", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[63945, 2292, 33, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[64003, 2296, 422, 11, 146, 34, 0, "StyleData", "AppendixSection", \
"All"],
Cell[64428, 2309, 120, 3, 117, 46, 0, "StyleData", "AppendixSection", \
"Printout"],
Cell[64551, 2314, 132, 3, 117, 58, 0, "StyleData", "AppendixSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[64720, 2322, 682, 18, 156, 40, 0, "StyleData", "AppendixSectionNumber", \
"All",
 CounterIncrements->"AppendixSectionNumber",
 CounterAssignments->{{"Section", 0}, {"AppendixEquation", 0}, {
   "FigureCaption", 0}, {"TableTitle", 0}}],
Cell[65405, 2342, 198, 5, 126, 52, 0, "StyleData", "AppendixSectionNumber", \
"Printout"],
Cell[65606, 2349, 210, 5, 126, 64, 0, "StyleData", "AppendixSectionNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[65853, 2359, 282, 7, 35, 27, 0, "StyleData", "Appendix", "All",
 CounterIncrements->"Appendix",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[66138, 2368, 131, 4, 32, 39, 0, "StyleData", "Appendix", "Printout"],
Cell[66272, 2374, 143, 4, 32, 51, 0, "StyleData", "Appendix", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[66452, 2383, 788, 19, 41, 35, 0, "StyleData", "AppendixEquation", "All",
 CounterIncrements->"AppendixEquation"],
Cell[67243, 2404, 62, 1, 36, 47, 0, "StyleData", "AppendixEquation", \
"Printout"],
Cell[67308, 2407, 74, 1, 34, 59, 0, "StyleData", "AppendixEquation", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[67431, 2414, 58, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[67514, 2419, 451, 13, 295, 33, 0, "StyleData", "EndnoteSection", "All"],
Cell[67968, 2434, 95, 2, 235, 45, 0, "StyleData", "EndnoteSection", \
"Printout"],
Cell[68066, 2438, 107, 2, 235, 57, 0, "StyleData", "EndnoteSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[68210, 2445, 317, 9, 31, 26, 0, "StyleData", "Endnote", "All",
 CounterIncrements->"Endnote"],
Cell[68530, 2456, 110, 3, 28, 38, 0, "StyleData", "Endnote", "Printout"],
Cell[68643, 2461, 119, 3, 28, 50, 0, "StyleData", "Endnote", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[68799, 2469, 300, 7, 35, 31, 0, "StyleData", "EndnoteLabel", "All",
 CounterIncrements->"EndnoteLabel"],
Cell[69102, 2478, 71, 1, 35, 43, 0, "StyleData", "EndnoteLabel", "Printout"],
Cell[69176, 2481, 83, 1, 35, 55, 0, "StyleData", "EndnoteLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[69296, 2487, 120, 3, 35, 32, 0, "StyleData", "EndnoteNumber", "All",
 CounterIncrements->"EndnoteNumber"],
Cell[69419, 2492, 44, 0, 35, 44, 0, "StyleData", "EndnoteNumber", \
"Printout"],
Cell[69466, 2494, 56, 0, 35, 56, 0, "StyleData", "EndnoteNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[69559, 2499, 236, 6, 35, 26, 0, "StyleData", "NoteKey", "All",
 ButtonStyleMenuListing->None],
Cell[69798, 2507, 64, 1, 35, 38, 0, "StyleData", "NoteKey", "Printout"],
Cell[69865, 2510, 76, 1, 35, 50, 0, "StyleData", "NoteKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[69978, 2516, 253, 6, 35, 36, 0, "StyleData", "EndnoteReturnLink", "All",
 ButtonStyleMenuListing->None],
Cell[70234, 2524, 113, 2, 35, 48, 0, "StyleData", "EndnoteReturnLink", \
"Printout"],
Cell[70350, 2528, 125, 2, 35, 60, 0, "StyleData", "EndnoteReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[70512, 2535, 281, 7, 35, 31, 0, "StyleData", "TableNoteKey", "All",
 ButtonStyleMenuListing->None],
Cell[70796, 2544, 69, 1, 35, 43, 0, "StyleData", "TableNoteKey", "Printout"],
Cell[70868, 2547, 81, 1, 35, 55, 0, "StyleData", "TableNoteKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[70964, 2551, 361, 10, 35, 23, 0, "StyleData", "Note", "All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[71350, 2565, 375, 9, 35, 23, 0, "StyleData", "Note", "All"],
Cell[71728, 2576, 54, 1, 35, 35, 0, "StyleData", "Note", "Printout"],
Cell[71785, 2579, 66, 1, 35, 47, 0, "StyleData", "Note", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[71900, 2586, 35, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[71960, 2590, 549, 14, 295, 35, 0, "StyleData", "ReferenceSection", "All",
 
 CounterIncrements->"ReferenceSection",
 CounterAssignments->{{"ReferenceText", 0}, {"BiblioEquation", 0}}],
Cell[72512, 2606, 97, 2, 235, 47, 0, "StyleData", "ReferenceSection", \
"Printout"],
Cell[72612, 2610, 109, 2, 235, 59, 0, "StyleData", "ReferenceSection", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[72758, 2617, 560, 16, 29, 28, 0, "StyleData", "Reference", "All",
 CounterIncrements->"BibliographyItem"],
Cell[73321, 2635, 131, 4, 28, 40, 0, "StyleData", "Reference", "Printout"],
Cell[73455, 2641, 143, 4, 28, 52, 0, "StyleData", "Reference", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[73635, 2650, 242, 7, 35, 33, 0, "StyleData", "ReferenceLabel", "All",
 CounterIncrements->"RefDingbat"],
Cell[73880, 2659, 73, 1, 35, 45, 0, "StyleData", "ReferenceLabel", \
"Printout"],
Cell[73956, 2662, 85, 1, 35, 57, 0, "StyleData", "ReferenceLabel", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[74078, 2668, 95, 2, 35, 25, 0, "StyleData", "RefSep", "All"],
Cell[74176, 2672, 37, 0, 35, 37, 0, "StyleData", "RefSep", "Printout"],
Cell[74216, 2674, 49, 0, 35, 49, 0, "StyleData", "RefSep", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[74302, 2679, 339, 8, 35, 32, 0, "StyleData", "RefReturnLink", "All",
 ButtonStyleMenuListing->None],
Cell[74644, 2689, 70, 1, 35, 44, 0, "StyleData", "RefReturnLink", \
"Printout"],
Cell[74717, 2692, 82, 1, 35, 56, 0, "StyleData", "RefReturnLink", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[74836, 2698, 403, 10, 37, 35, 0, "StyleData", "RefReturnPointer", "All",
 ButtonStyleMenuListing->None],
Cell[75242, 2710, 73, 1, 35, 47, 0, "StyleData", "RefReturnPointer", \
"Printout"],
Cell[75318, 2713, 85, 1, 35, 59, 0, "StyleData", "RefReturnPointer", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[75440, 2719, 374, 10, 24, 38, 0, "StyleData", "ReferenceSourceLink", \
"All",
 ButtonStyleMenuListing->None],
Cell[75817, 2731, 76, 1, 35, 50, 0, "StyleData", "ReferenceSourceLink", \
"Printout"]
}, Closed]],
Cell[75908, 2735, 37, 0, 35, 37, 0, "StyleData", "ReferenceSourceURL", \
"All"],
Cell[CellGroupData[{
Cell[75970, 2739, 347, 8, 35, 27, 0, "StyleData", "Citation", "All",
 ButtonStyleMenuListing->None],
Cell[76320, 2749, 65, 1, 35, 39, 0, "StyleData", "Citation", "Printout"],
Cell[76388, 2752, 77, 1, 35, 51, 0, "StyleData", "Citation", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[76502, 2758, 234, 6, 35, 25, 0, "StyleData", "RefKey", "All",
 ButtonStyleMenuListing->None],
Cell[76739, 2766, 63, 1, 35, 37, 0, "StyleData", "RefKey", "Printout"],
Cell[76805, 2769, 75, 1, 35, 49, 0, "StyleData", "RefKey", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[76917, 2775, 73, 1, 43, "Subsubsubsection"],
Cell[76993, 2778, 83, 1, 20, "ReferenceTemplate"],
Cell[77079, 2781, 86, 1, 20, "ReferenceTemplate"],
Cell[77168, 2784, 86, 1, 20, "ReferenceTemplate"],
Cell[77257, 2787, 82, 1, 20, "ReferenceTemplate"],
Cell[77342, 2790, 85, 1, 20, "ReferenceTemplate"],
Cell[77430, 2793, 84, 1, 20, "ReferenceTemplate"],
Cell[77517, 2796, 49, 0, 20, "ReferenceTemplate"],
Cell[77569, 2798, 49, 0, 20, "ReferenceTemplate"],
Cell[77621, 2800, 49, 0, 20, "ReferenceTemplate"],
Cell[77673, 2802, 49, 0, 20, "ReferenceTemplate"],
Cell[77725, 2804, 49, 0, 20, "ReferenceTemplate"],
Cell[77777, 2806, 56, 0, 20, "ReferenceTemplate"],
Cell[77836, 2808, 56, 0, 20, "ReferenceTemplate"],
Cell[CellGroupData[{
Cell[77917, 2812, 48, 0, 42, "Subsubsubsubsection"],
Cell[77968, 2814, 191, 4, 33, "ReferenceTemplate"],
Cell[78162, 2820, 152, 3, 20, "ReferenceTemplate"],
Cell[78317, 2825, 177, 3, 33, "ReferenceTemplate"],
Cell[78497, 2830, 139, 3, 20, "ReferenceTemplate"],
Cell[78639, 2835, 172, 3, 33, "ReferenceTemplate"],
Cell[78814, 2840, 136, 3, 20, "ReferenceTemplate"],
Cell[78953, 2845, 159, 3, 20, "ReferenceTemplate"],
Cell[79115, 2850, 123, 3, 20, "ReferenceTemplate"],
Cell[79241, 2855, 185, 4, 33, "ReferenceTemplate"],
Cell[79429, 2861, 146, 3, 20, "ReferenceTemplate"],
Cell[79578, 2866, 171, 3, 20, "ReferenceTemplate"],
Cell[79752, 2871, 133, 3, 20, "ReferenceTemplate"],
Cell[79888, 2876, 166, 3, 20, "ReferenceTemplate"],
Cell[80057, 2881, 130, 3, 20, "ReferenceTemplate"],
Cell[80190, 2886, 153, 3, 20, "ReferenceTemplate"],
Cell[80346, 2891, 117, 3, 20, "ReferenceTemplate"],
Cell[80466, 2896, 176, 4, 33, "ReferenceTemplate"],
Cell[80645, 2902, 137, 3, 20, "ReferenceTemplate"],
Cell[80785, 2907, 162, 3, 20, "ReferenceTemplate"],
Cell[80950, 2912, 124, 3, 20, "ReferenceTemplate"],
Cell[81077, 2917, 157, 3, 20, "ReferenceTemplate"],
Cell[81237, 2922, 121, 3, 20, "ReferenceTemplate"],
Cell[81361, 2927, 144, 3, 20, "ReferenceTemplate"],
Cell[81508, 2932, 106, 2, 20, "ReferenceTemplate"],
Cell[81617, 2936, 146, 3, 42, "Text"],
Cell[81766, 2941, 152, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[81955, 2949, 48, 0, 42, "Subsubsubsubsection"],
Cell[82006, 2951, 99, 2, 42, "Text"],
Cell[82108, 2955, 144, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[82289, 2963, 51, 0, 42, "Subsubsubsubsection"],
Cell[82343, 2965, 138, 3, 20, "ReferenceTemplate"],
Cell[82484, 2970, 99, 2, 20, "ReferenceTemplate"],
Cell[82586, 2974, 117, 3, 20, "ReferenceTemplate"],
Cell[82706, 2979, 143, 3, 42, "Text"],
Cell[82852, 2984, 85, 1, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[82974, 2990, 47, 0, 42, "Subsubsubsubsection"],
Cell[83024, 2992, 168, 3, 20, "ReferenceTemplate"],
Cell[83195, 2997, 133, 3, 20, "ReferenceTemplate"],
Cell[83331, 3002, 148, 3, 42, "Text"],
Cell[83482, 3007, 168, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[83687, 3015, 57, 0, 42, "Subsubsubsubsection"],
Cell[83747, 3017, 105, 3, 42, "Text"],
Cell[83855, 3022, 125, 3, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[84017, 3030, 54, 0, 42, "Subsubsubsubsection"],
Cell[84074, 3032, 107, 3, 42, "Text"],
Cell[84184, 3037, 105, 2, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[84326, 3044, 49, 0, 42, "Subsubsubsubsection"],
Cell[84378, 3046, 103, 3, 42, "Text"],
Cell[84484, 3051, 87, 1, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[84608, 3057, 55, 0, 42, "Subsubsubsubsection"],
Cell[84666, 3059, 127, 3, 42, "Text"],
Cell[84796, 3064, 58, 0, 20, "ReferenceTemplate"]
}, Closed]],
Cell[CellGroupData[{
Cell[84891, 3069, 45, 0, 42, "Subsubsubsubsection"],
Cell[84939, 3071, 97, 2, 42, "Text"],
Cell[85039, 3075, 44, 0, 20, "ReferenceTemplate"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[85132, 3081, 77, 1, 43, "Subsubsubsection"],
Cell[85212, 3084, 98, 2, 35, 27, 0, "StyleData", "RefTitle", "All"],
Cell[85313, 3088, 46, 1, 20, 26, 0, "StyleData", "RefType", "All"],
Cell[85362, 3091, 25, 0, 35, 25, 0, "StyleData", "RefURL", "All"],
Cell[85390, 3093, 35, 0, 35, 35, 0, "StyleData", "RefRetrievalDate", "All"],
Cell[85428, 3095, 38, 0, 35, 38, 0, "StyleData", "RefSourceOfAbstract", \
"All"],
Cell[85469, 3097, 37, 0, 35, 37, 0, "StyleData", "RefInsertedBibText", \
"All"],
Cell[85509, 3099, 26, 0, 35, 26, 0, "StyleData", "RefNote", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[85572, 3104, 75, 1, 43, "Subsubsubsection"],
Cell[85650, 3107, 102, 2, 35, 31, 0, "StyleData", "RefBookTitle", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[85789, 3114, 78, 1, 43, "Subsubsubsection"],
Cell[85870, 3117, 34, 0, 35, 34, 0, "StyleData", "RefJournalTitle", "All"],
Cell[85907, 3119, 105, 2, 35, 35, 0, "StyleData", "RefJournalVolume", "All"],
Cell[86015, 3123, 35, 0, 35, 35, 0, "StyleData", "RefJournalNumber", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[86087, 3128, 80, 1, 43, "Subsubsubsection"],
Cell[86170, 3131, 31, 0, 35, 31, 0, "StyleData", "RefPublisher", "All"],
Cell[86204, 3133, 47, 1, 35, 26, 0, "StyleData", "RefCity", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[86288, 3139, 77, 1, 43, "Subsubsubsection"],
Cell[86368, 3142, 33, 0, 35, 33, 0, "StyleData", "RefAuthorGroup", "All"],
Cell[86404, 3144, 30, 0, 35, 30, 0, "StyleData", "RefAuthorFN", "All"],
Cell[86437, 3146, 30, 0, 35, 30, 0, "StyleData", "RefAuthorLN", "All"],
Cell[86470, 3148, 30, 0, 35, 30, 0, "StyleData", "RefAuthorMN", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[86537, 3153, 77, 1, 43, "Subsubsubsection"],
Cell[86617, 3156, 33, 0, 35, 33, 0, "StyleData", "RefEditorGroup", "All"],
Cell[86653, 3158, 30, 0, 35, 30, 0, "StyleData", "RefEditorFN", "All"],
Cell[86686, 3160, 30, 0, 35, 30, 0, "StyleData", "RefEditorMN", "All"],
Cell[86719, 3162, 30, 0, 35, 30, 0, "StyleData", "RefEditorLN", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[86786, 3167, 77, 1, 43, "Subsubsubsection"],
Cell[86866, 3170, 28, 0, 35, 28, 0, "StyleData", "RefSchool", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[86931, 3175, 87, 1, 43, "Subsubsubsection"],
Cell[87021, 3178, 25, 0, 35, 25, 0, "StyleData", "RefDay", "All"],
Cell[87049, 3180, 27, 0, 35, 27, 0, "StyleData", "RefMonth", "All"],
Cell[87079, 3182, 26, 0, 35, 26, 0, "StyleData", "RefYear", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[87142, 3187, 114, 2, 43, "Subsubsubsection"],
Cell[87259, 3191, 52, 1, 35, 31, 0, "StyleData", "RefFirstPage", "All"],
Cell[87314, 3194, 51, 1, 35, 30, 0, "StyleData", "RefLastPage", "All"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[87426, 3202, 35, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[87486, 3206, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[87543, 3210, 850, 21, 156, 36, 0, "StyleData", "BookChapterNumber", \
"All",
 CounterIncrements->"BookChapterNumber",
 CounterAssignments->{{"Section", 0}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"EquationNumbered", 0}, {"FigureCaption", 0}, {
   "PictureCaption", 0}, {"ProgramCaption", 0}, {"TableTitle", 0}, {
   "Figure", 0}, {"Picture", 0}, {"Program", 0}, {"Table", 0}}],
Cell[88396, 3233, 194, 5, 126, 48, 0, "StyleData", "BookChapterNumber", \
"Printout"],
Cell[88593, 3240, 206, 5, 126, 60, 0, "StyleData", "BookChapterNumber", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[88836, 3250, 375, 10, 143, 35, 0, "StyleData", "BookChapterTitle", \
"All"],
Cell[89214, 3262, 95, 2, 117, 47, 0, "StyleData", "BookChapterTitle", \
"Printout"],
Cell[89312, 3266, 107, 2, 117, 59, 0, "StyleData", "BookChapterTitle", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[89468, 3274, 58, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[89551, 3279, 177, 4, 51, 27, 0, "StyleData", "Epigraph", "All"],
Cell[89731, 3285, 88, 2, 47, 39, 0, "StyleData", "Epigraph", "Printout"],
Cell[89822, 3289, 122, 3, 47, 51, 0, "StyleData", "Epigraph", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[89981, 3297, 168, 3, 63, 33, 0, "StyleData", "EpigraphAuthor", "All"],
Cell[90152, 3302, 95, 2, 57, 45, 0, "StyleData", "EpigraphAuthor", \
"Printout"],
Cell[90250, 3306, 107, 2, 57, 57, 0, "StyleData", "EpigraphAuthor", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[90418, 3315, 41, 0, 30, "Subsection"],
Cell[90462, 3317, 94, 3, 32, 25, 0, "StyleData", "Header", "All"],
Cell[90559, 3322, 92, 3, 30, 25, 0, "StyleData", "Footer", "All"],
Cell[90654, 3327, 144, 5, 31, 29, 0, "StyleData", "PageNumber", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[90835, 3337, 35, 0, 30, "Subsection"],
Cell[90873, 3339, 255, 5, 35, 34, 0, "StyleData", "TextSuperscript", "All"],
Cell[91131, 3346, 182, 4, 35, 32, 0, "StyleData", "TextSubscript", "All"],
Cell[91316, 3352, 22, 0, 35, 22, 0, "StyleData", "Nil", "All"],
Cell[91341, 3354, 27, 0, 35, 27, 0, "StyleData", "Verbatim", "All"],
Cell[91371, 3356, 103, 2, 35, 26, 0, "StyleData", "TeXName", "All"],
Cell[91477, 3360, 107, 2, 35, 28, 0, "StyleData", "LaTeXName", "All"],
Cell[91587, 3364, 109, 2, 35, 29, 0, "StyleData", "LaTeXeName", "All"],
Cell[91699, 3368, 86, 2, 35, 34, 0, "StyleData", "ChemicalElement", "All"],
Cell[91788, 3372, 63, 1, 35, 34, 0, "StyleData", "CustomCharacter", "All"],
Cell[91854, 3375, 26, 0, 35, 26, 0, "StyleData", "Palette", "All"],
Cell[CellGroupData[{
Cell[91905, 3379, 547, 16, 1, 28, 0, "StyleData", "PageBreak", "All"],
Cell[92455, 3397, 116, 3, 12, 40, 0, "StyleData", "PageBreak", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[92608, 3405, 147, 5, 51, 31, 0, "StyleData", "CreationDate", "All"],
Cell[92758, 3412, 111, 3, 23, 43, 0, "StyleData", "CreationDate", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[92906, 3420, 42, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[92973, 3424, 121, 3, 19, 29, 0, "StyleData", "SingleLine", "All"],
Cell[93097, 3429, 133, 3, 19, 41, 0, "StyleData", "SingleLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[93267, 3437, 230, 7, 21, 29, 0, "StyleData", "DoubleLine", "All"],
Cell[93500, 3446, 88, 2, 19, 41, 0, "StyleData", "DoubleLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[93625, 3453, 253, 8, 12, 27, 0, "StyleData", "ThinLine", "All"],
Cell[93881, 3463, 39, 0, 12, 39, 0, "StyleData", "ThinLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[93957, 3468, 253, 8, 14, 29, 0, "StyleData", "MediumLine", "All"],
Cell[94213, 3478, 41, 0, 14, 41, 0, "StyleData", "MediumLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[94291, 3483, 252, 8, 15, 28, 0, "StyleData", "ThickLine", "All"],
Cell[94546, 3493, 40, 0, 15, 40, 0, "StyleData", "ThickLine", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[94623, 3498, 73, 1, 35, 25, 0, "StyleData", "Spacer", "All"],
Cell[94699, 3501, 37, 0, 35, 37, 0, "StyleData", "Spacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[94773, 3506, 29, 0, 35, 29, 0, "StyleData", "TextSpacer", "All"],
Cell[94805, 3508, 41, 0, 35, 41, 0, "StyleData", "TextSpacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[94883, 3513, 32, 0, 35, 32, 0, "StyleData", "SectionSpacer", "All"],
Cell[94918, 3515, 44, 0, 35, 44, 0, "StyleData", "SectionSpacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[94999, 3520, 33, 0, 35, 33, 0, "StyleData", "GraphicsSpacer", "All"],
Cell[95035, 3522, 45, 0, 35, 45, 0, "StyleData", "GraphicsSpacer", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[95129, 3528, 54, 1, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[95208, 3533, 307, 8, 56, 28, 0, "StyleData", "VitaGroup", "All"],
Cell[95518, 3543, 40, 0, 56, 40, 0, "StyleData", "VitaGroup", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[95595, 3548, 63, 1, 41, 29, 0, "StyleData", "VitaAuthor", "All"],
Cell[95661, 3551, 81, 1, 37, 41, 0, "StyleData", "VitaAuthor", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[95779, 3557, 75, 1, 41, 41, 0, "StyleData", "VitaContactInformation", \
"All"],
Cell[95857, 3560, 93, 1, 37, 53, 0, "StyleData", "VitaContactInformation", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[95987, 3566, 171, 5, 69, 30, 0, "StyleData", "VitaSection", "All"],
Cell[96161, 3573, 90, 2, 60, 42, 0, "StyleData", "VitaSection", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[96288, 3580, 244, 7, 64, 33, 0, "StyleData", "VitaSubsection", "All"],
Cell[96535, 3589, 93, 2, 53, 45, 0, "StyleData", "VitaSubsection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[96665, 3596, 542, 12, 30, 27, 0, "StyleData", "VitaItem", "All"],
Cell[97210, 3610, 86, 2, 28, 39, 0, "StyleData", "VitaItem", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[97333, 3617, 231, 6, 35, 32, 0, "StyleData", "VitaItemLabel", "All"],
Cell[97567, 3625, 87, 2, 34, 44, 0, "StyleData", "VitaItemLabel", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[97691, 3632, 301, 6, 29, 36, 0, "StyleData", "VitaItemParagraph", "All",
 CounterAssignments->{{"Item2Numbered", 0}, {"Item3Numbered", 0}}],
Cell[97995, 3640, 96, 2, 28, 48, 0, "StyleData", "VitaItemParagraph", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[98128, 3647, 57, 1, 41, 23, 0, "StyleData", "Vita", "All"],
Cell[98188, 3650, 75, 1, 37, 35, 0, "StyleData", "Vita", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[98312, 3657, 32, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[98369, 3661, 447, 12, 47, 27, 0, "StyleData", "Outline1", "All",
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}}],
Cell[98819, 3675, 86, 2, 43, 39, 0, "StyleData", "Outline1", "Printout"],
Cell[98908, 3679, 98, 2, 43, 51, 0, "StyleData", "Outline1", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[99043, 3686, 104, 3, 35, 32, 0, "StyleData", "Outline1Label", "All"],
Cell[99150, 3691, 72, 1, 35, 44, 0, "StyleData", "Outline1Label", \
"Printout"],
Cell[99225, 3694, 84, 1, 35, 56, 0, "StyleData", "Outline1Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[99346, 3700, 469, 13, 45, 27, 0, "StyleData", "Outline2", "All",
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}}],
Cell[99818, 3715, 87, 2, 41, 39, 0, "StyleData", "Outline2", "Printout"],
Cell[99908, 3719, 99, 2, 41, 51, 0, "StyleData", "Outline2", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[100044, 3726, 104, 3, 35, 32, 0, "StyleData", "Outline2Label", "All"],
Cell[100151, 3731, 72, 1, 35, 44, 0, "StyleData", "Outline2Label", \
"Printout"],
Cell[100226, 3734, 84, 1, 35, 56, 0, "StyleData", "Outline2Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[100347, 3740, 415, 11, 43, 27, 0, "StyleData", "Outline3", "All",
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}}],
Cell[100765, 3753, 87, 2, 39, 39, 0, "StyleData", "Outline3", "Printout"],
Cell[100855, 3757, 99, 2, 39, 51, 0, "StyleData", "Outline3", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[100991, 3764, 104, 3, 35, 32, 0, "StyleData", "Outline3Label", "All"],
Cell[101098, 3769, 72, 1, 35, 44, 0, "StyleData", "Outline3Label", \
"Printout"],
Cell[101173, 3772, 84, 1, 35, 56, 0, "StyleData", "Outline3Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[101294, 3778, 393, 10, 41, 27, 0, "StyleData", "Outline4", "All",
 CounterIncrements->"Outline4"],
Cell[101690, 3790, 87, 2, 38, 39, 0, "StyleData", "Outline4", "Printout"],
Cell[101780, 3794, 99, 2, 38, 51, 0, "StyleData", "Outline4", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[101916, 3801, 104, 3, 35, 32, 0, "StyleData", "Outline4Label", "All"],
Cell[102023, 3806, 72, 1, 35, 44, 0, "StyleData", "Outline4Label", \
"Printout"],
Cell[102098, 3809, 84, 1, 35, 56, 0, "StyleData", "Outline4Label", \
"DoubleSpacedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[102219, 3815, 213, 5, 35, 30, 0, "StyleData", "OutlineText", "All",
 CounterIncrements->"Text"],
Cell[102435, 3822, 135, 4, 32, 42, 0, "StyleData", "OutlineText", \
"Printout"],
Cell[102573, 3828, 147, 4, 32, 54, 0, "StyleData", "OutlineText", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[102769, 3838, 35, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[102829, 3842, 1077, 29, 4, 41, 0, "StyleData", "SlideShowNavigationBar", \
"All",
 CounterIncrements->"SlideShowNavigationBar",
 CounterAssignments->{{"Item1Numbered", 0}}],
Cell[103909, 3873, 193, 5, 25, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[104139, 3883, 285, 9, 49, 33, 0, "StyleData", "SlideHyperlink", "All",
 ButtonStyleMenuListing->None],
Cell[104427, 3894, 115, 2, 35, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"],
Cell[104545, 3898, 127, 2, 35, 57, 0, "StyleData", "SlideHyperlink", \
"DoubleSpacedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[104733, 3907, 35, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[104793, 3911, 73, 1, 45, "Subsubsection"],
Cell[104869, 3914, 64, 2, 35, 21, 0, "StyleData", "RM", "All"],
Cell[104936, 3918, 91, 2, 35, 21, 0, "StyleData", "BF", "All"],
Cell[105030, 3922, 129, 3, 35, 21, 0, "StyleData", "IT", "All"],
Cell[105162, 3927, 152, 3, 31, 28, 0, "StyleData", "SmallCaps", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[105351, 3935, 79, 1, 45, "Subsubsection"],
Cell[105433, 3938, 86, 3, 35, 21, 0, "StyleData", "TR", "All"],
Cell[105522, 3943, 173, 5, 35, 21, 0, "StyleData", "TI", "All"],
Cell[105698, 3950, 171, 5, 35, 21, 0, "StyleData", "TB", "All"],
Cell[105872, 3957, 183, 5, 35, 22, 0, "StyleData", "TBI", "All"],
Cell[106058, 3964, 260, 7, 36, 21, 0, "StyleData", "MR", "All"],
Cell[106321, 3973, 271, 7, 36, 21, 0, "StyleData", "MO", "All"],
Cell[106595, 3982, 269, 7, 36, 21, 0, "StyleData", "MB", "All"],
Cell[106867, 3991, 287, 8, 36, 22, 0, "StyleData", "MBO", "All"],
Cell[107157, 4001, 176, 5, 35, 21, 0, "StyleData", "SR", "All"],
Cell[107336, 4008, 187, 5, 36, 21, 0, "StyleData", "SO", "All"],
Cell[107526, 4015, 185, 5, 36, 21, 0, "StyleData", "SB", "All"],
Cell[107714, 4022, 203, 6, 36, 22, 0, "StyleData", "SBO", "All"],
Cell[107920, 4030, 122, 2, 35, 32, 0, "StyleData", "PlainGreekWin", "All"],
Cell[108045, 4034, 114, 2, 39, 32, 0, "StyleData", "PlainGreekMac", "All"],
Cell[108162, 4038, 114, 2, 39, 32, 0, "StyleData", "PlainGreekLin", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[108313, 4045, 35, 0, 45, "Subsubsection"],
Cell[CellGroupData[{
Cell[108373, 4049, 364, 9, 35, 28, 0, "StyleData", "Hyperlink", "All",
 ButtonStyleMenuListing->None],
Cell[108740, 4060, 120, 3, 34, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[108897, 4068, 263, 7, 35, 29, 0, "StyleData", "XMLWebLink", "All",
 ButtonStyleMenuListing->None],
Cell[109163, 4077, 106, 2, 35, 41, 0, "StyleData", "XMLWebLink", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[109306, 4084, 53, 0, 43, "Subsubsubsection"],
Cell[CellGroupData[{
Cell[109384, 4088, 278, 7, 35, 32, 0, "StyleData", "UserGuideLink", "All",
 ButtonStyleMenuListing->None],
Cell[109665, 4097, 109, 2, 35, 44, 0, "StyleData", "UserGuideLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[109811, 4104, 278, 7, 35, 32, 0, "StyleData", "ReferenceLink", "All",
 ButtonStyleMenuListing->None],
Cell[110092, 4113, 109, 2, 35, 44, 0, "StyleData", "ReferenceLink", \
"Printout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[110274, 4123, 28, 0, 30, "Subsection"],
Cell[CellGroupData[{
Cell[110327, 4127, 67, 1, 45, "Subsubsection"],
Cell[110397, 4130, 304, 7, 117, "Text"],
Cell[110704, 4139, 290, 9, 52, 33, 0, "StyleData", "CellExpression", "All"],
Cell[110997, 4150, 78, 2, 36, 28, 0, "StyleData", "InputForm", "All"],
Cell[111078, 4154, 132, 4, 41, 29, 0, "StyleData", "OutputForm", "All"],
Cell[111213, 4160, 80, 2, 36, 31, 0, "StyleData", "StandardForm", "All"],
Cell[111296, 4164, 149, 4, 35, 34, 0, "StyleData", "TraditionalForm", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[111482, 4173, 56, 0, 45, "Subsubsection"],
Cell[111541, 4175, 122, 3, 42, 36, 0, "StyleData", "ReferenceTemplate", \
"All"],
Cell[111666, 4180, 136, 3, 42, 50, 0, "StyleData", \
"AuthorFormCustomizationTemplate", "All"],
Cell[111805, 4185, 119, 3, 42, 33, 0, "StyleData", "CSSDefinitions", "All"],
Cell[111927, 4190, 118, 3, 42, 32, 0, "StyleData", "LaTeXPreamble", "All"],
Cell[112048, 4195, 118, 3, 42, 32, 0, "StyleData", "DOCTYPEFormat", "All"],
Cell[112169, 4200, 122, 3, 42, 36, 0, "StyleData", "ValidationSetting", \
"All"],
Cell[112294, 4205, 124, 3, 42, 38, 0, "StyleData", "XRefPaletteSettings", \
"All"],
Cell[112421, 4210, 117, 3, 42, 31, 0, "StyleData", "MiscSettings", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[112575, 4218, 62, 1, 45, "Subsubsection"],
Cell[112640, 4221, 116, 5, 87, "Text"],
Cell[112759, 4228, 84, 2, 35, 29, 0, "StyleData", "InlineCell", "All"],
Cell[112846, 4232, 89, 1, 51, 36, 0, "StyleData", "InlineCellEditing", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[112972, 4238, 57, 1, 45, "Subsubsection"],
Cell[113032, 4241, 122, 5, 87, "Text"],
Cell[113157, 4248, 191, 4, 39, 24, 0, "StyleData", "Paste", "All",
 ButtonStyleMenuListing->Automatic],
Cell[113351, 4254, 161, 3, 35, 29, 0, "StyleData", "StyleApply", "All",
 ButtonStyleMenuListing->Automatic],
Cell[113515, 4259, 218, 5, 35, 45, 0, "StyleData", \
"StyleApplyWithVerification", "All",
 ButtonStyleMenuListing->Automatic],
Cell[113736, 4266, 286, 6, 35, 35, 0, "StyleData", "ConvertCharacter", "All",
 ButtonStyleMenuListing->Automatic]
}, Closed]],
Cell[CellGroupData[{
Cell[114059, 4277, 59, 1, 45, "Subsubsection"],
Cell[114121, 4280, 330, 9, 132, "Text"],
Cell[114454, 4291, 82, 1, 35, 35, 0, "StyleData", "UnmatchedBracket", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[114573, 4297, 63, 1, 45, "Subsubsection"],
Cell[114639, 4300, 159, 4, 2067, 55, 0, "StyleData", \
"DialogStyleSheetMisapplicationEscape", "All"]
}, Closed]]
}, Closed]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
