(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    384926,      12838]
NotebookOptionsPosition[    247601,       9505]
NotebookOutlinePosition[    248365,       9534]
CellTagsIndexPosition[    248249,       9528]
MenuPosition->0
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions for Online Help", "Title"],

Cell["\<\
These styles are carefully tuned for all aspects of the online help. It's \
recommended that they remain unchanged.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
 PageWidth->WindowWidth,
 ShowCellBracket->False,
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Brackets"],
 PageWidth->WindowWidth,
 ShowCellBracket->True,
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
 PageWidth->WindowWidth,
 ShowCellBracket->False,
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "SlideShow"],
 PageWidth->WindowWidth,
 ScrollingOptions->{"PagewiseDisplay"->True,
 "VerticalScrollRange"->Fit},
 ShowCellBracket->False,
 ShowAutoStyles->False,
 ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
 PageWidth->PaperWidth,
 ShowCellBracket->False,
 ShowAutoStyles->False,
 ScriptMinSize->5,
 PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "EnhancedPrintout"],
 PageWidth->PaperWidth,
 ShowCellBracket->True,
 ShowAutoStyles->False,
 ScriptMinSize->5,
 FontFamily->"Palatino",
 PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "EnhancedPrintoutNonGray"],
 PageWidth->PaperWidth,
 ShowCellBracket->False,
 ShowAutoStyles->False,
 ScriptMinSize->5,
 FontFamily->"Palatino",
 PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
  The options defined for the style below will be used at the Notebook level. \
 \
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Notebook"],
 PageHeaders->{{
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"], None, 
    Cell[
     TextData[{"Printed from the ", 
       StyleBox["Mathematica", FontSlant -> "Italic"], " Help Browser"}], 
     "PageHeader"]}, {
    Cell[
     TextData[{"Printed from the ", 
       StyleBox["Mathematica", FontSlant -> "Italic"], " Help Browser"}], 
     "PageHeader"], None, 
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"]}},
 PageFooters->{{None, 
    Cell[
     TextData[{
      "\[Copyright]1988\[Dash]2007 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, 
    Cell[
     TextData[{
      "\[Copyright]1988\[Dash]2007 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
 PageHeaderLines->{True, True},
 PageFooterLines->{True, True},
 PrintingOptions->{"FacingPages"->True},
 CellLabelAutoDelete->False,
 CellFrameLabelMargins->6],

Cell[StyleData["Notebook", "Printout"],
 PageHeaders->{{
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"], None, 
    Cell[
     TextData[{"Printed from the ", 
       StyleBox["Mathematica", FontSlant -> "Italic"], " Help Browser"}], 
     "PageHeader"]}, {
    Cell[
     TextData[{"Printed from the ", 
       StyleBox["Mathematica", FontSlant -> "Italic"], " Help Browser"}], 
     "PageHeader"], None, 
    Cell[
     TextData[{
       CounterBox["Page"]}], "PageNumber"]}},
 PageFooters->{{None, 
    Cell[
     TextData[{
      "\[Copyright]1988-2006 Wolfram Research, Inc. All rights reserved."}], 
     "PageFooter"], None}, {None, 
    Cell[
     TextData[{
      "\[Copyright]1988-2006 Wolfram Research, Inc. All rights reserved."}], 
     "PageFooter"], None}},
 PageHeaderLines->{True, True},
 PageFooterLines->{True, True},
 PrintingOptions->{"FacingPages"->True}],

Cell[StyleData["Notebook", "EnhancedPrintout"],
 PageFooters->{{None, None, None}, {None, None, None}},
 PageHeaderLines->{True, True},
 PageFooterLines->{False, False},
 PrintingOptions->{"FacingPages"->True,
 "FirstPageFace"->Right,
 "FirstPageHeader"->False,
 "PageSize"->{594, 657},
 "PrintRegistrationMarks"->True,
 "PrintingMargins"->{{54, 54}, {36, 72}}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Chapter"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{27, 27}, {10, 40}},
 CellGroupingRules->{"TitleGrouping", 0},
 PageBreakBelow->False,
 DefaultNewInlineCellStyle->"None",
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 LanguageCategory->"NaturalLanguage",
 CounterIncrements->"Chapter",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subtitle", 0}, {"Subsubtitle", 0}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Plain",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Chapter", "Presentation"],
 FontSize->36],

Cell[StyleData["Chapter", "Printout"],
 CellMargins->{{2, 10}, {6, 30}},
 FontSize->24],

Cell[StyleData["Chapter", "EnhancedPrintout"],
 CellFrame->False,
 CellMargins->{{2, 10}, {6, 30}},
 FontFamily->"Frutiger-Bold",
 FontSize->24,
 FontColor->GrayLevel[0]],

Cell[StyleData["Chapter", "EnhancedPrintoutNonGray"],
 CellFrame->False,
 CellMargins->{{2, 10}, {6, 30}},
 FontFamily->"Frutiger-Bold",
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
 CellMargins->{{27, 27}, {9, 30}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->20,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Section", "Presentation"],
 FontSize->30],

Cell[StyleData["Section", "SlideShow"],
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {5, 0}},
 PageBreakBelow->False,
 CellFrameMargins->{{36, 36}, {Inherited, 15}},
 FontFamily->"Helvetica",
 FontSize->18,
 FontWeight->"Bold",
 FontColor->GrayLevel[1],
 Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["Section", "Printout"],
 CellMargins->{{2, 0}, {0, 18}},
 PageBreakBelow->False,
 FontSize->18],

Cell[StyleData["Section", "EnhancedPrintout"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{2, 2}, {5, 30}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 CellFrameMargins->8,
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Frutiger-Bold",
 FontSize->16,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["Section", "EnhancedPrintoutNonGray"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{2, Inherited}, {5, 30}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 CellFrameMargins->8,
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Frutiger-Bold",
 FontSize->16,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
 CellDingbat->None,
 CellMargins->{{27, 27}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 CellFrameLabelMargins->6,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->16,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Subsection", "Presentation"],
 FontSize->24],

Cell[StyleData["Subsection", "SlideShow"],
 CellDingbat->None,
 CellMargins->{{70, 0}, {4, 12}},
 FontSize->12],

Cell[StyleData["Subsection", "Printout"],
 CellMargins->{{2, 0}, {5, 24}},
 FontSize->12],

Cell[StyleData["Subsection", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {5, 20}},
 FontFamily->"Frutiger-Bold",
 FontSize->12,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["Subsection", "EnhancedPrintoutNonGray"],
 CellMargins->{{9, 0}, {5, 20}},
 FontFamily->"Frutiger-Bold",
 FontSize->12,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
 CellMargins->{{27, 27}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 CellGroupingRules->{"SectionGrouping", 50},
 PageBreakBelow->False,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Subsubsection", "Presentation"],
 FontSize->18],

Cell[StyleData["Subsubsection", "Printout"],
 CellMargins->{{2, 0}, {3, 8}},
 FontSize->10],

Cell[StyleData["Subsubsection", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {3, 8}},
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["Subsubsection", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {3, 8}},
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionColor"],
 CellMargins->{{27, 27}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 CellGroupingRules->{"SectionGrouping", 50},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.297993, 0, 0.454994]],

Cell[StyleData["SubsubsectionColor", "Presentation"],
 FontSize->18],

Cell[StyleData["SubsubsectionColor", "Printout"],
 CellMargins->{{2, 0}, {0, 18}},
 PageBreakBelow->False,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionIcon"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{46, 27}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->8},
 CellGroupingRules->{"SectionGrouping", 40},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->16,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SubsectionIcon", "Presentation"],
 FontSize->24],

Cell[StyleData["SubsectionIcon", "Printout"],
 CellDingbat->"\[FilledSquare]",
 ShowGroupOpenCloseIcon->False,
 CellMargins->{{16, 0}, {0, 18}},
 PageBreakBelow->False,
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionIcon"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{46, 27}, {0, 8}},
 CellElementSpacings->{"ClosedGroupTopMargin"->4},
 CellGroupingRules->{"SectionGrouping", 50},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 CounterIncrements->"Subsubsection",
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SubsubsectionIcon", "Presentation"],
 FontSize->18],

Cell[StyleData["SubsubsectionIcon", "Printout"],
 ShowGroupOpenCloseIcon->False,
 CellMargins->{{2, 0}, {0, 18}},
 PageBreakBelow->False,
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
 CellMargins->{{27, 27}, {0, 8}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 ParagraphSpacing->{0, 8},
 CounterIncrements->"Text",
 FontSize->12],

Cell[StyleData["Text", "Presentation"],
 FontSize->18],

Cell[StyleData["Text", "SlideShow"],
 CellMargins->{{36, 24}, {4, 4}},
 Hyphenation->False,
 FontSize->14],

Cell[StyleData["Text", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["Text", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["Text", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CompactText"],
 CellMargins->{{27, 27}, {0, 8}},
 ParagraphSpacing->{0, 0},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["CompactText", "Presentation"],
 FontSize->15],

Cell[StyleData["CompactText", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontSize->8],

Cell[StyleData["CompactText", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->8],

Cell[StyleData["CompactText", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Compact12Text"],
 CellMargins->{{27, 27}, {0, 8}},
 ParagraphSpacing->{0, 0},
 StyleMenuListing->None],

Cell[StyleData["Compact12Text", "Presentation"],
 FontSize->18],

Cell[StyleData["Compact12Text", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["Compact12Text", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["Compact12Text", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextSans"],
 CellMargins->{{27, 27}, {0, 8}},
 CellHorizontalScrolling->True,
 ParagraphSpacing->{0, 8},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10],

Cell[StyleData["TextSans", "Presentation"],
 FontSize->15],

Cell[StyleData["TextSans", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontSize->8],

Cell[StyleData["TextSans", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontFamily->"Frutiger-Roman",
 FontSize->8],

Cell[StyleData["TextSans", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontFamily->"Frutiger-Roman",
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedText"],
 CellMargins->{{66, 4}, {4, 4}},
 LineSpacing->{1, 3},
 ParagraphIndent->-22,
 CounterIncrements->"ItemizedText",
 StyleMenuListing->None],

Cell[StyleData["ItemizedText", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedText", "Printout"],
 CellMargins->{{16, 4}, {2, 4}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["ItemizedText", "EnhancedPrintout"],
 CellMargins->{{16, 4}, {2, 4}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedText", "EnhancedPrintoutNonGray"],
 Hyphenation->True,
 LineSpacing->{1, 1},
 ParagraphIndent->-18,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote"],
 CellMargins->{{88, 4}, {4, 0}},
 LineSpacing->{1, 2},
 CounterIncrements->"ItemizedTextNote",
 StyleMenuListing->None],

Cell[StyleData["ItemizedTextNote", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedTextNote", "Printout"],
 CellMargins->{{34, 4}, {4, 1}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["ItemizedTextNote", "EnhancedPrintout"],
 CellMargins->{{39, 4}, {4, 1}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedTextNote", "EnhancedPrintoutNonGray"],
 CellMargins->{{39, 4}, {4, 1}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndentedText"],
 CellMargins->{{66, 4}, {0, 6}},
 LineSpacing->{1, 3},
 CounterIncrements->"IndentedText",
 StyleMenuListing->None],

Cell[StyleData["IndentedText", "Presentation"],
 FontSize->18],

Cell[StyleData["IndentedText", "SlideShow"],
 CellMargins->{{80, 24}, {5, 5}},
 Hyphenation->False,
 FontSize->13],

Cell[StyleData["IndentedText", "Printout"],
 CellMargins->{{16, 4}, {2, 4}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["IndentedText", "EnhancedPrintout"],
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["IndentedText", "EnhancedPrintoutNonGray"],
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedList"],
 CellMargins->{{58, 4}, {4, 4}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       StyleBox[
        CounterBox["ItemizedList"], "TB"], 
       StyleBox[".", "TB"]}], CellBaseline -> Baseline, 
     CellSize -> {24, Inherited}, TextAlignment -> Right], Inherited}, {
   Inherited, Inherited}},
 LineSpacing->{1, 3},
 CounterIncrements->"ItemizedList",
 StyleMenuListing->None],

Cell[StyleData["ItemizedList", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedList", "Printout"],
 CellMargins->{{9, 4}, {2, 4}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["ItemizedList", "EnhancedPrintout"],
 CellMargins->{{9, 4}, {2, 4}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedList", "EnhancedPrintoutNonGray"],
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedSubList"],
 CellMargins->{{92, 4}, {4, 4}},
 CellFrameLabels->{{
    Cell[
     TextData[{
       StyleBox[
        CounterBox["ItemizedSubList"], "TB"], 
       StyleBox[".", "TB"]}], CellBaseline -> Baseline, 
     CellSize -> {24, Inherited}, TextAlignment -> Right], Inherited}, {
   Inherited, Inherited}},
 CounterIncrements->"ItemizedSubList",
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["ItemizedSubList", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedSubList", "Printout"],
 CellMargins->{{34, 4}, {4, 1}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["ItemizedSubList", "EnhancedPrintout"],
 CellMargins->{{26, 4}, {2, 4}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedSubList", "EnhancedPrintoutNonGray"],
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedSubListNote"],
 CellMargins->{{110, 4}, {4, 4}},
 CounterIncrements->"ItemizedSubList",
 StyleMenuListing->None,
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["ItemizedSubListNote", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedSubListNote", "Printout"],
 CellMargins->{{34, 4}, {4, 1}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["ItemizedSubListNote", "EnhancedPrintout"],
 CellMargins->{{56, 4}, {2, 4}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedSubListNote", "EnhancedPrintoutNonGray"],
 CellMargins->{{48, 4}, {2, 4}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BulletedList"],
 CellMargins->{{76, 4}, {4, 4}},
 CellFrameLabels->{{
    Cell["\[Bullet]", "BulletedList", CellBaseline -> Baseline], Inherited}, {
   Inherited, Inherited}},
 LineSpacing->{1, 3},
 CounterIncrements->"BulletText",
 StyleMenuListing->None],

Cell[StyleData["BulletedList", "Presentation"],
 FontSize->18],

Cell[StyleData["BulletedList", "Printout"],
 CellMargins->{{16, 4}, {4, 1}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["BulletedList", "EnhancedPrintout"],
 CellMargins->{{26, 4}, {2, 4}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["BulletedList", "EnhancedPrintoutNonGray"],
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListNote"],
 CellMargins->{{88, 4}, {4, 0}},
 LineSpacing->{1, 2},
 CounterIncrements->"ListNote",
 StyleMenuListing->None],

Cell[StyleData["ListNote", "Presentation"],
 FontSize->18],

Cell[StyleData["ListNote", "Printout"],
 CellMargins->{{34, 4}, {4, 1}},
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["ListNote", "EnhancedPrintout"],
 CellMargins->{{39, 4}, {4, 1}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ListNote", "EnhancedPrintoutNonGray"],
 CellMargins->{{39, 4}, {4, 1}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MathCaption"],
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{66, 12}, {2, 20}},
 PageBreakBelow->False,
 CellFrameMargins->{{8, 8}, {8, 2}},
 CellFrameColor->GrayLevel[0.700008],
 CellFrameLabelMargins->4,
 LineSpacing->{1, 1},
 ParagraphSpacing->{0, 8},
 FontColor->GrayLevel[0.2]],

Cell[StyleData["MathCaption", "Presentation"],
 FontSize->18],

Cell[StyleData["MathCaption", "SlideShow"],
 ShowCellBracket->False,
 CellMargins->{{36, 36}, {6, 6}}],

Cell[StyleData["MathCaption", "Printout"],
 CellMargins->{{9, 0}, {0, 14}},
 Hyphenation->True,
 FontSize->9,
 FontColor->GrayLevel[0]],

Cell[StyleData["MathCaption", "EnhancedPrintout"],
 CellMargins->{{9, 0}, {0, 14}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->9,
 FontColor->GrayLevel[0]],

Cell[StyleData["MathCaption", "EnhancedPrintoutNonGray"],
 CellMargins->{{9, 0}, {0, 14}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
 CellMargins->{{27, 27}, {0, 8}},
 LineSpacing->{1, 3},
 ParagraphSpacing->{0.7, 0},
 CounterIncrements->"SmallText",
 FontSize->9],

Cell[StyleData["SmallText", "Presentation"],
 FontSize->14],

Cell[StyleData["SmallText", "Printout"],
 CellMargins->{{2, 2}, {5, 5}},
 TextJustification->1,
 Hyphenation->True,
 FontSize->7],

Cell[StyleData["SmallText", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {5, 5}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->7],

Cell[StyleData["SmallText", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 2}, {5, 5}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names.    \
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
 ShowCellBracket->True,
 CellMargins->{{66, 4}, {3, 8}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelAutoDelete->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 ShowSpecialCharacters->Automatic,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Mathematica",
 FormatType->StandardForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
 FontSize->18],

Cell[StyleData["Input", "SlideShow"],
 ShowCellBracket->True,
 CellMargins->{{100, 50}, {0, 6}},
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellFrameMargins->{{8, 8}, {4, 8}},
 Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["Input", "Printout"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {4, 6}},
 FontSize->9],

Cell[StyleData["Input", "EnhancedPrintout"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {4, 6}},
 FontSize->9],

Cell[StyleData["Input", "EnhancedPrintoutNonGray"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {4, 6}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
 ShowCellBracket->True,
 CellMargins->{{66, 4}, {8, 2}},
 CellEditDuplicate->True,
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabelAutoDelete->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->None,
 FormatType->StandardForm],

Cell[StyleData["Output", "Presentation"],
 FontSize->18],

Cell[StyleData["Output", "SlideShow"],
 ShowCellBracket->True,
 CellMargins->{{100, 50}, {6, 0}},
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellFrameMargins->{{8, 8}, {8, 4}},
 Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["Output", "Printout"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {6, 4}},
 FontSize->9],

Cell[StyleData["Output", "EnhancedPrintout"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {6, 4}},
 FontSize->9],

Cell[StyleData["Output", "EnhancedPrintoutNonGray"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {6, 4}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputOnly"],
 ShowCellBracket->True,
 CellMargins->{{66, 4}, {8, 8}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelAutoDelete->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 ShowSpecialCharacters->Automatic,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Mathematica",
 FormatType->StandardForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["InputOnly", "Presentation"],
 FontSize->18],

Cell[StyleData["InputOnly", "SlideShow"],
 ShowCellBracket->True,
 CellMargins->{{100, 50}, {6, 6}},
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["InputOnly", "Printout"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {6, 6}},
 FontSize->9],

Cell[StyleData["InputOnly", "EnhancedPrintout"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {6, 6}},
 FontSize->9],

Cell[StyleData["InputOnly", "EnhancedPrintoutNonGray"],
 ShowCellBracket->False,
 CellMargins->{{39, 0}, {6, 6}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
 ShowCellBracket->True,
 CellMargins->{{66, 4}, {4, 2}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 AutoStyleOptions->{"SyntaxErrorStyle"->None},
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->None,
 FormatType->InputForm,
 CounterIncrements->"Message",
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontColor->RGBColor[0.6, 0.100008, 0.100008]],

Cell[StyleData["Message", "Presentation"],
 FontSize->18],

Cell[StyleData["Message", "SlideShow"],
 CellMargins->{{100, 50}, {6, 6}},
 FontSize->10,
 FontColor->RGBColor[0.699992, 0.4, 0]],

Cell[StyleData["Message", "Printout"],
 ShowCellBracket->False,
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontSize->9,
 FontColor->GrayLevel[0]],

Cell[StyleData["Message", "EnhancedPrintout"],
 ShowCellBracket->False,
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontFamily->"Courier",
 FontSize->9,
 FontColor->GrayLevel[0]],

Cell[StyleData["Message", "EnhancedPrintoutNonGray"],
 ShowCellBracket->False,
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 FontFamily->"Courier",
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
 ShowCellBracket->True,
 CellMargins->{{66, 4}, {4, 2}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->None,
 FormatType->InputForm,
 StyleMenuListing->None],

Cell[StyleData["Print", "Presentation"],
 FontSize->18],

Cell[StyleData["Print", "SlideShow"],
 CellMargins->{{100, 50}, {6, 6}}],

Cell[StyleData["Print", "Printout"],
 ShowCellBracket->False,
 CellMargins->{{57, Inherited}, {Inherited, Inherited}},
 FontSize->9],

Cell[StyleData["Print", "EnhancedPrintout"],
 ShowCellBracket->False,
 CellMargins->{{57, Inherited}, {Inherited, Inherited}},
 FontFamily->"Courier Std",
 FontSize->9],

Cell[StyleData["Print", "EnhancedPrintoutNonGray"],
 ShowCellBracket->False,
 CellMargins->{{57, Inherited}, {Inherited, Inherited}},
 FontFamily->"Courier Std",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
 ShowCellBracket->True,
 CellMargins->{{66, 4}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 AutoStyleOptions->{"HighlightMisspelledWords"->False},
 LanguageCategory->"NaturalLanguage",
 FormatType->InputForm,
 ShowStringCharacters->False,
 NumberMarks->False,
 CounterIncrements->"Graphics",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 StyleMenuListing->None,
 FontFamily->"Times",
 FontSize->10,
 FontWeight->"Plain"],

Cell[StyleData["Graphics", "Presentation"],
 FontSize->18],

Cell[StyleData["Graphics", "SlideShow"],
 ShowCellBracket->True,
 CellMargins->{{100, 50}, {6, 0}},
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellFrameMargins->{{8, 8}, {4, 4}},
 Background->RGBColor[1, 1, 0.8]],

Cell[StyleData["Graphics", "Printout"],
 ShowCellBracket->False,
 CellMargins->{{39, Inherited}, {Inherited, Inherited}},
 ImageSize->{250, 250},
 FontSize->9],

Cell[StyleData["Graphics", "EnhancedPrintout"],
 ShowCellBracket->False,
 CellMargins->{{32, Inherited}, {Inherited, Inherited}},
 ImageSize->{250, 250},
 FontFamily->"Courier Std",
 FontSize->9],

Cell[StyleData["Graphics", "EnhancedPrintoutNonGray"],
 ShowCellBracket->False,
 CellMargins->{{32, Inherited}, {Inherited, Inherited}},
 ImageSize->{250, 250},
 FontFamily->"Courier Std",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
 LanguageCategory->None,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontWeight->"Plain",
 FontColor->RGBColor[0.269993, 0.308507, 0.6]],

Cell[StyleData["CellLabel", "Presentation"],
 FontSize->14],

Cell[StyleData["CellLabel", "SlideShow"],
 FontColor->RGBColor[0.699992, 0.4, 0]],

Cell[StyleData["CellLabel", "Printout"],
 FontFamily->"Courier",
 FontSize->8,
 FontSlant->"Oblique",
 FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "EnhancedPrintout"],
 FontFamily->"Courier Std",
 FontSize->8,
 FontSlant->"Oblique",
 FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std",
 FontSize->8,
 FontSlant->"Oblique",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Name"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontWeight->"Plain",
 FontSlant->"Italic",
 FontColor->RGBColor[0.269993, 0.308507, 0.6]],

Cell[StyleData["Name", "Presentation"],
 FontSize->14],

Cell[StyleData["Name", "Printout"],
 FontSize->7,
 FontSlant->"Oblique",
 FontColor->GrayLevel[0]],

Cell[StyleData["Name", "EnhancedPrintout"],
 FontFamily->"Frutiger-Italic",
 FontSize->7,
 FontSlant->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["Name", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Italic",
 FontSize->7,
 FontSlant->"Plain",
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Default Box Styles", "Section"],

Cell["\<\
The following styles are the default styles for the boxes used in the Front \
End.\
\>", "Text"],

Cell[StyleData["DefaultGraphicsBox"],
 CellMargins->{{4, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"GraphicsGrouping",
 StripStyleOnPaste->False,
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 AutoStyleOptions->{"HighlightMisspelledWords"->False},
 LanguageCategory->"NaturalLanguage",
 FormatType->StandardForm,
 ShowStringCharacters->False,
 NumberMarks->False,
 CounterIncrements->"Graphics",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 StyleMenuListing->None,
 FontFamily->"Times",
 FontSize->10,
 FontWeight->"Plain"],

Cell[StyleData["DefaultGraphics3DBox"],
 CellMargins->{{4, Inherited}, {Inherited, Inherited}},
 CellGroupingRules->"GraphicsGrouping",
 StripStyleOnPaste->False,
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 DefaultFormatType->DefaultOutputFormatType,
 AutoStyleOptions->{"HighlightMisspelledWords"->False},
 LanguageCategory->"NaturalLanguage",
 FormatType->StandardForm,
 ShowStringCharacters->False,
 NumberMarks->False,
 CounterIncrements->"Graphics",
 ImageMargins->{{43, Inherited}, {Inherited, 0}},
 StyleMenuListing->None,
 FontFamily->"Times",
 FontSize->10,
 FontWeight->"Plain"],

Cell[StyleData["DefaultPanelBox"],
 FontFamily->CurrentValue["PanelFontFamily"],
 FontSize->CurrentValue["PanelFontSize"]],

Cell[StyleData["DefaultPopupBox"],
 TextAlignment->Left,
 TextJustification->0.,
 FontFamily->CurrentValue["ControlsFontFamily"],
 FontSize->CurrentValue["ControlsFontSize"]],

Cell[StyleData["DefaultButtonBox"],
 TextAlignment->Left,
 TextJustification->0.,
 FontFamily->CurrentValue["ControlsFontFamily"],
 FontSize->CurrentValue["ControlsFontSize"]]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlinks", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext ButtonBoxes.  The \
\"Hyperlink\" style is for links within the same Notebook, or between \
Notebooks. The others point to the various sections of the help browser. \
These styles will modify individual words or letters in a cell exclusive of \
the cell tag.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["Hyperlink", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]],

Cell[StyleData["Hyperlink", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "MainBook", #]}]& )}],

Cell[StyleData["MainBookLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["MainBookLink", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]],

Cell[StyleData["MainBookLink", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MainBookLinkMR"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "MainBook", #]}]& )}],

Cell[StyleData["MainBookLinkMR", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["MainBookLinkMR", "EnhancedPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["MainBookLinkMR", "EnhancedPrintoutNonGray"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "AddOns", #]}]& )}],

Cell[StyleData["AddOnsLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["AddOnsLink", "EnhancedPrintout"],
 FontFamily->"WRICourier",
 FontColor->GrayLevel[0]],

Cell[StyleData["AddOnsLink", "EnhancedPrintoutNonGray"],
 FontFamily->"WRICourier",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLinkText"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Times",
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "AddOns", #]}]& )}],

Cell[StyleData["AddOnsLinkText", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["AddOnsLinkText", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]],

Cell[StyleData["AddOnsLinkText", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "RefGuide", #]}]& )}],

Cell[StyleData["RefGuideLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["RefGuideLink", "EnhancedPrintout"],
 FontFamily->"WRICourier",
 FontColor->GrayLevel[0]],

Cell[StyleData["RefGuideLink", "EnhancedPrintoutNonGray"],
 FontFamily->"WRICourier",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "GettingStarted", #]}]& )}],

Cell[StyleData["GettingStartedLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["GettingStartedLink", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]],

Cell[StyleData["GettingStartedLink", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DemosLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "Demos", #]}]& )}],

Cell[StyleData["DemosLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["DemosLink", "EnhancedPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["DemosLink", "EnhancedPrintoutNonGray"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TourLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "Tour", #]}]& )}],

Cell[StyleData["TourLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["TourLink", "EnhancedPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["TourLink", "EnhancedPrintoutNonGray"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "OtherInformation", #]}]& )}],

Cell[StyleData["OtherInformationLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["OtherInformationLink", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]],

Cell[StyleData["OtherInformationLink", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLinkMR"],
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "OtherInformation", #]}]& )}],

Cell[StyleData["OtherInformationLinkMR", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintoutNonGray"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MasterIndexLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "MasterIndex", #]}]& )}],

Cell[StyleData["MasterIndexLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["MasterIndexLink", "EnhancedPrintout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["MasterIndexLink", "EnhancedPrintoutNonGray"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NotebookLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Times",
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#]}]& )}],

Cell[StyleData["NotebookLink", "Printout"],
 FontSize->11,
 FontColor->GrayLevel[0]],

Cell[StyleData["NotebookLink", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["NotebookLink", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NotebookLinkMR"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Courier",
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#]}]& )}],

Cell[StyleData["NotebookLinkMR", "Printout"],
 FontSize->11,
 FontColor->GrayLevel[0]],

Cell[StyleData["NotebookLinkMR", "EnhancedPrintout"],
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["NotebookLinkMR", "EnhancedPrintoutNonGray"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, for use \
in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, After]}]& )}],

Cell[StyleData["Evaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["EvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionMove[
     FrontEnd`InputNotebook[], All, Cell, 1], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluate"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluate[
     FrontEnd`InputNotebook[], All]}]& )}],

Cell[StyleData["CopyEvaluateCell"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionCreateCell[
     FrontEnd`InputNotebook[], All], 
    FrontEnd`NotebookApply[
     FrontEnd`InputNotebook[], #, All], 
    FrontEnd`SelectionEvaluateCreateCell[
     FrontEnd`InputNotebook[], All]}]& )}]
}, Closed]],

Cell[CellGroupData[{

Cell["Inline Formatting", "Section"],

Cell["\<\
These styles are for modifying individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["JT"],
 StyleMenuListing->None,
 FontFamily->"JFontText"],

Cell[StyleData["JT", "Printout"]],

Cell[StyleData["JT", "EnhancedPrintout"]],

Cell[StyleData["JT", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["JS"],
 StyleMenuListing->None,
 FontFamily->"JFontSans"],

Cell[StyleData["JS", "Printout"]],

Cell[StyleData["JS", "EnhancedPrintout"]],

Cell[StyleData["JS", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["JSB"],
 StyleMenuListing->None,
 FontFamily->"JFontSansBold"],

Cell[StyleData["JSB", "Printout"]],

Cell[StyleData["JSB", "EnhancedPrintout"]],

Cell[StyleData["JSB", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RM"],
 StyleMenuListing->None,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["RM", "Printout"]],

Cell[StyleData["RM", "EnhancedPrintout"]],

Cell[StyleData["RM", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BF"],
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["BF", "Printout"]],

Cell[StyleData["BF", "EnhancedPrintout"]],

Cell[StyleData["BF", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IT"],
 StyleMenuListing->None,
 FontSlant->"Italic"],

Cell[StyleData["IT", "Printout"]],

Cell[StyleData["IT", "EnhancedPrintout"]],

Cell[StyleData["IT", "EnhancedPrintoutNonGray"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TR"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["TR", "Printout"]],

Cell[StyleData["TR", "EnhancedPrintout"],
 FontFamily->"Palatino"],

Cell[StyleData["TR", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontSlant->"Italic"],

Cell[StyleData["TI", "Printout"]],

Cell[StyleData["TI", "EnhancedPrintout"],
 FontFamily->"Palatino"],

Cell[StyleData["TI", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TB"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["TB", "Printout"]],

Cell[StyleData["TB", "EnhancedPrintout"],
 FontFamily->"Palatino"],

Cell[StyleData["TB", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TBI"],
 StyleMenuListing->None,
 FontFamily->"Times",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["TBI", "Printout"]],

Cell[StyleData["TBI", "EnhancedPrintout"],
 FontFamily->"Palatino"],

Cell[StyleData["TBI", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MR"],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MR", "Printout"]],

Cell[StyleData["MR", "EnhancedPrintout"],
 FontFamily->"Courier Std"],

Cell[StyleData["MR", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MO"],
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["MO", "Printout"],
 FontSlant->"Oblique"],

Cell[StyleData["MO", "EnhancedPrintout"],
 FontFamily->"Courier Std",
 FontSlant->"Oblique"],

Cell[StyleData["MO", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std",
 FontSlant->"Oblique"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MB"],
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["MB", "Printout"]],

Cell[StyleData["MB", "EnhancedPrintout"],
 FontFamily->"Courier Std"],

Cell[StyleData["MB", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MBO"],
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["MBO", "Printout"],
 FontSlant->"Oblique"],

Cell[StyleData["MBO", "EnhancedPrintout"],
 FontFamily->"Courier Std",
 FontSlant->"Oblique"],

Cell[StyleData["MBO", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std",
 FontSlant->"Oblique"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SR"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SR", "Printout"]],

Cell[StyleData["SR", "EnhancedPrintout"],
 FontFamily->"Frutiger-Roman"],

Cell[StyleData["SR", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Roman"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SO", "Printout"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SO", "EnhancedPrintout"],
 FontFamily->"Frutiger-Italic",
 FontSlant->"Plain"],

Cell[StyleData["SO", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Italic",
 FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SB"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SB", "Printout"],
 StyleMenuListing->None],

Cell[StyleData["SB", "EnhancedPrintout"],
 FontFamily->"Frutiger-Bold",
 FontWeight->"Plain"],

Cell[StyleData["SB", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Bold",
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SBColor"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Plain"],

Cell[StyleData["SBColor", "Printout"],
 StyleMenuListing->None],

Cell[StyleData["SBColor", "EnhancedPrintout"],
 FontFamily->"Frutiger-Bold",
 FontWeight->"Plain"],

Cell[StyleData["SBColor", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Bold",
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SBO"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SBO", "Printout"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["SBO", "EnhancedPrintout"],
 FontFamily->"Frutiger-BoldItalic",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SBO", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-BoldItalic",
 FontWeight->"Plain",
 FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["M4"],
 ShowCellBracket->True,
 StyleMenuListing->None,
 FontFamily->"Mathematica4",
 CharacterEncoding->"Mathematica4"],

Cell[StyleData["M4", "Printout"],
 ShowCellBracket->True,
 StyleMenuListing->None,
 FontFamily->"Mathematica4",
 CharacterEncoding->"Mathematica4"],

Cell[StyleData["M4", "EnhancedPrintout"],
 ShowCellBracket->True,
 StyleMenuListing->None,
 FontFamily->"Mathematica4",
 CharacterEncoding->"Mathematica4"],

Cell[StyleData["M4", "EnhancedPrintoutNonGray"],
 ShowCellBracket->True,
 StyleMenuListing->None,
 FontFamily->"Mathematica4",
 CharacterEncoding->"Mathematica4"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SO10"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SO10", "Printout"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->8,
 FontWeight->"Plain",
 FontSlant->"Italic"],

Cell[StyleData["SO10", "EnhancedPrintout"],
 StyleMenuListing->None,
 FontFamily->"Frutiger-Italic",
 FontSize->8,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["SO10", "EnhancedPrintoutNonGray"],
 StyleMenuListing->None,
 FontFamily->"Frutiger-Italic",
 FontSize->8,
 FontWeight->"Plain",
 FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["S9"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontWeight->"Plain"],

Cell[StyleData["S9", "Printout"],
 FontSize->9,
 FontWeight->"Plain"],

Cell[StyleData["S9", "EnhancedPrintout"],
 FontFamily->"Frutiger-Roman",
 FontSize->9,
 FontWeight->"Plain"],

Cell[StyleData["S9", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Roman",
 FontSize->9,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["S10"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Plain"],

Cell[StyleData["S10", "Printout"],
 FontSize->10,
 FontWeight->"Plain"],

Cell[StyleData["S10", "EnhancedPrintout"],
 FontFamily->"Frutiger-Roman",
 FontSize->10,
 FontWeight->"Plain"],

Cell[StyleData["S10", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Roman",
 FontSize->10,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SB9"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9,
 FontWeight->"Bold",
 PrivateFontOptions->{"OperatorSubstitution"->False}],

Cell[StyleData["SB9", "Printout"],
 FontSize->7],

Cell[StyleData["SB9", "EnhancedPrintout"],
 FontFamily->"Frutiger-Bold",
 FontSize->7,
 FontWeight->"Plain"],

Cell[StyleData["SB9", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Bold",
 FontSize->7,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SB10"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold"],

Cell[StyleData["SB10", "Printout"],
 FontSize->8],

Cell[StyleData["SB10", "EnhancedPrintout"],
 FontFamily->"Frutiger-Bold",
 FontSize->8,
 FontWeight->"Plain"],

Cell[StyleData["SB10", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Bold",
 FontSize->8,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MR10"],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 SingleLetterItalics->False,
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->10,
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["MR10", "Printout"],
 FontSize->7],

Cell[StyleData["MR10", "EnhancedPrintout"],
 FontFamily->"Courier Std",
 FontSize->7],

Cell[StyleData["MR10", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std",
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MO10"],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 SingleLetterItalics->False,
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->10,
 FontWeight->"Plain",
 FontSlant->"Oblique"],

Cell[StyleData["MO10", "Printout"],
 FontSize->7],

Cell[StyleData["MR10", "EnhancedPrintout"],
 FontFamily->"Courier Std",
 FontSize->7],

Cell[StyleData["MO10", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std",
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["C1"],
 StyleMenuListing->None,
 FontColor->RGBColor[0.4, 0, 1]],

Cell[StyleData["C1", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["C1", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["C1", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["C1MR"],
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontColor->RGBColor[0.4, 0, 1]],

Cell[StyleData["C1MR", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["C1MR", "EnhancedPrintout"],
 FontFamily->"Courier Std",
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["C1MR", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std",
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallCaps"],
 StyleMenuListing->None,
 Magnification->0.8],

Cell[StyleData["SmallCaps", "Printout"]],

Cell[StyleData["SmallCaps", "EnhancedPrintout"],
 FontFamily->"Palatino"],

Cell[StyleData["SmallCaps", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["KeyboardChars"],
 StyleMenuListing->None,
 FontSize->12],

Cell[StyleData["KeyboardChars", "Printout"],
 FontSize->10],

Cell[StyleData["KeyboardChars", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["KeyboardChars", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[StyleData["Tiny"],
 StyleMenuListing->None,
 FontSize->8],

Cell[StyleData["Small"],
 StyleMenuListing->None,
 FontSize->9],

Cell[StyleData["Medium"],
 StyleMenuListing->None,
 FontSize->12],

Cell[StyleData["Large"],
 StyleMenuListing->None,
 FontSize->24],

Cell[StyleData["PackageLoaded"],
 StyleMenuListing->None,
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0., 0.501960784313725, 0.501960784313725]],

Cell[StyleData["PackageNotLoaded"],
 StyleMenuListing->None,
 FontSize->10,
 FontWeight->"Bold"],

Cell[StyleData["FunctionTemplate"],
 StyleMenuListing->None],

Cell[StyleData["NoPrintFunctionTemplate"],
 StyleMenuListing->None],

Cell[CellGroupData[{

Cell["TMB Specific", "Subsection"],

Cell[StyleData["HeadingNumber"],
 StyleMenuListing->None],

Cell[StyleData["NewInVersion6"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0.5]],

Cell[StyleData["NewInVersion6"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0.5]],

Cell[StyleData["ModInVersion6"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0.5]],

Cell[StyleData["ModInVersion5"],
 StyleMenuListing->None,
 FontColor->GrayLevel[0.5]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Emphasis Boxes and Pictures", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Box"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["Box", "Presentation"],
 FontSize->18],

Cell[StyleData["Box", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["Box", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["Box", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DoubleBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.4]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["DoubleBox", "Presentation"],
 FontSize->18],

Cell[StyleData["DoubleBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["DoubleBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["DoubleBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["1ColumnBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["1ColumnBox", "Presentation"],
 FontSize->18],

Cell[StyleData["1ColumnBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["1ColumnBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["1ColumnBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 SingleLetterItalics->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.31], {
      Scaled[0.67]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["2ColumnBox", "Presentation"],
 FontSize->18],

Cell[StyleData["2ColumnBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->9,
 Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->9,
 Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->9,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.46]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["2ColumnEvenBox", "Presentation"],
 FontSize->18],

Cell[StyleData["2ColumnEvenBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnEvenBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnEvenBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnSmallBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.05]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["2ColumnSmallBox", "Presentation"],
 FontSize->18],

Cell[StyleData["2ColumnSmallBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnSmallBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["2ColumnSmallBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.32]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["3ColumnBox", "Presentation"],
 FontSize->18],

Cell[StyleData["3ColumnBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["3ColumnBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["3ColumnBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnSmallBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Right, Center, {Left}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.24]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.05]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["3ColumnSmallBox", "Presentation"],
 FontSize->18],

Cell[StyleData["3ColumnSmallBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["3ColumnSmallBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["3ColumnSmallBox", "EnhancedPrintoutNonGray"],
 CellFrame->0.5,
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["4ColumnBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 SingleLetterItalics->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.13], 
     Scaled[0.35], 
     Scaled[0.13], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["4ColumnBox", "Presentation"],
 FontSize->18],

Cell[StyleData["4ColumnBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["4ColumnBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["4ColumnBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {{
      Scaled[0.202]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["5ColumnBox", "Presentation"],
 FontSize->18],

Cell[StyleData["5ColumnBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->9,
 Background->GrayLevel[0.900008]],

Cell[StyleData["5ColumnBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->9,
 Background->GrayLevel[0.900008]],

Cell[StyleData["5ColumnBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->9,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{BoxFrame->0.5,
 FrameMargins->True},
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.12], 
     Scaled[0.22], 
     Scaled[0.12], 
     Scaled[0.12], 
     Scaled[0.22], {
      Scaled[0.12]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["6ColumnBox", "Presentation"],
 FontSize->18],

Cell[StyleData["6ColumnBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["6ColumnBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["6ColumnBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FramedBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.56]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["FramedBox", "Presentation"],
 FontSize->18],

Cell[StyleData["FramedBox", "Printout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["FramedBox", "EnhancedPrintout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["FramedBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.4], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["DefinitionBox", "Presentation"],
 FontSize->18],

Cell[StyleData["DefinitionBox", "Printout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox", "EnhancedPrintout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox3Col"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.35], 
     Scaled[0.2], {
      Scaled[0.45]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["DefinitionBox3Col", "Presentation"],
 FontSize->18],

Cell[StyleData["DefinitionBox3Col", "Printout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox3Col", "EnhancedPrintout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox3Col", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox4Col"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.15], 
     Scaled[0.35], 
     Scaled[0.15], {
      Scaled[0.35]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["DefinitionBox4Col", "Presentation"],
 FontSize->18],

Cell[StyleData["DefinitionBox4Col", "Printout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox4Col", "EnhancedPrintout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox4Col", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PrecedenceTable"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.3], 
     Scaled[0.45], 
     Scaled[0.2], {
      Scaled[0.05]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["PrecedenceTable", "Presentation"],
 FontSize->18],

Cell[StyleData["PrecedenceTable", "Printout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["PrecedenceTable", "EnhancedPrintout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["PrecedenceTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox5Col"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.2]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["DefinitionBox5Col", "Presentation"],
 FontSize->18],

Cell[StyleData["DefinitionBox5Col", "Printout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox5Col", "EnhancedPrintout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox5Col", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DefinitionBox6Col"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.13], 
     Scaled[0.24], 
     Scaled[0.13], 
     Scaled[0.13], 
     Scaled[0.24], {
      Scaled[0.13]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["DefinitionBox6Col", "Presentation"],
 FontSize->18],

Cell[StyleData["DefinitionBox6Col", "Printout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox6Col", "EnhancedPrintout"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["DefinitionBox6Col", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopBox"],
 CellFrame->{{0.5, 0.5}, {0, 0.5}},
 CellMargins->{{27, 12}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakBelow->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.31], {
      Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TopBox", "Presentation"],
 FontSize->18],

Cell[StyleData["TopBox", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 Background->GrayLevel[1]],

Cell[StyleData["TopBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 Background->GrayLevel[1]],

Cell[StyleData["TopBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleBox"],
 CellFrame->{{0.5, 0.5}, {0, 0}},
 CellMargins->{{27, 12}, {0, -7}},
 CellHorizontalScrolling->True,
 PageBreakAbove->False,
 PageBreakBelow->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.31], {
      Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["MiddleBox", "Presentation"],
 FontSize->18],

Cell[StyleData["MiddleBox", "Printout"],
 CellMargins->{{2, 0}, {0, 2}},
 CellFrameColor->GrayLevel[0],
 Background->GrayLevel[1]],

Cell[StyleData["MiddleBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 4}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 Background->GrayLevel[1]],

Cell[StyleData["MiddleBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 4}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BottomBox"],
 CellFrame->{{0.5, 0.5}, {0.5, 0}},
 CellMargins->{{27, 12}, {0, -7}},
 CellHorizontalScrolling->True,
 PageBreakAbove->False,
 PageBreakBelow->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.31], {
      Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["BottomBox", "Presentation"],
 FontSize->18],

Cell[StyleData["BottomBox", "Printout"],
 CellMargins->{{2, 0}, {0, -5}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{2.2}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["BottomBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, -5}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{2.2}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["BottomBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, -5}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{2.2}}, 
   "RowsIndexed" -> {}}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TopSpanBox"],
 CellFrame->{{0.5, 0.5}, {0, 0.5}},
 CellMargins->{{27, 12}, {-2, 8}},
 CellHorizontalScrolling->True,
 PageBreakBelow->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.9], {
      Scaled[0.03]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["TopSpanBox", "Presentation"],
 FontSize->18],

Cell[StyleData["TopSpanBox", "Printout"],
 CellMargins->{{2, 0}, {-2, 8}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["TopSpanBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {-4, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]],

Cell[StyleData["TopSpanBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {-4, 8}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleSpanBox"],
 CellFrame->{{0.5, 0.5}, {0, 0}},
 CellMargins->{{27, 12}, {0, 0}},
 CellHorizontalScrolling->True,
 PageBreakAbove->False,
 PageBreakBelow->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 ShowSyntaxStyles->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.9], {
      Scaled[0.03]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["MiddleSpanBox", "Presentation"],
 FontSize->18],

Cell[StyleData["MiddleSpanBox", "Printout"],
 CellMargins->{{2, 0}, {-5, 0}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.8}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["MiddleSpanBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {-7, 0}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.8}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["MiddleSpanBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {-7, 0}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 FontSize->10,
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.8}}, 
   "RowsIndexed" -> {}}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Picture"],
 CellMargins->{{27, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["Picture", "Presentation"],
 FontSize->18],

Cell[StyleData["Picture", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.65],

Cell[StyleData["Picture", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.65],

Cell[StyleData["Picture", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.65]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OpenCloseItemizedPicture"],
 CellMargins->{{88, 4}, {4, 4}},
 PrivateCellOptions->{"DefaultCellGroupOpen"->False},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["OpenCloseItemizedPicture", "Presentation"],
 FontSize->18],

Cell[StyleData["OpenCloseItemizedPicture", "Printout"],
 CellMargins->{{76, 2}, {0, 0}},
 CellElementSpacings->{"CellMinHeight"->1,
 "ClosedCellHeight"->0},
 CellOpen->False],

Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintout"],
 CellMargins->{{76, 2}, {0, 0}},
 CellElementSpacings->{"CellMinHeight"->1,
 "ClosedCellHeight"->0},
 CellOpen->False],

Cell[StyleData["OpenCloseItemizedPicture", "EnhancedPrintoutNonGray"],
 CellMargins->{{76, 2}, {0, 0}},
 CellElementSpacings->{"CellMinHeight"->1,
 "ClosedCellHeight"->0},
 CellOpen->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedPicture"],
 CellMargins->{{88, 4}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemizedPicture", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedPicture", "Printout"],
 CellMargins->{{77, 2}, {4, -4}},
 Magnification->0.5],

Cell[StyleData["ItemizedPicture", "EnhancedPrintout"],
 CellMargins->{{78, 2}, {12, -6}},
 Magnification->0.5],

Cell[StyleData["ItemizedPicture", "EnhancedPrintoutNonGray"],
 CellMargins->{{75, 2}, {4, -6}},
 Magnification->0.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListGraphic"],
 CellMargins->{{88, 4}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ListGraphic", "Presentation"],
 FontSize->18],

Cell[StyleData["ListGraphic", "Printout"],
 CellMargins->{{77, 2}, {4, -4}},
 Magnification->0.5],

Cell[StyleData["ListGraphic", "EnhancedPrintout"],
 CellMargins->{{78, 2}, {12, -6}},
 Magnification->0.5],

Cell[StyleData["ListGraphic", "EnhancedPrintoutNonGray"],
 CellMargins->{{75, 2}, {4, -6}},
 Magnification->0.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ListNoteBox"],
 CellFrame->0.5,
 CellMargins->{{88, 12}, {8, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ShowSyntaxStyles->False,
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{FrameMargins->{{1, 1}, {1.5, 1.5}}},
 GridBoxOptions->{GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["ListNoteBox", "Presentation"],
 FontSize->18],

Cell[StyleData["ListNoteBox", "Printout"],
 CellMargins->{{77, 4}, {6, 2}},
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["ListNoteBox", "EnhancedPrintout"],
 CellMargins->{{39, 4}, {6, 2}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["ListNoteBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{77, 4}, {6, 2}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureGroup"],
 CellMargins->{{41, 4}, {0, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureGroup", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureGroup", "Printout"],
 CellMargins->{{76, 2}, {0, 0}},
 CellElementSpacings->{"CellMinHeight"->1,
 "ClosedCellHeight"->0},
 CellOpen->False],

Cell[StyleData["PictureGroup", "EnhancedPrintout"],
 CellMargins->{{76, 2}, {0, 0}},
 CellElementSpacings->{"CellMinHeight"->1,
 "ClosedCellHeight"->0},
 CellOpen->False],

Cell[StyleData["PictureGroup", "EnhancedPrintoutNonGray"],
 CellMargins->{{76, 2}, {0, 0}},
 CellElementSpacings->{"CellMinHeight"->1,
 "ClosedCellHeight"->0},
 CellOpen->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Sound"],
 ShowCellBracket->True,
 CellMargins->{{27, Inherited}, {0, 8}},
 StyleMenuListing->None],

Cell[StyleData["Sound", "Presentation"],
 FontSize->18],

Cell[StyleData["Sound", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->10],

Cell[StyleData["Sound", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->10],

Cell[StyleData["Sound", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
 CellMargins->{{27, 4}, {0, 3}},
 PageBreakAbove->False,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["Caption", "Presentation"],
 FontSize->14],

Cell[StyleData["Caption", "Printout"],
 CellMargins->{{2, 4}, {2, 0}},
 FontSize->7],

Cell[StyleData["Caption", "EnhancedPrintout"],
 CellMargins->{{2, 4}, {2, 2}},
 FontFamily->"Frutiger-Roman",
 FontSize->7],

Cell[StyleData["Caption", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {2, -2}},
 FontFamily->"Frutiger-Roman",
 FontSize->7]
}, Closed]],

Cell[StyleData["HeaderCell"],
 ShowCellBracket->False,
 CellMargins->{{0, 0}, {0, 0}},
 Evaluatable->False,
 PageBreakBelow->False,
 ImageSize->{350, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Tables", "Section"],

Cell[CellGroupData[{

Cell[StyleData["2ColumnTable"],
 CellMargins->{{35, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.34], {
      Scaled[0.64]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["2ColumnTable", "Presentation"],
 FontSize->18],

Cell[StyleData["2ColumnTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9],

Cell[StyleData["2ColumnTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9],

Cell[StyleData["2ColumnTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["2ColumnEvenTable"],
 CellMargins->{{35, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.49]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["2ColumnEvenTable", "Presentation"],
 FontSize->18],

Cell[StyleData["2ColumnEvenTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9],

Cell[StyleData["2ColumnEvenTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9],

Cell[StyleData["2ColumnEvenTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnTable"],
 CellMargins->{{35, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.28], 
     Scaled[0.28], {
      Scaled[0.43]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["3ColumnTable", "Presentation"],
 FontSize->18],

Cell[StyleData["3ColumnTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9],

Cell[StyleData["3ColumnTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9],

Cell[StyleData["3ColumnTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
 CellMargins->{{27, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 LanguageCategory->"Formula",
 AutoSpacing->True,
 ScriptLevel->1,
 SingleLetterItalics->True,
 SpanMaxSize->Infinity,
 StyleMenuListing->None],

Cell[StyleData["InlineFormula", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->10],

Cell[StyleData["InlineFormula", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->10],

Cell[StyleData["InlineFormula", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InlineOutput"],
 CellMargins->{{27, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 LanguageCategory->None,
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["InlineOutput", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9.5],

Cell[StyleData["InlineOutput", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9.5],

Cell[StyleData["InlineOutput", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}},
 FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
 CellMargins->{{66, Inherited}, {Inherited, 10}},
 CellHorizontalScrolling->True,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 LanguageCategory->"Formula",
 ScriptLevel->0,
 SingleLetterItalics->True,
 SpanMaxSize->Infinity,
 StyleMenuListing->None,
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["DisplayFormula", "Presentation"],
 FontSize->18],

Cell[StyleData["DisplayFormula", "Printout"]],

Cell[StyleData["DisplayFormula", "EnhancedPrintout"],
 FontFamily->"Palatino"],

Cell[StyleData["DisplayFormula", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayMath"],
 CellMargins->{{66, 10}, {7, 7}},
 Evaluatable->False,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 DefaultFormatType->DefaultInputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FormatType->InputForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 CounterIncrements->"Input"],

Cell[StyleData["DisplayMath", "Presentation"],
 FontSize->18],

Cell[StyleData["DisplayMath", "Printout"],
 CellMargins->{{39, 0}, {6, 6}},
 FontSize->9],

Cell[StyleData["DisplayMath", "EnhancedPrintout"],
 CellMargins->{{39, 0}, {4, 6}},
 FontFamily->"WRICourier",
 FontSize->9],

Cell[StyleData["DisplayMath", "EnhancedPrintoutNonGray"],
 CellMargins->{{39, 0}, {4, 6}},
 FontFamily->"WRICourier",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
 CellMargins->{{66, 27}, {7, 7}},
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(", 
       CounterBox["NumberedEquation"], ")"}]]}, {None, None}},
 DefaultFormatType->DefaultInputFormatType,
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 LanguageCategory->"Formula",
 CounterIncrements->"NumberedEquation",
 FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Presentation"],
 FontSize->18],

Cell[StyleData["NumberedEquation", "Printout"],
 CellMargins->{{39, 55}, {0, 10}},
 FontSize->10],

Cell[StyleData["NumberedEquation", "EnhancedPrintout"],
 CellMargins->{{39, 55}, {0, 10}},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["NumberedEquation", "EnhancedPrintoutNonGray"],
 CellMargins->{{39, 55}, {0, 10}},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["EquationNumber"],
 CellMargins->{{66, Inherited}, {Inherited, Inherited}},
 LineSpacing->{1.83, 0},
 LanguageCategory->"Formula"],

Cell[StyleData["EquationNumber", "Presentation"],
 FontSize->18],

Cell[StyleData["EquationNumber", "Printout"],
 LineSpacing->{1.7, 0}],

Cell[StyleData["EquationNumber", "EnhancedPrintout"],
 LineSpacing->{1.7, 0},
 FontFamily->"Palatino"],

Cell[StyleData["EquationNumber", "EnhancedPrintoutNonGray"],
 LineSpacing->{1.7, 0},
 FontFamily->"Palatino"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
 CellMargins->{{66, Inherited}, {Inherited, 10}},
 CellHorizontalScrolling->True,
 ShowSpecialCharacters->Automatic,
 AutoItalicWords->{},
 LanguageCategory->"Formula",
 FontFamily->"Courier"],

Cell[StyleData["Program", "Presentation"],
 FontSize->18],

Cell[StyleData["Program", "Printout"],
 CellMargins->{{42, 30}, {Inherited, 4}},
 FontSize->9.5],

Cell[StyleData["Program", "EnhancedPrintout"],
 CellMargins->{{42, 30}, {Inherited, 4}},
 FontFamily->"WRICourier",
 FontSize->9.5],

Cell[StyleData["Program", "EnhancedPrintoutNonGray"],
 CellMargins->{{42, 30}, {Inherited, 4}},
 FontFamily->"WRICourier",
 FontSize->9.5]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Help Browser Styles", "Section"],

Cell[CellGroupData[{

Cell["\<\
Standard Styles
\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["InspectorLevel1"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 10}, {2, 7}},
 CellGroupingRules->{"SectionGrouping", 60},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphIndent->-38,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->16,
 FontWeight->"Bold"],

Cell[StyleData["InspectorLevel1", "Presentation"],
 FontSize->24],

Cell[StyleData["InspectorLevel1", "SlideShow"],
 HyphenationOptions->{"HyphenationCharacter"->"-"}],

Cell[StyleData["InspectorLevel1", "Printout"],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InspectorLevel2"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {0, 14}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["InspectorLevel2", "Presentation"],
 FontSize->21],

Cell[StyleData["InspectorLevel2", "SlideShow"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{48, 10}, {2, 12}},
 CellGroupingRules->{"SectionGrouping", 70},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphIndent->-27,
 FontFamily->"Helvetica",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["InspectorLevel2", "Printout"],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ObjectName"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{0, 0}, {0, 0}},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameMargins->{{27, 12}, {3, 15}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->18,
 FontWeight->"Bold",
 Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[StyleData["ObjectName", "Presentation"],
 FontSize->24],

Cell[StyleData["ObjectName", "SlideShow"],
 CellMargins->{{72, 4}, {1, 14}},
 CellGroupingRules->{"SectionGrouping", 90},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["ObjectName", "Printout"],
 CellMargins->{{0, 0}, {0, 10}},
 CellFrameMargins->{{24, 8}, {Inherited, Inherited}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubObjectNameClosed"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {1, 10}},
 PrivateCellOptions->{"DefaultCellGroupOpen"->False},
 CellGroupingRules->{"SectionGrouping", 90},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->14,
 FontWeight->"Bold"],

Cell[StyleData["SubObjectNameClosed", "Presentation"],
 FontSize->21],

Cell[StyleData["SubObjectNameClosed", "SlideShow"],
 CellMargins->{{72, 4}, {1, 14}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["SubObjectNameClosed", "Printout"],
 CellMargins->{{2, 0}, {1, 10}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubObjectName"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {1, 10}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["SubObjectName", "Presentation"],
 FontSize->24],

Cell[StyleData["SubObjectName", "SlideShow"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{90, 4}, {1, 14}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontFamily->"Courier",
 FontSize->12],

Cell[StyleData["SubObjectName", "Printout"],
 CellMargins->{{2, 0}, {1, 10}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontFamily->"Courier",
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GroupObjectName"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {0, 14}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["GroupObjectName", "Presentation"],
 FontSize->24],

Cell[StyleData["GroupObjectName", "SlideShow"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{72, 10}, {2, 12}},
 CellGroupingRules->{"SectionGrouping", 70},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphIndent->-27,
 CounterIncrements->"Outline2",
 FontFamily->"Courier",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["GroupObjectName", "Printout"],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GroupObjectNameClosed"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {0, 14}},
 PrivateCellOptions->{"DefaultCellGroupOpen"->False},
 CellGroupingRules->{"SectionGrouping", 80},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["GroupObjectNameClosed", "Presentation"],
 FontSize->24],

Cell[StyleData["GroupObjectNameClosed", "SlideShow"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{72, 10}, {2, 12}},
 CellGroupingRules->{"SectionGrouping", 70},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphIndent->-27,
 CounterIncrements->"Outline2",
 FontFamily->"Courier",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["GroupObjectNameClosed", "Printout"],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ObjectNameWarningMessages"],
 CellMargins->{{27, 4}, {1, 10}},
 CellGroupingRules->{"SectionGrouping", 65},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->18,
 FontWeight->"Bold"],

Cell[StyleData["ObjectNameWarningMessages", "Presentation"],
 FontSize->24],

Cell[StyleData["ObjectNameWarningMessages", "SlideShow"],
 CellMargins->{{10, 4}, {1, 10}},
 CellGroupingRules->{"SectionGrouping", 65},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontFamily->"Courier",
 FontSize->16,
 FontWeight->"Bold"],

Cell[StyleData["ObjectNameWarningMessages", "Printout"],
 CellMargins->{{2, 0}, {1, 10}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Command"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{0, 0}, {0, 0}},
 CellFrameMargins->{{27, 12}, {3, 15}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 CounterIncrements->"Section",
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->18,
 FontWeight->"Bold",
 Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[StyleData["Command", "Presentation"],
 FontSize->24],

Cell[StyleData["Command", "Printout"],
 CellMargins->{{0, 0}, {0, 14}},
 PageBreakBelow->False,
 CellFrameMargins->{{24, 8}, {Inherited, Inherited}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CharacterName"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{0, 0}, {0, 0}},
 CellFrameMargins->{{27, 27}, {8, 8}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[StyleData["CharacterName", "Presentation"],
 FontSize->18],

Cell[StyleData["CharacterName", "SlideShow"],
 CellMargins->{{72, 4}, {1, 14}},
 CellGroupingRules->{"SectionGrouping", 90},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["CharacterName", "Printout"],
 CellMargins->{{2, 0}, {0, 4}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Usage"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{0, 0}, {0, 0}},
 CellFrameMargins->{{27, 27}, {8, 8}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 Hyphenation->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphSpacing->{0, 6},
 ParagraphIndent->-10,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[StyleData["Usage", "Presentation"],
 FontSize->18],

Cell[StyleData["Usage", "SlideShow"],
 CellFrame->{{0, 0}, {0.5, 0.5}},
 CellMargins->{{72, 4}, {0, 4}},
 CellFrameMargins->5,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphSpacing->{0, 6},
 ParagraphIndent->-10,
 StyleMenuListing->None],

Cell[StyleData["Usage", "Printout"],
 CellMargins->{{0, 0}, {0, 0}},
 CellFrameMargins->{{24, 8}, {Inherited, Inherited}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontSize->10,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ErrorMessage"],
 CellFrame->{{0, 0}, {0.5, 0.5}},
 ShowCellBracket->True,
 CellMargins->{{27, 4}, {0, 4}},
 CellGroupingRules->"OutputGrouping",
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowCellLabel->False,
 CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
 CellFrameMargins->5,
 DefaultFormatType->DefaultOutputFormatType,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FormatType->InputForm,
 StyleMenuListing->None,
 FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["ErrorMessage", "Presentation"],
 FontSize->18],

Cell[StyleData["ErrorMessage", "SlideShow"],
 CellMargins->{{72, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None],

Cell[StyleData["ErrorMessage", "Printout"],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Notes"],
 CellMargins->{{27, 27}, {0, 8}},
 CellHorizontalScrolling->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphSpacing->{0, 6},
 ParagraphIndent->-10,
 StyleMenuListing->None,
 FontFamily->"Times"],

Cell[StyleData["Notes", "Presentation"],
 FontSize->18],

Cell[StyleData["Notes", "SlideShow"],
 CellMargins->{{72, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphSpacing->{0, 6},
 ParagraphIndent->-10,
 StyleMenuListing->None,
 FontFamily->"Times"],

Cell[StyleData["Notes", "Printout"],
 CellMargins->{{24, 0}, {0, 8}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NotesList"],
 CellMargins->{{20, 4}, {2, 8}},
 CellHorizontalScrolling->True,
 ScriptLevel->1,
 SingleLetterItalics->True,
 StyleMenuListing->None,
 FontFamily->"Times"],

Cell[StyleData["NotesList", "Presentation"],
 FontSize->18],

Cell[StyleData["NotesList", "SlideShow"],
 CellMargins->{{82, 4}, {2, 8}},
 CellHorizontalScrolling->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ScriptLevel->1,
 SingleLetterItalics->True,
 StyleMenuListing->None,
 FontFamily->"Times"],

Cell[StyleData["NotesList", "Printout"],
 CellMargins->{{12, 0}, {2, 8}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ReferenceSection"],
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {0, 10}},
 CellGroupingRules->{"SectionGrouping", 30},
 CellFrameMargins->12,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["ReferenceSection", "Presentation"],
 FontSize->20],

Cell[StyleData["ReferenceSection", "Printout"],
 CellMargins->{{3, 0}, {0, 10}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
 CellMargins->{{27, 27}, {0, 8}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 ParagraphSpacing->{0, 8},
 CounterIncrements->"Reference",
 FontSize->12],

Cell[StyleData["Reference", "Presentation"],
 FontSize->18],

Cell[StyleData["Reference", "SlideShow"],
 CellMargins->{{27, 27}, {4, 4}},
 Hyphenation->False,
 FontSize->14],

Cell[StyleData["Reference", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["Reference", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["Reference", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MessagesSection"],
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {0, 10}},
 CellGroupingRules->{"SectionGrouping", 70},
 CellFrameMargins->12,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["MessagesSection", "Presentation"],
 FontSize->20],

Cell[StyleData["MessagesSection", "Printout"],
 CellMargins->{{3, 0}, {0, 10}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TemplateSection"],
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{27, 4}, {0, 10}},
 PrivateCellOptions->{"DefaultCellGroupOpen"->True},
 CellGroupingRules->{"SectionGrouping", 70},
 CellFrameMargins->12,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["TemplateSection", "Presentation"],
 FontSize->20],

Cell[StyleData["TemplateSection", "Printout"],
 CellMargins->{{3, 0}, {0, 10}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["LineHead"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{27, 4}, {8, 18}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["LineHead", "Presentation"],
 FontSize->18],

Cell[StyleData["LineHead", "Printout"],
 CellMargins->{{2, 0}, {8, 18}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FlushInput"],
 CellMargins->{{27, 4}, {1, 4}},
 Evaluatable->True,
 CellGroupingRules->"InputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 CellLabelAutoDelete->False,
 CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultInputFormatType,
 ShowAutoStyles->True,
 ShowSpecialCharacters->Automatic,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FormatType->StandardForm,
 ShowStringCharacters->True,
 NumberMarks->True,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["FlushInput", "Presentation"],
 FontSize->18],

Cell[StyleData["FlushInput", "Printout"],
 CellMargins->{{2, 0}, {1, 4}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FlushOutput"],
 CellMargins->{{27, Inherited}, {Inherited, Inherited}},
 CellEditDuplicate->True,
 CellGroupingRules->"OutputGrouping",
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 GroupPageBreakWithin->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabelAutoDelete->False,
 CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
 DefaultFormatType->DefaultOutputFormatType,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FormatType->StandardForm,
 StyleMenuListing->None],

Cell[StyleData["FlushOutput", "Presentation"],
 FontSize->18],

Cell[StyleData["FlushOutput", "Printout"],
 CellMargins->{{2, Inherited}, {Inherited, Inherited}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DialogItem"],
 CellDingbat->"\[EmptyDiamond]",
 CellMargins->{{27, 4}, {0, 12}},
 CellGroupingRules->{"SectionGrouping", 70},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold"],

Cell[StyleData["DialogItem", "Presentation"],
 FontSize->15],

Cell[StyleData["DialogItem", "Printout"],
 CellMargins->{{12, 0}, {0, 12}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GroupDivider"],
 CellMargins->{{27, Inherited}, {Inherited, Inherited}},
 CellEditDuplicate->True,
 CellGroupingRules->{"TitleGrouping", 0},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None],

Cell[StyleData["GroupDivider", "Presentation"],
 FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Highlight"],
 CellFrame->0.5,
 CellMargins->{{27, 4}, {0, 18}},
 CellFrameColor->GrayLevel[0.800015],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 Background->GrayLevel[0.950011]],

Cell[StyleData["Highlight", "Presentation"],
 FontSize->18],

Cell[StyleData["Highlight", "Printout"],
 CellMargins->{{2, 0}, {0, 18}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 LineSpacing->{1, 3},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["UserNotes"],
 CellFrame->{{3, 0}, {0, 0}},
 CellMargins->{{27, 4}, {0, 8}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ParagraphIndent->-7,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10],

Cell[StyleData["UserNotes", "Presentation"],
 FontSize->15],

Cell[StyleData["UserNotes", "Printout"],
 CellMargins->{{2, 0}, {0, 4}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 LineSpacing->{1, 3},
 FontSize->8],

Cell[StyleData["UserNotes", "EnhancedPrintout"],
 CellMargins->{{0, 0}, {0, 4}},
 Hyphenation->True,
 LineSpacing->{1, 3},
 FontFamily->"Frutiger-Roman",
 FontSize->8],

Cell[StyleData["UserNotes", "EnhancedPrintoutNonGray"],
 CellMargins->{{0, 0}, {0, 4}},
 Hyphenation->True,
 LineSpacing->{1, 3},
 FontFamily->"Frutiger-Roman",
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MoreInfo"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ParagraphIndent->-7,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[StyleData["MoreInfo", "Presentation"],
 FontSize->15],

Cell[StyleData["MoreInfo", "Printout"],
 CellMargins->{{2, 0}, {0, 4}},
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 LineSpacing->{1, 3},
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["UserTips"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {0, 8}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 ParagraphIndent->-7,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[StyleData["UserTips", "Presentation"],
 FontSize->15],

Cell[StyleData["UserTips", "Printout"],
 CellMargins->{{2, 0}, {0, 4}},
 CellFrameColor->GrayLevel[0.800015],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 LineSpacing->{1, 3},
 FontSize->8,
 Background->GrayLevel[0.900008]],

Cell[StyleData["UserTips", "EnhancedPrintout"],
 CellMargins->{{0, 0}, {0, 4}},
 CellFrameColor->GrayLevel[0],
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 LineSpacing->{1, 3},
 FontFamily->"Frutiger-Roman",
 FontSize->8,
 Background->GrayLevel[0.700008]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Theorem"],
 CellFrame->{{4, 0}, {0, 0}},
 CellMargins->{{27, 62}, {0, 14}},
 CellFrameMargins->4,
 CellFrameColor->RGBColor[0, 0, 0.8],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 LineSpacing->{1, 1},
 ParagraphSpacing->{0, 8}],

Cell[StyleData["Theorem", "Presentation"],
 FontSize->18],

Cell[StyleData["Theorem", "Printout"],
 CellMargins->{{2, 0}, {0, 14}},
 CellFrameMargins->3,
 CellFrameColor->GrayLevel[0.8],
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Commentary"],
 CellFrame->{{2, 0}, {0, 0}},
 CellMargins->{{36, 10}, {7, 7}},
 PageBreakBelow->False,
 CellFrameMargins->8,
 CellFrameColor->RGBColor[0, 0.2, 1],
 LineSpacing->{1, 3},
 FontSlant->"Italic"],

Cell[StyleData["Commentary", "Presentation"],
 FontSize->18],

Cell[StyleData["Commentary", "Printout"],
 CellMargins->{{36, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.8],
 FontSize->10],

Cell[StyleData["Commentary", "EnhancedPrintout"],
 CellMargins->{{36, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.8],
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["Commentary", "EnhancedPrintoutNonGray"],
 CellMargins->{{36, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.8],
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Level1Icon"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{48, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphSpacing->{0, 8},
 StyleMenuListing->None],

Cell[StyleData["Level1Icon", "Presentation"],
 FontSize->18],

Cell[StyleData["Level1Icon", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Level2Icon"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{48, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphSpacing->{0, 8},
 StyleMenuListing->None],

Cell[StyleData["Level2Icon", "Presentation"],
 FontSize->18],

Cell[StyleData["Level2Icon", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CopyrightHead"],
 CellMargins->{{27, 4}, {0, 8}},
 PageBreakAbove->False,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["CopyrightHead", "Presentation"],
 FontSize->18],

Cell[StyleData["CopyrightHead", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Copyright"],
 CellMargins->{{27, 4}, {0, 8}},
 PageBreakAbove->False,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10],

Cell[StyleData["Copyright", "Presentation"],
 FontSize->15],

Cell[StyleData["Copyright", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontSize->8],

Cell[StyleData["Copyright", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontFamily->"Frutiger-Roman",
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RegisterSubsection"],
 CellDingbat->None,
 CellMargins->{{27, 27}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 CellGroupingRules->{"SectionGrouping", 45},
 CellFrameLabelMargins->6,
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 FontFamily->"Helvetica",
 FontSize->16],

Cell[StyleData["RegisterSubsection", "Presentation"],
 FontSize->24],

Cell[StyleData["RegisterSubsection", "SlideShow"],
 CellDingbat->None,
 CellMargins->{{70, 0}, {4, 12}},
 FontSize->12],

Cell[StyleData["RegisterSubsection", "Printout"],
 CellMargins->{{9, 0}, {5, 24}},
 FontSize->12],

Cell[StyleData["RegisterSubsection", "EnhancedPrintout"],
 CellMargins->{{9, 0}, {5, 20}},
 FontFamily->"Frutiger-Roman",
 FontSize->12],

Cell[StyleData["RegisterSubsection", "EnhancedPrintoutNonGray"],
 CellMargins->{{9, 0}, {5, 20}},
 FontFamily->"Frutiger-Roman",
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RegisterSubsubsection"],
 CellMargins->{{27, 27}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 CellGroupingRules->{"SectionGrouping", 50},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["RegisterSubsubsection", "Presentation"],
 FontSize->18],

Cell[StyleData["RegisterSubsubsection", "Printout"],
 CellMargins->{{2, 0}, {3, 8}},
 FontSize->10],

Cell[StyleData["RegisterSubsubsection", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {3, 8}},
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["RegisterSubsubsection", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {3, 8}},
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RegisterText"],
 CellMargins->{{27, 4}, {0, 8}},
 PageBreakAbove->False,
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["RegisterText", "Presentation"],
 FontSize->15],

Cell[StyleData["RegisterText", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontSize->8],

Cell[StyleData["RegisterText", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontFamily->"Palatino",
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CaptionHead"],
 CellMargins->{{27, 4}, {0, 8}},
 PageBreakAbove->False,
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["CaptionHead", "Presentation"],
 FontSize->15],

Cell[StyleData["CaptionHead", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontSize->8],

Cell[StyleData["CaptionHead", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontFamily->"Palatino",
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CaptionText"],
 CellMargins->{{66, 4}, {0, 8}},
 PageBreakAbove->False,
 StyleMenuListing->None],

Cell[StyleData["CaptionText", "Presentation"],
 FontSize->15],

Cell[StyleData["CaptionText", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontSize->8],

Cell[StyleData["CaptionText", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontFamily->"Palatino",
 FontSize->7]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BulletText"],
 CellMargins->{{76, 4}, {4, 4}},
 CellFrameLabels->{{
    Cell["\[Bullet]", "BulletText", CellBaseline -> Baseline], Inherited}, {
   Inherited, Inherited}},
 Hyphenation->False,
 LineSpacing->{1, 3},
 CounterIncrements->"BulletText",
 StyleMenuListing->None],

Cell[StyleData["BulletText", "Presentation"],
 FontSize->18],

Cell[StyleData["BulletText", "Printout"],
 FontSize->10],

Cell[StyleData["BulletText", "EnhancedPrintout"],
 CellMargins->{{16, 4}, {2, 4}},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["BulletText", "EnhancedPrintoutNonGray"],
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["HelpLabels"],
 CellMargins->{{88, 4}, {0, 8}},
 StyleMenuListing->None],

Cell[StyleData["HelpLabels", "Presentation"],
 FontSize->15],

Cell[StyleData["HelpLabels", "Printout"],
 CellMargins->{{34, 2}, {6, 6}},
 FontSize->10],

Cell[StyleData["HelpLabels", "EnhancedPrintout"],
 CellMargins->{{34, 2}, {6, 6}},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Manual.nb Merge", "Subsection"],

Cell[CellGroupData[{

Cell["Function List", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["FunctionName"],
 CellDingbat->"\[FilledSquare]",
 CellMargins->{{24, 10}, {10, 12}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->14,
 FontWeight->"Bold",
 CellTags->"FunctionName"],

Cell[StyleData["FunctionName", "Presentation"],
 FontSize->21],

Cell[StyleData["FunctionName", "Printout"],
 CellMargins->{{9, 0}, {10, 10}},
 FontSize->12],

Cell[StyleData["FunctionName", "EnhancedPrintout"],
 CellMargins->{{9, 0}, {10, 10}},
 FontFamily->"Courier",
 FontSize->12],

Cell[StyleData["FunctionName", "EnhancedPrintoutNonGray"],
 CellMargins->{{9, 0}, {10, 10}},
 FontFamily->"Courier",
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionSubsection"],
 CellDingbat->"\[FilledSquare]",
 CellMargins->{{36, 10}, {0, 6}},
 CellGroupingRules->{"SectionGrouping", 60},
 PageBreakBelow->False,
 StyleMenuListing->None,
 FontWeight->"Bold",
 CellTags->"FunctionSubsection"],

Cell[StyleData["FunctionSubsection", "Presentation"],
 FontSize->18],

Cell[StyleData["FunctionSubsection", "Printout"],
 CellMargins->{{30, 0}, {0, 6}}],

Cell[StyleData["FunctionSubsection", "EnhancedPrintout"],
 CellMargins->{{30, 0}, {0, 6}},
 FontFamily->"Palatino",
 FontSize->11],

Cell[StyleData["FunctionSubsection", "EnhancedPrintoutNonGray"],
 CellMargins->{{30, 0}, {0, 6}},
 FontFamily->"Palatino",
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescription"],
 CellMargins->{{36, 10}, {4, 0}},
 LineSpacing->{1, 3},
 ParagraphSpacing->{0.7, 0},
 CounterIncrements->"FunctionDescription",
 StyleMenuListing->None,
 FontWeight->"Plain"],

Cell[StyleData["FunctionDescription", "Presentation"],
 FontSize->18],

Cell[StyleData["FunctionDescription", "Printout"],
 CellMargins->{{30, 0}, {4, 0}},
 FontSize->11],

Cell[StyleData["FunctionDescription", "EnhancedPrintout"],
 CellMargins->{{30, 0}, {4, 0}},
 TextJustification->0,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["FunctionDescription", "EnhancedPrintoutNonGray"],
 CellMargins->{{30, 0}, {4, 0}},
 TextJustification->0,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuled"],
 CellFrame->{{0, 0}, {0.25, 0.25}},
 CellMargins->{{36, 10}, {4, 0}},
 LineSpacing->{1, 3},
 ParagraphSpacing->{0.7, 0},
 CounterIncrements->"FunctionDescriptionRuled",
 StyleMenuListing->None],

Cell[StyleData["FunctionDescriptionRuled", "Presentation"],
 FontSize->18],

Cell[StyleData["FunctionDescriptionRuled", "Printout"],
 CellMargins->{{30, 0}, {4, 0}},
 FontSize->11],

Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintout"],
 CellMargins->{{30, 0}, {4, 0}},
 TextJustification->0,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintoutNonGray"],
 CellMargins->{{30, 0}, {4, 0}},
 TextJustification->0,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuleTop"],
 CellFrame->{{0, 0}, {0, 0.25}},
 CellMargins->{{36, 10}, {4, 0}},
 LineSpacing->{1, 3},
 ParagraphSpacing->{0.7, 0},
 CounterIncrements->"FunctionDescriptionRuleTop",
 StyleMenuListing->None],

Cell[StyleData["FunctionDescriptionRuleTop", "Presentation"],
 FontSize->18],

Cell[StyleData["FunctionDescriptionRuleTop", "Printout"],
 CellMargins->{{30, 0}, {4, 0}},
 FontSize->11],

Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintout"],
 CellMargins->{{30, 0}, {4, 0}},
 TextJustification->0,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"],
 CellMargins->{{30, 0}, {4, 0}},
 TextJustification->0,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionDescriptionRuleBottom"],
 CellFrame->{{0, 0}, {0.25, 0}},
 CellMargins->{{36, 10}, {4, 0}},
 LineSpacing->{1, 3},
 ParagraphSpacing->{0.7, 0},
 CounterIncrements->"FunctionDescriptionRuleBottom",
 StyleMenuListing->None],

Cell[StyleData["FunctionDescriptionRuleBottom", "Presentation"],
 FontSize->18],

Cell[StyleData["FunctionDescriptionRuleBottom", "Printout"],
 CellMargins->{{30, 0}, {4, 0}},
 FontSize->11],

Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintout"],
 CellMargins->{{30, 0}, {4, 0}},
 TextJustification->0,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"],
 CellMargins->{{30, 0}, {4, 0}},
 TextJustification->0,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionExample"],
 CellMargins->{{36, 10}, {4, 0}},
 StyleMenuListing->None,
 FontSize->10],

Cell[StyleData["FunctionExample", "Presentation"],
 FontSize->15],

Cell[StyleData["FunctionExample", "Printout"],
 CellMargins->{{30, 0}, {4, 0}},
 FontSize->9],

Cell[StyleData["FunctionExample", "EnhancedPrintout"],
 CellMargins->{{30, 0}, {4, 0}},
 FontFamily->"Palatino",
 FontSize->9],

Cell[StyleData["FunctionExample", "EnhancedPrintoutNonGray"],
 CellMargins->{{30, 0}, {4, 0}},
 FontFamily->"Palatino",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["FunctionTextNote"],
 CellMargins->{{36, 4}, {0, 4}},
 LineSpacing->{1, 3},
 ParagraphSpacing->{0, 4},
 LineIndent->0,
 StyleMenuListing->None],

Cell[StyleData["FunctionTextNote", "Presentation"],
 FontSize->18],

Cell[StyleData["FunctionTextNote", "Printout"],
 CellMargins->{{36, 4}, {0, 4}},
 FontSize->9],

Cell[StyleData["FunctionTextNote", "EnhancedPrintout"],
 CellMargins->{{36, 4}, {0, 4}},
 FontFamily->"Palatino",
 FontSize->8],

Cell[StyleData["FunctionTextNote", "EnhancedPrintoutNonGray"],
 CellMargins->{{36, 4}, {0, 4}},
 FontFamily->"Palatino",
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["3ColumnFunctionTable"],
 CellMargins->{{36, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 AutoIndent->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.28], 
     Scaled[0.28], {
      Scaled[0.43]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.4]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["3ColumnFunctionTable", "Presentation"],
 FontSize->18],

Cell[StyleData["3ColumnFunctionTable", "Printout"],
 CellMargins->{{30, 0}, {0, 8}},
 FontSize->10],

Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintout"],
 CellMargins->{{30, 0}, {0, 8}},
 FontSize->10],

Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{30, 0}, {0, 8}},
 FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Browser Emulation", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["TextNormal"],
 CellMargins->{{12, 10}, {7, 7}},
 LineSpacing->{1, 3},
 CounterIncrements->"TextNormal",
 StyleMenuListing->None,
 FontFamily->"Times",
 FontSize->12],

Cell[StyleData["TextNormal", "Presentation"],
 FontSize->18],

Cell[StyleData["TextNormal", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["BrowserEmulation"],
 CellMargins->{{12, 1}, {7, 24}},
 CellGroupingRules->{"SectionGrouping", 70},
 LineSpacing->{1, 3},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {{True}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {True, {False}, True}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.25]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.35], {
      Offset[0.56]}, 
     Offset[0.35]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["BrowserEmulation", "Presentation"],
 FontSize->18],

Cell[StyleData["BrowserEmulation", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CategoryDefs"],
 CellMargins->{{300, 10}, {7, 7}},
 LineSpacing->{1, 3},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 Background->RGBColor[1, 0.8, 0.6],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Columns" -> {False, {True}, False}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}}}],

Cell[StyleData["CategoryDefs", "Presentation"],
 FontSize->18],

Cell[StyleData["CategoryDefs", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category1"],
 ShowCellBracket->False,
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{12, 10}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 50},
 StyleMenuListing->None,
 FontSize->16,
 FontWeight->"Bold"],

Cell[StyleData["Category1", "Presentation"],
 FontSize->24],

Cell[StyleData["Category1", "Printout"],
 CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category2"],
 ShowCellBracket->False,
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{85, 10}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 60},
 StyleMenuListing->None,
 FontSize->14,
 FontWeight->"Bold",
 FontColor->RGBColor[0, 0, 0.500008]],

Cell[StyleData["Category2", "Presentation"],
 FontSize->21],

Cell[StyleData["Category2", "Printout"],
 CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category3"],
 ShowCellBracket->False,
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{157, 10}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 70},
 StyleMenuListing->None,
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.2, 0, 0.4]],

Cell[StyleData["Category3", "Presentation"],
 FontSize->18],

Cell[StyleData["Category3", "Printout"],
 CellMargins->{{2, 2}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Category4"],
 ShowCellBracket->False,
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{230, 10}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 80},
 StyleMenuListing->None,
 FontWeight->"Bold",
 FontColor->RGBColor[0, 0.300008, 0.4]],

Cell[StyleData["Category4", "Presentation"],
 FontSize->18],

Cell[StyleData["Category4", "Printout"],
 CellMargins->{{2, 2}, {6, 6}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Misc", "Subsubsection"],

Cell[CellGroupData[{

Cell[StyleData["4ColumnTable"],
 CellMargins->{{10, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 AutoIndent->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.25]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.4]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["4ColumnTable", "Presentation"],
 FontSize->18],

Cell[StyleData["4ColumnTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["4ColumnTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["4ColumnTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["5ColumnTable"],
 CellMargins->{{10, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 AutoIndent->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.2]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.4]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["5ColumnTable", "Presentation"],
 FontSize->18],

Cell[StyleData["5ColumnTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["5ColumnTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["5ColumnTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["6ColumnTable"],
 CellMargins->{{10, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 AutoIndent->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.16]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.4]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["6ColumnTable", "Presentation"],
 FontSize->18],

Cell[StyleData["6ColumnTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["6ColumnTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["6ColumnTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["7ColumnTable"],
 CellMargins->{{10, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 AutoIndent->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.14]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.4]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["7ColumnTable", "Presentation"],
 FontSize->18],

Cell[StyleData["7ColumnTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["7ColumnTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["7ColumnTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["8ColumnTable"],
 CellMargins->{{10, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 AutoIndent->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {Left, {Center}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.12]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.4]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["8ColumnTable", "Presentation"],
 FontSize->18],

Cell[StyleData["8ColumnTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["8ColumnTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["8ColumnTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ABItemizedText"],
 CellMargins->{{20, 4}, {0, 5}},
 LineSpacing->{1, 3},
 ParagraphIndent->-21,
 CounterIncrements->"ItemizedText",
 StyleMenuListing->None],

Cell[StyleData["ABItemizedText", "Presentation"],
 FontSize->18],

Cell[StyleData["ABItemizedText", "Printout"],
 Hyphenation->True,
 ParagraphIndent->-21,
 FontSize->11],

Cell[StyleData["ABItemizedText", "EnhancedPrintout"],
 Hyphenation->True,
 ParagraphIndent->-21,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ABItemizedText", "EnhancedPrintoutNonGray"],
 Hyphenation->True,
 ParagraphIndent->-21,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChapNumber"],
 CellMargins->{{27, Inherited}, {20, 40}},
 CellGroupingRules->{"TitleGrouping", 0},
 PageBreakBelow->False,
 DefaultNewInlineCellStyle->"None",
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 LanguageCategory->"NaturalLanguage",
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subtitle", 0}, {"Subsubtitle", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->42,
 FontWeight->"Plain",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["ChapNumber", "Presentation"],
 FontSize->63],

Cell[StyleData["ChapNumber", "Printout"],
 CellMargins->{{2, 10}, {15, 30}},
 FontSize->36],

Cell[StyleData["ChapNumber", "EnhancedPrintout"],
 CellMargins->{{2, 10}, {15, 30}},
 FontFamily->"Frutiger-Roman",
 FontSize->36,
 FontColor->GrayLevel[0]],

Cell[StyleData["ChapNumber", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 10}, {15, 30}},
 FontFamily->"Frutiger-Roman",
 FontSize->36,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChapTitle"],
 CellMargins->{{27, Inherited}, {80, 10}},
 CellGroupingRules->{"TitleGrouping", 0},
 PageBreakBelow->False,
 DefaultNewInlineCellStyle->"None",
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 LanguageCategory->"NaturalLanguage",
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subtitle", 0}, {"Subsubtitle", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->36,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["ChapTitle", "Presentation"],
 FontSize->54],

Cell[StyleData["ChapTitle", "Printout"],
 CellMargins->{{2, 10}, {80, 6}},
 FontSize->30],

Cell[StyleData["ChapTitle", "EnhancedPrintout"],
 CellMargins->{{2, 10}, {80, 6}},
 FontFamily->"Frutiger-Bold",
 FontSize->30,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["ChapTitle", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 10}, {80, 6}},
 FontFamily->"Frutiger-Bold",
 FontSize->30,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemDingbat"],
 CellSize->{22, 14},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontWeight->"Bold"],

Cell[StyleData["ItemDingbat", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemDingbat", "Printout"],
 CellSize->{22, 13.125}],

Cell[StyleData["ItemDingbat", "EnhancedPrintout"],
 CellSize->{22, 11}],

Cell[StyleData["ItemDingbat", "EnhancedPrintoutNonGray"],
 CellSize->{22, 11}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1"],
 CellMargins->{{19, 4}, {4, 4}},
 ParagraphIndent->-22,
 CounterIncrements->"Item1",
 StyleMenuListing->None],

Cell[StyleData["Item1", "Presentation"],
 FontSize->18],

Cell[StyleData["Item1", "Printout"],
 CellMargins->{{12, 0}, {2, 4}},
 FontSize->10],

Cell[StyleData["Item1", "EnhancedPrintout"],
 CellMargins->{{16, 0}, {2, 4}},
 FontSize->10],

Cell[StyleData["Item1", "EnhancedPrintoutNonGray"],
 CellMargins->{{16, 0}, {2, 4}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item1Continued"],
 CellMargins->{{41, 4}, {4, 1}},
 CounterIncrements->"Item1Continued",
 StyleMenuListing->None],

Cell[StyleData["Item1Continued", "Presentation"],
 FontSize->18],

Cell[StyleData["Item1Continued", "Printout"],
 CellMargins->{{34, 0}, {4, 1}},
 FontSize->10],

Cell[StyleData["Item1Continued", "EnhancedPrintout"],
 CellMargins->{{39, 0}, {4, 1}},
 FontSize->10],

Cell[StyleData["Item1Continued", "EnhancedPrintoutNonGray"],
 CellMargins->{{39, 0}, {4, 1}},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2"],
 CellMargins->{{32, 4}, {4, 4}},
 ParagraphIndent->-22,
 CounterIncrements->"Item2",
 StyleMenuListing->None],

Cell[StyleData["Item2", "Presentation"],
 FontSize->18],

Cell[StyleData["Item2", "Printout"],
 CellMargins->{{26, 0}, {4, 4}},
 ParagraphIndent->-22,
 FontSize->10],

Cell[StyleData["Item2", "EnhancedPrintout"],
 CellMargins->{{29, 0}, {2, 4}},
 ParagraphIndent->-22,
 FontSize->10],

Cell[StyleData["Item2", "EnhancedPrintoutNonGray"],
 CellMargins->{{29, 0}, {2, 4}},
 ParagraphIndent->-22,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item2Continued"],
 CellMargins->{{54, 4}, {4, 1}},
 CounterIncrements->"Item2Continued",
 StyleMenuListing->None],

Cell[StyleData["Item2Continued", "Presentation"],
 FontSize->18],

Cell[StyleData["Item2Continued", "Printout"],
 CellMargins->{{27, 0}, {4, 1}}],

Cell[StyleData["Item2Continued", "EnhancedPrintout"],
 CellMargins->{{52, 0}, {4, 1}},
 FontSize->10],

Cell[StyleData["Item2Continued", "EnhancedPrintoutNonGray"],
 CellMargins->{{52, 0}, {4, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3"],
 CellMargins->{{45, 4}, {4, 4}},
 ParagraphIndent->-23,
 CounterIncrements->"Item3",
 StyleMenuListing->None],

Cell[StyleData["Item3", "Presentation"],
 FontSize->18],

Cell[StyleData["Item3", "Printout"],
 CellMargins->{{27, 0}, {2, 4}}],

Cell[StyleData["Item3", "EnhancedPrintout"],
 CellMargins->{{42, 0}, {2, 4}},
 FontSize->10],

Cell[StyleData["Item3", "EnhancedPrintoutNonGray"],
 CellMargins->{{42, 0}, {2, 4}},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Item3Continued"],
 CellMargins->{{67, 4}, {4, 1}},
 CounterIncrements->"Item3Continued",
 StyleMenuListing->None],

Cell[StyleData["Item3Continued", "Presentation"],
 FontSize->18],

Cell[StyleData["Item3Continued", "Printout"],
 CellMargins->{{27, 0}, {4, 1}}],

Cell[StyleData["Item3Continued", "EnhancedPrintout"],
 CellMargins->{{65, 0}, {4, 1}},
 FontSize->10],

Cell[StyleData["Item3Continued", "EnhancedPrintoutNonGray"],
 CellMargins->{{65, 0}, {4, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedBulletText"],
 CellMargins->{{19, 4}, {0, 5}},
 LineSpacing->{1, 3},
 ParagraphIndent->-22,
 CounterIncrements->"ItemizedBulletText",
 StyleMenuListing->None],

Cell[StyleData["ItemizedBulletText", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedBulletText", "Printout"],
 Hyphenation->True,
 ParagraphIndent->-20,
 FontSize->11],

Cell[StyleData["ItemizedBulletText", "EnhancedPrintout"],
 Hyphenation->True,
 ParagraphIndent->-19,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedBulletText", "EnhancedPrintoutNonGray"],
 Hyphenation->True,
 ParagraphIndent->-19,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NoteBox"],
 CellFrame->0.5,
 CellMargins->{{27, 12}, {8, 8}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{FrameMargins->{{1, 1}, {1.5, 1.5}}},
 GridBoxOptions->{GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["NoteBox", "Presentation"],
 FontSize->18],

Cell[StyleData["NoteBox", "Printout"],
 CellMargins->{{2, 4}, {6, 2}},
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["NoteBox", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 2}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["NoteBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 4}, {6, 2}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedNoteBox"],
 CellFrame->0.5,
 CellMargins->{{41, 4}, {8, 2}},
 CellHorizontalScrolling->True,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 FrameBoxOptions->{FrameMargins->{{1, 1}, {1.5, 1.5}}},
 GridBoxOptions->{GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.4]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["ItemizedNoteBox", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedNoteBox", "Printout"],
 CellMargins->{{39, 4}, {6, 2}},
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedNoteBox", "EnhancedPrintout"],
 CellMargins->{{39, 4}, {6, 2}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedNoteBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{39, 4}, {6, 2}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTopBox"],
 CellFrame->{{0.5, 0.5}, {0, 0.5}},
 CellMargins->{{37, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 CellFrameMargins->{{8, 8}, {0, 8}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.31], {
      Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["ItemizedTopBox", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedTopBox", "Printout"],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedTopBox", "EnhancedPrintout"],
 CellMargins->{{39, 4}, {0, 6}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedTopBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{39, 4}, {0, 6}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedBottomBox"],
 CellFrame->{{0.5, 0.5}, {0.5, 0}},
 CellMargins->{{37, 4}, {4, 0}},
 CellHorizontalScrolling->True,
 CellFrameMargins->{{8, 8}, {8, 0}},
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 LineIndent->0,
 StyleMenuListing->None,
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.31], {
      Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["ItemizedBottomBox", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedBottomBox", "Printout"],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedBottomBox", "EnhancedPrintout"],
 CellMargins->{{39, 4}, {6, 0}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[0.900008]],

Cell[StyleData["ItemizedBottomBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{39, 4}, {6, 0}},
 CellFrameColor->GrayLevel[0],
 FontSize->10,
 Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["MiddleSpacedBox"],
 CellFrame->{{0.5, 0.5}, {0, 0}},
 CellMargins->{{27, 12}, {0, -7}},
 CellHorizontalScrolling->True,
 PageBreakAbove->False,
 PageBreakBelow->False,
 CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
 AutoIndent->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 FontWeight->"Plain",
 Background->RGBColor[0.964706, 0.929412, 0.839216],
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.31], {
      Scaled[0.62]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.7]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["MiddleSpacedBox", "Presentation"],
 FontSize->18],

Cell[StyleData["MiddleSpacedBox", "Printout"],
 CellMargins->{{2, 0}, {0, 0}},
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.8}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["MiddleSpacedBox", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 0}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.8}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["MiddleSpacedBox", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 0}},
 CellFrameColor->GrayLevel[0],
 FontFamily->"Palatino",
 Background->GrayLevel[1],
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{All}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.8}}, 
   "RowsIndexed" -> {}}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedNote"],
 CellMargins->{{41, 4}, {0, 12}},
 LineSpacing->{1, 2},
 CounterIncrements->"ItemizedNote",
 StyleMenuListing->None],

Cell[StyleData["ItemizedNote", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedNote", "Printout"],
 CellMargins->{{38, 4}, {0, 9}},
 Hyphenation->True,
 FontSize->11],

Cell[StyleData["ItemizedNote", "EnhancedPrintout"],
 CellMargins->{{38, 4}, {0, 0}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedNote", "EnhancedPrintoutNonGray"],
 CellMargins->{{38, 4}, {0, 0}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedNoteBelow"],
 CellMargins->{{41, 4}, {0, 8}},
 LineSpacing->{1, 2},
 CounterIncrements->"ItemizedNote",
 StyleMenuListing->None],

Cell[StyleData["ItemizedNoteBelow", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedNoteBelow", "Printout"],
 CellMargins->{{38, 4}, {0, 12}},
 Hyphenation->True,
 FontSize->11],

Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintout"],
 CellMargins->{{38, 4}, {0, 8}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintoutNonGray"],
 CellMargins->{{38, 4}, {0, 8}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextBelowPic"],
 CellMargins->{{19, 4}, {0, 8}},
 LineSpacing->{1, 3},
 ParagraphIndent->-22,
 CounterIncrements->"ItemizedText",
 StyleMenuListing->None],

Cell[StyleData["ItemizedTextBelowPic", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedTextBelowPic", "Printout"],
 CellMargins->{{20, 4}, {2, 12}},
 Hyphenation->True,
 ParagraphIndent->-18,
 FontSize->11],

Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintout"],
 CellMargins->{{20, 4}, {2, 12}},
 Hyphenation->True,
 ParagraphIndent->-17,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintoutNonGray"],
 CellMargins->{{20, 4}, {2, 12}},
 Hyphenation->True,
 ParagraphIndent->-17,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemizedTextNote2"],
 CellMargins->{{41, 4}, {0, 4}},
 LineSpacing->{1, 2},
 CounterIncrements->"ItemizedNote",
 StyleMenuListing->None],

Cell[StyleData["ItemizedTextNote2", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemizedTextNote2", "Printout"],
 CellMargins->{{38, 4}, {0, 2}},
 Hyphenation->True,
 FontSize->11],

Cell[StyleData["ItemizedTextNote2", "EnhancedPrintout"],
 CellMargins->{{38, 4}, {0, 2}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["ItemizedTextNote2", "EnhancedPrintoutNonGray"],
 CellMargins->{{38, 4}, {0, 2}},
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedItem1"],
 CellMargins->{{48, 4}, {4, 4}},
 CellGroupingRules->{"SectionGrouping", 15},
 ParagraphIndent->-23,
 CounterIncrements->"NumberedItem1",
 StyleMenuListing->None],

Cell[StyleData["NumberedItem1", "Presentation"],
 FontSize->18],

Cell[StyleData["NumberedItem1", "Printout"],
 CellMargins->{{12, 0}, {0, 8}}],

Cell[StyleData["NumberedItem1", "EnhancedPrintout"],
 CellMargins->{{12, 0}, {0, 8}}],

Cell[StyleData["NumberedItem1", "EnhancedPrintoutNonGray"],
 CellMargins->{{12, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedItem2"],
 CellMargins->{{71, 4}, {3, 3}},
 CellGroupingRules->{"SectionGrouping", 15},
 ParagraphIndent->-21,
 CounterIncrements->"NumberedItem2",
 StyleMenuListing->None],

Cell[StyleData["NumberedItem2", "Presentation"],
 FontSize->18],

Cell[StyleData["NumberedItem2", "Printout"],
 CellMargins->{{27, 0}, {0, 4}}],

Cell[StyleData["NumberedItem2", "EnhancedPrintout"],
 CellMargins->{{27, 0}, {0, 4}}],

Cell[StyleData["NumberedItem2", "EnhancedPrintoutNonGray"],
 CellMargins->{{27, 0}, {0, 4}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedItem3"],
 CellMargins->{{94, 4}, {2, 2}},
 CellGroupingRules->{"SectionGrouping", 15},
 ParagraphIndent->-23,
 CounterIncrements->"NumberedItem3",
 StyleMenuListing->None],

Cell[StyleData["NumberedItem3", "Presentation"],
 FontSize->18],

Cell[StyleData["NumberedItem3", "Printout"],
 CellMargins->{{27, 0}, {0, 4}}],

Cell[StyleData["NumberedItem3", "EnhancedPrintout"],
 CellMargins->{{27, 0}, {0, 4}}],

Cell[StyleData["NumberedItem3", "EnhancedPrintoutNonGray"],
 CellMargins->{{27, 0}, {0, 4}},
 StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageHeaderBold"],
 CellMargins->{{0, 0}, {2, 0}},
 StyleMenuListing->None,
 FontSize->8,
 FontWeight->"Bold",
 FontSlant->"Italic"],

Cell[StyleData["PageHeaderBold", "Printout"]],

Cell[StyleData["PageHeaderBold", "EnhancedPrintout"],
 FontFamily->"Frutiger-BoldItalic",
 FontWeight->"Plain",
 FontSlant->"Plain"],

Cell[StyleData["PageHeaderBold", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-BoldItalic",
 FontWeight->"Plain",
 FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SingleRowTable"],
 CellMargins->{{10, 4}, {0, 8}},
 CellHorizontalScrolling->True,
 PageBreakWithin->False,
 AutoIndent->False,
 AutoSpacing->False,
 LineIndent->0,
 StyleMenuListing->None,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[1.4]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.6]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["SingleRowTable", "Presentation"],
 FontSize->18],

Cell[StyleData["SingleRowTable", "Printout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["SingleRowTable", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}}],

Cell[StyleData["SingleRowTable", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {0, 8}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsubsection"],
 CellMargins->{{27, 4}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 StyleMenuListing->None,
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["Subsubsubsection", "Presentation"],
 FontSize->18],

Cell[StyleData["Subsubsubsection", "Printout"],
 CellMargins->{{2, 0}, {3, 8}},
 FontSize->10],

Cell[StyleData["Subsubsubsection", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {3, 8}},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["Subsubsubsection", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {3, 8}},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
 CellMargins->{{27, Inherited}, {20, 15}},
 CellGroupingRules->{"TitleGrouping", 20},
 PageBreakBelow->False,
 DefaultNewInlineCellStyle->"None",
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 LanguageCategory->"NaturalLanguage",
 CounterIncrements->"Subsubtitle",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->14,
 FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
 FontSize->21],

Cell[StyleData["Subsubtitle", "Printout"],
 CellMargins->{{2, 10}, {8, 10}},
 FontSize->12],

Cell[StyleData["Subsubtitle", "EnhancedPrintout"],
 CellMargins->{{2, 10}, {8, 10}},
 FontFamily->"Frutiger-Roman",
 FontSize->12],

Cell[StyleData["Subsubtitle", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 10}, {8, 10}},
 FontFamily->"Frutiger-Roman",
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
 CellMargins->{{27, Inherited}, {20, 15}},
 CellGroupingRules->{"TitleGrouping", 10},
 PageBreakBelow->False,
 DefaultNewInlineCellStyle->"None",
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 LanguageCategory->"NaturalLanguage",
 CounterIncrements->"Subtitle",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subsubtitle", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->24],

Cell[StyleData["Subtitle", "Presentation"],
 FontSize->36],

Cell[StyleData["Subtitle", "Printout"],
 CellMargins->{{2, 10}, {10, 15}},
 FontSize->24],

Cell[StyleData["Subtitle", "EnhancedPrintout"],
 CellMargins->{{2, 10}, {10, 15}},
 FontFamily->"Frutiger-Roman",
 FontSize->24],

Cell[StyleData["Subtitle", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 10}, {10, 15}},
 FontFamily->"Frutiger-Roman",
 FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TextBelow"],
 CellMargins->{{27, 4}, {0, 14}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 ParagraphSpacing->{0, 8},
 StyleMenuListing->None,
 FontSize->12],

Cell[StyleData["TextBelow", "Presentation"],
 FontSize->18],

Cell[StyleData["TextBelow", "Printout"],
 CellMargins->{{2, 2}, {6, 12}},
 TextJustification->1,
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["TextBelow", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 12}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["TextBelow", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 2}, {6, 12}},
 TextJustification->1,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Title"],
 CellMargins->{{27, Inherited}, {20, 40}},
 CellGroupingRules->{"TitleGrouping", 0},
 PageBreakBelow->False,
 DefaultNewInlineCellStyle->"None",
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 LanguageCategory->"NaturalLanguage",
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subtitle", 0}, {"Subsubtitle", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->36,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["Title", "Presentation"],
 FontSize->54],

Cell[StyleData["Title", "Printout"],
 CellMargins->{{2, 10}, {15, 30}},
 FontSize->30],

Cell[StyleData["Title", "EnhancedPrintout"],
 CellMargins->{{2, 10}, {15, 30}},
 FontFamily->"Frutiger-Bold",
 FontSize->30.5,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["Title", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 10}, {15, 30}},
 FontFamily->"Frutiger-Bold",
 FontSize->30.5,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Undersubsection"],
 CellMargins->{{10, 4}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm]},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["Undersubsection", "Presentation"],
 FontSize->18],

Cell[StyleData["Undersubsection", "Printout"],
 CellMargins->{{2, 0}, {7, 10}},
 FontSize->10],

Cell[StyleData["Undersubsection", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {7, 8}},
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain"],

Cell[StyleData["Undersubsection", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {7, 8}},
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionFirst"],
 CellMargins->{{27, 27}, {12, 18}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 CounterIncrements->"Section",
 FontFamily->"Helvetica",
 FontSize->20,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SectionFirst", "Presentation"],
 FontSize->30],

Cell[StyleData["SectionFirst", "Printout"],
 CellMargins->{{2, 0}, {0, 6}},
 PageBreakBelow->False,
 FontSize->18],

Cell[StyleData["SectionFirst", "EnhancedPrintout"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{2, Inherited}, {5, 6}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 CellFrameMargins->8,
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Frutiger-Bold",
 FontSize->16,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["SectionFirst", "EnhancedPrintoutNonGray"],
 CellFrame->{{0, 0}, {0.5, 0}},
 CellMargins->{{2, Inherited}, {5, 6}},
 CellGroupingRules->{"SectionGrouping", 30},
 PageBreakBelow->False,
 CellFrameMargins->8,
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 FontFamily->"Frutiger-Bold",
 FontSize->16,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsectionFirst"],
 CellDingbat->None,
 CellMargins->{{27, 27}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 FontFamily->"Helvetica",
 FontSize->16,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SubsectionFirst", "Presentation"],
 FontSize->24],

Cell[StyleData["SubsectionFirst", "SlideShow"],
 CellDingbat->None,
 CellMargins->{{70, 0}, {4, 6}},
 FontSize->12],

Cell[StyleData["SubsectionFirst", "Printout"],
 CellMargins->{{9, 0}, {5, 6}},
 CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
 FontSize->12],

Cell[StyleData["SubsectionFirst", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {5, 6}},
 CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
 FontFamily->"Frutiger-Bold",
 FontSize->12,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["SubsectionFirst", "EnhancedPrintoutNonGray"],
 CellMargins->{{9, 0}, {5, 6}},
 CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
 FontFamily->"Frutiger-Bold",
 FontSize->12,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsectionFirst"],
 CellMargins->{{27, 27}, {0, 18}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 CellGroupingRules->{"SectionGrouping", 50},
 PageBreakBelow->False,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["SubsubsectionFirst", "Presentation"],
 FontSize->18],

Cell[StyleData["SubsubsectionFirst", "Printout"],
 CellMargins->{{2, 0}, {3, 3}},
 CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
 FontSize->10],

Cell[StyleData["SubsubsectionFirst", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {3, 3}},
 CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]],

Cell[StyleData["SubsubsectionFirst", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {3, 3}},
 CellBracketOptions->{"Color"->RGBColor[1, 0, 0]},
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SubsubsubsectionFirst"],
 CellMargins->{{10, 4}, {0, 12}},
 CellElementSpacings->{"ClosedGroupTopMargin"->18},
 StyleMenuListing->None,
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["SubsubsubsectionFirst", "Presentation"],
 FontSize->18],

Cell[StyleData["SubsubsubsectionFirst", "Printout"],
 CellMargins->{{2, 0}, {3, 3}},
 FontSize->10],

Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {3, 3}},
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["SubsubsubsectionFirst", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 0}, {3, 3}},
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell["Spacer Cell", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Spacer"],
 CellMargins->{{10, 10}, {0, 0}},
 CellElementSpacings->{"CellMinHeight"->2,
 "ClosedCellHeight"->1},
 CellOpen->False,
 StyleMenuListing->None],

Cell[StyleData["Spacer", "Printout"],
 CellOpen->True,
 FontSize->3]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DiscretionaryHyphen"],
 StyleMenuListing->None,
 FontSize->0.0625,
 FontColor->GrayLevel[1]],

Cell[StyleData["DiscretionaryHyphen", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintout"],
 FontSize->10,
 FontColor->GrayLevel[0]],

Cell[StyleData["DiscretionaryHyphen", "EnhancedPrintoutNonGray"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller1"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureSmaller1", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureSmaller1", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.63],

Cell[StyleData["PictureSmaller1", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.63],

Cell[StyleData["PictureSmaller1", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.63]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller2"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureSmaller2", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureSmaller2", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.61],

Cell[StyleData["PictureSmaller2", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.61],

Cell[StyleData["PictureSmaller2", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.61]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller3"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureSmaller3", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureSmaller3", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.59],

Cell[StyleData["PictureSmaller3", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.59],

Cell[StyleData["PictureSmaller3", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.59]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller4"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureSmaller4", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureSmaller4", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.57],

Cell[StyleData["PictureSmaller4", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.57],

Cell[StyleData["PictureSmaller4", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.57]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller5"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureSmaller5", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureSmaller5", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.55],

Cell[StyleData["PictureSmaller5", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.55],

Cell[StyleData["PictureSmaller5", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.55]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureSmaller6"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureSmaller6", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureSmaller6", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.53],

Cell[StyleData["PictureSmaller6", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.53],

Cell[StyleData["PictureSmaller6", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.53]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPicture"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPicture", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPicture", "Printout"],
 CellMargins->{{55, Inherited}, {8, -4}},
 Magnification->0.65],

Cell[StyleData["ItemPicture", "EnhancedPrintout"],
 CellMargins->{{60, Inherited}, {10, -3}},
 Magnification->0.65],

Cell[StyleData["ItemPicture", "EnhancedPrintoutNonGray"],
 CellMargins->{{60, Inherited}, {10, -3}},
 Magnification->0.65]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller1"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller1", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureSmaller1", "Printout"],
 CellMargins->{{56, Inherited}, {9, -3}},
 Magnification->0.63],

Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintout"],
 CellMargins->{{63, Inherited}, {10, -3}},
 Magnification->0.63],

Cell[StyleData["ItemPictureSmaller1", "EnhancedPrintoutNonGray"],
 CellMargins->{{63, Inherited}, {10, -3}},
 Magnification->0.63]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller2"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller2", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureSmaller2", "Printout"],
 CellMargins->{{58, Inherited}, {8, -4}},
 Magnification->0.61],

Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintout"],
 CellMargins->{{65, Inherited}, {11, -3}},
 Magnification->0.61],

Cell[StyleData["ItemPictureSmaller2", "EnhancedPrintoutNonGray"],
 CellMargins->{{65, Inherited}, {11, -3}},
 Magnification->0.61]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller3"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller3", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureSmaller3", "Printout"],
 CellMargins->{{61, Inherited}, {10, -2}},
 Magnification->0.59],

Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintout"],
 CellMargins->{{67, Inherited}, {11, -3}},
 Magnification->0.59],

Cell[StyleData["ItemPictureSmaller3", "EnhancedPrintoutNonGray"],
 CellMargins->{{67, Inherited}, {11, -3}},
 Magnification->0.59]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller4"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller4", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureSmaller4", "Printout"],
 CellMargins->{{63, Inherited}, {10, -2}},
 Magnification->0.57],

Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintout"],
 CellMargins->{{69, Inherited}, {12, -4}},
 Magnification->0.57],

Cell[StyleData["ItemPictureSmaller4", "EnhancedPrintoutNonGray"],
 CellMargins->{{69, Inherited}, {12, -4}},
 Magnification->0.57]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller5"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller5", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureSmaller5", "Printout"],
 CellMargins->{{65, Inherited}, {11, -2}},
 Magnification->0.55],

Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintout"],
 CellMargins->{{71, Inherited}, {13, -2}},
 Magnification->0.55],

Cell[StyleData["ItemPictureSmaller5", "EnhancedPrintoutNonGray"],
 CellMargins->{{71, Inherited}, {13, -2}},
 Magnification->0.55]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureSmaller6"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureSmaller6", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureSmaller6", "Printout"],
 CellMargins->{{67, Inherited}, {12, -2}},
 Magnification->0.53],

Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintout"],
 CellMargins->{{74, Inherited}, {13, -3}},
 Magnification->0.53],

Cell[StyleData["ItemPictureSmaller6", "EnhancedPrintoutNonGray"],
 CellMargins->{{74, Inherited}, {13, -3}},
 Magnification->0.53]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger1"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureBigger1", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureBigger1", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.68],

Cell[StyleData["PictureBigger1", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.68],

Cell[StyleData["PictureBigger1", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.68]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger2"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureBigger2", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureBigger2", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.71],

Cell[StyleData["PictureBigger2", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.71],

Cell[StyleData["PictureBigger2", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.71]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger3"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureBigger3", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureBigger3", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.74],

Cell[StyleData["PictureBigger3", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.74],

Cell[StyleData["PictureBigger3", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.74]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger4"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureBigger4", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureBigger4", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.77],

Cell[StyleData["PictureBigger4", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.77],

Cell[StyleData["PictureBigger4", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.77]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger5"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureBigger5", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureBigger5", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.8],

Cell[StyleData["PictureBigger5", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.8],

Cell[StyleData["PictureBigger5", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PictureBigger6"],
 CellMargins->{{10, Inherited}, {4, 4}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PictureBigger6", "Presentation"],
 FontSize->18],

Cell[StyleData["PictureBigger6", "Printout"],
 CellMargins->{{2, Inherited}, {4, 4}},
 Magnification->0.83],

Cell[StyleData["PictureBigger6", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.83],

Cell[StyleData["PictureBigger6", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {4, 2}},
 Magnification->0.83]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger1"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger1", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureBigger1", "Printout"],
 CellMargins->{{50, Inherited}, {9, -3}},
 Magnification->0.68],

Cell[StyleData["ItemPictureBigger1", "EnhancedPrintout"],
 CellMargins->{{57, Inherited}, {10, -3}},
 Magnification->0.68],

Cell[StyleData["ItemPictureBigger1", "EnhancedPrintoutNonGray"],
 CellMargins->{{57, Inherited}, {10, -3}},
 Magnification->0.68]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger2"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger2", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureBigger2", "Printout"],
 CellMargins->{{48, Inherited}, {8, -4}},
 Magnification->0.71],

Cell[StyleData["ItemPictureBigger2", "EnhancedPrintout"],
 CellMargins->{{54, Inherited}, {10, -3}},
 Magnification->0.71],

Cell[StyleData["ItemPictureBigger2", "EnhancedPrintoutNonGray"],
 CellMargins->{{54, Inherited}, {10, -3}},
 Magnification->0.71]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger3"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger3", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureBigger3", "Printout"],
 CellMargins->{{46, Inherited}, {10, -2}},
 Magnification->0.74],

Cell[StyleData["ItemPictureBigger3", "EnhancedPrintout"],
 CellMargins->{{52, Inherited}, {10, -3}},
 Magnification->0.74],

Cell[StyleData["ItemPictureBigger3", "EnhancedPrintoutNonGray"],
 CellMargins->{{52, Inherited}, {10, -3}},
 Magnification->0.74]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger4"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger4", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureBigger4", "Printout"],
 CellMargins->{{45, Inherited}, {10, -2}},
 Magnification->0.77],

Cell[StyleData["ItemPictureBigger4", "EnhancedPrintout"],
 CellMargins->{{50, Inherited}, {10, -3}},
 Magnification->0.77],

Cell[StyleData["ItemPictureBigger4", "EnhancedPrintoutNonGray"],
 CellMargins->{{50, Inherited}, {10, -3}},
 Magnification->0.77]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger5"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger5", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureBigger5", "Printout"],
 CellMargins->{{43, Inherited}, {11, -2}},
 Magnification->0.8],

Cell[StyleData["ItemPictureBigger5", "EnhancedPrintout"],
 CellMargins->{{49, Inherited}, {10, -3}},
 Magnification->0.8],

Cell[StyleData["ItemPictureBigger5", "EnhancedPrintoutNonGray"],
 CellMargins->{{49, Inherited}, {10, -3}},
 Magnification->0.8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ItemPictureBigger6"],
 CellMargins->{{41, Inherited}, {4, 2}},
 CellGroupingRules->"GraphicsGrouping",
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ItemPictureBigger6", "Presentation"],
 FontSize->18],

Cell[StyleData["ItemPictureBigger6", "Printout"],
 CellMargins->{{43, Inherited}, {12, -2}},
 Magnification->0.83],

Cell[StyleData["ItemPictureBigger6", "EnhancedPrintout"],
 CellMargins->{{46, Inherited}, {8, -2}},
 Magnification->0.83],

Cell[StyleData["ItemPictureBigger6", "EnhancedPrintoutNonGray"],
 CellMargins->{{46, Inherited}, {8, -2}},
 Magnification->0.83]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ScreenGraphic"],
 CellMargins->{{12, Inherited}, {0, 8}},
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["ScreenGraphic", "Presentation"],
 FontSize->18],

Cell[StyleData["ScreenGraphic", "Printout"],
 CellMargins->{{2, Inherited}, {0, 8}}],

Cell[StyleData["ScreenGraphic", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {0, 8}},
 CellElementSpacings->{"CellMinHeight"->2,
 "ClosedCellHeight"->2},
 CellOpen->False],

Cell[StyleData["ScreenGraphic", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {0, 8}},
 CellElementSpacings->{"CellMinHeight"->2,
 "ClosedCellHeight"->2},
 CellOpen->False]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PrintGraphic"],
 CellMargins->{{12, Inherited}, {0, 8}},
 CellElementSpacings->{"CellMinHeight"->2,
 "ClosedCellHeight"->2},
 CellOpen->False,
 CellHorizontalScrolling->True,
 StyleMenuListing->None],

Cell[StyleData["PrintGraphic", "Presentation"],
 FontSize->18],

Cell[StyleData["PrintGraphic", "Printout"],
 CellMargins->{{2, Inherited}, {0, 8}},
 CellElementSpacings->{"CellMinHeight"->2,
 "ClosedCellHeight"->2},
 CellOpen->False],

Cell[StyleData["PrintGraphic", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {0, 8}},
 CellElementSpacings->{"CellMinHeight"->12},
 CellOpen->True],

Cell[StyleData["PrintGraphic", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, Inherited}, {0, 8}},
 CellElementSpacings->{"CellMinHeight"->12},
 CellOpen->True]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SmallTextSans"],
 CellMargins->{{10, 4}, {8, 8}},
 TextJustification->1,
 LineSpacing->{1, 2},
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["SmallTextSans", "Presentation"],
 FontSize->14],

Cell[StyleData["SmallTextSans", "Printout"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 FontSize->7],

Cell[StyleData["SmallTextSans", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {0, 8}},
 Hyphenation->True,
 LineSpacing->{1, 1},
 ParagraphSpacing->{0, -2},
 FontFamily->"Frutiger-Roman",
 FontSize->7]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["AuthorTools", "Section"],

Cell[CellGroupData[{

Cell[StyleData["BilateralCell"],
 CellMargins->{{27, 4}, {0, 8}},
 StyleMenuListing->None,
 FontSize->12,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.33], {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["BilateralCell", "Presentation"],
 FontSize->18],

Cell[StyleData["BilateralCell", "SlideShow"],
 CellMargins->{{36, 24}, {4, 4}},
 Background->GrayLevel[0.900008]],

Cell[StyleData["BilateralCell", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontSize->10],

Cell[StyleData["BilateralCell", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontFamily->"Palatino",
 FontSize->10],

Cell[StyleData["BilateralCell", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->1,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RuledPageBreak"],
 CellFrame->{{0, 0}, {0.25, 0}},
 CellMargins->{{27, 4}, {12, 0}},
 CellFrameMargins->{{0, 0}, {1, 0}},
 FontSize->8],

Cell[StyleData["RuledPageBreak", "Presentation"],
 FontSize->12],

Cell[StyleData["RuledPageBreak", "SlideShow"],
 CellMargins->{{36, 24}, {4, 4}}],

Cell[StyleData["RuledPageBreak", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 PageBreakBelow->True,
 FontSize->1],

Cell[StyleData["RuledPageBreak", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {6, 6}},
 PageBreakBelow->True],

Cell[StyleData["RuledPageBreak", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 2}, {6, 6}},
 PageBreakBelow->True]
}, Closed]],

Cell[StyleData["PaletteTitle"],
 CellFrame->{{0, 0}, {1, 0}},
 CellMargins->{{4, 0}, {Inherited, 0}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->14,
 FontWeight->"Bold",
 FontColor->GrayLevel[1],
 Background->RGBColor[0, 0.32549, 0.537255],
 ButtonBoxOptions->{BaseStyle->"PaletteButton",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`HelpBrowserLookup[
     FrontEnd`ButtonNotebook[], "AddOns", #2]}]& ),
 ButtonMargins->3,
 Evaluator->None}],

Cell[StyleData["PaletteButton"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->GrayLevel[1],
 ButtonBoxOptions->{Active->True,
 Background->RGBColor[0.329412, 0.584314, 0.694118],
 ButtonMargins->6,
 Evaluator->"Local"}],

Cell[StyleData["PaletteButton2"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->GrayLevel[1],
 ButtonBoxOptions->{Active->True,
 Background->RGBColor[0.537255, 0.72549, 0.843137],
 ButtonMargins->4,
 Evaluator->"Local"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Outline Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Outline1"],
 CellMargins->{{27, 10}, {7, 7}},
 CellGroupingRules->{"SectionGrouping", 50},
 ParagraphIndent->-38,
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}, {"Outline3", 0}, {"Outline4", 0}},
 FontSize->18,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],

Cell[StyleData["Outline1", "Presentation"],
 FontSize->27],

Cell[StyleData["Outline1", "Printout"],
 CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline2"],
 CellMargins->{{57, 10}, {6, 6}},
 CellGroupingRules->{"SectionGrouping", 60},
 ParagraphIndent->-27,
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}, {"Outline4", 0}},
 FontSize->15,
 FontWeight->"Bold",
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}],

Cell[StyleData["Outline2", "Presentation"],
 FontSize->23],

Cell[StyleData["Outline2", "Printout"],
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["A", "Z"], #]& )}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline3"],
 CellMargins->{{87, 10}, {5, 5}},
 CellGroupingRules->{"SectionGrouping", 70},
 ParagraphIndent->-21,
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}},
 FontSize->12,
 CounterBoxOptions->{CounterFunction:>Identity}],

Cell[StyleData["Outline3", "Presentation"],
 FontSize->18],

Cell[StyleData["Outline3", "Printout"],
 CounterBoxOptions->{CounterFunction:>Identity}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Outline4"],
 CellMargins->{{117, 10}, {4, 4}},
 CellGroupingRules->{"SectionGrouping", 80},
 ParagraphIndent->-18,
 CounterIncrements->"Outline4",
 FontSize->10,
 CounterBoxOptions->{CounterFunction:>(Part[
   CharacterRange["a", "z"], #]& )}],

Cell[StyleData["Outline4", "Presentation"],
 FontSize->15],

Cell[StyleData["Outline4", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Slide Show Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["SlideShowNavigationBar"],
 Editable->False,
 CellFrame->True,
 CellMargins->{{0, 0}, {3, 3}},
 CellElementSpacings->{"CellMinHeight"->0.8125},
 CellGroupingRules->{"SectionGrouping", -5},
 CellFrameMargins->False,
 CellFrameColor->GrayLevel[1],
 CellFrameLabelMargins->False,
 TextAlignment->Center,
 CounterIncrements->"SlideShowNavigationBar",
 StyleMenuListing->None,
 FontSize->10,
 Magnification->1,
 Background->GrayLevel[0.8],
 GridBoxOptions->{BaselinePosition->Center,
 GridBoxAlignment->{
  "Columns" -> {
    Center, Center, Center, Center, Center, Center, Right, {Center}}, 
   "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{
  "Columns" -> {3.5, 3.5, 3.5, 3.5, 13, 5, {4}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {{1.}}, "RowsIndexed" -> {}},
 GridBoxSpacings->{"Columns" -> {
     Offset[0.28], {
      Offset[0.]}, 
     Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
     Offset[0.2], {
      Offset[0.]}, 
     Offset[0.2]}, "RowsIndexed" -> {}}}],

Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{-1, -1}, {-1, -1}},
 PageBreakAbove->True,
 CellFrameMargins->{{1, 1}, {0, 0}}],

Cell[StyleData["SlideShowNavigationBar", "Printout"],
 CellMargins->{{18, 4}, {4, 4}},
 LineSpacing->{1, 3},
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideShowSection"],
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{0, 0}, {10, 0}},
 CellGroupingRules->{"SectionGrouping", 40},
 PageBreakBelow->False,
 CellFrameMargins->{{12, 4}, {6, 12}},
 InputAutoReplacements->{"TeX" -> StyleBox[
     RowBox[{"T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "LaTeX" -> StyleBox[
     RowBox[{"L", 
       StyleBox[
        AdjustmentBox[
        "A", BoxMargins -> {{-0.36, -0.1}, {0, 0}}, BoxBaselineShift -> -0.2],
         FontSize -> Smaller], "T", 
       AdjustmentBox[
       "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
        0.5], "X"}]], "mma" -> "Mathematica", "Mma" -> "Mathematica", "MMA" -> 
   "Mathematica", "gridMathematica" -> FormBox[
     RowBox[{"grid", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], "webMathematica" -> 
   FormBox[
     RowBox[{"web", 
       AdjustmentBox[
        StyleBox["Mathematica", FontSlant -> "Italic"], 
        BoxMargins -> {{-0.175, 0}, {0, 0}}]}], TextForm], Inherited},
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->18,
 FontWeight->"Plain",
 FontColor->GrayLevel[1],
 Background->RGBColor[0.408011, 0.440726, 0.8]],

Cell[StyleData["SlideShowSection", "Presentation"],
 FontSize->27],

Cell[StyleData["SlideShowSection", "SlideShow"],
 ShowCellBracket->False,
 PageBreakAbove->True],

Cell[StyleData["SlideShowSection", "Printout"],
 CellMargins->{{18, 30}, {0, 30}},
 CellFrameMargins->5,
 FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideHyperlink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontSize->26,
 FontColor->GrayLevel[0.400015],
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlideHyperlink", "SlideShow"]],

Cell[StyleData["SlideHyperlink", "Printout"],
 FontSize->10,
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PreviousNext"],
 CellMargins->{{60, 10}, {7, 7}},
 TextAlignment->0.75,
 LineSpacing->{1, 3},
 CounterIncrements->"PreviousNext",
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontColor->GrayLevel[0.500008]],

Cell[StyleData["PreviousNext", "Presentation"],
 CellMargins->{{24, 50}, {10, 10}},
 LineSpacing->{1, 5},
 FontSize->12],

Cell[StyleData["PreviousNext", "SlideShow"],
 CellMargins->{{50, 50}, {50, 15}},
 FontSize->12],

Cell[StyleData["PreviousNext", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 TextJustification->0.5,
 Hyphenation->True,
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlidePreviousNextLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontVariations->{"Underline"->False},
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->0.5,
 ButtonMinHeight->0.85,
 ButtonNote->None}],

Cell[StyleData["SlidePreviousNextLink", "Presentation"]],

Cell[StyleData["SlidePreviousNextLink", "SlideShow"]],

Cell[StyleData["SlidePreviousNextLink", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOCLink"],
 CellMargins->{{24, Inherited}, {Inherited, Inherited}},
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontFamily->"Helvetica",
 ButtonBoxOptions->{Active->True,
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& ),
 ButtonMargins->1.5,
 ButtonNote->ButtonData}],

Cell[StyleData["SlideTOCLink", "SlideShow"]],

Cell[StyleData["SlideTOCLink", "Printout"],
 FontVariations->{"Underline"->False},
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SlideTOC"],
 CellDingbat->"\[Bullet]",
 CellMargins->{{18, Inherited}, {Inherited, Inherited}},
 StyleMenuListing->None,
 FontFamily->"Helvetica"],

Cell[StyleData["SlideTOC", "SlideShow"],
 FontSize->14],

Cell[StyleData["SlideTOC", "Printout"],
 FontSize->10,
 FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Title Page, Contents, and Index", "Section"],

Cell[CellGroupData[{

Cell[StyleData["ContentsTitle"],
 CellMargins->{{21, 4}, {12, 24}},
 FontFamily->"Helvetica",
 FontSize->24,
 FontWeight->"Bold",
 FontColor->RGBColor[0.592157, 0.313726, 0.313726]],

Cell[StyleData["ContentsTitle", "Presentation"],
 FontSize->36],

Cell[StyleData["ContentsTitle", "Printout"],
 CellMargins->{{12, 0}, {102, 89}},
 PageBreakBelow->False,
 FontSize->30.5,
 FontColor->GrayLevel[0]],

Cell[StyleData["ContentsTitle", "EnhancedPrintout"],
 CellMargins->{{2, Inherited}, {15, 30}},
 PageBreakBelow->False,
 FontFamily->"Frutiger-Bold",
 FontSize->30.5,
 FontWeight->"Plain",
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ContentsSection"],
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{35, 4}, {3, 18}},
 CellGroupingRules->{"SectionGrouping", 70},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["ContentsSection", "Presentation"],
 FontSize->18],

Cell[StyleData["ContentsSection", "Printout"],
 CellMargins->{{20, 0}, {3, 18}},
 PageBreakBelow->False,
 FontSize->11],

Cell[StyleData["ContentsSection", "EnhancedPrintout"],
 CellMargins->{{20, 0}, {3, 18}},
 PageBreakBelow->False,
 FontFamily->"Frutiger-Bold",
 FontSize->11,
 FontWeight->"Plain"],

Cell[StyleData["ContentsSection", "EnhancedPrintoutNonGray"],
 CellMargins->{{20, 0}, {3, 18}},
 PageBreakBelow->False,
 FontFamily->"Frutiger-Bold",
 FontSize->11,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndexSection"],
 CellDingbat->"\[FilledSquare]",
 CellMargins->{{20, 4}, {5, 20}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["IndexSection", "Presentation"],
 FontSize->18],

Cell[StyleData["IndexSection", "Printout"],
 CellMargins->{{12, 0}, {5, 20}},
 PageBreakBelow->False,
 FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Contents"],
 ShowGroupOpenCloseIcon->False,
 CellMargins->{{50, 4}, {0, 5}},
 CellGroupingRules->{"SectionGrouping", 90},
 StyleMenuListing->None],

Cell[StyleData["Contents", "Presentation"],
 FontSize->18],

Cell[StyleData["Contents", "Printout"],
 CellMargins->{{40, 4}, {0, 5}},
 FontSize->11],

Cell[StyleData["Contents", "EnhancedPrintout"],
 CellMargins->{{40, 5}, {0, 5}},
 FontFamily->"Palatino",
 FontSize->11],

Cell[StyleData["Contents", "EnhancedPrintoutNonGray"],
 CellMargins->{{40, 5}, {0, 5}},
 FontFamily->"Palatino",
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Index"],
 CellMargins->{{21, 4}, {0, 0}},
 ParagraphIndent->-48,
 StyleMenuListing->None],

Cell[StyleData["Index", "Presentation"],
 FontSize->18],

Cell[StyleData["Index", "Printout"],
 CellMargins->{{13, 0}, {0, 0}},
 FontSize->9],

Cell[StyleData["Index", "EnhancedPrintout"],
 CellMargins->{{13, 0}, {0, 0}},
 FontFamily->"Palatino",
 FontSize->9],

Cell[StyleData["Index", "EnhancedPrintoutNonGray"],
 CellMargins->{{13, 0}, {0, 0}},
 FontFamily->"Palatino",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["IndexSubentry"],
 CellMargins->{{36, 4}, {0, 0}},
 ParagraphIndent->-48],

Cell[StyleData["IndexSubentry", "Presentation"],
 FontSize->18],

Cell[StyleData["IndexSubentry", "Printout"],
 CellMargins->{{24, 0}, {0, 0}},
 FontSize->9],

Cell[StyleData["IndexSubentry", "EnhancedPrintout"],
 CellMargins->{{24, 0}, {0, 0}},
 FontFamily->"Palatino",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Index2Column"],
 CellMargins->{{21, 4}, {0, 8}},
 ParagraphIndent->-20,
 TabSpacings->1,
 StyleMenuListing->None,
 FontSize->10,
 GridBoxOptions->{
 GridBoxAlignment->{
  "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {{
      Scaled[0.5]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}}],

Cell[StyleData["Index2Column", "Presentation"],
 FontSize->15],

Cell[StyleData["Index2Column", "Printout"],
 CellMargins->{{2, 2}, {6, 6}},
 FontSize->8],

Cell[StyleData["Index2Column", "EnhancedPrintout"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{1, 0.2},
 FontFamily->"Palatino",
 FontSize->8],

Cell[StyleData["Index2Column", "EnhancedPrintoutNonGray"],
 CellMargins->{{2, 2}, {1, 1}},
 LineSpacing->{1, 0.2},
 FontFamily->"Palatino",
 FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Leader"],
 TabFilling->".",
 StyleMenuListing->None,
 FontFamily->"Times",
 FontSize->12,
 FontWeight->"Plain"],

Cell[StyleData["Leader", "Printout"],
 FontSize->10],

Cell[StyleData["Leader", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["LeaderNoDots"],
 TabFilling->" ",
 StyleMenuListing->None,
 FontFamily->"Times",
 FontSize->12,
 FontWeight->"Plain"],

Cell[StyleData["LeaderNoDots", "Printout"],
 FontSize->10],

Cell[StyleData["LeaderNoDots", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageLink"],
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic,
 FontColor->RGBColor[0.269993, 0.308507, 0.6],
 ButtonBoxOptions->{Active->True,
 ButtonFrame->"None",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`NotebookLocate[#2]}]& )}],

Cell[StyleData["PageLink", "Printout"],
 FontColor->GrayLevel[0]],

Cell[StyleData["PageLink", "EnhancedPrintout"],
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCPage"],
 CellSize->{22, Inherited},
 TextAlignment->Right,
 StyleMenuListing->None,
 FontSize->12,
 FontWeight->"Plain"],

Cell[StyleData["TOCPage", "Presentation"],
 FontSize->18],

Cell[StyleData["TOCPage", "Printout"],
 FontSize->10],

Cell[StyleData["TOCPage", "EnhancedPrintout"],
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTitle"],
 CellMargins->{{20, 0}, {1, 8}},
 CellGroupingRules->{"SectionGrouping", 70},
 TabSpacings->46,
 CounterIncrements->"TOCTitle",
 CounterAssignments->{{"TOCSection", 0}},
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["TOCTitle", "Presentation"],
 FontSize->18],

Cell[StyleData["TOCTitle", "Printout"],
 CellMargins->{{12, 0}, {1, 8}},
 PageBreakBelow->False,
 TabSpacings->47.4,
 FontSize->11],

Cell[StyleData["TOCTitle", "EnhancedPrintout"],
 CellMargins->{{2, 0}, {2, 10}},
 PageBreakBelow->False,
 TabSpacings->49.3,
 FontFamily->"Frutiger-Bold",
 FontSize->10,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSection"],
 CellMargins->{{48, 0}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 75},
 TabSpacings->42.9,
 CounterIncrements->"TOCSection",
 CounterAssignments->{{"TOCSubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->12],

Cell[StyleData["TOCSection", "Presentation"],
 FontSize->18],

Cell[StyleData["TOCSection", "Printout"],
 CellMargins->{{30, 0}, {1, 1}},
 PageBreakBelow->False,
 FontSize->12],

Cell[StyleData["TOCSection", "EnhancedPrintout"],
 CellMargins->{{26, 0}, {1, 3}},
 PageBreakBelow->False,
 TabSpacings->46.45,
 FontFamily->"Frutiger-Roman",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsection"],
 CellMargins->{{76, 0}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 80},
 TabSpacings->39.8,
 CounterIncrements->"TOCSubsection",
 CounterAssignments->{{"TOCSubsubsection", 0}},
 FontSize->12],

Cell[StyleData["TOCSubsection", "Presentation"],
 FontSize->18],

Cell[StyleData["TOCSubsection", "Printout"],
 CellMargins->{{70, 0}, {1, 1}},
 PageBreakBelow->False,
 FontSize->10],

Cell[StyleData["TOCSubsection", "EnhancedPrintout"],
 CellMargins->{{38, 0}, {1, 1}},
 PageBreakBelow->False,
 TabSpacings->45.15,
 FontFamily->"Palatino",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsubsection"],
 CellMargins->{{104, 0}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 85},
 TabSpacings->36.7,
 CounterIncrements->"TOCSubsubsection",
 FontSize->12],

Cell[StyleData["TOCSubsubsection", "Presentation"],
 FontSize->18],

Cell[StyleData["TOCSubsubsection", "Printout"],
 CellMargins->{{96, 0}, {1, 1}},
 PageBreakBelow->False,
 FontSize->9],

Cell[StyleData["TOCSubsubsection", "EnhancedPrintout"],
 CellMargins->{{96, 0}, {1, 1}},
 PageBreakBelow->False,
 FontFamily->"Palatino",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTitleDingbat"],
 CellSize->{34, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCTitleDingbat", "EnhancedPrintout"],
 FontFamily->"Frutiger-Roman",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSectionDingbat"],
 CellSize->{38, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCSectionDingbat", "EnhancedPrintout"],
 FontFamily->"Frutiger-Roman",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsectionDingbat"],
 CellSize->{54, Inherited},
 TextAlignment->Right],

Cell[StyleData["TOCSubsectionDingbat", "EnhancedPrintout"],
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCTitleCondensed"],
 CellMargins->{{20, 0}, {1, 8}},
 CellGroupingRules->{"SectionGrouping", 70},
 TabSpacings->50.4,
 CounterIncrements->"TOCTitleCondensed",
 CounterAssignments->{{"TOCSectionCondensed", 0}, {
   "TOCSubsectionCondensed", 0}},
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold"],

Cell[StyleData["TOCTitleCondensed", "Presentation"],
 FontSize->18],

Cell[StyleData["TOCTitleCondensed", "Printout"],
 CellMargins->{{12, 0}, {1, 8}},
 PageBreakBelow->False,
 FontSize->11],

Cell[StyleData["TOCTitleCondensed", "EnhancedPrintout"],
 CellMargins->{{12, 0}, {1, 8}},
 PageBreakBelow->False,
 FontFamily->"Frutiger-Bold",
 FontSize->11,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSectionCondensed"],
 CellMargins->{{48, 0}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 75},
 TabSpacings->47.4,
 CounterIncrements->"TOCSectionCondensed",
 CounterAssignments->{{"TOCSubsection", 0}},
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->GrayLevel[0.2]],

Cell[StyleData["TOCSectionCondensed", "Presentation"],
 FontSize->15],

Cell[StyleData["TOCSectionCondensed", "Printout"],
 CellMargins->{{36, 0}, {1, 1}},
 PageBreakBelow->False,
 FontSize->11],

Cell[StyleData["TOCSectionCondensed", "EnhancedPrintout"],
 CellMargins->{{36, 0}, {1, 1}},
 PageBreakBelow->False,
 FontFamily->"Palatino",
 FontSize->11]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsectionCondensed"],
 PageWidth->470,
 CellMargins->{{76, 0}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 80},
 TextJustification->1,
 FontSize->12],

Cell[StyleData["TOCSubsectionCondensed", "Presentation"],
 FontSize->18],

Cell[StyleData["TOCSubsectionCondensed", "Printout"],
 CellMargins->{{72, 0}, {1, 1}},
 PageBreakBelow->False,
 Hyphenation->True,
 FontSize->10],

Cell[StyleData["TOCSubsectionCondensed", "EnhancedPrintout"],
 CellMargins->{{72, 0}, {1, 1}},
 PageBreakBelow->False,
 Hyphenation->True,
 FontFamily->"Palatino",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TOCSubsubsectionCondensed"],
 CellMargins->{{104, 0}, {1, 1}},
 CellGroupingRules->{"SectionGrouping", 85},
 TabSpacings->39.3,
 CounterIncrements->"TOCSubsubsectionCondensed",
 FontSize->12],

Cell[StyleData["TOCSubsubsectionCondensed", "Presentation"],
 FontSize->18],

Cell[StyleData["TOCSubsubsectionCondensed", "Printout"],
 CellMargins->{{96, 0}, {1, 1}},
 PageBreakBelow->False,
 FontSize->9],

Cell[StyleData["TOCSubsubsectionCondensed", "EnhancedPrintout"],
 CellMargins->{{96, 0}, {1, 1}},
 PageBreakBelow->False,
 FontFamily->"Palatino",
 FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TitlePageGraphic"],
 CellMargins->{{0, 0}, {100, 20}},
 Evaluatable->False,
 PageBreakBelow->False,
 TextAlignment->Center],

Cell[StyleData["TitlePageGraphic", "Presentation"],
 FontSize->18],

Cell[StyleData["TitlePageGraphic", "Printout"],
 CellMargins->{{0, 0}, {230, 88}}],

Cell[StyleData["TitlePageGraphic", "EnhancedPrintout"],
 CellMargins->{{0, 0}, {230, 88}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["TitlePageLogo"],
 CellMargins->{{0, 0}, {0, 0}}],

Cell[StyleData["TitlePageLogo", "Presentation"],
 FontSize->18],

Cell[StyleData["TitlePageLogo", "Printout"]],

Cell[StyleData["TitlePageLogo", "EnhancedPrintout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Section"],

Cell[CellGroupData[{

Cell[StyleData["ReferenceGroup"],
 CellFrame->{{0, 0}, {0, 0.25}},
 ShowCellBracket->False,
 CellMargins->{{27, 0}, {0, 18}},
 CellGroupingRules->{"SectionGrouping", 60},
 CellFrameMargins->{{0, 12}, {6, 4}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontFamily->"Helvetica",
 FontWeight->"Bold",
 Background->GrayLevel[0.990005]],

Cell[StyleData["ReferenceGroup", "Presentation"],
 FontSize->20],

Cell[StyleData["ReferenceGroup", "Printout"],
 CellMargins->{{3, 0}, {0, 10}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleHead1"],
 ShowCellBracket->True,
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {6, 6}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 70},
 CellFrameMargins->12,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontFamily->"Helvetica",
 FontWeight->"Plain"],

Cell[StyleData["ExampleHead1", "Presentation"],
 FontSize->20],

Cell[StyleData["ExampleHead1", "Printout"],
 CellMargins->{{3, 0}, {0, 10}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleHead2"],
 ShowCellBracket->True,
 CellMargins->{{27, 4}, {6, 12}},
 CellElementSpacings->{"ClosedGroupTopMargin"->12},
 CellGroupingRules->{"SectionGrouping", 80},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontFamily->"Helvetica",
 FontWeight->"Plain",
 FontColor->RGBColor[0.592157, 0.313725, 0.313725]],

Cell[StyleData["ExampleHead2", "Presentation"],
 FontSize->20],

Cell[StyleData["ExampleHead2", "Printout"],
 CellMargins->{{3, 0}, {0, 10}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleHead3"],
 ShowCellBracket->True,
 CellMargins->{{27, 4}, {6, 12}},
 CellGroupingRules->{"SectionGrouping", 90},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontFamily->"Times",
 FontWeight->"Bold"],

Cell[StyleData["ExampleHead3", "Presentation"],
 FontSize->20],

Cell[StyleData["ExampleHead3", "Printout"],
 CellMargins->{{3, 0}, {0, 10}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleSection"],
 CellFrame->{{0, 0}, {0, 0.5}},
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {0, 10}},
 CellGroupingRules->{"SectionGrouping", 70},
 CellFrameMargins->12,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontWeight->"Bold"],

Cell[StyleData["ExampleSection", "Presentation"],
 FontSize->20],

Cell[StyleData["ExampleSection", "Printout"],
 CellMargins->{{3, 0}, {0, 10}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->9,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleText"],
 CellMargins->{{27, 40}, {0, 18}},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 ParagraphSpacing->{0, 6},
 StyleMenuListing->None,
 FontColor->RGBColor[0, 0, 0.4]],

Cell[StyleData["ExampleText", "Presentation"],
 FontSize->18],

Cell[StyleData["ExampleText", "Printout"],
 CellMargins->{{2, 80}, {0, 8}},
 PageBreakBelow->False,
 Hyphenation->True,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->8,
 FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ExampleSubsection"],
 ShowCellBracket->True,
 ShowGroupOpenCloseIcon->True,
 CellMargins->{{27, 4}, {0, 16}},
 CellGroupingRules->{"SectionGrouping", 80},
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold"],

Cell[StyleData["ExampleSubsection", "Presentation"],
 FontSize->15],

Cell[StyleData["ExampleSubsection", "Printout"],
 CellMargins->{{12, 0}, {0, 16}},
 PageBreakBelow->False,
 HyphenationOptions->{"HyphenationCharacter"->"-"},
 FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Horizontal Lines", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Line1"],
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{10, 4}, {-16, 9}},
 StyleMenuListing->None,
 FontSize->2],

Cell[StyleData["Line1", "Presentation"],
 FontSize->3],

Cell[StyleData["Line1", "Printout"],
 CellMargins->{{2, 0}, {-16, 9}}]
}, Closed]],

Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["ProgramTop"],
 CellFrame->{{0.5, 0.5}, {0, 0.5}},
 CellMargins->{{27, 4}, {-18, 18}},
 LineSpacing->{1, -4},
 StyleMenuListing->None,
 FontSize->4],

Cell[StyleData["ProgramTop", "Presentation"],
 FontSize->6],

Cell[StyleData["ProgramTop", "Printout"],
 CellMargins->{{2, 0}, {-18, 18}}]
}, Closed]],

Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["ProgramBottom"],
 CellFrame->{{0.5, 0.5}, {0.5, 0}},
 CellMargins->{{27, 4}, {-10, -2}},
 LineSpacing->{1, -4},
 StyleMenuListing->None,
 FontSize->4],

Cell[StyleData["ProgramBottom", "Presentation"],
 FontSize->6],

Cell[StyleData["ProgramBottom", "Printout"],
 CellMargins->{{2, 0}, {-10, -2}}]
}, Closed]],

Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["SessionLabel"],
 CellFrame->{{0.5, 0}, {0, 0.5}},
 CellMargins->{{27, 4}, {-4, 18}},
 LineSpacing->{1, 0},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->9],

Cell[StyleData["SessionLabel", "Presentation"],
 FontSize->14],

Cell[StyleData["SessionLabel", "Printout"],
 CellMargins->{{2, 0}, {-4, 18}},
 FontSize->7]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Page Headers and Footers", "Section"],

Cell[CellGroupData[{

Cell[StyleData["PageHeader"],
 CellMargins->{{0, 0}, {2, 0}},
 StyleMenuListing->None,
 FontSize->8,
 FontSlant->"Italic"],

Cell[StyleData["PageHeader", "Printout"]],

Cell[StyleData["PageHeader", "EnhancedPrintout"],
 FontFamily->"Frutiger-Italic",
 FontSize->8,
 FontSlant->"Plain"],

Cell[StyleData["PageHeader", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Italic",
 FontSize->8,
 FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageNumber"],
 CellMargins->{{0, 0}, {2, 0}},
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->8,
 FontWeight->"Bold"],

Cell[StyleData["PageNumber", "Printout"]],

Cell[StyleData["PageNumber", "EnhancedPrintout"],
 FontFamily->"Frutiger-Bold",
 FontSize->8,
 FontWeight->"Plain"],

Cell[StyleData["PageNumber", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Bold",
 FontSize->8,
 FontWeight->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["PageFooter"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->6],

Cell[StyleData["PageFooter", "Printout"]],

Cell[StyleData["PageFooter", "EnhancedPrintout"],
 FontFamily->"Frutiger-Roman",
 FontSize->6],

Cell[StyleData["PageFooter", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Roman",
 FontSize->6]
}, Closed]],

Cell[CellGroupData[{

Cell["For compatibility", "Subsection"],

Cell[CellGroupData[{

Cell[StyleData["Header"],
 CellMargins->{{0, 0}, {2, 0}},
 StyleMenuListing->None,
 FontSize->8,
 FontSlant->"Italic"],

Cell[StyleData["Header", "Printout"]],

Cell[StyleData["Header", "EnhancedPrintout"],
 FontFamily->"Frutiger-Italic",
 FontSize->8,
 FontSlant->"Plain"],

Cell[StyleData["Header", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Italic",
 FontSize->8,
 FontSlant->"Plain"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Footer"],
 StyleMenuListing->None,
 FontFamily->"Helvetica",
 FontSize->6],

Cell[StyleData["Footer", "Printout"]],

Cell[StyleData["Footer", "EnhancedPrintout"],
 FontFamily->"Frutiger-Roman",
 FontSize->6],

Cell[StyleData["Footer", "EnhancedPrintoutNonGray"],
 FontFamily->"Frutiger-Roman",
 FontSize->6]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of most \
cells.  If a cell's FormatType matches the name of one of the styles defined \
below, then that style is applied between the cell's style and its own \
options. This is particularly true of Input and Output.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["CellExpression"],
 PageWidth->Infinity,
 CellMargins->{{6, Inherited}, {Inherited, Inherited}},
 ShowCellLabel->False,
 ShowSpecialCharacters->False,
 AllowInlineCells->False,
 Hyphenation->False,
 AutoItalicWords->{},
 StyleMenuListing->None,
 FontFamily->"Courier",
 FontSize->12,
 Background->GrayLevel[1]],

Cell[StyleData["CellExpression", "EnhancedPrintout"],
 FontFamily->"Courier Std",
 FontSize->10],

Cell[StyleData["CellExpression", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std",
 FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["InputForm"],
 InputAutoReplacements->{},
 AllowInlineCells->False,
 Hyphenation->False,
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["InputForm", "EnhancedPrintout"],
 FontFamily->"Courier Std"],

Cell[StyleData["InputForm", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OutputForm"],
 PageWidth->Infinity,
 TextAlignment->Left,
 LineSpacing->{0.6, 1},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["OutputForm", "EnhancedPrintout"],
 FontFamily->"Courier Std"],

Cell[StyleData["OutputForm", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["StandardForm"],
 InputAutoReplacements->{
  "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", ">=" -> 
   "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]", Inherited},
 "TwoByteSyntaxCharacterAutoReplacement"->True,
 LineSpacing->{1.25, 0},
 StyleMenuListing->None,
 FontFamily->"Courier"],

Cell[StyleData["StandardForm", "EnhancedPrintout"],
 FontFamily->"Courier Std"],

Cell[StyleData["StandardForm", "EnhancedPrintoutNonGray"],
 FontFamily->"Courier Std"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Automatic Styles", "Section"],

Cell["\<\
The cells below define styles that are used to affect the display of certain \
types of objects in typeset expressions.  For example, \"UnmatchedBracket\" \
style defines how unmatched bracket, curly bracket, and parenthesis \
characters are displayed (typically by coloring them to make them stand out).\
\
\>", "Text"],

Cell[StyleData["UnmatchedBracket"],
 StyleMenuListing->None]
}, Closed]]
}, Open  ]]
},
WindowSize->{637, 582},
WindowMargins->{{76, Automatic}, {Automatic, 19}},
MenuPosition->None,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (January 7, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FunctionName"->{
  Cell[143161, 5468, 281, 9, 70, 31, 0, "StyleData", "FunctionName", "All",
   StyleMenuListing->None,
   CellTags->"FunctionName"]},
 "FunctionSubsection"->{
  Cell[143900, 5499, 252, 7, 70, 37, 0, "StyleData", "FunctionSubsection", 
  "All",
   StyleMenuListing->None,
   CellTags->"FunctionSubsection"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FunctionName", 247918, 9516},
 {"FunctionSubsection", 248077, 9520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[606, 24, 50, 0, 83, "Title"],
Cell[659, 26, 139, 3, 47, "Text"],
Cell[CellGroupData[{
Cell[823, 33, 42, 0, 71, "Section"],
Cell[868, 35, 191, 5, 70, 31, 0, "StyleData", "All", "Working"],
Cell[1062, 42, 191, 5, 70, 32, 0, "StyleData", "All", "Brackets"],
Cell[1256, 49, 196, 5, 70, 36, 0, "StyleData", "All", "Presentation"],
Cell[1455, 56, 201, 6, 70, 33, 0, "StyleData", "All", "SlideShow"],
Cell[1659, 64, 170, 5, 70, 32, 0, "StyleData", "All", "Printout"],
Cell[1832, 71, 202, 6, 70, 40, 0, "StyleData", "All", "EnhancedPrintout"],
Cell[2037, 79, 210, 6, 70, 47, 0, "StyleData", "All", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[2284, 90, 35, 0, 41, "Section"],
Cell[2322, 92, 105, 3, 29, "Text"],
Cell[CellGroupData[{
Cell[2452, 99, 946, 29, 40, 27, 0, "StyleData", "Notebook", "All"],
Cell[3401, 130, 898, 27, 70, 39, 0, "StyleData", "Notebook", "Printout"],
Cell[4302, 159, 362, 9, 70, 47, 0, "StyleData", "Notebook", \
"EnhancedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[4713, 174, 27, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[4765, 178, 1448, 36, 70, 26, 0, "StyleData", "Chapter", "All",
 CounterIncrements->"Chapter",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[6216, 216, 57, 1, 70, 42, 0, "StyleData", "Chapter", "Presentation"],
Cell[6276, 219, 87, 2, 70, 38, 0, "StyleData", "Chapter", "Printout"],
Cell[6366, 223, 170, 5, 70, 46, 0, "StyleData", "Chapter", \
"EnhancedPrintout"],
Cell[6539, 230, 151, 4, 70, 53, 0, "StyleData", "Chapter", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[6727, 239, 1295, 32, 70, 26, 0, "StyleData", "Section", "All",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[8025, 273, 57, 1, 70, 42, 0, "StyleData", "Section", "Presentation"],
Cell[8085, 276, 336, 10, 70, 39, 0, "StyleData", "Section", "SlideShow"],
Cell[8424, 288, 110, 3, 70, 38, 0, "StyleData", "Section", "Printout"],
Cell[8537, 293, 390, 11, 70, 46, 0, "StyleData", "Section", \
"EnhancedPrintout",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[8930, 306, 379, 10, 70, 53, 0, "StyleData", "Section", \
"EnhancedPrintoutNonGray",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}]
}, Closed]],
Cell[CellGroupData[{
Cell[9346, 321, 1381, 35, 70, 29, 0, "StyleData", "Subsection", "All",
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}}],
Cell[10730, 358, 60, 1, 70, 45, 0, "StyleData", "Subsection", \
"Presentation"],
Cell[10793, 361, 111, 3, 70, 42, 0, "StyleData", "Subsection", "SlideShow"],
Cell[10907, 366, 89, 2, 70, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[10999, 370, 175, 5, 70, 49, 0, "StyleData", "Subsection", \
"EnhancedPrintout"],
Cell[11177, 377, 156, 4, 70, 56, 0, "StyleData", "Subsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[11370, 386, 1258, 31, 70, 32, 0, "StyleData", "Subsubsection", "All"],
Cell[12631, 419, 63, 1, 70, 48, 0, "StyleData", "Subsubsection", \
"Presentation"],
Cell[12697, 422, 91, 2, 70, 44, 0, "StyleData", "Subsubsection", "Printout"],
Cell[12791, 426, 177, 5, 70, 52, 0, "StyleData", "Subsubsection", \
"EnhancedPrintout"],
Cell[12971, 433, 158, 4, 70, 59, 0, "StyleData", "Subsubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[13166, 442, 1257, 31, 70, 37, 0, "StyleData", "SubsubsectionColor", \
"All",
 StyleMenuListing->None],
Cell[14426, 475, 68, 1, 70, 53, 0, "StyleData", "SubsubsectionColor", \
"Presentation"],
Cell[14497, 478, 121, 3, 70, 49, 0, "StyleData", "SubsubsectionColor", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[14655, 486, 1344, 33, 70, 33, 0, "StyleData", "SubsectionIcon", "All",
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}}],
Cell[16002, 521, 64, 1, 70, 49, 0, "StyleData", "SubsectionIcon", \
"Presentation"],
Cell[16069, 524, 183, 5, 70, 45, 0, "StyleData", "SubsectionIcon", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[16289, 534, 1304, 32, 70, 36, 0, "StyleData", "SubsubsectionIcon", "All",
 
 CounterIncrements->"Subsubsection"],
Cell[17596, 568, 67, 1, 70, 52, 0, "StyleData", "SubsubsectionIcon", \
"Presentation"],
Cell[17666, 571, 152, 4, 70, 48, 0, "StyleData", "SubsubsectionIcon", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[17867, 581, 23, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[17915, 585, 1083, 27, 70, 23, 0, "StyleData", "Text", "All",
 CounterIncrements->"Text"],
Cell[19001, 614, 54, 1, 70, 39, 0, "StyleData", "Text", "Presentation"],
Cell[19058, 617, 106, 3, 70, 36, 0, "StyleData", "Text", "SlideShow"],
Cell[19167, 622, 125, 4, 70, 35, 0, "StyleData", "Text", "Printout"],
Cell[19295, 628, 158, 5, 70, 43, 0, "StyleData", "Text", "EnhancedPrintout"],
Cell[19456, 635, 165, 5, 70, 50, 0, "StyleData", "Text", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[19658, 645, 131, 4, 70, 30, 0, "StyleData", "CompactText", "All",
 StyleMenuListing->None],
Cell[19792, 651, 61, 1, 70, 46, 0, "StyleData", "CompactText", \
"Presentation"],
Cell[19856, 654, 108, 3, 70, 42, 0, "StyleData", "CompactText", "Printout"],
Cell[19967, 659, 141, 4, 70, 50, 0, "StyleData", "CompactText", \
"EnhancedPrintout"],
Cell[20111, 665, 148, 4, 70, 57, 0, "StyleData", "CompactText", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[20296, 674, 118, 3, 70, 32, 0, "StyleData", "Compact12Text", "All",
 StyleMenuListing->None],
Cell[20417, 679, 63, 1, 70, 48, 0, "StyleData", "Compact12Text", \
"Presentation"],
Cell[20483, 682, 111, 3, 70, 44, 0, "StyleData", "Compact12Text", \
"Printout"],
Cell[20597, 687, 144, 4, 70, 52, 0, "StyleData", "Compact12Text", \
"EnhancedPrintout"],
Cell[20744, 693, 151, 4, 70, 59, 0, "StyleData", "Compact12Text", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[20932, 702, 186, 6, 70, 27, 0, "StyleData", "TextSans", "All",
 StyleMenuListing->None],
Cell[21121, 710, 58, 1, 70, 43, 0, "StyleData", "TextSans", "Presentation"],
Cell[21182, 713, 105, 3, 70, 39, 0, "StyleData", "TextSans", "Printout"],
Cell[21290, 718, 144, 4, 70, 47, 0, "StyleData", "TextSans", \
"EnhancedPrintout"],
Cell[21437, 724, 151, 4, 70, 54, 0, "StyleData", "TextSans", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[21625, 733, 170, 5, 70, 31, 0, "StyleData", "ItemizedText", "All",
 CounterIncrements->"ItemizedText",
 StyleMenuListing->None],
Cell[21798, 740, 62, 1, 70, 47, 0, "StyleData", "ItemizedText", \
"Presentation"],
Cell[21863, 743, 111, 3, 70, 43, 0, "StyleData", "ItemizedText", "Printout"],
Cell[21977, 748, 166, 5, 70, 51, 0, "StyleData", "ItemizedText", \
"EnhancedPrintout"],
Cell[22146, 755, 163, 5, 70, 58, 0, "StyleData", "ItemizedText", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[22346, 765, 155, 4, 70, 35, 0, "StyleData", "ItemizedTextNote", "All",
 CounterIncrements->"ItemizedTextNote",
 StyleMenuListing->None],
Cell[22504, 771, 66, 1, 70, 51, 0, "StyleData", "ItemizedTextNote", \
"Presentation"],
Cell[22573, 774, 115, 3, 70, 47, 0, "StyleData", "ItemizedTextNote", \
"Printout"],
Cell[22691, 779, 170, 5, 70, 55, 0, "StyleData", "ItemizedTextNote", \
"EnhancedPrintout"],
Cell[22864, 786, 177, 5, 70, 62, 0, "StyleData", "ItemizedTextNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[23078, 796, 147, 4, 70, 31, 0, "StyleData", "IndentedText", "All",
 CounterIncrements->"IndentedText",
 StyleMenuListing->None],
Cell[23228, 802, 62, 1, 70, 47, 0, "StyleData", "IndentedText", \
"Presentation"],
Cell[23293, 805, 114, 3, 70, 44, 0, "StyleData", "IndentedText", \
"SlideShow"],
Cell[23410, 810, 111, 3, 70, 43, 0, "StyleData", "IndentedText", "Printout"],
Cell[23524, 815, 190, 5, 70, 51, 0, "StyleData", "IndentedText", \
"EnhancedPrintout"],
Cell[23717, 822, 140, 4, 70, 58, 0, "StyleData", "IndentedText", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[23894, 831, 412, 12, 70, 31, 0, "StyleData", "ItemizedList", "All",
 CounterIncrements->"ItemizedList",
 StyleMenuListing->None],
Cell[24309, 845, 62, 1, 70, 47, 0, "StyleData", "ItemizedList", \
"Presentation"],
Cell[24374, 848, 110, 3, 70, 43, 0, "StyleData", "ItemizedList", "Printout"],
Cell[24487, 853, 165, 5, 70, 51, 0, "StyleData", "ItemizedList", \
"EnhancedPrintout"],
Cell[24655, 860, 140, 4, 70, 58, 0, "StyleData", "ItemizedList", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[24832, 869, 481, 13, 70, 34, 0, "StyleData", "ItemizedSubList", "All",
 CounterIncrements->"ItemizedSubList",
 StyleMenuListing->None],
Cell[25316, 884, 65, 1, 70, 50, 0, "StyleData", "ItemizedSubList", \
"Presentation"],
Cell[25384, 887, 114, 3, 70, 46, 0, "StyleData", "ItemizedSubList", \
"Printout"],
Cell[25501, 892, 147, 4, 70, 54, 0, "StyleData", "ItemizedSubList", \
"EnhancedPrintout"],
Cell[25651, 898, 121, 3, 70, 61, 0, "StyleData", "ItemizedSubList", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[25809, 906, 218, 5, 70, 38, 0, "StyleData", "ItemizedSubListNote", "All",
 
 CounterIncrements->"ItemizedSubList",
 StyleMenuListing->None],
Cell[26030, 913, 69, 1, 70, 54, 0, "StyleData", "ItemizedSubListNote", \
"Presentation"],
Cell[26102, 916, 118, 3, 70, 50, 0, "StyleData", "ItemizedSubListNote", \
"Printout"],
Cell[26223, 921, 151, 4, 70, 58, 0, "StyleData", "ItemizedSubListNote", \
"EnhancedPrintout"],
Cell[26377, 927, 158, 4, 70, 65, 0, "StyleData", "ItemizedSubListNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[26572, 936, 272, 7, 70, 31, 0, "StyleData", "BulletedList", "All",
 CounterIncrements->"BulletText",
 StyleMenuListing->None],
Cell[26847, 945, 62, 1, 70, 47, 0, "StyleData", "BulletedList", \
"Presentation"],
Cell[26912, 948, 111, 3, 70, 43, 0, "StyleData", "BulletedList", "Printout"],
Cell[27026, 953, 166, 5, 70, 51, 0, "StyleData", "BulletedList", \
"EnhancedPrintout"],
Cell[27195, 960, 140, 4, 70, 58, 0, "StyleData", "BulletedList", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[27372, 969, 139, 4, 70, 27, 0, "StyleData", "ListNote", "All",
 CounterIncrements->"ListNote",
 StyleMenuListing->None],
Cell[27514, 975, 58, 1, 70, 43, 0, "StyleData", "ListNote", "Presentation"],
Cell[27575, 978, 107, 3, 70, 39, 0, "StyleData", "ListNote", "Printout"],
Cell[27685, 983, 162, 5, 70, 47, 0, "StyleData", "ListNote", \
"EnhancedPrintout"],
Cell[27850, 990, 169, 5, 70, 54, 0, "StyleData", "ListNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[28056, 1000, 300, 9, 70, 30, 0, "StyleData", "MathCaption", "All"],
Cell[28359, 1011, 61, 1, 70, 46, 0, "StyleData", "MathCaption", \
"Presentation"],
Cell[28423, 1014, 102, 2, 70, 43, 0, "StyleData", "MathCaption", \
"SlideShow"],
Cell[28528, 1018, 135, 4, 70, 42, 0, "StyleData", "MathCaption", "Printout"],
Cell[28666, 1024, 168, 5, 70, 50, 0, "StyleData", "MathCaption", \
"EnhancedPrintout"],
Cell[28837, 1031, 175, 5, 70, 57, 0, "StyleData", "MathCaption", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[29049, 1041, 160, 5, 70, 28, 0, "StyleData", "SmallText", "All",
 CounterIncrements->"SmallText"],
Cell[29212, 1048, 59, 1, 70, 44, 0, "StyleData", "SmallText", \
"Presentation"],
Cell[29274, 1051, 129, 4, 70, 40, 0, "StyleData", "SmallText", "Printout"],
Cell[29406, 1057, 162, 5, 70, 48, 0, "StyleData", "SmallText", \
"EnhancedPrintout"],
Cell[29571, 1064, 169, 5, 70, 55, 0, "StyleData", "SmallText", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29789, 1075, 31, 0, 41, "Section"],
Cell[29823, 1077, 252, 5, 70, "Text"],
Cell[CellGroupData[{
Cell[30100, 1086, 653, 19, 70, 24, 0, "StyleData", "Input", "All"],
Cell[30756, 1107, 55, 1, 70, 40, 0, "StyleData", "Input", "Presentation"],
Cell[30814, 1110, 222, 6, 70, 37, 0, "StyleData", "Input", "SlideShow"],
Cell[31039, 1118, 108, 3, 70, 36, 0, "StyleData", "Input", "Printout"],
Cell[31150, 1123, 116, 3, 70, 44, 0, "StyleData", "Input", \
"EnhancedPrintout"],
Cell[31269, 1128, 123, 3, 70, 51, 0, "StyleData", "Input", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[31429, 1136, 605, 17, 70, 25, 0, "StyleData", "Output", "All"],
Cell[32037, 1155, 56, 1, 70, 41, 0, "StyleData", "Output", "Presentation"],
Cell[32096, 1158, 223, 6, 70, 38, 0, "StyleData", "Output", "SlideShow"],
Cell[32322, 1166, 109, 3, 70, 37, 0, "StyleData", "Output", "Printout"],
Cell[32434, 1171, 117, 3, 70, 45, 0, "StyleData", "Output", \
"EnhancedPrintout"],
Cell[32554, 1176, 124, 3, 70, 52, 0, "StyleData", "Output", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[32715, 1184, 682, 20, 70, 28, 0, "StyleData", "InputOnly", "All",
 StyleMenuListing->None],
Cell[33400, 1206, 59, 1, 70, 44, 0, "StyleData", "InputOnly", \
"Presentation"],
Cell[33462, 1209, 189, 5, 70, 41, 0, "StyleData", "InputOnly", "SlideShow"],
Cell[33654, 1216, 112, 3, 70, 40, 0, "StyleData", "InputOnly", "Printout"],
Cell[33769, 1221, 120, 3, 70, 48, 0, "StyleData", "InputOnly", \
"EnhancedPrintout"],
Cell[33892, 1226, 127, 3, 70, 55, 0, "StyleData", "InputOnly", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[34056, 1234, 730, 21, 70, 26, 0, "StyleData", "Message", "All",
 CounterIncrements->"Message",
 StyleMenuListing->None],
Cell[34789, 1257, 57, 1, 70, 42, 0, "StyleData", "Message", "Presentation"],
Cell[34849, 1260, 129, 3, 70, 39, 0, "StyleData", "Message", "SlideShow"],
Cell[34981, 1265, 160, 4, 70, 38, 0, "StyleData", "Message", "Printout"],
Cell[35144, 1271, 192, 5, 70, 46, 0, "StyleData", "Message", \
"EnhancedPrintout"],
Cell[35339, 1278, 199, 5, 70, 53, 0, "StyleData", "Message", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[35575, 1288, 562, 16, 70, 24, 0, "StyleData", "Print", "All",
 StyleMenuListing->None],
Cell[36140, 1306, 55, 1, 70, 40, 0, "StyleData", "Print", "Presentation"],
Cell[36198, 1309, 72, 1, 70, 37, 0, "StyleData", "Print", "SlideShow"],
Cell[36273, 1312, 132, 3, 70, 36, 0, "StyleData", "Print", "Printout"],
Cell[36408, 1317, 168, 4, 70, 44, 0, "StyleData", "Print", \
"EnhancedPrintout"],
Cell[36579, 1323, 175, 4, 70, 51, 0, "StyleData", "Print", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[36791, 1332, 600, 19, 70, 27, 0, "StyleData", "Graphics", "All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[37394, 1353, 58, 1, 70, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[37455, 1356, 225, 6, 70, 40, 0, "StyleData", "Graphics", "SlideShow"],
Cell[37683, 1364, 159, 4, 70, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[37845, 1370, 195, 5, 70, 47, 0, "StyleData", "Graphics", \
"EnhancedPrintout"],
Cell[38043, 1377, 202, 5, 70, 54, 0, "StyleData", "Graphics", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[38282, 1387, 187, 6, 70, 28, 0, "StyleData", "CellLabel", "All",
 StyleMenuListing->None],
Cell[38472, 1395, 59, 1, 70, 44, 0, "StyleData", "CellLabel", \
"Presentation"],
Cell[38534, 1398, 81, 1, 70, 41, 0, "StyleData", "CellLabel", "SlideShow"],
Cell[38618, 1401, 127, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[38748, 1407, 139, 4, 70, 48, 0, "StyleData", "CellLabel", \
"EnhancedPrintout"],
Cell[38890, 1413, 146, 4, 70, 55, 0, "StyleData", "CellLabel", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[39073, 1422, 179, 6, 70, 23, 0, "StyleData", "Name", "All",
 StyleMenuListing->None],
Cell[39255, 1430, 54, 1, 70, 39, 0, "StyleData", "Name", "Presentation"],
Cell[39312, 1433, 98, 3, 70, 35, 0, "StyleData", "Name", "Printout"],
Cell[39413, 1438, 136, 4, 70, 43, 0, "StyleData", "Name", \
"EnhancedPrintout"],
Cell[39552, 1444, 143, 4, 70, 50, 0, "StyleData", "Name", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[39744, 1454, 37, 0, 41, "Section"],
Cell[39784, 1456, 106, 3, 70, "Text"],
Cell[39893, 1461, 671, 20, 70, 37, 0, "StyleData", "DefaultGraphicsBox", \
"All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[40567, 1483, 673, 20, 70, 39, 0, "StyleData", "DefaultGraphics3DBox", \
"All",
 CounterIncrements->"Graphics",
 StyleMenuListing->None],
Cell[41243, 1505, 122, 2, 70, 34, 0, "StyleData", "DefaultPanelBox", "All"],
Cell[41368, 1509, 174, 4, 70, 34, 0, "StyleData", "DefaultPopupBox", "All"],
Cell[41545, 1515, 175, 4, 70, 35, 0, "StyleData", "DefaultButtonBox", "All"]
}, Closed]],
Cell[CellGroupData[{
Cell[41757, 1524, 29, 0, 41, "Section"],
Cell[41789, 1526, 340, 6, 70, "Text"],
Cell[CellGroupData[{
Cell[42154, 1536, 270, 7, 70, 28, 0, "StyleData", "Hyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[42427, 1545, 66, 1, 70, 40, 0, "StyleData", "Hyperlink", "Printout"],
Cell[42496, 1548, 99, 2, 70, 48, 0, "StyleData", "Hyperlink", \
"EnhancedPrintout"],
Cell[42598, 1552, 106, 2, 70, 55, 0, "StyleData", "Hyperlink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[42741, 1559, 317, 8, 70, 31, 0, "StyleData", "MainBookLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[43061, 1569, 69, 1, 70, 43, 0, "StyleData", "MainBookLink", "Printout"],
Cell[43133, 1572, 102, 2, 70, 51, 0, "StyleData", "MainBookLink", \
"EnhancedPrintout"],
Cell[43238, 1576, 109, 2, 70, 58, 0, "StyleData", "MainBookLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[43384, 1583, 343, 9, 70, 33, 0, "StyleData", "MainBookLinkMR", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[43730, 1594, 71, 1, 70, 45, 0, "StyleData", "MainBookLinkMR", \
"Printout"],
Cell[43804, 1597, 79, 1, 70, 53, 0, "StyleData", "MainBookLinkMR", \
"EnhancedPrintout"],
Cell[43886, 1600, 86, 1, 70, 60, 0, "StyleData", "MainBookLinkMR", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[44009, 1606, 337, 9, 70, 29, 0, "StyleData", "AddOnsLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[44349, 1617, 67, 1, 70, 41, 0, "StyleData", "AddOnsLink", "Printout"],
Cell[44419, 1620, 102, 2, 70, 49, 0, "StyleData", "AddOnsLink", \
"EnhancedPrintout"],
Cell[44524, 1624, 109, 2, 70, 56, 0, "StyleData", "AddOnsLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[44670, 1631, 339, 9, 70, 33, 0, "StyleData", "AddOnsLinkText", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[45012, 1642, 71, 1, 70, 45, 0, "StyleData", "AddOnsLinkText", \
"Printout"],
Cell[45086, 1645, 104, 2, 70, 53, 0, "StyleData", "AddOnsLinkText", \
"EnhancedPrintout"],
Cell[45193, 1649, 111, 2, 70, 60, 0, "StyleData", "AddOnsLinkText", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[45341, 1656, 341, 9, 70, 31, 0, "StyleData", "RefGuideLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[45685, 1667, 69, 1, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"],
Cell[45757, 1670, 104, 2, 70, 51, 0, "StyleData", "RefGuideLink", \
"EnhancedPrintout"],
Cell[45864, 1674, 111, 2, 70, 58, 0, "StyleData", "RefGuideLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[46012, 1681, 329, 8, 70, 37, 0, "StyleData", "GettingStartedLink", "All",
 
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[46344, 1691, 75, 1, 70, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"],
Cell[46422, 1694, 108, 2, 70, 57, 0, "StyleData", "GettingStartedLink", \
"EnhancedPrintout"],
Cell[46533, 1698, 115, 2, 70, 64, 0, "StyleData", "GettingStartedLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[46685, 1705, 311, 8, 70, 28, 0, "StyleData", "DemosLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[46999, 1715, 66, 1, 70, 40, 0, "StyleData", "DemosLink", "Printout"],
Cell[47068, 1718, 74, 1, 70, 48, 0, "StyleData", "DemosLink", \
"EnhancedPrintout"],
Cell[47145, 1721, 81, 1, 70, 55, 0, "StyleData", "DemosLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[47263, 1727, 309, 8, 70, 27, 0, "StyleData", "TourLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[47575, 1737, 65, 1, 70, 39, 0, "StyleData", "TourLink", "Printout"],
Cell[47643, 1740, 73, 1, 70, 47, 0, "StyleData", "TourLink", \
"EnhancedPrintout"],
Cell[47719, 1743, 80, 1, 70, 54, 0, "StyleData", "TourLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[47836, 1749, 333, 8, 70, 39, 0, "StyleData", "OtherInformationLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[48172, 1759, 77, 1, 70, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"],
Cell[48252, 1762, 110, 2, 70, 59, 0, "StyleData", "OtherInformationLink", \
"EnhancedPrintout"],
Cell[48365, 1766, 117, 2, 70, 66, 0, "StyleData", "OtherInformationLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[48519, 1773, 323, 8, 70, 41, 0, "StyleData", "OtherInformationLinkMR", \
"All",
 StyleMenuListing->None],
Cell[48845, 1783, 79, 1, 70, 53, 0, "StyleData", "OtherInformationLinkMR", \
"Printout"],
Cell[48927, 1786, 87, 1, 70, 61, 0, "StyleData", "OtherInformationLinkMR", \
"EnhancedPrintout"],
Cell[49017, 1789, 94, 1, 70, 68, 0, "StyleData", "OtherInformationLinkMR", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[49148, 1795, 323, 8, 70, 34, 0, "StyleData", "MasterIndexLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[49474, 1805, 72, 1, 70, 46, 0, "StyleData", "MasterIndexLink", \
"Printout"],
Cell[49549, 1808, 80, 1, 70, 54, 0, "StyleData", "MasterIndexLink", \
"EnhancedPrintout"],
Cell[49632, 1811, 87, 1, 70, 61, 0, "StyleData", "MasterIndexLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[49756, 1817, 291, 8, 70, 31, 0, "StyleData", "NotebookLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[50050, 1827, 84, 2, 70, 43, 0, "StyleData", "NotebookLink", "Printout"],
Cell[50137, 1831, 117, 3, 70, 51, 0, "StyleData", "NotebookLink", \
"EnhancedPrintout"],
Cell[50257, 1836, 124, 3, 70, 58, 0, "StyleData", "NotebookLink", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[50418, 1844, 295, 8, 70, 33, 0, "StyleData", "NotebookLinkMR", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[50716, 1854, 86, 2, 70, 45, 0, "StyleData", "NotebookLinkMR", \
"Printout"],
Cell[50805, 1858, 94, 2, 70, 53, 0, "StyleData", "NotebookLinkMR", \
"EnhancedPrintout"],
Cell[50902, 1862, 101, 2, 70, 60, 0, "StyleData", "NotebookLinkMR", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[51052, 1870, 33, 0, 41, "Section"],
Cell[51088, 1872, 121, 3, 70, "Text"],
Cell[51212, 1877, 216, 5, 70, 24, 0, "StyleData", "Paste", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[51431, 1884, 287, 7, 70, 27, 0, "StyleData", "Evaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[51721, 1893, 376, 9, 70, 31, 0, "StyleData", "EvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[52100, 1904, 363, 9, 70, 31, 0, "StyleData", "CopyEvaluate", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[52466, 1915, 377, 9, 70, 35, 0, "StyleData", "CopyEvaluateCell", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic]
}, Closed]],
Cell[CellGroupData[{
Cell[52880, 1929, 36, 0, 41, "Section"],
Cell[52919, 1931, 121, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[53065, 1938, 72, 2, 70, 21, 0, "StyleData", "JT", "All",
 StyleMenuListing->None],
Cell[53140, 1942, 33, 0, 70, 33, 0, "StyleData", "JT", "Printout"],
Cell[53176, 1944, 41, 0, 70, 41, 0, "StyleData", "JT", "EnhancedPrintout"],
Cell[53220, 1946, 48, 0, 70, 48, 0, "StyleData", "JT", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[53305, 1951, 72, 2, 70, 21, 0, "StyleData", "JS", "All",
 StyleMenuListing->None],
Cell[53380, 1955, 33, 0, 70, 33, 0, "StyleData", "JS", "Printout"],
Cell[53416, 1957, 41, 0, 70, 41, 0, "StyleData", "JS", "EnhancedPrintout"],
Cell[53460, 1959, 48, 0, 70, 48, 0, "StyleData", "JS", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[53545, 1964, 77, 2, 70, 22, 0, "StyleData", "JSB", "All",
 StyleMenuListing->None],
Cell[53625, 1968, 34, 0, 70, 34, 0, "StyleData", "JSB", "Printout"],
Cell[53662, 1970, 42, 0, 70, 42, 0, "StyleData", "JSB", "EnhancedPrintout"],
Cell[53707, 1972, 49, 0, 70, 49, 0, "StyleData", "JSB", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[53793, 1977, 89, 3, 70, 21, 0, "StyleData", "RM", "All",
 StyleMenuListing->None],
Cell[53885, 1982, 33, 0, 70, 33, 0, "StyleData", "RM", "Printout"],
Cell[53921, 1984, 41, 0, 70, 41, 0, "StyleData", "RM", "EnhancedPrintout"],
Cell[53965, 1986, 48, 0, 70, 48, 0, "StyleData", "RM", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[54050, 1991, 67, 2, 70, 21, 0, "StyleData", "BF", "All",
 StyleMenuListing->None],
Cell[54120, 1995, 33, 0, 70, 33, 0, "StyleData", "BF", "Printout"],
Cell[54156, 1997, 41, 0, 70, 41, 0, "StyleData", "BF", "EnhancedPrintout"],
Cell[54200, 1999, 48, 0, 70, 48, 0, "StyleData", "BF", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[54285, 2004, 68, 2, 70, 21, 0, "StyleData", "IT", "All",
 StyleMenuListing->None],
Cell[54356, 2008, 33, 0, 70, 33, 0, "StyleData", "IT", "Printout"],
Cell[54392, 2010, 41, 0, 70, 41, 0, "StyleData", "IT", "EnhancedPrintout"],
Cell[54436, 2012, 48, 0, 70, 48, 0, "StyleData", "IT", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[54521, 2017, 111, 4, 70, 21, 0, "StyleData", "TR", "All",
 StyleMenuListing->None],
Cell[54635, 2023, 33, 0, 70, 33, 0, "StyleData", "TR", "Printout"],
Cell[54671, 2025, 66, 1, 70, 41, 0, "StyleData", "TR", "EnhancedPrintout"],
Cell[54740, 2028, 73, 1, 70, 48, 0, "StyleData", "TR", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[54850, 2034, 90, 3, 70, 21, 0, "StyleData", "TI", "All",
 StyleMenuListing->None],
Cell[54943, 2039, 33, 0, 70, 33, 0, "StyleData", "TI", "Printout"],
Cell[54979, 2041, 66, 1, 70, 41, 0, "StyleData", "TI", "EnhancedPrintout"],
Cell[55048, 2044, 73, 1, 70, 48, 0, "StyleData", "TI", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[55158, 2050, 110, 4, 70, 21, 0, "StyleData", "TB", "All",
 StyleMenuListing->None],
Cell[55271, 2056, 33, 0, 70, 33, 0, "StyleData", "TB", "Printout"],
Cell[55307, 2058, 66, 1, 70, 41, 0, "StyleData", "TB", "EnhancedPrintout"],
Cell[55376, 2061, 73, 1, 70, 48, 0, "StyleData", "TB", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[55486, 2067, 112, 4, 70, 22, 0, "StyleData", "TBI", "All",
 StyleMenuListing->None],
Cell[55601, 2073, 34, 0, 70, 34, 0, "StyleData", "TBI", "Printout"],
Cell[55638, 2075, 67, 1, 70, 42, 0, "StyleData", "TBI", "EnhancedPrintout"],
Cell[55708, 2078, 74, 1, 70, 49, 0, "StyleData", "TBI", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[55819, 2084, 221, 7, 70, 21, 0, "StyleData", "MR", "All",
 StyleMenuListing->None],
Cell[56043, 2093, 33, 0, 70, 33, 0, "StyleData", "MR", "Printout"],
Cell[56079, 2095, 69, 1, 70, 41, 0, "StyleData", "MR", "EnhancedPrintout"],
Cell[56151, 2098, 76, 1, 70, 48, 0, "StyleData", "MR", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[56264, 2104, 180, 5, 70, 21, 0, "StyleData", "MO", "All",
 StyleMenuListing->None],
Cell[56447, 2111, 56, 1, 70, 33, 0, "StyleData", "MO", "Printout"],
Cell[56506, 2114, 92, 2, 70, 41, 0, "StyleData", "MO", "EnhancedPrintout"],
Cell[56601, 2118, 99, 2, 70, 48, 0, "StyleData", "MO", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[56737, 2125, 178, 5, 70, 21, 0, "StyleData", "MB", "All",
 StyleMenuListing->None],
Cell[56918, 2132, 33, 0, 70, 33, 0, "StyleData", "MB", "Printout"],
Cell[56954, 2134, 69, 1, 70, 41, 0, "StyleData", "MB", "EnhancedPrintout"],
Cell[57026, 2137, 76, 1, 70, 48, 0, "StyleData", "MB", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[57139, 2143, 180, 5, 70, 22, 0, "StyleData", "MBO", "All",
 StyleMenuListing->None],
Cell[57322, 2150, 57, 1, 70, 34, 0, "StyleData", "MBO", "Printout"],
Cell[57382, 2153, 93, 2, 70, 42, 0, "StyleData", "MBO", "EnhancedPrintout"],
Cell[57478, 2157, 100, 2, 70, 49, 0, "StyleData", "MBO", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[57615, 2164, 115, 4, 70, 21, 0, "StyleData", "SR", "All",
 StyleMenuListing->None],
Cell[57733, 2170, 33, 0, 70, 33, 0, "StyleData", "SR", "Printout"],
Cell[57769, 2172, 72, 1, 70, 41, 0, "StyleData", "SR", "EnhancedPrintout"],
Cell[57844, 2175, 79, 1, 70, 48, 0, "StyleData", "SR", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[57960, 2181, 116, 4, 70, 21, 0, "StyleData", "SO", "All",
 StyleMenuListing->None],
Cell[58079, 2187, 128, 4, 70, 33, 0, "StyleData", "SO", "Printout",
 StyleMenuListing->None],
Cell[58210, 2193, 94, 2, 70, 41, 0, "StyleData", "SO", "EnhancedPrintout"],
Cell[58307, 2197, 101, 2, 70, 48, 0, "StyleData", "SO", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[58445, 2204, 114, 4, 70, 21, 0, "StyleData", "SB", "All",
 StyleMenuListing->None],
Cell[58562, 2210, 58, 1, 70, 33, 0, "StyleData", "SB", "Printout",
 StyleMenuListing->None],
Cell[58623, 2213, 93, 2, 70, 41, 0, "StyleData", "SB", "EnhancedPrintout"],
Cell[58719, 2217, 100, 2, 70, 48, 0, "StyleData", "SB", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[58856, 2224, 119, 4, 70, 26, 0, "StyleData", "SBColor", "All",
 StyleMenuListing->None],
Cell[58978, 2230, 63, 1, 70, 38, 0, "StyleData", "SBColor", "Printout",
 StyleMenuListing->None],
Cell[59044, 2233, 98, 2, 70, 46, 0, "StyleData", "SBColor", \
"EnhancedPrintout"],
Cell[59145, 2237, 105, 2, 70, 53, 0, "StyleData", "SBColor", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[59287, 2244, 116, 4, 70, 22, 0, "StyleData", "SBO", "All",
 StyleMenuListing->None],
Cell[59406, 2250, 128, 4, 70, 34, 0, "StyleData", "SBO", "Printout",
 StyleMenuListing->None],
Cell[59537, 2256, 121, 3, 70, 42, 0, "StyleData", "SBO", "EnhancedPrintout"],
Cell[59661, 2261, 128, 3, 70, 49, 0, "StyleData", "SBO", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[59826, 2269, 135, 4, 70, 21, 0, "StyleData", "M4", "All",
 StyleMenuListing->None],
Cell[59964, 2275, 147, 4, 70, 33, 0, "StyleData", "M4", "Printout",
 StyleMenuListing->None],
Cell[60114, 2281, 155, 4, 70, 41, 0, "StyleData", "M4", "EnhancedPrintout",
 StyleMenuListing->None],
Cell[60272, 2287, 162, 4, 70, 48, 0, "StyleData", "M4", \
"EnhancedPrintoutNonGray",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[60471, 2296, 133, 5, 70, 23, 0, "StyleData", "SO10", "All",
 StyleMenuListing->None],
Cell[60607, 2303, 144, 5, 70, 35, 0, "StyleData", "SO10", "Printout",
 StyleMenuListing->None],
Cell[60754, 2310, 157, 5, 70, 43, 0, "StyleData", "SO10", "EnhancedPrintout",
 StyleMenuListing->None],
Cell[60914, 2317, 164, 5, 70, 50, 0, "StyleData", "SO10", \
"EnhancedPrintoutNonGray",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[61115, 2327, 108, 4, 70, 21, 0, "StyleData", "S9", "All",
 StyleMenuListing->None],
Cell[61226, 2333, 69, 2, 70, 33, 0, "StyleData", "S9", "Printout"],
Cell[61298, 2337, 108, 3, 70, 41, 0, "StyleData", "S9", "EnhancedPrintout"],
Cell[61409, 2342, 115, 3, 70, 48, 0, "StyleData", "S9", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[61561, 2350, 110, 4, 70, 22, 0, "StyleData", "S10", "All",
 StyleMenuListing->None],
Cell[61674, 2356, 71, 2, 70, 34, 0, "StyleData", "S10", "Printout"],
Cell[61748, 2360, 110, 3, 70, 42, 0, "StyleData", "S10", "EnhancedPrintout"],
Cell[61861, 2365, 117, 3, 70, 49, 0, "StyleData", "S10", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[62015, 2373, 162, 5, 70, 22, 0, "StyleData", "SB9", "All",
 StyleMenuListing->None],
Cell[62180, 2380, 48, 1, 70, 34, 0, "StyleData", "SB9", "Printout"],
Cell[62231, 2383, 108, 3, 70, 42, 0, "StyleData", "SB9", "EnhancedPrintout"],
Cell[62342, 2388, 115, 3, 70, 49, 0, "StyleData", "SB9", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[62494, 2396, 110, 4, 70, 23, 0, "StyleData", "SB10", "All",
 StyleMenuListing->None],
Cell[62607, 2402, 49, 1, 70, 35, 0, "StyleData", "SB10", "Printout"],
Cell[62659, 2405, 109, 3, 70, 43, 0, "StyleData", "SB10", \
"EnhancedPrintout"],
Cell[62771, 2410, 116, 3, 70, 50, 0, "StyleData", "SB10", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[62924, 2418, 245, 8, 70, 23, 0, "StyleData", "MR10", "All",
 StyleMenuListing->None],
Cell[63172, 2428, 49, 1, 70, 35, 0, "StyleData", "MR10", "Printout"],
Cell[63224, 2431, 85, 2, 70, 43, 0, "StyleData", "MR10", "EnhancedPrintout"],
Cell[63312, 2435, 92, 2, 70, 50, 0, "StyleData", "MR10", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[63441, 2442, 247, 8, 70, 23, 0, "StyleData", "MO10", "All",
 StyleMenuListing->None],
Cell[63691, 2452, 49, 1, 70, 35, 0, "StyleData", "MO10", "Printout"],
Cell[63743, 2455, 85, 2, 70, 43, 0, "StyleData", "MR10", "EnhancedPrintout"],
Cell[63831, 2459, 92, 2, 70, 50, 0, "StyleData", "MO10", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[63960, 2466, 79, 2, 70, 21, 0, "StyleData", "C1", "All",
 StyleMenuListing->None],
Cell[64042, 2470, 74, 2, 70, 33, 0, "StyleData", "C1", "Printout"],
Cell[64119, 2474, 107, 3, 70, 41, 0, "StyleData", "C1", "EnhancedPrintout"],
Cell[64229, 2479, 114, 3, 70, 48, 0, "StyleData", "C1", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[64380, 2487, 105, 3, 70, 23, 0, "StyleData", "C1MR", "All",
 StyleMenuListing->None],
Cell[64488, 2492, 76, 2, 70, 35, 0, "StyleData", "C1MR", "Printout"],
Cell[64567, 2496, 112, 3, 70, 43, 0, "StyleData", "C1MR", \
"EnhancedPrintout"],
Cell[64682, 2501, 119, 3, 70, 50, 0, "StyleData", "C1MR", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[64838, 2509, 74, 2, 70, 28, 0, "StyleData", "SmallCaps", "All",
 StyleMenuListing->None],
Cell[64915, 2513, 40, 0, 70, 40, 0, "StyleData", "SmallCaps", "Printout"],
Cell[64958, 2515, 73, 1, 70, 48, 0, "StyleData", "SmallCaps", \
"EnhancedPrintout"],
Cell[65034, 2518, 80, 1, 70, 55, 0, "StyleData", "SmallCaps", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[65151, 2524, 72, 2, 70, 32, 0, "StyleData", "KeyboardChars", "All",
 StyleMenuListing->None],
Cell[65226, 2528, 59, 1, 70, 44, 0, "StyleData", "KeyboardChars", \
"Printout"],
Cell[65288, 2531, 92, 2, 70, 52, 0, "StyleData", "KeyboardChars", \
"EnhancedPrintout"],
Cell[65383, 2535, 99, 2, 70, 59, 0, "StyleData", "KeyboardChars", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[65497, 2540, 62, 2, 70, 23, 0, "StyleData", "Tiny", "All",
 StyleMenuListing->None],
Cell[65562, 2544, 63, 2, 70, 24, 0, "StyleData", "Small", "All",
 StyleMenuListing->None],
Cell[65628, 2548, 65, 2, 70, 25, 0, "StyleData", "Medium", "All",
 StyleMenuListing->None],
Cell[65696, 2552, 64, 2, 70, 24, 0, "StyleData", "Large", "All",
 StyleMenuListing->None],
Cell[65763, 2556, 157, 4, 70, 32, 0, "StyleData", "PackageLoaded", "All",
 StyleMenuListing->None],
Cell[65923, 2562, 96, 3, 70, 35, 0, "StyleData", "PackageNotLoaded", "All",
 StyleMenuListing->None],
Cell[66022, 2567, 60, 1, 70, 35, 0, "StyleData", "FunctionTemplate", "All",
 StyleMenuListing->None],
Cell[66085, 2570, 67, 1, 70, 42, 0, "StyleData", "NoPrintFunctionTemplate", \
"All",
 StyleMenuListing->None],
Cell[CellGroupData[{
Cell[66177, 2575, 34, 0, 70, "Subsection"],
Cell[66214, 2577, 57, 1, 70, 32, 0, "StyleData", "HeadingNumber", "All",
 StyleMenuListing->None],
Cell[66274, 2580, 85, 2, 70, 32, 0, "StyleData", "NewInVersion6", "All",
 StyleMenuListing->None],
Cell[66362, 2584, 85, 2, 70, 32, 0, "StyleData", "NewInVersion6", "All",
 StyleMenuListing->None],
Cell[66450, 2588, 85, 2, 70, 32, 0, "StyleData", "ModInVersion6", "All",
 StyleMenuListing->None],
Cell[66538, 2592, 85, 2, 70, 32, 0, "StyleData", "ModInVersion5", "All",
 StyleMenuListing->None]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[66672, 2600, 46, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[66743, 2604, 553, 16, 70, 22, 0, "StyleData", "Box", "All",
 StyleMenuListing->None],
Cell[67299, 2622, 53, 1, 70, 38, 0, "StyleData", "Box", "Presentation"],
Cell[67355, 2625, 146, 4, 70, 34, 0, "StyleData", "Box", "Printout"],
Cell[67504, 2631, 154, 4, 70, 42, 0, "StyleData", "Box", "EnhancedPrintout"],
Cell[67661, 2637, 154, 4, 70, 49, 0, "StyleData", "Box", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[67852, 2646, 678, 20, 70, 28, 0, "StyleData", "DoubleBox", "All",
 StyleMenuListing->None],
Cell[68533, 2668, 59, 1, 70, 44, 0, "StyleData", "DoubleBox", \
"Presentation"],
Cell[68595, 2671, 152, 4, 70, 40, 0, "StyleData", "DoubleBox", "Printout"],
Cell[68750, 2677, 160, 4, 70, 48, 0, "StyleData", "DoubleBox", \
"EnhancedPrintout"],
Cell[68913, 2683, 160, 4, 70, 55, 0, "StyleData", "DoubleBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[69110, 2692, 576, 17, 70, 29, 0, "StyleData", "1ColumnBox", "All",
 StyleMenuListing->None],
Cell[69689, 2711, 60, 1, 70, 45, 0, "StyleData", "1ColumnBox", \
"Presentation"],
Cell[69752, 2714, 153, 4, 70, 41, 0, "StyleData", "1ColumnBox", "Printout"],
Cell[69908, 2720, 161, 4, 70, 49, 0, "StyleData", "1ColumnBox", \
"EnhancedPrintout"],
Cell[70072, 2726, 161, 4, 70, 56, 0, "StyleData", "1ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[70270, 2735, 536, 15, 70, 29, 0, "StyleData", "2ColumnBox", "All",
 StyleMenuListing->None],
Cell[70809, 2752, 60, 1, 70, 45, 0, "StyleData", "2ColumnBox", \
"Presentation"],
Cell[70872, 2755, 152, 4, 70, 41, 0, "StyleData", "2ColumnBox", "Printout"],
Cell[71027, 2761, 160, 4, 70, 49, 0, "StyleData", "2ColumnBox", \
"EnhancedPrintout"],
Cell[71190, 2767, 160, 4, 70, 56, 0, "StyleData", "2ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[71387, 2776, 491, 13, 70, 33, 0, "StyleData", "2ColumnEvenBox", "All",
 StyleMenuListing->None],
Cell[71881, 2791, 64, 1, 70, 49, 0, "StyleData", "2ColumnEvenBox", \
"Presentation"],
Cell[71948, 2794, 157, 4, 70, 45, 0, "StyleData", "2ColumnEvenBox", \
"Printout"],
Cell[72108, 2800, 165, 4, 70, 53, 0, "StyleData", "2ColumnEvenBox", \
"EnhancedPrintout"],
Cell[72276, 2806, 165, 4, 70, 60, 0, "StyleData", "2ColumnEvenBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[72478, 2815, 836, 24, 70, 34, 0, "StyleData", "2ColumnSmallBox", "All",
 StyleMenuListing->None],
Cell[73317, 2841, 65, 1, 70, 50, 0, "StyleData", "2ColumnSmallBox", \
"Presentation"],
Cell[73385, 2844, 158, 4, 70, 46, 0, "StyleData", "2ColumnSmallBox", \
"Printout"],
Cell[73546, 2850, 166, 4, 70, 54, 0, "StyleData", "2ColumnSmallBox", \
"EnhancedPrintout"],
Cell[73715, 2856, 166, 4, 70, 61, 0, "StyleData", "2ColumnSmallBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[73918, 2865, 487, 13, 70, 29, 0, "StyleData", "3ColumnBox", "All",
 StyleMenuListing->None],
Cell[74408, 2880, 60, 1, 70, 45, 0, "StyleData", "3ColumnBox", \
"Presentation"],
Cell[74471, 2883, 153, 4, 70, 41, 0, "StyleData", "3ColumnBox", "Printout"],
Cell[74627, 2889, 161, 4, 70, 49, 0, "StyleData", "3ColumnBox", \
"EnhancedPrintout"],
Cell[74791, 2895, 161, 4, 70, 56, 0, "StyleData", "3ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[74989, 2904, 844, 24, 70, 34, 0, "StyleData", "3ColumnSmallBox", "All",
 StyleMenuListing->None],
Cell[75836, 2930, 65, 1, 70, 50, 0, "StyleData", "3ColumnSmallBox", \
"Presentation"],
Cell[75904, 2933, 158, 4, 70, 46, 0, "StyleData", "3ColumnSmallBox", \
"Printout"],
Cell[76065, 2939, 166, 4, 70, 54, 0, "StyleData", "3ColumnSmallBox", \
"EnhancedPrintout"],
Cell[76234, 2945, 183, 5, 70, 61, 0, "StyleData", "3ColumnSmallBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[76454, 2955, 576, 17, 70, 29, 0, "StyleData", "4ColumnBox", "All",
 StyleMenuListing->None],
Cell[77033, 2974, 60, 1, 70, 45, 0, "StyleData", "4ColumnBox", \
"Presentation"],
Cell[77096, 2977, 153, 4, 70, 41, 0, "StyleData", "4ColumnBox", "Printout"],
Cell[77252, 2983, 161, 4, 70, 49, 0, "StyleData", "4ColumnBox", \
"EnhancedPrintout"],
Cell[77416, 2989, 161, 4, 70, 56, 0, "StyleData", "4ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[77614, 2998, 488, 13, 70, 29, 0, "StyleData", "5ColumnBox", "All",
 StyleMenuListing->None],
Cell[78105, 3013, 60, 1, 70, 45, 0, "StyleData", "5ColumnBox", \
"Presentation"],
Cell[78168, 3016, 152, 4, 70, 41, 0, "StyleData", "5ColumnBox", "Printout"],
Cell[78323, 3022, 160, 4, 70, 49, 0, "StyleData", "5ColumnBox", \
"EnhancedPrintout"],
Cell[78486, 3028, 160, 4, 70, 56, 0, "StyleData", "5ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[78683, 3037, 587, 18, 70, 29, 0, "StyleData", "6ColumnBox", "All",
 StyleMenuListing->None],
Cell[79273, 3057, 60, 1, 70, 45, 0, "StyleData", "6ColumnBox", \
"Presentation"],
Cell[79336, 3060, 153, 4, 70, 41, 0, "StyleData", "6ColumnBox", "Printout"],
Cell[79492, 3066, 161, 4, 70, 49, 0, "StyleData", "6ColumnBox", \
"EnhancedPrintout"],
Cell[79656, 3072, 161, 4, 70, 56, 0, "StyleData", "6ColumnBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[79854, 3081, 705, 22, 70, 28, 0, "StyleData", "FramedBox", "All"],
Cell[80562, 3105, 59, 1, 70, 44, 0, "StyleData", "FramedBox", \
"Presentation"],
Cell[80624, 3108, 145, 4, 70, 40, 0, "StyleData", "FramedBox", "Printout"],
Cell[80772, 3114, 178, 5, 70, 48, 0, "StyleData", "FramedBox", \
"EnhancedPrintout"],
Cell[80953, 3121, 185, 5, 70, 55, 0, "StyleData", "FramedBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[81175, 3131, 851, 26, 70, 32, 0, "StyleData", "DefinitionBox", "All"],
Cell[82029, 3159, 63, 1, 70, 48, 0, "StyleData", "DefinitionBox", \
"Presentation"],
Cell[82095, 3162, 149, 4, 70, 44, 0, "StyleData", "DefinitionBox", \
"Printout"],
Cell[82247, 3168, 182, 5, 70, 52, 0, "StyleData", "DefinitionBox", \
"EnhancedPrintout"],
Cell[82432, 3175, 189, 5, 70, 59, 0, "StyleData", "DefinitionBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[82658, 3185, 876, 27, 70, 36, 0, "StyleData", "DefinitionBox3Col", \
"All"],
Cell[83537, 3214, 67, 1, 70, 52, 0, "StyleData", "DefinitionBox3Col", \
"Presentation"],
Cell[83607, 3217, 153, 4, 70, 48, 0, "StyleData", "DefinitionBox3Col", \
"Printout"],
Cell[83763, 3223, 186, 5, 70, 56, 0, "StyleData", "DefinitionBox3Col", \
"EnhancedPrintout"],
Cell[83952, 3230, 193, 5, 70, 63, 0, "StyleData", "DefinitionBox3Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[84182, 3240, 897, 28, 70, 36, 0, "StyleData", "DefinitionBox4Col", \
"All"],
Cell[85082, 3270, 67, 1, 70, 52, 0, "StyleData", "DefinitionBox4Col", \
"Presentation"],
Cell[85152, 3273, 153, 4, 70, 48, 0, "StyleData", "DefinitionBox4Col", \
"Printout"],
Cell[85308, 3279, 186, 5, 70, 56, 0, "StyleData", "DefinitionBox4Col", \
"EnhancedPrintout"],
Cell[85497, 3286, 193, 5, 70, 63, 0, "StyleData", "DefinitionBox4Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[85727, 3296, 893, 28, 70, 34, 0, "StyleData", "PrecedenceTable", "All"],
Cell[86623, 3326, 65, 1, 70, 50, 0, "StyleData", "PrecedenceTable", \
"Presentation"],
Cell[86691, 3329, 151, 4, 70, 46, 0, "StyleData", "PrecedenceTable", \
"Printout"],
Cell[86845, 3335, 184, 5, 70, 54, 0, "StyleData", "PrecedenceTable", \
"EnhancedPrintout"],
Cell[87032, 3342, 191, 5, 70, 61, 0, "StyleData", "PrecedenceTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[87260, 3352, 836, 25, 70, 36, 0, "StyleData", "DefinitionBox5Col", \
"All"],
Cell[88099, 3379, 67, 1, 70, 52, 0, "StyleData", "DefinitionBox5Col", \
"Presentation"],
Cell[88169, 3382, 153, 4, 70, 48, 0, "StyleData", "DefinitionBox5Col", \
"Printout"],
Cell[88325, 3388, 186, 5, 70, 56, 0, "StyleData", "DefinitionBox5Col", \
"EnhancedPrintout"],
Cell[88514, 3395, 193, 5, 70, 63, 0, "StyleData", "DefinitionBox5Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[88744, 3405, 937, 30, 70, 36, 0, "StyleData", "DefinitionBox6Col", \
"All"],
Cell[89684, 3437, 67, 1, 70, 52, 0, "StyleData", "DefinitionBox6Col", \
"Presentation"],
Cell[89754, 3440, 153, 4, 70, 48, 0, "StyleData", "DefinitionBox6Col", \
"Printout"],
Cell[89910, 3446, 186, 5, 70, 56, 0, "StyleData", "DefinitionBox6Col", \
"EnhancedPrintout"],
Cell[90099, 3453, 193, 5, 70, 63, 0, "StyleData", "DefinitionBox6Col", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[90329, 3463, 889, 27, 70, 25, 0, "StyleData", "TopBox", "All",
 StyleMenuListing->None],
Cell[91221, 3492, 56, 1, 70, 41, 0, "StyleData", "TopBox", "Presentation"],
Cell[91280, 3495, 127, 3, 70, 37, 0, "StyleData", "TopBox", "Printout"],
Cell[91410, 3500, 160, 4, 70, 45, 0, "StyleData", "TopBox", \
"EnhancedPrintout"],
Cell[91573, 3506, 167, 4, 70, 52, 0, "StyleData", "TopBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[91777, 3515, 915, 28, 70, 28, 0, "StyleData", "MiddleBox", "All",
 StyleMenuListing->None],
Cell[92695, 3545, 59, 1, 70, 44, 0, "StyleData", "MiddleBox", \
"Presentation"],
Cell[92757, 3548, 130, 3, 70, 40, 0, "StyleData", "MiddleBox", "Printout"],
Cell[92890, 3553, 163, 4, 70, 48, 0, "StyleData", "MiddleBox", \
"EnhancedPrintout"],
Cell[93056, 3559, 170, 4, 70, 55, 0, "StyleData", "MiddleBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[93263, 3568, 917, 28, 70, 28, 0, "StyleData", "BottomBox", "All",
 StyleMenuListing->None],
Cell[94183, 3598, 59, 1, 70, 44, 0, "StyleData", "BottomBox", \
"Presentation"],
Cell[94245, 3601, 279, 8, 70, 40, 0, "StyleData", "BottomBox", "Printout"],
Cell[94527, 3611, 312, 9, 70, 48, 0, "StyleData", "BottomBox", \
"EnhancedPrintout"],
Cell[94842, 3622, 319, 9, 70, 55, 0, "StyleData", "BottomBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[95198, 3636, 893, 27, 70, 29, 0, "StyleData", "TopSpanBox", "All",
 StyleMenuListing->None],
Cell[96094, 3665, 60, 1, 70, 45, 0, "StyleData", "TopSpanBox", \
"Presentation"],
Cell[96157, 3668, 147, 4, 70, 41, 0, "StyleData", "TopSpanBox", "Printout"],
Cell[96307, 3674, 180, 5, 70, 49, 0, "StyleData", "TopSpanBox", \
"EnhancedPrintout"],
Cell[96490, 3681, 187, 5, 70, 56, 0, "StyleData", "TopSpanBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[96714, 3691, 917, 28, 70, 32, 0, "StyleData", "MiddleSpanBox", "All",
 StyleMenuListing->None],
Cell[97634, 3721, 63, 1, 70, 48, 0, "StyleData", "MiddleSpanBox", \
"Presentation"],
Cell[97700, 3724, 283, 8, 70, 44, 0, "StyleData", "MiddleSpanBox", \
"Printout"],
Cell[97986, 3734, 316, 9, 70, 52, 0, "StyleData", "MiddleSpanBox", \
"EnhancedPrintout"],
Cell[98305, 3745, 323, 9, 70, 59, 0, "StyleData", "MiddleSpanBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[98665, 3759, 164, 4, 70, 26, 0, "StyleData", "Picture", "All",
 StyleMenuListing->None],
Cell[98832, 3765, 57, 1, 70, 42, 0, "StyleData", "Picture", "Presentation"],
Cell[98892, 3768, 100, 2, 70, 38, 0, "StyleData", "Picture", "Printout"],
Cell[98995, 3772, 108, 2, 70, 46, 0, "StyleData", "Picture", \
"EnhancedPrintout"],
Cell[99106, 3776, 115, 2, 70, 53, 0, "StyleData", "Picture", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[99258, 3783, 227, 5, 70, 43, 0, "StyleData", "OpenCloseItemizedPicture", \
"All",
 StyleMenuListing->None],
Cell[99488, 3790, 74, 1, 70, 59, 0, "StyleData", "OpenCloseItemizedPicture", \
"Presentation"],
Cell[99565, 3793, 174, 4, 70, 55, 0, "StyleData", "OpenCloseItemizedPicture", \
"Printout"],
Cell[99742, 3799, 182, 4, 70, 63, 0, "StyleData", "OpenCloseItemizedPicture", \
"EnhancedPrintout"],
Cell[99927, 3805, 189, 4, 70, 70, 0, "StyleData", "OpenCloseItemizedPicture", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[100153, 3814, 164, 4, 70, 34, 0, "StyleData", "ItemizedPicture", "All",
 StyleMenuListing->None],
Cell[100320, 3820, 65, 1, 70, 50, 0, "StyleData", "ItemizedPicture", \
"Presentation"],
Cell[100388, 3823, 101, 2, 70, 46, 0, "StyleData", "ItemizedPicture", \
"Printout"],
Cell[100492, 3827, 110, 2, 70, 54, 0, "StyleData", "ItemizedPicture", \
"EnhancedPrintout"],
Cell[100605, 3831, 116, 2, 70, 61, 0, "StyleData", "ItemizedPicture", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[100758, 3838, 160, 4, 70, 30, 0, "StyleData", "ListGraphic", "All",
 StyleMenuListing->None],
Cell[100921, 3844, 61, 1, 70, 46, 0, "StyleData", "ListGraphic", \
"Presentation"],
Cell[100985, 3847, 97, 2, 70, 42, 0, "StyleData", "ListGraphic", "Printout"],
Cell[101085, 3851, 106, 2, 70, 50, 0, "StyleData", "ListGraphic", \
"EnhancedPrintout"],
Cell[101194, 3855, 112, 2, 70, 57, 0, "StyleData", "ListGraphic", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[101343, 3862, 577, 16, 70, 30, 0, "StyleData", "ListNoteBox", "All",
 StyleMenuListing->None],
Cell[101923, 3880, 61, 1, 70, 46, 0, "StyleData", "ListNoteBox", \
"Presentation"],
Cell[101987, 3883, 124, 3, 70, 42, 0, "StyleData", "ListNoteBox", \
"Printout"],
Cell[102114, 3888, 163, 4, 70, 50, 0, "StyleData", "ListNoteBox", \
"EnhancedPrintout"],
Cell[102280, 3894, 163, 4, 70, 57, 0, "StyleData", "ListNoteBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[102480, 3903, 161, 4, 70, 31, 0, "StyleData", "PictureGroup", "All",
 StyleMenuListing->None],
Cell[102644, 3909, 62, 1, 70, 47, 0, "StyleData", "PictureGroup", \
"Presentation"],
Cell[102709, 3912, 162, 4, 70, 43, 0, "StyleData", "PictureGroup", \
"Printout"],
Cell[102874, 3918, 170, 4, 70, 51, 0, "StyleData", "PictureGroup", \
"EnhancedPrintout"],
Cell[103047, 3924, 177, 4, 70, 58, 0, "StyleData", "PictureGroup", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[103261, 3933, 114, 3, 70, 24, 0, "StyleData", "Sound", "All",
 StyleMenuListing->None],
Cell[103378, 3938, 55, 1, 70, 40, 0, "StyleData", "Sound", "Presentation"],
Cell[103436, 3941, 83, 2, 70, 36, 0, "StyleData", "Sound", "Printout"],
Cell[103522, 3945, 91, 2, 70, 44, 0, "StyleData", "Sound", \
"EnhancedPrintout"],
Cell[103616, 3949, 98, 2, 70, 51, 0, "StyleData", "Sound", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[103751, 3956, 148, 5, 70, 26, 0, "StyleData", "Caption", "All",
 StyleMenuListing->None],
Cell[103902, 3963, 57, 1, 70, 42, 0, "StyleData", "Caption", "Presentation"],
Cell[103962, 3966, 84, 2, 70, 38, 0, "StyleData", "Caption", "Printout"],
Cell[104049, 3970, 123, 3, 70, 46, 0, "StyleData", "Caption", \
"EnhancedPrintout"],
Cell[104175, 3975, 131, 3, 70, 53, 0, "StyleData", "Caption", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[104321, 3981, 244, 8, 70, 29, 0, "StyleData", "HeaderCell", "All",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[104602, 3994, 25, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[104652, 3998, 422, 12, 70, 31, 0, "StyleData", "2ColumnTable", "All",
 StyleMenuListing->None],
Cell[105077, 4012, 62, 1, 70, 47, 0, "StyleData", "2ColumnTable", \
"Presentation"],
Cell[105142, 4015, 89, 2, 70, 43, 0, "StyleData", "2ColumnTable", \
"Printout"],
Cell[105234, 4019, 97, 2, 70, 51, 0, "StyleData", "2ColumnTable", \
"EnhancedPrintout"],
Cell[105334, 4023, 104, 2, 70, 58, 0, "StyleData", "2ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[105475, 4030, 406, 11, 70, 35, 0, "StyleData", "2ColumnEvenTable", "All",
 
 StyleMenuListing->None],
Cell[105884, 4043, 66, 1, 70, 51, 0, "StyleData", "2ColumnEvenTable", \
"Presentation"],
Cell[105953, 4046, 93, 2, 70, 47, 0, "StyleData", "2ColumnEvenTable", \
"Printout"],
Cell[106049, 4050, 101, 2, 70, 55, 0, "StyleData", "2ColumnEvenTable", \
"EnhancedPrintout"],
Cell[106153, 4054, 108, 2, 70, 62, 0, "StyleData", "2ColumnEvenTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[106298, 4061, 442, 13, 70, 31, 0, "StyleData", "3ColumnTable", "All",
 StyleMenuListing->None],
Cell[106743, 4076, 62, 1, 70, 47, 0, "StyleData", "3ColumnTable", \
"Presentation"],
Cell[106808, 4079, 89, 2, 70, 43, 0, "StyleData", "3ColumnTable", \
"Printout"],
Cell[106900, 4083, 97, 2, 70, 51, 0, "StyleData", "3ColumnTable", \
"EnhancedPrintout"],
Cell[107000, 4087, 104, 2, 70, 58, 0, "StyleData", "3ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[107153, 4095, 43, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[107221, 4099, 355, 10, 70, 32, 0, "StyleData", "InlineFormula", "All",
 StyleMenuListing->None],
Cell[107579, 4111, 91, 2, 70, 44, 0, "StyleData", "InlineFormula", \
"Printout"],
Cell[107673, 4115, 99, 2, 70, 52, 0, "StyleData", "InlineFormula", \
"EnhancedPrintout"],
Cell[107775, 4119, 106, 2, 70, 59, 0, "StyleData", "InlineFormula", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[107918, 4126, 284, 7, 70, 31, 0, "StyleData", "InlineOutput", "All",
 StyleMenuListing->None],
Cell[108205, 4135, 91, 2, 70, 43, 0, "StyleData", "InlineOutput", \
"Printout"],
Cell[108299, 4139, 99, 2, 70, 51, 0, "StyleData", "InlineOutput", \
"EnhancedPrintout"],
Cell[108401, 4143, 106, 2, 70, 58, 0, "StyleData", "InlineOutput", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[108544, 4150, 546, 14, 70, 33, 0, "StyleData", "DisplayFormula", "All",
 StyleMenuListing->None],
Cell[109093, 4166, 64, 1, 70, 49, 0, "StyleData", "DisplayFormula", \
"Presentation"],
Cell[109160, 4169, 45, 0, 70, 45, 0, "StyleData", "DisplayFormula", \
"Printout"],
Cell[109208, 4171, 78, 1, 70, 53, 0, "StyleData", "DisplayFormula", \
"EnhancedPrintout"],
Cell[109289, 4174, 85, 1, 70, 60, 0, "StyleData", "DisplayFormula", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[109411, 4180, 521, 15, 70, 30, 0, "StyleData", "DisplayMath", "All",
 CounterIncrements->"Input"],
Cell[109935, 4197, 61, 1, 70, 46, 0, "StyleData", "DisplayMath", \
"Presentation"],
Cell[109999, 4200, 89, 2, 70, 42, 0, "StyleData", "DisplayMath", "Printout"],
Cell[110091, 4204, 124, 3, 70, 50, 0, "StyleData", "DisplayMath", \
"EnhancedPrintout"],
Cell[110218, 4209, 131, 3, 70, 57, 0, "StyleData", "DisplayMath", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[110386, 4217, 383, 10, 70, 35, 0, "StyleData", "NumberedEquation", "All",
 
 CounterIncrements->"NumberedEquation"],
Cell[110772, 4229, 66, 1, 70, 51, 0, "StyleData", "NumberedEquation", \
"Presentation"],
Cell[110841, 4232, 97, 2, 70, 47, 0, "StyleData", "NumberedEquation", \
"Printout"],
Cell[110941, 4236, 130, 3, 70, 55, 0, "StyleData", "NumberedEquation", \
"EnhancedPrintout"],
Cell[111074, 4241, 137, 3, 70, 62, 0, "StyleData", "NumberedEquation", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[111248, 4249, 145, 3, 70, 33, 0, "StyleData", "EquationNumber", "All"],
Cell[111396, 4254, 64, 1, 70, 49, 0, "StyleData", "EquationNumber", \
"Presentation"],
Cell[111463, 4257, 69, 1, 70, 45, 0, "StyleData", "EquationNumber", \
"Printout"],
Cell[111535, 4260, 102, 2, 70, 53, 0, "StyleData", "EquationNumber", \
"EnhancedPrintout"],
Cell[111640, 4264, 109, 2, 70, 60, 0, "StyleData", "EquationNumber", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[111786, 4271, 219, 6, 70, 26, 0, "StyleData", "Program", "All"],
Cell[112008, 4279, 57, 1, 70, 42, 0, "StyleData", "Program", "Presentation"],
Cell[112068, 4282, 96, 2, 70, 38, 0, "StyleData", "Program", "Printout"],
Cell[112167, 4286, 131, 3, 70, 46, 0, "StyleData", "Program", \
"EnhancedPrintout"],
Cell[112301, 4291, 138, 3, 70, 53, 0, "StyleData", "Program", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[112488, 4300, 45, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[112558, 4304, 46, 3, 70, "Subsection"],
Cell[CellGroupData[{
Cell[112629, 4311, 306, 9, 70, 34, 0, "StyleData", "InspectorLevel1", "All",
 StyleMenuListing->None],
Cell[112938, 4322, 65, 1, 70, 50, 0, "StyleData", "InspectorLevel1", \
"Presentation"],
Cell[113006, 4325, 99, 1, 70, 47, 0, "StyleData", "InspectorLevel1", \
"SlideShow"],
Cell[113108, 4328, 113, 2, 70, 46, 0, "StyleData", "InspectorLevel1", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[113258, 4335, 238, 7, 70, 34, 0, "StyleData", "InspectorLevel2", "All",
 StyleMenuListing->None],
Cell[113499, 4344, 65, 1, 70, 50, 0, "StyleData", "InspectorLevel2", \
"Presentation"],
Cell[113567, 4347, 295, 8, 70, 47, 0, "StyleData", "InspectorLevel2", \
"SlideShow"],
Cell[113865, 4357, 113, 2, 70, 46, 0, "StyleData", "InspectorLevel2", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[114015, 4364, 424, 11, 70, 29, 0, "StyleData", "ObjectName", "All",
 StyleMenuListing->None],
Cell[114442, 4377, 60, 1, 70, 45, 0, "StyleData", "ObjectName", \
"Presentation"],
Cell[114505, 4380, 258, 7, 70, 42, 0, "StyleData", "ObjectName", "SlideShow",
 StyleMenuListing->None],
Cell[114766, 4389, 195, 4, 70, 41, 0, "StyleData", "ObjectName", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[114998, 4398, 339, 9, 70, 38, 0, "StyleData", "SubObjectNameClosed", \
"All",
 StyleMenuListing->None],
Cell[115340, 4409, 69, 1, 70, 54, 0, "StyleData", "SubObjectNameClosed", \
"Presentation"],
Cell[115412, 4412, 222, 6, 70, 51, 0, "StyleData", "SubObjectNameClosed", \
"SlideShow",
 StyleMenuListing->None],
Cell[115637, 4420, 150, 3, 70, 50, 0, "StyleData", "SubObjectNameClosed", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[115824, 4428, 234, 7, 70, 32, 0, "StyleData", "SubObjectName", "All",
 StyleMenuListing->None],
Cell[116061, 4437, 63, 1, 70, 48, 0, "StyleData", "SubObjectName", \
"Presentation"],
Cell[116127, 4440, 201, 5, 70, 45, 0, "StyleData", "SubObjectName", \
"SlideShow"],
Cell[116331, 4447, 168, 4, 70, 44, 0, "StyleData", "SubObjectName", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[116536, 4456, 236, 7, 70, 34, 0, "StyleData", "GroupObjectName", "All",
 StyleMenuListing->None],
Cell[116775, 4465, 65, 1, 70, 50, 0, "StyleData", "GroupObjectName", \
"Presentation"],
Cell[116843, 4468, 325, 9, 70, 47, 0, "StyleData", "GroupObjectName", \
"SlideShow",
 CounterIncrements->"Outline2"],
Cell[117171, 4479, 113, 2, 70, 46, 0, "StyleData", "GroupObjectName", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[117321, 4486, 341, 9, 70, 40, 0, "StyleData", "GroupObjectNameClosed", \
"All",
 StyleMenuListing->None],
Cell[117665, 4497, 71, 1, 70, 56, 0, "StyleData", "GroupObjectNameClosed", \
"Presentation"],
Cell[117739, 4500, 331, 9, 70, 53, 0, "StyleData", "GroupObjectNameClosed", \
"SlideShow",
 CounterIncrements->"Outline2"],
Cell[118073, 4511, 119, 2, 70, 52, 0, "StyleData", "GroupObjectNameClosed", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[118229, 4518, 260, 7, 70, 44, 0, "StyleData", \
"ObjectNameWarningMessages", "All",
 StyleMenuListing->None],
Cell[118492, 4527, 75, 1, 70, 60, 0, "StyleData", \
"ObjectNameWarningMessages", "Presentation"],
Cell[118570, 4530, 248, 6, 70, 57, 0, "StyleData", \
"ObjectNameWarningMessages", "SlideShow"],
Cell[118821, 4538, 156, 3, 70, 56, 0, "StyleData", \
"ObjectNameWarningMessages", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[119014, 4546, 409, 11, 70, 26, 0, "StyleData", "Command", "All",
 CounterIncrements->"Section",
 StyleMenuListing->None],
Cell[119426, 4559, 57, 1, 70, 42, 0, "StyleData", "Command", "Presentation"],
Cell[119486, 4562, 216, 5, 70, 38, 0, "StyleData", "Command", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[119739, 4572, 321, 7, 70, 32, 0, "StyleData", "CharacterName", "All",
 StyleMenuListing->None],
Cell[120063, 4581, 63, 1, 70, 48, 0, "StyleData", "CharacterName", \
"Presentation"],
Cell[120129, 4584, 261, 7, 70, 45, 0, "StyleData", "CharacterName", \
"SlideShow",
 StyleMenuListing->None],
Cell[120393, 4593, 143, 3, 70, 44, 0, "StyleData", "CharacterName", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[120573, 4601, 384, 10, 70, 24, 0, "StyleData", "Usage", "All",
 StyleMenuListing->None],
Cell[120960, 4613, 55, 1, 70, 40, 0, "StyleData", "Usage", "Presentation"],
Cell[121018, 4616, 253, 7, 70, 37, 0, "StyleData", "Usage", "SlideShow",
 StyleMenuListing->None],
Cell[121274, 4625, 236, 6, 70, 36, 0, "StyleData", "Usage", "Printout",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[121547, 4636, 547, 16, 70, 31, 0, "StyleData", "ErrorMessage", "All",
 StyleMenuListing->None],
Cell[122097, 4654, 62, 1, 70, 47, 0, "StyleData", "ErrorMessage", \
"Presentation"],
Cell[122162, 4657, 186, 4, 70, 44, 0, "StyleData", "ErrorMessage", \
"SlideShow",
 StyleMenuListing->None],
Cell[122351, 4663, 135, 3, 70, 43, 0, "StyleData", "ErrorMessage", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[122523, 4671, 239, 7, 70, 24, 0, "StyleData", "Notes", "All",
 StyleMenuListing->None],
Cell[122765, 4680, 55, 1, 70, 40, 0, "StyleData", "Notes", "Presentation"],
Cell[122823, 4683, 251, 7, 70, 37, 0, "StyleData", "Notes", "SlideShow",
 StyleMenuListing->None],
Cell[123077, 4692, 155, 4, 70, 36, 0, "StyleData", "Notes", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[123269, 4701, 185, 6, 70, 28, 0, "StyleData", "NotesList", "All",
 StyleMenuListing->None],
Cell[123457, 4709, 59, 1, 70, 44, 0, "StyleData", "NotesList", \
"Presentation"],
Cell[123519, 4712, 250, 7, 70, 41, 0, "StyleData", "NotesList", "SlideShow",
 StyleMenuListing->None],
Cell[123772, 4721, 159, 4, 70, 40, 0, "StyleData", "NotesList", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[123968, 4730, 324, 9, 70, 35, 0, "StyleData", "ReferenceSection", "All",
 StyleMenuListing->None],
Cell[124295, 4741, 66, 1, 70, 51, 0, "StyleData", "ReferenceSection", \
"Presentation"],
Cell[124364, 4744, 196, 5, 70, 47, 0, "StyleData", "ReferenceSection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[124597, 4754, 1093, 27, 70, 28, 0, "StyleData", "Reference", "All",
 CounterIncrements->"Reference"],
Cell[125693, 4783, 59, 1, 70, 44, 0, "StyleData", "Reference", \
"Presentation"],
Cell[125755, 4786, 111, 3, 70, 41, 0, "StyleData", "Reference", "SlideShow"],
Cell[125869, 4791, 130, 4, 70, 40, 0, "StyleData", "Reference", "Printout"],
Cell[126002, 4797, 163, 5, 70, 48, 0, "StyleData", "Reference", \
"EnhancedPrintout"],
Cell[126168, 4804, 170, 5, 70, 55, 0, "StyleData", "Reference", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[126375, 4814, 323, 9, 70, 34, 0, "StyleData", "MessagesSection", "All",
 StyleMenuListing->None],
Cell[126701, 4825, 65, 1, 70, 50, 0, "StyleData", "MessagesSection", \
"Presentation"],
Cell[126769, 4828, 195, 5, 70, 46, 0, "StyleData", "MessagesSection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[127001, 4838, 345, 9, 70, 34, 0, "StyleData", "TemplateSection", "All",
 StyleMenuListing->None],
Cell[127349, 4849, 65, 1, 70, 50, 0, "StyleData", "TemplateSection", \
"Presentation"],
Cell[127417, 4852, 195, 5, 70, 46, 0, "StyleData", "TemplateSection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[127649, 4862, 311, 9, 70, 27, 0, "StyleData", "LineHead", "All",
 CounterIncrements->"Subsection",
 CounterAssignments->{{"Subsubsection", 0}},
 StyleMenuListing->None],
Cell[127963, 4873, 58, 1, 70, 43, 0, "StyleData", "LineHead", \
"Presentation"],
Cell[128024, 4876, 163, 4, 70, 39, 0, "StyleData", "LineHead", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[128224, 4885, 573, 17, 70, 29, 0, "StyleData", "FlushInput", "All",
 StyleMenuListing->None],
Cell[128800, 4904, 60, 1, 70, 45, 0, "StyleData", "FlushInput", \
"Presentation"],
Cell[128863, 4907, 140, 3, 70, 41, 0, "StyleData", "FlushInput", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[129040, 4915, 526, 14, 70, 30, 0, "StyleData", "FlushOutput", "All",
 StyleMenuListing->None],
Cell[129569, 4931, 61, 1, 70, 46, 0, "StyleData", "FlushOutput", \
"Presentation"],
Cell[129633, 4934, 165, 3, 70, 42, 0, "StyleData", "FlushOutput", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[129835, 4942, 280, 8, 70, 29, 0, "StyleData", "DialogItem", "All",
 StyleMenuListing->None],
Cell[130118, 4952, 60, 1, 70, 45, 0, "StyleData", "DialogItem", \
"Presentation"],
Cell[130181, 4955, 165, 4, 70, 41, 0, "StyleData", "DialogItem", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[130383, 4964, 233, 5, 70, 31, 0, "StyleData", "GroupDivider", "All",
 StyleMenuListing->None],
Cell[130619, 4971, 62, 1, 70, 47, 0, "StyleData", "GroupDivider", \
"Presentation"]
}, Closed]],
Cell[CellGroupData[{
Cell[130718, 4977, 269, 8, 70, 28, 0, "StyleData", "Highlight", "All",
 StyleMenuListing->None],
Cell[130990, 4987, 59, 1, 70, 44, 0, "StyleData", "Highlight", \
"Presentation"],
Cell[131052, 4990, 181, 5, 70, 40, 0, "StyleData", "Highlight", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[131270, 5000, 235, 7, 70, 28, 0, "StyleData", "UserNotes", "All",
 StyleMenuListing->None],
Cell[131508, 5009, 59, 1, 70, 44, 0, "StyleData", "UserNotes", \
"Presentation"],
Cell[131570, 5012, 180, 5, 70, 40, 0, "StyleData", "UserNotes", "Printout"],
Cell[131753, 5019, 167, 5, 70, 48, 0, "StyleData", "UserNotes", \
"EnhancedPrintout"],
Cell[131923, 5026, 174, 5, 70, 55, 0, "StyleData", "UserNotes", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[132134, 5036, 275, 8, 70, 27, 0, "StyleData", "MoreInfo", "All",
 StyleMenuListing->None],
Cell[132412, 5046, 58, 1, 70, 43, 0, "StyleData", "MoreInfo", \
"Presentation"],
Cell[132473, 5049, 179, 5, 70, 39, 0, "StyleData", "MoreInfo", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[132689, 5059, 275, 8, 70, 27, 0, "StyleData", "UserTips", "All",
 StyleMenuListing->None],
Cell[132967, 5069, 58, 1, 70, 43, 0, "StyleData", "UserTips", \
"Presentation"],
Cell[133028, 5072, 251, 7, 70, 39, 0, "StyleData", "UserTips", "Printout"],
Cell[133282, 5081, 283, 8, 70, 47, 0, "StyleData", "UserTips", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[133602, 5094, 252, 7, 70, 26, 0, "StyleData", "Theorem", "All"],
Cell[133857, 5103, 57, 1, 70, 42, 0, "StyleData", "Theorem", "Presentation"],
Cell[133917, 5106, 218, 6, 70, 38, 0, "StyleData", "Theorem", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[134172, 5117, 221, 7, 70, 29, 0, "StyleData", "Commentary", "All"],
Cell[134396, 5126, 60, 1, 70, 45, 0, "StyleData", "Commentary", \
"Presentation"],
Cell[134459, 5129, 122, 3, 70, 41, 0, "StyleData", "Commentary", "Printout"],
Cell[134584, 5134, 155, 4, 70, 49, 0, "StyleData", "Commentary", \
"EnhancedPrintout"],
Cell[134742, 5140, 162, 4, 70, 56, 0, "StyleData", "Commentary", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[134941, 5149, 229, 6, 70, 29, 0, "StyleData", "Level1Icon", "All",
 StyleMenuListing->None],
Cell[135173, 5157, 60, 1, 70, 45, 0, "StyleData", "Level1Icon", \
"Presentation"],
Cell[135236, 5160, 140, 3, 70, 41, 0, "StyleData", "Level1Icon", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[135413, 5168, 229, 6, 70, 29, 0, "StyleData", "Level2Icon", "All",
 StyleMenuListing->None],
Cell[135645, 5176, 60, 1, 70, 45, 0, "StyleData", "Level2Icon", \
"Presentation"],
Cell[135708, 5179, 140, 3, 70, 41, 0, "StyleData", "Level2Icon", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[135885, 5187, 176, 6, 70, 32, 0, "StyleData", "CopyrightHead", "All",
 StyleMenuListing->None],
Cell[136064, 5195, 63, 1, 70, 48, 0, "StyleData", "CopyrightHead", \
"Presentation"],
Cell[136130, 5198, 114, 3, 70, 44, 0, "StyleData", "CopyrightHead", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[136281, 5206, 151, 5, 70, 28, 0, "StyleData", "Copyright", "All",
 StyleMenuListing->None],
Cell[136435, 5213, 59, 1, 70, 44, 0, "StyleData", "Copyright", \
"Presentation"],
Cell[136497, 5216, 109, 3, 70, 40, 0, "StyleData", "Copyright", "Printout"],
Cell[136609, 5221, 148, 4, 70, 48, 0, "StyleData", "Copyright", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[136794, 5230, 1213, 30, 70, 37, 0, "StyleData", "RegisterSubsection", \
"All"],
Cell[138010, 5262, 68, 1, 70, 53, 0, "StyleData", "RegisterSubsection", \
"Presentation"],
Cell[138081, 5265, 119, 3, 70, 50, 0, "StyleData", "RegisterSubsection", \
"SlideShow"],
Cell[138203, 5270, 97, 2, 70, 49, 0, "StyleData", "RegisterSubsection", \
"Printout"],
Cell[138303, 5274, 136, 3, 70, 57, 0, "StyleData", "RegisterSubsection", \
"EnhancedPrintout"],
Cell[138442, 5279, 143, 3, 70, 64, 0, "StyleData", "RegisterSubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[138622, 5287, 1227, 29, 70, 40, 0, "StyleData", "RegisterSubsubsection", \
"All"],
Cell[139852, 5318, 71, 1, 70, 56, 0, "StyleData", "RegisterSubsubsection", \
"Presentation"],
Cell[139926, 5321, 99, 2, 70, 52, 0, "StyleData", "RegisterSubsubsection", \
"Printout"],
Cell[140028, 5325, 185, 5, 70, 60, 0, "StyleData", "RegisterSubsubsection", \
"EnhancedPrintout"],
Cell[140216, 5332, 192, 5, 70, 67, 0, "StyleData", "RegisterSubsubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[140445, 5342, 128, 4, 70, 31, 0, "StyleData", "RegisterText", "All",
 StyleMenuListing->None],
Cell[140576, 5348, 62, 1, 70, 47, 0, "StyleData", "RegisterText", \
"Presentation"],
Cell[140641, 5351, 112, 3, 70, 43, 0, "StyleData", "RegisterText", \
"Printout"],
Cell[140756, 5356, 145, 4, 70, 51, 0, "StyleData", "RegisterText", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[140938, 5365, 174, 6, 70, 30, 0, "StyleData", "CaptionHead", "All",
 StyleMenuListing->None],
Cell[141115, 5373, 61, 1, 70, 46, 0, "StyleData", "CaptionHead", \
"Presentation"],
Cell[141179, 5376, 111, 3, 70, 42, 0, "StyleData", "CaptionHead", \
"Printout"],
Cell[141293, 5381, 144, 4, 70, 50, 0, "StyleData", "CaptionHead", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[141474, 5390, 112, 3, 70, 30, 0, "StyleData", "CaptionText", "All",
 StyleMenuListing->None],
Cell[141589, 5395, 61, 1, 70, 46, 0, "StyleData", "CaptionText", \
"Presentation"],
Cell[141653, 5398, 111, 3, 70, 42, 0, "StyleData", "CaptionText", \
"Printout"],
Cell[141767, 5403, 144, 4, 70, 50, 0, "StyleData", "CaptionText", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[141948, 5412, 289, 8, 70, 29, 0, "StyleData", "BulletText", "All",
 CounterIncrements->"BulletText",
 StyleMenuListing->None],
Cell[142240, 5422, 60, 1, 70, 45, 0, "StyleData", "BulletText", \
"Presentation"],
Cell[142303, 5425, 56, 1, 70, 41, 0, "StyleData", "BulletText", "Printout"],
Cell[142362, 5428, 122, 3, 70, 49, 0, "StyleData", "BulletText", \
"EnhancedPrintout"],
Cell[142487, 5433, 96, 2, 70, 56, 0, "StyleData", "BulletText", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[142620, 5440, 87, 2, 70, 29, 0, "StyleData", "HelpLabels", "All",
 StyleMenuListing->None],
Cell[142710, 5444, 60, 1, 70, 45, 0, "StyleData", "HelpLabels", \
"Presentation"],
Cell[142773, 5447, 89, 2, 70, 41, 0, "StyleData", "HelpLabels", "Printout"],
Cell[142865, 5451, 122, 3, 70, 49, 0, "StyleData", "HelpLabels", \
"EnhancedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[143036, 5460, 37, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[143098, 5464, 38, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[143161, 5468, 281, 9, 70, 31, 0, "StyleData", "FunctionName", "All",
 StyleMenuListing->None,
 CellTags->"FunctionName"],
Cell[143445, 5479, 62, 1, 70, 47, 0, "StyleData", "FunctionName", \
"Presentation"],
Cell[143510, 5482, 92, 2, 70, 43, 0, "StyleData", "FunctionName", \
"Printout"],
Cell[143605, 5486, 124, 3, 70, 51, 0, "StyleData", "FunctionName", \
"EnhancedPrintout"],
Cell[143732, 5491, 131, 3, 70, 58, 0, "StyleData", "FunctionName", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[143900, 5499, 252, 7, 70, 37, 0, "StyleData", "FunctionSubsection", \
"All",
 StyleMenuListing->None,
 CellTags->"FunctionSubsection"],
Cell[144155, 5508, 68, 1, 70, 53, 0, "StyleData", "FunctionSubsection", \
"Presentation"],
Cell[144226, 5511, 82, 1, 70, 49, 0, "StyleData", "FunctionSubsection", \
"Printout"],
Cell[144311, 5514, 130, 3, 70, 57, 0, "StyleData", "FunctionSubsection", \
"EnhancedPrintout"],
Cell[144444, 5519, 137, 3, 70, 64, 0, "StyleData", "FunctionSubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[144618, 5527, 213, 6, 70, 38, 0, "StyleData", "FunctionDescription", \
"All",
 CounterIncrements->"FunctionDescription",
 StyleMenuListing->None],
Cell[144834, 5535, 69, 1, 70, 54, 0, "StyleData", "FunctionDescription", \
"Presentation"],
Cell[144906, 5538, 98, 2, 70, 50, 0, "StyleData", "FunctionDescription", \
"Printout"],
Cell[145007, 5542, 154, 4, 70, 58, 0, "StyleData", "FunctionDescription", \
"EnhancedPrintout"],
Cell[145164, 5548, 161, 4, 70, 65, 0, "StyleData", "FunctionDescription", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[145362, 5557, 237, 6, 70, 43, 0, "StyleData", \
"FunctionDescriptionRuled", "All",
 CounterIncrements->"FunctionDescriptionRuled",
 StyleMenuListing->None],
Cell[145602, 5565, 74, 1, 70, 59, 0, "StyleData", "FunctionDescriptionRuled", \
"Presentation"],
Cell[145679, 5568, 103, 2, 70, 55, 0, "StyleData", \
"FunctionDescriptionRuled", "Printout"],
Cell[145785, 5572, 159, 4, 70, 63, 0, "StyleData", \
"FunctionDescriptionRuled", "EnhancedPrintout"],
Cell[145947, 5578, 166, 4, 70, 70, 0, "StyleData", \
"FunctionDescriptionRuled", "EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[146150, 5587, 238, 6, 70, 45, 0, "StyleData", \
"FunctionDescriptionRuleTop", "All",
 CounterIncrements->"FunctionDescriptionRuleTop",
 StyleMenuListing->None],
Cell[146391, 5595, 76, 1, 70, 61, 0, "StyleData", \
"FunctionDescriptionRuleTop", "Presentation"],
Cell[146470, 5598, 105, 2, 70, 57, 0, "StyleData", \
"FunctionDescriptionRuleTop", "Printout"],
Cell[146578, 5602, 161, 4, 70, 65, 0, "StyleData", \
"FunctionDescriptionRuleTop", "EnhancedPrintout"],
Cell[146742, 5608, 168, 4, 70, 72, 0, "StyleData", \
"FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[146947, 5617, 244, 6, 70, 48, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "All",
 CounterIncrements->"FunctionDescriptionRuleBottom",
 StyleMenuListing->None],
Cell[147194, 5625, 79, 1, 70, 64, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "Presentation"],
Cell[147276, 5628, 108, 2, 70, 60, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "Printout"],
Cell[147387, 5632, 164, 4, 70, 68, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "EnhancedPrintout"],
Cell[147554, 5638, 171, 4, 70, 75, 0, "StyleData", \
"FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[147762, 5647, 108, 3, 70, 34, 0, "StyleData", "FunctionExample", "All",
 StyleMenuListing->None],
Cell[147873, 5652, 65, 1, 70, 50, 0, "StyleData", "FunctionExample", \
"Presentation"],
Cell[147941, 5655, 93, 2, 70, 46, 0, "StyleData", "FunctionExample", \
"Printout"],
Cell[148037, 5659, 126, 3, 70, 54, 0, "StyleData", "FunctionExample", \
"EnhancedPrintout"],
Cell[148166, 5664, 133, 3, 70, 61, 0, "StyleData", "FunctionExample", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[148336, 5672, 158, 5, 70, 35, 0, "StyleData", "FunctionTextNote", "All",
 StyleMenuListing->None],
Cell[148497, 5679, 66, 1, 70, 51, 0, "StyleData", "FunctionTextNote", \
"Presentation"],
Cell[148566, 5682, 94, 2, 70, 47, 0, "StyleData", "FunctionTextNote", \
"Printout"],
Cell[148663, 5686, 127, 3, 70, 55, 0, "StyleData", "FunctionTextNote", \
"EnhancedPrintout"],
Cell[148793, 5691, 134, 3, 70, 62, 0, "StyleData", "FunctionTextNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[148964, 5699, 730, 23, 70, 39, 0, "StyleData", "3ColumnFunctionTable", \
"All",
 StyleMenuListing->None],
Cell[149697, 5724, 70, 1, 70, 55, 0, "StyleData", "3ColumnFunctionTable", \
"Presentation"],
Cell[149770, 5727, 99, 2, 70, 51, 0, "StyleData", "3ColumnFunctionTable", \
"Printout"],
Cell[149872, 5731, 107, 2, 70, 59, 0, "StyleData", "3ColumnFunctionTable", \
"EnhancedPrintout"],
Cell[149982, 5735, 114, 2, 70, 66, 0, "StyleData", "3ColumnFunctionTable", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[150145, 5743, 42, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[150212, 5747, 181, 6, 70, 29, 0, "StyleData", "TextNormal", "All",
 CounterIncrements->"TextNormal",
 StyleMenuListing->None],
Cell[150396, 5755, 60, 1, 70, 45, 0, "StyleData", "TextNormal", \
"Presentation"],
Cell[150459, 5758, 88, 2, 70, 41, 0, "StyleData", "TextNormal", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[150584, 5765, 795, 22, 70, 35, 0, "StyleData", "BrowserEmulation", "All",
 
 StyleMenuListing->None],
Cell[151382, 5789, 66, 1, 70, 51, 0, "StyleData", "BrowserEmulation", \
"Presentation"],
Cell[151451, 5792, 94, 2, 70, 47, 0, "StyleData", "BrowserEmulation", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[151582, 5799, 458, 12, 70, 31, 0, "StyleData", "CategoryDefs", "All",
 StyleMenuListing->None],
Cell[152043, 5813, 62, 1, 70, 47, 0, "StyleData", "CategoryDefs", \
"Presentation"],
Cell[152108, 5816, 90, 2, 70, 43, 0, "StyleData", "CategoryDefs", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[152235, 5823, 224, 7, 70, 28, 0, "StyleData", "Category1", "All",
 StyleMenuListing->None],
Cell[152462, 5832, 59, 1, 70, 44, 0, "StyleData", "Category1", \
"Presentation"],
Cell[152524, 5835, 72, 1, 70, 40, 0, "StyleData", "Category1", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[152633, 5841, 262, 8, 70, 28, 0, "StyleData", "Category2", "All",
 StyleMenuListing->None],
Cell[152898, 5851, 59, 1, 70, 44, 0, "StyleData", "Category2", \
"Presentation"],
Cell[152960, 5854, 72, 1, 70, 40, 0, "StyleData", "Category2", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[153069, 5860, 260, 8, 70, 28, 0, "StyleData", "Category3", "All",
 StyleMenuListing->None],
Cell[153332, 5870, 59, 1, 70, 44, 0, "StyleData", "Category3", \
"Presentation"],
Cell[153394, 5873, 72, 1, 70, 40, 0, "StyleData", "Category3", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[153503, 5879, 250, 7, 70, 28, 0, "StyleData", "Category4", "All",
 StyleMenuListing->None],
Cell[153756, 5888, 59, 1, 70, 44, 0, "StyleData", "Category4", \
"Presentation"],
Cell[153818, 5891, 72, 1, 70, 40, 0, "StyleData", "Category4", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[153939, 5898, 29, 0, 70, "Subsubsection"],
Cell[CellGroupData[{
Cell[153993, 5902, 690, 21, 70, 31, 0, "StyleData", "4ColumnTable", "All",
 StyleMenuListing->None],
Cell[154686, 5925, 62, 1, 70, 47, 0, "StyleData", "4ColumnTable", \
"Presentation"],
Cell[154751, 5928, 75, 1, 70, 43, 0, "StyleData", "4ColumnTable", \
"Printout"],
Cell[154829, 5931, 83, 1, 70, 51, 0, "StyleData", "4ColumnTable", \
"EnhancedPrintout"],
Cell[154915, 5934, 90, 1, 70, 58, 0, "StyleData", "4ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[155042, 5940, 689, 21, 70, 31, 0, "StyleData", "5ColumnTable", "All",
 StyleMenuListing->None],
Cell[155734, 5963, 62, 1, 70, 47, 0, "StyleData", "5ColumnTable", \
"Presentation"],
Cell[155799, 5966, 75, 1, 70, 43, 0, "StyleData", "5ColumnTable", \
"Printout"],
Cell[155877, 5969, 83, 1, 70, 51, 0, "StyleData", "5ColumnTable", \
"EnhancedPrintout"],
Cell[155963, 5972, 90, 1, 70, 58, 0, "StyleData", "5ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[156090, 5978, 690, 21, 70, 31, 0, "StyleData", "6ColumnTable", "All",
 StyleMenuListing->None],
Cell[156783, 6001, 62, 1, 70, 47, 0, "StyleData", "6ColumnTable", \
"Presentation"],
Cell[156848, 6004, 75, 1, 70, 43, 0, "StyleData", "6ColumnTable", \
"Printout"],
Cell[156926, 6007, 83, 1, 70, 51, 0, "StyleData", "6ColumnTable", \
"EnhancedPrintout"],
Cell[157012, 6010, 90, 1, 70, 58, 0, "StyleData", "6ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[157139, 6016, 690, 21, 70, 31, 0, "StyleData", "7ColumnTable", "All",
 StyleMenuListing->None],
Cell[157832, 6039, 62, 1, 70, 47, 0, "StyleData", "7ColumnTable", \
"Presentation"],
Cell[157897, 6042, 75, 1, 70, 43, 0, "StyleData", "7ColumnTable", \
"Printout"],
Cell[157975, 6045, 83, 1, 70, 51, 0, "StyleData", "7ColumnTable", \
"EnhancedPrintout"],
Cell[158061, 6048, 90, 1, 70, 58, 0, "StyleData", "7ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[158188, 6054, 690, 21, 70, 31, 0, "StyleData", "8ColumnTable", "All",
 StyleMenuListing->None],
Cell[158881, 6077, 62, 1, 70, 47, 0, "StyleData", "8ColumnTable", \
"Presentation"],
Cell[158946, 6080, 75, 1, 70, 43, 0, "StyleData", "8ColumnTable", \
"Printout"],
Cell[159024, 6083, 83, 1, 70, 51, 0, "StyleData", "8ColumnTable", \
"EnhancedPrintout"],
Cell[159110, 6086, 90, 1, 70, 58, 0, "StyleData", "8ColumnTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[159237, 6092, 172, 5, 70, 33, 0, "StyleData", "ABItemizedText", "All",
 CounterIncrements->"ItemizedText",
 StyleMenuListing->None],
Cell[159412, 6099, 64, 1, 70, 49, 0, "StyleData", "ABItemizedText", \
"Presentation"],
Cell[159479, 6102, 103, 3, 70, 45, 0, "StyleData", "ABItemizedText", \
"Printout"],
Cell[159585, 6107, 136, 4, 70, 53, 0, "StyleData", "ABItemizedText", \
"EnhancedPrintout"],
Cell[159724, 6113, 143, 4, 70, 60, 0, "StyleData", "ABItemizedText", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[159904, 6122, 1449, 36, 70, 29, 0, "StyleData", "ChapNumber", "All",
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subtitle", 0}, {"Subsubtitle", 0}},
 StyleMenuListing->None],
Cell[161356, 6160, 60, 1, 70, 45, 0, "StyleData", "ChapNumber", \
"Presentation"],
Cell[161419, 6163, 91, 2, 70, 41, 0, "StyleData", "ChapNumber", "Printout"],
Cell[161513, 6167, 156, 4, 70, 49, 0, "StyleData", "ChapNumber", \
"EnhancedPrintout"],
Cell[161672, 6173, 163, 4, 70, 56, 0, "StyleData", "ChapNumber", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[161872, 6182, 1447, 36, 70, 28, 0, "StyleData", "ChapTitle", "All",
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subtitle", 0}, {"Subsubtitle", 0}},
 StyleMenuListing->None],
Cell[163322, 6220, 59, 1, 70, 44, 0, "StyleData", "ChapTitle", \
"Presentation"],
Cell[163384, 6223, 89, 2, 70, 40, 0, "StyleData", "ChapTitle", "Printout"],
Cell[163476, 6227, 175, 5, 70, 48, 0, "StyleData", "ChapTitle", \
"EnhancedPrintout"],
Cell[163654, 6234, 156, 4, 70, 55, 0, "StyleData", "ChapTitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[163847, 6243, 120, 4, 70, 30, 0, "StyleData", "ItemDingbat", "All",
 StyleMenuListing->None],
Cell[163970, 6249, 61, 1, 70, 46, 0, "StyleData", "ItemDingbat", \
"Presentation"],
Cell[164034, 6252, 67, 1, 70, 42, 0, "StyleData", "ItemDingbat", "Printout"],
Cell[164104, 6255, 71, 1, 70, 50, 0, "StyleData", "ItemDingbat", \
"EnhancedPrintout"],
Cell[164178, 6258, 78, 1, 70, 57, 0, "StyleData", "ItemDingbat", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[164293, 6264, 134, 4, 70, 24, 0, "StyleData", "Item1", "All",
 CounterIncrements->"Item1",
 StyleMenuListing->None],
Cell[164430, 6270, 55, 1, 70, 40, 0, "StyleData", "Item1", "Presentation"],
Cell[164488, 6273, 84, 2, 70, 36, 0, "StyleData", "Item1", "Printout"],
Cell[164575, 6277, 92, 2, 70, 44, 0, "StyleData", "Item1", \
"EnhancedPrintout"],
Cell[164670, 6281, 99, 2, 70, 51, 0, "StyleData", "Item1", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[164806, 6288, 129, 3, 70, 33, 0, "StyleData", "Item1Continued", "All",
 CounterIncrements->"Item1Continued",
 StyleMenuListing->None],
Cell[164938, 6293, 64, 1, 70, 49, 0, "StyleData", "Item1Continued", \
"Presentation"],
Cell[165005, 6296, 93, 2, 70, 45, 0, "StyleData", "Item1Continued", \
"Printout"],
Cell[165101, 6300, 101, 2, 70, 53, 0, "StyleData", "Item1Continued", \
"EnhancedPrintout"],
Cell[165205, 6304, 108, 2, 70, 60, 0, "StyleData", "Item1Continued", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[165350, 6311, 134, 4, 70, 24, 0, "StyleData", "Item2", "All",
 CounterIncrements->"Item2",
 StyleMenuListing->None],
Cell[165487, 6317, 55, 1, 70, 40, 0, "StyleData", "Item2", "Presentation"],
Cell[165545, 6320, 107, 3, 70, 36, 0, "StyleData", "Item2", "Printout"],
Cell[165655, 6325, 115, 3, 70, 44, 0, "StyleData", "Item2", \
"EnhancedPrintout"],
Cell[165773, 6330, 122, 3, 70, 51, 0, "StyleData", "Item2", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[165932, 6338, 129, 3, 70, 33, 0, "StyleData", "Item2Continued", "All",
 CounterIncrements->"Item2Continued",
 StyleMenuListing->None],
Cell[166064, 6343, 64, 1, 70, 49, 0, "StyleData", "Item2Continued", \
"Presentation"],
Cell[166131, 6346, 78, 1, 70, 45, 0, "StyleData", "Item2Continued", \
"Printout"],
Cell[166212, 6349, 101, 2, 70, 53, 0, "StyleData", "Item2Continued", \
"EnhancedPrintout"],
Cell[166316, 6353, 93, 1, 70, 60, 0, "StyleData", "Item2Continued", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[166446, 6359, 134, 4, 70, 24, 0, "StyleData", "Item3", "All",
 CounterIncrements->"Item3",
 StyleMenuListing->None],
Cell[166583, 6365, 55, 1, 70, 40, 0, "StyleData", "Item3", "Presentation"],
Cell[166641, 6368, 69, 1, 70, 36, 0, "StyleData", "Item3", "Printout"],
Cell[166713, 6371, 92, 2, 70, 44, 0, "StyleData", "Item3", \
"EnhancedPrintout"],
Cell[166808, 6375, 109, 2, 70, 51, 0, "StyleData", "Item3", \
"EnhancedPrintoutNonGray",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[166954, 6382, 129, 3, 70, 33, 0, "StyleData", "Item3Continued", "All",
 CounterIncrements->"Item3Continued",
 StyleMenuListing->None],
Cell[167086, 6387, 64, 1, 70, 49, 0, "StyleData", "Item3Continued", \
"Presentation"],
Cell[167153, 6390, 78, 1, 70, 45, 0, "StyleData", "Item3Continued", \
"Printout"],
Cell[167234, 6393, 101, 2, 70, 53, 0, "StyleData", "Item3Continued", \
"EnhancedPrintout"],
Cell[167338, 6397, 93, 1, 70, 60, 0, "StyleData", "Item3Continued", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[167468, 6403, 182, 5, 70, 37, 0, "StyleData", "ItemizedBulletText", \
"All",
 CounterIncrements->"ItemizedBulletText",
 StyleMenuListing->None],
Cell[167653, 6410, 68, 1, 70, 53, 0, "StyleData", "ItemizedBulletText", \
"Presentation"],
Cell[167724, 6413, 107, 3, 70, 49, 0, "StyleData", "ItemizedBulletText", \
"Printout"],
Cell[167834, 6418, 140, 4, 70, 57, 0, "StyleData", "ItemizedBulletText", \
"EnhancedPrintout"],
Cell[167977, 6424, 147, 4, 70, 64, 0, "StyleData", "ItemizedBulletText", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[168161, 6433, 547, 15, 70, 26, 0, "StyleData", "NoteBox", "All",
 StyleMenuListing->None],
Cell[168711, 6450, 57, 1, 70, 42, 0, "StyleData", "NoteBox", "Presentation"],
Cell[168771, 6453, 119, 3, 70, 38, 0, "StyleData", "NoteBox", "Printout"],
Cell[168893, 6458, 158, 4, 70, 46, 0, "StyleData", "NoteBox", \
"EnhancedPrintout"],
Cell[169054, 6464, 158, 4, 70, 53, 0, "StyleData", "NoteBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[169249, 6473, 554, 15, 70, 34, 0, "StyleData", "ItemizedNoteBox", "All",
 StyleMenuListing->None],
Cell[169806, 6490, 65, 1, 70, 50, 0, "StyleData", "ItemizedNoteBox", \
"Presentation"],
Cell[169874, 6493, 128, 3, 70, 46, 0, "StyleData", "ItemizedNoteBox", \
"Printout"],
Cell[170005, 6498, 167, 4, 70, 54, 0, "StyleData", "ItemizedNoteBox", \
"EnhancedPrintout"],
Cell[170175, 6504, 167, 4, 70, 61, 0, "StyleData", "ItemizedNoteBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[170379, 6513, 820, 23, 70, 33, 0, "StyleData", "ItemizedTopBox", "All",
 StyleMenuListing->None],
Cell[171202, 6538, 64, 1, 70, 49, 0, "StyleData", "ItemizedTopBox", \
"Presentation"],
Cell[171269, 6541, 94, 2, 70, 45, 0, "StyleData", "ItemizedTopBox", \
"Printout"],
Cell[171366, 6545, 166, 4, 70, 53, 0, "StyleData", "ItemizedTopBox", \
"EnhancedPrintout"],
Cell[171535, 6551, 166, 4, 70, 60, 0, "StyleData", "ItemizedTopBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[171738, 6560, 823, 23, 70, 36, 0, "StyleData", "ItemizedBottomBox", \
"All",
 StyleMenuListing->None],
Cell[172564, 6585, 67, 1, 70, 52, 0, "StyleData", "ItemizedBottomBox", \
"Presentation"],
Cell[172634, 6588, 97, 2, 70, 48, 0, "StyleData", "ItemizedBottomBox", \
"Printout"],
Cell[172734, 6592, 169, 4, 70, 56, 0, "StyleData", "ItemizedBottomBox", \
"EnhancedPrintout"],
Cell[172906, 6598, 169, 4, 70, 63, 0, "StyleData", "ItemizedBottomBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[173112, 6607, 895, 27, 70, 34, 0, "StyleData", "MiddleSpacedBox", "All",
 StyleMenuListing->None],
Cell[174010, 6636, 65, 1, 70, 50, 0, "StyleData", "MiddleSpacedBox", \
"Presentation"],
Cell[174078, 6639, 238, 6, 70, 46, 0, "StyleData", "MiddleSpacedBox", \
"Printout"],
Cell[174319, 6647, 302, 8, 70, 54, 0, "StyleData", "MiddleSpacedBox", \
"EnhancedPrintout"],
Cell[174624, 6657, 309, 8, 70, 61, 0, "StyleData", "MiddleSpacedBox", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[174970, 6670, 148, 4, 70, 31, 0, "StyleData", "ItemizedNote", "All",
 CounterIncrements->"ItemizedNote",
 StyleMenuListing->None],
Cell[175121, 6676, 62, 1, 70, 47, 0, "StyleData", "ItemizedNote", \
"Presentation"],
Cell[175186, 6679, 111, 3, 70, 43, 0, "StyleData", "ItemizedNote", \
"Printout"],
Cell[175300, 6684, 167, 5, 70, 51, 0, "StyleData", "ItemizedNote", \
"EnhancedPrintout"],
Cell[175470, 6691, 174, 5, 70, 58, 0, "StyleData", "ItemizedNote", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[175681, 6701, 152, 4, 70, 36, 0, "StyleData", "ItemizedNoteBelow", "All",
 
 CounterIncrements->"ItemizedNote",
 StyleMenuListing->None],
Cell[175836, 6707, 67, 1, 70, 52, 0, "StyleData", "ItemizedNoteBelow", \
"Presentation"],
Cell[175906, 6710, 117, 3, 70, 48, 0, "StyleData", "ItemizedNoteBelow", \
"Printout"],
Cell[176026, 6715, 172, 5, 70, 56, 0, "StyleData", "ItemizedNoteBelow", \
"EnhancedPrintout"],
Cell[176201, 6722, 179, 5, 70, 63, 0, "StyleData", "ItemizedNoteBelow", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[176417, 6732, 178, 5, 70, 39, 0, "StyleData", "ItemizedTextBelowPic", \
"All",
 CounterIncrements->"ItemizedText",
 StyleMenuListing->None],
Cell[176598, 6739, 70, 1, 70, 55, 0, "StyleData", "ItemizedTextBelowPic", \
"Presentation"],
Cell[176671, 6742, 143, 4, 70, 51, 0, "StyleData", "ItemizedTextBelowPic", \
"Printout"],
Cell[176817, 6748, 176, 5, 70, 59, 0, "StyleData", "ItemizedTextBelowPic", \
"EnhancedPrintout"],
Cell[176996, 6755, 183, 5, 70, 66, 0, "StyleData", "ItemizedTextBelowPic", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[177216, 6765, 152, 4, 70, 36, 0, "StyleData", "ItemizedTextNote2", "All",
 
 CounterIncrements->"ItemizedNote",
 StyleMenuListing->None],
Cell[177371, 6771, 67, 1, 70, 52, 0, "StyleData", "ItemizedTextNote2", \
"Presentation"],
Cell[177441, 6774, 116, 3, 70, 48, 0, "StyleData", "ItemizedTextNote2", \
"Printout"],
Cell[177560, 6779, 149, 4, 70, 56, 0, "StyleData", "ItemizedTextNote2", \
"EnhancedPrintout"],
Cell[177712, 6785, 156, 4, 70, 63, 0, "StyleData", "ItemizedTextNote2", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[177905, 6794, 195, 5, 70, 32, 0, "StyleData", "NumberedItem1", "All",
 CounterIncrements->"NumberedItem1",
 StyleMenuListing->None],
Cell[178103, 6801, 63, 1, 70, 48, 0, "StyleData", "NumberedItem1", \
"Presentation"],
Cell[178169, 6804, 77, 1, 70, 44, 0, "StyleData", "NumberedItem1", \
"Printout"],
Cell[178249, 6807, 85, 1, 70, 52, 0, "StyleData", "NumberedItem1", \
"EnhancedPrintout"],
Cell[178337, 6810, 92, 1, 70, 59, 0, "StyleData", "NumberedItem1", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[178466, 6816, 195, 5, 70, 32, 0, "StyleData", "NumberedItem2", "All",
 CounterIncrements->"NumberedItem2",
 StyleMenuListing->None],
Cell[178664, 6823, 63, 1, 70, 48, 0, "StyleData", "NumberedItem2", \
"Presentation"],
Cell[178730, 6826, 77, 1, 70, 44, 0, "StyleData", "NumberedItem2", \
"Printout"],
Cell[178810, 6829, 85, 1, 70, 52, 0, "StyleData", "NumberedItem2", \
"EnhancedPrintout"],
Cell[178898, 6832, 92, 1, 70, 59, 0, "StyleData", "NumberedItem2", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[179027, 6838, 195, 5, 70, 32, 0, "StyleData", "NumberedItem3", "All",
 CounterIncrements->"NumberedItem3",
 StyleMenuListing->None],
Cell[179225, 6845, 63, 1, 70, 48, 0, "StyleData", "NumberedItem3", \
"Presentation"],
Cell[179291, 6848, 77, 1, 70, 44, 0, "StyleData", "NumberedItem3", \
"Printout"],
Cell[179371, 6851, 85, 1, 70, 52, 0, "StyleData", "NumberedItem3", \
"EnhancedPrintout"],
Cell[179459, 6854, 117, 2, 70, 59, 0, "StyleData", "NumberedItem3", \
"EnhancedPrintoutNonGray",
 StyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[179613, 6861, 147, 5, 70, 33, 0, "StyleData", "PageHeaderBold", "All",
 StyleMenuListing->None],
Cell[179763, 6868, 45, 0, 70, 45, 0, "StyleData", "PageHeaderBold", \
"Printout"],
Cell[179811, 6870, 132, 3, 70, 53, 0, "StyleData", "PageHeaderBold", \
"EnhancedPrintout"],
Cell[179946, 6875, 139, 3, 70, 60, 0, "StyleData", "PageHeaderBold", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[180122, 6883, 559, 18, 70, 33, 0, "StyleData", "SingleRowTable", "All",
 StyleMenuListing->None],
Cell[180684, 6903, 64, 1, 70, 49, 0, "StyleData", "SingleRowTable", \
"Presentation"],
Cell[180751, 6906, 77, 1, 70, 45, 0, "StyleData", "SingleRowTable", \
"Printout"],
Cell[180831, 6909, 85, 1, 70, 53, 0, "StyleData", "SingleRowTable", \
"EnhancedPrintout"],
Cell[180919, 6912, 92, 1, 70, 60, 0, "StyleData", "SingleRowTable", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[181048, 6918, 182, 5, 70, 35, 0, "StyleData", "Subsubsubsection", "All",
 StyleMenuListing->None],
Cell[181233, 6925, 66, 1, 70, 51, 0, "StyleData", "Subsubsubsection", \
"Presentation"],
Cell[181302, 6928, 94, 2, 70, 47, 0, "StyleData", "Subsubsubsection", \
"Printout"],
Cell[181399, 6932, 127, 3, 70, 55, 0, "StyleData", "Subsubsubsection", \
"EnhancedPrintout"],
Cell[181529, 6937, 134, 3, 70, 62, 0, "StyleData", "Subsubsubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[181700, 6945, 1364, 34, 70, 30, 0, "StyleData", "Subsubtitle", "All",
 CounterIncrements->"Subsubtitle",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
 StyleMenuListing->None],
Cell[183067, 6981, 61, 1, 70, 46, 0, "StyleData", "Subsubtitle", \
"Presentation"],
Cell[183131, 6984, 91, 2, 70, 42, 0, "StyleData", "Subsubtitle", "Printout"],
Cell[183225, 6988, 130, 3, 70, 50, 0, "StyleData", "Subsubtitle", \
"EnhancedPrintout"],
Cell[183358, 6993, 137, 3, 70, 57, 0, "StyleData", "Subsubtitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[183532, 7001, 1360, 34, 70, 27, 0, "StyleData", "Subtitle", "All",
 CounterIncrements->"Subtitle",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subsubtitle", 0}},
 StyleMenuListing->None],
Cell[184895, 7037, 58, 1, 70, 43, 0, "StyleData", "Subtitle", \
"Presentation"],
Cell[184956, 7040, 89, 2, 70, 39, 0, "StyleData", "Subtitle", "Printout"],
Cell[185048, 7044, 128, 3, 70, 47, 0, "StyleData", "Subtitle", \
"EnhancedPrintout"],
Cell[185179, 7049, 135, 3, 70, 54, 0, "StyleData", "Subtitle", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[185351, 7057, 1085, 27, 70, 28, 0, "StyleData", "TextBelow", "All",
 StyleMenuListing->None],
Cell[186439, 7086, 59, 1, 70, 44, 0, "StyleData", "TextBelow", \
"Presentation"],
Cell[186501, 7089, 131, 4, 70, 40, 0, "StyleData", "TextBelow", "Printout"],
Cell[186635, 7095, 164, 5, 70, 48, 0, "StyleData", "TextBelow", \
"EnhancedPrintout"],
Cell[186802, 7102, 171, 5, 70, 55, 0, "StyleData", "TextBelow", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[187010, 7112, 1443, 36, 70, 24, 0, "StyleData", "Title", "All",
 CounterIncrements->"Title",
 CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
   "Subtitle", 0}, {"Subsubtitle", 0}},
 StyleMenuListing->None],
Cell[188456, 7150, 55, 1, 70, 40, 0, "StyleData", "Title", "Presentation"],
Cell[188514, 7153, 86, 2, 70, 36, 0, "StyleData", "Title", "Printout"],
Cell[188603, 7157, 174, 5, 70, 44, 0, "StyleData", "Title", \
"EnhancedPrintout"],
Cell[188780, 7164, 155, 4, 70, 51, 0, "StyleData", "Title", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[188972, 7173, 1163, 29, 70, 34, 0, "StyleData", "Undersubsection", "All",
 
 StyleMenuListing->None],
Cell[190138, 7204, 65, 1, 70, 50, 0, "StyleData", "Undersubsection", \
"Presentation"],
Cell[190206, 7207, 94, 2, 70, 46, 0, "StyleData", "Undersubsection", \
"Printout"],
Cell[190303, 7211, 153, 4, 70, 54, 0, "StyleData", "Undersubsection", \
"EnhancedPrintout"],
Cell[190459, 7217, 160, 4, 70, 61, 0, "StyleData", "Undersubsection", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[190656, 7226, 281, 8, 70, 31, 0, "StyleData", "SectionFirst", "All",
 CounterIncrements->"Section"],
Cell[190940, 7236, 62, 1, 70, 47, 0, "StyleData", "SectionFirst", \
"Presentation"],
Cell[191005, 7239, 114, 3, 70, 43, 0, "StyleData", "SectionFirst", \
"Printout"],
Cell[191122, 7244, 402, 11, 70, 51, 0, "StyleData", "SectionFirst", \
"EnhancedPrintout",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[191527, 7257, 383, 10, 70, 58, 0, "StyleData", "SectionFirst", \
"EnhancedPrintoutNonGray",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}]
}, Closed]],
Cell[CellGroupData[{
Cell[191947, 7272, 324, 9, 70, 34, 0, "StyleData", "SubsectionFirst", "All"],
Cell[192274, 7283, 65, 1, 70, 50, 0, "StyleData", "SubsectionFirst", \
"Presentation"],
Cell[192342, 7286, 115, 3, 70, 47, 0, "StyleData", "SubsectionFirst", \
"SlideShow"],
Cell[192460, 7291, 144, 3, 70, 46, 0, "StyleData", "SubsectionFirst", \
"Printout"],
Cell[192607, 7296, 230, 6, 70, 54, 0, "StyleData", "SubsectionFirst", \
"EnhancedPrintout"],
Cell[192840, 7304, 211, 5, 70, 61, 0, "StyleData", "SubsectionFirst", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[193088, 7314, 307, 8, 70, 37, 0, "StyleData", "SubsubsectionFirst", \
"All"],
Cell[193398, 7324, 68, 1, 70, 53, 0, "StyleData", "SubsubsectionFirst", \
"Presentation"],
Cell[193469, 7327, 147, 3, 70, 49, 0, "StyleData", "SubsubsectionFirst", \
"Printout"],
Cell[193619, 7332, 233, 6, 70, 57, 0, "StyleData", "SubsubsectionFirst", \
"EnhancedPrintout"],
Cell[193855, 7340, 214, 5, 70, 64, 0, "StyleData", "SubsubsectionFirst", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[194106, 7350, 187, 5, 70, 40, 0, "StyleData", "SubsubsubsectionFirst", \
"All",
 StyleMenuListing->None],
Cell[194296, 7357, 71, 1, 70, 56, 0, "StyleData", "SubsubsubsectionFirst", \
"Presentation"],
Cell[194370, 7360, 99, 2, 70, 52, 0, "StyleData", "SubsubsubsectionFirst", \
"Printout"],
Cell[194472, 7364, 132, 3, 70, 60, 0, "StyleData", "SubsubsubsectionFirst", \
"EnhancedPrintout"],
Cell[194607, 7369, 139, 3, 70, 67, 0, "StyleData", "SubsubsubsectionFirst", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[194761, 7375, 27, 0, 70, "Text"],
Cell[CellGroupData[{
Cell[194813, 7379, 170, 5, 19, 25, 0, "StyleData", "Spacer", "All",
 StyleMenuListing->None],
Cell[194986, 7386, 68, 2, 70, 37, 0, "StyleData", "Spacer", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[195091, 7393, 108, 3, 70, 38, 0, "StyleData", "DiscretionaryHyphen", \
"All",
 StyleMenuListing->None],
Cell[195202, 7398, 91, 2, 70, 50, 0, "StyleData", "DiscretionaryHyphen", \
"Printout"],
Cell[195296, 7402, 99, 2, 70, 58, 0, "StyleData", "DiscretionaryHyphen", \
"EnhancedPrintout"],
Cell[195398, 7406, 106, 2, 70, 65, 0, "StyleData", "DiscretionaryHyphen", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[195541, 7413, 172, 4, 70, 34, 0, "StyleData", "PictureSmaller1", "All",
 StyleMenuListing->None],
Cell[195716, 7419, 65, 1, 70, 50, 0, "StyleData", "PictureSmaller1", \
"Presentation"],
Cell[195784, 7422, 108, 2, 70, 46, 0, "StyleData", "PictureSmaller1", \
"Printout"],
Cell[195895, 7426, 116, 2, 70, 54, 0, "StyleData", "PictureSmaller1", \
"EnhancedPrintout"],
Cell[196014, 7430, 123, 2, 70, 61, 0, "StyleData", "PictureSmaller1", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[196174, 7437, 172, 4, 70, 34, 0, "StyleData", "PictureSmaller2", "All",
 StyleMenuListing->None],
Cell[196349, 7443, 65, 1, 70, 50, 0, "StyleData", "PictureSmaller2", \
"Presentation"],
Cell[196417, 7446, 108, 2, 70, 46, 0, "StyleData", "PictureSmaller2", \
"Printout"],
Cell[196528, 7450, 116, 2, 70, 54, 0, "StyleData", "PictureSmaller2", \
"EnhancedPrintout"],
Cell[196647, 7454, 123, 2, 70, 61, 0, "StyleData", "PictureSmaller2", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[196807, 7461, 172, 4, 70, 34, 0, "StyleData", "PictureSmaller3", "All",
 StyleMenuListing->None],
Cell[196982, 7467, 65, 1, 70, 50, 0, "StyleData", "PictureSmaller3", \
"Presentation"],
Cell[197050, 7470, 108, 2, 70, 46, 0, "StyleData", "PictureSmaller3", \
"Printout"],
Cell[197161, 7474, 116, 2, 70, 54, 0, "StyleData", "PictureSmaller3", \
"EnhancedPrintout"],
Cell[197280, 7478, 123, 2, 70, 61, 0, "StyleData", "PictureSmaller3", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[197440, 7485, 172, 4, 70, 34, 0, "StyleData", "PictureSmaller4", "All",
 StyleMenuListing->None],
Cell[197615, 7491, 65, 1, 70, 50, 0, "StyleData", "PictureSmaller4", \
"Presentation"],
Cell[197683, 7494, 108, 2, 70, 46, 0, "StyleData", "PictureSmaller4", \
"Printout"],
Cell[197794, 7498, 116, 2, 70, 54, 0, "StyleData", "PictureSmaller4", \
"EnhancedPrintout"],
Cell[197913, 7502, 123, 2, 70, 61, 0, "StyleData", "PictureSmaller4", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[198073, 7509, 172, 4, 70, 34, 0, "StyleData", "PictureSmaller5", "All",
 StyleMenuListing->None],
Cell[198248, 7515, 65, 1, 70, 50, 0, "StyleData", "PictureSmaller5", \
"Presentation"],
Cell[198316, 7518, 108, 2, 70, 46, 0, "StyleData", "PictureSmaller5", \
"Printout"],
Cell[198427, 7522, 116, 2, 70, 54, 0, "StyleData", "PictureSmaller5", \
"EnhancedPrintout"],
Cell[198546, 7526, 123, 2, 70, 61, 0, "StyleData", "PictureSmaller5", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[198706, 7533, 172, 4, 70, 34, 0, "StyleData", "PictureSmaller6", "All",
 StyleMenuListing->None],
Cell[198881, 7539, 65, 1, 70, 50, 0, "StyleData", "PictureSmaller6", \
"Presentation"],
Cell[198949, 7542, 108, 2, 70, 46, 0, "StyleData", "PictureSmaller6", \
"Printout"],
Cell[199060, 7546, 116, 2, 70, 54, 0, "StyleData", "PictureSmaller6", \
"EnhancedPrintout"],
Cell[199179, 7550, 123, 2, 70, 61, 0, "StyleData", "PictureSmaller6", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[199339, 7557, 168, 4, 70, 30, 0, "StyleData", "ItemPicture", "All",
 StyleMenuListing->None],
Cell[199510, 7563, 61, 1, 70, 46, 0, "StyleData", "ItemPicture", \
"Presentation"],
Cell[199574, 7566, 106, 2, 70, 42, 0, "StyleData", "ItemPicture", \
"Printout"],
Cell[199683, 7570, 115, 2, 70, 50, 0, "StyleData", "ItemPicture", \
"EnhancedPrintout"],
Cell[199801, 7574, 122, 2, 70, 57, 0, "StyleData", "ItemPicture", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[199960, 7581, 176, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller1", \
"All",
 StyleMenuListing->None],
Cell[200139, 7587, 69, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller1", \
"Presentation"],
Cell[200211, 7590, 114, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller1", \
"Printout"],
Cell[200328, 7594, 123, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller1", \
"EnhancedPrintout"],
Cell[200454, 7598, 130, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller1", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[200621, 7605, 176, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller2", \
"All",
 StyleMenuListing->None],
Cell[200800, 7611, 69, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller2", \
"Presentation"],
Cell[200872, 7614, 114, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller2", \
"Printout"],
Cell[200989, 7618, 123, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller2", \
"EnhancedPrintout"],
Cell[201115, 7622, 130, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller2", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[201282, 7629, 176, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller3", \
"All",
 StyleMenuListing->None],
Cell[201461, 7635, 69, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller3", \
"Presentation"],
Cell[201533, 7638, 115, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller3", \
"Printout"],
Cell[201651, 7642, 123, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller3", \
"EnhancedPrintout"],
Cell[201777, 7646, 130, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller3", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[201944, 7653, 176, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller4", \
"All",
 StyleMenuListing->None],
Cell[202123, 7659, 69, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller4", \
"Presentation"],
Cell[202195, 7662, 115, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller4", \
"Printout"],
Cell[202313, 7666, 123, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller4", \
"EnhancedPrintout"],
Cell[202439, 7670, 130, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller4", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[202606, 7677, 176, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller5", \
"All",
 StyleMenuListing->None],
Cell[202785, 7683, 69, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller5", \
"Presentation"],
Cell[202857, 7686, 115, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller5", \
"Printout"],
Cell[202975, 7690, 123, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller5", \
"EnhancedPrintout"],
Cell[203101, 7694, 130, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller5", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[203268, 7701, 176, 4, 70, 38, 0, "StyleData", "ItemPictureSmaller6", \
"All",
 StyleMenuListing->None],
Cell[203447, 7707, 69, 1, 70, 54, 0, "StyleData", "ItemPictureSmaller6", \
"Presentation"],
Cell[203519, 7710, 115, 2, 70, 50, 0, "StyleData", "ItemPictureSmaller6", \
"Printout"],
Cell[203637, 7714, 123, 2, 70, 58, 0, "StyleData", "ItemPictureSmaller6", \
"EnhancedPrintout"],
Cell[203763, 7718, 130, 2, 70, 65, 0, "StyleData", "ItemPictureSmaller6", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[203930, 7725, 171, 4, 70, 33, 0, "StyleData", "PictureBigger1", "All",
 StyleMenuListing->None],
Cell[204104, 7731, 64, 1, 70, 49, 0, "StyleData", "PictureBigger1", \
"Presentation"],
Cell[204171, 7734, 107, 2, 70, 45, 0, "StyleData", "PictureBigger1", \
"Printout"],
Cell[204281, 7738, 115, 2, 70, 53, 0, "StyleData", "PictureBigger1", \
"EnhancedPrintout"],
Cell[204399, 7742, 122, 2, 70, 60, 0, "StyleData", "PictureBigger1", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[204558, 7749, 171, 4, 70, 33, 0, "StyleData", "PictureBigger2", "All",
 StyleMenuListing->None],
Cell[204732, 7755, 64, 1, 70, 49, 0, "StyleData", "PictureBigger2", \
"Presentation"],
Cell[204799, 7758, 107, 2, 70, 45, 0, "StyleData", "PictureBigger2", \
"Printout"],
Cell[204909, 7762, 115, 2, 70, 53, 0, "StyleData", "PictureBigger2", \
"EnhancedPrintout"],
Cell[205027, 7766, 122, 2, 70, 60, 0, "StyleData", "PictureBigger2", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[205186, 7773, 171, 4, 70, 33, 0, "StyleData", "PictureBigger3", "All",
 StyleMenuListing->None],
Cell[205360, 7779, 64, 1, 70, 49, 0, "StyleData", "PictureBigger3", \
"Presentation"],
Cell[205427, 7782, 107, 2, 70, 45, 0, "StyleData", "PictureBigger3", \
"Printout"],
Cell[205537, 7786, 115, 2, 70, 53, 0, "StyleData", "PictureBigger3", \
"EnhancedPrintout"],
Cell[205655, 7790, 122, 2, 70, 60, 0, "StyleData", "PictureBigger3", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[205814, 7797, 171, 4, 70, 33, 0, "StyleData", "PictureBigger4", "All",
 StyleMenuListing->None],
Cell[205988, 7803, 64, 1, 70, 49, 0, "StyleData", "PictureBigger4", \
"Presentation"],
Cell[206055, 7806, 107, 2, 70, 45, 0, "StyleData", "PictureBigger4", \
"Printout"],
Cell[206165, 7810, 115, 2, 70, 53, 0, "StyleData", "PictureBigger4", \
"EnhancedPrintout"],
Cell[206283, 7814, 122, 2, 70, 60, 0, "StyleData", "PictureBigger4", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[206442, 7821, 171, 4, 70, 33, 0, "StyleData", "PictureBigger5", "All",
 StyleMenuListing->None],
Cell[206616, 7827, 64, 1, 70, 49, 0, "StyleData", "PictureBigger5", \
"Presentation"],
Cell[206683, 7830, 106, 2, 70, 45, 0, "StyleData", "PictureBigger5", \
"Printout"],
Cell[206792, 7834, 114, 2, 70, 53, 0, "StyleData", "PictureBigger5", \
"EnhancedPrintout"],
Cell[206909, 7838, 121, 2, 70, 60, 0, "StyleData", "PictureBigger5", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[207067, 7845, 171, 4, 70, 33, 0, "StyleData", "PictureBigger6", "All",
 StyleMenuListing->None],
Cell[207241, 7851, 64, 1, 70, 49, 0, "StyleData", "PictureBigger6", \
"Presentation"],
Cell[207308, 7854, 107, 2, 70, 45, 0, "StyleData", "PictureBigger6", \
"Printout"],
Cell[207418, 7858, 115, 2, 70, 53, 0, "StyleData", "PictureBigger6", \
"EnhancedPrintout"],
Cell[207536, 7862, 122, 2, 70, 60, 0, "StyleData", "PictureBigger6", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[207695, 7869, 175, 4, 70, 37, 0, "StyleData", "ItemPictureBigger1", \
"All",
 StyleMenuListing->None],
Cell[207873, 7875, 68, 1, 70, 53, 0, "StyleData", "ItemPictureBigger1", \
"Presentation"],
Cell[207944, 7878, 113, 2, 70, 49, 0, "StyleData", "ItemPictureBigger1", \
"Printout"],
Cell[208060, 7882, 122, 2, 70, 57, 0, "StyleData", "ItemPictureBigger1", \
"EnhancedPrintout"],
Cell[208185, 7886, 129, 2, 70, 64, 0, "StyleData", "ItemPictureBigger1", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[208351, 7893, 175, 4, 70, 37, 0, "StyleData", "ItemPictureBigger2", \
"All",
 StyleMenuListing->None],
Cell[208529, 7899, 68, 1, 70, 53, 0, "StyleData", "ItemPictureBigger2", \
"Presentation"],
Cell[208600, 7902, 113, 2, 70, 49, 0, "StyleData", "ItemPictureBigger2", \
"Printout"],
Cell[208716, 7906, 122, 2, 70, 57, 0, "StyleData", "ItemPictureBigger2", \
"EnhancedPrintout"],
Cell[208841, 7910, 129, 2, 70, 64, 0, "StyleData", "ItemPictureBigger2", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[209007, 7917, 175, 4, 70, 37, 0, "StyleData", "ItemPictureBigger3", \
"All",
 StyleMenuListing->None],
Cell[209185, 7923, 68, 1, 70, 53, 0, "StyleData", "ItemPictureBigger3", \
"Presentation"],
Cell[209256, 7926, 114, 2, 70, 49, 0, "StyleData", "ItemPictureBigger3", \
"Printout"],
Cell[209373, 7930, 122, 2, 70, 57, 0, "StyleData", "ItemPictureBigger3", \
"EnhancedPrintout"],
Cell[209498, 7934, 129, 2, 70, 64, 0, "StyleData", "ItemPictureBigger3", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[209664, 7941, 175, 4, 70, 37, 0, "StyleData", "ItemPictureBigger4", \
"All",
 StyleMenuListing->None],
Cell[209842, 7947, 68, 1, 70, 53, 0, "StyleData", "ItemPictureBigger4", \
"Presentation"],
Cell[209913, 7950, 114, 2, 70, 49, 0, "StyleData", "ItemPictureBigger4", \
"Printout"],
Cell[210030, 7954, 122, 2, 70, 57, 0, "StyleData", "ItemPictureBigger4", \
"EnhancedPrintout"],
Cell[210155, 7958, 129, 2, 70, 64, 0, "StyleData", "ItemPictureBigger4", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[210321, 7965, 175, 4, 70, 37, 0, "StyleData", "ItemPictureBigger5", \
"All",
 StyleMenuListing->None],
Cell[210499, 7971, 68, 1, 70, 53, 0, "StyleData", "ItemPictureBigger5", \
"Presentation"],
Cell[210570, 7974, 113, 2, 70, 49, 0, "StyleData", "ItemPictureBigger5", \
"Printout"],
Cell[210686, 7978, 121, 2, 70, 57, 0, "StyleData", "ItemPictureBigger5", \
"EnhancedPrintout"],
Cell[210810, 7982, 128, 2, 70, 64, 0, "StyleData", "ItemPictureBigger5", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[210975, 7989, 175, 4, 70, 37, 0, "StyleData", "ItemPictureBigger6", \
"All",
 StyleMenuListing->None],
Cell[211153, 7995, 68, 1, 70, 53, 0, "StyleData", "ItemPictureBigger6", \
"Presentation"],
Cell[211224, 7998, 114, 2, 70, 49, 0, "StyleData", "ItemPictureBigger6", \
"Printout"],
Cell[211341, 8002, 121, 2, 70, 57, 0, "StyleData", "ItemPictureBigger6", \
"EnhancedPrintout"],
Cell[211465, 8006, 128, 2, 70, 64, 0, "StyleData", "ItemPictureBigger6", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[211630, 8013, 130, 3, 70, 32, 0, "StyleData", "ScreenGraphic", "All",
 StyleMenuListing->None],
Cell[211763, 8018, 63, 1, 70, 48, 0, "StyleData", "ScreenGraphic", \
"Presentation"],
Cell[211829, 8021, 84, 1, 70, 44, 0, "StyleData", "ScreenGraphic", \
"Printout"],
Cell[211916, 8024, 178, 4, 70, 52, 0, "StyleData", "ScreenGraphic", \
"EnhancedPrintout"],
Cell[212097, 8030, 185, 4, 70, 59, 0, "StyleData", "ScreenGraphic", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[212319, 8039, 215, 6, 19, 31, 0, "StyleData", "PrintGraphic", "All",
 StyleMenuListing->None],
Cell[212537, 8047, 62, 1, 70, 47, 0, "StyleData", "PrintGraphic", \
"Presentation"],
Cell[212602, 8050, 169, 4, 70, 43, 0, "StyleData", "PrintGraphic", \
"Printout"],
Cell[212774, 8056, 153, 3, 70, 51, 0, "StyleData", "PrintGraphic", \
"EnhancedPrintout"],
Cell[212930, 8061, 160, 3, 70, 58, 0, "StyleData", "PrintGraphic", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[213127, 8069, 150, 5, 70, 32, 0, "StyleData", "SmallTextSans", "All"],
Cell[213280, 8076, 63, 1, 70, 48, 0, "StyleData", "SmallTextSans", \
"Presentation"],
Cell[213346, 8079, 110, 3, 70, 44, 0, "StyleData", "SmallTextSans", \
"Printout"],
Cell[213459, 8084, 199, 6, 70, 52, 0, "StyleData", "SmallTextSans", \
"EnhancedPrintout"]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[213731, 8098, 30, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[213786, 8102, 384, 11, 70, 32, 0, "StyleData", "BilateralCell", "All",
 StyleMenuListing->None],
Cell[214173, 8115, 63, 1, 70, 48, 0, "StyleData", "BilateralCell", \
"Presentation"],
Cell[214239, 8118, 113, 2, 70, 45, 0, "StyleData", "BilateralCell", \
"SlideShow"],
Cell[214355, 8122, 114, 3, 70, 44, 0, "StyleData", "BilateralCell", \
"Printout"],
Cell[214472, 8127, 147, 4, 70, 52, 0, "StyleData", "BilateralCell", \
"EnhancedPrintout"],
Cell[214622, 8133, 154, 4, 70, 59, 0, "StyleData", "BilateralCell", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[214813, 8142, 151, 4, 70, 33, 0, "StyleData", "RuledPageBreak", "All"],
Cell[214967, 8148, 64, 1, 70, 49, 0, "StyleData", "RuledPageBreak", \
"Presentation"],
Cell[215034, 8151, 80, 1, 70, 46, 0, "StyleData", "RuledPageBreak", \
"SlideShow"],
Cell[215117, 8154, 114, 3, 70, 45, 0, "StyleData", "RuledPageBreak", \
"Printout"],
Cell[215234, 8159, 108, 2, 70, 53, 0, "StyleData", "RuledPageBreak", \
"EnhancedPrintout"],
Cell[215345, 8163, 115, 2, 70, 60, 0, "StyleData", "RuledPageBreak", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[215475, 8168, 496, 15, 70, 31, 0, "StyleData", "PaletteTitle", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[215974, 8185, 304, 10, 70, 32, 0, "StyleData", "PaletteButton", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None],
Cell[216281, 8197, 304, 10, 70, 33, 0, "StyleData", "PaletteButton2", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->None]
}, Closed]],
Cell[CellGroupData[{
Cell[216622, 8212, 33, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[216680, 8216, 331, 8, 70, 27, 0, "StyleData", "Outline1", "All",
 CounterIncrements->"Outline1",
 CounterAssignments->{{"Outline2", 0}, {"Outline3", 0}, {"Outline4", 0}}],
Cell[217014, 8226, 58, 1, 70, 43, 0, "StyleData", "Outline1", \
"Presentation"],
Cell[217075, 8229, 99, 1, 70, 39, 0, "StyleData", "Outline1", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[217211, 8235, 336, 9, 70, 27, 0, "StyleData", "Outline2", "All",
 CounterIncrements->"Outline2",
 CounterAssignments->{{"Outline3", 0}, {"Outline4", 0}}],
Cell[217550, 8246, 58, 1, 70, 43, 0, "StyleData", "Outline2", \
"Presentation"],
Cell[217611, 8249, 121, 2, 70, 39, 0, "StyleData", "Outline2", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[217769, 8256, 265, 7, 70, 27, 0, "StyleData", "Outline3", "All",
 CounterIncrements->"Outline3",
 CounterAssignments->{{"Outline4", 0}}],
Cell[218037, 8265, 58, 1, 70, 43, 0, "StyleData", "Outline3", \
"Presentation"],
Cell[218098, 8268, 88, 1, 70, 39, 0, "StyleData", "Outline3", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[218223, 8274, 259, 7, 70, 27, 0, "StyleData", "Outline4", "All",
 CounterIncrements->"Outline4"],
Cell[218485, 8283, 58, 1, 70, 43, 0, "StyleData", "Outline4", \
"Presentation"],
Cell[218546, 8286, 39, 0, 70, 39, 0, "StyleData", "Outline4", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[218634, 8292, 36, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[218695, 8296, 1025, 29, 70, 41, 0, "StyleData", \
"SlideShowNavigationBar", "All",
 CounterIncrements->"SlideShowNavigationBar",
 StyleMenuListing->None],
Cell[219723, 8327, 194, 5, 70, 54, 0, "StyleData", "SlideShowNavigationBar", \
"SlideShow"],
Cell[219920, 8334, 123, 3, 70, 53, 0, "StyleData", "SlideShowNavigationBar", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[220080, 8342, 1432, 36, 70, 35, 0, "StyleData", "SlideShowSection", \
"All",
 CounterIncrements->"Section",
 CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
 StyleMenuListing->None],
Cell[221515, 8380, 66, 1, 70, 51, 0, "StyleData", "SlideShowSection", \
"Presentation"],
Cell[221584, 8383, 96, 2, 70, 48, 0, "StyleData", "SlideShowSection", \
"SlideShow"],
Cell[221683, 8387, 119, 3, 70, 47, 0, "StyleData", "SlideShowSection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[221839, 8395, 315, 10, 70, 33, 0, "StyleData", "SlideHyperlink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[222157, 8407, 46, 0, 70, 46, 0, "StyleData", "SlideHyperlink", \
"SlideShow"],
Cell[222206, 8409, 125, 3, 70, 45, 0, "StyleData", "SlideHyperlink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[222368, 8417, 244, 8, 70, 31, 0, "StyleData", "PreviousNext", "All",
 CounterIncrements->"PreviousNext",
 StyleMenuListing->None],
Cell[222615, 8427, 120, 3, 70, 47, 0, "StyleData", "PreviousNext", \
"Presentation"],
Cell[222738, 8432, 95, 2, 70, 44, 0, "StyleData", "PreviousNext", \
"SlideShow"],
Cell[222836, 8436, 135, 4, 70, 43, 0, "StyleData", "PreviousNext", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[223008, 8445, 313, 9, 70, 40, 0, "StyleData", "SlidePreviousNextLink", \
"All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[223324, 8456, 56, 0, 70, 56, 0, "StyleData", "SlidePreviousNextLink", \
"Presentation"],
Cell[223383, 8458, 53, 0, 70, 53, 0, "StyleData", "SlidePreviousNextLink", \
"SlideShow"],
Cell[223439, 8460, 52, 0, 70, 52, 0, "StyleData", "SlidePreviousNextLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[223528, 8465, 330, 9, 70, 31, 0, "StyleData", "SlideTOCLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[223861, 8476, 44, 0, 70, 44, 0, "StyleData", "SlideTOCLink", \
"SlideShow"],
Cell[223908, 8478, 108, 2, 70, 43, 0, "StyleData", "SlideTOCLink", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[224053, 8485, 162, 4, 70, 27, 0, "StyleData", "SlideTOC", "All",
 StyleMenuListing->None],
Cell[224218, 8491, 55, 1, 70, 40, 0, "StyleData", "SlideTOC", "SlideShow"],
Cell[224276, 8494, 80, 2, 70, 39, 0, "StyleData", "SlideTOC", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[224405, 8502, 50, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[224480, 8506, 181, 5, 70, 32, 0, "StyleData", "ContentsTitle", "All"],
Cell[224664, 8513, 63, 1, 70, 48, 0, "StyleData", "ContentsTitle", \
"Presentation"],
Cell[224730, 8516, 147, 4, 70, 44, 0, "StyleData", "ContentsTitle", \
"Printout"],
Cell[224880, 8522, 213, 6, 70, 52, 0, "StyleData", "ContentsTitle", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[225130, 8533, 231, 7, 70, 34, 0, "StyleData", "ContentsSection", "All",
 StyleMenuListing->None],
Cell[225364, 8542, 65, 1, 70, 50, 0, "StyleData", "ContentsSection", \
"Presentation"],
Cell[225432, 8545, 119, 3, 70, 46, 0, "StyleData", "ContentsSection", \
"Printout"],
Cell[225554, 8550, 179, 5, 70, 54, 0, "StyleData", "ContentsSection", \
"EnhancedPrintout"],
Cell[225736, 8557, 186, 5, 70, 61, 0, "StyleData", "ContentsSection", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[225959, 8567, 185, 6, 70, 31, 0, "StyleData", "IndexSection", "All",
 StyleMenuListing->None],
Cell[226147, 8575, 62, 1, 70, 47, 0, "StyleData", "IndexSection", \
"Presentation"],
Cell[226212, 8578, 116, 3, 70, 43, 0, "StyleData", "IndexSection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[226365, 8586, 162, 4, 70, 27, 0, "StyleData", "Contents", "All",
 StyleMenuListing->None],
Cell[226530, 8592, 58, 1, 70, 43, 0, "StyleData", "Contents", \
"Presentation"],
Cell[226591, 8595, 87, 2, 70, 39, 0, "StyleData", "Contents", "Printout"],
Cell[226681, 8599, 120, 3, 70, 47, 0, "StyleData", "Contents", \
"EnhancedPrintout"],
Cell[226804, 8604, 127, 3, 70, 54, 0, "StyleData", "Contents", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[226968, 8612, 105, 3, 70, 24, 0, "StyleData", "Index", "All",
 StyleMenuListing->None],
Cell[227076, 8617, 55, 1, 70, 40, 0, "StyleData", "Index", "Presentation"],
Cell[227134, 8620, 83, 2, 70, 36, 0, "StyleData", "Index", "Printout"],
Cell[227220, 8624, 116, 3, 70, 44, 0, "StyleData", "Index", \
"EnhancedPrintout"],
Cell[227339, 8629, 123, 3, 70, 51, 0, "StyleData", "Index", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[227499, 8637, 88, 2, 70, 32, 0, "StyleData", "IndexSubentry", "All"],
Cell[227590, 8641, 63, 1, 70, 48, 0, "StyleData", "IndexSubentry", \
"Presentation"],
Cell[227656, 8644, 91, 2, 70, 44, 0, "StyleData", "IndexSubentry", \
"Printout"],
Cell[227750, 8648, 124, 3, 70, 52, 0, "StyleData", "IndexSubentry", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[227911, 8656, 408, 12, 70, 31, 0, "StyleData", "Index2Column", "All",
 StyleMenuListing->None],
Cell[228322, 8670, 62, 1, 70, 47, 0, "StyleData", "Index2Column", \
"Presentation"],
Cell[228387, 8673, 89, 2, 70, 43, 0, "StyleData", "Index2Column", \
"Printout"],
Cell[228479, 8677, 146, 4, 70, 51, 0, "StyleData", "Index2Column", \
"EnhancedPrintout"],
Cell[228628, 8683, 153, 4, 70, 58, 0, "StyleData", "Index2Column", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[228818, 8692, 127, 5, 70, 25, 0, "StyleData", "Leader", "All",
 StyleMenuListing->None],
Cell[228948, 8699, 52, 1, 70, 37, 0, "StyleData", "Leader", "Printout"],
Cell[229003, 8702, 85, 2, 70, 45, 0, "StyleData", "Leader", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[229125, 8709, 133, 5, 70, 31, 0, "StyleData", "LeaderNoDots", "All",
 StyleMenuListing->None],
Cell[229261, 8716, 58, 1, 70, 43, 0, "StyleData", "LeaderNoDots", \
"Printout"],
Cell[229322, 8719, 91, 2, 70, 51, 0, "StyleData", "LeaderNoDots", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[229450, 8726, 266, 7, 70, 27, 0, "StyleData", "PageLink", "All",
 StyleMenuListing->None,
 ButtonStyleMenuListing->Automatic],
Cell[229719, 8735, 65, 1, 70, 39, 0, "StyleData", "PageLink", "Printout"],
Cell[229787, 8738, 73, 1, 70, 47, 0, "StyleData", "PageLink", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[229897, 8744, 139, 5, 70, 26, 0, "StyleData", "TOCPage", "All",
 StyleMenuListing->None],
Cell[230039, 8751, 57, 1, 70, 42, 0, "StyleData", "TOCPage", "Presentation"],
Cell[230099, 8754, 53, 1, 70, 38, 0, "StyleData", "TOCPage", "Printout"],
Cell[230155, 8757, 86, 2, 70, 46, 0, "StyleData", "TOCPage", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[230278, 8764, 259, 8, 70, 27, 0, "StyleData", "TOCTitle", "All",
 CounterIncrements->"TOCTitle",
 CounterAssignments->{{"TOCSection", 0}}],
Cell[230540, 8774, 58, 1, 70, 43, 0, "StyleData", "TOCTitle", \
"Presentation"],
Cell[230601, 8777, 131, 4, 70, 39, 0, "StyleData", "TOCTitle", "Printout"],
Cell[230735, 8783, 191, 6, 70, 47, 0, "StyleData", "TOCTitle", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[230963, 8794, 247, 7, 70, 29, 0, "StyleData", "TOCSection", "All",
 CounterIncrements->"TOCSection",
 CounterAssignments->{{"TOCSubsection", 0}}],
Cell[231213, 8803, 60, 1, 70, 45, 0, "StyleData", "TOCSection", \
"Presentation"],
Cell[231276, 8806, 113, 3, 70, 41, 0, "StyleData", "TOCSection", "Printout"],
Cell[231392, 8811, 172, 5, 70, 49, 0, "StyleData", "TOCSection", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[231601, 8821, 230, 6, 70, 32, 0, "StyleData", "TOCSubsection", "All",
 CounterIncrements->"TOCSubsection",
 CounterAssignments->{{"TOCSubsubsection", 0}}],
Cell[231834, 8829, 63, 1, 70, 48, 0, "StyleData", "TOCSubsection", \
"Presentation"],
Cell[231900, 8832, 116, 3, 70, 44, 0, "StyleData", "TOCSubsection", \
"Printout"],
Cell[232019, 8837, 169, 5, 70, 52, 0, "StyleData", "TOCSubsection", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[232225, 8847, 189, 5, 70, 35, 0, "StyleData", "TOCSubsubsection", "All",
 CounterIncrements->"TOCSubsubsection"],
Cell[232417, 8854, 66, 1, 70, 51, 0, "StyleData", "TOCSubsubsection", \
"Presentation"],
Cell[232486, 8857, 118, 3, 70, 47, 0, "StyleData", "TOCSubsubsection", \
"Printout"],
Cell[232607, 8862, 151, 4, 70, 55, 0, "StyleData", "TOCSubsubsection", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[232795, 8871, 85, 2, 70, 34, 0, "StyleData", "TOCTitleDingbat", "All"],
Cell[232883, 8875, 100, 2, 70, 54, 0, "StyleData", "TOCTitleDingbat", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[233020, 8882, 87, 2, 70, 36, 0, "StyleData", "TOCSectionDingbat", \
"All"],
Cell[233110, 8886, 101, 2, 70, 56, 0, "StyleData", "TOCSectionDingbat", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[233248, 8893, 90, 2, 70, 39, 0, "StyleData", "TOCSubsectionDingbat", \
"All"],
Cell[233341, 8897, 73, 1, 70, 59, 0, "StyleData", "TOCSubsectionDingbat", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[233451, 8903, 323, 9, 70, 36, 0, "StyleData", "TOCTitleCondensed", "All",
 
 CounterIncrements->"TOCTitleCondensed",
 CounterAssignments->{{"TOCSectionCondensed", 0}, {
   "TOCSubsectionCondensed", 0}}],
Cell[233777, 8914, 67, 1, 70, 52, 0, "StyleData", "TOCTitleCondensed", \
"Presentation"],
Cell[233847, 8917, 120, 3, 70, 48, 0, "StyleData", "TOCTitleCondensed", \
"Printout"],
Cell[233970, 8922, 180, 5, 70, 56, 0, "StyleData", "TOCTitleCondensed", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[234187, 8932, 314, 9, 70, 38, 0, "StyleData", "TOCSectionCondensed", \
"All",
 CounterIncrements->"TOCSectionCondensed",
 CounterAssignments->{{"TOCSubsection", 0}}],
Cell[234504, 8943, 69, 1, 70, 54, 0, "StyleData", "TOCSectionCondensed", \
"Presentation"],
Cell[234576, 8946, 122, 3, 70, 50, 0, "StyleData", "TOCSectionCondensed", \
"Printout"],
Cell[234701, 8951, 155, 4, 70, 58, 0, "StyleData", "TOCSectionCondensed", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[234893, 8960, 174, 5, 70, 41, 0, "StyleData", "TOCSubsectionCondensed", \
"All"],
Cell[235070, 8967, 72, 1, 70, 57, 0, "StyleData", "TOCSubsectionCondensed", \
"Presentation"],
Cell[235145, 8970, 145, 4, 70, 53, 0, "StyleData", "TOCSubsectionCondensed", \
"Printout"],
Cell[235293, 8976, 178, 5, 70, 61, 0, "StyleData", "TOCSubsectionCondensed", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[235508, 8986, 207, 5, 70, 44, 0, "StyleData", \
"TOCSubsubsectionCondensed", "All",
 CounterIncrements->"TOCSubsubsectionCondensed"],
Cell[235718, 8993, 75, 1, 70, 60, 0, "StyleData", \
"TOCSubsubsectionCondensed", "Presentation"],
Cell[235796, 8996, 127, 3, 70, 56, 0, "StyleData", \
"TOCSubsubsectionCondensed", "Printout"],
Cell[235926, 9001, 160, 4, 70, 64, 0, "StyleData", \
"TOCSubsubsectionCondensed", "EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[236123, 9010, 139, 4, 70, 35, 0, "StyleData", "TitlePageGraphic", \
"All"],
Cell[236265, 9016, 66, 1, 70, 51, 0, "StyleData", "TitlePageGraphic", \
"Presentation"],
Cell[236334, 9019, 82, 1, 70, 47, 0, "StyleData", "TitlePageGraphic", \
"Printout"],
Cell[236419, 9022, 90, 1, 70, 55, 0, "StyleData", "TitlePageGraphic", \
"EnhancedPrintout"]
}, Closed]],
Cell[CellGroupData[{
Cell[236546, 9028, 64, 1, 70, 32, 0, "StyleData", "TitlePageLogo", "All"],
Cell[236613, 9031, 63, 1, 70, 48, 0, "StyleData", "TitlePageLogo", \
"Presentation"],
Cell[236679, 9034, 44, 0, 70, 44, 0, "StyleData", "TitlePageLogo", \
"Printout"],
Cell[236726, 9036, 52, 0, 70, 52, 0, "StyleData", "TitlePageLogo", \
"EnhancedPrintout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[236827, 9042, 27, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[236879, 9046, 341, 9, 70, 33, 0, "StyleData", "ReferenceGroup", "All"],
Cell[237223, 9057, 64, 1, 70, 49, 0, "StyleData", "ReferenceGroup", \
"Presentation"],
Cell[237290, 9060, 194, 5, 70, 45, 0, "StyleData", "ReferenceGroup", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[237521, 9070, 339, 9, 70, 31, 0, "StyleData", "ExampleHead1", "All"],
Cell[237863, 9081, 62, 1, 70, 47, 0, "StyleData", "ExampleHead1", \
"Presentation"],
Cell[237928, 9084, 192, 5, 70, 43, 0, "StyleData", "ExampleHead1", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[238157, 9094, 338, 8, 70, 31, 0, "StyleData", "ExampleHead2", "All"],
Cell[238498, 9104, 62, 1, 70, 47, 0, "StyleData", "ExampleHead2", \
"Presentation"],
Cell[238563, 9107, 192, 5, 70, 43, 0, "StyleData", "ExampleHead2", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[238792, 9117, 229, 6, 70, 31, 0, "StyleData", "ExampleHead3", "All"],
Cell[239024, 9125, 62, 1, 70, 47, 0, "StyleData", "ExampleHead3", \
"Presentation"],
Cell[239089, 9128, 192, 5, 70, 43, 0, "StyleData", "ExampleHead3", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[239318, 9138, 322, 9, 70, 33, 0, "StyleData", "ExampleSection", "All",
 StyleMenuListing->None],
Cell[239643, 9149, 64, 1, 70, 49, 0, "StyleData", "ExampleSection", \
"Presentation"],
Cell[239710, 9152, 194, 5, 70, 45, 0, "StyleData", "ExampleSection", \
"Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[239941, 9162, 202, 5, 70, 30, 0, "StyleData", "ExampleText", "All",
 StyleMenuListing->None],
Cell[240146, 9169, 61, 1, 70, 46, 0, "StyleData", "ExampleText", \
"Presentation"],
Cell[240210, 9172, 211, 6, 70, 42, 0, "StyleData", "ExampleText", "Printout"]
}, Closed]],
Cell[CellGroupData[{
Cell[240458, 9183, 309, 9, 70, 36, 0, "StyleData", "ExampleSubsection", "All",
 
 StyleMenuListing->None],
Cell[240770, 9194, 67, 1, 70, 52, 0, "StyleData", "ExampleSubsection", \
"Presentation"],
Cell[240840, 9197, 172, 4, 70, 48, 0, "StyleData", "ExampleSubsection", \
"Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[241061, 9207, 35, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[241121, 9211, 130, 4, 70, 24, 0, "StyleData", "Line1", "All",
 StyleMenuListing->None],
Cell[241254, 9217, 54, 1, 70, 40, 0, "StyleData", "Line1", "Presentation"],
Cell[241311, 9220, 70, 1, 70, 36, 0, "StyleData", "Line1", "Printout"]
}, Closed]],
Cell[241396, 9224, 65, 3, 70, "Text"],
Cell[CellGroupData[{
Cell[241486, 9231, 163, 5, 70, 29, 0, "StyleData", "ProgramTop", "All",
 StyleMenuListing->None],
Cell[241652, 9238, 59, 1, 70, 45, 0, "StyleData", "ProgramTop", \
"Presentation"],
Cell[241714, 9241, 76, 1, 70, 41, 0, "StyleData", "ProgramTop", "Printout"]
}, Closed]],
Cell[241805, 9245, 61, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[241891, 9253, 166, 5, 70, 32, 0, "StyleData", "ProgramBottom", "All",
 StyleMenuListing->None],
Cell[242060, 9260, 62, 1, 70, 48, 0, "StyleData", "ProgramBottom", \
"Presentation"],
Cell[242125, 9263, 79, 1, 70, 44, 0, "StyleData", "ProgramBottom", \
"Printout"]
}, Closed]],
Cell[242219, 9267, 64, 4, 70, "Text"],
Cell[CellGroupData[{
Cell[242308, 9275, 187, 6, 70, 31, 0, "StyleData", "SessionLabel", "All",
 StyleMenuListing->None],
Cell[242498, 9283, 62, 1, 70, 47, 0, "StyleData", "SessionLabel", \
"Presentation"],
Cell[242563, 9286, 91, 2, 70, 43, 0, "StyleData", "SessionLabel", "Printout"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[242703, 9294, 43, 0, 41, "Section"],
Cell[CellGroupData[{
Cell[242771, 9298, 122, 4, 70, 29, 0, "StyleData", "PageHeader", "All",
 StyleMenuListing->None],
Cell[242896, 9304, 41, 0, 70, 41, 0, "StyleData", "PageHeader", "Printout"],
Cell[242940, 9306, 116, 3, 70, 49, 0, "StyleData", "PageHeader", \
"EnhancedPrintout"],
Cell[243059, 9311, 123, 3, 70, 56, 0, "StyleData", "PageHeader", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[243219, 9319, 147, 5, 70, 29, 0, "StyleData", "PageNumber", "All",
 StyleMenuListing->None],
Cell[243369, 9326, 41, 0, 70, 41, 0, "StyleData", "PageNumber", "Printout"],
Cell[243413, 9328, 115, 3, 70, 49, 0, "StyleData", "PageNumber", \
"EnhancedPrintout"],
Cell[243531, 9333, 122, 3, 70, 56, 0, "StyleData", "PageNumber", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[243690, 9341, 94, 3, 70, 29, 0, "StyleData", "PageFooter", "All",
 StyleMenuListing->None],
Cell[243787, 9346, 41, 0, 70, 41, 0, "StyleData", "PageFooter", "Printout"],
Cell[243831, 9348, 94, 2, 70, 49, 0, "StyleData", "PageFooter", \
"EnhancedPrintout"],
Cell[243928, 9352, 101, 2, 70, 56, 0, "StyleData", "PageFooter", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[244066, 9359, 39, 0, 70, "Subsection"],
Cell[CellGroupData[{
Cell[244130, 9363, 118, 4, 70, 25, 0, "StyleData", "Header", "All",
 StyleMenuListing->None],
Cell[244251, 9369, 37, 0, 70, 37, 0, "StyleData", "Header", "Printout"],
Cell[244291, 9371, 112, 3, 70, 45, 0, "StyleData", "Header", \
"EnhancedPrintout"],
Cell[244406, 9376, 119, 3, 70, 52, 0, "StyleData", "Header", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[244562, 9384, 90, 3, 70, 25, 0, "StyleData", "Footer", "All",
 StyleMenuListing->None],
Cell[244655, 9389, 37, 0, 70, 37, 0, "StyleData", "Footer", "Printout"],
Cell[244695, 9391, 90, 2, 70, 45, 0, "StyleData", "Footer", \
"EnhancedPrintout"],
Cell[244788, 9395, 97, 2, 70, 52, 0, "StyleData", "Footer", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[244946, 9404, 36, 0, 41, "Section"],
Cell[244985, 9406, 305, 5, 70, "Text"],
Cell[CellGroupData[{
Cell[245315, 9415, 325, 11, 70, 33, 0, "StyleData", "CellExpression", "All",
 StyleMenuListing->None],
Cell[245643, 9428, 96, 2, 70, 53, 0, "StyleData", "CellExpression", \
"EnhancedPrintout"],
Cell[245742, 9432, 103, 2, 70, 60, 0, "StyleData", "CellExpression", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[245882, 9439, 152, 5, 70, 28, 0, "StyleData", "InputForm", "All",
 StyleMenuListing->None],
Cell[246037, 9446, 76, 1, 70, 48, 0, "StyleData", "InputForm", \
"EnhancedPrintout"],
Cell[246116, 9449, 83, 1, 70, 55, 0, "StyleData", "InputForm", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[246236, 9455, 146, 5, 70, 29, 0, "StyleData", "OutputForm", "All",
 StyleMenuListing->None],
Cell[246385, 9462, 77, 1, 70, 49, 0, "StyleData", "OutputForm", \
"EnhancedPrintout"],
Cell[246465, 9465, 84, 1, 70, 56, 0, "StyleData", "OutputForm", \
"EnhancedPrintoutNonGray"]
}, Closed]],
Cell[CellGroupData[{
Cell[246586, 9471, 336, 7, 70, 31, 0, "StyleData", "StandardForm", "All",
 StyleMenuListing->None],
Cell[246925, 9480, 79, 1, 70, 51, 0, "StyleData", "StandardForm", \
"EnhancedPrintout"],
Cell[247007, 9483, 86, 1, 70, 58, 0, "StyleData", "StandardForm", \
"EnhancedPrintoutNonGray"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[247142, 9490, 35, 0, 41, "Section"],
Cell[247180, 9492, 330, 6, 70, "Text"],
Cell[247513, 9500, 60, 1, 70, 35, 0, "StyleData", "UnmatchedBracket", "All",
 StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
